#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::ProductSortCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ProductSortCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::ProductSortCodeType

=head1 DESCRIPTION

Controls the order of product (not item) searches.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 PopularityAsc

Sort by product popularity (as determined by eBay),
and return the most popular products first.



=cut


use constant PopularityAsc => scalar('PopularityAsc');


=head2 PopularityDesc

Sort by product popularity (as determined by eBay),
and return the least popular products first.



=cut


use constant PopularityDesc => scalar('PopularityDesc');


=head2 RatingAsc

Sort by average rating, and return the lowest rated
products first.



=cut


use constant RatingAsc => scalar('RatingAsc');


=head2 RatingDesc

Sort by average rating, and return the highest rated
products first.



=cut


use constant RatingDesc => scalar('RatingDesc');


=head2 ReviewCountAsc

Sort by the number of reviews, and return products with
the fewest reviews first.



=cut


use constant ReviewCountAsc => scalar('ReviewCountAsc');


=head2 ReviewCountDesc

Sort by the number of reviews, and return products with
the most reviews first.



=cut


use constant ReviewCountDesc => scalar('ReviewCountDesc');


=head2 ItemCountAsc

Sort by the number of active items listed with this product,
and return products with the fewest items first.



=cut


use constant ItemCountAsc => scalar('ItemCountAsc');


=head2 ItemCountDesc

Sort by the number of active items listed with this product,
and return products with the most items first.



=cut


use constant ItemCountDesc => scalar('ItemCountDesc');


=head2 TitleAsc

Sort by the product title, and return products in ascending order.
For example, with Western character sets, this means alphabetical order
(e.g., A to Z), where titles that start with the word "A" appear
before titles that start with the word "The".



=cut


use constant TitleAsc => scalar('TitleAsc');


=head2 TitleDesc

Sort by the product title, and return products in reverse order
(e.g., Z to A).



=cut


use constant TitleDesc => scalar('TitleDesc');


=head2 CustomCode

Reserved for values that are not available in the version of the schema
you are using. If eBay adds a new value to this code type as of a
particular version, we return CustomCode when you specify a
lower request version.



=cut


use constant CustomCode => scalar('CustomCode');







1;   
