NAME
    RISCOS::Text::PrettyPrint --perl module that emulates
    OS_PrettyPrint

SYNOPSIS
        use RISCOS::Text::PrettyPrint;
        $expand = prettyprint_expand ($sometext, $special);

        @kernel_dict = read_riscosdict ('Resources:$.Resources.Kernel.Dictionary');
        $expand = prettyprint_expand ($sometext, '', @kernel_dict);


DESCRIPTION
    RISC OS provides a call `OS_PrettyPrint' that both formats text
    in a *pretty* fashion and allows a limited form of text
    compaction by using a dictionary. `prettyprint_expand' does not
    perform the line wrapping or tab expansion of `OS_PrettyPrint'
    (see the Text::Wrap manpage and the Text::Tabs manpage if this
    is needed) but does perform the dictionary expansion and
    converts the `OS_PrettyPrint' codes for non-breaking space and
    newline (`<31>' and `<13>' respectively) to `<160>' and `<10>'
    (a newline).

    The second (optional) parameter to `prettyprint_expand' is a
    *special string* which is used as dictionary entry zero. The
    remaining parameters are form the dictionary. If no dictionary
    is supplied then the default RISC OS dictionary is used (as in
    `OS_PrettyPrint'), which contains text common to the syntax
    messages of many modules.

    `read_riscosdict' reads the `OS_PrettyPrint' dictionary format
    and converts it to an array. If passed a string this will be
    taken as a filename and opened. If passed a reference to a
    filehandle this will be read from. (This allows reading of the
    default dictionary from the `DATA' filehadle of this module.

EXAMPLE
    This will print out the default dictionary.

        use RISCOS::Text::PrettyPrint ':DEFAULT', '@default_dict';

        foreach $entry (0 .. $#default_dict)
        {
    	print prettyprint_expand (sprintf ("%2d: \c[%c\n", $entry, $entry),
    				  '<Special string>');
        }


AUTHOR
    Nicholas Clark <nick@unfortu.net>

