#
# This file is auto-generated. ***ANY*** changes here will be lost
#

package Errno;
our (@EXPORT_OK,%EXPORT_TAGS,@ISA,$VERSION,%errno,$AUTOLOAD);
use Exporter ();
use Config;
use strict;

"$Config{'archname'}-$Config{'osvers'}" eq
"aix-5.1.0.0" or
	die "Errno architecture (aix-5.1.0.0) does not match executable architecture ($Config{'archname'}-$Config{'osvers'})";

$VERSION = "1.09_00";
$VERSION = eval $VERSION;
@ISA = qw(Exporter);

@EXPORT_OK = qw(ENOMSG EROFS ENOTSUP ESHUTDOWN EMULTIHOP
	EPROTONOSUPPORT ENFILE ENOLCK EL3HLT EADDRINUSE ECONNABORTED EBADF
	ECANCELED ENOTBLK ECHRNG EDEADLK ENOLINK ELNRNG ENOTDIR ETIME EINVAL
	ENOTTY ECORRUPT EXDEV EMEDIA ELOOP ECONNREFUSED ENOSTR EISCONN
	EOVERFLOW EFBIG ENOENT EPFNOSUPPORT ECONNRESET EWOULDBLOCK EBADMSG
	EL2HLT ENOCONNECT EDOM ENOTRUST EMSGSIZE ENOCSI EL3RST ENOSPC EIO
	EIDRM EWRPROTECT ENOTSOCK EDESTADDRREQ ERANGE EINPROGRESS ENOBUFS
	EAFNOSUPPORT EADDRNOTAVAIL ENOSYS EINTR EHOSTDOWN EREMOTE EILSEQ
	ENOMEM ENOSR EPIPE ENETUNREACH ENOTCONN ESTALE ENOTREADY ENODATA
	EDQUOT EUSERS EOPNOTSUPP EPROTO ESPIPE EALREADY EMFILE ENAMETOOLONG
	EACCES ENOEXEC EDESTADDREQ EISDIR EPROCLIM ESOFT EBUSY E2BIG EPERM
	EEXIST ETOOMANYREFS EDIST ERESTART ESOCKTNOSUPPORT EUNATCH ETIMEDOUT
	ESAD ENOATTR ENXIO ESRCH EFAULT ENODEV ETXTBSY EFORMAT EAGAIN EMLINK
	ENOPROTOOPT ECHILD ENETDOWN EHOSTUNREACH EPROTOTYPE EL2NSYNC ECLONEME
	ENETRESET ENOTEMPTY);

%EXPORT_TAGS = (
    POSIX => [qw(
	E2BIG EACCES EADDRINUSE EADDRNOTAVAIL EAFNOSUPPORT EAGAIN EALREADY
	EBADF EBUSY ECHILD ECONNABORTED ECONNREFUSED ECONNRESET EDEADLK
	EDESTADDRREQ EDOM EDQUOT EEXIST EFAULT EFBIG EHOSTDOWN EHOSTUNREACH
	EINPROGRESS EINTR EINVAL EIO EISCONN EISDIR ELOOP EMFILE EMLINK
	EMSGSIZE ENAMETOOLONG ENETDOWN ENETRESET ENETUNREACH ENFILE ENOBUFS
	ENODEV ENOENT ENOEXEC ENOLCK ENOMEM ENOPROTOOPT ENOSPC ENOSYS ENOTBLK
	ENOTCONN ENOTDIR ENOTEMPTY ENOTSOCK ENOTTY ENXIO EOPNOTSUPP EPERM
	EPFNOSUPPORT EPIPE EPROCLIM EPROTONOSUPPORT EPROTOTYPE ERANGE EREMOTE
	ERESTART EROFS ESHUTDOWN ESOCKTNOSUPPORT ESPIPE ESRCH ESTALE ETIMEDOUT
	ETOOMANYREFS ETXTBSY EUSERS EWOULDBLOCK EXDEV
    )]
);

sub EPERM () { 1 }
sub ENOENT () { 2 }
sub ESRCH () { 3 }
sub EINTR () { 4 }
sub EIO () { 5 }
sub ENXIO () { 6 }
sub E2BIG () { 7 }
sub ENOEXEC () { 8 }
sub EBADF () { 9 }
sub ECHILD () { 10 }
sub EWOULDBLOCK () { 11 }
sub EAGAIN () { 11 }
sub ENOMEM () { 12 }
sub EACCES () { 13 }
sub EFAULT () { 14 }
sub ENOTBLK () { 15 }
sub EBUSY () { 16 }
sub EEXIST () { 17 }
sub ENOTEMPTY () { 17 }
sub EXDEV () { 18 }
sub ENODEV () { 19 }
sub ENOTDIR () { 20 }
sub EISDIR () { 21 }
sub EINVAL () { 22 }
sub ENFILE () { 23 }
sub EMFILE () { 24 }
sub ENOTTY () { 25 }
sub ETXTBSY () { 26 }
sub EFBIG () { 27 }
sub ENOSPC () { 28 }
sub ESPIPE () { 29 }
sub EROFS () { 30 }
sub EMLINK () { 31 }
sub EPIPE () { 32 }
sub EDOM () { 33 }
sub ERANGE () { 34 }
sub ENOMSG () { 35 }
sub EIDRM () { 36 }
sub ECHRNG () { 37 }
sub EL2NSYNC () { 38 }
sub EL3HLT () { 39 }
sub EL3RST () { 40 }
sub ELNRNG () { 41 }
sub EUNATCH () { 42 }
sub ENOCSI () { 43 }
sub EL2HLT () { 44 }
sub EDEADLK () { 45 }
sub ENOTREADY () { 46 }
sub EWRPROTECT () { 47 }
sub EFORMAT () { 48 }
sub ENOLCK () { 49 }
sub ENOCONNECT () { 50 }
sub ESTALE () { 52 }
sub EDIST () { 53 }
sub EINPROGRESS () { 55 }
sub EALREADY () { 56 }
sub ENOTSOCK () { 57 }
sub EDESTADDRREQ () { 58 }
sub EDESTADDREQ () { 58 }
sub EMSGSIZE () { 59 }
sub EPROTOTYPE () { 60 }
sub ENOPROTOOPT () { 61 }
sub EPROTONOSUPPORT () { 62 }
sub ESOCKTNOSUPPORT () { 63 }
sub EOPNOTSUPP () { 64 }
sub EPFNOSUPPORT () { 65 }
sub EAFNOSUPPORT () { 66 }
sub EADDRINUSE () { 67 }
sub EADDRNOTAVAIL () { 68 }
sub ENETDOWN () { 69 }
sub ENETUNREACH () { 70 }
sub ENETRESET () { 71 }
sub ECONNABORTED () { 72 }
sub ECONNRESET () { 73 }
sub ENOBUFS () { 74 }
sub EISCONN () { 75 }
sub ENOTCONN () { 76 }
sub ESHUTDOWN () { 77 }
sub ETIMEDOUT () { 78 }
sub ECONNREFUSED () { 79 }
sub EHOSTDOWN () { 80 }
sub EHOSTUNREACH () { 81 }
sub ERESTART () { 82 }
sub ECLONEME () { 82 }
sub EPROCLIM () { 83 }
sub EUSERS () { 84 }
sub ELOOP () { 85 }
sub ENAMETOOLONG () { 86 }
sub EDQUOT () { 88 }
sub ECORRUPT () { 89 }
sub EREMOTE () { 93 }
sub ENOSYS () { 109 }
sub EMEDIA () { 110 }
sub ESOFT () { 111 }
sub ENOATTR () { 112 }
sub ESAD () { 113 }
sub ENOTRUST () { 114 }
sub ETOOMANYREFS () { 115 }
sub EILSEQ () { 116 }
sub ECANCELED () { 117 }
sub ENOSR () { 118 }
sub ETIME () { 119 }
sub EBADMSG () { 120 }
sub EPROTO () { 121 }
sub ENODATA () { 122 }
sub ENOSTR () { 123 }
sub ENOTSUP () { 124 }
sub EMULTIHOP () { 125 }
sub ENOLINK () { 126 }
sub EOVERFLOW () { 127 }

sub TIEHASH { bless [] }

sub FETCH {
    my ($self, $errname) = @_;
    my $proto = prototype("Errno::$errname");
    my $errno = "";
    if (defined($proto) && $proto eq "") {
	no strict 'refs';
	$errno = &$errname;
        $errno = 0 unless $! == $errno;
    }
    return $errno;
}

sub STORE {
    require Carp;
    Carp::confess("ERRNO hash is read only!");
}

*CLEAR = \&STORE;
*DELETE = \&STORE;

sub NEXTKEY {
    my($k,$v);
    while(($k,$v) = each %Errno::) {
	my $proto = prototype("Errno::$k");
	last if (defined($proto) && $proto eq "");
    }
    $k
}

sub FIRSTKEY {
    my $s = scalar keys %Errno::;	# initialize iterator
    goto &NEXTKEY;
}

sub EXISTS {
    my ($self, $errname) = @_;
    my $proto = prototype($errname);
    defined($proto) && $proto eq "";
}

tie %!, __PACKAGE__;

1;
__END__

=head1 NAME

Errno - System errno constants

=head1 SYNOPSIS

    use Errno qw(EINTR EIO :POSIX);

=head1 DESCRIPTION

C<Errno> defines and conditionally exports all the error constants
defined in your system C<errno.h> include file. It has a single export
tag, C<:POSIX>, which will export all POSIX defined error numbers.

C<Errno> also makes C<%!> magic such that each element of C<%!> has a
non-zero value only if C<$!> is set to that value. For example:

    use Errno;

    unless (open(FH, "/fangorn/spouse")) {
        if ($!{ENOENT}) {
            warn "Get a wife!\n";
        } else {
            warn "This path is barred: $!";
        } 
    } 

If a specified constant C<EFOO> does not exist on the system, C<$!{EFOO}>
returns C<"">.  You may use C<exists $!{EFOO}> to check whether the
constant is available on the system.

=head1 CAVEATS

Importing a particular constant may not be very portable, because the
import will fail on platforms that do not have that constant.  A more
portable way to set C<$!> to a valid value is to use:

    if (exists &Errno::EFOO) {
        $! = &Errno::EFOO;
    }

=head1 AUTHOR

Graham Barr <gbarr@pobox.com>

=head1 COPYRIGHT

Copyright (c) 1997-8 Graham Barr. All rights reserved.
This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

