import socket
import time
try:
  import cPickle
  pickle = cPickle
except:
  import pickle

AF_UNIX = socket.AF_UNIX
AF_INET = socket.AF_INET

_load = pickle.load
def _dump(o, f):
  pickle.dump(o, f, -1)

class GetEventsRequest:
  def __init__(self, after_time):
    self.after_time = after_time

class GetRootObjectRequest:
  pass

class UnrefRequest:
  def __init__(self, obj_id):
    self.obj_id = obj_id

class ReprRequest:
  def __init__(self, obj_id):
    self.obj_id = obj_id

class StrRequest:
  def __init__(self, obj_id):
    self.obj_id = obj_id

class UnicodeRequest:
  def __init__(self, obj_id):
    self.obj_id = obj_id

class GetAttrRequest:
  def __init__(self, obj_id, name):
    self.obj_id = obj_id
    self.name = name

class SetAttrRequest:
  def __init__(self, obj_id, name, value):
    self.obj_id = obj_id
    self.name = name
    self.value = value

class DelAttrRequest:
  def __init__(self, obj_id, name):
    self.obj_id = obj_id
    self.name = name

class CallRequest:
  def __init__(self, obj_id, args):
    self.obj_id = obj_id
    self.args = args

class LenRequest:
  def __init__(self, obj_id):
    self.obj_id = obj_id

class GetItemRequest:
  def __init__(self, obj_id, key):
    self.obj_id = obj_id
    self.key = key

class SetItemRequest:
  def __init__(self, obj_id, key, value):
    self.obj_id = obj_id
    self.key = key
    self.value = value

class DelItemRequest:
  def __init__(self, obj_id, key):
    self.obj_id = obj_id
    self.key = key

class ErrorResponse:
  def __init__(self, exception):
    self.exception = exception

class UnknownRequestError(Exception):
  pass

class UnknownObjectError(Exception):
  def __init__(self, obj_id):
    self.obj_id = obj_id

class DObjClient:
  def __init__(self, address_family, server_address, timeout=None):
    self._address_family = address_family
    self._server_address = server_address
    self._timeout = timeout
  def _call_server(self, request):
    for i in range(3):
      sock = socket.socket(self._address_family, socket.SOCK_STREAM)
      sock.connect(self._server_address)
      sock.settimeout(self._timeout)
      _dump(request, sock.makefile('w'))
      value = _load(sock.makefile('r'))
      sock.close()
      if not isinstance(value, ErrorResponse): return value
      if value.exception != UnknownRequestError: break
    raise value.exception

class DObject(DObjClient):
  _id = None
  _unref_on_del = 1
  def __init__(self, address_family, server_address, id):
    DObjClient.__init__(self, address_family, server_address)
    self._id = id
  def __del__(self):
    if self._unref_on_del:
      self._call_server(UnrefRequest(self._id))
  def __repr__(self):
    return self._call_server(ReprRequest(self._id))
  def __str__(self):
    return self._call_server(StrRequest(self._id))
  def __unicode__(self):
    return self._call_server(UnicodeRequest(self._id))
  def __getattr__(self, name):
    if name[0:1] == "_": raise AttributeError(name)
    return self._call_server(GetAttrRequest(self._id, name))
  def __setattr__(self, name, value):
    if name[0:1] == "_":
      self.__dict__[name] = value
      return
    self._call_server(SetAttrRequest(self._id, name, value))
  def __delattr__(self, name):
    if name[0:1] == "_":
      del self.__dict__[name]
      return
    self._call_server(DelAttrRequest(self._id, name))
  def __call__(self, *args):
    return self._call_server(CallRequest(self._id, args))
  def __len__(self):
    return self._call_server(LenRequest(self._id))
  def __getitem__(self, key):
    return self._call_server(GetItemRequest(self._id, key))
  def __setitem__(self, key, value):
    self._call_server(SetItemRequest(self._id, key, value))
  def __delitem__(self, key):
    self._call_server(DelItemRequest(self._id, key))

class BaseEvent:
  def __init__(self):
    self.time = time.time()

class SimpleEvent(BaseEvent):
  def __init__(self, data):
    BaseEvent.__init__(self)
    self.data = data

class DObjConnection(DObjClient):
  def __init__(self, address_family, server_address, timeout=None):
    DObjClient.__init__(self, address_family, server_address, timeout)
    self.last_event_time = time.time()
  def get_object(self):
    return self._call_server(GetRootObjectRequest())
  def get_events(self, after_time = 0):
    if after_time == 0: after_time = self.last_event_time
    events = self._call_server(GetEventsRequest(after_time))
    if events:
      self.last_event_time = max(self.last_event_time,
          events[-1].time)
    return events
