# Copyright (C) 2003 Konstantin Korikov

#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

""" Importers managment"""
import os.path
import glob

def ls_importers():
  "List avaible importers. Return list of tuple (importer_id, program_name)."
  implist = []
  for impfn in glob.glob(os.path.dirname(__file__) + "/*_importer.py"):
    #impmn = __name__ + "." + os.path.basename(impfn)[:-3]
    impmn = os.path.basename(impfn)[:-3]
    impm = __import__(impmn, globals(), locals())
    try:
      impclass = getattr(impm, impm.importer_class)
      implist.append((impmn, impclass.program))
    except AttributeError: pass
  return implist
  
def get_importer_args_info(importer_id):
  "Return information about constructor arguments."
  impm = __import__(importer_id, globals(), locals())
  impclass = getattr(impm, impm.importer_class)
  return impclass.constructor_args
  
def get_importer_info(importer_id):
  "Return importer information as dictionary."
  impm = __import__(importer_id, globals(), locals())
  impclass = getattr(impm, impm.importer_class)
  info = {}
  if hasattr(impclass, "__doc__"): 
    info.update({"description": impclass.__doc__})
  if hasattr(impclass, "author"): 
    info.update({"author": impclass.author})
  return info
  
def get_importer(importer_id, args):
  "Return importer object."
  impm = __import__(importer_id, globals(), locals())
  return apply(getattr(impm, impm.importer_class), args)

