.\" dpkg manual page - dpkg-divert(1)
.\"
.\" Copyright © 1995 Ian Jackson <ijackson@chiark.greenend.org.uk>
.\" Copyright © 1999 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2004 Scott James Remnant <keybuk@debian.org>
.\" Copyright © 2007-2013, 2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-divert 1 %RELEASE_DATE% %VERSION% "dpkg suite"
.nh
.SH 名前
dpkg\-divert \- パッケージの提供するファイルの上書き
.
.SH 書式
\fBdpkg\-divert\fP [\fIoption\fP...] \fIcommand\fP
.
.SH 説明
\fBdpkg\-divert\fP は、退避ファイルの一覧を設定、更新するためのユーティリティである。
.PP
File \fIdiversions\fP are a way of forcing \fBdpkg\fP(1)  not to install a file
into its location, but to a \fIdiverted\fP location. Diversions can be used
through the Debian package scripts to move a file away when it causes a
conflict. System administrators can also use it to override some package's
configuration file, or whenever some files (which aren't marked as
“conffiles”) need to be preserved by \fBdpkg\fP, when installing a newer
version of a package which contains those files.
.sp
.SH コマンド
.TP 
[\fB\-\-add\fP] \fIfile\fP
\fIfile\fP を退避ファイルに追加する。
.TP 
\fB\-\-remove\fP\fI file\fP
\fIfile\fP を退避ファイルから削除する。
.TP 
\fB\-\-list\fP\fI glob\-pattern\fP
\fIglob\-pattern\fP にマッチする退避ファイルの一覧を表示する。
.TP 
\fB\-\-listpackage\fP\fI file\fP
Print the name of the package that diverts \fIfile\fP (since dpkg 1.15.0).
Prints LOCAL if \fIfile\fP is locally diverted and nothing if \fIfile\fP is not
diverted.
.TP 
\fB\-\-truename\fP\fI file\fP
退避されたファイルの実際のファイル名を表示する。
.
.SH オプション
.TP 
\fB\-\-admindir\fP\fI directory\fP
Set the \fBdpkg\fP data directory to \fIdirectory\fP (default: \fI%ADMINDIR%\fP).
.TP 
\fB\-\-divert\fP\fI divert\-to\fP
\fIdivert\-to\fP は、他のパッケージによって提供された \fIfile\fP の退避場所である。
.TP 
\fB\-\-local\fP
パッケージが提供する該当ファイルについてはすべて退避の対象とする。これは、いかなるパッケージがインストールされても、該当のファイルは退避されることを意味する。これにより、管理者が修正したファイルをローカルにインストールすることが可能となる。
.TP 
\fB\-\-package\fP\fI package\fP
\fIpackage\fP は、\fIfile\fP の退避が発生しないパッケージ名である。つまり、\fIpackage\fP 以外のすべてのパッケージの提供する
\fIfile\fP は、退避される。
.TP 
\fB\-\-quiet\fP
非表示モード。冗長な出力をしない。
.TP 
\fB\-\-rename\fP
実際にファイルを退避 (もしくは復帰) させる。\fBdpkg\-divert\fP は、退避 (復帰) 先のファイルが既に存在していると動作を中断する。
.TP 
\fB\-\-test\fP
テストモード。実際にはなにも実行せず、なにを実行するかを表示するだけである。
.TP 
\fB\-?\fP, \fB\-\-help\fP
利用方法を表示して終了する。
.TP 
\fB\-\-version\fP
バージョン情報を表示して終了する。
.
.SH 終了ステータス
.TP 
\fB0\fP
指定したアクションが正しく実行された。
.TP 
\fB2\fP
Fatal or unrecoverable error due to invalid command\-line usage, or
interactions with the system, such as accesses to the database, memory
allocations, etc.
.
.SH 環境変数
.TP 
\fBDPKG_ADMINDIR\fP
If set and the \fB\-\-admindir\fP option has not been specified, it will be used
as the \fBdpkg\fP data directory.
.TP 
\fBDPKG_MAINTSCRIPT_PACKAGE\fP
\fB\-\-local\fP および \fB\-\-package\fP オプションが設定されておらず、この変数が設定されている場合、\fBdpkg\-divert\fP
は、この変数の値をパッケージ名として使用する。
.
.SH ファイル
.TP 
\fI%ADMINDIR%/diversions\fP
File which contains the current list of diversions of the system. It is
located in the \fBdpkg\fP administration directory, along with other files
important to \fBdpkg\fP, such as \fIstatus\fP or \fIavailable\fP.
.br
注記: \fBdpkg\-divert\fP は、このファイルを更新する時に古いバージョンを \fI\-old\fP という拡張子をつけたファイルにコピーして保存する。
.
.SH 参考
ファイルを追加する時のデフォルトは、\fB\-\-local\fP および \fB\-\-divert\fP \fIoriginal\fP\fB.distrib\fP
である。削除する時に、\fB\-\-package\fP もしくは \fB\-\-local\fP と \fB\-\-divert\fP
が指定されていた場合は、これらの整合性がとれている必要がある。

\fBdpkg\-divert\fP でディレクトリを退避させることはできない。

Care should be taken when diverting shared libraries, \fBldconfig\fP(8)
creates a symbolic link based on the DT_SONAME field embedded in the
library.  Because \fBldconfig\fP doesn't honour diverts (only \fBdpkg\fP does),
the symlink may end up pointing at the diverted library, if a diverted
library has the same SONAME as the undiverted one.
.
.SH 例
\fI/usr/bin/example\fP となるファイルすべてを \fI/usr/bin/example.foo\fP
に退避させる、つまり、\fI/usr/bin/example\fP を提供するすべてのパッケージが、該当ファイルを
\fI/usr/bin/example.foo\fP にリネームしてインストールするようにさせる:
.HP
dpkg\-divert \-\-divert /usr/bin/example.foo \-\-rename /usr/bin/example
.PP
該当の退避ファイルを削除する。
.HP
dpkg\-divert \-\-rename \-\-remove /usr/bin/example

.PP
\fI/usr/bin/example\fP をインストールしようとするすべてのパッケージを \fI/usr/bin/example.foo\fP
に退避させる。ただし、自作の \fIwibble\fP パッケージを除く:
.HP
dpkg\-divert \-\-package wibble \-\-divert /usr/bin/example.foo \-\-rename
/usr/bin/example
.PP
該当の退避ファイルを削除する。
.HP
dpkg\-divert \-\-package wibble \-\-rename \-\-remove /usr/bin/example
.
.SH 関連項目
\fBdpkg\fP(1).
.SH 翻訳者
高橋 基信 <monyo@monyo.com>.
喜瀬 浩 <kise@fuyuneko.jp>.
関戸 幸一 <sekido@mbox.kyoto-inet.or.jp>.
鍋谷 栄展 <nabe@debian.or.jp>.
倉澤 望 <nabetaro@debian.or.jp>.
石川 睦 <ishikawa@linux.or.jp>.
鵜飼 文敏 <ukai@debian.or.jp>.
中野 武雄 <nakano@apm.seikei.ac.jp>.
.SH 翻訳校正
Debian JP Documentation ML <debian-doc@debian.or.jp>.
