static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2015 Martin Blanchard <tchaik@gmx.com>                           \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_file_path (path, _(\"File\"), \"\")                                  \n"
"    description (_(\"Target path and filename, use '-' for stdout\"))         \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SINK                                                          \n"
"#define GEGL_OP_C_SOURCE tiff-save.c                                          \n"
"                                                                              \n"
"#include <gegl-op.h>                                                          \n"
"#include <gegl-gio-private.h>                                                 \n"
"#include <tiffio.h>                                                           \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  GFile *file;                                                                \n"
"  GOutputStream *stream;                                                      \n"
"  gboolean can_seek;                                                          \n"
"                                                                              \n"
"  gchar *buffer;                                                              \n"
"  gsize allocated;                                                            \n"
"  gsize position;                                                             \n"
"                                                                              \n"
"  TIFF *tiff;                                                                 \n"
"} Priv;                                                                       \n"
"                                                                              \n"
"static void                                                                   \n"
"cleanup(GeglOperation *operation)                                             \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES(operation);                             \n"
"  Priv *p = (Priv*) o->user_data;                                             \n"
"                                                                              \n"
"  if (p != NULL)                                                              \n"
"    {                                                                         \n"
"      if (p->tiff != NULL)                                                    \n"
"        TIFFClose(p->tiff);                                                   \n"
"      else if (p->stream != NULL)                                             \n"
"        g_output_stream_close(G_OUTPUT_STREAM(p->stream), NULL, NULL);        \n"
"      if (p->stream != NULL)                                                  \n"
"        g_clear_object(&p->stream);                                           \n"
"      p->tiff = NULL;                                                         \n"
"                                                                              \n"
"      if (p->file != NULL)                                                    \n"
"        g_clear_object(&p->file);                                             \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static GSeekType                                                              \n"
"lseek_to_seek_type(int whence)                                                \n"
"{                                                                             \n"
"  switch (whence)                                                             \n"
"    {                                                                         \n"
"    default:                                                                  \n"
"    case SEEK_SET:                                                            \n"
"      return G_SEEK_SET;                                                      \n"
"                                                                              \n"
"    case SEEK_CUR:                                                            \n"
"      return G_SEEK_CUR;                                                      \n"
"                                                                              \n"
"    case G_SEEK_END:                                                          \n"
"      return SEEK_END;                                                        \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static tsize_t                                                                \n"
"read_from_stream(thandle_t handle,                                            \n"
"                 tdata_t buffer,                                              \n"
"                 tsize_t size)                                                \n"
"{                                                                             \n"
"  Priv *p = (Priv*) handle;                                                   \n"
"                                                                              \n"
"  g_assert(p->stream && FALSE);                                               \n"
"                                                                              \n"
"  return -1;                                                                  \n"
"}                                                                             \n"
"                                                                              \n"
"static tsize_t                                                                \n"
"write_to_stream(thandle_t handle,                                             \n"
"                tdata_t buffer,                                               \n"
"                tsize_t size)                                                 \n"
"{                                                                             \n"
"  Priv *p = (Priv*) handle;                                                   \n"
"  GError *error = NULL;                                                       \n"
"  gchar *new_buffer;                                                          \n"
"  gsize new_size;                                                             \n"
"  gssize written = -1;                                                        \n"
"                                                                              \n"
"  g_assert(p->stream);                                                        \n"
"                                                                              \n"
"  if (p->can_seek)                                                            \n"
"    {                                                                         \n"
"      written = g_output_stream_write(G_OUTPUT_STREAM(p->stream),             \n"
"                                      (void *) buffer, (gsize) size,          \n"
"                                      NULL, &error);                          \n"
"      if (written < 0)                                                        \n"
"        {                                                                     \n"
"          g_warning(error->message);                                          \n"
"          g_error_free(error);                                                \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      if (p->position + size > p->allocated)                                  \n"
"        {                                                                     \n"
"          new_size = p->position + size;                                      \n"
"          new_buffer = g_try_realloc(p->buffer, new_size);                    \n"
"          if (!new_buffer)                                                    \n"
"            return -1;                                                        \n"
"                                                                              \n"
"          p->allocated = new_size;                                            \n"
"          p->buffer = new_buffer;                                             \n"
"        }                                                                     \n"
"                                                                              \n"
"      g_assert(p->position + size >= p->allocated);                           \n"
"                                                                              \n"
"      memcpy(p->buffer + p->position, buffer, size);                          \n"
"      p->position += size;                                                    \n"
"      written = size;                                                         \n"
"    }                                                                         \n"
"                                                                              \n"
"  return (tsize_t) written;                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static toff_t                                                                 \n"
"seek_in_stream(thandle_t handle,                                              \n"
"               toff_t offset,                                                 \n"
"               int whence)                                                    \n"
"{                                                                             \n"
"  Priv *p = (Priv*) handle;                                                   \n"
"  GError *error = NULL;                                                       \n"
"  gboolean sought = FALSE;                                                    \n"
"  goffset position = -1;                                                      \n"
"                                                                              \n"
"  g_assert(p->stream);                                                        \n"
"                                                                              \n"
"  if (p->can_seek)                                                            \n"
"    {                                                                         \n"
"      sought = g_seekable_seek(G_SEEKABLE(p->stream),                         \n"
"                               (goffset) offset, lseek_to_seek_type(whence),  \n"
"                               NULL, &error);                                 \n"
"      if (sought)                                                             \n"
"        position = g_seekable_tell(G_SEEKABLE(p->stream));                    \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          g_warning(error->message);                                          \n"
"          g_error_free(error);                                                \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      switch (whence)                                                         \n"
"        {                                                                     \n"
"        default:                                                              \n"
"        case SEEK_SET:                                                        \n"
"          if (offset <= p->allocated)                                         \n"
"            position = p->position = offset;                                  \n"
"          break;                                                              \n"
"                                                                              \n"
"        case SEEK_CUR:                                                        \n"
"          if (p->position + offset <= p->allocated)                           \n"
"            position = p->position += offset;                                 \n"
"          break;                                                              \n"
"                                                                              \n"
"        case G_SEEK_END:                                                      \n"
"          position = p->position = p->allocated + offset;                     \n"
"          break;                                                              \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  return (toff_t) position;                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static int                                                                    \n"
"close_stream(thandle_t handle)                                                \n"
"{                                                                             \n"
"  Priv *p = (Priv*) handle;                                                   \n"
"  GError *error = NULL;                                                       \n"
"  gsize total = 0;                                                            \n"
"  gboolean closed = FALSE;                                                    \n"
"                                                                              \n"
"  g_assert(p->stream);                                                        \n"
"                                                                              \n"
"  /* !can_seek: file content is now fully cached, time to write it down. */   \n"
"  if (!p->can_seek && p->buffer != NULL && p->allocated > 0)                  \n"
"    {                                                                         \n"
"      while (total < p->allocated)                                            \n"
"        {                                                                     \n"
"          gssize written;                                                     \n"
"                                                                              \n"
"          written = g_output_stream_write(G_OUTPUT_STREAM(p->stream),         \n"
"                                          (void *) (p->buffer + total),       \n"
"                                          p->allocated - total,               \n"
"                                          NULL, &error);                      \n"
"          if (written < 0)                                                    \n"
"            {                                                                 \n"
"                  g_warning(error->message);                                  \n"
"                  g_error_free(error);                                        \n"
"                  break;                                                      \n"
"            }                                                                 \n"
"                                                                              \n"
"          total += written;                                                   \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  closed = g_output_stream_close(G_OUTPUT_STREAM(p->stream),                  \n"
"                                 NULL, &error);                               \n"
"  if (!closed)                                                                \n"
"    {                                                                         \n"
"      g_warning(error->message);                                              \n"
"      g_error_free(error);                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  g_clear_object(&p->stream);                                                 \n"
"                                                                              \n"
"  p->position = 0;                                                            \n"
"                                                                              \n"
"  if (p->buffer != NULL)                                                      \n"
"    g_free(p->buffer);                                                        \n"
"  p->buffer = NULL;                                                           \n"
"                                                                              \n"
"  p->allocated = 0;                                                           \n"
"                                                                              \n"
"  return (closed) ? 0 : -1;                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static toff_t                                                                 \n"
"get_file_size(thandle_t handle)                                               \n"
"{                                                                             \n"
"  Priv *p = (Priv*) handle;                                                   \n"
"  GError *error = NULL;                                                       \n"
"  GFileInfo *info;                                                            \n"
"  goffset size;                                                               \n"
"                                                                              \n"
"  g_assert(p->stream);                                                        \n"
"                                                                              \n"
"  size = p->allocated;                                                        \n"
"                                                                              \n"
"  if (p->file != NULL)                                                        \n"
"    {                                                                         \n"
"      info = g_file_query_info(p->file,                                       \n"
"                               G_FILE_ATTRIBUTE_STANDARD_SIZE,                \n"
"                               G_FILE_QUERY_INFO_NONE,                        \n"
"                               NULL, &error);                                 \n"
"      if (info == NULL)                                                       \n"
"        {                                                                     \n"
"          g_warning(error->message);                                          \n"
"          g_error_free(error);                                                \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          if (g_file_info_has_attribute(info, G_FILE_ATTRIBUTE_STANDARD_SIZE))\n"
"            size = g_file_info_get_size(info);                                \n"
"          g_object_unref(info);                                               \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  return (toff_t) size;                                                       \n"
"}                                                                             \n"
"                                                                              \n"
"static gint                                                                   \n"
"save_contiguous(GeglOperation *operation,                                     \n"
"                GeglBuffer    *input,                                         \n"
"                const GeglRectangle *result,                                  \n"
"                const Babl *format)                                           \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES(operation);                             \n"
"  Priv *p = (Priv*) o->user_data;                                             \n"
"  gint bytes_per_pixel, bytes_per_row;                                        \n"
"  gint tile_width = result->width;                                            \n"
"  gint tile_height = result->height;                                          \n"
"  guchar *buffer;                                                             \n"
"  gint x, y;                                                                  \n"
"                                                                              \n"
"  g_return_val_if_fail(p->tiff != NULL, -1);                                  \n"
"                                                                              \n"
"  bytes_per_pixel = babl_format_get_bytes_per_pixel(format);                  \n"
"  bytes_per_row = bytes_per_pixel * tile_width;                               \n"
"                                                                              \n"
"  buffer = g_try_new(guchar, bytes_per_row * tile_height);                    \n"
"                                                                              \n"
"  g_assert(buffer != NULL);                                                   \n"
"                                                                              \n"
"  for (y = result->y; y < result->y + tile_height; y += tile_height)          \n"
"    {                                                                         \n"
"      for (x = result->x; x < result->x + tile_width; x += tile_width)        \n"
"        {                                                                     \n"
"          GeglRectangle tile = { x, y, tile_width, tile_height };             \n"
"          gint row;                                                           \n"
"                                                                              \n"
"          gegl_buffer_get(input, &tile, 1.0, format, buffer,                  \n"
"                          GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);              \n"
"                                                                              \n"
"          for (row = y; row < y + tile_height; row++)                         \n"
"            {                                                                 \n"
"              guchar *tile_row = buffer + (bytes_per_row * (row - y));        \n"
"              gint written;                                                   \n"
"                                                                              \n"
"              written = TIFFWriteScanline(p->tiff, tile_row, row, 0);         \n"
"                                                                              \n"
"              if (!written)                                                   \n"
"                {                                                             \n"
"                  g_critical(\"failed a scanline write on row %d\", row);     \n"
"                  continue;                                                   \n"
"                }                                                             \n"
"            }                                                                 \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  TIFFFlushData(p->tiff);                                                     \n"
"                                                                              \n"
"  g_free(buffer);                                                             \n"
"  return 0;                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static int                                                                    \n"
"export_tiff (GeglOperation *operation,                                        \n"
"             GeglBuffer *input,                                               \n"
"             const GeglRectangle *result)                                     \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES(operation);                             \n"
"  Priv *p = (Priv*) o->user_data;                                             \n"
"  gshort color_space, compression = COMPRESSION_NONE;                         \n"
"  gushort bits_per_sample, samples_per_pixel;                                 \n"
"  gboolean has_alpha, alpha_is_premultiplied = FALSE;                         \n"
"  gushort sample_format, predictor = 0;                                       \n"
"  gushort extra_types[1];                                                     \n"
"  glong rows_per_stripe = 1;                                                  \n"
"  gint bytes_per_row;                                                         \n"
"  const Babl *type, *model;                                                   \n"
"  gchar format_string[32];                                                    \n"
"  const Babl *format;                                                         \n"
"                                                                              \n"
"  g_return_val_if_fail(p->tiff != NULL, -1);                                  \n"
"                                                                              \n"
"  TIFFSetField(p->tiff, TIFFTAG_SUBFILETYPE, 0);                              \n"
"  TIFFSetField(p->tiff, TIFFTAG_ORIENTATION, ORIENTATION_TOPLEFT);            \n"
"                                                                              \n"
"  TIFFSetField(p->tiff, TIFFTAG_IMAGEWIDTH, result->width);                   \n"
"  TIFFSetField(p->tiff, TIFFTAG_IMAGELENGTH, result->height);                 \n"
"                                                                              \n"
"  format = gegl_buffer_get_format(input);                                     \n"
"                                                                              \n"
"  model = babl_format_get_model(format);                                      \n"
"  type = babl_format_get_type(format, 0);                                     \n"
"                                                                              \n"
"  if (model == babl_model(\"Y\") || model == babl_model(\"Y'\"))              \n"
"    {                                                                         \n"
"      has_alpha = FALSE;                                                      \n"
"      color_space = PHOTOMETRIC_MINISBLACK;                                   \n"
"      model = babl_model(\"Y'\");                                             \n"
"      samples_per_pixel = 1;                                                  \n"
"    }                                                                         \n"
"  else if (model == babl_model(\"YA\") || model == babl_model(\"Y'A\"))       \n"
"    {                                                                         \n"
"      has_alpha = TRUE;                                                       \n"
"      alpha_is_premultiplied = FALSE;                                         \n"
"      color_space = PHOTOMETRIC_MINISBLACK;                                   \n"
"      model = babl_model(\"Y'A\");                                            \n"
"      samples_per_pixel = 2;                                                  \n"
"    }                                                                         \n"
"  else if (model == babl_model(\"YaA\") || model == babl_model(\"Y'aA\"))     \n"
"    {                                                                         \n"
"      has_alpha = TRUE;                                                       \n"
"      alpha_is_premultiplied = TRUE;                                          \n"
"      color_space = PHOTOMETRIC_MINISBLACK;                                   \n"
"      model = babl_model(\"Y'aA\");                                           \n"
"      samples_per_pixel = 2;                                                  \n"
"    }                                                                         \n"
"  else if (model == babl_model(\"RGB\") || model == babl_model(\"R'G'B'\"))   \n"
"    {                                                                         \n"
"      has_alpha = FALSE;                                                      \n"
"      color_space = PHOTOMETRIC_RGB;                                          \n"
"      model = babl_model(\"R'G'B'\");                                         \n"
"      samples_per_pixel = 3;                                                  \n"
"      predictor = 2;                                                          \n"
"    }                                                                         \n"
"  else if (model == babl_model(\"RGBA\") || model == babl_model(\"R'G'B'A\")) \n"
"    {                                                                         \n"
"      has_alpha = TRUE;                                                       \n"
"      alpha_is_premultiplied = FALSE;                                         \n"
"      color_space = PHOTOMETRIC_RGB;                                          \n"
"      model = babl_model(\"R'G'B'A\");                                        \n"
"      samples_per_pixel = 4;                                                  \n"
"      predictor = 2;                                                          \n"
"    }                                                                         \n"
"  else if (model == babl_model(\"RaGaBaA\") || model == babl_model(\"R'aG'aB'aA\"))\n"
"    {                                                                         \n"
"      has_alpha = TRUE;                                                       \n"
"      alpha_is_premultiplied = TRUE;                                          \n"
"      color_space = PHOTOMETRIC_RGB;                                          \n"
"      model = babl_model(\"R'aG'aB'aA\");                                     \n"
"      samples_per_pixel = 4;                                                  \n"
"      predictor = 2;                                                          \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      g_warning(\"color space not supported: %s\", babl_get_name(model));     \n"
"                                                                              \n"
"      has_alpha = TRUE;                                                       \n"
"      alpha_is_premultiplied = TRUE;                                          \n"
"      color_space = PHOTOMETRIC_RGB;                                          \n"
"      model = babl_model(\"R'aG'aB'aA\");                                     \n"
"      samples_per_pixel = 4;                                                  \n"
"      predictor = 2;                                                          \n"
"    }                                                                         \n"
"                                                                              \n"
"  TIFFSetField(p->tiff, TIFFTAG_PHOTOMETRIC, color_space);                    \n"
"  TIFFSetField(p->tiff, TIFFTAG_SAMPLESPERPIXEL, samples_per_pixel);          \n"
"  TIFFSetField(p->tiff, TIFFTAG_PLANARCONFIG, PLANARCONFIG_CONTIG);           \n"
"                                                                              \n"
"  if (has_alpha)                                                              \n"
"    {                                                                         \n"
"      if (alpha_is_premultiplied)                                             \n"
"        extra_types[0] = EXTRASAMPLE_ASSOCALPHA;                              \n"
"      else                                                                    \n"
"        extra_types[0] = EXTRASAMPLE_UNASSALPHA;                              \n"
"                                                                              \n"
"      TIFFSetField(p->tiff, TIFFTAG_EXTRASAMPLES, 1, extra_types);            \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (predictor != 0)                                                         \n"
"    {                                                                         \n"
"      if (compression == COMPRESSION_LZW)                                     \n"
"        TIFFSetField(p->tiff, TIFFTAG_PREDICTOR, predictor);                  \n"
"      else if (compression == COMPRESSION_ADOBE_DEFLATE)                      \n"
"        TIFFSetField(p->tiff, TIFFTAG_PREDICTOR, predictor);                  \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (type == babl_type(\"u8\"))                                              \n"
"    {                                                                         \n"
"      sample_format = SAMPLEFORMAT_UINT;                                      \n"
"      bits_per_sample = 8;                                                    \n"
"    }                                                                         \n"
"  else if (type == babl_type(\"half\"))                                       \n"
"    {                                                                         \n"
"      sample_format = SAMPLEFORMAT_IEEEFP;                                    \n"
"      bits_per_sample = 16;                                                   \n"
"    }                                                                         \n"
"  else if (type == babl_type(\"u16\"))                                        \n"
"    {                                                                         \n"
"      sample_format = SAMPLEFORMAT_UINT;                                      \n"
"      bits_per_sample = 16;                                                   \n"
"    }                                                                         \n"
"  else if (type == babl_type(\"float\"))                                      \n"
"    {                                                                         \n"
"      sample_format = SAMPLEFORMAT_IEEEFP;                                    \n"
"      bits_per_sample = 32;                                                   \n"
"    }                                                                         \n"
"  else if (type == babl_type(\"u32\"))                                        \n"
"    {                                                                         \n"
"      sample_format = SAMPLEFORMAT_UINT;                                      \n"
"      bits_per_sample = 32;                                                   \n"
"    }                                                                         \n"
"  else  if (type == babl_type(\"double\"))                                    \n"
"    {                                                                         \n"
"      sample_format = SAMPLEFORMAT_IEEEFP;                                    \n"
"      bits_per_sample = 64;                                                   \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      g_warning(\"sample format not supported: %s\", babl_get_name(type));    \n"
"                                                                              \n"
"      sample_format = SAMPLEFORMAT_UINT;                                      \n"
"      type = babl_type(\"u8\");                                               \n"
"      bits_per_sample = 8;                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  TIFFSetField(p->tiff, TIFFTAG_BITSPERSAMPLE, bits_per_sample);              \n"
"  TIFFSetField(p->tiff, TIFFTAG_SAMPLEFORMAT, sample_format);                 \n"
"                                                                              \n"
"  TIFFSetField(p->tiff, TIFFTAG_COMPRESSION, compression);                    \n"
"                                                                              \n"
"  if ((compression == COMPRESSION_CCITTFAX3 ||                                \n"
"       compression == COMPRESSION_CCITTFAX4) &&                               \n"
"       (bits_per_sample != 1 || samples_per_pixel != 1))                      \n"
"    {                                                                         \n"
"      g_critical(\"only monochrome pictures can be compressed \"              \n"
"                 \"with \\\"CCITT Group 4\\\" or \\\"CCITT Group 3\\\"\");    \n"
"      return -1;                                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  g_snprintf(format_string, 32, \"%s %s\",                                    \n"
"             babl_get_name(model), babl_get_name(type));                      \n"
"                                                                              \n"
"  format = babl_format(format_string);                                        \n"
"                                                                              \n"
"  /* \"Choose RowsPerStrip such that each strip is about 8K bytes.\" */       \n"
"  bytes_per_row = babl_format_get_bytes_per_pixel(format) * result->width;    \n"
"  while (bytes_per_row * rows_per_stripe <= 8192)                             \n"
"    rows_per_stripe++;                                                        \n"
"                                                                              \n"
"  rows_per_stripe = MIN(rows_per_stripe, result->height);                     \n"
"                                                                              \n"
"  TIFFSetField(p->tiff, TIFFTAG_ROWSPERSTRIP, rows_per_stripe);               \n"
"                                                                              \n"
"  return save_contiguous(operation, input, result, format);                   \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process(GeglOperation *operation,                                             \n"
"        GeglBuffer *input,                                                    \n"
"        const GeglRectangle *result,                                          \n"
"        int level)                                                            \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES(operation);                             \n"
"  Priv *p = g_new0(Priv, 1);                                                  \n"
"  gboolean status = TRUE;                                                     \n"
"  GError *error = NULL;                                                       \n"
"                                                                              \n"
"  g_assert(p != NULL);                                                        \n"
"                                                                              \n"
"  o->user_data = (void*) p;                                                   \n"
"                                                                              \n"
"  p->stream = gegl_gio_open_output_stream(NULL, o->path, &p->file, &error);   \n"
"  if (p->stream != NULL && p->file != NULL)                                   \n"
"    p->can_seek = g_seekable_can_seek(G_SEEKABLE(p->stream));                 \n"
"  if (p->stream == NULL)                                                      \n"
"    {                                                                         \n"
"      status = FALSE;                                                         \n"
"      g_warning(error->message);                                              \n"
"      goto cleanup;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  p->tiff = TIFFClientOpen(\"GEGL-tiff-save\", \"w\", (thandle_t) p,          \n"
"                           read_from_stream, write_to_stream,                 \n"
"                           seek_in_stream, close_stream,                      \n"
"                           get_file_size, NULL, NULL);                        \n"
"  if (p->tiff == NULL)                                                        \n"
"    {                                                                         \n"
"      status = FALSE;                                                         \n"
"      g_warning(\"failed to openi TIFF from %s\", o->path);                   \n"
"      goto cleanup;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (export_tiff(operation, input, result))                                  \n"
"    {                                                                         \n"
"      status = FALSE;                                                         \n"
"      g_warning(\"could not export TIFF file\");                              \n"
"      goto cleanup;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"cleanup:                                                                      \n"
"  cleanup(operation);                                                         \n"
"  if (o->user_data != NULL)                                                   \n"
"    g_free(o->user_data);                                                     \n"
"  o->user_data = NULL;                                                        \n"
"                                                                              \n"
"  if (error != NULL)                                                          \n"
"    g_error_free(error);                                                      \n"
"                                                                              \n"
"  return status;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init(GeglOpClass *klass)                                        \n"
"{                                                                             \n"
"  GeglOperationClass *operation_class;                                        \n"
"  GeglOperationSinkClass *sink_class;                                         \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS(klass);                              \n"
"  sink_class = GEGL_OPERATION_SINK_CLASS(klass);                              \n"
"                                                                              \n"
"  sink_class->needs_full = TRUE;                                              \n"
"  sink_class->process = process;                                              \n"
"                                                                              \n"
"  gegl_operation_class_set_keys(operation_class,                              \n"
"    \"name\",          \"gegl:tiff-save\",                                    \n"
"    \"title\",       _(\"TIFF File Saver\"),                                  \n"
"    \"categories\",    \"output\",                                            \n"
"    \"description\", _(\"TIFF image saver using libtiff\"),                   \n"
"    NULL);                                                                    \n"
"                                                                              \n"
"  gegl_extension_handler_register_saver(\".tiff\", \"gegl:tiff-save\");       \n"
"  gegl_extension_handler_register_saver(\".tif\", \"gegl:tiff-save\");        \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
