// -*- c++ -*-
// Generated by gmmproc 2.38.0 -- DO NOT MODIFY!
#ifndef _GTKMM_REVEALER_H
#define _GTKMM_REVEALER_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * Copyright (C) 2013 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gtkmm/bin.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkRevealer GtkRevealer;
typedef struct _GtkRevealerClass GtkRevealerClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Revealer_Class; } // namespace Gtk
namespace Gtk
{

/** Hide and show with animation.
 *
 * The Gtk::Revealer widget is a container which animates
 * the transition of its child from invisible to visible.
 *
 * The style of transition can be controlled with
 * Gtk::Revealer::set_transition_type().
 *
 * @ingroup Widgets
 * @newin{3,10}
 */

class Revealer
  : public Bin
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Revealer CppObjectType;
  typedef Revealer_Class CppClassType;
  typedef GtkRevealer BaseObjectType;
  typedef GtkRevealerClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Revealer();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Revealer_Class;
  static CppClassType revealer_class_;

  // noncopyable
  Revealer(const Revealer&);
  Revealer& operator=(const Revealer&);

protected:
  explicit Revealer(const Glib::ConstructParams& construct_params);
  explicit Revealer(GtkRevealer* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkRevealer*       gobj()       { return reinterpret_cast<GtkRevealer*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkRevealer* gobj() const { return reinterpret_cast<GtkRevealer*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:

public:

  /** Create Gtk::Revealer widget.
   *
   *
   */
  Revealer();


  /** Returns whether the child is currently
   * revealed. See set_reveal_child().
   * 
   * This function returns <tt>true</tt> as soon as the transition
   * is to the revealed state is started. To learn whether
   * the child is fully revealed (ie the transition is completed),
   * use get_child_revealed().
   * 
   * @newin{3,10}
   * @return <tt>true</tt> if the child is revealed.
   */
  bool get_reveal_child() const;
  
  /** Tells the Gtk::Revealer to reveal or conceal its child.
   * 
   * The transition will be animated with the current
   * transition type of @a revealer.
   * 
   * @newin{3,10}
   * @param reveal_child <tt>true</tt> to reveal the child.
   */
  void set_reveal_child(bool reveal_child =  true);

  
  /** Returns whether the child is fully revealed, ie wether
   * the transition to the revealed state is completed.
   * 
   * @newin{3,10}
   * @return <tt>true</tt> if the child is fully revealed.
   */
  bool get_child_revealed() const;

  
  /** Returns the amount of time (in milliseconds) that
   * transitions will take.
   * 
   * @newin{3,10}
   * @return The transition duration.
   */
  guint get_transition_duration() const;
  
  /** Sets the duration that transitions will take.
   * 
   * @newin{3,10}
   * @param duration The new duration, in milliseconds.
   */
  void set_transition_duration(guint duration);

  
  /** Gets the type of animation that will be used
   * for transitions in @a revealer.
   * 
   * @newin{3,10}
   * @return The current transition type of @a revealer.
   */
  RevealerTransitionType get_transition_type() const;
  
  /** Sets the type of animation that will be used for
   * transitions in @a revealer. Available types include
   * various kinds of fades and slides.
   * 
   * @newin{3,10}
   * @param transition The new transition type.
   */
  void set_transition_type(RevealerTransitionType transition);


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The type of animation used to transition.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< RevealerTransitionType > property_transition_type() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The type of animation used to transition.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< RevealerTransitionType > property_transition_type() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The animation duration, in milliseconds.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< guint > property_transition_duration() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The animation duration, in milliseconds.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint > property_transition_duration() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the container should reveal the child.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_reveal_child() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the container should reveal the child.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_reveal_child() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the child is revealed and the animation target reached.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_child_revealed() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  // Gtk::Revealer has no signals nor vfuncs as of 3.10.


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::Revealer
   */
  Gtk::Revealer* wrap(GtkRevealer* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_REVEALER_H */

