/*
Copyright 2016 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package componentconfig

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg1_unversioned "k8s.io/client-go/pkg/api/unversioned"
	pkg2_config "k8s.io/client-go/pkg/util/config"
	"reflect"
	"runtime"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg1_unversioned.TypeMeta
		var v1 pkg2_config.ConfigurationMap
		var v2 time.Duration
		_, _, _ = v0, v1, v2
	}
}

func (x *KubeProxyConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [23]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Kind != ""
			yyq2[1] = x.APIVersion != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(23)
			} else {
				yynn2 = 21
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym10 := z.EncBinary()
				_ = yym10
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.BindAddress))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("bindAddress"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym11 := z.EncBinary()
				_ = yym11
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.BindAddress))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym13 := z.EncBinary()
				_ = yym13
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym14 := z.EncBinary()
				_ = yym14
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterCIDR))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym16 := z.EncBinary()
				_ = yym16
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HealthzBindAddress))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("healthzBindAddress"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym17 := z.EncBinary()
				_ = yym17
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HealthzBindAddress))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym19 := z.EncBinary()
				_ = yym19
				if false {
				} else {
					r.EncodeInt(int64(x.HealthzPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("healthzPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym20 := z.EncBinary()
				_ = yym20
				if false {
				} else {
					r.EncodeInt(int64(x.HealthzPort))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym22 := z.EncBinary()
				_ = yym22
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostnameOverride))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostnameOverride"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym23 := z.EncBinary()
				_ = yym23
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostnameOverride))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.IPTablesMasqueradeBit == nil {
					r.EncodeNil()
				} else {
					yy25 := *x.IPTablesMasqueradeBit
					yym26 := z.EncBinary()
					_ = yym26
					if false {
					} else {
						r.EncodeInt(int64(yy25))
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("iptablesMasqueradeBit"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.IPTablesMasqueradeBit == nil {
					r.EncodeNil()
				} else {
					yy27 := *x.IPTablesMasqueradeBit
					yym28 := z.EncBinary()
					_ = yym28
					if false {
					} else {
						r.EncodeInt(int64(yy27))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy30 := &x.IPTablesSyncPeriod
				yym31 := z.EncBinary()
				_ = yym31
				if false {
				} else if z.HasExtensions() && z.EncExt(yy30) {
				} else if !yym31 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy30)
				} else {
					z.EncFallback(yy30)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("iptablesSyncPeriodSeconds"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy32 := &x.IPTablesSyncPeriod
				yym33 := z.EncBinary()
				_ = yym33
				if false {
				} else if z.HasExtensions() && z.EncExt(yy32) {
				} else if !yym33 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy32)
				} else {
					z.EncFallback(yy32)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy35 := &x.IPTablesMinSyncPeriod
				yym36 := z.EncBinary()
				_ = yym36
				if false {
				} else if z.HasExtensions() && z.EncExt(yy35) {
				} else if !yym36 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy35)
				} else {
					z.EncFallback(yy35)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("iptablesMinSyncPeriodSeconds"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy37 := &x.IPTablesMinSyncPeriod
				yym38 := z.EncBinary()
				_ = yym38
				if false {
				} else if z.HasExtensions() && z.EncExt(yy37) {
				} else if !yym38 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy37)
				} else {
					z.EncFallback(yy37)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym40 := z.EncBinary()
				_ = yym40
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeconfigPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeconfigPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym41 := z.EncBinary()
				_ = yym41
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeconfigPath))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym43 := z.EncBinary()
				_ = yym43
				if false {
				} else {
					r.EncodeBool(bool(x.MasqueradeAll))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("masqueradeAll"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym44 := z.EncBinary()
				_ = yym44
				if false {
				} else {
					r.EncodeBool(bool(x.MasqueradeAll))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym46 := z.EncBinary()
				_ = yym46
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Master))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("master"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym47 := z.EncBinary()
				_ = yym47
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Master))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.OOMScoreAdj == nil {
					r.EncodeNil()
				} else {
					yy49 := *x.OOMScoreAdj
					yym50 := z.EncBinary()
					_ = yym50
					if false {
					} else {
						r.EncodeInt(int64(yy49))
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("oomScoreAdj"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.OOMScoreAdj == nil {
					r.EncodeNil()
				} else {
					yy51 := *x.OOMScoreAdj
					yym52 := z.EncBinary()
					_ = yym52
					if false {
					} else {
						r.EncodeInt(int64(yy51))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Mode.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("mode"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Mode.CodecEncodeSelf(e)
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym55 := z.EncBinary()
				_ = yym55
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PortRange))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("portRange"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym56 := z.EncBinary()
				_ = yym56
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PortRange))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym58 := z.EncBinary()
				_ = yym58
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ResourceContainer))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("resourceContainer"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym59 := z.EncBinary()
				_ = yym59
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ResourceContainer))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy61 := &x.UDPIdleTimeout
				yym62 := z.EncBinary()
				_ = yym62
				if false {
				} else if z.HasExtensions() && z.EncExt(yy61) {
				} else if !yym62 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy61)
				} else {
					z.EncFallback(yy61)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("udpTimeoutMilliseconds"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy63 := &x.UDPIdleTimeout
				yym64 := z.EncBinary()
				_ = yym64
				if false {
				} else if z.HasExtensions() && z.EncExt(yy63) {
				} else if !yym64 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy63)
				} else {
					z.EncFallback(yy63)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym66 := z.EncBinary()
				_ = yym66
				if false {
				} else {
					r.EncodeInt(int64(x.ConntrackMax))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("conntrackMax"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym67 := z.EncBinary()
				_ = yym67
				if false {
				} else {
					r.EncodeInt(int64(x.ConntrackMax))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym69 := z.EncBinary()
				_ = yym69
				if false {
				} else {
					r.EncodeInt(int64(x.ConntrackMaxPerCore))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("conntrackMaxPerCore"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym70 := z.EncBinary()
				_ = yym70
				if false {
				} else {
					r.EncodeInt(int64(x.ConntrackMaxPerCore))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym72 := z.EncBinary()
				_ = yym72
				if false {
				} else {
					r.EncodeInt(int64(x.ConntrackMin))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("conntrackMin"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym73 := z.EncBinary()
				_ = yym73
				if false {
				} else {
					r.EncodeInt(int64(x.ConntrackMin))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy75 := &x.ConntrackTCPEstablishedTimeout
				yym76 := z.EncBinary()
				_ = yym76
				if false {
				} else if z.HasExtensions() && z.EncExt(yy75) {
				} else if !yym76 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy75)
				} else {
					z.EncFallback(yy75)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("conntrackTCPEstablishedTimeout"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy77 := &x.ConntrackTCPEstablishedTimeout
				yym78 := z.EncBinary()
				_ = yym78
				if false {
				} else if z.HasExtensions() && z.EncExt(yy77) {
				} else if !yym78 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy77)
				} else {
					z.EncFallback(yy77)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy80 := &x.ConntrackTCPCloseWaitTimeout
				yym81 := z.EncBinary()
				_ = yym81
				if false {
				} else if z.HasExtensions() && z.EncExt(yy80) {
				} else if !yym81 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy80)
				} else {
					z.EncFallback(yy80)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("conntrackTCPCloseWaitTimeout"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy82 := &x.ConntrackTCPCloseWaitTimeout
				yym83 := z.EncBinary()
				_ = yym83
				if false {
				} else if z.HasExtensions() && z.EncExt(yy82) {
				} else if !yym83 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy82)
				} else {
					z.EncFallback(yy82)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeProxyConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym84 := z.DecBinary()
	_ = yym84
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct85 := r.ContainerType()
		if yyct85 == codecSelferValueTypeMap1234 {
			yyl85 := r.ReadMapStart()
			if yyl85 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl85, d)
			}
		} else if yyct85 == codecSelferValueTypeArray1234 {
			yyl85 := r.ReadArrayStart()
			if yyl85 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl85, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeProxyConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys86Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys86Slc
	var yyhl86 bool = l >= 0
	for yyj86 := 0; ; yyj86++ {
		if yyhl86 {
			if yyj86 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys86Slc = r.DecodeBytes(yys86Slc, true, true)
		yys86 := string(yys86Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys86 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "bindAddress":
			if r.TryDecodeAsNil() {
				x.BindAddress = ""
			} else {
				x.BindAddress = string(r.DecodeString())
			}
		case "clusterCIDR":
			if r.TryDecodeAsNil() {
				x.ClusterCIDR = ""
			} else {
				x.ClusterCIDR = string(r.DecodeString())
			}
		case "healthzBindAddress":
			if r.TryDecodeAsNil() {
				x.HealthzBindAddress = ""
			} else {
				x.HealthzBindAddress = string(r.DecodeString())
			}
		case "healthzPort":
			if r.TryDecodeAsNil() {
				x.HealthzPort = 0
			} else {
				x.HealthzPort = int32(r.DecodeInt(32))
			}
		case "hostnameOverride":
			if r.TryDecodeAsNil() {
				x.HostnameOverride = ""
			} else {
				x.HostnameOverride = string(r.DecodeString())
			}
		case "iptablesMasqueradeBit":
			if r.TryDecodeAsNil() {
				if x.IPTablesMasqueradeBit != nil {
					x.IPTablesMasqueradeBit = nil
				}
			} else {
				if x.IPTablesMasqueradeBit == nil {
					x.IPTablesMasqueradeBit = new(int32)
				}
				yym95 := z.DecBinary()
				_ = yym95
				if false {
				} else {
					*((*int32)(x.IPTablesMasqueradeBit)) = int32(r.DecodeInt(32))
				}
			}
		case "iptablesSyncPeriodSeconds":
			if r.TryDecodeAsNil() {
				x.IPTablesSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv96 := &x.IPTablesSyncPeriod
				yym97 := z.DecBinary()
				_ = yym97
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv96) {
				} else if !yym97 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv96)
				} else {
					z.DecFallback(yyv96, false)
				}
			}
		case "iptablesMinSyncPeriodSeconds":
			if r.TryDecodeAsNil() {
				x.IPTablesMinSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv98 := &x.IPTablesMinSyncPeriod
				yym99 := z.DecBinary()
				_ = yym99
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv98) {
				} else if !yym99 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv98)
				} else {
					z.DecFallback(yyv98, false)
				}
			}
		case "kubeconfigPath":
			if r.TryDecodeAsNil() {
				x.KubeconfigPath = ""
			} else {
				x.KubeconfigPath = string(r.DecodeString())
			}
		case "masqueradeAll":
			if r.TryDecodeAsNil() {
				x.MasqueradeAll = false
			} else {
				x.MasqueradeAll = bool(r.DecodeBool())
			}
		case "master":
			if r.TryDecodeAsNil() {
				x.Master = ""
			} else {
				x.Master = string(r.DecodeString())
			}
		case "oomScoreAdj":
			if r.TryDecodeAsNil() {
				if x.OOMScoreAdj != nil {
					x.OOMScoreAdj = nil
				}
			} else {
				if x.OOMScoreAdj == nil {
					x.OOMScoreAdj = new(int32)
				}
				yym104 := z.DecBinary()
				_ = yym104
				if false {
				} else {
					*((*int32)(x.OOMScoreAdj)) = int32(r.DecodeInt(32))
				}
			}
		case "mode":
			if r.TryDecodeAsNil() {
				x.Mode = ""
			} else {
				x.Mode = ProxyMode(r.DecodeString())
			}
		case "portRange":
			if r.TryDecodeAsNil() {
				x.PortRange = ""
			} else {
				x.PortRange = string(r.DecodeString())
			}
		case "resourceContainer":
			if r.TryDecodeAsNil() {
				x.ResourceContainer = ""
			} else {
				x.ResourceContainer = string(r.DecodeString())
			}
		case "udpTimeoutMilliseconds":
			if r.TryDecodeAsNil() {
				x.UDPIdleTimeout = pkg1_unversioned.Duration{}
			} else {
				yyv108 := &x.UDPIdleTimeout
				yym109 := z.DecBinary()
				_ = yym109
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv108) {
				} else if !yym109 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv108)
				} else {
					z.DecFallback(yyv108, false)
				}
			}
		case "conntrackMax":
			if r.TryDecodeAsNil() {
				x.ConntrackMax = 0
			} else {
				x.ConntrackMax = int32(r.DecodeInt(32))
			}
		case "conntrackMaxPerCore":
			if r.TryDecodeAsNil() {
				x.ConntrackMaxPerCore = 0
			} else {
				x.ConntrackMaxPerCore = int32(r.DecodeInt(32))
			}
		case "conntrackMin":
			if r.TryDecodeAsNil() {
				x.ConntrackMin = 0
			} else {
				x.ConntrackMin = int32(r.DecodeInt(32))
			}
		case "conntrackTCPEstablishedTimeout":
			if r.TryDecodeAsNil() {
				x.ConntrackTCPEstablishedTimeout = pkg1_unversioned.Duration{}
			} else {
				yyv113 := &x.ConntrackTCPEstablishedTimeout
				yym114 := z.DecBinary()
				_ = yym114
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv113) {
				} else if !yym114 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv113)
				} else {
					z.DecFallback(yyv113, false)
				}
			}
		case "conntrackTCPCloseWaitTimeout":
			if r.TryDecodeAsNil() {
				x.ConntrackTCPCloseWaitTimeout = pkg1_unversioned.Duration{}
			} else {
				yyv115 := &x.ConntrackTCPCloseWaitTimeout
				yym116 := z.DecBinary()
				_ = yym116
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv115) {
				} else if !yym116 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv115)
				} else {
					z.DecFallback(yyv115, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys86)
		} // end switch yys86
	} // end for yyj86
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeProxyConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj117 int
	var yyb117 bool
	var yyhl117 bool = l >= 0
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.BindAddress = ""
	} else {
		x.BindAddress = string(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterCIDR = ""
	} else {
		x.ClusterCIDR = string(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HealthzBindAddress = ""
	} else {
		x.HealthzBindAddress = string(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HealthzPort = 0
	} else {
		x.HealthzPort = int32(r.DecodeInt(32))
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostnameOverride = ""
	} else {
		x.HostnameOverride = string(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.IPTablesMasqueradeBit != nil {
			x.IPTablesMasqueradeBit = nil
		}
	} else {
		if x.IPTablesMasqueradeBit == nil {
			x.IPTablesMasqueradeBit = new(int32)
		}
		yym126 := z.DecBinary()
		_ = yym126
		if false {
		} else {
			*((*int32)(x.IPTablesMasqueradeBit)) = int32(r.DecodeInt(32))
		}
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IPTablesSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv127 := &x.IPTablesSyncPeriod
		yym128 := z.DecBinary()
		_ = yym128
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv127) {
		} else if !yym128 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv127)
		} else {
			z.DecFallback(yyv127, false)
		}
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IPTablesMinSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv129 := &x.IPTablesMinSyncPeriod
		yym130 := z.DecBinary()
		_ = yym130
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv129) {
		} else if !yym130 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv129)
		} else {
			z.DecFallback(yyv129, false)
		}
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeconfigPath = ""
	} else {
		x.KubeconfigPath = string(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MasqueradeAll = false
	} else {
		x.MasqueradeAll = bool(r.DecodeBool())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Master = ""
	} else {
		x.Master = string(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.OOMScoreAdj != nil {
			x.OOMScoreAdj = nil
		}
	} else {
		if x.OOMScoreAdj == nil {
			x.OOMScoreAdj = new(int32)
		}
		yym135 := z.DecBinary()
		_ = yym135
		if false {
		} else {
			*((*int32)(x.OOMScoreAdj)) = int32(r.DecodeInt(32))
		}
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Mode = ""
	} else {
		x.Mode = ProxyMode(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PortRange = ""
	} else {
		x.PortRange = string(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceContainer = ""
	} else {
		x.ResourceContainer = string(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UDPIdleTimeout = pkg1_unversioned.Duration{}
	} else {
		yyv139 := &x.UDPIdleTimeout
		yym140 := z.DecBinary()
		_ = yym140
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv139) {
		} else if !yym140 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv139)
		} else {
			z.DecFallback(yyv139, false)
		}
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConntrackMax = 0
	} else {
		x.ConntrackMax = int32(r.DecodeInt(32))
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConntrackMaxPerCore = 0
	} else {
		x.ConntrackMaxPerCore = int32(r.DecodeInt(32))
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConntrackMin = 0
	} else {
		x.ConntrackMin = int32(r.DecodeInt(32))
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConntrackTCPEstablishedTimeout = pkg1_unversioned.Duration{}
	} else {
		yyv144 := &x.ConntrackTCPEstablishedTimeout
		yym145 := z.DecBinary()
		_ = yym145
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv144) {
		} else if !yym145 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv144)
		} else {
			z.DecFallback(yyv144, false)
		}
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConntrackTCPCloseWaitTimeout = pkg1_unversioned.Duration{}
	} else {
		yyv146 := &x.ConntrackTCPCloseWaitTimeout
		yym147 := z.DecBinary()
		_ = yym147
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv146) {
		} else if !yym147 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv146)
		} else {
			z.DecFallback(yyv146, false)
		}
	}
	for {
		yyj117++
		if yyhl117 {
			yyb117 = yyj117 > l
		} else {
			yyb117 = r.CheckBreak()
		}
		if yyb117 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj117-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ProxyMode) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym148 := z.EncBinary()
	_ = yym148
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ProxyMode) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym149 := z.DecBinary()
	_ = yym149
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x HairpinMode) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym150 := z.EncBinary()
	_ = yym150
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *HairpinMode) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym151 := z.DecBinary()
	_ = yym151
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *KubeletConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym152 := z.EncBinary()
		_ = yym152
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep153 := !z.EncBinary()
			yy2arr153 := z.EncBasicHandle().StructToArray
			var yyq153 [114]bool
			_, _, _ = yysep153, yyq153, yy2arr153
			const yyr153 bool = false
			yyq153[0] = x.Kind != ""
			yyq153[1] = x.APIVersion != ""
			yyq153[55] = x.CloudProvider != ""
			yyq153[56] = x.CloudConfigFile != ""
			yyq153[57] = x.KubeletCgroups != ""
			yyq153[58] = x.ExperimentalCgroupsPerQOS != false
			yyq153[59] = x.CgroupDriver != ""
			yyq153[60] = x.RuntimeCgroups != ""
			yyq153[61] = x.SystemCgroups != ""
			yyq153[62] = x.CgroupRoot != ""
			yyq153[66] = true
			yyq153[67] = x.RktPath != ""
			yyq153[68] = x.ExperimentalMounterPath != ""
			yyq153[69] = x.RktAPIEndpoint != ""
			yyq153[70] = x.RktStage1Image != ""
			yyq153[89] = true
			yyq153[90] = x.NodeIP != ""
			yyq153[94] = x.EvictionHard != ""
			yyq153[95] = x.EvictionSoft != ""
			yyq153[96] = x.EvictionSoftGracePeriod != ""
			yyq153[97] = true
			yyq153[98] = x.EvictionMaxPodGracePeriod != 0
			yyq153[99] = x.EvictionMinimumReclaim != ""
			yyq153[109] = len(x.AllowedUnsafeSysctls) != 0
			yyq153[111] = x.EnableCRI != false
			yyq153[112] = x.ExperimentalFailSwapOn != false
			yyq153[113] = x.ExperimentalCheckNodeCapabilitiesBeforeMount != false
			var yynn153 int
			if yyr153 || yy2arr153 {
				r.EncodeArrayStart(114)
			} else {
				yynn153 = 87
				for _, b := range yyq153 {
					if b {
						yynn153++
					}
				}
				r.EncodeMapStart(yynn153)
				yynn153 = 0
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[0] {
					yym155 := z.EncBinary()
					_ = yym155
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym156 := z.EncBinary()
					_ = yym156
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[1] {
					yym158 := z.EncBinary()
					_ = yym158
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym159 := z.EncBinary()
					_ = yym159
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym161 := z.EncBinary()
				_ = yym161
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodManifestPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podManifestPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym162 := z.EncBinary()
				_ = yym162
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodManifestPath))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy164 := &x.SyncFrequency
				yym165 := z.EncBinary()
				_ = yym165
				if false {
				} else if z.HasExtensions() && z.EncExt(yy164) {
				} else if !yym165 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy164)
				} else {
					z.EncFallback(yy164)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("syncFrequency"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy166 := &x.SyncFrequency
				yym167 := z.EncBinary()
				_ = yym167
				if false {
				} else if z.HasExtensions() && z.EncExt(yy166) {
				} else if !yym167 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy166)
				} else {
					z.EncFallback(yy166)
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy169 := &x.FileCheckFrequency
				yym170 := z.EncBinary()
				_ = yym170
				if false {
				} else if z.HasExtensions() && z.EncExt(yy169) {
				} else if !yym170 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy169)
				} else {
					z.EncFallback(yy169)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("fileCheckFrequency"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy171 := &x.FileCheckFrequency
				yym172 := z.EncBinary()
				_ = yym172
				if false {
				} else if z.HasExtensions() && z.EncExt(yy171) {
				} else if !yym172 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy171)
				} else {
					z.EncFallback(yy171)
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy174 := &x.HTTPCheckFrequency
				yym175 := z.EncBinary()
				_ = yym175
				if false {
				} else if z.HasExtensions() && z.EncExt(yy174) {
				} else if !yym175 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy174)
				} else {
					z.EncFallback(yy174)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("httpCheckFrequency"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy176 := &x.HTTPCheckFrequency
				yym177 := z.EncBinary()
				_ = yym177
				if false {
				} else if z.HasExtensions() && z.EncExt(yy176) {
				} else if !yym177 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy176)
				} else {
					z.EncFallback(yy176)
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym179 := z.EncBinary()
				_ = yym179
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ManifestURL))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("manifestURL"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym180 := z.EncBinary()
				_ = yym180
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ManifestURL))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym182 := z.EncBinary()
				_ = yym182
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ManifestURLHeader))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("manifestURLHeader"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym183 := z.EncBinary()
				_ = yym183
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ManifestURLHeader))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym185 := z.EncBinary()
				_ = yym185
				if false {
				} else {
					r.EncodeBool(bool(x.EnableServer))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableServer"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym186 := z.EncBinary()
				_ = yym186
				if false {
				} else {
					r.EncodeBool(bool(x.EnableServer))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym188 := z.EncBinary()
				_ = yym188
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("address"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym189 := z.EncBinary()
				_ = yym189
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym191 := z.EncBinary()
				_ = yym191
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym192 := z.EncBinary()
				_ = yym192
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym194 := z.EncBinary()
				_ = yym194
				if false {
				} else {
					r.EncodeInt(int64(x.ReadOnlyPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("readOnlyPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym195 := z.EncBinary()
				_ = yym195
				if false {
				} else {
					r.EncodeInt(int64(x.ReadOnlyPort))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym197 := z.EncBinary()
				_ = yym197
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TLSCertFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("tlsCertFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym198 := z.EncBinary()
				_ = yym198
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TLSCertFile))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym200 := z.EncBinary()
				_ = yym200
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TLSPrivateKeyFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("tlsPrivateKeyFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym201 := z.EncBinary()
				_ = yym201
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TLSPrivateKeyFile))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym203 := z.EncBinary()
				_ = yym203
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CertDirectory))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("certDirectory"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym204 := z.EncBinary()
				_ = yym204
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CertDirectory))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy206 := &x.Authentication
				yy206.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("authentication"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy207 := &x.Authentication
				yy207.CodecEncodeSelf(e)
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy209 := &x.Authorization
				yy209.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("authorization"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy210 := &x.Authorization
				yy210.CodecEncodeSelf(e)
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym212 := z.EncBinary()
				_ = yym212
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostnameOverride))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostnameOverride"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym213 := z.EncBinary()
				_ = yym213
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostnameOverride))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym215 := z.EncBinary()
				_ = yym215
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodInfraContainerImage))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podInfraContainerImage"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym216 := z.EncBinary()
				_ = yym216
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodInfraContainerImage))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym218 := z.EncBinary()
				_ = yym218
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DockerEndpoint))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("dockerEndpoint"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym219 := z.EncBinary()
				_ = yym219
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DockerEndpoint))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym221 := z.EncBinary()
				_ = yym221
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RootDirectory))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("rootDirectory"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym222 := z.EncBinary()
				_ = yym222
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RootDirectory))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym224 := z.EncBinary()
				_ = yym224
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SeccompProfileRoot))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("seccompProfileRoot"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym225 := z.EncBinary()
				_ = yym225
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SeccompProfileRoot))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym227 := z.EncBinary()
				_ = yym227
				if false {
				} else {
					r.EncodeBool(bool(x.AllowPrivileged))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("allowPrivileged"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym228 := z.EncBinary()
				_ = yym228
				if false {
				} else {
					r.EncodeBool(bool(x.AllowPrivileged))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.HostNetworkSources == nil {
					r.EncodeNil()
				} else {
					yym230 := z.EncBinary()
					_ = yym230
					if false {
					} else {
						z.F.EncSliceStringV(x.HostNetworkSources, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostNetworkSources"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.HostNetworkSources == nil {
					r.EncodeNil()
				} else {
					yym231 := z.EncBinary()
					_ = yym231
					if false {
					} else {
						z.F.EncSliceStringV(x.HostNetworkSources, false, e)
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.HostPIDSources == nil {
					r.EncodeNil()
				} else {
					yym233 := z.EncBinary()
					_ = yym233
					if false {
					} else {
						z.F.EncSliceStringV(x.HostPIDSources, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostPIDSources"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.HostPIDSources == nil {
					r.EncodeNil()
				} else {
					yym234 := z.EncBinary()
					_ = yym234
					if false {
					} else {
						z.F.EncSliceStringV(x.HostPIDSources, false, e)
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.HostIPCSources == nil {
					r.EncodeNil()
				} else {
					yym236 := z.EncBinary()
					_ = yym236
					if false {
					} else {
						z.F.EncSliceStringV(x.HostIPCSources, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostIPCSources"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.HostIPCSources == nil {
					r.EncodeNil()
				} else {
					yym237 := z.EncBinary()
					_ = yym237
					if false {
					} else {
						z.F.EncSliceStringV(x.HostIPCSources, false, e)
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym239 := z.EncBinary()
				_ = yym239
				if false {
				} else {
					r.EncodeInt(int64(x.RegistryPullQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registryPullQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym240 := z.EncBinary()
				_ = yym240
				if false {
				} else {
					r.EncodeInt(int64(x.RegistryPullQPS))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym242 := z.EncBinary()
				_ = yym242
				if false {
				} else {
					r.EncodeInt(int64(x.RegistryBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registryBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym243 := z.EncBinary()
				_ = yym243
				if false {
				} else {
					r.EncodeInt(int64(x.RegistryBurst))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym245 := z.EncBinary()
				_ = yym245
				if false {
				} else {
					r.EncodeInt(int64(x.EventRecordQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("eventRecordQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym246 := z.EncBinary()
				_ = yym246
				if false {
				} else {
					r.EncodeInt(int64(x.EventRecordQPS))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym248 := z.EncBinary()
				_ = yym248
				if false {
				} else {
					r.EncodeInt(int64(x.EventBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("eventBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym249 := z.EncBinary()
				_ = yym249
				if false {
				} else {
					r.EncodeInt(int64(x.EventBurst))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym251 := z.EncBinary()
				_ = yym251
				if false {
				} else {
					r.EncodeBool(bool(x.EnableDebuggingHandlers))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableDebuggingHandlers"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym252 := z.EncBinary()
				_ = yym252
				if false {
				} else {
					r.EncodeBool(bool(x.EnableDebuggingHandlers))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy254 := &x.MinimumGCAge
				yym255 := z.EncBinary()
				_ = yym255
				if false {
				} else if z.HasExtensions() && z.EncExt(yy254) {
				} else if !yym255 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy254)
				} else {
					z.EncFallback(yy254)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("minimumGCAge"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy256 := &x.MinimumGCAge
				yym257 := z.EncBinary()
				_ = yym257
				if false {
				} else if z.HasExtensions() && z.EncExt(yy256) {
				} else if !yym257 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy256)
				} else {
					z.EncFallback(yy256)
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym259 := z.EncBinary()
				_ = yym259
				if false {
				} else {
					r.EncodeInt(int64(x.MaxPerPodContainerCount))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxPerPodContainerCount"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym260 := z.EncBinary()
				_ = yym260
				if false {
				} else {
					r.EncodeInt(int64(x.MaxPerPodContainerCount))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym262 := z.EncBinary()
				_ = yym262
				if false {
				} else {
					r.EncodeInt(int64(x.MaxContainerCount))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxContainerCount"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym263 := z.EncBinary()
				_ = yym263
				if false {
				} else {
					r.EncodeInt(int64(x.MaxContainerCount))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym265 := z.EncBinary()
				_ = yym265
				if false {
				} else {
					r.EncodeInt(int64(x.CAdvisorPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cAdvisorPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym266 := z.EncBinary()
				_ = yym266
				if false {
				} else {
					r.EncodeInt(int64(x.CAdvisorPort))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym268 := z.EncBinary()
				_ = yym268
				if false {
				} else {
					r.EncodeInt(int64(x.HealthzPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("healthzPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym269 := z.EncBinary()
				_ = yym269
				if false {
				} else {
					r.EncodeInt(int64(x.HealthzPort))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym271 := z.EncBinary()
				_ = yym271
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HealthzBindAddress))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("healthzBindAddress"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym272 := z.EncBinary()
				_ = yym272
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HealthzBindAddress))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym274 := z.EncBinary()
				_ = yym274
				if false {
				} else {
					r.EncodeInt(int64(x.OOMScoreAdj))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("oomScoreAdj"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym275 := z.EncBinary()
				_ = yym275
				if false {
				} else {
					r.EncodeInt(int64(x.OOMScoreAdj))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym277 := z.EncBinary()
				_ = yym277
				if false {
				} else {
					r.EncodeBool(bool(x.RegisterNode))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registerNode"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym278 := z.EncBinary()
				_ = yym278
				if false {
				} else {
					r.EncodeBool(bool(x.RegisterNode))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym280 := z.EncBinary()
				_ = yym280
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterDomain))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterDomain"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym281 := z.EncBinary()
				_ = yym281
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterDomain))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym283 := z.EncBinary()
				_ = yym283
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MasterServiceNamespace))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("masterServiceNamespace"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym284 := z.EncBinary()
				_ = yym284
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MasterServiceNamespace))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym286 := z.EncBinary()
				_ = yym286
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterDNS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterDNS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym287 := z.EncBinary()
				_ = yym287
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterDNS))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy289 := &x.StreamingConnectionIdleTimeout
				yym290 := z.EncBinary()
				_ = yym290
				if false {
				} else if z.HasExtensions() && z.EncExt(yy289) {
				} else if !yym290 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy289)
				} else {
					z.EncFallback(yy289)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("streamingConnectionIdleTimeout"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy291 := &x.StreamingConnectionIdleTimeout
				yym292 := z.EncBinary()
				_ = yym292
				if false {
				} else if z.HasExtensions() && z.EncExt(yy291) {
				} else if !yym292 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy291)
				} else {
					z.EncFallback(yy291)
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy294 := &x.NodeStatusUpdateFrequency
				yym295 := z.EncBinary()
				_ = yym295
				if false {
				} else if z.HasExtensions() && z.EncExt(yy294) {
				} else if !yym295 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy294)
				} else {
					z.EncFallback(yy294)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeStatusUpdateFrequency"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy296 := &x.NodeStatusUpdateFrequency
				yym297 := z.EncBinary()
				_ = yym297
				if false {
				} else if z.HasExtensions() && z.EncExt(yy296) {
				} else if !yym297 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy296)
				} else {
					z.EncFallback(yy296)
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy299 := &x.ImageMinimumGCAge
				yym300 := z.EncBinary()
				_ = yym300
				if false {
				} else if z.HasExtensions() && z.EncExt(yy299) {
				} else if !yym300 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy299)
				} else {
					z.EncFallback(yy299)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("imageMinimumGCAge"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy301 := &x.ImageMinimumGCAge
				yym302 := z.EncBinary()
				_ = yym302
				if false {
				} else if z.HasExtensions() && z.EncExt(yy301) {
				} else if !yym302 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy301)
				} else {
					z.EncFallback(yy301)
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym304 := z.EncBinary()
				_ = yym304
				if false {
				} else {
					r.EncodeInt(int64(x.ImageGCHighThresholdPercent))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("imageGCHighThresholdPercent"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym305 := z.EncBinary()
				_ = yym305
				if false {
				} else {
					r.EncodeInt(int64(x.ImageGCHighThresholdPercent))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym307 := z.EncBinary()
				_ = yym307
				if false {
				} else {
					r.EncodeInt(int64(x.ImageGCLowThresholdPercent))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("imageGCLowThresholdPercent"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym308 := z.EncBinary()
				_ = yym308
				if false {
				} else {
					r.EncodeInt(int64(x.ImageGCLowThresholdPercent))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym310 := z.EncBinary()
				_ = yym310
				if false {
				} else {
					r.EncodeInt(int64(x.LowDiskSpaceThresholdMB))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lowDiskSpaceThresholdMB"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym311 := z.EncBinary()
				_ = yym311
				if false {
				} else {
					r.EncodeInt(int64(x.LowDiskSpaceThresholdMB))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy313 := &x.VolumeStatsAggPeriod
				yym314 := z.EncBinary()
				_ = yym314
				if false {
				} else if z.HasExtensions() && z.EncExt(yy313) {
				} else if !yym314 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy313)
				} else {
					z.EncFallback(yy313)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumeStatsAggPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy315 := &x.VolumeStatsAggPeriod
				yym316 := z.EncBinary()
				_ = yym316
				if false {
				} else if z.HasExtensions() && z.EncExt(yy315) {
				} else if !yym316 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy315)
				} else {
					z.EncFallback(yy315)
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym318 := z.EncBinary()
				_ = yym318
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NetworkPluginName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("networkPluginName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym319 := z.EncBinary()
				_ = yym319
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NetworkPluginName))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym321 := z.EncBinary()
				_ = yym321
				if false {
				} else {
					r.EncodeInt(int64(x.NetworkPluginMTU))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("networkPluginMTU"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym322 := z.EncBinary()
				_ = yym322
				if false {
				} else {
					r.EncodeInt(int64(x.NetworkPluginMTU))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym324 := z.EncBinary()
				_ = yym324
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NetworkPluginDir))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("networkPluginDir"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym325 := z.EncBinary()
				_ = yym325
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NetworkPluginDir))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym327 := z.EncBinary()
				_ = yym327
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CNIConfDir))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cniConfDir"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym328 := z.EncBinary()
				_ = yym328
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CNIConfDir))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym330 := z.EncBinary()
				_ = yym330
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CNIBinDir))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cniBinDir"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym331 := z.EncBinary()
				_ = yym331
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CNIBinDir))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym333 := z.EncBinary()
				_ = yym333
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumePluginDir))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumePluginDir"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym334 := z.EncBinary()
				_ = yym334
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumePluginDir))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[55] {
					yym336 := z.EncBinary()
					_ = yym336
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CloudProvider))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[55] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cloudProvider"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym337 := z.EncBinary()
					_ = yym337
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CloudProvider))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[56] {
					yym339 := z.EncBinary()
					_ = yym339
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CloudConfigFile))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[56] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cloudConfigFile"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym340 := z.EncBinary()
					_ = yym340
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CloudConfigFile))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[57] {
					yym342 := z.EncBinary()
					_ = yym342
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.KubeletCgroups))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[57] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kubeletCgroups"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym343 := z.EncBinary()
					_ = yym343
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.KubeletCgroups))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[58] {
					yym345 := z.EncBinary()
					_ = yym345
					if false {
					} else {
						r.EncodeBool(bool(x.ExperimentalCgroupsPerQOS))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq153[58] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("experimentalCgroupsPerQOS"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym346 := z.EncBinary()
					_ = yym346
					if false {
					} else {
						r.EncodeBool(bool(x.ExperimentalCgroupsPerQOS))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[59] {
					yym348 := z.EncBinary()
					_ = yym348
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CgroupDriver))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[59] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cgroupDriver"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym349 := z.EncBinary()
					_ = yym349
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CgroupDriver))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[60] {
					yym351 := z.EncBinary()
					_ = yym351
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RuntimeCgroups))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[60] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("runtimeCgroups"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym352 := z.EncBinary()
					_ = yym352
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RuntimeCgroups))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[61] {
					yym354 := z.EncBinary()
					_ = yym354
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SystemCgroups))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[61] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("systemCgroups"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym355 := z.EncBinary()
					_ = yym355
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SystemCgroups))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[62] {
					yym357 := z.EncBinary()
					_ = yym357
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CgroupRoot))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[62] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cgroupRoot"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym358 := z.EncBinary()
					_ = yym358
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CgroupRoot))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym360 := z.EncBinary()
				_ = yym360
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContainerRuntime))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("containerRuntime"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym361 := z.EncBinary()
				_ = yym361
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContainerRuntime))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym363 := z.EncBinary()
				_ = yym363
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RemoteRuntimeEndpoint))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("remoteRuntimeEndpoint"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym364 := z.EncBinary()
				_ = yym364
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RemoteRuntimeEndpoint))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym366 := z.EncBinary()
				_ = yym366
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RemoteImageEndpoint))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("remoteImageEndpoint"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym367 := z.EncBinary()
				_ = yym367
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RemoteImageEndpoint))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[66] {
					yy369 := &x.RuntimeRequestTimeout
					yym370 := z.EncBinary()
					_ = yym370
					if false {
					} else if z.HasExtensions() && z.EncExt(yy369) {
					} else if !yym370 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy369)
					} else {
						z.EncFallback(yy369)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq153[66] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("runtimeRequestTimeout"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy371 := &x.RuntimeRequestTimeout
					yym372 := z.EncBinary()
					_ = yym372
					if false {
					} else if z.HasExtensions() && z.EncExt(yy371) {
					} else if !yym372 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy371)
					} else {
						z.EncFallback(yy371)
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[67] {
					yym374 := z.EncBinary()
					_ = yym374
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktPath))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[67] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rktPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym375 := z.EncBinary()
					_ = yym375
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktPath))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[68] {
					yym377 := z.EncBinary()
					_ = yym377
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ExperimentalMounterPath))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[68] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("experimentalMounterPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym378 := z.EncBinary()
					_ = yym378
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ExperimentalMounterPath))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[69] {
					yym380 := z.EncBinary()
					_ = yym380
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktAPIEndpoint))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[69] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rktAPIEndpoint"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym381 := z.EncBinary()
					_ = yym381
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktAPIEndpoint))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[70] {
					yym383 := z.EncBinary()
					_ = yym383
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktStage1Image))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[70] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rktStage1Image"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym384 := z.EncBinary()
					_ = yym384
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktStage1Image))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym386 := z.EncBinary()
				_ = yym386
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.LockFilePath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lockFilePath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym387 := z.EncBinary()
				_ = yym387
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.LockFilePath))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym389 := z.EncBinary()
				_ = yym389
				if false {
				} else {
					r.EncodeBool(bool(x.ExitOnLockContention))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("exitOnLockContention"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym390 := z.EncBinary()
				_ = yym390
				if false {
				} else {
					r.EncodeBool(bool(x.ExitOnLockContention))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym392 := z.EncBinary()
				_ = yym392
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HairpinMode))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hairpinMode"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym393 := z.EncBinary()
				_ = yym393
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HairpinMode))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym395 := z.EncBinary()
				_ = yym395
				if false {
				} else {
					r.EncodeBool(bool(x.BabysitDaemons))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("babysitDaemons"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym396 := z.EncBinary()
				_ = yym396
				if false {
				} else {
					r.EncodeBool(bool(x.BabysitDaemons))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym398 := z.EncBinary()
				_ = yym398
				if false {
				} else {
					r.EncodeInt(int64(x.MaxPods))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxPods"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym399 := z.EncBinary()
				_ = yym399
				if false {
				} else {
					r.EncodeInt(int64(x.MaxPods))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym401 := z.EncBinary()
				_ = yym401
				if false {
				} else {
					r.EncodeInt(int64(x.NvidiaGPUs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nvidiaGPUs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym402 := z.EncBinary()
				_ = yym402
				if false {
				} else {
					r.EncodeInt(int64(x.NvidiaGPUs))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym404 := z.EncBinary()
				_ = yym404
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DockerExecHandlerName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("dockerExecHandlerName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym405 := z.EncBinary()
				_ = yym405
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DockerExecHandlerName))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym407 := z.EncBinary()
				_ = yym407
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym408 := z.EncBinary()
				_ = yym408
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodCIDR))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym410 := z.EncBinary()
				_ = yym410
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ResolverConfig))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("resolvConf"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym411 := z.EncBinary()
				_ = yym411
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ResolverConfig))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym413 := z.EncBinary()
				_ = yym413
				if false {
				} else {
					r.EncodeBool(bool(x.CPUCFSQuota))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cpuCFSQuota"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym414 := z.EncBinary()
				_ = yym414
				if false {
				} else {
					r.EncodeBool(bool(x.CPUCFSQuota))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym416 := z.EncBinary()
				_ = yym416
				if false {
				} else {
					r.EncodeBool(bool(x.Containerized))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("containerized"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym417 := z.EncBinary()
				_ = yym417
				if false {
				} else {
					r.EncodeBool(bool(x.Containerized))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym419 := z.EncBinary()
				_ = yym419
				if false {
				} else {
					r.EncodeInt(int64(x.MaxOpenFiles))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxOpenFiles"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym420 := z.EncBinary()
				_ = yym420
				if false {
				} else {
					r.EncodeInt(int64(x.MaxOpenFiles))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym422 := z.EncBinary()
				_ = yym422
				if false {
				} else {
					r.EncodeBool(bool(x.ReconcileCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("reconcileCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym423 := z.EncBinary()
				_ = yym423
				if false {
				} else {
					r.EncodeBool(bool(x.ReconcileCIDR))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym425 := z.EncBinary()
				_ = yym425
				if false {
				} else {
					r.EncodeBool(bool(x.RegisterSchedulable))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registerSchedulable"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym426 := z.EncBinary()
				_ = yym426
				if false {
				} else {
					r.EncodeBool(bool(x.RegisterSchedulable))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym428 := z.EncBinary()
				_ = yym428
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("contentType"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym429 := z.EncBinary()
				_ = yym429
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym431 := z.EncBinary()
				_ = yym431
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym432 := z.EncBinary()
				_ = yym432
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIQPS))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym434 := z.EncBinary()
				_ = yym434
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym435 := z.EncBinary()
				_ = yym435
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym437 := z.EncBinary()
				_ = yym437
				if false {
				} else {
					r.EncodeBool(bool(x.SerializeImagePulls))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serializeImagePulls"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym438 := z.EncBinary()
				_ = yym438
				if false {
				} else {
					r.EncodeBool(bool(x.SerializeImagePulls))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[89] {
					yy440 := &x.OutOfDiskTransitionFrequency
					yym441 := z.EncBinary()
					_ = yym441
					if false {
					} else if z.HasExtensions() && z.EncExt(yy440) {
					} else if !yym441 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy440)
					} else {
						z.EncFallback(yy440)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq153[89] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("outOfDiskTransitionFrequency"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy442 := &x.OutOfDiskTransitionFrequency
					yym443 := z.EncBinary()
					_ = yym443
					if false {
					} else if z.HasExtensions() && z.EncExt(yy442) {
					} else if !yym443 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy442)
					} else {
						z.EncFallback(yy442)
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[90] {
					yym445 := z.EncBinary()
					_ = yym445
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.NodeIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[90] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym446 := z.EncBinary()
					_ = yym446
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.NodeIP))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.NodeLabels == nil {
					r.EncodeNil()
				} else {
					yym448 := z.EncBinary()
					_ = yym448
					if false {
					} else {
						z.F.EncMapStringStringV(x.NodeLabels, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeLabels"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.NodeLabels == nil {
					r.EncodeNil()
				} else {
					yym449 := z.EncBinary()
					_ = yym449
					if false {
					} else {
						z.F.EncMapStringStringV(x.NodeLabels, false, e)
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym451 := z.EncBinary()
				_ = yym451
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NonMasqueradeCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nonMasqueradeCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym452 := z.EncBinary()
				_ = yym452
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NonMasqueradeCIDR))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym454 := z.EncBinary()
				_ = yym454
				if false {
				} else {
					r.EncodeBool(bool(x.EnableCustomMetrics))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableCustomMetrics"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym455 := z.EncBinary()
				_ = yym455
				if false {
				} else {
					r.EncodeBool(bool(x.EnableCustomMetrics))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[94] {
					yym457 := z.EncBinary()
					_ = yym457
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionHard))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[94] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionHard"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym458 := z.EncBinary()
					_ = yym458
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionHard))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[95] {
					yym460 := z.EncBinary()
					_ = yym460
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionSoft))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[95] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionSoft"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym461 := z.EncBinary()
					_ = yym461
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionSoft))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[96] {
					yym463 := z.EncBinary()
					_ = yym463
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionSoftGracePeriod))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[96] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionSoftGracePeriod"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym464 := z.EncBinary()
					_ = yym464
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionSoftGracePeriod))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[97] {
					yy466 := &x.EvictionPressureTransitionPeriod
					yym467 := z.EncBinary()
					_ = yym467
					if false {
					} else if z.HasExtensions() && z.EncExt(yy466) {
					} else if !yym467 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy466)
					} else {
						z.EncFallback(yy466)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq153[97] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionPressureTransitionPeriod"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy468 := &x.EvictionPressureTransitionPeriod
					yym469 := z.EncBinary()
					_ = yym469
					if false {
					} else if z.HasExtensions() && z.EncExt(yy468) {
					} else if !yym469 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy468)
					} else {
						z.EncFallback(yy468)
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[98] {
					yym471 := z.EncBinary()
					_ = yym471
					if false {
					} else {
						r.EncodeInt(int64(x.EvictionMaxPodGracePeriod))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq153[98] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionMaxPodGracePeriod"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym472 := z.EncBinary()
					_ = yym472
					if false {
					} else {
						r.EncodeInt(int64(x.EvictionMaxPodGracePeriod))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[99] {
					yym474 := z.EncBinary()
					_ = yym474
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionMinimumReclaim))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[99] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionMinimumReclaim"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym475 := z.EncBinary()
					_ = yym475
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionMinimumReclaim))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym477 := z.EncBinary()
				_ = yym477
				if false {
				} else {
					r.EncodeBool(bool(x.ExperimentalKernelMemcgNotification))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("experimentalKernelMemcgNotification"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym478 := z.EncBinary()
				_ = yym478
				if false {
				} else {
					r.EncodeBool(bool(x.ExperimentalKernelMemcgNotification))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym480 := z.EncBinary()
				_ = yym480
				if false {
				} else {
					r.EncodeInt(int64(x.PodsPerCore))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podsPerCore"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym481 := z.EncBinary()
				_ = yym481
				if false {
				} else {
					r.EncodeInt(int64(x.PodsPerCore))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym483 := z.EncBinary()
				_ = yym483
				if false {
				} else {
					r.EncodeBool(bool(x.EnableControllerAttachDetach))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableControllerAttachDetach"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym484 := z.EncBinary()
				_ = yym484
				if false {
				} else {
					r.EncodeBool(bool(x.EnableControllerAttachDetach))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.SystemReserved == nil {
					r.EncodeNil()
				} else {
					yym486 := z.EncBinary()
					_ = yym486
					if false {
					} else if z.HasExtensions() && z.EncExt(x.SystemReserved) {
					} else {
						h.encconfig_ConfigurationMap((pkg2_config.ConfigurationMap)(x.SystemReserved), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("systemReserved"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.SystemReserved == nil {
					r.EncodeNil()
				} else {
					yym487 := z.EncBinary()
					_ = yym487
					if false {
					} else if z.HasExtensions() && z.EncExt(x.SystemReserved) {
					} else {
						h.encconfig_ConfigurationMap((pkg2_config.ConfigurationMap)(x.SystemReserved), e)
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.KubeReserved == nil {
					r.EncodeNil()
				} else {
					yym489 := z.EncBinary()
					_ = yym489
					if false {
					} else if z.HasExtensions() && z.EncExt(x.KubeReserved) {
					} else {
						h.encconfig_ConfigurationMap((pkg2_config.ConfigurationMap)(x.KubeReserved), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeReserved"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.KubeReserved == nil {
					r.EncodeNil()
				} else {
					yym490 := z.EncBinary()
					_ = yym490
					if false {
					} else if z.HasExtensions() && z.EncExt(x.KubeReserved) {
					} else {
						h.encconfig_ConfigurationMap((pkg2_config.ConfigurationMap)(x.KubeReserved), e)
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym492 := z.EncBinary()
				_ = yym492
				if false {
				} else {
					r.EncodeBool(bool(x.ProtectKernelDefaults))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("protectKernelDefaults"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym493 := z.EncBinary()
				_ = yym493
				if false {
				} else {
					r.EncodeBool(bool(x.ProtectKernelDefaults))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym495 := z.EncBinary()
				_ = yym495
				if false {
				} else {
					r.EncodeBool(bool(x.MakeIPTablesUtilChains))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("makeIPTablesUtilChains"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym496 := z.EncBinary()
				_ = yym496
				if false {
				} else {
					r.EncodeBool(bool(x.MakeIPTablesUtilChains))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym498 := z.EncBinary()
				_ = yym498
				if false {
				} else {
					r.EncodeInt(int64(x.IPTablesMasqueradeBit))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("iptablesMasqueradeBit"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym499 := z.EncBinary()
				_ = yym499
				if false {
				} else {
					r.EncodeInt(int64(x.IPTablesMasqueradeBit))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym501 := z.EncBinary()
				_ = yym501
				if false {
				} else {
					r.EncodeInt(int64(x.IPTablesDropBit))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("iptablesDropBit"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym502 := z.EncBinary()
				_ = yym502
				if false {
				} else {
					r.EncodeInt(int64(x.IPTablesDropBit))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[109] {
					if x.AllowedUnsafeSysctls == nil {
						r.EncodeNil()
					} else {
						yym504 := z.EncBinary()
						_ = yym504
						if false {
						} else {
							z.F.EncSliceStringV(x.AllowedUnsafeSysctls, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq153[109] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("experimentalAllowedUnsafeSysctls"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AllowedUnsafeSysctls == nil {
						r.EncodeNil()
					} else {
						yym505 := z.EncBinary()
						_ = yym505
						if false {
						} else {
							z.F.EncSliceStringV(x.AllowedUnsafeSysctls, false, e)
						}
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym507 := z.EncBinary()
				_ = yym507
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FeatureGates))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("featureGates"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym508 := z.EncBinary()
				_ = yym508
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FeatureGates))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[111] {
					yym510 := z.EncBinary()
					_ = yym510
					if false {
					} else {
						r.EncodeBool(bool(x.EnableCRI))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq153[111] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("enableCRI"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym511 := z.EncBinary()
					_ = yym511
					if false {
					} else {
						r.EncodeBool(bool(x.EnableCRI))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[112] {
					yym513 := z.EncBinary()
					_ = yym513
					if false {
					} else {
						r.EncodeBool(bool(x.ExperimentalFailSwapOn))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq153[112] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("experimentalFailSwapOn"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym514 := z.EncBinary()
					_ = yym514
					if false {
					} else {
						r.EncodeBool(bool(x.ExperimentalFailSwapOn))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[113] {
					yym516 := z.EncBinary()
					_ = yym516
					if false {
					} else {
						r.EncodeBool(bool(x.ExperimentalCheckNodeCapabilitiesBeforeMount))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq153[113] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ExperimentalCheckNodeCapabilitiesBeforeMount"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym517 := z.EncBinary()
					_ = yym517
					if false {
					} else {
						r.EncodeBool(bool(x.ExperimentalCheckNodeCapabilitiesBeforeMount))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeletConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym518 := z.DecBinary()
	_ = yym518
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct519 := r.ContainerType()
		if yyct519 == codecSelferValueTypeMap1234 {
			yyl519 := r.ReadMapStart()
			if yyl519 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl519, d)
			}
		} else if yyct519 == codecSelferValueTypeArray1234 {
			yyl519 := r.ReadArrayStart()
			if yyl519 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl519, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeletConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys520Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys520Slc
	var yyhl520 bool = l >= 0
	for yyj520 := 0; ; yyj520++ {
		if yyhl520 {
			if yyj520 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys520Slc = r.DecodeBytes(yys520Slc, true, true)
		yys520 := string(yys520Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys520 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "podManifestPath":
			if r.TryDecodeAsNil() {
				x.PodManifestPath = ""
			} else {
				x.PodManifestPath = string(r.DecodeString())
			}
		case "syncFrequency":
			if r.TryDecodeAsNil() {
				x.SyncFrequency = pkg1_unversioned.Duration{}
			} else {
				yyv524 := &x.SyncFrequency
				yym525 := z.DecBinary()
				_ = yym525
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv524) {
				} else if !yym525 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv524)
				} else {
					z.DecFallback(yyv524, false)
				}
			}
		case "fileCheckFrequency":
			if r.TryDecodeAsNil() {
				x.FileCheckFrequency = pkg1_unversioned.Duration{}
			} else {
				yyv526 := &x.FileCheckFrequency
				yym527 := z.DecBinary()
				_ = yym527
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv526) {
				} else if !yym527 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv526)
				} else {
					z.DecFallback(yyv526, false)
				}
			}
		case "httpCheckFrequency":
			if r.TryDecodeAsNil() {
				x.HTTPCheckFrequency = pkg1_unversioned.Duration{}
			} else {
				yyv528 := &x.HTTPCheckFrequency
				yym529 := z.DecBinary()
				_ = yym529
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv528) {
				} else if !yym529 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv528)
				} else {
					z.DecFallback(yyv528, false)
				}
			}
		case "manifestURL":
			if r.TryDecodeAsNil() {
				x.ManifestURL = ""
			} else {
				x.ManifestURL = string(r.DecodeString())
			}
		case "manifestURLHeader":
			if r.TryDecodeAsNil() {
				x.ManifestURLHeader = ""
			} else {
				x.ManifestURLHeader = string(r.DecodeString())
			}
		case "enableServer":
			if r.TryDecodeAsNil() {
				x.EnableServer = false
			} else {
				x.EnableServer = bool(r.DecodeBool())
			}
		case "address":
			if r.TryDecodeAsNil() {
				x.Address = ""
			} else {
				x.Address = string(r.DecodeString())
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int32(r.DecodeInt(32))
			}
		case "readOnlyPort":
			if r.TryDecodeAsNil() {
				x.ReadOnlyPort = 0
			} else {
				x.ReadOnlyPort = int32(r.DecodeInt(32))
			}
		case "tlsCertFile":
			if r.TryDecodeAsNil() {
				x.TLSCertFile = ""
			} else {
				x.TLSCertFile = string(r.DecodeString())
			}
		case "tlsPrivateKeyFile":
			if r.TryDecodeAsNil() {
				x.TLSPrivateKeyFile = ""
			} else {
				x.TLSPrivateKeyFile = string(r.DecodeString())
			}
		case "certDirectory":
			if r.TryDecodeAsNil() {
				x.CertDirectory = ""
			} else {
				x.CertDirectory = string(r.DecodeString())
			}
		case "authentication":
			if r.TryDecodeAsNil() {
				x.Authentication = KubeletAuthentication{}
			} else {
				yyv539 := &x.Authentication
				yyv539.CodecDecodeSelf(d)
			}
		case "authorization":
			if r.TryDecodeAsNil() {
				x.Authorization = KubeletAuthorization{}
			} else {
				yyv540 := &x.Authorization
				yyv540.CodecDecodeSelf(d)
			}
		case "hostnameOverride":
			if r.TryDecodeAsNil() {
				x.HostnameOverride = ""
			} else {
				x.HostnameOverride = string(r.DecodeString())
			}
		case "podInfraContainerImage":
			if r.TryDecodeAsNil() {
				x.PodInfraContainerImage = ""
			} else {
				x.PodInfraContainerImage = string(r.DecodeString())
			}
		case "dockerEndpoint":
			if r.TryDecodeAsNil() {
				x.DockerEndpoint = ""
			} else {
				x.DockerEndpoint = string(r.DecodeString())
			}
		case "rootDirectory":
			if r.TryDecodeAsNil() {
				x.RootDirectory = ""
			} else {
				x.RootDirectory = string(r.DecodeString())
			}
		case "seccompProfileRoot":
			if r.TryDecodeAsNil() {
				x.SeccompProfileRoot = ""
			} else {
				x.SeccompProfileRoot = string(r.DecodeString())
			}
		case "allowPrivileged":
			if r.TryDecodeAsNil() {
				x.AllowPrivileged = false
			} else {
				x.AllowPrivileged = bool(r.DecodeBool())
			}
		case "hostNetworkSources":
			if r.TryDecodeAsNil() {
				x.HostNetworkSources = nil
			} else {
				yyv547 := &x.HostNetworkSources
				yym548 := z.DecBinary()
				_ = yym548
				if false {
				} else {
					z.F.DecSliceStringX(yyv547, false, d)
				}
			}
		case "hostPIDSources":
			if r.TryDecodeAsNil() {
				x.HostPIDSources = nil
			} else {
				yyv549 := &x.HostPIDSources
				yym550 := z.DecBinary()
				_ = yym550
				if false {
				} else {
					z.F.DecSliceStringX(yyv549, false, d)
				}
			}
		case "hostIPCSources":
			if r.TryDecodeAsNil() {
				x.HostIPCSources = nil
			} else {
				yyv551 := &x.HostIPCSources
				yym552 := z.DecBinary()
				_ = yym552
				if false {
				} else {
					z.F.DecSliceStringX(yyv551, false, d)
				}
			}
		case "registryPullQPS":
			if r.TryDecodeAsNil() {
				x.RegistryPullQPS = 0
			} else {
				x.RegistryPullQPS = int32(r.DecodeInt(32))
			}
		case "registryBurst":
			if r.TryDecodeAsNil() {
				x.RegistryBurst = 0
			} else {
				x.RegistryBurst = int32(r.DecodeInt(32))
			}
		case "eventRecordQPS":
			if r.TryDecodeAsNil() {
				x.EventRecordQPS = 0
			} else {
				x.EventRecordQPS = int32(r.DecodeInt(32))
			}
		case "eventBurst":
			if r.TryDecodeAsNil() {
				x.EventBurst = 0
			} else {
				x.EventBurst = int32(r.DecodeInt(32))
			}
		case "enableDebuggingHandlers":
			if r.TryDecodeAsNil() {
				x.EnableDebuggingHandlers = false
			} else {
				x.EnableDebuggingHandlers = bool(r.DecodeBool())
			}
		case "minimumGCAge":
			if r.TryDecodeAsNil() {
				x.MinimumGCAge = pkg1_unversioned.Duration{}
			} else {
				yyv558 := &x.MinimumGCAge
				yym559 := z.DecBinary()
				_ = yym559
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv558) {
				} else if !yym559 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv558)
				} else {
					z.DecFallback(yyv558, false)
				}
			}
		case "maxPerPodContainerCount":
			if r.TryDecodeAsNil() {
				x.MaxPerPodContainerCount = 0
			} else {
				x.MaxPerPodContainerCount = int32(r.DecodeInt(32))
			}
		case "maxContainerCount":
			if r.TryDecodeAsNil() {
				x.MaxContainerCount = 0
			} else {
				x.MaxContainerCount = int32(r.DecodeInt(32))
			}
		case "cAdvisorPort":
			if r.TryDecodeAsNil() {
				x.CAdvisorPort = 0
			} else {
				x.CAdvisorPort = int32(r.DecodeInt(32))
			}
		case "healthzPort":
			if r.TryDecodeAsNil() {
				x.HealthzPort = 0
			} else {
				x.HealthzPort = int32(r.DecodeInt(32))
			}
		case "healthzBindAddress":
			if r.TryDecodeAsNil() {
				x.HealthzBindAddress = ""
			} else {
				x.HealthzBindAddress = string(r.DecodeString())
			}
		case "oomScoreAdj":
			if r.TryDecodeAsNil() {
				x.OOMScoreAdj = 0
			} else {
				x.OOMScoreAdj = int32(r.DecodeInt(32))
			}
		case "registerNode":
			if r.TryDecodeAsNil() {
				x.RegisterNode = false
			} else {
				x.RegisterNode = bool(r.DecodeBool())
			}
		case "clusterDomain":
			if r.TryDecodeAsNil() {
				x.ClusterDomain = ""
			} else {
				x.ClusterDomain = string(r.DecodeString())
			}
		case "masterServiceNamespace":
			if r.TryDecodeAsNil() {
				x.MasterServiceNamespace = ""
			} else {
				x.MasterServiceNamespace = string(r.DecodeString())
			}
		case "clusterDNS":
			if r.TryDecodeAsNil() {
				x.ClusterDNS = ""
			} else {
				x.ClusterDNS = string(r.DecodeString())
			}
		case "streamingConnectionIdleTimeout":
			if r.TryDecodeAsNil() {
				x.StreamingConnectionIdleTimeout = pkg1_unversioned.Duration{}
			} else {
				yyv570 := &x.StreamingConnectionIdleTimeout
				yym571 := z.DecBinary()
				_ = yym571
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv570) {
				} else if !yym571 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv570)
				} else {
					z.DecFallback(yyv570, false)
				}
			}
		case "nodeStatusUpdateFrequency":
			if r.TryDecodeAsNil() {
				x.NodeStatusUpdateFrequency = pkg1_unversioned.Duration{}
			} else {
				yyv572 := &x.NodeStatusUpdateFrequency
				yym573 := z.DecBinary()
				_ = yym573
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv572) {
				} else if !yym573 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv572)
				} else {
					z.DecFallback(yyv572, false)
				}
			}
		case "imageMinimumGCAge":
			if r.TryDecodeAsNil() {
				x.ImageMinimumGCAge = pkg1_unversioned.Duration{}
			} else {
				yyv574 := &x.ImageMinimumGCAge
				yym575 := z.DecBinary()
				_ = yym575
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv574) {
				} else if !yym575 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv574)
				} else {
					z.DecFallback(yyv574, false)
				}
			}
		case "imageGCHighThresholdPercent":
			if r.TryDecodeAsNil() {
				x.ImageGCHighThresholdPercent = 0
			} else {
				x.ImageGCHighThresholdPercent = int32(r.DecodeInt(32))
			}
		case "imageGCLowThresholdPercent":
			if r.TryDecodeAsNil() {
				x.ImageGCLowThresholdPercent = 0
			} else {
				x.ImageGCLowThresholdPercent = int32(r.DecodeInt(32))
			}
		case "lowDiskSpaceThresholdMB":
			if r.TryDecodeAsNil() {
				x.LowDiskSpaceThresholdMB = 0
			} else {
				x.LowDiskSpaceThresholdMB = int32(r.DecodeInt(32))
			}
		case "volumeStatsAggPeriod":
			if r.TryDecodeAsNil() {
				x.VolumeStatsAggPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv579 := &x.VolumeStatsAggPeriod
				yym580 := z.DecBinary()
				_ = yym580
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv579) {
				} else if !yym580 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv579)
				} else {
					z.DecFallback(yyv579, false)
				}
			}
		case "networkPluginName":
			if r.TryDecodeAsNil() {
				x.NetworkPluginName = ""
			} else {
				x.NetworkPluginName = string(r.DecodeString())
			}
		case "networkPluginMTU":
			if r.TryDecodeAsNil() {
				x.NetworkPluginMTU = 0
			} else {
				x.NetworkPluginMTU = int32(r.DecodeInt(32))
			}
		case "networkPluginDir":
			if r.TryDecodeAsNil() {
				x.NetworkPluginDir = ""
			} else {
				x.NetworkPluginDir = string(r.DecodeString())
			}
		case "cniConfDir":
			if r.TryDecodeAsNil() {
				x.CNIConfDir = ""
			} else {
				x.CNIConfDir = string(r.DecodeString())
			}
		case "cniBinDir":
			if r.TryDecodeAsNil() {
				x.CNIBinDir = ""
			} else {
				x.CNIBinDir = string(r.DecodeString())
			}
		case "volumePluginDir":
			if r.TryDecodeAsNil() {
				x.VolumePluginDir = ""
			} else {
				x.VolumePluginDir = string(r.DecodeString())
			}
		case "cloudProvider":
			if r.TryDecodeAsNil() {
				x.CloudProvider = ""
			} else {
				x.CloudProvider = string(r.DecodeString())
			}
		case "cloudConfigFile":
			if r.TryDecodeAsNil() {
				x.CloudConfigFile = ""
			} else {
				x.CloudConfigFile = string(r.DecodeString())
			}
		case "kubeletCgroups":
			if r.TryDecodeAsNil() {
				x.KubeletCgroups = ""
			} else {
				x.KubeletCgroups = string(r.DecodeString())
			}
		case "experimentalCgroupsPerQOS":
			if r.TryDecodeAsNil() {
				x.ExperimentalCgroupsPerQOS = false
			} else {
				x.ExperimentalCgroupsPerQOS = bool(r.DecodeBool())
			}
		case "cgroupDriver":
			if r.TryDecodeAsNil() {
				x.CgroupDriver = ""
			} else {
				x.CgroupDriver = string(r.DecodeString())
			}
		case "runtimeCgroups":
			if r.TryDecodeAsNil() {
				x.RuntimeCgroups = ""
			} else {
				x.RuntimeCgroups = string(r.DecodeString())
			}
		case "systemCgroups":
			if r.TryDecodeAsNil() {
				x.SystemCgroups = ""
			} else {
				x.SystemCgroups = string(r.DecodeString())
			}
		case "cgroupRoot":
			if r.TryDecodeAsNil() {
				x.CgroupRoot = ""
			} else {
				x.CgroupRoot = string(r.DecodeString())
			}
		case "containerRuntime":
			if r.TryDecodeAsNil() {
				x.ContainerRuntime = ""
			} else {
				x.ContainerRuntime = string(r.DecodeString())
			}
		case "remoteRuntimeEndpoint":
			if r.TryDecodeAsNil() {
				x.RemoteRuntimeEndpoint = ""
			} else {
				x.RemoteRuntimeEndpoint = string(r.DecodeString())
			}
		case "remoteImageEndpoint":
			if r.TryDecodeAsNil() {
				x.RemoteImageEndpoint = ""
			} else {
				x.RemoteImageEndpoint = string(r.DecodeString())
			}
		case "runtimeRequestTimeout":
			if r.TryDecodeAsNil() {
				x.RuntimeRequestTimeout = pkg1_unversioned.Duration{}
			} else {
				yyv598 := &x.RuntimeRequestTimeout
				yym599 := z.DecBinary()
				_ = yym599
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv598) {
				} else if !yym599 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv598)
				} else {
					z.DecFallback(yyv598, false)
				}
			}
		case "rktPath":
			if r.TryDecodeAsNil() {
				x.RktPath = ""
			} else {
				x.RktPath = string(r.DecodeString())
			}
		case "experimentalMounterPath":
			if r.TryDecodeAsNil() {
				x.ExperimentalMounterPath = ""
			} else {
				x.ExperimentalMounterPath = string(r.DecodeString())
			}
		case "rktAPIEndpoint":
			if r.TryDecodeAsNil() {
				x.RktAPIEndpoint = ""
			} else {
				x.RktAPIEndpoint = string(r.DecodeString())
			}
		case "rktStage1Image":
			if r.TryDecodeAsNil() {
				x.RktStage1Image = ""
			} else {
				x.RktStage1Image = string(r.DecodeString())
			}
		case "lockFilePath":
			if r.TryDecodeAsNil() {
				x.LockFilePath = ""
			} else {
				x.LockFilePath = string(r.DecodeString())
			}
		case "exitOnLockContention":
			if r.TryDecodeAsNil() {
				x.ExitOnLockContention = false
			} else {
				x.ExitOnLockContention = bool(r.DecodeBool())
			}
		case "hairpinMode":
			if r.TryDecodeAsNil() {
				x.HairpinMode = ""
			} else {
				x.HairpinMode = string(r.DecodeString())
			}
		case "babysitDaemons":
			if r.TryDecodeAsNil() {
				x.BabysitDaemons = false
			} else {
				x.BabysitDaemons = bool(r.DecodeBool())
			}
		case "maxPods":
			if r.TryDecodeAsNil() {
				x.MaxPods = 0
			} else {
				x.MaxPods = int32(r.DecodeInt(32))
			}
		case "nvidiaGPUs":
			if r.TryDecodeAsNil() {
				x.NvidiaGPUs = 0
			} else {
				x.NvidiaGPUs = int32(r.DecodeInt(32))
			}
		case "dockerExecHandlerName":
			if r.TryDecodeAsNil() {
				x.DockerExecHandlerName = ""
			} else {
				x.DockerExecHandlerName = string(r.DecodeString())
			}
		case "podCIDR":
			if r.TryDecodeAsNil() {
				x.PodCIDR = ""
			} else {
				x.PodCIDR = string(r.DecodeString())
			}
		case "resolvConf":
			if r.TryDecodeAsNil() {
				x.ResolverConfig = ""
			} else {
				x.ResolverConfig = string(r.DecodeString())
			}
		case "cpuCFSQuota":
			if r.TryDecodeAsNil() {
				x.CPUCFSQuota = false
			} else {
				x.CPUCFSQuota = bool(r.DecodeBool())
			}
		case "containerized":
			if r.TryDecodeAsNil() {
				x.Containerized = false
			} else {
				x.Containerized = bool(r.DecodeBool())
			}
		case "maxOpenFiles":
			if r.TryDecodeAsNil() {
				x.MaxOpenFiles = 0
			} else {
				x.MaxOpenFiles = int64(r.DecodeInt(64))
			}
		case "reconcileCIDR":
			if r.TryDecodeAsNil() {
				x.ReconcileCIDR = false
			} else {
				x.ReconcileCIDR = bool(r.DecodeBool())
			}
		case "registerSchedulable":
			if r.TryDecodeAsNil() {
				x.RegisterSchedulable = false
			} else {
				x.RegisterSchedulable = bool(r.DecodeBool())
			}
		case "contentType":
			if r.TryDecodeAsNil() {
				x.ContentType = ""
			} else {
				x.ContentType = string(r.DecodeString())
			}
		case "kubeAPIQPS":
			if r.TryDecodeAsNil() {
				x.KubeAPIQPS = 0
			} else {
				x.KubeAPIQPS = int32(r.DecodeInt(32))
			}
		case "kubeAPIBurst":
			if r.TryDecodeAsNil() {
				x.KubeAPIBurst = 0
			} else {
				x.KubeAPIBurst = int32(r.DecodeInt(32))
			}
		case "serializeImagePulls":
			if r.TryDecodeAsNil() {
				x.SerializeImagePulls = false
			} else {
				x.SerializeImagePulls = bool(r.DecodeBool())
			}
		case "outOfDiskTransitionFrequency":
			if r.TryDecodeAsNil() {
				x.OutOfDiskTransitionFrequency = pkg1_unversioned.Duration{}
			} else {
				yyv622 := &x.OutOfDiskTransitionFrequency
				yym623 := z.DecBinary()
				_ = yym623
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv622) {
				} else if !yym623 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv622)
				} else {
					z.DecFallback(yyv622, false)
				}
			}
		case "nodeIP":
			if r.TryDecodeAsNil() {
				x.NodeIP = ""
			} else {
				x.NodeIP = string(r.DecodeString())
			}
		case "nodeLabels":
			if r.TryDecodeAsNil() {
				x.NodeLabels = nil
			} else {
				yyv625 := &x.NodeLabels
				yym626 := z.DecBinary()
				_ = yym626
				if false {
				} else {
					z.F.DecMapStringStringX(yyv625, false, d)
				}
			}
		case "nonMasqueradeCIDR":
			if r.TryDecodeAsNil() {
				x.NonMasqueradeCIDR = ""
			} else {
				x.NonMasqueradeCIDR = string(r.DecodeString())
			}
		case "enableCustomMetrics":
			if r.TryDecodeAsNil() {
				x.EnableCustomMetrics = false
			} else {
				x.EnableCustomMetrics = bool(r.DecodeBool())
			}
		case "evictionHard":
			if r.TryDecodeAsNil() {
				x.EvictionHard = ""
			} else {
				x.EvictionHard = string(r.DecodeString())
			}
		case "evictionSoft":
			if r.TryDecodeAsNil() {
				x.EvictionSoft = ""
			} else {
				x.EvictionSoft = string(r.DecodeString())
			}
		case "evictionSoftGracePeriod":
			if r.TryDecodeAsNil() {
				x.EvictionSoftGracePeriod = ""
			} else {
				x.EvictionSoftGracePeriod = string(r.DecodeString())
			}
		case "evictionPressureTransitionPeriod":
			if r.TryDecodeAsNil() {
				x.EvictionPressureTransitionPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv632 := &x.EvictionPressureTransitionPeriod
				yym633 := z.DecBinary()
				_ = yym633
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv632) {
				} else if !yym633 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv632)
				} else {
					z.DecFallback(yyv632, false)
				}
			}
		case "evictionMaxPodGracePeriod":
			if r.TryDecodeAsNil() {
				x.EvictionMaxPodGracePeriod = 0
			} else {
				x.EvictionMaxPodGracePeriod = int32(r.DecodeInt(32))
			}
		case "evictionMinimumReclaim":
			if r.TryDecodeAsNil() {
				x.EvictionMinimumReclaim = ""
			} else {
				x.EvictionMinimumReclaim = string(r.DecodeString())
			}
		case "experimentalKernelMemcgNotification":
			if r.TryDecodeAsNil() {
				x.ExperimentalKernelMemcgNotification = false
			} else {
				x.ExperimentalKernelMemcgNotification = bool(r.DecodeBool())
			}
		case "podsPerCore":
			if r.TryDecodeAsNil() {
				x.PodsPerCore = 0
			} else {
				x.PodsPerCore = int32(r.DecodeInt(32))
			}
		case "enableControllerAttachDetach":
			if r.TryDecodeAsNil() {
				x.EnableControllerAttachDetach = false
			} else {
				x.EnableControllerAttachDetach = bool(r.DecodeBool())
			}
		case "systemReserved":
			if r.TryDecodeAsNil() {
				x.SystemReserved = nil
			} else {
				yyv639 := &x.SystemReserved
				yym640 := z.DecBinary()
				_ = yym640
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv639) {
				} else {
					h.decconfig_ConfigurationMap((*pkg2_config.ConfigurationMap)(yyv639), d)
				}
			}
		case "kubeReserved":
			if r.TryDecodeAsNil() {
				x.KubeReserved = nil
			} else {
				yyv641 := &x.KubeReserved
				yym642 := z.DecBinary()
				_ = yym642
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv641) {
				} else {
					h.decconfig_ConfigurationMap((*pkg2_config.ConfigurationMap)(yyv641), d)
				}
			}
		case "protectKernelDefaults":
			if r.TryDecodeAsNil() {
				x.ProtectKernelDefaults = false
			} else {
				x.ProtectKernelDefaults = bool(r.DecodeBool())
			}
		case "makeIPTablesUtilChains":
			if r.TryDecodeAsNil() {
				x.MakeIPTablesUtilChains = false
			} else {
				x.MakeIPTablesUtilChains = bool(r.DecodeBool())
			}
		case "iptablesMasqueradeBit":
			if r.TryDecodeAsNil() {
				x.IPTablesMasqueradeBit = 0
			} else {
				x.IPTablesMasqueradeBit = int32(r.DecodeInt(32))
			}
		case "iptablesDropBit":
			if r.TryDecodeAsNil() {
				x.IPTablesDropBit = 0
			} else {
				x.IPTablesDropBit = int32(r.DecodeInt(32))
			}
		case "experimentalAllowedUnsafeSysctls":
			if r.TryDecodeAsNil() {
				x.AllowedUnsafeSysctls = nil
			} else {
				yyv647 := &x.AllowedUnsafeSysctls
				yym648 := z.DecBinary()
				_ = yym648
				if false {
				} else {
					z.F.DecSliceStringX(yyv647, false, d)
				}
			}
		case "featureGates":
			if r.TryDecodeAsNil() {
				x.FeatureGates = ""
			} else {
				x.FeatureGates = string(r.DecodeString())
			}
		case "enableCRI":
			if r.TryDecodeAsNil() {
				x.EnableCRI = false
			} else {
				x.EnableCRI = bool(r.DecodeBool())
			}
		case "experimentalFailSwapOn":
			if r.TryDecodeAsNil() {
				x.ExperimentalFailSwapOn = false
			} else {
				x.ExperimentalFailSwapOn = bool(r.DecodeBool())
			}
		case "ExperimentalCheckNodeCapabilitiesBeforeMount":
			if r.TryDecodeAsNil() {
				x.ExperimentalCheckNodeCapabilitiesBeforeMount = false
			} else {
				x.ExperimentalCheckNodeCapabilitiesBeforeMount = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys520)
		} // end switch yys520
	} // end for yyj520
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeletConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj653 int
	var yyb653 bool
	var yyhl653 bool = l >= 0
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodManifestPath = ""
	} else {
		x.PodManifestPath = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SyncFrequency = pkg1_unversioned.Duration{}
	} else {
		yyv657 := &x.SyncFrequency
		yym658 := z.DecBinary()
		_ = yym658
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv657) {
		} else if !yym658 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv657)
		} else {
			z.DecFallback(yyv657, false)
		}
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FileCheckFrequency = pkg1_unversioned.Duration{}
	} else {
		yyv659 := &x.FileCheckFrequency
		yym660 := z.DecBinary()
		_ = yym660
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv659) {
		} else if !yym660 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv659)
		} else {
			z.DecFallback(yyv659, false)
		}
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HTTPCheckFrequency = pkg1_unversioned.Duration{}
	} else {
		yyv661 := &x.HTTPCheckFrequency
		yym662 := z.DecBinary()
		_ = yym662
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv661) {
		} else if !yym662 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv661)
		} else {
			z.DecFallback(yyv661, false)
		}
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ManifestURL = ""
	} else {
		x.ManifestURL = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ManifestURLHeader = ""
	} else {
		x.ManifestURLHeader = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableServer = false
	} else {
		x.EnableServer = bool(r.DecodeBool())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Address = ""
	} else {
		x.Address = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int32(r.DecodeInt(32))
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnlyPort = 0
	} else {
		x.ReadOnlyPort = int32(r.DecodeInt(32))
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TLSCertFile = ""
	} else {
		x.TLSCertFile = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TLSPrivateKeyFile = ""
	} else {
		x.TLSPrivateKeyFile = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CertDirectory = ""
	} else {
		x.CertDirectory = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Authentication = KubeletAuthentication{}
	} else {
		yyv672 := &x.Authentication
		yyv672.CodecDecodeSelf(d)
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Authorization = KubeletAuthorization{}
	} else {
		yyv673 := &x.Authorization
		yyv673.CodecDecodeSelf(d)
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostnameOverride = ""
	} else {
		x.HostnameOverride = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodInfraContainerImage = ""
	} else {
		x.PodInfraContainerImage = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DockerEndpoint = ""
	} else {
		x.DockerEndpoint = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RootDirectory = ""
	} else {
		x.RootDirectory = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SeccompProfileRoot = ""
	} else {
		x.SeccompProfileRoot = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AllowPrivileged = false
	} else {
		x.AllowPrivileged = bool(r.DecodeBool())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostNetworkSources = nil
	} else {
		yyv680 := &x.HostNetworkSources
		yym681 := z.DecBinary()
		_ = yym681
		if false {
		} else {
			z.F.DecSliceStringX(yyv680, false, d)
		}
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostPIDSources = nil
	} else {
		yyv682 := &x.HostPIDSources
		yym683 := z.DecBinary()
		_ = yym683
		if false {
		} else {
			z.F.DecSliceStringX(yyv682, false, d)
		}
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostIPCSources = nil
	} else {
		yyv684 := &x.HostIPCSources
		yym685 := z.DecBinary()
		_ = yym685
		if false {
		} else {
			z.F.DecSliceStringX(yyv684, false, d)
		}
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegistryPullQPS = 0
	} else {
		x.RegistryPullQPS = int32(r.DecodeInt(32))
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegistryBurst = 0
	} else {
		x.RegistryBurst = int32(r.DecodeInt(32))
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EventRecordQPS = 0
	} else {
		x.EventRecordQPS = int32(r.DecodeInt(32))
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EventBurst = 0
	} else {
		x.EventBurst = int32(r.DecodeInt(32))
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableDebuggingHandlers = false
	} else {
		x.EnableDebuggingHandlers = bool(r.DecodeBool())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinimumGCAge = pkg1_unversioned.Duration{}
	} else {
		yyv691 := &x.MinimumGCAge
		yym692 := z.DecBinary()
		_ = yym692
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv691) {
		} else if !yym692 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv691)
		} else {
			z.DecFallback(yyv691, false)
		}
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxPerPodContainerCount = 0
	} else {
		x.MaxPerPodContainerCount = int32(r.DecodeInt(32))
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxContainerCount = 0
	} else {
		x.MaxContainerCount = int32(r.DecodeInt(32))
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CAdvisorPort = 0
	} else {
		x.CAdvisorPort = int32(r.DecodeInt(32))
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HealthzPort = 0
	} else {
		x.HealthzPort = int32(r.DecodeInt(32))
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HealthzBindAddress = ""
	} else {
		x.HealthzBindAddress = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OOMScoreAdj = 0
	} else {
		x.OOMScoreAdj = int32(r.DecodeInt(32))
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegisterNode = false
	} else {
		x.RegisterNode = bool(r.DecodeBool())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterDomain = ""
	} else {
		x.ClusterDomain = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MasterServiceNamespace = ""
	} else {
		x.MasterServiceNamespace = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterDNS = ""
	} else {
		x.ClusterDNS = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.StreamingConnectionIdleTimeout = pkg1_unversioned.Duration{}
	} else {
		yyv703 := &x.StreamingConnectionIdleTimeout
		yym704 := z.DecBinary()
		_ = yym704
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv703) {
		} else if !yym704 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv703)
		} else {
			z.DecFallback(yyv703, false)
		}
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeStatusUpdateFrequency = pkg1_unversioned.Duration{}
	} else {
		yyv705 := &x.NodeStatusUpdateFrequency
		yym706 := z.DecBinary()
		_ = yym706
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv705) {
		} else if !yym706 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv705)
		} else {
			z.DecFallback(yyv705, false)
		}
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImageMinimumGCAge = pkg1_unversioned.Duration{}
	} else {
		yyv707 := &x.ImageMinimumGCAge
		yym708 := z.DecBinary()
		_ = yym708
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv707) {
		} else if !yym708 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv707)
		} else {
			z.DecFallback(yyv707, false)
		}
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImageGCHighThresholdPercent = 0
	} else {
		x.ImageGCHighThresholdPercent = int32(r.DecodeInt(32))
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImageGCLowThresholdPercent = 0
	} else {
		x.ImageGCLowThresholdPercent = int32(r.DecodeInt(32))
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LowDiskSpaceThresholdMB = 0
	} else {
		x.LowDiskSpaceThresholdMB = int32(r.DecodeInt(32))
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeStatsAggPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv712 := &x.VolumeStatsAggPeriod
		yym713 := z.DecBinary()
		_ = yym713
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv712) {
		} else if !yym713 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv712)
		} else {
			z.DecFallback(yyv712, false)
		}
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NetworkPluginName = ""
	} else {
		x.NetworkPluginName = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NetworkPluginMTU = 0
	} else {
		x.NetworkPluginMTU = int32(r.DecodeInt(32))
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NetworkPluginDir = ""
	} else {
		x.NetworkPluginDir = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CNIConfDir = ""
	} else {
		x.CNIConfDir = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CNIBinDir = ""
	} else {
		x.CNIBinDir = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumePluginDir = ""
	} else {
		x.VolumePluginDir = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CloudProvider = ""
	} else {
		x.CloudProvider = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CloudConfigFile = ""
	} else {
		x.CloudConfigFile = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeletCgroups = ""
	} else {
		x.KubeletCgroups = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExperimentalCgroupsPerQOS = false
	} else {
		x.ExperimentalCgroupsPerQOS = bool(r.DecodeBool())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CgroupDriver = ""
	} else {
		x.CgroupDriver = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RuntimeCgroups = ""
	} else {
		x.RuntimeCgroups = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SystemCgroups = ""
	} else {
		x.SystemCgroups = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CgroupRoot = ""
	} else {
		x.CgroupRoot = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerRuntime = ""
	} else {
		x.ContainerRuntime = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RemoteRuntimeEndpoint = ""
	} else {
		x.RemoteRuntimeEndpoint = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RemoteImageEndpoint = ""
	} else {
		x.RemoteImageEndpoint = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RuntimeRequestTimeout = pkg1_unversioned.Duration{}
	} else {
		yyv731 := &x.RuntimeRequestTimeout
		yym732 := z.DecBinary()
		_ = yym732
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv731) {
		} else if !yym732 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv731)
		} else {
			z.DecFallback(yyv731, false)
		}
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RktPath = ""
	} else {
		x.RktPath = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExperimentalMounterPath = ""
	} else {
		x.ExperimentalMounterPath = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RktAPIEndpoint = ""
	} else {
		x.RktAPIEndpoint = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RktStage1Image = ""
	} else {
		x.RktStage1Image = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LockFilePath = ""
	} else {
		x.LockFilePath = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExitOnLockContention = false
	} else {
		x.ExitOnLockContention = bool(r.DecodeBool())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HairpinMode = ""
	} else {
		x.HairpinMode = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.BabysitDaemons = false
	} else {
		x.BabysitDaemons = bool(r.DecodeBool())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxPods = 0
	} else {
		x.MaxPods = int32(r.DecodeInt(32))
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NvidiaGPUs = 0
	} else {
		x.NvidiaGPUs = int32(r.DecodeInt(32))
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DockerExecHandlerName = ""
	} else {
		x.DockerExecHandlerName = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodCIDR = ""
	} else {
		x.PodCIDR = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResolverConfig = ""
	} else {
		x.ResolverConfig = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CPUCFSQuota = false
	} else {
		x.CPUCFSQuota = bool(r.DecodeBool())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Containerized = false
	} else {
		x.Containerized = bool(r.DecodeBool())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxOpenFiles = 0
	} else {
		x.MaxOpenFiles = int64(r.DecodeInt(64))
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReconcileCIDR = false
	} else {
		x.ReconcileCIDR = bool(r.DecodeBool())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegisterSchedulable = false
	} else {
		x.RegisterSchedulable = bool(r.DecodeBool())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContentType = ""
	} else {
		x.ContentType = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIQPS = 0
	} else {
		x.KubeAPIQPS = int32(r.DecodeInt(32))
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIBurst = 0
	} else {
		x.KubeAPIBurst = int32(r.DecodeInt(32))
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SerializeImagePulls = false
	} else {
		x.SerializeImagePulls = bool(r.DecodeBool())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OutOfDiskTransitionFrequency = pkg1_unversioned.Duration{}
	} else {
		yyv755 := &x.OutOfDiskTransitionFrequency
		yym756 := z.DecBinary()
		_ = yym756
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv755) {
		} else if !yym756 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv755)
		} else {
			z.DecFallback(yyv755, false)
		}
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeIP = ""
	} else {
		x.NodeIP = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeLabels = nil
	} else {
		yyv758 := &x.NodeLabels
		yym759 := z.DecBinary()
		_ = yym759
		if false {
		} else {
			z.F.DecMapStringStringX(yyv758, false, d)
		}
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NonMasqueradeCIDR = ""
	} else {
		x.NonMasqueradeCIDR = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableCustomMetrics = false
	} else {
		x.EnableCustomMetrics = bool(r.DecodeBool())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionHard = ""
	} else {
		x.EvictionHard = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionSoft = ""
	} else {
		x.EvictionSoft = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionSoftGracePeriod = ""
	} else {
		x.EvictionSoftGracePeriod = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionPressureTransitionPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv765 := &x.EvictionPressureTransitionPeriod
		yym766 := z.DecBinary()
		_ = yym766
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv765) {
		} else if !yym766 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv765)
		} else {
			z.DecFallback(yyv765, false)
		}
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionMaxPodGracePeriod = 0
	} else {
		x.EvictionMaxPodGracePeriod = int32(r.DecodeInt(32))
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionMinimumReclaim = ""
	} else {
		x.EvictionMinimumReclaim = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExperimentalKernelMemcgNotification = false
	} else {
		x.ExperimentalKernelMemcgNotification = bool(r.DecodeBool())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodsPerCore = 0
	} else {
		x.PodsPerCore = int32(r.DecodeInt(32))
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableControllerAttachDetach = false
	} else {
		x.EnableControllerAttachDetach = bool(r.DecodeBool())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SystemReserved = nil
	} else {
		yyv772 := &x.SystemReserved
		yym773 := z.DecBinary()
		_ = yym773
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv772) {
		} else {
			h.decconfig_ConfigurationMap((*pkg2_config.ConfigurationMap)(yyv772), d)
		}
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeReserved = nil
	} else {
		yyv774 := &x.KubeReserved
		yym775 := z.DecBinary()
		_ = yym775
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv774) {
		} else {
			h.decconfig_ConfigurationMap((*pkg2_config.ConfigurationMap)(yyv774), d)
		}
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ProtectKernelDefaults = false
	} else {
		x.ProtectKernelDefaults = bool(r.DecodeBool())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MakeIPTablesUtilChains = false
	} else {
		x.MakeIPTablesUtilChains = bool(r.DecodeBool())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IPTablesMasqueradeBit = 0
	} else {
		x.IPTablesMasqueradeBit = int32(r.DecodeInt(32))
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IPTablesDropBit = 0
	} else {
		x.IPTablesDropBit = int32(r.DecodeInt(32))
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AllowedUnsafeSysctls = nil
	} else {
		yyv780 := &x.AllowedUnsafeSysctls
		yym781 := z.DecBinary()
		_ = yym781
		if false {
		} else {
			z.F.DecSliceStringX(yyv780, false, d)
		}
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FeatureGates = ""
	} else {
		x.FeatureGates = string(r.DecodeString())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableCRI = false
	} else {
		x.EnableCRI = bool(r.DecodeBool())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExperimentalFailSwapOn = false
	} else {
		x.ExperimentalFailSwapOn = bool(r.DecodeBool())
	}
	yyj653++
	if yyhl653 {
		yyb653 = yyj653 > l
	} else {
		yyb653 = r.CheckBreak()
	}
	if yyb653 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExperimentalCheckNodeCapabilitiesBeforeMount = false
	} else {
		x.ExperimentalCheckNodeCapabilitiesBeforeMount = bool(r.DecodeBool())
	}
	for {
		yyj653++
		if yyhl653 {
			yyb653 = yyj653 > l
		} else {
			yyb653 = r.CheckBreak()
		}
		if yyb653 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj653-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x KubeletAuthorizationMode) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym786 := z.EncBinary()
	_ = yym786
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *KubeletAuthorizationMode) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym787 := z.DecBinary()
	_ = yym787
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *KubeletAuthorization) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym788 := z.EncBinary()
		_ = yym788
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep789 := !z.EncBinary()
			yy2arr789 := z.EncBasicHandle().StructToArray
			var yyq789 [2]bool
			_, _, _ = yysep789, yyq789, yy2arr789
			const yyr789 bool = false
			var yynn789 int
			if yyr789 || yy2arr789 {
				r.EncodeArrayStart(2)
			} else {
				yynn789 = 2
				for _, b := range yyq789 {
					if b {
						yynn789++
					}
				}
				r.EncodeMapStart(yynn789)
				yynn789 = 0
			}
			if yyr789 || yy2arr789 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Mode.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("mode"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Mode.CodecEncodeSelf(e)
			}
			if yyr789 || yy2arr789 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy792 := &x.Webhook
				yy792.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("webhook"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy793 := &x.Webhook
				yy793.CodecEncodeSelf(e)
			}
			if yyr789 || yy2arr789 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeletAuthorization) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym794 := z.DecBinary()
	_ = yym794
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct795 := r.ContainerType()
		if yyct795 == codecSelferValueTypeMap1234 {
			yyl795 := r.ReadMapStart()
			if yyl795 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl795, d)
			}
		} else if yyct795 == codecSelferValueTypeArray1234 {
			yyl795 := r.ReadArrayStart()
			if yyl795 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl795, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeletAuthorization) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys796Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys796Slc
	var yyhl796 bool = l >= 0
	for yyj796 := 0; ; yyj796++ {
		if yyhl796 {
			if yyj796 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys796Slc = r.DecodeBytes(yys796Slc, true, true)
		yys796 := string(yys796Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys796 {
		case "mode":
			if r.TryDecodeAsNil() {
				x.Mode = ""
			} else {
				x.Mode = KubeletAuthorizationMode(r.DecodeString())
			}
		case "webhook":
			if r.TryDecodeAsNil() {
				x.Webhook = KubeletWebhookAuthorization{}
			} else {
				yyv798 := &x.Webhook
				yyv798.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys796)
		} // end switch yys796
	} // end for yyj796
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeletAuthorization) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj799 int
	var yyb799 bool
	var yyhl799 bool = l >= 0
	yyj799++
	if yyhl799 {
		yyb799 = yyj799 > l
	} else {
		yyb799 = r.CheckBreak()
	}
	if yyb799 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Mode = ""
	} else {
		x.Mode = KubeletAuthorizationMode(r.DecodeString())
	}
	yyj799++
	if yyhl799 {
		yyb799 = yyj799 > l
	} else {
		yyb799 = r.CheckBreak()
	}
	if yyb799 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Webhook = KubeletWebhookAuthorization{}
	} else {
		yyv801 := &x.Webhook
		yyv801.CodecDecodeSelf(d)
	}
	for {
		yyj799++
		if yyhl799 {
			yyb799 = yyj799 > l
		} else {
			yyb799 = r.CheckBreak()
		}
		if yyb799 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj799-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *KubeletWebhookAuthorization) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym802 := z.EncBinary()
		_ = yym802
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep803 := !z.EncBinary()
			yy2arr803 := z.EncBasicHandle().StructToArray
			var yyq803 [2]bool
			_, _, _ = yysep803, yyq803, yy2arr803
			const yyr803 bool = false
			var yynn803 int
			if yyr803 || yy2arr803 {
				r.EncodeArrayStart(2)
			} else {
				yynn803 = 2
				for _, b := range yyq803 {
					if b {
						yynn803++
					}
				}
				r.EncodeMapStart(yynn803)
				yynn803 = 0
			}
			if yyr803 || yy2arr803 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy805 := &x.CacheAuthorizedTTL
				yym806 := z.EncBinary()
				_ = yym806
				if false {
				} else if z.HasExtensions() && z.EncExt(yy805) {
				} else if !yym806 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy805)
				} else {
					z.EncFallback(yy805)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cacheAuthorizedTTL"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy807 := &x.CacheAuthorizedTTL
				yym808 := z.EncBinary()
				_ = yym808
				if false {
				} else if z.HasExtensions() && z.EncExt(yy807) {
				} else if !yym808 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy807)
				} else {
					z.EncFallback(yy807)
				}
			}
			if yyr803 || yy2arr803 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy810 := &x.CacheUnauthorizedTTL
				yym811 := z.EncBinary()
				_ = yym811
				if false {
				} else if z.HasExtensions() && z.EncExt(yy810) {
				} else if !yym811 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy810)
				} else {
					z.EncFallback(yy810)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cacheUnauthorizedTTL"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy812 := &x.CacheUnauthorizedTTL
				yym813 := z.EncBinary()
				_ = yym813
				if false {
				} else if z.HasExtensions() && z.EncExt(yy812) {
				} else if !yym813 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy812)
				} else {
					z.EncFallback(yy812)
				}
			}
			if yyr803 || yy2arr803 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeletWebhookAuthorization) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym814 := z.DecBinary()
	_ = yym814
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct815 := r.ContainerType()
		if yyct815 == codecSelferValueTypeMap1234 {
			yyl815 := r.ReadMapStart()
			if yyl815 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl815, d)
			}
		} else if yyct815 == codecSelferValueTypeArray1234 {
			yyl815 := r.ReadArrayStart()
			if yyl815 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl815, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeletWebhookAuthorization) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys816Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys816Slc
	var yyhl816 bool = l >= 0
	for yyj816 := 0; ; yyj816++ {
		if yyhl816 {
			if yyj816 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys816Slc = r.DecodeBytes(yys816Slc, true, true)
		yys816 := string(yys816Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys816 {
		case "cacheAuthorizedTTL":
			if r.TryDecodeAsNil() {
				x.CacheAuthorizedTTL = pkg1_unversioned.Duration{}
			} else {
				yyv817 := &x.CacheAuthorizedTTL
				yym818 := z.DecBinary()
				_ = yym818
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv817) {
				} else if !yym818 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv817)
				} else {
					z.DecFallback(yyv817, false)
				}
			}
		case "cacheUnauthorizedTTL":
			if r.TryDecodeAsNil() {
				x.CacheUnauthorizedTTL = pkg1_unversioned.Duration{}
			} else {
				yyv819 := &x.CacheUnauthorizedTTL
				yym820 := z.DecBinary()
				_ = yym820
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv819) {
				} else if !yym820 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv819)
				} else {
					z.DecFallback(yyv819, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys816)
		} // end switch yys816
	} // end for yyj816
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeletWebhookAuthorization) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj821 int
	var yyb821 bool
	var yyhl821 bool = l >= 0
	yyj821++
	if yyhl821 {
		yyb821 = yyj821 > l
	} else {
		yyb821 = r.CheckBreak()
	}
	if yyb821 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CacheAuthorizedTTL = pkg1_unversioned.Duration{}
	} else {
		yyv822 := &x.CacheAuthorizedTTL
		yym823 := z.DecBinary()
		_ = yym823
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv822) {
		} else if !yym823 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv822)
		} else {
			z.DecFallback(yyv822, false)
		}
	}
	yyj821++
	if yyhl821 {
		yyb821 = yyj821 > l
	} else {
		yyb821 = r.CheckBreak()
	}
	if yyb821 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CacheUnauthorizedTTL = pkg1_unversioned.Duration{}
	} else {
		yyv824 := &x.CacheUnauthorizedTTL
		yym825 := z.DecBinary()
		_ = yym825
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv824) {
		} else if !yym825 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv824)
		} else {
			z.DecFallback(yyv824, false)
		}
	}
	for {
		yyj821++
		if yyhl821 {
			yyb821 = yyj821 > l
		} else {
			yyb821 = r.CheckBreak()
		}
		if yyb821 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj821-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *KubeletAuthentication) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym826 := z.EncBinary()
		_ = yym826
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep827 := !z.EncBinary()
			yy2arr827 := z.EncBasicHandle().StructToArray
			var yyq827 [3]bool
			_, _, _ = yysep827, yyq827, yy2arr827
			const yyr827 bool = false
			var yynn827 int
			if yyr827 || yy2arr827 {
				r.EncodeArrayStart(3)
			} else {
				yynn827 = 3
				for _, b := range yyq827 {
					if b {
						yynn827++
					}
				}
				r.EncodeMapStart(yynn827)
				yynn827 = 0
			}
			if yyr827 || yy2arr827 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy829 := &x.X509
				yy829.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("x509"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy830 := &x.X509
				yy830.CodecEncodeSelf(e)
			}
			if yyr827 || yy2arr827 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy832 := &x.Webhook
				yy832.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("webhook"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy833 := &x.Webhook
				yy833.CodecEncodeSelf(e)
			}
			if yyr827 || yy2arr827 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy835 := &x.Anonymous
				yy835.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("anonymous"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy836 := &x.Anonymous
				yy836.CodecEncodeSelf(e)
			}
			if yyr827 || yy2arr827 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeletAuthentication) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym837 := z.DecBinary()
	_ = yym837
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct838 := r.ContainerType()
		if yyct838 == codecSelferValueTypeMap1234 {
			yyl838 := r.ReadMapStart()
			if yyl838 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl838, d)
			}
		} else if yyct838 == codecSelferValueTypeArray1234 {
			yyl838 := r.ReadArrayStart()
			if yyl838 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl838, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeletAuthentication) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys839Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys839Slc
	var yyhl839 bool = l >= 0
	for yyj839 := 0; ; yyj839++ {
		if yyhl839 {
			if yyj839 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys839Slc = r.DecodeBytes(yys839Slc, true, true)
		yys839 := string(yys839Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys839 {
		case "x509":
			if r.TryDecodeAsNil() {
				x.X509 = KubeletX509Authentication{}
			} else {
				yyv840 := &x.X509
				yyv840.CodecDecodeSelf(d)
			}
		case "webhook":
			if r.TryDecodeAsNil() {
				x.Webhook = KubeletWebhookAuthentication{}
			} else {
				yyv841 := &x.Webhook
				yyv841.CodecDecodeSelf(d)
			}
		case "anonymous":
			if r.TryDecodeAsNil() {
				x.Anonymous = KubeletAnonymousAuthentication{}
			} else {
				yyv842 := &x.Anonymous
				yyv842.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys839)
		} // end switch yys839
	} // end for yyj839
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeletAuthentication) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj843 int
	var yyb843 bool
	var yyhl843 bool = l >= 0
	yyj843++
	if yyhl843 {
		yyb843 = yyj843 > l
	} else {
		yyb843 = r.CheckBreak()
	}
	if yyb843 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.X509 = KubeletX509Authentication{}
	} else {
		yyv844 := &x.X509
		yyv844.CodecDecodeSelf(d)
	}
	yyj843++
	if yyhl843 {
		yyb843 = yyj843 > l
	} else {
		yyb843 = r.CheckBreak()
	}
	if yyb843 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Webhook = KubeletWebhookAuthentication{}
	} else {
		yyv845 := &x.Webhook
		yyv845.CodecDecodeSelf(d)
	}
	yyj843++
	if yyhl843 {
		yyb843 = yyj843 > l
	} else {
		yyb843 = r.CheckBreak()
	}
	if yyb843 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Anonymous = KubeletAnonymousAuthentication{}
	} else {
		yyv846 := &x.Anonymous
		yyv846.CodecDecodeSelf(d)
	}
	for {
		yyj843++
		if yyhl843 {
			yyb843 = yyj843 > l
		} else {
			yyb843 = r.CheckBreak()
		}
		if yyb843 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj843-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *KubeletX509Authentication) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym847 := z.EncBinary()
		_ = yym847
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep848 := !z.EncBinary()
			yy2arr848 := z.EncBasicHandle().StructToArray
			var yyq848 [1]bool
			_, _, _ = yysep848, yyq848, yy2arr848
			const yyr848 bool = false
			var yynn848 int
			if yyr848 || yy2arr848 {
				r.EncodeArrayStart(1)
			} else {
				yynn848 = 1
				for _, b := range yyq848 {
					if b {
						yynn848++
					}
				}
				r.EncodeMapStart(yynn848)
				yynn848 = 0
			}
			if yyr848 || yy2arr848 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym850 := z.EncBinary()
				_ = yym850
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClientCAFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clientCAFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym851 := z.EncBinary()
				_ = yym851
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClientCAFile))
				}
			}
			if yyr848 || yy2arr848 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeletX509Authentication) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym852 := z.DecBinary()
	_ = yym852
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct853 := r.ContainerType()
		if yyct853 == codecSelferValueTypeMap1234 {
			yyl853 := r.ReadMapStart()
			if yyl853 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl853, d)
			}
		} else if yyct853 == codecSelferValueTypeArray1234 {
			yyl853 := r.ReadArrayStart()
			if yyl853 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl853, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeletX509Authentication) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys854Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys854Slc
	var yyhl854 bool = l >= 0
	for yyj854 := 0; ; yyj854++ {
		if yyhl854 {
			if yyj854 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys854Slc = r.DecodeBytes(yys854Slc, true, true)
		yys854 := string(yys854Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys854 {
		case "clientCAFile":
			if r.TryDecodeAsNil() {
				x.ClientCAFile = ""
			} else {
				x.ClientCAFile = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys854)
		} // end switch yys854
	} // end for yyj854
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeletX509Authentication) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj856 int
	var yyb856 bool
	var yyhl856 bool = l >= 0
	yyj856++
	if yyhl856 {
		yyb856 = yyj856 > l
	} else {
		yyb856 = r.CheckBreak()
	}
	if yyb856 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClientCAFile = ""
	} else {
		x.ClientCAFile = string(r.DecodeString())
	}
	for {
		yyj856++
		if yyhl856 {
			yyb856 = yyj856 > l
		} else {
			yyb856 = r.CheckBreak()
		}
		if yyb856 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj856-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *KubeletWebhookAuthentication) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym858 := z.EncBinary()
		_ = yym858
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep859 := !z.EncBinary()
			yy2arr859 := z.EncBasicHandle().StructToArray
			var yyq859 [2]bool
			_, _, _ = yysep859, yyq859, yy2arr859
			const yyr859 bool = false
			var yynn859 int
			if yyr859 || yy2arr859 {
				r.EncodeArrayStart(2)
			} else {
				yynn859 = 2
				for _, b := range yyq859 {
					if b {
						yynn859++
					}
				}
				r.EncodeMapStart(yynn859)
				yynn859 = 0
			}
			if yyr859 || yy2arr859 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym861 := z.EncBinary()
				_ = yym861
				if false {
				} else {
					r.EncodeBool(bool(x.Enabled))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enabled"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym862 := z.EncBinary()
				_ = yym862
				if false {
				} else {
					r.EncodeBool(bool(x.Enabled))
				}
			}
			if yyr859 || yy2arr859 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy864 := &x.CacheTTL
				yym865 := z.EncBinary()
				_ = yym865
				if false {
				} else if z.HasExtensions() && z.EncExt(yy864) {
				} else if !yym865 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy864)
				} else {
					z.EncFallback(yy864)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cacheTTL"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy866 := &x.CacheTTL
				yym867 := z.EncBinary()
				_ = yym867
				if false {
				} else if z.HasExtensions() && z.EncExt(yy866) {
				} else if !yym867 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy866)
				} else {
					z.EncFallback(yy866)
				}
			}
			if yyr859 || yy2arr859 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeletWebhookAuthentication) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym868 := z.DecBinary()
	_ = yym868
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct869 := r.ContainerType()
		if yyct869 == codecSelferValueTypeMap1234 {
			yyl869 := r.ReadMapStart()
			if yyl869 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl869, d)
			}
		} else if yyct869 == codecSelferValueTypeArray1234 {
			yyl869 := r.ReadArrayStart()
			if yyl869 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl869, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeletWebhookAuthentication) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys870Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys870Slc
	var yyhl870 bool = l >= 0
	for yyj870 := 0; ; yyj870++ {
		if yyhl870 {
			if yyj870 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys870Slc = r.DecodeBytes(yys870Slc, true, true)
		yys870 := string(yys870Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys870 {
		case "enabled":
			if r.TryDecodeAsNil() {
				x.Enabled = false
			} else {
				x.Enabled = bool(r.DecodeBool())
			}
		case "cacheTTL":
			if r.TryDecodeAsNil() {
				x.CacheTTL = pkg1_unversioned.Duration{}
			} else {
				yyv872 := &x.CacheTTL
				yym873 := z.DecBinary()
				_ = yym873
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv872) {
				} else if !yym873 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv872)
				} else {
					z.DecFallback(yyv872, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys870)
		} // end switch yys870
	} // end for yyj870
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeletWebhookAuthentication) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj874 int
	var yyb874 bool
	var yyhl874 bool = l >= 0
	yyj874++
	if yyhl874 {
		yyb874 = yyj874 > l
	} else {
		yyb874 = r.CheckBreak()
	}
	if yyb874 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Enabled = false
	} else {
		x.Enabled = bool(r.DecodeBool())
	}
	yyj874++
	if yyhl874 {
		yyb874 = yyj874 > l
	} else {
		yyb874 = r.CheckBreak()
	}
	if yyb874 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CacheTTL = pkg1_unversioned.Duration{}
	} else {
		yyv876 := &x.CacheTTL
		yym877 := z.DecBinary()
		_ = yym877
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv876) {
		} else if !yym877 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv876)
		} else {
			z.DecFallback(yyv876, false)
		}
	}
	for {
		yyj874++
		if yyhl874 {
			yyb874 = yyj874 > l
		} else {
			yyb874 = r.CheckBreak()
		}
		if yyb874 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj874-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *KubeletAnonymousAuthentication) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym878 := z.EncBinary()
		_ = yym878
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep879 := !z.EncBinary()
			yy2arr879 := z.EncBasicHandle().StructToArray
			var yyq879 [1]bool
			_, _, _ = yysep879, yyq879, yy2arr879
			const yyr879 bool = false
			var yynn879 int
			if yyr879 || yy2arr879 {
				r.EncodeArrayStart(1)
			} else {
				yynn879 = 1
				for _, b := range yyq879 {
					if b {
						yynn879++
					}
				}
				r.EncodeMapStart(yynn879)
				yynn879 = 0
			}
			if yyr879 || yy2arr879 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym881 := z.EncBinary()
				_ = yym881
				if false {
				} else {
					r.EncodeBool(bool(x.Enabled))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enabled"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym882 := z.EncBinary()
				_ = yym882
				if false {
				} else {
					r.EncodeBool(bool(x.Enabled))
				}
			}
			if yyr879 || yy2arr879 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeletAnonymousAuthentication) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym883 := z.DecBinary()
	_ = yym883
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct884 := r.ContainerType()
		if yyct884 == codecSelferValueTypeMap1234 {
			yyl884 := r.ReadMapStart()
			if yyl884 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl884, d)
			}
		} else if yyct884 == codecSelferValueTypeArray1234 {
			yyl884 := r.ReadArrayStart()
			if yyl884 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl884, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeletAnonymousAuthentication) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys885Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys885Slc
	var yyhl885 bool = l >= 0
	for yyj885 := 0; ; yyj885++ {
		if yyhl885 {
			if yyj885 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys885Slc = r.DecodeBytes(yys885Slc, true, true)
		yys885 := string(yys885Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys885 {
		case "enabled":
			if r.TryDecodeAsNil() {
				x.Enabled = false
			} else {
				x.Enabled = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys885)
		} // end switch yys885
	} // end for yyj885
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeletAnonymousAuthentication) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj887 int
	var yyb887 bool
	var yyhl887 bool = l >= 0
	yyj887++
	if yyhl887 {
		yyb887 = yyj887 > l
	} else {
		yyb887 = r.CheckBreak()
	}
	if yyb887 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Enabled = false
	} else {
		x.Enabled = bool(r.DecodeBool())
	}
	for {
		yyj887++
		if yyhl887 {
			yyb887 = yyj887 > l
		} else {
			yyb887 = r.CheckBreak()
		}
		if yyb887 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj887-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *KubeSchedulerConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym889 := z.EncBinary()
		_ = yym889
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep890 := !z.EncBinary()
			yy2arr890 := z.EncBasicHandle().StructToArray
			var yyq890 [14]bool
			_, _, _ = yysep890, yyq890, yy2arr890
			const yyr890 bool = false
			yyq890[0] = x.Kind != ""
			yyq890[1] = x.APIVersion != ""
			var yynn890 int
			if yyr890 || yy2arr890 {
				r.EncodeArrayStart(14)
			} else {
				yynn890 = 12
				for _, b := range yyq890 {
					if b {
						yynn890++
					}
				}
				r.EncodeMapStart(yynn890)
				yynn890 = 0
			}
			if yyr890 || yy2arr890 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq890[0] {
					yym892 := z.EncBinary()
					_ = yym892
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq890[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym893 := z.EncBinary()
					_ = yym893
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr890 || yy2arr890 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq890[1] {
					yym895 := z.EncBinary()
					_ = yym895
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq890[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym896 := z.EncBinary()
					_ = yym896
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr890 || yy2arr890 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym898 := z.EncBinary()
				_ = yym898
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym899 := z.EncBinary()
				_ = yym899
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr890 || yy2arr890 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym901 := z.EncBinary()
				_ = yym901
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("address"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym902 := z.EncBinary()
				_ = yym902
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			}
			if yyr890 || yy2arr890 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym904 := z.EncBinary()
				_ = yym904
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.AlgorithmProvider))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("algorithmProvider"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym905 := z.EncBinary()
				_ = yym905
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.AlgorithmProvider))
				}
			}
			if yyr890 || yy2arr890 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym907 := z.EncBinary()
				_ = yym907
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PolicyConfigFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("policyConfigFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym908 := z.EncBinary()
				_ = yym908
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PolicyConfigFile))
				}
			}
			if yyr890 || yy2arr890 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym910 := z.EncBinary()
				_ = yym910
				if false {
				} else {
					r.EncodeBool(bool(x.EnableProfiling))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableProfiling"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym911 := z.EncBinary()
				_ = yym911
				if false {
				} else {
					r.EncodeBool(bool(x.EnableProfiling))
				}
			}
			if yyr890 || yy2arr890 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym913 := z.EncBinary()
				_ = yym913
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("contentType"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym914 := z.EncBinary()
				_ = yym914
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			}
			if yyr890 || yy2arr890 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym916 := z.EncBinary()
				_ = yym916
				if false {
				} else {
					r.EncodeFloat32(float32(x.KubeAPIQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym917 := z.EncBinary()
				_ = yym917
				if false {
				} else {
					r.EncodeFloat32(float32(x.KubeAPIQPS))
				}
			}
			if yyr890 || yy2arr890 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym919 := z.EncBinary()
				_ = yym919
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym920 := z.EncBinary()
				_ = yym920
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			}
			if yyr890 || yy2arr890 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym922 := z.EncBinary()
				_ = yym922
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SchedulerName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("schedulerName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym923 := z.EncBinary()
				_ = yym923
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SchedulerName))
				}
			}
			if yyr890 || yy2arr890 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym925 := z.EncBinary()
				_ = yym925
				if false {
				} else {
					r.EncodeInt(int64(x.HardPodAffinitySymmetricWeight))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hardPodAffinitySymmetricWeight"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym926 := z.EncBinary()
				_ = yym926
				if false {
				} else {
					r.EncodeInt(int64(x.HardPodAffinitySymmetricWeight))
				}
			}
			if yyr890 || yy2arr890 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym928 := z.EncBinary()
				_ = yym928
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FailureDomains))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("failureDomains"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym929 := z.EncBinary()
				_ = yym929
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FailureDomains))
				}
			}
			if yyr890 || yy2arr890 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy931 := &x.LeaderElection
				yy931.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("leaderElection"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy932 := &x.LeaderElection
				yy932.CodecEncodeSelf(e)
			}
			if yyr890 || yy2arr890 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeSchedulerConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym933 := z.DecBinary()
	_ = yym933
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct934 := r.ContainerType()
		if yyct934 == codecSelferValueTypeMap1234 {
			yyl934 := r.ReadMapStart()
			if yyl934 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl934, d)
			}
		} else if yyct934 == codecSelferValueTypeArray1234 {
			yyl934 := r.ReadArrayStart()
			if yyl934 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl934, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeSchedulerConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys935Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys935Slc
	var yyhl935 bool = l >= 0
	for yyj935 := 0; ; yyj935++ {
		if yyhl935 {
			if yyj935 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys935Slc = r.DecodeBytes(yys935Slc, true, true)
		yys935 := string(yys935Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys935 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int32(r.DecodeInt(32))
			}
		case "address":
			if r.TryDecodeAsNil() {
				x.Address = ""
			} else {
				x.Address = string(r.DecodeString())
			}
		case "algorithmProvider":
			if r.TryDecodeAsNil() {
				x.AlgorithmProvider = ""
			} else {
				x.AlgorithmProvider = string(r.DecodeString())
			}
		case "policyConfigFile":
			if r.TryDecodeAsNil() {
				x.PolicyConfigFile = ""
			} else {
				x.PolicyConfigFile = string(r.DecodeString())
			}
		case "enableProfiling":
			if r.TryDecodeAsNil() {
				x.EnableProfiling = false
			} else {
				x.EnableProfiling = bool(r.DecodeBool())
			}
		case "contentType":
			if r.TryDecodeAsNil() {
				x.ContentType = ""
			} else {
				x.ContentType = string(r.DecodeString())
			}
		case "kubeAPIQPS":
			if r.TryDecodeAsNil() {
				x.KubeAPIQPS = 0
			} else {
				x.KubeAPIQPS = float32(r.DecodeFloat(true))
			}
		case "kubeAPIBurst":
			if r.TryDecodeAsNil() {
				x.KubeAPIBurst = 0
			} else {
				x.KubeAPIBurst = int32(r.DecodeInt(32))
			}
		case "schedulerName":
			if r.TryDecodeAsNil() {
				x.SchedulerName = ""
			} else {
				x.SchedulerName = string(r.DecodeString())
			}
		case "hardPodAffinitySymmetricWeight":
			if r.TryDecodeAsNil() {
				x.HardPodAffinitySymmetricWeight = 0
			} else {
				x.HardPodAffinitySymmetricWeight = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "failureDomains":
			if r.TryDecodeAsNil() {
				x.FailureDomains = ""
			} else {
				x.FailureDomains = string(r.DecodeString())
			}
		case "leaderElection":
			if r.TryDecodeAsNil() {
				x.LeaderElection = LeaderElectionConfiguration{}
			} else {
				yyv949 := &x.LeaderElection
				yyv949.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys935)
		} // end switch yys935
	} // end for yyj935
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeSchedulerConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj950 int
	var yyb950 bool
	var yyhl950 bool = l >= 0
	yyj950++
	if yyhl950 {
		yyb950 = yyj950 > l
	} else {
		yyb950 = r.CheckBreak()
	}
	if yyb950 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj950++
	if yyhl950 {
		yyb950 = yyj950 > l
	} else {
		yyb950 = r.CheckBreak()
	}
	if yyb950 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj950++
	if yyhl950 {
		yyb950 = yyj950 > l
	} else {
		yyb950 = r.CheckBreak()
	}
	if yyb950 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int32(r.DecodeInt(32))
	}
	yyj950++
	if yyhl950 {
		yyb950 = yyj950 > l
	} else {
		yyb950 = r.CheckBreak()
	}
	if yyb950 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Address = ""
	} else {
		x.Address = string(r.DecodeString())
	}
	yyj950++
	if yyhl950 {
		yyb950 = yyj950 > l
	} else {
		yyb950 = r.CheckBreak()
	}
	if yyb950 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AlgorithmProvider = ""
	} else {
		x.AlgorithmProvider = string(r.DecodeString())
	}
	yyj950++
	if yyhl950 {
		yyb950 = yyj950 > l
	} else {
		yyb950 = r.CheckBreak()
	}
	if yyb950 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PolicyConfigFile = ""
	} else {
		x.PolicyConfigFile = string(r.DecodeString())
	}
	yyj950++
	if yyhl950 {
		yyb950 = yyj950 > l
	} else {
		yyb950 = r.CheckBreak()
	}
	if yyb950 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableProfiling = false
	} else {
		x.EnableProfiling = bool(r.DecodeBool())
	}
	yyj950++
	if yyhl950 {
		yyb950 = yyj950 > l
	} else {
		yyb950 = r.CheckBreak()
	}
	if yyb950 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContentType = ""
	} else {
		x.ContentType = string(r.DecodeString())
	}
	yyj950++
	if yyhl950 {
		yyb950 = yyj950 > l
	} else {
		yyb950 = r.CheckBreak()
	}
	if yyb950 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIQPS = 0
	} else {
		x.KubeAPIQPS = float32(r.DecodeFloat(true))
	}
	yyj950++
	if yyhl950 {
		yyb950 = yyj950 > l
	} else {
		yyb950 = r.CheckBreak()
	}
	if yyb950 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIBurst = 0
	} else {
		x.KubeAPIBurst = int32(r.DecodeInt(32))
	}
	yyj950++
	if yyhl950 {
		yyb950 = yyj950 > l
	} else {
		yyb950 = r.CheckBreak()
	}
	if yyb950 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SchedulerName = ""
	} else {
		x.SchedulerName = string(r.DecodeString())
	}
	yyj950++
	if yyhl950 {
		yyb950 = yyj950 > l
	} else {
		yyb950 = r.CheckBreak()
	}
	if yyb950 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HardPodAffinitySymmetricWeight = 0
	} else {
		x.HardPodAffinitySymmetricWeight = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj950++
	if yyhl950 {
		yyb950 = yyj950 > l
	} else {
		yyb950 = r.CheckBreak()
	}
	if yyb950 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FailureDomains = ""
	} else {
		x.FailureDomains = string(r.DecodeString())
	}
	yyj950++
	if yyhl950 {
		yyb950 = yyj950 > l
	} else {
		yyb950 = r.CheckBreak()
	}
	if yyb950 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LeaderElection = LeaderElectionConfiguration{}
	} else {
		yyv964 := &x.LeaderElection
		yyv964.CodecDecodeSelf(d)
	}
	for {
		yyj950++
		if yyhl950 {
			yyb950 = yyj950 > l
		} else {
			yyb950 = r.CheckBreak()
		}
		if yyb950 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj950-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LeaderElectionConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym965 := z.EncBinary()
		_ = yym965
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep966 := !z.EncBinary()
			yy2arr966 := z.EncBasicHandle().StructToArray
			var yyq966 [4]bool
			_, _, _ = yysep966, yyq966, yy2arr966
			const yyr966 bool = false
			var yynn966 int
			if yyr966 || yy2arr966 {
				r.EncodeArrayStart(4)
			} else {
				yynn966 = 4
				for _, b := range yyq966 {
					if b {
						yynn966++
					}
				}
				r.EncodeMapStart(yynn966)
				yynn966 = 0
			}
			if yyr966 || yy2arr966 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym968 := z.EncBinary()
				_ = yym968
				if false {
				} else {
					r.EncodeBool(bool(x.LeaderElect))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("leaderElect"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym969 := z.EncBinary()
				_ = yym969
				if false {
				} else {
					r.EncodeBool(bool(x.LeaderElect))
				}
			}
			if yyr966 || yy2arr966 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy971 := &x.LeaseDuration
				yym972 := z.EncBinary()
				_ = yym972
				if false {
				} else if z.HasExtensions() && z.EncExt(yy971) {
				} else if !yym972 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy971)
				} else {
					z.EncFallback(yy971)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("leaseDuration"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy973 := &x.LeaseDuration
				yym974 := z.EncBinary()
				_ = yym974
				if false {
				} else if z.HasExtensions() && z.EncExt(yy973) {
				} else if !yym974 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy973)
				} else {
					z.EncFallback(yy973)
				}
			}
			if yyr966 || yy2arr966 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy976 := &x.RenewDeadline
				yym977 := z.EncBinary()
				_ = yym977
				if false {
				} else if z.HasExtensions() && z.EncExt(yy976) {
				} else if !yym977 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy976)
				} else {
					z.EncFallback(yy976)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("renewDeadline"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy978 := &x.RenewDeadline
				yym979 := z.EncBinary()
				_ = yym979
				if false {
				} else if z.HasExtensions() && z.EncExt(yy978) {
				} else if !yym979 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy978)
				} else {
					z.EncFallback(yy978)
				}
			}
			if yyr966 || yy2arr966 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy981 := &x.RetryPeriod
				yym982 := z.EncBinary()
				_ = yym982
				if false {
				} else if z.HasExtensions() && z.EncExt(yy981) {
				} else if !yym982 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy981)
				} else {
					z.EncFallback(yy981)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("retryPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy983 := &x.RetryPeriod
				yym984 := z.EncBinary()
				_ = yym984
				if false {
				} else if z.HasExtensions() && z.EncExt(yy983) {
				} else if !yym984 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy983)
				} else {
					z.EncFallback(yy983)
				}
			}
			if yyr966 || yy2arr966 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LeaderElectionConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym985 := z.DecBinary()
	_ = yym985
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct986 := r.ContainerType()
		if yyct986 == codecSelferValueTypeMap1234 {
			yyl986 := r.ReadMapStart()
			if yyl986 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl986, d)
			}
		} else if yyct986 == codecSelferValueTypeArray1234 {
			yyl986 := r.ReadArrayStart()
			if yyl986 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl986, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LeaderElectionConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys987Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys987Slc
	var yyhl987 bool = l >= 0
	for yyj987 := 0; ; yyj987++ {
		if yyhl987 {
			if yyj987 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys987Slc = r.DecodeBytes(yys987Slc, true, true)
		yys987 := string(yys987Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys987 {
		case "leaderElect":
			if r.TryDecodeAsNil() {
				x.LeaderElect = false
			} else {
				x.LeaderElect = bool(r.DecodeBool())
			}
		case "leaseDuration":
			if r.TryDecodeAsNil() {
				x.LeaseDuration = pkg1_unversioned.Duration{}
			} else {
				yyv989 := &x.LeaseDuration
				yym990 := z.DecBinary()
				_ = yym990
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv989) {
				} else if !yym990 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv989)
				} else {
					z.DecFallback(yyv989, false)
				}
			}
		case "renewDeadline":
			if r.TryDecodeAsNil() {
				x.RenewDeadline = pkg1_unversioned.Duration{}
			} else {
				yyv991 := &x.RenewDeadline
				yym992 := z.DecBinary()
				_ = yym992
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv991) {
				} else if !yym992 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv991)
				} else {
					z.DecFallback(yyv991, false)
				}
			}
		case "retryPeriod":
			if r.TryDecodeAsNil() {
				x.RetryPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv993 := &x.RetryPeriod
				yym994 := z.DecBinary()
				_ = yym994
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv993) {
				} else if !yym994 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv993)
				} else {
					z.DecFallback(yyv993, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys987)
		} // end switch yys987
	} // end for yyj987
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LeaderElectionConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj995 int
	var yyb995 bool
	var yyhl995 bool = l >= 0
	yyj995++
	if yyhl995 {
		yyb995 = yyj995 > l
	} else {
		yyb995 = r.CheckBreak()
	}
	if yyb995 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LeaderElect = false
	} else {
		x.LeaderElect = bool(r.DecodeBool())
	}
	yyj995++
	if yyhl995 {
		yyb995 = yyj995 > l
	} else {
		yyb995 = r.CheckBreak()
	}
	if yyb995 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LeaseDuration = pkg1_unversioned.Duration{}
	} else {
		yyv997 := &x.LeaseDuration
		yym998 := z.DecBinary()
		_ = yym998
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv997) {
		} else if !yym998 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv997)
		} else {
			z.DecFallback(yyv997, false)
		}
	}
	yyj995++
	if yyhl995 {
		yyb995 = yyj995 > l
	} else {
		yyb995 = r.CheckBreak()
	}
	if yyb995 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RenewDeadline = pkg1_unversioned.Duration{}
	} else {
		yyv999 := &x.RenewDeadline
		yym1000 := z.DecBinary()
		_ = yym1000
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv999) {
		} else if !yym1000 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv999)
		} else {
			z.DecFallback(yyv999, false)
		}
	}
	yyj995++
	if yyhl995 {
		yyb995 = yyj995 > l
	} else {
		yyb995 = r.CheckBreak()
	}
	if yyb995 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RetryPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1001 := &x.RetryPeriod
		yym1002 := z.DecBinary()
		_ = yym1002
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1001) {
		} else if !yym1002 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1001)
		} else {
			z.DecFallback(yyv1001, false)
		}
	}
	for {
		yyj995++
		if yyhl995 {
			yyb995 = yyj995 > l
		} else {
			yyb995 = r.CheckBreak()
		}
		if yyb995 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj995-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *KubeControllerManagerConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1003 := z.EncBinary()
		_ = yym1003
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1004 := !z.EncBinary()
			yy2arr1004 := z.EncBasicHandle().StructToArray
			var yyq1004 [63]bool
			_, _, _ = yysep1004, yyq1004, yy2arr1004
			const yyr1004 bool = false
			yyq1004[0] = x.Kind != ""
			yyq1004[1] = x.APIVersion != ""
			var yynn1004 int
			if yyr1004 || yy2arr1004 {
				r.EncodeArrayStart(63)
			} else {
				yynn1004 = 61
				for _, b := range yyq1004 {
					if b {
						yynn1004++
					}
				}
				r.EncodeMapStart(yynn1004)
				yynn1004 = 0
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1004[0] {
					yym1006 := z.EncBinary()
					_ = yym1006
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1004[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1007 := z.EncBinary()
					_ = yym1007
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1004[1] {
					yym1009 := z.EncBinary()
					_ = yym1009
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1004[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1010 := z.EncBinary()
					_ = yym1010
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1012 := z.EncBinary()
				_ = yym1012
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1013 := z.EncBinary()
				_ = yym1013
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1015 := z.EncBinary()
				_ = yym1015
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("address"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1016 := z.EncBinary()
				_ = yym1016
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1018 := z.EncBinary()
				_ = yym1018
				if false {
				} else {
					r.EncodeBool(bool(x.UseServiceAccountCredentials))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("useServiceAccountCredentials"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1019 := z.EncBinary()
				_ = yym1019
				if false {
				} else {
					r.EncodeBool(bool(x.UseServiceAccountCredentials))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1021 := z.EncBinary()
				_ = yym1021
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CloudProvider))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cloudProvider"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1022 := z.EncBinary()
				_ = yym1022
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CloudProvider))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1024 := z.EncBinary()
				_ = yym1024
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CloudConfigFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cloudConfigFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1025 := z.EncBinary()
				_ = yym1025
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CloudConfigFile))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1027 := z.EncBinary()
				_ = yym1027
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentEndpointSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentEndpointSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1028 := z.EncBinary()
				_ = yym1028
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentEndpointSyncs))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1030 := z.EncBinary()
				_ = yym1030
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentRSSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentRSSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1031 := z.EncBinary()
				_ = yym1031
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentRSSyncs))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1033 := z.EncBinary()
				_ = yym1033
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentRCSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentRCSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1034 := z.EncBinary()
				_ = yym1034
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentRCSyncs))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1036 := z.EncBinary()
				_ = yym1036
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentServiceSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentServiceSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1037 := z.EncBinary()
				_ = yym1037
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentServiceSyncs))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1039 := z.EncBinary()
				_ = yym1039
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentResourceQuotaSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentResourceQuotaSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1040 := z.EncBinary()
				_ = yym1040
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentResourceQuotaSyncs))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1042 := z.EncBinary()
				_ = yym1042
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentDeploymentSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentDeploymentSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1043 := z.EncBinary()
				_ = yym1043
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentDeploymentSyncs))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1045 := z.EncBinary()
				_ = yym1045
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentDaemonSetSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentDaemonSetSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1046 := z.EncBinary()
				_ = yym1046
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentDaemonSetSyncs))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1048 := z.EncBinary()
				_ = yym1048
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentJobSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentJobSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1049 := z.EncBinary()
				_ = yym1049
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentJobSyncs))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1051 := z.EncBinary()
				_ = yym1051
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentNamespaceSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentNamespaceSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1052 := z.EncBinary()
				_ = yym1052
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentNamespaceSyncs))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1054 := z.EncBinary()
				_ = yym1054
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentSATokenSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentSATokenSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1055 := z.EncBinary()
				_ = yym1055
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentSATokenSyncs))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1057 := z.EncBinary()
				_ = yym1057
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForRC))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lookupCacheSizeForRC"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1058 := z.EncBinary()
				_ = yym1058
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForRC))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1060 := z.EncBinary()
				_ = yym1060
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForRS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lookupCacheSizeForRS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1061 := z.EncBinary()
				_ = yym1061
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForRS))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1063 := z.EncBinary()
				_ = yym1063
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForDaemonSet))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lookupCacheSizeForDaemonSet"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1064 := z.EncBinary()
				_ = yym1064
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForDaemonSet))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1066 := &x.ServiceSyncPeriod
				yym1067 := z.EncBinary()
				_ = yym1067
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1066) {
				} else if !yym1067 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1066)
				} else {
					z.EncFallback(yy1066)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serviceSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1068 := &x.ServiceSyncPeriod
				yym1069 := z.EncBinary()
				_ = yym1069
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1068) {
				} else if !yym1069 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1068)
				} else {
					z.EncFallback(yy1068)
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1071 := &x.NodeSyncPeriod
				yym1072 := z.EncBinary()
				_ = yym1072
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1071) {
				} else if !yym1072 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1071)
				} else {
					z.EncFallback(yy1071)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1073 := &x.NodeSyncPeriod
				yym1074 := z.EncBinary()
				_ = yym1074
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1073) {
				} else if !yym1074 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1073)
				} else {
					z.EncFallback(yy1073)
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1076 := &x.RouteReconciliationPeriod
				yym1077 := z.EncBinary()
				_ = yym1077
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1076) {
				} else if !yym1077 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1076)
				} else {
					z.EncFallback(yy1076)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("routeReconciliationPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1078 := &x.RouteReconciliationPeriod
				yym1079 := z.EncBinary()
				_ = yym1079
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1078) {
				} else if !yym1079 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1078)
				} else {
					z.EncFallback(yy1078)
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1081 := &x.ResourceQuotaSyncPeriod
				yym1082 := z.EncBinary()
				_ = yym1082
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1081) {
				} else if !yym1082 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1081)
				} else {
					z.EncFallback(yy1081)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("resourceQuotaSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1083 := &x.ResourceQuotaSyncPeriod
				yym1084 := z.EncBinary()
				_ = yym1084
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1083) {
				} else if !yym1084 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1083)
				} else {
					z.EncFallback(yy1083)
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1086 := &x.NamespaceSyncPeriod
				yym1087 := z.EncBinary()
				_ = yym1087
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1086) {
				} else if !yym1087 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1086)
				} else {
					z.EncFallback(yy1086)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("namespaceSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1088 := &x.NamespaceSyncPeriod
				yym1089 := z.EncBinary()
				_ = yym1089
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1088) {
				} else if !yym1089 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1088)
				} else {
					z.EncFallback(yy1088)
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1091 := &x.PVClaimBinderSyncPeriod
				yym1092 := z.EncBinary()
				_ = yym1092
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1091) {
				} else if !yym1092 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1091)
				} else {
					z.EncFallback(yy1091)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("pvClaimBinderSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1093 := &x.PVClaimBinderSyncPeriod
				yym1094 := z.EncBinary()
				_ = yym1094
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1093) {
				} else if !yym1094 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1093)
				} else {
					z.EncFallback(yy1093)
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1096 := &x.MinResyncPeriod
				yym1097 := z.EncBinary()
				_ = yym1097
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1096) {
				} else if !yym1097 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1096)
				} else {
					z.EncFallback(yy1096)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("minResyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1098 := &x.MinResyncPeriod
				yym1099 := z.EncBinary()
				_ = yym1099
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1098) {
				} else if !yym1099 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1098)
				} else {
					z.EncFallback(yy1098)
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1101 := z.EncBinary()
				_ = yym1101
				if false {
				} else {
					r.EncodeInt(int64(x.TerminatedPodGCThreshold))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("terminatedPodGCThreshold"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1102 := z.EncBinary()
				_ = yym1102
				if false {
				} else {
					r.EncodeInt(int64(x.TerminatedPodGCThreshold))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1104 := &x.HorizontalPodAutoscalerSyncPeriod
				yym1105 := z.EncBinary()
				_ = yym1105
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1104) {
				} else if !yym1105 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1104)
				} else {
					z.EncFallback(yy1104)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("horizontalPodAutoscalerSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1106 := &x.HorizontalPodAutoscalerSyncPeriod
				yym1107 := z.EncBinary()
				_ = yym1107
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1106) {
				} else if !yym1107 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1106)
				} else {
					z.EncFallback(yy1106)
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1109 := &x.DeploymentControllerSyncPeriod
				yym1110 := z.EncBinary()
				_ = yym1110
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1109) {
				} else if !yym1110 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1109)
				} else {
					z.EncFallback(yy1109)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("deploymentControllerSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1111 := &x.DeploymentControllerSyncPeriod
				yym1112 := z.EncBinary()
				_ = yym1112
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1111) {
				} else if !yym1112 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1111)
				} else {
					z.EncFallback(yy1111)
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1114 := &x.PodEvictionTimeout
				yym1115 := z.EncBinary()
				_ = yym1115
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1114) {
				} else if !yym1115 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1114)
				} else {
					z.EncFallback(yy1114)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podEvictionTimeout"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1116 := &x.PodEvictionTimeout
				yym1117 := z.EncBinary()
				_ = yym1117
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1116) {
				} else if !yym1117 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1116)
				} else {
					z.EncFallback(yy1116)
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1119 := z.EncBinary()
				_ = yym1119
				if false {
				} else {
					r.EncodeFloat32(float32(x.DeletingPodsQps))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("deletingPodsQps"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1120 := z.EncBinary()
				_ = yym1120
				if false {
				} else {
					r.EncodeFloat32(float32(x.DeletingPodsQps))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1122 := z.EncBinary()
				_ = yym1122
				if false {
				} else {
					r.EncodeInt(int64(x.DeletingPodsBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("deletingPodsBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1123 := z.EncBinary()
				_ = yym1123
				if false {
				} else {
					r.EncodeInt(int64(x.DeletingPodsBurst))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1125 := &x.NodeMonitorGracePeriod
				yym1126 := z.EncBinary()
				_ = yym1126
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1125) {
				} else if !yym1126 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1125)
				} else {
					z.EncFallback(yy1125)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeMonitorGracePeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1127 := &x.NodeMonitorGracePeriod
				yym1128 := z.EncBinary()
				_ = yym1128
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1127) {
				} else if !yym1128 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1127)
				} else {
					z.EncFallback(yy1127)
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1130 := z.EncBinary()
				_ = yym1130
				if false {
				} else {
					r.EncodeInt(int64(x.RegisterRetryCount))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registerRetryCount"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1131 := z.EncBinary()
				_ = yym1131
				if false {
				} else {
					r.EncodeInt(int64(x.RegisterRetryCount))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1133 := &x.NodeStartupGracePeriod
				yym1134 := z.EncBinary()
				_ = yym1134
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1133) {
				} else if !yym1134 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1133)
				} else {
					z.EncFallback(yy1133)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeStartupGracePeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1135 := &x.NodeStartupGracePeriod
				yym1136 := z.EncBinary()
				_ = yym1136
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1135) {
				} else if !yym1136 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1135)
				} else {
					z.EncFallback(yy1135)
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1138 := &x.NodeMonitorPeriod
				yym1139 := z.EncBinary()
				_ = yym1139
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1138) {
				} else if !yym1139 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1138)
				} else {
					z.EncFallback(yy1138)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeMonitorPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1140 := &x.NodeMonitorPeriod
				yym1141 := z.EncBinary()
				_ = yym1141
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1140) {
				} else if !yym1141 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1140)
				} else {
					z.EncFallback(yy1140)
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1143 := z.EncBinary()
				_ = yym1143
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceAccountKeyFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serviceAccountKeyFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1144 := z.EncBinary()
				_ = yym1144
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceAccountKeyFile))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1146 := z.EncBinary()
				_ = yym1146
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterSigningCertFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterSigningCertFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1147 := z.EncBinary()
				_ = yym1147
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterSigningCertFile))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1149 := z.EncBinary()
				_ = yym1149
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterSigningKeyFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterSigningKeyFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1150 := z.EncBinary()
				_ = yym1150
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterSigningKeyFile))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1152 := z.EncBinary()
				_ = yym1152
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ApproveAllKubeletCSRsForGroup))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("approveAllKubeletCSRsForGroup"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1153 := z.EncBinary()
				_ = yym1153
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ApproveAllKubeletCSRsForGroup))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1155 := z.EncBinary()
				_ = yym1155
				if false {
				} else {
					r.EncodeBool(bool(x.EnableProfiling))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableProfiling"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1156 := z.EncBinary()
				_ = yym1156
				if false {
				} else {
					r.EncodeBool(bool(x.EnableProfiling))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1158 := z.EncBinary()
				_ = yym1158
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1159 := z.EncBinary()
				_ = yym1159
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1161 := z.EncBinary()
				_ = yym1161
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1162 := z.EncBinary()
				_ = yym1162
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterCIDR))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1164 := z.EncBinary()
				_ = yym1164
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serviceCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1165 := z.EncBinary()
				_ = yym1165
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceCIDR))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1167 := z.EncBinary()
				_ = yym1167
				if false {
				} else {
					r.EncodeInt(int64(x.NodeCIDRMaskSize))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeCIDRMaskSize"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1168 := z.EncBinary()
				_ = yym1168
				if false {
				} else {
					r.EncodeInt(int64(x.NodeCIDRMaskSize))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1170 := z.EncBinary()
				_ = yym1170
				if false {
				} else {
					r.EncodeBool(bool(x.AllocateNodeCIDRs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("allocateNodeCIDRs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1171 := z.EncBinary()
				_ = yym1171
				if false {
				} else {
					r.EncodeBool(bool(x.AllocateNodeCIDRs))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1173 := z.EncBinary()
				_ = yym1173
				if false {
				} else {
					r.EncodeBool(bool(x.ConfigureCloudRoutes))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("configureCloudRoutes"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1174 := z.EncBinary()
				_ = yym1174
				if false {
				} else {
					r.EncodeBool(bool(x.ConfigureCloudRoutes))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1176 := z.EncBinary()
				_ = yym1176
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RootCAFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("rootCAFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1177 := z.EncBinary()
				_ = yym1177
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RootCAFile))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1179 := z.EncBinary()
				_ = yym1179
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("contentType"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1180 := z.EncBinary()
				_ = yym1180
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1182 := z.EncBinary()
				_ = yym1182
				if false {
				} else {
					r.EncodeFloat32(float32(x.KubeAPIQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1183 := z.EncBinary()
				_ = yym1183
				if false {
				} else {
					r.EncodeFloat32(float32(x.KubeAPIQPS))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1185 := z.EncBinary()
				_ = yym1185
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1186 := z.EncBinary()
				_ = yym1186
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1188 := &x.LeaderElection
				yy1188.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("leaderElection"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1189 := &x.LeaderElection
				yy1189.CodecEncodeSelf(e)
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1191 := &x.VolumeConfiguration
				yy1191.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumeConfiguration"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1192 := &x.VolumeConfiguration
				yy1192.CodecEncodeSelf(e)
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1194 := &x.ControllerStartInterval
				yym1195 := z.EncBinary()
				_ = yym1195
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1194) {
				} else if !yym1195 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1194)
				} else {
					z.EncFallback(yy1194)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("controllerStartInterval"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1196 := &x.ControllerStartInterval
				yym1197 := z.EncBinary()
				_ = yym1197
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1196) {
				} else if !yym1197 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1196)
				} else {
					z.EncFallback(yy1196)
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1199 := z.EncBinary()
				_ = yym1199
				if false {
				} else {
					r.EncodeBool(bool(x.EnableGarbageCollector))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableGarbageCollector"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1200 := z.EncBinary()
				_ = yym1200
				if false {
				} else {
					r.EncodeBool(bool(x.EnableGarbageCollector))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1202 := z.EncBinary()
				_ = yym1202
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentGCSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentGCSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1203 := z.EncBinary()
				_ = yym1203
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentGCSyncs))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1205 := z.EncBinary()
				_ = yym1205
				if false {
				} else {
					r.EncodeFloat32(float32(x.NodeEvictionRate))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeEvictionRate"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1206 := z.EncBinary()
				_ = yym1206
				if false {
				} else {
					r.EncodeFloat32(float32(x.NodeEvictionRate))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1208 := z.EncBinary()
				_ = yym1208
				if false {
				} else {
					r.EncodeFloat32(float32(x.SecondaryNodeEvictionRate))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("secondaryNodeEvictionRate"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1209 := z.EncBinary()
				_ = yym1209
				if false {
				} else {
					r.EncodeFloat32(float32(x.SecondaryNodeEvictionRate))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1211 := z.EncBinary()
				_ = yym1211
				if false {
				} else {
					r.EncodeInt(int64(x.LargeClusterSizeThreshold))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("largeClusterSizeThreshold"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1212 := z.EncBinary()
				_ = yym1212
				if false {
				} else {
					r.EncodeInt(int64(x.LargeClusterSizeThreshold))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1214 := z.EncBinary()
				_ = yym1214
				if false {
				} else {
					r.EncodeFloat32(float32(x.UnhealthyZoneThreshold))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("unhealthyZoneThreshold"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1215 := z.EncBinary()
				_ = yym1215
				if false {
				} else {
					r.EncodeFloat32(float32(x.UnhealthyZoneThreshold))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1217 := z.EncBinary()
				_ = yym1217
				if false {
				} else {
					r.EncodeBool(bool(x.DisableAttachDetachReconcilerSync))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("disableAttachDetachReconcilerSync"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1218 := z.EncBinary()
				_ = yym1218
				if false {
				} else {
					r.EncodeBool(bool(x.DisableAttachDetachReconcilerSync))
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1220 := &x.ReconcilerSyncLoopPeriod
				yym1221 := z.EncBinary()
				_ = yym1221
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1220) {
				} else if !yym1221 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1220)
				} else {
					z.EncFallback(yy1220)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("reconcilerSyncLoopPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1222 := &x.ReconcilerSyncLoopPeriod
				yym1223 := z.EncBinary()
				_ = yym1223
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1222) {
				} else if !yym1223 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1222)
				} else {
					z.EncFallback(yy1222)
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeControllerManagerConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1224 := z.DecBinary()
	_ = yym1224
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1225 := r.ContainerType()
		if yyct1225 == codecSelferValueTypeMap1234 {
			yyl1225 := r.ReadMapStart()
			if yyl1225 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1225, d)
			}
		} else if yyct1225 == codecSelferValueTypeArray1234 {
			yyl1225 := r.ReadArrayStart()
			if yyl1225 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1225, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeControllerManagerConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1226Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1226Slc
	var yyhl1226 bool = l >= 0
	for yyj1226 := 0; ; yyj1226++ {
		if yyhl1226 {
			if yyj1226 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1226Slc = r.DecodeBytes(yys1226Slc, true, true)
		yys1226 := string(yys1226Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1226 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int32(r.DecodeInt(32))
			}
		case "address":
			if r.TryDecodeAsNil() {
				x.Address = ""
			} else {
				x.Address = string(r.DecodeString())
			}
		case "useServiceAccountCredentials":
			if r.TryDecodeAsNil() {
				x.UseServiceAccountCredentials = false
			} else {
				x.UseServiceAccountCredentials = bool(r.DecodeBool())
			}
		case "cloudProvider":
			if r.TryDecodeAsNil() {
				x.CloudProvider = ""
			} else {
				x.CloudProvider = string(r.DecodeString())
			}
		case "cloudConfigFile":
			if r.TryDecodeAsNil() {
				x.CloudConfigFile = ""
			} else {
				x.CloudConfigFile = string(r.DecodeString())
			}
		case "concurrentEndpointSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentEndpointSyncs = 0
			} else {
				x.ConcurrentEndpointSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentRSSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentRSSyncs = 0
			} else {
				x.ConcurrentRSSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentRCSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentRCSyncs = 0
			} else {
				x.ConcurrentRCSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentServiceSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentServiceSyncs = 0
			} else {
				x.ConcurrentServiceSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentResourceQuotaSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentResourceQuotaSyncs = 0
			} else {
				x.ConcurrentResourceQuotaSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentDeploymentSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentDeploymentSyncs = 0
			} else {
				x.ConcurrentDeploymentSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentDaemonSetSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentDaemonSetSyncs = 0
			} else {
				x.ConcurrentDaemonSetSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentJobSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentJobSyncs = 0
			} else {
				x.ConcurrentJobSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentNamespaceSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentNamespaceSyncs = 0
			} else {
				x.ConcurrentNamespaceSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentSATokenSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentSATokenSyncs = 0
			} else {
				x.ConcurrentSATokenSyncs = int32(r.DecodeInt(32))
			}
		case "lookupCacheSizeForRC":
			if r.TryDecodeAsNil() {
				x.LookupCacheSizeForRC = 0
			} else {
				x.LookupCacheSizeForRC = int32(r.DecodeInt(32))
			}
		case "lookupCacheSizeForRS":
			if r.TryDecodeAsNil() {
				x.LookupCacheSizeForRS = 0
			} else {
				x.LookupCacheSizeForRS = int32(r.DecodeInt(32))
			}
		case "lookupCacheSizeForDaemonSet":
			if r.TryDecodeAsNil() {
				x.LookupCacheSizeForDaemonSet = 0
			} else {
				x.LookupCacheSizeForDaemonSet = int32(r.DecodeInt(32))
			}
		case "serviceSyncPeriod":
			if r.TryDecodeAsNil() {
				x.ServiceSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1247 := &x.ServiceSyncPeriod
				yym1248 := z.DecBinary()
				_ = yym1248
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1247) {
				} else if !yym1248 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1247)
				} else {
					z.DecFallback(yyv1247, false)
				}
			}
		case "nodeSyncPeriod":
			if r.TryDecodeAsNil() {
				x.NodeSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1249 := &x.NodeSyncPeriod
				yym1250 := z.DecBinary()
				_ = yym1250
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1249) {
				} else if !yym1250 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1249)
				} else {
					z.DecFallback(yyv1249, false)
				}
			}
		case "routeReconciliationPeriod":
			if r.TryDecodeAsNil() {
				x.RouteReconciliationPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1251 := &x.RouteReconciliationPeriod
				yym1252 := z.DecBinary()
				_ = yym1252
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1251) {
				} else if !yym1252 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1251)
				} else {
					z.DecFallback(yyv1251, false)
				}
			}
		case "resourceQuotaSyncPeriod":
			if r.TryDecodeAsNil() {
				x.ResourceQuotaSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1253 := &x.ResourceQuotaSyncPeriod
				yym1254 := z.DecBinary()
				_ = yym1254
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1253) {
				} else if !yym1254 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1253)
				} else {
					z.DecFallback(yyv1253, false)
				}
			}
		case "namespaceSyncPeriod":
			if r.TryDecodeAsNil() {
				x.NamespaceSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1255 := &x.NamespaceSyncPeriod
				yym1256 := z.DecBinary()
				_ = yym1256
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1255) {
				} else if !yym1256 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1255)
				} else {
					z.DecFallback(yyv1255, false)
				}
			}
		case "pvClaimBinderSyncPeriod":
			if r.TryDecodeAsNil() {
				x.PVClaimBinderSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1257 := &x.PVClaimBinderSyncPeriod
				yym1258 := z.DecBinary()
				_ = yym1258
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1257) {
				} else if !yym1258 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1257)
				} else {
					z.DecFallback(yyv1257, false)
				}
			}
		case "minResyncPeriod":
			if r.TryDecodeAsNil() {
				x.MinResyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1259 := &x.MinResyncPeriod
				yym1260 := z.DecBinary()
				_ = yym1260
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1259) {
				} else if !yym1260 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1259)
				} else {
					z.DecFallback(yyv1259, false)
				}
			}
		case "terminatedPodGCThreshold":
			if r.TryDecodeAsNil() {
				x.TerminatedPodGCThreshold = 0
			} else {
				x.TerminatedPodGCThreshold = int32(r.DecodeInt(32))
			}
		case "horizontalPodAutoscalerSyncPeriod":
			if r.TryDecodeAsNil() {
				x.HorizontalPodAutoscalerSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1262 := &x.HorizontalPodAutoscalerSyncPeriod
				yym1263 := z.DecBinary()
				_ = yym1263
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1262) {
				} else if !yym1263 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1262)
				} else {
					z.DecFallback(yyv1262, false)
				}
			}
		case "deploymentControllerSyncPeriod":
			if r.TryDecodeAsNil() {
				x.DeploymentControllerSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1264 := &x.DeploymentControllerSyncPeriod
				yym1265 := z.DecBinary()
				_ = yym1265
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1264) {
				} else if !yym1265 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1264)
				} else {
					z.DecFallback(yyv1264, false)
				}
			}
		case "podEvictionTimeout":
			if r.TryDecodeAsNil() {
				x.PodEvictionTimeout = pkg1_unversioned.Duration{}
			} else {
				yyv1266 := &x.PodEvictionTimeout
				yym1267 := z.DecBinary()
				_ = yym1267
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1266) {
				} else if !yym1267 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1266)
				} else {
					z.DecFallback(yyv1266, false)
				}
			}
		case "deletingPodsQps":
			if r.TryDecodeAsNil() {
				x.DeletingPodsQps = 0
			} else {
				x.DeletingPodsQps = float32(r.DecodeFloat(true))
			}
		case "deletingPodsBurst":
			if r.TryDecodeAsNil() {
				x.DeletingPodsBurst = 0
			} else {
				x.DeletingPodsBurst = int32(r.DecodeInt(32))
			}
		case "nodeMonitorGracePeriod":
			if r.TryDecodeAsNil() {
				x.NodeMonitorGracePeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1270 := &x.NodeMonitorGracePeriod
				yym1271 := z.DecBinary()
				_ = yym1271
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1270) {
				} else if !yym1271 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1270)
				} else {
					z.DecFallback(yyv1270, false)
				}
			}
		case "registerRetryCount":
			if r.TryDecodeAsNil() {
				x.RegisterRetryCount = 0
			} else {
				x.RegisterRetryCount = int32(r.DecodeInt(32))
			}
		case "nodeStartupGracePeriod":
			if r.TryDecodeAsNil() {
				x.NodeStartupGracePeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1273 := &x.NodeStartupGracePeriod
				yym1274 := z.DecBinary()
				_ = yym1274
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1273) {
				} else if !yym1274 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1273)
				} else {
					z.DecFallback(yyv1273, false)
				}
			}
		case "nodeMonitorPeriod":
			if r.TryDecodeAsNil() {
				x.NodeMonitorPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1275 := &x.NodeMonitorPeriod
				yym1276 := z.DecBinary()
				_ = yym1276
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1275) {
				} else if !yym1276 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1275)
				} else {
					z.DecFallback(yyv1275, false)
				}
			}
		case "serviceAccountKeyFile":
			if r.TryDecodeAsNil() {
				x.ServiceAccountKeyFile = ""
			} else {
				x.ServiceAccountKeyFile = string(r.DecodeString())
			}
		case "clusterSigningCertFile":
			if r.TryDecodeAsNil() {
				x.ClusterSigningCertFile = ""
			} else {
				x.ClusterSigningCertFile = string(r.DecodeString())
			}
		case "clusterSigningKeyFile":
			if r.TryDecodeAsNil() {
				x.ClusterSigningKeyFile = ""
			} else {
				x.ClusterSigningKeyFile = string(r.DecodeString())
			}
		case "approveAllKubeletCSRsForGroup":
			if r.TryDecodeAsNil() {
				x.ApproveAllKubeletCSRsForGroup = ""
			} else {
				x.ApproveAllKubeletCSRsForGroup = string(r.DecodeString())
			}
		case "enableProfiling":
			if r.TryDecodeAsNil() {
				x.EnableProfiling = false
			} else {
				x.EnableProfiling = bool(r.DecodeBool())
			}
		case "clusterName":
			if r.TryDecodeAsNil() {
				x.ClusterName = ""
			} else {
				x.ClusterName = string(r.DecodeString())
			}
		case "clusterCIDR":
			if r.TryDecodeAsNil() {
				x.ClusterCIDR = ""
			} else {
				x.ClusterCIDR = string(r.DecodeString())
			}
		case "serviceCIDR":
			if r.TryDecodeAsNil() {
				x.ServiceCIDR = ""
			} else {
				x.ServiceCIDR = string(r.DecodeString())
			}
		case "nodeCIDRMaskSize":
			if r.TryDecodeAsNil() {
				x.NodeCIDRMaskSize = 0
			} else {
				x.NodeCIDRMaskSize = int32(r.DecodeInt(32))
			}
		case "allocateNodeCIDRs":
			if r.TryDecodeAsNil() {
				x.AllocateNodeCIDRs = false
			} else {
				x.AllocateNodeCIDRs = bool(r.DecodeBool())
			}
		case "configureCloudRoutes":
			if r.TryDecodeAsNil() {
				x.ConfigureCloudRoutes = false
			} else {
				x.ConfigureCloudRoutes = bool(r.DecodeBool())
			}
		case "rootCAFile":
			if r.TryDecodeAsNil() {
				x.RootCAFile = ""
			} else {
				x.RootCAFile = string(r.DecodeString())
			}
		case "contentType":
			if r.TryDecodeAsNil() {
				x.ContentType = ""
			} else {
				x.ContentType = string(r.DecodeString())
			}
		case "kubeAPIQPS":
			if r.TryDecodeAsNil() {
				x.KubeAPIQPS = 0
			} else {
				x.KubeAPIQPS = float32(r.DecodeFloat(true))
			}
		case "kubeAPIBurst":
			if r.TryDecodeAsNil() {
				x.KubeAPIBurst = 0
			} else {
				x.KubeAPIBurst = int32(r.DecodeInt(32))
			}
		case "leaderElection":
			if r.TryDecodeAsNil() {
				x.LeaderElection = LeaderElectionConfiguration{}
			} else {
				yyv1292 := &x.LeaderElection
				yyv1292.CodecDecodeSelf(d)
			}
		case "volumeConfiguration":
			if r.TryDecodeAsNil() {
				x.VolumeConfiguration = VolumeConfiguration{}
			} else {
				yyv1293 := &x.VolumeConfiguration
				yyv1293.CodecDecodeSelf(d)
			}
		case "controllerStartInterval":
			if r.TryDecodeAsNil() {
				x.ControllerStartInterval = pkg1_unversioned.Duration{}
			} else {
				yyv1294 := &x.ControllerStartInterval
				yym1295 := z.DecBinary()
				_ = yym1295
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1294) {
				} else if !yym1295 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1294)
				} else {
					z.DecFallback(yyv1294, false)
				}
			}
		case "enableGarbageCollector":
			if r.TryDecodeAsNil() {
				x.EnableGarbageCollector = false
			} else {
				x.EnableGarbageCollector = bool(r.DecodeBool())
			}
		case "concurrentGCSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentGCSyncs = 0
			} else {
				x.ConcurrentGCSyncs = int32(r.DecodeInt(32))
			}
		case "nodeEvictionRate":
			if r.TryDecodeAsNil() {
				x.NodeEvictionRate = 0
			} else {
				x.NodeEvictionRate = float32(r.DecodeFloat(true))
			}
		case "secondaryNodeEvictionRate":
			if r.TryDecodeAsNil() {
				x.SecondaryNodeEvictionRate = 0
			} else {
				x.SecondaryNodeEvictionRate = float32(r.DecodeFloat(true))
			}
		case "largeClusterSizeThreshold":
			if r.TryDecodeAsNil() {
				x.LargeClusterSizeThreshold = 0
			} else {
				x.LargeClusterSizeThreshold = int32(r.DecodeInt(32))
			}
		case "unhealthyZoneThreshold":
			if r.TryDecodeAsNil() {
				x.UnhealthyZoneThreshold = 0
			} else {
				x.UnhealthyZoneThreshold = float32(r.DecodeFloat(true))
			}
		case "disableAttachDetachReconcilerSync":
			if r.TryDecodeAsNil() {
				x.DisableAttachDetachReconcilerSync = false
			} else {
				x.DisableAttachDetachReconcilerSync = bool(r.DecodeBool())
			}
		case "reconcilerSyncLoopPeriod":
			if r.TryDecodeAsNil() {
				x.ReconcilerSyncLoopPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1303 := &x.ReconcilerSyncLoopPeriod
				yym1304 := z.DecBinary()
				_ = yym1304
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1303) {
				} else if !yym1304 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1303)
				} else {
					z.DecFallback(yyv1303, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1226)
		} // end switch yys1226
	} // end for yyj1226
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeControllerManagerConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1305 int
	var yyb1305 bool
	var yyhl1305 bool = l >= 0
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int32(r.DecodeInt(32))
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Address = ""
	} else {
		x.Address = string(r.DecodeString())
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UseServiceAccountCredentials = false
	} else {
		x.UseServiceAccountCredentials = bool(r.DecodeBool())
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CloudProvider = ""
	} else {
		x.CloudProvider = string(r.DecodeString())
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CloudConfigFile = ""
	} else {
		x.CloudConfigFile = string(r.DecodeString())
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentEndpointSyncs = 0
	} else {
		x.ConcurrentEndpointSyncs = int32(r.DecodeInt(32))
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentRSSyncs = 0
	} else {
		x.ConcurrentRSSyncs = int32(r.DecodeInt(32))
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentRCSyncs = 0
	} else {
		x.ConcurrentRCSyncs = int32(r.DecodeInt(32))
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentServiceSyncs = 0
	} else {
		x.ConcurrentServiceSyncs = int32(r.DecodeInt(32))
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentResourceQuotaSyncs = 0
	} else {
		x.ConcurrentResourceQuotaSyncs = int32(r.DecodeInt(32))
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentDeploymentSyncs = 0
	} else {
		x.ConcurrentDeploymentSyncs = int32(r.DecodeInt(32))
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentDaemonSetSyncs = 0
	} else {
		x.ConcurrentDaemonSetSyncs = int32(r.DecodeInt(32))
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentJobSyncs = 0
	} else {
		x.ConcurrentJobSyncs = int32(r.DecodeInt(32))
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentNamespaceSyncs = 0
	} else {
		x.ConcurrentNamespaceSyncs = int32(r.DecodeInt(32))
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentSATokenSyncs = 0
	} else {
		x.ConcurrentSATokenSyncs = int32(r.DecodeInt(32))
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LookupCacheSizeForRC = 0
	} else {
		x.LookupCacheSizeForRC = int32(r.DecodeInt(32))
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LookupCacheSizeForRS = 0
	} else {
		x.LookupCacheSizeForRS = int32(r.DecodeInt(32))
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LookupCacheSizeForDaemonSet = 0
	} else {
		x.LookupCacheSizeForDaemonSet = int32(r.DecodeInt(32))
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServiceSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1326 := &x.ServiceSyncPeriod
		yym1327 := z.DecBinary()
		_ = yym1327
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1326) {
		} else if !yym1327 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1326)
		} else {
			z.DecFallback(yyv1326, false)
		}
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1328 := &x.NodeSyncPeriod
		yym1329 := z.DecBinary()
		_ = yym1329
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1328) {
		} else if !yym1329 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1328)
		} else {
			z.DecFallback(yyv1328, false)
		}
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RouteReconciliationPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1330 := &x.RouteReconciliationPeriod
		yym1331 := z.DecBinary()
		_ = yym1331
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1330) {
		} else if !yym1331 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1330)
		} else {
			z.DecFallback(yyv1330, false)
		}
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceQuotaSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1332 := &x.ResourceQuotaSyncPeriod
		yym1333 := z.DecBinary()
		_ = yym1333
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1332) {
		} else if !yym1333 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1332)
		} else {
			z.DecFallback(yyv1332, false)
		}
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NamespaceSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1334 := &x.NamespaceSyncPeriod
		yym1335 := z.DecBinary()
		_ = yym1335
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1334) {
		} else if !yym1335 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1334)
		} else {
			z.DecFallback(yyv1334, false)
		}
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PVClaimBinderSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1336 := &x.PVClaimBinderSyncPeriod
		yym1337 := z.DecBinary()
		_ = yym1337
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1336) {
		} else if !yym1337 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1336)
		} else {
			z.DecFallback(yyv1336, false)
		}
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinResyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1338 := &x.MinResyncPeriod
		yym1339 := z.DecBinary()
		_ = yym1339
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1338) {
		} else if !yym1339 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1338)
		} else {
			z.DecFallback(yyv1338, false)
		}
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TerminatedPodGCThreshold = 0
	} else {
		x.TerminatedPodGCThreshold = int32(r.DecodeInt(32))
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HorizontalPodAutoscalerSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1341 := &x.HorizontalPodAutoscalerSyncPeriod
		yym1342 := z.DecBinary()
		_ = yym1342
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1341) {
		} else if !yym1342 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1341)
		} else {
			z.DecFallback(yyv1341, false)
		}
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DeploymentControllerSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1343 := &x.DeploymentControllerSyncPeriod
		yym1344 := z.DecBinary()
		_ = yym1344
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1343) {
		} else if !yym1344 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1343)
		} else {
			z.DecFallback(yyv1343, false)
		}
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodEvictionTimeout = pkg1_unversioned.Duration{}
	} else {
		yyv1345 := &x.PodEvictionTimeout
		yym1346 := z.DecBinary()
		_ = yym1346
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1345) {
		} else if !yym1346 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1345)
		} else {
			z.DecFallback(yyv1345, false)
		}
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DeletingPodsQps = 0
	} else {
		x.DeletingPodsQps = float32(r.DecodeFloat(true))
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DeletingPodsBurst = 0
	} else {
		x.DeletingPodsBurst = int32(r.DecodeInt(32))
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeMonitorGracePeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1349 := &x.NodeMonitorGracePeriod
		yym1350 := z.DecBinary()
		_ = yym1350
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1349) {
		} else if !yym1350 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1349)
		} else {
			z.DecFallback(yyv1349, false)
		}
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegisterRetryCount = 0
	} else {
		x.RegisterRetryCount = int32(r.DecodeInt(32))
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeStartupGracePeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1352 := &x.NodeStartupGracePeriod
		yym1353 := z.DecBinary()
		_ = yym1353
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1352) {
		} else if !yym1353 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1352)
		} else {
			z.DecFallback(yyv1352, false)
		}
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeMonitorPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1354 := &x.NodeMonitorPeriod
		yym1355 := z.DecBinary()
		_ = yym1355
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1354) {
		} else if !yym1355 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1354)
		} else {
			z.DecFallback(yyv1354, false)
		}
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServiceAccountKeyFile = ""
	} else {
		x.ServiceAccountKeyFile = string(r.DecodeString())
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterSigningCertFile = ""
	} else {
		x.ClusterSigningCertFile = string(r.DecodeString())
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterSigningKeyFile = ""
	} else {
		x.ClusterSigningKeyFile = string(r.DecodeString())
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ApproveAllKubeletCSRsForGroup = ""
	} else {
		x.ApproveAllKubeletCSRsForGroup = string(r.DecodeString())
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableProfiling = false
	} else {
		x.EnableProfiling = bool(r.DecodeBool())
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterName = ""
	} else {
		x.ClusterName = string(r.DecodeString())
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterCIDR = ""
	} else {
		x.ClusterCIDR = string(r.DecodeString())
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServiceCIDR = ""
	} else {
		x.ServiceCIDR = string(r.DecodeString())
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeCIDRMaskSize = 0
	} else {
		x.NodeCIDRMaskSize = int32(r.DecodeInt(32))
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AllocateNodeCIDRs = false
	} else {
		x.AllocateNodeCIDRs = bool(r.DecodeBool())
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConfigureCloudRoutes = false
	} else {
		x.ConfigureCloudRoutes = bool(r.DecodeBool())
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RootCAFile = ""
	} else {
		x.RootCAFile = string(r.DecodeString())
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContentType = ""
	} else {
		x.ContentType = string(r.DecodeString())
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIQPS = 0
	} else {
		x.KubeAPIQPS = float32(r.DecodeFloat(true))
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIBurst = 0
	} else {
		x.KubeAPIBurst = int32(r.DecodeInt(32))
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LeaderElection = LeaderElectionConfiguration{}
	} else {
		yyv1371 := &x.LeaderElection
		yyv1371.CodecDecodeSelf(d)
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeConfiguration = VolumeConfiguration{}
	} else {
		yyv1372 := &x.VolumeConfiguration
		yyv1372.CodecDecodeSelf(d)
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ControllerStartInterval = pkg1_unversioned.Duration{}
	} else {
		yyv1373 := &x.ControllerStartInterval
		yym1374 := z.DecBinary()
		_ = yym1374
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1373) {
		} else if !yym1374 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1373)
		} else {
			z.DecFallback(yyv1373, false)
		}
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableGarbageCollector = false
	} else {
		x.EnableGarbageCollector = bool(r.DecodeBool())
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentGCSyncs = 0
	} else {
		x.ConcurrentGCSyncs = int32(r.DecodeInt(32))
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeEvictionRate = 0
	} else {
		x.NodeEvictionRate = float32(r.DecodeFloat(true))
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SecondaryNodeEvictionRate = 0
	} else {
		x.SecondaryNodeEvictionRate = float32(r.DecodeFloat(true))
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LargeClusterSizeThreshold = 0
	} else {
		x.LargeClusterSizeThreshold = int32(r.DecodeInt(32))
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UnhealthyZoneThreshold = 0
	} else {
		x.UnhealthyZoneThreshold = float32(r.DecodeFloat(true))
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DisableAttachDetachReconcilerSync = false
	} else {
		x.DisableAttachDetachReconcilerSync = bool(r.DecodeBool())
	}
	yyj1305++
	if yyhl1305 {
		yyb1305 = yyj1305 > l
	} else {
		yyb1305 = r.CheckBreak()
	}
	if yyb1305 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReconcilerSyncLoopPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1382 := &x.ReconcilerSyncLoopPeriod
		yym1383 := z.DecBinary()
		_ = yym1383
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1382) {
		} else if !yym1383 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1382)
		} else {
			z.DecFallback(yyv1382, false)
		}
	}
	for {
		yyj1305++
		if yyhl1305 {
			yyb1305 = yyj1305 > l
		} else {
			yyb1305 = r.CheckBreak()
		}
		if yyb1305 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1305-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *VolumeConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1384 := z.EncBinary()
		_ = yym1384
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1385 := !z.EncBinary()
			yy2arr1385 := z.EncBasicHandle().StructToArray
			var yyq1385 [4]bool
			_, _, _ = yysep1385, yyq1385, yy2arr1385
			const yyr1385 bool = false
			var yynn1385 int
			if yyr1385 || yy2arr1385 {
				r.EncodeArrayStart(4)
			} else {
				yynn1385 = 4
				for _, b := range yyq1385 {
					if b {
						yynn1385++
					}
				}
				r.EncodeMapStart(yynn1385)
				yynn1385 = 0
			}
			if yyr1385 || yy2arr1385 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1387 := z.EncBinary()
				_ = yym1387
				if false {
				} else {
					r.EncodeBool(bool(x.EnableHostPathProvisioning))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableHostPathProvisioning"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1388 := z.EncBinary()
				_ = yym1388
				if false {
				} else {
					r.EncodeBool(bool(x.EnableHostPathProvisioning))
				}
			}
			if yyr1385 || yy2arr1385 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1390 := z.EncBinary()
				_ = yym1390
				if false {
				} else {
					r.EncodeBool(bool(x.EnableDynamicProvisioning))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableDynamicProvisioning"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1391 := z.EncBinary()
				_ = yym1391
				if false {
				} else {
					r.EncodeBool(bool(x.EnableDynamicProvisioning))
				}
			}
			if yyr1385 || yy2arr1385 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1393 := &x.PersistentVolumeRecyclerConfiguration
				yy1393.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("persitentVolumeRecyclerConfiguration"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1394 := &x.PersistentVolumeRecyclerConfiguration
				yy1394.CodecEncodeSelf(e)
			}
			if yyr1385 || yy2arr1385 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1396 := z.EncBinary()
				_ = yym1396
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FlexVolumePluginDir))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("flexVolumePluginDir"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1397 := z.EncBinary()
				_ = yym1397
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FlexVolumePluginDir))
				}
			}
			if yyr1385 || yy2arr1385 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *VolumeConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1398 := z.DecBinary()
	_ = yym1398
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1399 := r.ContainerType()
		if yyct1399 == codecSelferValueTypeMap1234 {
			yyl1399 := r.ReadMapStart()
			if yyl1399 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1399, d)
			}
		} else if yyct1399 == codecSelferValueTypeArray1234 {
			yyl1399 := r.ReadArrayStart()
			if yyl1399 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1399, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *VolumeConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1400Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1400Slc
	var yyhl1400 bool = l >= 0
	for yyj1400 := 0; ; yyj1400++ {
		if yyhl1400 {
			if yyj1400 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1400Slc = r.DecodeBytes(yys1400Slc, true, true)
		yys1400 := string(yys1400Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1400 {
		case "enableHostPathProvisioning":
			if r.TryDecodeAsNil() {
				x.EnableHostPathProvisioning = false
			} else {
				x.EnableHostPathProvisioning = bool(r.DecodeBool())
			}
		case "enableDynamicProvisioning":
			if r.TryDecodeAsNil() {
				x.EnableDynamicProvisioning = false
			} else {
				x.EnableDynamicProvisioning = bool(r.DecodeBool())
			}
		case "persitentVolumeRecyclerConfiguration":
			if r.TryDecodeAsNil() {
				x.PersistentVolumeRecyclerConfiguration = PersistentVolumeRecyclerConfiguration{}
			} else {
				yyv1403 := &x.PersistentVolumeRecyclerConfiguration
				yyv1403.CodecDecodeSelf(d)
			}
		case "flexVolumePluginDir":
			if r.TryDecodeAsNil() {
				x.FlexVolumePluginDir = ""
			} else {
				x.FlexVolumePluginDir = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1400)
		} // end switch yys1400
	} // end for yyj1400
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *VolumeConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1405 int
	var yyb1405 bool
	var yyhl1405 bool = l >= 0
	yyj1405++
	if yyhl1405 {
		yyb1405 = yyj1405 > l
	} else {
		yyb1405 = r.CheckBreak()
	}
	if yyb1405 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableHostPathProvisioning = false
	} else {
		x.EnableHostPathProvisioning = bool(r.DecodeBool())
	}
	yyj1405++
	if yyhl1405 {
		yyb1405 = yyj1405 > l
	} else {
		yyb1405 = r.CheckBreak()
	}
	if yyb1405 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableDynamicProvisioning = false
	} else {
		x.EnableDynamicProvisioning = bool(r.DecodeBool())
	}
	yyj1405++
	if yyhl1405 {
		yyb1405 = yyj1405 > l
	} else {
		yyb1405 = r.CheckBreak()
	}
	if yyb1405 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PersistentVolumeRecyclerConfiguration = PersistentVolumeRecyclerConfiguration{}
	} else {
		yyv1408 := &x.PersistentVolumeRecyclerConfiguration
		yyv1408.CodecDecodeSelf(d)
	}
	yyj1405++
	if yyhl1405 {
		yyb1405 = yyj1405 > l
	} else {
		yyb1405 = r.CheckBreak()
	}
	if yyb1405 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FlexVolumePluginDir = ""
	} else {
		x.FlexVolumePluginDir = string(r.DecodeString())
	}
	for {
		yyj1405++
		if yyhl1405 {
			yyb1405 = yyj1405 > l
		} else {
			yyb1405 = r.CheckBreak()
		}
		if yyb1405 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1405-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeRecyclerConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1410 := z.EncBinary()
		_ = yym1410
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1411 := !z.EncBinary()
			yy2arr1411 := z.EncBasicHandle().StructToArray
			var yyq1411 [7]bool
			_, _, _ = yysep1411, yyq1411, yy2arr1411
			const yyr1411 bool = false
			var yynn1411 int
			if yyr1411 || yy2arr1411 {
				r.EncodeArrayStart(7)
			} else {
				yynn1411 = 7
				for _, b := range yyq1411 {
					if b {
						yynn1411++
					}
				}
				r.EncodeMapStart(yynn1411)
				yynn1411 = 0
			}
			if yyr1411 || yy2arr1411 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1413 := z.EncBinary()
				_ = yym1413
				if false {
				} else {
					r.EncodeInt(int64(x.MaximumRetry))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maximumRetry"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1414 := z.EncBinary()
				_ = yym1414
				if false {
				} else {
					r.EncodeInt(int64(x.MaximumRetry))
				}
			}
			if yyr1411 || yy2arr1411 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1416 := z.EncBinary()
				_ = yym1416
				if false {
				} else {
					r.EncodeInt(int64(x.MinimumTimeoutNFS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("minimumTimeoutNFS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1417 := z.EncBinary()
				_ = yym1417
				if false {
				} else {
					r.EncodeInt(int64(x.MinimumTimeoutNFS))
				}
			}
			if yyr1411 || yy2arr1411 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1419 := z.EncBinary()
				_ = yym1419
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodTemplateFilePathNFS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podTemplateFilePathNFS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1420 := z.EncBinary()
				_ = yym1420
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodTemplateFilePathNFS))
				}
			}
			if yyr1411 || yy2arr1411 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1422 := z.EncBinary()
				_ = yym1422
				if false {
				} else {
					r.EncodeInt(int64(x.IncrementTimeoutNFS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("incrementTimeoutNFS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1423 := z.EncBinary()
				_ = yym1423
				if false {
				} else {
					r.EncodeInt(int64(x.IncrementTimeoutNFS))
				}
			}
			if yyr1411 || yy2arr1411 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1425 := z.EncBinary()
				_ = yym1425
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodTemplateFilePathHostPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podTemplateFilePathHostPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1426 := z.EncBinary()
				_ = yym1426
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodTemplateFilePathHostPath))
				}
			}
			if yyr1411 || yy2arr1411 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1428 := z.EncBinary()
				_ = yym1428
				if false {
				} else {
					r.EncodeInt(int64(x.MinimumTimeoutHostPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("minimumTimeoutHostPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1429 := z.EncBinary()
				_ = yym1429
				if false {
				} else {
					r.EncodeInt(int64(x.MinimumTimeoutHostPath))
				}
			}
			if yyr1411 || yy2arr1411 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1431 := z.EncBinary()
				_ = yym1431
				if false {
				} else {
					r.EncodeInt(int64(x.IncrementTimeoutHostPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("incrementTimeoutHostPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1432 := z.EncBinary()
				_ = yym1432
				if false {
				} else {
					r.EncodeInt(int64(x.IncrementTimeoutHostPath))
				}
			}
			if yyr1411 || yy2arr1411 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeRecyclerConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1433 := z.DecBinary()
	_ = yym1433
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1434 := r.ContainerType()
		if yyct1434 == codecSelferValueTypeMap1234 {
			yyl1434 := r.ReadMapStart()
			if yyl1434 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1434, d)
			}
		} else if yyct1434 == codecSelferValueTypeArray1234 {
			yyl1434 := r.ReadArrayStart()
			if yyl1434 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1434, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeRecyclerConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1435Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1435Slc
	var yyhl1435 bool = l >= 0
	for yyj1435 := 0; ; yyj1435++ {
		if yyhl1435 {
			if yyj1435 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1435Slc = r.DecodeBytes(yys1435Slc, true, true)
		yys1435 := string(yys1435Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1435 {
		case "maximumRetry":
			if r.TryDecodeAsNil() {
				x.MaximumRetry = 0
			} else {
				x.MaximumRetry = int32(r.DecodeInt(32))
			}
		case "minimumTimeoutNFS":
			if r.TryDecodeAsNil() {
				x.MinimumTimeoutNFS = 0
			} else {
				x.MinimumTimeoutNFS = int32(r.DecodeInt(32))
			}
		case "podTemplateFilePathNFS":
			if r.TryDecodeAsNil() {
				x.PodTemplateFilePathNFS = ""
			} else {
				x.PodTemplateFilePathNFS = string(r.DecodeString())
			}
		case "incrementTimeoutNFS":
			if r.TryDecodeAsNil() {
				x.IncrementTimeoutNFS = 0
			} else {
				x.IncrementTimeoutNFS = int32(r.DecodeInt(32))
			}
		case "podTemplateFilePathHostPath":
			if r.TryDecodeAsNil() {
				x.PodTemplateFilePathHostPath = ""
			} else {
				x.PodTemplateFilePathHostPath = string(r.DecodeString())
			}
		case "minimumTimeoutHostPath":
			if r.TryDecodeAsNil() {
				x.MinimumTimeoutHostPath = 0
			} else {
				x.MinimumTimeoutHostPath = int32(r.DecodeInt(32))
			}
		case "incrementTimeoutHostPath":
			if r.TryDecodeAsNil() {
				x.IncrementTimeoutHostPath = 0
			} else {
				x.IncrementTimeoutHostPath = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys1435)
		} // end switch yys1435
	} // end for yyj1435
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeRecyclerConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1443 int
	var yyb1443 bool
	var yyhl1443 bool = l >= 0
	yyj1443++
	if yyhl1443 {
		yyb1443 = yyj1443 > l
	} else {
		yyb1443 = r.CheckBreak()
	}
	if yyb1443 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaximumRetry = 0
	} else {
		x.MaximumRetry = int32(r.DecodeInt(32))
	}
	yyj1443++
	if yyhl1443 {
		yyb1443 = yyj1443 > l
	} else {
		yyb1443 = r.CheckBreak()
	}
	if yyb1443 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinimumTimeoutNFS = 0
	} else {
		x.MinimumTimeoutNFS = int32(r.DecodeInt(32))
	}
	yyj1443++
	if yyhl1443 {
		yyb1443 = yyj1443 > l
	} else {
		yyb1443 = r.CheckBreak()
	}
	if yyb1443 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodTemplateFilePathNFS = ""
	} else {
		x.PodTemplateFilePathNFS = string(r.DecodeString())
	}
	yyj1443++
	if yyhl1443 {
		yyb1443 = yyj1443 > l
	} else {
		yyb1443 = r.CheckBreak()
	}
	if yyb1443 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IncrementTimeoutNFS = 0
	} else {
		x.IncrementTimeoutNFS = int32(r.DecodeInt(32))
	}
	yyj1443++
	if yyhl1443 {
		yyb1443 = yyj1443 > l
	} else {
		yyb1443 = r.CheckBreak()
	}
	if yyb1443 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodTemplateFilePathHostPath = ""
	} else {
		x.PodTemplateFilePathHostPath = string(r.DecodeString())
	}
	yyj1443++
	if yyhl1443 {
		yyb1443 = yyj1443 > l
	} else {
		yyb1443 = r.CheckBreak()
	}
	if yyb1443 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinimumTimeoutHostPath = 0
	} else {
		x.MinimumTimeoutHostPath = int32(r.DecodeInt(32))
	}
	yyj1443++
	if yyhl1443 {
		yyb1443 = yyj1443 > l
	} else {
		yyb1443 = r.CheckBreak()
	}
	if yyb1443 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IncrementTimeoutHostPath = 0
	} else {
		x.IncrementTimeoutHostPath = int32(r.DecodeInt(32))
	}
	for {
		yyj1443++
		if yyhl1443 {
			yyb1443 = yyj1443 > l
		} else {
			yyb1443 = r.CheckBreak()
		}
		if yyb1443 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1443-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) encconfig_ConfigurationMap(v pkg2_config.ConfigurationMap, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeMapStart(len(v))
	for yyk1451, yyv1451 := range v {
		z.EncSendContainerState(codecSelfer_containerMapKey1234)
		yym1452 := z.EncBinary()
		_ = yym1452
		if false {
		} else {
			r.EncodeString(codecSelferC_UTF81234, string(yyk1451))
		}
		z.EncSendContainerState(codecSelfer_containerMapValue1234)
		yym1453 := z.EncBinary()
		_ = yym1453
		if false {
		} else {
			r.EncodeString(codecSelferC_UTF81234, string(yyv1451))
		}
	}
	z.EncSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x codecSelfer1234) decconfig_ConfigurationMap(v *pkg2_config.ConfigurationMap, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1454 := *v
	yyl1454 := r.ReadMapStart()
	yybh1454 := z.DecBasicHandle()
	if yyv1454 == nil {
		yyrl1454, _ := z.DecInferLen(yyl1454, yybh1454.MaxInitLen, 32)
		yyv1454 = make(map[string]string, yyrl1454)
		*v = yyv1454
	}
	var yymk1454 string
	var yymv1454 string
	var yymg1454 bool
	if yybh1454.MapValueReset {
	}
	if yyl1454 > 0 {
		for yyj1454 := 0; yyj1454 < yyl1454; yyj1454++ {
			z.DecSendContainerState(codecSelfer_containerMapKey1234)
			if r.TryDecodeAsNil() {
				yymk1454 = ""
			} else {
				yymk1454 = string(r.DecodeString())
			}

			if yymg1454 {
				yymv1454 = yyv1454[yymk1454]
			}
			z.DecSendContainerState(codecSelfer_containerMapValue1234)
			if r.TryDecodeAsNil() {
				yymv1454 = ""
			} else {
				yymv1454 = string(r.DecodeString())
			}

			if yyv1454 != nil {
				yyv1454[yymk1454] = yymv1454
			}
		}
	} else if yyl1454 < 0 {
		for yyj1454 := 0; !r.CheckBreak(); yyj1454++ {
			z.DecSendContainerState(codecSelfer_containerMapKey1234)
			if r.TryDecodeAsNil() {
				yymk1454 = ""
			} else {
				yymk1454 = string(r.DecodeString())
			}

			if yymg1454 {
				yymv1454 = yyv1454[yymk1454]
			}
			z.DecSendContainerState(codecSelfer_containerMapValue1234)
			if r.TryDecodeAsNil() {
				yymv1454 = ""
			} else {
				yymv1454 = string(r.DecodeString())
			}

			if yyv1454 != nil {
				yyv1454[yymk1454] = yymv1454
			}
		}
	} // else len==0: TODO: Should we clear map entries?
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}
