/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics.spi;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class Util {
    private Util() {
    }

    public static List<InetSocketAddress> parse(String specs, int defaultPort) {
        ArrayList<InetSocketAddress> result = new ArrayList<InetSocketAddress>(1);
        if (specs == null) {
            result.add(new InetSocketAddress("localhost", defaultPort));
        } else {
            String[] specStrings;
            for (String specString : specStrings = specs.split("[ ,]+")) {
                int colon = specString.indexOf(58);
                if (colon < 0 || colon == specString.length() - 1) {
                    result.add(new InetSocketAddress(specString, defaultPort));
                    continue;
                }
                String hostname = specString.substring(0, colon);
                int port = Integer.parseInt(specString.substring(colon + 1));
                result.add(new InetSocketAddress(hostname, port));
            }
        }
        return result;
    }
}

