/*----------------------------------------------------------------------------
 *
 * File:
 * eas_fmtables.c
 *
 * Contents and purpose:
 * Contains lookup tables for the FM synthesizer
 *
 *
 * Copyright Sonic Network Inc. 2005

 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *----------------------------------------------------------------------------
 * Revision Control:
 *   $Revision: 82 $
 *   $Date: 2006-07-10 11:45:19 -0700 (Mon, 10 Jul 2006) $
 *
 *----------------------------------------------------------------------------
*/


#include "eas_types.h"

/* this table is needed by the DSP and the main processor */
const EAS_U8 fmScaleTable[16] =
{
    0,8,16,24,32,40,48,56,64,72,80,96,128,160,192,255
};

/* these tables are needed on the main processor */
#ifndef _DSP_CODE
const EAS_I16 fmControlTable[128] =
{
    -32768,-14313,-12265,-11067,-10217,-9558,-9019,-8563,
    -8169,-7821,-7510,-7228,-6971,-6734,-6515,-6312,
    -6121,-5942,-5773,-5613,-5462,-5317,-5180,-5049,
    -4923,-4802,-4686,-4575,-4467,-4364,-4264,-4167,
    -4073,-3982,-3894,-3808,-3725,-3644,-3565,-3488,
    -3414,-3341,-3269,-3200,-3132,-3066,-3001,-2937,
    -2875,-2814,-2754,-2696,-2638,-2582,-2527,-2473,
    -2419,-2367,-2316,-2265,-2216,-2167,-2119,-2071,
    -2025,-1979,-1934,-1889,-1846,-1803,-1760,-1718,
    -1677,-1636,-1596,-1556,-1517,-1478,-1440,-1403,
    -1366,-1329,-1293,-1257,-1221,-1186,-1152,-1118,
    -1084,-1051,-1018,-985,-953,-921,-889,-858,
    -827,-796,-766,-736,-706,-677,-648,-619,
    -590,-562,-534,-506,-479,-452,-425,-398,
    -371,-345,-319,-293,-268,-242,-217,-192,
    -168,-143,-119,-95,-71,-47,-23,0
};

const EAS_U16 fmRateTable[128] =
{
    32767,32764,32758,32747,32731,32712,32688,32659,
    32627,32590,32548,32503,32453,32398,32340,32277,
    32211,32140,32065,31985,31902,31815,31724,31628,
    31529,31426,31319,31208,31094,30976,30854,30728,
    30599,30466,30330,30191,30048,29902,29752,29599,
    29443,29285,29123,28958,28790,28619,28445,28269,
    28090,27909,27725,27538,27349,27158,26964,26769,
    26571,26371,26169,25965,25760,25552,25343,25132,
    24920,24706,24490,24274,24056,23836,23616,23394,
    23172,22948,22724,22499,22273,22046,21819,21591,
    21363,21135,20906,20676,20447,20217,19987,19758,
    19528,19298,19069,18840,18610,18382,18153,17926,
    17698,17471,17245,17020,16795,16571,16347,16125,
    15903,15683,15463,15245,15027,14811,14596,14382,
    14169,13957,13747,13538,13331,13125,12920,12717,
    12516,12316,12117,11921,11725,11532,11340,0
};

const EAS_U16 fmAttackTable[15] =
{
    27,54,109,327,655,1310,2730,4095,
    4681,5461,6553,8191,10922,16383,32767
};

const EAS_U8 fmDecayTable[16] =
{
    4,7,10,15,20,25,30,35,40,50,60,70,80,90,100,127
};

const EAS_U8 fmReleaseTable[16] =
{
    10,15,20,25,30,35,40,45,50,60,70,80,90,100,113,127
};
#endif

/* this table is needed only on the DSP */
#if defined(_DSP_CODE) || !defined(_SPLIT_ARCHITECTURE)
//---------------------------------------------------------------------
// sineTable
//
// Contains sine lookup table
//---------------------------------------------------------------------

const EAS_I16 sineTable[2048] =
{
    0,101,201,302,402,503,603,704,
    804,905,1005,1106,1206,1307,1407,1507,
    1608,1708,1809,1909,2009,2110,2210,2310,
    2410,2511,2611,2711,2811,2911,3012,3112,
    3212,3312,3412,3512,3612,3712,3811,3911,
    4011,4111,4210,4310,4410,4509,4609,4708,
    4808,4907,5007,5106,5205,5305,5404,5503,
    5602,5701,5800,5899,5998,6096,6195,6294,
    6393,6491,6590,6688,6786,6885,6983,7081,
    7179,7277,7375,7473,7571,7669,7767,7864,
    7962,8059,8157,8254,8351,8448,8545,8642,
    8739,8836,8933,9030,9126,9223,9319,9416,
    9512,9608,9704,9800,9896,9992,10087,10183,
    10278,10374,10469,10564,10659,10754,10849,10944,
    11039,11133,11228,11322,11417,11511,11605,11699,
    11793,11886,11980,12074,12167,12260,12353,12446,
    12539,12632,12725,12817,12910,13002,13094,13187,
    13279,13370,13462,13554,13645,13736,13828,13919,
    14010,14101,14191,14282,14372,14462,14553,14643,
    14732,14822,14912,15001,15090,15180,15269,15358,
    15446,15535,15623,15712,15800,15888,15976,16063,
    16151,16238,16325,16413,16499,16586,16673,16759,
    16846,16932,17018,17104,17189,17275,17360,17445,
    17530,17615,17700,17784,17869,17953,18037,18121,
    18204,18288,18371,18454,18537,18620,18703,18785,
    18868,18950,19032,19113,19195,19276,19357,19438,
    19519,19600,19680,19761,19841,19921,20000,20080,
    20159,20238,20317,20396,20475,20553,20631,20709,
    20787,20865,20942,21019,21096,21173,21250,21326,
    21403,21479,21554,21630,21705,21781,21856,21930,
    22005,22079,22154,22227,22301,22375,22448,22521,
    22594,22667,22739,22812,22884,22956,23027,23099,
    23170,23241,23311,23382,23452,23522,23592,23662,
    23731,23801,23870,23938,24007,24075,24143,24211,
    24279,24346,24413,24480,24547,24613,24680,24746,
    24811,24877,24942,25007,25072,25137,25201,25265,
    25329,25393,25456,25519,25582,25645,25708,25770,
    25832,25893,25955,26016,26077,26138,26198,26259,
    26319,26378,26438,26497,26556,26615,26674,26732,
    26790,26848,26905,26962,27019,27076,27133,27189,
    27245,27300,27356,27411,27466,27521,27575,27629,
    27683,27737,27790,27843,27896,27949,28001,28053,
    28105,28157,28208,28259,28310,28360,28411,28460,
    28510,28560,28609,28658,28706,28755,28803,28850,
    28898,28945,28992,29039,29085,29131,29177,29223,
    29268,29313,29358,29403,29447,29491,29534,29578,
    29621,29664,29706,29749,29791,29832,29874,29915,
    29956,29997,30037,30077,30117,30156,30195,30234,
    30273,30311,30349,30387,30424,30462,30498,30535,
    30571,30607,30643,30679,30714,30749,30783,30818,
    30852,30885,30919,30952,30985,31017,31050,31082,
    31113,31145,31176,31206,31237,31267,31297,31327,
    31356,31385,31414,31442,31470,31498,31526,31553,
    31580,31607,31633,31659,31685,31710,31736,31760,
    31785,31809,31833,31857,31880,31903,31926,31949,
    31971,31993,32014,32036,32057,32077,32098,32118,
    32137,32157,32176,32195,32213,32232,32250,32267,
    32285,32302,32318,32335,32351,32367,32382,32397,
    32412,32427,32441,32455,32469,32482,32495,32508,
    32521,32533,32545,32556,32567,32578,32589,32599,
    32609,32619,32628,32637,32646,32655,32663,32671,
    32678,32685,32692,32699,32705,32711,32717,32722,
    32728,32732,32737,32741,32745,32748,32752,32755,
    32757,32759,32761,32763,32765,32766,32766,32767,
    32767,32767,32766,32766,32765,32763,32761,32759,
    32757,32755,32752,32748,32745,32741,32737,32732,
    32728,32722,32717,32711,32705,32699,32692,32685,
    32678,32671,32663,32655,32646,32637,32628,32619,
    32609,32599,32589,32578,32567,32556,32545,32533,
    32521,32508,32495,32482,32469,32455,32441,32427,
    32412,32397,32382,32367,32351,32335,32318,32302,
    32285,32267,32250,32232,32213,32195,32176,32157,
    32137,32118,32098,32077,32057,32036,32014,31993,
    31971,31949,31926,31903,31880,31857,31833,31809,
    31785,31760,31736,31710,31685,31659,31633,31607,
    31580,31553,31526,31498,31470,31442,31414,31385,
    31356,31327,31297,31267,31237,31206,31176,31145,
    31113,31082,31050,31017,30985,30952,30919,30885,
    30852,30818,30783,30749,30714,30679,30643,30607,
    30571,30535,30498,30462,30424,30387,30349,30311,
    30273,30234,30195,30156,30117,30077,30037,29997,
    29956,29915,29874,29832,29791,29749,29706,29664,
    29621,29578,29534,29491,29447,29403,29358,29313,
    29268,29223,29177,29131,29085,29039,28992,28945,
    28898,28850,28803,28755,28706,28658,28609,28560,
    28510,28460,28411,28360,28310,28259,28208,28157,
    28105,28053,28001,27949,27896,27843,27790,27737,
    27683,27629,27575,27521,27466,27411,27356,27300,
    27245,27189,27133,27076,27019,26962,26905,26848,
    26790,26732,26674,26615,26556,26497,26438,26378,
    26319,26259,26198,26138,26077,26016,25955,25893,
    25832,25770,25708,25645,25582,25519,25456,25393,
    25329,25265,25201,25137,25072,25007,24942,24877,
    24811,24746,24680,24613,24547,24480,24413,24346,
    24279,24211,24143,24075,24007,23938,23870,23801,
    23731,23662,23592,23522,23452,23382,23311,23241,
    23170,23099,23027,22956,22884,22812,22739,22667,
    22594,22521,22448,22375,22301,22227,22154,22079,
    22005,21930,21856,21781,21705,21630,21554,21479,
    21403,21326,21250,21173,21096,21019,20942,20865,
    20787,20709,20631,20553,20475,20396,20317,20238,
    20159,20080,20000,19921,19841,19761,19680,19600,
    19519,19438,19357,19276,19195,19113,19032,18950,
    18868,18785,18703,18620,18537,18454,18371,18288,
    18204,18121,18037,17953,17869,17784,17700,17615,
    17530,17445,17360,17275,17189,17104,17018,16932,
    16846,16759,16673,16586,16499,16413,16325,16238,
    16151,16063,15976,15888,15800,15712,15623,15535,
    15446,15358,15269,15180,15090,15001,14912,14822,
    14732,14643,14553,14462,14372,14282,14191,14101,
    14010,13919,13828,13736,13645,13554,13462,13370,
    13279,13187,13094,13002,12910,12817,12725,12632,
    12539,12446,12353,12260,12167,12074,11980,11886,
    11793,11699,11605,11511,11417,11322,11228,11133,
    11039,10944,10849,10754,10659,10564,10469,10374,
    10278,10183,10087,9992,9896,9800,9704,9608,
    9512,9416,9319,9223,9126,9030,8933,8836,
    8739,8642,8545,8448,8351,8254,8157,8059,
    7962,7864,7767,7669,7571,7473,7375,7277,
    7179,7081,6983,6885,6786,6688,6590,6491,
    6393,6294,6195,6096,5998,5899,5800,5701,
    5602,5503,5404,5305,5205,5106,5007,4907,
    4808,4708,4609,4509,4410,4310,4210,4111,
    4011,3911,3811,3712,3612,3512,3412,3312,
    3212,3112,3012,2911,2811,2711,2611,2511,
    2410,2310,2210,2110,2009,1909,1809,1708,
    1608,1507,1407,1307,1206,1106,1005,905,
    804,704,603,503,402,302,201,101,
    0,-101,-201,-302,-402,-503,-603,-704,
    -804,-905,-1005,-1106,-1206,-1307,-1407,-1507,
    -1608,-1708,-1809,-1909,-2009,-2110,-2210,-2310,
    -2410,-2511,-2611,-2711,-2811,-2911,-3012,-3112,
    -3212,-3312,-3412,-3512,-3612,-3712,-3811,-3911,
    -4011,-4111,-4210,-4310,-4410,-4509,-4609,-4708,
    -4808,-4907,-5007,-5106,-5205,-5305,-5404,-5503,
    -5602,-5701,-5800,-5899,-5998,-6096,-6195,-6294,
    -6393,-6491,-6590,-6688,-6786,-6885,-6983,-7081,
    -7179,-7277,-7375,-7473,-7571,-7669,-7767,-7864,
    -7962,-8059,-8157,-8254,-8351,-8448,-8545,-8642,
    -8739,-8836,-8933,-9030,-9126,-9223,-9319,-9416,
    -9512,-9608,-9704,-9800,-9896,-9992,-10087,-10183,
    -10278,-10374,-10469,-10564,-10659,-10754,-10849,-10944,
    -11039,-11133,-11228,-11322,-11417,-11511,-11605,-11699,
    -11793,-11886,-11980,-12074,-12167,-12260,-12353,-12446,
    -12539,-12632,-12725,-12817,-12910,-13002,-13094,-13187,
    -13279,-13370,-13462,-13554,-13645,-13736,-13828,-13919,
    -14010,-14101,-14191,-14282,-14372,-14462,-14553,-14643,
    -14732,-14822,-14912,-15001,-15090,-15180,-15269,-15358,
    -15446,-15535,-15623,-15712,-15800,-15888,-15976,-16063,
    -16151,-16238,-16325,-16413,-16499,-16586,-16673,-16759,
    -16846,-16932,-17018,-17104,-17189,-17275,-17360,-17445,
    -17530,-17615,-17700,-17784,-17869,-17953,-18037,-18121,
    -18204,-18288,-18371,-18454,-18537,-18620,-18703,-18785,
    -18868,-18950,-19032,-19113,-19195,-19276,-19357,-19438,
    -19519,-19600,-19680,-19761,-19841,-19921,-20000,-20080,
    -20159,-20238,-20317,-20396,-20475,-20553,-20631,-20709,
    -20787,-20865,-20942,-21019,-21096,-21173,-21250,-21326,
    -21403,-21479,-21554,-21630,-21705,-21781,-21856,-21930,
    -22005,-22079,-22154,-22227,-22301,-22375,-22448,-22521,
    -22594,-22667,-22739,-22812,-22884,-22956,-23027,-23099,
    -23170,-23241,-23311,-23382,-23452,-23522,-23592,-23662,
    -23731,-23801,-23870,-23938,-24007,-24075,-24143,-24211,
    -24279,-24346,-24413,-24480,-24547,-24613,-24680,-24746,
    -24811,-24877,-24942,-25007,-25072,-25137,-25201,-25265,
    -25329,-25393,-25456,-25519,-25582,-25645,-25708,-25770,
    -25832,-25893,-25955,-26016,-26077,-26138,-26198,-26259,
    -26319,-26378,-26438,-26497,-26556,-26615,-26674,-26732,
    -26790,-26848,-26905,-26962,-27019,-27076,-27133,-27189,
    -27245,-27300,-27356,-27411,-27466,-27521,-27575,-27629,
    -27683,-27737,-27790,-27843,-27896,-27949,-28001,-28053,
    -28105,-28157,-28208,-28259,-28310,-28360,-28411,-28460,
    -28510,-28560,-28609,-28658,-28706,-28755,-28803,-28850,
    -28898,-28945,-28992,-29039,-29085,-29131,-29177,-29223,
    -29268,-29313,-29358,-29403,-29447,-29491,-29534,-29578,
    -29621,-29664,-29706,-29749,-29791,-29832,-29874,-29915,
    -29956,-29997,-30037,-30077,-30117,-30156,-30195,-30234,
    -30273,-30311,-30349,-30387,-30424,-30462,-30498,-30535,
    -30571,-30607,-30643,-30679,-30714,-30749,-30783,-30818,
    -30852,-30885,-30919,-30952,-30985,-31017,-31050,-31082,
    -31113,-31145,-31176,-31206,-31237,-31267,-31297,-31327,
    -31356,-31385,-31414,-31442,-31470,-31498,-31526,-31553,
    -31580,-31607,-31633,-31659,-31685,-31710,-31736,-31760,
    -31785,-31809,-31833,-31857,-31880,-31903,-31926,-31949,
    -31971,-31993,-32014,-32036,-32057,-32077,-32098,-32118,
    -32137,-32157,-32176,-32195,-32213,-32232,-32250,-32267,
    -32285,-32302,-32318,-32335,-32351,-32367,-32382,-32397,
    -32412,-32427,-32441,-32455,-32469,-32482,-32495,-32508,
    -32521,-32533,-32545,-32556,-32567,-32578,-32589,-32599,
    -32609,-32619,-32628,-32637,-32646,-32655,-32663,-32671,
    -32678,-32685,-32692,-32699,-32705,-32711,-32717,-32722,
    -32728,-32732,-32737,-32741,-32745,-32748,-32752,-32755,
    -32757,-32759,-32761,-32763,-32765,-32766,-32766,-32767,
    -32767,-32767,-32766,-32766,-32765,-32763,-32761,-32759,
    -32757,-32755,-32752,-32748,-32745,-32741,-32737,-32732,
    -32728,-32722,-32717,-32711,-32705,-32699,-32692,-32685,
    -32678,-32671,-32663,-32655,-32646,-32637,-32628,-32619,
    -32609,-32599,-32589,-32578,-32567,-32556,-32545,-32533,
    -32521,-32508,-32495,-32482,-32469,-32455,-32441,-32427,
    -32412,-32397,-32382,-32367,-32351,-32335,-32318,-32302,
    -32285,-32267,-32250,-32232,-32213,-32195,-32176,-32157,
    -32137,-32118,-32098,-32077,-32057,-32036,-32014,-31993,
    -31971,-31949,-31926,-31903,-31880,-31857,-31833,-31809,
    -31785,-31760,-31736,-31710,-31685,-31659,-31633,-31607,
    -31580,-31553,-31526,-31498,-31470,-31442,-31414,-31385,
    -31356,-31327,-31297,-31267,-31237,-31206,-31176,-31145,
    -31113,-31082,-31050,-31017,-30985,-30952,-30919,-30885,
    -30852,-30818,-30783,-30749,-30714,-30679,-30643,-30607,
    -30571,-30535,-30498,-30462,-30424,-30387,-30349,-30311,
    -30273,-30234,-30195,-30156,-30117,-30077,-30037,-29997,
    -29956,-29915,-29874,-29832,-29791,-29749,-29706,-29664,
    -29621,-29578,-29534,-29491,-29447,-29403,-29358,-29313,
    -29268,-29223,-29177,-29131,-29085,-29039,-28992,-28945,
    -28898,-28850,-28803,-28755,-28706,-28658,-28609,-28560,
    -28510,-28460,-28411,-28360,-28310,-28259,-28208,-28157,
    -28105,-28053,-28001,-27949,-27896,-27843,-27790,-27737,
    -27683,-27629,-27575,-27521,-27466,-27411,-27356,-27300,
    -27245,-27189,-27133,-27076,-27019,-26962,-26905,-26848,
    -26790,-26732,-26674,-26615,-26556,-26497,-26438,-26378,
    -26319,-26259,-26198,-26138,-26077,-26016,-25955,-25893,
    -25832,-25770,-25708,-25645,-25582,-25519,-25456,-25393,
    -25329,-25265,-25201,-25137,-25072,-25007,-24942,-24877,
    -24811,-24746,-24680,-24613,-24547,-24480,-24413,-24346,
    -24279,-24211,-24143,-24075,-24007,-23938,-23870,-23801,
    -23731,-23662,-23592,-23522,-23452,-23382,-23311,-23241,
    -23170,-23099,-23027,-22956,-22884,-22812,-22739,-22667,
    -22594,-22521,-22448,-22375,-22301,-22227,-22154,-22079,
    -22005,-21930,-21856,-21781,-21705,-21630,-21554,-21479,
    -21403,-21326,-21250,-21173,-21096,-21019,-20942,-20865,
    -20787,-20709,-20631,-20553,-20475,-20396,-20317,-20238,
    -20159,-20080,-20000,-19921,-19841,-19761,-19680,-19600,
    -19519,-19438,-19357,-19276,-19195,-19113,-19032,-18950,
    -18868,-18785,-18703,-18620,-18537,-18454,-18371,-18288,
    -18204,-18121,-18037,-17953,-17869,-17784,-17700,-17615,
    -17530,-17445,-17360,-17275,-17189,-17104,-17018,-16932,
    -16846,-16759,-16673,-16586,-16499,-16413,-16325,-16238,
    -16151,-16063,-15976,-15888,-15800,-15712,-15623,-15535,
    -15446,-15358,-15269,-15180,-15090,-15001,-14912,-14822,
    -14732,-14643,-14553,-14462,-14372,-14282,-14191,-14101,
    -14010,-13919,-13828,-13736,-13645,-13554,-13462,-13370,
    -13279,-13187,-13094,-13002,-12910,-12817,-12725,-12632,
    -12539,-12446,-12353,-12260,-12167,-12074,-11980,-11886,
    -11793,-11699,-11605,-11511,-11417,-11322,-11228,-11133,
    -11039,-10944,-10849,-10754,-10659,-10564,-10469,-10374,
    -10278,-10183,-10087,-9992,-9896,-9800,-9704,-9608,
    -9512,-9416,-9319,-9223,-9126,-9030,-8933,-8836,
    -8739,-8642,-8545,-8448,-8351,-8254,-8157,-8059,
    -7962,-7864,-7767,-7669,-7571,-7473,-7375,-7277,
    -7179,-7081,-6983,-6885,-6786,-6688,-6590,-6491,
    -6393,-6294,-6195,-6096,-5998,-5899,-5800,-5701,
    -5602,-5503,-5404,-5305,-5205,-5106,-5007,-4907,
    -4808,-4708,-4609,-4509,-4410,-4310,-4210,-4111,
    -4011,-3911,-3811,-3712,-3612,-3512,-3412,-3312,
    -3212,-3112,-3012,-2911,-2811,-2711,-2611,-2511,
    -2410,-2310,-2210,-2110,-2009,-1909,-1809,-1708,
    -1608,-1507,-1407,-1307,-1206,-1106,-1005,-905,
    -804,-704,-603,-503,-402,-302,-201,-101
};
#endif

