/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.InvalidArgument;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class AttachNetworkInterface
extends BaseCmd {
    private static final String INSTANCE_DESC = "The ID of the instance that will be attached to the network interface.";
    private static final String DEVICE_INDEX_DESC = "The index of the device for the network interface attachment on the instance.";
    private String networkInterfaceId;
    private String instanceId;
    private Integer deviceIndex;

    public AttachNetworkInterface(String[] args) {
        super("ec2attnic", "ec2-attach-network-interface");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    @Override
    protected String getOptionString() {
        return "NETWORKINTERFACE -i INSTANCE -d DEVICEINDEX";
    }

    private Options getOptions() {
        Options options = new Options();
        options.addOption(AttachNetworkInterface.createOptionWithArgs("i", "instance", INSTANCE_DESC, "INSTANCE"));
        options.addOption(AttachNetworkInterface.createOptionWithArgs("d", "device-index", DEVICE_INDEX_DESC, "DEVICEINDEX"));
        return options;
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Attaches a network interface to an instance.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("instance");
        this.printOption("device-index");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        RequestResultPair rsp = jec2.attachNetworkInterface(this.networkInterfaceId, this.instanceId, this.deviceIndex.intValue());
        out.output(System.out, (String)rsp.getResponse());
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    @Override
    protected void parseOpts(String[] args) {
        super.parseOpts(args);
    }

    protected void validateParameters() {
        this.assertNonOptionSet("NETWORKINTERFACE");
        this.warnIfTooManyNonOptions();
        this.assertOptionSet("instance");
        this.assertOptionSet("device-index");
        this.networkInterfaceId = this.getNonOptions()[0];
        this.instanceId = this.getOptionValue("instance");
        String deviceIndex = this.getOptionValue("device-index");
        try {
            this.deviceIndex = Integer.parseInt(deviceIndex, 10);
        }
        catch (NumberFormatException e) {
            throw new InvalidArgument("device-index", deviceIndex);
        }
    }

    public static void main(String[] args) {
        new AttachNetworkInterface(args).invoke();
    }
}

