/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.model;

import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import java.io.File;
import org.kohsuke.args4j.Option;

public class ServerCertUploadRequest
extends CLIRequest {
    private static final String NAME = "iam-servercertupload";
    private static final String DESCRIPTION = "Uploads a new server certificate under your account.";
    @Option(name="-b", usage="the pem encoded public key certificate file", required=true, metaVar="CERTBODYFILE")
    private File certBodyFile_;
    @Option(name="-c", usage="the pem encoded certificate chain file", metaVar="CERTCHAINFILE")
    private File certChainFile_;
    @Option(name="-k", usage="the pem encoded private key file", required=true, metaVar="PRIVATEKEYFILE")
    private File privateKeyFile_;
    @Option(name="-p", usage="the path of the server certificate, defaults to /", metaVar="PATH")
    private String path_;
    @Option(name="-s", usage="the name of the server certificate", required=true, metaVar="SERVERCERTNAME")
    private String scName_;
    @Option(name="-v", usage="print out the newly created server certificate's arn and guid", metaVar="VERBOSE")
    private boolean isVerbose_;

    public File getCertificateBodyFile() {
        return this.certBodyFile_;
    }

    public File getCertificateChainFile() {
        return this.certChainFile_;
    }

    public File getPrivateKeyFile() {
        return this.privateKeyFile_;
    }

    public String getPath() {
        return this.path_;
    }

    public String getServerCertificateName() {
        return this.scName_;
    }

    public boolean isVerbose() {
        return this.isVerbose_;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getRequestName() {
        return NAME;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ServerCertUploadRequest [scName_=");
        builder.append(this.scName_);
        builder.append(", path_=");
        builder.append(this.path_);
        builder.append(", certBodyFile_=");
        builder.append(this.certBodyFile_);
        builder.append(", certChainFile_=");
        builder.append(this.certChainFile_);
        builder.append(", privateKeyFile_=");
        builder.append(this.privateKeyFile_);
        builder.append(", super.toString()=");
        builder.append(super.toString());
        builder.append("]");
        return builder.toString();
    }
}

