/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

public class JideFocusTracker {
    protected Component compHeighest;
    protected FocusListener listenerFocus = null;
    protected ContainerListener listenerContainer = null;
    protected transient FocusListener listenerMultiCast;
    protected boolean repeat;
    protected transient Component lastFocus = null;

    public JideFocusTracker() {
        this.setRepeating(true);
        this.listenerFocus = new MainFocusListener();
        this.listenerContainer = new MainContainerListener();
    }

    public JideFocusTracker(Component component) {
        this();
        this.setHeighestComponent(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeighestComponent(Component component) {
        Object object;
        Component component2 = this.compHeighest;
        if (component2 != null) {
            object = component2.getTreeLock();
            synchronized (object) {
                this.removeInternalListeners(component2);
            }
        }
        if (component != null) {
            object = component.getTreeLock();
            synchronized (object) {
                this.addInternalListeners(component);
            }
        }
        this.compHeighest = component;
    }

    public Component getHeighestComponent() {
        return this.compHeighest;
    }

    public boolean isRepeating() {
        return this.repeat;
    }

    public void setRepeating(boolean bl) {
        this.repeat = bl;
    }

    public synchronized void addFocusListener(FocusListener focusListener) {
        this.listenerMultiCast = AWTEventMulticaster.add(this.listenerMultiCast, focusListener);
    }

    public synchronized void removeFocusListener(FocusListener focusListener) {
        this.listenerMultiCast = AWTEventMulticaster.remove(this.listenerMultiCast, focusListener);
    }

    protected void addInternalListeners(Component component) {
        component.addFocusListener(this.listenerFocus);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.addContainerListener(this.listenerContainer);
            for (int i = 0; i < container.getComponentCount(); ++i) {
                this.addInternalListeners(container.getComponent(i));
            }
        }
    }

    protected void removeInternalListeners(Component component) {
        component.removeFocusListener(this.listenerFocus);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.removeContainerListener(this.listenerContainer);
            for (int i = 0; i < container.getComponentCount(); ++i) {
                this.removeInternalListeners(container.getComponent(i));
            }
        }
    }

    class MainFocusListener
    implements FocusListener {
        MainFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (JideFocusTracker.this.listenerMultiCast != null && (focusEvent.getSource() != JideFocusTracker.this.lastFocus || JideFocusTracker.this.isRepeating())) {
                JideFocusTracker.this.listenerMultiCast.focusGained(focusEvent);
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (JideFocusTracker.this.listenerMultiCast != null && (focusEvent.getSource() != JideFocusTracker.this.lastFocus || JideFocusTracker.this.isRepeating())) {
                JideFocusTracker.this.listenerMultiCast.focusLost(focusEvent);
            }
        }
    }

    class MainContainerListener
    implements ContainerListener {
        MainContainerListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            Object object = containerEvent.getChild().getTreeLock();
            synchronized (object) {
                JideFocusTracker.this.addInternalListeners(containerEvent.getChild());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            Object object = containerEvent.getChild().getTreeLock();
            synchronized (object) {
                JideFocusTracker.this.removeInternalListeners(containerEvent.getChild());
            }
        }
    }
}

