/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.hierarchy;

import java.awt.Component;
import java.awt.Window;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.awt.AWT;
import org.fest.swing.hierarchy.ChildrenFinder;
import org.fest.swing.hierarchy.ParentFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WindowFilter {
    private final ParentFinder parentFinder;
    private final ChildrenFinder childrenFinder;
    final Map<Component, Boolean> ignored = new WeakHashMap<Component, Boolean>();
    final Map<Component, Boolean> implicitlyIgnored = new WeakHashMap<Component, Boolean>();

    WindowFilter() {
        this(new ParentFinder(), new ChildrenFinder());
    }

    WindowFilter(ParentFinder parentFinder, ChildrenFinder childrenFinder) {
        this.parentFinder = parentFinder;
        this.childrenFinder = childrenFinder;
    }

    boolean isImplicitlyIgnored(Component c) {
        return this.implicitlyIgnored.containsKey(c);
    }

    @RunsInCurrentThread
    boolean isIgnored(Component c) {
        if (c == null) {
            return false;
        }
        if (this.ignored.containsKey(c)) {
            return true;
        }
        if (c instanceof Window && this.isIgnored(c.getParent())) {
            return true;
        }
        return !(c instanceof Window) && this.isWindowIgnored(c);
    }

    private boolean isWindowIgnored(Component c) {
        Window w = this.parentFinder.windowFor(c);
        return w != null && this.isIgnored(w);
    }

    void implicitlyIgnore(Component c) {
        this.implicitlyIgnored.put(c, true);
    }

    @RunsInCurrentThread
    void ignore(Component c) {
        this.filter(c, true);
    }

    @RunsInCurrentThread
    void recognize(Component c) {
        this.filter(c, false);
    }

    Collection<Component> filtered() {
        return this.ignored.keySet();
    }

    private void filter(Component c, boolean ignore) {
        if (AWT.isSharedInvisibleFrame(c)) {
            for (Component child : this.childrenFinder.childrenOf(c)) {
                this.filter(child, ignore);
            }
            return;
        }
        this.doFilter(c, ignore);
        this.implicitlyIgnored.remove(c);
        if (!(c instanceof Window)) {
            return;
        }
        for (Window owned : ((Window)c).getOwnedWindows()) {
            this.filter(owned, ignore);
        }
    }

    private void doFilter(Component c, boolean ignore) {
        if (ignore) {
            this.ignored.put(c, true);
            return;
        }
        this.ignored.remove(c);
    }
}

