/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.aiff;

import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.AiffModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.IOException;

public class SaxelChunk
extends Chunk {
    public SaxelChunk(AiffModule aiffModule, ChunkHeader chunkHeader, DataInputStream dataInputStream) {
        super(aiffModule, chunkHeader, dataInputStream);
    }

    @Override
    public boolean readChunk(RepInfo repInfo) throws IOException {
        AiffModule aiffModule = (AiffModule)this._module;
        int n = aiffModule.readUnsignedShort(this._dstream);
        this.bytesLeft -= 2L;
        if (n == 0) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            Property[] propertyArray = new Property[2];
            int n2 = aiffModule.readUnsignedShort(this._dstream);
            int n3 = aiffModule.readUnsignedShort(this._dstream);
            aiffModule.skipBytes(this._dstream, n3, aiffModule);
            propertyArray[0] = new Property("ID", PropertyType.INTEGER, (Object)new Integer(n2));
            propertyArray[1] = new Property("Size", PropertyType.INTEGER, (Object)new Integer(n3));
            aiffModule.addSaxel(new Property("Saxel", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)propertyArray));
        }
        return true;
    }
}

