/*###############################################################################
# Linux Management Providers (LMP), Power Management provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "OpenDRIM_AssociatedPowerManagementServiceAccess.h"

int PowerManagement_OpenDRIM_AssociatedPowerManagementService_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(PowerManagement_CIM_ManagedElement_load(broker, errorMessage));
	CF_assert(PowerManagement_CIM_PowerManagementService_load(broker, errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int PowerManagement_OpenDRIM_AssociatedPowerManagementService_unload(string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(PowerManagement_CIM_ManagedElement_unload(errorMessage));
	CF_assert(PowerManagement_CIM_PowerManagementService_unload(errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int PowerManagement_OpenDRIM_AssociatedPowerManagementService_isAssociated(const Instance& UserOfService, const Instance& ServiceProvided, bool& isAssociated, string& errorMessage) {
	_E_;
	// TODO Determine if the association can be established or not
	isAssociated=true;
	_L_;
	return OK;
}

int PowerManagement_OpenDRIM_AssociatedPowerManagementService_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_AssociatedPowerManagementService>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> subjects;
	// Only get the instance names
	CF_assert(PowerManagement_OpenDRIM_AssociatedPowerManagementService_enumerateUserOfServices(broker, ctx, subjects, NULL, true, errorMessage));
	// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
	// CF_assert(PowerManagement_OpenDRIM_AssociatedPowerManagementService_enumerateUserOfServices(broker, ctx, subjects, NULL, false, errorMessage));
	vector<Instance>::iterator c = subjects.begin();
	vector<Instance>::iterator end = subjects.end();
	for (; c != end; ++c) {
		bool leftToRight = true;
		vector<Instance> associatedInstances;
		PowerManagement_OpenDRIM_AssociatedPowerManagementService_associator(broker, ctx,
			(*c).getObjectpath().getHdl(), (*c),
			UserOfService_classnames[0], ServiceProvided_classnames[0],
			UserOfService_role.c_str(), ServiceProvided_role.c_str(), NULL,
			associatedInstances, leftToRight, errorMessage, "an");

		string ref_discriminant = discriminant == "ein" ? "rn" : "r";
		CF_assert(PowerManagement_OpenDRIM_AssociatedPowerManagementService_referenceUserOfServiceToServiceProvided(broker, ctx, (*c), associatedInstances, result, NULL, errorMessage, ref_discriminant));
	}
	_L_;
	return OK;
}

int PowerManagement_OpenDRIM_AssociatedPowerManagementService_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_AssociatedPowerManagementService& instance, const char** properties, string& errorMessage) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	Objectpath UserOfService_objectpath;
	instance.getUserOfService(UserOfService_objectpath);
	Instance UserOfService_instance;
	CF_assert(PowerManagement_OpenDRIM_AssociatedPowerManagementService_getUserOfService(broker, ctx, UserOfService_objectpath, UserOfService_instance, NULL, errorMessage));
	
	Objectpath ServiceProvided_objectpath;
	instance.getServiceProvided(ServiceProvided_objectpath);
	Instance ServiceProvided_instance;
	CF_assert(PowerManagement_OpenDRIM_AssociatedPowerManagementService_getServiceProvided(broker, ctx, ServiceProvided_objectpath, ServiceProvided_instance, NULL, errorMessage));

	bool isAssociated = false;
	CF_assert(PowerManagement_OpenDRIM_AssociatedPowerManagementService_isAssociated(UserOfService_instance, ServiceProvided_instance, isAssociated, errorMessage));
	if (!isAssociated)
	{
		if(errorMessage.empty())
			errorMessage = "No instance";
		
		return NOT_FOUND;
	}
	CF_assert(PowerManagement_OpenDRIM_AssociatedPowerManagementService_populate(instance, errorMessage));
	_L_;
	return OK;
}

int PowerManagement_OpenDRIM_AssociatedPowerManagementService_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AssociatedPowerManagementService& newInstance, const OpenDRIM_AssociatedPowerManagementService& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PowerManagement_OpenDRIM_AssociatedPowerManagementService_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AssociatedPowerManagementService& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PowerManagement_OpenDRIM_AssociatedPowerManagementService_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AssociatedPowerManagementService& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PowerManagement_OpenDRIM_AssociatedPowerManagementService_associatorUserOfServiceToServiceProvided(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& UserOfService_instance, const char** properties, vector<Instance>& ServiceProvided_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> ServiceProvided_instances;
	if (discriminant=="a")
		CF_assert(PowerManagement_OpenDRIM_AssociatedPowerManagementService_enumerateServiceProvideds(broker, ctx, ServiceProvided_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(PowerManagement_OpenDRIM_AssociatedPowerManagementService_enumerateServiceProvideds(broker, ctx, ServiceProvided_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(PowerManagement_OpenDRIM_AssociatedPowerManagementService_enumerateServiceProvideds(broker, ctx, ServiceProvided_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<ServiceProvided_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(PowerManagement_OpenDRIM_AssociatedPowerManagementService_isAssociated(UserOfService_instance, ServiceProvided_instances[i], isAssociated, errorMessage));
		if (isAssociated)
			ServiceProvided_associatedInstances.push_back(ServiceProvided_instances[i]);
	}
	_L_;
	return OK;
}

int PowerManagement_OpenDRIM_AssociatedPowerManagementService_associatorServiceProvidedToUserOfService(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ServiceProvided_instance, const char** properties, vector<Instance>& UserOfService_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> UserOfService_instances;
	if (discriminant=="a")
		CF_assert(PowerManagement_OpenDRIM_AssociatedPowerManagementService_enumerateUserOfServices(broker, ctx, UserOfService_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(PowerManagement_OpenDRIM_AssociatedPowerManagementService_enumerateUserOfServices(broker, ctx, UserOfService_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(PowerManagement_OpenDRIM_AssociatedPowerManagementService_enumerateUserOfServices(broker, ctx, UserOfService_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<UserOfService_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(PowerManagement_OpenDRIM_AssociatedPowerManagementService_isAssociated(UserOfService_instances[i], ServiceProvided_instance, isAssociated, errorMessage));
		if (isAssociated)
			UserOfService_associatedInstances.push_back(UserOfService_instances[i]);
	}
	_L_;
	return OK;
}

int PowerManagement_OpenDRIM_AssociatedPowerManagementService_referenceUserOfServiceToServiceProvided(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& UserOfService_instance, const vector<Instance>& ServiceProvided_instances, vector<OpenDRIM_AssociatedPowerManagementService>& OpenDRIM_AssociatedPowerManagementService_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < ServiceProvided_instances.size(); i++) {
		OpenDRIM_AssociatedPowerManagementService instance;
		instance.setUserOfService(((Instance) UserOfService_instance).getObjectpath());
		instance.setServiceProvided(((Instance) ServiceProvided_instances[i]).getObjectpath());
			
		if (discriminant == "r") {
			CF_assert(PowerManagement_OpenDRIM_AssociatedPowerManagementService_populate(instance, errorMessage));
		}
		
		OpenDRIM_AssociatedPowerManagementService_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int PowerManagement_OpenDRIM_AssociatedPowerManagementService_referenceServiceProvidedToUserOfService(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ServiceProvided_instance, const vector<Instance>& UserOfService_instances, vector<OpenDRIM_AssociatedPowerManagementService>& OpenDRIM_AssociatedPowerManagementService_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < UserOfService_instances.size(); i++) {
		OpenDRIM_AssociatedPowerManagementService instance;
		instance.setUserOfService(((Instance) UserOfService_instances[i]).getObjectpath());
		instance.setServiceProvided(((Instance) ServiceProvided_instance).getObjectpath());
			
		if (discriminant == "r") {
			CF_assert(PowerManagement_OpenDRIM_AssociatedPowerManagementService_populate(instance, errorMessage));
		}
		
		OpenDRIM_AssociatedPowerManagementService_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int PowerManagement_OpenDRIM_AssociatedPowerManagementService_populate(OpenDRIM_AssociatedPowerManagementService& instance, string& errorMessage) {
	_E_;
	// Cannot be associated to a computer system whichi is not On
	instance.setPowerState(2); // On
	_L_;
	return OK;
}

