#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Slay the Spire
# send your bug reports to contact@dotslashplay.it
###

script_version=20230812.1

GAME_ID='slay-the-spire'
GAME_NAME='Slay the Spire'

ARCHIVE_BASE_0='slay_the_spire_2020_12_15_8735c9fe3cc2280b76aa3ec47c953352a7df1f65_43444.sh'
ARCHIVE_BASE_0_MD5='1989ebecb2434f0480b42c4e576dfc78'
ARCHIVE_BASE_0_SIZE='570000'
ARCHIVE_BASE_0_VERSION='2.2-gog43444'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/slay_the_spire'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_DATA_FILES='
desktop-1.0.jar
mod-uploader.jar
mts-launcher.jar'
CONTENT_GAME_BIN_SHIPPED_FILES='
SlayTheSpire
config.json
jre'
CONTENT_DOC_DATA_FILES='
README.md'

# Applications

USER_PERSISTENT_DIRECTORIES='
betaPreferences
saves'
USER_PERSISTENT_FILES='
info.displayconfig'

APPLICATIONS_LIST='APP_MAIN'

APP_MAIN_ICON='../support/icon.png'

## Using system-provided Java

APP_MAIN_TYPE_BIN_SYSTEM='java'
APP_MAIN_EXE_BIN_SYSTEM='desktop-1.0.jar'

## Using shipped binaries

APP_MAIN_TYPE_BIN_SHIPPED='native'
APP_MAIN_EXE_BIN_SHIPPED='SlayTheSpire'


PACKAGES_LIST='PKG_BIN_SHIPPED PKG_BIN_SYSTEM PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Binaries packages

PKG_BIN_ID="${GAME_ID}-bin"

## Using system-provided Java

PKG_BIN_SYSTEM_ID="${PKG_BIN_ID}-system"
PKG_BIN_SYSTEM_DESCRIPTION='Using system-provided Java'
PKG_BIN_SYSTEM_PROVIDES="
$PKG_BIN_ID"
PKG_BIN_SYSTEM_DEPS="$PKG_DATA_ID"

## Using shipped binarie

PKG_BIN_SHIPPED_ID="${PKG_BIN_ID}-shipped"
PKG_BIN_SHIPPED_DESCRIPTION='Using shipped binaries'
PKG_BIN_SHIPPED_ARCH='64'
PKG_BIN_SHIPPED_PROVIDES="
$PKG_BIN_ID"
PKG_BIN_SHIPPED_DEPS="$PKG_DATA_ID"
PKG_BIN_SHIPPED_DEPENDENCIES_LIBRARIES='
libasound.so.2
libatk-1.0.so.0
libcairo.so.2
libc.so.6
libdl.so.2
libfontconfig.so.1
libfreetype.so.6
libgcc_s.so.1
libgdk_pixbuf-2.0.so.0
libgdk-x11-2.0.so.0
libgio-2.0.so.0
libglib-2.0.so.0
libGL.so.1
libgmodule-2.0.so.0
libgobject-2.0.so.0
libgthread-2.0.so.0
libgtk-x11-2.0.so.0
libm.so.6
libpango-1.0.so.0
libpangocairo-1.0.so.0
libpangoft2-1.0.so.0
libpthread.so.0
librt.so.1
libstdc++.so.6
libthread_db.so.1
libX11.so.6
libXext.so.6
libXi.so.6
libxml2.so.2
libXrender.so.1
libxslt.so.1
libXtst.so.6
libXxf86vm.so.1'

# Load common functions

target_version='2.24'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icon

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

for PKG in 'PKG_BIN_SHIPPED' 'PKG_BIN_SYSTEM'; do
	launchers_write
done

# Build packages

packages_generation

# Print instructions

case "${LANG%_*}" in
	('fr')
		message='Utilisation des binaires fournis par %s :'
		bin_system='le système'
		bin_shipped='les développeurs'
	;;
	('en'|*)
		message='Using binaries provided by %s:'
		bin_system='the system'
		bin_shipped='the developers'
	;;
esac
printf '\n'
printf "$message" "$bin_system"
print_instructions 'PKG_BIN_SYSTEM' 'PKG_DATA'
printf "$message" "$bin_shipped"
print_instructions 'PKG_BIN_SHIPPED' 'PKG_DATA'

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
