#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2019 BetaRays
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Tengami
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220805.1

GAME_ID='tengami'
GAME_NAME='Tengami'

# This game archive is no longer distributed,
# since Playism store closed down in favour of Steam.
ARCHIVE_BASE_0='Tengami Win0113.zip'
ARCHIVE_BASE_0_MD5='956f8bff6b8bdef8702e994dea23b8dc'
ARCHIVE_BASE_0_SIZE='830000'
ARCHIVE_BASE_0_VERSION='0113-playism'

CONTENT_PATH_DEFAULT='app'
ARCHIVE_GAME_BIN_FILES='
Tengami.exe
glew32.DLL
SDL2.dll'
ARCHIVE_GAME_DATA_FILES='
Binary'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='Tengami.exe'
APP_MAIN_ICON='Tengami.exe'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID wine libGL.so.1"
PKG_BIN_DEPS_ARCH='lib32-alsa-lib'

# Use persistent storage for user data

USER_PERSISTENT_DIRECTORIES='
Save'

# Load common functions

target_version='2.17'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
INNER_ARCHIVE="${PLAYIT_WORKDIR}/gamedata/Tengami Win/Tengami_Game_Win20150113.exe"
INNER_ARCHIVE_EXTRACTOR='innoextract'
INNER_ARCHIVE_EXTRACTOR_OPTIONS='--progress=1 --silent'
archive_extraction 'INNER_ARCHIVE'
rm --force "$INNER_ARCHIVE"

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
