# B.2 Why are anarchists against the state?

As previously noted (see [section B.1](secB1.md)), anarchists oppose all
forms of hierarchical authority. Historically, however, they have spent most
of their time and energy opposing two main forms in particular. One is
capitalism, the other, the state. These two forms of authority have a
symbiotic relationship and cannot be easily separated:

> _"[T]he State . . . and Capitalism are facts and conceptions which we cannot
separate from each other. In the course of history these institutions have
developed, supporting and reinforcing each other.  
>  _

>

> _"They are connected with each other -- not as mere accidental co-
incidences. They are linked together by the links of cause and effect."_
[Kropotkin, **Evolution and Environment**, p. 94]

In this section, in consequence, as well as explaining why anarchists oppose
the state, we will necessarily have to analyse the relationship between it and
capitalism.

So what is the state? As Malatesta put it, anarchists _"have used the word
State, and still do, to mean the sum total of the political, legislative,
judiciary, military and financial institutions through which the management of
their own affairs, the control over their personal behaviour, the
responsibility for their personal safety, are taken away from the people and
entrusted to others who, by usurpation or delegation, are vested with the
power to make laws for everything and everybody, and to oblige the people to
observe them, if need be, by the use of collective force."_ [**Anarchy**, p.
17]

He continues:

> _ "For us, government [or the state] is made up of all the governors; and
the governors . . . are those who have the power to make **laws** regulating
inter-human relations and to see that they are carried out . . . [and] who
have the power, to a greater or lesser degree, to make use of the social
power, that is of the physical, intellectual and economic power of the whole
community, in order to oblige everybody to carry out their wishes. And this
power, in our opinion, constitutes the principle of government, of
authority."_ [**Op. Cit.**, p. 19]

Kropotkin presented a similar analysis, arguing that the state _"not only
includes the existence of a power situated above society, but also of a
**territorial concentration** as well as the concentration **in the hands of a
few of many functions in the life of societies** . . . A whole mechanism of
legislation and of policing has to be developed in order to subject some
classes to the domination of others."_ [**The State: Its Historic Role**, p.
10] For Bakunin, all states _"are in essence only machines governing the
masses from above, through . . . a privileged minority, allegedly knowing the
genuine interests of the people better than the people themselves."_ [**The
Political Philosophy of Bakunin**, p. 211] On this subject Murray Bookchin
writes:

> _ "Minimally, the State is a professional system of social coercion -- not
merely a system of social administration as it is still naively regarded by
the public and by many political theorists. The word 'professional' should be
emphasised as much as the word 'coercion.' . . . It is only when coercion is
institutionalised into a professional, systematic and organised form of social
control -- that is, when people are plucked out of their everyday lives in a
community and expected not only to 'administer' it but to do so with the
backing of a monopoly of violence -- that we can properly speak of a State."_
[**Remaking Society**, p. 66]

As Bookchin indicates, anarchists reject the idea that the state is the same
as society or that **any** grouping of human beings living and organised
together is a state. This confusion, as Kropotkin notes, explains why
_"anarchists are generally upbraided for wanting to 'destroy society' and of
advocating a return to 'the permanent war of each against all.'"_ Such a
position _"overlook[s] the fact that Man lived in Societies for thousands of
years before the State had been heard of"_ and that, consequently, the State
_"is only one of the forms assumed by society in the course of history."_
[**Op. Cit.**, p. 10]

The state, therefore, is not just federations of individuals or peoples and
so, as Malatesta stressed, cannot be used to describe a _"human collectively
gathered together in a particular territory and making up what is called a
social unit irrespective of the way the way said collectivity are grouped or
the state of relations between them."_ It cannot be _"used simply as a synonym
for society."_ [**Op. Cit.**, p. 17] The state is a particular form of social
organisation based on certain key attributes and so, we argue, _"the word
'State' . . . should be reserved for those societies with the hierarchical
system and centralisation."_ [Peter Kropotkin, **Ethics**, p. 317f] As such,
the state _"is a historic, transitory institution, a temporary form of
society"_ and one whose _"utter extinction"_ is possible as the _"State is not
society."_ [Bakunin, **Michael Bakunin: Selected Writings**, p. 151]

In summary, the state is a specific way in which human affairs are organised
in a given area, a way marked by certain institutions which, in turn, have
certain characteristics. This does not imply, however, that the state is a
monolithic entity that has been the same from its birth to the present day.
States vary in many ways, especially in their degree of authoritarianism, in
the size and power of their bureaucracy and how they organise themselves. Thus
we have monarchies, oligarchies, theocracies, party dictatorships and (more or
less) democratic states. We have ancient states, with minimal bureaucracy, and
modern ones, with enormous bureaucracy.

Moreover, anarchists argue that _"the **political** regime . . . is always an
expression of the **economic** regime which exists at the heart of society."_
This means that regardless of how the state changes, it _"continues to be
shaped by the economic system, of which it is always the expression and, at
the same time, the consecration and the sustaining force."_ Needless to say,
there is not always an exact match and sometimes _"the political regime of a
country finds itself lagging behind the economic changes that are taking
place, and in that case it will abruptly be set aside and remodelled in a way
appropriate to the economic regime that has been established."_ [Kropotkin,
**Words of a Rebel**, p. 118]

At other times, the state can change its form to protect the economic system
it is an expression of. Thus we see democracies turn to dictatorships in the
face of popular revolts and movements. The most obvious examples of Pinochet's
Chile, Franco's Spain, Mussolini's Italy and Hitler's Germany are all striking
confirmations of Bakunin's comment that while _"[n]o government could serve
the economic interests of the bourgeoisie better than a republic,"_ that class
would _"prefer . . . military dictatorship"_ if needed to crush _"the revolts
of the proletariat."_ [**Bakunin on Anarchism**, p. 417]

However, as much as the state may change its form it still has certain
characteristics which identify a social institution as a state. As such, we
can say that, for anarchists, the state is marked by three things:

       1) A _**"monopoly of violence"**_ in a given territorial area;
2) This violence having a _"professional,"_ institutional nature; and
3) A hierarchical nature, centralisation of power and initiative into the
hands of a few.

Of these three aspects, the last one (its centralised, hierarchical nature) is
the most important simply because the concentration of power into the hands of
the few ensures a division of society into government and governed (which
necessitates the creation of a professional body to enforce that division).
Hence we find Bakunin arguing that _"[w]ith the State there must go also . . .
all organisation of social life from the top downward, via legislation and
government."_ [**The Political Philosophy of Bakunin**, p. 242] In other
words, _"the people was not governing itself."_ [Kropotkin, **Op. Cit.**, p.
120]

This aspect implies the rest. In a state, all the people residing in an area
are subject to the state, submitting themselves to the individuals who make up
the institution of authority ruling that territory. To enforce the will of
this few, they must have a monopoly of force within the territory. As the
members of the state collectively monopolise political decision making power,
they are a privileged body separated by its position and status from the rest
of the population as a whole which means they cannot rely on them to enforce
its will. This necessities a professional body of some kind to enforce their
decisions, a separate police force or army rather than the people armed.

Given this, the division of society into rulers and ruled is the key to what
constitutes a state. Without such a division, we would not need a monopoly of
violence and so would simply have an association of equals, unmarked by power
and hierarchy (such as exists in many stateless "primitive" tribes and will
exist in a future anarchist society). And, it must be stressed, such a
division exists even in democratic states as _"with the state there is always
a hierarchical and status difference between rulers and ruled. Even if it is a
democracy, where we suppose those who rule today are not rulers tomorrow,
there are still differences in status. In a democratic system, only a tiny
minority will ever have the opportunity to rule and these are invariably drawn
from the elite."_ [Harold Barclay, **The State**, pp. 23-4]

Thus, the _"essence of government"_ is that _"it is a thing apart, developing
its own interests"_ and so is _"an institution existing for its own sake,
preying upon the people, and teaching them whatever will tend to keep it
secure in its seat."_ [Voltairine de Cleyre, **The Voltairine de Cleyre
Reader**, p. 27 and p. 26] And so _"despotism resides not so much in the
**form** of the State or power as in the very **principle** of the State and
political power."_ [Bakunin, **Op. Cit.**, p. 211]

As the state is the delegation of power into the hands of the few, it is
obviously based on hierarchy. This delegation of power results in the elected
people becoming isolated from the mass of people who elected them and outside
of their control (see [section B.2.4](secB2.md#secb24)). In addition, as
those elected are given power over a host of different issues and told to
decide upon them, a bureaucracy soon develops around them to aid in their
decision-making and enforce those decisions once they have been reached.
However, this bureaucracy, due to its control of information and its
permanency, soon has more power than the elected officials. Therefore _"a
highly complex state machine . . . leads to the formation of a class
especially concerned with state management, which, using its acquired
experience, begins to deceive the rest for its personal advantage."_
[Kropotkin, **Selected Writings on Anarchism and Revolution**, p. 61] This
means that those who serve the people's (so-called) servant have more power
than those they serve, just as the politician has more power than those who
elected him. All forms of state-like (i.e. hierarchical) organisations
inevitably spawn a bureaucracy about them. This bureaucracy soon becomes the
de facto focal point of power in the structure, regardless of the official
rules.

This marginalisation and disempowerment of ordinary people (and so the
empowerment of a bureaucracy) is the key reason for anarchist opposition to
the state. Such an arrangement ensures that the individual is disempowered,
subject to bureaucratic, authoritarian rule which reduces the person to an
object or a number, **not** a unique individual with hopes, dreams, thoughts
and feelings. As Proudhon forcefully argued:

> _ "To be GOVERNED is to be kept in sight, inspected, spied upon, directed,
law-driven, numbered, enrolled, indoctrinated, preached at, controlled,
estimated, valued, censured, commanded, by creatures who have neither the
right, nor the wisdom, nor the virtue to do so . . . To be GOVERNED is to be
at every operation, at every transaction, noted, registered, enrolled, taxed,
stamped, measured, numbered, assessed, licensed, authorised, admonished,
forbidden, reformed, corrected, punished. It is, under the pretext of public
utility, and in the name of the general interest, to be placed under
contribution, trained, ransomed, exploited, monopolised, extorted, squeezed,
mystified, robbed; then, at the slightest resistance, the first word of
complaint, to be repressed, fined, despised, harassed, tracked, abused,
clubbed, disarmed, choked, imprisoned, judged, condemned, shot, deported,
sacrificed, sold, betrayed; and, to crown it all, mocked, ridiculed, outraged,
dishonoured. That is government; that is its justice; that is its morality."_
[**General Idea of the Revolution**, p. 294]

Such is the nature of the state that **any** act, no matter how evil, becomes
good if it helps forward the interests of the state and the minorities it
protects. As Bakunin put it:

> _ "**The State . . . is the most flagrant, the most cynical, and the most
complete negation of humanity.** It shatters the universal solidarity of all
men [and women] on the earth, and brings some of them into association only
for the purpose of destroying, conquering, and enslaving all the rest . . .  
>  _

>

> _"This flagrant negation of humanity which constitutes the very essence of
the State is, from the standpoint of the State, its supreme duty and its
greatest virtue . . . Thus, to offend, to oppress, to despoil, to plunder, to
assassinate or enslave one's fellowman [or woman] is ordinarily regarded as a
crime. In public life, on the other hand, from the standpoint of patriotism,
when these things are done for the greater glory of the State, for the
preservation or the extension of its power, it is all transformed into duty
and virtue. And this virtue, this duty, are obligatory for each patriotic
citizen; everyone if supposed to exercise them not against foreigners only but
against one's own fellow citizens . . . whenever the welfare of the State
demands it. _

>

> _"This explains why, since the birth of the State, the world of politics has
always been and continues to be the stage for unlimited rascality and
brigandage . . . This explains why the entire history of ancient and modern
states is merely a series of revolting crimes; why kings and ministers, past
and present, of all times and all countries -- statesmen, diplomats,
bureaucrats, and warriors -- if judged from the standpoint of simply morality
and human justice, have a hundred, a thousand times over earned their sentence
to hard labour or to the gallows. There is no horror, no cruelty, sacrilege,
or perjury, no imposture, no infamous transaction, no cynical robbery, no bold
plunder or shabby betrayal that has not been or is not daily being perpetrated
by the representatives of the states, under no other pretext than those
elastic words, so convenient and yet so terrible: '**for reasons of
state.**'"_ [**Bakunin on Anarchism**, pp. 133-4]

Governments habitually lie to the people they claim to represent in order to
justify wars, reductions (if not the destruction) of civil liberties and human
rights, policies which benefit the few over the many, and other crimes. And if
its subjects protest, the state will happily use whatever force deemed
necessary to bring the rebels back in line (labelling such repression "law and
order"). Such repression includes the use of death squads, the
institutionalisation of torture, collective punishments, indefinite
imprisonment, and other horrors at the worse extremes.

Little wonder the state usually spends so much time ensuring the
(mis)education of its population -- only by obscuring (when not hiding) its
actual practises can it ensure the allegiance of those subject to it. The
history of the state could be viewed as nothing more than the attempts of its
subjects to control it and bind it to the standards people apply to
themselves.

Such behaviour is not surprising, given that Anarchists see the state, with
its vast scope and control of deadly force, as the "ultimate" hierarchical
structure, suffering from all the negative characteristics associated with
authority described in the [last section](secB1.md). _"Any loical and
straightforward theory of the State,"_ argued Bakunin, _"is essentially
founded upon the principle of **authority**, that is the eminently
theological, metaphysical, and political idea that the masses, **always**
incapable of governing themselves, must at all times submit to the beneficent
yoke of a wisdom and a justice imposed upon them, in some way or other, from
above."_ [**Bakunin on Anarchism**, p. 142] Such a system of authority cannot
help being centralised, hierarchical and bureaucratic in nature. And because
of its centralised, hierarchical, and bureaucratic nature, the state becomes a
great weight over society, restricting its growth and development and making
popular control impossible. As Bakunin put it:

> _ "the so-called general interests of society supposedly represented by the
State . . . [are] in reality . . . the general and permanent negation of the
positive interests of the regions, communes, and associations, and a vast
number of individuals subordinated to the State . . . [in which] all the best
aspirations, all the living forces of a country, are sanctimoniously immolated
and interred."_ [**The Political Philosophy of Bakunin**, p. 207]

That is by no means the end of it. As well as its obvious hierarchical form,
anarchists object to the state for another, equally important, reason. This is
its role as a defender of the economically dominant class in society against
the rest of it (i.e. from the working class). This means, under the current
system, the capitalists _"need the state to legalise their methods of robbery,
to protect the capitalist system."_ [Berkman, **What is Anarchism?**, p. 16]
The state, as we discuss in [section B.2.1](secB2.md#secb21), is the
defender of private property (see [section B.3](secB3.md) for a discussion
of what anarchists mean by that term and how it differs from individual
possessions).

This means that in capitalist states the mechanisms of state domination are
controlled by and for a corporate elite (and hence the large corporations are
often considered to belong to a wider _"state-complex"_). Indeed, as we
discuss in more depth in [section F.8](secF8.md), the _"State has been, and
still is, the main pillar and the creator, direct and indirect, of Capitalism
and its powers over the masses."_ [Kropotkin, **Evolution and Environment**,
p. 97] [Section B.2.3](secB2.md#secb23) indicates how this is domination is
achieved in a representative democracy.

However this does not mean anarchists think that the state is purely an
instrument of economic class rule. As Malatesta argued, while _"a special
class (government) which, provided with the necessary means of repression,
exists to legalise and protect the owning class from the demands of the
workers . . . it uses the powers at its disposal to create privileges for
itself and to subject, if it can, the owning class itself as well."_ [**Errico
Malatesta: His Life and Ideas**, p. 183] Thus the state has interests of its
own, distinct from and sometimes in opposition to the economic ruling elite.
This means that both state **and** capitalism needs to be abolished, for the
former is as much a distinct (and oppressive and exploitative) class as the
former. This aspects of the state is discussed in [section
B.2.6](secB2.md#secb26).

As part of its role as defender of capitalism, the state is involved in not
only in political domination but also in economic domination. This domination
can take different forms, varying from simply maintaining capitalist property
rights to actually owning workplaces and exploiting labour directly. Thus
every state intervenes in the economy in some manner. While this is usually to
favour the economically dominant, it can also occur try and mitigate the anti-
social nature of the capitalist market and regulate its worse abuses. We
discuss this aspect of the state in [section B.2.2](secB2.md#secb22).

Needless to say, the characteristics which mark a state did not develop by
chance. As we discuss in [section H.3.7](secH3.md#sech37), anarchists have
an evolutionary perspective on the state. This means that it has a
hierarchical nature in order to facilitate the execution of its role, its
function. As sections [B.2.4](secB2.md#secb24) and
[B.2.5](secB2.md#secb25) indicate, the centralisation that marks a state is
required to secure elite rule and was deliberately and actively created to do
so. This means that states, by their very nature, are top-down institutions
which centralise power into a few hands and, as a consequence, a state _"with
its traditions, its hierarchy, and its narrow nationalism"_ can _"not be
utilised as an instrument of emancipation."_ [Kropotkon, **Evolution and
Environment**, p. 78] It is for this reason that anarchists aim to create a
new form of social organisation and life, a decentralised one based on
decision making from the bottom-up and the elimination of hierarchy.

Finally, we must point out that anarchists, while stressing what states have
in common, do recognise that some forms of the state are better than others.
Democracies, for example, tend to be less oppressive than dictatorships or
monarchies. As such it would be false to conclude that anarchists, _"in
criticising the democratic government we thereby show our preference for the
monarchy. We are firmly convinced that the most imperfect republic is a
thousand times better than the most enlightened monarchy."_ [Bakunin,
**Bakunin on Anarchism**, p. 144] However, this does not change the nature or
role of the state. Indeed, what liberties we have are **not** dependent on the
goodwill of the state but rather the result of people standing against it and
exercising their autonomy. Left to itself, the state would soon turn the
liberties and rights it says it defends into dead-laws -- things that look
good in print but not practised in real life.

So in the rest of this section we will discuss the state, its role, its impact
on a society's freedom and who benefits from its existence. Kropotkin's
classic essay, **The State: It's Historic Role** is recommended for further
reading on this subject. Harold Barclay's **The State** is a good overview of
the origins of the state, how it has changed over the millenniums and the
nature of the modern state.

  

## B.2.1 What is main function of the state?

The main function of the state is to guarantee the existing social
relationships and their sources within a given society through centralised
power and a monopoly of violence. To use Malatesta's words, the state is
basically _"the property owners' **gendarme.**"_ This is because there are
_"two ways of oppressing men [and women]: either directly by brute force, by
physical violence; or indirectly by denying them the means of life and thus
reducing them to a state of surrender."_ The owning class, _"gradually
concentrating in their hands the means of production, the real sources of
life, agriculture, industry, barter, etc., end up establishing their own power
which, by reason of the superiority of its means . . . always ends by more or
less openly subjecting the political power, which is the government, and
making it into its own **gendarme.**"_ [**Op. Cit.**, p. 23, p. 21 and p. 22]

The state, therefore, is _"the political expression of the economic
structure"_ of society and, therefore, _"the representative of the people who
own or control the wealth of the community and the oppressor of the people who
do the work which creates the wealth."_ [Nicholas Walter, **About Anarchism**,
p. 37] It is therefore no exaggeration to say that the state is the extractive
apparatus of society's parasites.

The state ensures the exploitative privileges of its ruling elite by
protecting certain economic monopolies from which its members derive their
wealth. The nature of these economic privileges varies over time. Under the
current system, this means defending capitalist property rights (see [section
B.3.2](secB3.md#secb32)). This service is referred to as "protecting private
property" and is said to be one of the two main functions of the state, the
other being to ensure that individuals are "secure in their persons." However,
although this second aim is professed, in reality most state laws and
institutions are concerned with the protection of property (for the anarchist
definition of "property" see [section B.3.1](secB3.md#secb31)).

From this we may infer that references to the "security of persons," "crime
prevention," etc., are mostly rationalisations of the state's existence and
smokescreens for its perpetuation of elite power and privileges. This does not
mean that the state does not address these issues. Of course it does, but, to
quote Kropotkin, any _"laws developed from the nucleus of customs useful to
human communities . . . have been turned to account by rulers to sanctify
their own domination." of the people, and maintained only by the fear of
punishment."_ [**Anarchism**, p. 215]

Simply put, if the state _"presented nothing but a collection of prescriptions
serviceable to rulers, it would find some difficulty in insuring acceptance
and obedience"_ and so the law reflects customs "essential to the very being
of society" but these are _"cleverly intermingled with usages imposed by the
ruling caste and both claim equal respect from the crowd."_ Thus the state's
laws have a _"two-fold character."_ While its _"origin is the desire of the
ruling class to give permanence to customs imposed by themselves for their own
advantage"_ it also passes into law _"customs useful to society, customs which
have no need of law to insure respect"_ \-- unlike those _"other customs
useful only to rulers, injurious to the mass of the people, and maintained
only by the fear of punishment."_ [Kropotkin, **Op. Cit.**, pp. 205-6] To use
an obvious example, we find the state using the defence of an individual's
possessions as the rationale for imposing capitalist private property rights
upon the general public and, consequently, defending the elite and the source
of its wealth and power against those subject to it.

Moreover, even though the state does take a secondary interest in protecting
the security of persons (particularly elite persons), the vast majority of
crimes against persons are motivated by poverty and alienation due to state-
supported exploitation and also by the desensitisation to violence created by
the state's own violent methods of protecting private property. In other
words, the state rationalises its existence by pointing to the social evils it
itself helps to create (either directly or indirectly). Hence, anarchists
maintain that without the state and the crime-engendering conditions to which
it gives rise, it would be possible for decentralised, voluntary community
associations to deal compassionately (not punitively) with the few
incorrigibly violent people who might remain (see [section
I.5.8](secI5.md#seci58)).

Anarchists think it is pretty clear what the real role of the modern state is.
It represents the essential coercive mechanisms by which capitalism and the
authority relations associated with private property are sustained. The
protection of property is fundamentally the means of assuring the social
domination of owners over non-owners, both in society as a whole and in the
particular case of a specific boss over a specific group of workers. Class
domination is the authority of property owners over those who use that
property and it is the primary function of the state to uphold that domination
(and the social relationships that generate it). In Kropotkin's words, _"the
rich perfectly well know that if the machinery of the State ceased to protect
them, their power over the labouring classes would be gone immediately."_
[**Evolution and Environment**, p. 98] Protecting private property and
upholding class domination are the same thing.

The historian Charles Beard makes a similar point:

> _ "Inasmuch as the primary object of a government, beyond mere repression of
physical violence, is the making of the rules which determine the property
relations of members of society, the dominant classes whose rights are thus to
be protected must perforce obtain from the government such rules as are
consonant with the larger interests necessary to the continuance of their
economic processes, or they must themselves control the organs of
government."_ ["An Economic Interpretation of the Constitution," quoted by
Howard Zinn, **Op. Cit.**, p. 89]

This role of the state -- to protect capitalism and the property, power and
authority of the property owner -- was also noticed by Adam Smith:

> _"[T]he inequality of fortune . . . introduces among men a degree of
authority and subordination which could not possibly exist before. It thereby
introduces some degree of that civil government which is indispensably
necessary for its own preservation . . . [and] to maintain and secure that
authority and subordination. The rich, in particular, are necessarily
interested to support that order of things which can alone secure them in the
possession of their own advantages. Men of inferior wealth combine to defend
those of superior wealth in the possession of their property, in order that
men of superior wealth may combine to defend them in the possession of theirs
. . . [T]he maintenance of their lesser authority depends upon that of his
greater authority, and that upon their subordination to him depends his power
of keeping their inferiors in subordination to them. They constitute a sort of
little nobility, who feel themselves interested to defend the property and to
support the authority of their own little sovereign in order that he may be
able to defend their property and to support their authority. Civil
government, so far as it is instituted for the security of property, is in
reality instituted for the defence of the rich against the poor, or of those
who have some property against those who have none at all."_ [**The Wealth of
Nations**, book 5, pp. 412-3]

This is reflected in both the theory and history of the modern state.
Theorists of the liberal state like John Locke had no qualms about developing
a theory of the state which placed the defence of private property at its
heart. This perspective was reflected in the American Revolution. For example,
there is the words of John Jay (the first chief justice of the Supreme Court),
namely that _"the people who own the country ought to govern it."_ [quoted by
Noam Chomksy, **Understanding Power**, p. 315] This was the maxim of the
Founding Fathers of American _"democracy"_ and it has continued ever since.

So, in a nutshell, the state is the means by which the ruling class rules.
Hence Bakunin:

> _ "The State is authority, domination, and force, organised by the property-
owning and so-called enlightened classes against the masses . . . the State's
domination . . . [ensures] that of the privileged classes who it solely
represents."_ [**The Basic Bakunin**, p. 140]

Under the current system, this means that the state _"constitutes the chief
bulwark of capital"_ because of its _"centralisation, law (always written by a
minority in the interest of that minority), and courts of justice (established
mainly for the defence of authority and capital)."_ Thus it is _"the mission
of all governments . . . is to protect and maintain by force the . . .
privileges of the possessing classes."_ Consequently, while _"[i]n the
struggle between the individual and the State, anarchism . . . takes the side
of the individual as against the State, of society against the authority which
oppresses it,"_ anarchists are well aware that the state does not exist above
society, independent of the classes which make it up. [Kropotkin,
**Anarchism**, pp. 149-50, p. 214 and pp. 192-3]

Consequently anarchists reject the idea that the role of the state is simply
to represent the interests of the people or "the nation." For _"democracy is
an empty pretence to the extent that production, finance and commerce -- and
along with them, the political processes of the society as well -- are under
control of 'concentrations of private power.' The 'national interest' as
articulated by those who dominate the . . . societies will be their special
interests. Under these circumstances, talk of 'national interest' can only
contribute to mystification and oppression."_ [Noam Chomsky, **Radical
Priorities**, p. 52] As we discuss in [section D.6](secD6.md), nationalism
always reflects the interests of the elite, not those who make up a nation
and, consequently, anarchists reject the notion as nothing more than a con
(i.e. the use of affection of where you live to further ruling class aims and
power).

Indeed, part of the state's role as defender of the ruling elite is to do so
internationally, defending "national" (i.e. elite) interests against the
elites of other nations. Thus we find that at the IMF and World Bank, nations
are represented by ministers who are _"closely aligned with particular
constituents **within** their countries. The trade ministers reflect the
concerns of the business community"_ while the _"finance ministers and central
bank governors are closely tied to financial community; they come from
financial firms, and after their period in service, that is where they return
. . . These individuals see the world through the eyes of the financial
community."_ Unsurprisingly, the _"decisions of any institution naturally
reflect the perspectives and interests of those who make the decisions"_ and
so the _"policies of the international economic institutions are all too often
closely aligned with the commercial and financial interests of those in the
advanced industrial countries."_ [Joseph Stiglitz, **Globalisation and its
Discontents**, pp. 19-20]

This, it must be stressed, does not change in the so-called democratic state.
Here, however, the primary function of the state is disguised by the
"democratic" facade of the representative electoral system, through which it
is made to appear that the people rule themselves. Thus Bakunin writes that
the modern state _"unites in itself the two conditions necessary for the
prosperity of the capitalistic economy: State centralisation and the actual
subjection of . . . the people . . . to the minority allegedly representing it
but actually governing it."_ [**Op. Cit.**, p. 210] How this is achieved is
discussed in [section B.2.3](secB2.md#secb23).

  

## B.2.2 Does the state have subsidiary functions?

Yes, it does. While, as discussed in the [last section](secB2.md#secb21),
the state is an instrument to maintain class rule this does not mean that it
is limited to just defending the social relationships in a society and the
economic and political sources of those relationships. No state has ever left
its activities at that bare minimum. As well as defending the rich, their
property and the specific forms of property rights they favoured, the state
has numerous other subsidiary functions.

What these are has varied considerably over time and space and, consequently,
it would be impossible to list them all. However, **why** it does is more
straight forward. We can generalise two main forms of subsidiary functions of
the state. The first one is to boost the interests of the ruling elite either
nationally or internationally beyond just defending their property. The second
is to protect society against the negative effects of the capitalist market.
We will discuss each in turn and, for simplicity and relevance, we will
concentrate on capitalism (see also [section D.1](secD1.md)).

The first main subsidiary function of the state is when it intervenes in
society to help the capitalist class in some way. This can take obvious forms
of intervention, such as subsidies, tax breaks, non-bid government contracts,
protective tariffs to old, inefficient, industries, giving actual monopolies
to certain firms or individuals, bailouts of corporations judged by state
bureaucrats as too important to let fail, and so on. However, the state
intervenes far more than that and in more subtle ways. Usually it does so to
solve problems that arise in the course of capitalist development and which
cannot, in general, be left to the market (at least initially). These are
designed to benefit the capitalist class as a whole rather than just specific
individuals, companies or sectors.

These interventions have taken different forms in different times and include
state funding for industry (e.g. military spending); the creation of social
infrastructure too expensive for private capital to provide (railways,
motorways); the funding of research that companies cannot afford to undertake;
protective tariffs to protect developing industries from more efficient
international competition (the key to successful industrialisation as it
allows capitalists to rip-off consumers, making them rich and increasing funds
available for investment); giving capitalists preferential access to land and
other natural resources; providing education to the general public that
ensures they have the skills and attitude required by capitalists and the
state (it is no accident that a key thing learned in school is how to survive
boredom, being in a hierarchy and to do what it orders); imperialist ventures
to create colonies or client states (or protect citizen's capital invested
abroad) in order to create markets or get access to raw materials and cheap
labour; government spending to stimulate consumer demand in the face of
recession and stagnation; maintaining a "natural" level of unemployment that
can be used to discipline the working class, so ensuring they produce more,
for less; manipulating the interest rate in order to try and reduce the
effects of the business cycle and undermine workers' gains in the class
struggle.

These actions, and others like it, ensures that a key role of the state within
capitalism _"is essentially to socialise risk and cost, and to privatise power
and profit."_ Unsurprisingly, _"with all the talk about minimising the state,
in the OECD countries the state continues to grow relative to GNP."_ [Noam
Chomsky, **Rogue States**, p. 189] Hence David Deleon:

> _ "Above all, the state remains an institution for the continuance of
dominant socioeconomic relations, whether through such agencies as the
military, the courts, politics or the police . . . Contemporary states have
acquired . . . less primitive means to reinforce their property systems [than
state violence -- which is always the means of last, often first, resort].
States can regulate, moderate or resolve tensions in the economy by preventing
the bankruptcies of key corporations, manipulating the economy through
interest rates, supporting hierarchical ideology through tax benefits for
churches and schools, and other tactics. In essence, it is not a neutral
institution; it is powerfully for the status quo. The capitalist state, for
example, is virtually a gyroscope centred in capital, balancing the system. If
one sector of the economy earns a level of profit, let us say, that harms the
rest of the system -- such as oil producers' causing public resentment and
increased manufacturing costs -- the state may redistribute some of that
profit through taxation, or offer encouragement to competitors."_ [_"Anarchism
on the origins and functions of the state: some basic notes"_, **Reinventing
Anarchy**, pp. 71-72]

In other words, the state acts to protect the long-term interests of the
capitalist class as a whole (and ensure its own survival) by protecting the
system. This role can and does clash with the interests of particular
capitalists or even whole sections of the ruling class (see [section
B.2.6](secB2.md#secb26)). But this conflict does not change the role of the
state as the property owners' policeman. Indeed, the state can be considered
as a means for settling (in a peaceful and apparently independent manner)
upper-class disputes over what to do to keep the system going.

This subsidiary role, it must be stressed, is no accident, It is part and
parcel capitalism. Indeed, _"successful industrial societies have consistently
relied on departures from market orthodoxies, while condemning their victims
[at home and abroad] to market discipline."_ [Noam Chomsky, **World Orders,
Old and New**, p. 113] While such state intervention grew greatly after the
Second World War, the role of the state as active promoter of the capitalist
class rather than just its passive defender as implied in capitalist ideology
(i.e. as defender of property) has always been a feature of the system. As
Kropotkin put it:

> _ "every State reduces the peasants and the industrial workers to a life of
misery, by means of taxes, and through the monopolies it creates in favour of
the landlords, the cotton lords, the railway magnates, the publicans, and the
like . . . we need only to look round, to see how everywhere in Europe and
America the States are constituting monopolies in favour of capitalists at
home, and still more in conquered lands [which are part of their empires]."_
[**Evolution and Environment**, p. 97]

By _"monopolies,"_ it should be noted, Kropotkin meant general privileges and
benefits rather than giving a certain firm total control over a market. This
continues to this day by such means as, for example, privatising industries
but providing them with state subsidies or by (mis-labelled) "free trade"
agreements which impose protectionist measures such as intellectual property
rights on the world market.

All this means that capitalism has rarely relied on purely economic power to
keep the capitalists in their social position of dominance (either nationally,
vis-à-vis the working class, or internationally, vis-à-vis competing foreign
elites). While a "free market" capitalist regime in which the state reduces
its intervention to simply protecting capitalist property rights has been
approximated on a few occasions, this is not the standard state of the system
-- direct force, i.e. state action, almost always supplements it.

This is most obviously the case during the birth of capitalist production.
Then the bourgeoisie wants and uses the power of the state to "regulate" wages
(i.e. to keep them down to such levels as to maximise profits and force people
attend work regularly), to lengthen the working day and to keep the labourer
dependent on wage labour as their own means of income (by such means as
enclosing land, enforcing property rights on unoccupied land, and so forth).
As capitalism is not and has never been a "natural" development in society, it
is not surprising that more and more state intervention is required to keep it
going (and if even this was not the case, if force was essential to creating
the system in the first place, the fact that it latter can survive without
further direct intervention does not make the system any less statist). As
such, "regulation" and other forms of state intervention continue to be used
in order to skew the market in favour of the rich and so force working people
to sell their labour on the bosses terms.

This form of state intervention is designed to prevent those greater evils
which might threaten the efficiency of a capitalist economy or the social and
economic position of the bosses. It is designed not to provide positive
benefits for those subject to the elite (although this may be a side-effect).
Which brings us to the other kind of state intervention, the attempts by
society, by means of the state, to protect itself against the eroding effects
of the capitalist market system.

Capitalism is an inherently anti-social system. By trying to treat labour
(people) and land (the environment) as commodities, it has to break down
communities and weaken eco-systems. This cannot but harm those subject to it
and, as a consequence, this leads to pressure on government to intervene to
mitigate the most damaging effects of unrestrained capitalism. Therefore, on
one side there is the historical movement of the market, a movement that has
not inherent limit and that therefore threatens society's very existence. On
the other there is society's natural propensity to defend itself, and
therefore to create institutions for its protection. Combine this with a
desire for justice on behalf of the oppressed along with opposition to the
worse inequalities and abuses of power and wealth and we have the potential
for the state to act to combat the worse excesses of the system in order to
keep the system as a whole going. After all, the government _"cannot want
society to break up, for it would mean that it and the dominant class would be
deprived of the sources of exploitation."_ [Malatesta, **Op. Cit.**, p. 25]

Needless to say, the thrust for any system of social protection usually comes
from below, from the people most directly affected by the negative effects of
capitalism. In the face of mass protests the state may be used to grant
concessions to the working class in cases where not doing so would threaten
the integrity of the system as a whole. Thus, social struggle is the dynamic
for understanding many, if not all, of the subsidiary functions acquired by
the state over the years (this applies to pro-capitalist functions as these
are usually driven by the need to bolster the profits and power of capitalists
at the expense of the working class).

State legislation to set the length of the working day is an obvious example
this. In the early period of capitalist development, the economic position of
the capitalists was secure and, consequently, the state happily ignored the
lengthening working day, thus allowing capitalists to appropriate more surplus
value from workers and increase the rate of profit without interference.
Whatever protests erupted were handled by troops. Later, however, after
workers began to organise on a wider and wider scale, reducing the length of
the working day became a key demand around which revolutionary socialist
fervour was developing. In order to defuse this threat (and socialist
revolution is the worst-case scenario for the capitalist), the state passed
legislation to reduce the length of the working day.

Initially, the state was functioning purely as the protector of the capitalist
class, using its powers simply to defend the property of the few against the
many who used it (i.e. repressing the labour movement to allow the capitalists
to do as they liked). In the second period, the state was granting concessions
to the working class to eliminate a threat to the integrity of the system as a
whole. Needless to say, once workers' struggle calmed down and their
bargaining position reduced by the normal workings of market (see [section
B.4.3](secB4.md#secb43)), the legislation restricting the working day was
happily ignored and became "dead laws."

This suggests that there is a continuing tension and conflict between the
efforts to establish, maintain, and spread the "free market" and the efforts
to protect people and society from the consequences of its workings. Who wins
this conflict depends on the relative strength of those involved (as does the
actual reforms agreed to). Ultimately, what the state concedes, it can also
take back. Thus the rise and fall of the welfare state -- granted to stop more
revolutionary change (see [section D.1.3](secD1.md#secd13)), it did not
fundamentally challenge the existence of wage labour and was useful as a means
of regulating capitalism but was "reformed" (i.e. made worse, rather than
better) when it conflicted with the needs of the capitalist economy and the
ruling elite felt strong enough to do so.

Of course, this form of state intervention does not change the nature nor role
of the state as an instrument of minority power. Indeed, that nature cannot
help but shape how the state tries to implement social protection and so if
the state assumes functions it does so as much in the immediate interest of
the capitalist class as in the interest of society in general. Even where it
takes action under pressure from the general population or to try and mend the
harm done by the capitalist market, its class and hierarchical character
twists the results in ways useful primarily to the capitalist class or itself.
This can be seen from how labour legislation is applied, for example. Thus
even the "good" functions of the state are penetrated with and dominated by
the state's hierarchical nature. As Malatesta forcefully put it:

> _ "The basic function of government . . . is always that of oppressing and
exploiting the masses, of defending the oppressors and the exploiters . . . It
is true that to these basic functions . . . other functions have been added in
the course of history . . . hardly ever has a government existed . . . which
did not combine with its oppressive and plundering activities others which
were useful . . . to social life. But this does not detract from the fact that
government is by nature oppressive . . . and that it is in origin and by its
attitude, inevitably inclined to defend and strengthen the dominant class;
indeed it confirms and aggravates the position . . . [I]t is enough to
understand how and why it carries out these functions to find the practical
evidence that whatever governments do is always motivated by the desire to
dominate, and is always geared to defending, extending and perpetuating its
privileges and those of the class of which it is both the representative and
defender."_ [**Op. Cit.**, pp. 23-4]

This does not mean that these reforms should be abolished (the alternative is
often worse, as neo-liberalism shows), it simply recognises that the state is
not a neutral body and cannot be expected to act as if it were. Which,
ironically, indicates another aspect of social protection reforms within
capitalism: they make for good PR. By appearing to care for the interests of
those harmed by capitalism, the state can obscure it real nature:

> _ "A government cannot maintain itself for long without hiding its true
nature behind a pretence of general usefulness; it cannot impose respect for
the lives of the privileged if it does not appear to demand respect for all
human life; it cannot impose acceptance of the privileges of the few if it
does not pretend to be the guardian of the rights of all."_ [Malatesta, **Op.
Cit.**, p. 24]

Obviously, being an instrument of the ruling elite, the state can hardly be
relied upon to control the system which that elite run. As we discuss in the
[next section](secB2.md#secb23), even in a democracy the state is run and
controlled by the wealthy making it unlikely that pro-people legislation will
be introduced or enforced without substantial popular pressure. That is why
anarchists favour direct action and extra-parliamentary organising (see
sections [J.2](secJ2.md) and [J.5](secJ5.md) for details). Ultimately,
even basic civil liberties and rights are the product of direct action, of
_"mass movements among the people"_ to _"wrest these rights from the ruling
classes, who would never have consented to them voluntarily."_ [Rocker,
**Anarcho-Syndicalism**, p. 75]

Equally obviously, the ruling elite and its defenders hate any legislation it
does not favour -- while, of course, remaining silent on its own use of the
state. As Benjamin Tucker pointed out about the "free market" capitalist
Herbert Spencer, _"amid his multitudinous illustrations . . . of the evils of
legislation, he in every instance cites some law passed ostensibly at least to
protect labour, alleviating suffering, or promote the people's welfare. . .
But never once does he call attention to the far more deadly and deep-seated
evils growing out of the innumerable laws creating privilege and sustaining
monopoly."_ [**The Individualist Anarchists**, p. 45] Such hypocrisy is
staggering, but all too common in the ranks of supporters of "free market"
capitalism.

Finally, it must be stressed that none of these subsidiary functions implies
that capitalism can be changed through a series of piecemeal reforms into a
benevolent system that primarily serves working class interests. To the
contrary, these functions grow out of, and supplement, the basic role of the
state as the protector of capitalist property and the social relations they
generate -- i.e. the foundation of the capitalist's ability to exploit.
Therefore reforms may modify the functioning of capitalism but they can never
threaten its basis.

In summary, while the level and nature of statist intervention on behalf of
the employing classes may vary, it is always there. No matter what activity it
conducts beyond its primary function of protecting private property, what
subsidiary functions it takes on, the state always operates as an instrument
of the ruling class. This applies even to those subsidiary functions which
have been imposed on the state by the general public -- even the most popular
reform will be twisted to benefit the state or capital, if at all possible.
This is not to dismiss all attempts at reform as irrelevant, it simply means
recognising that we, the oppressed, need to rely on our own strength and
organisations to improve our circumstances.

  

## B.2.3 How does the ruling class maintain control of the state?

In some systems, it is obvious how economic dominant minorities control the
state. In feudalism, for example, the land was owned by the feudal lords who
exploited the peasantry directly. Economic and political power were merged
into the same set of hands, the landlords. Absolutism saw the monarch bring
the feudal lords under his power and the relative decentralised nature of
feudalism was replaced by a centralised state.

It was this centralised state system which the raising bourgeoisie took as the
model for their state. The King was replaced by a Parliament, which was
initially elected on a limited suffrage. In this initial form of capitalist
state, it is (again) obvious how the elite maintain control of the state
machine. As the vote was based on having a minimum amount of property, the
poor were effectively barred from having any (official) say in what the
government did. This exclusion was theorised by philosophers like John Locke
-- the working masses were considered to be an object of state policy rather
than part of the body of people (property owners) who nominated the
government. In this perspective the state was like a joint-stock company. The
owning class were the share-holders who nominated the broad of directors and
the mass of the population were the workers who had no say in determining the
management personnel and were expected to follow orders.

As would be expected, this system was mightily disliked by the majority who
were subjected to it. Such a "classical liberal" regime was rule by an alien,
despotic power, lacking popular legitimacy, and utterly unaccountable to the
general population. It is quite evident that a government elected on a limited
franchise could not be trusted to treat those who owned no real property with
equal consideration. It was predictable that the ruling elite would use the
state they controlled to further their own interests and to weaken potential
resistance to their social, economic and political power. Which is precisely
what they did do, while masking their power under the guise of "good
governance" and "liberty." Moreover, limited suffrage, like absolutism, was
considered an affront to liberty and individual dignity by many of those
subject to it.

Hence the call for universal suffrage and opposition to property
qualifications for the franchise. For many radicals (including Marx and
Engels) such a system would mean that the working classes would hold
_"political power"_ and, consequently, be in a position to end the class
system once and for all. Anarchists were not convinced, arguing that
_"universal suffrage, considered in itself and applied in a society based on
economic and social inequality, will be nothing but a swindle and snare for
the people"_ and _"the surest way to consolidate under the mantle of
liberalism and justice the permanent domination of the people by the owning
classes, to the detriment of popular liberty."_ Consequently, anarchists
denied that it _"could be used by the people for the conquest of economic and
social equality. It must always and necessarily be an instrument hostile to
the people, one which supports the **de facto** dictatorship of the
bourgeoisie."_ [Bakunin, **Bakunin on Anarchism**, p. 224]

Due to popular mass movements form below, the vote was won by the male working
classes and, at a later stage, women. While the elite fought long and hard to
retain their privileged position they were defeated. Sadly, the history of
universal suffrage proven the anarchists right. Even allegedly _"democratic"_
capitalist states are in effect dictatorships of the propertariat. The
political history of modern times can be summarised by the rise of capitalist
power, the rise, due to popular movements, of (representative) democracy and
the continued success of the former to undermine and control the latter.

This is achieved by three main processes which combine to effectively deter
democracy. These are the wealth barrier, the bureaucracy barrier and, lastly,
the capital barrier. Each will be discussed in turn and all ensure that
_"representative democracy"_ remains an _"organ of capitalist domination."_
[Kropotkin, **Words of a Rebel**, p. 127]

The wealth barrier is the most obvious. It takes money to run for office. In
1976, the total spent on the US Presidential election was $66.9 million. In
1984, it was $103.6 million and in 1996 it was $239.9 million. At the dawn of
the 21st century, these figures had increased yet again. 2000 saw $343.1 spent
and 2004, $717.9 million. Most of this money was spent by the two main
candidates. In 2000, Republican George Bush spent a massive $185,921,855 while
his Democratic rival Al Gore spent only $120,031,205. Four years later, Bush
spent $345,259,155 while John Kerry managed a mere $310,033,347.

Other election campaigns are also enormously expensive. In 2000, the average
winning candidate for a seat in the US House of Representatives spent $816,000
while the average willing senator spent $7 million. Even local races require
significant amounts of fundraising. One candidate for the Illinois House
raised over $650,000 while another candidate for the Illinois Supreme Court
raised $737,000. In the UK, similarly prohibitive amounts were spent. In the
2001 general election the Labour Party spent a total of £10,945,119, the
Tories £12,751,813 and the Liberal Democrats (who came a distant third) just
£1,361,377.

To get this sort of money, wealthy contributors need to be found and wooed, in
other words promised that that their interests will be actively looked after.
While, in theory, it is possible to raise large sums from small contributions
in practice this is difficult. To raise $1 million you need to either convince
50 millionaires to give you $20,000 or 20,000 people to fork out $50. Given
that for the elite $20,000 is pocket money, it is hardly surprising that
politicians aim for winning over the few, not the many. Similarly with
corporations and big business. It is far easier and more efficient in time and
energy to concentrate on the wealthy few (whether individuals or companies).

It is obvious: whoever pays the piper calls the tune. And in capitalism, this
means the wealthy and business. In the US corporate campaign donations and
policy paybacks have reached unprecedented proportions. The vast majority of
large campaign donations are, not surprisingly, from corporations. Most of the
wealthy individuals who give large donations to the candidates are CEOs and
corporate board members. And, just to be sure, many companies give to more
than one party.

Unsurprisingly, corporations and the rich expect their investments to get a
return. This can be seen from George W. Bush's administration. His election
campaigns were beholden to the energy industry (which has backed him since the
beginning of his career as Governor of Texas). The disgraced corporation Enron
(and its CEO Kenneth Lay) were among Bush's largest contributors in 2000. Once
in power, Bush backed numerous policies favourable to that industry (such as
rolling back environmental regulation on a national level as he had done in
Texas). His supporters in Wall Street were not surprised that Bush tried to
privatise Social Security. Nor were the credit card companies when the
Republicans tighten the noose on bankrupt people in 2005. By funding Bush,
these corporations ensured that the government furthered their interests
rather than the people who voted in the election.

This means that as a _"consequence of the distribution of resources and
decision-making power in the society at large . . . the political class and
the cultural managers typically associate themselves with the sectors that
dominate the private economy; they are either drawn directly from those
sectors or expect to join them."_ [Chomsky, **Necessary Illusions**, p. 23]
This can be seen from George W. Bush's quip at an elite fund-raising gala
during the 2000 Presidential election: _"This is an impressive crowd -- the
haves and the have-mores. Some people call you the elites; I call you my
base."_ Unsurprisingly:

> _ "In the real world, state policy is largely determined by those groups
that command resources, ultimately by virtue of their ownership and management
of the private economy or their status as wealthy professionals. The major
decision-making positions in the Executive branch of the government are
typically filled by representatives of major corporations, banks and
investment firms, a few law firms that cater primarily to corporate interests
and thus represent the broad interests of owners and managers rather than some
parochial interest . . . The Legislative branch is more varied, but
overwhelmingly, it is drawn from the business and professional classes."_
[Chomsky, **On Power and Ideology**, pp. 116-7]

That is not the only tie between politics and business. Many politicians also
have directorships in companies, interests in companies, shares, land and
other forms of property income and so forth. Thus they are less like the
majority of constituents they claim to represent and more like the wealthy
few. Combine these outside earnings with a high salary (in the UK, MP's are
paid more than twice the national average) and politicians can be among the
richest 1% of the population. Thus not only do we have a sharing of common
interests the elite, the politicians are part of it. As such, they can hardly
be said to be representative of the general public and are in a position of
having a vested interest in legislation on property being voted on.

Some defend these second jobs and outside investments by saying that it keeps
them in touch with the outside world and, consequently, makes them better
politicians. That such an argument is spurious can be seen from the fact that
such outside interests never involve working in McDonald's flipping burgers or
working on an assembly line. For some reason, no politician seeks to get a
feeling for what life is like for the average person. Yet, in a sense, this
argument **does** have a point. Such jobs and income do keep politicians in
touch with the world of the elite rather than that of the masses and, as the
task of the state is to protect elite interests, it cannot be denied that this
sharing of interests and income with the elite can only aid that task!

Then there is the sad process by which politicians, once they leave politics,
get jobs in the corporate hierarchy (particularly with the very companies they
had previously claimed to regulate on behalf of the public). This was termed
"the revolving door." Incredibly, this has changed for the worse. Now the
highest of government officials arrive directly from the executive offices of
powerful corporations. Lobbyists are appointed to the jobs whose occupants
they once vied to influence. Those who regulate and those supposed to be
regulated have become almost indistinguishable.

Thus politicians and capitalists go hand in hand. Wealth selects them, funds
them and gives them jobs and income when in office. Finally, once they finally
leave politics, they are often given directorships and other jobs in the
business world. Little wonder, then, that the capitalist class maintains
control of the state.

That is not all. The wealth barrier operates indirectly to. This takes many
forms. The most obvious is in the ability of corporations and the elite to
lobby politicians. In the US, there is the pervasive power of Washington's
army of 24,000 registered lobbyists -- and the influence of the corporate
interests they represent. These lobbyists, whose job it is to convince
politicians to vote in certain ways to further the interests of their
corporate clients help shape the political agenda even further toward business
interests than it already is. This Lobby industry is immense -- and
exclusively for big business and the elite. Wealth ensures that the equal
opportunity to garner resources to share a perspective and influence the
political progress is monopolised by the few: _"where are the desperately
needed countervailing lobbies to represent the interests of average citizens?
Where are the millions of dollars acting in **their** interests? Alas, they
are notably absent."_ [Joel Bakan, **The Corporation**, p. 107]

However, it cannot be denied that it is up to the general population to vote
for politicians. This is when the indirect impact of wealth kicks in, namely
the role of the media and the Public Relations (PR) industry. As we discuss in
[section D.3](secD3.md), the modern media is dominated by big business and,
unsurprisingly, reflects their interests. This means that the media has an
important impact on how voters see parties and specific politicians and
candidates. A radical party will, at best, be ignored by the capitalist press
or, at worse, subject to smears and attacks. This will have a corresponding
negative impact on their election prospects and will involve the affected
party having to invest substantially more time, energy and resources in
countering the negative media coverage. The PR industry has a similar effect,
although that has the advantage of not having to bother with appearing to look
factual or unbiased. Add to this the impact of elite and corporation funded
_"think tanks"_ and the political system is fatally skewed in favour of the
capitalist class (also see [section D.2](secD2.md)).

In a nutshell:

> _ "The business class dominates government through its ability to fund
political campaigns, purchase high priced lobbyists and reward former
officials with lucrative jobs . . . [Politicians] have become wholly dependent
upon the same corporate dollars to pay for a new professional class of PR
consultants, marketeers and social scientists who manage and promote causes
and candidates in essentially the same manner that advertising campaigns sell
cars, fashions, drugs and other wares."_ [John Stauber and Sheldon Rampton,
**Toxic Sludge is Good for You**, p. 78]

That is the first barrier, the direct and indirect impact of wealth. This, in
itself, is a powerful barrier to deter democracy and, as a consequence, it is
usually sufficient in itself. Yet sometimes people see through the media
distortions and vote for reformist, even radical, candidates. As we discuss in
[section J.2.6](secJ2.md#secj26), anarchists argue that the net effect of
running for office is a general **de**-radicalising of the party involved.
Revolutionary parties become reformist, reformist parties end up maintaining
capitalism and introducing polities the opposite of which they had promised.
So while it is unlikely that a radical party could get elected and remain
radical in the process, it is possible. If such a party did get into office,
the remaining two barriers kicks in: the bureaucracy barrier and the capital
barrier.

The existence of a state bureaucracy is a key feature in ensuring that the
state remains the ruling class's _"policeman"_ and will be discussed in
greater detail in section J.2.2 ([Why do anarchists reject voting as a means
for change?](secJ2.md#secj22)). Suffice to say, the politicians who are
elected to office are at a disadvantage as regards the state bureaucracy. The
latter is a permanent concentration of power while the former come and go.
Consequently, they are in a position to tame any rebel government by means of
bureaucratic inertia, distorting and hiding necessary information and pushing
its own agenda onto the politicians who are in theory their bosses but in
reality dependent on the bureaucracy. And, needless to say, if all else fails
the state bureaucracy can play its final hand: the military coup.

This threat has been applied in many countries, most obviously in the
developing world (with the aid of Western, usually US, imperialism). The coups
in Iran (1953) and Chile (1973) are just two examples of this process. Yet the
so-called developed world is not immune to it. The rise of fascism in Italy,
Germany, Portugal and Spain can be considered as variations of a military coup
(particularly the last one where fascism was imposed by the military). Wealthy
business men funded para-military forces to break the back of the labour
movement, forces formed by ex-military people. Even the New Deal in America
was threatened by such a coup. [Joel Bakan, **Op. Cit.**, pp. 86-95] While
such regimes do protect the interests of capital and are, consequently, backed
by it, they do hold problems for capitalism. This is because, as with the
Absolutism which fostered capitalism in the first place, this kind of
government can get ideas above its station This means that a military coup
will only be used when the last barrier, the capital barrier, is used and
fails.

The capital barrier is obviously related to the wealth barrier insofar as it
relates to the power that great wealth produces. However, it is different in
how it is applied. The wealth barrier restricts who gets into office, the
capital barrier controls whoever does so. The capital barrier, in other words,
are the economic forces that can be brought to bear on any government which is
acting in ways disliked of by the capitalist class.

We see their power implied when the news report that changes in government,
policies and law have been _"welcomed by the markets."_ As the richest 1% of
households in America (about 2 million adults) owned 35% of the stock owned by
individuals in 1992 -- with the top 10% owning over 81% -- we can see that the
_"opinion"_ of the markets actually means the power of the richest 1-5% of a
countries population (and their finance experts), power derived from their
control over investment and production. Given that the bottom 90% of the US
population has a smaller share (23%) of all kinds of investable capital that
the richest 1/2% (who own 29%), with stock ownership being even more
concentrated (the top 5% holding 95% of all shares), its obvious why Doug
Henwood argues that stock markets are _"a way for the very rich as a class to
own an economy's productive capital stock as a whole,"_ are a source of
_"political power"_ and a way to have influence over government policy.
[**Wall Street: Class Racket**]

The mechanism is simple enough. The ability of capital to disinvest (capital
flight) and otherwise adversely impact the economy is a powerful weapon to
keep the state as its servant. The companies and the elite can invest at home
or abroad, speculate in currency markets and so forth. If a significant number
of investors or corporations lose confidence in a government they will simply
stop investing at home and move their funds abroad. At home, the general
population feel the results as demand drops, layoffs increase and recession
kicks in. As Noam Chomsky notes:

> _ "In capitalist democracy, the interests that must be satisfied are those
of capitalists; otherwise, there is no investment, no production, no work, no
resources to be devoted, however marginally, to the needs of the general
population."_ [**Turning the Tide**, p. 233]

This ensures the elite control of government as government policies which
private power finds unwelcome will quickly be reversed. The power which
"business confidence" has over the political system ensures that democracy is
subservient to big business. As summarised by Malatesta:

> _ "Even with universal suffrage -- we could well say even more so with
universal suffrage -- the government remained the bourgeoisie's servant and
**gendarme.** For were it to be otherwise with the government hinting that it
might take up a hostile attitude, or that democracy could ever be anything but
a pretence to deceive the people, the bourgeoisie, feeling its interests
threatened, would by quick to react, and would use all the influence and force
at its disposal, by reason of its wealth, to recall the government to its
proper place as the bourgeoisie's **gendarme.**"_ [**Anarchy**, p. 23]

It is due to these barriers that the state remains an instrument of the
capitalist class while being, in theory, a democracy. Thus the state machine
remains a tool by which the few can enrich themselves at the expense of the
many. This does not mean, of course, that the state is immune to popular
pressure. Far from it. As indicated in the [last section](secB2.md#secb22),
direct action by the oppressed can and has forced the state to implement
significant reforms. Similarly, the need to defend society against the
negative effects of unregulated capitalism can also force through populist
measures (particularly when the alternative may be worse than the allowing the
reforms, i.e. revolution). The key is that such changes are **not** the
natural function of the state.

So due to their economic assets, the elites whose incomes are derived from
them -- namely, finance capitalists, industrial capitalists, and landlords --
are able to accumulate vast wealth from those whom they exploit. This
stratifies society into a hierarchy of economic classes, with a huge disparity
of wealth between the small property-owning elite at the top and the non-
property-owning majority at the bottom. Then, because it takes enormous wealth
to win elections and lobby or bribe legislators, the propertied elite are able
to control the political process -- and hence the state -- through the _"power
of the purse."_ In summary:

> _ "No democracy has freed itself from the rule by the well-to-do anymore
than it has freed itself from the division between the ruler and the ruled . .
. at the very least, no democracy has jeopardised the role of business
enterprise. Only the wealthy and well off can afford to launch viable
campaigns for public office and to assume such positions. Change in government
in a democracy is a circulation from one elite group to another."_ [Harold
Barclay, **Op. Cit.**, p. 47]

In other words, elite control of politics through huge wealth disparities
insures the continuation of such disparities and thus the continuation of
elite control. In this way the crucial political decisions of those at the top
are insulated from significant influence by those at the bottom. Finally, it
should be noted that these barriers do not arise accidentally. They flow from
the way the state is structured. By effectively disempowering the masses and
centralising power into the hands of the few which make up the government, the
very nature of the state ensures that it remains under elite control. This is
why, from the start, the capitalist class has favoured centralisation. We
discuss this in the next two sections.

(For more on the ruling elite and its relation to the state, see C. Wright
Mills, **The Power Elite** [Oxford, 1956]; cf. Ralph Miliband, **The State in
Capitalist Society** [Basic Books, 1969] and **Divided Societies** [Oxford,
1989]; G. William Domhoff, **Who Rules America?** [Prentice Hall, 1967]; and
**Who Rules America Now? A View for the '80s** [Touchstone, 1983]).

## B.2.4 How does state centralisation affect freedom?

It is a common idea that voting every four or so years to elect the public
face of a highly centralised and bureaucratic machine means that ordinary
people control the state and, as a consequence, free. In reality, this is a
false idea. In any system of centralised power the general population have
little say in what affects them and, as a result, their freedom is extremely
limited.

Obviously, to say that this idea is false does not imply that there is no
difference between a liberal republic and a fascistic or monarchical state.
Far from it. The vote is an important victory wrested from the powers that be.
That, of course, is not to suggest that anarchists think that libertarian
socialism is only possible after universal suffrage has been won or that it is
achievable via it. Far from it. It is simply to point out that being able to
pick your ruler is a step forward from having one imposed upon you. Moreover,
those considered able to pick their ruler is, logically, also able to do
without one.

However, while the people are proclaimed to be sovereign in a democratic
state, in reality they alienate their power and hand over control of their
affairs to a small minority. Liberty, in other words, is reduced to merely the
possibility _"to pick rulers"_ every four or five years and whose mandate
(sic!) is _"to legislate on any subject, and his decision will become law."_
[Kropotkin, **Words of a Rebel**, p. 122 and p. 123]

In other words, representative democracy is not "liberty" nor "self-
government." It is about alienating power to a few people who then (mis)rule
in your name. To imply it is anything else is nonsense. So while we get to
pick a politician to govern in our name it does not follow that they represent
those who voted for them in any meaningful sense. As shown time and time
again, "representative" governments can happily ignore the opinions of the
majority while, at the same time, verbally praising the "democracy" it is
abusing (New Labour in the UK during the run up to the invasion of Iraq was a
classic example of this). Given that politicians can do what they like for
four or five years once elected, it is clear that popular control via the
ballot box is hardly effective or even meaningful.

Indeed, such "democracy" almost always means electing politicians who say one
thing in opposition and do the opposite once in office. Politicians who, at
best, ignore their election manifesto when it suits them or, at worse,
introduce the exact opposite. It is the kind of "democracy" in which people
can protest in their hundreds of thousands against a policy only to see their
"representative" government simply ignore them (while, at the same time,
seeing their representatives bend over backward ensuring corporate profits and
power while speaking platitudes to the electorate and their need to tighten
their belts). At best it can be said that democratic governments tend to be
less oppressive than others but it does not follow that this equates to
liberty.

State centralisation is the means to ensure this situation and the debasement
of freedom it implies.

All forms of hierarchy, even those in which the top officers are elected are
marked by authoritarianism and centralism. Power is concentrated in the centre
(or at the top), which means that society becomes _"a heap of dust animated
from without by a subordinating, centralist idea."_ [P. J. Proudhon, quoted by
Martin Buber, **Paths in Utopia**, p. 29] For, once elected, top officers can
do as they please, and, as in all bureaucracies, many important decisions are
made by non-elected staff. This means that the democratic state is a
contradiction in terms:

> _ "In the democratic state the election of rulers by alleged majority vote
is a subterfuge which helps individuals to believe that they control the
situation. They are selecting persons to do a task for them and they have no
guarantee that it will be carried out as they desired. They are abdicating to
these persons, granting them the right to impose their own wills by the threat
of force. Electing individuals to public office is like being given a limited
choice of your oppressors . . . Parliamentary democracies are essentially
oligarchies in which the populace is led to believe that it delegates all its
authority to members of parliament to do as they think best."_ [Harold
Barclay, **Op. Cit.**, pp. 46-7]

The nature of centralisation places power into the hands of the few.
Representative democracy is based on this delegation of power, with voters
electing others to govern them. This cannot help but create a situation in
which freedom is endangered -- universal suffrage _"does not prevent the
formation of a body of politicians, privileged in fact though not in law, who,
devoting themselves exclusively to the administration of the nation's public
affairs, end by becoming a sort of political aristocracy or oligarchy."_
[Bakunin, **The Political Philosophy of Bakunin**, p. 240]

This should not come as a surprise, for to _"create a state is to
institutionalise power in a form of machine that exists **apart** from the
people. It is to professionalise rule and policy making, to create a distinct
interest (be it of bureaucrats, deputies, commissars, legislators, the
military, the police, ad nauseam) that, however weak or however well-
intentioned it may be at first, eventually takes on a corruptive power of its
own."_ [Murray Bookchin, _"The Ecological Crisis, Socialism, and the need to
remake society,"_ pp. 1-10, **Society and Nature**, vol. 2, no. 3, p. 7]

Centralism makes democracy meaningless, as political decision-making is given
over to professional politicians in remote capitals. Lacking local autonomy,
people are isolated from each other (atomised) by having no political forum
where they can come together to discuss, debate, and decide among themselves
the issues they consider important. Elections are not based on natural,
decentralised groupings and thus cease to be relevant. The individual is just
another "voter" in the mass, a political "constituent" and nothing more. The
amorphous basis of modern, statist elections _"aims at nothing less than to
abolish political life in towns, communes and departments, and through this
destruction of all municipal and regional autonomy to arrest the development
of universal suffrage."_ [Proudhon, quoted by Martin Buber, **Op. Cit.**, p.
29]

Thus people are disempowered by the very structures that claim to allow them
to express themselves. To quote Proudhon again, in the centralised state _"the
citizen divests himself of sovereignty, the town and the Department and
province above it, absorbed by central authority, are no longer anything but
agencies under direct ministerial control."_ He continues:

> _ "The Consequences soon make themselves felt: the citizen and the town are
deprived of all dignity, the state's depredations multiply, and the burden on
the taxpayer increases in proportion. It is no longer the government that is
made for the people; it is the people who are made for the government. Power
invades everything, dominates everything, absorbs everything."_ [**The
Principle of Federation**, p. 59]

As intended, as isolated people are no threat to the powers that be. This
process of marginalisation can be seen from American history, for example,
when town meetings were replaced by elected bodies, with the citizens being
placed in passive, spectator roles as mere "voters" (see [next
section](secB2.md#secb25)). Being an atomised voter is hardly an ideal
notion of "freedom," despite the rhetoric of politicians about the virtues of
a "free society" and "The Free World" -- as if voting once every four or five
years could ever be classed as "liberty" or even "democracy."

Marginalisation of the people is the key control mechanism in the state and
authoritarian organisations in general. Considering the European Community
(EC), for example, we find that the _"mechanism for decision-making between EC
states leaves power in the hands of officials (from Interior ministries,
police, immigration, customs and security services) through a myriad of
working groups. Senior officials . . . play a critical role in ensuring
agreements between the different state officials. The EC Summit meetings,
comprising the 12 Prime Ministers, simply rubber-stamp the conclusions agreed
by the Interior and Justice Ministers. It is only then, in this
intergovernmental process, that parliaments and people are informed (and them
only with the barest details)."_ [Tony Bunyon, **Statewatching the New
Europe**, p. 39]

As well as economic pressures from elites, governments also face pressures
within the state itself due to the bureaucracy that comes with centralism.
There is a difference between the state and government. The state is the
permanent collection of institutions that have entrenched power structures and
interests. The government is made up of various politicians. It's the
institutions that have power in the state due to their permanence, not the
representatives who come and go. As Clive Ponting (an ex-civil servant
himself) indicates, _"the function of a political system in any country . . .
is to regulate, but not to alter radically, the existing economic structure
and its linked power relationships. The great illusion of politics is that
politicians have the ability to make whatever changes they like."_ [quoted in
**Alternatives**, no.5, p. 19]

Therefore, as well as marginalising the people, the state also ends up
marginalising "our" representatives. As power rests not in the elected bodies,
but in a bureaucracy, popular control becomes increasingly meaningless. As
Bakunin pointed out, _"liberty can be valid only when . . . [popular] control
[of the state] is valid. On the contrary, where such control is fictitious,
this freedom of the people likewise becomes a mere fiction."_ [**Op. Cit.**,
p. 212] State centralisation ensures that popular control is meaningless.

This means that state centralism can become a serious source of danger to the
liberty and well-being of most of the people under it. _"The bourgeois
republicans,"_ argued Bakunin, _"do not yet grasp this simple truth,
demonstrated by the experience of all times and in all lands, that every
organised power standing above and over the people necessarily excludes the
freedom of peoples. The political state has no other purpose than to protect
and perpetuate the exploitation of the labour of the proletariat by the
economically dominant classes, and in so doing the state places itself against
the freedom of the people."_ [**Bakunin on Anarchism**, p. 416]

Unsurprisingly, therefore, _"whatever progress that has been made . . . on
various issues, whatever things have been done for people, whatever human
rights have been gained, have not been gained through the calm deliberations
of Congress or the wisdom of presidents or the ingenious decisions of the
Supreme Court. Whatever progress has been made . . . has come because of the
actions of ordinary people, of citizens, of social movements. Not from the
Constitution."_ That document has been happily ignored by the official of the
state when it suits them. An obvious example is the 14th Amendment of the US
Constitution, which _"didn't have any meaning until black people rose up in
the 1950s and 1960s in the South in mass movements . . . They made whatever
words there were in the Constitution and the 14th Amendment have some meaning
for the first time."_ [Howard Zinn, **Failure to Quit**, p. 69 and p. 73]

This is because the _"fact that you have got a constitutional right doesn't
mean you're going to get that right. Who has the power on the spot? The
policeman on the street. The principal in the school. The employer on job. The
Constitution does not cover private employment. In other words, the
Constitution does not cover most of reality."_ Thus our liberty is not
determined by the laws of the state. Rather _"the source and solution of our
civil liberties problems are in the situations of every day . . . Our actual
freedom is determined not by the Constitution or the Court, but by the power
the policeman has over us on the street or that of the local judge behind him;
by the authority of our employers; . . . by the welfare bureaucrats if we are
poor; . . . by landlords if we are tenants."_ Thus freedom and justice _"are
determined by power and money"_ rather than laws. This points to the
importance of popular participation, of social movements, for what those do
are _"to create a countervailing power to the policeman with a club and a gun.
That's essentially what movements do: They create countervailing powers to
counter the power which is much more important than what is written down in
the Constitution or the laws."_ [Zinn, **Op. Cit.**, pp. 84-5, pp. 54-5 and p.
79]

It is precisely this kind of mass participation that centralisation kills.
Under centralism, social concern and power are taken away from ordinary
citizens and centralised in the hands of the few. This results in any formally
guaranteed liberties being effectively ignored when people want to use them,
if the powers at be so decide. Ultimately, isolated individuals facing the
might of a centralised state machine are in a weak position. Which is way the
state does what it can to undermine such popular movements and organisations
(going so far as to violate its own laws to do so).

As should be obvious, by centralisation anarchists do not mean simply a
territorial centralisation of power in a specific central location (such as in
a nation state where power rests in a central government located in a specific
place). We also mean the centralisation of **power** into a few hands. Thus we
can have a system like feudalism which is territorially decentralised (i.e.
made up on numerous feudal lords without a strong central state) while having
power centralised in a few hands locally (i.e. power rests in the hands of the
feudal lords, not in the general population). Or, to use another example, we
can have a laissez-faire capitalist system which has a weak central authority
but is made up of a multitude of autocratic workplaces. As such, getting rid
of the central power (say the central state in capitalism or the monarch in
absolutism) while retaining the local authoritarian institutions (say
capitalist firms and feudal landlords) would not ensure freedom. Equally, the
abolition of local authorities may simply result in the strengthening of
central power and a corresponding weakening of freedom.

## B.2.5 Who benefits from centralisation?

No social system would exist unless it benefited someone or some group.
Centralisation, be it in the state or the company, is no different. In all
cases, centralisation directly benefits those at the top, because it shelters
them from those who are below, allowing the latter to be controlled and
governed more effectively. Therefore, it is in the direct interests of
bureaucrats and politicians to support centralism.

Under capitalism, however, various sections of the business class also support
state centralism. This is the symbiotic relationship between capital and the
state. As will be discussed later (in [section F.8](secF8.md)), the state
played an important role in "nationalising" the market, i.e. forcing the "free
market" onto society. By centralising power in the hands of representatives
and so creating a state bureaucracy, ordinary people were disempowered and
thus became less likely to interfere with the interests of the wealthy. _"In a
republic,"_ writes Bakunin, _"the so-called people, the legal people,
allegedly represented by the State, stifle and will keep on stifling the
actual and living people"_ by _"the bureaucratic world"_ for _"the greater
benefit of the privileged propertied classes as well as for its own benefit."_
[**Op. Cit.**, p. 211]

Examples of increased political centralisation being promoted by wealthy
business interests by can be seen throughout the history of capitalism. _"In
revolutionary America, 'the nature of city government came in for heated
discussion,' observes Merril Jensen . . . Town meetings . . . 'had been a
focal point of revolutionary activity'. The anti-democratic reaction that set
in after the American revolution was marked by efforts to do away with town
meeting government . . . Attempts by conservative elements were made to
establish a 'corporate form (of municipal government) whereby the towns would
be governed by mayors and councils' elected from urban wards . . . [T]he
merchants 'backed incorporation consistently in their efforts to escape town
meetings.'"_ [Murray Bookchin, **Towards an Ecological Society**, p. 182]

Here we see local policy making being taken out of the hands of the many and
centralised in the hands of the few (who are always the wealthy). France
provides another example:

> _ "The Government found. . .the folkmotes [of all households] 'too noisy',
too disobedient, and in 1787, elected councils, composed of a mayor and three
to six syndics, chosen among the wealthier peasants, were introduced
instead."_ [Peter Kropotkin, **Mutual Aid**, pp. 185-186]

This was part of a general movement to disempower the working class by
centralising decision making power into the hands of the few (as in the
American revolution). Kropotkin indicates the process at work:

> _ "[T]he middle classes, who had until then had sought the support of the
people, in order to obtain constitutional laws and to dominate the higher
nobility, were going, now that they had seen and felt the strength of the
people, to do all they could to dominate the people, to disarm them and to
drive them back into subjection.  
>  _

>

> _[. . .] _

>

> _"[T]hey made haste to legislate in such a way that the political power
which was slipping out of the hand of the Court should not fall into the hands
of the people. Thus . . . [it was] proposed . . . to divide the French into
two classes, of which one only, the **active** citizens, should take part in
the government, whilst the other, comprising the great mass of the people
under the name of **passive** citizens, should be deprived of all political
rights . . . [T]he [National] Assembly divided France into departments . . .
always maintaining the principle of excluding the poorer classes from the
Government . . . [T]hey excluded from the primary assemblies the mass of the
people . . . who could no longer take part in the primary assemblies, and
accordingly had no right to nominate the electors [who chose representatives
to the National Assembly], or the municipality, or any of the local
authorities . . . _

>

> _"And finally, the **permanence** of the electoral assemblies was
interdicted. Once the middle-class governors were appointed, these assemblies
were not to meet again. Once the middle-class governors were appointed, they
must not be controlled too strictly. Soon the right even of petitioning and of
passing resolutions was taken away -- 'Vote and hold your tongue!' _

>

> _"As to the villages . . . the general assembly of the inhabitants . . . [to
which] belonged the administration of the affairs of the commune . . . were
forbidden by the . . . law. Henceforth only the well-to-do peasants, the
**active** citizens, had the right to meet, **once a year**, to nominate the
mayor and the municipality, composed of three or four middle-class men of the
village. _

>

> _"A similar municipal organisation was given to the towns. . . _

>

> _"[Thus] the middle classes surrounded themselves with every precaution in
order to keep the municipal power in the hands of the well-to-do members of
the community."_ [**The Great French Revolution**, vol. 1, pp. 179-186]

Thus centralisation aimed to take power away from the mass of the people and
give it to the wealthy. The power of the people rested in popular assemblies,
such as the _"Sections"_ and _"Districts"_ of Paris (expressing, in
Kropotkin's words, _"the principles of anarchism"_ and _"practising . . .
Direct Self-Government"_ [**Op. Cit.**, p. 204 and p. 203]) and village
assemblies. However, the National Assembly _"tried all it could to lessen the
power of the districts . . . [and] put an end to those hotbeds of Revolution .
. . [by allowing] **active** citizens only . . . to take part in the electoral
and administrative assemblies."_ [**Op. Cit.**, p. 211] Thus the _"central
government was steadily endeavouring to subject the sections to its
authority"_ with the state _"seeking to centralise everything in its own hands
. . . [I]ts depriving the popular organisations . . . all . . . administrative
functions . . . and its subjecting them to its bureaucracy in police matters,
meant the death of the sections."_ [**Op. Cit.**, vol. 2, p. 549 and p. 552]

As can be seen, both the French and American revolutions saw a similar process
by which the wealthy centralised power into their own hands (volume one of
Murray Bookchin's **The Third Revolution** discusses the French and American
revolutions in some detail). This ensured that working class people (i.e. the
majority) were excluded from the decision making process and subject to the
laws and power of a few. Which, of course, benefits the minority class whose
representatives have that power. This was the rationale for the centralisation
of power in every revolution. Whether it was the American, French or Russian,
the centralisation of power was the means to exclude the many from
participating in the decisions that affected them and their communities.

For example, the founding fathers of the American State were quite explicit on
the need for centralisation for precisely this reason. For James Madison the
key worry was when the _"majority"_ gained control of _"popular government"_
and was in a position to _"sacrifice to its ruling passion or interest both
the public good and the rights of other citizens."_ Thus the _"public good"_
escaped the _"majority"_ nor was it, as you would think, what the public
thought of as good (for some reason left unexplained, Madison considered the
majority able to pick those who **could** identify the public good). To
safeguard against this, he advocated a republic rather than a democracy in
which the citizens _"assemble and administer the government in person . . .
have ever been found incompatible with personal security or the rights of
property."_ He, of course, took it for granted that _"[t]hose who hold and
those who are without property have ever formed distinct interests in
society."_ His schema was to ensure that private property was defended and, as
a consequence, the interests of those who held protected. Hence the need for
_"the delegation of the government . . . to a small number of citizens elected
by the rest."_ This centralisation of power into a few hands locally was
matched by a territorial centralisation for the same reason. Madison favoured
_"a large over a small republic"_ as a _"rage for paper money, for an
abolition of debts, for an equal division of property, or for any other
improper or wicked project, will be less apt to pervade the whole body of the
Union than a particular member of it."_ [contained in **Voices of a People's
History of the United States**, Howard Zinn and Anthony Arnove (eds.), pp.
109-113] This desire to have a formal democracy, where the masses are mere
spectators of events rather than participants, is a recurring theme in
capitalism (see the chapter _"Force and Opinion"_ in Noam Chomsky's
**Deterring Democracy** for a good overview).

On the federal and state levels in the US after the Revolution, centralisation
of power was encouraged, since _"most of the makers of the Constitution had
some direct economic interest in establishing a strong federal government."_
Needless to say, while the rich elite were well represented in formulating the
principles of the new order, four groups were not: _"slaves, indentured
servants, women, men without property."_ Needless to say, the new state and
its constitution did not reflect their interests. Given that these were the
vast majority, _"there was not only a positive need for strong central
government to protect the large economic interests, but also immediate fear of
rebellion by discontented farmers."_ [Howard Zinn, **A People's History of the
United States**, p. 90] The chief event was Shay's Rebellion in western
Massachusetts. There the new Constitution had raised property qualifications
for voting and, therefore, no one could hold state office without being
wealthy. The new state was formed to combat such rebellions, to protect the
wealthy few against the many.

Moreover, state centralisation, the exclusion of popular participation, was
essential to mould US society into one dominated by capitalism:

> _ "In the thirty years leading up to the Civil War, the law was increasingly
interpreted in the courts to suit capitalist development. Studying this,
Morton Horwitz (**The Transformation of American Law**) points out that the
English common-law was no longer holy when it stood in the way of business
growth . . . Judgements for damages against businessmen were taken out of the
hands of juries, which were unpredictable, and given to judges . . . The
ancient idea of a fair price for goods gave way in the courts to the idea of
caveat emptor (let the buyer beware) . . . contract law was intended to
discriminate against working people and for business . . . The pretence of the
law was that a worker and a railroad made a contract with equal bargaining
power . . . 'The circle was completed; the law had come simply to ratify those
forms of inequality that the market system had produced.'"_ [Zinn, **Op.
Cit.**, p. 234]

The US state was created on elitist liberal doctrine and actively aimed to
reduce democratic tendencies (in the name of "individual liberty"). What
happened in practice (unsurprisingly enough) was that the wealthy elite used
the state to undermine popular culture and common right in favour of
protecting and extending their own interests and power. In the process, US
society was reformed in their own image:

> _ "By the middle of the nineteenth century the legal system had been
reshaped to the advantage of men of commerce and industry at the expense of
farmers, workers, consumers, and other less powerful groups in society. . . it
actively promoted a legal distribution of wealth against the weakest groups in
society."_ [Morton Horwitz, quoted by Zinn, **Op. Cit.**, p. 235]

In more modern times, state centralisation and expansion has gone hand in
glove with rapid industrialisation and the growth of business. As Edward
Herman points out, _"[t]o a great extent, it was the growth in business size
and power that elicited the countervailing emergence of unions and the growth
of government. Bigness **beyond** business was to a large extent a response to
bigness **in** business."_ [**Corporate Control, Corporate Power**, p. 188 --
see also, Stephen Skowronek, **Building A New American State: The Expansion of
National Administrative Capacities, 1877-1920**] State centralisation was
required to produce bigger, well-defined markets and was supported by business
when it acted in their interests (i.e. as markets expanded, so did the state
in order to standardise and enforce property laws and so on). On the other
hand, this development towards "big government" created an environment in
which big business could grow (often encouraged by the state by subsidies and
protectionism - as would be expected when the state is run by the wealthy) as
well as further removing state power from influence by the masses and placing
it more firmly in the hands of the wealthy. It is little wonder we see such
developments, for _"[s]tructures of governance tend to coalesce around
domestic power, in the last few centuries, economic power."_ [Noam Chomsky,
**World Orders, Old and New**, p. 178]

State centralisation makes it easier for business to control government,
ensuring that it remains their puppet and to influence the political process.
For example, the European Round Table (ERT) _"an elite lobby group of . . .
chairmen or chief executives of large multi-nationals based mainly in the EU .
. . [with] 11 of the 20 largest European companies [with] combined sales [in
1991] . . . exceeding $500 billion, . . . approximately 60 per cent of EU
industrial production,"_ makes much use of the EU. As two researchers who have
studied this body note, the ERT _"is adept at lobbying . . . so that many ERT
proposals and 'visions' are mysteriously regurgitated in Commission summit
documents."_ The ERT _"claims that the labour market should be more
'flexible,' arguing for more flexible hours, seasonal contracts, job sharing
and part time work. In December 1993, seven years after the ERT made its
suggestions [and after most states had agreed to the Maastricht Treaty and its
"social chapter"], the European Commission published a white paper . . .
[proposing] making labour markets in Europe more flexible."_ [Doherty and
Hoedeman, _"Knights of the Road,"_ **New Statesman**, 4/11/94, p. 27]

The current talk of globalisation, NAFTA, and the Single European Market
indicates an underlying transformation in which state growth follows the path
cut by economic growth. Simply put, with the growth of transnational
corporations and global finance markets, the bounds of the nation-state have
been made economically redundant. As companies have expanded into multi-
nationals, so the pressure has mounted for states to follow suit and
rationalise their markets across _"nations"_ by creating multi-state
agreements and unions.

As Noam Chomsky notes, G7, the IMF, the World Bank and so forth are a _"de
facto world government,"_ and _"the institutions of the transnational state
largely serve other masters [than the people], as state power typically does;
in this case the rising transnational corporations in the domains of finance
and other services, manufacturing, media and communications."_ [**Op. Cit.**,
p. 179]

As multi-nationals grow and develop, breaking through national boundaries, a
corresponding growth in statism is required. Moreover, a _"particularly
valuable feature of the rising de facto governing institutions is their
immunity from popular influence, even awareness. They operate in secret,
creating a world subordinated to the needs of investors, with the public 'put
in its place', the threat of democracy reduced"_ [Chomsky, **Op. Cit.**, p.
178].

This does not mean that capitalists desire state centralisation for
everything. Often, particularly for social issues, relative decentralisation
is often preferred (i.e. power is given to local bureaucrats) in order to
increase business control over them. By devolving control to local areas, the
power which large corporations, investment firms and the like have over the
local government increases proportionally. In addition, even middle-sized
enterprise can join in and influence, constrain or directly control local
policies and set one workforce against another. Private power can ensure that
_"freedom"_ is safe, **their** freedom.

No matter which set of bureaucrats are selected, the need to centralise social
power, thus marginalising the population, is of prime importance to the
business class. It is also important to remember that capitalist opposition to
_"big government"_ is often financial, as the state feeds off the available
social surplus, so reducing the amount left for the market to distribute to
the various capitals in competition.

In reality, what capitalists object to about "big government" is its spending
on social programs designed to benefit the poor and working class, an
"illegitimate" function which "wastes" part of the surplus that might go to
capital (and also makes people less desperate and so less willing to work
cheaply). Hence the constant push to reduce the state to its "classical" role
as protector of private property and the system, and little else. Other than
their specious quarrel with the welfare state, capitalists are the staunchest
supports of government (and the "correct" form of state intervention, such as
defence spending), as evidenced by the fact that funds can always be found to
build more prisons and send troops abroad to advance ruling-class interests,
even as politicians are crying that there is "no money" in the treasury for
scholarships, national health care, or welfare for the poor.

State centralisation ensures that _"as much as the equalitarian principles
have been embodied in its political constitutions, it is the bourgeoisie that
governs, and it is the people, the workers, peasants included, who obey the
laws made by the bourgeoisie"_ who _"has in fact if not by right the exclusive
privilege of governing."_ This means that _"political equality . . . is only a
puerile fiction, an utter lie."_ It takes a great deal of faith to assume that
the rich, _"being so far removed from the people by the conditions of its
economic and social existence"_ can _"give expression in the government and in
the laws, to the feelings, the ideas, and the will of the people."_
Unsurprisingly, we find that _"in legislation as well as in carrying on the
government, the bourgeoisie is guided by its own interests and its own
instincts without concerning itself much with the interests of the people."_
So while _"on election days even the proudest bourgeois who have any political
ambitions are forced to court . . . The Sovereign People."_ But on the _"day
after the elections every one goes back to their daily business"_ and the
politicians are given carte blanche to rule in the name of the people they
claim to represent." [Bakunin, **The Political Philosophy of Bakunin**, p. 218
and p. 219]

## B.2.6 Can the state be an independent power within society?

Yes it can. Given the power of the state machine, it would be hard to believe
that it could always be simply a tool for the economically dominant minority
in a society. Given its structure and powers, it can use them to further its
own interests. Indeed, in some circumstances it can be the ruling class
itself.

However, in normal times the state is, as we discussed in [section
B.2.1](secB2.md#secb21), a tool of the capitalist class. This, it must be
stressed, does not mean that they always see _"eye to eye."_ Top politicians,
for example, are part of the ruling elite, but they are in competition with
other parts of it. In addition, different sectors of the capitalist class are
competing against each other for profits, political influence, privileges,
etc. The bourgeoisie, argued Malatesta, _"are always at war among themselves .
. . Thus the games of the swings, the manoeuvres, the concessions and
withdrawals, the attempts to find allies among the people against the
conservatives, and among the conservatives against the people."_ [**Anarchy**,
p. 25] This means that different sections of the ruling class will cluster
around different parties, depending on their interests, and these parties will
seek to gain power to further those interests. This may bring them into
conflict with other sections of the capitalist class. The state is the means
by which these conflicts can be resolved.

Given that the role of the state is to ensure the best conditions for capital
**as a whole,** this means that, when necessary, it can and does work against
the interests of certain parts of the capitalist class. To carry out this
function the state needs to be above individual capitalists or companies. This
is what can give the state the appearance of being a neutral social
institution and can fool people into thinking that it represents the interests
of society as a whole. Yet this sometime neutrality with regards to individual
capitalist companies exists only as an expression of its role as an instrument
of capital in general. Moreover, without the tax money from successful
businesses the state would be weakened and so the state is in competition with
capitalists for the surplus value produced by the working class. Hence the
anti-state rhetoric of big business which can fool those unaware of the hand-
in-glove nature of modern capitalism to the state.

As Chomsky notes:

> _ "There has always been a kind of love-hate relationship between business
interests and the capitalist state. On the one hand, business wants a powerful
state to regulate disorderly markets, provide services and subsidies to
business, enhance and protect access to foreign markets and resources, and so
on. On the other hand, business does not want a powerful competitor, in
particular, one that might respond to different interests, popular interests,
and conduct policies with a redistributive effect, with regard to income or
power."_ [**Turning the Tide**, p. 211]

As such, the state is often in conflict with sections of the capitalist class,
just as sections of that class use the state to advance their own interests
within the general framework of protecting the capitalist system (i.e. the
interests of the ruling class **as a class**). The state's role is to resolve
such disputes within that class peacefully. Under modern capitalism, this is
usually done via the _"democratic"_ process (within which we get the chance of
picking the representatives of the elite who will oppress us least).

Such conflicts sometimes give the impression of the state being a "neutral"
body, but this is an illusion -- it exists to defend class power and privilege
-- but exactly which class it defends can change. While recognising that the
state protects the power and position of the economically dominant class
within a society anarchists also argue that the state has, due to its
hierarchical nature, interests of its own. Thus it cannot be considered as
simply the tool of the economically dominant class in society. States have
their own dynamics, due to their structure, which generate their own classes
and class interests and privileges (and which allows them to escape from the
control of the economic ruling class and pursue their own interests, to a
greater or lesser degree). As Malatesta put it _"the government, though
springing from the bourgeoisie and its servant and protector, tends, as with
every servant and every protector, to achieve its own emancipation and to
dominate whoever it protects."_ [**Op. Cit.**, p. 25]

Thus, even in a class system like capitalism, the state can act independently
of the ruling elite and, potentially, act against their interests. As part of
its role is to mediate between individual capitalists/corporations, it needs
sufficient power to tame them and this requires the state to have some
independence from the class whose interests it, in general, defends. And such
independence can be used to further its own interests, even to the detriment
of the capitalist class, if the circumstances allow. If the capitalist class
is weak or divided then the state can be in a position to exercise its
autonomy vis-à-vis the economically dominant elite, using against the
capitalists as a whole the tools it usually applies to them individually to
further its own interests and powers.

This means that the state it not just _"the guardian of capital"_ for it _"has
a vitality of its own and constitutes . . . a veritable social class apart
from other classes . . . ; and this class has its own particular parasitical
and usurious interests, in conflict with those of the rest of the collectivity
which the State itself claims to represent . . . The State, being the
depository of society's greatest physical and material force, has too much
power in its hands to resign itself to being no more than the capitalists'
guard dog."_ [Luigi Fabbri, quoted by David Berry, **A History of the French
Anarchist Movement, 1917-1945**, p. 39]

Therefore the state machine (and structure), while its modern form is
intrinsically linked to capitalism, cannot be seen as being a tool usable by
the majority. This is because the _"State, any State -- even when it dresses-
up in the most liberal and democratic form -- is essentially based on
domination, and upon violence, that is upon despotism -- a concealed but no
less dangerous despotism."_ The State _"denotes power, authority, domination;
it presupposes inequality in fact."_ [**The Political Philosophy of Michael
Bakunin**, p. 211 and p. 240] The state, therefore, has its own specific
logic, its own priorities and its own momentum. It constitutes its own locus
of power which is not merely a derivative of economic class power.
Consequently, the state can be beyond the control of the economically dominant
class and it need not reflect economic relations.

This is due to its hierarchical and centralised nature, which empowers the few
who control the state machine -- _"[e]very state power, every government, by
its nature places itself outside and over the people and inevitably
subordinates them to an organisation and to aims which are foreign to and
opposed to the real needs and aspirations of the people."_ If _"the whole
proletariat . . . [are] members of the government . . . there will be no
government, no state, but, if there is to be a state there will be those who
are ruled and those who are slaves."_ [**Bakunin on Anarchism**, p. 328 and p.
330]

In other words, the state bureaucracy is itself directly an oppressor and can
exist independently of an economically dominant class. In Bakunin's prophetic
words:

> _ "What have we seen throughout history? The State has always been the
patrimony of some privileged class: the sacerdotal class, the nobility, the
bourgeoisie -- and finally, when all other classes have exhausted themselves,
the class of the bureaucracy enters the stage and then the State falls, or
rises, if you please, to the position of a machine."_ [**The Political
Philosophy of Michael Bakunin**, p. 208]

This is unsurprising. For anarchists, _"the State organisation . . . [is] the
force to which minorities resorted for establishing and organising their power
over the masses."_ It does not imply that these minorities need to be the
economically dominant class in a society. The state is _"a superstructure
built to the advantage of Landlordism, Capitalism, and Officialism."_
[**Evolution and Environment**, p. 82 and p. 105] Consequently, we cannot
assume that abolishing one or even two of this unholy trinity will result in
freedom nor that all three share exactly the same interests or power in
relation to the others. Thus, in some situations, the landlord class can
promote its interests over those of the capitalist class (and vice versa)
while the state bureaucracy can grow at the expense of both.

As such, it is important to stress that the minority whose interests the state
defends need not be an economically dominant one (although it usually is).
Under some circumstances a priesthood can be a ruling class, as can a military
group or a bureaucracy. This means that the state can also effectively
**replace** the economically dominant elite as the exploiting class. This is
because anarchists view the state as having (class) interests of its own.

As we discuss in more detail in [section H.3.9](secH3.md#sech39), the state
cannot be considered as merely an instrument of (economic) class rule. History
has shown numerous societies were the state **itself** was the ruling class
and where no other dominant economic class existed. The experience of Soviet
Russia indicates the validity of this analysis. The reality of the Russian
Revolution contrasted starkly with the Marxist claim that a state was simply
an instrument of class rule and, consequently, the working class needed to
build its own state within which to rule society. Rather than being an
instrument by which working class people could run and transform society in
their own interests, the new state created by the Russian Revolution soon
became a power over the class it claimed to represent (see [section
H.6](secH6.md) for more on this). The working class was exploited and
dominated by the new state and its bureaucracy rather than by the capitalist
class as previously. This did not happen by chance. As we discuss in [section
H.3.7](secH3.md#sech37), the state has evolved certain characteristics (such
as centralisation, delegated power and so on) which ensure its task as
enforcer of minority rule is achieved. Keeping those characteristics will
inevitably mean keeping the task they were created to serve.

Thus, to summarise, the state's role is to repress the individual and the
working class as a whole in the interests of economically dominant
minorities/classes and in its own interests. It is _"a society for mutual
insurance between the landlord, the military commander, the judge, the priest,
and later on the capitalist, in order to support such other's authority over
the people, and for exploiting the poverty of the masses and getting rich
themselves."_ Such was the _"origin of the State; such was its history; and
such is its present essence."_ [Kropotkin, **Evolution and Environment**, p.
94]

So while the state is an instrument of class rule it does **not**
automatically mean that it does not clash with sections of the class it
represents nor that it has to be the tool of an economically dominant class.
One thing is sure, however. The state is not a suitable tool for securing the
emancipation of the oppressed.

[‹ B.1 Why are anarchists against authority and hierarchy?](secB1.md "Go to
previous page" ) [up](secBcon.md "Go to parent page" ) [B.3 Why are
anarchists against private property? ›](secB3.md "Go to next page" )

