/*
 *  functions.h
 *
 *  Copyright 2009 Arnaud Soyez <weboide@codealpha.net>
 *
 *  This file is part of AudioPreview.
 *
 *  AudioPreview is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  AudioPreview is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with AudioPreview.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef FUNCTIONS_H
#define FUNCTIONS_H

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gst/gst.h>
#include <unistd.h>
#include <termios.h>
#include <sys/ioctl.h>
#include "ap_config.h"


/* Color macros.  */

static const char *color_bold_red     = "01;31";
static const char *color_bold_green   = "01;32";
static const char *color_bold_blue    = "01;34";
static const char *color_bold_magenta = "01;35";
static const char *color_bold_cyan    = "01;36";
static const char *color_red      = "31";
static const char *color_green    = "32";
static const char *color_blue     = "34";
static const char *color_magenta  = "35";
static const char *color_cyan     = "36";

static const char *color_start = "\33[%sm\33[K";
#define COLOR_START_CODE  color_start
static const char *color_end   = "\33[m\33[K";
#define COLOR_END_CODE    color_end

#define COLOR_PRINT(fmt, s)  {if (ap_config.want_colors && *(s)) printf((fmt), (s));}
#define COLOR_START_PRINT(s) COLOR_PRINT(COLOR_START_CODE, (s))
#define COLOR_END_PRINT(s)   COLOR_PRINT(COLOR_END_CODE,   s)


GList*        g_list_shuffle            (GList *list);
gpointer      wait_for_key              (GSourceFunc dispatch_func);
gboolean      set_tty_flags             (gboolean activate);
void          remove_tty_flags          ();
gboolean      key_dispatcher            (gint *car);
gboolean      start_thread_wait_for_key ();
gint          get_terminal_width        ();
gboolean      need_colors               ();
void          terminal_size_changed     (gint s);
#endif /* FUNCTIONS_H */
