/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.cff;

import com.kreative.cff.FieldSize;
import com.kreative.cff.FieldType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;

public class FieldSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final FieldSpec DATA = new FieldSpec(FieldType.DATA, FieldSize.DATA);
    private FieldType type;
    private FieldSize size;
    private boolean littleEndian;

    public FieldSpec(FieldType type, FieldSize size) {
        this.type = type;
        this.size = size;
        this.littleEndian = false;
    }

    public FieldSpec(FieldType type, FieldSize size, boolean littleEndian) {
        this.type = type;
        this.size = size;
        this.littleEndian = littleEndian;
    }

    public FieldSpec(String spec) {
        this.type = null;
        this.size = null;
        this.littleEndian = false;
        spec = spec.trim();
        if (spec.length() > 0) {
            this.type = FieldType.forChar(spec.charAt(0));
        }
        if (this.type == null) {
            this.type = FieldType.CHARACTER_TYPE;
        }
        if (spec.length() > 1) {
            this.size = FieldSize.forChar(spec.charAt(1));
        }
        if (this.size == null) {
            FieldSize fieldSize = this.size = this.type == FieldType.DATA ? FieldSize.DATA : FieldSize.MEDIUM;
        }
        if (spec.length() > 2) {
            switch (spec.charAt(2)) {
                case 'I': 
                case 'L': 
                case 'i': 
                case 'l': {
                    this.littleEndian = true;
                    break;
                }
                case 'B': 
                case 'M': 
                case 'b': 
                case 'm': {
                    this.littleEndian = false;
                }
            }
        }
    }

    public FieldSpec(byte spec) {
        this.type = FieldType.forBitPattern(spec);
        if (this.type == null) {
            this.type = FieldType.CHARACTER_TYPE;
        }
        this.size = FieldSize.forBitPattern(spec);
        if (this.size == null) {
            this.size = this.type == FieldType.DATA ? FieldSize.DATA : FieldSize.MEDIUM;
        }
        this.littleEndian = (spec & 0x80) != 0;
    }

    public FieldType type() {
        return this.type;
    }

    public FieldSize size() {
        return this.size;
    }

    public boolean littleEndian() {
        return this.littleEndian;
    }

    public boolean bigEndian() {
        return !this.littleEndian;
    }

    public int byteCount() {
        return this.size.byteCount();
    }

    public int bitCount() {
        return this.size.bitCount();
    }

    public Class<? extends Number> nativeType() {
        return this.size.nativeType();
    }

    public String stringRepresentation() {
        String s = "" + this.type.canonicalCharRepresentation();
        if (this.size.nativeType() != null) {
            s = String.valueOf(s) + this.size.canonicalCharRepresentation();
            if (this.littleEndian) {
                s = String.valueOf(s) + "l";
            }
        }
        return s;
    }

    public byte bitPatternRepresentation() {
        return (byte)(this.type.bitPatternRepresentation() | this.size.bitPatternRepresentation() | (this.littleEndian ? -128 : 0));
    }

    public Number read(DataInput in) throws IOException {
        return this.littleEndian ? (Number)this.size.readLE(in) : (Number)this.size.readBE(in);
    }

    public void write(DataOutput out, Number n) throws IOException {
        if (this.littleEndian) {
            this.size.writeLE(out, n);
        } else {
            this.size.writeBE(out, n);
        }
    }

    public boolean equals(Object o) {
        return o instanceof FieldSpec && ((FieldSpec)o).type == this.type && ((FieldSpec)o).size == this.size && ((FieldSpec)o).littleEndian == this.littleEndian;
    }

    public int hashCode() {
        return this.type.hashCode() ^ this.size.hashCode() ^ (this.littleEndian ? -1 : 0);
    }
}

