/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2016 Univ. Grenoble Alpes, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include "DicomItkComponent.h"

// To read DICOM images and DICOM image series
#include <itkImage.h>
#include <itkGDCMImageIO.h>
#include <itkGDCMSeriesFileNames.h>
#include <itkImageSeriesReader.h>
#include <itkImageFileWriter.h>
#include <itkImageToVTKImageFilter.h>
#include <itkOrientImageFilter.h>
// #include <itkDICOMImageIO2.h>

#include <QTextStream>
#include <vector>

#include <vtkSmartPointer.h>


#include <Log.h>
using namespace camitk;

// -------------------- default constructor --------------------
DicomItkComponent::DicomItkComponent(const QString directoryName, FilenamesContainerType filenames, QString name)
throw (AbortException) : ImageComponent(directoryName) {
    createComponent(directoryName, filenames, name);
}

void DicomItkComponent::createComponent(const QString directoryName, FilenamesContainerType filenames, QString name) {
    if (!directoryName.isEmpty()) {
        vtkSmartPointer<vtkImageData> img = readVolume(directoryName, filenames);
        if(img)
            setImageData(img, false);
        setName(name);
    }
}


vtkSmartPointer<vtkImageData> DicomItkComponent::readVolume(const QString directoryName, FilenamesContainerType fileNames) {

    // Most DICOM images are of type signed short
    typedef short PixelType;
    // 3D images with signed short pixels
    typedef itk::Image< PixelType, 3 > ImageType;
    // Reader of Dicom series of 3D signed short images
    typedef itk::ImageSeriesReader< ImageType > ReaderType;


    ReaderType::Pointer reader = ReaderType::New();
    // use of itk::DICOMImageIO2 for display in the right view
//  itk::DICOMImageIO2::Pointer dicomIO2 = itk::DICOMImageIO2::New();
//  reader->SetImageIO( dicomIO2 );

    itk::GDCMImageIO::Pointer dicomIO = itk::GDCMImageIO::New();
    reader->SetImageIO(dicomIO);


    // To re-orient the image
    typedef itk::OrientImageFilter<ImageType,ImageType> OrientType;
    OrientType::Pointer orientImage = OrientType::New();

    reader->SetFileNames( fileNames );

    orientImage->SetInput(reader->GetOutput());
    orientImage->SetUseImageDirection(true);
    orientImage->SetDesiredCoordinateOrientation(itk::SpatialOrientation::ITK_COORDINATE_ORIENTATION_RAI);

    // Read the chosen image
    try {
        orientImage->Update();
    } catch (itk::ExceptionObject & e) {
        cout << e.what();
        return NULL;
    }

    // To convert itkImages to vtkImages
    typedef itk::ImageToVTKImageFilter< ImageType > ConnectorType;
    ConnectorType::Pointer connector = ConnectorType::New();
    connector->SetInput(orientImage->GetOutput());

    connector->Update();
    // Copy the output image because the filters will be removed
    // and we want to keep the image for other vtk pipelines
    vtkSmartPointer<vtkImageData> returnedImg = vtkSmartPointer<vtkImageData>::New();
    vtkSmartPointer<vtkImageData> readImg = connector->GetOutput();
    int extent[6];
    readImg->GetExtent(extent);
    returnedImg->SetExtent(extent);
    returnedImg->DeepCopy(readImg);

    return returnedImg;
}
