/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#include "REAL.H"
#include "CONSTANTS.H"
#include "ArrayLim.H"
#include "AmrDeriveIntScalLen_F.H"

      subroutine FORT_SCALLEN (u,uloi1,uloi2,uloi3,uhii1,uhii2,uhii3,
     $ nvar,dx,ovlo,ovhi,TSL_z,corr,corrSize,
     $ ug,uglo1,uglo2,uglo3,ughi1,ughi2,ughi3)

      integer uloi1,uloi2,uloi3
      integer uhii1,uhii2,uhii3

      integer uglo1,uglo2,uglo3
      integer ughi1,ughi2,ughi3

      integer corrSize

      integer ovlo(3), ovhi(3)
      integer nvar
      REAL_T dx(3)
      REAL_T  u(1:uhii1-uloi1+1, 1:uhii2-uloi2+1, 1:uhii3-uloi3+1, nvar)
      REAL_T ug(1:ughi1-uglo1+1, 1:ughi2-uglo2+1, 1:ughi3-uglo3+1)
      REAL_T TSL_z(1:uhii3-uloi3+1)
      REAL_T corr(0:corrSize-1)

      integer i,j,k,imax,jmax,kmax, ir, vComp
      REAL_T average, sum

      vComp = 1
      
      imax = uhii1-uloi1+1
      jmax = uhii2-uloi2+1
      kmax = uhii3-uloi3+1

      do i=1,imax
         do k=1,kmax
            do j=1,jmax
               ug(i,     j,k) = u(i,j,k,vComp)
               ug(i+imax,j,k) = u(i,j,k,vComp)
            enddo
         enddo
      enddo

      average = 0.d0
      do  k=1,kmax
         do i=1,imax/2
            ir = i-1
            sum = zero
            do j=1,jmax
               do ibase=1,imax
                  sum = sum + ug(ibase,j,k)*ug(ibase+ir,j,k)                  
               enddo
            enddo
            corr(ir) = sum
         enddo

         factor = corr(0)
         if (factor.ne.zero) then
            do ir = 0,imax/2-1
               corr(ir) = corr(ir)/factor
            enddo
         endif
         
         sum = 0.d0
         do ir=1,imax/2-1
            sum = sum+half*(corr(ir)+corr(ir-1))*dx(vComp)
         enddo
         
         average = average + sum
         TSL_z(k) = sum
c         write(*,*)" integral scale at k = ",k, " is ", sum         
      enddo

      end

      subroutine FORT_TKE (u,uloi1,uloi2,uloi3,uhii1,uhii2,uhii3,
     $ nvar,dx,ovlo,ovhi,TKE_z)

      integer uloi1,uloi2,uloi3
      integer uhii1,uhii2,uhii3

      integer ovlo(3), ovhi(3)
      integer nvar
      REAL_T dx(3)
      REAL_T u(1:uhii1-uloi1+1, 1:uhii2-uloi2+1, 1:uhii3-uloi3+1, nvar)
      REAL_T TKE_z(1:uhii3-uloi3+1)

      integer i,j,k,imax,jmax,kmax
      REAL_T average, sum, ave(3), tmp(3)
      
      imax = uhii1-uloi1+1
      jmax = uhii2-uloi2+1
      kmax = uhii3-uloi3+1

c     Turb kinetic energy
      do k=1,kmax
         do n = 1,3
            ave(n) = zero
         end do
         do j=1,jmax
            do i=1,imax
               do n = 1,3
                  ave(n) = ave(n) + u(i,j,k,n)
               end do                
            end do
         end do
         do n = 1,3
            ave(n) = ave(n)/(jmax*imax)
            tmp(n) = zero
         end do
         do j=1,jmax
            do i=1,imax
               do n = 1,3
                  tmp(n) = tmp(n) + (u(i,j,k,n) - ave(n))**2
               end do                
            end do
         end do
         TKE_z(k) = zero
         do n = 1,3
            TKE_z(k) = TKE_z(k) + half*tmp(n)/(jmax*imax)
         end do
      end do
      end

      subroutine FORT_GUS (u,uloi1,uloi2,uloi3,uhii1,uhii2,uhii3,
     $ nvar,dx,ovlo,ovhi,GUS_z)

      integer uloi1,uloi2,uloi3
      integer uhii1,uhii2,uhii3

      integer ovlo(3), ovhi(3)
      integer nvar
      REAL_T dx(3)
      REAL_T u(1:uhii1-uloi1+1, 1:uhii2-uloi2+1, 1:uhii3-uloi3+1, nvar)
      REAL_T GUS_z(2:uhii3-uloi3)

      integer i,j,k,imax,jmax,kmax
      REAL_T ave(3), uprime(3)
      
      imax = uhii1-uloi1+1
      jmax = uhii2-uloi2+1
      kmax = uhii3-uloi3+1

c     Grad(U) sqrd
      sum = 0.d0
      DO k=2, kmax-1
        sum = zero
        DO n=1,3
          DO j=2, jmax-1
            DO i=2, imax-1
               vx = (u(i+1,j,k,n)-u(i-1,j,k,n))/(2.*dx(1))
               vy = (u(i,j+1,k,n)-u(i,j-1,k,n))/(2.*dx(2))
               vz = (u(i,j,k+1,n)-u(i,j,k-1,n))/(2.*dx(3))
               sum =sum+vx*vx+vy*vy+vz*vz
            ENDDO
          ENDDO
        ENDDO
        GUS_z(k) = sum / dfloat((imax-2)*(jmax-2)*(kmax-2))
      ENDDO


      end

      subroutine FORT_TI (u,uloi1,uloi2,uloi3,uhii1,uhii2,uhii3,
     $ nvar,dx,ovlo,ovhi,TIz)

      integer uloi1,uloi2,uloi3
      integer uhii1,uhii2,uhii3

      integer ovlo(3), ovhi(3)
      integer nvar
      REAL_T dx(3)
      REAL_T u(1:uhii1-uloi1+1, 1:uhii2-uloi2+1, 1:uhii3-uloi3+1, nvar)
      REAL_T TI_z(1:uhii3-uloi3+1)

      integer i,j,k,imax,jmax,kmax,vComp
      REAL_T average, sum

      vComp = 1
      
      imax = uhii1-uloi1+1
      jmax = uhii2-uloi2+1
      kmax = uhii3-uloi3+1

c     Turbulent intensity (of vComp component)
      do k=1,kmax
         average = zero
         do j=1,jmax
            do i=1,imax
               average= average + u(i,j,k,vComp)
            enddo
         enddo
   
         average = average/dfloat(imax*jmax)

         do j=1,jmax
            do i=1,imax
               sum = sum +(u(i,j,k,vComp)-average)**2
            enddo
         enddo

         sum = dsqrt(sum/dfloat(imax*jmax))
         TI_z(k) = sum
c         write(*,*) "turbulent intensity at ",k," = ",sum
      enddo
      end

      subroutine FORT_TAVG (T,Tloi1,Tloi2,Tloi3,Thii1,Thii2,Thii3,
     $ nvar,dx,ovlo,ovhi,TAVG_z)

      integer Tloi1,Tloi2,Tloi3
      integer Thii1,Thii2,Thii3

      integer ovlo(3), ovhi(3)
      integer nvar
      REAL_T dx(3)
      REAL_T T(1:Thii1-Tloi1+1, 1:Thii2-Tloi2+1, 1:Thii3-Tloi3+1, nvar)
      REAL_T TAVG_z(1:Thii3-Tloi3+1)

      integer i,j,k,imax,jmax,kmax
      REAL_T average, sum, avg
      
      imax = Thii1-Tloi1+1
      jmax = Thii2-Tloi2+1
      kmax = Thii3-Tloi3+1

c     Average T
      do k=1,kmax
         TAVG_z(k) = zero
         do j=1,jmax
            do i=1,imax
               TAVG_z(k) = TAVG_z(k) + T(i,j,k,1)
            end do
         end do
         TAVG_z(k) = TAVG_z(k)/(jmax*imax)
      end do
      end
