/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#include "REAL.H"
#include "CONSTANTS.H"
#include "BCTypes.H"

#define DIMS lo_1,lo_2,lo_3,hi_1,hi_2,hi_3
#define SDIMS slo_1,slo_2,slo_3,shi_1,shi_2,shi_3

#if BL_USE_FLOAT
#define threehalves    1.5e0
#else
#define threehalves    1.5d0
#endif

c *************************************************************************
c ** SETSCALBC **
c ** Impose the physical boundary conditions on scalars s
c *************************************************************************

      subroutine setscalbc(s,DIMS,SDIMS,bc,which_scal,dx,time)

      implicit none

      integer DIMS
      integer SDIMS
      integer which_scal
      integer bc(2,3)
      REAL_T  dx(3)
      REAL_T  time
      REAL_T  s(slo_1:shi_1,slo_2:shi_2,slo_3:shi_3)

c     Local variables
      integer is,ie,js,je,ks,ke,i,j,k
      integer ilo,ihi,jlo,jhi
      integer ng,ngmax

      is = lo_1
      ie = hi_1
      js = lo_2
      je = hi_2
      ks = lo_3
      ke = hi_3

      ilo = cvmgt(slo_1,lo_1,BCX_LO .eq. INTERIOR .or. BCX_LO .eq. PERIODIC)
      ihi = cvmgt(shi_1,hi_1,BCX_HI .eq. INTERIOR .or. BCX_HI .eq. PERIODIC)
      jlo = cvmgt(slo_2,lo_2,BCY_LO .eq. INTERIOR .or. BCY_LO .eq. PERIODIC)
      jhi = cvmgt(shi_2,hi_2,BCY_HI .eq. INTERIOR .or. BCY_HI .eq. PERIODIC)
 
      ngmax = lo_1 - slo_1

c     NOTE: IF BC == WALL, THESE VALUES ARE DEFINED ON THE EDGE OF THE PHYSICAL
c           BOUNDARY, NOT IN THE GHOST CELL

      if (BCZ_LO .eq. WALL) then

        do ng = 1,ngmax
        do j = jlo,jhi
        do i = ilo,ihi
c         s(i,j,ks-1) = threehalves*s(i,j,ks) - half*s(i,j,ks+1)
          s(i,j,ks-ng) = s(i,j,ks)
        enddo
        enddo
        enddo

      elseif (BCZ_LO .eq. INLET) then

        call scalinflow(s,DIMS,SDIMS,time,dx,2,0,which_scal)

      elseif (BCZ_LO .eq. OUTLET) then

        do ng = 1,ngmax
        do j = jlo,jhi
        do i = ilo,ihi
c         s(i,j,ks-1) = threehalves*s(i,j,ks) - half*s(i,j,ks+1)
          s(i,j,ks-ng) = s(i,j,ks)
        enddo
        enddo
        enddo

      endif

      if (BCZ_HI .eq. WALL) then

        do ng = 1,ngmax
        do j = jlo,jhi
        do i = ilo,ihi
c         s(i,j,ke+1) = threehalves*s(i,j,ke) - half*s(i,j,ke-1)
          s(i,j,ke+ng) = s(i,j,ke)
        enddo
        enddo
        enddo

      elseif (BCZ_HI .eq. INLET) then

        call scalinflow(s,DIMS,SDIMS,time,dx,2,1,which_scal)

      elseif (BCZ_HI .eq. OUTLET) then

        do ng = 1,ngmax
        do j = jlo,jhi
        do i = ilo,ihi
c         s(i,j,ke+1) = threehalves*s(i,j,ke) - half*s(i,j,ke-1)
          s(i,j,ke+ng) = s(i,j,ke)
        enddo
        enddo
        enddo

      endif

      if (BCY_LO .eq. WALL) then

        do ng = 1,ngmax
        do k = slo_3,shi_3
        do i = ilo,ihi
c         s(i,js-1,k) = threehalves*s(i,js,k) - half*s(i,js+1,k)
          s(i,js-ng,k) = s(i,js,k)
        enddo
        enddo
        enddo

      elseif (BCY_LO .eq. INLET) then

        call scalinflow(s,DIMS,SDIMS,time,dx,1,0,which_scal)

      elseif (BCY_LO .eq. OUTLET) then

        do ng = 1,ngmax
        do k = slo_3,shi_3
        do i = ilo,ihi
c         s(i,js-1,k) = threehalves*s(i,js,k) - half*s(i,js+1,k)
          s(i,js-ng,k) = s(i,js,k)
        enddo
        enddo
        enddo

      endif

      if (BCY_HI .eq. WALL) then

        do ng = 1,ngmax
        do k = slo_3,shi_3
        do i = ilo,ihi
c         s(i,je+1,k) = threehalves*s(i,je,k) - half*s(i,je-1,k)
          s(i,je+ng,k) = s(i,je,k)
        enddo
        enddo
        enddo

      elseif (BCY_HI .eq. INLET) then

        call scalinflow(s,DIMS,SDIMS,time,dx,1,1,which_scal)

      elseif (BCY_HI .eq. OUTLET) then

        do ng = 1,ngmax
        do k = slo_3,shi_3
        do i = ilo,ihi
c         s(i,je+1,k) = threehalves*s(i,je,k) - half*s(i,je-1,k)
          s(i,je+ng,k) = s(i,je,k)
        enddo
        enddo
        enddo

      endif

      if (BCX_LO .eq. WALL) then

        do ng = 1,ngmax
        do k = slo_3,shi_3
        do j = slo_2,shi_2
c         s(is-1,j,k) = threehalves*s(is,j,k) - half*s(is+1,j,k)
          s(is-ng,j,k) = s(is,j,k)
        enddo
        enddo
        enddo

      elseif (BCX_LO .eq. INLET) then

        call scalinflow(s,DIMS,SDIMS,time,dx,0,0,which_scal)

      elseif (BCX_LO .eq. OUTLET) then

        do ng = 1,ngmax
        do k = slo_3,shi_3
        do j = slo_2,shi_2
c         s(is-1,j,k) = threehalves*s(is,j,k) - half*s(is+1,j,k)
          s(is-ng,j,k) = s(is,j,k)
        enddo
        enddo
        enddo

      endif

      if (BCX_HI .eq. WALL) then

        do ng = 1,ngmax
        do k = slo_3,shi_3
        do j = slo_2,shi_2
c         s(ie+1,j,k) = threehalves*s(ie,j,k) - half*s(ie-1,j,k)
          s(ie+ng,j,k) = s(ie,j,k)
        enddo
        enddo
        enddo

      elseif (BCX_HI .eq. INLET) then

        call scalinflow(s,DIMS,SDIMS,time,dx,0,1,which_scal)

      elseif (BCX_HI .eq. OUTLET) then

        do ng = 1,ngmax
        do k = slo_3,shi_3
        do j = slo_2,shi_2
c         s(ie+1,j,k) = threehalves*s(ie,j,k) - half*s(ie-1,j,k)
          s(ie+ng,j,k) = s(ie,j,k)
        enddo
        enddo
        enddo

      endif

      return
      end
