/*
  This file is part of CDO. CDO is a collection of Operators to
  manipulate and analyse Climate model Data.

  Copyright (C) 2003-2019 Uwe Schulzweida, <uwe.schulzweida AT mpimet.mpg.de>
  See COPYING file for copying and redistribution conditions.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
*/
#ifndef CDO_OPTIONS_H
#define CDO_OPTIONS_H

namespace Cdo
{
extern const char *progname;
extern char File_Suffix[32];  // refactor: added keyword extern
extern const char *Version;
extern const char *Username;
}  // namespace Cdo

namespace Options
{
extern int numStreamWorker;
extern bool benchmark;
extern bool silentMode;

extern bool cdoCompress;
extern int cdoCompType;
extern int cdoCompLevel;
extern bool cdoInteractive;
extern bool cdoVerbose;
extern int cdoExitStatus;
extern bool Timer;

extern bool CheckDatarange;

extern int CDO_flt_digits;
extern int CDO_dbl_digits;

extern bool Use_FFTW;
extern bool VersionInfo;
extern int CMOR_Mode;

extern bool cdoDiag;

extern int CDO_Memtype;
#define MEMTYPE_DOUBLE 1
#define MEMTYPE_FLOAT 2
extern bool CDO_Parallel_Read;

extern int CDO_Reduce_Dim;
extern int CDO_Append_History;
extern bool CDO_Reset_History;

extern unsigned Random_Seed;

extern int cdoChunkType;
extern bool cdoOverwriteMode;
extern bool cdoParIO;
extern bool cdoRegulargrid;
extern int cdoNumVarnames;
extern char **cdoVarnames;

extern bool REMAP_genweights;

}  // namespace Options

namespace Threading
{
extern int ompNumThreads;
extern bool cdoLockIO;
}  // namespace Threading

const char *cdoComment(void);

void set_comp(int fileID, int filetype);

#endif
