/*
 * Copyright © 2013 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *     Antti Kaijanmäki <antti.kaijanmaki@canonical.com>
 */
#ifndef PLATFORM_NMOFONO_MANAGER
#define PLATFORM_NMOFONO_MANAGER

#include <com/ubuntu/connectivity/networking/manager.h>

#include <services/nm.h>
#include <services/urfkill.h>

namespace platform {
namespace nmofono {
    class Manager;
    class Network;
}
}

class platform::nmofono::Manager : public com::ubuntu::connectivity::networking::Manager
{
    std::shared_ptr<org::freedesktop::NetworkManager::Interface::NetworkManager> nm;
    std::shared_ptr<org::freedesktop::URfkill::Interface::URfkill> urfkill;

    void updateNetworkingStatus(std::uint32_t);

    struct State
    {
        State();
        ~State();

        std::shared_ptr<core::dbus::Bus> m_bus;
        std::thread worker;
    };

    std::unique_ptr<State> m_state;

public:

    Manager();

    // Public API
    void enableFlightMode();
    void disableFlightMode();
    const core::Property<com::ubuntu::connectivity::networking::Manager::FlightModeStatus>& flightMode();

    const core::Property<std::set<std::shared_ptr<com::ubuntu::connectivity::networking::Link>>>& links();
    const core::Property<std::set<std::shared_ptr<com::ubuntu::connectivity::networking::Service>>>&services();
    const core::Property<com::ubuntu::connectivity::networking::Manager::NetworkingStatus> & status();
    const core::Property<std::uint32_t>& characteristics();

    // private API
    core::Property<com::ubuntu::connectivity::networking::Manager::FlightModeStatus> m_flightMode;
    core::Property<std::set<std::shared_ptr<com::ubuntu::connectivity::networking::Link>>> m_links;
    core::Property<std::set<std::shared_ptr<com::ubuntu::connectivity::networking::Service>>> m_services;
    core::Property<com::ubuntu::connectivity::networking::Manager::NetworkingStatus> m_status;
    core::Property<std::uint32_t> m_characteristics;
};

#endif
