/** \file
 *  This C source file was generated by $ANTLR version 3.4
 *
 *     -  From the grammar source file : ../../../../src/parser/smt2/Smt2.g
 *     -                            On : 2017-07-10 10:01:29
 *     -                for the parser : Smt2ParserParser
 *
 * Editing it, at least manually, is not wise.
 *
 * C language generator and runtime by Jim Idle, jimi|hereisanat|idle|dotgoeshere|ws.
 *
 *
*/
// [The "BSD license"]
// Copyright (c) 2005-2009 Jim Idle, Temporal Wave LLC
// http://www.temporal-wave.com
// http://www.linkedin.com/in/jimidle
//
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of the author may not be used to endorse or promote products
//    derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


/* =============================================================================
 * This is what the grammar programmer asked us to put at the top of every file.
 */

/**
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2016 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.
 **/

/* End of Header action.
 * =============================================================================
 */

/* -----------------------------------------
 * Include the ANTLR3 generated header file.
 */
#include    "Smt2Parser.h"


#include <set>
#include <sstream>
#include <string>
#include <vector>

#include "base/output.h"
#include "expr/expr.h"
#include "expr/kind.h"
#include "expr/type.h"
#include "options/set_language.h"
#include "parser/antlr_input.h"
#include "parser/parser.h"
#include "parser/smt2/smt2.h"
#include "util/floatingpoint.h"
#include "util/hash.h"
#include "util/integer.h"
#include "util/rational.h"
// \todo Review the need for this header
#include "math.h"

using namespace CVC4;
using namespace CVC4::parser;

/* These need to be macros so they can refer to the PARSER macro, which
 * will be defined by ANTLR *after* this section. (If they were functions,
 * PARSER would be undefined.) */
#undef PARSER_STATE
#define PARSER_STATE ((Smt2*)PARSER->super)
#undef EXPR_MANAGER
#define EXPR_MANAGER PARSER_STATE->getExprManager()
#undef MK_EXPR
#define MK_EXPR EXPR_MANAGER->mkExpr
#undef MK_CONST
#define MK_CONST EXPR_MANAGER->mkConst
#define UNSUPPORTED PARSER_STATE->unimplementedFeature

static bool isClosed(const Expr& e, std::set<Expr>& free, std::hash_set<Expr, ExprHashFunction>& closedCache) {
  if(closedCache.find(e) != closedCache.end()) {
    return true;
  }

  if(e.getKind() == kind::FORALL || e.getKind() == kind::EXISTS || e.getKind() == kind::LAMBDA) {
    isClosed(e[1], free, closedCache);
    for(Expr::const_iterator i = e[0].begin(); i != e[0].end(); ++i) {
      free.erase(*i);
    }
  } else if(e.getKind() == kind::BOUND_VARIABLE) {
    free.insert(e);
    return false;
  } else {
    if(e.hasOperator()) {
      isClosed(e.getOperator(), free, closedCache);
    }
    for(Expr::const_iterator i = e.begin(); i != e.end(); ++i) {
      isClosed(*i, free, closedCache);
    }
  }

  if(free.empty()) {
    closedCache.insert(e);
    return true;
  } else {
    return false;
  }
}

static inline bool isClosed(const Expr& e, std::set<Expr>& free) {
  std::hash_set<Expr, ExprHashFunction> cache;
  return isClosed(e, free, cache);
}  
  

/* ----------------------------------------- */





/* MACROS that hide the C interface implementations from the
 * generated code, which makes it a little more understandable to the human eye.
 * I am very much against using C pre-processor macros for function calls and bits
 * of code as you cannot see what is happening when single stepping in debuggers
 * and so on. The exception (in my book at least) is for generated code, where you are
 * not maintaining it, but may wish to read and understand it. If you single step it, you know that input()
 * hides some indirect calls, but is always referring to the input stream. This is
 * probably more readable than ctx->input->istream->input(snarfle0->blarg) and allows me to rejig
 * the runtime interfaces without changing the generated code too often, without
 * confusing the reader of the generated output, who may not wish to know the gory
 * details of the interface inheritance.
 */

#define		CTX	ctx

/* Aids in accessing scopes for grammar programmers
 */
#undef	SCOPE_TYPE
#undef	SCOPE_STACK
#undef	SCOPE_TOP
#define	SCOPE_TYPE(scope)   pSmt2Parser_##scope##_SCOPE
#define SCOPE_STACK(scope)  pSmt2Parser_##scope##Stack
#define	SCOPE_TOP(scope)    ctx->pSmt2Parser_##scope##Top
#define	SCOPE_SIZE(scope)		ctx->pSmt2Parser_##scope##Stack_limit
#define SCOPE_INSTANCE(scope, i)	(ctx->SCOPE_STACK(scope)->get(ctx->SCOPE_STACK(scope),i))

/* Macros for accessing things in the parser
 */

#undef	    PARSER
#undef	    RECOGNIZER
#undef	    HAVEPARSEDRULE
#undef		MEMOIZE
#undef	    INPUT
#undef	    STRSTREAM
#undef	    HASEXCEPTION
#undef	    EXCEPTION
#undef	    MATCHT
#undef	    MATCHANYT
#undef	    FOLLOWSTACK
#undef	    FOLLOWPUSH
#undef	    FOLLOWPOP
#undef	    PRECOVER
#undef	    PREPORTERROR
#undef	    LA
#undef	    LT
#undef	    CONSTRUCTEX
#undef	    CONSUME
#undef	    MARK
#undef	    REWIND
#undef	    REWINDLAST
#undef	    PERRORRECOVERY
#undef	    HASFAILED
#undef	    FAILEDFLAG
#undef	    RECOVERFROMMISMATCHEDSET
#undef	    RECOVERFROMMISMATCHEDELEMENT
#undef		INDEX
#undef      ADAPTOR
#undef		SEEK
#undef	    RULEMEMO
#undef		DBG

#define	    PARSER				ctx->pParser
#define	    RECOGNIZER				PARSER->rec
#define	    PSRSTATE				RECOGNIZER->state
#define	    HAVEPARSEDRULE(r)			RECOGNIZER->alreadyParsedRule(RECOGNIZER, r)
#define	    MEMOIZE(ri,si)			RECOGNIZER->memoize(RECOGNIZER, ri, si)
#define	    INPUT				PARSER->tstream
#define	    STRSTREAM				INPUT
#define	    ISTREAM				INPUT->istream
#define	    INDEX()				ISTREAM->index(INPUT->istream)
#define	    HASEXCEPTION()			(PSRSTATE->error == ANTLR3_TRUE)
#define	    EXCEPTION				PSRSTATE->exception
#define	    MATCHT(t, fs)			RECOGNIZER->match(RECOGNIZER, t, fs)
#define	    MATCHANYT()				RECOGNIZER->matchAny(RECOGNIZER)
#define	    FOLLOWSTACK				PSRSTATE->following
#ifdef  SKIP_FOLLOW_SETS
#define	    FOLLOWPUSH(x)
#define	    FOLLOWPOP()
#else
#define	    FOLLOWPUSH(x)			FOLLOWSTACK->push(FOLLOWSTACK, ((void *)(&(x))), NULL)
#define	    FOLLOWPOP()				FOLLOWSTACK->pop(FOLLOWSTACK)
#endif
#define	    PRECOVER()				RECOGNIZER->recover(RECOGNIZER)
#define	    PREPORTERROR()			RECOGNIZER->reportError(RECOGNIZER)
#define	    LA(n)				INPUT->istream->_LA(ISTREAM, n)
#define	    LT(n)				INPUT->_LT(INPUT, n)
#define	    CONSTRUCTEX()			RECOGNIZER->exConstruct(RECOGNIZER)
#define	    CONSUME()				ISTREAM->consume(ISTREAM)
#define	    MARK()				ISTREAM->mark(ISTREAM)
#define	    REWIND(m)				ISTREAM->rewind(ISTREAM, m)
#define	    REWINDLAST()			ISTREAM->rewindLast(ISTREAM)
#define	    SEEK(n)				ISTREAM->seek(ISTREAM, n)
#define	    PERRORRECOVERY			PSRSTATE->errorRecovery
#define	    FAILEDFLAG				PSRSTATE->failed
#define	    HASFAILED()				(FAILEDFLAG == ANTLR3_TRUE)
#define	    BACKTRACKING			PSRSTATE->backtracking
#define	    RECOVERFROMMISMATCHEDSET(s)		RECOGNIZER->recoverFromMismatchedSet(RECOGNIZER, s)
#define	    RECOVERFROMMISMATCHEDELEMENT(e)	RECOGNIZER->recoverFromMismatchedElement(RECOGNIZER, s)
#define     ADAPTOR                         ctx->adaptor
#define		RULEMEMO						PSRSTATE->ruleMemo
#define		DBG								RECOGNIZER->debugger


#define		TOKTEXT(tok, txt)				tok, (pANTLR3_UINT8)txt

/* The 4 tokens defined below may well clash with your own #defines or token types. If so
 * then for the present you must use different names for your defines as these are hard coded
 * in the code generator. It would be better not to use such names internally, and maybe
 * we can change this in a forthcoming release. I deliberately do not #undef these
 * here as this will at least give you a redefined error somewhere if they clash.
 */
#define	    UP	    ANTLR3_TOKEN_UP
#define	    DOWN    ANTLR3_TOKEN_DOWN
#define	    EOR	    ANTLR3_TOKEN_EOR
#define	    INVALID ANTLR3_TOKEN_INVALID


/* =============================================================================
 * Functions to create and destroy scopes. First come the rule scopes, followed
 * by the global declared scopes.
 */



/* ============================================================================= */

/* =============================================================================
 * Start of recognizer
 */


/** \brief Table of all token names in symbolic order, mainly used for
 *         error reporting.
 */
pANTLR3_UINT8   Smt2ParserTokenNames[155+4]
     = {
        (pANTLR3_UINT8) "<invalid>",       /* String to print to indicate an invalid token */
        (pANTLR3_UINT8) "<EOR>",
        (pANTLR3_UINT8) "<DOWN>",
        (pANTLR3_UINT8) "<UP>",
        (pANTLR3_UINT8) "ALPHA",
        (pANTLR3_UINT8) "AMPERSAND_TOK",
        (pANTLR3_UINT8) "AND_TOK",
        (pANTLR3_UINT8) "ASSERT_TOK",
        (pANTLR3_UINT8) "AS_TOK",
        (pANTLR3_UINT8) "ATTRIBUTE_INST_LEVEL",
        (pANTLR3_UINT8) "ATTRIBUTE_NAMED_TOK",
        (pANTLR3_UINT8) "ATTRIBUTE_NO_PATTERN_TOK",
        (pANTLR3_UINT8) "ATTRIBUTE_PATTERN_TOK",
        (pANTLR3_UINT8) "ATTRIBUTE_RR_PRIORITY",
        (pANTLR3_UINT8) "ATTRIBUTE_TOK",
        (pANTLR3_UINT8) "AT_TOK",
        (pANTLR3_UINT8) "BINARY_LITERAL",
        (pANTLR3_UINT8) "BV2NAT_TOK",
        (pANTLR3_UINT8) "CHECKSAT_TOK",
        (pANTLR3_UINT8) "CHECK_SYNTH_TOK",
        (pANTLR3_UINT8) "COMMENT",
        (pANTLR3_UINT8) "CONSTRAINT_TOK",
        (pANTLR3_UINT8) "CONST_TOK",
        (pANTLR3_UINT8) "DECIMAL_LITERAL",
        (pANTLR3_UINT8) "DECLARE_CODATATYPES_2_5_TOK",
        (pANTLR3_UINT8) "DECLARE_CODATATYPES_TOK",
        (pANTLR3_UINT8) "DECLARE_CODATATYPE_TOK",
        (pANTLR3_UINT8) "DECLARE_CONST_TOK",
        (pANTLR3_UINT8) "DECLARE_DATATYPES_2_5_TOK",
        (pANTLR3_UINT8) "DECLARE_DATATYPES_TOK",
        (pANTLR3_UINT8) "DECLARE_DATATYPE_TOK",
        (pANTLR3_UINT8) "DECLARE_FUNS_TOK",
        (pANTLR3_UINT8) "DECLARE_FUN_TOK",
        (pANTLR3_UINT8) "DECLARE_PREDS_TOK",
        (pANTLR3_UINT8) "DECLARE_PRIMED_VAR_TOK",
        (pANTLR3_UINT8) "DECLARE_SORTS_TOK",
        (pANTLR3_UINT8) "DECLARE_SORT_TOK",
        (pANTLR3_UINT8) "DECLARE_VAR_TOK",
        (pANTLR3_UINT8) "DEFINE_CONST_TOK",
        (pANTLR3_UINT8) "DEFINE_FUNS_REC_TOK",
        (pANTLR3_UINT8) "DEFINE_FUN_REC_TOK",
        (pANTLR3_UINT8) "DEFINE_FUN_TOK",
        (pANTLR3_UINT8) "DEFINE_SORT_TOK",
        (pANTLR3_UINT8) "DEFINE_TOK",
        (pANTLR3_UINT8) "DIGIT",
        (pANTLR3_UINT8) "DISTINCT_TOK",
        (pANTLR3_UINT8) "DIVISIBLE_TOK",
        (pANTLR3_UINT8) "DIV_TOK",
        (pANTLR3_UINT8) "DTSIZE_TOK",
        (pANTLR3_UINT8) "ECHO_TOK",
        (pANTLR3_UINT8) "EMPTYSET_TOK",
        (pANTLR3_UINT8) "EQUAL_TOK",
        (pANTLR3_UINT8) "EXISTS_TOK",
        (pANTLR3_UINT8) "EXIT_TOK",
        (pANTLR3_UINT8) "FMFCARDVAL_TOK",
        (pANTLR3_UINT8) "FMFCARD_TOK",
        (pANTLR3_UINT8) "FORALL_TOK",
        (pANTLR3_UINT8) "FP_NAN_TOK",
        (pANTLR3_UINT8) "FP_NINF_TOK",
        (pANTLR3_UINT8) "FP_NZERO_TOK",
        (pANTLR3_UINT8) "FP_PINF_TOK",
        (pANTLR3_UINT8) "FP_PZERO_TOK",
        (pANTLR3_UINT8) "FP_RNA_FULL_TOK",
        (pANTLR3_UINT8) "FP_RNA_TOK",
        (pANTLR3_UINT8) "FP_RNE_FULL_TOK",
        (pANTLR3_UINT8) "FP_RNE_TOK",
        (pANTLR3_UINT8) "FP_RTN_FULL_TOK",
        (pANTLR3_UINT8) "FP_RTN_TOK",
        (pANTLR3_UINT8) "FP_RTP_FULL_TOK",
        (pANTLR3_UINT8) "FP_RTP_TOK",
        (pANTLR3_UINT8) "FP_RTZ_FULL_TOK",
        (pANTLR3_UINT8) "FP_RTZ_TOK",
        (pANTLR3_UINT8) "FP_TO_FPBV_TOK",
        (pANTLR3_UINT8) "FP_TO_FPFP_TOK",
        (pANTLR3_UINT8) "FP_TO_FPR_TOK",
        (pANTLR3_UINT8) "FP_TO_FPS_TOK",
        (pANTLR3_UINT8) "FP_TO_FPU_TOK",
        (pANTLR3_UINT8) "FP_TO_FP_TOK",
        (pANTLR3_UINT8) "FP_TO_SBV_TOK",
        (pANTLR3_UINT8) "FP_TO_UBV_TOK",
        (pANTLR3_UINT8) "GET_ASSERTIONS_TOK",
        (pANTLR3_UINT8) "GET_ASSIGNMENT_TOK",
        (pANTLR3_UINT8) "GET_INFO_TOK",
        (pANTLR3_UINT8) "GET_MODEL_TOK",
        (pANTLR3_UINT8) "GET_OPTION_TOK",
        (pANTLR3_UINT8) "GET_PROOF_TOK",
        (pANTLR3_UINT8) "GET_QE_DISJUNCT_TOK",
        (pANTLR3_UINT8) "GET_QE_TOK",
        (pANTLR3_UINT8) "GET_UNSAT_CORE_TOK",
        (pANTLR3_UINT8) "GET_VALUE_TOK",
        (pANTLR3_UINT8) "GREATER_THAN_EQUAL_TOK",
        (pANTLR3_UINT8) "GREATER_THAN_TOK",
        (pANTLR3_UINT8) "HEX_DIGIT",
        (pANTLR3_UINT8) "HEX_LITERAL",
        (pANTLR3_UINT8) "IMPLIES_TOK",
        (pANTLR3_UINT8) "INCLUDE_TOK",
        (pANTLR3_UINT8) "INDEX_TOK",
        (pANTLR3_UINT8) "INST_CLOSURE_TOK",
        (pANTLR3_UINT8) "INT2BV_TOK",
        (pANTLR3_UINT8) "INTEGER_LITERAL",
        (pANTLR3_UINT8) "INV_CONSTRAINT_TOK",
        (pANTLR3_UINT8) "ITE_TOK",
        (pANTLR3_UINT8) "KEYWORD",
        (pANTLR3_UINT8) "LESS_THAN_EQUAL_TOK",
        (pANTLR3_UINT8) "LESS_THAN_TOK",
        (pANTLR3_UINT8) "LET_TOK",
        (pANTLR3_UINT8) "LPAREN_TOK",
        (pANTLR3_UINT8) "MATCH_TOK",
        (pANTLR3_UINT8) "META_INFO_TOK",
        (pANTLR3_UINT8) "MINUS_TOK",
        (pANTLR3_UINT8) "NILREF_TOK",
        (pANTLR3_UINT8) "NOT_TOK",
        (pANTLR3_UINT8) "NUMERAL",
        (pANTLR3_UINT8) "OR_TOK",
        (pANTLR3_UINT8) "PAR_TOK",
        (pANTLR3_UINT8) "PLUS_TOK",
        (pANTLR3_UINT8) "POP_TOK",
        (pANTLR3_UINT8) "PROPAGATION_RULE_TOK",
        (pANTLR3_UINT8) "PUSH_TOK",
        (pANTLR3_UINT8) "QUOTED_SYMBOL",
        (pANTLR3_UINT8) "REALLCHAR_TOK",
        (pANTLR3_UINT8) "REDUCTION_RULE_TOK",
        (pANTLR3_UINT8) "RENOSTR_TOK",
        (pANTLR3_UINT8) "RESET_ASSERTIONS_TOK",
        (pANTLR3_UINT8) "RESET_TOK",
        (pANTLR3_UINT8) "REWRITE_RULE_TOK",
        (pANTLR3_UINT8) "RPAREN_TOK",
        (pANTLR3_UINT8) "SET_INFO_TOK",
        (pANTLR3_UINT8) "SET_LOGIC_TOK",
        (pANTLR3_UINT8) "SET_OPTIONS_TOK",
        (pANTLR3_UINT8) "SET_OPTION_TOK",
        (pANTLR3_UINT8) "SIMPLE_SYMBOL",
        (pANTLR3_UINT8) "SIMPLIFY_TOK",
        (pANTLR3_UINT8) "STAR_TOK",
        (pANTLR3_UINT8) "STRING_LITERAL_2_0",
        (pANTLR3_UINT8) "STRING_LITERAL_2_5",
        (pANTLR3_UINT8) "SYGUS_CONSTANT_TOK",
        (pANTLR3_UINT8) "SYGUS_ENUM_CONS_TOK",
        (pANTLR3_UINT8) "SYGUS_ENUM_TOK",
        (pANTLR3_UINT8) "SYGUS_INPUT_VARIABLE_TOK",
        (pANTLR3_UINT8) "SYGUS_LOCAL_VARIABLE_TOK",
        (pANTLR3_UINT8) "SYGUS_QUOTED_LITERAL",
        (pANTLR3_UINT8) "SYGUS_VARIABLE_TOK",
        (pANTLR3_UINT8) "SYMBOL_CHAR",
        (pANTLR3_UINT8) "SYMBOL_CHAR_NOUNDERSCORE_NOATTRIBUTE",
        (pANTLR3_UINT8) "SYNTH_FUN_TOK",
        (pANTLR3_UINT8) "SYNTH_INV_TOK",
        (pANTLR3_UINT8) "TESTER_TOK",
        (pANTLR3_UINT8) "UNIVSET_TOK",
        (pANTLR3_UINT8) "UNTERMINATED_QUOTED_SYMBOL",
        (pANTLR3_UINT8) "WHITESPACE",
        (pANTLR3_UINT8) "XOR_TOK",
        (pANTLR3_UINT8) "'\\\\'",
        (pANTLR3_UINT8) "'extract'",
        (pANTLR3_UINT8) "'repeat'",
        (pANTLR3_UINT8) "'rotate_left'",
        (pANTLR3_UINT8) "'rotate_right'",
        (pANTLR3_UINT8) "'sign_extend'",
        (pANTLR3_UINT8) "'zero_extend'"
       };



// Forward declare the locally static matching functions we have generated.
//
static 
 CVC4::parser::smt2::myExpr
	parseExpr    (pSmt2Parser ctx);
static 
 CVC4::Command*
	parseCommand    (pSmt2Parser ctx);
static 
 CVC4::Command*
	parseSygus    (pSmt2Parser ctx);
static 
 void
	command    (pSmt2Parser ctx, CVC4::PtrCloser<CVC4::Command>* cmd);
static 
 void
	sygusCommand    (pSmt2Parser ctx, CVC4::PtrCloser<CVC4::Command>* cmd);
static 
 void
	sygusGTerm    (pSmt2Parser ctx, CVC4::SygusGTerm& sgt, std::string& fun);
static 
 void
	metaInfoInternal    (pSmt2Parser ctx, CVC4::PtrCloser<CVC4::Command>* cmd);
static 
 void
	setOptionInternal    (pSmt2Parser ctx, CVC4::PtrCloser<CVC4::Command>* cmd);
static 
 void
	smt25Command    (pSmt2Parser ctx, CVC4::PtrCloser<CVC4::Command>* cmd);
static 
 void
	extendedCommand    (pSmt2Parser ctx, CVC4::PtrCloser<CVC4::Command>* cmd);
static 
 void
	datatypes_2_5_DefCommand    (pSmt2Parser ctx, bool isCo, CVC4::PtrCloser<CVC4::Command>* cmd);
static 
 void
	datatypeDefCommand    (pSmt2Parser ctx, bool isCo, CVC4::PtrCloser<CVC4::Command>* cmd);
static 
 void
	datatypesDefCommand    (pSmt2Parser ctx, bool isCo, CVC4::PtrCloser<CVC4::Command>* cmd);
static 
 void
	rewriterulesCommand    (pSmt2Parser ctx, CVC4::PtrCloser<CVC4::Command>* cmd);
static 
 void
	rewritePropaKind    (pSmt2Parser ctx, CVC4::Kind& kind);
static 
 void
	pattern    (pSmt2Parser ctx, CVC4::Expr& expr);
static 
 void
	simpleSymbolicExprNoKeyword    (pSmt2Parser ctx, CVC4::SExpr& sexpr);
static 
 void
	keyword    (pSmt2Parser ctx, std::string& s);
static 
 void
	simpleSymbolicExpr    (pSmt2Parser ctx, CVC4::SExpr& sexpr);
static 
 void
	symbolicExpr    (pSmt2Parser ctx, CVC4::SExpr& sexpr);
static 
 void
	term    (pSmt2Parser ctx, CVC4::Expr& expr, CVC4::Expr& expr2);
static 
 void
	attribute    (pSmt2Parser ctx, CVC4::Expr& expr, CVC4::Expr& retExpr, std::string& attr);
static 
 void
	indexedFunctionName    (pSmt2Parser ctx, CVC4::Expr& op, CVC4::Kind& kind);
static 
 void
	badIndexedFunctionName    (pSmt2Parser ctx);
static 
 void
	termList    (pSmt2Parser ctx, std::vector<CVC4::Expr>& formulas, CVC4::Expr& expr);
static 
 void
	str    (pSmt2Parser ctx, std::string& s, bool fsmtlib);
static 
 void
	builtinOp    (pSmt2Parser ctx, CVC4::Kind& kind);
static 
 void
	quantOp    (pSmt2Parser ctx, CVC4::Kind& kind);
static 
 void
	functionName    (pSmt2Parser ctx, std::string& name, CVC4::parser::DeclarationCheck check);
static 
 void
	sortList    (pSmt2Parser ctx, std::vector<CVC4::Type>& sorts);
static 
 void
	nonemptySortList    (pSmt2Parser ctx, std::vector<CVC4::Type>& sorts);
static 
 void
	sortedVarList    (pSmt2Parser ctx, std::vector<std::pair<std::string, CVC4::Type> >& sortedVars);
static 
 void
	sortName    (pSmt2Parser ctx, std::string& name, CVC4::parser::DeclarationCheck check);
static 
 void
	sortSymbol    (pSmt2Parser ctx, CVC4::Type& t, CVC4::parser::DeclarationCheck check);
static 
 void
	symbolList    (pSmt2Parser ctx, std::vector<std::string>& names, CVC4::parser::DeclarationCheck check, CVC4::parser::SymbolType type);
static 
 void
	symbol    (pSmt2Parser ctx, std::string& id, CVC4::parser::DeclarationCheck check, CVC4::parser::SymbolType type);
static 
 void
	nonemptyNumeralList    (pSmt2Parser ctx, std::vector<uint64_t>& numerals);
static 
 void
	datatypeDef    (pSmt2Parser ctx, bool isCo, std::vector<CVC4::Datatype>& datatypes, std::vector< CVC4::Type >& params);
static 
 void
	constructorDef    (pSmt2Parser ctx, CVC4::Datatype& type);
static 
 void
	selector    (pSmt2Parser ctx, CVC4::DatatypeConstructor& ctor);
static void	Smt2ParserFree(pSmt2Parser ctx);
static void     Smt2ParserReset (pSmt2Parser ctx);

/* For use in tree output where we are accumulating rule labels via label += ruleRef
 * we need a function that knows how to free a return scope when the list is destroyed.
 * We cannot just use ANTLR3_FREE because in debug tracking mode, this is a macro.
 */
static	void ANTLR3_CDECL freeScope(void * scope)
{
    ANTLR3_FREE(scope);
}

/** \brief Name of the grammar file that generated this code
 */
static const char fileName[] = "../../../../src/parser/smt2/Smt2.g";

/** \brief Return the name of the grammar file that generated this code.
 */
static const char * getGrammarFileName()
{
	return fileName;
}
/** \brief Create a new Smt2Parser parser and return a context for it.
 *
 * \param[in] instream Pointer to an input stream interface.
 *
 * \return Pointer to new parser context upon success.
 */
ANTLR3_API pSmt2Parser
Smt2ParserNew   (pANTLR3_COMMON_TOKEN_STREAM instream)
{
	// See if we can create a new parser with the standard constructor
	//
	return Smt2ParserNewSSD(instream, NULL);
}

/** \brief Create a new Smt2Parser parser and return a context for it.
 *
 * \param[in] instream Pointer to an input stream interface.
 *
 * \return Pointer to new parser context upon success.
 */
ANTLR3_API pSmt2Parser
Smt2ParserNewSSD   (pANTLR3_COMMON_TOKEN_STREAM instream, pANTLR3_RECOGNIZER_SHARED_STATE state)
{
    pSmt2Parser ctx;	    /* Context structure we will build and return   */

    ctx	= (pSmt2Parser) ANTLR3_CALLOC(1, sizeof(Smt2Parser));

    if	(ctx == NULL)
    {
		// Failed to allocate memory for parser context
		//
        return  NULL;
    }

    /* -------------------------------------------------------------------
     * Memory for basic structure is allocated, now to fill in
     * the base ANTLR3 structures. We initialize the function pointers
     * for the standard ANTLR3 parser function set, but upon return
     * from here, the programmer may set the pointers to provide custom
     * implementations of each function.
     *
     * We don't use the macros defined in Smt2Parser.h here, in order that you can get a sense
     * of what goes where.
     */

    /* Create a base parser/recognizer, using the supplied token stream
     */
    ctx->pParser	    = antlr3ParserNewStream(ANTLR3_SIZE_HINT, instream->tstream, state);
    /* Install the implementation of our Smt2Parser interface
     */
    ctx->parseExpr	= parseExpr;
    ctx->parseCommand	= parseCommand;
    ctx->parseSygus	= parseSygus;
    ctx->command	= command;
    ctx->sygusCommand	= sygusCommand;
    ctx->sygusGTerm	= sygusGTerm;
    ctx->metaInfoInternal	= metaInfoInternal;
    ctx->setOptionInternal	= setOptionInternal;
    ctx->smt25Command	= smt25Command;
    ctx->extendedCommand	= extendedCommand;
    ctx->datatypes_2_5_DefCommand	= datatypes_2_5_DefCommand;
    ctx->datatypeDefCommand	= datatypeDefCommand;
    ctx->datatypesDefCommand	= datatypesDefCommand;
    ctx->rewriterulesCommand	= rewriterulesCommand;
    ctx->rewritePropaKind	= rewritePropaKind;
    ctx->pattern	= pattern;
    ctx->simpleSymbolicExprNoKeyword	= simpleSymbolicExprNoKeyword;
    ctx->keyword	= keyword;
    ctx->simpleSymbolicExpr	= simpleSymbolicExpr;
    ctx->symbolicExpr	= symbolicExpr;
    ctx->term	= term;
    ctx->attribute	= attribute;
    ctx->indexedFunctionName	= indexedFunctionName;
    ctx->badIndexedFunctionName	= badIndexedFunctionName;
    ctx->termList	= termList;
    ctx->str	= str;
    ctx->builtinOp	= builtinOp;
    ctx->quantOp	= quantOp;
    ctx->functionName	= functionName;
    ctx->sortList	= sortList;
    ctx->nonemptySortList	= nonemptySortList;
    ctx->sortedVarList	= sortedVarList;
    ctx->sortName	= sortName;
    ctx->sortSymbol	= sortSymbol;
    ctx->symbolList	= symbolList;
    ctx->symbol	= symbol;
    ctx->nonemptyNumeralList	= nonemptyNumeralList;
    ctx->datatypeDef	= datatypeDef;
    ctx->constructorDef	= constructorDef;
    ctx->selector	= selector;
    ctx->free			= Smt2ParserFree;
    ctx->reset			= Smt2ParserReset;
    ctx->getGrammarFileName	= getGrammarFileName;

    /* Install the scope pushing methods.
     */

    /* Install the token table
     */
    PSRSTATE->tokenNames   = Smt2ParserTokenNames;


    /* Return the newly built parser to the caller
     */
    return  ctx;
}

static void
Smt2ParserReset (pSmt2Parser ctx)
{
    RECOGNIZER->reset(RECOGNIZER);
}

/** Free the parser resources
 */
 static void
 Smt2ParserFree(pSmt2Parser ctx)
 {
    /* Free any scope memory
     */

	// Free this parser
	//
    ctx->pParser->free(ctx->pParser);


    ANTLR3_FREE(ctx);

    /* Everything is released, so we can return
     */
    return;
 }

/** Return token names used by this 
parser

 *
 * The returned pointer is used as an index into the token names table (using the token
 * number as the index).
 *
 * \return Pointer to first char * in the table.
 */
static pANTLR3_UINT8    *getTokenNames()
{
        return Smt2ParserTokenNames;
}


/* Declare the bitsets
 */
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_parseExpr119  */
static	ANTLR3_BITWORD FOLLOW_term_in_parseExpr119_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_parseExpr119	= { FOLLOW_term_in_parseExpr119_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EOF_in_parseExpr126  */
static	ANTLR3_BITWORD FOLLOW_EOF_in_parseExpr126_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EOF_in_parseExpr126	= { FOLLOW_EOF_in_parseExpr126_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_parseCommand155  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_parseCommand155_bits[]	= { ANTLR3_UINT64_LIT(0x00220FDBFF040080), ANTLR3_UINT64_LIT(0xBA70100003FF0000), ANTLR3_UINT64_LIT(0x000000000000001D) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_parseCommand155	= { FOLLOW_LPAREN_TOK_in_parseCommand155_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_command_in_parseCommand157  */
static	ANTLR3_BITWORD FOLLOW_command_in_parseCommand157_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_command_in_parseCommand157	= { FOLLOW_command_in_parseCommand157_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_parseCommand160  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_parseCommand160_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_parseCommand160	= { FOLLOW_RPAREN_TOK_in_parseCommand160_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_parseCommand173  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_parseCommand173_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000080000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_parseCommand173	= { FOLLOW_LPAREN_TOK_in_parseCommand173_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INCLUDE_TOK_in_parseCommand175  */
static	ANTLR3_BITWORD FOLLOW_INCLUDE_TOK_in_parseCommand175_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x00000000000000C0) };
static  ANTLR3_BITSET_LIST FOLLOW_INCLUDE_TOK_in_parseCommand175	= { FOLLOW_INCLUDE_TOK_in_parseCommand175_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_parseCommand177  */
static	ANTLR3_BITWORD FOLLOW_str_in_parseCommand177_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_parseCommand177	= { FOLLOW_str_in_parseCommand177_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_parseCommand180  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_parseCommand180_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_parseCommand180	= { FOLLOW_RPAREN_TOK_in_parseCommand180_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EOF_in_parseCommand193  */
static	ANTLR3_BITWORD FOLLOW_EOF_in_parseCommand193_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EOF_in_parseCommand193	= { FOLLOW_EOF_in_parseCommand193_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_parseSygus222  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_parseSygus222_bits[]	= { ANTLR3_UINT64_LIT(0x00220FFFFF2C0080), ANTLR3_UINT64_LIT(0xBA70101003FF0000), ANTLR3_UINT64_LIT(0x000000000006001D) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_parseSygus222	= { FOLLOW_LPAREN_TOK_in_parseSygus222_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sygusCommand_in_parseSygus224  */
static	ANTLR3_BITWORD FOLLOW_sygusCommand_in_parseSygus224_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sygusCommand_in_parseSygus224	= { FOLLOW_sygusCommand_in_parseSygus224_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_parseSygus227  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_parseSygus227_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_parseSygus227	= { FOLLOW_RPAREN_TOK_in_parseSygus227_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EOF_in_parseSygus233  */
static	ANTLR3_BITWORD FOLLOW_EOF_in_parseSygus233_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EOF_in_parseSygus233	= { FOLLOW_EOF_in_parseSygus233_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SET_LOGIC_TOK_in_command261  */
static	ANTLR3_BITWORD FOLLOW_SET_LOGIC_TOK_in_command261_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_SET_LOGIC_TOK_in_command261	= { FOLLOW_SET_LOGIC_TOK_in_command261_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_command263  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_command263_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_command263	= { FOLLOW_symbol_in_command263_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SET_INFO_TOK_in_command282  */
static	ANTLR3_BITWORD FOLLOW_SET_INFO_TOK_in_command282_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SET_INFO_TOK_in_command282	= { FOLLOW_SET_INFO_TOK_in_command282_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_metaInfoInternal_in_command284  */
static	ANTLR3_BITWORD FOLLOW_metaInfoInternal_in_command284_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_metaInfoInternal_in_command284	= { FOLLOW_metaInfoInternal_in_command284_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_INFO_TOK_in_command297  */
static	ANTLR3_BITWORD FOLLOW_GET_INFO_TOK_in_command297_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_INFO_TOK_in_command297	= { FOLLOW_GET_INFO_TOK_in_command297_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_KEYWORD_in_command299  */
static	ANTLR3_BITWORD FOLLOW_KEYWORD_in_command299_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_KEYWORD_in_command299	= { FOLLOW_KEYWORD_in_command299_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SET_OPTION_TOK_in_command317  */
static	ANTLR3_BITWORD FOLLOW_SET_OPTION_TOK_in_command317_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SET_OPTION_TOK_in_command317	= { FOLLOW_SET_OPTION_TOK_in_command317_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_setOptionInternal_in_command319  */
static	ANTLR3_BITWORD FOLLOW_setOptionInternal_in_command319_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_setOptionInternal_in_command319	= { FOLLOW_setOptionInternal_in_command319_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_OPTION_TOK_in_command332  */
static	ANTLR3_BITWORD FOLLOW_GET_OPTION_TOK_in_command332_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_OPTION_TOK_in_command332	= { FOLLOW_GET_OPTION_TOK_in_command332_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_KEYWORD_in_command334  */
static	ANTLR3_BITWORD FOLLOW_KEYWORD_in_command334_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_KEYWORD_in_command334	= { FOLLOW_KEYWORD_in_command334_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_SORT_TOK_in_command352  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_SORT_TOK_in_command352_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_SORT_TOK_in_command352	= { FOLLOW_DECLARE_SORT_TOK_in_command352_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_command366  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_command366_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_command366	= { FOLLOW_symbol_in_command366_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_command381  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_command381_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_command381	= { FOLLOW_INTEGER_LITERAL_in_command381_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DEFINE_SORT_TOK_in_command399  */
static	ANTLR3_BITWORD FOLLOW_DEFINE_SORT_TOK_in_command399_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_DEFINE_SORT_TOK_in_command399	= { FOLLOW_DEFINE_SORT_TOK_in_command399_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_command407  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_command407_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_command407	= { FOLLOW_symbol_in_command407_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_command420  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_command420_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x4080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_command420	= { FOLLOW_LPAREN_TOK_in_command420_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbolList_in_command422  */
static	ANTLR3_BITWORD FOLLOW_symbolList_in_command422_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbolList_in_command422	= { FOLLOW_symbolList_in_command422_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_command425  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_command425_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080041000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_command425	= { FOLLOW_RPAREN_TOK_in_command425_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_command437  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_command437_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_command437	= { FOLLOW_sortSymbol_in_command437_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_FUN_TOK_in_command456  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_FUN_TOK_in_command456_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_FUN_TOK_in_command456	= { FOLLOW_DECLARE_FUN_TOK_in_command456_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_command464  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_command464_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_command464	= { FOLLOW_symbol_in_command464_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_command477  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_command477_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x4080041000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_command477	= { FOLLOW_LPAREN_TOK_in_command477_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortList_in_command479  */
static	ANTLR3_BITWORD FOLLOW_sortList_in_command479_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortList_in_command479	= { FOLLOW_sortList_in_command479_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_command482  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_command482_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080041000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_command482	= { FOLLOW_RPAREN_TOK_in_command482_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_command488  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_command488_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_command488	= { FOLLOW_sortSymbol_in_command488_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DEFINE_FUN_TOK_in_command507  */
static	ANTLR3_BITWORD FOLLOW_DEFINE_FUN_TOK_in_command507_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_DEFINE_FUN_TOK_in_command507	= { FOLLOW_DEFINE_FUN_TOK_in_command507_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_command515  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_command515_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_command515	= { FOLLOW_symbol_in_command515_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_command528  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_command528_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_command528	= { FOLLOW_LPAREN_TOK_in_command528_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortedVarList_in_command530  */
static	ANTLR3_BITWORD FOLLOW_sortedVarList_in_command530_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortedVarList_in_command530	= { FOLLOW_sortedVarList_in_command530_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_command533  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_command533_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080041000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_command533	= { FOLLOW_RPAREN_TOK_in_command533_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_command539  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_command539_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_command539	= { FOLLOW_sortSymbol_in_command539_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_command552  */
static	ANTLR3_BITWORD FOLLOW_term_in_command552_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_command552	= { FOLLOW_term_in_command552_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_VALUE_TOK_in_command571  */
static	ANTLR3_BITWORD FOLLOW_GET_VALUE_TOK_in_command571_bits[]	= { ANTLR3_UINT64_LIT(0xFFFFFFFFFFFFFFF0), ANTLR3_UINT64_LIT(0xFFFFFFFFFFFFFFFF), ANTLR3_UINT64_LIT(0x000000007FFFFFFF) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_VALUE_TOK_in_command571	= { FOLLOW_GET_VALUE_TOK_in_command571_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_command581  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_command581_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_command581	= { FOLLOW_LPAREN_TOK_in_command581_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termList_in_command583  */
static	ANTLR3_BITWORD FOLLOW_termList_in_command583_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_termList_in_command583	= { FOLLOW_termList_in_command583_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_command586  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_command586_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_command586	= { FOLLOW_RPAREN_TOK_in_command586_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_command602  */
static	ANTLR3_BITWORD FOLLOW_set_in_command602_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_command602	= { FOLLOW_set_in_command602_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_ASSIGNMENT_TOK_in_command629  */
static	ANTLR3_BITWORD FOLLOW_GET_ASSIGNMENT_TOK_in_command629_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_ASSIGNMENT_TOK_in_command629	= { FOLLOW_GET_ASSIGNMENT_TOK_in_command629_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASSERT_TOK_in_command649  */
static	ANTLR3_BITWORD FOLLOW_ASSERT_TOK_in_command649_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_ASSERT_TOK_in_command649	= { FOLLOW_ASSERT_TOK_in_command649_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_command669  */
static	ANTLR3_BITWORD FOLLOW_term_in_command669_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_command669	= { FOLLOW_term_in_command669_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CHECKSAT_TOK_in_command688  */
static	ANTLR3_BITWORD FOLLOW_CHECKSAT_TOK_in_command688_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90002), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_CHECKSAT_TOK_in_command688	= { FOLLOW_CHECKSAT_TOK_in_command688_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_command704  */
static	ANTLR3_BITWORD FOLLOW_term_in_command704_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_command704	= { FOLLOW_term_in_command704_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_ASSERTIONS_TOK_in_command745  */
static	ANTLR3_BITWORD FOLLOW_GET_ASSERTIONS_TOK_in_command745_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_ASSERTIONS_TOK_in_command745	= { FOLLOW_GET_ASSERTIONS_TOK_in_command745_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_PROOF_TOK_in_command765  */
static	ANTLR3_BITWORD FOLLOW_GET_PROOF_TOK_in_command765_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_PROOF_TOK_in_command765	= { FOLLOW_GET_PROOF_TOK_in_command765_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_UNSAT_CORE_TOK_in_command785  */
static	ANTLR3_BITWORD FOLLOW_GET_UNSAT_CORE_TOK_in_command785_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_UNSAT_CORE_TOK_in_command785	= { FOLLOW_GET_UNSAT_CORE_TOK_in_command785_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PUSH_TOK_in_command805  */
static	ANTLR3_BITWORD FOLLOW_PUSH_TOK_in_command805_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_PUSH_TOK_in_command805	= { FOLLOW_PUSH_TOK_in_command805_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_command823  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_command823_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_command823	= { FOLLOW_INTEGER_LITERAL_in_command823_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_POP_TOK_in_command847  */
static	ANTLR3_BITWORD FOLLOW_POP_TOK_in_command847_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_POP_TOK_in_command847	= { FOLLOW_POP_TOK_in_command847_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_command865  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_command865_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_command865	= { FOLLOW_INTEGER_LITERAL_in_command865_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EXIT_TOK_in_command899  */
static	ANTLR3_BITWORD FOLLOW_EXIT_TOK_in_command899_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EXIT_TOK_in_command899	= { FOLLOW_EXIT_TOK_in_command899_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_smt25Command_in_command918  */
static	ANTLR3_BITWORD FOLLOW_smt25Command_in_command918_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_smt25Command_in_command918	= { FOLLOW_smt25Command_in_command918_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_extendedCommand_in_command938  */
static	ANTLR3_BITWORD FOLLOW_extendedCommand_in_command938_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_extendedCommand_in_command938	= { FOLLOW_extendedCommand_in_command938_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SIMPLE_SYMBOL_in_command958  */
static	ANTLR3_BITWORD FOLLOW_SIMPLE_SYMBOL_in_command958_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_SIMPLE_SYMBOL_in_command958	= { FOLLOW_SIMPLE_SYMBOL_in_command958_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_VAR_TOK_in_sygusCommand990  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_VAR_TOK_in_sygusCommand990_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_VAR_TOK_in_sygusCommand990	= { FOLLOW_DECLARE_VAR_TOK_in_sygusCommand990_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sygusCommand998  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sygusCommand998_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080041000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sygusCommand998	= { FOLLOW_symbol_in_sygusCommand998_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sygusCommand1011  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sygusCommand1011_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sygusCommand1011	= { FOLLOW_sortSymbol_in_sygusCommand1011_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_PRIMED_VAR_TOK_in_sygusCommand1030  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_PRIMED_VAR_TOK_in_sygusCommand1030_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_PRIMED_VAR_TOK_in_sygusCommand1030	= { FOLLOW_DECLARE_PRIMED_VAR_TOK_in_sygusCommand1030_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sygusCommand1038  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sygusCommand1038_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080041000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sygusCommand1038	= { FOLLOW_symbol_in_sygusCommand1038_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sygusCommand1051  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sygusCommand1051_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sygusCommand1051	= { FOLLOW_sortSymbol_in_sygusCommand1051_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SYNTH_FUN_TOK_in_sygusCommand1073  */
static	ANTLR3_BITWORD FOLLOW_SYNTH_FUN_TOK_in_sygusCommand1073_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_SYNTH_FUN_TOK_in_sygusCommand1073	= { FOLLOW_SYNTH_FUN_TOK_in_sygusCommand1073_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SYNTH_INV_TOK_in_sygusCommand1077  */
static	ANTLR3_BITWORD FOLLOW_SYNTH_INV_TOK_in_sygusCommand1077_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_SYNTH_INV_TOK_in_sygusCommand1077	= { FOLLOW_SYNTH_INV_TOK_in_sygusCommand1077_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sygusCommand1093  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sygusCommand1093_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sygusCommand1093	= { FOLLOW_symbol_in_sygusCommand1093_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sygusCommand1100  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sygusCommand1100_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sygusCommand1100	= { FOLLOW_LPAREN_TOK_in_sygusCommand1100_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortedVarList_in_sygusCommand1102  */
static	ANTLR3_BITWORD FOLLOW_sortedVarList_in_sygusCommand1102_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortedVarList_in_sygusCommand1102	= { FOLLOW_sortedVarList_in_sygusCommand1102_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sygusCommand1105  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sygusCommand1105_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280002), ANTLR3_UINT64_LIT(0x0080041000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sygusCommand1105	= { FOLLOW_RPAREN_TOK_in_sygusCommand1105_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sygusCommand1119  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sygusCommand1119_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sygusCommand1119	= { FOLLOW_sortSymbol_in_sygusCommand1119_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sygusCommand1133  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sygusCommand1133_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sygusCommand1133	= { FOLLOW_LPAREN_TOK_in_sygusCommand1133_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sygusCommand1141  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sygusCommand1141_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sygusCommand1141	= { FOLLOW_LPAREN_TOK_in_sygusCommand1141_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sygusCommand1149  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sygusCommand1149_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080041000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sygusCommand1149	= { FOLLOW_symbol_in_sygusCommand1149_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sygusCommand1159  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sygusCommand1159_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sygusCommand1159	= { FOLLOW_sortSymbol_in_sygusCommand1159_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sygusCommand1190  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sygusCommand1190_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400290000), ANTLR3_UINT64_LIT(0x0080041820000000), ANTLR3_UINT64_LIT(0x00000000042600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sygusCommand1190	= { FOLLOW_LPAREN_TOK_in_sygusCommand1190_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sygusGTerm_in_sygusCommand1194  */
static	ANTLR3_BITWORD FOLLOW_sygusGTerm_in_sygusCommand1194_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400290000), ANTLR3_UINT64_LIT(0x4080041820000000), ANTLR3_UINT64_LIT(0x00000000042600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_sygusGTerm_in_sygusCommand1194	= { FOLLOW_sygusGTerm_in_sygusCommand1194_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sygusCommand1215  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sygusCommand1215_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sygusCommand1215	= { FOLLOW_RPAREN_TOK_in_sygusCommand1215_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sygusCommand1225  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sygusCommand1225_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sygusCommand1225	= { FOLLOW_RPAREN_TOK_in_sygusCommand1225_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sygusCommand1239  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sygusCommand1239_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sygusCommand1239	= { FOLLOW_RPAREN_TOK_in_sygusCommand1239_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CONSTRAINT_TOK_in_sygusCommand1266  */
static	ANTLR3_BITWORD FOLLOW_CONSTRAINT_TOK_in_sygusCommand1266_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_CONSTRAINT_TOK_in_sygusCommand1266	= { FOLLOW_CONSTRAINT_TOK_in_sygusCommand1266_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_sygusCommand1274  */
static	ANTLR3_BITWORD FOLLOW_term_in_sygusCommand1274_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_sygusCommand1274	= { FOLLOW_term_in_sygusCommand1274_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INV_CONSTRAINT_TOK_in_sygusCommand1287  */
static	ANTLR3_BITWORD FOLLOW_INV_CONSTRAINT_TOK_in_sygusCommand1287_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_INV_CONSTRAINT_TOK_in_sygusCommand1287	= { FOLLOW_INV_CONSTRAINT_TOK_in_sygusCommand1287_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sygusCommand1297  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sygusCommand1297_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280002), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sygusCommand1297	= { FOLLOW_symbol_in_sygusCommand1297_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CHECK_SYNTH_TOK_in_sygusCommand1321  */
static	ANTLR3_BITWORD FOLLOW_CHECK_SYNTH_TOK_in_sygusCommand1321_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_CHECK_SYNTH_TOK_in_sygusCommand1321	= { FOLLOW_CHECK_SYNTH_TOK_in_sygusCommand1321_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_command_in_sygusCommand1339  */
static	ANTLR3_BITWORD FOLLOW_command_in_sygusCommand1339_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_command_in_sygusCommand1339	= { FOLLOW_command_in_sygusCommand1339_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sygusGTerm1380  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sygusGTerm1380_bits[]	= { ANTLR3_UINT64_LIT(0x00C9A024002A0040), ANTLR3_UINT64_LIT(0x008AA3B24C000000), ANTLR3_UINT64_LIT(0x0000000004A6592A) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sygusGTerm1380	= { FOLLOW_LPAREN_TOK_in_sygusGTerm1380_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_builtinOp_in_sygusGTerm1393  */
static	ANTLR3_BITWORD FOLLOW_builtinOp_in_sygusGTerm1393_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400290000), ANTLR3_UINT64_LIT(0x4080041820000000), ANTLR3_UINT64_LIT(0x00000000042600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_builtinOp_in_sygusGTerm1393	= { FOLLOW_builtinOp_in_sygusGTerm1393_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LET_TOK_in_sygusGTerm1404  */
static	ANTLR3_BITWORD FOLLOW_LET_TOK_in_sygusGTerm1404_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LET_TOK_in_sygusGTerm1404	= { FOLLOW_LET_TOK_in_sygusGTerm1404_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sygusGTerm1406  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sygusGTerm1406_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sygusGTerm1406	= { FOLLOW_LPAREN_TOK_in_sygusGTerm1406_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sygusGTerm1419  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sygusGTerm1419_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sygusGTerm1419	= { FOLLOW_LPAREN_TOK_in_sygusGTerm1419_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sygusGTerm1430  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sygusGTerm1430_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080041000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sygusGTerm1430	= { FOLLOW_symbol_in_sygusGTerm1430_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sygusGTerm1442  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sygusGTerm1442_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400290000), ANTLR3_UINT64_LIT(0x0080041820000000), ANTLR3_UINT64_LIT(0x00000000042600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sygusGTerm1442	= { FOLLOW_sortSymbol_in_sygusGTerm1442_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sygusGTerm_in_sygusGTerm1456  */
static	ANTLR3_BITWORD FOLLOW_sygusGTerm_in_sygusGTerm1456_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sygusGTerm_in_sygusGTerm1456	= { FOLLOW_sygusGTerm_in_sygusGTerm1456_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sygusGTerm1467  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sygusGTerm1467_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sygusGTerm1467	= { FOLLOW_RPAREN_TOK_in_sygusGTerm1467_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sygusGTerm1472  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sygusGTerm1472_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400290000), ANTLR3_UINT64_LIT(0x4080041820000000), ANTLR3_UINT64_LIT(0x00000000042600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sygusGTerm1472	= { FOLLOW_RPAREN_TOK_in_sygusGTerm1472_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SYGUS_CONSTANT_TOK_in_sygusGTerm1480  */
static	ANTLR3_BITWORD FOLLOW_SYGUS_CONSTANT_TOK_in_sygusGTerm1480_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080041000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_SYGUS_CONSTANT_TOK_in_sygusGTerm1480	= { FOLLOW_SYGUS_CONSTANT_TOK_in_sygusGTerm1480_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sygusGTerm1482  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sygusGTerm1482_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400290000), ANTLR3_UINT64_LIT(0x4080041820000000), ANTLR3_UINT64_LIT(0x00000000042600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sygusGTerm1482	= { FOLLOW_sortSymbol_in_sygusGTerm1482_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SYGUS_VARIABLE_TOK_in_sygusGTerm1500  */
static	ANTLR3_BITWORD FOLLOW_SYGUS_VARIABLE_TOK_in_sygusGTerm1500_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080041000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_SYGUS_VARIABLE_TOK_in_sygusGTerm1500	= { FOLLOW_SYGUS_VARIABLE_TOK_in_sygusGTerm1500_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sygusGTerm1502  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sygusGTerm1502_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400290000), ANTLR3_UINT64_LIT(0x4080041820000000), ANTLR3_UINT64_LIT(0x00000000042600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sygusGTerm1502	= { FOLLOW_sortSymbol_in_sygusGTerm1502_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SYGUS_LOCAL_VARIABLE_TOK_in_sygusGTerm1519  */
static	ANTLR3_BITWORD FOLLOW_SYGUS_LOCAL_VARIABLE_TOK_in_sygusGTerm1519_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080041000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_SYGUS_LOCAL_VARIABLE_TOK_in_sygusGTerm1519	= { FOLLOW_SYGUS_LOCAL_VARIABLE_TOK_in_sygusGTerm1519_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sygusGTerm1521  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sygusGTerm1521_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400290000), ANTLR3_UINT64_LIT(0x4080041820000000), ANTLR3_UINT64_LIT(0x00000000042600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sygusGTerm1521	= { FOLLOW_sortSymbol_in_sygusGTerm1521_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SYGUS_INPUT_VARIABLE_TOK_in_sygusGTerm1538  */
static	ANTLR3_BITWORD FOLLOW_SYGUS_INPUT_VARIABLE_TOK_in_sygusGTerm1538_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080041000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_SYGUS_INPUT_VARIABLE_TOK_in_sygusGTerm1538	= { FOLLOW_SYGUS_INPUT_VARIABLE_TOK_in_sygusGTerm1538_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sygusGTerm1540  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sygusGTerm1540_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400290000), ANTLR3_UINT64_LIT(0x4080041820000000), ANTLR3_UINT64_LIT(0x00000000042600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sygusGTerm1540	= { FOLLOW_sortSymbol_in_sygusGTerm1540_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sygusGTerm1557  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sygusGTerm1557_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400290000), ANTLR3_UINT64_LIT(0x4080041820000000), ANTLR3_UINT64_LIT(0x00000000042600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sygusGTerm1557	= { FOLLOW_symbol_in_sygusGTerm1557_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sygusGTerm_in_sygusGTerm1585  */
static	ANTLR3_BITWORD FOLLOW_sygusGTerm_in_sygusGTerm1585_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400290000), ANTLR3_UINT64_LIT(0x4080041820000000), ANTLR3_UINT64_LIT(0x00000000042600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_sygusGTerm_in_sygusGTerm1585	= { FOLLOW_sygusGTerm_in_sygusGTerm1585_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sygusGTerm1608  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sygusGTerm1608_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sygusGTerm1608	= { FOLLOW_RPAREN_TOK_in_sygusGTerm1608_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_sygusGTerm1616  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_sygusGTerm1616_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_sygusGTerm1616	= { FOLLOW_INTEGER_LITERAL_in_sygusGTerm1616_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HEX_LITERAL_in_sygusGTerm1628  */
static	ANTLR3_BITWORD FOLLOW_HEX_LITERAL_in_sygusGTerm1628_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_HEX_LITERAL_in_sygusGTerm1628	= { FOLLOW_HEX_LITERAL_in_sygusGTerm1628_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BINARY_LITERAL_in_sygusGTerm1640  */
static	ANTLR3_BITWORD FOLLOW_BINARY_LITERAL_in_sygusGTerm1640_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BINARY_LITERAL_in_sygusGTerm1640	= { FOLLOW_BINARY_LITERAL_in_sygusGTerm1640_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_sygusGTerm1652  */
static	ANTLR3_BITWORD FOLLOW_str_in_sygusGTerm1652_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_sygusGTerm1652	= { FOLLOW_str_in_sygusGTerm1652_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sygusGTerm1665  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sygusGTerm1665_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sygusGTerm1665	= { FOLLOW_symbol_in_sygusGTerm1665_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SYGUS_ENUM_CONS_TOK_in_sygusGTerm1674  */
static	ANTLR3_BITWORD FOLLOW_SYGUS_ENUM_CONS_TOK_in_sygusGTerm1674_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_SYGUS_ENUM_CONS_TOK_in_sygusGTerm1674	= { FOLLOW_SYGUS_ENUM_CONS_TOK_in_sygusGTerm1674_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sygusGTerm1676  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sygusGTerm1676_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sygusGTerm1676	= { FOLLOW_symbol_in_sygusGTerm1676_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_KEYWORD_in_metaInfoInternal1718  */
static	ANTLR3_BITWORD FOLLOW_KEYWORD_in_metaInfoInternal1718_bits[]	= { ANTLR3_UINT64_LIT(0x00EBA7B520AF00C0), ANTLR3_UINT64_LIT(0xBAFAA5FA6F3F0000), ANTLR3_UINT64_LIT(0x0000000004A600FF) };
static  ANTLR3_BITSET_LIST FOLLOW_KEYWORD_in_metaInfoInternal1718	= { FOLLOW_KEYWORD_in_metaInfoInternal1718_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbolicExpr_in_metaInfoInternal1720  */
static	ANTLR3_BITWORD FOLLOW_symbolicExpr_in_metaInfoInternal1720_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbolicExpr_in_metaInfoInternal1720	= { FOLLOW_symbolicExpr_in_metaInfoInternal1720_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_keyword_in_setOptionInternal1746  */
static	ANTLR3_BITWORD FOLLOW_keyword_in_setOptionInternal1746_bits[]	= { ANTLR3_UINT64_LIT(0x00EBA7B520AF00C0), ANTLR3_UINT64_LIT(0xBAFAA5FA6F3F0000), ANTLR3_UINT64_LIT(0x0000000004A600FF) };
static  ANTLR3_BITSET_LIST FOLLOW_keyword_in_setOptionInternal1746	= { FOLLOW_keyword_in_setOptionInternal1746_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbolicExpr_in_setOptionInternal1749  */
static	ANTLR3_BITWORD FOLLOW_symbolicExpr_in_setOptionInternal1749_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbolicExpr_in_setOptionInternal1749	= { FOLLOW_symbolicExpr_in_setOptionInternal1749_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_META_INFO_TOK_in_smt25Command1781  */
static	ANTLR3_BITWORD FOLLOW_META_INFO_TOK_in_smt25Command1781_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_META_INFO_TOK_in_smt25Command1781	= { FOLLOW_META_INFO_TOK_in_smt25Command1781_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_metaInfoInternal_in_smt25Command1783  */
static	ANTLR3_BITWORD FOLLOW_metaInfoInternal_in_smt25Command1783_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_metaInfoInternal_in_smt25Command1783	= { FOLLOW_metaInfoInternal_in_smt25Command1783_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_CONST_TOK_in_smt25Command1797  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_CONST_TOK_in_smt25Command1797_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_CONST_TOK_in_smt25Command1797	= { FOLLOW_DECLARE_CONST_TOK_in_smt25Command1797_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_smt25Command1805  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_smt25Command1805_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080041000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_smt25Command1805	= { FOLLOW_symbol_in_smt25Command1805_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_smt25Command1818  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_smt25Command1818_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_smt25Command1818	= { FOLLOW_sortSymbol_in_smt25Command1818_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_MODEL_TOK_in_smt25Command1838  */
static	ANTLR3_BITWORD FOLLOW_GET_MODEL_TOK_in_smt25Command1838_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_MODEL_TOK_in_smt25Command1838	= { FOLLOW_GET_MODEL_TOK_in_smt25Command1838_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ECHO_TOK_in_smt25Command1859  */
static	ANTLR3_BITWORD FOLLOW_ECHO_TOK_in_smt25Command1859_bits[]	= { ANTLR3_UINT64_LIT(0x00EBA7B520AF00C2), ANTLR3_UINT64_LIT(0xBAFAA1FA6F3F0000), ANTLR3_UINT64_LIT(0x0000000004A600FF) };
static  ANTLR3_BITSET_LIST FOLLOW_ECHO_TOK_in_smt25Command1859	= { FOLLOW_ECHO_TOK_in_smt25Command1859_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleSymbolicExpr_in_smt25Command1867  */
static	ANTLR3_BITWORD FOLLOW_simpleSymbolicExpr_in_smt25Command1867_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleSymbolicExpr_in_smt25Command1867	= { FOLLOW_simpleSymbolicExpr_in_smt25Command1867_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RESET_TOK_in_smt25Command1903  */
static	ANTLR3_BITWORD FOLLOW_RESET_TOK_in_smt25Command1903_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RESET_TOK_in_smt25Command1903	= { FOLLOW_RESET_TOK_in_smt25Command1903_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RESET_ASSERTIONS_TOK_in_smt25Command1921  */
static	ANTLR3_BITWORD FOLLOW_RESET_ASSERTIONS_TOK_in_smt25Command1921_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RESET_ASSERTIONS_TOK_in_smt25Command1921	= { FOLLOW_RESET_ASSERTIONS_TOK_in_smt25Command1921_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DEFINE_FUN_REC_TOK_in_smt25Command1933  */
static	ANTLR3_BITWORD FOLLOW_DEFINE_FUN_REC_TOK_in_smt25Command1933_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_DEFINE_FUN_REC_TOK_in_smt25Command1933	= { FOLLOW_DEFINE_FUN_REC_TOK_in_smt25Command1933_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_smt25Command1945  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_smt25Command1945_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_smt25Command1945	= { FOLLOW_symbol_in_smt25Command1945_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_smt25Command1958  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_smt25Command1958_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_smt25Command1958	= { FOLLOW_LPAREN_TOK_in_smt25Command1958_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortedVarList_in_smt25Command1960  */
static	ANTLR3_BITWORD FOLLOW_sortedVarList_in_smt25Command1960_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortedVarList_in_smt25Command1960	= { FOLLOW_sortedVarList_in_smt25Command1960_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_smt25Command1963  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_smt25Command1963_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080041000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_smt25Command1963	= { FOLLOW_RPAREN_TOK_in_smt25Command1963_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_smt25Command1969  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_smt25Command1969_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_smt25Command1969	= { FOLLOW_sortSymbol_in_smt25Command1969_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_smt25Command1982  */
static	ANTLR3_BITWORD FOLLOW_term_in_smt25Command1982_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_smt25Command1982	= { FOLLOW_term_in_smt25Command1982_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DEFINE_FUNS_REC_TOK_in_smt25Command1995  */
static	ANTLR3_BITWORD FOLLOW_DEFINE_FUNS_REC_TOK_in_smt25Command1995_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DEFINE_FUNS_REC_TOK_in_smt25Command1995	= { FOLLOW_DEFINE_FUNS_REC_TOK_in_smt25Command1995_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_smt25Command2007  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_smt25Command2007_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_smt25Command2007	= { FOLLOW_LPAREN_TOK_in_smt25Command2007_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_smt25Command2015  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_smt25Command2015_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_smt25Command2015	= { FOLLOW_LPAREN_TOK_in_smt25Command2015_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_smt25Command2023  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_smt25Command2023_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_smt25Command2023	= { FOLLOW_symbol_in_smt25Command2023_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_smt25Command2040  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_smt25Command2040_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_smt25Command2040	= { FOLLOW_LPAREN_TOK_in_smt25Command2040_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortedVarList_in_smt25Command2042  */
static	ANTLR3_BITWORD FOLLOW_sortedVarList_in_smt25Command2042_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortedVarList_in_smt25Command2042	= { FOLLOW_sortedVarList_in_smt25Command2042_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_smt25Command2045  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_smt25Command2045_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080041000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_smt25Command2045	= { FOLLOW_RPAREN_TOK_in_smt25Command2045_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_smt25Command2053  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_smt25Command2053_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_smt25Command2053	= { FOLLOW_sortSymbol_in_smt25Command2053_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_smt25Command2070  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_smt25Command2070_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_smt25Command2070	= { FOLLOW_RPAREN_TOK_in_smt25Command2070_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_smt25Command2083  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_smt25Command2083_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_smt25Command2083	= { FOLLOW_RPAREN_TOK_in_smt25Command2083_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_smt25Command2089  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_smt25Command2089_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_smt25Command2089	= { FOLLOW_LPAREN_TOK_in_smt25Command2089_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_smt25Command2107  */
static	ANTLR3_BITWORD FOLLOW_term_in_smt25Command2107_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x45804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_smt25Command2107	= { FOLLOW_term_in_smt25Command2107_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_smt25Command2127  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_smt25Command2127_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_smt25Command2127	= { FOLLOW_RPAREN_TOK_in_smt25Command2127_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_DATATYPES_2_5_TOK_in_extendedCommand2164  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_DATATYPES_2_5_TOK_in_extendedCommand2164_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_DATATYPES_2_5_TOK_in_extendedCommand2164	= { FOLLOW_DECLARE_DATATYPES_2_5_TOK_in_extendedCommand2164_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypes_2_5_DefCommand_in_extendedCommand2166  */
static	ANTLR3_BITWORD FOLLOW_datatypes_2_5_DefCommand_in_extendedCommand2166_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypes_2_5_DefCommand_in_extendedCommand2166	= { FOLLOW_datatypes_2_5_DefCommand_in_extendedCommand2166_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_CODATATYPES_2_5_TOK_in_extendedCommand2173  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_CODATATYPES_2_5_TOK_in_extendedCommand2173_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_CODATATYPES_2_5_TOK_in_extendedCommand2173	= { FOLLOW_DECLARE_CODATATYPES_2_5_TOK_in_extendedCommand2173_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypes_2_5_DefCommand_in_extendedCommand2175  */
static	ANTLR3_BITWORD FOLLOW_datatypes_2_5_DefCommand_in_extendedCommand2175_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypes_2_5_DefCommand_in_extendedCommand2175	= { FOLLOW_datatypes_2_5_DefCommand_in_extendedCommand2175_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_DATATYPE_TOK_in_extendedCommand2182  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_DATATYPE_TOK_in_extendedCommand2182_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_DATATYPE_TOK_in_extendedCommand2182	= { FOLLOW_DECLARE_DATATYPE_TOK_in_extendedCommand2182_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypeDefCommand_in_extendedCommand2184  */
static	ANTLR3_BITWORD FOLLOW_datatypeDefCommand_in_extendedCommand2184_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypeDefCommand_in_extendedCommand2184	= { FOLLOW_datatypeDefCommand_in_extendedCommand2184_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_CODATATYPE_TOK_in_extendedCommand2191  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_CODATATYPE_TOK_in_extendedCommand2191_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_CODATATYPE_TOK_in_extendedCommand2191	= { FOLLOW_DECLARE_CODATATYPE_TOK_in_extendedCommand2191_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypeDefCommand_in_extendedCommand2193  */
static	ANTLR3_BITWORD FOLLOW_datatypeDefCommand_in_extendedCommand2193_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypeDefCommand_in_extendedCommand2193	= { FOLLOW_datatypeDefCommand_in_extendedCommand2193_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_DATATYPES_TOK_in_extendedCommand2200  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_DATATYPES_TOK_in_extendedCommand2200_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_DATATYPES_TOK_in_extendedCommand2200	= { FOLLOW_DECLARE_DATATYPES_TOK_in_extendedCommand2200_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypesDefCommand_in_extendedCommand2202  */
static	ANTLR3_BITWORD FOLLOW_datatypesDefCommand_in_extendedCommand2202_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypesDefCommand_in_extendedCommand2202	= { FOLLOW_datatypesDefCommand_in_extendedCommand2202_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_CODATATYPES_TOK_in_extendedCommand2209  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_CODATATYPES_TOK_in_extendedCommand2209_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_CODATATYPES_TOK_in_extendedCommand2209	= { FOLLOW_DECLARE_CODATATYPES_TOK_in_extendedCommand2209_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypesDefCommand_in_extendedCommand2211  */
static	ANTLR3_BITWORD FOLLOW_datatypesDefCommand_in_extendedCommand2211_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypesDefCommand_in_extendedCommand2211	= { FOLLOW_datatypesDefCommand_in_extendedCommand2211_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_rewriterulesCommand_in_extendedCommand2218  */
static	ANTLR3_BITWORD FOLLOW_rewriterulesCommand_in_extendedCommand2218_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_rewriterulesCommand_in_extendedCommand2218	= { FOLLOW_rewriterulesCommand_in_extendedCommand2218_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_SORTS_TOK_in_extendedCommand2233  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_SORTS_TOK_in_extendedCommand2233_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_SORTS_TOK_in_extendedCommand2233	= { FOLLOW_DECLARE_SORTS_TOK_in_extendedCommand2233_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_extendedCommand2253  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_extendedCommand2253_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_extendedCommand2253	= { FOLLOW_LPAREN_TOK_in_extendedCommand2253_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_extendedCommand2261  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_extendedCommand2261_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x4080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_extendedCommand2261	= { FOLLOW_symbol_in_extendedCommand2261_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_extendedCommand2283  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_extendedCommand2283_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_extendedCommand2283	= { FOLLOW_RPAREN_TOK_in_extendedCommand2283_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_FUNS_TOK_in_extendedCommand2296  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_FUNS_TOK_in_extendedCommand2296_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_FUNS_TOK_in_extendedCommand2296	= { FOLLOW_DECLARE_FUNS_TOK_in_extendedCommand2296_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_extendedCommand2310  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_extendedCommand2310_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_extendedCommand2310	= { FOLLOW_LPAREN_TOK_in_extendedCommand2310_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_extendedCommand2318  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_extendedCommand2318_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_extendedCommand2318	= { FOLLOW_LPAREN_TOK_in_extendedCommand2318_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_extendedCommand2320  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_extendedCommand2320_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080041000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_extendedCommand2320	= { FOLLOW_symbol_in_extendedCommand2320_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nonemptySortList_in_extendedCommand2337  */
static	ANTLR3_BITWORD FOLLOW_nonemptySortList_in_extendedCommand2337_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_nonemptySortList_in_extendedCommand2337	= { FOLLOW_nonemptySortList_in_extendedCommand2337_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_extendedCommand2340  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_extendedCommand2340_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_extendedCommand2340	= { FOLLOW_RPAREN_TOK_in_extendedCommand2340_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_extendedCommand2361  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_extendedCommand2361_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_extendedCommand2361	= { FOLLOW_RPAREN_TOK_in_extendedCommand2361_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_PREDS_TOK_in_extendedCommand2374  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_PREDS_TOK_in_extendedCommand2374_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_PREDS_TOK_in_extendedCommand2374	= { FOLLOW_DECLARE_PREDS_TOK_in_extendedCommand2374_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_extendedCommand2388  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_extendedCommand2388_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_extendedCommand2388	= { FOLLOW_LPAREN_TOK_in_extendedCommand2388_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_extendedCommand2396  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_extendedCommand2396_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_extendedCommand2396	= { FOLLOW_LPAREN_TOK_in_extendedCommand2396_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_extendedCommand2398  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_extendedCommand2398_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x4080041000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_extendedCommand2398	= { FOLLOW_symbol_in_extendedCommand2398_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortList_in_extendedCommand2415  */
static	ANTLR3_BITWORD FOLLOW_sortList_in_extendedCommand2415_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortList_in_extendedCommand2415	= { FOLLOW_sortList_in_extendedCommand2415_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_extendedCommand2418  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_extendedCommand2418_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_extendedCommand2418	= { FOLLOW_RPAREN_TOK_in_extendedCommand2418_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_extendedCommand2439  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_extendedCommand2439_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_extendedCommand2439	= { FOLLOW_RPAREN_TOK_in_extendedCommand2439_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DEFINE_TOK_in_extendedCommand2452  */
static	ANTLR3_BITWORD FOLLOW_DEFINE_TOK_in_extendedCommand2452_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080041000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_DEFINE_TOK_in_extendedCommand2452	= { FOLLOW_DEFINE_TOK_in_extendedCommand2452_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_extendedCommand2462  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_extendedCommand2462_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_extendedCommand2462	= { FOLLOW_symbol_in_extendedCommand2462_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_extendedCommand2479  */
static	ANTLR3_BITWORD FOLLOW_term_in_extendedCommand2479_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_extendedCommand2479	= { FOLLOW_term_in_extendedCommand2479_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_extendedCommand2496  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_extendedCommand2496_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_extendedCommand2496	= { FOLLOW_LPAREN_TOK_in_extendedCommand2496_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_extendedCommand2504  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_extendedCommand2504_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_extendedCommand2504	= { FOLLOW_symbol_in_extendedCommand2504_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortedVarList_in_extendedCommand2521  */
static	ANTLR3_BITWORD FOLLOW_sortedVarList_in_extendedCommand2521_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortedVarList_in_extendedCommand2521	= { FOLLOW_sortedVarList_in_extendedCommand2521_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_extendedCommand2524  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_extendedCommand2524_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_extendedCommand2524	= { FOLLOW_RPAREN_TOK_in_extendedCommand2524_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_extendedCommand2540  */
static	ANTLR3_BITWORD FOLLOW_term_in_extendedCommand2540_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_extendedCommand2540	= { FOLLOW_term_in_extendedCommand2540_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DEFINE_CONST_TOK_in_extendedCommand2561  */
static	ANTLR3_BITWORD FOLLOW_DEFINE_CONST_TOK_in_extendedCommand2561_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_DEFINE_CONST_TOK_in_extendedCommand2561	= { FOLLOW_DEFINE_CONST_TOK_in_extendedCommand2561_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_extendedCommand2569  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_extendedCommand2569_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080041000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_extendedCommand2569	= { FOLLOW_symbol_in_extendedCommand2569_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_extendedCommand2582  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_extendedCommand2582_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_extendedCommand2582	= { FOLLOW_sortSymbol_in_extendedCommand2582_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_extendedCommand2595  */
static	ANTLR3_BITWORD FOLLOW_term_in_extendedCommand2595_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_extendedCommand2595	= { FOLLOW_term_in_extendedCommand2595_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SIMPLIFY_TOK_in_extendedCommand2609  */
static	ANTLR3_BITWORD FOLLOW_SIMPLIFY_TOK_in_extendedCommand2609_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_SIMPLIFY_TOK_in_extendedCommand2609	= { FOLLOW_SIMPLIFY_TOK_in_extendedCommand2609_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_extendedCommand2617  */
static	ANTLR3_BITWORD FOLLOW_term_in_extendedCommand2617_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_extendedCommand2617	= { FOLLOW_term_in_extendedCommand2617_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_QE_TOK_in_extendedCommand2630  */
static	ANTLR3_BITWORD FOLLOW_GET_QE_TOK_in_extendedCommand2630_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_QE_TOK_in_extendedCommand2630	= { FOLLOW_GET_QE_TOK_in_extendedCommand2630_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_extendedCommand2638  */
static	ANTLR3_BITWORD FOLLOW_term_in_extendedCommand2638_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_extendedCommand2638	= { FOLLOW_term_in_extendedCommand2638_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_QE_DISJUNCT_TOK_in_extendedCommand2651  */
static	ANTLR3_BITWORD FOLLOW_GET_QE_DISJUNCT_TOK_in_extendedCommand2651_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_QE_DISJUNCT_TOK_in_extendedCommand2651	= { FOLLOW_GET_QE_DISJUNCT_TOK_in_extendedCommand2651_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_extendedCommand2659  */
static	ANTLR3_BITWORD FOLLOW_term_in_extendedCommand2659_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_extendedCommand2659	= { FOLLOW_term_in_extendedCommand2659_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand2690  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand2690_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x4080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand2690	= { FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand2690_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_datatypes_2_5_DefCommand2698  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_datatypes_2_5_DefCommand2698_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x4080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_datatypes_2_5_DefCommand2698	= { FOLLOW_symbol_in_datatypes_2_5_DefCommand2698_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand2714  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand2714_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand2714	= { FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand2714_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand2718  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand2718_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand2718	= { FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand2718_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand2722  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand2722_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand2722	= { FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand2722_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypeDef_in_datatypes_2_5_DefCommand2724  */
static	ANTLR3_BITWORD FOLLOW_datatypeDef_in_datatypes_2_5_DefCommand2724_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypeDef_in_datatypes_2_5_DefCommand2724	= { FOLLOW_datatypeDef_in_datatypes_2_5_DefCommand2724_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand2727  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand2727_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand2727	= { FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand2727_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand2732  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand2732_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand2732	= { FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand2732_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_datatypeDefCommand2761  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_datatypeDefCommand2761_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_datatypeDefCommand2761	= { FOLLOW_symbol_in_datatypeDefCommand2761_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypeDefCommand2764  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypeDefCommand2764_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypeDefCommand2764	= { FOLLOW_LPAREN_TOK_in_datatypeDefCommand2764_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypeDefCommand2772  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypeDefCommand2772_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypeDefCommand2772	= { FOLLOW_LPAREN_TOK_in_datatypeDefCommand2772_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_constructorDef_in_datatypeDefCommand2774  */
static	ANTLR3_BITWORD FOLLOW_constructorDef_in_datatypeDefCommand2774_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_constructorDef_in_datatypeDefCommand2774	= { FOLLOW_constructorDef_in_datatypeDefCommand2774_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypeDefCommand2777  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypeDefCommand2777_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypeDefCommand2777	= { FOLLOW_RPAREN_TOK_in_datatypeDefCommand2777_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypeDefCommand2783  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypeDefCommand2783_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypeDefCommand2783	= { FOLLOW_RPAREN_TOK_in_datatypeDefCommand2783_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypesDefCommand2810  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypesDefCommand2810_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypesDefCommand2810	= { FOLLOW_LPAREN_TOK_in_datatypesDefCommand2810_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypesDefCommand2818  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypesDefCommand2818_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypesDefCommand2818	= { FOLLOW_LPAREN_TOK_in_datatypesDefCommand2818_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_datatypesDefCommand2820  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_datatypesDefCommand2820_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_datatypesDefCommand2820	= { FOLLOW_symbol_in_datatypesDefCommand2820_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_datatypesDefCommand2825  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_datatypesDefCommand2825_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_datatypesDefCommand2825	= { FOLLOW_INTEGER_LITERAL_in_datatypesDefCommand2825_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypesDefCommand2827  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypesDefCommand2827_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypesDefCommand2827	= { FOLLOW_RPAREN_TOK_in_datatypesDefCommand2827_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypesDefCommand2842  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypesDefCommand2842_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypesDefCommand2842	= { FOLLOW_RPAREN_TOK_in_datatypesDefCommand2842_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypesDefCommand2847  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypesDefCommand2847_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypesDefCommand2847	= { FOLLOW_LPAREN_TOK_in_datatypesDefCommand2847_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypesDefCommand2854  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypesDefCommand2854_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0004040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypesDefCommand2854	= { FOLLOW_LPAREN_TOK_in_datatypesDefCommand2854_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PAR_TOK_in_datatypesDefCommand2864  */
static	ANTLR3_BITWORD FOLLOW_PAR_TOK_in_datatypesDefCommand2864_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_PAR_TOK_in_datatypesDefCommand2864	= { FOLLOW_PAR_TOK_in_datatypesDefCommand2864_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypesDefCommand2868  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypesDefCommand2868_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x4080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypesDefCommand2868	= { FOLLOW_LPAREN_TOK_in_datatypesDefCommand2868_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_datatypesDefCommand2878  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_datatypesDefCommand2878_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x4080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_datatypesDefCommand2878	= { FOLLOW_symbol_in_datatypesDefCommand2878_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypesDefCommand2906  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypesDefCommand2906_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypesDefCommand2906	= { FOLLOW_RPAREN_TOK_in_datatypesDefCommand2906_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypesDefCommand2916  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypesDefCommand2916_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypesDefCommand2916	= { FOLLOW_LPAREN_TOK_in_datatypesDefCommand2916_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypesDefCommand2926  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypesDefCommand2926_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypesDefCommand2926	= { FOLLOW_LPAREN_TOK_in_datatypesDefCommand2926_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_constructorDef_in_datatypesDefCommand2928  */
static	ANTLR3_BITWORD FOLLOW_constructorDef_in_datatypesDefCommand2928_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_constructorDef_in_datatypesDefCommand2928	= { FOLLOW_constructorDef_in_datatypesDefCommand2928_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypesDefCommand2931  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypesDefCommand2931_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypesDefCommand2931	= { FOLLOW_RPAREN_TOK_in_datatypesDefCommand2931_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypesDefCommand2942  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypesDefCommand2942_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypesDefCommand2942	= { FOLLOW_RPAREN_TOK_in_datatypesDefCommand2942_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypesDefCommand2963  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypesDefCommand2963_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypesDefCommand2963	= { FOLLOW_LPAREN_TOK_in_datatypesDefCommand2963_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_constructorDef_in_datatypesDefCommand2965  */
static	ANTLR3_BITWORD FOLLOW_constructorDef_in_datatypesDefCommand2965_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_constructorDef_in_datatypesDefCommand2965	= { FOLLOW_constructorDef_in_datatypesDefCommand2965_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypesDefCommand2968  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypesDefCommand2968_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypesDefCommand2968	= { FOLLOW_RPAREN_TOK_in_datatypesDefCommand2968_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypesDefCommand2983  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypesDefCommand2983_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypesDefCommand2983	= { FOLLOW_RPAREN_TOK_in_datatypesDefCommand2983_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypesDefCommand2994  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypesDefCommand2994_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypesDefCommand2994	= { FOLLOW_RPAREN_TOK_in_datatypesDefCommand2994_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REWRITE_RULE_TOK_in_rewriterulesCommand3023  */
static	ANTLR3_BITWORD FOLLOW_REWRITE_RULE_TOK_in_rewriterulesCommand3023_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_REWRITE_RULE_TOK_in_rewriterulesCommand3023	= { FOLLOW_REWRITE_RULE_TOK_in_rewriterulesCommand3023_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_rewriterulesCommand3029  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_rewriterulesCommand3029_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_rewriterulesCommand3029	= { FOLLOW_LPAREN_TOK_in_rewriterulesCommand3029_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortedVarList_in_rewriterulesCommand3031  */
static	ANTLR3_BITWORD FOLLOW_sortedVarList_in_rewriterulesCommand3031_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortedVarList_in_rewriterulesCommand3031	= { FOLLOW_sortedVarList_in_rewriterulesCommand3031_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_rewriterulesCommand3034  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_rewriterulesCommand3034_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_rewriterulesCommand3034	= { FOLLOW_RPAREN_TOK_in_rewriterulesCommand3034_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_rewriterulesCommand3046  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_rewriterulesCommand3046_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_rewriterulesCommand3046	= { FOLLOW_LPAREN_TOK_in_rewriterulesCommand3046_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_pattern_in_rewriterulesCommand3050  */
static	ANTLR3_BITWORD FOLLOW_pattern_in_rewriterulesCommand3050_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_pattern_in_rewriterulesCommand3050	= { FOLLOW_pattern_in_rewriterulesCommand3050_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_rewriterulesCommand3058  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_rewriterulesCommand3058_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_rewriterulesCommand3058	= { FOLLOW_RPAREN_TOK_in_rewriterulesCommand3058_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_rewriterulesCommand3064  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_rewriterulesCommand3064_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x45804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_rewriterulesCommand3064	= { FOLLOW_LPAREN_TOK_in_rewriterulesCommand3064_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termList_in_rewriterulesCommand3067  */
static	ANTLR3_BITWORD FOLLOW_termList_in_rewriterulesCommand3067_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_termList_in_rewriterulesCommand3067	= { FOLLOW_termList_in_rewriterulesCommand3067_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_rewriterulesCommand3072  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_rewriterulesCommand3072_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_rewriterulesCommand3072	= { FOLLOW_RPAREN_TOK_in_rewriterulesCommand3072_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_rewriterulesCommand3078  */
static	ANTLR3_BITWORD FOLLOW_term_in_rewriterulesCommand3078_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_rewriterulesCommand3078	= { FOLLOW_term_in_rewriterulesCommand3078_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_rewriterulesCommand3081  */
static	ANTLR3_BITWORD FOLLOW_term_in_rewriterulesCommand3081_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_rewriterulesCommand3081	= { FOLLOW_term_in_rewriterulesCommand3081_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_rewritePropaKind_in_rewriterulesCommand3100  */
static	ANTLR3_BITWORD FOLLOW_rewritePropaKind_in_rewriterulesCommand3100_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_rewritePropaKind_in_rewriterulesCommand3100	= { FOLLOW_rewritePropaKind_in_rewriterulesCommand3100_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_rewriterulesCommand3107  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_rewriterulesCommand3107_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_rewriterulesCommand3107	= { FOLLOW_LPAREN_TOK_in_rewriterulesCommand3107_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortedVarList_in_rewriterulesCommand3109  */
static	ANTLR3_BITWORD FOLLOW_sortedVarList_in_rewriterulesCommand3109_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortedVarList_in_rewriterulesCommand3109	= { FOLLOW_sortedVarList_in_rewriterulesCommand3109_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_rewriterulesCommand3112  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_rewriterulesCommand3112_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_rewriterulesCommand3112	= { FOLLOW_RPAREN_TOK_in_rewriterulesCommand3112_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_rewriterulesCommand3124  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_rewriterulesCommand3124_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_rewriterulesCommand3124	= { FOLLOW_LPAREN_TOK_in_rewriterulesCommand3124_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_pattern_in_rewriterulesCommand3128  */
static	ANTLR3_BITWORD FOLLOW_pattern_in_rewriterulesCommand3128_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_pattern_in_rewriterulesCommand3128	= { FOLLOW_pattern_in_rewriterulesCommand3128_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_rewriterulesCommand3136  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_rewriterulesCommand3136_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_rewriterulesCommand3136	= { FOLLOW_RPAREN_TOK_in_rewriterulesCommand3136_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_rewriterulesCommand3142  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_rewriterulesCommand3142_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x45804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_rewriterulesCommand3142	= { FOLLOW_LPAREN_TOK_in_rewriterulesCommand3142_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termList_in_rewriterulesCommand3145  */
static	ANTLR3_BITWORD FOLLOW_termList_in_rewriterulesCommand3145_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_termList_in_rewriterulesCommand3145	= { FOLLOW_termList_in_rewriterulesCommand3145_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_rewriterulesCommand3150  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_rewriterulesCommand3150_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_rewriterulesCommand3150	= { FOLLOW_RPAREN_TOK_in_rewriterulesCommand3150_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_rewriterulesCommand3156  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_rewriterulesCommand3156_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x45804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_rewriterulesCommand3156	= { FOLLOW_LPAREN_TOK_in_rewriterulesCommand3156_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termList_in_rewriterulesCommand3159  */
static	ANTLR3_BITWORD FOLLOW_termList_in_rewriterulesCommand3159_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_termList_in_rewriterulesCommand3159	= { FOLLOW_termList_in_rewriterulesCommand3159_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_rewriterulesCommand3164  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_rewriterulesCommand3164_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_rewriterulesCommand3164	= { FOLLOW_RPAREN_TOK_in_rewriterulesCommand3164_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_rewriterulesCommand3170  */
static	ANTLR3_BITWORD FOLLOW_term_in_rewriterulesCommand3170_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_rewriterulesCommand3170	= { FOLLOW_term_in_rewriterulesCommand3170_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REDUCTION_RULE_TOK_in_rewritePropaKind3191  */
static	ANTLR3_BITWORD FOLLOW_REDUCTION_RULE_TOK_in_rewritePropaKind3191_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_REDUCTION_RULE_TOK_in_rewritePropaKind3191	= { FOLLOW_REDUCTION_RULE_TOK_in_rewritePropaKind3191_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PROPAGATION_RULE_TOK_in_rewritePropaKind3202  */
static	ANTLR3_BITWORD FOLLOW_PROPAGATION_RULE_TOK_in_rewritePropaKind3202_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_PROPAGATION_RULE_TOK_in_rewritePropaKind3202	= { FOLLOW_PROPAGATION_RULE_TOK_in_rewritePropaKind3202_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_pattern3224  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_pattern3224_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_pattern3224	= { FOLLOW_LPAREN_TOK_in_pattern3224_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termList_in_pattern3226  */
static	ANTLR3_BITWORD FOLLOW_termList_in_pattern3226_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_termList_in_pattern3226	= { FOLLOW_termList_in_pattern3226_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_pattern3229  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_pattern3229_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_pattern3229	= { FOLLOW_RPAREN_TOK_in_pattern3229_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExprNoKeyword3254  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExprNoKeyword3254_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExprNoKeyword3254	= { FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExprNoKeyword3254_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExprNoKeyword3266  */
static	ANTLR3_BITWORD FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExprNoKeyword3266_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExprNoKeyword3266	= { FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExprNoKeyword3266_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HEX_LITERAL_in_simpleSymbolicExprNoKeyword3278  */
static	ANTLR3_BITWORD FOLLOW_HEX_LITERAL_in_simpleSymbolicExprNoKeyword3278_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_HEX_LITERAL_in_simpleSymbolicExprNoKeyword3278	= { FOLLOW_HEX_LITERAL_in_simpleSymbolicExprNoKeyword3278_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BINARY_LITERAL_in_simpleSymbolicExprNoKeyword3290  */
static	ANTLR3_BITWORD FOLLOW_BINARY_LITERAL_in_simpleSymbolicExprNoKeyword3290_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BINARY_LITERAL_in_simpleSymbolicExprNoKeyword3290	= { FOLLOW_BINARY_LITERAL_in_simpleSymbolicExprNoKeyword3290_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_simpleSymbolicExprNoKeyword3302  */
static	ANTLR3_BITWORD FOLLOW_str_in_simpleSymbolicExprNoKeyword3302_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_simpleSymbolicExprNoKeyword3302	= { FOLLOW_str_in_simpleSymbolicExprNoKeyword3302_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_simpleSymbolicExprNoKeyword3322  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_simpleSymbolicExprNoKeyword3322_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_simpleSymbolicExprNoKeyword3322	= { FOLLOW_symbol_in_simpleSymbolicExprNoKeyword3322_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_simpleSymbolicExprNoKeyword3337  */
static	ANTLR3_BITWORD FOLLOW_set_in_simpleSymbolicExprNoKeyword3337_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_simpleSymbolicExprNoKeyword3337	= { FOLLOW_set_in_simpleSymbolicExprNoKeyword3337_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_builtinOp_in_simpleSymbolicExprNoKeyword3523  */
static	ANTLR3_BITWORD FOLLOW_builtinOp_in_simpleSymbolicExprNoKeyword3523_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_builtinOp_in_simpleSymbolicExprNoKeyword3523	= { FOLLOW_builtinOp_in_simpleSymbolicExprNoKeyword3523_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_KEYWORD_in_keyword3544  */
static	ANTLR3_BITWORD FOLLOW_KEYWORD_in_keyword3544_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_KEYWORD_in_keyword3544	= { FOLLOW_KEYWORD_in_keyword3544_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleSymbolicExprNoKeyword_in_simpleSymbolicExpr3564  */
static	ANTLR3_BITWORD FOLLOW_simpleSymbolicExprNoKeyword_in_simpleSymbolicExpr3564_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleSymbolicExprNoKeyword_in_simpleSymbolicExpr3564	= { FOLLOW_simpleSymbolicExprNoKeyword_in_simpleSymbolicExpr3564_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_KEYWORD_in_simpleSymbolicExpr3571  */
static	ANTLR3_BITWORD FOLLOW_KEYWORD_in_simpleSymbolicExpr3571_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_KEYWORD_in_simpleSymbolicExpr3571	= { FOLLOW_KEYWORD_in_simpleSymbolicExpr3571_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleSymbolicExpr_in_symbolicExpr3596  */
static	ANTLR3_BITWORD FOLLOW_simpleSymbolicExpr_in_symbolicExpr3596_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleSymbolicExpr_in_symbolicExpr3596	= { FOLLOW_simpleSymbolicExpr_in_symbolicExpr3596_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_symbolicExpr3603  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_symbolicExpr3603_bits[]	= { ANTLR3_UINT64_LIT(0x00EBA7B520AF00C0), ANTLR3_UINT64_LIT(0xFAFAA5FA6F3F0000), ANTLR3_UINT64_LIT(0x0000000004A600FF) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_symbolicExpr3603	= { FOLLOW_LPAREN_TOK_in_symbolicExpr3603_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbolicExpr_in_symbolicExpr3611  */
static	ANTLR3_BITWORD FOLLOW_symbolicExpr_in_symbolicExpr3611_bits[]	= { ANTLR3_UINT64_LIT(0x00EBA7B520AF00C0), ANTLR3_UINT64_LIT(0xFAFAA5FA6F3F0000), ANTLR3_UINT64_LIT(0x0000000004A600FF) };
static  ANTLR3_BITSET_LIST FOLLOW_symbolicExpr_in_symbolicExpr3611	= { FOLLOW_symbolicExpr_in_symbolicExpr3611_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_symbolicExpr3619  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_symbolicExpr3619_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_symbolicExpr3619	= { FOLLOW_RPAREN_TOK_in_symbolicExpr3619_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_term3652  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_term3652_bits[]	= { ANTLR3_UINT64_LIT(0x00C9A00000020040), ANTLR3_UINT64_LIT(0x000AA1A24C000000), ANTLR3_UINT64_LIT(0x0000000000800020) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_term3652	= { FOLLOW_LPAREN_TOK_in_term3652_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_builtinOp_in_term3654  */
static	ANTLR3_BITWORD FOLLOW_builtinOp_in_term3654_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_builtinOp_in_term3654	= { FOLLOW_builtinOp_in_term3654_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termList_in_term3657  */
static	ANTLR3_BITWORD FOLLOW_termList_in_term3657_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_termList_in_term3657	= { FOLLOW_termList_in_term3657_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_term3660  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_term3660_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_term3660	= { FOLLOW_RPAREN_TOK_in_term3660_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_term3672  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_term3672_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000100) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_term3672	= { FOLLOW_LPAREN_TOK_in_term3672_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_AS_TOK_in_term3674  */
static	ANTLR3_BITWORD FOLLOW_AS_TOK_in_term3674_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_AS_TOK_in_term3674	= { FOLLOW_AS_TOK_in_term3674_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_term3676  */
static	ANTLR3_BITWORD FOLLOW_term_in_term3676_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080041000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_term3676	= { FOLLOW_term_in_term3676_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_term3679  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_term3679_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_term3679	= { FOLLOW_sortSymbol_in_term3679_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_term3682  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_term3682_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_term3682	= { FOLLOW_RPAREN_TOK_in_term3682_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_term3694  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_term3694_bits[]	= { ANTLR3_UINT64_LIT(0x0110000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_term3694	= { FOLLOW_LPAREN_TOK_in_term3694_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_quantOp_in_term3696  */
static	ANTLR3_BITWORD FOLLOW_quantOp_in_term3696_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_quantOp_in_term3696	= { FOLLOW_quantOp_in_term3696_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_term3703  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_term3703_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_term3703	= { FOLLOW_LPAREN_TOK_in_term3703_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortedVarList_in_term3705  */
static	ANTLR3_BITWORD FOLLOW_sortedVarList_in_term3705_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortedVarList_in_term3705	= { FOLLOW_sortedVarList_in_term3705_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_term3708  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_term3708_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_term3708	= { FOLLOW_RPAREN_TOK_in_term3708_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_term3720  */
static	ANTLR3_BITWORD FOLLOW_term_in_term3720_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_term3720	= { FOLLOW_term_in_term3720_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_term3723  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_term3723_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_term3723	= { FOLLOW_RPAREN_TOK_in_term3723_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_term3735  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_term3735_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_term3735	= { FOLLOW_LPAREN_TOK_in_term3735_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_functionName_in_term3737  */
static	ANTLR3_BITWORD FOLLOW_functionName_in_term3737_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_functionName_in_term3737	= { FOLLOW_functionName_in_term3737_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termList_in_term3755  */
static	ANTLR3_BITWORD FOLLOW_termList_in_term3755_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_termList_in_term3755	= { FOLLOW_termList_in_term3755_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_term3758  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_term3758_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_term3758	= { FOLLOW_RPAREN_TOK_in_term3758_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_term3771  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_term3771_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_term3771	= { FOLLOW_LPAREN_TOK_in_term3771_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_indexedFunctionName_in_term3787  */
static	ANTLR3_BITWORD FOLLOW_indexedFunctionName_in_term3787_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_indexedFunctionName_in_term3787	= { FOLLOW_indexedFunctionName_in_term3787_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termList_in_term3790  */
static	ANTLR3_BITWORD FOLLOW_termList_in_term3790_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_termList_in_term3790	= { FOLLOW_termList_in_term3790_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_term3793  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_term3793_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_term3793	= { FOLLOW_RPAREN_TOK_in_term3793_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_term3817  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_term3817_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000100) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_term3817	= { FOLLOW_LPAREN_TOK_in_term3817_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_AS_TOK_in_term3819  */
static	ANTLR3_BITWORD FOLLOW_AS_TOK_in_term3819_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000400000) };
static  ANTLR3_BITSET_LIST FOLLOW_AS_TOK_in_term3819	= { FOLLOW_AS_TOK_in_term3819_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CONST_TOK_in_term3821  */
static	ANTLR3_BITWORD FOLLOW_CONST_TOK_in_term3821_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080041000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_CONST_TOK_in_term3821	= { FOLLOW_CONST_TOK_in_term3821_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_term3823  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_term3823_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_term3823	= { FOLLOW_sortSymbol_in_term3823_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_term3832  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_term3832_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_term3832	= { FOLLOW_RPAREN_TOK_in_term3832_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_term3834  */
static	ANTLR3_BITWORD FOLLOW_term_in_term3834_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_term3834	= { FOLLOW_term_in_term3834_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_term3837  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_term3837_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_term3837	= { FOLLOW_RPAREN_TOK_in_term3837_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_term3863  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_term3863_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_term3863	= { FOLLOW_LPAREN_TOK_in_term3863_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LET_TOK_in_term3865  */
static	ANTLR3_BITWORD FOLLOW_LET_TOK_in_term3865_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LET_TOK_in_term3865	= { FOLLOW_LET_TOK_in_term3865_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_term3867  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_term3867_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_term3867	= { FOLLOW_LPAREN_TOK_in_term3867_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_term3881  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_term3881_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_term3881	= { FOLLOW_LPAREN_TOK_in_term3881_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_term3883  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_term3883_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_term3883	= { FOLLOW_symbol_in_term3883_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_term3893  */
static	ANTLR3_BITWORD FOLLOW_term_in_term3893_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_term3893	= { FOLLOW_term_in_term3893_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_term3898  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_term3898_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_term3898	= { FOLLOW_sortSymbol_in_term3898_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_term3910  */
static	ANTLR3_BITWORD FOLLOW_term_in_term3910_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_term3910	= { FOLLOW_term_in_term3910_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_term3927  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_term3927_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_term3927	= { FOLLOW_RPAREN_TOK_in_term3927_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_term3964  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_term3964_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_term3964	= { FOLLOW_RPAREN_TOK_in_term3964_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_term3970  */
static	ANTLR3_BITWORD FOLLOW_term_in_term3970_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_term3970	= { FOLLOW_term_in_term3970_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_term3977  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_term3977_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_term3977	= { FOLLOW_RPAREN_TOK_in_term3977_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_term3995  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_term3995_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000080000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_term3995	= { FOLLOW_LPAREN_TOK_in_term3995_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_MATCH_TOK_in_term3997  */
static	ANTLR3_BITWORD FOLLOW_MATCH_TOK_in_term3997_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_MATCH_TOK_in_term3997	= { FOLLOW_MATCH_TOK_in_term3997_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_term3999  */
static	ANTLR3_BITWORD FOLLOW_term_in_term3999_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_term3999	= { FOLLOW_term_in_term3999_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_term4008  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_term4008_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_term4008	= { FOLLOW_LPAREN_TOK_in_term4008_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_term4032  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_term4032_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000100000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_term4032	= { FOLLOW_LPAREN_TOK_in_term4032_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INDEX_TOK_in_term4034  */
static	ANTLR3_BITWORD FOLLOW_INDEX_TOK_in_term4034_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_INDEX_TOK_in_term4034	= { FOLLOW_INDEX_TOK_in_term4034_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_term4036  */
static	ANTLR3_BITWORD FOLLOW_term_in_term4036_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_term4036	= { FOLLOW_term_in_term4036_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_term4049  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_term4049_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_term4049	= { FOLLOW_RPAREN_TOK_in_term4049_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_term4059  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_term4059_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_term4059	= { FOLLOW_LPAREN_TOK_in_term4059_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_term4061  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_term4061_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_term4061	= { FOLLOW_LPAREN_TOK_in_term4061_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_term4063  */
static	ANTLR3_BITWORD FOLLOW_term_in_term4063_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x4080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_term4063	= { FOLLOW_term_in_term4063_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_term4089  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_term4089_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x4080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_term4089	= { FOLLOW_symbol_in_term4089_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_term4115  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_term4115_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_term4115	= { FOLLOW_RPAREN_TOK_in_term4115_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_term4126  */
static	ANTLR3_BITWORD FOLLOW_term_in_term4126_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_term4126	= { FOLLOW_term_in_term4126_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_term4140  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_term4140_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_term4140	= { FOLLOW_RPAREN_TOK_in_term4140_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_term4163  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_term4163_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_term4163	= { FOLLOW_LPAREN_TOK_in_term4163_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_term4165  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_term4165_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_term4165	= { FOLLOW_symbol_in_term4165_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_term4179  */
static	ANTLR3_BITWORD FOLLOW_term_in_term4179_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_term4179	= { FOLLOW_term_in_term4179_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_term4193  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_term4193_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_term4193	= { FOLLOW_RPAREN_TOK_in_term4193_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_term4206  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_term4206_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_term4206	= { FOLLOW_RPAREN_TOK_in_term4206_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_term4208  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_term4208_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_term4208	= { FOLLOW_RPAREN_TOK_in_term4208_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_term4217  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_term4217_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_term4217	= { FOLLOW_symbol_in_term4217_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SYGUS_ENUM_CONS_TOK_in_term4220  */
static	ANTLR3_BITWORD FOLLOW_SYGUS_ENUM_CONS_TOK_in_term4220_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_SYGUS_ENUM_CONS_TOK_in_term4220	= { FOLLOW_SYGUS_ENUM_CONS_TOK_in_term4220_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_term4226  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_term4226_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_term4226	= { FOLLOW_symbol_in_term4226_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_term4245  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_term4245_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_term4245	= { FOLLOW_symbol_in_term4245_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_term4265  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_term4265_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000004000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_term4265	= { FOLLOW_LPAREN_TOK_in_term4265_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ATTRIBUTE_TOK_in_term4267  */
static	ANTLR3_BITWORD FOLLOW_ATTRIBUTE_TOK_in_term4267_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_ATTRIBUTE_TOK_in_term4267	= { FOLLOW_ATTRIBUTE_TOK_in_term4267_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_term4269  */
static	ANTLR3_BITWORD FOLLOW_term_in_term4269_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000003E00), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_term4269	= { FOLLOW_term_in_term4269_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_attribute_in_term4278  */
static	ANTLR3_BITWORD FOLLOW_attribute_in_term4278_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000003E00), ANTLR3_UINT64_LIT(0x4000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_attribute_in_term4278	= { FOLLOW_attribute_in_term4278_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_term4296  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_term4296_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_term4296	= { FOLLOW_RPAREN_TOK_in_term4296_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_term4314  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_term4314_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_term4314	= { FOLLOW_INTEGER_LITERAL_in_term4314_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECIMAL_LITERAL_in_term4327  */
static	ANTLR3_BITWORD FOLLOW_DECIMAL_LITERAL_in_term4327_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DECIMAL_LITERAL_in_term4327	= { FOLLOW_DECIMAL_LITERAL_in_term4327_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_term4340  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_term4340_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000100000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_term4340	= { FOLLOW_LPAREN_TOK_in_term4340_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INDEX_TOK_in_term4342  */
static	ANTLR3_BITWORD FOLLOW_INDEX_TOK_in_term4342_bits[]	= { ANTLR3_UINT64_LIT(0x1600000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_INDEX_TOK_in_term4342	= { FOLLOW_INDEX_TOK_in_term4342_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SIMPLE_SYMBOL_in_term4353  */
static	ANTLR3_BITWORD FOLLOW_SIMPLE_SYMBOL_in_term4353_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SIMPLE_SYMBOL_in_term4353	= { FOLLOW_SIMPLE_SYMBOL_in_term4353_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_term4357  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_term4357_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_term4357	= { FOLLOW_INTEGER_LITERAL_in_term4357_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_PINF_TOK_in_term4374  */
static	ANTLR3_BITWORD FOLLOW_FP_PINF_TOK_in_term4374_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_PINF_TOK_in_term4374	= { FOLLOW_FP_PINF_TOK_in_term4374_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_term4378  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_term4378_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_term4378	= { FOLLOW_INTEGER_LITERAL_in_term4378_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_term4382  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_term4382_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_term4382	= { FOLLOW_INTEGER_LITERAL_in_term4382_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_NINF_TOK_in_term4398  */
static	ANTLR3_BITWORD FOLLOW_FP_NINF_TOK_in_term4398_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_NINF_TOK_in_term4398	= { FOLLOW_FP_NINF_TOK_in_term4398_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_term4402  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_term4402_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_term4402	= { FOLLOW_INTEGER_LITERAL_in_term4402_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_term4406  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_term4406_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_term4406	= { FOLLOW_INTEGER_LITERAL_in_term4406_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_NAN_TOK_in_term4422  */
static	ANTLR3_BITWORD FOLLOW_FP_NAN_TOK_in_term4422_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_NAN_TOK_in_term4422	= { FOLLOW_FP_NAN_TOK_in_term4422_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_term4426  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_term4426_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_term4426	= { FOLLOW_INTEGER_LITERAL_in_term4426_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_term4430  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_term4430_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_term4430	= { FOLLOW_INTEGER_LITERAL_in_term4430_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_term4456  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_term4456_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_term4456	= { FOLLOW_RPAREN_TOK_in_term4456_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HEX_LITERAL_in_term4463  */
static	ANTLR3_BITWORD FOLLOW_HEX_LITERAL_in_term4463_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_HEX_LITERAL_in_term4463	= { FOLLOW_HEX_LITERAL_in_term4463_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BINARY_LITERAL_in_term4476  */
static	ANTLR3_BITWORD FOLLOW_BINARY_LITERAL_in_term4476_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BINARY_LITERAL_in_term4476	= { FOLLOW_BINARY_LITERAL_in_term4476_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_term4489  */
static	ANTLR3_BITWORD FOLLOW_str_in_term4489_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_term4489	= { FOLLOW_str_in_term4489_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_RNE_TOK_in_term4502  */
static	ANTLR3_BITWORD FOLLOW_FP_RNE_TOK_in_term4502_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_RNE_TOK_in_term4502	= { FOLLOW_FP_RNE_TOK_in_term4502_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_RNA_TOK_in_term4515  */
static	ANTLR3_BITWORD FOLLOW_FP_RNA_TOK_in_term4515_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_RNA_TOK_in_term4515	= { FOLLOW_FP_RNA_TOK_in_term4515_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_RTP_TOK_in_term4528  */
static	ANTLR3_BITWORD FOLLOW_FP_RTP_TOK_in_term4528_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_RTP_TOK_in_term4528	= { FOLLOW_FP_RTP_TOK_in_term4528_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_RTN_TOK_in_term4541  */
static	ANTLR3_BITWORD FOLLOW_FP_RTN_TOK_in_term4541_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_RTN_TOK_in_term4541	= { FOLLOW_FP_RTN_TOK_in_term4541_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_RTZ_TOK_in_term4554  */
static	ANTLR3_BITWORD FOLLOW_FP_RTZ_TOK_in_term4554_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_RTZ_TOK_in_term4554	= { FOLLOW_FP_RTZ_TOK_in_term4554_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_RNE_FULL_TOK_in_term4567  */
static	ANTLR3_BITWORD FOLLOW_FP_RNE_FULL_TOK_in_term4567_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_RNE_FULL_TOK_in_term4567	= { FOLLOW_FP_RNE_FULL_TOK_in_term4567_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_RNA_FULL_TOK_in_term4575  */
static	ANTLR3_BITWORD FOLLOW_FP_RNA_FULL_TOK_in_term4575_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_RNA_FULL_TOK_in_term4575	= { FOLLOW_FP_RNA_FULL_TOK_in_term4575_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_RTP_FULL_TOK_in_term4583  */
static	ANTLR3_BITWORD FOLLOW_FP_RTP_FULL_TOK_in_term4583_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_RTP_FULL_TOK_in_term4583	= { FOLLOW_FP_RTP_FULL_TOK_in_term4583_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_RTN_FULL_TOK_in_term4591  */
static	ANTLR3_BITWORD FOLLOW_FP_RTN_FULL_TOK_in_term4591_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_RTN_FULL_TOK_in_term4591	= { FOLLOW_FP_RTN_FULL_TOK_in_term4591_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_RTZ_FULL_TOK_in_term4599  */
static	ANTLR3_BITWORD FOLLOW_FP_RTZ_FULL_TOK_in_term4599_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_RTZ_FULL_TOK_in_term4599	= { FOLLOW_FP_RTZ_FULL_TOK_in_term4599_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RENOSTR_TOK_in_term4608  */
static	ANTLR3_BITWORD FOLLOW_RENOSTR_TOK_in_term4608_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RENOSTR_TOK_in_term4608	= { FOLLOW_RENOSTR_TOK_in_term4608_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REALLCHAR_TOK_in_term4621  */
static	ANTLR3_BITWORD FOLLOW_REALLCHAR_TOK_in_term4621_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_REALLCHAR_TOK_in_term4621	= { FOLLOW_REALLCHAR_TOK_in_term4621_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EMPTYSET_TOK_in_term4634  */
static	ANTLR3_BITWORD FOLLOW_EMPTYSET_TOK_in_term4634_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EMPTYSET_TOK_in_term4634	= { FOLLOW_EMPTYSET_TOK_in_term4634_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_UNIVSET_TOK_in_term4647  */
static	ANTLR3_BITWORD FOLLOW_UNIVSET_TOK_in_term4647_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_UNIVSET_TOK_in_term4647	= { FOLLOW_UNIVSET_TOK_in_term4647_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NILREF_TOK_in_term4660  */
static	ANTLR3_BITWORD FOLLOW_NILREF_TOK_in_term4660_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_NILREF_TOK_in_term4660	= { FOLLOW_NILREF_TOK_in_term4660_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_KEYWORD_in_attribute4692  */
static	ANTLR3_BITWORD FOLLOW_KEYWORD_in_attribute4692_bits[]	= { ANTLR3_UINT64_LIT(0x00EBA7B520AF00C2), ANTLR3_UINT64_LIT(0xBAFAA1BA6F3F0000), ANTLR3_UINT64_LIT(0x0000000004A600FF) };
static  ANTLR3_BITSET_LIST FOLLOW_KEYWORD_in_attribute4692	= { FOLLOW_KEYWORD_in_attribute4692_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleSymbolicExprNoKeyword_in_attribute4696  */
static	ANTLR3_BITWORD FOLLOW_simpleSymbolicExprNoKeyword_in_attribute4696_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleSymbolicExprNoKeyword_in_attribute4696	= { FOLLOW_simpleSymbolicExprNoKeyword_in_attribute4696_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ATTRIBUTE_PATTERN_TOK_in_attribute4712  */
static	ANTLR3_BITWORD FOLLOW_ATTRIBUTE_PATTERN_TOK_in_attribute4712_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_ATTRIBUTE_PATTERN_TOK_in_attribute4712	= { FOLLOW_ATTRIBUTE_PATTERN_TOK_in_attribute4712_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_attribute4714  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_attribute4714_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_attribute4714	= { FOLLOW_LPAREN_TOK_in_attribute4714_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_attribute4722  */
static	ANTLR3_BITWORD FOLLOW_term_in_attribute4722_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x45804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_attribute4722	= { FOLLOW_term_in_attribute4722_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_attribute4740  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_attribute4740_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_attribute4740	= { FOLLOW_RPAREN_TOK_in_attribute4740_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ATTRIBUTE_NO_PATTERN_TOK_in_attribute4752  */
static	ANTLR3_BITWORD FOLLOW_ATTRIBUTE_NO_PATTERN_TOK_in_attribute4752_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_ATTRIBUTE_NO_PATTERN_TOK_in_attribute4752	= { FOLLOW_ATTRIBUTE_NO_PATTERN_TOK_in_attribute4752_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_attribute4754  */
static	ANTLR3_BITWORD FOLLOW_term_in_attribute4754_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_attribute4754	= { FOLLOW_term_in_attribute4754_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_attribute4769  */
static	ANTLR3_BITWORD FOLLOW_set_in_attribute4769_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_attribute4769	= { FOLLOW_set_in_attribute4769_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_attribute4779  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_attribute4779_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_attribute4779	= { FOLLOW_INTEGER_LITERAL_in_attribute4779_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ATTRIBUTE_NAMED_TOK_in_attribute4791  */
static	ANTLR3_BITWORD FOLLOW_ATTRIBUTE_NAMED_TOK_in_attribute4791_bits[]	= { ANTLR3_UINT64_LIT(0x00EBA7B520AF00C0), ANTLR3_UINT64_LIT(0xBAFAA5FA6F3F0000), ANTLR3_UINT64_LIT(0x0000000004A600FF) };
static  ANTLR3_BITSET_LIST FOLLOW_ATTRIBUTE_NAMED_TOK_in_attribute4791	= { FOLLOW_ATTRIBUTE_NAMED_TOK_in_attribute4791_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbolicExpr_in_attribute4793  */
static	ANTLR3_BITWORD FOLLOW_symbolicExpr_in_attribute4793_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbolicExpr_in_attribute4793	= { FOLLOW_symbolicExpr_in_attribute4793_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_indexedFunctionName4821  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_indexedFunctionName4821_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000100000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_indexedFunctionName4821	= { FOLLOW_LPAREN_TOK_in_indexedFunctionName4821_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INDEX_TOK_in_indexedFunctionName4823  */
static	ANTLR3_BITWORD FOLLOW_INDEX_TOK_in_indexedFunctionName4823_bits[]	= { ANTLR3_UINT64_LIT(0x3E00400000000000), ANTLR3_UINT64_LIT(0x008000040000FF00), ANTLR3_UINT64_LIT(0x000000007E280008) };
static  ANTLR3_BITSET_LIST FOLLOW_INDEX_TOK_in_indexedFunctionName4823	= { FOLLOW_INDEX_TOK_in_indexedFunctionName4823_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_153_in_indexedFunctionName4831  */
static	ANTLR3_BITWORD FOLLOW_153_in_indexedFunctionName4831_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_153_in_indexedFunctionName4831	= { FOLLOW_153_in_indexedFunctionName4831_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4835  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4835_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4835	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4835_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4839  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4839_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4839	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4839_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_154_in_indexedFunctionName4855  */
static	ANTLR3_BITWORD FOLLOW_154_in_indexedFunctionName4855_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_154_in_indexedFunctionName4855	= { FOLLOW_154_in_indexedFunctionName4855_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4859  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4859_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4859	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4859_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_158_in_indexedFunctionName4875  */
static	ANTLR3_BITWORD FOLLOW_158_in_indexedFunctionName4875_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_158_in_indexedFunctionName4875	= { FOLLOW_158_in_indexedFunctionName4875_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4879  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4879_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4879	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4879_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_157_in_indexedFunctionName4895  */
static	ANTLR3_BITWORD FOLLOW_157_in_indexedFunctionName4895_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_157_in_indexedFunctionName4895	= { FOLLOW_157_in_indexedFunctionName4895_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4899  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4899_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4899	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4899_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_155_in_indexedFunctionName4915  */
static	ANTLR3_BITWORD FOLLOW_155_in_indexedFunctionName4915_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_155_in_indexedFunctionName4915	= { FOLLOW_155_in_indexedFunctionName4915_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4919  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4919_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4919	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4919_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_156_in_indexedFunctionName4935  */
static	ANTLR3_BITWORD FOLLOW_156_in_indexedFunctionName4935_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_156_in_indexedFunctionName4935	= { FOLLOW_156_in_indexedFunctionName4935_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4939  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4939_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4939	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4939_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DIVISIBLE_TOK_in_indexedFunctionName4955  */
static	ANTLR3_BITWORD FOLLOW_DIVISIBLE_TOK_in_indexedFunctionName4955_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DIVISIBLE_TOK_in_indexedFunctionName4955	= { FOLLOW_DIVISIBLE_TOK_in_indexedFunctionName4955_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4959  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4959_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4959	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4959_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INT2BV_TOK_in_indexedFunctionName4975  */
static	ANTLR3_BITWORD FOLLOW_INT2BV_TOK_in_indexedFunctionName4975_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INT2BV_TOK_in_indexedFunctionName4975	= { FOLLOW_INT2BV_TOK_in_indexedFunctionName4975_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4979  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4979_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4979	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4979_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_PINF_TOK_in_indexedFunctionName4995  */
static	ANTLR3_BITWORD FOLLOW_FP_PINF_TOK_in_indexedFunctionName4995_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_PINF_TOK_in_indexedFunctionName4995	= { FOLLOW_FP_PINF_TOK_in_indexedFunctionName4995_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4999  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4999_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4999	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4999_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5003  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5003_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5003	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5003_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_NINF_TOK_in_indexedFunctionName5019  */
static	ANTLR3_BITWORD FOLLOW_FP_NINF_TOK_in_indexedFunctionName5019_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_NINF_TOK_in_indexedFunctionName5019	= { FOLLOW_FP_NINF_TOK_in_indexedFunctionName5019_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5023  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5023_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5023	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5023_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5027  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5027_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5027	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5027_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_NAN_TOK_in_indexedFunctionName5043  */
static	ANTLR3_BITWORD FOLLOW_FP_NAN_TOK_in_indexedFunctionName5043_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_NAN_TOK_in_indexedFunctionName5043	= { FOLLOW_FP_NAN_TOK_in_indexedFunctionName5043_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5047  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5047_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5047	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5047_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5051  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5051_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5051	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5051_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_PZERO_TOK_in_indexedFunctionName5067  */
static	ANTLR3_BITWORD FOLLOW_FP_PZERO_TOK_in_indexedFunctionName5067_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_PZERO_TOK_in_indexedFunctionName5067	= { FOLLOW_FP_PZERO_TOK_in_indexedFunctionName5067_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5071  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5071_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5071	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5071_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5075  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5075_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5075	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5075_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_NZERO_TOK_in_indexedFunctionName5091  */
static	ANTLR3_BITWORD FOLLOW_FP_NZERO_TOK_in_indexedFunctionName5091_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_NZERO_TOK_in_indexedFunctionName5091	= { FOLLOW_FP_NZERO_TOK_in_indexedFunctionName5091_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5095  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5095_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5095	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5095_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5099  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5099_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5099	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5099_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_TO_FP_TOK_in_indexedFunctionName5115  */
static	ANTLR3_BITWORD FOLLOW_FP_TO_FP_TOK_in_indexedFunctionName5115_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_TO_FP_TOK_in_indexedFunctionName5115	= { FOLLOW_FP_TO_FP_TOK_in_indexedFunctionName5115_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5119  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5119_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5119	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5119_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5123  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5123_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5123	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5123_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_TO_FPBV_TOK_in_indexedFunctionName5139  */
static	ANTLR3_BITWORD FOLLOW_FP_TO_FPBV_TOK_in_indexedFunctionName5139_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_TO_FPBV_TOK_in_indexedFunctionName5139	= { FOLLOW_FP_TO_FPBV_TOK_in_indexedFunctionName5139_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5143  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5143_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5143	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5143_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5147  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5147_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5147	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5147_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_TO_FPFP_TOK_in_indexedFunctionName5163  */
static	ANTLR3_BITWORD FOLLOW_FP_TO_FPFP_TOK_in_indexedFunctionName5163_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_TO_FPFP_TOK_in_indexedFunctionName5163	= { FOLLOW_FP_TO_FPFP_TOK_in_indexedFunctionName5163_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5167  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5167_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5167	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5167_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5171  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5171_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5171	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5171_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_TO_FPR_TOK_in_indexedFunctionName5187  */
static	ANTLR3_BITWORD FOLLOW_FP_TO_FPR_TOK_in_indexedFunctionName5187_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_TO_FPR_TOK_in_indexedFunctionName5187	= { FOLLOW_FP_TO_FPR_TOK_in_indexedFunctionName5187_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5191  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5191_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5191	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5191_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5195  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5195_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5195	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5195_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_TO_FPS_TOK_in_indexedFunctionName5211  */
static	ANTLR3_BITWORD FOLLOW_FP_TO_FPS_TOK_in_indexedFunctionName5211_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_TO_FPS_TOK_in_indexedFunctionName5211	= { FOLLOW_FP_TO_FPS_TOK_in_indexedFunctionName5211_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5215  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5215_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5215	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5215_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5219  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5219_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5219	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5219_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_TO_FPU_TOK_in_indexedFunctionName5235  */
static	ANTLR3_BITWORD FOLLOW_FP_TO_FPU_TOK_in_indexedFunctionName5235_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_TO_FPU_TOK_in_indexedFunctionName5235	= { FOLLOW_FP_TO_FPU_TOK_in_indexedFunctionName5235_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5239  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5239_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5239	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5239_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5243  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5243_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5243	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5243_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_TO_UBV_TOK_in_indexedFunctionName5259  */
static	ANTLR3_BITWORD FOLLOW_FP_TO_UBV_TOK_in_indexedFunctionName5259_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_TO_UBV_TOK_in_indexedFunctionName5259	= { FOLLOW_FP_TO_UBV_TOK_in_indexedFunctionName5259_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5263  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5263_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5263	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5263_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_TO_SBV_TOK_in_indexedFunctionName5279  */
static	ANTLR3_BITWORD FOLLOW_FP_TO_SBV_TOK_in_indexedFunctionName5279_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_TO_SBV_TOK_in_indexedFunctionName5279	= { FOLLOW_FP_TO_SBV_TOK_in_indexedFunctionName5279_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5283  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5283_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5283	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5283_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TESTER_TOK_in_indexedFunctionName5299  */
static	ANTLR3_BITWORD FOLLOW_TESTER_TOK_in_indexedFunctionName5299_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90000), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_TESTER_TOK_in_indexedFunctionName5299	= { FOLLOW_TESTER_TOK_in_indexedFunctionName5299_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_indexedFunctionName5301  */
static	ANTLR3_BITWORD FOLLOW_term_in_indexedFunctionName5301_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_indexedFunctionName5301	= { FOLLOW_term_in_indexedFunctionName5301_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_badIndexedFunctionName_in_indexedFunctionName5312  */
static	ANTLR3_BITWORD FOLLOW_badIndexedFunctionName_in_indexedFunctionName5312_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_badIndexedFunctionName_in_indexedFunctionName5312	= { FOLLOW_badIndexedFunctionName_in_indexedFunctionName5312_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_indexedFunctionName5324  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_indexedFunctionName5324_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_indexedFunctionName5324	= { FOLLOW_RPAREN_TOK_in_indexedFunctionName5324_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_badIndexedFunctionName5346  */
static	ANTLR3_BITWORD FOLLOW_set_in_badIndexedFunctionName5346_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_badIndexedFunctionName5346	= { FOLLOW_set_in_badIndexedFunctionName5346_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_termList5387  */
static	ANTLR3_BITWORD FOLLOW_term_in_termList5387_bits[]	= { ANTLR3_UINT64_LIT(0xC004002400A90002), ANTLR3_UINT64_LIT(0x05804418200000FF), ANTLR3_UINT64_LIT(0x00000000043600CA) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_termList5387	= { FOLLOW_term_in_termList5387_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_LITERAL_2_0_in_str5409  */
static	ANTLR3_BITWORD FOLLOW_STRING_LITERAL_2_0_in_str5409_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_LITERAL_2_0_in_str5409	= { FOLLOW_STRING_LITERAL_2_0_in_str5409_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_LITERAL_2_5_in_str5421  */
static	ANTLR3_BITWORD FOLLOW_STRING_LITERAL_2_5_in_str5421_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_LITERAL_2_5_in_str5421	= { FOLLOW_STRING_LITERAL_2_5_in_str5421_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NOT_TOK_in_builtinOp5448  */
static	ANTLR3_BITWORD FOLLOW_NOT_TOK_in_builtinOp5448_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_NOT_TOK_in_builtinOp5448	= { FOLLOW_NOT_TOK_in_builtinOp5448_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IMPLIES_TOK_in_builtinOp5461  */
static	ANTLR3_BITWORD FOLLOW_IMPLIES_TOK_in_builtinOp5461_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IMPLIES_TOK_in_builtinOp5461	= { FOLLOW_IMPLIES_TOK_in_builtinOp5461_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_AND_TOK_in_builtinOp5470  */
static	ANTLR3_BITWORD FOLLOW_AND_TOK_in_builtinOp5470_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_AND_TOK_in_builtinOp5470	= { FOLLOW_AND_TOK_in_builtinOp5470_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_OR_TOK_in_builtinOp5483  */
static	ANTLR3_BITWORD FOLLOW_OR_TOK_in_builtinOp5483_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_OR_TOK_in_builtinOp5483	= { FOLLOW_OR_TOK_in_builtinOp5483_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_XOR_TOK_in_builtinOp5497  */
static	ANTLR3_BITWORD FOLLOW_XOR_TOK_in_builtinOp5497_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_XOR_TOK_in_builtinOp5497	= { FOLLOW_XOR_TOK_in_builtinOp5497_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQUAL_TOK_in_builtinOp5510  */
static	ANTLR3_BITWORD FOLLOW_EQUAL_TOK_in_builtinOp5510_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EQUAL_TOK_in_builtinOp5510	= { FOLLOW_EQUAL_TOK_in_builtinOp5510_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DISTINCT_TOK_in_builtinOp5521  */
static	ANTLR3_BITWORD FOLLOW_DISTINCT_TOK_in_builtinOp5521_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DISTINCT_TOK_in_builtinOp5521	= { FOLLOW_DISTINCT_TOK_in_builtinOp5521_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ITE_TOK_in_builtinOp5529  */
static	ANTLR3_BITWORD FOLLOW_ITE_TOK_in_builtinOp5529_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ITE_TOK_in_builtinOp5529	= { FOLLOW_ITE_TOK_in_builtinOp5529_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GREATER_THAN_TOK_in_builtinOp5542  */
static	ANTLR3_BITWORD FOLLOW_GREATER_THAN_TOK_in_builtinOp5542_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_GREATER_THAN_TOK_in_builtinOp5542	= { FOLLOW_GREATER_THAN_TOK_in_builtinOp5542_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GREATER_THAN_EQUAL_TOK_in_builtinOp5567  */
static	ANTLR3_BITWORD FOLLOW_GREATER_THAN_EQUAL_TOK_in_builtinOp5567_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_GREATER_THAN_EQUAL_TOK_in_builtinOp5567	= { FOLLOW_GREATER_THAN_EQUAL_TOK_in_builtinOp5567_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LESS_THAN_EQUAL_TOK_in_builtinOp5592  */
static	ANTLR3_BITWORD FOLLOW_LESS_THAN_EQUAL_TOK_in_builtinOp5592_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_LESS_THAN_EQUAL_TOK_in_builtinOp5592	= { FOLLOW_LESS_THAN_EQUAL_TOK_in_builtinOp5592_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LESS_THAN_TOK_in_builtinOp5617  */
static	ANTLR3_BITWORD FOLLOW_LESS_THAN_TOK_in_builtinOp5617_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_LESS_THAN_TOK_in_builtinOp5617	= { FOLLOW_LESS_THAN_TOK_in_builtinOp5617_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PLUS_TOK_in_builtinOp5642  */
static	ANTLR3_BITWORD FOLLOW_PLUS_TOK_in_builtinOp5642_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_PLUS_TOK_in_builtinOp5642	= { FOLLOW_PLUS_TOK_in_builtinOp5642_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_MINUS_TOK_in_builtinOp5654  */
static	ANTLR3_BITWORD FOLLOW_MINUS_TOK_in_builtinOp5654_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_MINUS_TOK_in_builtinOp5654	= { FOLLOW_MINUS_TOK_in_builtinOp5654_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STAR_TOK_in_builtinOp5665  */
static	ANTLR3_BITWORD FOLLOW_STAR_TOK_in_builtinOp5665_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STAR_TOK_in_builtinOp5665	= { FOLLOW_STAR_TOK_in_builtinOp5665_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DIV_TOK_in_builtinOp5677  */
static	ANTLR3_BITWORD FOLLOW_DIV_TOK_in_builtinOp5677_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DIV_TOK_in_builtinOp5677	= { FOLLOW_DIV_TOK_in_builtinOp5677_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BV2NAT_TOK_in_builtinOp5691  */
static	ANTLR3_BITWORD FOLLOW_BV2NAT_TOK_in_builtinOp5691_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BV2NAT_TOK_in_builtinOp5691	= { FOLLOW_BV2NAT_TOK_in_builtinOp5691_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DTSIZE_TOK_in_builtinOp5704  */
static	ANTLR3_BITWORD FOLLOW_DTSIZE_TOK_in_builtinOp5704_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DTSIZE_TOK_in_builtinOp5704	= { FOLLOW_DTSIZE_TOK_in_builtinOp5704_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FMFCARD_TOK_in_builtinOp5718  */
static	ANTLR3_BITWORD FOLLOW_FMFCARD_TOK_in_builtinOp5718_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FMFCARD_TOK_in_builtinOp5718	= { FOLLOW_FMFCARD_TOK_in_builtinOp5718_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FMFCARDVAL_TOK_in_builtinOp5731  */
static	ANTLR3_BITWORD FOLLOW_FMFCARDVAL_TOK_in_builtinOp5731_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FMFCARDVAL_TOK_in_builtinOp5731	= { FOLLOW_FMFCARDVAL_TOK_in_builtinOp5731_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INST_CLOSURE_TOK_in_builtinOp5741  */
static	ANTLR3_BITWORD FOLLOW_INST_CLOSURE_TOK_in_builtinOp5741_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INST_CLOSURE_TOK_in_builtinOp5741	= { FOLLOW_INST_CLOSURE_TOK_in_builtinOp5741_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EXISTS_TOK_in_quantOp5783  */
static	ANTLR3_BITWORD FOLLOW_EXISTS_TOK_in_quantOp5783_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EXISTS_TOK_in_quantOp5783	= { FOLLOW_EXISTS_TOK_in_quantOp5783_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FORALL_TOK_in_quantOp5794  */
static	ANTLR3_BITWORD FOLLOW_FORALL_TOK_in_quantOp5794_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FORALL_TOK_in_quantOp5794	= { FOLLOW_FORALL_TOK_in_quantOp5794_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_functionName5815  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_functionName5815_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_functionName5815	= { FOLLOW_symbol_in_functionName5815_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sortList5839  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sortList5839_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280002), ANTLR3_UINT64_LIT(0x0080041000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sortList5839	= { FOLLOW_sortSymbol_in_sortList5839_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_nonemptySortList5866  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_nonemptySortList5866_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280002), ANTLR3_UINT64_LIT(0x0080041000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_nonemptySortList5866	= { FOLLOW_sortSymbol_in_nonemptySortList5866_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sortedVarList5895  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sortedVarList5895_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sortedVarList5895	= { FOLLOW_LPAREN_TOK_in_sortedVarList5895_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sortedVarList5897  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sortedVarList5897_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080041000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sortedVarList5897	= { FOLLOW_symbol_in_sortedVarList5897_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sortedVarList5906  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sortedVarList5906_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sortedVarList5906	= { FOLLOW_sortSymbol_in_sortedVarList5906_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sortedVarList5909  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sortedVarList5909_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sortedVarList5909	= { FOLLOW_RPAREN_TOK_in_sortedVarList5909_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sortName5940  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sortName5940_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sortName5940	= { FOLLOW_symbol_in_sortName5940_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortName_in_sortSymbol5960  */
static	ANTLR3_BITWORD FOLLOW_sortName_in_sortSymbol5960_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sortName_in_sortSymbol5960	= { FOLLOW_sortName_in_sortSymbol5960_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sortSymbol5973  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sortSymbol5973_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001100000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sortSymbol5973	= { FOLLOW_LPAREN_TOK_in_sortSymbol5973_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INDEX_TOK_in_sortSymbol5976  */
static	ANTLR3_BITWORD FOLLOW_INDEX_TOK_in_sortSymbol5976_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_INDEX_TOK_in_sortSymbol5976	= { FOLLOW_INDEX_TOK_in_sortSymbol5976_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sortSymbol5989  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sortSymbol5989_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x4080041800000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sortSymbol5989	= { FOLLOW_symbol_in_sortSymbol5989_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nonemptyNumeralList_in_sortSymbol5998  */
static	ANTLR3_BITWORD FOLLOW_nonemptyNumeralList_in_sortSymbol5998_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_nonemptyNumeralList_in_sortSymbol5998	= { FOLLOW_nonemptyNumeralList_in_sortSymbol5998_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortList_in_sortSymbol6015  */
static	ANTLR3_BITWORD FOLLOW_sortList_in_sortSymbol6015_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortList_in_sortSymbol6015	= { FOLLOW_sortList_in_sortSymbol6015_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sortSymbol6032  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sortSymbol6032_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sortSymbol6032	= { FOLLOW_RPAREN_TOK_in_sortSymbol6032_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_symbolList6055  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_symbolList6055_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280002), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_symbolList6055	= { FOLLOW_symbol_in_symbolList6055_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SIMPLE_SYMBOL_in_symbol6077  */
static	ANTLR3_BITWORD FOLLOW_SIMPLE_SYMBOL_in_symbol6077_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_SIMPLE_SYMBOL_in_symbol6077	= { FOLLOW_SIMPLE_SYMBOL_in_symbol6077_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_154_in_symbol6091  */
static	ANTLR3_BITWORD FOLLOW_154_in_symbol6091_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_154_in_symbol6091	= { FOLLOW_154_in_symbol6091_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SET_OPTIONS_TOK_in_symbol6107  */
static	ANTLR3_BITWORD FOLLOW_SET_OPTIONS_TOK_in_symbol6107_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_SET_OPTIONS_TOK_in_symbol6107	= { FOLLOW_SET_OPTIONS_TOK_in_symbol6107_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_VAR_TOK_in_symbol6117  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_VAR_TOK_in_symbol6117_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_VAR_TOK_in_symbol6117	= { FOLLOW_DECLARE_VAR_TOK_in_symbol6117_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_PRIMED_VAR_TOK_in_symbol6127  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_PRIMED_VAR_TOK_in_symbol6127_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_PRIMED_VAR_TOK_in_symbol6127	= { FOLLOW_DECLARE_PRIMED_VAR_TOK_in_symbol6127_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SYNTH_FUN_TOK_in_symbol6137  */
static	ANTLR3_BITWORD FOLLOW_SYNTH_FUN_TOK_in_symbol6137_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_SYNTH_FUN_TOK_in_symbol6137	= { FOLLOW_SYNTH_FUN_TOK_in_symbol6137_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SYNTH_INV_TOK_in_symbol6147  */
static	ANTLR3_BITWORD FOLLOW_SYNTH_INV_TOK_in_symbol6147_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_SYNTH_INV_TOK_in_symbol6147	= { FOLLOW_SYNTH_INV_TOK_in_symbol6147_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CONSTRAINT_TOK_in_symbol6157  */
static	ANTLR3_BITWORD FOLLOW_CONSTRAINT_TOK_in_symbol6157_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_CONSTRAINT_TOK_in_symbol6157	= { FOLLOW_CONSTRAINT_TOK_in_symbol6157_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INV_CONSTRAINT_TOK_in_symbol6167  */
static	ANTLR3_BITWORD FOLLOW_INV_CONSTRAINT_TOK_in_symbol6167_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INV_CONSTRAINT_TOK_in_symbol6167	= { FOLLOW_INV_CONSTRAINT_TOK_in_symbol6167_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CHECK_SYNTH_TOK_in_symbol6177  */
static	ANTLR3_BITWORD FOLLOW_CHECK_SYNTH_TOK_in_symbol6177_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_CHECK_SYNTH_TOK_in_symbol6177	= { FOLLOW_CHECK_SYNTH_TOK_in_symbol6177_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_QUOTED_SYMBOL_in_symbol6197  */
static	ANTLR3_BITWORD FOLLOW_QUOTED_SYMBOL_in_symbol6197_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_QUOTED_SYMBOL_in_symbol6197	= { FOLLOW_QUOTED_SYMBOL_in_symbol6197_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_UNTERMINATED_QUOTED_SYMBOL_in_symbol6209  */
static	ANTLR3_BITWORD FOLLOW_UNTERMINATED_QUOTED_SYMBOL_in_symbol6209_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000001000000) };
static  ANTLR3_BITSET_LIST FOLLOW_UNTERMINATED_QUOTED_SYMBOL_in_symbol6209	= { FOLLOW_UNTERMINATED_QUOTED_SYMBOL_in_symbol6209_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EOF_in_symbol6217  */
static	ANTLR3_BITWORD FOLLOW_EOF_in_symbol6217_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EOF_in_symbol6217	= { FOLLOW_EOF_in_symbol6217_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_152_in_symbol6233  */
static	ANTLR3_BITWORD FOLLOW_152_in_symbol6233_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_152_in_symbol6233	= { FOLLOW_152_in_symbol6233_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_nonemptyNumeralList6265  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_nonemptyNumeralList6265_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_nonemptyNumeralList6265	= { FOLLOW_INTEGER_LITERAL_in_nonemptyNumeralList6265_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_datatypeDef6307  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_datatypeDef6307_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_datatypeDef6307	= { FOLLOW_symbol_in_datatypeDef6307_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypeDef6330  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypeDef6330_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypeDef6330	= { FOLLOW_LPAREN_TOK_in_datatypeDef6330_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_constructorDef_in_datatypeDef6332  */
static	ANTLR3_BITWORD FOLLOW_constructorDef_in_datatypeDef6332_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_constructorDef_in_datatypeDef6332	= { FOLLOW_constructorDef_in_datatypeDef6332_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypeDef6335  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypeDef6335_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypeDef6335	= { FOLLOW_RPAREN_TOK_in_datatypeDef6335_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_constructorDef6365  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_constructorDef6365_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_constructorDef6365	= { FOLLOW_symbol_in_constructorDef6365_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_constructorDef6380  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_constructorDef6380_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080001000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_constructorDef6380	= { FOLLOW_LPAREN_TOK_in_constructorDef6380_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_selector_in_constructorDef6382  */
static	ANTLR3_BITWORD FOLLOW_selector_in_constructorDef6382_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_selector_in_constructorDef6382	= { FOLLOW_selector_in_constructorDef6382_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_constructorDef6385  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_constructorDef6385_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_constructorDef6385	= { FOLLOW_RPAREN_TOK_in_constructorDef6385_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_selector6413  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_selector6413_bits[]	= { ANTLR3_UINT64_LIT(0x0000002400280000), ANTLR3_UINT64_LIT(0x0080041000000000), ANTLR3_UINT64_LIT(0x000000000426000A) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_selector6413	= { FOLLOW_symbol_in_selector6413_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_selector6416  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_selector6416_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_selector6416	= { FOLLOW_sortSymbol_in_selector6416_bits, 1	};


/* ==============================================
 * Parsing rules
 */
/**
 * $ANTLR start parseExpr
 * ../../../../src/parser/smt2/Smt2.g:194:1: parseExpr returns [CVC4::parser::smt2::myExpr expr] : ( term[expr, expr2] | EOF );
 */
static CVC4::parser::smt2::myExpr
parseExpr(pSmt2Parser ctx)
{
    CVC4::parser::smt2::myExpr expr;



      Expr expr2;

    /* Initialize rule variables
     */

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:198:3: ( term[expr, expr2] | EOF )

            ANTLR3_UINT32 alt1;

            alt1=2;

            switch ( LA(1) )
            {
            case BINARY_LITERAL:
            case CHECK_SYNTH_TOK:
            case CONSTRAINT_TOK:
            case DECIMAL_LITERAL:
            case DECLARE_PRIMED_VAR_TOK:
            case DECLARE_VAR_TOK:
            case EMPTYSET_TOK:
            case FP_RNA_FULL_TOK:
            case FP_RNA_TOK:
            case FP_RNE_FULL_TOK:
            case FP_RNE_TOK:
            case FP_RTN_FULL_TOK:
            case FP_RTN_TOK:
            case FP_RTP_FULL_TOK:
            case FP_RTP_TOK:
            case FP_RTZ_FULL_TOK:
            case FP_RTZ_TOK:
            case HEX_LITERAL:
            case INTEGER_LITERAL:
            case INV_CONSTRAINT_TOK:
            case LPAREN_TOK:
            case NILREF_TOK:
            case QUOTED_SYMBOL:
            case REALLCHAR_TOK:
            case RENOSTR_TOK:
            case SET_OPTIONS_TOK:
            case SIMPLE_SYMBOL:
            case STRING_LITERAL_2_0:
            case STRING_LITERAL_2_5:
            case SYNTH_FUN_TOK:
            case SYNTH_INV_TOK:
            case UNIVSET_TOK:
            case UNTERMINATED_QUOTED_SYMBOL:
            case 154:
            	{
            		alt1=1;
            	}
                break;
            case EOF:
            	{
            		alt1=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 1;
                EXCEPTION->state        = 0;


                goto ruleparseExprEx;

            }

            switch (alt1)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:198:5: term[expr, expr2]
        	    {
        	        FOLLOWPUSH(FOLLOW_term_in_parseExpr119);
        	        term(ctx, expr, expr2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseExprEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:199:5: EOF
        	    {
        	         MATCHT(EOF, &FOLLOW_EOF_in_parseExpr126);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseExprEx;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleparseExprEx; /* Prevent compiler warnings */
    ruleparseExprEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return expr;
}
/* $ANTLR end parseExpr */

/**
 * $ANTLR start parseCommand
 * ../../../../src/parser/smt2/Smt2.g:206:1: parseCommand returns [CVC4::Command* cmd_return = NULL] : ( LPAREN_TOK command[&cmd] RPAREN_TOK | LPAREN_TOK INCLUDE_TOK str[name,true] RPAREN_TOK | EOF );
 */
static CVC4::Command*
parseCommand(pSmt2Parser ctx)
{
    CVC4::Command* cmd_return;



      CVC4::PtrCloser<CVC4::Command> cmd;
      std::string name;

    /* Initialize rule variables
     */
    cmd_return =  NULL;


    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:214:3: ( LPAREN_TOK command[&cmd] RPAREN_TOK | LPAREN_TOK INCLUDE_TOK str[name,true] RPAREN_TOK | EOF )

            ANTLR3_UINT32 alt2;

            alt2=3;

            switch ( LA(1) )
            {
            case LPAREN_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case INCLUDE_TOK:
            			{
            				alt2=2;
            			}
            		    break;
            		case ASSERT_TOK:
            		case CHECKSAT_TOK:
            		case DECLARE_CODATATYPES_2_5_TOK:
            		case DECLARE_CODATATYPES_TOK:
            		case DECLARE_CODATATYPE_TOK:
            		case DECLARE_CONST_TOK:
            		case DECLARE_DATATYPES_2_5_TOK:
            		case DECLARE_DATATYPES_TOK:
            		case DECLARE_DATATYPE_TOK:
            		case DECLARE_FUNS_TOK:
            		case DECLARE_FUN_TOK:
            		case DECLARE_PREDS_TOK:
            		case DECLARE_SORTS_TOK:
            		case DECLARE_SORT_TOK:
            		case DEFINE_CONST_TOK:
            		case DEFINE_FUNS_REC_TOK:
            		case DEFINE_FUN_REC_TOK:
            		case DEFINE_FUN_TOK:
            		case DEFINE_SORT_TOK:
            		case DEFINE_TOK:
            		case ECHO_TOK:
            		case EXIT_TOK:
            		case GET_ASSERTIONS_TOK:
            		case GET_ASSIGNMENT_TOK:
            		case GET_INFO_TOK:
            		case GET_MODEL_TOK:
            		case GET_OPTION_TOK:
            		case GET_PROOF_TOK:
            		case GET_QE_DISJUNCT_TOK:
            		case GET_QE_TOK:
            		case GET_UNSAT_CORE_TOK:
            		case GET_VALUE_TOK:
            		case META_INFO_TOK:
            		case POP_TOK:
            		case PROPAGATION_RULE_TOK:
            		case PUSH_TOK:
            		case REDUCTION_RULE_TOK:
            		case RESET_ASSERTIONS_TOK:
            		case RESET_TOK:
            		case REWRITE_RULE_TOK:
            		case SET_INFO_TOK:
            		case SET_LOGIC_TOK:
            		case SET_OPTION_TOK:
            		case SIMPLE_SYMBOL:
            		case SIMPLIFY_TOK:
            			{
            				alt2=1;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 2;
            		    EXCEPTION->state        = 1;


            		    goto ruleparseCommandEx;

            		}

            	}
                break;
            case EOF:
            	{
            		alt2=3;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 2;
                EXCEPTION->state        = 0;


                goto ruleparseCommandEx;

            }

            switch (alt2)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:214:5: LPAREN_TOK command[&cmd] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_parseCommand155);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_command_in_parseCommand157);
        	        command(ctx, &cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_parseCommand160);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:219:5: LPAREN_TOK INCLUDE_TOK str[name,true] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_parseCommand173);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	         MATCHT(INCLUDE_TOK, &FOLLOW_INCLUDE_TOK_in_parseCommand175);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_str_in_parseCommand177);
        	        str(ctx, name, true);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_parseCommand180);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	        {
        	             if(!PARSER_STATE->canIncludeFile()) {
        	                    PARSER_STATE->parseError("include-file feature was disabled for this "
        	                                             "run.");
        	                  }
        	                  if(PARSER_STATE->strictModeEnabled()) {
        	                    PARSER_STATE->parseError("Extended commands are not permitted while "
        	                                             "operating in strict compliance mode.");
        	                  }
        	                  PARSER_STATE->includeFile(name);
        	                  // The command of the included file will be produced at the next
        	                  // parseCommand() call
        	                  cmd.reset(new EmptyCommand("include::" + name));
        	                
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/smt2/Smt2.g:234:5: EOF
        	    {
        	         MATCHT(EOF, &FOLLOW_EOF_in_parseCommand193);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleparseCommandEx; /* Prevent compiler warnings */
    ruleparseCommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
            else
            {
                {

                      cmd_return = cmd.release();

                }
            }


    return cmd_return;
}
/* $ANTLR end parseCommand */

/**
 * $ANTLR start parseSygus
 * ../../../../src/parser/smt2/Smt2.g:242:1: parseSygus returns [CVC4::Command* cmd_return = NULL] : ( LPAREN_TOK sygusCommand[&cmd] RPAREN_TOK | EOF );
 */
static CVC4::Command*
parseSygus(pSmt2Parser ctx)
{
    CVC4::Command* cmd_return;



      CVC4::PtrCloser<CVC4::Command> cmd;
      std::string name;

    /* Initialize rule variables
     */
    cmd_return =  NULL;


    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:250:3: ( LPAREN_TOK sygusCommand[&cmd] RPAREN_TOK | EOF )

            ANTLR3_UINT32 alt3;

            alt3=2;

            switch ( LA(1) )
            {
            case LPAREN_TOK:
            	{
            		alt3=1;
            	}
                break;
            case EOF:
            	{
            		alt3=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 3;
                EXCEPTION->state        = 0;


                goto ruleparseSygusEx;

            }

            switch (alt3)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:250:5: LPAREN_TOK sygusCommand[&cmd] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_parseSygus222);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseSygusEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sygusCommand_in_parseSygus224);
        	        sygusCommand(ctx, &cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseSygusEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_parseSygus227);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseSygusEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:251:5: EOF
        	    {
        	         MATCHT(EOF, &FOLLOW_EOF_in_parseSygus233);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseSygusEx;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleparseSygusEx; /* Prevent compiler warnings */
    ruleparseSygusEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
            else
            {
                {

                      cmd_return = cmd.release();

                }
            }


    return cmd_return;
}
/* $ANTLR end parseSygus */

/**
 * $ANTLR start command
 * ../../../../src/parser/smt2/Smt2.g:258:1: command[CVC4::PtrCloser<CVC4::Command>* cmd] : ( SET_LOGIC_TOK symbol[name,CHECK_NONE,SYM_SORT] | SET_INFO_TOK metaInfoInternal[cmd] | GET_INFO_TOK KEYWORD | SET_OPTION_TOK setOptionInternal[cmd] | GET_OPTION_TOK KEYWORD | DECLARE_SORT_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] n= INTEGER_LITERAL | DEFINE_SORT_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] LPAREN_TOK symbolList[names,CHECK_NONE,SYM_SORT] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] | DECLARE_FUN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortList[sorts] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] | DEFINE_FUN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] term[expr, expr2] | GET_VALUE_TOK ( LPAREN_TOK termList[terms,expr] RPAREN_TOK |~ LPAREN_TOK ) | GET_ASSIGNMENT_TOK | ASSERT_TOK term[expr, expr2] | CHECKSAT_TOK ( term[expr, expr2] |) | GET_ASSERTIONS_TOK | GET_PROOF_TOK | GET_UNSAT_CORE_TOK | PUSH_TOK (k= INTEGER_LITERAL |) | POP_TOK (k= INTEGER_LITERAL |) | EXIT_TOK | smt25Command[cmd] | extendedCommand[cmd] | SIMPLE_SYMBOL );
 */
static void
command(pSmt2Parser ctx, CVC4::PtrCloser<CVC4::Command>* cmd)
{

      std::string name;
      std::vector<std::string> names;
      Expr expr, expr2;
      Type t;
      std::vector<Expr> terms;
      std::vector<Type> sorts;
      std::vector<std::pair<std::string, Type> > sortedVarNames;

    pANTLR3_COMMON_TOKEN    n;
    pANTLR3_COMMON_TOKEN    k;
    pANTLR3_COMMON_TOKEN    KEYWORD1;
    pANTLR3_COMMON_TOKEN    KEYWORD2;
    pANTLR3_COMMON_TOKEN    SIMPLE_SYMBOL3;

    /* Initialize rule variables
     */

    n       = NULL;
    k       = NULL;
    KEYWORD1       = NULL;
    KEYWORD2       = NULL;
    SIMPLE_SYMBOL3       = NULL;

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:268:3: ( SET_LOGIC_TOK symbol[name,CHECK_NONE,SYM_SORT] | SET_INFO_TOK metaInfoInternal[cmd] | GET_INFO_TOK KEYWORD | SET_OPTION_TOK setOptionInternal[cmd] | GET_OPTION_TOK KEYWORD | DECLARE_SORT_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] n= INTEGER_LITERAL | DEFINE_SORT_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] LPAREN_TOK symbolList[names,CHECK_NONE,SYM_SORT] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] | DECLARE_FUN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortList[sorts] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] | DEFINE_FUN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] term[expr, expr2] | GET_VALUE_TOK ( LPAREN_TOK termList[terms,expr] RPAREN_TOK |~ LPAREN_TOK ) | GET_ASSIGNMENT_TOK | ASSERT_TOK term[expr, expr2] | CHECKSAT_TOK ( term[expr, expr2] |) | GET_ASSERTIONS_TOK | GET_PROOF_TOK | GET_UNSAT_CORE_TOK | PUSH_TOK (k= INTEGER_LITERAL |) | POP_TOK (k= INTEGER_LITERAL |) | EXIT_TOK | smt25Command[cmd] | extendedCommand[cmd] | SIMPLE_SYMBOL )

            ANTLR3_UINT32 alt8;

            alt8=22;

            switch ( LA(1) )
            {
            case SET_LOGIC_TOK:
            	{
            		alt8=1;
            	}
                break;
            case SET_INFO_TOK:
            	{
            		alt8=2;
            	}
                break;
            case GET_INFO_TOK:
            	{
            		alt8=3;
            	}
                break;
            case SET_OPTION_TOK:
            	{
            		alt8=4;
            	}
                break;
            case GET_OPTION_TOK:
            	{
            		alt8=5;
            	}
                break;
            case DECLARE_SORT_TOK:
            	{
            		alt8=6;
            	}
                break;
            case DEFINE_SORT_TOK:
            	{
            		alt8=7;
            	}
                break;
            case DECLARE_FUN_TOK:
            	{
            		alt8=8;
            	}
                break;
            case DEFINE_FUN_TOK:
            	{
            		alt8=9;
            	}
                break;
            case GET_VALUE_TOK:
            	{
            		alt8=10;
            	}
                break;
            case GET_ASSIGNMENT_TOK:
            	{
            		alt8=11;
            	}
                break;
            case ASSERT_TOK:
            	{
            		alt8=12;
            	}
                break;
            case CHECKSAT_TOK:
            	{
            		alt8=13;
            	}
                break;
            case GET_ASSERTIONS_TOK:
            	{
            		alt8=14;
            	}
                break;
            case GET_PROOF_TOK:
            	{
            		alt8=15;
            	}
                break;
            case GET_UNSAT_CORE_TOK:
            	{
            		alt8=16;
            	}
                break;
            case PUSH_TOK:
            	{
            		alt8=17;
            	}
                break;
            case POP_TOK:
            	{
            		alt8=18;
            	}
                break;
            case EXIT_TOK:
            	{
            		alt8=19;
            	}
                break;
            case DECLARE_CONST_TOK:
            case DEFINE_FUNS_REC_TOK:
            case DEFINE_FUN_REC_TOK:
            case ECHO_TOK:
            case GET_MODEL_TOK:
            case META_INFO_TOK:
            case RESET_ASSERTIONS_TOK:
            case RESET_TOK:
            	{
            		alt8=20;
            	}
                break;
            case DECLARE_CODATATYPES_2_5_TOK:
            case DECLARE_CODATATYPES_TOK:
            case DECLARE_CODATATYPE_TOK:
            case DECLARE_DATATYPES_2_5_TOK:
            case DECLARE_DATATYPES_TOK:
            case DECLARE_DATATYPE_TOK:
            case DECLARE_FUNS_TOK:
            case DECLARE_PREDS_TOK:
            case DECLARE_SORTS_TOK:
            case DEFINE_CONST_TOK:
            case DEFINE_TOK:
            case GET_QE_DISJUNCT_TOK:
            case GET_QE_TOK:
            case PROPAGATION_RULE_TOK:
            case REDUCTION_RULE_TOK:
            case REWRITE_RULE_TOK:
            case SIMPLIFY_TOK:
            	{
            		alt8=21;
            	}
                break;
            case SIMPLE_SYMBOL:
            	{
            		alt8=22;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 8;
                EXCEPTION->state        = 0;


                goto rulecommandEx;

            }

            switch (alt8)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:269:5: SET_LOGIC_TOK symbol[name,CHECK_NONE,SYM_SORT]
        	    {
        	         MATCHT(SET_LOGIC_TOK, &FOLLOW_SET_LOGIC_TOK_in_command261);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_command263);
        	        symbol(ctx, name, CHECK_NONE, SYM_SORT);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             Debug("parser") << "set logic: '" << name << "'" << std::endl;
        	                  if( PARSER_STATE->logicIsSet() ) {
        	                    PARSER_STATE->parseError("Only one set-logic is allowed.");
        	                  }
        	                  PARSER_STATE->setLogic(name);
        	                  if( PARSER_STATE->sygus() ){
        	                    cmd->reset(new SetBenchmarkLogicCommand(PARSER_STATE->getLogic().getLogicString()));
        	                  }else{
        	                    cmd->reset(new SetBenchmarkLogicCommand(name));
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:282:5: SET_INFO_TOK metaInfoInternal[cmd]
        	    {
        	         MATCHT(SET_INFO_TOK, &FOLLOW_SET_INFO_TOK_in_command282);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_metaInfoInternal_in_command284);
        	        metaInfoInternal(ctx, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/smt2/Smt2.g:284:5: GET_INFO_TOK KEYWORD
        	    {
        	         MATCHT(GET_INFO_TOK, &FOLLOW_GET_INFO_TOK_in_command297);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        KEYWORD1 = (pANTLR3_COMMON_TOKEN) MATCHT(KEYWORD, &FOLLOW_KEYWORD_in_command299);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             cmd->reset(new GetInfoCommand(
        	                      AntlrInput::tokenText(KEYWORD1).c_str() + 1));
        	                
        	        }


        	    }
        	    break;
        	case 4:
        	    // ../../../../src/parser/smt2/Smt2.g:289:5: SET_OPTION_TOK setOptionInternal[cmd]
        	    {
        	         MATCHT(SET_OPTION_TOK, &FOLLOW_SET_OPTION_TOK_in_command317);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_setOptionInternal_in_command319);
        	        setOptionInternal(ctx, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	    }
        	    break;
        	case 5:
        	    // ../../../../src/parser/smt2/Smt2.g:291:5: GET_OPTION_TOK KEYWORD
        	    {
        	         MATCHT(GET_OPTION_TOK, &FOLLOW_GET_OPTION_TOK_in_command332);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        KEYWORD2 = (pANTLR3_COMMON_TOKEN) MATCHT(KEYWORD, &FOLLOW_KEYWORD_in_command334);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             cmd->reset(new GetOptionCommand(
        	                      AntlrInput::tokenText(KEYWORD2).c_str() + 1));
        	                
        	        }


        	    }
        	    break;
        	case 6:
        	    // ../../../../src/parser/smt2/Smt2.g:296:5: DECLARE_SORT_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] n= INTEGER_LITERAL
        	    {
        	         MATCHT(DECLARE_SORT_TOK, &FOLLOW_DECLARE_SORT_TOK_in_command352);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             if(!PARSER_STATE->isTheoryEnabled(Smt2::THEORY_UF) &&
        	                     !PARSER_STATE->isTheoryEnabled(Smt2::THEORY_ARRAYS) &&
        	                     !PARSER_STATE->isTheoryEnabled(Smt2::THEORY_DATATYPES) &&
        	                     !PARSER_STATE->isTheoryEnabled(Smt2::THEORY_SETS)) {
        	                      PARSER_STATE->parseErrorLogic("Free sort symbols not allowed in ");
        	                  }
        	                
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_command366);
        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_SORT);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkUserSymbol(name); 
        	        }


        	        n = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_command381);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             Debug("parser") << "declare sort: '" << name
        	                                  << "' arity=" << n << std::endl;
        	                  unsigned arity = AntlrInput::tokenToUnsigned(n);
        	                  if(arity == 0) {
        	                    Type type = PARSER_STATE->mkSort(name);
        	                    cmd->reset(new DeclareTypeCommand(name, 0, type));
        	                  } else {
        	                    Type type = PARSER_STATE->mkSortConstructor(name, arity);
        	                    cmd->reset(new DeclareTypeCommand(name, arity, type));
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 7:
        	    // ../../../../src/parser/smt2/Smt2.g:319:5: DEFINE_SORT_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] LPAREN_TOK symbolList[names,CHECK_NONE,SYM_SORT] RPAREN_TOK sortSymbol[t,CHECK_DECLARED]
        	    {
        	         MATCHT(DEFINE_SORT_TOK, &FOLLOW_DEFINE_SORT_TOK_in_command399);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_command407);
        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_SORT);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkUserSymbol(name); 
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_command420);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_symbolList_in_command422);
        	        symbolList(ctx, names, CHECK_NONE, SYM_SORT);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_command425);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->pushScope(true);
        	                  for(std::vector<std::string>::const_iterator i = names.begin(),
        	                        iend = names.end();
        	                      i != iend;
        	                      ++i) {
        	                    sorts.push_back(PARSER_STATE->mkSort(*i));
        	                  }
        	                
        	        }


        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_command437);
        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->popScope();
        	                  // Do NOT call mkSort, since that creates a new sort!
        	                  // This name is not its own distinct sort, it's an alias.
        	                  PARSER_STATE->defineParameterizedType(name, sorts, t);
        	                  cmd->reset(new DefineTypeCommand(name, sorts, t));
        	                
        	        }


        	    }
        	    break;
        	case 8:
        	    // ../../../../src/parser/smt2/Smt2.g:339:5: DECLARE_FUN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortList[sorts] RPAREN_TOK sortSymbol[t,CHECK_DECLARED]
        	    {
        	         MATCHT(DECLARE_FUN_TOK, &FOLLOW_DECLARE_FUN_TOK_in_command456);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_command464);
        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkUserSymbol(name); 
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_command477);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortList_in_command479);
        	        sortList(ctx, sorts);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_command482);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_command488);
        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             Debug("parser") << "declare fun: '" << name << "'" << std::endl;
        	                  if( sorts.size() > 0 ) {
        	                    if(!PARSER_STATE->isTheoryEnabled(Smt2::THEORY_UF)) {
        	                      PARSER_STATE->parseErrorLogic("Functions (of non-zero arity) cannot "
        	                                                    "be declared in logic ");
        	                    }
        	                    t = EXPR_MANAGER->mkFunctionType(sorts, t);
        	                  }
        	                  Expr func = PARSER_STATE->mkVar(name, t);
        	                  cmd->reset(new DeclareFunctionCommand(name, func, t));
        	                
        	        }


        	    }
        	    break;
        	case 9:
        	    // ../../../../src/parser/smt2/Smt2.g:356:5: DEFINE_FUN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] term[expr, expr2]
        	    {
        	         MATCHT(DEFINE_FUN_TOK, &FOLLOW_DEFINE_FUN_TOK_in_command507);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_command515);
        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkUserSymbol(name); 
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_command528);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortedVarList_in_command530);
        	        sortedVarList(ctx, sortedVarNames);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_command533);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_command539);
        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             /* add variables to parser state before parsing term */
        	                  Debug("parser") << "define fun: '" << name << "'" << std::endl;
        	                  if( sortedVarNames.size() > 0 ) {
        	                    std::vector<CVC4::Type> sorts;
        	                    sorts.reserve(sortedVarNames.size());
        	                    for(std::vector<std::pair<std::string, CVC4::Type> >::const_iterator i =
        	                          sortedVarNames.begin(), iend = sortedVarNames.end();
        	                        i != iend;
        	                        ++i) {
        	                      sorts.push_back((*i).second);
        	                    }
        	                    t = EXPR_MANAGER->mkFunctionType(sorts, t);
        	                  }
        	                  PARSER_STATE->pushScope(true);
        	                  for(std::vector<std::pair<std::string, CVC4::Type> >::const_iterator i =
        	                        sortedVarNames.begin(), iend = sortedVarNames.end();
        	                      i != iend;
        	                      ++i) {
        	                    terms.push_back(PARSER_STATE->mkBoundVar((*i).first, (*i).second));
        	                  }
        	                
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_command552);
        	        term(ctx, expr, expr2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->popScope();
        	                  // declare the name down here (while parsing term, signature
        	                  // must not be extended with the name itself; no recursion
        	                  // permitted)
        	                  Expr func = PARSER_STATE->mkFunction(name, t,
        	                                                       ExprManager::VAR_FLAG_DEFINED);
        	                  cmd->reset(new DefineFunctionCommand(name, func, terms, expr));
        	                
        	        }


        	    }
        	    break;
        	case 10:
        	    // ../../../../src/parser/smt2/Smt2.g:392:5: GET_VALUE_TOK ( LPAREN_TOK termList[terms,expr] RPAREN_TOK |~ LPAREN_TOK )
        	    {
        	         MATCHT(GET_VALUE_TOK, &FOLLOW_GET_VALUE_TOK_in_command571);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:393:5: ( LPAREN_TOK termList[terms,expr] RPAREN_TOK |~ LPAREN_TOK )
        	        {
        	            int alt4=2;
        	            switch ( LA(1) )
        	            {
        	            case LPAREN_TOK:
        	            	{
        	            		alt4=1;
        	            	}
        	                break;
        	            case ALPHA:
        	            case AMPERSAND_TOK:
        	            case AND_TOK:
        	            case ASSERT_TOK:
        	            case AS_TOK:
        	            case ATTRIBUTE_INST_LEVEL:
        	            case ATTRIBUTE_NAMED_TOK:
        	            case ATTRIBUTE_NO_PATTERN_TOK:
        	            case ATTRIBUTE_PATTERN_TOK:
        	            case ATTRIBUTE_RR_PRIORITY:
        	            case ATTRIBUTE_TOK:
        	            case AT_TOK:
        	            case BINARY_LITERAL:
        	            case BV2NAT_TOK:
        	            case CHECKSAT_TOK:
        	            case CHECK_SYNTH_TOK:
        	            case COMMENT:
        	            case CONSTRAINT_TOK:
        	            case CONST_TOK:
        	            case DECIMAL_LITERAL:
        	            case DECLARE_CODATATYPES_2_5_TOK:
        	            case DECLARE_CODATATYPES_TOK:
        	            case DECLARE_CODATATYPE_TOK:
        	            case DECLARE_CONST_TOK:
        	            case DECLARE_DATATYPES_2_5_TOK:
        	            case DECLARE_DATATYPES_TOK:
        	            case DECLARE_DATATYPE_TOK:
        	            case DECLARE_FUNS_TOK:
        	            case DECLARE_FUN_TOK:
        	            case DECLARE_PREDS_TOK:
        	            case DECLARE_PRIMED_VAR_TOK:
        	            case DECLARE_SORTS_TOK:
        	            case DECLARE_SORT_TOK:
        	            case DECLARE_VAR_TOK:
        	            case DEFINE_CONST_TOK:
        	            case DEFINE_FUNS_REC_TOK:
        	            case DEFINE_FUN_REC_TOK:
        	            case DEFINE_FUN_TOK:
        	            case DEFINE_SORT_TOK:
        	            case DEFINE_TOK:
        	            case DIGIT:
        	            case DISTINCT_TOK:
        	            case DIVISIBLE_TOK:
        	            case DIV_TOK:
        	            case DTSIZE_TOK:
        	            case ECHO_TOK:
        	            case EMPTYSET_TOK:
        	            case EQUAL_TOK:
        	            case EXISTS_TOK:
        	            case EXIT_TOK:
        	            case FMFCARDVAL_TOK:
        	            case FMFCARD_TOK:
        	            case FORALL_TOK:
        	            case FP_NAN_TOK:
        	            case FP_NINF_TOK:
        	            case FP_NZERO_TOK:
        	            case FP_PINF_TOK:
        	            case FP_PZERO_TOK:
        	            case FP_RNA_FULL_TOK:
        	            case FP_RNA_TOK:
        	            case FP_RNE_FULL_TOK:
        	            case FP_RNE_TOK:
        	            case FP_RTN_FULL_TOK:
        	            case FP_RTN_TOK:
        	            case FP_RTP_FULL_TOK:
        	            case FP_RTP_TOK:
        	            case FP_RTZ_FULL_TOK:
        	            case FP_RTZ_TOK:
        	            case FP_TO_FPBV_TOK:
        	            case FP_TO_FPFP_TOK:
        	            case FP_TO_FPR_TOK:
        	            case FP_TO_FPS_TOK:
        	            case FP_TO_FPU_TOK:
        	            case FP_TO_FP_TOK:
        	            case FP_TO_SBV_TOK:
        	            case FP_TO_UBV_TOK:
        	            case GET_ASSERTIONS_TOK:
        	            case GET_ASSIGNMENT_TOK:
        	            case GET_INFO_TOK:
        	            case GET_MODEL_TOK:
        	            case GET_OPTION_TOK:
        	            case GET_PROOF_TOK:
        	            case GET_QE_DISJUNCT_TOK:
        	            case GET_QE_TOK:
        	            case GET_UNSAT_CORE_TOK:
        	            case GET_VALUE_TOK:
        	            case GREATER_THAN_EQUAL_TOK:
        	            case GREATER_THAN_TOK:
        	            case HEX_DIGIT:
        	            case HEX_LITERAL:
        	            case IMPLIES_TOK:
        	            case INCLUDE_TOK:
        	            case INDEX_TOK:
        	            case INST_CLOSURE_TOK:
        	            case INT2BV_TOK:
        	            case INTEGER_LITERAL:
        	            case INV_CONSTRAINT_TOK:
        	            case ITE_TOK:
        	            case KEYWORD:
        	            case LESS_THAN_EQUAL_TOK:
        	            case LESS_THAN_TOK:
        	            case LET_TOK:
        	            case MATCH_TOK:
        	            case META_INFO_TOK:
        	            case MINUS_TOK:
        	            case NILREF_TOK:
        	            case NOT_TOK:
        	            case NUMERAL:
        	            case OR_TOK:
        	            case PAR_TOK:
        	            case PLUS_TOK:
        	            case POP_TOK:
        	            case PROPAGATION_RULE_TOK:
        	            case PUSH_TOK:
        	            case QUOTED_SYMBOL:
        	            case REALLCHAR_TOK:
        	            case REDUCTION_RULE_TOK:
        	            case RENOSTR_TOK:
        	            case RESET_ASSERTIONS_TOK:
        	            case RESET_TOK:
        	            case REWRITE_RULE_TOK:
        	            case RPAREN_TOK:
        	            case SET_INFO_TOK:
        	            case SET_LOGIC_TOK:
        	            case SET_OPTIONS_TOK:
        	            case SET_OPTION_TOK:
        	            case SIMPLE_SYMBOL:
        	            case SIMPLIFY_TOK:
        	            case STAR_TOK:
        	            case STRING_LITERAL_2_0:
        	            case STRING_LITERAL_2_5:
        	            case SYGUS_CONSTANT_TOK:
        	            case SYGUS_ENUM_CONS_TOK:
        	            case SYGUS_ENUM_TOK:
        	            case SYGUS_INPUT_VARIABLE_TOK:
        	            case SYGUS_LOCAL_VARIABLE_TOK:
        	            case SYGUS_QUOTED_LITERAL:
        	            case SYGUS_VARIABLE_TOK:
        	            case SYMBOL_CHAR:
        	            case SYMBOL_CHAR_NOUNDERSCORE_NOATTRIBUTE:
        	            case SYNTH_FUN_TOK:
        	            case SYNTH_INV_TOK:
        	            case TESTER_TOK:
        	            case UNIVSET_TOK:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            case WHITESPACE:
        	            case XOR_TOK:
        	            case 152:
        	            case 153:
        	            case 154:
        	            case 155:
        	            case 156:
        	            case 157:
        	            case 158:
        	            	{
        	            		alt4=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 4;
        	                EXCEPTION->state        = 0;


        	                goto rulecommandEx;

        	            }

        	            switch (alt4)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:393:7: LPAREN_TOK termList[terms,expr] RPAREN_TOK
        	        	    {
        	        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_command581);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_termList_in_command583);
        	        	        termList(ctx, terms, expr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }


        	        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_command586);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }


        	        	        {
        	        	             cmd->reset(new GetValueCommand(terms)); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/smt2/Smt2.g:395:7: ~ LPAREN_TOK
        	        	    {
        	        	        if ( ((LA(1) >= ALPHA) && (LA(1) <= LET_TOK)) || ((LA(1) >= MATCH_TOK) && (LA(1) <= 158)) )
        	        	        {
        	        	            CONSUME();
        	        	            PERRORRECOVERY=ANTLR3_FALSE;
        	        	        }
        	        	        else
        	        	        {
        	        	            CONSTRUCTEX();
        	        	            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
        	        	            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
        	        	            EXCEPTION->expectingSet = NULL;

        	        	            goto rulecommandEx;
        	        	        }


        	        	        {
        	        	             PARSER_STATE->parseError("The get-value command expects a list of "
        	        	                                             "terms.  Perhaps you forgot a pair of "
        	        	                                             "parentheses?");
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 11:
        	    // ../../../../src/parser/smt2/Smt2.g:402:5: GET_ASSIGNMENT_TOK
        	    {
        	         MATCHT(GET_ASSIGNMENT_TOK, &FOLLOW_GET_ASSIGNMENT_TOK_in_command629);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             cmd->reset(new GetAssignmentCommand()); 
        	        }


        	    }
        	    break;
        	case 12:
        	    // ../../../../src/parser/smt2/Smt2.g:405:5: ASSERT_TOK term[expr, expr2]
        	    {
        	         MATCHT(ASSERT_TOK, &FOLLOW_ASSERT_TOK_in_command649);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             PARSER_STATE->clearLastNamedTerm(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_command669);
        	        term(ctx, expr, expr2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             bool inUnsatCore = PARSER_STATE->lastNamedTerm().first == expr;
        	                  cmd->reset(new AssertCommand(expr, inUnsatCore));
        	                  if(inUnsatCore) {
        	                    PARSER_STATE->registerUnsatCoreName(PARSER_STATE->lastNamedTerm());
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 13:
        	    // ../../../../src/parser/smt2/Smt2.g:419:5: CHECKSAT_TOK ( term[expr, expr2] |)
        	    {
        	         MATCHT(CHECKSAT_TOK, &FOLLOW_CHECKSAT_TOK_in_command688);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             if( PARSER_STATE->sygus() ){
        	                    PARSER_STATE->parseError("Sygus does not support check-sat command.");
        	                  }
        	                
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:424:5: ( term[expr, expr2] |)
        	        {
        	            int alt5=2;
        	            switch ( LA(1) )
        	            {
        	            case BINARY_LITERAL:
        	            case CHECK_SYNTH_TOK:
        	            case CONSTRAINT_TOK:
        	            case DECIMAL_LITERAL:
        	            case DECLARE_PRIMED_VAR_TOK:
        	            case DECLARE_VAR_TOK:
        	            case EMPTYSET_TOK:
        	            case FP_RNA_FULL_TOK:
        	            case FP_RNA_TOK:
        	            case FP_RNE_FULL_TOK:
        	            case FP_RNE_TOK:
        	            case FP_RTN_FULL_TOK:
        	            case FP_RTN_TOK:
        	            case FP_RTP_FULL_TOK:
        	            case FP_RTP_TOK:
        	            case FP_RTZ_FULL_TOK:
        	            case FP_RTZ_TOK:
        	            case HEX_LITERAL:
        	            case INTEGER_LITERAL:
        	            case INV_CONSTRAINT_TOK:
        	            case LPAREN_TOK:
        	            case NILREF_TOK:
        	            case QUOTED_SYMBOL:
        	            case REALLCHAR_TOK:
        	            case RENOSTR_TOK:
        	            case SET_OPTIONS_TOK:
        	            case SIMPLE_SYMBOL:
        	            case STRING_LITERAL_2_0:
        	            case STRING_LITERAL_2_5:
        	            case SYNTH_FUN_TOK:
        	            case SYNTH_INV_TOK:
        	            case UNIVSET_TOK:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            case 154:
        	            	{
        	            		alt5=1;
        	            	}
        	                break;
        	            case RPAREN_TOK:
        	            	{
        	            		alt5=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 5;
        	                EXCEPTION->state        = 0;


        	                goto rulecommandEx;

        	            }

        	            switch (alt5)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:424:7: term[expr, expr2]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_term_in_command704);
        	        	        term(ctx, expr, expr2);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }


        	        	        {
        	        	             if(PARSER_STATE->strictModeEnabled()) {
        	        	                      PARSER_STATE->parseError(
        	        	                          "Extended commands (such as check-sat with an argument) are not "
        	        	                          "permitted while operating in strict compliance mode.");
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/smt2/Smt2.g:431:7: 
        	        	    {
        	        	        {
        	        	             expr = MK_CONST(bool(true)); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        {
        	             cmd->reset(new CheckSatCommand(expr)); 
        	        }


        	    }
        	    break;
        	case 14:
        	    // ../../../../src/parser/smt2/Smt2.g:435:5: GET_ASSERTIONS_TOK
        	    {
        	         MATCHT(GET_ASSERTIONS_TOK, &FOLLOW_GET_ASSERTIONS_TOK_in_command745);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             cmd->reset(new GetAssertionsCommand()); 
        	        }


        	    }
        	    break;
        	case 15:
        	    // ../../../../src/parser/smt2/Smt2.g:438:5: GET_PROOF_TOK
        	    {
        	         MATCHT(GET_PROOF_TOK, &FOLLOW_GET_PROOF_TOK_in_command765);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             cmd->reset(new GetProofCommand()); 
        	        }


        	    }
        	    break;
        	case 16:
        	    // ../../../../src/parser/smt2/Smt2.g:441:5: GET_UNSAT_CORE_TOK
        	    {
        	         MATCHT(GET_UNSAT_CORE_TOK, &FOLLOW_GET_UNSAT_CORE_TOK_in_command785);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             cmd->reset(new GetUnsatCoreCommand(PARSER_STATE->getUnsatCoreNames())); 
        	        }


        	    }
        	    break;
        	case 17:
        	    // ../../../../src/parser/smt2/Smt2.g:444:5: PUSH_TOK (k= INTEGER_LITERAL |)
        	    {
        	         MATCHT(PUSH_TOK, &FOLLOW_PUSH_TOK_in_command805);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             if( PARSER_STATE->sygus() ){
        	                    PARSER_STATE->parseError("Sygus does not support push command.");
        	                  }
        	                
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:449:5: (k= INTEGER_LITERAL |)
        	        {
        	            int alt6=2;
        	            switch ( LA(1) )
        	            {
        	            case INTEGER_LITERAL:
        	            	{
        	            		alt6=1;
        	            	}
        	                break;
        	            case RPAREN_TOK:
        	            	{
        	            		alt6=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 6;
        	                EXCEPTION->state        = 0;


        	                goto rulecommandEx;

        	            }

        	            switch (alt6)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:449:7: k= INTEGER_LITERAL
        	        	    {
        	        	        k = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_command823);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }


        	        	        {
        	        	             unsigned n = AntlrInput::tokenToUnsigned(k);
        	        	                    if(n == 0) {
        	        	                      cmd->reset(new EmptyCommand());
        	        	                    } else if(n == 1) {
        	        	                      PARSER_STATE->pushScope();
        	        	                      PARSER_STATE->pushUnsatCoreNameScope();
        	        	                      cmd->reset(new PushCommand());
        	        	                    } else {
        	        	                      CVC4::PtrCloser<CommandSequence> seq(new CommandSequence());
        	        	                      do {
        	        	                        PARSER_STATE->pushScope();
        	        	                        PARSER_STATE->pushUnsatCoreNameScope();
        	        	                        Command* push_cmd = new PushCommand();
        	        	                        push_cmd->setMuted(n > 1);
        	        	                        seq->addCommand(push_cmd);
        	        	                        --n;
        	        	                        } while(n > 0);
        	        	                      cmd->reset(seq.release());
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/smt2/Smt2.g:470:7: 
        	        	    {
        	        	        {
        	        	             if(PARSER_STATE->strictModeEnabled()) {
        	        	                      PARSER_STATE->parseError(
        	        	                          "Strict compliance mode demands an integer to be provided to "
        	        	                          "PUSH.  Maybe you want (push 1)?");
        	        	                    } else {
        	        	                      PARSER_STATE->pushScope();
        	        	                      PARSER_STATE->pushUnsatCoreNameScope();
        	        	                      cmd->reset(new PushCommand());
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 18:
        	    // ../../../../src/parser/smt2/Smt2.g:480:5: POP_TOK (k= INTEGER_LITERAL |)
        	    {
        	         MATCHT(POP_TOK, &FOLLOW_POP_TOK_in_command847);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             if( PARSER_STATE->sygus() ){
        	                    PARSER_STATE->parseError("Sygus does not support pop command.");
        	                  }
        	                
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:485:5: (k= INTEGER_LITERAL |)
        	        {
        	            int alt7=2;
        	            switch ( LA(1) )
        	            {
        	            case INTEGER_LITERAL:
        	            	{
        	            		alt7=1;
        	            	}
        	                break;
        	            case RPAREN_TOK:
        	            	{
        	            		alt7=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 7;
        	                EXCEPTION->state        = 0;


        	                goto rulecommandEx;

        	            }

        	            switch (alt7)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:485:7: k= INTEGER_LITERAL
        	        	    {
        	        	        k = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_command865);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }


        	        	        {
        	        	             unsigned n = AntlrInput::tokenToUnsigned(k);
        	        	                    if(n > PARSER_STATE->scopeLevel()) {
        	        	                      PARSER_STATE->parseError("Attempted to pop above the top stack "
        	        	                                               "frame.");
        	        	                    }
        	        	                    if(n == 0) {
        	        	                      cmd->reset(new EmptyCommand());
        	        	                    } else if(n == 1) {
        	        	                      PARSER_STATE->popUnsatCoreNameScope();
        	        	                      PARSER_STATE->popScope();
        	        	                      cmd->reset(new PopCommand());
        	        	                    } else {
        	        	                      CVC4::PtrCloser<CommandSequence> seq(new CommandSequence());
        	        	                      do {
        	        	                        PARSER_STATE->popUnsatCoreNameScope();
        	        	                        PARSER_STATE->popScope();
        	        	                        Command* pop_command = new PopCommand();
        	        	                        pop_command->setMuted(n > 1);
        	        	                        seq->addCommand(pop_command);
        	        	                        --n;
        	        	                      } while(n > 0);
        	        	                      cmd->reset(seq.release());
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/smt2/Smt2.g:510:7: 
        	        	    {
        	        	        {
        	        	             if(PARSER_STATE->strictModeEnabled()) {
        	        	                      PARSER_STATE->parseError(
        	        	                          "Strict compliance mode demands an integer to be provided to POP."
        	        	                          "Maybe you want (pop 1)?");
        	        	                    } else {
        	        	                      PARSER_STATE->popUnsatCoreNameScope();
        	        	                      PARSER_STATE->popScope();
        	        	                      cmd->reset(new PopCommand());
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 19:
        	    // ../../../../src/parser/smt2/Smt2.g:522:5: EXIT_TOK
        	    {
        	         MATCHT(EXIT_TOK, &FOLLOW_EXIT_TOK_in_command899);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             cmd->reset(new QuitCommand()); 
        	        }


        	    }
        	    break;
        	case 20:
        	    // ../../../../src/parser/smt2/Smt2.g:526:5: smt25Command[cmd]
        	    {
        	        FOLLOWPUSH(FOLLOW_smt25Command_in_command918);
        	        smt25Command(ctx, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             if(PARSER_STATE->v2_0() && PARSER_STATE->strictModeEnabled()) {
        	                    PARSER_STATE->parseError(
        	                        "SMT-LIB 2.5 commands are not permitted while operating in strict "
        	                        "compliance mode and in SMT-LIB 2.0 mode.");
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 21:
        	    // ../../../../src/parser/smt2/Smt2.g:535:5: extendedCommand[cmd]
        	    {
        	        FOLLOWPUSH(FOLLOW_extendedCommand_in_command938);
        	        extendedCommand(ctx, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             if(PARSER_STATE->strictModeEnabled()) {
        	                    PARSER_STATE->parseError(
        	                        "Extended commands are not permitted while operating in strict "
        	                        "compliance mode.");
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 22:
        	    // ../../../../src/parser/smt2/Smt2.g:544:5: SIMPLE_SYMBOL
        	    {
        	        SIMPLE_SYMBOL3 = (pANTLR3_COMMON_TOKEN) MATCHT(SIMPLE_SYMBOL, &FOLLOW_SIMPLE_SYMBOL_in_command958);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             std::string id = AntlrInput::tokenText(SIMPLE_SYMBOL3);
        	                  if(id == "benchmark") {
        	                    PARSER_STATE->parseError(
        	                        "In SMT-LIBv2 mode, but got something that looks like SMT-LIBv1. "
        	                        "Use --lang smt1 for SMT-LIBv1.");
        	                  } else {
        	                    PARSER_STATE->parseError("expected SMT-LIBv2 command, got `" + id +
        	                                             "'.");
        	                  }
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulecommandEx; /* Prevent compiler warnings */
    rulecommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end command */

/**
 * $ANTLR start sygusCommand
 * ../../../../src/parser/smt2/Smt2.g:557:1: sygusCommand[CVC4::PtrCloser<CVC4::Command>* cmd] : ( DECLARE_VAR_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] | DECLARE_PRIMED_VAR_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] | ( SYNTH_FUN_TOK | SYNTH_INV_TOK ) symbol[fun,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK ( sortSymbol[range,CHECK_DECLARED] )? ( LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] LPAREN_TOK ( sygusGTerm[ sgts.back().back(), fun] )+ RPAREN_TOK RPAREN_TOK )+ RPAREN_TOK )? | CONSTRAINT_TOK term[expr, expr2] | INV_CONSTRAINT_TOK ( symbol[name,CHECK_NONE,SYM_VARIABLE] )+ | CHECK_SYNTH_TOK | command[cmd] );
 */
static void
sygusCommand(pSmt2Parser ctx, CVC4::PtrCloser<CVC4::Command>* cmd)
{

      std::string name, fun;
      std::vector<std::string> names;
      Expr expr, expr2;
      Type t, range;
      std::vector<Expr> terms;
      std::vector<Type> sorts;
      std::vector<Expr> sygus_vars;
      std::vector<std::pair<std::string, Type> > sortedVarNames;
      SExpr sexpr;
      CVC4::PtrCloser<CVC4::CommandSequence> seq;
      std::vector< std::vector< CVC4::SygusGTerm > > sgts;
      std::vector< CVC4::Datatype > datatypes;
      std::vector< std::vector<Expr> > ops;
      std::vector< std::vector< std::string > > cnames;
      std::vector< std::vector< std::vector< CVC4::Type > > > cargs;
      std::vector< bool > allow_const;
      std::vector< std::vector< std::string > > unresolved_gterm_sym;
      bool read_syntax = false;
      Type sygus_ret;
      std::map< CVC4::Type, CVC4::Type > sygus_to_builtin;
      std::map< CVC4::Type, CVC4::Expr > sygus_to_builtin_expr;
      int startIndex = -1;

    /* Initialize rule variables
     */

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:582:3: ( DECLARE_VAR_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] | DECLARE_PRIMED_VAR_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] | ( SYNTH_FUN_TOK | SYNTH_INV_TOK ) symbol[fun,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK ( sortSymbol[range,CHECK_DECLARED] )? ( LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] LPAREN_TOK ( sygusGTerm[ sgts.back().back(), fun] )+ RPAREN_TOK RPAREN_TOK )+ RPAREN_TOK )? | CONSTRAINT_TOK term[expr, expr2] | INV_CONSTRAINT_TOK ( symbol[name,CHECK_NONE,SYM_VARIABLE] )+ | CHECK_SYNTH_TOK | command[cmd] )

            ANTLR3_UINT32 alt15;

            alt15=7;

            switch ( LA(1) )
            {
            case DECLARE_VAR_TOK:
            	{
            		alt15=1;
            	}
                break;
            case DECLARE_PRIMED_VAR_TOK:
            	{
            		alt15=2;
            	}
                break;
            case SYNTH_FUN_TOK:
            case SYNTH_INV_TOK:
            	{
            		alt15=3;
            	}
                break;
            case CONSTRAINT_TOK:
            	{
            		alt15=4;
            	}
                break;
            case INV_CONSTRAINT_TOK:
            	{
            		alt15=5;
            	}
                break;
            case CHECK_SYNTH_TOK:
            	{
            		alt15=6;
            	}
                break;
            case ASSERT_TOK:
            case CHECKSAT_TOK:
            case DECLARE_CODATATYPES_2_5_TOK:
            case DECLARE_CODATATYPES_TOK:
            case DECLARE_CODATATYPE_TOK:
            case DECLARE_CONST_TOK:
            case DECLARE_DATATYPES_2_5_TOK:
            case DECLARE_DATATYPES_TOK:
            case DECLARE_DATATYPE_TOK:
            case DECLARE_FUNS_TOK:
            case DECLARE_FUN_TOK:
            case DECLARE_PREDS_TOK:
            case DECLARE_SORTS_TOK:
            case DECLARE_SORT_TOK:
            case DEFINE_CONST_TOK:
            case DEFINE_FUNS_REC_TOK:
            case DEFINE_FUN_REC_TOK:
            case DEFINE_FUN_TOK:
            case DEFINE_SORT_TOK:
            case DEFINE_TOK:
            case ECHO_TOK:
            case EXIT_TOK:
            case GET_ASSERTIONS_TOK:
            case GET_ASSIGNMENT_TOK:
            case GET_INFO_TOK:
            case GET_MODEL_TOK:
            case GET_OPTION_TOK:
            case GET_PROOF_TOK:
            case GET_QE_DISJUNCT_TOK:
            case GET_QE_TOK:
            case GET_UNSAT_CORE_TOK:
            case GET_VALUE_TOK:
            case META_INFO_TOK:
            case POP_TOK:
            case PROPAGATION_RULE_TOK:
            case PUSH_TOK:
            case REDUCTION_RULE_TOK:
            case RESET_ASSERTIONS_TOK:
            case RESET_TOK:
            case REWRITE_RULE_TOK:
            case SET_INFO_TOK:
            case SET_LOGIC_TOK:
            case SET_OPTION_TOK:
            case SIMPLE_SYMBOL:
            case SIMPLIFY_TOK:
            	{
            		alt15=7;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 15;
                EXCEPTION->state        = 0;


                goto rulesygusCommandEx;

            }

            switch (alt15)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:583:5: DECLARE_VAR_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED]
        	    {
        	         MATCHT(DECLARE_VAR_TOK, &FOLLOW_DECLARE_VAR_TOK_in_sygusCommand990);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_sygusCommand998);
        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkUserSymbol(name); 
        	        }


        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_sygusCommand1011);
        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        {
        	             PARSER_STATE->mkSygusVar(name, t);
        	                  cmd->reset(new EmptyCommand());
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:591:5: DECLARE_PRIMED_VAR_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED]
        	    {
        	         MATCHT(DECLARE_PRIMED_VAR_TOK, &FOLLOW_DECLARE_PRIMED_VAR_TOK_in_sygusCommand1030);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_sygusCommand1038);
        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkUserSymbol(name); 
        	        }


        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_sygusCommand1051);
        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        {
        	             PARSER_STATE->mkSygusVar(name, t, true);
        	                  cmd->reset(new EmptyCommand());
        	                
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/smt2/Smt2.g:600:5: ( SYNTH_FUN_TOK | SYNTH_INV_TOK ) symbol[fun,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK ( sortSymbol[range,CHECK_DECLARED] )? ( LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] LPAREN_TOK ( sygusGTerm[ sgts.back().back(), fun] )+ RPAREN_TOK RPAREN_TOK )+ RPAREN_TOK )?
        	    {
        	        // ../../../../src/parser/smt2/Smt2.g:600:5: ( SYNTH_FUN_TOK | SYNTH_INV_TOK )
        	        {
        	            int alt9=2;
        	            switch ( LA(1) )
        	            {
        	            case SYNTH_FUN_TOK:
        	            	{
        	            		alt9=1;
        	            	}
        	                break;
        	            case SYNTH_INV_TOK:
        	            	{
        	            		alt9=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 9;
        	                EXCEPTION->state        = 0;


        	                goto rulesygusCommandEx;

        	            }

        	            switch (alt9)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:600:7: SYNTH_FUN_TOK
        	        	    {
        	        	         MATCHT(SYNTH_FUN_TOK, &FOLLOW_SYNTH_FUN_TOK_in_sygusCommand1073);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusCommandEx;
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/smt2/Smt2.g:600:23: SYNTH_INV_TOK
        	        	    {
        	        	         MATCHT(SYNTH_INV_TOK, &FOLLOW_SYNTH_INV_TOK_in_sygusCommand1077);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusCommandEx;
        	        	        }


        	        	        {
        	        	             range = EXPR_MANAGER->booleanType(); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_sygusCommand1093);
        	        symbol(ctx, fun, CHECK_UNDECLARED, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sygusCommand1100);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortedVarList_in_sygusCommand1102);
        	        sortedVarList(ctx, sortedVarNames);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sygusCommand1105);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        {
        	             seq.reset(new CommandSequence());
        	                  PARSER_STATE->pushScope(true);
        	                  for(std::vector<std::pair<std::string, CVC4::Type> >::const_iterator i =
        	                        sortedVarNames.begin(), iend = sortedVarNames.end(); i != iend;
        	                      ++i) {
        	                    Expr v = PARSER_STATE->mkBoundVar((*i).first, (*i).second);
        	                    terms.push_back( v );
        	                    sygus_vars.push_back( v );
        	                  }
        	                  Expr bvl;
        	                  if( !terms.empty() ){
        	                    bvl = MK_EXPR(kind::BOUND_VAR_LIST, terms);
        	                  }
        	                  terms.clear();
        	                  terms.push_back(bvl);
        	                
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:620:5: ( sortSymbol[range,CHECK_DECLARED] )?
        	        {
        	            int alt10=2;
        	            switch ( LA(1) )
        	            {
        	                case CHECK_SYNTH_TOK:
        	                case CONSTRAINT_TOK:
        	                case DECLARE_PRIMED_VAR_TOK:
        	                case DECLARE_VAR_TOK:
        	                case INV_CONSTRAINT_TOK:
        	                case QUOTED_SYMBOL:
        	                case SET_OPTIONS_TOK:
        	                case SIMPLE_SYMBOL:
        	                case SYNTH_FUN_TOK:
        	                case SYNTH_INV_TOK:
        	                case UNTERMINATED_QUOTED_SYMBOL:
        	                case 154:
        	                	{
        	                		alt10=1;
        	                	}
        	                    break;
        	                case LPAREN_TOK:
        	                	{
        	                		switch ( LA(2) )
        	                		{
        	                		    case CHECK_SYNTH_TOK:
        	                		    case CONSTRAINT_TOK:
        	                		    case DECLARE_PRIMED_VAR_TOK:
        	                		    case DECLARE_VAR_TOK:
        	                		    case INDEX_TOK:
        	                		    case INV_CONSTRAINT_TOK:
        	                		    case QUOTED_SYMBOL:
        	                		    case SET_OPTIONS_TOK:
        	                		    case SIMPLE_SYMBOL:
        	                		    case SYNTH_FUN_TOK:
        	                		    case SYNTH_INV_TOK:
        	                		    case UNTERMINATED_QUOTED_SYMBOL:
        	                		    case 154:
        	                		    	{
        	                		    		alt10=1;
        	                		    	}
        	                		        break;
        	                		}

        	                	}
        	                    break;
        	            }

        	            switch (alt10)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:620:7: sortSymbol[range,CHECK_DECLARED]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_sygusCommand1119);
        	        	        sortSymbol(ctx, range, CHECK_DECLARED);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusCommandEx;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        {

        	                  if( range.isNull() ){
        	                    PARSER_STATE->parseError("Must supply return type for synth-fun.");
        	                  }
        	                
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:625:5: ( LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] LPAREN_TOK ( sygusGTerm[ sgts.back().back(), fun] )+ RPAREN_TOK RPAREN_TOK )+ RPAREN_TOK )?
        	        {
        	            int alt13=2;
        	            switch ( LA(1) )
        	            {
        	                case LPAREN_TOK:
        	                	{
        	                		alt13=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt13)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:625:7: LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] LPAREN_TOK ( sygusGTerm[ sgts.back().back(), fun] )+ RPAREN_TOK RPAREN_TOK )+ RPAREN_TOK
        	        	    {
        	        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sygusCommand1133);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusCommandEx;
        	        	        }


        	        	        // ../../../../src/parser/smt2/Smt2.g:626:5: ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] LPAREN_TOK ( sygusGTerm[ sgts.back().back(), fun] )+ RPAREN_TOK RPAREN_TOK )+
        	        	        {
        	        	            int cnt12=0;

        	        	            for (;;)
        	        	            {
        	        	                int alt12=2;
        	        	        	switch ( LA(1) )
        	        	        	{
        	        	        	case LPAREN_TOK:
        	        	        		{
        	        	        			alt12=1;
        	        	        		}
        	        	        	    break;

        	        	        	}

        	        	        	switch (alt12)
        	        	        	{
        	        	        	    case 1:
        	        	        	        // ../../../../src/parser/smt2/Smt2.g:626:7: LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] LPAREN_TOK ( sygusGTerm[ sgts.back().back(), fun] )+ RPAREN_TOK RPAREN_TOK
        	        	        	        {
        	        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sygusCommand1141);
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto rulesygusCommandEx;
        	        	        	            }


        	        	        	            FOLLOWPUSH(FOLLOW_symbol_in_sygusCommand1149);
        	        	        	            symbol(ctx, name, CHECK_NONE, SYM_VARIABLE);

        	        	        	            FOLLOWPOP();
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto rulesygusCommandEx;
        	        	        	            }


        	        	        	            FOLLOWPUSH(FOLLOW_sortSymbol_in_sygusCommand1159);
        	        	        	            sortSymbol(ctx, t, CHECK_DECLARED);

        	        	        	            FOLLOWPOP();
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto rulesygusCommandEx;
        	        	        	            }


        	        	        	            {
        	        	        	                 std::stringstream ss;
        	        	        	                        ss << fun << "_" << name;
        	        	        	                        if( name=="Start" ){
        	        	        	                          startIndex = datatypes.size();
        	        	        	                        }
        	        	        	                        std::string dname = ss.str();
        	        	        	                        sgts.push_back( std::vector< CVC4::SygusGTerm >() );
        	        	        	                        sgts.back().push_back( CVC4::SygusGTerm() );
        	        	        	                        PARSER_STATE->pushSygusDatatypeDef(
        	        	        	                            t, dname, datatypes, sorts, ops, cnames, cargs, allow_const,
        	        	        	                            unresolved_gterm_sym);
        	        	        	                        Type unres_t;
        	        	        	                        if(!PARSER_STATE->isUnresolvedType(dname)) {
        	        	        	                          // if not unresolved, must be undeclared
        	        	        	                          Debug("parser-sygus") << "Make unresolved type : " << dname
        	        	        	                                                << std::endl;
        	        	        	                          PARSER_STATE->checkDeclaration(dname, CHECK_UNDECLARED, SYM_SORT);
        	        	        	                          unres_t = PARSER_STATE->mkUnresolvedType(dname);
        	        	        	                        }else{
        	        	        	                          Debug("parser-sygus") << "Get sort : " << dname << std::endl;
        	        	        	                          unres_t = PARSER_STATE->getSort(dname);
        	        	        	                        }
        	        	        	                        sygus_to_builtin[unres_t] = t;
        	        	        	                        Debug("parser-sygus") << "--- Read sygus grammar " << name
        	        	        	                                              << " under function " << fun << "..."
        	        	        	                                              << std::endl
        	        	        	                                              << "    type to resolve " << unres_t << std::endl
        	        	        	                                              << "    builtin type " << t << std::endl;
        	        	        	                      
        	        	        	            }


        	        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sygusCommand1190);
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto rulesygusCommandEx;
        	        	        	            }


        	        	        	            // ../../../../src/parser/smt2/Smt2.g:660:18: ( sygusGTerm[ sgts.back().back(), fun] )+
        	        	        	            {
        	        	        	                int cnt11=0;

        	        	        	                for (;;)
        	        	        	                {
        	        	        	                    int alt11=2;
        	        	        	            	switch ( LA(1) )
        	        	        	            	{
        	        	        	            	case BINARY_LITERAL:
        	        	        	            	case CHECK_SYNTH_TOK:
        	        	        	            	case CONSTRAINT_TOK:
        	        	        	            	case DECLARE_PRIMED_VAR_TOK:
        	        	        	            	case DECLARE_VAR_TOK:
        	        	        	            	case HEX_LITERAL:
        	        	        	            	case INTEGER_LITERAL:
        	        	        	            	case INV_CONSTRAINT_TOK:
        	        	        	            	case LPAREN_TOK:
        	        	        	            	case QUOTED_SYMBOL:
        	        	        	            	case SET_OPTIONS_TOK:
        	        	        	            	case SIMPLE_SYMBOL:
        	        	        	            	case STRING_LITERAL_2_0:
        	        	        	            	case STRING_LITERAL_2_5:
        	        	        	            	case SYNTH_FUN_TOK:
        	        	        	            	case SYNTH_INV_TOK:
        	        	        	            	case UNTERMINATED_QUOTED_SYMBOL:
        	        	        	            	case 154:
        	        	        	            		{
        	        	        	            			alt11=1;
        	        	        	            		}
        	        	        	            	    break;

        	        	        	            	}

        	        	        	            	switch (alt11)
        	        	        	            	{
        	        	        	            	    case 1:
        	        	        	            	        // ../../../../src/parser/smt2/Smt2.g:660:20: sygusGTerm[ sgts.back().back(), fun]
        	        	        	            	        {
        	        	        	            	            FOLLOWPUSH(FOLLOW_sygusGTerm_in_sygusCommand1194);
        	        	        	            	            sygusGTerm(ctx, sgts.back().back(), fun);

        	        	        	            	            FOLLOWPOP();
        	        	        	            	            if  (HASEXCEPTION())
        	        	        	            	            {
        	        	        	            	                goto rulesygusCommandEx;
        	        	        	            	            }


        	        	        	            	            {
        	        	        	            	                 sgts.back().push_back( CVC4::SygusGTerm() ); 
        	        	        	            	            }


        	        	        	            	        }
        	        	        	            	        break;

        	        	        	            	    default:

        	        	        	            		if ( cnt11 >= 1 )
        	        	        	            		{
        	        	        	            		    goto loop11;
        	        	        	            		}
        	        	        	            		/* mismatchedSetEx()
        	        	        	            		 */
        	        	        	            		CONSTRUCTEX();
        	        	        	            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        	        	            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        	        	            		goto rulesygusCommandEx;
        	        	        	            	}
        	        	        	            	cnt11++;
        	        	        	                }
        	        	        	                loop11: ;	/* Jump to here if this rule does not match */
        	        	        	            }

        	        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sygusCommand1215);
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto rulesygusCommandEx;
        	        	        	            }


        	        	        	            {
        	        	        	                 sgts.back().pop_back(); 
        	        	        	            }


        	        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sygusCommand1225);
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto rulesygusCommandEx;
        	        	        	            }


        	        	        	        }
        	        	        	        break;

        	        	        	    default:

        	        	        		if ( cnt12 >= 1 )
        	        	        		{
        	        	        		    goto loop12;
        	        	        		}
        	        	        		/* mismatchedSetEx()
        	        	        		 */
        	        	        		CONSTRUCTEX();
        	        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        	        		goto rulesygusCommandEx;
        	        	        	}
        	        	        	cnt12++;
        	        	            }
        	        	            loop12: ;	/* Jump to here if this rule does not match */
        	        	        }

        	        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sygusCommand1239);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusCommandEx;
        	        	        }


        	        	        {
        	        	             read_syntax = true; 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        {
        	             
        	                  if( !read_syntax ){
        	                    //create the default grammar
        	                    Debug("parser-sygus") << "Make default grammar..." << std::endl;
        	                    PARSER_STATE->mkSygusDefaultGrammar(
        	                        range, terms[0], fun, datatypes, sorts, ops, sygus_vars,
        	                        startIndex);
        	                    //set start index
        	                    Debug("parser-sygus") << "Set start index " << startIndex << "..."
        	                                          << std::endl;
        	                    PARSER_STATE->setSygusStartIndex(fun, startIndex, datatypes, sorts,
        	                                                     ops);        
        	                  }else{
        	                    Debug("parser-sygus") << "--- Process " << sgts.size()
        	                                          << " sygus gterms..." << std::endl;
        	                    for( unsigned i=0; i<sgts.size(); i++ ){
        	                      for( unsigned j=0; j<sgts[i].size(); j++ ){
        	                        Type sub_ret;
        	                        PARSER_STATE->processSygusGTerm(
        	                            sgts[i][j], i, datatypes, sorts, ops, cnames, cargs,
        	                            allow_const, unresolved_gterm_sym, sygus_vars, sygus_to_builtin,
        	                            sygus_to_builtin_expr, sub_ret );
        	                      }
        	                    }
        	                    //swap index if necessary
        	                    Debug("parser-sygus") << "--- Making sygus datatypes..." << std::endl;
        	                    for( unsigned i=0; i<datatypes.size(); i++ ){
        	                      Debug("parser-sygus") << "..." << datatypes[i].getName()
        	                                            << " has builtin sort " << sorts[i]
        	                                            << std::endl;
        	                    }
        	                    for( unsigned i=0; i<datatypes.size(); i++ ){
        	                      Debug("parser-sygus") << "...make " << datatypes[i].getName()
        	                                            << " with builtin sort " << sorts[i]
        	                                            << std::endl;
        	                      if( sorts[i].isNull() ){
        	                        PARSER_STATE->parseError("Internal error : could not infer "
        	                                                 "builtin sort for nested gterm.");
        	                      }
        	                      datatypes[i].setSygus( sorts[i], terms[0], allow_const[i], false );
        	                      PARSER_STATE->mkSygusDatatype(
        	                          datatypes[i], ops[i], cnames[i], cargs[i],
        	                          unresolved_gterm_sym[i], sygus_to_builtin );
        	                    }
        	                    PARSER_STATE->setSygusStartIndex(fun, startIndex, datatypes, sorts,
        	                                                     ops);
        	                  }
        	                  //only care about datatypes/sorts/ops past here
        	                  PARSER_STATE->popScope();
        	                  Debug("parser-sygus") << "--- Make " << datatypes.size()
        	                                        << " mutual datatypes..." << std::endl;
        	                  for( unsigned i=0; i<datatypes.size(); i++ ){
        	                    Debug("parser-sygus") << "  " << i << " : " << datatypes[i].getName()
        	                                          << std::endl;
        	                  }
        	                  std::vector<DatatypeType> datatypeTypes =
        	                      PARSER_STATE->mkMutualDatatypeTypes(datatypes);
        	                  seq->addCommand(new DatatypeDeclarationCommand(datatypeTypes));
        	                  std::map<DatatypeType, Expr> evals;
        	                  if( sorts[0]!=range ){
        	                    PARSER_STATE->parseError(std::string("Bad return type in grammar for "
        	                                                         "SyGuS function ") + fun);
        	                  }
        	                  // make all the evals first, since they are mutually referential
        	                  for(size_t i = 0; i < datatypeTypes.size(); ++i) {
        	                    DatatypeType dtt = datatypeTypes[i];
        	                    const Datatype& dt = dtt.getDatatype();
        	                    Expr eval = dt.getSygusEvaluationFunc();
        	                    Debug("parser-sygus") << "Make eval " << eval << " for " << dt.getName()
        	                                          << std::endl;
        	                    evals.insert(std::make_pair(dtt, eval));
        	                    if(i == 0) {
        	                      PARSER_STATE->addSygusFun(fun, eval);
        	                    }
        	                  }
        	                  // now go through and settle everything
        	                  for(size_t i = 0; i < datatypeTypes.size(); ++i) {
        	                    DatatypeType dtt = datatypeTypes[i];
        	                    const Datatype& dt = dtt.getDatatype();
        	                    Expr eval = evals[dtt];
        	                    Debug("parser-sygus") << "Sygus : process grammar : " << dt
        	                                          << std::endl;
        	                    for(size_t j = 0; j < dt.getNumConstructors(); ++j) {
        	                      Expr assertion = PARSER_STATE->getSygusAssertion(
        	                          datatypeTypes, ops, evals, terms, eval, dt, i, j );
        	                      seq->addCommand(new AssertCommand(assertion));
        	                    }
        	                  }
        	                  cmd->reset(seq.release());
        	                
        	        }


        	    }
        	    break;
        	case 4:
        	    // ../../../../src/parser/smt2/Smt2.g:758:5: CONSTRAINT_TOK term[expr, expr2]
        	    {
        	         MATCHT(CONSTRAINT_TOK, &FOLLOW_CONSTRAINT_TOK_in_sygusCommand1266);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        {
        	             
        	                  PARSER_STATE->checkThatLogicIsSet();
        	                  Debug("parser-sygus") << "Sygus : define sygus funs..." << std::endl;
        	                  PARSER_STATE->defineSygusFuns(); 
        	                  Debug("parser-sygus") << "Sygus : read constraint..." << std::endl;
        	                
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_sygusCommand1274);
        	        term(ctx, expr, expr2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        {
        	             Debug("parser-sygus") << "...read constraint " << expr << std::endl;
        	                  PARSER_STATE->addSygusConstraint(expr);
        	                  cmd->reset(new EmptyCommand());
        	                
        	        }


        	    }
        	    break;
        	case 5:
        	    // ../../../../src/parser/smt2/Smt2.g:769:5: INV_CONSTRAINT_TOK ( symbol[name,CHECK_NONE,SYM_VARIABLE] )+
        	    {
        	         MATCHT(INV_CONSTRAINT_TOK, &FOLLOW_INV_CONSTRAINT_TOK_in_sygusCommand1287);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        {
        	              
        	                  PARSER_STATE->checkThatLogicIsSet();
        	                  Debug("parser-sygus") << "Sygus : define sygus funs..." << std::endl;
        	                  PARSER_STATE->defineSygusFuns(); 
        	                  Debug("parser-sygus") << "Sygus : read inv-constraint..." << std::endl;
        	                
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:775:5: ( symbol[name,CHECK_NONE,SYM_VARIABLE] )+
        	        {
        	            int cnt14=0;

        	            for (;;)
        	            {
        	                int alt14=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case CHECK_SYNTH_TOK:
        	        	case CONSTRAINT_TOK:
        	        	case DECLARE_PRIMED_VAR_TOK:
        	        	case DECLARE_VAR_TOK:
        	        	case INV_CONSTRAINT_TOK:
        	        	case QUOTED_SYMBOL:
        	        	case SET_OPTIONS_TOK:
        	        	case SIMPLE_SYMBOL:
        	        	case SYNTH_FUN_TOK:
        	        	case SYNTH_INV_TOK:
        	        	case UNTERMINATED_QUOTED_SYMBOL:
        	        	case 154:
        	        		{
        	        			alt14=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt14)
        	        	{
        	        	    case 1:
        	        	        // ../../../../src/parser/smt2/Smt2.g:775:7: symbol[name,CHECK_NONE,SYM_VARIABLE]
        	        	        {
        	        	            FOLLOWPUSH(FOLLOW_symbol_in_sygusCommand1297);
        	        	            symbol(ctx, name, CHECK_NONE, SYM_VARIABLE);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulesygusCommandEx;
        	        	            }


        	        	            {
        	        	                 
        	        	                        if( !terms.empty() ){
        	        	                          if( !PARSER_STATE->isDefinedFunction(name) ){
        	        	                            std::stringstream ss;
        	        	                            ss << "Function " << name << " in inv-constraint is not defined.";
        	        	                            PARSER_STATE->parseError(ss.str());
        	        	                          }
        	        	                        }
        	        	                        terms.push_back( PARSER_STATE->getVariable(name) );
        	        	                      
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt14 >= 1 )
        	        		{
        	        		    goto loop14;
        	        		}
        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto rulesygusCommandEx;
        	        	}
        	        	cnt14++;
        	            }
        	            loop14: ;	/* Jump to here if this rule does not match */
        	        }

        	        {

        	                  if( terms.size()!=4 ){
        	                    PARSER_STATE->parseError("Bad syntax for inv-constraint: expected 4 "
        	                                             "arguments.");
        	                  }
        	                  //get primed variables
        	                  std::vector< Expr > primed[2];
        	                  std::vector< Expr > all;
        	                  for( unsigned i=0; i<2; i++ ){
        	                    PARSER_STATE->getSygusPrimedVars( primed[i], i==1 );
        	                    all.insert( all.end(), primed[i].begin(), primed[i].end() );
        	                  }
        	                  //make relevant terms
        	                  for( unsigned i=0; i<4; i++ ){
        	                    Debug("parser-sygus") << "Make inv-constraint term #" << i << "..."
        	                                          << std::endl;
        	                    Expr op = terms[i];
        	                    std::vector< Expr > children;
        	                    children.push_back( op );
        	                    if( i==2 ){
        	                      children.insert( children.end(), all.begin(), all.end() );
        	                    }else{
        	                      children.insert( children.end(), primed[0].begin(), primed[0].end() );
        	                    }
        	                    terms[i] = EXPR_MANAGER->mkExpr(kind::APPLY,children);
        	                    if( i==0 ){
        	                      std::vector< Expr > children2;
        	                      children2.push_back( op );
        	                      children2.insert(children2.end(), primed[1].begin(),
        	                                       primed[1].end());
        	                      terms.push_back( EXPR_MANAGER->mkExpr(kind::APPLY,children2) );
        	                    }
        	                  }
        	                  //make constraints
        	                  std::vector< Expr > conj;
        	                  conj.push_back( EXPR_MANAGER->mkExpr(kind::IMPLIES, terms[1],
        	                                                       terms[0] ) );
        	                  const Expr term0_and_2 = EXPR_MANAGER->mkExpr(kind::AND, terms[0],
        	                                                                terms[2] );
        	                  conj.push_back( EXPR_MANAGER->mkExpr(kind::IMPLIES, term0_and_2,
        	                                                       terms[4] ) );
        	                  conj.push_back( EXPR_MANAGER->mkExpr(kind::IMPLIES, terms[0], terms[3]) );
        	                  Expr ic = EXPR_MANAGER->mkExpr( kind::AND, conj );
        	                  Debug("parser-sygus") << "...read invariant constraint " << ic
        	                                        << std::endl;
        	                  PARSER_STATE->addSygusConstraint(ic);
        	                  cmd->reset(new EmptyCommand());
        	                
        	        }


        	    }
        	    break;
        	case 6:
        	    // ../../../../src/parser/smt2/Smt2.g:834:5: CHECK_SYNTH_TOK
        	    {
        	         MATCHT(CHECK_SYNTH_TOK, &FOLLOW_CHECK_SYNTH_TOK_in_sygusCommand1321);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); PARSER_STATE->defineSygusFuns(); 
        	        }


        	        {
        	             Expr sygusVar = EXPR_MANAGER->mkVar("sygus", EXPR_MANAGER->booleanType());
        	                  Expr inst_attr =EXPR_MANAGER->mkExpr(kind::INST_ATTRIBUTE, sygusVar);
        	                  Expr sygusAttr = EXPR_MANAGER->mkExpr(kind::INST_PATTERN_LIST, inst_attr);
        	                  std::vector<Expr> bodyv;
        	                  Debug("parser-sygus") << "Sygus : Constructing sygus constraint..."
        	                                        << std::endl;
        	                  Expr body = EXPR_MANAGER->mkExpr(kind::NOT,
        	                                                   PARSER_STATE->getSygusConstraints());
        	                  Debug("parser-sygus") << "...constructed sygus constraint " << body
        	                                        << std::endl;      
        	                  if( !PARSER_STATE->getSygusVars().empty() ){
        	                    Expr boundVars = EXPR_MANAGER->mkExpr(kind::BOUND_VAR_LIST,
        	                                                          PARSER_STATE->getSygusVars());
        	                    body = EXPR_MANAGER->mkExpr(kind::EXISTS, boundVars, body);
        	                    Debug("parser-sygus") << "...constructed exists " << body << std::endl;
        	                  }
        	                  if( !PARSER_STATE->getSygusFunSymbols().empty() ){
        	                    Expr boundVars = EXPR_MANAGER->mkExpr(
        	                        kind::BOUND_VAR_LIST, PARSER_STATE->getSygusFunSymbols());
        	                    body = EXPR_MANAGER->mkExpr(kind::FORALL, boundVars, body, sygusAttr);
        	                  }
        	                  Debug("parser-sygus") << "...constructed forall " << body << std::endl;   
        	                  Command* c = new SetUserAttributeCommand("sygus", sygusVar);
        	                  c->setMuted(true);
        	                  PARSER_STATE->preemptCommand(c);
        	                  cmd->reset(new CheckSynthCommand(body));
        	                
        	        }


        	    }
        	    break;
        	case 7:
        	    // ../../../../src/parser/smt2/Smt2.g:863:5: command[cmd]
        	    {
        	        FOLLOWPUSH(FOLLOW_command_in_sygusCommand1339);
        	        command(ctx, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesygusCommandEx; /* Prevent compiler warnings */
    rulesygusCommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end sygusCommand */

/**
 * $ANTLR start sygusGTerm
 * ../../../../src/parser/smt2/Smt2.g:880:1: sygusGTerm[CVC4::SygusGTerm& sgt, std::string& fun] : ( LPAREN_TOK ( builtinOp[k] | LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[sname,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] sygusGTerm[sgt.d_children.back(), fun] RPAREN_TOK )+ RPAREN_TOK | SYGUS_CONSTANT_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_LOCAL_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_INPUT_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | symbol[name,CHECK_NONE,SYM_VARIABLE] ) ( sygusGTerm[sgt.d_children.back(), fun] )* RPAREN_TOK | INTEGER_LITERAL | HEX_LITERAL | BINARY_LITERAL | str[s,false] | symbol[name,CHECK_NONE,SYM_VARIABLE] ( SYGUS_ENUM_CONS_TOK symbol[name2,CHECK_NONE,SYM_VARIABLE] )? );
 */
static void
sygusGTerm(pSmt2Parser ctx, CVC4::SygusGTerm& sgt, std::string& fun)
{

      std::string name, name2;
      bool readEnum = false;
      Kind k;
      Type t;
      CVC4::DatatypeConstructor* ctor = NULL;
      std::string sname;
      std::vector< Expr > let_vars;
      bool readingLet = false;
      std::string s;

    pANTLR3_COMMON_TOKEN    INTEGER_LITERAL4;
    pANTLR3_COMMON_TOKEN    HEX_LITERAL5;
    pANTLR3_COMMON_TOKEN    BINARY_LITERAL6;

    /* Initialize rule variables
     */

    INTEGER_LITERAL4       = NULL;
    HEX_LITERAL5       = NULL;
    BINARY_LITERAL6       = NULL;

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:892:3: ( LPAREN_TOK ( builtinOp[k] | LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[sname,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] sygusGTerm[sgt.d_children.back(), fun] RPAREN_TOK )+ RPAREN_TOK | SYGUS_CONSTANT_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_LOCAL_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_INPUT_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | symbol[name,CHECK_NONE,SYM_VARIABLE] ) ( sygusGTerm[sgt.d_children.back(), fun] )* RPAREN_TOK | INTEGER_LITERAL | HEX_LITERAL | BINARY_LITERAL | str[s,false] | symbol[name,CHECK_NONE,SYM_VARIABLE] ( SYGUS_ENUM_CONS_TOK symbol[name2,CHECK_NONE,SYM_VARIABLE] )? )

            ANTLR3_UINT32 alt20;

            alt20=6;

            switch ( LA(1) )
            {
            case LPAREN_TOK:
            	{
            		alt20=1;
            	}
                break;
            case INTEGER_LITERAL:
            	{
            		alt20=2;
            	}
                break;
            case HEX_LITERAL:
            	{
            		alt20=3;
            	}
                break;
            case BINARY_LITERAL:
            	{
            		alt20=4;
            	}
                break;
            case STRING_LITERAL_2_0:
            case STRING_LITERAL_2_5:
            	{
            		alt20=5;
            	}
                break;
            case CHECK_SYNTH_TOK:
            case CONSTRAINT_TOK:
            case DECLARE_PRIMED_VAR_TOK:
            case DECLARE_VAR_TOK:
            case INV_CONSTRAINT_TOK:
            case QUOTED_SYMBOL:
            case SET_OPTIONS_TOK:
            case SIMPLE_SYMBOL:
            case SYNTH_FUN_TOK:
            case SYNTH_INV_TOK:
            case UNTERMINATED_QUOTED_SYMBOL:
            case 154:
            	{
            		alt20=6;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 20;
                EXCEPTION->state        = 0;


                goto rulesygusGTermEx;

            }

            switch (alt20)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:892:5: LPAREN_TOK ( builtinOp[k] | LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[sname,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] sygusGTerm[sgt.d_children.back(), fun] RPAREN_TOK )+ RPAREN_TOK | SYGUS_CONSTANT_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_LOCAL_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_INPUT_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | symbol[name,CHECK_NONE,SYM_VARIABLE] ) ( sygusGTerm[sgt.d_children.back(), fun] )* RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sygusGTerm1380);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusGTermEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:894:5: ( builtinOp[k] | LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[sname,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] sygusGTerm[sgt.d_children.back(), fun] RPAREN_TOK )+ RPAREN_TOK | SYGUS_CONSTANT_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_LOCAL_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_INPUT_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | symbol[name,CHECK_NONE,SYM_VARIABLE] )
        	        {
        	            int alt17=7;
        	            switch ( LA(1) )
        	            {
        	            case AND_TOK:
        	            case BV2NAT_TOK:
        	            case DISTINCT_TOK:
        	            case DIV_TOK:
        	            case DTSIZE_TOK:
        	            case EQUAL_TOK:
        	            case FMFCARDVAL_TOK:
        	            case FMFCARD_TOK:
        	            case GREATER_THAN_EQUAL_TOK:
        	            case GREATER_THAN_TOK:
        	            case IMPLIES_TOK:
        	            case INST_CLOSURE_TOK:
        	            case ITE_TOK:
        	            case LESS_THAN_EQUAL_TOK:
        	            case LESS_THAN_TOK:
        	            case MINUS_TOK:
        	            case NOT_TOK:
        	            case OR_TOK:
        	            case PLUS_TOK:
        	            case STAR_TOK:
        	            case XOR_TOK:
        	            	{
        	            		alt17=1;
        	            	}
        	                break;
        	            case LET_TOK:
        	            	{
        	            		alt17=2;
        	            	}
        	                break;
        	            case SYGUS_CONSTANT_TOK:
        	            	{
        	            		alt17=3;
        	            	}
        	                break;
        	            case SYGUS_VARIABLE_TOK:
        	            	{
        	            		alt17=4;
        	            	}
        	                break;
        	            case SYGUS_LOCAL_VARIABLE_TOK:
        	            	{
        	            		alt17=5;
        	            	}
        	                break;
        	            case SYGUS_INPUT_VARIABLE_TOK:
        	            	{
        	            		alt17=6;
        	            	}
        	                break;
        	            case CHECK_SYNTH_TOK:
        	            case CONSTRAINT_TOK:
        	            case DECLARE_PRIMED_VAR_TOK:
        	            case DECLARE_VAR_TOK:
        	            case INV_CONSTRAINT_TOK:
        	            case QUOTED_SYMBOL:
        	            case SET_OPTIONS_TOK:
        	            case SIMPLE_SYMBOL:
        	            case SYNTH_FUN_TOK:
        	            case SYNTH_INV_TOK:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            case 154:
        	            	{
        	            		alt17=7;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 17;
        	                EXCEPTION->state        = 0;


        	                goto rulesygusGTermEx;

        	            }

        	            switch (alt17)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:894:7: builtinOp[k]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_builtinOp_in_sygusGTerm1393);
        	        	        builtinOp(ctx, k);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        {
        	        	             
        	        	                    Debug("parser-sygus") << "Sygus grammar " << fun << " : builtin op : "
        	        	                                          << name << std::endl;
        	        	                    // Since we enforce satisfaction completeness, immediately convert to
        	        	                    // total version.
        	        	                    if( k==CVC4::kind::BITVECTOR_UDIV ){
        	        	                      k = CVC4::kind::BITVECTOR_UDIV_TOTAL;
        	        	                    }else if( k==CVC4::kind::BITVECTOR_UREM ){
        	        	                      k = CVC4::kind::BITVECTOR_UREM_TOTAL;
        	        	                    }
        	        	                    sgt.d_name = kind::kindToString(k);
        	        	                    sgt.d_gterm_type = SygusGTerm::gterm_op;
        	        	                    sgt.d_expr = EXPR_MANAGER->operatorOf(k);
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/smt2/Smt2.g:908:8: LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[sname,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] sygusGTerm[sgt.d_children.back(), fun] RPAREN_TOK )+ RPAREN_TOK
        	        	    {
        	        	         MATCHT(LET_TOK, &FOLLOW_LET_TOK_in_sygusGTerm1404);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sygusGTerm1406);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        {
        	        	             
        	        	                     sgt.d_name = std::string("let");
        	        	                     sgt.d_gterm_type = SygusGTerm::gterm_let;
        	        	                     PARSER_STATE->pushScope(true);
        	        	                     readingLet = true;
        	        	                   
        	        	        }


        	        	        // ../../../../src/parser/smt2/Smt2.g:914:8: ( LPAREN_TOK symbol[sname,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] sygusGTerm[sgt.d_children.back(), fun] RPAREN_TOK )+
        	        	        {
        	        	            int cnt16=0;

        	        	            for (;;)
        	        	            {
        	        	                int alt16=2;
        	        	        	switch ( LA(1) )
        	        	        	{
        	        	        	case LPAREN_TOK:
        	        	        		{
        	        	        			alt16=1;
        	        	        		}
        	        	        	    break;

        	        	        	}

        	        	        	switch (alt16)
        	        	        	{
        	        	        	    case 1:
        	        	        	        // ../../../../src/parser/smt2/Smt2.g:914:10: LPAREN_TOK symbol[sname,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] sygusGTerm[sgt.d_children.back(), fun] RPAREN_TOK
        	        	        	        {
        	        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sygusGTerm1419);
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto rulesygusGTermEx;
        	        	        	            }


        	        	        	            FOLLOWPUSH(FOLLOW_symbol_in_sygusGTerm1430);
        	        	        	            symbol(ctx, sname, CHECK_NONE, SYM_VARIABLE);

        	        	        	            FOLLOWPOP();
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto rulesygusGTermEx;
        	        	        	            }


        	        	        	            FOLLOWPUSH(FOLLOW_sortSymbol_in_sygusGTerm1442);
        	        	        	            sortSymbol(ctx, t, CHECK_DECLARED);

        	        	        	            FOLLOWPOP();
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto rulesygusGTermEx;
        	        	        	            }


        	        	        	            {
        	        	        	                 
        	        	        	                          Expr v = PARSER_STATE->mkBoundVar(sname,t); 
        	        	        	                          sgt.d_let_vars.push_back( v ); 
        	        	        	                          sgt.addChild();
        	        	        	                        
        	        	        	            }


        	        	        	            FOLLOWPUSH(FOLLOW_sygusGTerm_in_sygusGTerm1456);
        	        	        	            sygusGTerm(ctx, sgt.d_children.back(), fun);

        	        	        	            FOLLOWPOP();
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto rulesygusGTermEx;
        	        	        	            }


        	        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sygusGTerm1467);
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto rulesygusGTermEx;
        	        	        	            }


        	        	        	        }
        	        	        	        break;

        	        	        	    default:

        	        	        		if ( cnt16 >= 1 )
        	        	        		{
        	        	        		    goto loop16;
        	        	        		}
        	        	        		/* mismatchedSetEx()
        	        	        		 */
        	        	        		CONSTRUCTEX();
        	        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        	        		goto rulesygusGTermEx;
        	        	        	}
        	        	        	cnt16++;
        	        	            }
        	        	            loop16: ;	/* Jump to here if this rule does not match */
        	        	        }

        	        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sygusGTerm1472);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	    }
        	        	    break;
        	        	case 3:
        	        	    // ../../../../src/parser/smt2/Smt2.g:923:7: SYGUS_CONSTANT_TOK sortSymbol[t,CHECK_DECLARED]
        	        	    {
        	        	         MATCHT(SYGUS_CONSTANT_TOK, &FOLLOW_SYGUS_CONSTANT_TOK_in_sygusGTerm1480);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_sygusGTerm1482);
        	        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        {
        	        	             sgt.d_gterm_type = SygusGTerm::gterm_constant;
        	        	                    sgt.d_type = t;
        	        	                    Debug("parser-sygus") << "Sygus grammar constant." << std::endl;
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 4:
        	        	    // ../../../../src/parser/smt2/Smt2.g:928:7: SYGUS_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED]
        	        	    {
        	        	         MATCHT(SYGUS_VARIABLE_TOK, &FOLLOW_SYGUS_VARIABLE_TOK_in_sygusGTerm1500);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_sygusGTerm1502);
        	        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        {
        	        	             sgt.d_gterm_type = SygusGTerm::gterm_variable;
        	        	                    sgt.d_type = t;
        	        	                    Debug("parser-sygus") << "Sygus grammar variable." << std::endl;
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 5:
        	        	    // ../../../../src/parser/smt2/Smt2.g:933:7: SYGUS_LOCAL_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED]
        	        	    {
        	        	         MATCHT(SYGUS_LOCAL_VARIABLE_TOK, &FOLLOW_SYGUS_LOCAL_VARIABLE_TOK_in_sygusGTerm1519);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_sygusGTerm1521);
        	        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        {
        	        	             sgt.d_gterm_type = SygusGTerm::gterm_local_variable;
        	        	                    sgt.d_type = t;
        	        	                    Debug("parser-sygus") << "Sygus grammar local variable...ignore."
        	        	                                          << std::endl;
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 6:
        	        	    // ../../../../src/parser/smt2/Smt2.g:939:7: SYGUS_INPUT_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED]
        	        	    {
        	        	         MATCHT(SYGUS_INPUT_VARIABLE_TOK, &FOLLOW_SYGUS_INPUT_VARIABLE_TOK_in_sygusGTerm1538);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_sygusGTerm1540);
        	        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        {
        	        	             sgt.d_gterm_type = SygusGTerm::gterm_input_variable;
        	        	                    sgt.d_type = t;
        	        	                    Debug("parser-sygus") << "Sygus grammar (input) variable."
        	        	                                          << std::endl;
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 7:
        	        	    // ../../../../src/parser/smt2/Smt2.g:945:7: symbol[name,CHECK_NONE,SYM_VARIABLE]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_symbol_in_sygusGTerm1557);
        	        	        symbol(ctx, name, CHECK_NONE, SYM_VARIABLE);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        {
        	        	             
        	        	                    bool isBuiltinOperator = PARSER_STATE->isOperatorEnabled(name);
        	        	                    if(isBuiltinOperator) {
        	        	                      Debug("parser-sygus") << "Sygus grammar " << fun << " : builtin op : "
        	        	                                            << name << std::endl;
        	        	                      k = PARSER_STATE->getOperatorKind(name);
        	        	                      if( k==CVC4::kind::BITVECTOR_UDIV ){
        	        	                        k = CVC4::kind::BITVECTOR_UDIV_TOTAL;
        	        	                      }else if( k==CVC4::kind::BITVECTOR_UREM ){
        	        	                        k = CVC4::kind::BITVECTOR_UREM_TOTAL;
        	        	                      }
        	        	                      sgt.d_name = kind::kindToString(k);
        	        	                      sgt.d_gterm_type = SygusGTerm::gterm_op;
        	        	                      sgt.d_expr = EXPR_MANAGER->operatorOf(k);
        	        	                    }else{
        	        	                      // what is this sygus term trying to accomplish here, if the
        	        	                      // symbol isn't yet declared?!  probably the following line will
        	        	                      // fail, but we need an operator to continue here..
        	        	                      Debug("parser-sygus")
        	        	                          << "Sygus grammar " << fun << " : op (declare="
        	        	                          << PARSER_STATE->isDeclared(name) << ", define="
        	        	                          << PARSER_STATE->isDefinedFunction(name) << ") : " << name
        	        	                          << std::endl;
        	        	                      if(!PARSER_STATE->isDeclared(name) &&
        	        	                         !PARSER_STATE->isDefinedFunction(name) ){
        	        	                        PARSER_STATE->parseError("Functions in sygus grammars must be "
        	        	                                                 "defined.");
        	        	                      }
        	        	                      sgt.d_name = name;
        	        	                      sgt.d_gterm_type = SygusGTerm::gterm_op;
        	        	                      sgt.d_expr = PARSER_STATE->getVariable(name) ;
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        {
        	             Debug("parser-sygus") << "Read arguments under " << sgt.d_name
        	                                        << std::endl;
        	                  sgt.addChild();
        	                
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:984:5: ( sygusGTerm[sgt.d_children.back(), fun] )*

        	        for (;;)
        	        {
        	            int alt18=2;
        	            switch ( LA(1) )
        	            {
        	            case BINARY_LITERAL:
        	            case CHECK_SYNTH_TOK:
        	            case CONSTRAINT_TOK:
        	            case DECLARE_PRIMED_VAR_TOK:
        	            case DECLARE_VAR_TOK:
        	            case HEX_LITERAL:
        	            case INTEGER_LITERAL:
        	            case INV_CONSTRAINT_TOK:
        	            case LPAREN_TOK:
        	            case QUOTED_SYMBOL:
        	            case SET_OPTIONS_TOK:
        	            case SIMPLE_SYMBOL:
        	            case STRING_LITERAL_2_0:
        	            case STRING_LITERAL_2_5:
        	            case SYNTH_FUN_TOK:
        	            case SYNTH_INV_TOK:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            case 154:
        	            	{
        	            		alt18=1;
        	            	}
        	                break;

        	            }

        	            switch (alt18)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:984:7: sygusGTerm[sgt.d_children.back(), fun]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_sygusGTerm_in_sygusGTerm1585);
        	        	        sygusGTerm(ctx, sgt.d_children.back(), fun);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        {
        	        	             Debug("parser-sygus") << "Finished read argument #"
        	        	                                          << sgt.d_children.size() << "..." << std::endl;
        	        	                    sgt.addChild();
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop18;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop18: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sygusGTerm1608);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusGTermEx;
        	        }


        	        {

        	                  //pop last child index 
        	                  sgt.d_children.pop_back();   
        	                  if( readingLet ){
        	                    PARSER_STATE->popScope();
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:997:5: INTEGER_LITERAL
        	    {
        	        INTEGER_LITERAL4 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_sygusGTerm1616);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusGTermEx;
        	        }


        	        {
        	             Debug("parser-sygus") << "Sygus grammar " << fun << " : integer literal "
        	                                        << AntlrInput::tokenText(INTEGER_LITERAL4)
        	                                        << std::endl;
        	                  sgt.d_expr = MK_CONST(Rational(AntlrInput::tokenText(INTEGER_LITERAL4)));
        	                  sgt.d_name = AntlrInput::tokenText(INTEGER_LITERAL4);
        	                  sgt.d_gterm_type = SygusGTerm::gterm_op;
        	                
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/smt2/Smt2.g:1005:5: HEX_LITERAL
        	    {
        	        HEX_LITERAL5 = (pANTLR3_COMMON_TOKEN) MATCHT(HEX_LITERAL, &FOLLOW_HEX_LITERAL_in_sygusGTerm1628);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusGTermEx;
        	        }


        	        {
        	             Debug("parser-sygus") << "Sygus grammar " << fun << " : hex literal "
        	                                        << AntlrInput::tokenText(HEX_LITERAL5) << std::endl;
        	                  assert( AntlrInput::tokenText(HEX_LITERAL5).find("#x") == 0 );
        	                  std::string hexString = AntlrInput::tokenTextSubstr(HEX_LITERAL5, 2);
        	                  sgt.d_expr = MK_CONST( BitVector(hexString, 16) );
        	                  sgt.d_name = AntlrInput::tokenText(HEX_LITERAL5);
        	                  sgt.d_gterm_type = SygusGTerm::gterm_op;
        	                
        	        }


        	    }
        	    break;
        	case 4:
        	    // ../../../../src/parser/smt2/Smt2.g:1014:5: BINARY_LITERAL
        	    {
        	        BINARY_LITERAL6 = (pANTLR3_COMMON_TOKEN) MATCHT(BINARY_LITERAL, &FOLLOW_BINARY_LITERAL_in_sygusGTerm1640);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusGTermEx;
        	        }


        	        {
        	             Debug("parser-sygus") << "Sygus grammar " << fun << " : binary literal "
        	                                        << AntlrInput::tokenText(BINARY_LITERAL6)
        	                                        << std::endl;
        	                  assert( AntlrInput::tokenText(BINARY_LITERAL6).find("#b") == 0 );
        	                  std::string binString = AntlrInput::tokenTextSubstr(BINARY_LITERAL6, 2);
        	                  sgt.d_expr = MK_CONST( BitVector(binString, 2) );
        	                  sgt.d_name = AntlrInput::tokenText(BINARY_LITERAL6);
        	                  sgt.d_gterm_type = SygusGTerm::gterm_op;
        	                
        	        }


        	    }
        	    break;
        	case 5:
        	    // ../../../../src/parser/smt2/Smt2.g:1024:5: str[s,false]
        	    {
        	        FOLLOWPUSH(FOLLOW_str_in_sygusGTerm1652);
        	        str(ctx, s, false);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusGTermEx;
        	        }


        	        {
        	             Debug("parser-sygus") << "Sygus grammar " << fun << " : string literal \""
        	                                        << s << "\"" << std::endl;
        	                  sgt.d_expr = MK_CONST( ::CVC4::String(s) );
        	                  sgt.d_name = s;
        	                  sgt.d_gterm_type = SygusGTerm::gterm_op;
        	                
        	        }


        	    }
        	    break;
        	case 6:
        	    // ../../../../src/parser/smt2/Smt2.g:1031:5: symbol[name,CHECK_NONE,SYM_VARIABLE] ( SYGUS_ENUM_CONS_TOK symbol[name2,CHECK_NONE,SYM_VARIABLE] )?
        	    {
        	        FOLLOWPUSH(FOLLOW_symbol_in_sygusGTerm1665);
        	        symbol(ctx, name, CHECK_NONE, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusGTermEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:1032:5: ( SYGUS_ENUM_CONS_TOK symbol[name2,CHECK_NONE,SYM_VARIABLE] )?
        	        {
        	            int alt19=2;
        	            switch ( LA(1) )
        	            {
        	                case SYGUS_ENUM_CONS_TOK:
        	                	{
        	                		alt19=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt19)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:1032:7: SYGUS_ENUM_CONS_TOK symbol[name2,CHECK_NONE,SYM_VARIABLE]
        	        	    {
        	        	         MATCHT(SYGUS_ENUM_CONS_TOK, &FOLLOW_SYGUS_ENUM_CONS_TOK_in_sygusGTerm1674);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_symbol_in_sygusGTerm1676);
        	        	        symbol(ctx, name2, CHECK_NONE, SYM_VARIABLE);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        {
        	        	             readEnum = true; 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        {
        	             if( readEnum ){
        	                    name = name + "__Enum__" + name2;
        	                    Debug("parser-sygus") << "Sygus grammar " << fun << " : Enum constant "
        	                                          << name << std::endl;
        	                    Expr c = PARSER_STATE->getVariable(name);
        	                    sgt.d_expr = MK_EXPR(kind::APPLY_CONSTRUCTOR,c);
        	                    sgt.d_name = name;
        	                    sgt.d_gterm_type = SygusGTerm::gterm_op;
        	                  }else{
        	                    if( name[0] == '-' ){  //hack for unary minus
        	                      Debug("parser-sygus") << "Sygus grammar " << fun
        	                                            << " : unary minus integer literal " << name
        	                                            << std::endl;
        	                      sgt.d_expr = MK_CONST(Rational(name));
        	                      sgt.d_name = name;
        	                      sgt.d_gterm_type = SygusGTerm::gterm_op;
        	                    }else if( PARSER_STATE->isDeclared(name,SYM_VARIABLE) ){
        	                      Debug("parser-sygus") << "Sygus grammar " << fun << " : symbol "
        	                                            << name << std::endl;
        	                      sgt.d_expr = PARSER_STATE->getVariable(name);
        	                      sgt.d_name = name;
        	                      sgt.d_gterm_type = SygusGTerm::gterm_op;
        	                    }else{
        	                      //prepend function name to base sorts when reading an operator
        	                      std::stringstream ss;
        	                      ss << fun << "_" << name;
        	                      name = ss.str();
        	                      if( PARSER_STATE->isDeclared(name, SYM_SORT) ){
        	                        Debug("parser-sygus") << "Sygus grammar " << fun
        	                                              << " : nested sort " << name << std::endl;
        	                        sgt.d_type = PARSER_STATE->getSort(name);
        	                        sgt.d_gterm_type = SygusGTerm::gterm_nested_sort;
        	                      }else{
        	                        Debug("parser-sygus") << "Sygus grammar " << fun
        	                                              << " : unresolved symbol " << name
        	                                              << std::endl;
        	                        sgt.d_gterm_type = SygusGTerm::gterm_unresolved;
        	                        sgt.d_name = name;
        	                      }
        	                    }
        	                  }
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesygusGTermEx; /* Prevent compiler warnings */
    rulesygusGTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end sygusGTerm */

/**
 * $ANTLR start metaInfoInternal
 * ../../../../src/parser/smt2/Smt2.g:1080:1: metaInfoInternal[CVC4::PtrCloser<CVC4::Command>* cmd] : KEYWORD symbolicExpr[sexpr] ;
 */
static void
metaInfoInternal(pSmt2Parser ctx, CVC4::PtrCloser<CVC4::Command>* cmd)
{

      std::string name;
      SExpr sexpr;

    pANTLR3_COMMON_TOKEN    KEYWORD7;

    /* Initialize rule variables
     */

    KEYWORD7       = NULL;

    {
        // ../../../../src/parser/smt2/Smt2.g:1085:3: ( KEYWORD symbolicExpr[sexpr] )
        // ../../../../src/parser/smt2/Smt2.g:1085:5: KEYWORD symbolicExpr[sexpr]
        {
            KEYWORD7 = (pANTLR3_COMMON_TOKEN) MATCHT(KEYWORD, &FOLLOW_KEYWORD_in_metaInfoInternal1718);
            if  (HASEXCEPTION())
            {
                goto rulemetaInfoInternalEx;
            }


            FOLLOWPUSH(FOLLOW_symbolicExpr_in_metaInfoInternal1720);
            symbolicExpr(ctx, sexpr);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulemetaInfoInternalEx;
            }


            {
                 name = AntlrInput::tokenText(KEYWORD7);
                      if(name == ":cvc4-logic" || name == ":cvc4_logic") {
                        PARSER_STATE->setLogic(sexpr.getValue());
                      } else if(name == ":smt-lib-version") {
                        // if we don't recognize the revision name, just keep the current mode
                        if( (sexpr.isRational() && sexpr.getRationalValue() == Rational(2)) ||
                            sexpr.getValue() == "2" ||
                            sexpr.getValue() == "2.0" ) {
                          PARSER_STATE->setLanguage(language::input::LANG_SMTLIB_V2_0);
                        } else if( (sexpr.isRational() &&
                                    sexpr.getRationalValue() == Rational(5, 2)) ||
                                  sexpr.getValue() == "2.5" ) {
                          PARSER_STATE->setLanguage(language::input::LANG_SMTLIB_V2_5);
                        } else if( (sexpr.isRational() &&
                                    sexpr.getRationalValue() == Rational(13, 5)) ||
                                  sexpr.getValue() == "2.6" ) {
                          PARSER_STATE->setLanguage(language::input::LANG_SMTLIB_V2_6);
                        }
                      }
                      PARSER_STATE->setInfo(name.c_str() + 1, sexpr);
                      cmd->reset(new SetInfoCommand(name.c_str() + 1, sexpr));
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulemetaInfoInternalEx; /* Prevent compiler warnings */
    rulemetaInfoInternalEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end metaInfoInternal */

/**
 * $ANTLR start setOptionInternal
 * ../../../../src/parser/smt2/Smt2.g:1110:1: setOptionInternal[CVC4::PtrCloser<CVC4::Command>* cmd] : keyword[name] symbolicExpr[sexpr] ;
 */
static void
setOptionInternal(pSmt2Parser ctx, CVC4::PtrCloser<CVC4::Command>* cmd)
{
    /* Initialize rule variables
     */


      std::string name;
      SExpr sexpr;

    {
        // ../../../../src/parser/smt2/Smt2.g:1115:3: ( keyword[name] symbolicExpr[sexpr] )
        // ../../../../src/parser/smt2/Smt2.g:1115:5: keyword[name] symbolicExpr[sexpr]
        {
            FOLLOWPUSH(FOLLOW_keyword_in_setOptionInternal1746);
            keyword(ctx, name);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulesetOptionInternalEx;
            }


            FOLLOWPUSH(FOLLOW_symbolicExpr_in_setOptionInternal1749);
            symbolicExpr(ctx, sexpr);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulesetOptionInternalEx;
            }


            {
                 PARSER_STATE->setOption(name.c_str() + 1, sexpr);
                      cmd->reset(new SetOptionCommand(name.c_str() + 1, sexpr));
                      // Ugly that this changes the state of the parser; but
                      // global-declarations affects parsing, so we can't hold off
                      // on this until some SmtEngine eventually (if ever) executes it.
                      if(name == ":global-declarations") {
                        PARSER_STATE->setGlobalDeclarations(sexpr.getValue() == "true");
                      }
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulesetOptionInternalEx; /* Prevent compiler warnings */
    rulesetOptionInternalEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end setOptionInternal */

/**
 * $ANTLR start smt25Command
 * ../../../../src/parser/smt2/Smt2.g:1127:1: smt25Command[CVC4::PtrCloser<CVC4::Command>* cmd] : ( META_INFO_TOK metaInfoInternal[cmd] | DECLARE_CONST_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] | GET_MODEL_TOK | ECHO_TOK ( simpleSymbolicExpr[sexpr] |) | RESET_TOK | RESET_ASSERTIONS_TOK | DEFINE_FUN_REC_TOK symbol[fname,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] term[expr, expr2] | DEFINE_FUNS_REC_TOK LPAREN_TOK ( LPAREN_TOK symbol[fname,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] RPAREN_TOK )+ RPAREN_TOK LPAREN_TOK ( term[expr,expr2] )+ RPAREN_TOK );
 */
static void
smt25Command(pSmt2Parser ctx, CVC4::PtrCloser<CVC4::Command>* cmd)
{

      std::string name;
      std::string fname;
      Expr expr, expr2;
      std::vector<std::pair<std::string, Type> > sortedVarNames;
      SExpr sexpr;
      Type t;
      Expr func_app;
      std::vector<Expr> bvs;
      std::vector< std::vector<std::pair<std::string, Type> > > sortedVarNamesList;
      std::vector<Expr> funcs;
      std::vector<Expr> func_defs;
      Expr aexpr;
      CVC4::PtrCloser<CVC4::CommandSequence> seq;

    /* Initialize rule variables
     */

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:1144:3: ( META_INFO_TOK metaInfoInternal[cmd] | DECLARE_CONST_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] | GET_MODEL_TOK | ECHO_TOK ( simpleSymbolicExpr[sexpr] |) | RESET_TOK | RESET_ASSERTIONS_TOK | DEFINE_FUN_REC_TOK symbol[fname,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] term[expr, expr2] | DEFINE_FUNS_REC_TOK LPAREN_TOK ( LPAREN_TOK symbol[fname,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] RPAREN_TOK )+ RPAREN_TOK LPAREN_TOK ( term[expr,expr2] )+ RPAREN_TOK )

            ANTLR3_UINT32 alt24;

            alt24=8;

            switch ( LA(1) )
            {
            case META_INFO_TOK:
            	{
            		alt24=1;
            	}
                break;
            case DECLARE_CONST_TOK:
            	{
            		alt24=2;
            	}
                break;
            case GET_MODEL_TOK:
            	{
            		alt24=3;
            	}
                break;
            case ECHO_TOK:
            	{
            		alt24=4;
            	}
                break;
            case RESET_TOK:
            	{
            		alt24=5;
            	}
                break;
            case RESET_ASSERTIONS_TOK:
            	{
            		alt24=6;
            	}
                break;
            case DEFINE_FUN_REC_TOK:
            	{
            		alt24=7;
            	}
                break;
            case DEFINE_FUNS_REC_TOK:
            	{
            		alt24=8;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 24;
                EXCEPTION->state        = 0;


                goto rulesmt25CommandEx;

            }

            switch (alt24)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:1144:5: META_INFO_TOK metaInfoInternal[cmd]
        	    {
        	         MATCHT(META_INFO_TOK, &FOLLOW_META_INFO_TOK_in_smt25Command1781);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_metaInfoInternal_in_smt25Command1783);
        	        metaInfoInternal(ctx, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:1147:5: DECLARE_CONST_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED]
        	    {
        	         MATCHT(DECLARE_CONST_TOK, &FOLLOW_DECLARE_CONST_TOK_in_smt25Command1797);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_smt25Command1805);
        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkUserSymbol(name); 
        	        }


        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_smt25Command1818);
        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             Expr c = PARSER_STATE->mkVar(name, t);
        	                  cmd->reset(new DeclareFunctionCommand(name, c, t)); 
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/smt2/Smt2.g:1155:5: GET_MODEL_TOK
        	    {
        	         MATCHT(GET_MODEL_TOK, &FOLLOW_GET_MODEL_TOK_in_smt25Command1838);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             cmd->reset(new GetModelCommand()); 
        	        }


        	    }
        	    break;
        	case 4:
        	    // ../../../../src/parser/smt2/Smt2.g:1159:5: ECHO_TOK ( simpleSymbolicExpr[sexpr] |)
        	    {
        	         MATCHT(ECHO_TOK, &FOLLOW_ECHO_TOK_in_smt25Command1859);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:1160:5: ( simpleSymbolicExpr[sexpr] |)
        	        {
        	            int alt21=2;
        	            switch ( LA(1) )
        	            {
        	            case AND_TOK:
        	            case ASSERT_TOK:
        	            case BINARY_LITERAL:
        	            case BV2NAT_TOK:
        	            case CHECKSAT_TOK:
        	            case CHECK_SYNTH_TOK:
        	            case CONSTRAINT_TOK:
        	            case DECIMAL_LITERAL:
        	            case DECLARE_DATATYPES_TOK:
        	            case DECLARE_FUN_TOK:
        	            case DECLARE_PRIMED_VAR_TOK:
        	            case DECLARE_SORT_TOK:
        	            case DECLARE_VAR_TOK:
        	            case DEFINE_FUNS_REC_TOK:
        	            case DEFINE_FUN_REC_TOK:
        	            case DEFINE_FUN_TOK:
        	            case DEFINE_SORT_TOK:
        	            case DISTINCT_TOK:
        	            case DIV_TOK:
        	            case DTSIZE_TOK:
        	            case ECHO_TOK:
        	            case EQUAL_TOK:
        	            case EXIT_TOK:
        	            case FMFCARDVAL_TOK:
        	            case FMFCARD_TOK:
        	            case GET_ASSERTIONS_TOK:
        	            case GET_ASSIGNMENT_TOK:
        	            case GET_INFO_TOK:
        	            case GET_MODEL_TOK:
        	            case GET_OPTION_TOK:
        	            case GET_PROOF_TOK:
        	            case GET_UNSAT_CORE_TOK:
        	            case GET_VALUE_TOK:
        	            case GREATER_THAN_EQUAL_TOK:
        	            case GREATER_THAN_TOK:
        	            case HEX_LITERAL:
        	            case IMPLIES_TOK:
        	            case INST_CLOSURE_TOK:
        	            case INTEGER_LITERAL:
        	            case INV_CONSTRAINT_TOK:
        	            case ITE_TOK:
        	            case KEYWORD:
        	            case LESS_THAN_EQUAL_TOK:
        	            case LESS_THAN_TOK:
        	            case MINUS_TOK:
        	            case NOT_TOK:
        	            case OR_TOK:
        	            case PLUS_TOK:
        	            case POP_TOK:
        	            case PROPAGATION_RULE_TOK:
        	            case PUSH_TOK:
        	            case QUOTED_SYMBOL:
        	            case REDUCTION_RULE_TOK:
        	            case RESET_ASSERTIONS_TOK:
        	            case RESET_TOK:
        	            case REWRITE_RULE_TOK:
        	            case SET_INFO_TOK:
        	            case SET_LOGIC_TOK:
        	            case SET_OPTIONS_TOK:
        	            case SET_OPTION_TOK:
        	            case SIMPLE_SYMBOL:
        	            case SIMPLIFY_TOK:
        	            case STAR_TOK:
        	            case STRING_LITERAL_2_0:
        	            case STRING_LITERAL_2_5:
        	            case SYNTH_FUN_TOK:
        	            case SYNTH_INV_TOK:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            case XOR_TOK:
        	            case 154:
        	            	{
        	            		alt21=1;
        	            	}
        	                break;
        	            case RPAREN_TOK:
        	            	{
        	            		alt21=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 21;
        	                EXCEPTION->state        = 0;


        	                goto rulesmt25CommandEx;

        	            }

        	            switch (alt21)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:1160:7: simpleSymbolicExpr[sexpr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_simpleSymbolicExpr_in_smt25Command1867);
        	        	        simpleSymbolicExpr(ctx, sexpr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesmt25CommandEx;
        	        	        }


        	        	        {
        	        	             cmd->reset(new EchoCommand(sexpr.toString())); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/smt2/Smt2.g:1162:7: 
        	        	    {
        	        	        {
        	        	             cmd->reset(new EchoCommand()); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 5:
        	    // ../../../../src/parser/smt2/Smt2.g:1167:5: RESET_TOK
        	    {
        	         MATCHT(RESET_TOK, &FOLLOW_RESET_TOK_in_smt25Command1903);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             cmd->reset(new ResetCommand());
        	                  PARSER_STATE->reset();
        	                
        	        }


        	    }
        	    break;
        	case 6:
        	    // ../../../../src/parser/smt2/Smt2.g:1173:5: RESET_ASSERTIONS_TOK
        	    {
        	         MATCHT(RESET_ASSERTIONS_TOK, &FOLLOW_RESET_ASSERTIONS_TOK_in_smt25Command1921);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             cmd->reset(new ResetAssertionsCommand());
        	                  PARSER_STATE->resetAssertions();
        	                
        	        }


        	    }
        	    break;
        	case 7:
        	    // ../../../../src/parser/smt2/Smt2.g:1177:5: DEFINE_FUN_REC_TOK symbol[fname,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] term[expr, expr2]
        	    {
        	         MATCHT(DEFINE_FUN_REC_TOK, &FOLLOW_DEFINE_FUN_REC_TOK_in_smt25Command1933);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet();
        	                  seq.reset(new CVC4::CommandSequence());
        	                
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_smt25Command1945);
        	        symbol(ctx, fname, CHECK_UNDECLARED, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkUserSymbol(fname); 
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_smt25Command1958);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortedVarList_in_smt25Command1960);
        	        sortedVarList(ctx, sortedVarNames);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_smt25Command1963);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_smt25Command1969);
        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             if( sortedVarNames.size() > 0 ) {
        	                    std::vector<CVC4::Type> sorts;
        	                    sorts.reserve(sortedVarNames.size());
        	                    for(std::vector<std::pair<std::string, CVC4::Type> >::const_iterator i =
        	                        sortedVarNames.begin(), iend = sortedVarNames.end(); i != iend;
        	                        ++i) {
        	                      sorts.push_back((*i).second);
        	                    }
        	                    t = EXPR_MANAGER->mkFunctionType(sorts, t);
        	                  }
        	                  Expr func = PARSER_STATE->mkVar(fname, t);
        	                  seq->addCommand(new DeclareFunctionCommand(fname, func, t));
        	                  if( sortedVarNames.empty() ){
        	                    func_app = func;
        	                  }else{
        	                    std::vector< Expr > f_app;
        	                    f_app.push_back( func );
        	                    PARSER_STATE->pushScope(true);
        	                    for(std::vector<std::pair<std::string, CVC4::Type> >::const_iterator i =
        	                          sortedVarNames.begin(), iend = sortedVarNames.end(); i != iend;
        	                        ++i) {
        	                      Expr v = PARSER_STATE->mkBoundVar((*i).first, (*i).second);
        	                      bvs.push_back( v );
        	                      f_app.push_back( v );
        	                    }
        	                    func_app = MK_EXPR( kind::APPLY_UF, f_app );
        	                  }
        	                
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_smt25Command1982);
        	        term(ctx, expr, expr2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             PARSER_STATE->popScope(); 
        	                  Expr as = MK_EXPR( kind::EQUAL, func_app, expr);
        	                  if( !bvs.empty() ){
        	                    std::string attr_name("fun-def");
        	                    aexpr = MK_EXPR(kind::INST_ATTRIBUTE, func_app);
        	                    aexpr = MK_EXPR(kind::INST_PATTERN_LIST, aexpr);
        	                    //set the attribute to denote this is a function definition
        	                    seq->addCommand( new SetUserAttributeCommand( attr_name, func_app ) );
        	                    //assert it
        	                    Expr boundVars = EXPR_MANAGER->mkExpr(kind::BOUND_VAR_LIST, bvs);
        	                    as = EXPR_MANAGER->mkExpr(kind::FORALL, boundVars, as, aexpr);
        	                  }
        	                  seq->addCommand( new AssertCommand(as, false) );
        	                  cmd->reset(seq.release());
        	                
        	        }


        	    }
        	    break;
        	case 8:
        	    // ../../../../src/parser/smt2/Smt2.g:1229:5: DEFINE_FUNS_REC_TOK LPAREN_TOK ( LPAREN_TOK symbol[fname,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] RPAREN_TOK )+ RPAREN_TOK LPAREN_TOK ( term[expr,expr2] )+ RPAREN_TOK
        	    {
        	         MATCHT(DEFINE_FUNS_REC_TOK, &FOLLOW_DEFINE_FUNS_REC_TOK_in_smt25Command1995);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet();
        	                  seq.reset(new CVC4::CommandSequence());
        	                
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_smt25Command2007);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:1234:5: ( LPAREN_TOK symbol[fname,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] RPAREN_TOK )+
        	        {
        	            int cnt22=0;

        	            for (;;)
        	            {
        	                int alt22=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case LPAREN_TOK:
        	        		{
        	        			alt22=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt22)
        	        	{
        	        	    case 1:
        	        	        // ../../../../src/parser/smt2/Smt2.g:1234:7: LPAREN_TOK symbol[fname,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] RPAREN_TOK
        	        	        {
        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_smt25Command2015);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulesmt25CommandEx;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_symbol_in_smt25Command2023);
        	        	            symbol(ctx, fname, CHECK_UNDECLARED, SYM_VARIABLE);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulesmt25CommandEx;
        	        	            }


        	        	            {
        	        	                 PARSER_STATE->checkUserSymbol(fname); 
        	        	            }


        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_smt25Command2040);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulesmt25CommandEx;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_sortedVarList_in_smt25Command2042);
        	        	            sortedVarList(ctx, sortedVarNames);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulesmt25CommandEx;
        	        	            }


        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_smt25Command2045);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulesmt25CommandEx;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_sortSymbol_in_smt25Command2053);
        	        	            sortSymbol(ctx, t, CHECK_DECLARED);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulesmt25CommandEx;
        	        	            }


        	        	            {
        	        	                 sortedVarNamesList.push_back( sortedVarNames );
        	        	                        if( sortedVarNamesList[0].size() > 0 ) {
        	        	                          if( !sortedVarNames.empty() ){
        	        	                            std::vector<CVC4::Type> sorts;
        	        	                            for(std::vector<std::pair<std::string, CVC4::Type> >::const_iterator
        	        	                                    i = sortedVarNames.begin(), iend = sortedVarNames.end();
        	        	                                i != iend; ++i) {
        	        	                              sorts.push_back((*i).second);
        	        	                            }
        	        	                            t = EXPR_MANAGER->mkFunctionType(sorts, t);
        	        	                          }
        	        	                        }
        	        	                        sortedVarNames.clear();
        	        	                        Expr func = PARSER_STATE->mkVar(fname, t);
        	        	                        seq->addCommand(new DeclareFunctionCommand(fname, func, t));
        	        	                        funcs.push_back( func );
        	        	                      
        	        	            }


        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_smt25Command2070);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulesmt25CommandEx;
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt22 >= 1 )
        	        		{
        	        		    goto loop22;
        	        		}
        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto rulesmt25CommandEx;
        	        	}
        	        	cnt22++;
        	            }
        	            loop22: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_smt25Command2083);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_smt25Command2089);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             
        	                  //set up the first scope 
        	                  if( sortedVarNamesList.empty() ){
        	                    PARSER_STATE->parseError("Must define at least one function in "
        	                                             "define-funs-rec");
        	                  }
        	                  PARSER_STATE->pushScope(true);
        	                  bvs.clear();
        	                  if( sortedVarNamesList[0].empty() ){
        	                    func_app = funcs[0];
        	                  }else{
        	                    std::vector< Expr > f_app;
        	                    f_app.push_back( funcs[0] );
        	                    for(std::vector<std::pair<std::string, CVC4::Type> >::const_iterator
        	                          i = sortedVarNamesList[0].begin(),
        	                          iend = sortedVarNamesList[0].end(); i != iend; ++i) {
        	                      Expr v = PARSER_STATE->mkBoundVar((*i).first, (*i).second);
        	                      bvs.push_back( v );
        	                      f_app.push_back( v );
        	                    }
        	                    func_app = MK_EXPR( kind::APPLY_UF, f_app );
        	                  }
        	                
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:1283:5: ( term[expr,expr2] )+
        	        {
        	            int cnt23=0;

        	            for (;;)
        	            {
        	                int alt23=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case BINARY_LITERAL:
        	        	case CHECK_SYNTH_TOK:
        	        	case CONSTRAINT_TOK:
        	        	case DECIMAL_LITERAL:
        	        	case DECLARE_PRIMED_VAR_TOK:
        	        	case DECLARE_VAR_TOK:
        	        	case EMPTYSET_TOK:
        	        	case FP_RNA_FULL_TOK:
        	        	case FP_RNA_TOK:
        	        	case FP_RNE_FULL_TOK:
        	        	case FP_RNE_TOK:
        	        	case FP_RTN_FULL_TOK:
        	        	case FP_RTN_TOK:
        	        	case FP_RTP_FULL_TOK:
        	        	case FP_RTP_TOK:
        	        	case FP_RTZ_FULL_TOK:
        	        	case FP_RTZ_TOK:
        	        	case HEX_LITERAL:
        	        	case INTEGER_LITERAL:
        	        	case INV_CONSTRAINT_TOK:
        	        	case LPAREN_TOK:
        	        	case NILREF_TOK:
        	        	case QUOTED_SYMBOL:
        	        	case REALLCHAR_TOK:
        	        	case RENOSTR_TOK:
        	        	case SET_OPTIONS_TOK:
        	        	case SIMPLE_SYMBOL:
        	        	case STRING_LITERAL_2_0:
        	        	case STRING_LITERAL_2_5:
        	        	case SYNTH_FUN_TOK:
        	        	case SYNTH_INV_TOK:
        	        	case UNIVSET_TOK:
        	        	case UNTERMINATED_QUOTED_SYMBOL:
        	        	case 154:
        	        		{
        	        			alt23=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt23)
        	        	{
        	        	    case 1:
        	        	        // ../../../../src/parser/smt2/Smt2.g:1284:5: term[expr,expr2]
        	        	        {
        	        	            FOLLOWPUSH(FOLLOW_term_in_smt25Command2107);
        	        	            term(ctx, expr, expr2);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulesmt25CommandEx;
        	        	            }


        	        	            {
        	        	                 
        	        	                      func_defs.push_back( expr );
        	        	                      Expr as = MK_EXPR( kind::EQUAL, func_app, expr );
        	        	                      if( !bvs.empty() ){
        	        	                        std::string attr_name("fun-def");
        	        	                        aexpr = MK_EXPR(kind::INST_ATTRIBUTE, func_app);
        	        	                        aexpr = MK_EXPR(kind::INST_PATTERN_LIST, aexpr );
        	        	                        //set the attribute to denote these are function definitions
        	        	                        seq->addCommand( new SetUserAttributeCommand( attr_name, func_app ) );
        	        	                        //assert it
        	        	                        as = EXPR_MANAGER->mkExpr( kind::FORALL,
        	        	                                      EXPR_MANAGER->mkExpr(kind::BOUND_VAR_LIST, bvs),
        	        	                                      as, aexpr);
        	        	                      }
        	        	                      seq->addCommand( new AssertCommand(as, false) );
        	        	                      //set up the next scope 
        	        	                      PARSER_STATE->popScope();
        	        	                      if( func_defs.size()<funcs.size() ){
        	        	                        PARSER_STATE->pushScope(true);
        	        	                        bvs.clear();
        	        	                        unsigned j = func_defs.size();
        	        	                        if( sortedVarNamesList[j].empty() ){
        	        	                          func_app = funcs[j];
        	        	                        }else{
        	        	                          std::vector< Expr > f_app;
        	        	                          f_app.push_back( funcs[j] );
        	        	                          for(std::vector<std::pair<std::string, CVC4::Type> >::const_iterator
        	        	                                  i = sortedVarNamesList[j].begin(),
        	        	                                  iend = sortedVarNamesList[j].end(); i != iend; ++i) {
        	        	                            Expr v = PARSER_STATE->mkBoundVar((*i).first, (*i).second);
        	        	                            bvs.push_back( v );
        	        	                            f_app.push_back( v );
        	        	                          }
        	        	                          func_app = MK_EXPR( kind::APPLY_UF, f_app );
        	        	                        }
        	        	                      }
        	        	                    
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt23 >= 1 )
        	        		{
        	        		    goto loop23;
        	        		}
        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto rulesmt25CommandEx;
        	        	}
        	        	cnt23++;
        	            }
        	            loop23: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_smt25Command2127);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             if( funcs.size()!=func_defs.size() ){
        	                    PARSER_STATE->parseError(std::string(
        	                        "Number of functions defined does not match number listed in "
        	                        "define-funs-rec"));
        	                  }
        	                  cmd->reset(seq.release());
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesmt25CommandEx; /* Prevent compiler warnings */
    rulesmt25CommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end smt25Command */

/**
 * $ANTLR start extendedCommand
 * ../../../../src/parser/smt2/Smt2.g:1335:1: extendedCommand[CVC4::PtrCloser<CVC4::Command>* cmd] : ( DECLARE_DATATYPES_2_5_TOK datatypes_2_5_DefCommand[false, cmd] | DECLARE_CODATATYPES_2_5_TOK datatypes_2_5_DefCommand[true, cmd] | DECLARE_DATATYPE_TOK datatypeDefCommand[false, cmd] | DECLARE_CODATATYPE_TOK datatypeDefCommand[true, cmd] | DECLARE_DATATYPES_TOK datatypesDefCommand[false, cmd] | DECLARE_CODATATYPES_TOK datatypesDefCommand[true, cmd] | rewriterulesCommand[cmd] | DECLARE_SORTS_TOK LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )+ RPAREN_TOK | DECLARE_FUNS_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] nonemptySortList[sorts] RPAREN_TOK )+ RPAREN_TOK | DECLARE_PREDS_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortList[sorts] RPAREN_TOK )+ RPAREN_TOK | DEFINE_TOK ( symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] term[e,e2] | LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortedVarList[sortedVarNames] RPAREN_TOK term[e,e2] ) | DEFINE_CONST_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] term[e, e2] | SIMPLIFY_TOK term[e,e2] | GET_QE_TOK term[e,e2] | GET_QE_DISJUNCT_TOK term[e,e2] );
 */
static void
extendedCommand(pSmt2Parser ctx, CVC4::PtrCloser<CVC4::Command>* cmd)
{

      std::vector<CVC4::Datatype> dts;
      Expr e, e2;
      Type t;
      std::string name;
      std::vector<std::string> names;
      std::vector<Expr> terms;
      std::vector<Type> sorts;
      std::vector<std::pair<std::string, Type> > sortedVarNames;
      CVC4::PtrCloser<CVC4::CommandSequence> seq;

    /* Initialize rule variables
     */

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:1349:3: ( DECLARE_DATATYPES_2_5_TOK datatypes_2_5_DefCommand[false, cmd] | DECLARE_CODATATYPES_2_5_TOK datatypes_2_5_DefCommand[true, cmd] | DECLARE_DATATYPE_TOK datatypeDefCommand[false, cmd] | DECLARE_CODATATYPE_TOK datatypeDefCommand[true, cmd] | DECLARE_DATATYPES_TOK datatypesDefCommand[false, cmd] | DECLARE_CODATATYPES_TOK datatypesDefCommand[true, cmd] | rewriterulesCommand[cmd] | DECLARE_SORTS_TOK LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )+ RPAREN_TOK | DECLARE_FUNS_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] nonemptySortList[sorts] RPAREN_TOK )+ RPAREN_TOK | DECLARE_PREDS_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortList[sorts] RPAREN_TOK )+ RPAREN_TOK | DEFINE_TOK ( symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] term[e,e2] | LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortedVarList[sortedVarNames] RPAREN_TOK term[e,e2] ) | DEFINE_CONST_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] term[e, e2] | SIMPLIFY_TOK term[e,e2] | GET_QE_TOK term[e,e2] | GET_QE_DISJUNCT_TOK term[e,e2] )

            ANTLR3_UINT32 alt29;

            alt29=15;

            switch ( LA(1) )
            {
            case DECLARE_DATATYPES_2_5_TOK:
            	{
            		alt29=1;
            	}
                break;
            case DECLARE_CODATATYPES_2_5_TOK:
            	{
            		alt29=2;
            	}
                break;
            case DECLARE_DATATYPE_TOK:
            	{
            		alt29=3;
            	}
                break;
            case DECLARE_CODATATYPE_TOK:
            	{
            		alt29=4;
            	}
                break;
            case DECLARE_DATATYPES_TOK:
            	{
            		alt29=5;
            	}
                break;
            case DECLARE_CODATATYPES_TOK:
            	{
            		alt29=6;
            	}
                break;
            case PROPAGATION_RULE_TOK:
            case REDUCTION_RULE_TOK:
            case REWRITE_RULE_TOK:
            	{
            		alt29=7;
            	}
                break;
            case DECLARE_SORTS_TOK:
            	{
            		alt29=8;
            	}
                break;
            case DECLARE_FUNS_TOK:
            	{
            		alt29=9;
            	}
                break;
            case DECLARE_PREDS_TOK:
            	{
            		alt29=10;
            	}
                break;
            case DEFINE_TOK:
            	{
            		alt29=11;
            	}
                break;
            case DEFINE_CONST_TOK:
            	{
            		alt29=12;
            	}
                break;
            case SIMPLIFY_TOK:
            	{
            		alt29=13;
            	}
                break;
            case GET_QE_TOK:
            	{
            		alt29=14;
            	}
                break;
            case GET_QE_DISJUNCT_TOK:
            	{
            		alt29=15;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 29;
                EXCEPTION->state        = 0;


                goto ruleextendedCommandEx;

            }

            switch (alt29)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:1349:5: DECLARE_DATATYPES_2_5_TOK datatypes_2_5_DefCommand[false, cmd]
        	    {
        	         MATCHT(DECLARE_DATATYPES_2_5_TOK, &FOLLOW_DECLARE_DATATYPES_2_5_TOK_in_extendedCommand2164);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_datatypes_2_5_DefCommand_in_extendedCommand2166);
        	        datatypes_2_5_DefCommand(ctx, false, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:1350:5: DECLARE_CODATATYPES_2_5_TOK datatypes_2_5_DefCommand[true, cmd]
        	    {
        	         MATCHT(DECLARE_CODATATYPES_2_5_TOK, &FOLLOW_DECLARE_CODATATYPES_2_5_TOK_in_extendedCommand2173);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_datatypes_2_5_DefCommand_in_extendedCommand2175);
        	        datatypes_2_5_DefCommand(ctx, true, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/smt2/Smt2.g:1351:5: DECLARE_DATATYPE_TOK datatypeDefCommand[false, cmd]
        	    {
        	         MATCHT(DECLARE_DATATYPE_TOK, &FOLLOW_DECLARE_DATATYPE_TOK_in_extendedCommand2182);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_datatypeDefCommand_in_extendedCommand2184);
        	        datatypeDefCommand(ctx, false, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	    }
        	    break;
        	case 4:
        	    // ../../../../src/parser/smt2/Smt2.g:1352:5: DECLARE_CODATATYPE_TOK datatypeDefCommand[true, cmd]
        	    {
        	         MATCHT(DECLARE_CODATATYPE_TOK, &FOLLOW_DECLARE_CODATATYPE_TOK_in_extendedCommand2191);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_datatypeDefCommand_in_extendedCommand2193);
        	        datatypeDefCommand(ctx, true, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	    }
        	    break;
        	case 5:
        	    // ../../../../src/parser/smt2/Smt2.g:1353:5: DECLARE_DATATYPES_TOK datatypesDefCommand[false, cmd]
        	    {
        	         MATCHT(DECLARE_DATATYPES_TOK, &FOLLOW_DECLARE_DATATYPES_TOK_in_extendedCommand2200);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_datatypesDefCommand_in_extendedCommand2202);
        	        datatypesDefCommand(ctx, false, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	    }
        	    break;
        	case 6:
        	    // ../../../../src/parser/smt2/Smt2.g:1354:5: DECLARE_CODATATYPES_TOK datatypesDefCommand[true, cmd]
        	    {
        	         MATCHT(DECLARE_CODATATYPES_TOK, &FOLLOW_DECLARE_CODATATYPES_TOK_in_extendedCommand2209);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_datatypesDefCommand_in_extendedCommand2211);
        	        datatypesDefCommand(ctx, true, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	    }
        	    break;
        	case 7:
        	    // ../../../../src/parser/smt2/Smt2.g:1355:5: rewriterulesCommand[cmd]
        	    {
        	        FOLLOWPUSH(FOLLOW_rewriterulesCommand_in_extendedCommand2218);
        	        rewriterulesCommand(ctx, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	    }
        	    break;
        	case 8:
        	    // ../../../../src/parser/smt2/Smt2.g:1359:5: DECLARE_SORTS_TOK LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )+ RPAREN_TOK
        	    {
        	         MATCHT(DECLARE_SORTS_TOK, &FOLLOW_DECLARE_SORTS_TOK_in_extendedCommand2233);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             if(!PARSER_STATE->isTheoryEnabled(Smt2::THEORY_UF) &&
        	                     !PARSER_STATE->isTheoryEnabled(Smt2::THEORY_ARRAYS) &&
        	                     !PARSER_STATE->isTheoryEnabled(Smt2::THEORY_DATATYPES) &&
        	                     !PARSER_STATE->isTheoryEnabled(Smt2::THEORY_SETS)) {
        	                    PARSER_STATE->parseErrorLogic("Free sort symbols not allowed in ");
        	                  }
        	                
        	        }


        	        {
        	             seq.reset(new CVC4::CommandSequence()); 
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_extendedCommand2253);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:1369:5: ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )+
        	        {
        	            int cnt25=0;

        	            for (;;)
        	            {
        	                int alt25=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case CHECK_SYNTH_TOK:
        	        	case CONSTRAINT_TOK:
        	        	case DECLARE_PRIMED_VAR_TOK:
        	        	case DECLARE_VAR_TOK:
        	        	case INV_CONSTRAINT_TOK:
        	        	case QUOTED_SYMBOL:
        	        	case SET_OPTIONS_TOK:
        	        	case SIMPLE_SYMBOL:
        	        	case SYNTH_FUN_TOK:
        	        	case SYNTH_INV_TOK:
        	        	case UNTERMINATED_QUOTED_SYMBOL:
        	        	case 154:
        	        		{
        	        			alt25=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt25)
        	        	{
        	        	    case 1:
        	        	        // ../../../../src/parser/smt2/Smt2.g:1369:7: symbol[name,CHECK_UNDECLARED,SYM_SORT]
        	        	        {
        	        	            FOLLOWPUSH(FOLLOW_symbol_in_extendedCommand2261);
        	        	            symbol(ctx, name, CHECK_UNDECLARED, SYM_SORT);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }


        	        	            {
        	        	                 PARSER_STATE->checkUserSymbol(name);
        	        	                        Type type = PARSER_STATE->mkSort(name);
        	        	                        seq->addCommand(new DeclareTypeCommand(name, 0, type));
        	        	                      
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt25 >= 1 )
        	        		{
        	        		    goto loop25;
        	        		}
        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto ruleextendedCommandEx;
        	        	}
        	        	cnt25++;
        	            }
        	            loop25: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_extendedCommand2283);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             cmd->reset(seq.release()); 
        	        }


        	    }
        	    break;
        	case 9:
        	    // ../../../../src/parser/smt2/Smt2.g:1378:5: DECLARE_FUNS_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] nonemptySortList[sorts] RPAREN_TOK )+ RPAREN_TOK
        	    {
        	         MATCHT(DECLARE_FUNS_TOK, &FOLLOW_DECLARE_FUNS_TOK_in_extendedCommand2296);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             seq.reset(new CVC4::CommandSequence()); 
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_extendedCommand2310);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:1381:5: ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] nonemptySortList[sorts] RPAREN_TOK )+
        	        {
        	            int cnt26=0;

        	            for (;;)
        	            {
        	                int alt26=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case LPAREN_TOK:
        	        		{
        	        			alt26=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt26)
        	        	{
        	        	    case 1:
        	        	        // ../../../../src/parser/smt2/Smt2.g:1381:7: LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] nonemptySortList[sorts] RPAREN_TOK
        	        	        {
        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_extendedCommand2318);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_symbol_in_extendedCommand2320);
        	        	            symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }


        	        	            {
        	        	                 PARSER_STATE->checkUserSymbol(name); 
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_nonemptySortList_in_extendedCommand2337);
        	        	            nonemptySortList(ctx, sorts);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }


        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_extendedCommand2340);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }


        	        	            {
        	        	                 Type t;
        	        	                        if(sorts.size() > 1) {
        	        	                          if(!PARSER_STATE->isTheoryEnabled(Smt2::THEORY_UF)) {
        	        	                            PARSER_STATE->parseErrorLogic("Functions (of non-zero arity) "
        	        	                                                          "cannot be declared in logic ");
        	        	                          }
        	        	                          t = EXPR_MANAGER->mkFunctionType(sorts);
        	        	                        } else {
        	        	                          t = sorts[0];
        	        	                        }
        	        	                        Expr func = PARSER_STATE->mkVar(name, t);
        	        	                        seq->addCommand(new DeclareFunctionCommand(name, func, t));
        	        	                        sorts.clear();
        	        	                      
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt26 >= 1 )
        	        		{
        	        		    goto loop26;
        	        		}
        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto ruleextendedCommandEx;
        	        	}
        	        	cnt26++;
        	            }
        	            loop26: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_extendedCommand2361);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             cmd->reset(seq.release()); 
        	        }


        	    }
        	    break;
        	case 10:
        	    // ../../../../src/parser/smt2/Smt2.g:1401:5: DECLARE_PREDS_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortList[sorts] RPAREN_TOK )+ RPAREN_TOK
        	    {
        	         MATCHT(DECLARE_PREDS_TOK, &FOLLOW_DECLARE_PREDS_TOK_in_extendedCommand2374);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             seq.reset(new CVC4::CommandSequence()); 
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_extendedCommand2388);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:1404:5: ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortList[sorts] RPAREN_TOK )+
        	        {
        	            int cnt27=0;

        	            for (;;)
        	            {
        	                int alt27=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case LPAREN_TOK:
        	        		{
        	        			alt27=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt27)
        	        	{
        	        	    case 1:
        	        	        // ../../../../src/parser/smt2/Smt2.g:1404:7: LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortList[sorts] RPAREN_TOK
        	        	        {
        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_extendedCommand2396);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_symbol_in_extendedCommand2398);
        	        	            symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }


        	        	            {
        	        	                 PARSER_STATE->checkUserSymbol(name); 
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_sortList_in_extendedCommand2415);
        	        	            sortList(ctx, sorts);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }


        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_extendedCommand2418);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }


        	        	            {
        	        	                 Type t = EXPR_MANAGER->booleanType();
        	        	                        if(sorts.size() > 0) {
        	        	                          if(!PARSER_STATE->isTheoryEnabled(Smt2::THEORY_UF)) {
        	        	                            PARSER_STATE->parseErrorLogic("Predicates (of non-zero arity) "
        	        	                                                          "cannot be declared in logic ");
        	        	                          }
        	        	                          t = EXPR_MANAGER->mkFunctionType(sorts, t);
        	        	                        }
        	        	                        Expr func = PARSER_STATE->mkVar(name, t);
        	        	                        seq->addCommand(new DeclareFunctionCommand(name, func, t));
        	        	                        sorts.clear();
        	        	                      
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt27 >= 1 )
        	        		{
        	        		    goto loop27;
        	        		}
        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto ruleextendedCommandEx;
        	        	}
        	        	cnt27++;
        	            }
        	            loop27: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_extendedCommand2439);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             cmd->reset(seq.release()); 
        	        }


        	    }
        	    break;
        	case 11:
        	    // ../../../../src/parser/smt2/Smt2.g:1423:5: DEFINE_TOK ( symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] term[e,e2] | LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortedVarList[sortedVarNames] RPAREN_TOK term[e,e2] )
        	    {
        	         MATCHT(DEFINE_TOK, &FOLLOW_DEFINE_TOK_in_extendedCommand2452);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:1424:5: ( symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] term[e,e2] | LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortedVarList[sortedVarNames] RPAREN_TOK term[e,e2] )
        	        {
        	            int alt28=2;
        	            switch ( LA(1) )
        	            {
        	            case CHECK_SYNTH_TOK:
        	            case CONSTRAINT_TOK:
        	            case DECLARE_PRIMED_VAR_TOK:
        	            case DECLARE_VAR_TOK:
        	            case INV_CONSTRAINT_TOK:
        	            case QUOTED_SYMBOL:
        	            case SET_OPTIONS_TOK:
        	            case SIMPLE_SYMBOL:
        	            case SYNTH_FUN_TOK:
        	            case SYNTH_INV_TOK:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            case 154:
        	            	{
        	            		alt28=1;
        	            	}
        	                break;
        	            case LPAREN_TOK:
        	            	{
        	            		alt28=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 28;
        	                EXCEPTION->state        = 0;


        	                goto ruleextendedCommandEx;

        	            }

        	            switch (alt28)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:1424:7: symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] term[e,e2]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_symbol_in_extendedCommand2462);
        	        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleextendedCommandEx;
        	        	        }


        	        	        {
        	        	             PARSER_STATE->checkUserSymbol(name); 
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_term_in_extendedCommand2479);
        	        	        term(ctx, e, e2);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleextendedCommandEx;
        	        	        }


        	        	        {
        	        	             Expr func = PARSER_STATE->mkFunction(name, e.getType(),
        	        	                                                         ExprManager::VAR_FLAG_DEFINED);
        	        	                    cmd->reset(new DefineFunctionCommand(name, func, e));
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/smt2/Smt2.g:1431:7: LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortedVarList[sortedVarNames] RPAREN_TOK term[e,e2]
        	        	    {
        	        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_extendedCommand2496);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleextendedCommandEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_symbol_in_extendedCommand2504);
        	        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleextendedCommandEx;
        	        	        }


        	        	        {
        	        	             PARSER_STATE->checkUserSymbol(name); 
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_sortedVarList_in_extendedCommand2521);
        	        	        sortedVarList(ctx, sortedVarNames);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleextendedCommandEx;
        	        	        }


        	        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_extendedCommand2524);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleextendedCommandEx;
        	        	        }


        	        	        {
        	        	             /* add variables to parser state before parsing term */
        	        	                    Debug("parser") << "define fun: '" << name << "'" << std::endl;
        	        	                    PARSER_STATE->pushScope(true);
        	        	                    for(std::vector<std::pair<std::string, CVC4::Type> >::const_iterator i =
        	        	                          sortedVarNames.begin(), iend = sortedVarNames.end(); i != iend;
        	        	                        ++i) {
        	        	                      terms.push_back(PARSER_STATE->mkBoundVar((*i).first, (*i).second));
        	        	                    }
        	        	                  
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_term_in_extendedCommand2540);
        	        	        term(ctx, e, e2);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleextendedCommandEx;
        	        	        }


        	        	        {
        	        	             PARSER_STATE->popScope();
        	        	                    // declare the name down here (while parsing term, signature
        	        	                    // must not be extended with the name itself; no recursion
        	        	                    // permitted)
        	        	                    Type t = e.getType();
        	        	                    if( sortedVarNames.size() > 0 ) {
        	        	                      std::vector<CVC4::Type> sorts;
        	        	                      sorts.reserve(sortedVarNames.size());
        	        	                      for(std::vector<std::pair<std::string, CVC4::Type> >::const_iterator
        	        	                            i = sortedVarNames.begin(), iend = sortedVarNames.end();
        	        	                          i != iend; ++i) {
        	        	                        sorts.push_back((*i).second);
        	        	                      }
        	        	                      t = EXPR_MANAGER->mkFunctionType(sorts, t);
        	        	                    }
        	        	                    Expr func = PARSER_STATE->mkFunction(name, t,
        	        	                                                         ExprManager::VAR_FLAG_DEFINED);
        	        	                    cmd->reset(new DefineFunctionCommand(name, func, terms, e));
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 12:
        	    // ../../../../src/parser/smt2/Smt2.g:1465:5: DEFINE_CONST_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] term[e, e2]
        	    {
        	         MATCHT(DEFINE_CONST_TOK, &FOLLOW_DEFINE_CONST_TOK_in_extendedCommand2561);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_extendedCommand2569);
        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkUserSymbol(name); 
        	        }


        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_extendedCommand2582);
        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             /* add variables to parser state before parsing term */
        	                  Debug("parser") << "define const: '" << name << "'" << std::endl;
        	                  PARSER_STATE->pushScope(true);
        	                  for(std::vector<std::pair<std::string, CVC4::Type> >::const_iterator i =
        	                        sortedVarNames.begin(), iend = sortedVarNames.end(); i != iend;
        	                      ++i) {
        	                    terms.push_back(PARSER_STATE->mkBoundVar((*i).first, (*i).second));
        	                  }
        	                
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_extendedCommand2595);
        	        term(ctx, e, e2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             PARSER_STATE->popScope();
        	                  // declare the name down here (while parsing term, signature
        	                  // must not be extended with the name itself; no recursion
        	                  // permitted)
        	                  Expr func = PARSER_STATE->mkFunction(name, t,
        	                                                       ExprManager::VAR_FLAG_DEFINED);
        	                  cmd->reset(new DefineFunctionCommand(name, func, terms, e));
        	                
        	        }


        	    }
        	    break;
        	case 13:
        	    // ../../../../src/parser/smt2/Smt2.g:1488:5: SIMPLIFY_TOK term[e,e2]
        	    {
        	         MATCHT(SIMPLIFY_TOK, &FOLLOW_SIMPLIFY_TOK_in_extendedCommand2609);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_extendedCommand2617);
        	        term(ctx, e, e2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             cmd->reset(new SimplifyCommand(e)); 
        	        }


        	    }
        	    break;
        	case 14:
        	    // ../../../../src/parser/smt2/Smt2.g:1491:5: GET_QE_TOK term[e,e2]
        	    {
        	         MATCHT(GET_QE_TOK, &FOLLOW_GET_QE_TOK_in_extendedCommand2630);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_extendedCommand2638);
        	        term(ctx, e, e2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             cmd->reset(new GetQuantifierEliminationCommand(e, true)); 
        	        }


        	    }
        	    break;
        	case 15:
        	    // ../../../../src/parser/smt2/Smt2.g:1494:5: GET_QE_DISJUNCT_TOK term[e,e2]
        	    {
        	         MATCHT(GET_QE_DISJUNCT_TOK, &FOLLOW_GET_QE_DISJUNCT_TOK_in_extendedCommand2651);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_extendedCommand2659);
        	        term(ctx, e, e2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             cmd->reset(new GetQuantifierEliminationCommand(e, false)); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleextendedCommandEx; /* Prevent compiler warnings */
    ruleextendedCommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end extendedCommand */

/**
 * $ANTLR start datatypes_2_5_DefCommand
 * ../../../../src/parser/smt2/Smt2.g:1500:1: datatypes_2_5_DefCommand[bool isCo, CVC4::PtrCloser<CVC4::Command>* cmd] : LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK datatypeDef[isCo, dts, sorts] RPAREN_TOK )+ RPAREN_TOK ;
 */
static void
datatypes_2_5_DefCommand(pSmt2Parser ctx, bool isCo, CVC4::PtrCloser<CVC4::Command>* cmd)
{

      std::vector<CVC4::Datatype> dts;
      std::string name;
      std::vector<Type> sorts;

    /* Initialize rule variables
     */

    {
        // ../../../../src/parser/smt2/Smt2.g:1506:3: ( LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK datatypeDef[isCo, dts, sorts] RPAREN_TOK )+ RPAREN_TOK )
        // ../../../../src/parser/smt2/Smt2.g:1506:5: LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK datatypeDef[isCo, dts, sorts] RPAREN_TOK )+ RPAREN_TOK
        {
            {
                 PARSER_STATE->checkThatLogicIsSet();
                    /* open a scope to keep the UnresolvedTypes contained */
                    PARSER_STATE->pushScope(true); 
            }


             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand2690);
            if  (HASEXCEPTION())
            {
                goto ruledatatypes_2_5_DefCommandEx;
            }


            // ../../../../src/parser/smt2/Smt2.g:1510:3: ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )*

            for (;;)
            {
                int alt30=2;
                switch ( LA(1) )
                {
                case CHECK_SYNTH_TOK:
                case CONSTRAINT_TOK:
                case DECLARE_PRIMED_VAR_TOK:
                case DECLARE_VAR_TOK:
                case INV_CONSTRAINT_TOK:
                case QUOTED_SYMBOL:
                case SET_OPTIONS_TOK:
                case SIMPLE_SYMBOL:
                case SYNTH_FUN_TOK:
                case SYNTH_INV_TOK:
                case UNTERMINATED_QUOTED_SYMBOL:
                case 154:
                	{
                		alt30=1;
                	}
                    break;

                }

                switch (alt30)
                {
            	case 1:
            	    // ../../../../src/parser/smt2/Smt2.g:1510:5: symbol[name,CHECK_UNDECLARED,SYM_SORT]
            	    {
            	        FOLLOWPUSH(FOLLOW_symbol_in_datatypes_2_5_DefCommand2698);
            	        symbol(ctx, name, CHECK_UNDECLARED, SYM_SORT);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledatatypes_2_5_DefCommandEx;
            	        }


            	        {
            	             sorts.push_back( PARSER_STATE->mkSort(name) ); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop30;	/* break out of the loop */
            	    break;
                }
            }
            loop30: ; /* Jump out to here if this rule does not match */


             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand2714);
            if  (HASEXCEPTION())
            {
                goto ruledatatypes_2_5_DefCommandEx;
            }


             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand2718);
            if  (HASEXCEPTION())
            {
                goto ruledatatypes_2_5_DefCommandEx;
            }


            // ../../../../src/parser/smt2/Smt2.g:1514:14: ( LPAREN_TOK datatypeDef[isCo, dts, sorts] RPAREN_TOK )+
            {
                int cnt31=0;

                for (;;)
                {
                    int alt31=2;
            	switch ( LA(1) )
            	{
            	case LPAREN_TOK:
            		{
            			alt31=1;
            		}
            	    break;

            	}

            	switch (alt31)
            	{
            	    case 1:
            	        // ../../../../src/parser/smt2/Smt2.g:1514:16: LPAREN_TOK datatypeDef[isCo, dts, sorts] RPAREN_TOK
            	        {
            	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand2722);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruledatatypes_2_5_DefCommandEx;
            	            }


            	            FOLLOWPUSH(FOLLOW_datatypeDef_in_datatypes_2_5_DefCommand2724);
            	            datatypeDef(ctx, isCo, dts, sorts);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruledatatypes_2_5_DefCommandEx;
            	            }


            	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand2727);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruledatatypes_2_5_DefCommandEx;
            	            }


            	        }
            	        break;

            	    default:

            		if ( cnt31 >= 1 )
            		{
            		    goto loop31;
            		}
            		/* mismatchedSetEx()
            		 */
            		CONSTRUCTEX();
            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            		goto ruledatatypes_2_5_DefCommandEx;
            	}
            	cnt31++;
                }
                loop31: ;	/* Jump to here if this rule does not match */
            }

             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand2732);
            if  (HASEXCEPTION())
            {
                goto ruledatatypes_2_5_DefCommandEx;
            }


            {
                 PARSER_STATE->popScope();
                    cmd->reset(new DatatypeDeclarationCommand(PARSER_STATE->mkMutualDatatypeTypes(dts)));
                  
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruledatatypes_2_5_DefCommandEx; /* Prevent compiler warnings */
    ruledatatypes_2_5_DefCommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end datatypes_2_5_DefCommand */

/**
 * $ANTLR start datatypeDefCommand
 * ../../../../src/parser/smt2/Smt2.g:1520:1: datatypeDefCommand[bool isCo, CVC4::PtrCloser<CVC4::Command>* cmd] : symbol[name,CHECK_UNDECLARED,SYM_SORT] LPAREN_TOK ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ RPAREN_TOK ;
 */
static void
datatypeDefCommand(pSmt2Parser ctx, bool isCo, CVC4::PtrCloser<CVC4::Command>* cmd)
{

      std::vector<CVC4::Datatype> dts;
      std::string name;

    /* Initialize rule variables
     */

    {
        // ../../../../src/parser/smt2/Smt2.g:1525:2: ( symbol[name,CHECK_UNDECLARED,SYM_SORT] LPAREN_TOK ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ RPAREN_TOK )
        // ../../../../src/parser/smt2/Smt2.g:1525:4: symbol[name,CHECK_UNDECLARED,SYM_SORT] LPAREN_TOK ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ RPAREN_TOK
        {
            {
                 PARSER_STATE->checkThatLogicIsSet(); 
            }


            FOLLOWPUSH(FOLLOW_symbol_in_datatypeDefCommand2761);
            symbol(ctx, name, CHECK_UNDECLARED, SYM_SORT);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruledatatypeDefCommandEx;
            }


             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypeDefCommand2764);
            if  (HASEXCEPTION())
            {
                goto ruledatatypeDefCommandEx;
            }


            {
                 std::vector<Type> params;
                   dts.push_back(Datatype(name,params,isCo));
                 
            }


            // ../../../../src/parser/smt2/Smt2.g:1530:2: ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+
            {
                int cnt32=0;

                for (;;)
                {
                    int alt32=2;
            	switch ( LA(1) )
            	{
            	case LPAREN_TOK:
            		{
            			alt32=1;
            		}
            	    break;

            	}

            	switch (alt32)
            	{
            	    case 1:
            	        // ../../../../src/parser/smt2/Smt2.g:1530:4: LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK
            	        {
            	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypeDefCommand2772);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruledatatypeDefCommandEx;
            	            }


            	            FOLLOWPUSH(FOLLOW_constructorDef_in_datatypeDefCommand2774);
            	            constructorDef(ctx, dts.back());

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruledatatypeDefCommandEx;
            	            }


            	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypeDefCommand2777);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruledatatypeDefCommandEx;
            	            }


            	        }
            	        break;

            	    default:

            		if ( cnt32 >= 1 )
            		{
            		    goto loop32;
            		}
            		/* mismatchedSetEx()
            		 */
            		CONSTRUCTEX();
            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            		goto ruledatatypeDefCommandEx;
            	}
            	cnt32++;
                }
                loop32: ;	/* Jump to here if this rule does not match */
            }

             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypeDefCommand2783);
            if  (HASEXCEPTION())
            {
                goto ruledatatypeDefCommandEx;
            }


            {
                 cmd->reset(new DatatypeDeclarationCommand(PARSER_STATE->mkMutualDatatypeTypes(dts))); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruledatatypeDefCommandEx; /* Prevent compiler warnings */
    ruledatatypeDefCommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end datatypeDefCommand */

/**
 * $ANTLR start datatypesDefCommand
 * ../../../../src/parser/smt2/Smt2.g:1535:1: datatypesDefCommand[bool isCo, CVC4::PtrCloser<CVC4::Command>* cmd] : LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] n= INTEGER_LITERAL RPAREN_TOK )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK ( PAR_TOK LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ RPAREN_TOK | ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ ) RPAREN_TOK )+ RPAREN_TOK ;
 */
static void
datatypesDefCommand(pSmt2Parser ctx, bool isCo, CVC4::PtrCloser<CVC4::Command>* cmd)
{

      std::vector<CVC4::Datatype> dts;
      std::string name;
      std::vector<std::string> dnames;
      std::vector<unsigned> arities;
      std::vector<Type> params;

    pANTLR3_COMMON_TOKEN    n;

    /* Initialize rule variables
     */

    n       = NULL;

    {
        // ../../../../src/parser/smt2/Smt2.g:1543:3: ( LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] n= INTEGER_LITERAL RPAREN_TOK )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK ( PAR_TOK LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ RPAREN_TOK | ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ ) RPAREN_TOK )+ RPAREN_TOK )
        // ../../../../src/parser/smt2/Smt2.g:1543:5: LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] n= INTEGER_LITERAL RPAREN_TOK )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK ( PAR_TOK LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ RPAREN_TOK | ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ ) RPAREN_TOK )+ RPAREN_TOK
        {
            {
                 PARSER_STATE->checkThatLogicIsSet(); PARSER_STATE->pushScope(true); 
            }


             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypesDefCommand2810);
            if  (HASEXCEPTION())
            {
                goto ruledatatypesDefCommandEx;
            }


            // ../../../../src/parser/smt2/Smt2.g:1545:3: ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] n= INTEGER_LITERAL RPAREN_TOK )*

            for (;;)
            {
                int alt33=2;
                switch ( LA(1) )
                {
                case LPAREN_TOK:
                	{
                		alt33=1;
                	}
                    break;

                }

                switch (alt33)
                {
            	case 1:
            	    // ../../../../src/parser/smt2/Smt2.g:1545:5: LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] n= INTEGER_LITERAL RPAREN_TOK
            	    {
            	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypesDefCommand2818);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledatatypesDefCommandEx;
            	        }


            	        FOLLOWPUSH(FOLLOW_symbol_in_datatypesDefCommand2820);
            	        symbol(ctx, name, CHECK_UNDECLARED, SYM_SORT);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledatatypesDefCommandEx;
            	        }


            	        n = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_datatypesDefCommand2825);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledatatypesDefCommandEx;
            	        }


            	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypesDefCommand2827);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledatatypesDefCommandEx;
            	        }


            	        {
            	             unsigned arity = AntlrInput::tokenToUnsigned(n);
            	                  //Type type;
            	                  //if(arity == 0) {
            	                  //  type = PARSER_STATE->mkSort(name);
            	                  //} else {
            	                  //  type = PARSER_STATE->mkSortConstructor(name, arity);
            	                  //}
            	                  //types.push_back(type);
            	                  Debug("parser-dt") << "Datatype : " << name << ", arity = " << arity << std::endl;
            	                  dnames.push_back(name);
            	                  arities.push_back( arity );
            	                
            	        }


            	    }
            	    break;

            	default:
            	    goto loop33;	/* break out of the loop */
            	    break;
                }
            }
            loop33: ; /* Jump out to here if this rule does not match */


             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypesDefCommand2842);
            if  (HASEXCEPTION())
            {
                goto ruledatatypesDefCommandEx;
            }


             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypesDefCommand2847);
            if  (HASEXCEPTION())
            {
                goto ruledatatypesDefCommandEx;
            }


            // ../../../../src/parser/smt2/Smt2.g:1561:3: ( LPAREN_TOK ( PAR_TOK LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ RPAREN_TOK | ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ ) RPAREN_TOK )+
            {
                int cnt38=0;

                for (;;)
                {
                    int alt38=2;
            	switch ( LA(1) )
            	{
            	case LPAREN_TOK:
            		{
            			alt38=1;
            		}
            	    break;

            	}

            	switch (alt38)
            	{
            	    case 1:
            	        // ../../../../src/parser/smt2/Smt2.g:1561:5: LPAREN_TOK ( PAR_TOK LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ RPAREN_TOK | ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ ) RPAREN_TOK
            	        {
            	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypesDefCommand2854);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruledatatypesDefCommandEx;
            	            }


            	            {
            	                 
            	                      params.clear(); 
            	                      Debug("parser-dt") << "Processing datatype #" << dts.size() << std::endl;
            	                      if( dts.size()>=dnames.size() ){
            	                        PARSER_STATE->parseError("Too many datatypes defined in this block.");
            	                      }
            	                    
            	            }


            	            // ../../../../src/parser/smt2/Smt2.g:1568:5: ( PAR_TOK LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ RPAREN_TOK | ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ )
            	            {
            	                int alt37=2;
            	                switch ( LA(1) )
            	                {
            	                case PAR_TOK:
            	                	{
            	                		alt37=1;
            	                	}
            	                    break;
            	                case LPAREN_TOK:
            	                	{
            	                		alt37=2;
            	                	}
            	                    break;

            	                default:
            	                    CONSTRUCTEX();
            	                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	                    EXCEPTION->message      = (void *)"";
            	                    EXCEPTION->decisionNum  = 37;
            	                    EXCEPTION->state        = 0;


            	                    goto ruledatatypesDefCommandEx;

            	                }

            	                switch (alt37)
            	                {
            	            	case 1:
            	            	    // ../../../../src/parser/smt2/Smt2.g:1568:7: PAR_TOK LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ RPAREN_TOK
            	            	    {
            	            	         MATCHT(PAR_TOK, &FOLLOW_PAR_TOK_in_datatypesDefCommand2864);
            	            	        if  (HASEXCEPTION())
            	            	        {
            	            	            goto ruledatatypesDefCommandEx;
            	            	        }


            	            	        {
            	            	             PARSER_STATE->pushScope(true); 
            	            	        }


            	            	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypesDefCommand2868);
            	            	        if  (HASEXCEPTION())
            	            	        {
            	            	            goto ruledatatypesDefCommandEx;
            	            	        }


            	            	        // ../../../../src/parser/smt2/Smt2.g:1569:7: ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )*

            	            	        for (;;)
            	            	        {
            	            	            int alt34=2;
            	            	            switch ( LA(1) )
            	            	            {
            	            	            case CHECK_SYNTH_TOK:
            	            	            case CONSTRAINT_TOK:
            	            	            case DECLARE_PRIMED_VAR_TOK:
            	            	            case DECLARE_VAR_TOK:
            	            	            case INV_CONSTRAINT_TOK:
            	            	            case QUOTED_SYMBOL:
            	            	            case SET_OPTIONS_TOK:
            	            	            case SIMPLE_SYMBOL:
            	            	            case SYNTH_FUN_TOK:
            	            	            case SYNTH_INV_TOK:
            	            	            case UNTERMINATED_QUOTED_SYMBOL:
            	            	            case 154:
            	            	            	{
            	            	            		alt34=1;
            	            	            	}
            	            	                break;

            	            	            }

            	            	            switch (alt34)
            	            	            {
            	            	        	case 1:
            	            	        	    // ../../../../src/parser/smt2/Smt2.g:1569:9: symbol[name,CHECK_UNDECLARED,SYM_SORT]
            	            	        	    {
            	            	        	        FOLLOWPUSH(FOLLOW_symbol_in_datatypesDefCommand2878);
            	            	        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_SORT);

            	            	        	        FOLLOWPOP();
            	            	        	        if  (HASEXCEPTION())
            	            	        	        {
            	            	        	            goto ruledatatypesDefCommandEx;
            	            	        	        }


            	            	        	        {
            	            	        	             params.push_back( PARSER_STATE->mkSort(name) ); 
            	            	        	        }


            	            	        	    }
            	            	        	    break;

            	            	        	default:
            	            	        	    goto loop34;	/* break out of the loop */
            	            	        	    break;
            	            	            }
            	            	        }
            	            	        loop34: ; /* Jump out to here if this rule does not match */


            	            	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypesDefCommand2906);
            	            	        if  (HASEXCEPTION())
            	            	        {
            	            	            goto ruledatatypesDefCommandEx;
            	            	        }


            	            	        {

            	            	                    if( params.size()!=arities[dts.size()] ){
            	            	                      PARSER_STATE->parseError("Wrong number of parameters for datatype.");
            	            	                    }
            	            	                    Debug("parser-dt") << params.size() << " parameters for " << dnames[dts.size()] << std::endl;
            	            	                    dts.push_back(Datatype(dnames[dts.size()],params,isCo));
            	            	                  
            	            	        }


            	            	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypesDefCommand2916);
            	            	        if  (HASEXCEPTION())
            	            	        {
            	            	            goto ruledatatypesDefCommandEx;
            	            	        }


            	            	        // ../../../../src/parser/smt2/Smt2.g:1580:7: ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+
            	            	        {
            	            	            int cnt35=0;

            	            	            for (;;)
            	            	            {
            	            	                int alt35=2;
            	            	        	switch ( LA(1) )
            	            	        	{
            	            	        	case LPAREN_TOK:
            	            	        		{
            	            	        			alt35=1;
            	            	        		}
            	            	        	    break;

            	            	        	}

            	            	        	switch (alt35)
            	            	        	{
            	            	        	    case 1:
            	            	        	        // ../../../../src/parser/smt2/Smt2.g:1580:9: LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK
            	            	        	        {
            	            	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypesDefCommand2926);
            	            	        	            if  (HASEXCEPTION())
            	            	        	            {
            	            	        	                goto ruledatatypesDefCommandEx;
            	            	        	            }


            	            	        	            FOLLOWPUSH(FOLLOW_constructorDef_in_datatypesDefCommand2928);
            	            	        	            constructorDef(ctx, dts.back());

            	            	        	            FOLLOWPOP();
            	            	        	            if  (HASEXCEPTION())
            	            	        	            {
            	            	        	                goto ruledatatypesDefCommandEx;
            	            	        	            }


            	            	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypesDefCommand2931);
            	            	        	            if  (HASEXCEPTION())
            	            	        	            {
            	            	        	                goto ruledatatypesDefCommandEx;
            	            	        	            }


            	            	        	        }
            	            	        	        break;

            	            	        	    default:

            	            	        		if ( cnt35 >= 1 )
            	            	        		{
            	            	        		    goto loop35;
            	            	        		}
            	            	        		/* mismatchedSetEx()
            	            	        		 */
            	            	        		CONSTRUCTEX();
            	            	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            	            	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            	            	        		goto ruledatatypesDefCommandEx;
            	            	        	}
            	            	        	cnt35++;
            	            	            }
            	            	            loop35: ;	/* Jump to here if this rule does not match */
            	            	        }

            	            	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypesDefCommand2942);
            	            	        if  (HASEXCEPTION())
            	            	        {
            	            	            goto ruledatatypesDefCommandEx;
            	            	        }


            	            	        {
            	            	             PARSER_STATE->popScope(); 
            	            	        }


            	            	    }
            	            	    break;
            	            	case 2:
            	            	    // ../../../../src/parser/smt2/Smt2.g:1582:7: ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+
            	            	    {
            	            	        {
            	            	             if( 0!=arities[dts.size()] ){
            	            	                      PARSER_STATE->parseError("No parameters given for datatype.");
            	            	                    }
            	            	                    Debug("parser-dt") << params.size() << " parameters for " << dnames[dts.size()] << std::endl;
            	            	                    dts.push_back(Datatype(dnames[dts.size()],params,isCo));
            	            	                  
            	            	        }


            	            	        // ../../../../src/parser/smt2/Smt2.g:1588:7: ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+
            	            	        {
            	            	            int cnt36=0;

            	            	            for (;;)
            	            	            {
            	            	                int alt36=2;
            	            	        	switch ( LA(1) )
            	            	        	{
            	            	        	case LPAREN_TOK:
            	            	        		{
            	            	        			alt36=1;
            	            	        		}
            	            	        	    break;

            	            	        	}

            	            	        	switch (alt36)
            	            	        	{
            	            	        	    case 1:
            	            	        	        // ../../../../src/parser/smt2/Smt2.g:1588:9: LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK
            	            	        	        {
            	            	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypesDefCommand2963);
            	            	        	            if  (HASEXCEPTION())
            	            	        	            {
            	            	        	                goto ruledatatypesDefCommandEx;
            	            	        	            }


            	            	        	            FOLLOWPUSH(FOLLOW_constructorDef_in_datatypesDefCommand2965);
            	            	        	            constructorDef(ctx, dts.back());

            	            	        	            FOLLOWPOP();
            	            	        	            if  (HASEXCEPTION())
            	            	        	            {
            	            	        	                goto ruledatatypesDefCommandEx;
            	            	        	            }


            	            	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypesDefCommand2968);
            	            	        	            if  (HASEXCEPTION())
            	            	        	            {
            	            	        	                goto ruledatatypesDefCommandEx;
            	            	        	            }


            	            	        	        }
            	            	        	        break;

            	            	        	    default:

            	            	        		if ( cnt36 >= 1 )
            	            	        		{
            	            	        		    goto loop36;
            	            	        		}
            	            	        		/* mismatchedSetEx()
            	            	        		 */
            	            	        		CONSTRUCTEX();
            	            	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            	            	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            	            	        		goto ruledatatypesDefCommandEx;
            	            	        	}
            	            	        	cnt36++;
            	            	            }
            	            	            loop36: ;	/* Jump to here if this rule does not match */
            	            	        }

            	            	    }
            	            	    break;

            	                }
            	            }

            	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypesDefCommand2983);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruledatatypesDefCommandEx;
            	            }


            	        }
            	        break;

            	    default:

            		if ( cnt38 >= 1 )
            		{
            		    goto loop38;
            		}
            		/* mismatchedSetEx()
            		 */
            		CONSTRUCTEX();
            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            		goto ruledatatypesDefCommandEx;
            	}
            	cnt38++;
                }
                loop38: ;	/* Jump to here if this rule does not match */
            }

             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypesDefCommand2994);
            if  (HASEXCEPTION())
            {
                goto ruledatatypesDefCommandEx;
            }


            {
                 PARSER_STATE->popScope();
                    cmd->reset(new DatatypeDeclarationCommand(PARSER_STATE->mkMutualDatatypeTypes(dts))); 
                  
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruledatatypesDefCommandEx; /* Prevent compiler warnings */
    ruledatatypesDefCommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end datatypesDefCommand */

/**
 * $ANTLR start rewriterulesCommand
 * ../../../../src/parser/smt2/Smt2.g:1598:1: rewriterulesCommand[CVC4::PtrCloser<CVC4::Command>* cmd] : ( REWRITE_RULE_TOK LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK LPAREN_TOK ( pattern[expr] )* RPAREN_TOK LPAREN_TOK ( termList[guards,expr] )? RPAREN_TOK term[head, expr2] term[body, expr2] | rewritePropaKind[kind] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK LPAREN_TOK ( pattern[expr] )* RPAREN_TOK LPAREN_TOK ( termList[guards,expr] )? RPAREN_TOK LPAREN_TOK ( termList[heads,expr] )? RPAREN_TOK term[body, expr2] );
 */
static void
rewriterulesCommand(pSmt2Parser ctx, CVC4::PtrCloser<CVC4::Command>* cmd)
{

      std::vector<std::pair<std::string, Type> > sortedVarNames;
      std::vector<Expr> args, guards, heads, triggers;
      Expr head, body, expr, expr2, bvl;
      Kind kind;

    /* Initialize rule variables
     */

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:1605:3: ( REWRITE_RULE_TOK LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK LPAREN_TOK ( pattern[expr] )* RPAREN_TOK LPAREN_TOK ( termList[guards,expr] )? RPAREN_TOK term[head, expr2] term[body, expr2] | rewritePropaKind[kind] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK LPAREN_TOK ( pattern[expr] )* RPAREN_TOK LPAREN_TOK ( termList[guards,expr] )? RPAREN_TOK LPAREN_TOK ( termList[heads,expr] )? RPAREN_TOK term[body, expr2] )

            ANTLR3_UINT32 alt44;

            alt44=2;

            switch ( LA(1) )
            {
            case REWRITE_RULE_TOK:
            	{
            		alt44=1;
            	}
                break;
            case PROPAGATION_RULE_TOK:
            case REDUCTION_RULE_TOK:
            	{
            		alt44=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 44;
                EXCEPTION->state        = 0;


                goto rulerewriterulesCommandEx;

            }

            switch (alt44)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:1606:5: REWRITE_RULE_TOK LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK LPAREN_TOK ( pattern[expr] )* RPAREN_TOK LPAREN_TOK ( termList[guards,expr] )? RPAREN_TOK term[head, expr2] term[body, expr2]
        	    {
        	         MATCHT(REWRITE_RULE_TOK, &FOLLOW_REWRITE_RULE_TOK_in_rewriterulesCommand3023);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_rewriterulesCommand3029);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortedVarList_in_rewriterulesCommand3031);
        	        sortedVarList(ctx, sortedVarNames);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_rewriterulesCommand3034);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	        {

        	                  kind = CVC4::kind::RR_REWRITE;
        	                  PARSER_STATE->pushScope(true);
        	                  for(std::vector<std::pair<std::string, CVC4::Type> >::const_iterator i =
        	                        sortedVarNames.begin(), iend = sortedVarNames.end();
        	                      i != iend;
        	                      ++i) {
        	                    args.push_back(PARSER_STATE->mkBoundVar((*i).first, (*i).second));
        	                  }
        	                  bvl = MK_EXPR(kind::BOUND_VAR_LIST, args);
        	                
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_rewriterulesCommand3046);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:1619:16: ( pattern[expr] )*

        	        for (;;)
        	        {
        	            int alt39=2;
        	            switch ( LA(1) )
        	            {
        	            case LPAREN_TOK:
        	            	{
        	            		alt39=1;
        	            	}
        	                break;

        	            }

        	            switch (alt39)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:1619:18: pattern[expr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_pattern_in_rewriterulesCommand3050);
        	        	        pattern(ctx, expr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerewriterulesCommandEx;
        	        	        }


        	        	        {
        	        	             triggers.push_back( expr ); 
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop39;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop39: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_rewriterulesCommand3058);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_rewriterulesCommand3064);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:1620:16: ( termList[guards,expr] )?
        	        {
        	            int alt40=2;
        	            switch ( LA(1) )
        	            {
        	                case BINARY_LITERAL:
        	                case CHECK_SYNTH_TOK:
        	                case CONSTRAINT_TOK:
        	                case DECIMAL_LITERAL:
        	                case DECLARE_PRIMED_VAR_TOK:
        	                case DECLARE_VAR_TOK:
        	                case EMPTYSET_TOK:
        	                case FP_RNA_FULL_TOK:
        	                case FP_RNA_TOK:
        	                case FP_RNE_FULL_TOK:
        	                case FP_RNE_TOK:
        	                case FP_RTN_FULL_TOK:
        	                case FP_RTN_TOK:
        	                case FP_RTP_FULL_TOK:
        	                case FP_RTP_TOK:
        	                case FP_RTZ_FULL_TOK:
        	                case FP_RTZ_TOK:
        	                case HEX_LITERAL:
        	                case INTEGER_LITERAL:
        	                case INV_CONSTRAINT_TOK:
        	                case LPAREN_TOK:
        	                case NILREF_TOK:
        	                case QUOTED_SYMBOL:
        	                case REALLCHAR_TOK:
        	                case RENOSTR_TOK:
        	                case SET_OPTIONS_TOK:
        	                case SIMPLE_SYMBOL:
        	                case STRING_LITERAL_2_0:
        	                case STRING_LITERAL_2_5:
        	                case SYNTH_FUN_TOK:
        	                case SYNTH_INV_TOK:
        	                case UNIVSET_TOK:
        	                case UNTERMINATED_QUOTED_SYMBOL:
        	                case 154:
        	                	{
        	                		alt40=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt40)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:1620:17: termList[guards,expr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_termList_in_rewriterulesCommand3067);
        	        	        termList(ctx, guards, expr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerewriterulesCommandEx;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_rewriterulesCommand3072);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_rewriterulesCommand3078);
        	        term(ctx, head, expr2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_rewriterulesCommand3081);
        	        term(ctx, body, expr2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	        {

        	                  args.clear();
        	                  args.push_back(head);
        	                  args.push_back(body);
        	                  /* triggers */
        	                  if( !triggers.empty() ){
        	                    expr2 = MK_EXPR(kind::INST_PATTERN_LIST, triggers);
        	                    args.push_back(expr2);
        	                  };
        	                  expr = MK_EXPR(kind, args);
        	                  args.clear();
        	                  args.push_back(bvl);
        	                  /* guards */
        	                  switch( guards.size() ){
        	                  case 0:
        	                    args.push_back(MK_CONST(bool(true))); break;
        	                  case 1:
        	                    args.push_back(guards[0]); break;
        	                  default:
        	                    expr2 = MK_EXPR(kind::AND, guards);
        	                    args.push_back(expr2); break;
        	                  };
        	                  args.push_back(expr);
        	                  expr = MK_EXPR(CVC4::kind::REWRITE_RULE, args);
        	                  cmd->reset(new AssertCommand(expr, false)); 
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:1648:5: rewritePropaKind[kind] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK LPAREN_TOK ( pattern[expr] )* RPAREN_TOK LPAREN_TOK ( termList[guards,expr] )? RPAREN_TOK LPAREN_TOK ( termList[heads,expr] )? RPAREN_TOK term[body, expr2]
        	    {
        	        FOLLOWPUSH(FOLLOW_rewritePropaKind_in_rewriterulesCommand3100);
        	        rewritePropaKind(ctx, kind);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_rewriterulesCommand3107);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortedVarList_in_rewriterulesCommand3109);
        	        sortedVarList(ctx, sortedVarNames);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_rewriterulesCommand3112);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	        {

        	                  PARSER_STATE->pushScope(true);
        	                  for(std::vector<std::pair<std::string, CVC4::Type> >::const_iterator i =
        	                        sortedVarNames.begin(), iend = sortedVarNames.end();
        	                      i != iend;
        	                      ++i) {
        	                    args.push_back(PARSER_STATE->mkBoundVar((*i).first, (*i).second));
        	                  }
        	                  bvl = MK_EXPR(kind::BOUND_VAR_LIST, args);
        	                
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_rewriterulesCommand3124);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:1660:16: ( pattern[expr] )*

        	        for (;;)
        	        {
        	            int alt41=2;
        	            switch ( LA(1) )
        	            {
        	            case LPAREN_TOK:
        	            	{
        	            		alt41=1;
        	            	}
        	                break;

        	            }

        	            switch (alt41)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:1660:18: pattern[expr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_pattern_in_rewriterulesCommand3128);
        	        	        pattern(ctx, expr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerewriterulesCommandEx;
        	        	        }


        	        	        {
        	        	             triggers.push_back( expr ); 
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop41;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop41: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_rewriterulesCommand3136);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_rewriterulesCommand3142);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:1661:16: ( termList[guards,expr] )?
        	        {
        	            int alt42=2;
        	            switch ( LA(1) )
        	            {
        	                case BINARY_LITERAL:
        	                case CHECK_SYNTH_TOK:
        	                case CONSTRAINT_TOK:
        	                case DECIMAL_LITERAL:
        	                case DECLARE_PRIMED_VAR_TOK:
        	                case DECLARE_VAR_TOK:
        	                case EMPTYSET_TOK:
        	                case FP_RNA_FULL_TOK:
        	                case FP_RNA_TOK:
        	                case FP_RNE_FULL_TOK:
        	                case FP_RNE_TOK:
        	                case FP_RTN_FULL_TOK:
        	                case FP_RTN_TOK:
        	                case FP_RTP_FULL_TOK:
        	                case FP_RTP_TOK:
        	                case FP_RTZ_FULL_TOK:
        	                case FP_RTZ_TOK:
        	                case HEX_LITERAL:
        	                case INTEGER_LITERAL:
        	                case INV_CONSTRAINT_TOK:
        	                case LPAREN_TOK:
        	                case NILREF_TOK:
        	                case QUOTED_SYMBOL:
        	                case REALLCHAR_TOK:
        	                case RENOSTR_TOK:
        	                case SET_OPTIONS_TOK:
        	                case SIMPLE_SYMBOL:
        	                case STRING_LITERAL_2_0:
        	                case STRING_LITERAL_2_5:
        	                case SYNTH_FUN_TOK:
        	                case SYNTH_INV_TOK:
        	                case UNIVSET_TOK:
        	                case UNTERMINATED_QUOTED_SYMBOL:
        	                case 154:
        	                	{
        	                		alt42=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt42)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:1661:17: termList[guards,expr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_termList_in_rewriterulesCommand3145);
        	        	        termList(ctx, guards, expr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerewriterulesCommandEx;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_rewriterulesCommand3150);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_rewriterulesCommand3156);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:1662:16: ( termList[heads,expr] )?
        	        {
        	            int alt43=2;
        	            switch ( LA(1) )
        	            {
        	                case BINARY_LITERAL:
        	                case CHECK_SYNTH_TOK:
        	                case CONSTRAINT_TOK:
        	                case DECIMAL_LITERAL:
        	                case DECLARE_PRIMED_VAR_TOK:
        	                case DECLARE_VAR_TOK:
        	                case EMPTYSET_TOK:
        	                case FP_RNA_FULL_TOK:
        	                case FP_RNA_TOK:
        	                case FP_RNE_FULL_TOK:
        	                case FP_RNE_TOK:
        	                case FP_RTN_FULL_TOK:
        	                case FP_RTN_TOK:
        	                case FP_RTP_FULL_TOK:
        	                case FP_RTP_TOK:
        	                case FP_RTZ_FULL_TOK:
        	                case FP_RTZ_TOK:
        	                case HEX_LITERAL:
        	                case INTEGER_LITERAL:
        	                case INV_CONSTRAINT_TOK:
        	                case LPAREN_TOK:
        	                case NILREF_TOK:
        	                case QUOTED_SYMBOL:
        	                case REALLCHAR_TOK:
        	                case RENOSTR_TOK:
        	                case SET_OPTIONS_TOK:
        	                case SIMPLE_SYMBOL:
        	                case STRING_LITERAL_2_0:
        	                case STRING_LITERAL_2_5:
        	                case SYNTH_FUN_TOK:
        	                case SYNTH_INV_TOK:
        	                case UNIVSET_TOK:
        	                case UNTERMINATED_QUOTED_SYMBOL:
        	                case 154:
        	                	{
        	                		alt43=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt43)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:1662:17: termList[heads,expr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_termList_in_rewriterulesCommand3159);
        	        	        termList(ctx, heads, expr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerewriterulesCommandEx;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_rewriterulesCommand3164);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_rewriterulesCommand3170);
        	        term(ctx, body, expr2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	        {

        	                  args.clear();
        	                  /* heads */
        	                  switch( heads.size() ){
        	                  case 0:
        	                    args.push_back(MK_CONST(bool(true))); break;
        	                  case 1:
        	                    args.push_back(heads[0]); break;
        	                  default:
        	                    expr2 = MK_EXPR(kind::AND, heads);
        	                    args.push_back(expr2); break;
        	                  };
        	                  args.push_back(body);
        	                  /* triggers */
        	                  if( !triggers.empty() ){
        	                    expr2 = MK_EXPR(kind::INST_PATTERN_LIST, triggers);
        	                    args.push_back(expr2);
        	                  };
        	                  expr = MK_EXPR(kind, args);
        	                  args.clear();
        	                  args.push_back(bvl);
        	                  /* guards */
        	                  switch( guards.size() ){
        	                  case 0:
        	                    args.push_back(MK_CONST(bool(true))); break;
        	                  case 1:
        	                    args.push_back(guards[0]); break;
        	                  default:
        	                    expr2 = MK_EXPR(kind::AND, guards);
        	                    args.push_back(expr2); break;
        	                  };
        	                  args.push_back(expr);
        	                  expr = MK_EXPR(CVC4::kind::REWRITE_RULE, args);
        	                  cmd->reset(new AssertCommand(expr, false));
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulerewriterulesCommandEx; /* Prevent compiler warnings */
    rulerewriterulesCommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end rewriterulesCommand */

/**
 * $ANTLR start rewritePropaKind
 * ../../../../src/parser/smt2/Smt2.g:1701:1: rewritePropaKind[CVC4::Kind& kind] : ( REDUCTION_RULE_TOK | PROPAGATION_RULE_TOK );
 */
static void
rewritePropaKind(pSmt2Parser ctx, CVC4::Kind& kind)
{
    /* Initialize rule variables
     */

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:1702:3: ( REDUCTION_RULE_TOK | PROPAGATION_RULE_TOK )

            ANTLR3_UINT32 alt45;

            alt45=2;

            switch ( LA(1) )
            {
            case REDUCTION_RULE_TOK:
            	{
            		alt45=1;
            	}
                break;
            case PROPAGATION_RULE_TOK:
            	{
            		alt45=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 45;
                EXCEPTION->state        = 0;


                goto rulerewritePropaKindEx;

            }

            switch (alt45)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:1702:5: REDUCTION_RULE_TOK
        	    {
        	         MATCHT(REDUCTION_RULE_TOK, &FOLLOW_REDUCTION_RULE_TOK_in_rewritePropaKind3191);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewritePropaKindEx;
        	        }


        	        {
        	             kind= CVC4::kind::RR_REDUCTION; 
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:1703:5: PROPAGATION_RULE_TOK
        	    {
        	         MATCHT(PROPAGATION_RULE_TOK, &FOLLOW_PROPAGATION_RULE_TOK_in_rewritePropaKind3202);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewritePropaKindEx;
        	        }


        	        {
        	             kind= CVC4::kind::RR_DEDUCTION; 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulerewritePropaKindEx; /* Prevent compiler warnings */
    rulerewritePropaKindEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end rewritePropaKind */

/**
 * $ANTLR start pattern
 * ../../../../src/parser/smt2/Smt2.g:1706:1: pattern[CVC4::Expr& expr] : LPAREN_TOK termList[patexpr,expr] RPAREN_TOK ;
 */
static void
pattern(pSmt2Parser ctx, CVC4::Expr& expr)
{

      std::vector<Expr> patexpr;

    /* Initialize rule variables
     */

    {
        // ../../../../src/parser/smt2/Smt2.g:1710:3: ( LPAREN_TOK termList[patexpr,expr] RPAREN_TOK )
        // ../../../../src/parser/smt2/Smt2.g:1710:5: LPAREN_TOK termList[patexpr,expr] RPAREN_TOK
        {
             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_pattern3224);
            if  (HASEXCEPTION())
            {
                goto rulepatternEx;
            }


            FOLLOWPUSH(FOLLOW_termList_in_pattern3226);
            termList(ctx, patexpr, expr);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulepatternEx;
            }


             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_pattern3229);
            if  (HASEXCEPTION())
            {
                goto rulepatternEx;
            }


            {

                      expr = MK_EXPR(kind::INST_PATTERN, patexpr);
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulepatternEx; /* Prevent compiler warnings */
    rulepatternEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end pattern */

/**
 * $ANTLR start simpleSymbolicExprNoKeyword
 * ../../../../src/parser/smt2/Smt2.g:1716:1: simpleSymbolicExprNoKeyword[CVC4::SExpr& sexpr] : ( INTEGER_LITERAL | DECIMAL_LITERAL | HEX_LITERAL | BINARY_LITERAL | str[s,false] | symbol[s,CHECK_NONE,SYM_SORT] |tok= ( ASSERT_TOK | CHECKSAT_TOK | DECLARE_FUN_TOK | DECLARE_SORT_TOK | DEFINE_FUN_TOK | DEFINE_FUN_REC_TOK | DEFINE_FUNS_REC_TOK | DEFINE_SORT_TOK | GET_VALUE_TOK | GET_ASSIGNMENT_TOK | GET_ASSERTIONS_TOK | GET_PROOF_TOK | GET_UNSAT_CORE_TOK | EXIT_TOK | RESET_TOK | RESET_ASSERTIONS_TOK | SET_LOGIC_TOK | SET_INFO_TOK | GET_INFO_TOK | SET_OPTION_TOK | GET_OPTION_TOK | PUSH_TOK | POP_TOK | DECLARE_DATATYPES_TOK | GET_MODEL_TOK | ECHO_TOK | REWRITE_RULE_TOK | REDUCTION_RULE_TOK | PROPAGATION_RULE_TOK | SIMPLIFY_TOK ) | builtinOp[k] );
 */
static void
simpleSymbolicExprNoKeyword(pSmt2Parser ctx, CVC4::SExpr& sexpr)
{

      CVC4::Kind k;
      std::string s;
      std::vector<unsigned int> s_vec;

    pANTLR3_COMMON_TOKEN    tok;
    pANTLR3_COMMON_TOKEN    INTEGER_LITERAL8;
    pANTLR3_COMMON_TOKEN    DECIMAL_LITERAL9;
    pANTLR3_COMMON_TOKEN    HEX_LITERAL10;
    pANTLR3_COMMON_TOKEN    BINARY_LITERAL11;

    /* Initialize rule variables
     */

    tok       = NULL;
    INTEGER_LITERAL8       = NULL;
    DECIMAL_LITERAL9       = NULL;
    HEX_LITERAL10       = NULL;
    BINARY_LITERAL11       = NULL;

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:1722:3: ( INTEGER_LITERAL | DECIMAL_LITERAL | HEX_LITERAL | BINARY_LITERAL | str[s,false] | symbol[s,CHECK_NONE,SYM_SORT] |tok= ( ASSERT_TOK | CHECKSAT_TOK | DECLARE_FUN_TOK | DECLARE_SORT_TOK | DEFINE_FUN_TOK | DEFINE_FUN_REC_TOK | DEFINE_FUNS_REC_TOK | DEFINE_SORT_TOK | GET_VALUE_TOK | GET_ASSIGNMENT_TOK | GET_ASSERTIONS_TOK | GET_PROOF_TOK | GET_UNSAT_CORE_TOK | EXIT_TOK | RESET_TOK | RESET_ASSERTIONS_TOK | SET_LOGIC_TOK | SET_INFO_TOK | GET_INFO_TOK | SET_OPTION_TOK | GET_OPTION_TOK | PUSH_TOK | POP_TOK | DECLARE_DATATYPES_TOK | GET_MODEL_TOK | ECHO_TOK | REWRITE_RULE_TOK | REDUCTION_RULE_TOK | PROPAGATION_RULE_TOK | SIMPLIFY_TOK ) | builtinOp[k] )

            ANTLR3_UINT32 alt46;

            alt46=8;

            switch ( LA(1) )
            {
            case INTEGER_LITERAL:
            	{
            		alt46=1;
            	}
                break;
            case DECIMAL_LITERAL:
            	{
            		alt46=2;
            	}
                break;
            case HEX_LITERAL:
            	{
            		alt46=3;
            	}
                break;
            case BINARY_LITERAL:
            	{
            		alt46=4;
            	}
                break;
            case STRING_LITERAL_2_0:
            case STRING_LITERAL_2_5:
            	{
            		alt46=5;
            	}
                break;
            case CHECK_SYNTH_TOK:
            case CONSTRAINT_TOK:
            case DECLARE_PRIMED_VAR_TOK:
            case DECLARE_VAR_TOK:
            case INV_CONSTRAINT_TOK:
            case QUOTED_SYMBOL:
            case SET_OPTIONS_TOK:
            case SIMPLE_SYMBOL:
            case SYNTH_FUN_TOK:
            case SYNTH_INV_TOK:
            case UNTERMINATED_QUOTED_SYMBOL:
            case 154:
            	{
            		alt46=6;
            	}
                break;
            case ASSERT_TOK:
            case CHECKSAT_TOK:
            case DECLARE_DATATYPES_TOK:
            case DECLARE_FUN_TOK:
            case DECLARE_SORT_TOK:
            case DEFINE_FUNS_REC_TOK:
            case DEFINE_FUN_REC_TOK:
            case DEFINE_FUN_TOK:
            case DEFINE_SORT_TOK:
            case ECHO_TOK:
            case EXIT_TOK:
            case GET_ASSERTIONS_TOK:
            case GET_ASSIGNMENT_TOK:
            case GET_INFO_TOK:
            case GET_MODEL_TOK:
            case GET_OPTION_TOK:
            case GET_PROOF_TOK:
            case GET_UNSAT_CORE_TOK:
            case GET_VALUE_TOK:
            case POP_TOK:
            case PROPAGATION_RULE_TOK:
            case PUSH_TOK:
            case REDUCTION_RULE_TOK:
            case RESET_ASSERTIONS_TOK:
            case RESET_TOK:
            case REWRITE_RULE_TOK:
            case SET_INFO_TOK:
            case SET_LOGIC_TOK:
            case SET_OPTION_TOK:
            case SIMPLIFY_TOK:
            	{
            		alt46=7;
            	}
                break;
            case AND_TOK:
            case BV2NAT_TOK:
            case DISTINCT_TOK:
            case DIV_TOK:
            case DTSIZE_TOK:
            case EQUAL_TOK:
            case FMFCARDVAL_TOK:
            case FMFCARD_TOK:
            case GREATER_THAN_EQUAL_TOK:
            case GREATER_THAN_TOK:
            case IMPLIES_TOK:
            case INST_CLOSURE_TOK:
            case ITE_TOK:
            case LESS_THAN_EQUAL_TOK:
            case LESS_THAN_TOK:
            case MINUS_TOK:
            case NOT_TOK:
            case OR_TOK:
            case PLUS_TOK:
            case STAR_TOK:
            case XOR_TOK:
            	{
            		alt46=8;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 46;
                EXCEPTION->state        = 0;


                goto rulesimpleSymbolicExprNoKeywordEx;

            }

            switch (alt46)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:1722:5: INTEGER_LITERAL
        	    {
        	        INTEGER_LITERAL8 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExprNoKeyword3254);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprNoKeywordEx;
        	        }


        	        {
        	             sexpr = SExpr(Integer(AntlrInput::tokenText(INTEGER_LITERAL8))); 
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:1724:5: DECIMAL_LITERAL
        	    {
        	        DECIMAL_LITERAL9 = (pANTLR3_COMMON_TOKEN) MATCHT(DECIMAL_LITERAL, &FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExprNoKeyword3266);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprNoKeywordEx;
        	        }


        	        {
        	             sexpr = SExpr(AntlrInput::tokenToRational(DECIMAL_LITERAL9)); 
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/smt2/Smt2.g:1726:5: HEX_LITERAL
        	    {
        	        HEX_LITERAL10 = (pANTLR3_COMMON_TOKEN) MATCHT(HEX_LITERAL, &FOLLOW_HEX_LITERAL_in_simpleSymbolicExprNoKeyword3278);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprNoKeywordEx;
        	        }


        	        {
        	             assert( AntlrInput::tokenText(HEX_LITERAL10).find("#x") == 0 );
        	                  std::string hexString = AntlrInput::tokenTextSubstr(HEX_LITERAL10, 2);
        	                  sexpr = SExpr(Integer(hexString, 16));
        	                
        	        }


        	    }
        	    break;
        	case 4:
        	    // ../../../../src/parser/smt2/Smt2.g:1731:5: BINARY_LITERAL
        	    {
        	        BINARY_LITERAL11 = (pANTLR3_COMMON_TOKEN) MATCHT(BINARY_LITERAL, &FOLLOW_BINARY_LITERAL_in_simpleSymbolicExprNoKeyword3290);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprNoKeywordEx;
        	        }


        	        {
        	             assert( AntlrInput::tokenText(BINARY_LITERAL11).find("#b") == 0 );
        	                  std::string binString = AntlrInput::tokenTextSubstr(BINARY_LITERAL11, 2);
        	                  sexpr = SExpr(Integer(binString, 2));
        	                
        	        }


        	    }
        	    break;
        	case 5:
        	    // ../../../../src/parser/smt2/Smt2.g:1736:5: str[s,false]
        	    {
        	        FOLLOWPUSH(FOLLOW_str_in_simpleSymbolicExprNoKeyword3302);
        	        str(ctx, s, false);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprNoKeywordEx;
        	        }


        	        {
        	             sexpr = SExpr(s); 
        	        }


        	    }
        	    break;
        	case 6:
        	    // ../../../../src/parser/smt2/Smt2.g:1745:5: symbol[s,CHECK_NONE,SYM_SORT]
        	    {
        	        FOLLOWPUSH(FOLLOW_symbol_in_simpleSymbolicExprNoKeyword3322);
        	        symbol(ctx, s, CHECK_NONE, SYM_SORT);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprNoKeywordEx;
        	        }


        	        {
        	             sexpr = SExpr(SExpr::Keyword(s)); 
        	        }


        	    }
        	    break;
        	case 7:
        	    // ../../../../src/parser/smt2/Smt2.g:1747:5: tok= ( ASSERT_TOK | CHECKSAT_TOK | DECLARE_FUN_TOK | DECLARE_SORT_TOK | DEFINE_FUN_TOK | DEFINE_FUN_REC_TOK | DEFINE_FUNS_REC_TOK | DEFINE_SORT_TOK | GET_VALUE_TOK | GET_ASSIGNMENT_TOK | GET_ASSERTIONS_TOK | GET_PROOF_TOK | GET_UNSAT_CORE_TOK | EXIT_TOK | RESET_TOK | RESET_ASSERTIONS_TOK | SET_LOGIC_TOK | SET_INFO_TOK | GET_INFO_TOK | SET_OPTION_TOK | GET_OPTION_TOK | PUSH_TOK | POP_TOK | DECLARE_DATATYPES_TOK | GET_MODEL_TOK | ECHO_TOK | REWRITE_RULE_TOK | REDUCTION_RULE_TOK | PROPAGATION_RULE_TOK | SIMPLIFY_TOK )
        	    {
        	        tok=(pANTLR3_COMMON_TOKEN)LT(1);

        	        if ( LA(1) == ASSERT_TOK || LA(1) == CHECKSAT_TOK || LA(1) == DECLARE_DATATYPES_TOK || LA(1) == DECLARE_FUN_TOK || LA(1) == DECLARE_SORT_TOK || ((LA(1) >= DEFINE_FUNS_REC_TOK) && (LA(1) <= DEFINE_SORT_TOK)) || LA(1) == ECHO_TOK || LA(1) == EXIT_TOK || ((LA(1) >= GET_ASSERTIONS_TOK) && (LA(1) <= GET_PROOF_TOK)) || ((LA(1) >= GET_UNSAT_CORE_TOK) && (LA(1) <= GET_VALUE_TOK)) || ((LA(1) >= POP_TOK) && (LA(1) <= PUSH_TOK)) || LA(1) == REDUCTION_RULE_TOK || ((LA(1) >= RESET_ASSERTIONS_TOK) && (LA(1) <= REWRITE_RULE_TOK)) || ((LA(1) >= SET_INFO_TOK) && (LA(1) <= SET_LOGIC_TOK)) || LA(1) == SET_OPTION_TOK || LA(1) == SIMPLIFY_TOK )
        	        {
        	            CONSUME();
        	            PERRORRECOVERY=ANTLR3_FALSE;
        	        }
        	        else
        	        {
        	            CONSTRUCTEX();
        	            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
        	            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
        	            EXCEPTION->expectingSet = NULL;

        	            goto rulesimpleSymbolicExprNoKeywordEx;
        	        }


        	        {
        	             sexpr = SExpr(SExpr::Keyword(AntlrInput::tokenText(tok))); 
        	        }


        	    }
        	    break;
        	case 8:
        	    // ../../../../src/parser/smt2/Smt2.g:1756:5: builtinOp[k]
        	    {
        	        FOLLOWPUSH(FOLLOW_builtinOp_in_simpleSymbolicExprNoKeyword3523);
        	        builtinOp(ctx, k);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprNoKeywordEx;
        	        }


        	        {
        	             std::stringstream ss;
        	                  ss << language::SetLanguage(CVC4::language::output::LANG_SMTLIB_V2_5)
        	                     << EXPR_MANAGER->mkConst(k);
        	                  sexpr = SExpr(ss.str());
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesimpleSymbolicExprNoKeywordEx; /* Prevent compiler warnings */
    rulesimpleSymbolicExprNoKeywordEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end simpleSymbolicExprNoKeyword */

/**
 * $ANTLR start keyword
 * ../../../../src/parser/smt2/Smt2.g:1764:1: keyword[std::string& s] : KEYWORD ;
 */
static void
keyword(pSmt2Parser ctx, std::string& s)
{
    pANTLR3_COMMON_TOKEN    KEYWORD12;

    /* Initialize rule variables
     */

    KEYWORD12       = NULL;

    {
        // ../../../../src/parser/smt2/Smt2.g:1765:3: ( KEYWORD )
        // ../../../../src/parser/smt2/Smt2.g:1765:5: KEYWORD
        {
            KEYWORD12 = (pANTLR3_COMMON_TOKEN) MATCHT(KEYWORD, &FOLLOW_KEYWORD_in_keyword3544);
            if  (HASEXCEPTION())
            {
                goto rulekeywordEx;
            }


            {
                 s = AntlrInput::tokenText(KEYWORD12); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulekeywordEx; /* Prevent compiler warnings */
    rulekeywordEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end keyword */

/**
 * $ANTLR start simpleSymbolicExpr
 * ../../../../src/parser/smt2/Smt2.g:1769:1: simpleSymbolicExpr[CVC4::SExpr& sexpr] : ( simpleSymbolicExprNoKeyword[sexpr] | KEYWORD );
 */
static void
simpleSymbolicExpr(pSmt2Parser ctx, CVC4::SExpr& sexpr)
{
    pANTLR3_COMMON_TOKEN    KEYWORD13;

    /* Initialize rule variables
     */

    KEYWORD13       = NULL;

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:1770:3: ( simpleSymbolicExprNoKeyword[sexpr] | KEYWORD )

            ANTLR3_UINT32 alt47;

            alt47=2;

            switch ( LA(1) )
            {
            case AND_TOK:
            case ASSERT_TOK:
            case BINARY_LITERAL:
            case BV2NAT_TOK:
            case CHECKSAT_TOK:
            case CHECK_SYNTH_TOK:
            case CONSTRAINT_TOK:
            case DECIMAL_LITERAL:
            case DECLARE_DATATYPES_TOK:
            case DECLARE_FUN_TOK:
            case DECLARE_PRIMED_VAR_TOK:
            case DECLARE_SORT_TOK:
            case DECLARE_VAR_TOK:
            case DEFINE_FUNS_REC_TOK:
            case DEFINE_FUN_REC_TOK:
            case DEFINE_FUN_TOK:
            case DEFINE_SORT_TOK:
            case DISTINCT_TOK:
            case DIV_TOK:
            case DTSIZE_TOK:
            case ECHO_TOK:
            case EQUAL_TOK:
            case EXIT_TOK:
            case FMFCARDVAL_TOK:
            case FMFCARD_TOK:
            case GET_ASSERTIONS_TOK:
            case GET_ASSIGNMENT_TOK:
            case GET_INFO_TOK:
            case GET_MODEL_TOK:
            case GET_OPTION_TOK:
            case GET_PROOF_TOK:
            case GET_UNSAT_CORE_TOK:
            case GET_VALUE_TOK:
            case GREATER_THAN_EQUAL_TOK:
            case GREATER_THAN_TOK:
            case HEX_LITERAL:
            case IMPLIES_TOK:
            case INST_CLOSURE_TOK:
            case INTEGER_LITERAL:
            case INV_CONSTRAINT_TOK:
            case ITE_TOK:
            case LESS_THAN_EQUAL_TOK:
            case LESS_THAN_TOK:
            case MINUS_TOK:
            case NOT_TOK:
            case OR_TOK:
            case PLUS_TOK:
            case POP_TOK:
            case PROPAGATION_RULE_TOK:
            case PUSH_TOK:
            case QUOTED_SYMBOL:
            case REDUCTION_RULE_TOK:
            case RESET_ASSERTIONS_TOK:
            case RESET_TOK:
            case REWRITE_RULE_TOK:
            case SET_INFO_TOK:
            case SET_LOGIC_TOK:
            case SET_OPTIONS_TOK:
            case SET_OPTION_TOK:
            case SIMPLE_SYMBOL:
            case SIMPLIFY_TOK:
            case STAR_TOK:
            case STRING_LITERAL_2_0:
            case STRING_LITERAL_2_5:
            case SYNTH_FUN_TOK:
            case SYNTH_INV_TOK:
            case UNTERMINATED_QUOTED_SYMBOL:
            case XOR_TOK:
            case 154:
            	{
            		alt47=1;
            	}
                break;
            case KEYWORD:
            	{
            		alt47=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 47;
                EXCEPTION->state        = 0;


                goto rulesimpleSymbolicExprEx;

            }

            switch (alt47)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:1770:5: simpleSymbolicExprNoKeyword[sexpr]
        	    {
        	        FOLLOWPUSH(FOLLOW_simpleSymbolicExprNoKeyword_in_simpleSymbolicExpr3564);
        	        simpleSymbolicExprNoKeyword(ctx, sexpr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:1771:5: KEYWORD
        	    {
        	        KEYWORD13 = (pANTLR3_COMMON_TOKEN) MATCHT(KEYWORD, &FOLLOW_KEYWORD_in_simpleSymbolicExpr3571);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }


        	        {
        	             sexpr = SExpr(AntlrInput::tokenText(KEYWORD13)); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesimpleSymbolicExprEx; /* Prevent compiler warnings */
    rulesimpleSymbolicExprEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end simpleSymbolicExpr */

/**
 * $ANTLR start symbolicExpr
 * ../../../../src/parser/smt2/Smt2.g:1775:1: symbolicExpr[CVC4::SExpr& sexpr] : ( simpleSymbolicExpr[sexpr] | LPAREN_TOK ( symbolicExpr[sexpr] )* RPAREN_TOK );
 */
static void
symbolicExpr(pSmt2Parser ctx, CVC4::SExpr& sexpr)
{

      std::vector<SExpr> children;

    /* Initialize rule variables
     */

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:1779:3: ( simpleSymbolicExpr[sexpr] | LPAREN_TOK ( symbolicExpr[sexpr] )* RPAREN_TOK )

            ANTLR3_UINT32 alt49;

            alt49=2;

            switch ( LA(1) )
            {
            case AND_TOK:
            case ASSERT_TOK:
            case BINARY_LITERAL:
            case BV2NAT_TOK:
            case CHECKSAT_TOK:
            case CHECK_SYNTH_TOK:
            case CONSTRAINT_TOK:
            case DECIMAL_LITERAL:
            case DECLARE_DATATYPES_TOK:
            case DECLARE_FUN_TOK:
            case DECLARE_PRIMED_VAR_TOK:
            case DECLARE_SORT_TOK:
            case DECLARE_VAR_TOK:
            case DEFINE_FUNS_REC_TOK:
            case DEFINE_FUN_REC_TOK:
            case DEFINE_FUN_TOK:
            case DEFINE_SORT_TOK:
            case DISTINCT_TOK:
            case DIV_TOK:
            case DTSIZE_TOK:
            case ECHO_TOK:
            case EQUAL_TOK:
            case EXIT_TOK:
            case FMFCARDVAL_TOK:
            case FMFCARD_TOK:
            case GET_ASSERTIONS_TOK:
            case GET_ASSIGNMENT_TOK:
            case GET_INFO_TOK:
            case GET_MODEL_TOK:
            case GET_OPTION_TOK:
            case GET_PROOF_TOK:
            case GET_UNSAT_CORE_TOK:
            case GET_VALUE_TOK:
            case GREATER_THAN_EQUAL_TOK:
            case GREATER_THAN_TOK:
            case HEX_LITERAL:
            case IMPLIES_TOK:
            case INST_CLOSURE_TOK:
            case INTEGER_LITERAL:
            case INV_CONSTRAINT_TOK:
            case ITE_TOK:
            case KEYWORD:
            case LESS_THAN_EQUAL_TOK:
            case LESS_THAN_TOK:
            case MINUS_TOK:
            case NOT_TOK:
            case OR_TOK:
            case PLUS_TOK:
            case POP_TOK:
            case PROPAGATION_RULE_TOK:
            case PUSH_TOK:
            case QUOTED_SYMBOL:
            case REDUCTION_RULE_TOK:
            case RESET_ASSERTIONS_TOK:
            case RESET_TOK:
            case REWRITE_RULE_TOK:
            case SET_INFO_TOK:
            case SET_LOGIC_TOK:
            case SET_OPTIONS_TOK:
            case SET_OPTION_TOK:
            case SIMPLE_SYMBOL:
            case SIMPLIFY_TOK:
            case STAR_TOK:
            case STRING_LITERAL_2_0:
            case STRING_LITERAL_2_5:
            case SYNTH_FUN_TOK:
            case SYNTH_INV_TOK:
            case UNTERMINATED_QUOTED_SYMBOL:
            case XOR_TOK:
            case 154:
            	{
            		alt49=1;
            	}
                break;
            case LPAREN_TOK:
            	{
            		alt49=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 49;
                EXCEPTION->state        = 0;


                goto rulesymbolicExprEx;

            }

            switch (alt49)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:1779:5: simpleSymbolicExpr[sexpr]
        	    {
        	        FOLLOWPUSH(FOLLOW_simpleSymbolicExpr_in_symbolicExpr3596);
        	        simpleSymbolicExpr(ctx, sexpr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolicExprEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:1780:5: LPAREN_TOK ( symbolicExpr[sexpr] )* RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_symbolicExpr3603);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolicExprEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:1781:5: ( symbolicExpr[sexpr] )*

        	        for (;;)
        	        {
        	            int alt48=2;
        	            switch ( LA(1) )
        	            {
        	            case AND_TOK:
        	            case ASSERT_TOK:
        	            case BINARY_LITERAL:
        	            case BV2NAT_TOK:
        	            case CHECKSAT_TOK:
        	            case CHECK_SYNTH_TOK:
        	            case CONSTRAINT_TOK:
        	            case DECIMAL_LITERAL:
        	            case DECLARE_DATATYPES_TOK:
        	            case DECLARE_FUN_TOK:
        	            case DECLARE_PRIMED_VAR_TOK:
        	            case DECLARE_SORT_TOK:
        	            case DECLARE_VAR_TOK:
        	            case DEFINE_FUNS_REC_TOK:
        	            case DEFINE_FUN_REC_TOK:
        	            case DEFINE_FUN_TOK:
        	            case DEFINE_SORT_TOK:
        	            case DISTINCT_TOK:
        	            case DIV_TOK:
        	            case DTSIZE_TOK:
        	            case ECHO_TOK:
        	            case EQUAL_TOK:
        	            case EXIT_TOK:
        	            case FMFCARDVAL_TOK:
        	            case FMFCARD_TOK:
        	            case GET_ASSERTIONS_TOK:
        	            case GET_ASSIGNMENT_TOK:
        	            case GET_INFO_TOK:
        	            case GET_MODEL_TOK:
        	            case GET_OPTION_TOK:
        	            case GET_PROOF_TOK:
        	            case GET_UNSAT_CORE_TOK:
        	            case GET_VALUE_TOK:
        	            case GREATER_THAN_EQUAL_TOK:
        	            case GREATER_THAN_TOK:
        	            case HEX_LITERAL:
        	            case IMPLIES_TOK:
        	            case INST_CLOSURE_TOK:
        	            case INTEGER_LITERAL:
        	            case INV_CONSTRAINT_TOK:
        	            case ITE_TOK:
        	            case KEYWORD:
        	            case LESS_THAN_EQUAL_TOK:
        	            case LESS_THAN_TOK:
        	            case LPAREN_TOK:
        	            case MINUS_TOK:
        	            case NOT_TOK:
        	            case OR_TOK:
        	            case PLUS_TOK:
        	            case POP_TOK:
        	            case PROPAGATION_RULE_TOK:
        	            case PUSH_TOK:
        	            case QUOTED_SYMBOL:
        	            case REDUCTION_RULE_TOK:
        	            case RESET_ASSERTIONS_TOK:
        	            case RESET_TOK:
        	            case REWRITE_RULE_TOK:
        	            case SET_INFO_TOK:
        	            case SET_LOGIC_TOK:
        	            case SET_OPTIONS_TOK:
        	            case SET_OPTION_TOK:
        	            case SIMPLE_SYMBOL:
        	            case SIMPLIFY_TOK:
        	            case STAR_TOK:
        	            case STRING_LITERAL_2_0:
        	            case STRING_LITERAL_2_5:
        	            case SYNTH_FUN_TOK:
        	            case SYNTH_INV_TOK:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            case XOR_TOK:
        	            case 154:
        	            	{
        	            		alt48=1;
        	            	}
        	                break;

        	            }

        	            switch (alt48)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:1781:7: symbolicExpr[sexpr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_symbolicExpr_in_symbolicExpr3611);
        	        	        symbolicExpr(ctx, sexpr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesymbolicExprEx;
        	        	        }


        	        	        {
        	        	             children.push_back(sexpr); 
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop48;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop48: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_symbolicExpr3619);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolicExprEx;
        	        }


        	        {
        	             sexpr = SExpr(children); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesymbolicExprEx; /* Prevent compiler warnings */
    rulesymbolicExprEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end symbolicExpr */

/**
 * $ANTLR start term
 * ../../../../src/parser/smt2/Smt2.g:1789:1: term[CVC4::Expr& expr, CVC4::Expr& expr2] : ( LPAREN_TOK builtinOp[kind] termList[args,expr] RPAREN_TOK | LPAREN_TOK AS_TOK term[f, f2] sortSymbol[type, CHECK_DECLARED] RPAREN_TOK | LPAREN_TOK quantOp[kind] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK term[f, f2] RPAREN_TOK | LPAREN_TOK functionName[name, CHECK_NONE] termList[args,expr] RPAREN_TOK | LPAREN_TOK ( indexedFunctionName[op, kind] termList[args,expr] RPAREN_TOK | LPAREN_TOK AS_TOK CONST_TOK sortSymbol[type, CHECK_DECLARED] RPAREN_TOK term[f, f2] RPAREN_TOK ) | LPAREN_TOK LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] ( term[expr, f2] | sortSymbol[type,CHECK_DECLARED] term[expr, f2] ) RPAREN_TOK )+ RPAREN_TOK term[expr, f2] RPAREN_TOK | LPAREN_TOK MATCH_TOK term[expr, f2] LPAREN_TOK ( LPAREN_TOK INDEX_TOK term[f, f2] RPAREN_TOK | LPAREN_TOK LPAREN_TOK term[f, f2] ( symbol[name,CHECK_NONE,SYM_VARIABLE] )* RPAREN_TOK term[f3, f2] RPAREN_TOK | LPAREN_TOK symbol[name,CHECK_DECLARED,SYM_VARIABLE] term[f3, f2] RPAREN_TOK )+ RPAREN_TOK RPAREN_TOK | symbol[name,CHECK_NONE,SYM_VARIABLE] SYGUS_ENUM_CONS_TOK symbol[name2,CHECK_NONE,SYM_VARIABLE] | symbol[name,CHECK_DECLARED,SYM_VARIABLE] | LPAREN_TOK ATTRIBUTE_TOK term[expr, f2] ( attribute[expr, attexpr, attr] )+ RPAREN_TOK | INTEGER_LITERAL | DECIMAL_LITERAL | LPAREN_TOK INDEX_TOK (bvLit= SIMPLE_SYMBOL size= INTEGER_LITERAL | FP_PINF_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_NINF_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_NAN_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL ) RPAREN_TOK | HEX_LITERAL | BINARY_LITERAL | str[s,false] | FP_RNE_TOK | FP_RNA_TOK | FP_RTP_TOK | FP_RTN_TOK | FP_RTZ_TOK | FP_RNE_FULL_TOK | FP_RNA_FULL_TOK | FP_RTP_FULL_TOK | FP_RTN_FULL_TOK | FP_RTZ_FULL_TOK | RENOSTR_TOK | REALLCHAR_TOK | EMPTYSET_TOK | UNIVSET_TOK | NILREF_TOK );
 */
static void
term(pSmt2Parser ctx, CVC4::Expr& expr, CVC4::Expr& expr2)
{
    pANTLR3_COMMON_TOKEN    bvLit;
    pANTLR3_COMMON_TOKEN    size;
    pANTLR3_COMMON_TOKEN    eb;
    pANTLR3_COMMON_TOKEN    sb;
    pANTLR3_COMMON_TOKEN    INTEGER_LITERAL14;
    pANTLR3_COMMON_TOKEN    DECIMAL_LITERAL15;
    pANTLR3_COMMON_TOKEN    HEX_LITERAL16;
    pANTLR3_COMMON_TOKEN    BINARY_LITERAL17;

    /* Initialize rule variables
     */


      Debug("parser") << "term: " << AntlrInput::tokenText(LT(1)) << std::endl;
      Kind kind = kind::NULL_EXPR;
      Expr op;
      std::string name, name2;
      std::vector<Expr> args;
      std::vector< std::pair<std::string, Type> > sortedVarNames;
      Expr f, f2, f3, f4;
      std::string attr;
      Expr attexpr;
      std::vector<Expr> patexprs;
      std::vector<Expr> patconds;
      std::hash_set<std::string, StringHashFunction> names;
      std::vector< std::pair<std::string, Expr> > binders;
      Type type;
      std::string s;
      bool isBuiltinOperator = false;
      bool readLetSort = false;
      int match_vindex = -1;
      std::vector<Type> match_ptypes;

    bvLit       = NULL;
    size       = NULL;
    eb       = NULL;
    sb       = NULL;
    INTEGER_LITERAL14       = NULL;
    DECIMAL_LITERAL15       = NULL;
    HEX_LITERAL16       = NULL;
    BINARY_LITERAL17       = NULL;

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:1811:3: ( LPAREN_TOK builtinOp[kind] termList[args,expr] RPAREN_TOK | LPAREN_TOK AS_TOK term[f, f2] sortSymbol[type, CHECK_DECLARED] RPAREN_TOK | LPAREN_TOK quantOp[kind] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK term[f, f2] RPAREN_TOK | LPAREN_TOK functionName[name, CHECK_NONE] termList[args,expr] RPAREN_TOK | LPAREN_TOK ( indexedFunctionName[op, kind] termList[args,expr] RPAREN_TOK | LPAREN_TOK AS_TOK CONST_TOK sortSymbol[type, CHECK_DECLARED] RPAREN_TOK term[f, f2] RPAREN_TOK ) | LPAREN_TOK LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] ( term[expr, f2] | sortSymbol[type,CHECK_DECLARED] term[expr, f2] ) RPAREN_TOK )+ RPAREN_TOK term[expr, f2] RPAREN_TOK | LPAREN_TOK MATCH_TOK term[expr, f2] LPAREN_TOK ( LPAREN_TOK INDEX_TOK term[f, f2] RPAREN_TOK | LPAREN_TOK LPAREN_TOK term[f, f2] ( symbol[name,CHECK_NONE,SYM_VARIABLE] )* RPAREN_TOK term[f3, f2] RPAREN_TOK | LPAREN_TOK symbol[name,CHECK_DECLARED,SYM_VARIABLE] term[f3, f2] RPAREN_TOK )+ RPAREN_TOK RPAREN_TOK | symbol[name,CHECK_NONE,SYM_VARIABLE] SYGUS_ENUM_CONS_TOK symbol[name2,CHECK_NONE,SYM_VARIABLE] | symbol[name,CHECK_DECLARED,SYM_VARIABLE] | LPAREN_TOK ATTRIBUTE_TOK term[expr, f2] ( attribute[expr, attexpr, attr] )+ RPAREN_TOK | INTEGER_LITERAL | DECIMAL_LITERAL | LPAREN_TOK INDEX_TOK (bvLit= SIMPLE_SYMBOL size= INTEGER_LITERAL | FP_PINF_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_NINF_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_NAN_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL ) RPAREN_TOK | HEX_LITERAL | BINARY_LITERAL | str[s,false] | FP_RNE_TOK | FP_RNA_TOK | FP_RTP_TOK | FP_RTN_TOK | FP_RTZ_TOK | FP_RNE_FULL_TOK | FP_RNA_FULL_TOK | FP_RTP_FULL_TOK | FP_RTN_FULL_TOK | FP_RTZ_FULL_TOK | RENOSTR_TOK | REALLCHAR_TOK | EMPTYSET_TOK | UNIVSET_TOK | NILREF_TOK )

            ANTLR3_UINT32 alt57;

            alt57=31;

            switch ( LA(1) )
            {
            case LPAREN_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case AS_TOK:
            			{
            				alt57=2;
            			}
            		    break;
            		case LET_TOK:
            			{
            				alt57=6;
            			}
            		    break;
            		case MATCH_TOK:
            			{
            				alt57=7;
            			}
            		    break;
            		case ATTRIBUTE_TOK:
            			{
            				alt57=10;
            			}
            		    break;
            		case INDEX_TOK:
            			{
            				alt57=13;
            			}
            		    break;
            		case AND_TOK:
            		case BV2NAT_TOK:
            		case DISTINCT_TOK:
            		case DIV_TOK:
            		case DTSIZE_TOK:
            		case EQUAL_TOK:
            		case FMFCARDVAL_TOK:
            		case FMFCARD_TOK:
            		case GREATER_THAN_EQUAL_TOK:
            		case GREATER_THAN_TOK:
            		case IMPLIES_TOK:
            		case INST_CLOSURE_TOK:
            		case ITE_TOK:
            		case LESS_THAN_EQUAL_TOK:
            		case LESS_THAN_TOK:
            		case MINUS_TOK:
            		case NOT_TOK:
            		case OR_TOK:
            		case PLUS_TOK:
            		case STAR_TOK:
            		case XOR_TOK:
            			{
            				alt57=1;
            			}
            		    break;
            		case EXISTS_TOK:
            		case FORALL_TOK:
            			{
            				alt57=3;
            			}
            		    break;
            		case CHECK_SYNTH_TOK:
            		case CONSTRAINT_TOK:
            		case DECLARE_PRIMED_VAR_TOK:
            		case DECLARE_VAR_TOK:
            		case INV_CONSTRAINT_TOK:
            		case QUOTED_SYMBOL:
            		case SET_OPTIONS_TOK:
            		case SIMPLE_SYMBOL:
            		case SYNTH_FUN_TOK:
            		case SYNTH_INV_TOK:
            		case UNTERMINATED_QUOTED_SYMBOL:
            		case 154:
            			{
            				alt57=4;
            			}
            		    break;
            		case LPAREN_TOK:
            			{
            				alt57=5;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 57;
            		    EXCEPTION->state        = 1;


            		    goto ruletermEx;

            		}

            	}
                break;
            case SIMPLE_SYMBOL:
            	{
            		switch ( LA(2) )
            		{
            		case SYGUS_ENUM_CONS_TOK:
            			{
            				alt57=8;
            			}
            		    break;
            		case EOF:
            		case ATTRIBUTE_INST_LEVEL:
            		case ATTRIBUTE_NAMED_TOK:
            		case ATTRIBUTE_NO_PATTERN_TOK:
            		case ATTRIBUTE_PATTERN_TOK:
            		case ATTRIBUTE_RR_PRIORITY:
            		case BINARY_LITERAL:
            		case CHECK_SYNTH_TOK:
            		case CONSTRAINT_TOK:
            		case DECIMAL_LITERAL:
            		case DECLARE_PRIMED_VAR_TOK:
            		case DECLARE_VAR_TOK:
            		case EMPTYSET_TOK:
            		case FP_RNA_FULL_TOK:
            		case FP_RNA_TOK:
            		case FP_RNE_FULL_TOK:
            		case FP_RNE_TOK:
            		case FP_RTN_FULL_TOK:
            		case FP_RTN_TOK:
            		case FP_RTP_FULL_TOK:
            		case FP_RTP_TOK:
            		case FP_RTZ_FULL_TOK:
            		case FP_RTZ_TOK:
            		case HEX_LITERAL:
            		case INTEGER_LITERAL:
            		case INV_CONSTRAINT_TOK:
            		case KEYWORD:
            		case LPAREN_TOK:
            		case NILREF_TOK:
            		case QUOTED_SYMBOL:
            		case REALLCHAR_TOK:
            		case RENOSTR_TOK:
            		case RPAREN_TOK:
            		case SET_OPTIONS_TOK:
            		case SIMPLE_SYMBOL:
            		case STRING_LITERAL_2_0:
            		case STRING_LITERAL_2_5:
            		case SYNTH_FUN_TOK:
            		case SYNTH_INV_TOK:
            		case UNIVSET_TOK:
            		case UNTERMINATED_QUOTED_SYMBOL:
            		case 154:
            			{
            				alt57=9;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 57;
            		    EXCEPTION->state        = 2;


            		    goto ruletermEx;

            		}

            	}
                break;
            case 154:
            	{
            		switch ( LA(2) )
            		{
            		case SYGUS_ENUM_CONS_TOK:
            			{
            				alt57=8;
            			}
            		    break;
            		case EOF:
            		case ATTRIBUTE_INST_LEVEL:
            		case ATTRIBUTE_NAMED_TOK:
            		case ATTRIBUTE_NO_PATTERN_TOK:
            		case ATTRIBUTE_PATTERN_TOK:
            		case ATTRIBUTE_RR_PRIORITY:
            		case BINARY_LITERAL:
            		case CHECK_SYNTH_TOK:
            		case CONSTRAINT_TOK:
            		case DECIMAL_LITERAL:
            		case DECLARE_PRIMED_VAR_TOK:
            		case DECLARE_VAR_TOK:
            		case EMPTYSET_TOK:
            		case FP_RNA_FULL_TOK:
            		case FP_RNA_TOK:
            		case FP_RNE_FULL_TOK:
            		case FP_RNE_TOK:
            		case FP_RTN_FULL_TOK:
            		case FP_RTN_TOK:
            		case FP_RTP_FULL_TOK:
            		case FP_RTP_TOK:
            		case FP_RTZ_FULL_TOK:
            		case FP_RTZ_TOK:
            		case HEX_LITERAL:
            		case INTEGER_LITERAL:
            		case INV_CONSTRAINT_TOK:
            		case KEYWORD:
            		case LPAREN_TOK:
            		case NILREF_TOK:
            		case QUOTED_SYMBOL:
            		case REALLCHAR_TOK:
            		case RENOSTR_TOK:
            		case RPAREN_TOK:
            		case SET_OPTIONS_TOK:
            		case SIMPLE_SYMBOL:
            		case STRING_LITERAL_2_0:
            		case STRING_LITERAL_2_5:
            		case SYNTH_FUN_TOK:
            		case SYNTH_INV_TOK:
            		case UNIVSET_TOK:
            		case UNTERMINATED_QUOTED_SYMBOL:
            		case 154:
            			{
            				alt57=9;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 57;
            		    EXCEPTION->state        = 3;


            		    goto ruletermEx;

            		}

            	}
                break;
            case SET_OPTIONS_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case SYGUS_ENUM_CONS_TOK:
            			{
            				alt57=8;
            			}
            		    break;
            		case EOF:
            		case ATTRIBUTE_INST_LEVEL:
            		case ATTRIBUTE_NAMED_TOK:
            		case ATTRIBUTE_NO_PATTERN_TOK:
            		case ATTRIBUTE_PATTERN_TOK:
            		case ATTRIBUTE_RR_PRIORITY:
            		case BINARY_LITERAL:
            		case CHECK_SYNTH_TOK:
            		case CONSTRAINT_TOK:
            		case DECIMAL_LITERAL:
            		case DECLARE_PRIMED_VAR_TOK:
            		case DECLARE_VAR_TOK:
            		case EMPTYSET_TOK:
            		case FP_RNA_FULL_TOK:
            		case FP_RNA_TOK:
            		case FP_RNE_FULL_TOK:
            		case FP_RNE_TOK:
            		case FP_RTN_FULL_TOK:
            		case FP_RTN_TOK:
            		case FP_RTP_FULL_TOK:
            		case FP_RTP_TOK:
            		case FP_RTZ_FULL_TOK:
            		case FP_RTZ_TOK:
            		case HEX_LITERAL:
            		case INTEGER_LITERAL:
            		case INV_CONSTRAINT_TOK:
            		case KEYWORD:
            		case LPAREN_TOK:
            		case NILREF_TOK:
            		case QUOTED_SYMBOL:
            		case REALLCHAR_TOK:
            		case RENOSTR_TOK:
            		case RPAREN_TOK:
            		case SET_OPTIONS_TOK:
            		case SIMPLE_SYMBOL:
            		case STRING_LITERAL_2_0:
            		case STRING_LITERAL_2_5:
            		case SYNTH_FUN_TOK:
            		case SYNTH_INV_TOK:
            		case UNIVSET_TOK:
            		case UNTERMINATED_QUOTED_SYMBOL:
            		case 154:
            			{
            				alt57=9;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 57;
            		    EXCEPTION->state        = 4;


            		    goto ruletermEx;

            		}

            	}
                break;
            case DECLARE_VAR_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case SYGUS_ENUM_CONS_TOK:
            			{
            				alt57=8;
            			}
            		    break;
            		case EOF:
            		case ATTRIBUTE_INST_LEVEL:
            		case ATTRIBUTE_NAMED_TOK:
            		case ATTRIBUTE_NO_PATTERN_TOK:
            		case ATTRIBUTE_PATTERN_TOK:
            		case ATTRIBUTE_RR_PRIORITY:
            		case BINARY_LITERAL:
            		case CHECK_SYNTH_TOK:
            		case CONSTRAINT_TOK:
            		case DECIMAL_LITERAL:
            		case DECLARE_PRIMED_VAR_TOK:
            		case DECLARE_VAR_TOK:
            		case EMPTYSET_TOK:
            		case FP_RNA_FULL_TOK:
            		case FP_RNA_TOK:
            		case FP_RNE_FULL_TOK:
            		case FP_RNE_TOK:
            		case FP_RTN_FULL_TOK:
            		case FP_RTN_TOK:
            		case FP_RTP_FULL_TOK:
            		case FP_RTP_TOK:
            		case FP_RTZ_FULL_TOK:
            		case FP_RTZ_TOK:
            		case HEX_LITERAL:
            		case INTEGER_LITERAL:
            		case INV_CONSTRAINT_TOK:
            		case KEYWORD:
            		case LPAREN_TOK:
            		case NILREF_TOK:
            		case QUOTED_SYMBOL:
            		case REALLCHAR_TOK:
            		case RENOSTR_TOK:
            		case RPAREN_TOK:
            		case SET_OPTIONS_TOK:
            		case SIMPLE_SYMBOL:
            		case STRING_LITERAL_2_0:
            		case STRING_LITERAL_2_5:
            		case SYNTH_FUN_TOK:
            		case SYNTH_INV_TOK:
            		case UNIVSET_TOK:
            		case UNTERMINATED_QUOTED_SYMBOL:
            		case 154:
            			{
            				alt57=9;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 57;
            		    EXCEPTION->state        = 5;


            		    goto ruletermEx;

            		}

            	}
                break;
            case DECLARE_PRIMED_VAR_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case SYGUS_ENUM_CONS_TOK:
            			{
            				alt57=8;
            			}
            		    break;
            		case EOF:
            		case ATTRIBUTE_INST_LEVEL:
            		case ATTRIBUTE_NAMED_TOK:
            		case ATTRIBUTE_NO_PATTERN_TOK:
            		case ATTRIBUTE_PATTERN_TOK:
            		case ATTRIBUTE_RR_PRIORITY:
            		case BINARY_LITERAL:
            		case CHECK_SYNTH_TOK:
            		case CONSTRAINT_TOK:
            		case DECIMAL_LITERAL:
            		case DECLARE_PRIMED_VAR_TOK:
            		case DECLARE_VAR_TOK:
            		case EMPTYSET_TOK:
            		case FP_RNA_FULL_TOK:
            		case FP_RNA_TOK:
            		case FP_RNE_FULL_TOK:
            		case FP_RNE_TOK:
            		case FP_RTN_FULL_TOK:
            		case FP_RTN_TOK:
            		case FP_RTP_FULL_TOK:
            		case FP_RTP_TOK:
            		case FP_RTZ_FULL_TOK:
            		case FP_RTZ_TOK:
            		case HEX_LITERAL:
            		case INTEGER_LITERAL:
            		case INV_CONSTRAINT_TOK:
            		case KEYWORD:
            		case LPAREN_TOK:
            		case NILREF_TOK:
            		case QUOTED_SYMBOL:
            		case REALLCHAR_TOK:
            		case RENOSTR_TOK:
            		case RPAREN_TOK:
            		case SET_OPTIONS_TOK:
            		case SIMPLE_SYMBOL:
            		case STRING_LITERAL_2_0:
            		case STRING_LITERAL_2_5:
            		case SYNTH_FUN_TOK:
            		case SYNTH_INV_TOK:
            		case UNIVSET_TOK:
            		case UNTERMINATED_QUOTED_SYMBOL:
            		case 154:
            			{
            				alt57=9;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 57;
            		    EXCEPTION->state        = 6;


            		    goto ruletermEx;

            		}

            	}
                break;
            case SYNTH_FUN_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case SYGUS_ENUM_CONS_TOK:
            			{
            				alt57=8;
            			}
            		    break;
            		case EOF:
            		case ATTRIBUTE_INST_LEVEL:
            		case ATTRIBUTE_NAMED_TOK:
            		case ATTRIBUTE_NO_PATTERN_TOK:
            		case ATTRIBUTE_PATTERN_TOK:
            		case ATTRIBUTE_RR_PRIORITY:
            		case BINARY_LITERAL:
            		case CHECK_SYNTH_TOK:
            		case CONSTRAINT_TOK:
            		case DECIMAL_LITERAL:
            		case DECLARE_PRIMED_VAR_TOK:
            		case DECLARE_VAR_TOK:
            		case EMPTYSET_TOK:
            		case FP_RNA_FULL_TOK:
            		case FP_RNA_TOK:
            		case FP_RNE_FULL_TOK:
            		case FP_RNE_TOK:
            		case FP_RTN_FULL_TOK:
            		case FP_RTN_TOK:
            		case FP_RTP_FULL_TOK:
            		case FP_RTP_TOK:
            		case FP_RTZ_FULL_TOK:
            		case FP_RTZ_TOK:
            		case HEX_LITERAL:
            		case INTEGER_LITERAL:
            		case INV_CONSTRAINT_TOK:
            		case KEYWORD:
            		case LPAREN_TOK:
            		case NILREF_TOK:
            		case QUOTED_SYMBOL:
            		case REALLCHAR_TOK:
            		case RENOSTR_TOK:
            		case RPAREN_TOK:
            		case SET_OPTIONS_TOK:
            		case SIMPLE_SYMBOL:
            		case STRING_LITERAL_2_0:
            		case STRING_LITERAL_2_5:
            		case SYNTH_FUN_TOK:
            		case SYNTH_INV_TOK:
            		case UNIVSET_TOK:
            		case UNTERMINATED_QUOTED_SYMBOL:
            		case 154:
            			{
            				alt57=9;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 57;
            		    EXCEPTION->state        = 7;


            		    goto ruletermEx;

            		}

            	}
                break;
            case SYNTH_INV_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case SYGUS_ENUM_CONS_TOK:
            			{
            				alt57=8;
            			}
            		    break;
            		case EOF:
            		case ATTRIBUTE_INST_LEVEL:
            		case ATTRIBUTE_NAMED_TOK:
            		case ATTRIBUTE_NO_PATTERN_TOK:
            		case ATTRIBUTE_PATTERN_TOK:
            		case ATTRIBUTE_RR_PRIORITY:
            		case BINARY_LITERAL:
            		case CHECK_SYNTH_TOK:
            		case CONSTRAINT_TOK:
            		case DECIMAL_LITERAL:
            		case DECLARE_PRIMED_VAR_TOK:
            		case DECLARE_VAR_TOK:
            		case EMPTYSET_TOK:
            		case FP_RNA_FULL_TOK:
            		case FP_RNA_TOK:
            		case FP_RNE_FULL_TOK:
            		case FP_RNE_TOK:
            		case FP_RTN_FULL_TOK:
            		case FP_RTN_TOK:
            		case FP_RTP_FULL_TOK:
            		case FP_RTP_TOK:
            		case FP_RTZ_FULL_TOK:
            		case FP_RTZ_TOK:
            		case HEX_LITERAL:
            		case INTEGER_LITERAL:
            		case INV_CONSTRAINT_TOK:
            		case KEYWORD:
            		case LPAREN_TOK:
            		case NILREF_TOK:
            		case QUOTED_SYMBOL:
            		case REALLCHAR_TOK:
            		case RENOSTR_TOK:
            		case RPAREN_TOK:
            		case SET_OPTIONS_TOK:
            		case SIMPLE_SYMBOL:
            		case STRING_LITERAL_2_0:
            		case STRING_LITERAL_2_5:
            		case SYNTH_FUN_TOK:
            		case SYNTH_INV_TOK:
            		case UNIVSET_TOK:
            		case UNTERMINATED_QUOTED_SYMBOL:
            		case 154:
            			{
            				alt57=9;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 57;
            		    EXCEPTION->state        = 8;


            		    goto ruletermEx;

            		}

            	}
                break;
            case CONSTRAINT_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case SYGUS_ENUM_CONS_TOK:
            			{
            				alt57=8;
            			}
            		    break;
            		case EOF:
            		case ATTRIBUTE_INST_LEVEL:
            		case ATTRIBUTE_NAMED_TOK:
            		case ATTRIBUTE_NO_PATTERN_TOK:
            		case ATTRIBUTE_PATTERN_TOK:
            		case ATTRIBUTE_RR_PRIORITY:
            		case BINARY_LITERAL:
            		case CHECK_SYNTH_TOK:
            		case CONSTRAINT_TOK:
            		case DECIMAL_LITERAL:
            		case DECLARE_PRIMED_VAR_TOK:
            		case DECLARE_VAR_TOK:
            		case EMPTYSET_TOK:
            		case FP_RNA_FULL_TOK:
            		case FP_RNA_TOK:
            		case FP_RNE_FULL_TOK:
            		case FP_RNE_TOK:
            		case FP_RTN_FULL_TOK:
            		case FP_RTN_TOK:
            		case FP_RTP_FULL_TOK:
            		case FP_RTP_TOK:
            		case FP_RTZ_FULL_TOK:
            		case FP_RTZ_TOK:
            		case HEX_LITERAL:
            		case INTEGER_LITERAL:
            		case INV_CONSTRAINT_TOK:
            		case KEYWORD:
            		case LPAREN_TOK:
            		case NILREF_TOK:
            		case QUOTED_SYMBOL:
            		case REALLCHAR_TOK:
            		case RENOSTR_TOK:
            		case RPAREN_TOK:
            		case SET_OPTIONS_TOK:
            		case SIMPLE_SYMBOL:
            		case STRING_LITERAL_2_0:
            		case STRING_LITERAL_2_5:
            		case SYNTH_FUN_TOK:
            		case SYNTH_INV_TOK:
            		case UNIVSET_TOK:
            		case UNTERMINATED_QUOTED_SYMBOL:
            		case 154:
            			{
            				alt57=9;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 57;
            		    EXCEPTION->state        = 9;


            		    goto ruletermEx;

            		}

            	}
                break;
            case INV_CONSTRAINT_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case SYGUS_ENUM_CONS_TOK:
            			{
            				alt57=8;
            			}
            		    break;
            		case EOF:
            		case ATTRIBUTE_INST_LEVEL:
            		case ATTRIBUTE_NAMED_TOK:
            		case ATTRIBUTE_NO_PATTERN_TOK:
            		case ATTRIBUTE_PATTERN_TOK:
            		case ATTRIBUTE_RR_PRIORITY:
            		case BINARY_LITERAL:
            		case CHECK_SYNTH_TOK:
            		case CONSTRAINT_TOK:
            		case DECIMAL_LITERAL:
            		case DECLARE_PRIMED_VAR_TOK:
            		case DECLARE_VAR_TOK:
            		case EMPTYSET_TOK:
            		case FP_RNA_FULL_TOK:
            		case FP_RNA_TOK:
            		case FP_RNE_FULL_TOK:
            		case FP_RNE_TOK:
            		case FP_RTN_FULL_TOK:
            		case FP_RTN_TOK:
            		case FP_RTP_FULL_TOK:
            		case FP_RTP_TOK:
            		case FP_RTZ_FULL_TOK:
            		case FP_RTZ_TOK:
            		case HEX_LITERAL:
            		case INTEGER_LITERAL:
            		case INV_CONSTRAINT_TOK:
            		case KEYWORD:
            		case LPAREN_TOK:
            		case NILREF_TOK:
            		case QUOTED_SYMBOL:
            		case REALLCHAR_TOK:
            		case RENOSTR_TOK:
            		case RPAREN_TOK:
            		case SET_OPTIONS_TOK:
            		case SIMPLE_SYMBOL:
            		case STRING_LITERAL_2_0:
            		case STRING_LITERAL_2_5:
            		case SYNTH_FUN_TOK:
            		case SYNTH_INV_TOK:
            		case UNIVSET_TOK:
            		case UNTERMINATED_QUOTED_SYMBOL:
            		case 154:
            			{
            				alt57=9;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 57;
            		    EXCEPTION->state        = 10;


            		    goto ruletermEx;

            		}

            	}
                break;
            case CHECK_SYNTH_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case SYGUS_ENUM_CONS_TOK:
            			{
            				alt57=8;
            			}
            		    break;
            		case EOF:
            		case ATTRIBUTE_INST_LEVEL:
            		case ATTRIBUTE_NAMED_TOK:
            		case ATTRIBUTE_NO_PATTERN_TOK:
            		case ATTRIBUTE_PATTERN_TOK:
            		case ATTRIBUTE_RR_PRIORITY:
            		case BINARY_LITERAL:
            		case CHECK_SYNTH_TOK:
            		case CONSTRAINT_TOK:
            		case DECIMAL_LITERAL:
            		case DECLARE_PRIMED_VAR_TOK:
            		case DECLARE_VAR_TOK:
            		case EMPTYSET_TOK:
            		case FP_RNA_FULL_TOK:
            		case FP_RNA_TOK:
            		case FP_RNE_FULL_TOK:
            		case FP_RNE_TOK:
            		case FP_RTN_FULL_TOK:
            		case FP_RTN_TOK:
            		case FP_RTP_FULL_TOK:
            		case FP_RTP_TOK:
            		case FP_RTZ_FULL_TOK:
            		case FP_RTZ_TOK:
            		case HEX_LITERAL:
            		case INTEGER_LITERAL:
            		case INV_CONSTRAINT_TOK:
            		case KEYWORD:
            		case LPAREN_TOK:
            		case NILREF_TOK:
            		case QUOTED_SYMBOL:
            		case REALLCHAR_TOK:
            		case RENOSTR_TOK:
            		case RPAREN_TOK:
            		case SET_OPTIONS_TOK:
            		case SIMPLE_SYMBOL:
            		case STRING_LITERAL_2_0:
            		case STRING_LITERAL_2_5:
            		case SYNTH_FUN_TOK:
            		case SYNTH_INV_TOK:
            		case UNIVSET_TOK:
            		case UNTERMINATED_QUOTED_SYMBOL:
            		case 154:
            			{
            				alt57=9;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 57;
            		    EXCEPTION->state        = 11;


            		    goto ruletermEx;

            		}

            	}
                break;
            case QUOTED_SYMBOL:
            	{
            		switch ( LA(2) )
            		{
            		case SYGUS_ENUM_CONS_TOK:
            			{
            				alt57=8;
            			}
            		    break;
            		case EOF:
            		case ATTRIBUTE_INST_LEVEL:
            		case ATTRIBUTE_NAMED_TOK:
            		case ATTRIBUTE_NO_PATTERN_TOK:
            		case ATTRIBUTE_PATTERN_TOK:
            		case ATTRIBUTE_RR_PRIORITY:
            		case BINARY_LITERAL:
            		case CHECK_SYNTH_TOK:
            		case CONSTRAINT_TOK:
            		case DECIMAL_LITERAL:
            		case DECLARE_PRIMED_VAR_TOK:
            		case DECLARE_VAR_TOK:
            		case EMPTYSET_TOK:
            		case FP_RNA_FULL_TOK:
            		case FP_RNA_TOK:
            		case FP_RNE_FULL_TOK:
            		case FP_RNE_TOK:
            		case FP_RTN_FULL_TOK:
            		case FP_RTN_TOK:
            		case FP_RTP_FULL_TOK:
            		case FP_RTP_TOK:
            		case FP_RTZ_FULL_TOK:
            		case FP_RTZ_TOK:
            		case HEX_LITERAL:
            		case INTEGER_LITERAL:
            		case INV_CONSTRAINT_TOK:
            		case KEYWORD:
            		case LPAREN_TOK:
            		case NILREF_TOK:
            		case QUOTED_SYMBOL:
            		case REALLCHAR_TOK:
            		case RENOSTR_TOK:
            		case RPAREN_TOK:
            		case SET_OPTIONS_TOK:
            		case SIMPLE_SYMBOL:
            		case STRING_LITERAL_2_0:
            		case STRING_LITERAL_2_5:
            		case SYNTH_FUN_TOK:
            		case SYNTH_INV_TOK:
            		case UNIVSET_TOK:
            		case UNTERMINATED_QUOTED_SYMBOL:
            		case 154:
            			{
            				alt57=9;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 57;
            		    EXCEPTION->state        = 12;


            		    goto ruletermEx;

            		}

            	}
                break;
            case UNTERMINATED_QUOTED_SYMBOL:
            	{
            		switch ( LA(2) )
            		{
            		case EOF:
            			{
            				alt57=8;
            			}
            		    break;
            		case 152:
            			{
            				alt57=8;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 57;
            		    EXCEPTION->state        = 13;


            		    goto ruletermEx;

            		}

            	}
                break;
            case INTEGER_LITERAL:
            	{
            		alt57=11;
            	}
                break;
            case DECIMAL_LITERAL:
            	{
            		alt57=12;
            	}
                break;
            case HEX_LITERAL:
            	{
            		alt57=14;
            	}
                break;
            case BINARY_LITERAL:
            	{
            		alt57=15;
            	}
                break;
            case STRING_LITERAL_2_0:
            case STRING_LITERAL_2_5:
            	{
            		alt57=16;
            	}
                break;
            case FP_RNE_TOK:
            	{
            		alt57=17;
            	}
                break;
            case FP_RNA_TOK:
            	{
            		alt57=18;
            	}
                break;
            case FP_RTP_TOK:
            	{
            		alt57=19;
            	}
                break;
            case FP_RTN_TOK:
            	{
            		alt57=20;
            	}
                break;
            case FP_RTZ_TOK:
            	{
            		alt57=21;
            	}
                break;
            case FP_RNE_FULL_TOK:
            	{
            		alt57=22;
            	}
                break;
            case FP_RNA_FULL_TOK:
            	{
            		alt57=23;
            	}
                break;
            case FP_RTP_FULL_TOK:
            	{
            		alt57=24;
            	}
                break;
            case FP_RTN_FULL_TOK:
            	{
            		alt57=25;
            	}
                break;
            case FP_RTZ_FULL_TOK:
            	{
            		alt57=26;
            	}
                break;
            case RENOSTR_TOK:
            	{
            		alt57=27;
            	}
                break;
            case REALLCHAR_TOK:
            	{
            		alt57=28;
            	}
                break;
            case EMPTYSET_TOK:
            	{
            		alt57=29;
            	}
                break;
            case UNIVSET_TOK:
            	{
            		alt57=30;
            	}
                break;
            case NILREF_TOK:
            	{
            		alt57=31;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 57;
                EXCEPTION->state        = 0;


                goto ruletermEx;

            }

            switch (alt57)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:1812:5: LPAREN_TOK builtinOp[kind] termList[args,expr] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_term3652);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_builtinOp_in_term3654);
        	        builtinOp(ctx, kind);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_termList_in_term3657);
        	        termList(ctx, args, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_term3660);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {

        	                  if( !PARSER_STATE->strictModeEnabled() &&
        	                      (kind == CVC4::kind::AND || kind == CVC4::kind::OR) &&
        	                      args.size() == 1) {
        	                    /* Unary AND/OR can be replaced with the argument.
        	                     * It just so happens expr should already be the only argument. */
        	                    assert( expr == args[0] );
        	                  } else if( CVC4::kind::isAssociative(kind) &&
        	                             args.size() > EXPR_MANAGER->maxArity(kind) ) {
        	                    /* Special treatment for associative operators with lots of children */
        	                    expr = EXPR_MANAGER->mkAssociative(kind, args);
        	                  } else if( kind == CVC4::kind::MINUS && args.size() == 1 ) {
        	                    expr = MK_EXPR(CVC4::kind::UMINUS, args[0]);
        	                  } else if( ( kind == CVC4::kind::XOR || kind == CVC4::kind::MINUS ) &&
        	                             args.size() > 2 ) {
        	                    /* left-associative, but CVC4 internally only supports 2 args */
        	                    expr = args[0];
        	                    for(size_t i = 1; i < args.size(); ++i) {
        	                      expr = MK_EXPR(kind, expr, args[i]);
        	                    }
        	                  } else if( kind == CVC4::kind::IMPLIES && args.size() > 2 ) {
        	                    /* right-associative, but CVC4 internally only supports 2 args */
        	                    expr = args[args.size() - 1];
        	                    for(size_t i = args.size() - 1; i > 0;) {
        	                      expr = MK_EXPR(kind, args[--i], expr);
        	                    }
        	                  } else if( ( kind == CVC4::kind::EQUAL ||
        	                               kind == CVC4::kind::LT || kind == CVC4::kind::GT ||
        	                               kind == CVC4::kind::LEQ || kind == CVC4::kind::GEQ ) &&
        	                             args.size() > 2 ) {
        	                    /* "chainable", but CVC4 internally only supports 2 args */
        	                    expr = MK_EXPR(MK_CONST(Chain(kind)), args);
        	                  } else if( PARSER_STATE->strictModeEnabled() && kind == CVC4::kind::ABS &&
        	                             args.size() == 1 && !args[0].getType().isInteger() ) {
        	                    /* first, check that ABS is even defined in this logic */
        	                    PARSER_STATE->checkOperator(kind, args.size());
        	                    PARSER_STATE->parseError("abs can only be applied to Int, not Real, "
        	                                             "while in strict SMT-LIB compliance mode");
        	                  } else {
        	                    PARSER_STATE->checkOperator(kind, args.size());
        	                    expr = MK_EXPR(kind, args);
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:1856:5: LPAREN_TOK AS_TOK term[f, f2] sortSymbol[type, CHECK_DECLARED] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_term3672);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	         MATCHT(AS_TOK, &FOLLOW_AS_TOK_in_term3674);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_term3676);
        	        term(ctx, f, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_term3679);
        	        sortSymbol(ctx, type, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_term3682);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {

        	                  if(f.getKind() == CVC4::kind::APPLY_CONSTRUCTOR && type.isDatatype()) {
        	                    std::vector<CVC4::Expr> v;
        	                    Expr e = f.getOperator();
        	                    const DatatypeConstructor& dtc =
        	                        Datatype::datatypeOf(e)[Datatype::indexOf(e)];
        	                    v.push_back(MK_EXPR( CVC4::kind::APPLY_TYPE_ASCRIPTION,
        	                                         MK_CONST(AscriptionType(dtc.getSpecializedConstructorType(type))), f.getOperator() ));
        	                    v.insert(v.end(), f.begin(), f.end());
        	                    expr = MK_EXPR(CVC4::kind::APPLY_CONSTRUCTOR, v);
        	                  } else if(f.getKind() == CVC4::kind::EMPTYSET) {
        	                    Debug("parser") << "Empty set encountered: " << f << " "
        	                                      << f2 << " " << type <<  std::endl;
        	                    expr = MK_CONST( ::CVC4::EmptySet(type) );
        	                  } else if(f.getKind() == CVC4::kind::UNIVERSE_SET) {
        	                    expr = EXPR_MANAGER->mkNullaryOperator(type, kind::UNIVERSE_SET);
        	                  } else if(f.getKind() == CVC4::kind::SEP_NIL) {
        	                    //We don't want the nil reference to be a constant: for instance, it
        	                    //could be of type Int but is not a const rational. However, the
        	                    //expression has 0 children. So we convert to a SEP_NIL variable.
        	                    expr = EXPR_MANAGER->mkNullaryOperator(type, kind::SEP_NIL);
        	                  } else {
        	                    if(f.getType() != type) {
        	                      PARSER_STATE->parseError("Type ascription not satisfied.");
        	                    }
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/smt2/Smt2.g:1884:5: LPAREN_TOK quantOp[kind] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK term[f, f2] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_term3694);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_quantOp_in_term3696);
        	        quantOp(ctx, kind);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_term3703);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortedVarList_in_term3705);
        	        sortedVarList(ctx, sortedVarNames);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_term3708);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {

        	                  PARSER_STATE->pushScope(true);
        	                  for(std::vector<std::pair<std::string, CVC4::Type> >::const_iterator i =
        	                        sortedVarNames.begin(), iend = sortedVarNames.end();
        	                      i != iend;
        	                      ++i) {
        	                    args.push_back(PARSER_STATE->mkBoundVar((*i).first, (*i).second));
        	                  }
        	                  Expr bvl = MK_EXPR(kind::BOUND_VAR_LIST, args);
        	                  args.clear();
        	                  args.push_back(bvl);
        	                
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_term3720);
        	        term(ctx, f, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_term3723);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {

        	                  PARSER_STATE->popScope();
        	                  switch(f.getKind()) {
        	                  case CVC4::kind::RR_REWRITE:
        	                  case CVC4::kind::RR_REDUCTION:
        	                  case CVC4::kind::RR_DEDUCTION:
        	                    if(kind == CVC4::kind::EXISTS) {
        	                      PARSER_STATE->parseError("Use Exists instead of Forall for a rewrite "
        	                                               "rule.");
        	                    }
        	                    args.push_back(f2); // guards
        	                    args.push_back(f); // rule
        	                    expr = MK_EXPR(CVC4::kind::REWRITE_RULE, args);
        	                    break;
        	                  default:
        	                    args.push_back(f);
        	                    if(! f2.isNull()){
        	                      args.push_back(f2);
        	                    }
        	                    expr = MK_EXPR(kind, args);
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 4:
        	    // ../../../../src/parser/smt2/Smt2.g:1921:5: LPAREN_TOK functionName[name, CHECK_NONE] termList[args,expr] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_term3735);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_functionName_in_term3737);
        	        functionName(ctx, name, CHECK_NONE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {
        	             isBuiltinOperator = PARSER_STATE->isOperatorEnabled(name);
        	                  if(isBuiltinOperator) {
        	                    /* A built-in operator not already handled by the lexer */
        	                    kind = PARSER_STATE->getOperatorKind(name);
        	                  } else {
        	                    /* A non-built-in function application */
        	                    PARSER_STATE->checkDeclaration(name, CHECK_DECLARED, SYM_VARIABLE);
        	                    //hack to allow constants with parentheses (disabled for now)
        	                    //if( PARSER_STATE->sygus() && !PARSER_STATE->isFunctionLike(name) ){
        	                    //  op = PARSER_STATE->getVariable(name);
        	                    //}else{
        	                    PARSER_STATE->checkFunctionLike(name);
        	                    const bool isDefinedFunction =
        	                      PARSER_STATE->isDefinedFunction(name);
        	                    if(isDefinedFunction) {
        	                      expr = PARSER_STATE->getFunction(name);
        	                      kind = CVC4::kind::APPLY;
        	                    } else {
        	                      expr = PARSER_STATE->getVariable(name);
        	                      Type t = expr.getType();
        	                      if(t.isConstructor()) {
        	                        kind = CVC4::kind::APPLY_CONSTRUCTOR;
        	                      } else if(t.isSelector()) {
        	                        kind = CVC4::kind::APPLY_SELECTOR;
        	                      } else if(t.isTester()) {
        	                        kind = CVC4::kind::APPLY_TESTER;
        	                      } else {
        	                        kind = CVC4::kind::APPLY_UF;
        	                      }
        	                    }
        	                    args.push_back(expr);
        	                  }
        	                    
        	        }


        	        FOLLOWPUSH(FOLLOW_termList_in_term3755);
        	        termList(ctx, args, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_term3758);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {
        	             Debug("parser") << "args has size " << args.size() << std::endl
        	                                  << "expr is " << expr << std::endl;
        	                  for(std::vector<Expr>::iterator i = args.begin(); i != args.end(); ++i) {
        	                    Debug("parser") << "++ " << *i << std::endl;
        	                  }
        	                  if(isBuiltinOperator) {
        	                    PARSER_STATE->checkOperator(kind, args.size());
        	                  }
        	                  expr = MK_EXPR(kind, args); 
        	                
        	        }


        	    }
        	    break;
        	case 5:
        	    // ../../../../src/parser/smt2/Smt2.g:1968:5: LPAREN_TOK ( indexedFunctionName[op, kind] termList[args,expr] RPAREN_TOK | LPAREN_TOK AS_TOK CONST_TOK sortSymbol[type, CHECK_DECLARED] RPAREN_TOK term[f, f2] RPAREN_TOK )
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_term3771);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:1969:5: ( indexedFunctionName[op, kind] termList[args,expr] RPAREN_TOK | LPAREN_TOK AS_TOK CONST_TOK sortSymbol[type, CHECK_DECLARED] RPAREN_TOK term[f, f2] RPAREN_TOK )
        	        {
        	            int alt50=2;
        	            switch ( LA(1) )
        	            {
        	            case LPAREN_TOK:
        	            	{
        	            		switch ( LA(2) )
        	            		{
        	            		case INDEX_TOK:
        	            			{
        	            				alt50=1;
        	            			}
        	            		    break;
        	            		case AS_TOK:
        	            			{
        	            				alt50=2;
        	            			}
        	            		    break;

        	            		default:
        	            		    CONSTRUCTEX();
        	            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	            		    EXCEPTION->message      = (void *)"";
        	            		    EXCEPTION->decisionNum  = 50;
        	            		    EXCEPTION->state        = 1;


        	            		    goto ruletermEx;

        	            		}

        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 50;
        	                EXCEPTION->state        = 0;


        	                goto ruletermEx;

        	            }

        	            switch (alt50)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:1970:7: indexedFunctionName[op, kind] termList[args,expr] RPAREN_TOK
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_indexedFunctionName_in_term3787);
        	        	        indexedFunctionName(ctx, op, kind);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_termList_in_term3790);
        	        	        termList(ctx, args, expr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermEx;
        	        	        }


        	        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_term3793);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermEx;
        	        	        }


        	        	        {
        	        	             
        	        	                    if( kind!=kind::NULL_EXPR ){
        	        	                      expr = MK_EXPR( kind, op, args );
        	        	                    }else{
        	        	                      expr = MK_EXPR(op, args);
        	        	                    }
        	        	                    PARSER_STATE->checkOperator(expr.getKind(), args.size());
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/smt2/Smt2.g:1980:7: LPAREN_TOK AS_TOK CONST_TOK sortSymbol[type, CHECK_DECLARED] RPAREN_TOK term[f, f2] RPAREN_TOK
        	        	    {
        	        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_term3817);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermEx;
        	        	        }


        	        	         MATCHT(AS_TOK, &FOLLOW_AS_TOK_in_term3819);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermEx;
        	        	        }


        	        	         MATCHT(CONST_TOK, &FOLLOW_CONST_TOK_in_term3821);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_term3823);
        	        	        sortSymbol(ctx, type, CHECK_DECLARED);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermEx;
        	        	        }


        	        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_term3832);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_term_in_term3834);
        	        	        term(ctx, f, f2);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermEx;
        	        	        }


        	        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_term3837);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermEx;
        	        	        }


        	        	        {

        	        	                    if(!type.isArray()) {
        	        	                      std::stringstream ss;
        	        	                      ss << "expected array constant term, but cast is not of array type"
        	        	                         << std::endl
        	        	                         << "cast type: " << type;
        	        	                      PARSER_STATE->parseError(ss.str());
        	        	                    }
        	        	                    if(!f.isConst()) {
        	        	                      std::stringstream ss;
        	        	                      ss << "expected constant term inside array constant, but found "
        	        	                         << "nonconstant term:" << std::endl
        	        	                         << "the term: " << f;
        	        	                      PARSER_STATE->parseError(ss.str());
        	        	                    }
        	        	                    if(!ArrayType(type).getConstituentType().isComparableTo(f.getType())) {
        	        	                      std::stringstream ss;
        	        	                      ss << "type mismatch inside array constant term:" << std::endl
        	        	                         << "array type:          " << type << std::endl
        	        	                         << "expected const type: " << ArrayType(type).getConstituentType()
        	        	                         << std::endl
        	        	                         << "computed const type: " << f.getType();
        	        	                      PARSER_STATE->parseError(ss.str());
        	        	                    }
        	        	                    expr = MK_CONST( ::CVC4::ArrayStoreAll(type, f) );
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 6:
        	    // ../../../../src/parser/smt2/Smt2.g:2010:5: LPAREN_TOK LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] ( term[expr, f2] | sortSymbol[type,CHECK_DECLARED] term[expr, f2] ) RPAREN_TOK )+ RPAREN_TOK term[expr, f2] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_term3863);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	         MATCHT(LET_TOK, &FOLLOW_LET_TOK_in_term3865);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_term3867);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {
        	             PARSER_STATE->pushScope(true); 
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:2012:5: ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] ( term[expr, f2] | sortSymbol[type,CHECK_DECLARED] term[expr, f2] ) RPAREN_TOK )+
        	        {
        	            int cnt52=0;

        	            for (;;)
        	            {
        	                int alt52=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case LPAREN_TOK:
        	        		{
        	        			alt52=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt52)
        	        	{
        	        	    case 1:
        	        	        // ../../../../src/parser/smt2/Smt2.g:2012:7: LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] ( term[expr, f2] | sortSymbol[type,CHECK_DECLARED] term[expr, f2] ) RPAREN_TOK
        	        	        {
        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_term3881);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermEx;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_symbol_in_term3883);
        	        	            symbol(ctx, name, CHECK_NONE, SYM_VARIABLE);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermEx;
        	        	            }


        	        	            // ../../../../src/parser/smt2/Smt2.g:2013:7: ( term[expr, f2] | sortSymbol[type,CHECK_DECLARED] term[expr, f2] )
        	        	            {
        	        	                int alt51=2;
        	        	                switch ( LA(1) )
        	        	                {
        	        	                case LPAREN_TOK:
        	        	                	{
        	        	                		switch ( LA(2) )
        	        	                		{
        	        	                		case AND_TOK:
        	        	                		case AS_TOK:
        	        	                		case ATTRIBUTE_TOK:
        	        	                		case BV2NAT_TOK:
        	        	                		case DISTINCT_TOK:
        	        	                		case DIV_TOK:
        	        	                		case DTSIZE_TOK:
        	        	                		case EQUAL_TOK:
        	        	                		case EXISTS_TOK:
        	        	                		case FMFCARDVAL_TOK:
        	        	                		case FMFCARD_TOK:
        	        	                		case FORALL_TOK:
        	        	                		case GREATER_THAN_EQUAL_TOK:
        	        	                		case GREATER_THAN_TOK:
        	        	                		case IMPLIES_TOK:
        	        	                		case INST_CLOSURE_TOK:
        	        	                		case ITE_TOK:
        	        	                		case LESS_THAN_EQUAL_TOK:
        	        	                		case LESS_THAN_TOK:
        	        	                		case LET_TOK:
        	        	                		case LPAREN_TOK:
        	        	                		case MATCH_TOK:
        	        	                		case MINUS_TOK:
        	        	                		case NOT_TOK:
        	        	                		case OR_TOK:
        	        	                		case PLUS_TOK:
        	        	                		case STAR_TOK:
        	        	                		case XOR_TOK:
        	        	                			{
        	        	                				alt51=1;
        	        	                			}
        	        	                		    break;
        	        	                		case INDEX_TOK:
        	        	                			{
        	        	                				alt51=1;
        	        	                			}
        	        	                		    break;
        	        	                		case SIMPLE_SYMBOL:
        	        	                			{
        	        	                				alt51=1;
        	        	                			}
        	        	                		    break;
        	        	                		case 154:
        	        	                			{
        	        	                				alt51=1;
        	        	                			}
        	        	                		    break;
        	        	                		case SET_OPTIONS_TOK:
        	        	                			{
        	        	                				alt51=1;
        	        	                			}
        	        	                		    break;
        	        	                		case DECLARE_VAR_TOK:
        	        	                			{
        	        	                				alt51=1;
        	        	                			}
        	        	                		    break;
        	        	                		case DECLARE_PRIMED_VAR_TOK:
        	        	                			{
        	        	                				alt51=1;
        	        	                			}
        	        	                		    break;
        	        	                		case SYNTH_FUN_TOK:
        	        	                			{
        	        	                				alt51=1;
        	        	                			}
        	        	                		    break;
        	        	                		case SYNTH_INV_TOK:
        	        	                			{
        	        	                				alt51=1;
        	        	                			}
        	        	                		    break;
        	        	                		case CONSTRAINT_TOK:
        	        	                			{
        	        	                				alt51=1;
        	        	                			}
        	        	                		    break;
        	        	                		case INV_CONSTRAINT_TOK:
        	        	                			{
        	        	                				alt51=1;
        	        	                			}
        	        	                		    break;
        	        	                		case CHECK_SYNTH_TOK:
        	        	                			{
        	        	                				alt51=1;
        	        	                			}
        	        	                		    break;
        	        	                		case QUOTED_SYMBOL:
        	        	                			{
        	        	                				alt51=1;
        	        	                			}
        	        	                		    break;
        	        	                		case UNTERMINATED_QUOTED_SYMBOL:
        	        	                			{
        	        	                				alt51=1;
        	        	                			}
        	        	                		    break;

        	        	                		default:
        	        	                		    CONSTRUCTEX();
        	        	                		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                		    EXCEPTION->message      = (void *)"";
        	        	                		    EXCEPTION->decisionNum  = 51;
        	        	                		    EXCEPTION->state        = 1;


        	        	                		    goto ruletermEx;

        	        	                		}

        	        	                	}
        	        	                    break;
        	        	                case SIMPLE_SYMBOL:
        	        	                	{
        	        	                		switch ( LA(2) )
        	        	                		{
        	        	                		case RPAREN_TOK:
        	        	                		case SYGUS_ENUM_CONS_TOK:
        	        	                			{
        	        	                				alt51=1;
        	        	                			}
        	        	                		    break;
        	        	                		case BINARY_LITERAL:
        	        	                		case CHECK_SYNTH_TOK:
        	        	                		case CONSTRAINT_TOK:
        	        	                		case DECIMAL_LITERAL:
        	        	                		case DECLARE_PRIMED_VAR_TOK:
        	        	                		case DECLARE_VAR_TOK:
        	        	                		case EMPTYSET_TOK:
        	        	                		case FP_RNA_FULL_TOK:
        	        	                		case FP_RNA_TOK:
        	        	                		case FP_RNE_FULL_TOK:
        	        	                		case FP_RNE_TOK:
        	        	                		case FP_RTN_FULL_TOK:
        	        	                		case FP_RTN_TOK:
        	        	                		case FP_RTP_FULL_TOK:
        	        	                		case FP_RTP_TOK:
        	        	                		case FP_RTZ_FULL_TOK:
        	        	                		case FP_RTZ_TOK:
        	        	                		case HEX_LITERAL:
        	        	                		case INTEGER_LITERAL:
        	        	                		case INV_CONSTRAINT_TOK:
        	        	                		case LPAREN_TOK:
        	        	                		case NILREF_TOK:
        	        	                		case QUOTED_SYMBOL:
        	        	                		case REALLCHAR_TOK:
        	        	                		case RENOSTR_TOK:
        	        	                		case SET_OPTIONS_TOK:
        	        	                		case SIMPLE_SYMBOL:
        	        	                		case STRING_LITERAL_2_0:
        	        	                		case STRING_LITERAL_2_5:
        	        	                		case SYNTH_FUN_TOK:
        	        	                		case SYNTH_INV_TOK:
        	        	                		case UNIVSET_TOK:
        	        	                		case UNTERMINATED_QUOTED_SYMBOL:
        	        	                		case 154:
        	        	                			{
        	        	                				alt51=2;
        	        	                			}
        	        	                		    break;

        	        	                		default:
        	        	                		    CONSTRUCTEX();
        	        	                		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                		    EXCEPTION->message      = (void *)"";
        	        	                		    EXCEPTION->decisionNum  = 51;
        	        	                		    EXCEPTION->state        = 2;


        	        	                		    goto ruletermEx;

        	        	                		}

        	        	                	}
        	        	                    break;
        	        	                case 154:
        	        	                	{
        	        	                		switch ( LA(2) )
        	        	                		{
        	        	                		case RPAREN_TOK:
        	        	                		case SYGUS_ENUM_CONS_TOK:
        	        	                			{
        	        	                				alt51=1;
        	        	                			}
        	        	                		    break;
        	        	                		case BINARY_LITERAL:
        	        	                		case CHECK_SYNTH_TOK:
        	        	                		case CONSTRAINT_TOK:
        	        	                		case DECIMAL_LITERAL:
        	        	                		case DECLARE_PRIMED_VAR_TOK:
        	        	                		case DECLARE_VAR_TOK:
        	        	                		case EMPTYSET_TOK:
        	        	                		case FP_RNA_FULL_TOK:
        	        	                		case FP_RNA_TOK:
        	        	                		case FP_RNE_FULL_TOK:
        	        	                		case FP_RNE_TOK:
        	        	                		case FP_RTN_FULL_TOK:
        	        	                		case FP_RTN_TOK:
        	        	                		case FP_RTP_FULL_TOK:
        	        	                		case FP_RTP_TOK:
        	        	                		case FP_RTZ_FULL_TOK:
        	        	                		case FP_RTZ_TOK:
        	        	                		case HEX_LITERAL:
        	        	                		case INTEGER_LITERAL:
        	        	                		case INV_CONSTRAINT_TOK:
        	        	                		case LPAREN_TOK:
        	        	                		case NILREF_TOK:
        	        	                		case QUOTED_SYMBOL:
        	        	                		case REALLCHAR_TOK:
        	        	                		case RENOSTR_TOK:
        	        	                		case SET_OPTIONS_TOK:
        	        	                		case SIMPLE_SYMBOL:
        	        	                		case STRING_LITERAL_2_0:
        	        	                		case STRING_LITERAL_2_5:
        	        	                		case SYNTH_FUN_TOK:
        	        	                		case SYNTH_INV_TOK:
        	        	                		case UNIVSET_TOK:
        	        	                		case UNTERMINATED_QUOTED_SYMBOL:
        	        	                		case 154:
        	        	                			{
        	        	                				alt51=2;
        	        	                			}
        	        	                		    break;

        	        	                		default:
        	        	                		    CONSTRUCTEX();
        	        	                		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                		    EXCEPTION->message      = (void *)"";
        	        	                		    EXCEPTION->decisionNum  = 51;
        	        	                		    EXCEPTION->state        = 3;


        	        	                		    goto ruletermEx;

        	        	                		}

        	        	                	}
        	        	                    break;
        	        	                case SET_OPTIONS_TOK:
        	        	                	{
        	        	                		switch ( LA(2) )
        	        	                		{
        	        	                		case RPAREN_TOK:
        	        	                		case SYGUS_ENUM_CONS_TOK:
        	        	                			{
        	        	                				alt51=1;
        	        	                			}
        	        	                		    break;
        	        	                		case BINARY_LITERAL:
        	        	                		case CHECK_SYNTH_TOK:
        	        	                		case CONSTRAINT_TOK:
        	        	                		case DECIMAL_LITERAL:
        	        	                		case DECLARE_PRIMED_VAR_TOK:
        	        	                		case DECLARE_VAR_TOK:
        	        	                		case EMPTYSET_TOK:
        	        	                		case FP_RNA_FULL_TOK:
        	        	                		case FP_RNA_TOK:
        	        	                		case FP_RNE_FULL_TOK:
        	        	                		case FP_RNE_TOK:
        	        	                		case FP_RTN_FULL_TOK:
        	        	                		case FP_RTN_TOK:
        	        	                		case FP_RTP_FULL_TOK:
        	        	                		case FP_RTP_TOK:
        	        	                		case FP_RTZ_FULL_TOK:
        	        	                		case FP_RTZ_TOK:
        	        	                		case HEX_LITERAL:
        	        	                		case INTEGER_LITERAL:
        	        	                		case INV_CONSTRAINT_TOK:
        	        	                		case LPAREN_TOK:
        	        	                		case NILREF_TOK:
        	        	                		case QUOTED_SYMBOL:
        	        	                		case REALLCHAR_TOK:
        	        	                		case RENOSTR_TOK:
        	        	                		case SET_OPTIONS_TOK:
        	        	                		case SIMPLE_SYMBOL:
        	        	                		case STRING_LITERAL_2_0:
        	        	                		case STRING_LITERAL_2_5:
        	        	                		case SYNTH_FUN_TOK:
        	        	                		case SYNTH_INV_TOK:
        	        	                		case UNIVSET_TOK:
        	        	                		case UNTERMINATED_QUOTED_SYMBOL:
        	        	                		case 154:
        	        	                			{
        	        	                				alt51=2;
        	        	                			}
        	        	                		    break;

        	        	                		default:
        	        	                		    CONSTRUCTEX();
        	        	                		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                		    EXCEPTION->message      = (void *)"";
        	        	                		    EXCEPTION->decisionNum  = 51;
        	        	                		    EXCEPTION->state        = 4;


        	        	                		    goto ruletermEx;

        	        	                		}

        	        	                	}
        	        	                    break;
        	        	                case DECLARE_VAR_TOK:
        	        	                	{
        	        	                		switch ( LA(2) )
        	        	                		{
        	        	                		case RPAREN_TOK:
        	        	                		case SYGUS_ENUM_CONS_TOK:
        	        	                			{
        	        	                				alt51=1;
        	        	                			}
        	        	                		    break;
        	        	                		case BINARY_LITERAL:
        	        	                		case CHECK_SYNTH_TOK:
        	        	                		case CONSTRAINT_TOK:
        	        	                		case DECIMAL_LITERAL:
        	        	                		case DECLARE_PRIMED_VAR_TOK:
        	        	                		case DECLARE_VAR_TOK:
        	        	                		case EMPTYSET_TOK:
        	        	                		case FP_RNA_FULL_TOK:
        	        	                		case FP_RNA_TOK:
        	        	                		case FP_RNE_FULL_TOK:
        	        	                		case FP_RNE_TOK:
        	        	                		case FP_RTN_FULL_TOK:
        	        	                		case FP_RTN_TOK:
        	        	                		case FP_RTP_FULL_TOK:
        	        	                		case FP_RTP_TOK:
        	        	                		case FP_RTZ_FULL_TOK:
        	        	                		case FP_RTZ_TOK:
        	        	                		case HEX_LITERAL:
        	        	                		case INTEGER_LITERAL:
        	        	                		case INV_CONSTRAINT_TOK:
        	        	                		case LPAREN_TOK:
        	        	                		case NILREF_TOK:
        	        	                		case QUOTED_SYMBOL:
        	        	                		case REALLCHAR_TOK:
        	        	                		case RENOSTR_TOK:
        	        	                		case SET_OPTIONS_TOK:
        	        	                		case SIMPLE_SYMBOL:
        	        	                		case STRING_LITERAL_2_0:
        	        	                		case STRING_LITERAL_2_5:
        	        	                		case SYNTH_FUN_TOK:
        	        	                		case SYNTH_INV_TOK:
        	        	                		case UNIVSET_TOK:
        	        	                		case UNTERMINATED_QUOTED_SYMBOL:
        	        	                		case 154:
        	        	                			{
        	        	                				alt51=2;
        	        	                			}
        	        	                		    break;

        	        	                		default:
        	        	                		    CONSTRUCTEX();
        	        	                		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                		    EXCEPTION->message      = (void *)"";
        	        	                		    EXCEPTION->decisionNum  = 51;
        	        	                		    EXCEPTION->state        = 5;


        	        	                		    goto ruletermEx;

        	        	                		}

        	        	                	}
        	        	                    break;
        	        	                case DECLARE_PRIMED_VAR_TOK:
        	        	                	{
        	        	                		switch ( LA(2) )
        	        	                		{
        	        	                		case RPAREN_TOK:
        	        	                		case SYGUS_ENUM_CONS_TOK:
        	        	                			{
        	        	                				alt51=1;
        	        	                			}
        	        	                		    break;
        	        	                		case BINARY_LITERAL:
        	        	                		case CHECK_SYNTH_TOK:
        	        	                		case CONSTRAINT_TOK:
        	        	                		case DECIMAL_LITERAL:
        	        	                		case DECLARE_PRIMED_VAR_TOK:
        	        	                		case DECLARE_VAR_TOK:
        	        	                		case EMPTYSET_TOK:
        	        	                		case FP_RNA_FULL_TOK:
        	        	                		case FP_RNA_TOK:
        	        	                		case FP_RNE_FULL_TOK:
        	        	                		case FP_RNE_TOK:
        	        	                		case FP_RTN_FULL_TOK:
        	        	                		case FP_RTN_TOK:
        	        	                		case FP_RTP_FULL_TOK:
        	        	                		case FP_RTP_TOK:
        	        	                		case FP_RTZ_FULL_TOK:
        	        	                		case FP_RTZ_TOK:
        	        	                		case HEX_LITERAL:
        	        	                		case INTEGER_LITERAL:
        	        	                		case INV_CONSTRAINT_TOK:
        	        	                		case LPAREN_TOK:
        	        	                		case NILREF_TOK:
        	        	                		case QUOTED_SYMBOL:
        	        	                		case REALLCHAR_TOK:
        	        	                		case RENOSTR_TOK:
        	        	                		case SET_OPTIONS_TOK:
        	        	                		case SIMPLE_SYMBOL:
        	        	                		case STRING_LITERAL_2_0:
        	        	                		case STRING_LITERAL_2_5:
        	        	                		case SYNTH_FUN_TOK:
        	        	                		case SYNTH_INV_TOK:
        	        	                		case UNIVSET_TOK:
        	        	                		case UNTERMINATED_QUOTED_SYMBOL:
        	        	                		case 154:
        	        	                			{
        	        	                				alt51=2;
        	        	                			}
        	        	                		    break;

        	        	                		default:
        	        	                		    CONSTRUCTEX();
        	        	                		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                		    EXCEPTION->message      = (void *)"";
        	        	                		    EXCEPTION->decisionNum  = 51;
        	        	                		    EXCEPTION->state        = 6;


        	        	                		    goto ruletermEx;

        	        	                		}

        	        	                	}
        	        	                    break;
        	        	                case SYNTH_FUN_TOK:
        	        	                	{
        	        	                		switch ( LA(2) )
        	        	                		{
        	        	                		case RPAREN_TOK:
        	        	                		case SYGUS_ENUM_CONS_TOK:
        	        	                			{
        	        	                				alt51=1;
        	        	                			}
        	        	                		    break;
        	        	                		case BINARY_LITERAL:
        	        	                		case CHECK_SYNTH_TOK:
        	        	                		case CONSTRAINT_TOK:
        	        	                		case DECIMAL_LITERAL:
        	        	                		case DECLARE_PRIMED_VAR_TOK:
        	        	                		case DECLARE_VAR_TOK:
        	        	                		case EMPTYSET_TOK:
        	        	                		case FP_RNA_FULL_TOK:
        	        	                		case FP_RNA_TOK:
        	        	                		case FP_RNE_FULL_TOK:
        	        	                		case FP_RNE_TOK:
        	        	                		case FP_RTN_FULL_TOK:
        	        	                		case FP_RTN_TOK:
        	        	                		case FP_RTP_FULL_TOK:
        	        	                		case FP_RTP_TOK:
        	        	                		case FP_RTZ_FULL_TOK:
        	        	                		case FP_RTZ_TOK:
        	        	                		case HEX_LITERAL:
        	        	                		case INTEGER_LITERAL:
        	        	                		case INV_CONSTRAINT_TOK:
        	        	                		case LPAREN_TOK:
        	        	                		case NILREF_TOK:
        	        	                		case QUOTED_SYMBOL:
        	        	                		case REALLCHAR_TOK:
        	        	                		case RENOSTR_TOK:
        	        	                		case SET_OPTIONS_TOK:
        	        	                		case SIMPLE_SYMBOL:
        	        	                		case STRING_LITERAL_2_0:
        	        	                		case STRING_LITERAL_2_5:
        	        	                		case SYNTH_FUN_TOK:
        	        	                		case SYNTH_INV_TOK:
        	        	                		case UNIVSET_TOK:
        	        	                		case UNTERMINATED_QUOTED_SYMBOL:
        	        	                		case 154:
        	        	                			{
        	        	                				alt51=2;
        	        	                			}
        	        	                		    break;

        	        	                		default:
        	        	                		    CONSTRUCTEX();
        	        	                		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                		    EXCEPTION->message      = (void *)"";
        	        	                		    EXCEPTION->decisionNum  = 51;
        	        	                		    EXCEPTION->state        = 7;


        	        	                		    goto ruletermEx;

        	        	                		}

        	        	                	}
        	        	                    break;
        	        	                case SYNTH_INV_TOK:
        	        	                	{
        	        	                		switch ( LA(2) )
        	        	                		{
        	        	                		case RPAREN_TOK:
        	        	                		case SYGUS_ENUM_CONS_TOK:
        	        	                			{
        	        	                				alt51=1;
        	        	                			}
        	        	                		    break;
        	        	                		case BINARY_LITERAL:
        	        	                		case CHECK_SYNTH_TOK:
        	        	                		case CONSTRAINT_TOK:
        	        	                		case DECIMAL_LITERAL:
        	        	                		case DECLARE_PRIMED_VAR_TOK:
        	        	                		case DECLARE_VAR_TOK:
        	        	                		case EMPTYSET_TOK:
        	        	                		case FP_RNA_FULL_TOK:
        	        	                		case FP_RNA_TOK:
        	        	                		case FP_RNE_FULL_TOK:
        	        	                		case FP_RNE_TOK:
        	        	                		case FP_RTN_FULL_TOK:
        	        	                		case FP_RTN_TOK:
        	        	                		case FP_RTP_FULL_TOK:
        	        	                		case FP_RTP_TOK:
        	        	                		case FP_RTZ_FULL_TOK:
        	        	                		case FP_RTZ_TOK:
        	        	                		case HEX_LITERAL:
        	        	                		case INTEGER_LITERAL:
        	        	                		case INV_CONSTRAINT_TOK:
        	        	                		case LPAREN_TOK:
        	        	                		case NILREF_TOK:
        	        	                		case QUOTED_SYMBOL:
        	        	                		case REALLCHAR_TOK:
        	        	                		case RENOSTR_TOK:
        	        	                		case SET_OPTIONS_TOK:
        	        	                		case SIMPLE_SYMBOL:
        	        	                		case STRING_LITERAL_2_0:
        	        	                		case STRING_LITERAL_2_5:
        	        	                		case SYNTH_FUN_TOK:
        	        	                		case SYNTH_INV_TOK:
        	        	                		case UNIVSET_TOK:
        	        	                		case UNTERMINATED_QUOTED_SYMBOL:
        	        	                		case 154:
        	        	                			{
        	        	                				alt51=2;
        	        	                			}
        	        	                		    break;

        	        	                		default:
        	        	                		    CONSTRUCTEX();
        	        	                		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                		    EXCEPTION->message      = (void *)"";
        	        	                		    EXCEPTION->decisionNum  = 51;
        	        	                		    EXCEPTION->state        = 8;


        	        	                		    goto ruletermEx;

        	        	                		}

        	        	                	}
        	        	                    break;
        	        	                case CONSTRAINT_TOK:
        	        	                	{
        	        	                		switch ( LA(2) )
        	        	                		{
        	        	                		case RPAREN_TOK:
        	        	                		case SYGUS_ENUM_CONS_TOK:
        	        	                			{
        	        	                				alt51=1;
        	        	                			}
        	        	                		    break;
        	        	                		case BINARY_LITERAL:
        	        	                		case CHECK_SYNTH_TOK:
        	        	                		case CONSTRAINT_TOK:
        	        	                		case DECIMAL_LITERAL:
        	        	                		case DECLARE_PRIMED_VAR_TOK:
        	        	                		case DECLARE_VAR_TOK:
        	        	                		case EMPTYSET_TOK:
        	        	                		case FP_RNA_FULL_TOK:
        	        	                		case FP_RNA_TOK:
        	        	                		case FP_RNE_FULL_TOK:
        	        	                		case FP_RNE_TOK:
        	        	                		case FP_RTN_FULL_TOK:
        	        	                		case FP_RTN_TOK:
        	        	                		case FP_RTP_FULL_TOK:
        	        	                		case FP_RTP_TOK:
        	        	                		case FP_RTZ_FULL_TOK:
        	        	                		case FP_RTZ_TOK:
        	        	                		case HEX_LITERAL:
        	        	                		case INTEGER_LITERAL:
        	        	                		case INV_CONSTRAINT_TOK:
        	        	                		case LPAREN_TOK:
        	        	                		case NILREF_TOK:
        	        	                		case QUOTED_SYMBOL:
        	        	                		case REALLCHAR_TOK:
        	        	                		case RENOSTR_TOK:
        	        	                		case SET_OPTIONS_TOK:
        	        	                		case SIMPLE_SYMBOL:
        	        	                		case STRING_LITERAL_2_0:
        	        	                		case STRING_LITERAL_2_5:
        	        	                		case SYNTH_FUN_TOK:
        	        	                		case SYNTH_INV_TOK:
        	        	                		case UNIVSET_TOK:
        	        	                		case UNTERMINATED_QUOTED_SYMBOL:
        	        	                		case 154:
        	        	                			{
        	        	                				alt51=2;
        	        	                			}
        	        	                		    break;

        	        	                		default:
        	        	                		    CONSTRUCTEX();
        	        	                		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                		    EXCEPTION->message      = (void *)"";
        	        	                		    EXCEPTION->decisionNum  = 51;
        	        	                		    EXCEPTION->state        = 9;


        	        	                		    goto ruletermEx;

        	        	                		}

        	        	                	}
        	        	                    break;
        	        	                case INV_CONSTRAINT_TOK:
        	        	                	{
        	        	                		switch ( LA(2) )
        	        	                		{
        	        	                		case RPAREN_TOK:
        	        	                		case SYGUS_ENUM_CONS_TOK:
        	        	                			{
        	        	                				alt51=1;
        	        	                			}
        	        	                		    break;
        	        	                		case BINARY_LITERAL:
        	        	                		case CHECK_SYNTH_TOK:
        	        	                		case CONSTRAINT_TOK:
        	        	                		case DECIMAL_LITERAL:
        	        	                		case DECLARE_PRIMED_VAR_TOK:
        	        	                		case DECLARE_VAR_TOK:
        	        	                		case EMPTYSET_TOK:
        	        	                		case FP_RNA_FULL_TOK:
        	        	                		case FP_RNA_TOK:
        	        	                		case FP_RNE_FULL_TOK:
        	        	                		case FP_RNE_TOK:
        	        	                		case FP_RTN_FULL_TOK:
        	        	                		case FP_RTN_TOK:
        	        	                		case FP_RTP_FULL_TOK:
        	        	                		case FP_RTP_TOK:
        	        	                		case FP_RTZ_FULL_TOK:
        	        	                		case FP_RTZ_TOK:
        	        	                		case HEX_LITERAL:
        	        	                		case INTEGER_LITERAL:
        	        	                		case INV_CONSTRAINT_TOK:
        	        	                		case LPAREN_TOK:
        	        	                		case NILREF_TOK:
        	        	                		case QUOTED_SYMBOL:
        	        	                		case REALLCHAR_TOK:
        	        	                		case RENOSTR_TOK:
        	        	                		case SET_OPTIONS_TOK:
        	        	                		case SIMPLE_SYMBOL:
        	        	                		case STRING_LITERAL_2_0:
        	        	                		case STRING_LITERAL_2_5:
        	        	                		case SYNTH_FUN_TOK:
        	        	                		case SYNTH_INV_TOK:
        	        	                		case UNIVSET_TOK:
        	        	                		case UNTERMINATED_QUOTED_SYMBOL:
        	        	                		case 154:
        	        	                			{
        	        	                				alt51=2;
        	        	                			}
        	        	                		    break;

        	        	                		default:
        	        	                		    CONSTRUCTEX();
        	        	                		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                		    EXCEPTION->message      = (void *)"";
        	        	                		    EXCEPTION->decisionNum  = 51;
        	        	                		    EXCEPTION->state        = 10;


        	        	                		    goto ruletermEx;

        	        	                		}

        	        	                	}
        	        	                    break;
        	        	                case CHECK_SYNTH_TOK:
        	        	                	{
        	        	                		switch ( LA(2) )
        	        	                		{
        	        	                		case RPAREN_TOK:
        	        	                		case SYGUS_ENUM_CONS_TOK:
        	        	                			{
        	        	                				alt51=1;
        	        	                			}
        	        	                		    break;
        	        	                		case BINARY_LITERAL:
        	        	                		case CHECK_SYNTH_TOK:
        	        	                		case CONSTRAINT_TOK:
        	        	                		case DECIMAL_LITERAL:
        	        	                		case DECLARE_PRIMED_VAR_TOK:
        	        	                		case DECLARE_VAR_TOK:
        	        	                		case EMPTYSET_TOK:
        	        	                		case FP_RNA_FULL_TOK:
        	        	                		case FP_RNA_TOK:
        	        	                		case FP_RNE_FULL_TOK:
        	        	                		case FP_RNE_TOK:
        	        	                		case FP_RTN_FULL_TOK:
        	        	                		case FP_RTN_TOK:
        	        	                		case FP_RTP_FULL_TOK:
        	        	                		case FP_RTP_TOK:
        	        	                		case FP_RTZ_FULL_TOK:
        	        	                		case FP_RTZ_TOK:
        	        	                		case HEX_LITERAL:
        	        	                		case INTEGER_LITERAL:
        	        	                		case INV_CONSTRAINT_TOK:
        	        	                		case LPAREN_TOK:
        	        	                		case NILREF_TOK:
        	        	                		case QUOTED_SYMBOL:
        	        	                		case REALLCHAR_TOK:
        	        	                		case RENOSTR_TOK:
        	        	                		case SET_OPTIONS_TOK:
        	        	                		case SIMPLE_SYMBOL:
        	        	                		case STRING_LITERAL_2_0:
        	        	                		case STRING_LITERAL_2_5:
        	        	                		case SYNTH_FUN_TOK:
        	        	                		case SYNTH_INV_TOK:
        	        	                		case UNIVSET_TOK:
        	        	                		case UNTERMINATED_QUOTED_SYMBOL:
        	        	                		case 154:
        	        	                			{
        	        	                				alt51=2;
        	        	                			}
        	        	                		    break;

        	        	                		default:
        	        	                		    CONSTRUCTEX();
        	        	                		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                		    EXCEPTION->message      = (void *)"";
        	        	                		    EXCEPTION->decisionNum  = 51;
        	        	                		    EXCEPTION->state        = 11;


        	        	                		    goto ruletermEx;

        	        	                		}

        	        	                	}
        	        	                    break;
        	        	                case QUOTED_SYMBOL:
        	        	                	{
        	        	                		switch ( LA(2) )
        	        	                		{
        	        	                		case RPAREN_TOK:
        	        	                		case SYGUS_ENUM_CONS_TOK:
        	        	                			{
        	        	                				alt51=1;
        	        	                			}
        	        	                		    break;
        	        	                		case BINARY_LITERAL:
        	        	                		case CHECK_SYNTH_TOK:
        	        	                		case CONSTRAINT_TOK:
        	        	                		case DECIMAL_LITERAL:
        	        	                		case DECLARE_PRIMED_VAR_TOK:
        	        	                		case DECLARE_VAR_TOK:
        	        	                		case EMPTYSET_TOK:
        	        	                		case FP_RNA_FULL_TOK:
        	        	                		case FP_RNA_TOK:
        	        	                		case FP_RNE_FULL_TOK:
        	        	                		case FP_RNE_TOK:
        	        	                		case FP_RTN_FULL_TOK:
        	        	                		case FP_RTN_TOK:
        	        	                		case FP_RTP_FULL_TOK:
        	        	                		case FP_RTP_TOK:
        	        	                		case FP_RTZ_FULL_TOK:
        	        	                		case FP_RTZ_TOK:
        	        	                		case HEX_LITERAL:
        	        	                		case INTEGER_LITERAL:
        	        	                		case INV_CONSTRAINT_TOK:
        	        	                		case LPAREN_TOK:
        	        	                		case NILREF_TOK:
        	        	                		case QUOTED_SYMBOL:
        	        	                		case REALLCHAR_TOK:
        	        	                		case RENOSTR_TOK:
        	        	                		case SET_OPTIONS_TOK:
        	        	                		case SIMPLE_SYMBOL:
        	        	                		case STRING_LITERAL_2_0:
        	        	                		case STRING_LITERAL_2_5:
        	        	                		case SYNTH_FUN_TOK:
        	        	                		case SYNTH_INV_TOK:
        	        	                		case UNIVSET_TOK:
        	        	                		case UNTERMINATED_QUOTED_SYMBOL:
        	        	                		case 154:
        	        	                			{
        	        	                				alt51=2;
        	        	                			}
        	        	                		    break;

        	        	                		default:
        	        	                		    CONSTRUCTEX();
        	        	                		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                		    EXCEPTION->message      = (void *)"";
        	        	                		    EXCEPTION->decisionNum  = 51;
        	        	                		    EXCEPTION->state        = 12;


        	        	                		    goto ruletermEx;

        	        	                		}

        	        	                	}
        	        	                    break;
        	        	                case UNTERMINATED_QUOTED_SYMBOL:
        	        	                	{
        	        	                		switch ( LA(2) )
        	        	                		{
        	        	                		case EOF:
        	        	                			{
        	        	                				alt51=1;
        	        	                			}
        	        	                		    break;
        	        	                		case 152:
        	        	                			{
        	        	                				alt51=1;
        	        	                			}
        	        	                		    break;

        	        	                		default:
        	        	                		    CONSTRUCTEX();
        	        	                		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                		    EXCEPTION->message      = (void *)"";
        	        	                		    EXCEPTION->decisionNum  = 51;
        	        	                		    EXCEPTION->state        = 13;


        	        	                		    goto ruletermEx;

        	        	                		}

        	        	                	}
        	        	                    break;
        	        	                case BINARY_LITERAL:
        	        	                case DECIMAL_LITERAL:
        	        	                case EMPTYSET_TOK:
        	        	                case FP_RNA_FULL_TOK:
        	        	                case FP_RNA_TOK:
        	        	                case FP_RNE_FULL_TOK:
        	        	                case FP_RNE_TOK:
        	        	                case FP_RTN_FULL_TOK:
        	        	                case FP_RTN_TOK:
        	        	                case FP_RTP_FULL_TOK:
        	        	                case FP_RTP_TOK:
        	        	                case FP_RTZ_FULL_TOK:
        	        	                case FP_RTZ_TOK:
        	        	                case HEX_LITERAL:
        	        	                case INTEGER_LITERAL:
        	        	                case NILREF_TOK:
        	        	                case REALLCHAR_TOK:
        	        	                case RENOSTR_TOK:
        	        	                case STRING_LITERAL_2_0:
        	        	                case STRING_LITERAL_2_5:
        	        	                case UNIVSET_TOK:
        	        	                	{
        	        	                		alt51=1;
        	        	                	}
        	        	                    break;

        	        	                default:
        	        	                    CONSTRUCTEX();
        	        	                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                    EXCEPTION->message      = (void *)"";
        	        	                    EXCEPTION->decisionNum  = 51;
        	        	                    EXCEPTION->state        = 0;


        	        	                    goto ruletermEx;

        	        	                }

        	        	                switch (alt51)
        	        	                {
        	        	            	case 1:
        	        	            	    // ../../../../src/parser/smt2/Smt2.g:2013:8: term[expr, f2]
        	        	            	    {
        	        	            	        FOLLOWPUSH(FOLLOW_term_in_term3893);
        	        	            	        term(ctx, expr, f2);

        	        	            	        FOLLOWPOP();
        	        	            	        if  (HASEXCEPTION())
        	        	            	        {
        	        	            	            goto ruletermEx;
        	        	            	        }


        	        	            	    }
        	        	            	    break;
        	        	            	case 2:
        	        	            	    // ../../../../src/parser/smt2/Smt2.g:2013:25: sortSymbol[type,CHECK_DECLARED] term[expr, f2]
        	        	            	    {
        	        	            	        FOLLOWPUSH(FOLLOW_sortSymbol_in_term3898);
        	        	            	        sortSymbol(ctx, type, CHECK_DECLARED);

        	        	            	        FOLLOWPOP();
        	        	            	        if  (HASEXCEPTION())
        	        	            	        {
        	        	            	            goto ruletermEx;
        	        	            	        }


        	        	            	        {
        	        	            	             readLetSort = true; 
        	        	            	        }


        	        	            	        FOLLOWPUSH(FOLLOW_term_in_term3910);
        	        	            	        term(ctx, expr, f2);

        	        	            	        FOLLOWPOP();
        	        	            	        if  (HASEXCEPTION())
        	        	            	        {
        	        	            	            goto ruletermEx;
        	        	            	        }


        	        	            	    }
        	        	            	    break;

        	        	                }
        	        	            }

        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_term3927);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermEx;
        	        	            }


        	        	            {
        	        	                 if( !PARSER_STATE->sygus() && readLetSort ){
        	        	                          PARSER_STATE->parseError("Bad syntax for let term.");
        	        	                        }else if(names.count(name) == 1) {
        	        	                          std::stringstream ss;
        	        	                          ss << "warning: symbol `" << name << "' bound multiple times by let;"
        	        	                             << " the last binding will be used, shadowing earlier ones";
        	        	                          PARSER_STATE->warning(ss.str());
        	        	                        } else {
        	        	                          names.insert(name);
        	        	                        }
        	        	                        binders.push_back(std::make_pair(name, expr)); 
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt52 >= 1 )
        	        		{
        	        		    goto loop52;
        	        		}
        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto ruletermEx;
        	        	}
        	        	cnt52++;
        	            }
        	            loop52: ;	/* Jump to here if this rule does not match */
        	        }

        	        {
        	             // now implement these bindings
        	                  for(std::vector< std::pair<std::string, Expr> >::iterator
        	                        i = binders.begin(); i != binders.end(); ++i) {
        	                    PARSER_STATE->defineVar((*i).first, (*i).second);
        	                  }
        	                
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_term3964);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_term3970);
        	        term(ctx, expr, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_term3977);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {
        	             PARSER_STATE->popScope(); 
        	        }


        	    }
        	    break;
        	case 7:
        	    // ../../../../src/parser/smt2/Smt2.g:2041:5: LPAREN_TOK MATCH_TOK term[expr, f2] LPAREN_TOK ( LPAREN_TOK INDEX_TOK term[f, f2] RPAREN_TOK | LPAREN_TOK LPAREN_TOK term[f, f2] ( symbol[name,CHECK_NONE,SYM_VARIABLE] )* RPAREN_TOK term[f3, f2] RPAREN_TOK | LPAREN_TOK symbol[name,CHECK_DECLARED,SYM_VARIABLE] term[f3, f2] RPAREN_TOK )+ RPAREN_TOK RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_term3995);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	         MATCHT(MATCH_TOK, &FOLLOW_MATCH_TOK_in_term3997);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_term3999);
        	        term(ctx, expr, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {

        	                  if( !expr.getType().isDatatype() ){
        	                    PARSER_STATE->parseError("Cannot match on non-datatype term.");
        	                  }
        	                
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_term4008);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:2047:5: ( LPAREN_TOK INDEX_TOK term[f, f2] RPAREN_TOK | LPAREN_TOK LPAREN_TOK term[f, f2] ( symbol[name,CHECK_NONE,SYM_VARIABLE] )* RPAREN_TOK term[f3, f2] RPAREN_TOK | LPAREN_TOK symbol[name,CHECK_DECLARED,SYM_VARIABLE] term[f3, f2] RPAREN_TOK )+
        	        {
        	            int cnt54=0;

        	            for (;;)
        	            {
        	                int alt54=4;
        	        	switch ( LA(1) )
        	        	{
        	        	case LPAREN_TOK:
        	        		{
        	        			switch ( LA(2) )
        	        			{
        	        			case INDEX_TOK:
        	        				{
        	        					alt54=1;
        	        				}
        	        			    break;
        	        			case LPAREN_TOK:
        	        				{
        	        					alt54=2;
        	        				}
        	        			    break;
        	        			case CHECK_SYNTH_TOK:
        	        			case CONSTRAINT_TOK:
        	        			case DECLARE_PRIMED_VAR_TOK:
        	        			case DECLARE_VAR_TOK:
        	        			case INV_CONSTRAINT_TOK:
        	        			case QUOTED_SYMBOL:
        	        			case SET_OPTIONS_TOK:
        	        			case SIMPLE_SYMBOL:
        	        			case SYNTH_FUN_TOK:
        	        			case SYNTH_INV_TOK:
        	        			case UNTERMINATED_QUOTED_SYMBOL:
        	        			case 154:
        	        				{
        	        					alt54=3;
        	        				}
        	        			    break;

        	        			}

        	        		}
        	        	    break;

        	        	}

        	        	switch (alt54)
        	        	{
        	        	    case 1:
        	        	        // ../../../../src/parser/smt2/Smt2.g:2049:8: LPAREN_TOK INDEX_TOK term[f, f2] RPAREN_TOK
        	        	        {
        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_term4032);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermEx;
        	        	            }


        	        	             MATCHT(INDEX_TOK, &FOLLOW_INDEX_TOK_in_term4034);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermEx;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_term_in_term4036);
        	        	            term(ctx, f, f2);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermEx;
        	        	            }


        	        	            {
        	        	                 
        	        	                          if( match_vindex==-1 ){
        	        	                            match_vindex = (int)patexprs.size(); 
        	        	                          }
        	        	                          patexprs.push_back( f ); 
        	        	                          patconds.push_back(MK_CONST(bool(true)));
        	        	                        
        	        	            }


        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_term4049);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermEx;
        	        	            }


        	        	        }
        	        	        break;
        	        	    case 2:
        	        	        // ../../../../src/parser/smt2/Smt2.g:2057:9: LPAREN_TOK LPAREN_TOK term[f, f2] ( symbol[name,CHECK_NONE,SYM_VARIABLE] )* RPAREN_TOK term[f3, f2] RPAREN_TOK
        	        	        {
        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_term4059);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermEx;
        	        	            }


        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_term4061);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermEx;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_term_in_term4063);
        	        	            term(ctx, f, f2);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermEx;
        	        	            }


        	        	            {
        	        	                 
        	        	                           args.clear(); 
        	        	                           PARSER_STATE->pushScope(true); 
        	        	                           //f should be a constructor
        	        	                           type = f.getType();
        	        	                           Debug("parser-dt") << "Pattern head : " << f << " " << f.getType() << std::endl;
        	        	                           if( !type.isConstructor() ){
        	        	                             PARSER_STATE->parseError("Pattern must be application of a constructor or a variable.");
        	        	                           }
        	        	                           if( Datatype::datatypeOf(f).isParametric() ){
        	        	                             type = Datatype::datatypeOf(f)[Datatype::indexOf(f)].getSpecializedConstructorType(expr.getType());
        	        	                           }
        	        	                           match_ptypes = ((ConstructorType)type).getArgTypes();
        	        	                         
        	        	            }


        	        	            // ../../../../src/parser/smt2/Smt2.g:2072:10: ( symbol[name,CHECK_NONE,SYM_VARIABLE] )*

        	        	            for (;;)
        	        	            {
        	        	                int alt53=2;
        	        	                switch ( LA(1) )
        	        	                {
        	        	                case CHECK_SYNTH_TOK:
        	        	                case CONSTRAINT_TOK:
        	        	                case DECLARE_PRIMED_VAR_TOK:
        	        	                case DECLARE_VAR_TOK:
        	        	                case INV_CONSTRAINT_TOK:
        	        	                case QUOTED_SYMBOL:
        	        	                case SET_OPTIONS_TOK:
        	        	                case SIMPLE_SYMBOL:
        	        	                case SYNTH_FUN_TOK:
        	        	                case SYNTH_INV_TOK:
        	        	                case UNTERMINATED_QUOTED_SYMBOL:
        	        	                case 154:
        	        	                	{
        	        	                		alt53=1;
        	        	                	}
        	        	                    break;

        	        	                }

        	        	                switch (alt53)
        	        	                {
        	        	            	case 1:
        	        	            	    // ../../../../src/parser/smt2/Smt2.g:2072:12: symbol[name,CHECK_NONE,SYM_VARIABLE]
        	        	            	    {
        	        	            	        FOLLOWPUSH(FOLLOW_symbol_in_term4089);
        	        	            	        symbol(ctx, name, CHECK_NONE, SYM_VARIABLE);

        	        	            	        FOLLOWPOP();
        	        	            	        if  (HASEXCEPTION())
        	        	            	        {
        	        	            	            goto ruletermEx;
        	        	            	        }


        	        	            	        {

        	        	            	                         if( args.size()>=match_ptypes.size() ){
        	        	            	                           PARSER_STATE->parseError("Too many arguments for pattern.");
        	        	            	                         }
        	        	            	                         //make of proper type
        	        	            	                         Expr arg = PARSER_STATE->mkBoundVar(name, match_ptypes[args.size()]);
        	        	            	                         args.push_back( arg );
        	        	            	                       
        	        	            	        }


        	        	            	    }
        	        	            	    break;

        	        	            	default:
        	        	            	    goto loop53;	/* break out of the loop */
        	        	            	    break;
        	        	                }
        	        	            }
        	        	            loop53: ; /* Jump out to here if this rule does not match */


        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_term4115);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermEx;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_term_in_term4126);
        	        	            term(ctx, f3, f2);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermEx;
        	        	            }


        	        	            {
        	        	                 
        	        	                           const DatatypeConstructor& dtc = Datatype::datatypeOf(f)[Datatype::indexOf(f)];
        	        	                           if( args.size()!=dtc.getNumArgs() ){
        	        	                             PARSER_STATE->parseError("Bad number of arguments for application of constructor in pattern.");
        	        	                           }
        	        	                           // build a lambda
        	        	                           std::vector<Expr> largs;
        	        	                           largs.push_back( MK_EXPR( CVC4::kind::BOUND_VAR_LIST, args ) );
        	        	                           largs.push_back( f3 );
        	        	                           std::vector< Expr > aargs;
        	        	                           aargs.push_back( MK_EXPR( CVC4::kind::LAMBDA, largs ) );
        	        	                           for( unsigned i=0; i<dtc.getNumArgs(); i++ ){
        	        	                             //can apply total version since we will be guarded by ITE condition
        	        	                             aargs.push_back( MK_EXPR( CVC4::kind::APPLY_SELECTOR_TOTAL, dtc[i].getSelector(), expr ) );
        	        	                           }
        	        	                           patexprs.push_back( MK_EXPR( CVC4::kind::APPLY, aargs ) );
        	        	                           patconds.push_back( MK_EXPR( CVC4::kind::APPLY_TESTER, dtc.getTester(), expr ) );
        	        	                         
        	        	            }


        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_term4140);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermEx;
        	        	            }


        	        	            {
        	        	                 PARSER_STATE->popScope(); 
        	        	            }


        	        	        }
        	        	        break;
        	        	    case 3:
        	        	        // ../../../../src/parser/smt2/Smt2.g:2102:10: LPAREN_TOK symbol[name,CHECK_DECLARED,SYM_VARIABLE] term[f3, f2] RPAREN_TOK
        	        	        {
        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_term4163);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermEx;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_symbol_in_term4165);
        	        	            symbol(ctx, name, CHECK_DECLARED, SYM_VARIABLE);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermEx;
        	        	            }


        	        	            {

        	        	                           f = PARSER_STATE->getVariable(name);
        	        	                           type = f.getType();
        	        	                           if( !type.isConstructor() || !((ConstructorType)type).getArgTypes().empty() ){
        	        	                             PARSER_STATE->parseError("Must apply constructors of arity greater than 0 to arguments in pattern.");
        	        	                           }
        	        	                         
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_term_in_term4179);
        	        	            term(ctx, f3, f2);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermEx;
        	        	            }


        	        	            {

        	        	                           const DatatypeConstructor& dtc = Datatype::datatypeOf(f)[Datatype::indexOf(f)];
        	        	                           patexprs.push_back( f3 );
        	        	                           patconds.push_back( MK_EXPR( CVC4::kind::APPLY_TESTER, dtc.getTester(), expr ) );
        	        	                         
        	        	            }


        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_term4193);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermEx;
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt54 >= 1 )
        	        		{
        	        		    goto loop54;
        	        		}
        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto ruletermEx;
        	        	}
        	        	cnt54++;
        	            }
        	            loop54: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_term4206);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_term4208);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {
        	             
        	                  if( match_vindex==-1 ){
        	                    const Datatype& dt = ((DatatypeType)expr.getType()).getDatatype();
        	                    std::map< unsigned, bool > processed;
        	                    unsigned count = 0;
        	                    //ensure that all datatype constructors are matched (to ensure exhaustiveness)
        	                    for( unsigned i=0; i<patconds.size(); i++ ){
        	                      unsigned curr_index = Datatype::indexOf(patconds[i].getOperator());
        	                      if( curr_index<0 && curr_index>=dt.getNumConstructors() ){
        	                        PARSER_STATE->parseError("Pattern is not legal for the head of a match.");
        	                      }
        	                      if( processed.find( curr_index )==processed.end() ){
        	                        processed[curr_index] = true;
        	                        count++;
        	                      }
        	                    }
        	                    if( count!=dt.getNumConstructors() ){
        	                      PARSER_STATE->parseError("Patterns are not exhaustive in a match construct.");
        	                    }
        	                  }
        	                  //now, make the ITE
        	                  int end_index = match_vindex==-1 ? patexprs.size()-1 : match_vindex;
        	                  bool first_time = true;
        	                  for( int index = end_index; index>=0; index-- ){
        	                    if( first_time ){
        	                      expr = patexprs[index];
        	                      first_time = false;
        	                    }else{
        	                      expr = MK_EXPR( CVC4::kind::ITE, patconds[index], patexprs[index], expr );
        	                    }
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 8:
        	    // ../../../../src/parser/smt2/Smt2.g:2148:5: symbol[name,CHECK_NONE,SYM_VARIABLE] SYGUS_ENUM_CONS_TOK symbol[name2,CHECK_NONE,SYM_VARIABLE]
        	    {
        	        FOLLOWPUSH(FOLLOW_symbol_in_term4217);
        	        symbol(ctx, name, CHECK_NONE, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	         MATCHT(SYGUS_ENUM_CONS_TOK, &FOLLOW_SYGUS_ENUM_CONS_TOK_in_term4220);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_term4226);
        	        symbol(ctx, name2, CHECK_NONE, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {
        	             std::string cname = name + "__Enum__" + name2;
        	                  Debug("parser-sygus") << "Check for enum const " << cname << std::endl;
        	                  expr = PARSER_STATE->getVariable(cname);
        	                  // expr.getType().isConstructor() &&
        	                  // ConstructorType(expr.getType()).getArity()==0;
        	                  expr = MK_EXPR(CVC4::kind::APPLY_CONSTRUCTOR, expr);
        	                
        	        }


        	    }
        	    break;
        	case 9:
        	    // ../../../../src/parser/smt2/Smt2.g:2158:5: symbol[name,CHECK_DECLARED,SYM_VARIABLE]
        	    {
        	        FOLLOWPUSH(FOLLOW_symbol_in_term4245);
        	        symbol(ctx, name, CHECK_DECLARED, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {
        	             if( PARSER_STATE->sygus() && name[0]=='-' && 
        	                      name.find_first_not_of("0123456789", 1) == std::string::npos ){
        	                    //allow unary minus in sygus
        	                    expr = MK_CONST(Rational(name));
        	                  }else{
        	                    const bool isDefinedFunction =
        	                      PARSER_STATE->isDefinedFunction(name);
        	                    if(PARSER_STATE->isAbstractValue(name)) {
        	                      expr = PARSER_STATE->mkAbstractValue(name);
        	                    } else if(isDefinedFunction) {
        	                      expr = MK_EXPR(CVC4::kind::APPLY,
        	                                    PARSER_STATE->getFunction(name));
        	                    } else {
        	                      expr = PARSER_STATE->getVariable(name);
        	                      Type t = PARSER_STATE->getType(name);
        	                      if(t.isConstructor() && ConstructorType(t).getArity() == 0) {
        	                        // don't require parentheses, immediately turn it into an apply
        	                        expr = MK_EXPR(CVC4::kind::APPLY_CONSTRUCTOR, expr);
        	                      }
        	                    }
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 10:
        	    // ../../../../src/parser/smt2/Smt2.g:2183:5: LPAREN_TOK ATTRIBUTE_TOK term[expr, f2] ( attribute[expr, attexpr, attr] )+ RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_term4265);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	         MATCHT(ATTRIBUTE_TOK, &FOLLOW_ATTRIBUTE_TOK_in_term4267);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_term4269);
        	        term(ctx, expr, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:2184:5: ( attribute[expr, attexpr, attr] )+
        	        {
        	            int cnt55=0;

        	            for (;;)
        	            {
        	                int alt55=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case ATTRIBUTE_INST_LEVEL:
        	        	case ATTRIBUTE_NAMED_TOK:
        	        	case ATTRIBUTE_NO_PATTERN_TOK:
        	        	case ATTRIBUTE_PATTERN_TOK:
        	        	case ATTRIBUTE_RR_PRIORITY:
        	        	case KEYWORD:
        	        		{
        	        			alt55=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt55)
        	        	{
        	        	    case 1:
        	        	        // ../../../../src/parser/smt2/Smt2.g:2184:7: attribute[expr, attexpr, attr]
        	        	        {
        	        	            FOLLOWPUSH(FOLLOW_attribute_in_term4278);
        	        	            attribute(ctx, expr, attexpr, attr);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermEx;
        	        	            }


        	        	            {
        	        	                 if( ! attexpr.isNull()) {
        	        	                          patexprs.push_back( attexpr );
        	        	                        }
        	        	                      
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt55 >= 1 )
        	        		{
        	        		    goto loop55;
        	        		}
        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto ruletermEx;
        	        	}
        	        	cnt55++;
        	            }
        	            loop55: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_term4296);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {

        	                  if(attr == ":rewrite-rule") {
        	                    Expr guard;
        	                    Expr body;
        	                    if(expr[1].getKind() == kind::IMPLIES ||
        	                       expr[1].getKind() == kind::EQUAL) {
        	                      guard = expr[0];
        	                      body = expr[1];
        	                    } else {
        	                      guard = MK_CONST(bool(true));
        	                      body = expr;
        	                    }
        	                    expr2 = guard;
        	                    args.push_back(body[0]);
        	                    args.push_back(body[1]);
        	                    if(!f2.isNull()) {
        	                      args.push_back(f2);
        	                    }

        	                    if( body.getKind()==kind::IMPLIES ){  
        	                      kind = kind::RR_DEDUCTION;
        	                    }else if( body.getKind()==kind::EQUAL ){
        	                      kind = body[0].getType().isBoolean() ? kind::RR_REDUCTION : kind::RR_REWRITE;
        	                    }else{
        	                      PARSER_STATE->parseError("Error parsing rewrite rule.");
        	                    }
        	                    expr = MK_EXPR( kind, args );
        	                  } else if(! patexprs.empty()) {
        	                    if( !f2.isNull() && f2.getKind()==kind::INST_PATTERN_LIST ){
        	                      for( size_t i=0; i<f2.getNumChildren(); i++ ){
        	                        if( f2[i].getKind()==kind::INST_PATTERN ){
        	                          patexprs.push_back( f2[i] );
        	                        }else{
        	                          std::stringstream ss;
        	                          ss << "warning: rewrite rules do not support " << f2[i]
        	                             << " within instantiation pattern list";
        	                          PARSER_STATE->warning(ss.str());
        	                        }
        	                      }
        	                    }
        	                    expr2 = MK_EXPR(kind::INST_PATTERN_LIST, patexprs);
        	                  } else {
        	                    expr2 = f2;
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 11:
        	    // ../../../../src/parser/smt2/Smt2.g:2236:5: INTEGER_LITERAL
        	    {
        	        INTEGER_LITERAL14 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_term4314);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {
        	             expr = MK_CONST( AntlrInput::tokenToInteger(INTEGER_LITERAL14) ); 
        	        }


        	    }
        	    break;
        	case 12:
        	    // ../../../../src/parser/smt2/Smt2.g:2239:5: DECIMAL_LITERAL
        	    {
        	        DECIMAL_LITERAL15 = (pANTLR3_COMMON_TOKEN) MATCHT(DECIMAL_LITERAL, &FOLLOW_DECIMAL_LITERAL_in_term4327);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {
        	             // FIXME: This doesn't work because an SMT rational is not a
        	                  // valid GMP rational string
        	                  expr = MK_CONST( AntlrInput::tokenToRational(DECIMAL_LITERAL15) ); 
        	        }


        	    }
        	    break;
        	case 13:
        	    // ../../../../src/parser/smt2/Smt2.g:2244:5: LPAREN_TOK INDEX_TOK (bvLit= SIMPLE_SYMBOL size= INTEGER_LITERAL | FP_PINF_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_NINF_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_NAN_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL ) RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_term4340);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	         MATCHT(INDEX_TOK, &FOLLOW_INDEX_TOK_in_term4342);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:2245:5: (bvLit= SIMPLE_SYMBOL size= INTEGER_LITERAL | FP_PINF_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_NINF_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_NAN_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL )
        	        {
        	            int alt56=4;
        	            switch ( LA(1) )
        	            {
        	            case SIMPLE_SYMBOL:
        	            	{
        	            		alt56=1;
        	            	}
        	                break;
        	            case FP_PINF_TOK:
        	            	{
        	            		alt56=2;
        	            	}
        	                break;
        	            case FP_NINF_TOK:
        	            	{
        	            		alt56=3;
        	            	}
        	                break;
        	            case FP_NAN_TOK:
        	            	{
        	            		alt56=4;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 56;
        	                EXCEPTION->state        = 0;


        	                goto ruletermEx;

        	            }

        	            switch (alt56)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2245:7: bvLit= SIMPLE_SYMBOL size= INTEGER_LITERAL
        	        	    {
        	        	        bvLit = (pANTLR3_COMMON_TOKEN) MATCHT(SIMPLE_SYMBOL, &FOLLOW_SIMPLE_SYMBOL_in_term4353);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermEx;
        	        	        }


        	        	        size = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_term4357);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermEx;
        	        	        }


        	        	        {
        	        	             if(AntlrInput::tokenText(bvLit).find("bv") == 0) {
        	        	                       expr = MK_CONST( AntlrInput::tokenToBitvector(bvLit, size) );
        	        	                    } else {
        	        	                       PARSER_STATE->parseError("Unexpected symbol `" +
        	        	                                                AntlrInput::tokenText(bvLit) + "'");
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2253:7: FP_PINF_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL
        	        	    {
        	        	         MATCHT(FP_PINF_TOK, &FOLLOW_FP_PINF_TOK_in_term4374);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermEx;
        	        	        }


        	        	        eb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_term4378);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermEx;
        	        	        }


        	        	        sb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_term4382);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermEx;
        	        	        }


        	        	        {
        	        	             expr = MK_CONST(FloatingPoint(AntlrInput::tokenToUnsigned(eb),
        	        	                                                  AntlrInput::tokenToUnsigned(sb),
        	        	                                                  +INFINITY)); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 3:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2257:7: FP_NINF_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL
        	        	    {
        	        	         MATCHT(FP_NINF_TOK, &FOLLOW_FP_NINF_TOK_in_term4398);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermEx;
        	        	        }


        	        	        eb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_term4402);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermEx;
        	        	        }


        	        	        sb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_term4406);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermEx;
        	        	        }


        	        	        {
        	        	             expr = MK_CONST(FloatingPoint(AntlrInput::tokenToUnsigned(eb),
        	        	                                                  AntlrInput::tokenToUnsigned(sb),
        	        	                                                 -INFINITY)); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 4:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2261:7: FP_NAN_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL
        	        	    {
        	        	         MATCHT(FP_NAN_TOK, &FOLLOW_FP_NAN_TOK_in_term4422);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermEx;
        	        	        }


        	        	        eb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_term4426);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermEx;
        	        	        }


        	        	        sb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_term4430);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermEx;
        	        	        }


        	        	        {
        	        	             expr = MK_CONST(FloatingPoint(AntlrInput::tokenToUnsigned(eb),
        	        	                                                  AntlrInput::tokenToUnsigned(sb),
        	        	                                                  NAN)); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_term4456);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	    }
        	    break;
        	case 14:
        	    // ../../../../src/parser/smt2/Smt2.g:2270:5: HEX_LITERAL
        	    {
        	        HEX_LITERAL16 = (pANTLR3_COMMON_TOKEN) MATCHT(HEX_LITERAL, &FOLLOW_HEX_LITERAL_in_term4463);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {
        	             assert( AntlrInput::tokenText(HEX_LITERAL16).find("#x") == 0 );
        	                  std::string hexString = AntlrInput::tokenTextSubstr(HEX_LITERAL16, 2);
        	                  expr = MK_CONST( BitVector(hexString, 16) ); 
        	        }


        	    }
        	    break;
        	case 15:
        	    // ../../../../src/parser/smt2/Smt2.g:2275:5: BINARY_LITERAL
        	    {
        	        BINARY_LITERAL17 = (pANTLR3_COMMON_TOKEN) MATCHT(BINARY_LITERAL, &FOLLOW_BINARY_LITERAL_in_term4476);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {
        	             assert( AntlrInput::tokenText(BINARY_LITERAL17).find("#b") == 0 );
        	                  std::string binString = AntlrInput::tokenTextSubstr(BINARY_LITERAL17, 2);
        	                  expr = MK_CONST( BitVector(binString, 2) ); 
        	        }


        	    }
        	    break;
        	case 16:
        	    // ../../../../src/parser/smt2/Smt2.g:2280:5: str[s,false]
        	    {
        	        FOLLOWPUSH(FOLLOW_str_in_term4489);
        	        str(ctx, s, false);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {
        	             expr = MK_CONST( ::CVC4::String(s) ); 
        	        }


        	    }
        	    break;
        	case 17:
        	    // ../../../../src/parser/smt2/Smt2.g:2282:5: FP_RNE_TOK
        	    {
        	         MATCHT(FP_RNE_TOK, &FOLLOW_FP_RNE_TOK_in_term4502);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {
        	             expr = MK_CONST(roundNearestTiesToEven); 
        	        }


        	    }
        	    break;
        	case 18:
        	    // ../../../../src/parser/smt2/Smt2.g:2283:5: FP_RNA_TOK
        	    {
        	         MATCHT(FP_RNA_TOK, &FOLLOW_FP_RNA_TOK_in_term4515);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {
        	             expr = MK_CONST(roundNearestTiesToAway); 
        	        }


        	    }
        	    break;
        	case 19:
        	    // ../../../../src/parser/smt2/Smt2.g:2284:5: FP_RTP_TOK
        	    {
        	         MATCHT(FP_RTP_TOK, &FOLLOW_FP_RTP_TOK_in_term4528);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {
        	             expr = MK_CONST(roundTowardPositive); 
        	        }


        	    }
        	    break;
        	case 20:
        	    // ../../../../src/parser/smt2/Smt2.g:2285:5: FP_RTN_TOK
        	    {
        	         MATCHT(FP_RTN_TOK, &FOLLOW_FP_RTN_TOK_in_term4541);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {
        	             expr = MK_CONST(roundTowardNegative); 
        	        }


        	    }
        	    break;
        	case 21:
        	    // ../../../../src/parser/smt2/Smt2.g:2286:5: FP_RTZ_TOK
        	    {
        	         MATCHT(FP_RTZ_TOK, &FOLLOW_FP_RTZ_TOK_in_term4554);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {
        	             expr = MK_CONST(roundTowardZero); 
        	        }


        	    }
        	    break;
        	case 22:
        	    // ../../../../src/parser/smt2/Smt2.g:2287:5: FP_RNE_FULL_TOK
        	    {
        	         MATCHT(FP_RNE_FULL_TOK, &FOLLOW_FP_RNE_FULL_TOK_in_term4567);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {
        	             expr = MK_CONST(roundNearestTiesToEven); 
        	        }


        	    }
        	    break;
        	case 23:
        	    // ../../../../src/parser/smt2/Smt2.g:2288:5: FP_RNA_FULL_TOK
        	    {
        	         MATCHT(FP_RNA_FULL_TOK, &FOLLOW_FP_RNA_FULL_TOK_in_term4575);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {
        	             expr = MK_CONST(roundNearestTiesToAway); 
        	        }


        	    }
        	    break;
        	case 24:
        	    // ../../../../src/parser/smt2/Smt2.g:2289:5: FP_RTP_FULL_TOK
        	    {
        	         MATCHT(FP_RTP_FULL_TOK, &FOLLOW_FP_RTP_FULL_TOK_in_term4583);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {
        	             expr = MK_CONST(roundTowardPositive); 
        	        }


        	    }
        	    break;
        	case 25:
        	    // ../../../../src/parser/smt2/Smt2.g:2290:5: FP_RTN_FULL_TOK
        	    {
        	         MATCHT(FP_RTN_FULL_TOK, &FOLLOW_FP_RTN_FULL_TOK_in_term4591);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {
        	             expr = MK_CONST(roundTowardNegative); 
        	        }


        	    }
        	    break;
        	case 26:
        	    // ../../../../src/parser/smt2/Smt2.g:2291:5: FP_RTZ_FULL_TOK
        	    {
        	         MATCHT(FP_RTZ_FULL_TOK, &FOLLOW_FP_RTZ_FULL_TOK_in_term4599);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {
        	             expr = MK_CONST(roundTowardZero); 
        	        }


        	    }
        	    break;
        	case 27:
        	    // ../../../../src/parser/smt2/Smt2.g:2293:5: RENOSTR_TOK
        	    {
        	         MATCHT(RENOSTR_TOK, &FOLLOW_RENOSTR_TOK_in_term4608);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {
        	             std::vector< Expr > nvec;
        	                  expr = MK_EXPR( CVC4::kind::REGEXP_EMPTY, nvec );
        	                
        	        }


        	    }
        	    break;
        	case 28:
        	    // ../../../../src/parser/smt2/Smt2.g:2298:5: REALLCHAR_TOK
        	    {
        	         MATCHT(REALLCHAR_TOK, &FOLLOW_REALLCHAR_TOK_in_term4621);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {
        	             std::vector< Expr > nvec;
        	                  expr = MK_EXPR( CVC4::kind::REGEXP_SIGMA, nvec );
        	                
        	        }


        	    }
        	    break;
        	case 29:
        	    // ../../../../src/parser/smt2/Smt2.g:2303:5: EMPTYSET_TOK
        	    {
        	         MATCHT(EMPTYSET_TOK, &FOLLOW_EMPTYSET_TOK_in_term4634);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {
        	             expr = MK_CONST( ::CVC4::EmptySet(Type())); 
        	        }


        	    }
        	    break;
        	case 30:
        	    // ../../../../src/parser/smt2/Smt2.g:2306:5: UNIVSET_TOK
        	    {
        	         MATCHT(UNIVSET_TOK, &FOLLOW_UNIVSET_TOK_in_term4647);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {
        	             //booleanType is placeholder here since we don't have type info without type annotation
        	                  expr = EXPR_MANAGER->mkNullaryOperator(EXPR_MANAGER->booleanType(), kind::UNIVERSE_SET); 
        	        }


        	    }
        	    break;
        	case 31:
        	    // ../../../../src/parser/smt2/Smt2.g:2310:5: NILREF_TOK
        	    {
        	         MATCHT(NILREF_TOK, &FOLLOW_NILREF_TOK_in_term4660);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {
        	             //booleanType is placeholder here since we don't have type info without type annotation
        	                  expr = EXPR_MANAGER->mkNullaryOperator(EXPR_MANAGER->booleanType(), kind::SEP_NIL); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruletermEx; /* Prevent compiler warnings */
    ruletermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end term */

/**
 * $ANTLR start attribute
 * ../../../../src/parser/smt2/Smt2.g:2319:1: attribute[CVC4::Expr& expr, CVC4::Expr& retExpr, std::string& attr] : ( KEYWORD ( simpleSymbolicExprNoKeyword[sexpr] )? | ATTRIBUTE_PATTERN_TOK LPAREN_TOK ( term[patexpr, e2] )+ RPAREN_TOK | ATTRIBUTE_NO_PATTERN_TOK term[patexpr, e2] |tok= ( ATTRIBUTE_INST_LEVEL | ATTRIBUTE_RR_PRIORITY ) INTEGER_LITERAL | ATTRIBUTE_NAMED_TOK symbolicExpr[sexpr] );
 */
static void
attribute(pSmt2Parser ctx, CVC4::Expr& expr, CVC4::Expr& retExpr, std::string& attr)
{
    pANTLR3_COMMON_TOKEN    tok;
    pANTLR3_COMMON_TOKEN    KEYWORD18;
    pANTLR3_COMMON_TOKEN    INTEGER_LITERAL19;

    /* Initialize rule variables
     */


      SExpr sexpr;
      Expr patexpr;
      std::vector<Expr> patexprs;
      Expr e2;
      bool hasValue = false;

    tok       = NULL;
    KEYWORD18       = NULL;
    INTEGER_LITERAL19       = NULL;

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:2327:3: ( KEYWORD ( simpleSymbolicExprNoKeyword[sexpr] )? | ATTRIBUTE_PATTERN_TOK LPAREN_TOK ( term[patexpr, e2] )+ RPAREN_TOK | ATTRIBUTE_NO_PATTERN_TOK term[patexpr, e2] |tok= ( ATTRIBUTE_INST_LEVEL | ATTRIBUTE_RR_PRIORITY ) INTEGER_LITERAL | ATTRIBUTE_NAMED_TOK symbolicExpr[sexpr] )

            ANTLR3_UINT32 alt60;

            alt60=5;

            switch ( LA(1) )
            {
            case KEYWORD:
            	{
            		alt60=1;
            	}
                break;
            case ATTRIBUTE_PATTERN_TOK:
            	{
            		alt60=2;
            	}
                break;
            case ATTRIBUTE_NO_PATTERN_TOK:
            	{
            		alt60=3;
            	}
                break;
            case ATTRIBUTE_INST_LEVEL:
            case ATTRIBUTE_RR_PRIORITY:
            	{
            		alt60=4;
            	}
                break;
            case ATTRIBUTE_NAMED_TOK:
            	{
            		alt60=5;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 60;
                EXCEPTION->state        = 0;


                goto ruleattributeEx;

            }

            switch (alt60)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:2327:5: KEYWORD ( simpleSymbolicExprNoKeyword[sexpr] )?
        	    {
        	        KEYWORD18 = (pANTLR3_COMMON_TOKEN) MATCHT(KEYWORD, &FOLLOW_KEYWORD_in_attribute4692);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:2327:13: ( simpleSymbolicExprNoKeyword[sexpr] )?
        	        {
        	            int alt58=2;
        	            switch ( LA(1) )
        	            {
        	                case AND_TOK:
        	                case ASSERT_TOK:
        	                case BINARY_LITERAL:
        	                case BV2NAT_TOK:
        	                case CHECKSAT_TOK:
        	                case CHECK_SYNTH_TOK:
        	                case CONSTRAINT_TOK:
        	                case DECIMAL_LITERAL:
        	                case DECLARE_DATATYPES_TOK:
        	                case DECLARE_FUN_TOK:
        	                case DECLARE_PRIMED_VAR_TOK:
        	                case DECLARE_SORT_TOK:
        	                case DECLARE_VAR_TOK:
        	                case DEFINE_FUNS_REC_TOK:
        	                case DEFINE_FUN_REC_TOK:
        	                case DEFINE_FUN_TOK:
        	                case DEFINE_SORT_TOK:
        	                case DISTINCT_TOK:
        	                case DIV_TOK:
        	                case DTSIZE_TOK:
        	                case ECHO_TOK:
        	                case EQUAL_TOK:
        	                case EXIT_TOK:
        	                case FMFCARDVAL_TOK:
        	                case FMFCARD_TOK:
        	                case GET_ASSERTIONS_TOK:
        	                case GET_ASSIGNMENT_TOK:
        	                case GET_INFO_TOK:
        	                case GET_MODEL_TOK:
        	                case GET_OPTION_TOK:
        	                case GET_PROOF_TOK:
        	                case GET_UNSAT_CORE_TOK:
        	                case GET_VALUE_TOK:
        	                case GREATER_THAN_EQUAL_TOK:
        	                case GREATER_THAN_TOK:
        	                case HEX_LITERAL:
        	                case IMPLIES_TOK:
        	                case INST_CLOSURE_TOK:
        	                case INTEGER_LITERAL:
        	                case INV_CONSTRAINT_TOK:
        	                case ITE_TOK:
        	                case LESS_THAN_EQUAL_TOK:
        	                case LESS_THAN_TOK:
        	                case MINUS_TOK:
        	                case NOT_TOK:
        	                case OR_TOK:
        	                case PLUS_TOK:
        	                case POP_TOK:
        	                case PROPAGATION_RULE_TOK:
        	                case PUSH_TOK:
        	                case QUOTED_SYMBOL:
        	                case REDUCTION_RULE_TOK:
        	                case RESET_ASSERTIONS_TOK:
        	                case RESET_TOK:
        	                case REWRITE_RULE_TOK:
        	                case SET_INFO_TOK:
        	                case SET_LOGIC_TOK:
        	                case SET_OPTIONS_TOK:
        	                case SET_OPTION_TOK:
        	                case SIMPLE_SYMBOL:
        	                case SIMPLIFY_TOK:
        	                case STAR_TOK:
        	                case STRING_LITERAL_2_0:
        	                case STRING_LITERAL_2_5:
        	                case SYNTH_FUN_TOK:
        	                case SYNTH_INV_TOK:
        	                case UNTERMINATED_QUOTED_SYMBOL:
        	                case XOR_TOK:
        	                case 154:
        	                	{
        	                		alt58=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt58)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2327:15: simpleSymbolicExprNoKeyword[sexpr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_simpleSymbolicExprNoKeyword_in_attribute4696);
        	        	        simpleSymbolicExprNoKeyword(ctx, sexpr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleattributeEx;
        	        	        }


        	        	        {
        	        	             hasValue = true; 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        {

        	                attr = AntlrInput::tokenText(KEYWORD18);
        	                // EXPR_MANAGER->setNamedAttribute( expr, attr );
        	                if(attr == ":rewrite-rule") {
        	                  if(hasValue) {
        	                    std::stringstream ss;
        	                    ss << "warning: Attribute " << attr
        	                       << " does not take a value (ignoring)";
        	                    PARSER_STATE->warning(ss.str());
        	                  }
        	                  // do nothing
        	                } else if(attr==":axiom" || attr==":conjecture" || attr==":fun-def" ||
        	                          attr==":sygus" || attr==":synthesis") {
        	                  if(hasValue) {
        	                    std::stringstream ss;
        	                    ss << "warning: Attribute " << attr
        	                       << " does not take a value (ignoring)";
        	                    PARSER_STATE->warning(ss.str());
        	                  }
        	                  Expr avar;
        	                  bool success = true;
        	                  std::string attr_name = attr;
        	                  attr_name.erase( attr_name.begin() );
        	                  if( attr==":fun-def" ){
        	                    if( expr.getKind()!=kind::EQUAL || expr[0].getKind()!=kind::APPLY_UF ){
        	                      success = false;
        	                    }else{
        	                      FunctionType t = (FunctionType)expr[0].getOperator().getType();
        	                      for( unsigned i=0; i<expr[0].getNumChildren(); i++ ){
        	                        if( expr[0][i].getKind() != kind::BOUND_VARIABLE ||
        	                            expr[0][i].getType() != t.getArgTypes()[i] ){
        	                          success = false;
        	                          break;
        	                        }else{
        	                          for( unsigned j=0; j<i; j++ ){
        	                            if( expr[0][j]==expr[0][i] ){
        	                              success = false;
        	                              break;
        	                            }
        	                          }
        	                        }
        	                      }
        	                    }
        	                    if( !success ){
        	                      std::stringstream ss;
        	                      ss << "warning: Function definition should be an equality whose LHS "
        	                         << "is an uninterpreted function applied to unique variables.";
        	                      PARSER_STATE->warning(ss.str());
        	                    }else{
        	                      avar = expr[0];
        	                    }
        	                  }else{
        	                    Type t = EXPR_MANAGER->booleanType();
        	                    avar = PARSER_STATE->mkVar(attr_name, t);
        	                  }
        	                  if( success ){
        	                    //Will set the attribute on auxiliary var (preserves attribute on
        	                    //formula through rewriting).
        	                    retExpr = MK_EXPR(kind::INST_ATTRIBUTE, avar);
        	                    Command* c = new SetUserAttributeCommand( attr_name, avar );
        	                    c->setMuted(true);
        	                    PARSER_STATE->preemptCommand(c);
        	                  }
        	                } else {
        	                  PARSER_STATE->attributeNotSupported(attr);
        	                }
        	              
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:2395:5: ATTRIBUTE_PATTERN_TOK LPAREN_TOK ( term[patexpr, e2] )+ RPAREN_TOK
        	    {
        	         MATCHT(ATTRIBUTE_PATTERN_TOK, &FOLLOW_ATTRIBUTE_PATTERN_TOK_in_attribute4712);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_attribute4714);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:2396:5: ( term[patexpr, e2] )+
        	        {
        	            int cnt59=0;

        	            for (;;)
        	            {
        	                int alt59=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case BINARY_LITERAL:
        	        	case CHECK_SYNTH_TOK:
        	        	case CONSTRAINT_TOK:
        	        	case DECIMAL_LITERAL:
        	        	case DECLARE_PRIMED_VAR_TOK:
        	        	case DECLARE_VAR_TOK:
        	        	case EMPTYSET_TOK:
        	        	case FP_RNA_FULL_TOK:
        	        	case FP_RNA_TOK:
        	        	case FP_RNE_FULL_TOK:
        	        	case FP_RNE_TOK:
        	        	case FP_RTN_FULL_TOK:
        	        	case FP_RTN_TOK:
        	        	case FP_RTP_FULL_TOK:
        	        	case FP_RTP_TOK:
        	        	case FP_RTZ_FULL_TOK:
        	        	case FP_RTZ_TOK:
        	        	case HEX_LITERAL:
        	        	case INTEGER_LITERAL:
        	        	case INV_CONSTRAINT_TOK:
        	        	case LPAREN_TOK:
        	        	case NILREF_TOK:
        	        	case QUOTED_SYMBOL:
        	        	case REALLCHAR_TOK:
        	        	case RENOSTR_TOK:
        	        	case SET_OPTIONS_TOK:
        	        	case SIMPLE_SYMBOL:
        	        	case STRING_LITERAL_2_0:
        	        	case STRING_LITERAL_2_5:
        	        	case SYNTH_FUN_TOK:
        	        	case SYNTH_INV_TOK:
        	        	case UNIVSET_TOK:
        	        	case UNTERMINATED_QUOTED_SYMBOL:
        	        	case 154:
        	        		{
        	        			alt59=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt59)
        	        	{
        	        	    case 1:
        	        	        // ../../../../src/parser/smt2/Smt2.g:2396:7: term[patexpr, e2]
        	        	        {
        	        	            FOLLOWPUSH(FOLLOW_term_in_attribute4722);
        	        	            term(ctx, patexpr, e2);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleattributeEx;
        	        	            }


        	        	            {
        	        	                 patexprs.push_back( patexpr ); 
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt59 >= 1 )
        	        		{
        	        		    goto loop59;
        	        		}
        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto ruleattributeEx;
        	        	}
        	        	cnt59++;
        	            }
        	            loop59: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_attribute4740);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }


        	        {

        	                  attr = std::string(":pattern");
        	                  retExpr = MK_EXPR(kind::INST_PATTERN, patexprs);
        	                
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/smt2/Smt2.g:2403:5: ATTRIBUTE_NO_PATTERN_TOK term[patexpr, e2]
        	    {
        	         MATCHT(ATTRIBUTE_NO_PATTERN_TOK, &FOLLOW_ATTRIBUTE_NO_PATTERN_TOK_in_attribute4752);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_attribute4754);
        	        term(ctx, patexpr, e2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }


        	        {

        	                  attr = std::string(":no-pattern");
        	                  retExpr = MK_EXPR(kind::INST_NO_PATTERN, patexpr);
        	                
        	        }


        	    }
        	    break;
        	case 4:
        	    // ../../../../src/parser/smt2/Smt2.g:2408:5: tok= ( ATTRIBUTE_INST_LEVEL | ATTRIBUTE_RR_PRIORITY ) INTEGER_LITERAL
        	    {
        	        tok=(pANTLR3_COMMON_TOKEN)LT(1);

        	        if ( LA(1) == ATTRIBUTE_INST_LEVEL || LA(1) == ATTRIBUTE_RR_PRIORITY )
        	        {
        	            CONSUME();
        	            PERRORRECOVERY=ANTLR3_FALSE;
        	        }
        	        else
        	        {
        	            CONSTRUCTEX();
        	            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
        	            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
        	            EXCEPTION->expectingSet = NULL;

        	            goto ruleattributeEx;
        	        }


        	        INTEGER_LITERAL19 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_attribute4779);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }


        	        {

        	                  Expr n = MK_CONST( AntlrInput::tokenToInteger(INTEGER_LITERAL19) );
        	                  std::vector<Expr> values;
        	                  values.push_back( n );
        	                  std::string attr_name(AntlrInput::tokenText(tok));
        	                  attr_name.erase( attr_name.begin() );
        	                  Type t = EXPR_MANAGER->booleanType();
        	                  Expr avar = PARSER_STATE->mkVar(attr_name, t);
        	                  retExpr = MK_EXPR(kind::INST_ATTRIBUTE, avar);
        	                  Command* c = new SetUserAttributeCommand( attr_name, avar, values );
        	                  c->setMuted(true);
        	                  PARSER_STATE->preemptCommand(c);
        	                
        	        }


        	    }
        	    break;
        	case 5:
        	    // ../../../../src/parser/smt2/Smt2.g:2422:5: ATTRIBUTE_NAMED_TOK symbolicExpr[sexpr]
        	    {
        	         MATCHT(ATTRIBUTE_NAMED_TOK, &FOLLOW_ATTRIBUTE_NAMED_TOK_in_attribute4791);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_symbolicExpr_in_attribute4793);
        	        symbolicExpr(ctx, sexpr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }


        	        {

        	                  attr = std::string(":named");
        	                  if(!sexpr.isKeyword()) {
        	                    PARSER_STATE->parseError("improperly formed :named annotation");
        	                  }
        	                  std::string name = sexpr.getValue();
        	                  PARSER_STATE->checkUserSymbol(name);
        	                  // ensure expr is a closed subterm
        	                  std::set<Expr> freeVars;
        	                  if(!isClosed(expr, freeVars)) {
        	                    assert(!freeVars.empty());
        	                    std::stringstream ss;
        	                    ss << ":named annotations can only name terms that are closed; this "
        	                       << "one contains free variables:";
        	                    for(std::set<Expr>::const_iterator i = freeVars.begin();
        	                        i != freeVars.end(); ++i) {
        	                      ss << " " << *i;
        	                    }
        	                    PARSER_STATE->parseError(ss.str());
        	                  }
        	                  // check that sexpr is a fresh function symbol, and reserve it
        	                  PARSER_STATE->reserveSymbolAtAssertionLevel(name);
        	                  // define it
        	                  Expr func = PARSER_STATE->mkFunction(name, expr.getType());
        	                  // remember the last term to have been given a :named attribute
        	                  PARSER_STATE->setLastNamedTerm(expr, name);
        	                  // bind name to expr with define-fun
        	                  Command* c =
        	                    new DefineNamedFunctionCommand(name, func, std::vector<Expr>(), expr);
        	                  c->setMuted(true);
        	                  PARSER_STATE->preemptCommand(c);
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleattributeEx; /* Prevent compiler warnings */
    ruleattributeEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end attribute */

/**
 * $ANTLR start indexedFunctionName
 * ../../../../src/parser/smt2/Smt2.g:2460:1: indexedFunctionName[CVC4::Expr& op, CVC4::Kind& kind] : LPAREN_TOK INDEX_TOK ( 'extract' n1= INTEGER_LITERAL n2= INTEGER_LITERAL | 'repeat' n= INTEGER_LITERAL | 'zero_extend' n= INTEGER_LITERAL | 'sign_extend' n= INTEGER_LITERAL | 'rotate_left' n= INTEGER_LITERAL | 'rotate_right' n= INTEGER_LITERAL | DIVISIBLE_TOK n= INTEGER_LITERAL | INT2BV_TOK n= INTEGER_LITERAL | FP_PINF_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_NINF_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_NAN_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_PZERO_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_NZERO_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FP_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPBV_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPFP_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPR_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPS_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPU_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_UBV_TOK m= INTEGER_LITERAL | FP_TO_SBV_TOK m= INTEGER_LITERAL | TESTER_TOK term[expr, expr2] | badIndexedFunctionName ) RPAREN_TOK ;
 */
static void
indexedFunctionName(pSmt2Parser ctx, CVC4::Expr& op, CVC4::Kind& kind)
{
    pANTLR3_COMMON_TOKEN    n1;
    pANTLR3_COMMON_TOKEN    n2;
    pANTLR3_COMMON_TOKEN    n;
    pANTLR3_COMMON_TOKEN    eb;
    pANTLR3_COMMON_TOKEN    sb;
    pANTLR3_COMMON_TOKEN    m;

    /* Initialize rule variables
     */


      Expr expr;
      Expr expr2;

    n1       = NULL;
    n2       = NULL;
    n       = NULL;
    eb       = NULL;
    sb       = NULL;
    m       = NULL;

    {
        // ../../../../src/parser/smt2/Smt2.g:2465:3: ( LPAREN_TOK INDEX_TOK ( 'extract' n1= INTEGER_LITERAL n2= INTEGER_LITERAL | 'repeat' n= INTEGER_LITERAL | 'zero_extend' n= INTEGER_LITERAL | 'sign_extend' n= INTEGER_LITERAL | 'rotate_left' n= INTEGER_LITERAL | 'rotate_right' n= INTEGER_LITERAL | DIVISIBLE_TOK n= INTEGER_LITERAL | INT2BV_TOK n= INTEGER_LITERAL | FP_PINF_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_NINF_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_NAN_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_PZERO_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_NZERO_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FP_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPBV_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPFP_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPR_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPS_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPU_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_UBV_TOK m= INTEGER_LITERAL | FP_TO_SBV_TOK m= INTEGER_LITERAL | TESTER_TOK term[expr, expr2] | badIndexedFunctionName ) RPAREN_TOK )
        // ../../../../src/parser/smt2/Smt2.g:2465:5: LPAREN_TOK INDEX_TOK ( 'extract' n1= INTEGER_LITERAL n2= INTEGER_LITERAL | 'repeat' n= INTEGER_LITERAL | 'zero_extend' n= INTEGER_LITERAL | 'sign_extend' n= INTEGER_LITERAL | 'rotate_left' n= INTEGER_LITERAL | 'rotate_right' n= INTEGER_LITERAL | DIVISIBLE_TOK n= INTEGER_LITERAL | INT2BV_TOK n= INTEGER_LITERAL | FP_PINF_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_NINF_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_NAN_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_PZERO_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_NZERO_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FP_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPBV_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPFP_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPR_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPS_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPU_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_UBV_TOK m= INTEGER_LITERAL | FP_TO_SBV_TOK m= INTEGER_LITERAL | TESTER_TOK term[expr, expr2] | badIndexedFunctionName ) RPAREN_TOK
        {
             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_indexedFunctionName4821);
            if  (HASEXCEPTION())
            {
                goto ruleindexedFunctionNameEx;
            }


             MATCHT(INDEX_TOK, &FOLLOW_INDEX_TOK_in_indexedFunctionName4823);
            if  (HASEXCEPTION())
            {
                goto ruleindexedFunctionNameEx;
            }


            // ../../../../src/parser/smt2/Smt2.g:2466:5: ( 'extract' n1= INTEGER_LITERAL n2= INTEGER_LITERAL | 'repeat' n= INTEGER_LITERAL | 'zero_extend' n= INTEGER_LITERAL | 'sign_extend' n= INTEGER_LITERAL | 'rotate_left' n= INTEGER_LITERAL | 'rotate_right' n= INTEGER_LITERAL | DIVISIBLE_TOK n= INTEGER_LITERAL | INT2BV_TOK n= INTEGER_LITERAL | FP_PINF_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_NINF_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_NAN_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_PZERO_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_NZERO_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FP_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPBV_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPFP_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPR_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPS_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPU_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_UBV_TOK m= INTEGER_LITERAL | FP_TO_SBV_TOK m= INTEGER_LITERAL | TESTER_TOK term[expr, expr2] | badIndexedFunctionName )
            {
                int alt61=23;
                switch ( LA(1) )
                {
                case 153:
                	{
                		alt61=1;
                	}
                    break;
                case 154:
                	{
                		alt61=2;
                	}
                    break;
                case 158:
                	{
                		alt61=3;
                	}
                    break;
                case 157:
                	{
                		alt61=4;
                	}
                    break;
                case 155:
                	{
                		alt61=5;
                	}
                    break;
                case 156:
                	{
                		alt61=6;
                	}
                    break;
                case DIVISIBLE_TOK:
                	{
                		alt61=7;
                	}
                    break;
                case INT2BV_TOK:
                	{
                		alt61=8;
                	}
                    break;
                case FP_PINF_TOK:
                	{
                		alt61=9;
                	}
                    break;
                case FP_NINF_TOK:
                	{
                		alt61=10;
                	}
                    break;
                case FP_NAN_TOK:
                	{
                		alt61=11;
                	}
                    break;
                case FP_PZERO_TOK:
                	{
                		alt61=12;
                	}
                    break;
                case FP_NZERO_TOK:
                	{
                		alt61=13;
                	}
                    break;
                case FP_TO_FP_TOK:
                	{
                		alt61=14;
                	}
                    break;
                case FP_TO_FPBV_TOK:
                	{
                		alt61=15;
                	}
                    break;
                case FP_TO_FPFP_TOK:
                	{
                		alt61=16;
                	}
                    break;
                case FP_TO_FPR_TOK:
                	{
                		alt61=17;
                	}
                    break;
                case FP_TO_FPS_TOK:
                	{
                		alt61=18;
                	}
                    break;
                case FP_TO_FPU_TOK:
                	{
                		alt61=19;
                	}
                    break;
                case FP_TO_UBV_TOK:
                	{
                		alt61=20;
                	}
                    break;
                case FP_TO_SBV_TOK:
                	{
                		alt61=21;
                	}
                    break;
                case TESTER_TOK:
                	{
                		alt61=22;
                	}
                    break;
                case QUOTED_SYMBOL:
                case SIMPLE_SYMBOL:
                case UNTERMINATED_QUOTED_SYMBOL:
                	{
                		alt61=23;
                	}
                    break;

                default:
                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 61;
                    EXCEPTION->state        = 0;


                    goto ruleindexedFunctionNameEx;

                }

                switch (alt61)
                {
            	case 1:
            	    // ../../../../src/parser/smt2/Smt2.g:2466:7: 'extract' n1= INTEGER_LITERAL n2= INTEGER_LITERAL
            	    {
            	         MATCHT(153, &FOLLOW_153_in_indexedFunctionName4831);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        n1 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4835);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        n2 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4839);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(BitVectorExtract(AntlrInput::tokenToUnsigned(n1),
            	                                                   AntlrInput::tokenToUnsigned(n2))); 
            	        }


            	    }
            	    break;
            	case 2:
            	    // ../../../../src/parser/smt2/Smt2.g:2469:7: 'repeat' n= INTEGER_LITERAL
            	    {
            	         MATCHT(154, &FOLLOW_154_in_indexedFunctionName4855);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        n = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4859);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(BitVectorRepeat(AntlrInput::tokenToUnsigned(n))); 
            	        }


            	    }
            	    break;
            	case 3:
            	    // ../../../../src/parser/smt2/Smt2.g:2471:7: 'zero_extend' n= INTEGER_LITERAL
            	    {
            	         MATCHT(158, &FOLLOW_158_in_indexedFunctionName4875);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        n = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4879);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(BitVectorZeroExtend(AntlrInput::tokenToUnsigned(n))); 
            	        }


            	    }
            	    break;
            	case 4:
            	    // ../../../../src/parser/smt2/Smt2.g:2473:7: 'sign_extend' n= INTEGER_LITERAL
            	    {
            	         MATCHT(157, &FOLLOW_157_in_indexedFunctionName4895);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        n = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4899);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(BitVectorSignExtend(AntlrInput::tokenToUnsigned(n))); 
            	        }


            	    }
            	    break;
            	case 5:
            	    // ../../../../src/parser/smt2/Smt2.g:2475:7: 'rotate_left' n= INTEGER_LITERAL
            	    {
            	         MATCHT(155, &FOLLOW_155_in_indexedFunctionName4915);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        n = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4919);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(BitVectorRotateLeft(AntlrInput::tokenToUnsigned(n))); 
            	        }


            	    }
            	    break;
            	case 6:
            	    // ../../../../src/parser/smt2/Smt2.g:2477:7: 'rotate_right' n= INTEGER_LITERAL
            	    {
            	         MATCHT(156, &FOLLOW_156_in_indexedFunctionName4935);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        n = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4939);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(BitVectorRotateRight(AntlrInput::tokenToUnsigned(n))); 
            	        }


            	    }
            	    break;
            	case 7:
            	    // ../../../../src/parser/smt2/Smt2.g:2479:7: DIVISIBLE_TOK n= INTEGER_LITERAL
            	    {
            	         MATCHT(DIVISIBLE_TOK, &FOLLOW_DIVISIBLE_TOK_in_indexedFunctionName4955);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        n = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4959);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(Divisible(AntlrInput::tokenToUnsigned(n))); 
            	        }


            	    }
            	    break;
            	case 8:
            	    // ../../../../src/parser/smt2/Smt2.g:2481:7: INT2BV_TOK n= INTEGER_LITERAL
            	    {
            	         MATCHT(INT2BV_TOK, &FOLLOW_INT2BV_TOK_in_indexedFunctionName4975);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        n = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4979);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(IntToBitVector(AntlrInput::tokenToUnsigned(n)));
            	                    if(PARSER_STATE->strictModeEnabled()) {
            	                      PARSER_STATE->parseError(
            	                          "bv2nat and int2bv are not part of SMT-LIB, and aren't available "
            	                          "in SMT-LIB strict compliance mode");
            	                    } 
            	        }


            	    }
            	    break;
            	case 9:
            	    // ../../../../src/parser/smt2/Smt2.g:2488:7: FP_PINF_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL
            	    {
            	         MATCHT(FP_PINF_TOK, &FOLLOW_FP_PINF_TOK_in_indexedFunctionName4995);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        eb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName4999);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        sb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5003);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(FloatingPoint(AntlrInput::tokenToUnsigned(eb),
            	                                                AntlrInput::tokenToUnsigned(sb),
            	                                                +INFINITY)); 
            	        }


            	    }
            	    break;
            	case 10:
            	    // ../../../../src/parser/smt2/Smt2.g:2492:7: FP_NINF_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL
            	    {
            	         MATCHT(FP_NINF_TOK, &FOLLOW_FP_NINF_TOK_in_indexedFunctionName5019);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        eb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5023);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        sb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5027);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(FloatingPoint(AntlrInput::tokenToUnsigned(eb),
            	                                                AntlrInput::tokenToUnsigned(sb),
            	                                                -INFINITY)); 
            	        }


            	    }
            	    break;
            	case 11:
            	    // ../../../../src/parser/smt2/Smt2.g:2496:7: FP_NAN_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL
            	    {
            	         MATCHT(FP_NAN_TOK, &FOLLOW_FP_NAN_TOK_in_indexedFunctionName5043);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        eb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5047);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        sb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5051);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(FloatingPoint(AntlrInput::tokenToUnsigned(eb),
            	                                                AntlrInput::tokenToUnsigned(sb),
            	                                                NAN)); 
            	        }


            	    }
            	    break;
            	case 12:
            	    // ../../../../src/parser/smt2/Smt2.g:2500:7: FP_PZERO_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL
            	    {
            	         MATCHT(FP_PZERO_TOK, &FOLLOW_FP_PZERO_TOK_in_indexedFunctionName5067);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        eb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5071);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        sb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5075);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(FloatingPoint(AntlrInput::tokenToUnsigned(eb),
            	                                                AntlrInput::tokenToUnsigned(sb),
            	                                                +0.0)); 
            	        }


            	    }
            	    break;
            	case 13:
            	    // ../../../../src/parser/smt2/Smt2.g:2504:7: FP_NZERO_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL
            	    {
            	         MATCHT(FP_NZERO_TOK, &FOLLOW_FP_NZERO_TOK_in_indexedFunctionName5091);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        eb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5095);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        sb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5099);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(FloatingPoint(AntlrInput::tokenToUnsigned(eb),
            	                                                AntlrInput::tokenToUnsigned(sb),
            	                                                -0.0)); 
            	        }


            	    }
            	    break;
            	case 14:
            	    // ../../../../src/parser/smt2/Smt2.g:2508:7: FP_TO_FP_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL
            	    {
            	         MATCHT(FP_TO_FP_TOK, &FOLLOW_FP_TO_FP_TOK_in_indexedFunctionName5115);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        eb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5119);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        sb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5123);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(FloatingPointToFPGeneric(
            	                            AntlrInput::tokenToUnsigned(eb),
            	                            AntlrInput::tokenToUnsigned(sb)));
            	                  
            	        }


            	    }
            	    break;
            	case 15:
            	    // ../../../../src/parser/smt2/Smt2.g:2513:7: FP_TO_FPBV_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL
            	    {
            	         MATCHT(FP_TO_FPBV_TOK, &FOLLOW_FP_TO_FPBV_TOK_in_indexedFunctionName5139);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        eb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5143);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        sb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5147);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(FloatingPointToFPIEEEBitVector(
            	                            AntlrInput::tokenToUnsigned(eb),
            	                            AntlrInput::tokenToUnsigned(sb)));
            	                  
            	        }


            	    }
            	    break;
            	case 16:
            	    // ../../../../src/parser/smt2/Smt2.g:2518:7: FP_TO_FPFP_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL
            	    {
            	         MATCHT(FP_TO_FPFP_TOK, &FOLLOW_FP_TO_FPFP_TOK_in_indexedFunctionName5163);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        eb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5167);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        sb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5171);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(FloatingPointToFPFloatingPoint(
            	                            AntlrInput::tokenToUnsigned(eb),
            	                            AntlrInput::tokenToUnsigned(sb)));
            	                  
            	        }


            	    }
            	    break;
            	case 17:
            	    // ../../../../src/parser/smt2/Smt2.g:2523:7: FP_TO_FPR_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL
            	    {
            	         MATCHT(FP_TO_FPR_TOK, &FOLLOW_FP_TO_FPR_TOK_in_indexedFunctionName5187);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        eb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5191);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        sb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5195);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(FloatingPointToFPReal(AntlrInput::tokenToUnsigned(eb),
            	                                                        AntlrInput::tokenToUnsigned(sb)));
            	                  
            	        }


            	    }
            	    break;
            	case 18:
            	    // ../../../../src/parser/smt2/Smt2.g:2527:7: FP_TO_FPS_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL
            	    {
            	         MATCHT(FP_TO_FPS_TOK, &FOLLOW_FP_TO_FPS_TOK_in_indexedFunctionName5211);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        eb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5215);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        sb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5219);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(FloatingPointToFPSignedBitVector(
            	                            AntlrInput::tokenToUnsigned(eb),
            	                            AntlrInput::tokenToUnsigned(sb)));
            	                  
            	        }


            	    }
            	    break;
            	case 19:
            	    // ../../../../src/parser/smt2/Smt2.g:2532:7: FP_TO_FPU_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL
            	    {
            	         MATCHT(FP_TO_FPU_TOK, &FOLLOW_FP_TO_FPU_TOK_in_indexedFunctionName5235);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        eb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5239);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        sb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5243);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(FloatingPointToFPUnsignedBitVector(
            	                            AntlrInput::tokenToUnsigned(eb),
            	                            AntlrInput::tokenToUnsigned(sb)));
            	                  
            	        }


            	    }
            	    break;
            	case 20:
            	    // ../../../../src/parser/smt2/Smt2.g:2537:7: FP_TO_UBV_TOK m= INTEGER_LITERAL
            	    {
            	         MATCHT(FP_TO_UBV_TOK, &FOLLOW_FP_TO_UBV_TOK_in_indexedFunctionName5259);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        m = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5263);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(FloatingPointToUBV(AntlrInput::tokenToUnsigned(m))); 
            	        }


            	    }
            	    break;
            	case 21:
            	    // ../../../../src/parser/smt2/Smt2.g:2539:7: FP_TO_SBV_TOK m= INTEGER_LITERAL
            	    {
            	         MATCHT(FP_TO_SBV_TOK, &FOLLOW_FP_TO_SBV_TOK_in_indexedFunctionName5279);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        m = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5283);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(FloatingPointToSBV(AntlrInput::tokenToUnsigned(m))); 
            	        }


            	    }
            	    break;
            	case 22:
            	    // ../../../../src/parser/smt2/Smt2.g:2541:7: TESTER_TOK term[expr, expr2]
            	    {
            	         MATCHT(TESTER_TOK, &FOLLOW_TESTER_TOK_in_indexedFunctionName5299);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        FOLLOWPUSH(FOLLOW_term_in_indexedFunctionName5301);
            	        term(ctx, expr, expr2);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             
            	                    if( expr.getKind()==kind::APPLY_CONSTRUCTOR && expr.getNumChildren()==0 ){
            	                      //for nullary constructors, must get the operator
            	                      expr = expr.getOperator();
            	                    }
            	                    if( !expr.getType().isConstructor() ){
            	                      PARSER_STATE->parseError("Bad syntax for test (_ is X), X must be a constructor.");
            	                    }
            	                    op = Datatype::datatypeOf(expr)[Datatype::indexOf(expr)].getTester();
            	                    kind = CVC4::kind::APPLY_TESTER;
            	                  
            	        }


            	    }
            	    break;
            	case 23:
            	    // ../../../../src/parser/smt2/Smt2.g:2552:7: badIndexedFunctionName
            	    {
            	        FOLLOWPUSH(FOLLOW_badIndexedFunctionName_in_indexedFunctionName5312);
            	        badIndexedFunctionName(ctx);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	    }
            	    break;

                }
            }

             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_indexedFunctionName5324);
            if  (HASEXCEPTION())
            {
                goto ruleindexedFunctionNameEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleindexedFunctionNameEx; /* Prevent compiler warnings */
    ruleindexedFunctionNameEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end indexedFunctionName */

/**
 * $ANTLR start badIndexedFunctionName
 * ../../../../src/parser/smt2/Smt2.g:2561:1: badIndexedFunctionName : id= ( SIMPLE_SYMBOL | QUOTED_SYMBOL | UNTERMINATED_QUOTED_SYMBOL ) ;
 */
static void
badIndexedFunctionName(pSmt2Parser ctx)
{

      std::string name;

    pANTLR3_COMMON_TOKEN    id;

    /* Initialize rule variables
     */

    id       = NULL;

    {
        // ../../../../src/parser/smt2/Smt2.g:2565:3: (id= ( SIMPLE_SYMBOL | QUOTED_SYMBOL | UNTERMINATED_QUOTED_SYMBOL ) )
        // ../../../../src/parser/smt2/Smt2.g:2565:5: id= ( SIMPLE_SYMBOL | QUOTED_SYMBOL | UNTERMINATED_QUOTED_SYMBOL )
        {
            id=(pANTLR3_COMMON_TOKEN)LT(1);

            if ( LA(1) == QUOTED_SYMBOL || LA(1) == SIMPLE_SYMBOL || LA(1) == UNTERMINATED_QUOTED_SYMBOL )
            {
                CONSUME();
                PERRORRECOVERY=ANTLR3_FALSE;
            }
            else
            {
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
                EXCEPTION->expectingSet = NULL;

                goto rulebadIndexedFunctionNameEx;
            }


            {
                 PARSER_STATE->parseError(std::string("Unknown indexed function `") +
                          AntlrInput::tokenText(id) + "'");
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulebadIndexedFunctionNameEx; /* Prevent compiler warnings */
    rulebadIndexedFunctionNameEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end badIndexedFunctionName */

/**
 * $ANTLR start termList
 * ../../../../src/parser/smt2/Smt2.g:2579:1: termList[std::vector<CVC4::Expr>& formulas, CVC4::Expr& expr] : ( term[expr, expr2] )+ ;
 */
static void
termList(pSmt2Parser ctx, std::vector<CVC4::Expr>& formulas, CVC4::Expr& expr)
{

      Expr expr2;

    /* Initialize rule variables
     */

    {
        // ../../../../src/parser/smt2/Smt2.g:2583:3: ( ( term[expr, expr2] )+ )
        // ../../../../src/parser/smt2/Smt2.g:2583:5: ( term[expr, expr2] )+
        {
            // ../../../../src/parser/smt2/Smt2.g:2583:5: ( term[expr, expr2] )+
            {
                int cnt62=0;

                for (;;)
                {
                    int alt62=2;
            	switch ( LA(1) )
            	{
            	case BINARY_LITERAL:
            	case CHECK_SYNTH_TOK:
            	case CONSTRAINT_TOK:
            	case DECIMAL_LITERAL:
            	case DECLARE_PRIMED_VAR_TOK:
            	case DECLARE_VAR_TOK:
            	case EMPTYSET_TOK:
            	case FP_RNA_FULL_TOK:
            	case FP_RNA_TOK:
            	case FP_RNE_FULL_TOK:
            	case FP_RNE_TOK:
            	case FP_RTN_FULL_TOK:
            	case FP_RTN_TOK:
            	case FP_RTP_FULL_TOK:
            	case FP_RTP_TOK:
            	case FP_RTZ_FULL_TOK:
            	case FP_RTZ_TOK:
            	case HEX_LITERAL:
            	case INTEGER_LITERAL:
            	case INV_CONSTRAINT_TOK:
            	case LPAREN_TOK:
            	case NILREF_TOK:
            	case QUOTED_SYMBOL:
            	case REALLCHAR_TOK:
            	case RENOSTR_TOK:
            	case SET_OPTIONS_TOK:
            	case SIMPLE_SYMBOL:
            	case STRING_LITERAL_2_0:
            	case STRING_LITERAL_2_5:
            	case SYNTH_FUN_TOK:
            	case SYNTH_INV_TOK:
            	case UNIVSET_TOK:
            	case UNTERMINATED_QUOTED_SYMBOL:
            	case 154:
            		{
            			alt62=1;
            		}
            	    break;

            	}

            	switch (alt62)
            	{
            	    case 1:
            	        // ../../../../src/parser/smt2/Smt2.g:2583:7: term[expr, expr2]
            	        {
            	            FOLLOWPUSH(FOLLOW_term_in_termList5387);
            	            term(ctx, expr, expr2);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruletermListEx;
            	            }


            	            {
            	                 formulas.push_back(expr); 
            	            }


            	        }
            	        break;

            	    default:

            		if ( cnt62 >= 1 )
            		{
            		    goto loop62;
            		}
            		/* mismatchedSetEx()
            		 */
            		CONSTRUCTEX();
            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            		goto ruletermListEx;
            	}
            	cnt62++;
                }
                loop62: ;	/* Jump to here if this rule does not match */
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto ruletermListEx; /* Prevent compiler warnings */
    ruletermListEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end termList */

/**
 * $ANTLR start str
 * ../../../../src/parser/smt2/Smt2.g:2589:1: str[std::string& s, bool fsmtlib] : ( STRING_LITERAL_2_0 | STRING_LITERAL_2_5 );
 */
static void
str(pSmt2Parser ctx, std::string& s, bool fsmtlib)
{
    pANTLR3_COMMON_TOKEN    STRING_LITERAL_2_020;
    pANTLR3_COMMON_TOKEN    STRING_LITERAL_2_521;

    /* Initialize rule variables
     */

    STRING_LITERAL_2_020       = NULL;
    STRING_LITERAL_2_521       = NULL;

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:2590:3: ( STRING_LITERAL_2_0 | STRING_LITERAL_2_5 )

            ANTLR3_UINT32 alt63;

            alt63=2;

            switch ( LA(1) )
            {
            case STRING_LITERAL_2_0:
            	{
            		alt63=1;
            	}
                break;
            case STRING_LITERAL_2_5:
            	{
            		alt63=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 63;
                EXCEPTION->state        = 0;


                goto rulestrEx;

            }

            switch (alt63)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:2590:5: STRING_LITERAL_2_0
        	    {
        	        STRING_LITERAL_2_020 = (pANTLR3_COMMON_TOKEN) MATCHT(STRING_LITERAL_2_0, &FOLLOW_STRING_LITERAL_2_0_in_str5409);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestrEx;
        	        }


        	        {
        	             s = AntlrInput::tokenText(STRING_LITERAL_2_020);
        	                  /* strip off the quotes */
        	                  s = s.substr(1, s.size() - 2);
        	                  for(size_t i=0; i<s.size(); i++) {
        	                    if((unsigned)s[i] > 127 && !isprint(s[i])) {
        	                      PARSER_STATE->parseError("Extended/unprintable characters are not "
        	                                               "part of SMT-LIB, and they must be encoded "
        	                                               "as escape sequences");
        	                    }
        	                  }
        	                  if(fsmtlib) {
        	                    /* handle SMT-LIB standard escapes '\\' and '\"' */
        	                    char* p_orig = strdup(s.c_str());
        	                    char *p = p_orig, *q = p_orig;
        	                    while(*q != '\0') {
        	                      if(*q == '\\') {
        	                        ++q;
        	                        if(*q == '\\' || *q == '"') {
        	                          *p++ = *q++;
        	                        } else {
        	                          assert(*q != '\0');
        	                          *p++ = '\\';
        	                          *p++ = *q++;
        	                        }
        	                      } else {
        	                        *p++ = *q++;
        	                      }
        	                    }
        	                    *p = '\0';
        	                    s = p_orig;
        	                    free(p_orig);
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:2624:5: STRING_LITERAL_2_5
        	    {
        	        STRING_LITERAL_2_521 = (pANTLR3_COMMON_TOKEN) MATCHT(STRING_LITERAL_2_5, &FOLLOW_STRING_LITERAL_2_5_in_str5421);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestrEx;
        	        }


        	        {
        	             s = AntlrInput::tokenText(STRING_LITERAL_2_521);
        	                  /* strip off the quotes */
        	                  s = s.substr(1, s.size() - 2);
        	                  for(size_t i=0; i<s.size(); i++) {
        	                    if((unsigned)s[i] > 127 && !isprint(s[i])) {
        	                      PARSER_STATE->parseError("Extended/unprintable characters are not "
        	                                               "part of SMT-LIB, and they must be encoded "
        	                                               "as escape sequences");
        	                    }
        	                  }
        	                  // In the 2.5 version, always handle escapes (regardless of fsmtlib flag).
        	                  char* p_orig = strdup(s.c_str());
        	                  char *p = p_orig, *q = p_orig;
        	                  while(*q != '\0') {
        	                    if(*q == '"') {
        	                      ++q;
        	                      assert(*q == '"');
        	                    }
        	                    *p++ = *q++;
        	                  }
        	                  *p = '\0';
        	                  s = p_orig;
        	                  free(p_orig);
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulestrEx; /* Prevent compiler warnings */
    rulestrEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end str */

/**
 * $ANTLR start builtinOp
 * ../../../../src/parser/smt2/Smt2.g:2654:1: builtinOp[CVC4::Kind& kind] : ( NOT_TOK | IMPLIES_TOK | AND_TOK | OR_TOK | XOR_TOK | EQUAL_TOK | DISTINCT_TOK | ITE_TOK | GREATER_THAN_TOK | GREATER_THAN_EQUAL_TOK | LESS_THAN_EQUAL_TOK | LESS_THAN_TOK | PLUS_TOK | MINUS_TOK | STAR_TOK | DIV_TOK | BV2NAT_TOK | DTSIZE_TOK | FMFCARD_TOK | FMFCARDVAL_TOK | INST_CLOSURE_TOK );
 */
static void
builtinOp(pSmt2Parser ctx, CVC4::Kind& kind)
{
    /* Initialize rule variables
     */


      Debug("parser") << "builtin: " << AntlrInput::tokenText(LT(1)) << std::endl;

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:2658:3: ( NOT_TOK | IMPLIES_TOK | AND_TOK | OR_TOK | XOR_TOK | EQUAL_TOK | DISTINCT_TOK | ITE_TOK | GREATER_THAN_TOK | GREATER_THAN_EQUAL_TOK | LESS_THAN_EQUAL_TOK | LESS_THAN_TOK | PLUS_TOK | MINUS_TOK | STAR_TOK | DIV_TOK | BV2NAT_TOK | DTSIZE_TOK | FMFCARD_TOK | FMFCARDVAL_TOK | INST_CLOSURE_TOK )

            ANTLR3_UINT32 alt64;

            alt64=21;

            switch ( LA(1) )
            {
            case NOT_TOK:
            	{
            		alt64=1;
            	}
                break;
            case IMPLIES_TOK:
            	{
            		alt64=2;
            	}
                break;
            case AND_TOK:
            	{
            		alt64=3;
            	}
                break;
            case OR_TOK:
            	{
            		alt64=4;
            	}
                break;
            case XOR_TOK:
            	{
            		alt64=5;
            	}
                break;
            case EQUAL_TOK:
            	{
            		alt64=6;
            	}
                break;
            case DISTINCT_TOK:
            	{
            		alt64=7;
            	}
                break;
            case ITE_TOK:
            	{
            		alt64=8;
            	}
                break;
            case GREATER_THAN_TOK:
            	{
            		alt64=9;
            	}
                break;
            case GREATER_THAN_EQUAL_TOK:
            	{
            		alt64=10;
            	}
                break;
            case LESS_THAN_EQUAL_TOK:
            	{
            		alt64=11;
            	}
                break;
            case LESS_THAN_TOK:
            	{
            		alt64=12;
            	}
                break;
            case PLUS_TOK:
            	{
            		alt64=13;
            	}
                break;
            case MINUS_TOK:
            	{
            		alt64=14;
            	}
                break;
            case STAR_TOK:
            	{
            		alt64=15;
            	}
                break;
            case DIV_TOK:
            	{
            		alt64=16;
            	}
                break;
            case BV2NAT_TOK:
            	{
            		alt64=17;
            	}
                break;
            case DTSIZE_TOK:
            	{
            		alt64=18;
            	}
                break;
            case FMFCARD_TOK:
            	{
            		alt64=19;
            	}
                break;
            case FMFCARDVAL_TOK:
            	{
            		alt64=20;
            	}
                break;
            case INST_CLOSURE_TOK:
            	{
            		alt64=21;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 64;
                EXCEPTION->state        = 0;


                goto rulebuiltinOpEx;

            }

            switch (alt64)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:2658:5: NOT_TOK
        	    {
        	         MATCHT(NOT_TOK, &FOLLOW_NOT_TOK_in_builtinOp5448);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::NOT;     
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:2659:5: IMPLIES_TOK
        	    {
        	         MATCHT(IMPLIES_TOK, &FOLLOW_IMPLIES_TOK_in_builtinOp5461);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::IMPLIES; 
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/smt2/Smt2.g:2660:5: AND_TOK
        	    {
        	         MATCHT(AND_TOK, &FOLLOW_AND_TOK_in_builtinOp5470);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::AND;     
        	        }


        	    }
        	    break;
        	case 4:
        	    // ../../../../src/parser/smt2/Smt2.g:2661:5: OR_TOK
        	    {
        	         MATCHT(OR_TOK, &FOLLOW_OR_TOK_in_builtinOp5483);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::OR;      
        	        }


        	    }
        	    break;
        	case 5:
        	    // ../../../../src/parser/smt2/Smt2.g:2662:5: XOR_TOK
        	    {
        	         MATCHT(XOR_TOK, &FOLLOW_XOR_TOK_in_builtinOp5497);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::XOR;     
        	        }


        	    }
        	    break;
        	case 6:
        	    // ../../../../src/parser/smt2/Smt2.g:2663:5: EQUAL_TOK
        	    {
        	         MATCHT(EQUAL_TOK, &FOLLOW_EQUAL_TOK_in_builtinOp5510);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::EQUAL;   
        	        }


        	    }
        	    break;
        	case 7:
        	    // ../../../../src/parser/smt2/Smt2.g:2664:5: DISTINCT_TOK
        	    {
        	         MATCHT(DISTINCT_TOK, &FOLLOW_DISTINCT_TOK_in_builtinOp5521);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::DISTINCT; 
        	        }


        	    }
        	    break;
        	case 8:
        	    // ../../../../src/parser/smt2/Smt2.g:2665:5: ITE_TOK
        	    {
        	         MATCHT(ITE_TOK, &FOLLOW_ITE_TOK_in_builtinOp5529);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::ITE; 
        	        }


        	    }
        	    break;
        	case 9:
        	    // ../../../../src/parser/smt2/Smt2.g:2666:5: GREATER_THAN_TOK
        	    {
        	         MATCHT(GREATER_THAN_TOK, &FOLLOW_GREATER_THAN_TOK_in_builtinOp5542);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::GT; 
        	        }


        	    }
        	    break;
        	case 10:
        	    // ../../../../src/parser/smt2/Smt2.g:2668:5: GREATER_THAN_EQUAL_TOK
        	    {
        	         MATCHT(GREATER_THAN_EQUAL_TOK, &FOLLOW_GREATER_THAN_EQUAL_TOK_in_builtinOp5567);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::GEQ; 
        	        }


        	    }
        	    break;
        	case 11:
        	    // ../../../../src/parser/smt2/Smt2.g:2670:5: LESS_THAN_EQUAL_TOK
        	    {
        	         MATCHT(LESS_THAN_EQUAL_TOK, &FOLLOW_LESS_THAN_EQUAL_TOK_in_builtinOp5592);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::LEQ; 
        	        }


        	    }
        	    break;
        	case 12:
        	    // ../../../../src/parser/smt2/Smt2.g:2672:5: LESS_THAN_TOK
        	    {
        	         MATCHT(LESS_THAN_TOK, &FOLLOW_LESS_THAN_TOK_in_builtinOp5617);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::LT; 
        	        }


        	    }
        	    break;
        	case 13:
        	    // ../../../../src/parser/smt2/Smt2.g:2674:5: PLUS_TOK
        	    {
        	         MATCHT(PLUS_TOK, &FOLLOW_PLUS_TOK_in_builtinOp5642);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::PLUS; 
        	        }


        	    }
        	    break;
        	case 14:
        	    // ../../../../src/parser/smt2/Smt2.g:2675:5: MINUS_TOK
        	    {
        	         MATCHT(MINUS_TOK, &FOLLOW_MINUS_TOK_in_builtinOp5654);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::MINUS; 
        	        }


        	    }
        	    break;
        	case 15:
        	    // ../../../../src/parser/smt2/Smt2.g:2676:5: STAR_TOK
        	    {
        	         MATCHT(STAR_TOK, &FOLLOW_STAR_TOK_in_builtinOp5665);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::MULT; 
        	        }


        	    }
        	    break;
        	case 16:
        	    // ../../../../src/parser/smt2/Smt2.g:2677:5: DIV_TOK
        	    {
        	         MATCHT(DIV_TOK, &FOLLOW_DIV_TOK_in_builtinOp5677);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::DIVISION; 
        	        }


        	    }
        	    break;
        	case 17:
        	    // ../../../../src/parser/smt2/Smt2.g:2679:5: BV2NAT_TOK
        	    {
        	         MATCHT(BV2NAT_TOK, &FOLLOW_BV2NAT_TOK_in_builtinOp5691);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::BITVECTOR_TO_NAT;
        	                  if(PARSER_STATE->strictModeEnabled()) {
        	                    PARSER_STATE->parseError("bv2nat and int2bv are not part of SMT-LIB, "
        	                                             "and aren't available in SMT-LIB strict "
        	                                             "compliance mode");
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 18:
        	    // ../../../../src/parser/smt2/Smt2.g:2688:5: DTSIZE_TOK
        	    {
        	         MATCHT(DTSIZE_TOK, &FOLLOW_DTSIZE_TOK_in_builtinOp5704);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::DT_SIZE; 
        	        }


        	    }
        	    break;
        	case 19:
        	    // ../../../../src/parser/smt2/Smt2.g:2689:5: FMFCARD_TOK
        	    {
        	         MATCHT(FMFCARD_TOK, &FOLLOW_FMFCARD_TOK_in_builtinOp5718);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::CARDINALITY_CONSTRAINT; 
        	        }


        	    }
        	    break;
        	case 20:
        	    // ../../../../src/parser/smt2/Smt2.g:2690:5: FMFCARDVAL_TOK
        	    {
        	         MATCHT(FMFCARDVAL_TOK, &FOLLOW_FMFCARDVAL_TOK_in_builtinOp5731);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::CARDINALITY_VALUE; 
        	        }


        	    }
        	    break;
        	case 21:
        	    // ../../../../src/parser/smt2/Smt2.g:2691:5: INST_CLOSURE_TOK
        	    {
        	         MATCHT(INST_CLOSURE_TOK, &FOLLOW_INST_CLOSURE_TOK_in_builtinOp5741);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::INST_CLOSURE; 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulebuiltinOpEx; /* Prevent compiler warnings */
    rulebuiltinOpEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end builtinOp */

/**
 * $ANTLR start quantOp
 * ../../../../src/parser/smt2/Smt2.g:2701:1: quantOp[CVC4::Kind& kind] : ( EXISTS_TOK | FORALL_TOK );
 */
static void
quantOp(pSmt2Parser ctx, CVC4::Kind& kind)
{
    /* Initialize rule variables
     */


      Debug("parser") << "quant: " << AntlrInput::tokenText(LT(1)) << std::endl;

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:2705:3: ( EXISTS_TOK | FORALL_TOK )

            ANTLR3_UINT32 alt65;

            alt65=2;

            switch ( LA(1) )
            {
            case EXISTS_TOK:
            	{
            		alt65=1;
            	}
                break;
            case FORALL_TOK:
            	{
            		alt65=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 65;
                EXCEPTION->state        = 0;


                goto rulequantOpEx;

            }

            switch (alt65)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:2705:5: EXISTS_TOK
        	    {
        	         MATCHT(EXISTS_TOK, &FOLLOW_EXISTS_TOK_in_quantOp5783);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulequantOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::EXISTS; 
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:2706:5: FORALL_TOK
        	    {
        	         MATCHT(FORALL_TOK, &FOLLOW_FORALL_TOK_in_quantOp5794);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulequantOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::FORALL; 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulequantOpEx; /* Prevent compiler warnings */
    rulequantOpEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end quantOp */

/**
 * $ANTLR start functionName
 * ../../../../src/parser/smt2/Smt2.g:2713:1: functionName[std::string& name, CVC4::parser::DeclarationCheck check] : symbol[name,check,SYM_VARIABLE] ;
 */
static void
functionName(pSmt2Parser ctx, std::string& name, CVC4::parser::DeclarationCheck check)
{
    /* Initialize rule variables
     */

    {
        // ../../../../src/parser/smt2/Smt2.g:2714:3: ( symbol[name,check,SYM_VARIABLE] )
        // ../../../../src/parser/smt2/Smt2.g:2714:5: symbol[name,check,SYM_VARIABLE]
        {
            FOLLOWPUSH(FOLLOW_symbol_in_functionName5815);
            symbol(ctx, name, check, SYM_VARIABLE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulefunctionNameEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulefunctionNameEx; /* Prevent compiler warnings */
    rulefunctionNameEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end functionName */

/**
 * $ANTLR start sortList
 * ../../../../src/parser/smt2/Smt2.g:2721:1: sortList[std::vector<CVC4::Type>& sorts] : ( sortSymbol[t,CHECK_DECLARED] )* ;
 */
static void
sortList(pSmt2Parser ctx, std::vector<CVC4::Type>& sorts)
{

      Type t;

    /* Initialize rule variables
     */

    {
        // ../../../../src/parser/smt2/Smt2.g:2725:3: ( ( sortSymbol[t,CHECK_DECLARED] )* )
        // ../../../../src/parser/smt2/Smt2.g:2725:5: ( sortSymbol[t,CHECK_DECLARED] )*
        {
            // ../../../../src/parser/smt2/Smt2.g:2725:5: ( sortSymbol[t,CHECK_DECLARED] )*

            for (;;)
            {
                int alt66=2;
                switch ( LA(1) )
                {
                case CHECK_SYNTH_TOK:
                case CONSTRAINT_TOK:
                case DECLARE_PRIMED_VAR_TOK:
                case DECLARE_VAR_TOK:
                case INV_CONSTRAINT_TOK:
                case LPAREN_TOK:
                case QUOTED_SYMBOL:
                case SET_OPTIONS_TOK:
                case SIMPLE_SYMBOL:
                case SYNTH_FUN_TOK:
                case SYNTH_INV_TOK:
                case UNTERMINATED_QUOTED_SYMBOL:
                case 154:
                	{
                		alt66=1;
                	}
                    break;

                }

                switch (alt66)
                {
            	case 1:
            	    // ../../../../src/parser/smt2/Smt2.g:2725:7: sortSymbol[t,CHECK_DECLARED]
            	    {
            	        FOLLOWPUSH(FOLLOW_sortSymbol_in_sortList5839);
            	        sortSymbol(ctx, t, CHECK_DECLARED);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulesortListEx;
            	        }


            	        {
            	             sorts.push_back(t); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop66;	/* break out of the loop */
            	    break;
                }
            }
            loop66: ; /* Jump out to here if this rule does not match */


        }

    }

    // This is where rules clean up and exit
    //
    goto rulesortListEx; /* Prevent compiler warnings */
    rulesortListEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end sortList */

/**
 * $ANTLR start nonemptySortList
 * ../../../../src/parser/smt2/Smt2.g:2728:1: nonemptySortList[std::vector<CVC4::Type>& sorts] : ( sortSymbol[t,CHECK_DECLARED] )+ ;
 */
static void
nonemptySortList(pSmt2Parser ctx, std::vector<CVC4::Type>& sorts)
{

      Type t;

    /* Initialize rule variables
     */

    {
        // ../../../../src/parser/smt2/Smt2.g:2732:3: ( ( sortSymbol[t,CHECK_DECLARED] )+ )
        // ../../../../src/parser/smt2/Smt2.g:2732:5: ( sortSymbol[t,CHECK_DECLARED] )+
        {
            // ../../../../src/parser/smt2/Smt2.g:2732:5: ( sortSymbol[t,CHECK_DECLARED] )+
            {
                int cnt67=0;

                for (;;)
                {
                    int alt67=2;
            	switch ( LA(1) )
            	{
            	case CHECK_SYNTH_TOK:
            	case CONSTRAINT_TOK:
            	case DECLARE_PRIMED_VAR_TOK:
            	case DECLARE_VAR_TOK:
            	case INV_CONSTRAINT_TOK:
            	case LPAREN_TOK:
            	case QUOTED_SYMBOL:
            	case SET_OPTIONS_TOK:
            	case SIMPLE_SYMBOL:
            	case SYNTH_FUN_TOK:
            	case SYNTH_INV_TOK:
            	case UNTERMINATED_QUOTED_SYMBOL:
            	case 154:
            		{
            			alt67=1;
            		}
            	    break;

            	}

            	switch (alt67)
            	{
            	    case 1:
            	        // ../../../../src/parser/smt2/Smt2.g:2732:7: sortSymbol[t,CHECK_DECLARED]
            	        {
            	            FOLLOWPUSH(FOLLOW_sortSymbol_in_nonemptySortList5866);
            	            sortSymbol(ctx, t, CHECK_DECLARED);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulenonemptySortListEx;
            	            }


            	            {
            	                 sorts.push_back(t); 
            	            }


            	        }
            	        break;

            	    default:

            		if ( cnt67 >= 1 )
            		{
            		    goto loop67;
            		}
            		/* mismatchedSetEx()
            		 */
            		CONSTRUCTEX();
            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            		goto rulenonemptySortListEx;
            	}
            	cnt67++;
                }
                loop67: ;	/* Jump to here if this rule does not match */
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto rulenonemptySortListEx; /* Prevent compiler warnings */
    rulenonemptySortListEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end nonemptySortList */

/**
 * $ANTLR start sortedVarList
 * ../../../../src/parser/smt2/Smt2.g:2739:1: sortedVarList[std::vector<std::pair<std::string, CVC4::Type> >& sortedVars] : ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] RPAREN_TOK )* ;
 */
static void
sortedVarList(pSmt2Parser ctx, std::vector<std::pair<std::string, CVC4::Type> >& sortedVars)
{

      std::string name;
      Type t;

    /* Initialize rule variables
     */

    {
        // ../../../../src/parser/smt2/Smt2.g:2744:3: ( ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] RPAREN_TOK )* )
        // ../../../../src/parser/smt2/Smt2.g:2744:5: ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] RPAREN_TOK )*
        {
            // ../../../../src/parser/smt2/Smt2.g:2744:5: ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] RPAREN_TOK )*

            for (;;)
            {
                int alt68=2;
                switch ( LA(1) )
                {
                case LPAREN_TOK:
                	{
                		alt68=1;
                	}
                    break;

                }

                switch (alt68)
                {
            	case 1:
            	    // ../../../../src/parser/smt2/Smt2.g:2744:7: LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] RPAREN_TOK
            	    {
            	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sortedVarList5895);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulesortedVarListEx;
            	        }


            	        FOLLOWPUSH(FOLLOW_symbol_in_sortedVarList5897);
            	        symbol(ctx, name, CHECK_NONE, SYM_VARIABLE);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulesortedVarListEx;
            	        }


            	        FOLLOWPUSH(FOLLOW_sortSymbol_in_sortedVarList5906);
            	        sortSymbol(ctx, t, CHECK_DECLARED);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulesortedVarListEx;
            	        }


            	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sortedVarList5909);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulesortedVarListEx;
            	        }


            	        {
            	             sortedVars.push_back(make_pair(name, t)); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop68;	/* break out of the loop */
            	    break;
                }
            }
            loop68: ; /* Jump out to here if this rule does not match */


        }

    }

    // This is where rules clean up and exit
    //
    goto rulesortedVarListEx; /* Prevent compiler warnings */
    rulesortedVarListEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end sortedVarList */

/**
 * $ANTLR start sortName
 * ../../../../src/parser/smt2/Smt2.g:2754:1: sortName[std::string& name, CVC4::parser::DeclarationCheck check] : symbol[name,check,SYM_SORT] ;
 */
static void
sortName(pSmt2Parser ctx, std::string& name, CVC4::parser::DeclarationCheck check)
{
    /* Initialize rule variables
     */

    {
        // ../../../../src/parser/smt2/Smt2.g:2755:3: ( symbol[name,check,SYM_SORT] )
        // ../../../../src/parser/smt2/Smt2.g:2755:5: symbol[name,check,SYM_SORT]
        {
            FOLLOWPUSH(FOLLOW_symbol_in_sortName5940);
            symbol(ctx, name, check, SYM_SORT);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulesortNameEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulesortNameEx; /* Prevent compiler warnings */
    rulesortNameEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end sortName */

/**
 * $ANTLR start sortSymbol
 * ../../../../src/parser/smt2/Smt2.g:2758:1: sortSymbol[CVC4::Type& t, CVC4::parser::DeclarationCheck check] : ( sortName[name,CHECK_NONE] | LPAREN_TOK ( INDEX_TOK |) symbol[name,CHECK_NONE,SYM_SORT] ( nonemptyNumeralList[numerals] | sortList[args] ) RPAREN_TOK );
 */
static void
sortSymbol(pSmt2Parser ctx, CVC4::Type& t, CVC4::parser::DeclarationCheck check)
{

      std::string name;
      std::vector<CVC4::Type> args;
      std::vector<uint64_t> numerals;
      bool indexed = false;

    /* Initialize rule variables
     */

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:2765:3: ( sortName[name,CHECK_NONE] | LPAREN_TOK ( INDEX_TOK |) symbol[name,CHECK_NONE,SYM_SORT] ( nonemptyNumeralList[numerals] | sortList[args] ) RPAREN_TOK )

            ANTLR3_UINT32 alt71;

            alt71=2;

            switch ( LA(1) )
            {
            case CHECK_SYNTH_TOK:
            case CONSTRAINT_TOK:
            case DECLARE_PRIMED_VAR_TOK:
            case DECLARE_VAR_TOK:
            case INV_CONSTRAINT_TOK:
            case QUOTED_SYMBOL:
            case SET_OPTIONS_TOK:
            case SIMPLE_SYMBOL:
            case SYNTH_FUN_TOK:
            case SYNTH_INV_TOK:
            case UNTERMINATED_QUOTED_SYMBOL:
            case 154:
            	{
            		alt71=1;
            	}
                break;
            case LPAREN_TOK:
            	{
            		alt71=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 71;
                EXCEPTION->state        = 0;


                goto rulesortSymbolEx;

            }

            switch (alt71)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:2765:5: sortName[name,CHECK_NONE]
        	    {
        	        FOLLOWPUSH(FOLLOW_sortName_in_sortSymbol5960);
        	        sortName(ctx, name, CHECK_NONE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesortSymbolEx;
        	        }


        	        {

        	                  if(check == CHECK_DECLARED || PARSER_STATE->isDeclared(name, SYM_SORT)) {
        	                    t = PARSER_STATE->getSort(name);
        	                  } else {
        	                    t = PARSER_STATE->mkUnresolvedType(name);
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:2773:5: LPAREN_TOK ( INDEX_TOK |) symbol[name,CHECK_NONE,SYM_SORT] ( nonemptyNumeralList[numerals] | sortList[args] ) RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sortSymbol5973);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesortSymbolEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:2773:16: ( INDEX_TOK |)
        	        {
        	            int alt69=2;
        	            switch ( LA(1) )
        	            {
        	            case INDEX_TOK:
        	            	{
        	            		alt69=1;
        	            	}
        	                break;
        	            case CHECK_SYNTH_TOK:
        	            case CONSTRAINT_TOK:
        	            case DECLARE_PRIMED_VAR_TOK:
        	            case DECLARE_VAR_TOK:
        	            case INV_CONSTRAINT_TOK:
        	            case QUOTED_SYMBOL:
        	            case SET_OPTIONS_TOK:
        	            case SIMPLE_SYMBOL:
        	            case SYNTH_FUN_TOK:
        	            case SYNTH_INV_TOK:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            case 154:
        	            	{
        	            		alt69=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 69;
        	                EXCEPTION->state        = 0;


        	                goto rulesortSymbolEx;

        	            }

        	            switch (alt69)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2773:17: INDEX_TOK
        	        	    {
        	        	         MATCHT(INDEX_TOK, &FOLLOW_INDEX_TOK_in_sortSymbol5976);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesortSymbolEx;
        	        	        }


        	        	        {
        	        	            indexed = true;
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2773:47: 
        	        	    {
        	        	        {
        	        	            indexed = false;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        FOLLOWPUSH(FOLLOW_symbol_in_sortSymbol5989);
        	        symbol(ctx, name, CHECK_NONE, SYM_SORT);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesortSymbolEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:2775:5: ( nonemptyNumeralList[numerals] | sortList[args] )
        	        {
        	            int alt70=2;
        	            switch ( LA(1) )
        	            {
        	            case INTEGER_LITERAL:
        	            	{
        	            		alt70=1;
        	            	}
        	                break;
        	            case CHECK_SYNTH_TOK:
        	            case CONSTRAINT_TOK:
        	            case DECLARE_PRIMED_VAR_TOK:
        	            case DECLARE_VAR_TOK:
        	            case INV_CONSTRAINT_TOK:
        	            case LPAREN_TOK:
        	            case QUOTED_SYMBOL:
        	            case RPAREN_TOK:
        	            case SET_OPTIONS_TOK:
        	            case SIMPLE_SYMBOL:
        	            case SYNTH_FUN_TOK:
        	            case SYNTH_INV_TOK:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            case 154:
        	            	{
        	            		alt70=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 70;
        	                EXCEPTION->state        = 0;


        	                goto rulesortSymbolEx;

        	            }

        	            switch (alt70)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2775:7: nonemptyNumeralList[numerals]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_nonemptyNumeralList_in_sortSymbol5998);
        	        	        nonemptyNumeralList(ctx, numerals);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesortSymbolEx;
        	        	        }


        	        	        {
        	        	             // allow sygus inputs to elide the `_'
        	        	                    if( !indexed && !PARSER_STATE->sygus() ) {
        	        	                      std::stringstream ss;
        	        	                      ss << "SMT-LIB requires use of an indexed sort here, e.g. (_ " << name
        	        	                         << " ...)";
        	        	                      PARSER_STATE->parseError(ss.str());
        	        	                    }
        	        	                    if( name == "BitVec" ) {
        	        	                      if( numerals.size() != 1 ) {
        	        	                        PARSER_STATE->parseError("Illegal bitvector type.");
        	        	                      }
        	        	                      if(numerals.front() == 0) {
        	        	                        PARSER_STATE->parseError("Illegal bitvector size: 0");
        	        	                      }
        	        	                      t = EXPR_MANAGER->mkBitVectorType(numerals.front());
        	        	                    } else if ( name == "FloatingPoint" ) {
        	        	                      if( numerals.size() != 2 ) {
        	        	                        PARSER_STATE->parseError("Illegal floating-point type.");
        	        	                      }
        	        	                      if(!validExponentSize(numerals[0])) {
        	        	                        PARSER_STATE->parseError("Illegal floating-point exponent size");
        	        	                      }
        	        	                      if(!validSignificandSize(numerals[1])) {
        	        	                        PARSER_STATE->parseError("Illegal floating-point significand size");
        	        	                      }
        	        	                      t = EXPR_MANAGER->mkFloatingPointType(numerals[0],numerals[1]);
        	        	                    } else {
        	        	                      std::stringstream ss;
        	        	                      ss << "unknown indexed sort symbol `" << name << "'";
        	        	                      PARSER_STATE->parseError(ss.str());
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2808:7: sortList[args]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_sortList_in_sortSymbol6015);
        	        	        sortList(ctx, args);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesortSymbolEx;
        	        	        }


        	        	        {
        	        	             if( indexed ) {
        	        	                      std::stringstream ss;
        	        	                      ss << "Unexpected use of indexing operator `_' before `" << name
        	        	                         << "', try leaving it out";
        	        	                      PARSER_STATE->parseError(ss.str());
        	        	                    }
        	        	                    if(args.empty()) {
        	        	                      PARSER_STATE->parseError("Extra parentheses around sort name not "
        	        	                                               "permitted in SMT-LIB");
        	        	                    } else if(name == "Array" &&
        	        	                       PARSER_STATE->isTheoryEnabled(Smt2::THEORY_ARRAYS) ) {
        	        	                      if(args.size() != 2) {
        	        	                        PARSER_STATE->parseError("Illegal array type.");
        	        	                      }
        	        	                      t = EXPR_MANAGER->mkArrayType( args[0], args[1] );
        	        	                    } else if(name == "Set" &&
        	        	                              PARSER_STATE->isTheoryEnabled(Smt2::THEORY_SETS) ) {
        	        	                      if(args.size() != 1) {
        	        	                        PARSER_STATE->parseError("Illegal set type.");
        	        	                      }
        	        	                      t = EXPR_MANAGER->mkSetType( args[0] );
        	        	                    } else if(check == CHECK_DECLARED ||
        	        	                              PARSER_STATE->isDeclared(name, SYM_SORT)) {
        	        	                      t = PARSER_STATE->getSort(name, args);
        	        	                    } else {
        	        	                      // make unresolved type
        	        	                      if(args.empty()) {
        	        	                        t = PARSER_STATE->mkUnresolvedType(name);
        	        	                        Debug("parser-param") << "param: make unres type " << name
        	        	                                              << std::endl;
        	        	                      } else {
        	        	                        t = PARSER_STATE->mkUnresolvedTypeConstructor(name,args);
        	        	                        t = SortConstructorType(t).instantiate( args );
        	        	                        Debug("parser-param")
        	        	                            << "param: make unres param type " << name << " " << args.size()
        	        	                            << " " << PARSER_STATE->getArity( name ) << std::endl;
        	        	                      }
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sortSymbol6032);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesortSymbolEx;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesortSymbolEx; /* Prevent compiler warnings */
    rulesortSymbolEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end sortSymbol */

/**
 * $ANTLR start symbolList
 * ../../../../src/parser/smt2/Smt2.g:2855:1: symbolList[std::vector<std::string>& names,\n CVC4::parser::DeclarationCheck check,\n CVC4::parser::SymbolType type] : ( symbol[id,check,type] )* ;
 */
static void
symbolList(pSmt2Parser ctx, std::vector<std::string>& names, CVC4::parser::DeclarationCheck check, CVC4::parser::SymbolType type)
{

      std::string id;

    /* Initialize rule variables
     */

    {
        // ../../../../src/parser/smt2/Smt2.g:2861:3: ( ( symbol[id,check,type] )* )
        // ../../../../src/parser/smt2/Smt2.g:2861:5: ( symbol[id,check,type] )*
        {
            // ../../../../src/parser/smt2/Smt2.g:2861:5: ( symbol[id,check,type] )*

            for (;;)
            {
                int alt72=2;
                switch ( LA(1) )
                {
                case CHECK_SYNTH_TOK:
                case CONSTRAINT_TOK:
                case DECLARE_PRIMED_VAR_TOK:
                case DECLARE_VAR_TOK:
                case INV_CONSTRAINT_TOK:
                case QUOTED_SYMBOL:
                case SET_OPTIONS_TOK:
                case SIMPLE_SYMBOL:
                case SYNTH_FUN_TOK:
                case SYNTH_INV_TOK:
                case UNTERMINATED_QUOTED_SYMBOL:
                case 154:
                	{
                		alt72=1;
                	}
                    break;

                }

                switch (alt72)
                {
            	case 1:
            	    // ../../../../src/parser/smt2/Smt2.g:2861:7: symbol[id,check,type]
            	    {
            	        FOLLOWPUSH(FOLLOW_symbol_in_symbolList6055);
            	        symbol(ctx, id, check, type);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulesymbolListEx;
            	        }


            	        {
            	             names.push_back(id); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop72;	/* break out of the loop */
            	    break;
                }
            }
            loop72: ; /* Jump out to here if this rule does not match */


        }

    }

    // This is where rules clean up and exit
    //
    goto rulesymbolListEx; /* Prevent compiler warnings */
    rulesymbolListEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end symbolList */

/**
 * $ANTLR start symbol
 * ../../../../src/parser/smt2/Smt2.g:2870:1: symbol[std::string& id,\n CVC4::parser::DeclarationCheck check,\n CVC4::parser::SymbolType type] : ( SIMPLE_SYMBOL | ( 'repeat' | SET_OPTIONS_TOK | DECLARE_VAR_TOK | DECLARE_PRIMED_VAR_TOK | SYNTH_FUN_TOK | SYNTH_INV_TOK | CONSTRAINT_TOK | INV_CONSTRAINT_TOK | CHECK_SYNTH_TOK ) | QUOTED_SYMBOL | UNTERMINATED_QUOTED_SYMBOL ( EOF | '\\\\' ) );
 */
static void
symbol(pSmt2Parser ctx, std::string& id, CVC4::parser::DeclarationCheck check, CVC4::parser::SymbolType type)
{
    pANTLR3_COMMON_TOKEN    SIMPLE_SYMBOL22;
    pANTLR3_COMMON_TOKEN    QUOTED_SYMBOL23;

    /* Initialize rule variables
     */

    SIMPLE_SYMBOL22       = NULL;
    QUOTED_SYMBOL23       = NULL;

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:2873:3: ( SIMPLE_SYMBOL | ( 'repeat' | SET_OPTIONS_TOK | DECLARE_VAR_TOK | DECLARE_PRIMED_VAR_TOK | SYNTH_FUN_TOK | SYNTH_INV_TOK | CONSTRAINT_TOK | INV_CONSTRAINT_TOK | CHECK_SYNTH_TOK ) | QUOTED_SYMBOL | UNTERMINATED_QUOTED_SYMBOL ( EOF | '\\\\' ) )

            ANTLR3_UINT32 alt75;

            alt75=4;

            switch ( LA(1) )
            {
            case SIMPLE_SYMBOL:
            	{
            		alt75=1;
            	}
                break;
            case CHECK_SYNTH_TOK:
            case CONSTRAINT_TOK:
            case DECLARE_PRIMED_VAR_TOK:
            case DECLARE_VAR_TOK:
            case INV_CONSTRAINT_TOK:
            case SET_OPTIONS_TOK:
            case SYNTH_FUN_TOK:
            case SYNTH_INV_TOK:
            case 154:
            	{
            		alt75=2;
            	}
                break;
            case QUOTED_SYMBOL:
            	{
            		alt75=3;
            	}
                break;
            case UNTERMINATED_QUOTED_SYMBOL:
            	{
            		alt75=4;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 75;
                EXCEPTION->state        = 0;


                goto rulesymbolEx;

            }

            switch (alt75)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:2873:5: SIMPLE_SYMBOL
        	    {
        	        SIMPLE_SYMBOL22 = (pANTLR3_COMMON_TOKEN) MATCHT(SIMPLE_SYMBOL, &FOLLOW_SIMPLE_SYMBOL_in_symbol6077);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolEx;
        	        }


        	        {
        	             id = AntlrInput::tokenText(SIMPLE_SYMBOL22);
        	                  if(!PARSER_STATE->isAbstractValue(id)) {
        	                    // if an abstract value, SmtEngine handles declaration
        	                    PARSER_STATE->checkDeclaration(id, check, type);
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:2880:5: ( 'repeat' | SET_OPTIONS_TOK | DECLARE_VAR_TOK | DECLARE_PRIMED_VAR_TOK | SYNTH_FUN_TOK | SYNTH_INV_TOK | CONSTRAINT_TOK | INV_CONSTRAINT_TOK | CHECK_SYNTH_TOK )
        	    {
        	        // ../../../../src/parser/smt2/Smt2.g:2880:5: ( 'repeat' | SET_OPTIONS_TOK | DECLARE_VAR_TOK | DECLARE_PRIMED_VAR_TOK | SYNTH_FUN_TOK | SYNTH_INV_TOK | CONSTRAINT_TOK | INV_CONSTRAINT_TOK | CHECK_SYNTH_TOK )
        	        {
        	            int alt73=9;
        	            switch ( LA(1) )
        	            {
        	            case 154:
        	            	{
        	            		alt73=1;
        	            	}
        	                break;
        	            case SET_OPTIONS_TOK:
        	            	{
        	            		alt73=2;
        	            	}
        	                break;
        	            case DECLARE_VAR_TOK:
        	            	{
        	            		alt73=3;
        	            	}
        	                break;
        	            case DECLARE_PRIMED_VAR_TOK:
        	            	{
        	            		alt73=4;
        	            	}
        	                break;
        	            case SYNTH_FUN_TOK:
        	            	{
        	            		alt73=5;
        	            	}
        	                break;
        	            case SYNTH_INV_TOK:
        	            	{
        	            		alt73=6;
        	            	}
        	                break;
        	            case CONSTRAINT_TOK:
        	            	{
        	            		alt73=7;
        	            	}
        	                break;
        	            case INV_CONSTRAINT_TOK:
        	            	{
        	            		alt73=8;
        	            	}
        	                break;
        	            case CHECK_SYNTH_TOK:
        	            	{
        	            		alt73=9;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 73;
        	                EXCEPTION->state        = 0;


        	                goto rulesymbolEx;

        	            }

        	            switch (alt73)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2880:7: 'repeat'
        	        	    {
        	        	         MATCHT(154, &FOLLOW_154_in_symbol6091);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesymbolEx;
        	        	        }


        	        	        {
        	        	             id = "repeat"; 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2883:7: SET_OPTIONS_TOK
        	        	    {
        	        	         MATCHT(SET_OPTIONS_TOK, &FOLLOW_SET_OPTIONS_TOK_in_symbol6107);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesymbolEx;
        	        	        }


        	        	        {
        	        	             id = "set-options"; 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 3:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2884:7: DECLARE_VAR_TOK
        	        	    {
        	        	         MATCHT(DECLARE_VAR_TOK, &FOLLOW_DECLARE_VAR_TOK_in_symbol6117);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesymbolEx;
        	        	        }


        	        	        {
        	        	             id = "declare-var"; 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 4:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2885:7: DECLARE_PRIMED_VAR_TOK
        	        	    {
        	        	         MATCHT(DECLARE_PRIMED_VAR_TOK, &FOLLOW_DECLARE_PRIMED_VAR_TOK_in_symbol6127);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesymbolEx;
        	        	        }


        	        	        {
        	        	             id = "declare-primed-var"; 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 5:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2886:7: SYNTH_FUN_TOK
        	        	    {
        	        	         MATCHT(SYNTH_FUN_TOK, &FOLLOW_SYNTH_FUN_TOK_in_symbol6137);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesymbolEx;
        	        	        }


        	        	        {
        	        	             id = "synth-fun"; 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 6:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2887:7: SYNTH_INV_TOK
        	        	    {
        	        	         MATCHT(SYNTH_INV_TOK, &FOLLOW_SYNTH_INV_TOK_in_symbol6147);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesymbolEx;
        	        	        }


        	        	        {
        	        	             id = "synth-inv"; 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 7:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2888:7: CONSTRAINT_TOK
        	        	    {
        	        	         MATCHT(CONSTRAINT_TOK, &FOLLOW_CONSTRAINT_TOK_in_symbol6157);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesymbolEx;
        	        	        }


        	        	        {
        	        	             id = "constraint"; 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 8:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2889:7: INV_CONSTRAINT_TOK
        	        	    {
        	        	         MATCHT(INV_CONSTRAINT_TOK, &FOLLOW_INV_CONSTRAINT_TOK_in_symbol6167);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesymbolEx;
        	        	        }


        	        	        {
        	        	             id = "inv-constraint"; 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 9:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2890:7: CHECK_SYNTH_TOK
        	        	    {
        	        	         MATCHT(CHECK_SYNTH_TOK, &FOLLOW_CHECK_SYNTH_TOK_in_symbol6177);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesymbolEx;
        	        	        }


        	        	        {
        	        	             id = "check-synth"; 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        {
        	             PARSER_STATE->checkDeclaration(id, check, type); 
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/smt2/Smt2.g:2893:5: QUOTED_SYMBOL
        	    {
        	        QUOTED_SYMBOL23 = (pANTLR3_COMMON_TOKEN) MATCHT(QUOTED_SYMBOL, &FOLLOW_QUOTED_SYMBOL_in_symbol6197);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolEx;
        	        }


        	        {
        	             id = AntlrInput::tokenText(QUOTED_SYMBOL23);
        	                  /* strip off the quotes */
        	                  id = id.substr(1, id.size() - 2);
        	                  if(!PARSER_STATE->isAbstractValue(id)) {
        	                    // if an abstract value, SmtEngine handles declaration
        	                    PARSER_STATE->checkDeclaration(id, check, type);
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 4:
        	    // ../../../../src/parser/smt2/Smt2.g:2902:5: UNTERMINATED_QUOTED_SYMBOL ( EOF | '\\\\' )
        	    {
        	         MATCHT(UNTERMINATED_QUOTED_SYMBOL, &FOLLOW_UNTERMINATED_QUOTED_SYMBOL_in_symbol6209);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:2903:5: ( EOF | '\\\\' )
        	        {
        	            int alt74=2;
        	            switch ( LA(1) )
        	            {
        	            case EOF:
        	            	{
        	            		alt74=1;
        	            	}
        	                break;
        	            case 152:
        	            	{
        	            		alt74=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 74;
        	                EXCEPTION->state        = 0;


        	                goto rulesymbolEx;

        	            }

        	            switch (alt74)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2903:7: EOF
        	        	    {
        	        	         MATCHT(EOF, &FOLLOW_EOF_in_symbol6217);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesymbolEx;
        	        	        }


        	        	        {
        	        	             PARSER_STATE->unexpectedEOF("unterminated |quoted| symbol"); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2905:7: '\\\\'
        	        	    {
        	        	         MATCHT(152, &FOLLOW_152_in_symbol6233);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesymbolEx;
        	        	        }


        	        	        {
        	        	             PARSER_STATE->unexpectedEOF("backslash not permitted in |quoted| "
        	        	                                                "symbol"); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesymbolEx; /* Prevent compiler warnings */
    rulesymbolEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end symbol */

/**
 * $ANTLR start nonemptyNumeralList
 * ../../../../src/parser/smt2/Smt2.g:2915:1: nonemptyNumeralList[std::vector<uint64_t>& numerals] : ( INTEGER_LITERAL )+ ;
 */
static void
nonemptyNumeralList(pSmt2Parser ctx, std::vector<uint64_t>& numerals)
{
    pANTLR3_COMMON_TOKEN    INTEGER_LITERAL24;

    /* Initialize rule variables
     */

    INTEGER_LITERAL24       = NULL;

    {
        // ../../../../src/parser/smt2/Smt2.g:2916:3: ( ( INTEGER_LITERAL )+ )
        // ../../../../src/parser/smt2/Smt2.g:2916:5: ( INTEGER_LITERAL )+
        {
            // ../../../../src/parser/smt2/Smt2.g:2916:5: ( INTEGER_LITERAL )+
            {
                int cnt76=0;

                for (;;)
                {
                    int alt76=2;
            	switch ( LA(1) )
            	{
            	case INTEGER_LITERAL:
            		{
            			alt76=1;
            		}
            	    break;

            	}

            	switch (alt76)
            	{
            	    case 1:
            	        // ../../../../src/parser/smt2/Smt2.g:2916:7: INTEGER_LITERAL
            	        {
            	            INTEGER_LITERAL24 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_nonemptyNumeralList6265);
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulenonemptyNumeralListEx;
            	            }


            	            {
            	                 numerals.push_back(AntlrInput::tokenToUnsigned(INTEGER_LITERAL24)); 
            	            }


            	        }
            	        break;

            	    default:

            		if ( cnt76 >= 1 )
            		{
            		    goto loop76;
            		}
            		/* mismatchedSetEx()
            		 */
            		CONSTRUCTEX();
            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            		goto rulenonemptyNumeralListEx;
            	}
            	cnt76++;
                }
                loop76: ;	/* Jump to here if this rule does not match */
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto rulenonemptyNumeralListEx; /* Prevent compiler warnings */
    rulenonemptyNumeralListEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end nonemptyNumeralList */

/**
 * $ANTLR start datatypeDef
 * ../../../../src/parser/smt2/Smt2.g:2924:1: datatypeDef[bool isCo, std::vector<CVC4::Datatype>& datatypes,\n std::vector< CVC4::Type >& params] : symbol[id,CHECK_NONE,SYM_SORT] ( LPAREN_TOK constructorDef[datatypes.back()] RPAREN_TOK )+ ;
 */
static void
datatypeDef(pSmt2Parser ctx, bool isCo, std::vector<CVC4::Datatype>& datatypes, std::vector< CVC4::Type >& params)
{
    /* Initialize rule variables
     */


      std::string id;

    {
        // ../../../../src/parser/smt2/Smt2.g:2933:3: ( symbol[id,CHECK_NONE,SYM_SORT] ( LPAREN_TOK constructorDef[datatypes.back()] RPAREN_TOK )+ )
        // ../../../../src/parser/smt2/Smt2.g:2933:5: symbol[id,CHECK_NONE,SYM_SORT] ( LPAREN_TOK constructorDef[datatypes.back()] RPAREN_TOK )+
        {
            FOLLOWPUSH(FOLLOW_symbol_in_datatypeDef6307);
            symbol(ctx, id, CHECK_NONE, SYM_SORT);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruledatatypeDefEx;
            }


            {
                 PARSER_STATE->pushScope(true); 
            }


            {
                 datatypes.push_back(Datatype(id,params,isCo));
                      if(!PARSER_STATE->isUnresolvedType(id)) {
                        // if not unresolved, must be undeclared
                        PARSER_STATE->checkDeclaration(id, CHECK_UNDECLARED, SYM_SORT);
                      }
                    
            }


            // ../../../../src/parser/smt2/Smt2.g:2949:5: ( LPAREN_TOK constructorDef[datatypes.back()] RPAREN_TOK )+
            {
                int cnt77=0;

                for (;;)
                {
                    int alt77=2;
            	switch ( LA(1) )
            	{
            	case LPAREN_TOK:
            		{
            			alt77=1;
            		}
            	    break;

            	}

            	switch (alt77)
            	{
            	    case 1:
            	        // ../../../../src/parser/smt2/Smt2.g:2949:7: LPAREN_TOK constructorDef[datatypes.back()] RPAREN_TOK
            	        {
            	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypeDef6330);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruledatatypeDefEx;
            	            }


            	            FOLLOWPUSH(FOLLOW_constructorDef_in_datatypeDef6332);
            	            constructorDef(ctx, datatypes.back());

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruledatatypeDefEx;
            	            }


            	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypeDef6335);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruledatatypeDefEx;
            	            }


            	        }
            	        break;

            	    default:

            		if ( cnt77 >= 1 )
            		{
            		    goto loop77;
            		}
            		/* mismatchedSetEx()
            		 */
            		CONSTRUCTEX();
            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            		goto ruledatatypeDefEx;
            	}
            	cnt77++;
                }
                loop77: ;	/* Jump to here if this rule does not match */
            }

            {
                 PARSER_STATE->popScope(); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruledatatypeDefEx; /* Prevent compiler warnings */
    ruledatatypeDefEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end datatypeDef */

/**
 * $ANTLR start constructorDef
 * ../../../../src/parser/smt2/Smt2.g:2956:1: constructorDef[CVC4::Datatype& type] : symbol[id,CHECK_UNDECLARED,SYM_VARIABLE] ( LPAREN_TOK selector[*ctor] RPAREN_TOK )* ;
 */
static void
constructorDef(pSmt2Parser ctx, CVC4::Datatype& type)
{
    /* Initialize rule variables
     */


      std::string id;
      CVC4::DatatypeConstructor* ctor = NULL;

    {
        // ../../../../src/parser/smt2/Smt2.g:2961:3: ( symbol[id,CHECK_UNDECLARED,SYM_VARIABLE] ( LPAREN_TOK selector[*ctor] RPAREN_TOK )* )
        // ../../../../src/parser/smt2/Smt2.g:2961:5: symbol[id,CHECK_UNDECLARED,SYM_VARIABLE] ( LPAREN_TOK selector[*ctor] RPAREN_TOK )*
        {
            FOLLOWPUSH(FOLLOW_symbol_in_constructorDef6365);
            symbol(ctx, id, CHECK_UNDECLARED, SYM_VARIABLE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleconstructorDefEx;
            }


            {
                 // make the tester
                      std::string testerId("is-");
                      testerId.append(id);
                      PARSER_STATE->checkDeclaration(testerId, CHECK_UNDECLARED, SYM_VARIABLE);
                      ctor = new CVC4::DatatypeConstructor(id, testerId);
                    
            }


            // ../../../../src/parser/smt2/Smt2.g:2968:5: ( LPAREN_TOK selector[*ctor] RPAREN_TOK )*

            for (;;)
            {
                int alt78=2;
                switch ( LA(1) )
                {
                case LPAREN_TOK:
                	{
                		alt78=1;
                	}
                    break;

                }

                switch (alt78)
                {
            	case 1:
            	    // ../../../../src/parser/smt2/Smt2.g:2968:7: LPAREN_TOK selector[*ctor] RPAREN_TOK
            	    {
            	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_constructorDef6380);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleconstructorDefEx;
            	        }


            	        FOLLOWPUSH(FOLLOW_selector_in_constructorDef6382);
            	        selector(ctx, *ctor);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleconstructorDefEx;
            	        }


            	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_constructorDef6385);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleconstructorDefEx;
            	        }


            	    }
            	    break;

            	default:
            	    goto loop78;	/* break out of the loop */
            	    break;
                }
            }
            loop78: ; /* Jump out to here if this rule does not match */


            {
                 // make the constructor
                      type.addConstructor(*ctor);
                      Debug("parser-idt") << "constructor: " << id.c_str() << std::endl;
                      delete ctor;
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleconstructorDefEx; /* Prevent compiler warnings */
    ruleconstructorDefEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end constructorDef */

/**
 * $ANTLR start selector
 * ../../../../src/parser/smt2/Smt2.g:2976:1: selector[CVC4::DatatypeConstructor& ctor] : symbol[id,CHECK_UNDECLARED,SYM_SORT] sortSymbol[t,CHECK_NONE] ;
 */
static void
selector(pSmt2Parser ctx, CVC4::DatatypeConstructor& ctor)
{
    /* Initialize rule variables
     */


      std::string id;
      Type t, t2;

    {
        // ../../../../src/parser/smt2/Smt2.g:2981:3: ( symbol[id,CHECK_UNDECLARED,SYM_SORT] sortSymbol[t,CHECK_NONE] )
        // ../../../../src/parser/smt2/Smt2.g:2981:5: symbol[id,CHECK_UNDECLARED,SYM_SORT] sortSymbol[t,CHECK_NONE]
        {
            FOLLOWPUSH(FOLLOW_symbol_in_selector6413);
            symbol(ctx, id, CHECK_UNDECLARED, SYM_SORT);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleselectorEx;
            }


            FOLLOWPUSH(FOLLOW_sortSymbol_in_selector6416);
            sortSymbol(ctx, t, CHECK_NONE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleselectorEx;
            }


            {
                 ctor.addArg(id, t);
                      Debug("parser-idt") << "selector: " << id.c_str()
                                          << " of type " << t << std::endl;
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleselectorEx; /* Prevent compiler warnings */
    ruleselectorEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end selector */
/* End of parsing rules
 * ==============================================
 */

/* ==============================================
 * Syntactic predicates
 */
/* End of syntactic predicates
 * ==============================================
 */






/* End of code
 * =============================================================================
 */
