/*********************                                                        */
/*! \file module_template.cpp
 ** \verbatim
 ** Top contributors (to current version):
 **   Morgan Deters, Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2018 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Option template for option modules.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.cpp file.
 **/

#include "options/options_holder.h"

namespace CVC4 {

template <> void Options::set(
    options::ufSymmetryBreaker__option_t,
    const options::ufSymmetryBreaker__option_t::type& x)
{
  d_holder->ufSymmetryBreaker = x;
}
template <> const options::ufSymmetryBreaker__option_t::type& Options::operator[](
    options::ufSymmetryBreaker__option_t) const
{
  return d_holder->ufSymmetryBreaker;
}
template <> bool Options::wasSetByUser(options::ufSymmetryBreaker__option_t) const
{
  return d_holder->ufSymmetryBreaker__setByUser__;
}
template <> void Options::set(
    options::ufHo__option_t,
    const options::ufHo__option_t::type& x)
{
  d_holder->ufHo = x;
}
template <> const options::ufHo__option_t::type& Options::operator[](
    options::ufHo__option_t) const
{
  return d_holder->ufHo;
}
template <> bool Options::wasSetByUser(options::ufHo__option_t) const
{
  return d_holder->ufHo__setByUser__;
}
template <> void Options::set(
    options::ufHoExt__option_t,
    const options::ufHoExt__option_t::type& x)
{
  d_holder->ufHoExt = x;
}
template <> const options::ufHoExt__option_t::type& Options::operator[](
    options::ufHoExt__option_t) const
{
  return d_holder->ufHoExt;
}
template <> bool Options::wasSetByUser(options::ufHoExt__option_t) const
{
  return d_holder->ufHoExt__setByUser__;
}
template <> const options::ufssAbortCardinality__option_t::type& Options::operator[](
    options::ufssAbortCardinality__option_t) const
{
  return d_holder->ufssAbortCardinality;
}
template <> bool Options::wasSetByUser(options::ufssAbortCardinality__option_t) const
{
  return d_holder->ufssAbortCardinality__setByUser__;
}
template <> const options::ufssCliqueSplits__option_t::type& Options::operator[](
    options::ufssCliqueSplits__option_t) const
{
  return d_holder->ufssCliqueSplits;
}
template <> bool Options::wasSetByUser(options::ufssCliqueSplits__option_t) const
{
  return d_holder->ufssCliqueSplits__setByUser__;
}
template <> const options::ufssEagerSplits__option_t::type& Options::operator[](
    options::ufssEagerSplits__option_t) const
{
  return d_holder->ufssEagerSplits;
}
template <> bool Options::wasSetByUser(options::ufssEagerSplits__option_t) const
{
  return d_holder->ufssEagerSplits__setByUser__;
}
template <> const options::ufssFairness__option_t::type& Options::operator[](
    options::ufssFairness__option_t) const
{
  return d_holder->ufssFairness;
}
template <> bool Options::wasSetByUser(options::ufssFairness__option_t) const
{
  return d_holder->ufssFairness__setByUser__;
}
template <> void Options::set(
    options::ufssFairnessMonotone__option_t,
    const options::ufssFairnessMonotone__option_t::type& x)
{
  d_holder->ufssFairnessMonotone = x;
}
template <> const options::ufssFairnessMonotone__option_t::type& Options::operator[](
    options::ufssFairnessMonotone__option_t) const
{
  return d_holder->ufssFairnessMonotone;
}
template <> bool Options::wasSetByUser(options::ufssFairnessMonotone__option_t) const
{
  return d_holder->ufssFairnessMonotone__setByUser__;
}
template <> const options::ufssRegions__option_t::type& Options::operator[](
    options::ufssRegions__option_t) const
{
  return d_holder->ufssRegions;
}
template <> bool Options::wasSetByUser(options::ufssRegions__option_t) const
{
  return d_holder->ufssRegions__setByUser__;
}
template <> const options::ufssTotality__option_t::type& Options::operator[](
    options::ufssTotality__option_t) const
{
  return d_holder->ufssTotality;
}
template <> bool Options::wasSetByUser(options::ufssTotality__option_t) const
{
  return d_holder->ufssTotality__setByUser__;
}
template <> const options::ufssTotalityLimited__option_t::type& Options::operator[](
    options::ufssTotalityLimited__option_t) const
{
  return d_holder->ufssTotalityLimited;
}
template <> bool Options::wasSetByUser(options::ufssTotalityLimited__option_t) const
{
  return d_holder->ufssTotalityLimited__setByUser__;
}
template <> const options::ufssTotalitySymBreak__option_t::type& Options::operator[](
    options::ufssTotalitySymBreak__option_t) const
{
  return d_holder->ufssTotalitySymBreak;
}
template <> bool Options::wasSetByUser(options::ufssTotalitySymBreak__option_t) const
{
  return d_holder->ufssTotalitySymBreak__setByUser__;
}
template <> const options::ufssMode__option_t::type& Options::operator[](
    options::ufssMode__option_t) const
{
  return d_holder->ufssMode;
}
template <> bool Options::wasSetByUser(options::ufssMode__option_t) const
{
  return d_holder->ufssMode__setByUser__;
}


namespace options {

struct ufSymmetryBreaker__option_t ufSymmetryBreaker;
struct ufHo__option_t ufHo;
struct ufHoExt__option_t ufHoExt;
struct ufssAbortCardinality__option_t ufssAbortCardinality;
struct ufssCliqueSplits__option_t ufssCliqueSplits;
struct ufssEagerSplits__option_t ufssEagerSplits;
struct ufssFairness__option_t ufssFairness;
struct ufssFairnessMonotone__option_t ufssFairnessMonotone;
struct ufssRegions__option_t ufssRegions;
struct ufssTotality__option_t ufssTotality;
struct ufssTotalityLimited__option_t ufssTotalityLimited;
struct ufssTotalitySymBreak__option_t ufssTotalitySymBreak;
struct ufssMode__option_t ufssMode;


}  // namespace options
}  // namespace CVC4
