/*
 * fxotune.h -- data structures and associated definitions for fxotune.c
 *
 * By Matthew Fredrickson <creslin@digium.com>
 *
 * Echo coefficients and acim register values taken from AN84 from Silicon
 * Laboratories app note AN84 for setting echo cancellation coefficients
 *
 * (C) 2005 Digium, Inc.
 */

/*
 * See http://www.asterisk.org for more information about
 * the Asterisk project. Please do not directly contact
 * any of the maintainers of this project for assistance;
 * the project provides a web site, mailing lists and IRC
 * channels for your use.
 *
 * This program is free software, distributed under the terms of
 * the GNU General Public License Version 2 as published by the
 * Free Software Foundation. See the LICENSE file included with
 * this program for more details.
 */

struct wctdm_echo_coefs echo_trys [] =
{
	/* 600 ohm echo settings */
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{ 10, 0, 6, 1, 254, 2, 255, 0, 0},
	{ 3, 255, 255, 0, 1, 0, 0, 0, 0},
	{ 3, 1, 253, 253, 2, 255, 0, 0, 0},
	{ 9, 254, 251, 255, 2, 0, 1, 0, 0},
	{ 5, 3, 251, 250, 2, 254, 0, 0, 255},
	{ 8, 253, 2, 244, 255, 10, 244, 3, 253},
	{ 10, 249, 244, 8, 12, 245, 252, 0, 1},
	
	/* 900 ohm echo settings */
	{ 1, 0, 0, 0, 0, 0, 0, 0, 0},
	{ 10, 252, 255, 1, 255, 0, 0, 0, 0},
	{ 7, 255, 251, 251, 2, 255, 255, 1, 255},
	{ 3, 1, 251, 250, 1, 254, 255, 0, 255},
	{ 5, 252, 250, 0, 0, 255, 1, 0, 0},
	{ 5, 3, 251, 250, 1, 253, 0, 0, 255},
	{ 8, 253, 2, 244, 255, 10, 244, 3, 253},
	{ 10, 249, 244, 8, 12, 245, 252, 0, 1},

	/* 270 ohm + (750 ohm || 150 nF) (CTR21) */
	{ 2, 0, 0, 0, 0, 0, 0, 0, 0},
	{ 7, 0, 0, 255, 254, 0, 0, 0, 0},
	{ 9, 0, 253, 254, 2, 255, 0, 0, 0},
	{ 5, 1, 249, 254, 4, 253, 1, 0, 0},
	{ 5, 252, 250, 1, 1, 254, 0, 255, 0},
	{ 5, 3, 251, 250, 2, 253, 255, 255, 255},
	{ 8, 253, 2, 244, 255, 10, 244, 3, 253},
	{ 10, 249, 244, 8, 12, 245, 252, 0, 1},

	/* 220 ohm + (820 ohm || 120 nF) (Australia/NewZealand) and 220 ohm + (820 ohm
	 * || 115nF) (Slovakia/SAfrica/Germany/Austria/Bulgaria)
	 */
	{ 3, 0, 0, 0, 0, 0, 0, 0, 0},
	{ 7, 0, 255, 254, 255, 0, 255, 0, 0},
	{ 9, 0, 253, 253, 1, 255, 0, 0, 0},
	{ 5, 1, 249, 254, 3, 253, 1, 0, 0},
	{ 5, 252, 250, 1, 1, 254, 0, 255, 0},
	{ 5, 3, 251, 251, 2, 253, 255, 255, 255},
	{ 8, 253, 2, 244, 255, 10, 244, 3, 253},
	{ 10, 249, 244, 8, 12, 245, 252, 0, 1},
	
	/* 370 ohm + (620ohm || 310nF) (New Zealand #2/India) CO Termination */
	{ 4, 0, 0, 0, 0, 0, 0, 0, 0},
	{ 9, 255, 1, 4, 0, 0, 1, 255, 0},
	{ 9, 0, 253, 0, 3, 254, 0, 0, 255},
	{ 9, 2, 250, 253, 5, 253, 1, 0 ,255},
	{ 5, 252, 250, 1, 2, 255, 0 ,255, 0},
	{ 5, 3, 251, 250, 3, 254, 255, 255, 255},
	{ 8, 253, 2, 244, 255, 10, 244, 3, 253},
	{ 10, 249, 244, 8, 12, 245, 252, 0, 1},
	
	/* 320 ohm + (1050ohm || 230 nF) (England) CO Termination */
	{ 5, 0, 0, 0, 0, 0, 0, 0, 0},
	{ 9, 0 ,255, 1, 255, 255, 0, 255, 0},
	{ 5, 255, 252, 0, 2, 254, 0, 255, 255},
	{ 9, 2, 250, 253, 4, 252, 0, 255, 255},
	{ 5, 252, 250, 1, 1, 254, 0 ,255, 255},
	{ 5, 3, 251, 250, 2, 253, 255, 255, 254},
	{ 3, 1, 1, 242, 2, 9, 245, 3, 253},
	{ 10, 249, 244, 8, 12, 245, 252, 0, 1},

	/* 370 ohm + (820 ohm || 110 nF) CO Termination */
	{ 6, 0, 0, 0, 0, 0, 0, 0, 0},
	{ 6, 1, 254, 253, 0, 255, 0, 0, 0},
	{ 9, 0, 251, 252, 2, 255, 0, 0, 0},
	{ 5, 1, 248, 252, 4, 253, 1, 0, 0},
	{ 5, 252, 250, 0, 0, 254, 0 , 255, 0},
	{ 5, 3, 251, 250, 2, 253, 255, 255, 254},
	{ 3, 1, 1, 242, 2, 9, 245, 3, 253},
	{ 10, 249, 244, 8, 12, 245, 252, 0, 1},

	/* 275 ohm + (780 ohm || 115 nF) CO Termination */
	{ 7, 0, 0, 0, 0, 0, 0, 0, 0},
	{ 7, 255, 255, 255, 255, 0, 0, 0, 0},
	{ 9, 0, 253, 254, 2, 255, 0, 0, 0},
	{ 5, 1, 249, 254, 4, 253, 1, 0, 0},
	{ 5, 252, 250, 1, 1, 254, 0, 255, 0},
	{ 5, 3, 251, 250, 2, 253, 255, 255, 255},
	{ 8, 253, 2, 244, 255, 10, 244, 3, 253},
	{ 10, 249, 244, 8, 12, 245, 252, 0, 1},
	
	/* Make sure we include the rest of the impedances */
	{ 8, 0, 0, 0, 0, 0, 0, 0, 0},
	{ 9, 0, 0, 0, 0, 0, 0, 0, 0},
	{ 10, 0, 0, 0, 0, 0, 0, 0, 0},
	{ 11, 0, 0, 0, 0, 0, 0, 0, 0},
	{ 12, 0, 0, 0, 0, 0, 0, 0, 0},
	{ 13, 0, 0, 0, 0, 0, 0, 0, 0},
	{ 14, 0, 0, 0, 0, 0, 0, 0, 0},
	{ 15, 0, 0, 0, 0, 0, 0, 0, 0},
};

