/*
 * Copyright (C) 2016 ~ 2017 Deepin Technology Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include <QScopedPointer>
#include <QLabel>

class ContentTitlePrivate;
class ContentTitle : public QWidget
{
    Q_OBJECT
public:
    explicit ContentTitle(QWidget *parent = 0);
    ~ContentTitle();

    void setSpacing(int width);
    QLabel *label() const;

public Q_SLOTS:
    void setTitle(const QString &title);

private:
    QScopedPointer<ContentTitlePrivate> d_ptr;
    Q_DECLARE_PRIVATE_D(qGetPtrHelper(d_ptr), ContentTitle)
};

