/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************
 *
 **/
/**
  * Object table()
  * @type table
  * @super Object
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535901.aspx
*/

function table(){};
table.prototype= new Object();
/**
  * Property accessKey
  * @type String
  * @returns {String}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533062.aspx
*/

table.prototype.accessKey="";
/**
  * Property align
  * @type String
  * @returns {String}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533068.aspx
*/

table.prototype.align="";
/**
  * Property background
  * @type String
  * @returns {String}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533499.aspx
*/

table.prototype.background="";
/**
  * Property bgColor
  * @type Object
  * @returns {Object}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533505.aspx
*/

table.prototype.bgColor=new Object();
/**
  * Property border
  * @type Object
  * @returns {Object}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533534.aspx
*/

table.prototype.border=new Object();
/**
  * Property borderColor
  * @type Object
  * @returns {Object}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533517.aspx
*/

table.prototype.borderColor=new Object();
/**
  * Property borderColorDark
  * @type Object
  * @returns {Object}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533514.aspx
*/

table.prototype.borderColorDark=new Object();
/**
  * Property borderColorLight
  * @type Object
  * @returns {Object}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533515.aspx
*/

table.prototype.borderColorLight=new Object();
/**
  * Property canHaveChildren
  * @type Boolean
  * @returns {Boolean}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533546.aspx
*/

table.prototype.canHaveChildren=false;
/**
  * Property canHaveHTML
  * @type Boolean
  * @returns {Boolean}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537836.aspx
*/

table.prototype.canHaveHTML=false;
/**
  * Property caption
  * @type String
  * @returns {String}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533548.aspx
*/

table.prototype.caption="";
/**
  * Property caption
  * @type caption
  * @returns {caption}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535213.aspx
*/

table.prototype.caption= new caption();
/**
  * Property cellPadding
  * @type Object
  * @returns {Object}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533550.aspx
*/

table.prototype.cellPadding=new Object();
/**
  * Property cellSpacing
  * @type Object
  * @returns {Object}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533551.aspx
*/

table.prototype.cellSpacing=new Object();
/**
  * Property className
  * @type String
  * @returns {String}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533560.aspx
*/

table.prototype.className="";
/**
  * Property clientHeight
  * @type Number
  * @returns {Number}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533563.aspx
*/

table.prototype.clientHeight=0;
/**
  * Property clientLeft
  * @type Number
  * @returns {Number}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533564.aspx
*/

table.prototype.clientLeft=0;
/**
  * Property offsetLeft
  * @type Number
  * @returns {Number}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534200.aspx
*/

table.prototype.offsetLeft=0;
/**
  * Property clientTop
  * @type Number
  * @returns {Number}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533565.aspx
*/

table.prototype.clientTop=0;
/**
  * Property offsetTop
  * @type Number
  * @returns {Number}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534303.aspx
*/

table.prototype.offsetTop=0;
/**
  * Property clientWidth
  * @type Number
  * @returns {Number}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533566.aspx
*/

table.prototype.clientWidth=0;
/**
  * Property cols
  * @type Number
  * @returns {Number}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533583.aspx
*/

table.prototype.cols=0;
/**
  * Property dataPageSize
  * @type Number
  * @returns {Number}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533708.aspx
*/

table.prototype.dataPageSize=0;
/**
  * Property dataSrc
  * @type String
  * @returns {String}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533709.aspx
*/

table.prototype.dataSrc="";
/**
  * Property dir
  * @type String
  * @returns {String}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533728.aspx
*/

table.prototype.dir="";
/**
  * Property firstChild
  * @type Object
  * @returns {Object}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533755.aspx
*/

table.prototype.firstChild=new Object();
/**
  * Property childNodes
  * @type childNodes
  * @returns {childNodes}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537445.aspx
*/

table.prototype.childNodes= new childNodes();
/**
  * Property frame
  * @type String
  * @returns {String}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533769.aspx
*/

table.prototype.frame="";
/**
  * Property height
  * @type Object
  * @returns {Object}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533781.aspx
*/

table.prototype.height=new Object();
/**
  * Property hideFocus
  * @type Boolean
  * @returns {Boolean}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533783.aspx
*/

table.prototype.hideFocus=false;
/**
  * Property id
  * @type String
  * @returns {String}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533880.aspx
*/

table.prototype.id="";
/**
  * Property innerHTML
  * @type String
  * @returns {String}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533897.aspx
*/

table.prototype.innerHTML="";
/**
  * Property innerText
  * @type String
  * @returns {String}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533899.aspx
*/

table.prototype.innerText="";
/**
  * Property isContentEditable
  * @type Boolean
  * @returns {Boolean}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537838.aspx
*/

table.prototype.isContentEditable=false;
/**
  * Property isDisabled
  * @type Boolean
  * @returns {Boolean}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533902.aspx
*/

table.prototype.isDisabled=false;
/**
  * Property isMultiLine
  * @type Boolean
  * @returns {Boolean}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537839.aspx
*/

table.prototype.isMultiLine=false;
/**
  * Property isTextEdit
  * @type Boolean
  * @returns {Boolean}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533920.aspx
*/

table.prototype.isTextEdit=false;
/**
  * Property TextRange
  * @type TextRange
  * @returns {TextRange}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535872.aspx
*/

table.prototype.TextRange= new TextRange();
/**
  * Property lang
  * @type String
  * @returns {String}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533935.aspx
*/

table.prototype.lang="";
/**
  * Property language
  * @type String
  * @returns {String}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533940.aspx
*/

table.prototype.language="";
/**
  * Property lastChild
  * @type Object
  * @returns {Object}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533943.aspx
*/

table.prototype.lastChild=new Object();
/**
  * Property nextSibling
  * @type Object
  * @returns {Object}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534189.aspx
*/

table.prototype.nextSibling=new Object();
/**
  * Property nodeName
  * @type String
  * @returns {String}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534190.aspx
*/

table.prototype.nodeName="";
/**
  * Property nodeType
  * @type Number
  * @returns {Number}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534191.aspx
*/

table.prototype.nodeType=0;
/**
  * Property nodeValue
  * @type Object
  * @returns {Object}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534192.aspx
*/

table.prototype.nodeValue=new Object();
/**
  * Property offsetHeight
  * @type Number
  * @returns {Number}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534199.aspx
*/

table.prototype.offsetHeight=0;
/**
  * Property offsetParent
  * @type Object
  * @returns {Object}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534302.aspx
*/

table.prototype.offsetParent=new Object();
/**
  * Property offsetWidth
  * @type Number
  * @returns {Number}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534304.aspx
*/

table.prototype.offsetWidth=0;
/**
  * Property onOffBehavior
  * @type DABoolean
  * @returns {DABoolean}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533630.aspx
*/

table.prototype.onOffBehavior=new DABoolean();
/**
  * Property outerHTML
  * @type String
  * @returns {String}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534310.aspx
*/

table.prototype.outerHTML="";
/**
  * Property outerText
  * @type String
  * @returns {String}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534311.aspx
*/

table.prototype.outerText="";
/**
  * Property ownerDocument
  * @type document
  * @returns {document}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534315.aspx
*/

table.prototype.ownerDocument=new document();
/**
  * Property document
  * @type document
  * @returns {document}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms531073.aspx
*/

table.prototype.document= new document();
/**
  * Property parentElement
  * @type Object
  * @returns {Object}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534327.aspx
*/

table.prototype.parentElement=new Object();
/**
  * Property parentNode
  * @type Object
  * @returns {Object}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534328.aspx
*/

table.prototype.parentNode=new Object();
/**
  * Property parentTextEdit
  * @type Object
  * @returns {Object}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534330.aspx
*/

table.prototype.parentTextEdit=new Object();
/**
  * Property previousSibling
  * @type Object
  * @returns {Object}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534350.aspx
*/

table.prototype.previousSibling=new Object();
/**
  * Property readyState
  * @type String
  * @returns {String}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534359.aspx
*/

table.prototype.readyState="";
/**
  * Property rules
  * @type String
  * @returns {String}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534384.aspx
*/

table.prototype.rules="";
/**
  * Property scopeName
  * @type String
  * @returns {String}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534388.aspx
*/

table.prototype.scopeName="";
/**
  * Property scrollHeight
  * @type Object
  * @returns {Object}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534615.aspx
*/

table.prototype.scrollHeight=new Object();
/**
  * Property scrollLeft
  * @type Number
  * @returns {Number}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534617.aspx
*/

table.prototype.scrollLeft=0;
/**
  * Property scrollTop
  * @type Number
  * @returns {Number}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534618.aspx
*/

table.prototype.scrollTop=0;
/**
  * Property scrollWidth
  * @type Object
  * @returns {Object}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534619.aspx
*/

table.prototype.scrollWidth=new Object();
/**
  * Property sourceIndex
  * @type Number
  * @returns {Number}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534635.aspx
*/

table.prototype.sourceIndex=0;
/**
  * Property all
  * @type all
  * @returns {all}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537434.aspx
*/

table.prototype.all= new all();
/**
  * Property summary
  * @type String
  * @returns {String}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534652.aspx
*/

table.prototype.summary="";
/**
  * Property tabIndex
  * @type Number
  * @returns {Number}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534654.aspx
*/

table.prototype.tabIndex=0;
/**
  * Property tagName
  * @type String
  * @returns {String}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534657.aspx
*/

table.prototype.tagName="";
/**
  * Property tagUrn
  * @type String
  * @returns {String}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534658.aspx
*/

table.prototype.tagUrn="";
/**
  * Property tFoot
  * @type tFoot
  * @returns {tFoot}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534680.aspx
*/

table.prototype.tFoot=new tFoot();
/**
  * Property tFoot
  * @type tFoot
  * @returns {tFoot}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535907.aspx
*/

table.prototype.tFoot= new tFoot();
/**
  * Property tHead
  * @type tHead
  * @returns {tHead}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534681.aspx
*/

table.prototype.tHead=new tHead();
/**
  * Property tHead
  * @type tHead
  * @returns {tHead}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535909.aspx
*/

table.prototype.tHead= new tHead();
/**
  * Property title
  * @type String
  * @returns {String}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534683.aspx
*/

table.prototype.title="";
/**
  * Property uniqueID
  * @type String
  * @returns {String}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534704.aspx
*/

table.prototype.uniqueID="";
/**
  * Property width
  * @type Object
  * @returns {Object}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535147.aspx
*/

table.prototype.width=new Object();
/**
  * function addBehavior(sUrl)
  * @param {String} sUrl
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535922.aspx
*/

table.prototype.addBehavior=function(sUrl){};
/**
  * function appendChild(oNode)
  * @param {appendChild} oNode
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535934.aspx
*/

table.prototype.appendChild=function(oNode){};
/**
  * function applyElement(oNewElement)
  * @param {String} oNewElement
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536341.aspx
*/

table.prototype.applyElement=function(oNewElement){};
/**
  * function attachEvent(sEvent,fpNotify)
  * @param {String} sEvent
  * @param {Boolean} fpNotify
  * @type Boolean
  * @returns {Boolean}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536343.aspx
*/

table.prototype.attachEvent=function(sEvent,fpNotify){};
/**
  * function blur()
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536347.aspx
*/

table.prototype.blur=function(){};
/**
  * Property onblur
  * @type onblur
  * @returns {onblur}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536909.aspx
*/

table.prototype.onblur= new onblur();
/**
  * function clearAttributes()
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536350.aspx
*/

table.prototype.clearAttributes=function(){};
/**
  * function click()
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536363.aspx
*/

table.prototype.click=function(){};
/**
  * Property onclick
  * @type onclick
  * @returns {onclick}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536913.aspx
*/

table.prototype.onclick= new onclick();
/**
  * function cloneNode(bCloneChildren)
  * @param {Boolean} bCloneChildren
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536365.aspx
*/

table.prototype.cloneNode=function(bCloneChildren){};
/**
  * function componentFromPoint(iCoordX,iCoordY)
  * @param {Number} iCoordX
  * @param {Number} iCoordY
  * @type String
  * @returns {String}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536375.aspx
*/

table.prototype.componentFromPoint=function(iCoordX,iCoordY){};
/**
  * function contains(oElement)
  * @param {Boolean} oElement
  * @type Boolean
  * @returns {Boolean}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536377.aspx
*/

table.prototype.contains=function(oElement){};
/**
  * function createCaption()
  * @type caption
  * @returns {caption}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536381.aspx
*/

table.prototype.createCaption=function(){};
/**
  * function createTFoot()
  * @type tFoot
  * @returns {tFoot}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536402.aspx
*/

table.prototype.createTFoot=function(){};
/**
  * function createTHead()
  * @type tHead
  * @returns {tHead}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536403.aspx
*/

table.prototype.createTHead=function(){};
/**
  * function deleteCaption()
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536405.aspx
*/

table.prototype.deleteCaption=function(){};
/**
  * function deleteRow(iRowIndex)
  * @param {Number} iRowIndex
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536408.aspx
*/

table.prototype.deleteRow=function(iRowIndex){};
/**
  * Property rows
  * @type rows
  * @returns {rows}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537484.aspx
*/

table.prototype.rows= new rows();
/**
  * function deleteTFoot()
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536409.aspx
*/

table.prototype.deleteTFoot=function(){};
/**
  * function deleteTHead()
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536410.aspx
*/

table.prototype.deleteTHead=function(){};
/**
  * function detachEvent(sEvent,fpNotify)
  * @param {String} sEvent
  * @param {attachEvent} fpNotify
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536411.aspx
*/

table.prototype.detachEvent=function(sEvent,fpNotify){};
/**
  * function dragDrop()
  * @type Boolean
  * @returns {Boolean}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536415.aspx
*/

table.prototype.dragDrop=function(){};
/**
  * function fireEvent(sEvent,oEventObject)
  * @param {String} sEvent
  * @param {event} oEventObject
  * @type Boolean
  * @returns {Boolean}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536423.aspx
*/

table.prototype.fireEvent=function(sEvent,oEventObject){};
/**
  * function firstPage()
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536424.aspx
*/

table.prototype.firstPage=function(){};
/**
  * function focus()
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536425.aspx
*/

table.prototype.focus=function(){};
/**
  * Property onfocus
  * @type onfocus
  * @returns {onfocus}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536934.aspx
*/

table.prototype.onfocus= new onfocus();
/**
  * function getAdjacentText(sWhere)
  * @param {String} sWhere
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536427.aspx
*/

table.prototype.getAdjacentText=function(sWhere){};
/**
  * function getAttribute(sAttrName,iFlags,sAttrName)
  * @param {String} sAttrName
  * @param {Number} iFlags
  * @param {getAttribute} sAttrName
  * @type Object
  * @returns {Object}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536429.aspx
*/

table.prototype.getAttribute=function(sAttrName,iFlags,sAttrName){};
/**
  * function getAttributeNode(sName)
  * @param {String} sName
  * @type attribute
  * @returns {attribute}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536430.aspx
*/

table.prototype.getAttributeNode=function(sName){};
/**
  * Property attribute
  * @type attribute
  * @returns {attribute}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535187.aspx
*/

table.prototype.attribute= new attribute();
/**
  * Property name
  * @type String
  * @returns {String}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534184.aspx
*/

table.prototype.name="";
/**
  * function getBoundingClientRect()
  * @type TextRectangle
  * @returns {TextRectangle}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536433.aspx
*/

table.prototype.getBoundingClientRect=function(){};
/**
  * Property TextRectangle
  * @type TextRectangle
  * @returns {TextRectangle}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535906.aspx
*/

table.prototype.TextRectangle= new TextRectangle();
/**
  * function getClientRects()
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536435.aspx
*/

table.prototype.getClientRects=function(){};
/**
  * function getElementsByTagName(sTagName)
  * @param {String} sTagName
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536439.aspx
*/

table.prototype.getElementsByTagName=function(sTagName){};
/**
  * function getExpression(sPropertyName)
  * @param {String} sPropertyName
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/aa358797.aspx
*/

table.prototype.getExpression=function(sPropertyName){};
/**
  * function hasChildNodes()
  * @type HTML Elements
  * @returns {HTML}
 Elements
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536445.aspx
*/

table.prototype.hasChildNodes=function(){};
/**
  * function insertAdjacentElement(sWhere,oElement)
  * @param {String} sWhere
  * @param {insertAdjacentElement} oElement
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536451.aspx
*/

table.prototype.insertAdjacentElement=function(sWhere,oElement){};
/**
  * function insertBefore(oNewNode,oChildNode)
  * @param {Object} oNewNode
  * @param {Object} oChildNode
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536454.aspx
*/

table.prototype.insertBefore=function(oNewNode,oChildNode){};
/**
  * function insertRow(iIndex)
  * @param {Number} iIndex
  * @type tr
  * @returns {tr}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536457.aspx
*/

table.prototype.insertRow=function(iIndex){};
/**
  * function lastPage()
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536612.aspx
*/

table.prototype.lastPage=function(){};
/**
  * function mergeAttributes(oSource,bPreserve)
  * @param {Object} oSource
  * @param {Boolean} bPreserve
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536614.aspx
*/

table.prototype.mergeAttributes=function(oSource,bPreserve){};
/**
  * function moveRow(iSource,iTarget)
  * @param {Number} iSource
  * @param {Number} iTarget
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536622.aspx
*/

table.prototype.moveRow=function(iSource,iTarget){};
/**
  * function nextPage()
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536644.aspx
*/

table.prototype.nextPage=function(){};
/**
  * function normalize()
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536646.aspx
*/

table.prototype.normalize=function(){};
/**
  * function previousPage()
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536670.aspx
*/

table.prototype.previousPage=function(){};
/**
  * function refresh()
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536687.aspx
*/

table.prototype.refresh=function(){};
/**
  * function removeRule(iIndex)
  * @param {Number} iIndex
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms531195.aspx
*/

table.prototype.removeRule=function(iIndex){};
/**
  * function releaseCapture()
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536689.aspx
*/

table.prototype.releaseCapture=function(){};
/**
  * function removeAttribute(sName,iCaseSensitive)
  * @param {String} sName
  * @param {Number} iCaseSensitive
  * @type Boolean
  * @returns {Boolean}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536696.aspx
*/

table.prototype.removeAttribute=function(sName,iCaseSensitive){};
/**
  * function removeAttributeNode(oSrcAttribute)
  * @param {attribute} oSrcAttribute
  * @type attribute
  * @returns {attribute}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536698.aspx
*/

table.prototype.removeAttributeNode=function(oSrcAttribute){};
/**
  * function removeBehavior(iID)
  * @param {Number} iID
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536700.aspx
*/

table.prototype.removeBehavior=function(iID){};
/**
  * function removeChild(oNode)
  * @param {Object} oNode
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536702.aspx
*/

table.prototype.removeChild=function(oNode){};
/**
  * function removeExpression(sPropertyName)
  * @param {String} sPropertyName
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/aa358798.aspx
*/

table.prototype.removeExpression=function(sPropertyName){};
/**
  * function removeNode(bRemoveChildren)
  * @param {Boolean} bRemoveChildren
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536708.aspx
*/

table.prototype.removeNode=function(bRemoveChildren){};
/**
  * function replaceAdjacentText(sWhere,sReplaceText)
  * @param {String} sWhere
  * @param {String} sReplaceText
  * @type String
  * @returns {String}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536714.aspx
*/

table.prototype.replaceAdjacentText=function(sWhere,sReplaceText){};
/**
  * function replaceChild(oNewNode,oChildNode)
  * @param {Object} oNewNode
  * @param {Object} oChildNode
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536716.aspx
*/

table.prototype.replaceChild=function(oNewNode,oChildNode){};
/**
  * function replaceNode(oNewNode)
  * @param {Object} oNewNode
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536719.aspx
*/

table.prototype.replaceNode=function(oNewNode){};
/**
  * function scrollIntoView(bAlignToTop)
  * @param {Boolean} bAlignToTop
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536730.aspx
*/

table.prototype.scrollIntoView=function(bAlignToTop){};
/**
  * function setActive()
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536738.aspx
*/

table.prototype.setActive=function(){};
/**
  * function setAttribute(sName,vValue)
  * @param {String} sName
  * @param {Number} vValue
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536739.aspx
*/

table.prototype.setAttribute=function(sName,vValue){};
/**
  * function setAttributeNode(oSrcAttribute)
  * @param {attribute} oSrcAttribute
  * @type attribute
  * @returns {attribute}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536741.aspx
*/

table.prototype.setAttributeNode=function(oSrcAttribute){};
/**
  * function setCapture(bContainerCapture)
  * @param {Boolean} bContainerCapture
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536742.aspx
*/

table.prototype.setCapture=function(bContainerCapture){};
/**
  * function setExpression(sPropertyName,sExpression,sLanguage)
  * @param {String} sPropertyName
  * @param {String} sExpression
  * @param {String} sLanguage
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms531196.aspx
*/

table.prototype.setExpression=function(sPropertyName,sExpression,sLanguage){};
/**
  * function swapNode(oNode)
  * @param {Object} oNode
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536774.aspx
*/

table.prototype.swapNode=function(oNode){};
/**
  * Property onactivate
  * @type onactivate
  * @returns {onactivate}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536787.aspx
*/

table.prototype.onactivate= new onactivate();
/**
  * Property activeElement
  * @type Object
  * @returns {Object}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533065.aspx
*/

table.prototype.activeElement=new Object();
/**
  * Property onbeforeactivate
  * @type onbeforeactivate
  * @returns {onbeforeactivate}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536791.aspx
*/

table.prototype.onbeforeactivate= new onbeforeactivate();
/**
  * Property onbeforecut
  * @type onbeforecut
  * @returns {onbeforecut}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536902.aspx
*/

table.prototype.onbeforecut= new onbeforecut();
/**
  * Property onbeforedeactivate
  * @type onbeforedeactivate
  * @returns {onbeforedeactivate}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536903.aspx
*/

table.prototype.onbeforedeactivate= new onbeforedeactivate();
/**
  * Property onbeforeeditfocus
  * @type onbeforeeditfocus
  * @returns {onbeforeeditfocus}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536904.aspx
*/

table.prototype.onbeforeeditfocus= new onbeforeeditfocus();
/**
  * Property onbeforepaste
  * @type onbeforepaste
  * @returns {onbeforepaste}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536905.aspx
*/

table.prototype.onbeforepaste= new onbeforepaste();
/**
  * Property onblur
  * @type onblur
  * @returns {onblur}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536909.aspx
*/

table.prototype.onblur= new onblur();
/**
  * Property onclick
  * @type onclick
  * @returns {onclick}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536913.aspx
*/

table.prototype.onclick= new onclick();
/**
  * Property oncontextmenu
  * @type oncontextmenu
  * @returns {oncontextmenu}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536914.aspx
*/

table.prototype.oncontextmenu= new oncontextmenu();
/**
  * Property oncontrolselect
  * @type oncontrolselect
  * @returns {oncontrolselect}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537844.aspx
*/

table.prototype.oncontrolselect= new oncontrolselect();
/**
  * Property oncut
  * @type oncut
  * @returns {oncut}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536917.aspx
*/

table.prototype.oncut= new oncut();
/**
  * Property ondblclick
  * @type ondblclick
  * @returns {ondblclick}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536921.aspx
*/

table.prototype.ondblclick= new ondblclick();
/**
  * Property ondeactivate
  * @type ondeactivate
  * @returns {ondeactivate}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536922.aspx
*/

table.prototype.ondeactivate= new ondeactivate();
/**
  * Property ondrag
  * @type ondrag
  * @returns {ondrag}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536923.aspx
*/

table.prototype.ondrag= new ondrag();
/**
  * Property ondragend
  * @type ondragend
  * @returns {ondragend}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536924.aspx
*/

table.prototype.ondragend= new ondragend();
/**
  * Property ondragenter
  * @type ondragenter
  * @returns {ondragenter}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536925.aspx
*/

table.prototype.ondragenter= new ondragenter();
/**
  * Property ondragleave
  * @type ondragleave
  * @returns {ondragleave}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536926.aspx
*/

table.prototype.ondragleave= new ondragleave();
/**
  * Property ondragover
  * @type ondragover
  * @returns {ondragover}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536927.aspx
*/

table.prototype.ondragover= new ondragover();
/**
  * Property ondragstart
  * @type ondragstart
  * @returns {ondragstart}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536928.aspx
*/

table.prototype.ondragstart= new ondragstart();
/**
  * Property ondrop
  * @type ondrop
  * @returns {ondrop}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536929.aspx
*/

table.prototype.ondrop= new ondrop();
/**
  * Property onfilterchange
  * @type onfilterchange
  * @returns {onfilterchange}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536932.aspx
*/

table.prototype.onfilterchange= new onfilterchange();
/**
  * Property onfocus
  * @type onfocus
  * @returns {onfocus}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536934.aspx
*/

table.prototype.onfocus= new onfocus();
/**
  * Property onfocusin
  * @type onfocusin
  * @returns {onfocusin}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536935.aspx
*/

table.prototype.onfocusin= new onfocusin();
/**
  * Property onfocusout
  * @type onfocusout
  * @returns {onfocusout}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536936.aspx
*/

table.prototype.onfocusout= new onfocusout();
/**
  * Property onhelp
  * @type onhelp
  * @returns {onhelp}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536937.aspx
*/

table.prototype.onhelp= new onhelp();
/**
  * Property onkeydown
  * @type onkeydown
  * @returns {onkeydown}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536938.aspx
*/

table.prototype.onkeydown= new onkeydown();
/**
  * Property onkeypress
  * @type onkeypress
  * @returns {onkeypress}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536939.aspx
*/

table.prototype.onkeypress= new onkeypress();
/**
  * Property onkeyup
  * @type onkeyup
  * @returns {onkeyup}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536940.aspx
*/

table.prototype.onkeyup= new onkeyup();
/**
  * Property onlosecapture
  * @type onlosecapture
  * @returns {onlosecapture}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536943.aspx
*/

table.prototype.onlosecapture= new onlosecapture();
/**
  * Property onmousedown
  * @type onmousedown
  * @returns {onmousedown}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536944.aspx
*/

table.prototype.onmousedown= new onmousedown();
/**
  * Property onmouseenter
  * @type onmouseenter
  * @returns {onmouseenter}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536945.aspx
*/

table.prototype.onmouseenter= new onmouseenter();
/**
  * Property onmouseleave
  * @type onmouseleave
  * @returns {onmouseleave}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536946.aspx
*/

table.prototype.onmouseleave= new onmouseleave();
/**
  * Property onmousemove
  * @type onmousemove
  * @returns {onmousemove}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536947.aspx
*/

table.prototype.onmousemove= new onmousemove();
/**
  * Property onmouseout
  * @type onmouseout
  * @returns {onmouseout}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536948.aspx
*/

table.prototype.onmouseout= new onmouseout();
/**
  * Property onmouseover
  * @type onmouseover
  * @returns {onmouseover}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536949.aspx
*/

table.prototype.onmouseover= new onmouseover();
/**
  * Property onmouseup
  * @type onmouseup
  * @returns {onmouseup}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536950.aspx
*/

table.prototype.onmouseup= new onmouseup();
/**
  * Property onmousewheel
  * @type onmousewheel
  * @returns {onmousewheel}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536951.aspx
*/

table.prototype.onmousewheel= new onmousewheel();
/**
  * Property onmove
  * @type onmove
  * @returns {onmove}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536952.aspx
*/

table.prototype.onmove= new onmove();
/**
  * Property onmoveend
  * @type onmoveend
  * @returns {onmoveend}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536953.aspx
*/

table.prototype.onmoveend= new onmoveend();
/**
  * Property onmovestart
  * @type onmovestart
  * @returns {onmovestart}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536954.aspx
*/

table.prototype.onmovestart= new onmovestart();
/**
  * Property onpaste
  * @type onpaste
  * @returns {onpaste}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536955.aspx
*/

table.prototype.onpaste= new onpaste();
/**
  * Property onpropertychange
  * @type onpropertychange
  * @returns {onpropertychange}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536956.aspx
*/

table.prototype.onpropertychange= new onpropertychange();
/**
  * Property onreadystatechange
  * @type onreadystatechange
  * @returns {onreadystatechange}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536957.aspx
*/

table.prototype.onreadystatechange= new onreadystatechange();
/**
  * Property onresize
  * @type onresize
  * @returns {onresize}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536959.aspx
*/

table.prototype.onresize= new onresize();
/**
  * Property onresizeend
  * @type onresizeend
  * @returns {onresizeend}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536960.aspx
*/

table.prototype.onresizeend= new onresizeend();
/**
  * Property onresizestart
  * @type onresizestart
  * @returns {onresizestart}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536961.aspx
*/

table.prototype.onresizestart= new onresizestart();
/**
  * Property onscroll
  * @type onscroll
  * @returns {onscroll}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536966.aspx
*/

table.prototype.onscroll= new onscroll();
/**
  * Property onselectstart
  * @type onselectstart
  * @returns {onselectstart}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536969.aspx
*/

table.prototype.onselectstart= new onselectstart();
/**
  * Property ontimeerror
  * @type ontimeerror
  * @returns {ontimeerror}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533588.aspx
*/

table.prototype.ontimeerror= new ontimeerror();
/**
  * Property all
  * @type all
  * @returns {all}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537434.aspx
*/

table.prototype.all= new all();
/**
  * Property attributes
  * @type attributes
  * @returns {attributes}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537438.aspx
*/

table.prototype.attributes= new attributes();
/**
  * Property behaviorUrns
  * @type behaviorUrns
  * @returns {behaviorUrns}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537439.aspx
*/

table.prototype.behaviorUrns= new behaviorUrns();
/**
  * Property cells
  * @type cells
  * @returns {cells}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537443.aspx
*/

table.prototype.cells= new cells();
/**
  * Property childNodes
  * @type childNodes
  * @returns {childNodes}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537445.aspx
*/

table.prototype.childNodes= new childNodes();
/**
  * Property TextNode
  * @type TextNode
  * @returns {TextNode}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535905.aspx
*/

table.prototype.TextNode= new TextNode();
/**
  * Property children
  * @type children
  * @returns {children}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537446.aspx
*/

table.prototype.children= new children();
/**
  * Property filters
  * @type filters
  * @returns {filters}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537452.aspx
*/

table.prototype.filters= new filters();
/**
  * Property rows
  * @type rows
  * @returns {rows}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537484.aspx
*/

table.prototype.rows= new rows();
/**
  * Property tr
  * @type tr
  * @returns {tr}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535911.aspx
*/

table.prototype.tr= new tr();
/**
  * Property tBodies
  * @type tBodies
  * @returns {tBodies}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537490.aspx
*/

table.prototype.tBodies= new tBodies();
/**
  * Property tBody
  * @type tBody
  * @returns {tBody}
  * @memberOf table
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535902.aspx
*/

table.prototype.tBody= new tBody();
