/* -*- c-file-style: "GNU" -*- */
/*
 * Copyright (C) CNRS, INRIA, Universite Bordeaux 1, Telecom SudParis
 * See COPYING in top-level directory.
 */

#ifndef __GOMP_EV_CODES_H__
#define __GOMP_EV_CODES_H__

#include "ev_codes.h"

#define EZTRACE_GOMP_EVENTS_ID    SYSTEM_MODULE_ID(0x01)
#define EZTRACE_GOMP_PREFIX       GENERATE_SYSTEM_MODULE_PREFIX(EZTRACE_GOMP_EVENTS_ID)

#define EZTRACE_GOMP_PARALLEL_START (EZTRACE_GOMP_PREFIX | 0x0001)
#define EZTRACE_GOMP_NEW_FORK       (EZTRACE_GOMP_PREFIX | 0x0002)
#define EZTRACE_GOMP_NEW_JOIN       (EZTRACE_GOMP_PREFIX | 0x0003)
#define EZTRACE_GOMP_JOIN_DONE      (EZTRACE_GOMP_PREFIX | 0x0004)

#define EZTRACE_GOMP_CRITICAL_START       (EZTRACE_GOMP_PREFIX | 0x0005)
#define EZTRACE_GOMP_CRITICAL_START_DONE  (EZTRACE_GOMP_PREFIX | 0x0006)
#define EZTRACE_GOMP_CRITICAL_STOP        (EZTRACE_GOMP_PREFIX | 0x0007)

#define EZTRACE_POMP2_FINALIZE        (EZTRACE_GOMP_PREFIX | 0xffff)

#define EZTRACE_POMP2_ATOMIC_ENTER    (EZTRACE_GOMP_PREFIX | 0x0010)
#define EZTRACE_POMP2_ATOMIC_EXIT     (EZTRACE_GOMP_PREFIX | 0x0011)

#define EZTRACE_POMP2_BARRIER_ENTER   (EZTRACE_GOMP_PREFIX | 0x0020)
#define EZTRACE_POMP2_BARRIER_EXIT    (EZTRACE_GOMP_PREFIX | 0x0021)
#define EZTRACE_POMP2_IMPLICIT_BARRIER_ENTER   (EZTRACE_GOMP_PREFIX | 0x0022)
#define EZTRACE_POMP2_IMPLICIT_BARRIER_EXIT    (EZTRACE_GOMP_PREFIX | 0x0023)

#define EZTRACE_POMP2_FLUSH_ENTER     (EZTRACE_GOMP_PREFIX | 0x0030)
#define EZTRACE_POMP2_FLUSH_EXIT      (EZTRACE_GOMP_PREFIX | 0x0031)

#define EZTRACE_POMP2_CRITICAL_ENTER  (EZTRACE_GOMP_PREFIX | 0x0040)
#define EZTRACE_POMP2_CRITICAL_EXIT   (EZTRACE_GOMP_PREFIX | 0x0041)
#define EZTRACE_POMP2_CRITICAL_BEGIN  (EZTRACE_GOMP_PREFIX | 0x0042)
#define EZTRACE_POMP2_CRITICAL_END    (EZTRACE_GOMP_PREFIX | 0x0043)

#define EZTRACE_POMP2_FOR_ENTER       (EZTRACE_GOMP_PREFIX | 0x0050)
#define EZTRACE_POMP2_FOR_EXIT        (EZTRACE_GOMP_PREFIX | 0x0051)

#define EZTRACE_POMP2_MASTER_BEGIN    (EZTRACE_GOMP_PREFIX | 0x0060)
#define EZTRACE_POMP2_MASTER_END      (EZTRACE_GOMP_PREFIX | 0x0061)

#define EZTRACE_POMP2_PARALLEL_BEGIN  (EZTRACE_GOMP_PREFIX | 0x0070)
#define EZTRACE_POMP2_PARALLEL_END    (EZTRACE_GOMP_PREFIX | 0x0071)
#define EZTRACE_POMP2_PARALLEL_FORK   (EZTRACE_GOMP_PREFIX | 0x0072)
#define EZTRACE_POMP2_PARALLEL_JOIN   (EZTRACE_GOMP_PREFIX | 0x0073)

#define EZTRACE_POMP2_SECTIONS_ENTER  (EZTRACE_GOMP_PREFIX | 0x0080)
#define EZTRACE_POMP2_SECTIONS_EXIT   (EZTRACE_GOMP_PREFIX | 0x0081)

#define EZTRACE_POMP2_SECTION_BEGIN   (EZTRACE_GOMP_PREFIX | 0x0082)
#define EZTRACE_POMP2_SECTION_END    (EZTRACE_GOMP_PREFIX | 0x0083)

#define EZTRACE_POMP2_SINGLE_ENTER    (EZTRACE_GOMP_PREFIX | 0x0090)
#define EZTRACE_POMP2_SINGLE_EXIT     (EZTRACE_GOMP_PREFIX | 0x0091)
#define EZTRACE_POMP2_SINGLE_BEGIN    (EZTRACE_GOMP_PREFIX | 0x0092)
#define EZTRACE_POMP2_SINGLE_END     (EZTRACE_GOMP_PREFIX | 0x0093)

#define EZTRACE_POMP2_WORKSHARE_ENTER (EZTRACE_GOMP_PREFIX | 0x00a0)
#define EZTRACE_POMP2_WORKSHARE_EXIT  (EZTRACE_GOMP_PREFIX | 0x00a1)

#define EZTRACE_POMP2_TASK_BEGIN        (EZTRACE_GOMP_PREFIX | 0x00b0)
#define EZTRACE_POMP2_TASK_END          (EZTRACE_GOMP_PREFIX | 0x00b1)
#define EZTRACE_POMP2_TASK_CREATE_BEGIN (EZTRACE_GOMP_PREFIX | 0x00b2)
#define EZTRACE_POMP2_TASK_CREATE_END   (EZTRACE_GOMP_PREFIX | 0x00b3)

#define EZTRACE_POMP2_UNTIED_TASK_BEGIN        (EZTRACE_GOMP_PREFIX | 0x00b4)
#define EZTRACE_POMP2_UNTIED_TASK_END          (EZTRACE_GOMP_PREFIX | 0x00b5)
#define EZTRACE_POMP2_UNTIED_TASK_CREATE_BEGIN (EZTRACE_GOMP_PREFIX | 0x00b6)
#define EZTRACE_POMP2_UNTIED_TASK_CREATE_END   (EZTRACE_GOMP_PREFIX | 0x00b7)

#define EZTRACE_POMP2_TASKWAIT_BEGIN    (EZTRACE_GOMP_PREFIX | 0x00b8)
#define EZTRACE_POMP2_TASKWAIT_END      (EZTRACE_GOMP_PREFIX | 0x00b9)

#define EZTRACE_POMP2_TASK_INFO         (EZTRACE_GOMP_PREFIX | 0x00ba)

#ifdef OPENMP_FOUND
#define EZTRACE_POMP2_SET_LOCK_ENTRY    (EZTRACE_GOMP_PREFIX | 0x0101)
#define EZTRACE_POMP2_SET_LOCK_EXIT     (EZTRACE_GOMP_PREFIX | 0x0102)
#define EZTRACE_POMP2_TEST_LOCK_SUCCESS (EZTRACE_GOMP_PREFIX | 0x0103)
#define EZTRACE_POMP2_UNSET_LOCK        (EZTRACE_GOMP_PREFIX | 0x0104)

#define EZTRACE_POMP2_SET_NEST_LOCK_ENTRY    (EZTRACE_GOMP_PREFIX | 0x0111)
#define EZTRACE_POMP2_SET_NEST_LOCK_EXIT     (EZTRACE_GOMP_PREFIX | 0x0112)
#define EZTRACE_POMP2_TEST_NEST_LOCK_SUCCESS (EZTRACE_GOMP_PREFIX | 0x0113)
#define EZTRACE_POMP2_UNSET_NEST_LOCK        (EZTRACE_GOMP_PREFIX | 0x0114)
#endif /* OPENMP_FOUND */

#endif	/* __GOMP_EV_CODES_H__ */
