/* bin2c.c	4/9/1996
 * convert a binary (or text) file to C.
 */

/* Copyright (c) 1995,1996 Sascha Demetrio
 * Copyright (c) 2009, 2010, 2015 Peter Pentchev
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *    If you modify any part of HEXER and redistribute it, you must add
 *    a notice to the `README' file and the modified source files containing
 *    information about the  changes you made.  I do not want to take
 *    credit or be blamed for your modifications.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *    If you modify any part of HEXER and redistribute it in binary form,
 *    you must supply a `README' file containing information about the
 *    changes you made.
 * 3. The name of the developer may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * HEXER WAS DEVELOPED BY SASCHA DEMETRIO.
 * THIS SOFTWARE SHOULD NOT BE CONSIDERED TO BE A COMMERCIAL PRODUCT.
 * THE DEVELOPER URGES THAT USERS WHO REQUIRE A COMMERCIAL PRODUCT
 * NOT MAKE USE OF THIS WORK.
 *
 * DISCLAIMER:
 * THIS SOFTWARE IS PROVIDED BY THE DEVELOPER ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE DEVELOPER BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <unistd.h>

static const char *usage = "\
usage: bin2c [-t] [-h] [-o outputfile] [-n name] [inputfile]\n\
  -t  you can use this option if the inputfile is a small (< 1K) textfile.\n\
  -h  display this help message.\n\
  -o outputfile\n\
      write the output to outputfile.  the default is <stdout>.\n\
  -n name\n\
      the name of the C variable generated.  the default is `data'\n\
  if no inputfile is specified, the input is read from <stdin>.\n\
";

  int
main(int argc, char **argv)
{
  const char *name = "data";
  FILE *in = stdin, *out = stdout;
  int text_f = 0;
  char *outfile = 0;
  int c;
  int i;

  while ((c = getopt(argc, argv, "htn:o:")) != -1)
    switch (c) {
    case 't':  /* generate a C string.  this option useful only
                * for *very* small text files, since some compilers
		* refuse to compile extremely long strings.  */
      ++text_f;
      break;
    case 'n':  /* select the name of the output C array. */
      name = optarg;
      break;
    case 'o':  /* select the name of the output file. */
      outfile = optarg;
      break;
    default:
      fprintf(stderr, "%s: invalid option -- -%c\n", *argv, (char)c);
    case 'h':
    case '?':
      fputs(usage, stderr);
      exit(1);
    }
  if (argc - optind > 1) {
    fputs(usage, stderr);
    exit(1);
  } else if (argc - optind == 1)
    if (!(in = fopen(argv[optind], "r"))) {
      perror(argv[optind]);
      exit(1);
    }
  if (outfile)
    if (!(out = fopen(outfile, "w"))) {
      perror(outfile);
      fclose(in);
      exit(1);
    }

  fprintf(out, "/* %s.c\n * generated by bin2c - do not edit!\n */\n\n", name);
/* Copyright (c) 1995,1996 Sascha Demetrio
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *    If you modify any part of HEXER and redistribute it, you must add
 *    a notice to the `README' file and the modified source files containing
 *    information about the  changes you made.  I do not want to take
 *    credit or be blamed for your modifications.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *    If you modify any part of HEXER and redistribute it in binary form,
 *    you must supply a `README' file containing information about the
 *    changes you made.
 * 3. The name of the developer may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * HEXER WAS DEVELOPED BY SASCHA DEMETRIO.
 * THIS SOFTWARE SHOULD NOT BE CONSIDERED TO BE A COMMERCIAL PRODUCT.
 * THE DEVELOPER URGES THAT USERS WHO REQUIRE A COMMERCIAL PRODUCT
 * NOT MAKE USE OF THIS WORK.
 *
 * DISCLAIMER:
 * THIS SOFTWARE IS PROVIDED BY THE DEVELOPER ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE DEVELOPER BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
  if (text_f) {
    fprintf(out, "char %s[] = \"\\\n", name);
    for (;;) {
      c = getc(in);
      if (feof(in)) break;
      if (!isprint(c))
	switch (c) {
	case '\n':
	  fprintf(out, "\\n\\\n");
	  break;
	case '\b':
	  fprintf(out, "\\b");
	  break;
	default:
	  fprintf(out, "\\%o", (int)(unsigned char)c);
	}
      else
	switch (c) {
	case '\\':
	  fprintf(out, "\\\\");
	  break;
	case '\"':
	  fprintf(out, "\\\"");
	  break;
	default:
	  putc(c, out);
	}
    }
    fprintf(out, "\";\n\n");
  } else {
    fprintf(out, "char %s[] = {", name);
    for (i = 0;; ++i) {
      c = getc(in);
      if (feof(in)) break;
      if (!(i % 8)) fprintf(out, "\n ");
      fprintf(out, " 0x%02x,", (int)(unsigned char)c);
    }
    if (!(i % 8)) fprintf(out, "\n ");
    fprintf(out, " 0\n};\n\n");
      /* we write a trailing 0 so the array can be used as a sting. */
  }
  fprintf(out, "/* end of %s.c */\n\n", name);
  fclose(in);
  fclose(out);
  return 0;
}
/* main */

