#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (C) 2009 Alessio Treglia
#
# This file is part of installation-report-generator.
#
# installation-report-generator is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# installation-report-generator is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with installation-report-generator.  If not, see <http://www.gnu.org/licenses/>.

import os, sys
import thread, threading, time
import irgenerator.globals

__doc__ = irgenerator.globals.__doc__

class VirtualClassInstanceError(Exception):
    def __init__(self):
        Exception.__init__(self, "can't create a virtual class instance")

class VirtualMethodCallError(Exception):
    def __init__(self):
        Exception.__init__(self, "can't call a virtual method")

class IPlugin:
    def __init__(self):
        if self.__class__.__name__ == "IPlugin":
            raise VirtualClassInstanceError
    def get_report(self):
        raise VirtualMethodError

class AbstractPlugin(threading.Thread):
    def __init__(self, active_obj=None, hwconfig=None):
        if self.__class__.__name__ != 'AbstractPlugin':
            threading.Thread.__init__(self)
            self.obj = active_obj
            self.hwconfig = hwconfig
        else:
            raise VirtualClassInstanceError
    def run(self):
        raise VirtualMethodError
    def set_active_obj(self, active_obj):
        self.obj = active_obj
    def set_hwconfig(self, hwconfig):
        self.hwconfig = hwconfig

class PluginCentral(object):
    from irgenerator.globals import PLUGINS_PATH
    plugins_list = set (map(lambda x: x.split('.')[0], os.listdir(PLUGINS_PATH)))
    loaded_plugins = dict()
    @staticmethod
    def load_plugin(name):
        plugin = None
        try: # check if it has just been loaded
            plugin = PluginCentral.loaded_plugins[name]
        except KeyError: # load the plugin
            sys.path.append(PluginCentral.PLUGINS_PATH)
            plugin_module = __import__(name)
            plugin = getattr(plugin_module, name + 'Plugin')
            PluginCentral.loaded_plugins[name] = plugin # and insert in to the dict
            sys.path.pop()
        return plugin # return the class
    @staticmethod
    def get_available_plugins():
        plugins_description = dict()
        for name in PluginCentral.plugins_list:
            plugin = PluginCentral.load_plugin(name)
            if plugin.enabled:
                plugins_description[name] = plugin.description
        return plugins_description

