#!/usr/bin/perl

# GPL Paul Slootman <paul@wurtel.demon.nl> 1998
#
# script to convert .config as generated by 'make menuconfig' into
# scripts/autoconf.h , so that one can edit .config by hand and then
# non-interactively create a configuration ready for building. Useful
# for package building (I'm thinking Debian or Red Hat here).

open(IN,  "<.config") || die "Can't open .config: $!\n";
open(OUT, ">scripts/autoconf.h") || die "Can't open scripts/autoconf.h: $!\n";

while (<IN>) {
    chop;
    next if /^#\s*$/;                   # empty comment line; ignore
    if (/^\s*$/) {                      # empty line; echo
        print OUT "\n";
        next;
    }
    if (/^# ([^\s]+) is not set/) {     # unset variables
        print OUT "#undef  $1\n";
        next;
    }
    if (/^#\s+([^\s].*)\s*/) {          # comment
        print OUT "/*\n * $1\n */\n";
        print OUT "#define AUTOCONF_INCLUDED\n" if /Automatically generated by/;
        next;
    }
    if (/(\w+)=(.*)/) {                 # assignment
        $var = $1;
        $val = $2;
        if ($val eq 'y') {                      # boolean true value
            print OUT "#define $var 1\n";
            next;
        }
        if ($val =~ /^['"](.*)["']$/) {         # string value
            print OUT "#define $var \"$1\"\n";
            next;
        }
        if ($val =~ /^(\d+)$/) {                # numeric value
            print OUT "#define $var ($1)\n";
            next;
        }
        die "Unexpected input at line $.: $_\n";
    }
}

close(IN);
close(OUT);
exit(0);
