/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include <QtGui/QInputDialog>
#include <QtGui/QStringListModel>

#include "connection.h"
#include "itemview.h"
#include "ldapsearchdialog.h"

#include "delegatefield.h"

using namespace Form;

class DelegateModel : public QStringListModel
{
  public:
    DelegateModel( QObject *parent = 0 )
      : QStringListModel( parent )
    {
    }

    virtual Qt::ItemFlags flags( const QModelIndex& ) const
    {
      return ( Qt::ItemIsSelectable | Qt::ItemIsEnabled );
    }
};

class DelegateItemView : public ItemView
{
  public:
    DelegateItemView( QWidget *parent )
      : ItemView( parent )
    {
    }

  protected:
    virtual void doAdd()
    {
      QStringList blacklist;
      blacklist << QString( "cn=manager,cn=internal,%1" ).arg( Connection::self()->baseDn() );
      blacklist << QString( "cn=calendar,cn=internal,%1" ).arg( Connection::self()->baseDn() );
      blacklist << QString( "cn=nobody,cn=internal,%1" ).arg( Connection::self()->baseDn() );

      LdapSearchDialog dlg( Connection::self(), this );
      dlg.setSearchFilter( "(&(objectClass=kolabInetOrgPerson)(|(mail=*%i*)))" );
      dlg.setDisplayFormat( "%mail%" );
      dlg.setBlackList( blacklist );

      if ( dlg.exec() ) {
        QStringList emails = dlg.selectedValues( "mail" );

        QAbstractItemModel *model = mListView->model();

        for ( int i = 0; i < emails.count(); ++i ) {
          bool found = false;
          for ( int j = 0; j < model->rowCount(); ++j ) {
            if ( emails[ i ] == model->data( model->index( j, 0 ) ).toString() ) {
              found = true;
              break;
            }
          }

          if ( !found ) {
            int pos = model->rowCount();
            model->insertRow( pos );
            model->setData( model->index( pos, 0 ), emails[ i ] );
          }
        }
      }
    }
};

DelegateField::DelegateField( const QString &name, QWidget *parent )
  : Field( name, parent )
{
  mView = new DelegateItemView( this );

  mModel = new DelegateModel( this );
  mView->setModel( mModel );

  fieldLayout()->addWidget( mView, 0, 0 );
}

void DelegateField::loadEntry( const Entry &entry )
{
  mModel->setStringList( entry.values( "kolabDelegate" ) );
}

void DelegateField::saveEntry( Entry &entry ) const
{
  entry.clearValue( "kolabDelegate" );

  const QStringList delegates = mModel->stringList();
  for ( int i = 0; i < delegates.count(); ++i ) {
    entry.addValue( "kolabDelegate", delegates[ i ] );
  }
}

bool DelegateField::isValid( QString&, PagePolicy::State ) const
{
  return true;
}

void DelegateField::setEditable( bool editable )
{
  mView->setEnabled( editable );
}

