<h1 align="center">
    <img
        width="500"
        src="https://raw.githubusercontent.com/liquidprompt/liquidprompt/master/docs/liquidprompt_emblem.svg"
        alt="Liquid Prompt"
    />
    <br/>
    A useful adaptive prompt for Bash & Zsh
</h1>

<p align="center">
<em>Liquid Prompt</em> gives you a <strong>carefully designed prompt</strong> with useful information.
It shows you <em>what</em> you need <em>when</em> you need it.
You will notice what changes when it changes, saving time and frustration.
You can even use it with your favorite shell – Bash or zsh.
</p>

<h2 align="center">
        <a href="https://liquidprompt.readthedocs.io">Website</a>
        &bull;
        <a href="https://liquidprompt.readthedocs.io/en/stable/overview.html">Overview</a>
        &bull;
        <a href="https://liquidprompt.readthedocs.io/en/stable/install.html">Install</a>
<h2>


## Examples

Below are screenshots of typical states that you would see in everyday use.

Using the default theme:

![Screenshot](https://raw.githubusercontent.com/liquidprompt/liquidprompt/master/docs/theme/default-med.png)

Using the Powerline theme:

![Screenshot](https://raw.githubusercontent.com/liquidprompt/liquidprompt/master/docs/theme/included/powerline-med.png)

Of course, Liquid Prompt may display much more information, depending on the status of your system.


## Why Liquidprompt?

There are many prompts configurations out there, but here is what makes Liquid Prompt stand out:

- **UX Design**: The Liquid Prompt was very carefully design from the beginning, to allow for the best user experience.
  That is, it displays *meaningful* information with *minimal visual clutter* and *maximum readability*.
  While most of the other prompts are focused on aligning as much colored "segments" as possible on top of each others to look fancy,
  Liquid Prompt focus on what really matters.
- **Ease of use**: The Liquid Prompt is written in (*heavily optimized*) portable Shell, and its installation is as easy as copying files.
  It also provides pre-defined themes, enabled by a simple command in your shell configuration.
  Configuration is as simple as editing text file with key/value pairs. No complex format to learn.
- **Shell features first**: The Liquid Prompt helps you being aware of all the powerfull features a modern shell can provide.
  While most of the other prompts focus on covering a lot of (boring) software version tags,
  Liquid Prompt shows you the features that are actually useful while you actually use the shell.
- **Configurability**: All aspects of Liquid Prompt are configurable, down to the core.

To see what that entails, see the [latest features overview](https://liquidprompt.readthedocs.io/en/latest/overview.html)
(which also presents a comparison with other prompt systems).

You may also take a closer look at this screenshot of a session showing various features, in the default theme:

![Screenshot](https://raw.github.com/liquidprompt/liquidprompt/master/demo.png)


## Documentation

![Tests](https://github.com/liquidprompt/liquidprompt/workflows/tests/badge.svg)
[![Documentation Status](https://readthedocs.org/projects/liquidprompt/badge/?version=stable)](https://liquidprompt.readthedocs.io/)

See the [Liquidprompt documentation](https://liquidprompt.readthedocs.io/) for
details on installing and configuring Liquidprompt.


## License

Liquid Prompt is distributed under the [GNU Affero General Public License
version 3](LICENSE).


## Authors

Current Maintainer: [Rycieos](https://github.com/Rycieos).
Other main authors: [nojhan](https://github.com/nojhan) and [dolmen](https://github.com/dolmen).

And many [contributors](CONTRIBUTORS.md)!
