### NAME

lib1305 - C API for the lib1305 implementation of the Poly1305 one-time authenticator

### SYNOPSIS

Using lib1305:

    #include <lib1305.h>

Link with `-l1305`.

Authenticating a message:

    unsigned char a[poly1305_BYTES];
    const unsigned char m[mlen];
    const unsigned char k[poly1305_KEYBYTES];

    poly1305(a,m,mlen,k);

Verifying an authenticator:

    const unsigned char a[poly1305_BYTES];
    const unsigned char m[mlen];
    const unsigned char k[poly1305_KEYBYTES];
    int result;

    result = poly1305_verify(a,m,mlen,k);

### DESCRIPTION

lib1305 is an implementation
of the Poly1305 one-time authenticator.
The lib1305 functions follow the SUPERCOP `onetimeauth` API
except that

* the function names are lib1305-specific instead of `crypto_onetimeauth_*`,
* message lengths are `long long` instead of `unsigned long long`, and
* the `poly1305` function returns `void` instead of `int`.

The `poly1305` function generates
an authenticator `a[0]`, `a[1]`, ..., `a[poly1305_BYTES-1]`
given a message
`m[0]`, `m[1]`, ..., `m[mlen-1]`
and a secret key
`k[0]`, `k[1]`, ..., `k[poly1305_KEYBYTES-1]`.
"One-time" means that the secret key must not be reused to generate an authenticator of another message.

The `poly1305_verify` function verifies
an authenticator `a[0]`, `a[1]`, ..., `a[poly1305_BYTES-1]`
given a message
`m[0]`, `m[1]`, ..., `m[mlen-1]`
and a secret key
`k[0]`, `k[1]`, ..., `k[poly1305_KEYBYTES-1]`.
It returns `0` if the authenticator is valid,
otherwise nonzero.

### SEE ALSO

**randombytes**(3)
