------------------------------------------------------------------------------
--                              Ada Web Server                              --
--                                                                          --
--                     Copyright (C) 2003-2013, AdaCore                     --
--                                                                          --
--  This library is free software;  you can redistribute it and/or modify   --
--  it under terms of the  GNU General Public License  as published by the  --
--  Free Software  Foundation;  either version 3,  or (at your  option) any --
--  later version. This library is distributed in the hope that it will be  --
--  useful, but WITHOUT ANY WARRANTY;  without even the implied warranty of --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                    --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--  You should have received a copy of the GNU General Public License and   --
--  a copy of the GCC Runtime Library Exception along with this program;    --
--  see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see   --
--  <http://www.gnu.org/licenses/>.                                         --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Unchecked_Conversion;

with Interfaces.C;

with AWS.Net.SSL.Certificate.Impl;

package body AWS.Net.SSL.Certificate is

   ---------------------
   -- Activation_Time --
   ---------------------

   function Activation_Time (Certificate : Object) return Calendar.Time is
   begin
      return Certificate.Activation;
   end Activation_Time;

   ---------------------
   -- Expiration_Time --
   ---------------------

   function Expiration_Time (Certificate : Object) return Calendar.Time is
   begin
      return Certificate.Expiration;
   end Expiration_Time;

   ---------
   -- Get --
   ---------

   function Get (Socket : Socket_Type) return Object is
   begin
      return Impl.Get (Socket);
   end Get;

   ------------
   -- Issuer --
   ------------

   function Issuer  (Certificate : Object) return String is
   begin
      return To_String (Certificate.Issuer);
   end Issuer;

   -------------------
   -- Serial_Number --
   -------------------

   function Serial_Number (Certificate : Object) return String is
   begin
      return To_String (Certificate.Serial_Number);
   end Serial_Number;

   -------------------------
   -- Set_Verify_Callback --
   -------------------------

   procedure Set_Verify_Callback
     (Config : in out SSL.Config; Callback : Verify_Callback)
   is
      function To_Address is new Unchecked_Conversion
        (Net.SSL.Certificate.Verify_Callback, System.Address);
   begin
      Set_Verify_Callback (Config, To_Address (Callback));
   end Set_Verify_Callback;

   ------------
   -- Status --
   ------------

   function Status (Certificate : Object) return Long_Integer is
   begin
      return Certificate.Status;
   end Status;

   --------------------
   -- Status_Message --
   --------------------

   function Status_Message (Certificate : Object) return String is
   begin
      return Impl.Status_String (Interfaces.C.long (Certificate.Status));
   end Status_Message;

   -------------
   -- Subject --
   -------------

   function Subject (Certificate : Object) return String is
   begin
      return To_String (Certificate.Subject);
   end Subject;

   --------------
   -- Verified --
   --------------

   function Verified (Certificate : Object) return Boolean is
   begin
      return Certificate.Verified;
   end Verified;

end AWS.Net.SSL.Certificate;
