WITH ada.strings.unbounded;
WITH ada.tags;
WITH ada.unchecked_deallocation;

WITH ibusiness_unit.fm_manager;

PACKAGE BODY ibusiness_unit.test IS

   Package fm renames ibusiness_unit.fm_manager;


   TYPE private_members IS
      RECORD

          fm_ref    : fm.reference    := NULL;

         is_initialized : boolean         := false;

         shortcut        : ada.strings.unbounded.unbounded_string;
         description     : ada.strings.unbounded.unbounded_string;
      END RECORD;

      PROCEDURE free IS NEW ada.unchecked_deallocation
      (object => object'class, name => reference);
   PROCEDURE free IS NEW ada.unchecked_deallocation
      (private_members, access_private_members);


  FUNCTION create (tracer_class_name        : IN string := "";
                    tracer_class_description : IN string := "")
                    RETURN ibusiness_unit.reference IS
      myself : reference;

   BEGIN

      myself        := NEW object;
      myself.member := NEW private_members;

      myself.member.shortcut          :=
         ada.strings.unbounded.to_unbounded_string (tracer_class_name);
      myself.member.description       :=
         ada.strings.unbounded.to_unbounded_string (tracer_class_description);

      myself.is_running := true;

      RETURN ibusiness_unit.reference (myself);

   EXCEPTION
      WHEN error: OTHERS =>
         RETURN NULL;
   END create;

  PROCEDURE initialize (ref                  : IN OUT reference;
                         enable : IN boolean) IS
   BEGIN

      IF NOT ref.member.is_initialized THEN
         ref.member.is_initialized := true;
      END IF;

   EXCEPTION
      WHEN error: OTHERS =>
        null;
   END initialize;

  PROCEDURE finalize (ref : IN OUT reference) IS
   BEGIN

      IF ref /= NULL THEN

         free (ref.member);
         free (ref);

      END IF;

   EXCEPTION
      WHEN error: OTHERS =>
         NULL;
   END finalize;


   PROCEDURE proceed (ref : IN OUT reference) IS
      result : fm.info;
  begin

result := fm.get_info(ref => ref.member.fm_ref);
  END proceed;


   FUNCTION get (ref : IN reference) RETURN boolean IS separate;



END ibusiness_unit.test;
