package de.intarsys.tools.reporter;

public class ReportMessage {

	public static final int TYPE_PROGRESS = 0;

	public static final int TYPE_ACTIVITY_START = 1;

	public static final int TYPE_ACTIVITY_END = 2;

	public static final int TYPE_STATUS = 3;

	public static final int TYPE_MESSAGE = 4;

	public static final int TYPE_ERROR = 5;

	private String title;

	private String message;

	private int style;

	private int percent;

	private int type;

	private Throwable throwable;

	public ReportMessage(int type, String title, String message, int style,
			int percent, Throwable throwable) {
		super();
		this.type = type;
		this.title = title;
		this.message = message;
		this.style = style;
		this.percent = percent;
		this.throwable = throwable;
	}

	public String getMessage() {
		return message;
	}

	public int getPercent() {
		return percent;
	}

	public int getStyle() {
		return style;
	}

	public Throwable getThrowable() {
		return throwable;
	}

	public String getTitle() {
		return title;
	}

	public int getType() {
		return type;
	}

	public boolean isActivityEnd() {
		return type == TYPE_ACTIVITY_END;
	}

	public boolean isActivityStart() {
		return type == TYPE_ACTIVITY_START;
	}

	public boolean isError() {
		return type == TYPE_ERROR;
	}

	public boolean isMessage() {
		return type == TYPE_MESSAGE;
	}

	public boolean isProgress() {
		return type == TYPE_PROGRESS;
	}

	public boolean isStatus() {
		return type == TYPE_STATUS;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public void setPercent(int percent) {
		this.percent = percent;
	}

	public void setStyle(int style) {
		this.style = style;
	}

	public void setThrowable(Throwable throwable) {
		this.throwable = throwable;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public void setType(int type) {
		this.type = type;
	}

}
