/* ----- core/inv3sntrup761, derived from supercop/crypto_core/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *core_inv3sntrup761_checksums[] = {
  "9e86b6061fb03967c7366ba2febae6e9e8d1b017f6c232437b46c2f1c54eca0f",
  "1a98d5561c7920363f4ed3c5c6b8f8100ff1a64dca2edcb93ee1b0db6442c929",
} ;

static void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
#define crypto_core_OUTPUTBYTES ntruprime_core_inv3sntrup761_OUTPUTBYTES
#define crypto_core_INPUTBYTES ntruprime_core_inv3sntrup761_INPUTBYTES
#define crypto_core_KEYBYTES ntruprime_core_inv3sntrup761_KEYBYTES
#define crypto_core_CONSTBYTES ntruprime_core_inv3sntrup761_CONSTBYTES

static void *storage_core_inv3sntrup761_h;
static unsigned char *test_core_inv3sntrup761_h;
static void *storage_core_inv3sntrup761_n;
static unsigned char *test_core_inv3sntrup761_n;
static void *storage_core_inv3sntrup761_k;
static unsigned char *test_core_inv3sntrup761_k;
static void *storage_core_inv3sntrup761_c;
static unsigned char *test_core_inv3sntrup761_c;
static void *storage_core_inv3sntrup761_h2;
static unsigned char *test_core_inv3sntrup761_h2;
static void *storage_core_inv3sntrup761_n2;
static unsigned char *test_core_inv3sntrup761_n2;
static void *storage_core_inv3sntrup761_k2;
static unsigned char *test_core_inv3sntrup761_k2;
static void *storage_core_inv3sntrup761_c2;
static unsigned char *test_core_inv3sntrup761_c2;

#define precomputed_core_inv3sntrup761_NUM 5

static const unsigned char precomputed_core_inv3sntrup761_h[precomputed_core_inv3sntrup761_NUM][crypto_core_OUTPUTBYTES] = {
  {1,1,255,0,1,1,0,1,0,0,1,0,0,255,0,255,0,255,255,255,1,0,0,1,255,1,255,255,1,1,0,255,0,0,255,255,1,0,0,255,255,255,0,1,0,1,255,255,0,0,255,1,1,1,1,1,0,255,0,1,0,255,255,255,0,1,1,0,1,255,0,255,0,0,1,255,255,1,0,0,0,0,1,1,255,255,1,1,255,0,255,0,0,1,0,1,255,255,1,1,0,1,0,1,0,0,255,1,0,0,255,0,0,255,255,1,0,255,0,1,255,255,0,255,1,255,255,1,1,0,255,255,1,0,1,1,255,0,1,255,0,1,0,0,0,255,255,255,255,255,0,255,255,1,1,1,1,1,1,255,1,0,0,1,1,1,1,1,1,1,255,0,1,1,1,1,255,255,0,255,1,255,0,0,255,1,255,255,0,255,1,255,255,0,0,255,1,0,255,255,0,1,1,0,1,1,1,255,0,255,1,255,0,0,0,0,255,1,1,0,0,0,1,0,1,255,0,255,1,255,255,0,1,0,1,1,255,0,1,0,255,0,255,1,1,0,0,0,1,1,1,255,1,0,255,1,0,255,255,1,255,0,0,255,0,0,1,255,0,255,0,255,1,1,1,0,0,1,255,0,0,1,1,0,255,255,1,255,0,0,0,255,1,1,1,0,0,0,255,0,0,0,255,0,1,1,255,1,1,255,0,0,255,255,1,0,1,0,0,255,255,1,0,1,1,255,1,1,1,0,255,1,0,0,255,0,1,255,0,255,0,0,255,255,0,1,0,255,1,255,0,0,0,0,255,255,1,1,1,1,0,0,255,0,255,255,1,0,0,1,255,255,1,255,255,0,1,0,0,255,0,255,0,0,255,255,1,0,1,0,255,255,0,0,1,255,1,255,255,1,255,1,255,255,0,1,1,255,255,1,0,255,0,0,1,1,255,0,1,0,255,255,1,0,0,1,255,255,0,1,255,0,0,1,255,255,0,0,1,1,255,255,255,0,255,255,1,0,0,255,1,0,1,1,0,1,255,1,0,255,1,255,255,255,1,1,0,255,1,0,0,255,1,0,0,0,1,1,255,255,255,255,0,0,1,255,255,1,255,1,1,1,1,0,0,0,0,1,0,1,1,0,255,1,1,255,255,0,1,255,0,1,255,1,255,0,0,255,1,0,255,1,255,255,255,255,0,0,255,255,255,0,255,0,1,255,1,1,255,0,255,255,255,1,255,0,1,1,0,0,0,1,255,1,1,0,255,0,255,0,1,1,1,255,1,1,255,0,255,255,1,0,255,1,0,1,0,255,0,0,255,255,0,255,255,1,0,255,0,1,1,0,255,1,255,0,255,255,0,255,0,0,1,255,255,255,0,0,0,255,0,255,0,0,1,1,1,1,0,255,255,0,0,1,0,0,1,1,255,1,1,1,255,0,1,255,0,0,0,0,0,255,0,1,1,1,1,0,0,1,1,0,1,0,1,255,255,1,0,255,255,1,0,0,0,0,255,1,255,1,1,255,0,0,255,255,1,0,1,255,255,1,255,255,255,0,0,255,0,255,1,0,0,1,0,0,0,255,0,1,255,255,0,0,255,0,0,1,255,0,0,1,255,0,1,255,255,255,255,255,255,0,255,255,1,1,1,0,0,255,0,1,255,1,1,0,1,0,255,1,0,1,0,0,0,0,0,1,255,1,0,0,0,1,0,0,255,0,1,255,255,0},
  {255,255,1,255,1,1,255,0,1,0,255,0,0,1,1,0,0,0,0,0,1,0,0,255,0,0,255,0,255,1,255,1,0,0,1,1,0,255,255,0,255,1,0,1,255,1,1,0,255,1,0,1,0,1,1,0,1,255,255,0,1,255,0,1,1,1,0,1,0,1,255,1,1,0,0,0,1,255,0,1,1,0,255,1,0,1,0,255,0,0,255,255,255,1,255,255,1,255,0,1,1,1,1,1,255,0,255,1,1,0,255,1,255,255,0,1,1,0,255,255,255,255,1,0,1,255,0,0,0,1,255,255,1,0,255,1,0,1,0,255,255,0,255,1,255,255,1,0,255,1,255,1,1,0,0,0,0,255,0,1,0,255,1,0,255,0,255,0,0,0,1,1,255,0,1,255,1,0,0,1,1,0,0,0,0,255,255,1,0,0,255,0,255,0,255,0,0,255,255,255,0,255,1,0,1,255,0,0,255,1,0,255,255,255,0,1,0,0,0,1,255,1,1,255,0,255,255,255,0,0,255,1,1,1,255,255,1,255,255,255,0,1,0,1,1,0,1,1,255,255,255,1,0,255,1,1,1,0,0,255,0,0,0,255,1,255,255,1,0,255,1,255,0,255,1,0,255,1,255,255,255,1,255,1,1,0,1,1,0,255,255,1,255,255,255,1,255,255,0,255,1,0,0,0,0,0,1,255,1,255,1,255,0,255,0,0,0,255,1,255,1,1,255,255,1,0,0,255,255,1,1,1,0,255,1,1,1,1,255,255,0,1,255,0,1,0,1,1,0,255,0,0,255,1,1,255,1,255,1,1,255,255,255,1,255,1,255,1,0,0,255,1,0,0,255,0,255,255,255,255,0,1,1,255,1,1,255,0,0,0,0,1,1,1,0,255,1,255,1,1,1,0,255,255,1,255,1,255,255,1,1,255,1,255,1,0,1,1,1,255,255,0,0,1,255,1,0,0,255,1,1,255,1,1,255,255,255,1,255,1,255,0,1,255,0,255,255,255,1,255,1,0,255,1,255,1,1,0,1,1,1,1,255,0,1,1,1,1,255,0,255,255,0,255,255,0,1,255,1,0,0,255,255,255,255,255,0,0,1,255,1,255,1,255,255,0,1,1,1,255,0,255,255,1,255,255,0,1,255,0,255,255,0,255,1,255,255,1,0,255,255,255,0,255,1,0,1,1,1,1,255,0,255,255,0,0,0,255,1,0,1,255,0,1,255,1,0,1,1,255,255,1,1,1,0,255,1,1,1,255,0,1,0,255,1,0,1,255,255,0,0,1,255,1,0,0,0,1,255,1,1,1,0,0,0,1,255,255,255,1,1,0,1,255,1,255,1,255,0,0,255,255,0,255,255,255,255,1,0,0,1,1,0,0,0,1,1,0,1,1,0,0,1,1,255,1,255,255,1,0,0,0,1,0,255,1,0,255,1,0,1,1,255,1,255,255,255,0,255,0,0,1,0,0,255,255,255,255,0,0,1,0,255,1,255,1,0,255,0,0,255,0,0,0,255,0,255,1,1,1,1,255,1,255,0,0,0,1,0,0,255,255,1,0,255,0,0,0,1,255,1,255,0,1,1,255,1,0,1,1,255,1,1,0,255,255,1,1,1,1,255,0,0,255,0,1,0,1,255,0,1,1,255,1,1,0,0,0,1,0,1,255,0,1,255,255,0,1,1,1,0,0,255,255,1,0,0,1,255,1,1,0},
  {0,1,255,255,0,255,255,0,255,1,1,1,1,0,255,0,1,0,255,1,0,1,0,1,0,1,255,255,0,255,255,1,0,1,0,1,255,255,0,0,0,1,1,1,255,1,255,0,255,1,0,1,255,0,1,255,255,0,255,0,255,1,0,0,1,1,255,1,1,1,1,0,0,255,255,255,0,1,1,0,1,255,255,0,0,0,255,1,1,255,255,0,1,1,0,1,255,0,0,1,255,1,255,0,0,255,0,1,255,0,0,0,255,1,255,1,0,1,0,0,255,0,0,1,255,255,1,1,1,255,0,0,255,255,255,0,0,1,0,255,0,0,255,0,255,0,0,255,255,1,255,255,1,255,255,0,0,1,1,0,1,1,0,1,0,255,0,255,0,255,255,255,0,0,255,0,0,0,0,0,0,0,255,0,255,1,0,0,0,255,1,1,0,0,0,255,0,0,1,255,255,0,1,255,1,1,1,0,0,255,1,255,1,1,1,255,255,1,255,1,0,0,1,255,1,255,0,0,1,0,255,0,255,255,0,0,0,255,1,0,255,1,1,255,255,0,255,0,1,0,0,1,0,255,0,0,1,0,1,1,0,255,1,255,1,1,0,255,1,0,255,255,0,1,0,255,255,0,1,0,0,1,255,0,0,0,255,1,255,255,255,1,0,255,255,1,0,1,255,1,255,255,1,0,1,1,1,1,255,1,0,255,0,255,0,1,1,1,1,0,255,1,0,1,1,255,0,0,0,1,255,255,0,0,255,1,1,0,0,1,0,255,1,1,255,255,0,0,255,0,1,0,1,1,0,1,1,1,255,0,1,1,1,1,1,255,255,1,255,1,255,0,1,1,1,255,0,0,1,0,255,0,255,1,0,1,255,0,0,255,0,0,255,0,255,1,1,1,0,0,255,0,1,255,1,0,0,255,255,1,0,0,0,255,255,255,255,255,255,1,255,255,1,1,0,0,1,0,0,255,255,255,0,1,0,1,0,0,1,0,0,1,255,1,0,0,1,0,1,0,1,1,255,255,255,0,0,255,1,1,0,255,0,1,255,0,255,1,1,0,255,1,0,255,255,255,0,255,255,0,0,255,0,255,255,255,0,0,0,255,1,0,1,0,0,255,0,255,1,0,1,1,255,0,255,255,1,0,255,0,1,255,0,1,1,1,1,0,1,255,0,0,255,0,1,1,255,255,255,255,1,0,1,1,0,255,1,1,0,255,1,1,255,0,1,255,0,0,255,255,255,0,255,255,1,1,0,0,255,255,255,0,255,0,255,255,0,1,255,0,1,255,255,255,255,255,1,1,255,255,255,0,255,1,1,255,0,255,0,0,0,0,0,255,1,1,1,255,255,255,1,1,0,1,1,1,255,255,0,255,1,255,255,255,255,255,1,1,1,255,0,1,0,1,255,255,1,1,255,255,1,0,0,255,255,255,0,255,0,0,0,0,255,0,1,1,255,255,255,0,255,1,255,1,1,0,0,0,0,255,255,1,1,255,1,0,0,0,1,1,0,255,0,255,1,255,1,255,255,255,0,1,1,255,0,0,255,255,255,255,1,1,255,1,0,255,0,0,1,255,1,1,1,255,255,1,1,255,1,255,255,255,0,255,0,0,255,255,0,255,255,0,1,255,1,255,1,255,0,0,0,255,0,255,0,0,0,0,255,255,0,255,255,0,1,1,255,0,1,255,0,1,1,1,0,1,1,255,1,0,255,0},
  {255,1,255,255,1,255,1,255,0,0,255,255,0,255,0,0,1,0,255,255,1,1,255,0,0,1,0,255,1,1,0,1,0,1,0,0,255,255,255,0,0,255,0,1,0,1,255,255,1,0,255,0,1,1,0,1,0,0,255,255,255,0,1,1,0,255,255,0,0,0,1,255,255,255,255,255,0,0,0,1,0,1,0,1,1,0,1,255,0,255,255,255,0,255,0,1,255,0,1,0,0,0,255,0,1,255,0,1,0,0,255,1,0,255,1,255,0,255,255,255,0,1,0,255,1,1,255,1,0,0,1,0,1,255,1,1,0,1,0,255,0,0,0,255,0,255,0,255,1,1,0,255,255,0,1,255,1,1,1,1,255,0,255,255,255,1,0,0,0,1,0,255,0,255,0,1,255,255,255,255,1,0,255,255,255,0,0,1,0,0,255,0,0,0,1,1,0,0,255,0,255,0,1,1,255,1,0,255,255,1,255,1,255,1,1,0,255,255,255,255,0,0,0,0,1,1,255,0,255,1,1,1,1,255,1,0,1,255,0,1,1,0,1,0,0,1,255,255,255,1,255,0,1,255,255,0,0,0,1,0,1,255,1,1,255,255,1,1,1,0,0,0,255,255,1,1,255,1,1,255,255,255,0,1,255,1,0,1,255,255,1,1,0,255,1,0,255,0,0,1,0,0,1,255,255,1,0,255,1,0,1,255,255,1,1,0,1,0,255,0,1,255,1,1,255,0,1,0,0,0,255,1,255,1,1,255,1,0,255,0,0,255,1,255,1,1,0,255,1,1,0,0,255,255,0,255,1,0,1,0,0,1,1,0,1,255,255,1,255,1,255,255,1,1,1,255,0,0,1,0,255,255,1,255,255,0,0,1,0,255,0,1,0,1,255,255,1,0,1,1,1,255,1,255,0,1,1,0,1,1,1,255,0,1,0,255,255,0,0,0,255,0,0,1,255,0,1,1,255,0,1,1,255,1,1,1,1,0,0,0,1,255,255,1,1,0,0,0,1,1,1,1,0,255,0,255,0,255,1,0,0,1,1,1,1,1,0,0,0,0,0,1,1,0,0,1,0,0,255,255,0,0,0,255,1,1,1,255,0,0,0,0,0,0,1,1,1,0,255,0,1,1,255,0,1,0,255,1,1,0,1,255,255,0,1,1,1,0,1,255,0,1,0,0,1,255,0,255,0,0,255,1,0,0,255,0,1,1,1,0,1,1,255,1,0,255,0,0,1,1,255,0,255,0,255,1,0,0,0,1,255,0,0,255,1,1,0,1,255,1,0,1,0,255,255,0,1,0,0,0,1,255,1,0,0,0,0,0,255,0,255,1,1,1,1,0,0,0,0,1,1,1,255,1,1,0,1,255,0,0,1,0,1,255,0,255,255,255,255,1,1,1,0,1,255,255,1,0,0,255,1,255,255,1,255,255,255,0,0,255,0,255,1,1,255,0,255,0,1,0,1,1,1,0,255,1,1,1,255,0,1,0,255,255,255,255,255,1,255,1,255,255,1,255,1,1,1,255,1,1,1,1,1,255,0,0,255,255,255,0,255,1,255,0,255,0,1,255,255,1,255,1,1,255,0,255,255,0,1,255,255,0,1,0,0,255,1,0,255,1,255,255,0,0,255,0,0,0,0,0,255,0,255,255,0,1,255,1,0,1,0,1,0,0,0,1,0,0,255,0,0,1,255,0,1,1,1,255,1,1,1,0},
  {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255},
} ;

static const unsigned char precomputed_core_inv3sntrup761_n[precomputed_core_inv3sntrup761_NUM][crypto_core_INPUTBYTES] = {
  {69,111,175,212,151,132,75,240,232,177,227,243,82,253,183,137,116,7,171,177,23,243,228,58,243,24,89,182,157,43,202,39,172,218,36,8,192,105,61,214,35,46,196,136,255,156,20,39,177,203,35,115,119,22,40,151,91,6,254,68,23,250,55,163,121,233,91,21,111,112,55,202,148,254,122,200,24,85,73,166,98,70,122,157,15,254,93,241,110,84,46,10,251,98,74,104,231,32,125,49,119,159,53,130,176,80,145,134,228,242,236,105,44,211,60,164,119,128,120,43,50,2,250,100,161,84,84,105,7,82,194,139,65,58,250,232,4,228,118,67,19,88,233,62,227,238,198,230,235,73,147,196,224,136,136,228,228,125,107,130,252,13,135,197,114,126,29,84,234,9,136,51,149,68,145,63,85,144,10,135,128,30,120,181,65,220,158,100,129,72,254,132,208,126,26,24,23,12,18,223,22,226,134,172,221,76,120,2,80,131,123,73,198,12,214,136,21,241,204,209,125,171,155,198,162,196,87,207,99,31,250,251,74,61,135,34,54,102,100,153,182,196,250,96,58,171,245,41,93,66,224,235,96,3,177,62,253,93,77,14,18,210,242,244,43,80,165,79,156,159,44,185,114,248,79,8,103,151,174,18,204,168,164,160,0,144,174,42,111,107,29,97,182,70,135,14,205,98,13,90,169,178,186,181,98,159,253,48,121,136,61,209,156,235,76,21,142,154,45,147,58,64,142,27,125,73,80,50,119,159,10,40,7,229,246,208,21,253,183,192,126,179,3,136,54,14,89,228,68,5,214,164,10,95,179,217,31,126,198,70,4,118,144,105,250,152,35,7,43,224,130,139,64,166,144,248,122,158,88,112,149,88,238,38,154,131,107,75,80,218,116,70,117,106,194,239,50,206,180,101,55,29,200,223,151,240,138,89,37,0,134,121,164,95,0,20,69,245,11,150,134,80,70,78,224,27,249,59,109,61,248,100,73,207,80,176,233,109,3,52,29,169,27,177,106,59,118,19,9,119,19,171,238,28,201,234,127,79,245,11,90,159,124,135,216,135,203,24,33,112,64,224,83,121,200,120,93,197,38,166,12,183,175,165,150,25,181,159,120,211,42,131,138,200,102,181,48,217,113,140,46,76,156,159,62,241,133,105,25,216,141,23,239,92,156,198,208,148,227,173,140,90,60,143,203,26,171,186,141,3,149,252,56,237,224,55,195,188,171,90,137,67,130,138,68,210,103,56,105,29,154,84,160,253,53,28,8,17,56,66,31,45,20,52,124,104,45,124,92,163,46,31,6,141,129,125,23,212,0,65,178,248,83,133,30,6,182,249,126,170,17,113,181,204,237,113,59,30,186,30,51,242,61,37,178,123,57,153,65,154,119,197,254,142,124,71,76,118,117,94,10,192,174,141,122,231,164,42,196,62,143,162,128,47,48,121,69,181,67,170,13,70,222,126,204,108,47,144,121,151,66,226,214,57,104,171,96,25,2,13,46,196,236,8,254,250,255,25,227,190,179,195,51,170,27,16,143,176,83,144,214,164,134,134,8,212,134,102,93,27,141,232,133,182,233,122,126,24,80,154,27,206,184,85,236,147,11,240,232,243,187,196,141,130,140,149,152,6,227,167,43,214,80,227,175,194,153,143,146,120,57,226,220,141,38,16,69,243,142,73,207,246,5,194,64,207,71,93,192,166,75,180,238,90,196,159,28,45,80,82,76},
  {66,68,204,209,192,244,6,227,48,167,174,97,62,107,253,96,207,128,210,163,82,123,31,0,215,37,109,49,4,207,23,198,123,200,47,184,7,146,186,148,8,70,232,194,130,190,254,125,205,87,250,139,180,120,186,158,65,184,241,1,166,124,206,225,95,177,120,177,61,252,209,38,127,222,4,34,160,78,212,206,165,35,12,17,44,170,22,32,111,34,28,76,110,241,237,156,158,202,28,105,49,128,250,129,232,90,195,197,66,251,182,155,168,144,251,146,95,149,118,106,157,250,151,14,250,36,223,77,28,246,201,7,33,241,193,191,225,228,129,192,28,177,169,52,156,111,196,189,116,12,67,204,36,71,141,198,50,227,88,175,30,242,195,21,99,207,9,29,46,25,225,153,189,107,142,94,153,168,146,81,131,76,0,114,209,110,249,205,145,191,102,195,142,84,11,180,186,19,253,88,17,59,73,113,176,145,126,124,86,175,115,16,137,251,211,218,122,147,173,234,215,46,115,47,175,238,246,27,210,237,5,38,70,77,83,20,255,104,146,88,74,233,32,10,195,247,137,44,240,166,53,103,1,113,222,140,72,8,234,101,72,35,133,195,5,255,118,231,194,209,53,25,3,120,166,241,238,185,238,19,161,56,67,87,47,22,37,181,80,69,246,254,7,57,127,172,253,48,5,115,54,111,15,71,54,97,192,173,199,30,65,245,99,105,116,126,168,65,220,211,121,89,243,14,69,20,118,202,246,128,205,15,43,223,241,80,113,217,131,235,15,122,204,143,139,239,224,151,64,17,243,47,213,254,169,102,0,91,192,18,98,203,250,191,179,90,82,87,13,21,38,76,247,22,117,150,189,99,100,66,74,12,49,189,220,21,182,45,52,136,235,12,68,182,81,108,175,231,252,20,223,188,71,41,132,193,101,171,79,212,42,1,223,39,122,93,165,195,16,196,251,227,42,37,73,50,9,24,120,244,105,174,190,199,115,148,6,60,2,147,82,159,35,223,176,25,223,60,1,247,131,204,92,125,25,55,193,160,40,52,27,102,82,200,218,134,249,253,89,77,187,108,58,253,129,119,161,212,172,190,77,165,151,152,3,198,242,41,44,22,242,84,68,226,225,66,84,50,99,185,178,16,225,192,133,150,4,235,4,26,174,81,25,58,71,234,220,155,230,109,147,160,230,165,236,120,157,233,26,6,247,209,253,77,177,72,217,212,243,17,255,248,92,25,46,139,216,176,22,15,44,221,41,134,45,198,223,30,250,108,96,88,245,143,9,149,31,196,241,137,124,128,56,209,55,132,233,13,217,232,10,115,34,203,135,110,192,156,170,10,63,134,80,157,97,237,138,24,255,170,235,244,78,28,14,162,188,59,140,49,88,40,159,251,78,230,58,209,110,170,73,130,220,94,17,44,210,193,176,16,90,173,111,105,205,210,76,13,88,69,52,89,216,71,247,156,141,248,4,49,239,69,58,184,238,250,103,25,54,156,182,114,100,87,143,11,179,254,186,173,30,205,191,228,228,86,205,74,173,1,126,3,171,36,95,217,20,6,216,208,185,126,13,102,175,41,118,221,171,232,209,212,200,220,84,3,67,20,223,205,74,96,8,227,146,97,131,40,171,122,185,0,102,127,232,8,87,30,60,54,216,114,183,44,190,52,197,146,24,227,244,137,207,232,170,235,132,31,233,23,54,3,218,145,118,56,197,197,90,57,183},
  {199,5,141,172,3,106,136,18,138,72,186,6,146,122,33,235,130,132,16,172,247,74,255,124,139,62,220,48,64,49,62,187,190,45,6,211,67,164,168,153,200,0,117,189,100,23,224,175,49,104,232,213,113,143,30,185,223,13,134,254,129,31,145,103,104,214,175,139,102,85,216,70,226,53,246,255,90,195,40,151,150,8,107,211,247,25,162,254,225,224,160,111,222,125,99,143,117,215,11,228,217,128,181,220,48,157,75,245,245,5,234,170,77,167,220,225,229,86,103,183,50,68,250,220,0,42,57,204,103,23,32,176,201,101,133,202,250,6,211,200,251,61,145,213,108,139,196,248,36,7,242,88,113,135,127,112,23,115,78,249,176,41,35,58,227,239,53,113,39,198,228,11,208,168,121,151,228,138,209,222,134,44,120,134,96,16,222,161,120,169,172,139,188,188,99,247,48,0,235,104,181,13,79,46,2,217,164,196,46,79,41,160,112,71,186,252,255,135,213,9,74,178,85,155,86,8,124,63,157,162,88,240,162,140,123,225,59,6,39,206,5,123,60,194,31,211,196,138,199,124,115,176,236,205,206,135,24,192,14,12,172,154,11,88,144,112,58,202,233,233,55,148,68,239,97,90,247,31,116,170,235,148,65,212,19,208,131,39,172,78,221,250,141,130,174,38,250,55,211,46,59,47,191,136,105,82,207,15,224,60,136,188,40,162,229,126,28,76,153,101,49,16,152,222,219,145,118,88,180,47,167,156,100,159,100,216,109,226,231,167,62,40,57,85,94,198,154,210,221,130,197,183,95,175,30,143,136,120,197,239,101,15,134,94,22,67,70,241,132,1,157,224,154,201,157,90,69,3,210,43,30,60,126,161,103,58,55,13,3,229,174,160,223,7,138,236,181,130,255,34,252,98,161,242,114,41,30,65,98,58,92,226,20,242,119,110,182,85,255,149,212,26,208,72,48,172,215,183,159,52,16,238,185,55,237,32,53,158,83,170,163,105,178,31,68,177,27,146,93,37,184,54,58,64,45,150,19,113,75,208,69,51,211,94,200,20,42,253,168,215,56,91,97,249,44,148,234,235,119,247,232,176,187,50,72,159,205,121,122,135,47,103,139,208,87,157,114,249,111,3,5,238,20,195,203,227,14,17,114,179,87,78,187,67,152,139,193,116,167,145,189,108,242,158,165,35,240,244,66,50,169,125,96,48,255,181,44,3,75,73,119,230,39,194,161,159,6,237,73,18,222,184,190,123,152,49,153,184,238,76,123,182,59,129,194,207,15,69,195,59,151,14,13,178,80,75,43,131,250,201,110,189,42,173,241,138,29,84,48,147,61,37,197,126,50,133,57,100,203,18,229,243,189,167,62,35,190,145,169,228,59,186,120,242,42,192,86,107,145,108,111,140,198,121,255,181,230,225,231,238,234,121,129,229,170,33,168,114,53,126,189,185,122,224,162,92,102,139,212,109,46,205,111,55,151,98,22,13,133,72,183,119,144,221,148,2,88,138,16,35,136,171,195,186,202,42,255,210,51,200,81,158,55,33,144,68,59,174,64,151,96,0,97,207,122,191,40,105,173,247,254,181,6,247,231,16,174,132,124,215,119,156,224,54,28,134,199,194,181,130,242,80,217,12,251,179,85,206,47,17,130,187,150,26,120,80,40,75,83,17,34,190,45,112,6,82,148,61,165,208,15,28,172,87,231,206,215,198,97,103,238},
  {138,131,94,87,16,239,242,31,191,74,138,37,22,208,105,208,31,170,59,94,223,143,166,12,106,120,113,56,42,88,104,87,50,127,190,149,206,178,191,27,143,0,40,248,54,93,100,188,216,18,142,196,250,36,60,31,162,23,254,67,180,191,41,145,229,9,204,19,242,39,199,106,215,96,212,110,135,117,36,232,143,232,90,72,219,117,86,189,15,147,22,238,199,122,114,8,34,8,191,245,12,39,71,225,170,125,188,18,121,236,135,132,174,91,217,17,138,4,206,132,168,122,99,176,255,93,34,222,205,103,20,214,183,145,6,42,27,248,107,3,53,9,107,118,89,77,98,223,212,248,42,157,215,21,215,196,28,141,99,91,255,143,242,79,91,240,23,210,37,169,199,135,185,66,56,213,116,7,10,87,165,129,183,161,128,182,132,107,247,107,195,30,8,254,56,119,94,147,182,46,238,220,208,76,41,108,201,36,235,203,74,77,174,3,125,83,166,133,109,222,225,238,15,11,118,150,112,217,40,92,136,58,174,221,51,44,101,220,44,94,193,107,161,89,19,231,179,189,53,119,30,224,144,234,177,23,102,203,101,159,76,239,178,54,5,114,89,126,147,202,218,152,63,221,17,167,215,247,152,221,152,166,115,20,104,173,235,154,36,142,121,172,1,227,61,33,74,37,95,207,80,85,186,8,78,238,247,137,14,139,242,68,243,57,147,155,173,46,48,52,254,230,241,190,22,236,146,44,214,98,5,1,196,128,181,120,133,117,79,33,113,171,154,91,50,239,244,251,4,140,131,143,145,104,243,188,75,44,164,146,144,172,134,58,122,0,203,138,166,225,97,99,81,156,25,143,217,25,221,75,195,195,56,87,226,98,229,150,21,190,91,211,114,66,60,144,108,57,127,104,25,4,170,164,233,237,22,242,112,30,57,108,167,143,131,156,177,28,228,13,226,110,79,63,148,194,26,208,0,180,212,58,174,81,57,179,69,254,96,93,108,13,229,171,167,235,145,254,44,107,125,125,240,148,68,51,127,42,201,15,8,132,178,97,100,80,72,151,145,61,66,119,232,53,176,242,21,99,164,16,109,172,99,149,82,200,12,207,196,71,62,213,42,105,255,35,27,79,222,211,77,226,222,242,130,115,139,191,101,117,236,227,13,223,37,200,124,166,33,189,81,65,167,52,171,127,249,230,45,54,25,63,187,20,73,40,32,110,114,60,189,147,133,139,97,23,212,247,2,46,90,22,217,206,213,117,61,46,251,243,224,24,71,121,177,243,239,98,161,233,90,242,36,115,143,97,105,133,117,220,71,190,46,159,250,236,74,84,227,59,130,125,145,56,140,113,250,147,0,159,155,164,91,18,113,243,91,243,86,202,217,99,247,221,136,121,213,231,109,58,183,87,242,193,63,74,124,164,30,119,29,214,255,42,115,232,130,189,80,136,77,108,181,52,207,244,13,57,70,27,161,21,119,171,94,22,53,235,119,166,124,202,16,151,241,16,66,244,224,161,14,111,82,162,8,247,150,190,54,98,43,142,13,107,188,3,201,203,212,117,150,80,15,158,214,174,48,94,105,238,137,194,11,85,30,173,204,216,11,10,173,121,171,49,5,166,35,1,22,238,1,238,143,171,251,202,207,115,82,63,120,72,8,68,222,241,67,113,28,42,84,246,73,142,140,158,132,41,170,42,114,180,48,252,38,1,81,95,67,193,98},
  {255,255,0,255,255,255,1,255,1,255,0,255,1,1,1,1,255,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
} ;

static const unsigned char precomputed_core_inv3sntrup761_k[precomputed_core_inv3sntrup761_NUM][crypto_core_KEYBYTES] = {
  {},
  {},
  {},
  {},
  {},
} ;

static const unsigned char precomputed_core_inv3sntrup761_c[precomputed_core_inv3sntrup761_NUM][crypto_core_CONSTBYTES] = {
  {},
  {},
  {},
  {},
  {},
} ;

static void test_core_inv3sntrup761_impl(long long impl)
{
  unsigned char *h = test_core_inv3sntrup761_h;
  unsigned char *n = test_core_inv3sntrup761_n;
  unsigned char *k = test_core_inv3sntrup761_k;
  unsigned char *c = test_core_inv3sntrup761_c;
  unsigned char *h2 = test_core_inv3sntrup761_h2;
  unsigned char *n2 = test_core_inv3sntrup761_n2;
  unsigned char *k2 = test_core_inv3sntrup761_k2;
  unsigned char *c2 = test_core_inv3sntrup761_c2;
  long long hlen = crypto_core_OUTPUTBYTES;
  long long nlen = crypto_core_INPUTBYTES;
  long long klen = crypto_core_KEYBYTES;
  long long clen = crypto_core_CONSTBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_core_inv3sntrup761_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_core = ntruprime_dispatch_core_inv3sntrup761(impl);
    printf("core_inv3sntrup761 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_inv3sntrup761_implementation(impl),ntruprime_dispatch_core_inv3sntrup761_compiler(impl));
  } else {
    crypto_core = ntruprime_core_inv3sntrup761;
    printf("core_inv3sntrup761 selected implementation %s compiler %s\n",ntruprime_core_inv3sntrup761_implementation(),ntruprime_core_inv3sntrup761_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 512;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(h2,h,hlen);
      input_prepare(n2,n,nlen);
      input_prepare(k2,k,klen);
      input_prepare(c2,c,clen);
      secret(n,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(h,n,k,c);
      public(n,nlen);
      public(k,klen);
      public(c,clen);
      public(h,hlen);
      checksum(h,hlen);
      output_compare(h2,h,hlen,"crypto_core");
      input_compare(n2,n,nlen,"crypto_core");
      input_compare(k2,k,klen,"crypto_core");
      input_compare(c2,c,clen,"crypto_core");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k2,klen);
      secret(c2,clen);
      crypto_core(h2,n2,k2,c2);
      public(n2,nlen);
      public(k2,klen);
      public(c2,clen);
      public(h2,hlen);
      if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_core is nondeterministic\n");
    }
    checksum_expected(core_inv3sntrup761_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_core_inv3sntrup761_NUM;++precomp) {
    output_prepare(h2,h,crypto_core_OUTPUTBYTES);
    input_prepare(n2,n,crypto_core_INPUTBYTES);
    memcpy(n,precomputed_core_inv3sntrup761_n[precomp],crypto_core_INPUTBYTES);
    memcpy(n2,precomputed_core_inv3sntrup761_n[precomp],crypto_core_INPUTBYTES);
    input_prepare(k2,k,crypto_core_KEYBYTES);
    memcpy(k,precomputed_core_inv3sntrup761_k[precomp],crypto_core_KEYBYTES);
    memcpy(k2,precomputed_core_inv3sntrup761_k[precomp],crypto_core_KEYBYTES);
    input_prepare(c2,c,crypto_core_CONSTBYTES);
    memcpy(c,precomputed_core_inv3sntrup761_c[precomp],crypto_core_CONSTBYTES);
    memcpy(c2,precomputed_core_inv3sntrup761_c[precomp],crypto_core_CONSTBYTES);
    crypto_core(h,n,k,c);
    if (memcmp(h,precomputed_core_inv3sntrup761_h[precomp],crypto_core_OUTPUTBYTES)) {
      fail("failure: crypto_core fails precomputed test vectors\n");
      printf("expected h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",((unsigned char *) precomputed_core_inv3sntrup761_h[precomp])[pos]);
      printf("\n");
      printf("received h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",h[pos]);
      printf("\n");
    }
    output_compare(h2,h,crypto_core_OUTPUTBYTES,"crypto_core");
    input_compare(n2,n,crypto_core_INPUTBYTES,"crypto_core");
    input_compare(k2,k,crypto_core_KEYBYTES,"crypto_core");
    input_compare(c2,c,crypto_core_CONSTBYTES,"crypto_core");
  }
}

void test_core_inv3sntrup761(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"inv3sntrup761")) return;
  storage_core_inv3sntrup761_h = callocplus(crypto_core_OUTPUTBYTES);
  test_core_inv3sntrup761_h = aligned(storage_core_inv3sntrup761_h,crypto_core_OUTPUTBYTES);
  if (crypto_core_OUTPUTBYTES > maxalloc) maxalloc = crypto_core_OUTPUTBYTES;
  storage_core_inv3sntrup761_n = callocplus(crypto_core_INPUTBYTES);
  test_core_inv3sntrup761_n = aligned(storage_core_inv3sntrup761_n,crypto_core_INPUTBYTES);
  if (crypto_core_INPUTBYTES > maxalloc) maxalloc = crypto_core_INPUTBYTES;
  storage_core_inv3sntrup761_k = callocplus(crypto_core_KEYBYTES);
  test_core_inv3sntrup761_k = aligned(storage_core_inv3sntrup761_k,crypto_core_KEYBYTES);
  if (crypto_core_KEYBYTES > maxalloc) maxalloc = crypto_core_KEYBYTES;
  storage_core_inv3sntrup761_c = callocplus(crypto_core_CONSTBYTES);
  test_core_inv3sntrup761_c = aligned(storage_core_inv3sntrup761_c,crypto_core_CONSTBYTES);
  if (crypto_core_CONSTBYTES > maxalloc) maxalloc = crypto_core_CONSTBYTES;
  storage_core_inv3sntrup761_h2 = callocplus(maxalloc);
  test_core_inv3sntrup761_h2 = aligned(storage_core_inv3sntrup761_h2,crypto_core_OUTPUTBYTES);
  storage_core_inv3sntrup761_n2 = callocplus(maxalloc);
  test_core_inv3sntrup761_n2 = aligned(storage_core_inv3sntrup761_n2,crypto_core_INPUTBYTES);
  storage_core_inv3sntrup761_k2 = callocplus(maxalloc);
  test_core_inv3sntrup761_k2 = aligned(storage_core_inv3sntrup761_k2,crypto_core_KEYBYTES);
  storage_core_inv3sntrup761_c2 = callocplus(maxalloc);
  test_core_inv3sntrup761_c2 = aligned(storage_core_inv3sntrup761_c2,crypto_core_CONSTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("core_inv3sntrup761 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_core_inv3sntrup761();++impl)
      forked(test_core_inv3sntrup761_impl,impl);
    ++test_core_inv3sntrup761_h;
    ++test_core_inv3sntrup761_n;
    ++test_core_inv3sntrup761_k;
    ++test_core_inv3sntrup761_c;
    ++test_core_inv3sntrup761_h2;
    ++test_core_inv3sntrup761_n2;
    ++test_core_inv3sntrup761_k2;
    ++test_core_inv3sntrup761_c2;
  }
  free(storage_core_inv3sntrup761_c2);
  free(storage_core_inv3sntrup761_k2);
  free(storage_core_inv3sntrup761_n2);
  free(storage_core_inv3sntrup761_h2);
  free(storage_core_inv3sntrup761_c);
  free(storage_core_inv3sntrup761_k);
  free(storage_core_inv3sntrup761_n);
  free(storage_core_inv3sntrup761_h);
}
#undef crypto_core_OUTPUTBYTES
#undef crypto_core_INPUTBYTES
#undef crypto_core_KEYBYTES
#undef crypto_core_CONSTBYTES

