/*
 * Copyright (C) 2004, 2005 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _TRANSLATE_GENERIC_SOUP_COOKIE_JAR_H
#define _TRANSLATE_GENERIC_SOUP_COOKIE_JAR_H

#include <glib-object.h>

#define TRANSLATE_GENERIC_TYPE_SOUP_COOKIE_JAR			(translate_generic_soup_cookie_jar_get_type())
#define TRANSLATE_GENERIC_SOUP_COOKIE_JAR(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), TRANSLATE_GENERIC_TYPE_SOUP_COOKIE_JAR, TranslateGenericSoupCookieJar))
#define TRANSLATE_GENERIC_SOUP_COOKIE_JAR_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), TRANSLATE_GENERIC_TYPE_SOUP_COOKIE_JAR, TranslateGenericSoupCookieJarClass))
#define TRANSLATE_GENERIC_IS_SOUP_COOKIE_JAR(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), TRANSLATE_GENERIC_TYPE_SOUP_COOKIE_JAR))
#define TRANSLATE_GENERIC_IS_SOUP_COOKIE_JAR_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), TRANSLATE_GENERIC_TYPE_SOUP_COOKIE_JAR))
#define TRANSLATE_GENERIC_SOUP_COOKIE_JAR_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), TRANSLATE_GENERIC_TYPE_SOUP_COOKIE_JAR, TranslateGenericSoupCookieJarClass))

typedef struct _TranslateGenericSoupCookieJar TranslateGenericSoupCookieJar;
typedef struct _TranslateGenericSoupCookieJarClass TranslateGenericSoupCookieJarClass;
typedef struct _TranslateGenericSoupCookieJarPrivate TranslateGenericSoupCookieJarPrivate;

struct _TranslateGenericSoupCookieJar
{
  GObject				parent;

  TranslateGenericSoupCookieJarPrivate	*priv;
};

struct _TranslateGenericSoupCookieJarClass
{
  GObjectClass				parent;
};

GType translate_generic_soup_cookie_jar_get_type (void);
TranslateGenericSoupCookieJar *translate_generic_soup_cookie_jar_new (void);

#endif /* _TRANSLATE_GENERIC_SOUP_COOKIE_JAR_H */
