/*! \file ContourLibrary.h
    \brief Definition of the Template class ContourLibrary.
    
    Magics Team - ECMWF 2010
    
    Started: Fri 16-Jul-2010
    
    Changes:
    
*/

#ifndef ContourLibrary_H
#define ContourLibrary_H

#include "magics.h"


namespace magics {

class MetaDataCollector;
class VisDefInfoBase;

class ContourLibrary {

public:
	ContourLibrary();
	virtual ~ContourLibrary();

	// sete the meata dat to be collected 
	void askId(MetaDataCollector&);

	bool checkId(MetaDataCollector&,MetaDataCollector&);

	// se the map to set the contour!
	void getAttributes(MetaDataCollector&, map<string, string>&);
	
protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream&) const; 

private:
    //! Copy constructor - No copy allowed
	ContourLibrary(const ContourLibrary&);
    //! Overloaded << operator to copy - No copy allowed
	ContourLibrary& operator=(const ContourLibrary&);
	
	bool setInfoObject(string);

// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const ContourLibrary& p)
		{ p.print(s); return s; }

	static VisDefInfoBase* info_;

};

} // namespace magics
#endif
