/* -*- buffer-read-only: t -*- vi: set ro: */
/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.36
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

/* Implementation : GUILE */

#define SWIG_GUILE_INIT_STATIC extern
extern "C" {

SWIG_GUILE_INIT_STATIC void
SWIG_init (void);

}

#ifdef __cplusplus
template<typename T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};

template <typename T> T SwigValueInit() {
  return T();
}
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__)) 
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__)) 
# else
#   define SWIGUNUSED 
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif 
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#  ifndef GCC_HASCLASSVISIBILITY
#    define GCC_HASCLASSVISIBILITY
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif


/* -----------------------------------------------------------------------------
 * swigrun.swg
 *
 * This file contains generic CAPI SWIG runtime support for pointer
 * type checking.
 * ----------------------------------------------------------------------------- */

/* This should only be incremented when either the layout of swig_type_info changes,
   or for whatever reason, the runtime changes incompatibly */
#define SWIG_RUNTIME_VERSION "4"

/* define SWIG_TYPE_TABLE_NAME as "SWIG_TYPE_TABLE" */
#ifdef SWIG_TYPE_TABLE
# define SWIG_QUOTE_STRING(x) #x
# define SWIG_EXPAND_AND_QUOTE_STRING(x) SWIG_QUOTE_STRING(x)
# define SWIG_TYPE_TABLE_NAME SWIG_EXPAND_AND_QUOTE_STRING(SWIG_TYPE_TABLE)
#else
# define SWIG_TYPE_TABLE_NAME
#endif

/*
  You can use the SWIGRUNTIME and SWIGRUNTIMEINLINE macros for
  creating a static or dynamic library from the swig runtime code.
  In 99.9% of the cases, swig just needs to declare them as 'static'.
  
  But only do this if is strictly necessary, ie, if you have problems
  with your compiler or so.
*/

#ifndef SWIGRUNTIME
# define SWIGRUNTIME SWIGINTERN
#endif

#ifndef SWIGRUNTIMEINLINE
# define SWIGRUNTIMEINLINE SWIGRUNTIME SWIGINLINE
#endif

/*  Generic buffer size */
#ifndef SWIG_BUFFER_SIZE
# define SWIG_BUFFER_SIZE 1024
#endif

/* Flags for pointer conversions */
#define SWIG_POINTER_DISOWN        0x1
#define SWIG_CAST_NEW_MEMORY       0x2

/* Flags for new pointer objects */
#define SWIG_POINTER_OWN           0x1


/* 
   Flags/methods for returning states.
   
   The swig conversion methods, as ConvertPtr, return and integer 
   that tells if the conversion was successful or not. And if not,
   an error code can be returned (see swigerrors.swg for the codes).
   
   Use the following macros/flags to set or process the returning
   states.
   
   In old swig versions, you usually write code as:

     if (SWIG_ConvertPtr(obj,vptr,ty.flags) != -1) {
       // success code
     } else {
       //fail code
     }

   Now you can be more explicit as:

    int res = SWIG_ConvertPtr(obj,vptr,ty.flags);
    if (SWIG_IsOK(res)) {
      // success code
    } else {
      // fail code
    }

   that seems to be the same, but now you can also do

    Type *ptr;
    int res = SWIG_ConvertPtr(obj,(void **)(&ptr),ty.flags);
    if (SWIG_IsOK(res)) {
      // success code
      if (SWIG_IsNewObj(res) {
        ...
	delete *ptr;
      } else {
        ...
      }
    } else {
      // fail code
    }
    
   I.e., now SWIG_ConvertPtr can return new objects and you can
   identify the case and take care of the deallocation. Of course that
   requires also to SWIG_ConvertPtr to return new result values, as

      int SWIG_ConvertPtr(obj, ptr,...) {         
        if (<obj is ok>) {			       
          if (<need new object>) {		       
            *ptr = <ptr to new allocated object>; 
            return SWIG_NEWOBJ;		       
          } else {				       
            *ptr = <ptr to old object>;	       
            return SWIG_OLDOBJ;		       
          } 				       
        } else {				       
          return SWIG_BADOBJ;		       
        }					       
      }

   Of course, returning the plain '0(success)/-1(fail)' still works, but you can be
   more explicit by returning SWIG_BADOBJ, SWIG_ERROR or any of the
   swig errors code.

   Finally, if the SWIG_CASTRANK_MODE is enabled, the result code
   allows to return the 'cast rank', for example, if you have this

       int food(double)
       int fooi(int);

   and you call
 
      food(1)   // cast rank '1'  (1 -> 1.0)
      fooi(1)   // cast rank '0'

   just use the SWIG_AddCast()/SWIG_CheckState()


 */
#define SWIG_OK                    (0) 
#define SWIG_ERROR                 (-1)
#define SWIG_IsOK(r)               (r >= 0)
#define SWIG_ArgError(r)           ((r != SWIG_ERROR) ? r : SWIG_TypeError)  

/* The CastRankLimit says how many bits are used for the cast rank */
#define SWIG_CASTRANKLIMIT         (1 << 8)
/* The NewMask denotes the object was created (using new/malloc) */
#define SWIG_NEWOBJMASK            (SWIG_CASTRANKLIMIT  << 1)
/* The TmpMask is for in/out typemaps that use temporal objects */
#define SWIG_TMPOBJMASK            (SWIG_NEWOBJMASK << 1)
/* Simple returning values */
#define SWIG_BADOBJ                (SWIG_ERROR)
#define SWIG_OLDOBJ                (SWIG_OK)
#define SWIG_NEWOBJ                (SWIG_OK | SWIG_NEWOBJMASK)
#define SWIG_TMPOBJ                (SWIG_OK | SWIG_TMPOBJMASK)
/* Check, add and del mask methods */
#define SWIG_AddNewMask(r)         (SWIG_IsOK(r) ? (r | SWIG_NEWOBJMASK) : r)
#define SWIG_DelNewMask(r)         (SWIG_IsOK(r) ? (r & ~SWIG_NEWOBJMASK) : r)
#define SWIG_IsNewObj(r)           (SWIG_IsOK(r) && (r & SWIG_NEWOBJMASK))
#define SWIG_AddTmpMask(r)         (SWIG_IsOK(r) ? (r | SWIG_TMPOBJMASK) : r)
#define SWIG_DelTmpMask(r)         (SWIG_IsOK(r) ? (r & ~SWIG_TMPOBJMASK) : r)
#define SWIG_IsTmpObj(r)           (SWIG_IsOK(r) && (r & SWIG_TMPOBJMASK))


/* Cast-Rank Mode */
#if defined(SWIG_CASTRANK_MODE)
#  ifndef SWIG_TypeRank
#    define SWIG_TypeRank             unsigned long
#  endif
#  ifndef SWIG_MAXCASTRANK            /* Default cast allowed */
#    define SWIG_MAXCASTRANK          (2)
#  endif
#  define SWIG_CASTRANKMASK          ((SWIG_CASTRANKLIMIT) -1)
#  define SWIG_CastRank(r)           (r & SWIG_CASTRANKMASK)
SWIGINTERNINLINE int SWIG_AddCast(int r) { 
  return SWIG_IsOK(r) ? ((SWIG_CastRank(r) < SWIG_MAXCASTRANK) ? (r + 1) : SWIG_ERROR) : r;
}
SWIGINTERNINLINE int SWIG_CheckState(int r) { 
  return SWIG_IsOK(r) ? SWIG_CastRank(r) + 1 : 0; 
}
#else /* no cast-rank mode */
#  define SWIG_AddCast
#  define SWIG_CheckState(r) (SWIG_IsOK(r) ? 1 : 0)
#endif




#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *, int *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

/* Structure to store information on one type */
typedef struct swig_type_info {
  const char             *name;			/* mangled name of this type */
  const char             *str;			/* human readable name of this type */
  swig_dycast_func        dcast;		/* dynamic cast function down a hierarchy */
  struct swig_cast_info  *cast;			/* linked list of types that can cast into this type */
  void                   *clientdata;		/* language specific type data */
  int                    owndata;		/* flag if the structure owns the clientdata */
} swig_type_info;

/* Structure to store a type and conversion function used for casting */
typedef struct swig_cast_info {
  swig_type_info         *type;			/* pointer to type that is equivalent to this type */
  swig_converter_func     converter;		/* function to cast the void pointers */
  struct swig_cast_info  *next;			/* pointer to next cast in linked list */
  struct swig_cast_info  *prev;			/* pointer to the previous cast */
} swig_cast_info;

/* Structure used to store module information
 * Each module generates one structure like this, and the runtime collects
 * all of these structures and stores them in a circularly linked list.*/
typedef struct swig_module_info {
  swig_type_info         **types;		/* Array of pointers to swig_type_info structures that are in this module */
  size_t                 size;		        /* Number of types in this module */
  struct swig_module_info *next;		/* Pointer to next element in circularly linked list */
  swig_type_info         **type_initial;	/* Array of initially generated type structures */
  swig_cast_info         **cast_initial;	/* Array of initially generated casting structures */
  void                    *clientdata;		/* Language specific module data */
} swig_module_info;

/* 
  Compare two type names skipping the space characters, therefore
  "char*" == "char *" and "Class<int>" == "Class<int >", etc.

  Return 0 when the two name types are equivalent, as in
  strncmp, but skipping ' '.
*/
SWIGRUNTIME int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return (*f1 > *f2) ? 1 : -1;
  }
  return (int)((l1 - f1) - (l2 - f2));
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if not equal, 1 if equal
*/
SWIGRUNTIME int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = (SWIG_TypeNameComp(nb, ne, tb, te) == 0) ? 1 : 0;
    if (*ne) ++ne;
  }
  return equiv;
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if equal, -1 if nb < tb, 1 if nb > tb
*/
SWIGRUNTIME int
SWIG_TypeCompare(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = (SWIG_TypeNameComp(nb, ne, tb, te) == 0) ? 1 : 0;
    if (*ne) ++ne;
  }
  return equiv;
}


/* think of this as a c++ template<> or a scheme macro */
#define SWIG_TypeCheck_Template(comparison, ty)         \
  if (ty) {                                             \
    swig_cast_info *iter = ty->cast;                    \
    while (iter) {                                      \
      if (comparison) {                                 \
        if (iter == ty->cast) return iter;              \
        /* Move iter to the top of the linked list */   \
        iter->prev->next = iter->next;                  \
        if (iter->next)                                 \
          iter->next->prev = iter->prev;                \
        iter->next = ty->cast;                          \
        iter->prev = 0;                                 \
        if (ty->cast) ty->cast->prev = iter;            \
        ty->cast = iter;                                \
        return iter;                                    \
      }                                                 \
      iter = iter->next;                                \
    }                                                   \
  }                                                     \
  return 0

/*
  Check the typename
*/
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheck(const char *c, swig_type_info *ty) {
  SWIG_TypeCheck_Template(strcmp(iter->type->name, c) == 0, ty);
}

/* Same as previous function, except strcmp is replaced with a pointer comparison */
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheckStruct(swig_type_info *from, swig_type_info *into) {
  SWIG_TypeCheck_Template(iter->type == from, into);
}

/*
  Cast a pointer up an inheritance hierarchy
*/
SWIGRUNTIMEINLINE void *
SWIG_TypeCast(swig_cast_info *ty, void *ptr, int *newmemory) {
  return ((!ty) || (!ty->converter)) ? ptr : (*ty->converter)(ptr, newmemory);
}

/* 
   Dynamic pointer casting. Down an inheritance hierarchy
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/*
  Return the name associated with this type
*/
SWIGRUNTIMEINLINE const char *
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/*
  Return the pretty name associated with this type,
  that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME const char *
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (!type) return NULL;
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Set the clientdata field for a type
*/
SWIGRUNTIME void
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_cast_info *cast = ti->cast;
  /* if (ti->clientdata == clientdata) return; */
  ti->clientdata = clientdata;
  
  while (cast) {
    if (!cast->converter) {
      swig_type_info *tc = cast->type;
      if (!tc->clientdata) {
	SWIG_TypeClientData(tc, clientdata);
      }
    }    
    cast = cast->next;
  }
}
SWIGRUNTIME void
SWIG_TypeNewClientData(swig_type_info *ti, void *clientdata) {
  SWIG_TypeClientData(ti, clientdata);
  ti->owndata = 1;
}
  
/*
  Search for a swig_type_info structure only by mangled name
  Search is a O(log #types)
  
  We start searching at module start, and finish searching when start == end.  
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_MangledTypeQueryModule(swig_module_info *start, 
                            swig_module_info *end, 
		            const char *name) {
  swig_module_info *iter = start;
  do {
    if (iter->size) {
      register size_t l = 0;
      register size_t r = iter->size - 1;
      do {
	/* since l+r >= 0, we can (>> 1) instead (/ 2) */
	register size_t i = (l + r) >> 1; 
	const char *iname = iter->types[i]->name;
	if (iname) {
	  register int compare = strcmp(name, iname);
	  if (compare == 0) {	    
	    return iter->types[i];
	  } else if (compare < 0) {
	    if (i) {
	      r = i - 1;
	    } else {
	      break;
	    }
	  } else if (compare > 0) {
	    l = i + 1;
	  }
	} else {
	  break; /* should never happen */
	}
      } while (l <= r);
    }
    iter = iter->next;
  } while (iter != end);
  return 0;
}

/*
  Search for a swig_type_info structure for either a mangled name or a human readable name.
  It first searches the mangled names of the types, which is a O(log #types)
  If a type is not found it then searches the human readable names, which is O(#types).
  
  We start searching at module start, and finish searching when start == end.  
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeQueryModule(swig_module_info *start, 
                     swig_module_info *end, 
		     const char *name) {
  /* STEP 1: Search the name field using binary search */
  swig_type_info *ret = SWIG_MangledTypeQueryModule(start, end, name);
  if (ret) {
    return ret;
  } else {
    /* STEP 2: If the type hasn't been found, do a complete search
       of the str field (the human readable name) */
    swig_module_info *iter = start;
    do {
      register size_t i = 0;
      for (; i < iter->size; ++i) {
	if (iter->types[i]->str && (SWIG_TypeEquiv(iter->types[i]->str, name)))
	  return iter->types[i];
      }
      iter = iter->next;
    } while (iter != end);
  }
  
  /* neither found a match */
  return 0;
}

/* 
   Pack binary data into a string
*/
SWIGRUNTIME char *
SWIG_PackData(char *c, void *ptr, size_t sz) {
  static const char hex[17] = "0123456789abcdef";
  register const unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    register unsigned char uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* 
   Unpack binary data from a string
*/
SWIGRUNTIME const char *
SWIG_UnpackData(const char *c, void *ptr, size_t sz) {
  register unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu = u + sz;
  for (; u != eu; ++u) {
    register char d = *(c++);
    register unsigned char uu;
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    else 
      return (char *) 0;
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    else 
      return (char *) 0;
    *u = uu;
  }
  return c;
}

/* 
   Pack 'void *' into a string buffer.
*/
SWIGRUNTIME char *
SWIG_PackVoidPtr(char *buff, void *ptr, const char *name, size_t bsz) {
  char *r = buff;
  if ((2*sizeof(void *) + 2) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,&ptr,sizeof(void *));
  if (strlen(name) + 1 > (bsz - (r - buff))) return 0;
  strcpy(r,name);
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackVoidPtr(const char *c, void **ptr, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      *ptr = (void *) 0;
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sizeof(void *));
}

SWIGRUNTIME char *
SWIG_PackDataName(char *buff, void *ptr, size_t sz, const char *name, size_t bsz) {
  char *r = buff;
  size_t lname = (name ? strlen(name) : 0);
  if ((2*sz + 2 + lname) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  if (lname) {
    strncpy(r,name,lname+1);
  } else {
    *r = 0;
  }
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackDataName(const char *c, void *ptr, size_t sz, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      memset(ptr,0,sz);
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sz);
}

#ifdef __cplusplus
}
#endif

/* -----------------------------------------------------------------------------
 * See the LICENSE file for information on copyright, usage and redistribution
 * of SWIG, and the README file for authors - http://www.swig.org/release.html.
 *
 * guile_scm_run.swg
 * ----------------------------------------------------------------------------- */

#include <libguile.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef SCM (*swig_guile_proc)();
typedef SCM (*guile_destructor)(SCM);

typedef struct swig_guile_clientdata {
  guile_destructor destroy;
  SCM goops_class;
} swig_guile_clientdata;

#define SWIG_scm2str(s) \
  SWIG_Guile_scm2newstr(s, NULL)
#define SWIG_malloc(size) \
  SCM_MUST_MALLOC(size)
#define SWIG_free(mem) \
  scm_must_free(mem)
#define SWIG_ConvertPtr(s, result, type, flags) \
  SWIG_Guile_ConvertPtr(s, result, type, flags)
#define SWIG_MustGetPtr(s, type, argnum, flags) \
  SWIG_Guile_MustGetPtr(s, type, argnum, flags, FUNC_NAME)
#define SWIG_NewPointerObj(ptr, type, owner) \
  SWIG_Guile_NewPointerObj((void*)ptr, type, owner)
#define SWIG_PointerAddress(object) \
  SWIG_Guile_PointerAddress(object)
#define SWIG_PointerType(object) \
  SWIG_Guile_PointerType(object)
#define SWIG_IsPointerOfType(object, type) \
  SWIG_Guile_IsPointerOfType(object, type)
#define SWIG_IsPointer(object) \
  SWIG_Guile_IsPointer(object)
#define SWIG_contract_assert(expr, msg)				\
  if (!(expr))							\
    scm_error(scm_str2symbol("swig-contract-assertion-failed"),	\
	      (char *) FUNC_NAME, (char *) msg,			\
	      SCM_EOL, SCM_BOOL_F); else

/* for C++ member pointers, ie, member methods */
#define SWIG_ConvertMember(obj, ptr, sz, ty) \
  SWIG_Guile_ConvertMember(obj, ptr, sz, ty, FUNC_NAME)
#define SWIG_NewMemberObj(ptr, sz, type) \
  SWIG_Guile_NewMemberObj(ptr, sz, type, FUNC_NAME)
  
/* Runtime API */
static swig_module_info *SWIG_Guile_GetModule(void);
#define SWIG_GetModule(clientdata) SWIG_Guile_GetModule()
#define SWIG_SetModule(clientdata, pointer) SWIG_Guile_SetModule(pointer)
  
SWIGINTERN char *
SWIG_Guile_scm2newstr(SCM str, size_t *len) {
#define FUNC_NAME "SWIG_Guile_scm2newstr"
  char *ret;
  size_t l;

  SCM_ASSERT (SCM_STRINGP(str), str, 1, FUNC_NAME);
  
  l = SCM_STRING_LENGTH(str);
  ret = (char *) SWIG_malloc( (l + 1) * sizeof(char));
  if (!ret) return NULL;

  memcpy(ret, SCM_STRING_CHARS(str), l);
  ret[l] = '\0';
  if (len) *len = l;
  return ret;
#undef FUNC_NAME
}

static int swig_initialized = 0;
static scm_t_bits swig_tag = 0;
static scm_t_bits swig_collectable_tag = 0;
static scm_t_bits swig_destroyed_tag = 0;
static scm_t_bits swig_member_function_tag = 0;
static SCM swig_make_func = SCM_EOL;
static SCM swig_keyword = SCM_EOL;
static SCM swig_symbol = SCM_EOL;

#define SWIG_Guile_GetSmob(x) \
  ( SCM_NNULLP(x) && SCM_INSTANCEP(x) && SCM_NFALSEP(scm_slot_exists_p(x, swig_symbol)) \
      ? scm_slot_ref(x, swig_symbol) : (x) )

SWIGINTERN SCM
SWIG_Guile_NewPointerObj(void *ptr, swig_type_info *type, int owner)
{
  if (ptr == NULL)
    return SCM_EOL;
  else {
    SCM smob;
    swig_guile_clientdata *cdata = (swig_guile_clientdata *) type->clientdata;
    if (owner)
      SCM_NEWSMOB2(smob, swig_collectable_tag, ptr, (void *) type);
    else
      SCM_NEWSMOB2(smob, swig_tag, ptr, (void *) type);

    if (!cdata || SCM_NULLP(cdata->goops_class) || swig_make_func == SCM_EOL ) {
      return smob;
    } else {
      /* the scm_make() C function only handles the creation of gf,
	 methods and classes (no instances) the (make ...) function is
	 later redefined in goops.scm.  So we need to call that
	 Scheme function. */
      return scm_apply(swig_make_func,
		       scm_list_3(cdata->goops_class,
				  swig_keyword,
				  smob),
		       SCM_EOL);
    }
  }
}

SWIGINTERN unsigned long
SWIG_Guile_PointerAddress(SCM object)
{
  SCM smob = SWIG_Guile_GetSmob(object);
  if (SCM_NULLP(smob)) return 0;
  else if (SCM_SMOB_PREDICATE(swig_tag, smob)
	   || SCM_SMOB_PREDICATE(swig_collectable_tag, smob)
	   || SCM_SMOB_PREDICATE(swig_destroyed_tag, smob)) {
    return (unsigned long) (void *) SCM_CELL_WORD_1(smob);
  }
  else scm_wrong_type_arg("SWIG-Guile-PointerAddress", 1, object);
}

SWIGINTERN swig_type_info *
SWIG_Guile_PointerType(SCM object)
{
  SCM smob = SWIG_Guile_GetSmob(object);
  if (SCM_NULLP(smob)) return NULL;
  else if (SCM_SMOB_PREDICATE(swig_tag, smob)
	   || SCM_SMOB_PREDICATE(swig_collectable_tag, smob)
	   || SCM_SMOB_PREDICATE(swig_destroyed_tag, smob)) {
    return (swig_type_info *) SCM_CELL_WORD_2(smob);
  }
  else scm_wrong_type_arg("SWIG-Guile-PointerType", 1, object);
}
  
SWIGINTERN int
SWIG_Guile_ConvertPtr(SCM s, void **result, swig_type_info *type, int flags)
{
  swig_cast_info *cast;
  swig_type_info *from;
  SCM smob = SWIG_Guile_GetSmob(s);

  if (SCM_NULLP(smob)) {
    *result = NULL;
    return SWIG_OK;
  } else if (SCM_SMOB_PREDICATE(swig_tag, smob) || SCM_SMOB_PREDICATE(swig_collectable_tag, smob)) {
    /* we do not accept smobs representing destroyed pointers */
    from = (swig_type_info *) SCM_CELL_WORD_2(smob);
    if (!from) return SWIG_ERROR;
    if (type) {
      cast = SWIG_TypeCheckStruct(from, type);
      if (cast) {
        int newmemory = 0;
        *result = SWIG_TypeCast(cast, (void *) SCM_CELL_WORD_1(smob), &newmemory);
        assert(!newmemory); /* newmemory handling not yet implemented */
        return SWIG_OK;
      } else {
        return SWIG_ERROR;
      }
    } else {
      *result = (void *) SCM_CELL_WORD_1(smob);
      return SWIG_OK;
    }
  }
  return SWIG_ERROR;
}

SWIGINTERNINLINE void *
SWIG_Guile_MustGetPtr (SCM s, swig_type_info *type,
		       int argnum, int flags, const char *func_name)
{
  void *result;
  int res = SWIG_Guile_ConvertPtr(s, &result, type, flags);
  if (!SWIG_IsOK(res)) {
    /* type mismatch */
    scm_wrong_type_arg((char *) func_name, argnum, s);
  }
  return result;
}

SWIGINTERNINLINE int
SWIG_Guile_IsPointerOfType (SCM s, swig_type_info *type)
{
  void *result;
  if (SWIG_Guile_ConvertPtr(s, &result, type, 0)) {
    /* type mismatch */
    return 0;
  }
  else return 1;
}

SWIGINTERNINLINE int
SWIG_Guile_IsPointer (SCM s)
{
  /* module might not be initialized yet, so initialize it */
  SWIG_Guile_GetModule();
  return SWIG_Guile_IsPointerOfType (s, NULL);
}

/* Mark a pointer object non-collectable */
SWIGINTERN void
SWIG_Guile_MarkPointerNoncollectable(SCM s)
{
  SCM smob = SWIG_Guile_GetSmob(s);
  if (!SCM_NULLP(smob)) {
    if (SCM_SMOB_PREDICATE(swig_tag, smob) || SCM_SMOB_PREDICATE(swig_collectable_tag, smob)) {
      SCM_SET_CELL_TYPE(smob, swig_tag);
    }
    else scm_wrong_type_arg(NULL, 0, s);
  }
}

/* Mark a pointer object destroyed */
SWIGINTERN void
SWIG_Guile_MarkPointerDestroyed(SCM s)
{
  SCM smob = SWIG_Guile_GetSmob(s);
  if (!SCM_NULLP(smob)) {
    if (SCM_SMOB_PREDICATE(swig_tag, smob) || SCM_SMOB_PREDICATE(swig_collectable_tag, smob)) {
      SCM_SET_CELL_TYPE(smob, swig_destroyed_tag);
    }
    else scm_wrong_type_arg(NULL, 0, s);
  }
}

/* Member functions */

SWIGINTERN SCM
SWIG_Guile_NewMemberObj(void *ptr, size_t sz, swig_type_info *type,
			const char *func_name)
{
  SCM smob;
  void *copy = malloc(sz);
  memcpy(copy, ptr, sz);
  SCM_NEWSMOB2(smob, swig_member_function_tag, copy, (void *) type);
  return smob;
}

SWIGINTERN int
SWIG_Guile_ConvertMember(SCM smob, void *ptr, size_t sz, swig_type_info *type,
			 const char *func_name)
{
  swig_cast_info *cast;
  swig_type_info *from;

  if (SCM_SMOB_PREDICATE(swig_member_function_tag, smob)) {
    from = (swig_type_info *) SCM_CELL_WORD_2(smob);
    if (!from) return SWIG_ERROR;
    if (type) {
      cast = SWIG_TypeCheckStruct(from, type);
      if (!cast) return SWIG_ERROR;
    }
    memcpy(ptr, (void *) SCM_CELL_WORD_1(smob), sz);
    return SWIG_OK;
  }
  return SWIG_ERROR;
}
     

/* Init */

SWIGINTERN int
print_swig_aux (SCM swig_smob, SCM port, scm_print_state *pstate, 
                const char *attribute)
{
  swig_type_info *type;
  
  type = (swig_type_info *) SCM_CELL_WORD_2(swig_smob);
  if (type) {
    scm_puts((char *) "#<", port);
    scm_puts((char *) attribute, port);
    scm_puts((char *) "swig-pointer ", port);
    scm_puts((char *) SWIG_TypePrettyName(type), port);
    scm_puts((char *) " ", port);
    scm_intprint((long) SCM_CELL_WORD_1(swig_smob), 16, port);
    scm_puts((char *) ">", port);
    /* non-zero means success */
    return 1;
  } else {
    return 0;
  }
}

  
SWIGINTERN int
print_swig (SCM swig_smob, SCM port, scm_print_state *pstate)
{
  return print_swig_aux(swig_smob, port, pstate, "");
}

SWIGINTERN int
print_collectable_swig (SCM swig_smob, SCM port, scm_print_state *pstate)
{
  return print_swig_aux(swig_smob, port, pstate, "collectable-");
}

SWIGINTERN int
print_destroyed_swig (SCM swig_smob, SCM port, scm_print_state *pstate)
{
  return print_swig_aux(swig_smob, port, pstate, "destroyed-");
}

SWIGINTERN int
print_member_function_swig (SCM swig_smob, SCM port, scm_print_state *pstate)
{
  swig_type_info *type;
  type = (swig_type_info *) SCM_CELL_WORD_2(swig_smob);
  if (type) {
    scm_puts((char *) "#<", port);
    scm_puts((char *) "swig-member-function-pointer ", port);
    scm_puts((char *) SWIG_TypePrettyName(type), port);
    scm_puts((char *) " >", port);
    /* non-zero means success */
    return 1;
  } else {
    return 0;
  }
}

SWIGINTERN SCM
equalp_swig (SCM A, SCM B)
{
  if (SCM_CELL_WORD_0(A) == SCM_CELL_WORD_0(B) && SCM_CELL_WORD_1(A) == SCM_CELL_WORD_1(B) 
      && SCM_CELL_WORD_2(A) == SCM_CELL_WORD_2(B))
    return SCM_BOOL_T;
  else return SCM_BOOL_F;
}

SWIGINTERN size_t
free_swig(SCM A)
{
  swig_type_info *type = (swig_type_info *) SCM_CELL_WORD_2(A);
  if (type) {
    if (type->clientdata && ((swig_guile_clientdata *)type->clientdata)->destroy)
      ((swig_guile_clientdata *)type->clientdata)->destroy(A);
  } 
  return 0;
}

SWIGINTERN size_t
free_swig_member_function(SCM A)
{
  free((swig_type_info *) SCM_CELL_WORD_1(A));
  return 0;
}

SWIGINTERN int
ensure_smob_tag(SCM swig_module,
		scm_t_bits *tag_variable,
		const char *smob_name,
		const char *scheme_variable_name)
{
  SCM variable = scm_sym2var(scm_str2symbol(scheme_variable_name),
			     scm_module_lookup_closure(swig_module),
			     SCM_BOOL_T);
  if (SCM_UNBNDP(SCM_VARIABLE_REF(variable))) {
    *tag_variable = scm_make_smob_type((char*)scheme_variable_name, 0);
    SCM_VARIABLE_SET(variable,
		     scm_ulong2num(*tag_variable));
    return 1;
  }
  else {
    *tag_variable = scm_num2ulong(SCM_VARIABLE_REF(variable), 0,
				  "SWIG_Guile_Init");
    return 0;
  }
}

SWIGINTERN SCM
SWIG_Guile_Init ()
{
  static SCM swig_module;
  
  if (swig_initialized) return swig_module;
  swig_initialized = 1;

  swig_module = scm_c_resolve_module("Swig swigrun");
  if (ensure_smob_tag(swig_module, &swig_tag,
		      "swig-pointer", "swig-pointer-tag")) {
    scm_set_smob_print(swig_tag, print_swig);
    scm_set_smob_equalp(swig_tag, equalp_swig);
  }
  if (ensure_smob_tag(swig_module, &swig_collectable_tag,
		      "collectable-swig-pointer", "collectable-swig-pointer-tag")) {
    scm_set_smob_print(swig_collectable_tag, print_collectable_swig);
    scm_set_smob_equalp(swig_collectable_tag, equalp_swig);
    scm_set_smob_free(swig_collectable_tag, free_swig);
  }
  if (ensure_smob_tag(swig_module, &swig_destroyed_tag,
		      "destroyed-swig-pointer", "destroyed-swig-pointer-tag")) {
    scm_set_smob_print(swig_destroyed_tag, print_destroyed_swig);
    scm_set_smob_equalp(swig_destroyed_tag, equalp_swig);
  }
  if (ensure_smob_tag(swig_module, &swig_member_function_tag,
		      "swig-member-function-pointer", "swig-member-function-pointer-tag")) {
    scm_set_smob_print(swig_member_function_tag, print_member_function_swig);
    scm_set_smob_free(swig_member_function_tag, free_swig_member_function);
  }
  swig_make_func = scm_permanent_object(
  scm_variable_ref(scm_c_module_lookup(scm_c_resolve_module("oop goops"), "make")));
  swig_keyword = scm_permanent_object(scm_c_make_keyword((char*) "init-smob"));
  swig_symbol = scm_permanent_object(scm_str2symbol("swig-smob"));
#ifdef SWIG_INIT_RUNTIME_MODULE
  SWIG_INIT_RUNTIME_MODULE
#endif

  return swig_module;
}

SWIGINTERN swig_module_info *
SWIG_Guile_GetModule(void)
{
  SCM module;
  SCM variable;

  module = SWIG_Guile_Init();

  variable = scm_sym2var(scm_str2symbol("swig-type-list-address" SWIG_RUNTIME_VERSION SWIG_TYPE_TABLE_NAME),
			       scm_module_lookup_closure(module),
			       SCM_BOOL_T);
  if (SCM_UNBNDP(SCM_VARIABLE_REF(variable))) {
    return NULL;
  } else {
    return (swig_module_info *) scm_num2ulong(SCM_VARIABLE_REF(variable), 0, "SWIG_Guile_Init");
  }
}

SWIGINTERN void
SWIG_Guile_SetModule(swig_module_info *swig_module)
{
  SCM module;
  SCM variable;

  module = SWIG_Guile_Init();
    
  variable = scm_sym2var(scm_str2symbol("swig-type-list-address" SWIG_RUNTIME_VERSION SWIG_TYPE_TABLE_NAME),
			       scm_module_lookup_closure(module),
			       SCM_BOOL_T);

  SCM_VARIABLE_SET(variable, scm_ulong2num((unsigned long) swig_module));
}

SWIGINTERN int
SWIG_Guile_GetArgs (SCM *dest, SCM rest,
		    int reqargs, int optargs,
		    const char *procname)
{
  int i;
  int num_args_passed = 0;
  for (i = 0; i<reqargs; i++) {
    if (!SCM_CONSP(rest))
      scm_wrong_num_args(scm_makfrom0str((char *) procname));
    *dest++ = SCM_CAR(rest);
    rest = SCM_CDR(rest);
    num_args_passed++;
  }
  for (i = 0; i<optargs && SCM_CONSP(rest); i++) {
    *dest++ = SCM_CAR(rest);
    rest = SCM_CDR(rest);
    num_args_passed++;
  }
  for (; i<optargs; i++)
    *dest++ = SCM_UNDEFINED;
  if (!SCM_NULLP(rest))
    scm_wrong_num_args(scm_makfrom0str((char *) procname));
  return num_args_passed;
}

#ifdef __cplusplus
}
#endif



#define GUILE_MAYBE_VALUES \
      if (gswig_list_p) gswig_result = scm_values(gswig_result);

#define GUILE_MAYBE_VECTOR \
      if (gswig_list_p) gswig_result = scm_vector(gswig_result);

#define SWIG_APPEND_VALUE(object)						\
    if (gswig_result == SCM_UNSPECIFIED)						\
        gswig_result = object;							\
    else {									\
      if (!gswig_list_p) {							\
	      gswig_list_p = 1;							\
	      gswig_result = scm_listify(gswig_result, object, SCM_UNDEFINED);	\
      }									\
      else									\
            gswig_result = scm_append(scm_listify(gswig_result, scm_listify(object, SCM_UNDEFINED), SCM_UNDEFINED));		\
    }
    /* used by Lib/exception.i */
    #define gh_symbol2scm scm_str2symbol
    /* useb by Lib/cdata.i */
    #define gh_str2scm scm_mem2string


static swig_guile_clientdata _swig_guile_clientdatasigned_direction = { NULL, SCM_EOL };
static swig_guile_clientdata _swig_guile_clientdatameep_vec = { NULL, SCM_EOL };
static swig_guile_clientdata _swig_guile_clientdatameep_ivec = { NULL, SCM_EOL };
static swig_guile_clientdata _swig_guile_clientdatameep_volume = { NULL, SCM_EOL };
static swig_guile_clientdata _swig_guile_clientdatameep_grid_volume = { NULL, SCM_EOL };
static swig_guile_clientdata _swig_guile_clientdatameep_symmetry = { NULL, SCM_EOL };
static swig_guile_clientdata _swig_guile_clientdatameep_volume_list = { NULL, SCM_EOL };
static swig_guile_clientdata _swig_guile_clientdatameep_initialize = { NULL, SCM_EOL };
static swig_guile_clientdata _swig_guile_clientdatameep_polarizability_identifier = { NULL, SCM_EOL };
static swig_guile_clientdata _swig_guile_clientdatameep_h5file = { NULL, SCM_EOL };
static swig_guile_clientdata _swig_guile_clientdatameep_material_function = { NULL, SCM_EOL };
static swig_guile_clientdata _swig_guile_clientdatameep_simple_material_function = { NULL, SCM_EOL };
static swig_guile_clientdata _swig_guile_clientdatameep_structure_chunk = { NULL, SCM_EOL };
static swig_guile_clientdata _swig_guile_clientdatameep_boundary_region = { NULL, SCM_EOL };
static swig_guile_clientdata _swig_guile_clientdatameep_structure = { NULL, SCM_EOL };
static swig_guile_clientdata _swig_guile_clientdatameep_src_time = { NULL, SCM_EOL };
static swig_guile_clientdata _swig_guile_clientdatameep_gaussian_src_time = { NULL, SCM_EOL };
static swig_guile_clientdata _swig_guile_clientdatameep_continuous_src_time = { NULL, SCM_EOL };
static swig_guile_clientdata _swig_guile_clientdatameep_custom_src_time = { NULL, SCM_EOL };
static swig_guile_clientdata _swig_guile_clientdatameep_monitor_point = { NULL, SCM_EOL };
static swig_guile_clientdata _swig_guile_clientdatameep_dft_chunk = { NULL, SCM_EOL };
static swig_guile_clientdata _swig_guile_clientdatameep_dft_flux = { NULL, SCM_EOL };
static swig_guile_clientdata _swig_guile_clientdatameep_dft_force = { NULL, SCM_EOL };
static swig_guile_clientdata _swig_guile_clientdatameep_fields_chunk = { NULL, SCM_EOL };
static swig_guile_clientdata _swig_guile_clientdatameep_fields = { NULL, SCM_EOL };
static swig_guile_clientdata _swig_guile_clientdatameep_flux_vol = { NULL, SCM_EOL };
static swig_guile_clientdata _swig_guile_clientdatameep_grace = { NULL, SCM_EOL };

/* -------- TYPES TABLE (BEGIN) -------- */

#define SWIGTYPE_p_FILE swig_types[0]
#define SWIGTYPE_p_a_2__p_double swig_types[1]
#define SWIGTYPE_p_a_5__bool swig_types[2]
#define SWIGTYPE_p_a_5__meep__boundary_condition swig_types[3]
#define SWIGTYPE_p_a_5__p_double swig_types[4]
#define SWIGTYPE_p_a_meep__CONNECT_COPY_1__a_meep__Outgoing_1__int swig_types[5]
#define SWIGTYPE_p_a_meep__CONNECT_COPY_1__a_meep__Outgoing_1__p_p_double swig_types[6]
#define SWIGTYPE_p_a_meep__CONNECT_COPY_1__p_int swig_types[7]
#define SWIGTYPE_p_access_mode swig_types[8]
#define SWIGTYPE_p_boundary_region_kind swig_types[9]
#define SWIGTYPE_p_complexT_double_t swig_types[10]
#define SWIGTYPE_p_complexT_long_double_t swig_types[11]
#define SWIGTYPE_p_ctlio__cnumber_list swig_types[12]
#define SWIGTYPE_p_ctlio__geometric_object_list swig_types[13]
#define SWIGTYPE_p_ctlio__material_type swig_types[14]
#define SWIGTYPE_p_ctlio__material_type_list swig_types[15]
#define SWIGTYPE_p_ctlio__pml_list swig_types[16]
#define SWIGTYPE_p_ctlio__symmetry_list swig_types[17]
#define SWIGTYPE_p_double swig_types[18]
#define SWIGTYPE_p_f_double_p_void__double swig_types[19]
#define SWIGTYPE_p_f_p_meep__fields_chunk_int_enum_meep__component_meep__ivec_meep__ivec_meep__vec_meep__vec_meep__vec_meep__vec_double_double_meep__ivec_complex__double___r_q_const__meep__symmetry_int_p_void__void swig_types[20]
#define SWIGTYPE_p_f_p_q_const__complex__double___r_q_const__meep__vec_p_void__double swig_types[21]
#define SWIGTYPE_p_f_r_q_const__meep__vec__double swig_types[22]
#define SWIGTYPE_p_int swig_types[23]
#define SWIGTYPE_p_long_double swig_types[24]
#define SWIGTYPE_p_meep__bandsdata swig_types[25]
#define SWIGTYPE_p_meep__boundary_region swig_types[26]
#define SWIGTYPE_p_meep__component swig_types[27]
#define SWIGTYPE_p_meep__continuous_src_time swig_types[28]
#define SWIGTYPE_p_meep__custom_src_time swig_types[29]
#define SWIGTYPE_p_meep__dft_chunk swig_types[30]
#define SWIGTYPE_p_meep__dft_flux swig_types[31]
#define SWIGTYPE_p_meep__dft_force swig_types[32]
#define SWIGTYPE_p_meep__fields swig_types[33]
#define SWIGTYPE_p_meep__fields_chunk swig_types[34]
#define SWIGTYPE_p_meep__flux_vol swig_types[35]
#define SWIGTYPE_p_meep__gaussian_src_time swig_types[36]
#define SWIGTYPE_p_meep__grace swig_types[37]
#define SWIGTYPE_p_meep__grid_volume swig_types[38]
#define SWIGTYPE_p_meep__h5file swig_types[39]
#define SWIGTYPE_p_meep__initialize swig_types[40]
#define SWIGTYPE_p_meep__ivec swig_types[41]
#define SWIGTYPE_p_meep__material_function swig_types[42]
#define SWIGTYPE_p_meep__monitor_point swig_types[43]
#define SWIGTYPE_p_meep__polarizability swig_types[44]
#define SWIGTYPE_p_meep__polarizability_identifier swig_types[45]
#define SWIGTYPE_p_meep__signed_direction swig_types[46]
#define SWIGTYPE_p_meep__simple_material_function swig_types[47]
#define SWIGTYPE_p_meep__src_time swig_types[48]
#define SWIGTYPE_p_meep__structure swig_types[49]
#define SWIGTYPE_p_meep__structure_chunk swig_types[50]
#define SWIGTYPE_p_meep__symmetry swig_types[51]
#define SWIGTYPE_p_meep__vec swig_types[52]
#define SWIGTYPE_p_meep__volume swig_types[53]
#define SWIGTYPE_p_meep__volume_list swig_types[54]
#define SWIGTYPE_p_p_complexT_double_t swig_types[55]
#define SWIGTYPE_p_p_double swig_types[56]
#define SWIGTYPE_p_p_meep__continuous_src_time swig_types[57]
#define SWIGTYPE_p_p_meep__custom_src_time swig_types[58]
#define SWIGTYPE_p_p_meep__fields_chunk swig_types[59]
#define SWIGTYPE_p_p_meep__gaussian_src_time swig_types[60]
#define SWIGTYPE_p_p_meep__polarization swig_types[61]
#define SWIGTYPE_p_p_meep__src_time swig_types[62]
#define SWIGTYPE_p_p_meep__src_vol swig_types[63]
#define SWIGTYPE_p_p_meep__structure_chunk swig_types[64]
#define SWIGTYPE_p_p_p_char swig_types[65]
#define SWIGTYPE_p_p_p_double swig_types[66]
#define SWIGTYPE_p_unsigned_long swig_types[67]
#define SWIGTYPE_p_vector3 swig_types[68]
static swig_type_info *swig_types[70];
static swig_module_info swig_module = {swig_types, 69, 0, 0, 0, 0};
#define SWIG_TypeQuery(name) SWIG_TypeQueryModule(&swig_module, &swig_module, name)
#define SWIG_MangledTypeQuery(name) SWIG_MangledTypeQueryModule(&swig_module, &swig_module, name)

/* -------- TYPES TABLE (END) -------- */


#include "meep-ctl.hpp"

static inline int SwigComplex_Check(SCM o) {
  return SCM_REALP(o) || SCM_COMPLEXP(o);
}

static inline int SwigVector3_Check(SCM o) {
  return SCM_VECTORP(o) && SCM_VECTOR_LENGTH(o) == 3;
}

/* Unfortunately, this is not re-entrant.  Damn dynamic scoping. 
   Hopefully, it should be good enough for our purposes. */
static SCM my_complex_func_scm;
static inline complex<double> my_complex_func(meep::vec const &v) {
  SCM ret = gh_call1(my_complex_func_scm, 
		     ctl_convert_vector3_to_scm(vec_to_vector3(v)));
  cnumber cret = ctl_convert_cnumber_to_c(ret);
  return std::complex<double>(cret.re, cret.im);
}

static inline complex<double> my_complex_func2(double t, void *f) {
  SCM ret = gh_call1((SCM) f, gh_double2scm(t));
  cnumber cret = ctl_convert_cnumber_to_c(ret);
  return std::complex<double>(cret.re, cret.im);
}

typedef struct { SCM func; int nf; } my_field_func_data;
static inline complex<double> my_field_func(const complex<double> *fields,
					    const meep::vec &loc,
					    void *data_) {
  my_field_func_data *data = (my_field_func_data *) data_;
  int num_items = data->nf;
  cnumber *items = new cnumber[num_items];
  for (int i = 0; i < num_items; ++i)
    items[i] = make_cnumber(real(fields[i]), imag(fields[i]));
  SCM ret = gh_apply(data->func,
		     scm_cons(ctl_convert_vector3_to_scm(vec_to_vector3(loc)),
			      make_cnumber_list(num_items, items)));
  delete[] items;
  cnumber cret = ctl_convert_cnumber_to_c(ret);
  return std::complex<double>(cret.re, cret.im);
}

/* Unfortunately, this is not re-entrant.  Damn dynamic scoping. 
   Hopefully, it should be good enough for our purposes. */
static SCM my_complex_func3_scm;
static inline complex<double> my_complex_func3(complex<double> x) {
  cnumber cx;
  cx.re = real(x); cx.im = imag(x);
  SCM ret = gh_call1(my_complex_func3_scm, ctl_convert_cnumber_to_scm(cx));
  cnumber cret = ctl_convert_cnumber_to_c(ret);
  return std::complex<double>(cret.re, cret.im);
}


static int gswig_const_meep_component_Ex = meep::Ex;
static int gswig_const_meep_component_Ey = meep::Ey;
static int gswig_const_meep_component_Er = meep::Er;
static int gswig_const_meep_component_Ep = meep::Ep;
static int gswig_const_meep_component_Ez = meep::Ez;
static int gswig_const_meep_component_Hx = meep::Hx;
static int gswig_const_meep_component_Hy = meep::Hy;
static int gswig_const_meep_component_Hr = meep::Hr;
static int gswig_const_meep_component_Hp = meep::Hp;
static int gswig_const_meep_component_Hz = meep::Hz;
static int gswig_const_meep_component_Dx = meep::Dx;
static int gswig_const_meep_component_Dy = meep::Dy;
static int gswig_const_meep_component_Dr = meep::Dr;
static int gswig_const_meep_component_Dp = meep::Dp;
static int gswig_const_meep_component_Dz = meep::Dz;
static int gswig_const_meep_component_Bx = meep::Bx;
static int gswig_const_meep_component_By = meep::By;
static int gswig_const_meep_component_Br = meep::Br;
static int gswig_const_meep_component_Bp = meep::Bp;
static int gswig_const_meep_component_Bz = meep::Bz;
static int gswig_const_meep_component_Dielectric = meep::Dielectric;
static int gswig_const_meep_component_Permeability = meep::Permeability;
static int gswig_const_meep_derived_component_Sx = meep::Sx;
static int gswig_const_meep_derived_component_Sy = meep::Sy;
static int gswig_const_meep_derived_component_Sr = meep::Sr;
static int gswig_const_meep_derived_component_Sp = meep::Sp;
static int gswig_const_meep_derived_component_Sz = meep::Sz;
static int gswig_const_meep_derived_component_EnergyDensity = meep::EnergyDensity;
static int gswig_const_meep_derived_component_D_EnergyDensity = meep::D_EnergyDensity;
static int gswig_const_meep_derived_component_H_EnergyDensity = meep::H_EnergyDensity;
static int gswig_const_meep_ndim_D1 = meep::D1;
static int gswig_const_meep_ndim_D2 = meep::D2;
static int gswig_const_meep_ndim_D3 = meep::D3;
static int gswig_const_meep_ndim_Dcyl = meep::Dcyl;
static int gswig_const_meep_field_type_E_stuff = meep::E_stuff;
static int gswig_const_meep_field_type_H_stuff = meep::H_stuff;
static int gswig_const_meep_field_type_D_stuff = meep::D_stuff;
static int gswig_const_meep_field_type_B_stuff = meep::B_stuff;
static int gswig_const_meep_field_type_PE_stuff = meep::PE_stuff;
static int gswig_const_meep_field_type_PH_stuff = meep::PH_stuff;
static int gswig_const_meep_boundary_side_High = meep::High;
static int gswig_const_meep_boundary_side_Low = meep::Low;
static int gswig_const_meep_direction_X = meep::X;
static int gswig_const_meep_direction_Y = meep::Y;
static int gswig_const_meep_direction_Z = meep::Z;
static int gswig_const_meep_direction_R = meep::R;
static int gswig_const_meep_direction_P = meep::P;
static int gswig_const_meep_direction_NO_DIRECTION = meep::NO_DIRECTION;
static int gswig_const_MEEP_SINGLE = 0;
static int gswig_const_meep_h5file_READONLY = meep::h5file::READONLY;
static int gswig_const_meep_h5file_READWRITE = meep::h5file::READWRITE;
static int gswig_const_meep_h5file_WRITE = meep::h5file::WRITE;
static double gswig_const_DEFAULT_SUBPIXEL_TOL = 1e-4;
static int gswig_const_DEFAULT_SUBPIXEL_MAXEVAL = 100000;
static int gswig_const_meep_boundary_region_NOTHING_SPECIAL = meep::boundary_region::NOTHING_SPECIAL;
static int gswig_const_meep_boundary_region_PML = meep::boundary_region::PML;
static int gswig_const_meep_in_or_out_Incoming = meep::Incoming;
static int gswig_const_meep_in_or_out_Outgoing = meep::Outgoing;
static int gswig_const_meep_connect_phase_CONNECT_PHASE = meep::CONNECT_PHASE;
static int gswig_const_meep_connect_phase_CONNECT_NEGATE = meep::CONNECT_NEGATE;
static int gswig_const_meep_connect_phase_CONNECT_COPY = meep::CONNECT_COPY;
static int gswig_const_meep_boundary_condition_Periodic = meep::Periodic;
static int gswig_const_meep_boundary_condition_Metallic = meep::Metallic;
static int gswig_const_meep_boundary_condition_Magnetic = meep::Magnetic;
static int gswig_const_meep_boundary_condition_None = meep::None;
static int gswig_const_meep_time_sink_Connecting = meep::Connecting;
static int gswig_const_meep_time_sink_Stepping = meep::Stepping;
static int gswig_const_meep_time_sink_Boundaries = meep::Boundaries;
static int gswig_const_meep_time_sink_MpiTime = meep::MpiTime;
static int gswig_const_meep_time_sink_FieldOutput = meep::FieldOutput;
static int gswig_const_meep_time_sink_FourierTransforming = meep::FourierTransforming;
static int gswig_const_meep_time_sink_Other = meep::Other;
static int gswig_const_meep_grace_type_XY = meep::XY;
static int gswig_const_meep_grace_type_ERROR_BARS = meep::ERROR_BARS;

#include "ctl-io.h"


#include "meep-ctl-swig.hpp"

static int gswig_const_MEEP_CTL_SWIG_HPP = 1;
static SCM
_wrap_NUM_FIELD_COMPONENTS(SCM s_0)
{
#define FUNC_NAME "NUM-FIELD-COMPONENTS"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(meep::NUM_FIELD_COMPONENTS);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_NUM_FIELD_TYPES(SCM s_0)
{
#define FUNC_NAME "NUM-FIELD-TYPES"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(meep::NUM_FIELD_TYPES);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_component_Ex(SCM s_0)
{
#define FUNC_NAME "meep-component-Ex"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_component_Ex);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_component_Ey(SCM s_0)
{
#define FUNC_NAME "meep-component-Ey"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_component_Ey);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_component_Er(SCM s_0)
{
#define FUNC_NAME "meep-component-Er"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_component_Er);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_component_Ep(SCM s_0)
{
#define FUNC_NAME "meep-component-Ep"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_component_Ep);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_component_Ez(SCM s_0)
{
#define FUNC_NAME "meep-component-Ez"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_component_Ez);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_component_Hx(SCM s_0)
{
#define FUNC_NAME "meep-component-Hx"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_component_Hx);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_component_Hy(SCM s_0)
{
#define FUNC_NAME "meep-component-Hy"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_component_Hy);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_component_Hr(SCM s_0)
{
#define FUNC_NAME "meep-component-Hr"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_component_Hr);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_component_Hp(SCM s_0)
{
#define FUNC_NAME "meep-component-Hp"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_component_Hp);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_component_Hz(SCM s_0)
{
#define FUNC_NAME "meep-component-Hz"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_component_Hz);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_component_Dx(SCM s_0)
{
#define FUNC_NAME "meep-component-Dx"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_component_Dx);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_component_Dy(SCM s_0)
{
#define FUNC_NAME "meep-component-Dy"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_component_Dy);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_component_Dr(SCM s_0)
{
#define FUNC_NAME "meep-component-Dr"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_component_Dr);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_component_Dp(SCM s_0)
{
#define FUNC_NAME "meep-component-Dp"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_component_Dp);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_component_Dz(SCM s_0)
{
#define FUNC_NAME "meep-component-Dz"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_component_Dz);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_component_Bx(SCM s_0)
{
#define FUNC_NAME "meep-component-Bx"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_component_Bx);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_component_By(SCM s_0)
{
#define FUNC_NAME "meep-component-By"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_component_By);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_component_Br(SCM s_0)
{
#define FUNC_NAME "meep-component-Br"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_component_Br);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_component_Bp(SCM s_0)
{
#define FUNC_NAME "meep-component-Bp"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_component_Bp);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_component_Bz(SCM s_0)
{
#define FUNC_NAME "meep-component-Bz"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_component_Bz);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_component_Dielectric(SCM s_0)
{
#define FUNC_NAME "meep-component-Dielectric"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_component_Dielectric);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_component_Permeability(SCM s_0)
{
#define FUNC_NAME "meep-component-Permeability"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_component_Permeability);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_derived_component_Sx(SCM s_0)
{
#define FUNC_NAME "meep-derived-component-Sx"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_derived_component_Sx);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_derived_component_Sy(SCM s_0)
{
#define FUNC_NAME "meep-derived-component-Sy"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_derived_component_Sy);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_derived_component_Sr(SCM s_0)
{
#define FUNC_NAME "meep-derived-component-Sr"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_derived_component_Sr);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_derived_component_Sp(SCM s_0)
{
#define FUNC_NAME "meep-derived-component-Sp"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_derived_component_Sp);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_derived_component_Sz(SCM s_0)
{
#define FUNC_NAME "meep-derived-component-Sz"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_derived_component_Sz);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_derived_component_EnergyDensity(SCM s_0)
{
#define FUNC_NAME "meep-derived-component-EnergyDensity"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_derived_component_EnergyDensity);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_derived_component_D_EnergyDensity(SCM s_0)
{
#define FUNC_NAME "meep-derived-component-D-EnergyDensity"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_derived_component_D_EnergyDensity);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_derived_component_H_EnergyDensity(SCM s_0)
{
#define FUNC_NAME "meep-derived-component-H-EnergyDensity"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_derived_component_H_EnergyDensity);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_ndim_D1(SCM s_0)
{
#define FUNC_NAME "meep-ndim-D1"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_ndim_D1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_ndim_D2(SCM s_0)
{
#define FUNC_NAME "meep-ndim-D2"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_ndim_D2);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_ndim_D3(SCM s_0)
{
#define FUNC_NAME "meep-ndim-D3"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_ndim_D3);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_ndim_Dcyl(SCM s_0)
{
#define FUNC_NAME "meep-ndim-Dcyl"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_ndim_Dcyl);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_field_type_E_stuff(SCM s_0)
{
#define FUNC_NAME "meep-field-type-E-stuff"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_field_type_E_stuff);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_field_type_H_stuff(SCM s_0)
{
#define FUNC_NAME "meep-field-type-H-stuff"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_field_type_H_stuff);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_field_type_D_stuff(SCM s_0)
{
#define FUNC_NAME "meep-field-type-D-stuff"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_field_type_D_stuff);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_field_type_B_stuff(SCM s_0)
{
#define FUNC_NAME "meep-field-type-B-stuff"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_field_type_B_stuff);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_field_type_PE_stuff(SCM s_0)
{
#define FUNC_NAME "meep-field-type-PE-stuff"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_field_type_PE_stuff);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_field_type_PH_stuff(SCM s_0)
{
#define FUNC_NAME "meep-field-type-PH-stuff"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_field_type_PH_stuff);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_boundary_side_High(SCM s_0)
{
#define FUNC_NAME "meep-boundary-side-High"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_boundary_side_High);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_boundary_side_Low(SCM s_0)
{
#define FUNC_NAME "meep-boundary-side-Low"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_boundary_side_Low);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_direction_X(SCM s_0)
{
#define FUNC_NAME "meep-direction-X"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_direction_X);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_direction_Y(SCM s_0)
{
#define FUNC_NAME "meep-direction-Y"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_direction_Y);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_direction_Z(SCM s_0)
{
#define FUNC_NAME "meep-direction-Z"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_direction_Z);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_direction_R(SCM s_0)
{
#define FUNC_NAME "meep-direction-R"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_direction_R);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_direction_P(SCM s_0)
{
#define FUNC_NAME "meep-direction-P"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_direction_P);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_direction_NO_DIRECTION(SCM s_0)
{
#define FUNC_NAME "meep-direction-NO-DIRECTION"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_direction_NO_DIRECTION);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_signed_direction__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "new-signed-direction"
  meep::direction arg1 ;
  bool arg2 ;
  complex< double > arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::signed_direction *result = 0 ;
  
  {
    arg1 = (meep::direction) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg2 = (bool) SCM_NFALSEP(argv[1]);
  }
  {
    cnumber cnum = ctl_convert_cnumber_to_c(argv[2]);
    arg3 = std::complex<double>(cnum.re, cnum.im);
  }
  result = (meep::signed_direction *)new meep::signed_direction(arg1,arg2,arg3);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__signed_direction, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_signed_direction__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "new-signed-direction"
  meep::direction arg1 ;
  bool arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::signed_direction *result = 0 ;
  
  {
    arg1 = (meep::direction) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg2 = (bool) SCM_NFALSEP(argv[1]);
  }
  result = (meep::signed_direction *)new meep::signed_direction(arg1,arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__signed_direction, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_signed_direction__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "new-signed-direction"
  meep::direction arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::signed_direction *result = 0 ;
  
  {
    arg1 = (meep::direction) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME); 
  }
  result = (meep::signed_direction *)new meep::signed_direction(arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__signed_direction, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_signed_direction__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "new-signed-direction"
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::signed_direction *result = 0 ;
  
  result = (meep::signed_direction *)new meep::signed_direction();
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__signed_direction, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_signed_direction__SWIG_4 (int argc, SCM *argv)
{
#define FUNC_NAME "new-signed-direction"
  meep::signed_direction *arg1 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::signed_direction *result = 0 ;
  
  {
    arg1 = (meep::signed_direction *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__signed_direction, 1, 0);
  }
  result = (meep::signed_direction *)new meep::signed_direction((meep::signed_direction const &)*arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__signed_direction, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_signed_direction(SCM rest)
{
#define FUNC_NAME "new-signed-direction"
  SCM argv[3];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "new-signed-direction");
  if (argc == 0) {
    return _wrap_new_signed_direction__SWIG_3(argc,argv);
  }
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__signed_direction, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      return _wrap_new_signed_direction__SWIG_4(argc,argv);
    }
  }
  if (argc == 1) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      return _wrap_new_signed_direction__SWIG_2(argc,argv);
    }
  }
  if (argc == 2) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      {
        _v = SCM_BOOLP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        return _wrap_new_signed_direction__SWIG_1(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      {
        _v = SCM_BOOLP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SwigComplex_Check(argv[2]);
        }
        if (_v) {
          return _wrap_new_signed_direction__SWIG_0(argc,argv);
        }
      }
    }
  }
  
  scm_misc_error("new-signed-direction", "No matching method for generic function `new_signed_direction'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_signed_direction_d_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "signed-direction-d-set"
  meep::signed_direction *arg1 = (meep::signed_direction *) 0 ;
  meep::direction arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::signed_direction *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__signed_direction, 1, 0);
  }
  {
    arg2 = (meep::direction) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  if (arg1) (arg1)->d = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_signed_direction_d_get (SCM s_0)
{
#define FUNC_NAME "signed-direction-d-get"
  meep::signed_direction *arg1 = (meep::signed_direction *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::direction result;
  
  {
    arg1 = (meep::signed_direction *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__signed_direction, 1, 0);
  }
  result = (meep::direction) ((arg1)->d);
  {
    gswig_result = scm_long2num(result); 
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_signed_direction_flipped_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "signed-direction-flipped-set"
  meep::signed_direction *arg1 = (meep::signed_direction *) 0 ;
  bool arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::signed_direction *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__signed_direction, 1, 0);
  }
  {
    arg2 = (bool) SCM_NFALSEP(s_1);
  }
  if (arg1) (arg1)->flipped = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_signed_direction_flipped_get (SCM s_0)
{
#define FUNC_NAME "signed-direction-flipped-get"
  meep::signed_direction *arg1 = (meep::signed_direction *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::signed_direction *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__signed_direction, 1, 0);
  }
  result = (bool) ((arg1)->flipped);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_signed_direction_phase_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "signed-direction-phase-set"
  meep::signed_direction *arg1 = (meep::signed_direction *) 0 ;
  complex< double > arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::signed_direction *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__signed_direction, 1, 0);
  }
  {
    cnumber cnum = ctl_convert_cnumber_to_c(s_1);
    arg2 = std::complex<double>(cnum.re, cnum.im);
  }
  if (arg1) (arg1)->phase = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_signed_direction_phase_get (SCM s_0)
{
#define FUNC_NAME "signed-direction-phase-get"
  meep::signed_direction *arg1 = (meep::signed_direction *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > result;
  
  {
    arg1 = (meep::signed_direction *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__signed_direction, 1, 0);
  }
  result =  ((arg1)->phase);
  {
    gswig_result = scm_make_rectangular(scm_make_real((&result)->real()),
      scm_make_real((&result)->imag()));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_delete_signed_direction (SCM s_0)
{
#define FUNC_NAME "delete-signed-direction"
  meep::signed_direction *arg1 = (meep::signed_direction *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::signed_direction *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__signed_direction, 1, 0);
  }
  delete arg1;
  gswig_result = SCM_UNSPECIFIED;
  
  SWIG_Guile_MarkPointerDestroyed(s_0);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_number_of_directions (SCM s_0)
{
#define FUNC_NAME "meep-number-of-directions"
  meep::ndim arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::ndim) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  result = (int)meep::number_of_directions(arg1);
  {
    gswig_result = scm_long2num(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_start_at_direction (SCM s_0)
{
#define FUNC_NAME "meep-start-at-direction"
  meep::ndim arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::direction result;
  
  {
    arg1 = (meep::ndim) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  result = (meep::direction)meep::start_at_direction(arg1);
  {
    gswig_result = scm_long2num(result); 
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_stop_at_direction (SCM s_0)
{
#define FUNC_NAME "meep-stop-at-direction"
  meep::ndim arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::direction result;
  
  {
    arg1 = (meep::ndim) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  result = (meep::direction)meep::stop_at_direction(arg1);
  {
    gswig_result = scm_long2num(result); 
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_first_field_component (SCM s_0)
{
#define FUNC_NAME "meep-first-field-component"
  meep::field_type arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::component result;
  
  {
    arg1 = (meep::field_type) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  result = (meep::component)meep::first_field_component(arg1);
  {
    gswig_result = scm_long2num(result); 
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_flip (SCM s_0)
{
#define FUNC_NAME "meep-flip"
  meep::signed_direction arg1 ;
  meep::signed_direction *argp1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::signed_direction result;
  
  {
    argp1 = (meep::signed_direction *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__signed_direction, 1, 0);
    arg1 = *argp1;
  }
  result = meep::flip(arg1);
  {
    meep::signed_direction * resultptr;
    resultptr = new meep::signed_direction((const meep::signed_direction &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__signed_direction, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_has_direction (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-has-direction"
  meep::ndim arg1 ;
  meep::direction arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::ndim) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg2 = (meep::direction) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = (bool)meep::has_direction(arg1,arg2);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_has_field_direction (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-has-field-direction"
  meep::ndim arg1 ;
  meep::direction arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::ndim) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg2 = (meep::direction) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = (bool)meep::has_field_direction(arg1,arg2);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_coordinate_mismatch__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-coordinate-mismatch"
  meep::ndim arg1 ;
  meep::direction arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::ndim) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg2 = (meep::direction) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  result = (bool)meep::coordinate_mismatch(arg1,arg2);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_is_tm (SCM s_0)
{
#define FUNC_NAME "meep-is-tm"
  meep::component arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::component) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  result = (bool)meep::is_tm(arg1);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_abort (SCM s_0)
{
#define FUNC_NAME "meep-abort"
  char *arg1 = (char *) 0 ;
  void *arg2 = 0 ;
  int must_free1 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (char *)SWIG_scm2str(s_0);
    must_free1 = 1;
  }
  meep::abort((char const *)arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  if (must_free1 && arg1) SWIG_free(arg1);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_is_electric (SCM s_0)
{
#define FUNC_NAME "meep-is-electric"
  meep::component arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::component) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  result = (bool)meep::is_electric(arg1);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_is_magnetic (SCM s_0)
{
#define FUNC_NAME "meep-is-magnetic"
  meep::component arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::component) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  result = (bool)meep::is_magnetic(arg1);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_is_D (SCM s_0)
{
#define FUNC_NAME "meep-is-D"
  meep::component arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::component) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  result = (bool)meep::is_D(arg1);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_is_B (SCM s_0)
{
#define FUNC_NAME "meep-is-B"
  meep::component arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::component) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  result = (bool)meep::is_B(arg1);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_is_derived (SCM s_0)
{
#define FUNC_NAME "meep-is-derived"
  int arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (int) scm_num2int(s_0, SCM_ARG1, FUNC_NAME);
  }
  result = (bool)meep::is_derived(arg1);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_is_poynting (SCM s_0)
{
#define FUNC_NAME "meep-is-poynting"
  meep::derived_component arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::derived_component) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  result = (bool)meep::is_poynting(arg1);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_is_energydensity (SCM s_0)
{
#define FUNC_NAME "meep-is-energydensity"
  meep::derived_component arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::derived_component) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  result = (bool)meep::is_energydensity(arg1);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_type (SCM s_0)
{
#define FUNC_NAME "meep-type"
  meep::component arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::field_type result;
  
  {
    arg1 = (meep::component) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  result = (meep::field_type)meep::type(arg1);
  {
    gswig_result = scm_long2num(result); 
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_component_name__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-component-name"
  meep::component arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  char *result = 0 ;
  
  {
    arg1 = (meep::component) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME); 
  }
  result = (char *)meep::component_name(arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_component_name__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-component-name"
  meep::derived_component arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  char *result = 0 ;
  
  {
    arg1 = (meep::derived_component) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME); 
  }
  result = (char *)meep::component_name(arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_component_name__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-component-name"
  int arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  char *result = 0 ;
  
  {
    arg1 = (int) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME);
  }
  result = (char *)meep::component_name(arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_component_name(SCM rest)
{
#define FUNC_NAME "meep-component-name"
  SCM argv[1];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 1, "meep-component-name");
  if (argc == 1) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      return _wrap_meep_component_name__SWIG_0(argc,argv);
    }
  }
  if (argc == 1) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      return _wrap_meep_component_name__SWIG_1(argc,argv);
    }
  }
  if (argc == 1) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      return _wrap_meep_component_name__SWIG_2(argc,argv);
    }
  }
  
  scm_misc_error("meep-component-name", "No matching method for generic function `meep_component_name'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_direction_name (SCM s_0)
{
#define FUNC_NAME "meep-direction-name"
  meep::direction arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  char *result = 0 ;
  
  {
    arg1 = (meep::direction) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  result = (char *)meep::direction_name(arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dimension_name (SCM s_0)
{
#define FUNC_NAME "meep-dimension-name"
  meep::ndim arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  char *result = 0 ;
  
  {
    arg1 = (meep::ndim) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  result = (char *)meep::dimension_name(arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_component_index (SCM s_0)
{
#define FUNC_NAME "meep-component-index"
  meep::component arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::component) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  result = (int)meep::component_index(arg1);
  {
    gswig_result = scm_long2num(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_component_direction__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-component-direction"
  int arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::direction result;
  
  {
    arg1 = (int) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME);
  }
  result = (meep::direction)meep::component_direction(arg1);
  {
    gswig_result = scm_long2num(result); 
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_direction_component__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-direction-component"
  int arg1 ;
  meep::direction arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (int) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME);
  }
  {
    arg2 = (meep::direction) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  result = (int)meep::direction_component(arg1,arg2);
  {
    gswig_result = scm_long2num(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_component_direction__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-component-direction"
  meep::component arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::direction result;
  
  {
    arg1 = (meep::component) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME); 
  }
  result = (meep::direction)meep::component_direction(arg1);
  {
    gswig_result = scm_long2num(result); 
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_component_direction__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-component-direction"
  meep::derived_component arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::direction result;
  
  {
    arg1 = (meep::derived_component) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME); 
  }
  result = (meep::direction)meep::component_direction(arg1);
  {
    gswig_result = scm_long2num(result); 
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_component_direction(SCM rest)
{
#define FUNC_NAME "meep-component-direction"
  SCM argv[1];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 1, "meep-component-direction");
  if (argc == 1) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      return _wrap_meep_component_direction__SWIG_0(argc,argv);
    }
  }
  if (argc == 1) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      return _wrap_meep_component_direction__SWIG_1(argc,argv);
    }
  }
  if (argc == 1) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      return _wrap_meep_component_direction__SWIG_2(argc,argv);
    }
  }
  
  scm_misc_error("meep-component-direction", "No matching method for generic function `meep_component_direction'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_direction_component__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-direction-component"
  meep::component arg1 ;
  meep::direction arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::component result;
  
  {
    arg1 = (meep::component) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg2 = (meep::direction) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  result = (meep::component)meep::direction_component(arg1,arg2);
  {
    gswig_result = scm_long2num(result); 
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_direction_component__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-direction-component"
  meep::derived_component arg1 ;
  meep::direction arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::derived_component result;
  
  {
    arg1 = (meep::derived_component) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg2 = (meep::direction) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  result = (meep::derived_component)meep::direction_component(arg1,arg2);
  {
    gswig_result = scm_long2num(result); 
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_direction_component(SCM rest)
{
#define FUNC_NAME "meep-direction-component"
  SCM argv[2];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 2, "meep-direction-component");
  if (argc == 2) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        return _wrap_meep_direction_component__SWIG_0(argc,argv);
      }
    }
  }
  if (argc == 2) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        return _wrap_meep_direction_component__SWIG_1(argc,argv);
      }
    }
  }
  if (argc == 2) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        return _wrap_meep_direction_component__SWIG_2(argc,argv);
      }
    }
  }
  
  scm_misc_error("meep-direction-component", "No matching method for generic function `meep_direction_component'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_field_type_component (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-field-type-component"
  meep::field_type arg1 ;
  meep::component arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::component result;
  
  {
    arg1 = (meep::field_type) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = (meep::component)meep::field_type_component(arg1,arg2);
  {
    gswig_result = scm_long2num(result); 
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_coordinate_mismatch__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-coordinate-mismatch"
  meep::ndim arg1 ;
  meep::component arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::ndim) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  result = (bool)meep::coordinate_mismatch(arg1,arg2);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_coordinate_mismatch__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-coordinate-mismatch"
  meep::ndim arg1 ;
  meep::derived_component arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::ndim) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg2 = (meep::derived_component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  result = (bool)meep::coordinate_mismatch(arg1,arg2);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_coordinate_mismatch(SCM rest)
{
#define FUNC_NAME "meep-coordinate-mismatch"
  SCM argv[2];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 2, "meep-coordinate-mismatch");
  if (argc == 2) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        return _wrap_meep_coordinate_mismatch__SWIG_0(argc,argv);
      }
    }
  }
  if (argc == 2) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        return _wrap_meep_coordinate_mismatch__SWIG_1(argc,argv);
      }
    }
  }
  if (argc == 2) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        return _wrap_meep_coordinate_mismatch__SWIG_2(argc,argv);
      }
    }
  }
  
  scm_misc_error("meep-coordinate-mismatch", "No matching method for generic function `meep_coordinate_mismatch'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_cycle_direction (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-cycle-direction"
  meep::ndim arg1 ;
  meep::direction arg2 ;
  int arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::direction result;
  
  {
    arg1 = (meep::ndim) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg2 = (meep::direction) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (int) scm_num2int(s_2, SCM_ARG1, FUNC_NAME);
  }
  result = (meep::direction)meep::cycle_direction(arg1,arg2,arg3);
  {
    gswig_result = scm_long2num(result); 
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_cycle_component (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-cycle-component"
  meep::ndim arg1 ;
  meep::component arg2 ;
  int arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::component result;
  
  {
    arg1 = (meep::ndim) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (int) scm_num2int(s_2, SCM_ARG1, FUNC_NAME);
  }
  result = (meep::component)meep::cycle_component(arg1,arg2,arg3);
  {
    gswig_result = scm_long2num(result); 
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_veccyl (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-veccyl"
  double arg1 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::vec result;
  
  {
    arg1 = (double) scm_num2dbl(s_0, FUNC_NAME);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  result = meep::veccyl(arg1,arg2);
  {
    gswig_result = ctl_convert_vector3_to_scm(vec_to_vector3(result));
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_zero_vec (SCM s_0)
{
#define FUNC_NAME "meep-zero-vec"
  meep::ndim arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::vec result;
  
  {
    arg1 = (meep::ndim) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  result = meep::zero_vec(arg1);
  {
    gswig_result = ctl_convert_vector3_to_scm(vec_to_vector3(result));
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_vec__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-vec"
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::vec *result = 0 ;
  
  result = (meep::vec *)new meep::vec();
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__vec, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_vec__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-vec"
  meep::ndim arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::vec *result = 0 ;
  
  {
    arg1 = (meep::ndim) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME); 
  }
  result = (meep::vec *)new meep::vec(arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__vec, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_vec__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-vec"
  meep::ndim arg1 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::vec *result = 0 ;
  
  {
    arg1 = (meep::ndim) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg2 = (double) scm_num2dbl(argv[1], FUNC_NAME);
  }
  result = (meep::vec *)new meep::vec(arg1,arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__vec, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_vec__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-vec"
  double arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::vec *result = 0 ;
  
  {
    arg1 = (double) scm_num2dbl(argv[0], FUNC_NAME);
  }
  result = (meep::vec *)new meep::vec(arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__vec, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_vec__SWIG_4 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-vec"
  double arg1 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::vec *result = 0 ;
  
  {
    arg1 = (double) scm_num2dbl(argv[0], FUNC_NAME);
  }
  {
    arg2 = (double) scm_num2dbl(argv[1], FUNC_NAME);
  }
  result = (meep::vec *)new meep::vec(arg1,arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__vec, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_vec__SWIG_5 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-vec"
  double arg1 ;
  double arg2 ;
  double arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::vec *result = 0 ;
  
  {
    arg1 = (double) scm_num2dbl(argv[0], FUNC_NAME);
  }
  {
    arg2 = (double) scm_num2dbl(argv[1], FUNC_NAME);
  }
  {
    arg3 = (double) scm_num2dbl(argv[2], FUNC_NAME);
  }
  result = (meep::vec *)new meep::vec(arg1,arg2,arg3);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__vec, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_vec(SCM rest)
{
#define FUNC_NAME "new-meep-vec"
  SCM argv[3];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "new-meep-vec");
  if (argc == 0) {
    return _wrap_new_meep_vec__SWIG_0(argc,argv);
  }
  if (argc == 1) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      return _wrap_new_meep_vec__SWIG_1(argc,argv);
    }
  }
  if (argc == 1) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_real_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      return _wrap_new_meep_vec__SWIG_3(argc,argv);
    }
  }
  if (argc == 2) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_real_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        return _wrap_new_meep_vec__SWIG_2(argc,argv);
      }
    }
  }
  if (argc == 2) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_real_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_real_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        return _wrap_new_meep_vec__SWIG_4(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_real_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_real_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_real_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_new_meep_vec__SWIG_5(argc,argv);
        }
      }
    }
  }
  
  scm_misc_error("new-meep-vec", "No matching method for generic function `new_meep_vec'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_delete_meep_vec (SCM s_0)
{
#define FUNC_NAME "delete-meep-vec"
  meep::vec *arg1 = (meep::vec *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::vec *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__vec, 1, 0);
  }
  delete arg1;
  gswig_result = SCM_UNSPECIFIED;
  
  SWIG_Guile_MarkPointerDestroyed(s_0);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_vec_round_float (SCM s_0)
{
#define FUNC_NAME "meep-vec-round-float"
  meep::vec *arg1 = (meep::vec *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::vec result;
  
  {
    arg1 = (meep::vec *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__vec, 1, 0);
  }
  result = ((meep::vec const *)arg1)->round_float();
  {
    gswig_result = ctl_convert_vector3_to_scm(vec_to_vector3(result));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_vec_dim_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-vec-dim-set"
  meep::vec *arg1 = (meep::vec *) 0 ;
  meep::ndim arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::vec *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__vec, 1, 0);
  }
  {
    arg2 = (meep::ndim) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  if (arg1) (arg1)->dim = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_vec_dim_get (SCM s_0)
{
#define FUNC_NAME "meep-vec-dim-get"
  meep::vec *arg1 = (meep::vec *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::ndim result;
  
  {
    arg1 = (meep::vec *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__vec, 1, 0);
  }
  result = (meep::ndim) ((arg1)->dim);
  {
    gswig_result = scm_long2num(result); 
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_vec_r (SCM s_0)
{
#define FUNC_NAME "meep-vec-r"
  meep::vec *arg1 = (meep::vec *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::vec *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__vec, 1, 0);
  }
  result = (double)((meep::vec const *)arg1)->r();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_vec_x (SCM s_0)
{
#define FUNC_NAME "meep-vec-x"
  meep::vec *arg1 = (meep::vec *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::vec *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__vec, 1, 0);
  }
  result = (double)((meep::vec const *)arg1)->x();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_vec_y (SCM s_0)
{
#define FUNC_NAME "meep-vec-y"
  meep::vec *arg1 = (meep::vec *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::vec *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__vec, 1, 0);
  }
  result = (double)((meep::vec const *)arg1)->y();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_vec_z (SCM s_0)
{
#define FUNC_NAME "meep-vec-z"
  meep::vec *arg1 = (meep::vec *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::vec *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__vec, 1, 0);
  }
  result = (double)((meep::vec const *)arg1)->z();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_vec_in_direction (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-vec-in-direction"
  meep::vec *arg1 = (meep::vec *) 0 ;
  meep::direction arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::vec *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__vec, 1, 0);
  }
  {
    arg2 = (meep::direction) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = (double)((meep::vec const *)arg1)->in_direction(arg2);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_vec_set_direction (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-vec-set-direction"
  meep::vec *arg1 = (meep::vec *) 0 ;
  meep::direction arg2 ;
  double arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::vec *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__vec, 1, 0);
  }
  {
    arg2 = (meep::direction) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (double) scm_num2dbl(s_2, FUNC_NAME);
  }
  (arg1)->set_direction(arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_vec_project_to_boundary (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-vec-project-to-boundary"
  meep::vec *arg1 = (meep::vec *) 0 ;
  meep::direction arg2 ;
  double arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::vec *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__vec, 1, 0);
  }
  {
    arg2 = (meep::direction) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (double) scm_num2dbl(s_2, FUNC_NAME);
  }
  result = (double)(arg1)->project_to_boundary(arg2,arg3);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_one_vec (SCM s_0)
{
#define FUNC_NAME "meep-one-vec"
  meep::ndim arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::vec result;
  
  {
    arg1 = (meep::ndim) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  result = meep::one_vec(arg1);
  {
    gswig_result = ctl_convert_vector3_to_scm(vec_to_vector3(result));
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_abs (SCM s_0)
{
#define FUNC_NAME "meep-abs"
  meep::vec *arg1 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  
  meep::vec vec__arg1 = vector3_to_vec(ctl_convert_vector3_to_c(s_0));
  arg1 = &vec__arg1;
  
  result = (double)meep::abs((meep::vec const &)*arg1);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_unit_vec (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-unit-vec"
  meep::ndim arg1 ;
  meep::direction arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::vec result;
  
  {
    arg1 = (meep::ndim) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg2 = (meep::direction) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = meep::unit_vec(arg1,arg2);
  {
    gswig_result = ctl_convert_vector3_to_scm(vec_to_vector3(result));
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_clean_vec__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-clean-vec"
  meep::vec *arg1 = 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::vec result;
  
  
  meep::vec vec__arg1 = vector3_to_vec(ctl_convert_vector3_to_c(argv[0]));
  arg1 = &vec__arg1;
  
  {
    arg2 = (double) scm_num2dbl(argv[1], FUNC_NAME);
  }
  result = meep::clean_vec((meep::vec const &)*arg1,arg2);
  {
    gswig_result = ctl_convert_vector3_to_scm(vec_to_vector3(result));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_clean_vec__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-clean-vec"
  meep::vec *arg1 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::vec result;
  
  
  meep::vec vec__arg1 = vector3_to_vec(ctl_convert_vector3_to_c(argv[0]));
  arg1 = &vec__arg1;
  
  result = meep::clean_vec((meep::vec const &)*arg1);
  {
    gswig_result = ctl_convert_vector3_to_scm(vec_to_vector3(result));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_clean_vec(SCM rest)
{
#define FUNC_NAME "meep-clean-vec"
  SCM argv[2];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 2, "meep-clean-vec");
  if (argc == 1) {
    int _v;
    {
      _v = SwigVector3_Check(argv[0]);
    }
    if (_v) {
      return _wrap_meep_clean_vec__SWIG_1(argc,argv);
    }
  }
  if (argc == 2) {
    int _v;
    {
      _v = SwigVector3_Check(argv[0]);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_real_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        return _wrap_meep_clean_vec__SWIG_0(argc,argv);
      }
    }
  }
  
  scm_misc_error("meep-clean-vec", "No matching method for generic function `meep_clean_vec'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_iveccyl (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-iveccyl"
  int arg1 ;
  int arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::ivec result;
  
  {
    arg1 = (int) scm_num2int(s_0, SCM_ARG1, FUNC_NAME);
  }
  {
    arg2 = (int) scm_num2int(s_1, SCM_ARG1, FUNC_NAME);
  }
  result = meep::iveccyl(arg1,arg2);
  {
    meep::ivec * resultptr;
    resultptr = new meep::ivec((const meep::ivec &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__ivec, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_zero_ivec (SCM s_0)
{
#define FUNC_NAME "meep-zero-ivec"
  meep::ndim arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::ivec result;
  
  {
    arg1 = (meep::ndim) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  result = meep::zero_ivec(arg1);
  {
    meep::ivec * resultptr;
    resultptr = new meep::ivec((const meep::ivec &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__ivec, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_one_ivec (SCM s_0)
{
#define FUNC_NAME "meep-one-ivec"
  meep::ndim arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::ivec result;
  
  {
    arg1 = (meep::ndim) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  result = meep::one_ivec(arg1);
  {
    meep::ivec * resultptr;
    resultptr = new meep::ivec((const meep::ivec &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__ivec, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_ivec__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-ivec"
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::ivec *result = 0 ;
  
  result = (meep::ivec *)new meep::ivec();
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__ivec, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_ivec__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-ivec"
  meep::ndim arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::ivec *result = 0 ;
  
  {
    arg1 = (meep::ndim) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME); 
  }
  result = (meep::ivec *)new meep::ivec(arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__ivec, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_ivec__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-ivec"
  meep::ndim arg1 ;
  int arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::ivec *result = 0 ;
  
  {
    arg1 = (meep::ndim) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg2 = (int) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME);
  }
  result = (meep::ivec *)new meep::ivec(arg1,arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__ivec, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_ivec__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-ivec"
  int arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::ivec *result = 0 ;
  
  {
    arg1 = (int) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME);
  }
  result = (meep::ivec *)new meep::ivec(arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__ivec, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_ivec__SWIG_4 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-ivec"
  int arg1 ;
  int arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::ivec *result = 0 ;
  
  {
    arg1 = (int) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME);
  }
  {
    arg2 = (int) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME);
  }
  result = (meep::ivec *)new meep::ivec(arg1,arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__ivec, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_ivec__SWIG_5 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-ivec"
  int arg1 ;
  int arg2 ;
  int arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::ivec *result = 0 ;
  
  {
    arg1 = (int) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME);
  }
  {
    arg2 = (int) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME);
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  result = (meep::ivec *)new meep::ivec(arg1,arg2,arg3);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__ivec, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_ivec(SCM rest)
{
#define FUNC_NAME "new-meep-ivec"
  SCM argv[3];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "new-meep-ivec");
  if (argc == 0) {
    return _wrap_new_meep_ivec__SWIG_0(argc,argv);
  }
  if (argc == 1) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      return _wrap_new_meep_ivec__SWIG_1(argc,argv);
    }
  }
  if (argc == 1) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      return _wrap_new_meep_ivec__SWIG_3(argc,argv);
    }
  }
  if (argc == 2) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        return _wrap_new_meep_ivec__SWIG_2(argc,argv);
      }
    }
  }
  if (argc == 2) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        return _wrap_new_meep_ivec__SWIG_4(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_new_meep_ivec__SWIG_5(argc,argv);
        }
      }
    }
  }
  
  scm_misc_error("new-meep-ivec", "No matching method for generic function `new_meep_ivec'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_delete_meep_ivec (SCM s_0)
{
#define FUNC_NAME "delete-meep-ivec"
  meep::ivec *arg1 = (meep::ivec *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::ivec *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__ivec, 1, 0);
  }
  delete arg1;
  gswig_result = SCM_UNSPECIFIED;
  
  SWIG_Guile_MarkPointerDestroyed(s_0);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_ivec_yucky_val (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-ivec-yucky-val"
  meep::ivec *arg1 = (meep::ivec *) 0 ;
  int arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::ivec *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__ivec, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(s_1, SCM_ARG1, FUNC_NAME);
  }
  result = (int)((meep::ivec const *)arg1)->yucky_val(arg2);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_ivec_dim_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-ivec-dim-set"
  meep::ivec *arg1 = (meep::ivec *) 0 ;
  meep::ndim arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::ivec *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__ivec, 1, 0);
  }
  {
    arg2 = (meep::ndim) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  if (arg1) (arg1)->dim = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_ivec_dim_get (SCM s_0)
{
#define FUNC_NAME "meep-ivec-dim-get"
  meep::ivec *arg1 = (meep::ivec *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::ndim result;
  
  {
    arg1 = (meep::ivec *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__ivec, 1, 0);
  }
  result = (meep::ndim) ((arg1)->dim);
  {
    gswig_result = scm_long2num(result); 
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_ivec_r (SCM s_0)
{
#define FUNC_NAME "meep-ivec-r"
  meep::ivec *arg1 = (meep::ivec *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::ivec *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__ivec, 1, 0);
  }
  result = (int)((meep::ivec const *)arg1)->r();
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_ivec_x (SCM s_0)
{
#define FUNC_NAME "meep-ivec-x"
  meep::ivec *arg1 = (meep::ivec *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::ivec *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__ivec, 1, 0);
  }
  result = (int)((meep::ivec const *)arg1)->x();
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_ivec_y (SCM s_0)
{
#define FUNC_NAME "meep-ivec-y"
  meep::ivec *arg1 = (meep::ivec *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::ivec *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__ivec, 1, 0);
  }
  result = (int)((meep::ivec const *)arg1)->y();
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_ivec_z (SCM s_0)
{
#define FUNC_NAME "meep-ivec-z"
  meep::ivec *arg1 = (meep::ivec *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::ivec *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__ivec, 1, 0);
  }
  result = (int)((meep::ivec const *)arg1)->z();
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_ivec_in_direction (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-ivec-in-direction"
  meep::ivec *arg1 = (meep::ivec *) 0 ;
  meep::direction arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::ivec *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__ivec, 1, 0);
  }
  {
    arg2 = (meep::direction) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = (int)((meep::ivec const *)arg1)->in_direction(arg2);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_ivec_set_direction (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-ivec-set-direction"
  meep::ivec *arg1 = (meep::ivec *) 0 ;
  meep::direction arg2 ;
  int arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::ivec *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__ivec, 1, 0);
  }
  {
    arg2 = (meep::direction) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (int) scm_num2int(s_2, SCM_ARG1, FUNC_NAME);
  }
  (arg1)->set_direction(arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_ivec_round_up_to_even (SCM s_0)
{
#define FUNC_NAME "meep-ivec-round-up-to-even"
  meep::ivec *arg1 = (meep::ivec *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::ivec result;
  
  {
    arg1 = (meep::ivec *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__ivec, 1, 0);
  }
  result = ((meep::ivec const *)arg1)->round_up_to_even();
  {
    meep::ivec * resultptr;
    resultptr = new meep::ivec((const meep::ivec &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__ivec, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_unit_ivec (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-unit-ivec"
  meep::ndim arg1 ;
  meep::direction arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::ivec result;
  
  {
    arg1 = (meep::ndim) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg2 = (meep::direction) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = meep::unit_ivec(arg1,arg2);
  {
    meep::ivec * resultptr;
    resultptr = new meep::ivec((const meep::ivec &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__ivec, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_max__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-max"
  meep::vec *arg1 = 0 ;
  meep::vec *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::vec result;
  
  
  meep::vec vec__arg1 = vector3_to_vec(ctl_convert_vector3_to_c(argv[0]));
  arg1 = &vec__arg1;
  
  
  meep::vec vec__arg2 = vector3_to_vec(ctl_convert_vector3_to_c(argv[1]));
  arg2 = &vec__arg2;
  
  result = meep::max((meep::vec const &)*arg1,(meep::vec const &)*arg2);
  {
    gswig_result = ctl_convert_vector3_to_scm(vec_to_vector3(result));
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_min__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-min"
  meep::vec *arg1 = 0 ;
  meep::vec *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::vec result;
  
  
  meep::vec vec__arg1 = vector3_to_vec(ctl_convert_vector3_to_c(argv[0]));
  arg1 = &vec__arg1;
  
  
  meep::vec vec__arg2 = vector3_to_vec(ctl_convert_vector3_to_c(argv[1]));
  arg2 = &vec__arg2;
  
  result = meep::min((meep::vec const &)*arg1,(meep::vec const &)*arg2);
  {
    gswig_result = ctl_convert_vector3_to_scm(vec_to_vector3(result));
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_max__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-max"
  meep::ivec *arg1 = 0 ;
  meep::ivec *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::ivec result;
  
  {
    arg1 = (meep::ivec *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__ivec, 1, 0);
  }
  {
    arg2 = (meep::ivec *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__ivec, 2, 0);
  }
  result = meep::max((meep::ivec const &)*arg1,(meep::ivec const &)*arg2);
  {
    meep::ivec * resultptr;
    resultptr = new meep::ivec((const meep::ivec &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__ivec, 1);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_max(SCM rest)
{
#define FUNC_NAME "meep-max"
  SCM argv[2];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 2, "meep-max");
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__ivec, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__ivec, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_meep_max__SWIG_1(argc,argv);
      }
    }
  }
  if (argc == 2) {
    int _v;
    {
      _v = SwigVector3_Check(argv[0]);
    }
    if (_v) {
      {
        _v = SwigVector3_Check(argv[1]);
      }
      if (_v) {
        return _wrap_meep_max__SWIG_0(argc,argv);
      }
    }
  }
  
  scm_misc_error("meep-max", "No matching method for generic function `meep_max'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_min__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-min"
  meep::ivec *arg1 = 0 ;
  meep::ivec *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::ivec result;
  
  {
    arg1 = (meep::ivec *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__ivec, 1, 0);
  }
  {
    arg2 = (meep::ivec *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__ivec, 2, 0);
  }
  result = meep::min((meep::ivec const &)*arg1,(meep::ivec const &)*arg2);
  {
    meep::ivec * resultptr;
    resultptr = new meep::ivec((const meep::ivec &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__ivec, 1);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_min(SCM rest)
{
#define FUNC_NAME "meep-min"
  SCM argv[2];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 2, "meep-min");
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__ivec, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__ivec, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_meep_min__SWIG_1(argc,argv);
      }
    }
  }
  if (argc == 2) {
    int _v;
    {
      _v = SwigVector3_Check(argv[0]);
    }
    if (_v) {
      {
        _v = SwigVector3_Check(argv[1]);
      }
      if (_v) {
        return _wrap_meep_min__SWIG_0(argc,argv);
      }
    }
  }
  
  scm_misc_error("meep-min", "No matching method for generic function `meep_min'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_max_to_all__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-max-to-all"
  meep::ivec *arg1 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::ivec result;
  
  {
    arg1 = (meep::ivec *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__ivec, 1, 0);
  }
  result = meep::max_to_all((meep::ivec const &)*arg1);
  {
    meep::ivec * resultptr;
    resultptr = new meep::ivec((const meep::ivec &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__ivec, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_volume_dim_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-volume-dim-set"
  meep::volume *arg1 = (meep::volume *) 0 ;
  meep::ndim arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__volume, 1, 0);
  }
  {
    arg2 = (meep::ndim) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  if (arg1) (arg1)->dim = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_volume_dim_get (SCM s_0)
{
#define FUNC_NAME "meep-volume-dim-get"
  meep::volume *arg1 = (meep::volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::ndim result;
  
  {
    arg1 = (meep::volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__volume, 1, 0);
  }
  result = (meep::ndim) ((arg1)->dim);
  {
    gswig_result = scm_long2num(result); 
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_volume__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-volume"
  meep::ndim arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::volume *result = 0 ;
  
  {
    arg1 = (meep::ndim) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME); 
  }
  result = (meep::volume *)new meep::volume(arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__volume, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_volume__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-volume"
  meep::vec *arg1 = 0 ;
  meep::vec *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::volume *result = 0 ;
  
  
  meep::vec vec__arg1 = vector3_to_vec(ctl_convert_vector3_to_c(argv[0]));
  arg1 = &vec__arg1;
  
  
  meep::vec vec__arg2 = vector3_to_vec(ctl_convert_vector3_to_c(argv[1]));
  arg2 = &vec__arg2;
  
  result = (meep::volume *)new meep::volume((meep::vec const &)*arg1,(meep::vec const &)*arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__volume, 1);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_volume__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-volume"
  meep::vec *arg1 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::volume *result = 0 ;
  
  
  meep::vec vec__arg1 = vector3_to_vec(ctl_convert_vector3_to_c(argv[0]));
  arg1 = &vec__arg1;
  
  result = (meep::volume *)new meep::volume((meep::vec const &)*arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__volume, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_volume(SCM rest)
{
#define FUNC_NAME "new-meep-volume"
  SCM argv[2];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 2, "new-meep-volume");
  if (argc == 1) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      return _wrap_new_meep_volume__SWIG_0(argc,argv);
    }
  }
  if (argc == 1) {
    int _v;
    {
      _v = SwigVector3_Check(argv[0]);
    }
    if (_v) {
      return _wrap_new_meep_volume__SWIG_2(argc,argv);
    }
  }
  if (argc == 2) {
    int _v;
    {
      _v = SwigVector3_Check(argv[0]);
    }
    if (_v) {
      {
        _v = SwigVector3_Check(argv[1]);
      }
      if (_v) {
        return _wrap_new_meep_volume__SWIG_1(argc,argv);
      }
    }
  }
  
  scm_misc_error("new-meep-volume", "No matching method for generic function `new_meep_volume'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_volume_set_direction_min (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-volume-set-direction-min"
  meep::volume *arg1 = (meep::volume *) 0 ;
  meep::direction arg2 ;
  double arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__volume, 1, 0);
  }
  {
    arg2 = (meep::direction) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (double) scm_num2dbl(s_2, FUNC_NAME);
  }
  (arg1)->set_direction_min(arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_volume_set_direction_max (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-volume-set-direction-max"
  meep::volume *arg1 = (meep::volume *) 0 ;
  meep::direction arg2 ;
  double arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__volume, 1, 0);
  }
  {
    arg2 = (meep::direction) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (double) scm_num2dbl(s_2, FUNC_NAME);
  }
  (arg1)->set_direction_max(arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_volume_in_direction_min (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-volume-in-direction-min"
  meep::volume *arg1 = (meep::volume *) 0 ;
  meep::direction arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__volume, 1, 0);
  }
  {
    arg2 = (meep::direction) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = (double)((meep::volume const *)arg1)->in_direction_min(arg2);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_volume_in_direction_max (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-volume-in-direction-max"
  meep::volume *arg1 = (meep::volume *) 0 ;
  meep::direction arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__volume, 1, 0);
  }
  {
    arg2 = (meep::direction) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = (double)((meep::volume const *)arg1)->in_direction_max(arg2);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_volume_in_direction (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-volume-in-direction"
  meep::volume *arg1 = (meep::volume *) 0 ;
  meep::direction arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__volume, 1, 0);
  }
  {
    arg2 = (meep::direction) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = (double)((meep::volume const *)arg1)->in_direction(arg2);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_volume_computational_volume (SCM s_0)
{
#define FUNC_NAME "meep-volume-computational-volume"
  meep::volume *arg1 = (meep::volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__volume, 1, 0);
  }
  result = (double)((meep::volume const *)arg1)->computational_volume();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_volume_integral_volume (SCM s_0)
{
#define FUNC_NAME "meep-volume-integral-volume"
  meep::volume *arg1 = (meep::volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__volume, 1, 0);
  }
  result = (double)((meep::volume const *)arg1)->integral_volume();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_volume_full_volume (SCM s_0)
{
#define FUNC_NAME "meep-volume-full-volume"
  meep::volume *arg1 = (meep::volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__volume, 1, 0);
  }
  result = (double)((meep::volume const *)arg1)->full_volume();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_volume_center (SCM s_0)
{
#define FUNC_NAME "meep-volume-center"
  meep::volume *arg1 = (meep::volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::vec result;
  
  {
    arg1 = (meep::volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__volume, 1, 0);
  }
  result = ((meep::volume const *)arg1)->center();
  {
    gswig_result = ctl_convert_vector3_to_scm(vec_to_vector3(result));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_volume_diameter (SCM s_0)
{
#define FUNC_NAME "meep-volume-diameter"
  meep::volume *arg1 = (meep::volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__volume, 1, 0);
  }
  result = (double)((meep::volume const *)arg1)->diameter();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_volume_contains__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-volume-contains"
  meep::volume *arg1 = (meep::volume *) 0 ;
  meep::vec *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__volume, 1, 0);
  }
  
  meep::vec vec__arg2 = vector3_to_vec(ctl_convert_vector3_to_c(argv[1]));
  arg2 = &vec__arg2;
  
  result = (bool)((meep::volume const *)arg1)->contains((meep::vec const &)*arg2);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_volume_contains__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-volume-contains"
  meep::volume *arg1 = (meep::volume *) 0 ;
  meep::volume *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__volume, 1, 0);
  }
  {
    arg2 = (meep::volume *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__volume, 2, 0);
  }
  result = (bool)((meep::volume const *)arg1)->contains((meep::volume const &)*arg2);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_volume_contains(SCM rest)
{
#define FUNC_NAME "meep-volume-contains"
  SCM argv[2];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 2, "meep-volume-contains");
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__volume, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_meep_volume_contains__SWIG_1(argc,argv);
      }
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SwigVector3_Check(argv[1]);
      }
      if (_v) {
        return _wrap_meep_volume_contains__SWIG_0(argc,argv);
      }
    }
  }
  
  scm_misc_error("meep-volume-contains", "No matching method for generic function `meep_volume_contains'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_volume_intersect_with (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-volume-intersect-with"
  meep::volume *arg1 = (meep::volume *) 0 ;
  meep::volume *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  SwigValueWrapper< meep::volume > result;
  
  {
    arg1 = (meep::volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__volume, 1, 0);
  }
  {
    arg2 = (meep::volume *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__volume, 2, 0);
  }
  result = ((meep::volume const *)arg1)->intersect_with((meep::volume const &)*arg2);
  {
    meep::volume * resultptr;
    resultptr = new meep::volume((const meep::volume &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__volume, 1);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_volume_round_float (SCM s_0)
{
#define FUNC_NAME "meep-volume-round-float"
  meep::volume *arg1 = (meep::volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  SwigValueWrapper< meep::volume > result;
  
  {
    arg1 = (meep::volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__volume, 1, 0);
  }
  result = ((meep::volume const *)arg1)->round_float();
  {
    meep::volume * resultptr;
    resultptr = new meep::volume((const meep::volume &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__volume, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_volume_intersects (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-volume-intersects"
  meep::volume *arg1 = (meep::volume *) 0 ;
  meep::volume *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__volume, 1, 0);
  }
  {
    arg2 = (meep::volume *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__volume, 2, 0);
  }
  result = (bool)((meep::volume const *)arg1)->intersects((meep::volume const &)*arg2);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_volume_get_min_corner (SCM s_0)
{
#define FUNC_NAME "meep-volume-get-min-corner"
  meep::volume *arg1 = (meep::volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::vec result;
  
  {
    arg1 = (meep::volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__volume, 1, 0);
  }
  result = ((meep::volume const *)arg1)->get_min_corner();
  {
    gswig_result = ctl_convert_vector3_to_scm(vec_to_vector3(result));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_volume_get_max_corner (SCM s_0)
{
#define FUNC_NAME "meep-volume-get-max-corner"
  meep::volume *arg1 = (meep::volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::vec result;
  
  {
    arg1 = (meep::volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__volume, 1, 0);
  }
  result = ((meep::volume const *)arg1)->get_max_corner();
  {
    gswig_result = ctl_convert_vector3_to_scm(vec_to_vector3(result));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_volume_normal_direction (SCM s_0)
{
#define FUNC_NAME "meep-volume-normal-direction"
  meep::volume *arg1 = (meep::volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::direction result;
  
  {
    arg1 = (meep::volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__volume, 1, 0);
  }
  result = (meep::direction)((meep::volume const *)arg1)->normal_direction();
  {
    gswig_result = scm_long2num(result); 
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_delete_meep_volume (SCM s_0)
{
#define FUNC_NAME "delete-meep-volume"
  meep::volume *arg1 = (meep::volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__volume, 1, 0);
  }
  delete arg1;
  gswig_result = SCM_UNSPECIFIED;
  
  SWIG_Guile_MarkPointerDestroyed(s_0);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_volcyl (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-volcyl"
  double arg1 ;
  double arg2 ;
  double arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::grid_volume result;
  
  {
    arg1 = (double) scm_num2dbl(s_0, FUNC_NAME);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  {
    arg3 = (double) scm_num2dbl(s_2, FUNC_NAME);
  }
  result = meep::volcyl(arg1,arg2,arg3);
  {
    meep::grid_volume * resultptr;
    resultptr = new meep::grid_volume((const meep::grid_volume &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__grid_volume, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_volone (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-volone"
  double arg1 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::grid_volume result;
  
  {
    arg1 = (double) scm_num2dbl(s_0, FUNC_NAME);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  result = meep::volone(arg1,arg2);
  {
    meep::grid_volume * resultptr;
    resultptr = new meep::grid_volume((const meep::grid_volume &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__grid_volume, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_vol1d (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-vol1d"
  double arg1 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::grid_volume result;
  
  {
    arg1 = (double) scm_num2dbl(s_0, FUNC_NAME);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  result = meep::vol1d(arg1,arg2);
  {
    meep::grid_volume * resultptr;
    resultptr = new meep::grid_volume((const meep::grid_volume &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__grid_volume, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_voltwo (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-voltwo"
  double arg1 ;
  double arg2 ;
  double arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::grid_volume result;
  
  {
    arg1 = (double) scm_num2dbl(s_0, FUNC_NAME);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  {
    arg3 = (double) scm_num2dbl(s_2, FUNC_NAME);
  }
  result = meep::voltwo(arg1,arg2,arg3);
  {
    meep::grid_volume * resultptr;
    resultptr = new meep::grid_volume((const meep::grid_volume &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__grid_volume, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_vol2d (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-vol2d"
  double arg1 ;
  double arg2 ;
  double arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::grid_volume result;
  
  {
    arg1 = (double) scm_num2dbl(s_0, FUNC_NAME);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  {
    arg3 = (double) scm_num2dbl(s_2, FUNC_NAME);
  }
  result = meep::vol2d(arg1,arg2,arg3);
  {
    meep::grid_volume * resultptr;
    resultptr = new meep::grid_volume((const meep::grid_volume &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__grid_volume, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_vol3d (SCM s_0, SCM s_1, SCM s_2, SCM s_3)
{
#define FUNC_NAME "meep-vol3d"
  double arg1 ;
  double arg2 ;
  double arg3 ;
  double arg4 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::grid_volume result;
  
  {
    arg1 = (double) scm_num2dbl(s_0, FUNC_NAME);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  {
    arg3 = (double) scm_num2dbl(s_2, FUNC_NAME);
  }
  {
    arg4 = (double) scm_num2dbl(s_3, FUNC_NAME);
  }
  result = meep::vol3d(arg1,arg2,arg3,arg4);
  {
    meep::grid_volume * resultptr;
    resultptr = new meep::grid_volume((const meep::grid_volume &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__grid_volume, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_grid_volume ()
{
#define FUNC_NAME "new-meep-grid-volume"
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::grid_volume *result = 0 ;
  
  result = (meep::grid_volume *)new meep::grid_volume();
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__grid_volume, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_dim_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-grid-volume-dim-set"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::ndim arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::ndim) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  if (arg1) (arg1)->dim = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_dim_get (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-dim-get"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::ndim result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  result = (meep::ndim) ((arg1)->dim);
  {
    gswig_result = scm_long2num(result); 
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_a_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-grid-volume-a-set"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  if (arg1) (arg1)->a = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_a_get (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-a-get"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  result = (double) ((arg1)->a);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_inva_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-grid-volume-inva-set"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  if (arg1) (arg1)->inva = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_inva_get (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-inva-get"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  result = (double) ((arg1)->inva);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_print (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-print"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  ((meep::grid_volume const *)arg1)->print();
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_stride (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-grid-volume-stride"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::direction arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::direction) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = (int)((meep::grid_volume const *)arg1)->stride(arg2);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_num_direction (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-grid-volume-num-direction"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::direction arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::direction) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = (int)((meep::grid_volume const *)arg1)->num_direction(arg2);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_yucky_num (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-grid-volume-yucky-num"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  int arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(s_1, SCM_ARG1, FUNC_NAME);
  }
  result = (int)((meep::grid_volume const *)arg1)->yucky_num(arg2);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_yucky_direction (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-grid-volume-yucky-direction"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  int arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::direction result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(s_1, SCM_ARG1, FUNC_NAME);
  }
  result = (meep::direction)((meep::grid_volume const *)arg1)->yucky_direction(arg2);
  {
    gswig_result = scm_long2num(result); 
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_set_num_direction (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-grid-volume-set-num-direction"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::direction arg2 ;
  int arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::direction) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (int) scm_num2int(s_2, SCM_ARG1, FUNC_NAME);
  }
  (arg1)->set_num_direction(arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_nr (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-nr"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  result = (int)((meep::grid_volume const *)arg1)->nr();
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_nx (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-nx"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  result = (int)((meep::grid_volume const *)arg1)->nx();
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_ny (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-ny"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  result = (int)((meep::grid_volume const *)arg1)->ny();
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_nz (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-nz"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  result = (int)((meep::grid_volume const *)arg1)->nz();
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_has_field (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-grid-volume-has-field"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::component arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = (bool)((meep::grid_volume const *)arg1)->has_field(arg2);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_has_boundary (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-grid-volume-has-boundary"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::boundary_side arg2 ;
  meep::direction arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::boundary_side) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::direction) scm_num2int(s_2, SCM_ARG1, FUNC_NAME); 
  }
  result = (int)((meep::grid_volume const *)arg1)->has_boundary(arg2,arg3);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_dr (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-dr"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::vec result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  result = ((meep::grid_volume const *)arg1)->dr();
  {
    gswig_result = ctl_convert_vector3_to_scm(vec_to_vector3(result));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_dx (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-dx"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::vec result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  result = ((meep::grid_volume const *)arg1)->dx();
  {
    gswig_result = ctl_convert_vector3_to_scm(vec_to_vector3(result));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_dy (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-dy"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::vec result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  result = ((meep::grid_volume const *)arg1)->dy();
  {
    gswig_result = ctl_convert_vector3_to_scm(vec_to_vector3(result));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_dz (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-dz"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::vec result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  result = ((meep::grid_volume const *)arg1)->dz();
  {
    gswig_result = ctl_convert_vector3_to_scm(vec_to_vector3(result));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_ntot (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-ntot"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  result = (int)((meep::grid_volume const *)arg1)->ntot();
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_nowned_min (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-nowned-min"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  result = (int)((meep::grid_volume const *)arg1)->nowned_min();
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_nowned (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-grid-volume-nowned"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::component arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = (int)((meep::grid_volume const *)arg1)->nowned(arg2);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_index (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-grid-volume-index"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::component arg2 ;
  meep::ivec *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::ivec *)SWIG_MustGetPtr(s_2, SWIGTYPE_p_meep__ivec, 3, 0);
  }
  result = (int)((meep::grid_volume const *)arg1)->index(arg2,(meep::ivec const &)*arg3);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_round_vec (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-grid-volume-round-vec"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::vec *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::ivec result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  
  meep::vec vec__arg2 = vector3_to_vec(ctl_convert_vector3_to_c(s_1));
  arg2 = &vec__arg2;
  
  result = ((meep::grid_volume const *)arg1)->round_vec((meep::vec const &)*arg2);
  {
    meep::ivec * resultptr;
    resultptr = new meep::ivec((const meep::ivec &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__ivec, 1);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_interpolate__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-grid-volume-interpolate"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::component arg2 ;
  meep::vec *arg3 = 0 ;
  int *arg4 ;
  double *arg5 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  
  meep::vec vec__arg3 = vector3_to_vec(ctl_convert_vector3_to_c(argv[2]));
  arg3 = &vec__arg3;
  
  {
    arg4 = (int *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_int, 4, 0);
  }
  {
    arg5 = (double *)SWIG_MustGetPtr(argv[4], SWIGTYPE_p_double, 5, 0);
  }
  ((meep::grid_volume const *)arg1)->interpolate(arg2,(meep::vec const &)*arg3,arg4,arg5);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_interpolate__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-grid-volume-interpolate"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::component arg2 ;
  meep::vec *arg3 = 0 ;
  meep::ivec *arg4 ;
  double *arg5 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  
  meep::vec vec__arg3 = vector3_to_vec(ctl_convert_vector3_to_c(argv[2]));
  arg3 = &vec__arg3;
  
  {
    arg4 = (meep::ivec *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__ivec, 4, 0);
  }
  {
    arg5 = (double *)SWIG_MustGetPtr(argv[4], SWIGTYPE_p_double, 5, 0);
  }
  ((meep::grid_volume const *)arg1)->interpolate(arg2,(meep::vec const &)*arg3,arg4,arg5);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_interpolate(SCM rest)
{
#define FUNC_NAME "meep-grid-volume-interpolate"
  SCM argv[5];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 5, "meep-grid-volume-interpolate");
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SwigVector3_Check(argv[2]);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_int, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              void *ptr;
              int res = SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_double, 0);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              return _wrap_meep_grid_volume_interpolate__SWIG_0(argc,argv);
            }
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SwigVector3_Check(argv[2]);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__ivec, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              void *ptr;
              int res = SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_double, 0);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              return _wrap_meep_grid_volume_interpolate__SWIG_1(argc,argv);
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-grid-volume-interpolate", "No matching method for generic function `meep_grid_volume_interpolate'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_dV__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-grid-volume-dV"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::component arg2 ;
  int arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  SwigValueWrapper< meep::volume > result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  result = ((meep::grid_volume const *)arg1)->dV(arg2,arg3);
  {
    meep::volume * resultptr;
    resultptr = new meep::volume((const meep::volume &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__volume, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_dV__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-grid-volume-dV"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::ivec *arg2 = 0 ;
  double arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  SwigValueWrapper< meep::volume > result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::ivec *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__ivec, 2, 0);
  }
  {
    arg3 = (double) scm_num2dbl(argv[2], FUNC_NAME);
  }
  result = ((meep::grid_volume const *)arg1)->dV((meep::ivec const &)*arg2,arg3);
  {
    meep::volume * resultptr;
    resultptr = new meep::volume((const meep::volume &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__volume, 1);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_dV__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-grid-volume-dV"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::ivec *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  SwigValueWrapper< meep::volume > result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::ivec *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__ivec, 2, 0);
  }
  result = ((meep::grid_volume const *)arg1)->dV((meep::ivec const &)*arg2);
  {
    meep::volume * resultptr;
    resultptr = new meep::volume((const meep::volume &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__volume, 1);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_dV(SCM rest)
{
#define FUNC_NAME "meep-grid-volume-dV"
  SCM argv[3];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "meep-grid-volume-dV");
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__ivec, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_meep_grid_volume_dV__SWIG_2(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__ivec, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_real_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_grid_volume_dV__SWIG_1(argc,argv);
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_grid_volume_dV__SWIG_0(argc,argv);
        }
      }
    }
  }
  
  scm_misc_error("meep-grid-volume-dV", "No matching method for generic function `meep_grid_volume_dV'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_intersect_with__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-grid-volume-intersect-with"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::grid_volume *arg2 = 0 ;
  meep::grid_volume *arg3 = (meep::grid_volume *) 0 ;
  meep::grid_volume *arg4 = (meep::grid_volume *) 0 ;
  int *arg5 = (int *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::grid_volume *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__grid_volume, 2, 0);
  }
  {
    arg3 = (meep::grid_volume *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__grid_volume, 3, 0);
  }
  {
    arg4 = (meep::grid_volume *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__grid_volume, 4, 0);
  }
  {
    arg5 = (int *)SWIG_MustGetPtr(argv[4], SWIGTYPE_p_int, 5, 0);
  }
  result = (bool)((meep::grid_volume const *)arg1)->intersect_with((meep::grid_volume const &)*arg2,arg3,arg4,arg5);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_intersect_with__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-grid-volume-intersect-with"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::grid_volume *arg2 = 0 ;
  meep::grid_volume *arg3 = (meep::grid_volume *) 0 ;
  meep::grid_volume *arg4 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::grid_volume *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__grid_volume, 2, 0);
  }
  {
    arg3 = (meep::grid_volume *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__grid_volume, 3, 0);
  }
  {
    arg4 = (meep::grid_volume *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__grid_volume, 4, 0);
  }
  result = (bool)((meep::grid_volume const *)arg1)->intersect_with((meep::grid_volume const &)*arg2,arg3,arg4);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_intersect_with__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-grid-volume-intersect-with"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::grid_volume *arg2 = 0 ;
  meep::grid_volume *arg3 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::grid_volume *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__grid_volume, 2, 0);
  }
  {
    arg3 = (meep::grid_volume *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__grid_volume, 3, 0);
  }
  result = (bool)((meep::grid_volume const *)arg1)->intersect_with((meep::grid_volume const &)*arg2,arg3);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_intersect_with__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-grid-volume-intersect-with"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::grid_volume *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::grid_volume *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__grid_volume, 2, 0);
  }
  result = (bool)((meep::grid_volume const *)arg1)->intersect_with((meep::grid_volume const &)*arg2);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_intersect_with(SCM rest)
{
#define FUNC_NAME "meep-grid-volume-intersect-with"
  SCM argv[5];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 5, "meep-grid-volume-intersect-with");
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_meep_grid_volume_intersect_with__SWIG_3(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_meep_grid_volume_intersect_with__SWIG_2(argc,argv);
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            return _wrap_meep_grid_volume_intersect_with__SWIG_1(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              void *ptr;
              int res = SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_int, 0);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              return _wrap_meep_grid_volume_intersect_with__SWIG_0(argc,argv);
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-grid-volume-intersect-with", "No matching method for generic function `meep_grid_volume_intersect_with'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_rmin (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-rmin"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  result = (double)((meep::grid_volume const *)arg1)->rmin();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_rmax (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-rmax"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  result = (double)((meep::grid_volume const *)arg1)->rmax();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_xmin (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-xmin"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  result = (double)((meep::grid_volume const *)arg1)->xmin();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_xmax (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-xmax"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  result = (double)((meep::grid_volume const *)arg1)->xmax();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_ymin (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-ymin"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  result = (double)((meep::grid_volume const *)arg1)->ymin();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_ymax (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-ymax"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  result = (double)((meep::grid_volume const *)arg1)->ymax();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_zmin (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-zmin"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  result = (double)((meep::grid_volume const *)arg1)->zmin();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_zmax (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-zmax"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  result = (double)((meep::grid_volume const *)arg1)->zmax();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_center (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-center"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::vec result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  result = ((meep::grid_volume const *)arg1)->center();
  {
    gswig_result = ctl_convert_vector3_to_scm(vec_to_vector3(result));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_icenter (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-icenter"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::ivec result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  result = ((meep::grid_volume const *)arg1)->icenter();
  {
    meep::ivec * resultptr;
    resultptr = new meep::ivec((const meep::ivec &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__ivec, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_loc (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-grid-volume-loc"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::component arg2 ;
  int arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::vec result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (int) scm_num2int(s_2, SCM_ARG1, FUNC_NAME);
  }
  result = ((meep::grid_volume const *)arg1)->loc(arg2,arg3);
  {
    gswig_result = ctl_convert_vector3_to_scm(vec_to_vector3(result));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_loc_at_resolution (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-grid-volume-loc-at-resolution"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  int arg2 ;
  double arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::vec result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(s_1, SCM_ARG1, FUNC_NAME);
  }
  {
    arg3 = (double) scm_num2dbl(s_2, FUNC_NAME);
  }
  result = ((meep::grid_volume const *)arg1)->loc_at_resolution(arg2,arg3);
  {
    gswig_result = ctl_convert_vector3_to_scm(vec_to_vector3(result));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_ntot_at_resolution (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-grid-volume-ntot-at-resolution"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  result = (int)((meep::grid_volume const *)arg1)->ntot_at_resolution(arg2);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_iloc (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-grid-volume-iloc"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::component arg2 ;
  int arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::ivec result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (int) scm_num2int(s_2, SCM_ARG1, FUNC_NAME);
  }
  result = ((meep::grid_volume const *)arg1)->iloc(arg2,arg3);
  {
    meep::ivec * resultptr;
    resultptr = new meep::ivec((const meep::ivec &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__ivec, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_yee_index (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-grid-volume-yee-index"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::component arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = (int)((meep::grid_volume const *)arg1)->yee_index(arg2);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_yee_shift (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-grid-volume-yee-shift"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::component arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::vec result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = ((meep::grid_volume const *)arg1)->yee_shift(arg2);
  {
    gswig_result = ctl_convert_vector3_to_scm(vec_to_vector3(result));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_eps_component (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-eps-component"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::component result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  result = (meep::component)((meep::grid_volume const *)arg1)->eps_component();
  {
    gswig_result = scm_long2num(result); 
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_yee2cent_offsets (SCM s_0, SCM s_1, SCM s_2, SCM s_3)
{
#define FUNC_NAME "meep-grid-volume-yee2cent-offsets"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::component arg2 ;
  int *arg3 = 0 ;
  int *arg4 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (int *)SWIG_MustGetPtr(s_2, SWIGTYPE_p_int, 3, 0);
  }
  {
    arg4 = (int *)SWIG_MustGetPtr(s_3, SWIGTYPE_p_int, 4, 0);
  }
  (arg1)->yee2cent_offsets(arg2,*arg3,*arg4);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_boundary_location (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-grid-volume-boundary-location"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::boundary_side arg2 ;
  meep::direction arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::boundary_side) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::direction) scm_num2int(s_2, SCM_ARG1, FUNC_NAME); 
  }
  result = (double)((meep::grid_volume const *)arg1)->boundary_location(arg2,arg3);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_big_corner (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-big-corner"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::ivec result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  result = ((meep::grid_volume const *)arg1)->big_corner();
  {
    meep::ivec * resultptr;
    resultptr = new meep::ivec((const meep::ivec &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__ivec, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_little_corner (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-little-corner"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::ivec result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  result = ((meep::grid_volume const *)arg1)->little_corner();
  {
    meep::ivec * resultptr;
    resultptr = new meep::ivec((const meep::ivec &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__ivec, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_corner (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-grid-volume-corner"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::boundary_side arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::vec result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::boundary_side) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = ((meep::grid_volume const *)arg1)->corner(arg2);
  {
    gswig_result = ctl_convert_vector3_to_scm(vec_to_vector3(result));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_contains__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-grid-volume-contains"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::vec *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  
  meep::vec vec__arg2 = vector3_to_vec(ctl_convert_vector3_to_c(argv[1]));
  arg2 = &vec__arg2;
  
  result = (bool)((meep::grid_volume const *)arg1)->contains((meep::vec const &)*arg2);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_contains__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-grid-volume-contains"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::ivec *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::ivec *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__ivec, 2, 0);
  }
  result = (bool)((meep::grid_volume const *)arg1)->contains((meep::ivec const &)*arg2);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_contains(SCM rest)
{
#define FUNC_NAME "meep-grid-volume-contains"
  SCM argv[2];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 2, "meep-grid-volume-contains");
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__ivec, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_meep_grid_volume_contains__SWIG_1(argc,argv);
      }
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SwigVector3_Check(argv[1]);
      }
      if (_v) {
        return _wrap_meep_grid_volume_contains__SWIG_0(argc,argv);
      }
    }
  }
  
  scm_misc_error("meep-grid-volume-contains", "No matching method for generic function `meep_grid_volume_contains'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_little_owned_corner0 (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-grid-volume-little-owned-corner0"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::component arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::ivec result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = ((meep::grid_volume const *)arg1)->little_owned_corner0(arg2);
  {
    meep::ivec * resultptr;
    resultptr = new meep::ivec((const meep::ivec &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__ivec, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_little_owned_corner (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-grid-volume-little-owned-corner"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::component arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::ivec result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = ((meep::grid_volume const *)arg1)->little_owned_corner(arg2);
  {
    meep::ivec * resultptr;
    resultptr = new meep::ivec((const meep::ivec &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__ivec, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_owns (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-grid-volume-owns"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::ivec *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::ivec *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__ivec, 2, 0);
  }
  result = (bool)((meep::grid_volume const *)arg1)->owns((meep::ivec const &)*arg2);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_surroundings (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-surroundings"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  SwigValueWrapper< meep::volume > result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  result = ((meep::grid_volume const *)arg1)->surroundings();
  {
    meep::volume * resultptr;
    resultptr = new meep::volume((const meep::volume &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__volume, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_interior (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-interior"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  SwigValueWrapper< meep::volume > result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  result = ((meep::grid_volume const *)arg1)->interior();
  {
    meep::volume * resultptr;
    resultptr = new meep::volume((const meep::volume &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__volume, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_get_boundary_icorners (SCM s_0, SCM s_1, SCM s_2, SCM s_3, SCM s_4)
{
#define FUNC_NAME "meep-grid-volume-get-boundary-icorners"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::component arg2 ;
  int arg3 ;
  meep::ivec *arg4 = (meep::ivec *) 0 ;
  meep::ivec *arg5 = (meep::ivec *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (int) scm_num2int(s_2, SCM_ARG1, FUNC_NAME);
  }
  {
    arg4 = (meep::ivec *)SWIG_MustGetPtr(s_3, SWIGTYPE_p_meep__ivec, 4, 0);
  }
  {
    arg5 = (meep::ivec *)SWIG_MustGetPtr(s_4, SWIGTYPE_p_meep__ivec, 5, 0);
  }
  result = (bool)((meep::grid_volume const *)arg1)->get_boundary_icorners(arg2,arg3,arg4,arg5);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_split (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-grid-volume-split"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  int arg2 ;
  int arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::grid_volume result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(s_1, SCM_ARG1, FUNC_NAME);
  }
  {
    arg3 = (int) scm_num2int(s_2, SCM_ARG1, FUNC_NAME);
  }
  result = ((meep::grid_volume const *)arg1)->split(arg2,arg3);
  {
    meep::grid_volume * resultptr;
    resultptr = new meep::grid_volume((const meep::grid_volume &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__grid_volume, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_split_by_effort__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-grid-volume-split-by-effort"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  meep::grid_volume *arg5 = (meep::grid_volume *) 0 ;
  double *arg6 = (double *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::grid_volume result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME);
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  {
    arg4 = (int) scm_num2int(argv[3], SCM_ARG1, FUNC_NAME);
  }
  {
    arg5 = (meep::grid_volume *)SWIG_MustGetPtr(argv[4], SWIGTYPE_p_meep__grid_volume, 5, 0);
  }
  {
    arg6 = (double *)SWIG_MustGetPtr(argv[5], SWIGTYPE_p_double, 6, 0);
  }
  result = ((meep::grid_volume const *)arg1)->split_by_effort(arg2,arg3,arg4,(meep::grid_volume const *)arg5,arg6);
  {
    meep::grid_volume * resultptr;
    resultptr = new meep::grid_volume((const meep::grid_volume &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__grid_volume, 1);
  }
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_split_by_effort__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-grid-volume-split-by-effort"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  meep::grid_volume *arg5 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::grid_volume result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME);
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  {
    arg4 = (int) scm_num2int(argv[3], SCM_ARG1, FUNC_NAME);
  }
  {
    arg5 = (meep::grid_volume *)SWIG_MustGetPtr(argv[4], SWIGTYPE_p_meep__grid_volume, 5, 0);
  }
  result = ((meep::grid_volume const *)arg1)->split_by_effort(arg2,arg3,arg4,(meep::grid_volume const *)arg5);
  {
    meep::grid_volume * resultptr;
    resultptr = new meep::grid_volume((const meep::grid_volume &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__grid_volume, 1);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_split_by_effort__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-grid-volume-split-by-effort"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::grid_volume result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME);
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  {
    arg4 = (int) scm_num2int(argv[3], SCM_ARG1, FUNC_NAME);
  }
  result = ((meep::grid_volume const *)arg1)->split_by_effort(arg2,arg3,arg4);
  {
    meep::grid_volume * resultptr;
    resultptr = new meep::grid_volume((const meep::grid_volume &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__grid_volume, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_split_by_effort__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-grid-volume-split-by-effort"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  int arg2 ;
  int arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::grid_volume result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME);
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  result = ((meep::grid_volume const *)arg1)->split_by_effort(arg2,arg3);
  {
    meep::grid_volume * resultptr;
    resultptr = new meep::grid_volume((const meep::grid_volume &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__grid_volume, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_split_by_effort(SCM rest)
{
#define FUNC_NAME "meep-grid-volume-split-by-effort"
  SCM argv[6];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 6, "meep-grid-volume-split-by-effort");
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_grid_volume_split_by_effort__SWIG_3(argc,argv);
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_integer_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            return _wrap_meep_grid_volume_split_by_effort__SWIG_2(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_integer_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            {
              void *ptr;
              int res = SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              return _wrap_meep_grid_volume_split_by_effort__SWIG_1(argc,argv);
            }
          }
        }
      }
    }
  }
  if (argc == 6) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_integer_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            {
              void *ptr;
              int res = SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              {
                void *ptr;
                int res = SWIG_ConvertPtr(argv[5], &ptr, SWIGTYPE_p_double, 0);
                _v = SWIG_CheckState(res);
              }
              if (_v) {
                return _wrap_meep_grid_volume_split_by_effort__SWIG_0(argc,argv);
              }
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-grid-volume-split-by-effort", "No matching method for generic function `meep_grid_volume_split_by_effort'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_split_at_fraction (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-grid-volume-split-at-fraction"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  bool arg2 ;
  int arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::grid_volume result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (bool) SCM_NFALSEP(s_1);
  }
  {
    arg3 = (int) scm_num2int(s_2, SCM_ARG1, FUNC_NAME);
  }
  result = ((meep::grid_volume const *)arg1)->split_at_fraction(arg2,arg3);
  {
    meep::grid_volume * resultptr;
    resultptr = new meep::grid_volume((const meep::grid_volume &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__grid_volume, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_halve (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-grid-volume-halve"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::direction arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::grid_volume result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::direction) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = ((meep::grid_volume const *)arg1)->halve(arg2);
  {
    meep::grid_volume * resultptr;
    resultptr = new meep::grid_volume((const meep::grid_volume &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__grid_volume, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_pad_self (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-grid-volume-pad-self"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::direction arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::direction) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  (arg1)->pad_self(arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_pad__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-grid-volume-pad"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::direction arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::grid_volume result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::direction) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  result = ((meep::grid_volume const *)arg1)->pad(arg2);
  {
    meep::grid_volume * resultptr;
    resultptr = new meep::grid_volume((const meep::grid_volume &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__grid_volume, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_pad__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-grid-volume-pad"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::grid_volume result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  result = ((meep::grid_volume const *)arg1)->pad();
  {
    meep::grid_volume * resultptr;
    resultptr = new meep::grid_volume((const meep::grid_volume &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__grid_volume, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_pad(SCM rest)
{
#define FUNC_NAME "meep-grid-volume-pad"
  SCM argv[2];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 2, "meep-grid-volume-pad");
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      return _wrap_meep_grid_volume_pad__SWIG_1(argc,argv);
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        return _wrap_meep_grid_volume_pad__SWIG_0(argc,argv);
      }
    }
  }
  
  scm_misc_error("meep-grid-volume-pad", "No matching method for generic function `meep_grid_volume_pad'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_iyee_shift (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-grid-volume-iyee-shift"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::component arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::ivec result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = ((meep::grid_volume const *)arg1)->iyee_shift(arg2);
  {
    meep::ivec * resultptr;
    resultptr = new meep::ivec((const meep::ivec &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__ivec, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_get_origin (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-get-origin"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::vec result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  result = ((meep::grid_volume const *)arg1)->get_origin();
  {
    gswig_result = ctl_convert_vector3_to_scm(vec_to_vector3(result));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_set_origin__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-grid-volume-set-origin"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::vec *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  
  meep::vec vec__arg2 = vector3_to_vec(ctl_convert_vector3_to_c(argv[1]));
  arg2 = &vec__arg2;
  
  (arg1)->set_origin((meep::vec const &)*arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_set_origin__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-grid-volume-set-origin"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::ivec *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::ivec *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__ivec, 2, 0);
  }
  (arg1)->set_origin((meep::ivec const &)*arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_shift_origin__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-grid-volume-shift-origin"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::vec *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  
  meep::vec vec__arg2 = vector3_to_vec(ctl_convert_vector3_to_c(argv[1]));
  arg2 = &vec__arg2;
  
  (arg1)->shift_origin((meep::vec const &)*arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_shift_origin__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-grid-volume-shift-origin"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::ivec *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::ivec *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__ivec, 2, 0);
  }
  (arg1)->shift_origin((meep::ivec const &)*arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_shift_origin__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-grid-volume-shift-origin"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::direction arg2 ;
  int arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::direction) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  (arg1)->shift_origin(arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_shift_origin(SCM rest)
{
#define FUNC_NAME "meep-grid-volume-shift-origin"
  SCM argv[3];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "meep-grid-volume-shift-origin");
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__ivec, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_meep_grid_volume_shift_origin__SWIG_1(argc,argv);
      }
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SwigVector3_Check(argv[1]);
      }
      if (_v) {
        return _wrap_meep_grid_volume_shift_origin__SWIG_0(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_grid_volume_shift_origin__SWIG_2(argc,argv);
        }
      }
    }
  }
  
  scm_misc_error("meep-grid-volume-shift-origin", "No matching method for generic function `meep_grid_volume_shift_origin'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_set_origin__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-grid-volume-set-origin"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::direction arg2 ;
  int arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::direction) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  (arg1)->set_origin(arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_set_origin(SCM rest)
{
#define FUNC_NAME "meep-grid-volume-set-origin"
  SCM argv[3];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "meep-grid-volume-set-origin");
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__ivec, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_meep_grid_volume_set_origin__SWIG_1(argc,argv);
      }
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SwigVector3_Check(argv[1]);
      }
      if (_v) {
        return _wrap_meep_grid_volume_set_origin__SWIG_0(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_grid_volume_set_origin__SWIG_2(argc,argv);
        }
      }
    }
  }
  
  scm_misc_error("meep-grid-volume-set-origin", "No matching method for generic function `meep_grid_volume_set_origin'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_center_origin (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-center-origin"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  (arg1)->center_origin();
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_origin_in_direction (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-grid-volume-origin-in-direction"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::direction arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::direction) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = (double)((meep::grid_volume const *)arg1)->origin_in_direction(arg2);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_iorigin_in_direction (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-grid-volume-iorigin-in-direction"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  meep::direction arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::direction) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = (int)((meep::grid_volume const *)arg1)->iorigin_in_direction(arg2);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_origin_r (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-origin-r"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  result = (double)((meep::grid_volume const *)arg1)->origin_r();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_origin_x (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-origin-x"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  result = (double)((meep::grid_volume const *)arg1)->origin_x();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_origin_y (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-origin-y"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  result = (double)((meep::grid_volume const *)arg1)->origin_y();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_grid_volume_origin_z (SCM s_0)
{
#define FUNC_NAME "meep-grid-volume-origin-z"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  result = (double)((meep::grid_volume const *)arg1)->origin_z();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_delete_meep_grid_volume (SCM s_0)
{
#define FUNC_NAME "delete-meep-grid-volume"
  meep::grid_volume *arg1 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  delete arg1;
  gswig_result = SCM_UNSPECIFIED;
  
  SWIG_Guile_MarkPointerDestroyed(s_0);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_identity ()
{
#define FUNC_NAME "meep-identity"
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::symmetry result;
  
  result = meep::identity();
  {
    meep::symmetry * resultptr;
    resultptr = new meep::symmetry((const meep::symmetry &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__symmetry, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_rotate4 (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-rotate4"
  meep::direction arg1 ;
  meep::grid_volume *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::symmetry result;
  
  {
    arg1 = (meep::direction) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg2 = (meep::grid_volume *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__grid_volume, 2, 0);
  }
  result = meep::rotate4(arg1,(meep::grid_volume const &)*arg2);
  {
    meep::symmetry * resultptr;
    resultptr = new meep::symmetry((const meep::symmetry &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__symmetry, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_rotate2 (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-rotate2"
  meep::direction arg1 ;
  meep::grid_volume *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::symmetry result;
  
  {
    arg1 = (meep::direction) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg2 = (meep::grid_volume *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__grid_volume, 2, 0);
  }
  result = meep::rotate2(arg1,(meep::grid_volume const &)*arg2);
  {
    meep::symmetry * resultptr;
    resultptr = new meep::symmetry((const meep::symmetry &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__symmetry, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_mirror (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-mirror"
  meep::direction arg1 ;
  meep::grid_volume *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::symmetry result;
  
  {
    arg1 = (meep::direction) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg2 = (meep::grid_volume *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__grid_volume, 2, 0);
  }
  result = meep::mirror(arg1,(meep::grid_volume const &)*arg2);
  {
    meep::symmetry * resultptr;
    resultptr = new meep::symmetry((const meep::symmetry &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__symmetry, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_r_to_minus_r_symmetry (SCM s_0)
{
#define FUNC_NAME "meep-r-to-minus-r-symmetry"
  double arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::symmetry result;
  
  {
    arg1 = (double) scm_num2dbl(s_0, FUNC_NAME);
  }
  result = meep::r_to_minus_r_symmetry(arg1);
  {
    meep::symmetry * resultptr;
    resultptr = new meep::symmetry((const meep::symmetry &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__symmetry, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_symmetry__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-symmetry"
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::symmetry *result = 0 ;
  
  result = (meep::symmetry *)new meep::symmetry();
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__symmetry, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_symmetry__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-symmetry"
  meep::symmetry *arg1 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::symmetry *result = 0 ;
  
  {
    arg1 = (meep::symmetry *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__symmetry, 1, 0);
  }
  result = (meep::symmetry *)new meep::symmetry((meep::symmetry const &)*arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__symmetry, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_symmetry(SCM rest)
{
#define FUNC_NAME "new-meep-symmetry"
  SCM argv[1];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 1, "new-meep-symmetry");
  if (argc == 0) {
    return _wrap_new_meep_symmetry__SWIG_0(argc,argv);
  }
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__symmetry, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      return _wrap_new_meep_symmetry__SWIG_1(argc,argv);
    }
  }
  
  scm_misc_error("new-meep-symmetry", "No matching method for generic function `new_meep_symmetry'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_delete_meep_symmetry (SCM s_0)
{
#define FUNC_NAME "delete-meep-symmetry"
  meep::symmetry *arg1 = (meep::symmetry *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::symmetry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__symmetry, 1, 0);
  }
  delete arg1;
  gswig_result = SCM_UNSPECIFIED;
  
  SWIG_Guile_MarkPointerDestroyed(s_0);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_symmetry_transform__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-symmetry-transform"
  meep::symmetry *arg1 = (meep::symmetry *) 0 ;
  meep::direction arg2 ;
  int arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::signed_direction result;
  
  {
    arg1 = (meep::symmetry *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__symmetry, 1, 0);
  }
  {
    arg2 = (meep::direction) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  result = ((meep::symmetry const *)arg1)->transform(arg2,arg3);
  {
    meep::signed_direction * resultptr;
    resultptr = new meep::signed_direction((const meep::signed_direction &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__signed_direction, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_symmetry_transform__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-symmetry-transform"
  meep::symmetry *arg1 = (meep::symmetry *) 0 ;
  meep::ivec *arg2 = 0 ;
  int arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::ivec result;
  
  {
    arg1 = (meep::symmetry *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__symmetry, 1, 0);
  }
  {
    arg2 = (meep::ivec *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__ivec, 2, 0);
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  result = ((meep::symmetry const *)arg1)->transform((meep::ivec const &)*arg2,arg3);
  {
    meep::ivec * resultptr;
    resultptr = new meep::ivec((const meep::ivec &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__ivec, 1);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_symmetry_transform__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-symmetry-transform"
  meep::symmetry *arg1 = (meep::symmetry *) 0 ;
  meep::vec *arg2 = 0 ;
  int arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::vec result;
  
  {
    arg1 = (meep::symmetry *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__symmetry, 1, 0);
  }
  
  meep::vec vec__arg2 = vector3_to_vec(ctl_convert_vector3_to_c(argv[1]));
  arg2 = &vec__arg2;
  
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  result = ((meep::symmetry const *)arg1)->transform((meep::vec const &)*arg2,arg3);
  {
    gswig_result = ctl_convert_vector3_to_scm(vec_to_vector3(result));
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_symmetry_transform_unshifted (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-symmetry-transform-unshifted"
  meep::symmetry *arg1 = (meep::symmetry *) 0 ;
  meep::ivec *arg2 = 0 ;
  int arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::ivec result;
  
  {
    arg1 = (meep::symmetry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__symmetry, 1, 0);
  }
  {
    arg2 = (meep::ivec *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__ivec, 2, 0);
  }
  {
    arg3 = (int) scm_num2int(s_2, SCM_ARG1, FUNC_NAME);
  }
  result = ((meep::symmetry const *)arg1)->transform_unshifted((meep::ivec const &)*arg2,arg3);
  {
    meep::ivec * resultptr;
    resultptr = new meep::ivec((const meep::ivec &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__ivec, 1);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_symmetry_transform__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-symmetry-transform"
  meep::symmetry *arg1 = (meep::symmetry *) 0 ;
  meep::volume *arg2 = 0 ;
  int arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  SwigValueWrapper< meep::volume > result;
  
  {
    arg1 = (meep::symmetry *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__symmetry, 1, 0);
  }
  {
    arg2 = (meep::volume *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__volume, 2, 0);
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  result = ((meep::symmetry const *)arg1)->transform((meep::volume const &)*arg2,arg3);
  {
    meep::volume * resultptr;
    resultptr = new meep::volume((const meep::volume &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__volume, 1);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_symmetry_transform__SWIG_4 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-symmetry-transform"
  meep::symmetry *arg1 = (meep::symmetry *) 0 ;
  meep::component arg2 ;
  int arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::component result;
  
  {
    arg1 = (meep::symmetry *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__symmetry, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  result = (meep::component)((meep::symmetry const *)arg1)->transform(arg2,arg3);
  {
    gswig_result = scm_long2num(result); 
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_symmetry_phase_shift__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-symmetry-phase-shift"
  meep::symmetry *arg1 = (meep::symmetry *) 0 ;
  meep::component arg2 ;
  int arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > result;
  
  {
    arg1 = (meep::symmetry *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__symmetry, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  result = ((meep::symmetry const *)arg1)->phase_shift(arg2,arg3);
  {
    gswig_result = scm_make_rectangular(scm_make_real((&result)->real()),
      scm_make_real((&result)->imag()));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_symmetry_transform__SWIG_5 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-symmetry-transform"
  meep::symmetry *arg1 = (meep::symmetry *) 0 ;
  meep::derived_component arg2 ;
  int arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::derived_component result;
  
  {
    arg1 = (meep::symmetry *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__symmetry, 1, 0);
  }
  {
    arg2 = (meep::derived_component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  result = (meep::derived_component)((meep::symmetry const *)arg1)->transform(arg2,arg3);
  {
    gswig_result = scm_long2num(result); 
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_symmetry_phase_shift__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-symmetry-phase-shift"
  meep::symmetry *arg1 = (meep::symmetry *) 0 ;
  meep::derived_component arg2 ;
  int arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > result;
  
  {
    arg1 = (meep::symmetry *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__symmetry, 1, 0);
  }
  {
    arg2 = (meep::derived_component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  result = ((meep::symmetry const *)arg1)->phase_shift(arg2,arg3);
  {
    gswig_result = scm_make_rectangular(scm_make_real((&result)->real()),
      scm_make_real((&result)->imag()));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_symmetry_transform__SWIG_6 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-symmetry-transform"
  meep::symmetry *arg1 = (meep::symmetry *) 0 ;
  int arg2 ;
  int arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::symmetry *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__symmetry, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME);
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  result = (int)((meep::symmetry const *)arg1)->transform(arg2,arg3);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_symmetry_transform(SCM rest)
{
#define FUNC_NAME "meep-symmetry-transform"
  SCM argv[3];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "meep-symmetry-transform");
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__symmetry, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__ivec, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_symmetry_transform__SWIG_1(argc,argv);
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__symmetry, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__volume, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_symmetry_transform__SWIG_3(argc,argv);
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__symmetry, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_symmetry_transform__SWIG_0(argc,argv);
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__symmetry, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_symmetry_transform__SWIG_4(argc,argv);
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__symmetry, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_symmetry_transform__SWIG_5(argc,argv);
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__symmetry, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_symmetry_transform__SWIG_6(argc,argv);
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__symmetry, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SwigVector3_Check(argv[1]);
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_symmetry_transform__SWIG_2(argc,argv);
        }
      }
    }
  }
  
  scm_misc_error("meep-symmetry-transform", "No matching method for generic function `meep_symmetry_transform'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_symmetry_phase_shift__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-symmetry-phase-shift"
  meep::symmetry *arg1 = (meep::symmetry *) 0 ;
  int arg2 ;
  int arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > result;
  
  {
    arg1 = (meep::symmetry *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__symmetry, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME);
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  result = ((meep::symmetry const *)arg1)->phase_shift(arg2,arg3);
  {
    gswig_result = scm_make_rectangular(scm_make_real((&result)->real()),
      scm_make_real((&result)->imag()));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_symmetry_phase_shift(SCM rest)
{
#define FUNC_NAME "meep-symmetry-phase-shift"
  SCM argv[3];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "meep-symmetry-phase-shift");
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__symmetry, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_symmetry_phase_shift__SWIG_0(argc,argv);
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__symmetry, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_symmetry_phase_shift__SWIG_1(argc,argv);
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__symmetry, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_symmetry_phase_shift__SWIG_2(argc,argv);
        }
      }
    }
  }
  
  scm_misc_error("meep-symmetry-phase-shift", "No matching method for generic function `meep_symmetry_phase_shift'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_symmetry_multiplicity (SCM s_0)
{
#define FUNC_NAME "meep-symmetry-multiplicity"
  meep::symmetry *arg1 = (meep::symmetry *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::symmetry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__symmetry, 1, 0);
  }
  result = (int)((meep::symmetry const *)arg1)->multiplicity();
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_symmetry_is_primitive (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-symmetry-is-primitive"
  meep::symmetry *arg1 = (meep::symmetry *) 0 ;
  meep::ivec *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::symmetry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__symmetry, 1, 0);
  }
  {
    arg2 = (meep::ivec *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__ivec, 2, 0);
  }
  result = (bool)((meep::symmetry const *)arg1)->is_primitive((meep::ivec const &)*arg2);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_symmetry_reduce (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-symmetry-reduce"
  meep::symmetry *arg1 = (meep::symmetry *) 0 ;
  meep::volume_list *arg2 = (meep::volume_list *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::volume_list *result = 0 ;
  
  {
    arg1 = (meep::symmetry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__symmetry, 1, 0);
  }
  {
    arg2 = (meep::volume_list *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__volume_list, 2, 0);
  }
  result = (meep::volume_list *)((meep::symmetry const *)arg1)->reduce((meep::volume_list const *)arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__volume_list, 0);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_symmetry_meep_symmetry_add (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-symmetry-meep-symmetry-add"
  meep::symmetry *arg1 = (meep::symmetry *) 0 ;
  meep::symmetry *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::symmetry result;
  
  {
    arg1 = (meep::symmetry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__symmetry, 1, 0);
  }
  {
    arg2 = (meep::symmetry *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__symmetry, 2, 0);
  }
  result = ((meep::symmetry const *)arg1)->operator +((meep::symmetry const &)*arg2);
  {
    meep::symmetry * resultptr;
    resultptr = new meep::symmetry((const meep::symmetry &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__symmetry, 1);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_symmetry_meep_symmetry_mul (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-symmetry-meep-symmetry-mul"
  meep::symmetry *arg1 = (meep::symmetry *) 0 ;
  complex< double > arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::symmetry result;
  
  {
    arg1 = (meep::symmetry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__symmetry, 1, 0);
  }
  {
    cnumber cnum = ctl_convert_cnumber_to_c(s_1);
    arg2 = std::complex<double>(cnum.re, cnum.im);
  }
  result = ((meep::symmetry const *)arg1)->operator *(arg2);
  {
    meep::symmetry * resultptr;
    resultptr = new meep::symmetry((const meep::symmetry &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__symmetry, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_symmetry_meep_symmetry_sub__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-symmetry-meep-symmetry-sub"
  meep::symmetry *arg1 = (meep::symmetry *) 0 ;
  meep::symmetry *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::symmetry result;
  
  {
    arg1 = (meep::symmetry *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__symmetry, 1, 0);
  }
  {
    arg2 = (meep::symmetry *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__symmetry, 2, 0);
  }
  result = ((meep::symmetry const *)arg1)->operator -((meep::symmetry const &)*arg2);
  {
    meep::symmetry * resultptr;
    resultptr = new meep::symmetry((const meep::symmetry &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__symmetry, 1);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_symmetry_meep_symmetry_sub__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-symmetry-meep-symmetry-sub"
  meep::symmetry *arg1 = (meep::symmetry *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::symmetry result;
  
  {
    arg1 = (meep::symmetry *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__symmetry, 1, 0);
  }
  result = ((meep::symmetry const *)arg1)->operator -();
  {
    meep::symmetry * resultptr;
    resultptr = new meep::symmetry((const meep::symmetry &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__symmetry, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_symmetry_meep_symmetry_sub(SCM rest)
{
#define FUNC_NAME "meep-symmetry-meep-symmetry-sub"
  SCM argv[2];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 2, "meep-symmetry-meep-symmetry-sub");
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__symmetry, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      return _wrap_meep_symmetry_meep_symmetry_sub__SWIG_1(argc,argv);
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__symmetry, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__symmetry, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_meep_symmetry_meep_symmetry_sub__SWIG_0(argc,argv);
      }
    }
  }
  
  scm_misc_error("meep-symmetry-meep-symmetry-sub", "No matching method for generic function `meep_symmetry_meep_symmetry_sub'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_symmetry_meep_symmetry_eq (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-symmetry-meep-symmetry-eq"
  meep::symmetry *arg1 = (meep::symmetry *) 0 ;
  meep::symmetry *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::symmetry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__symmetry, 1, 0);
  }
  {
    arg2 = (meep::symmetry *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__symmetry, 2, 0);
  }
  result = (bool)((meep::symmetry const *)arg1)->operator ==((meep::symmetry const &)*arg2);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_symmetry_meep_symmetry_neq (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-symmetry-meep-symmetry-neq"
  meep::symmetry *arg1 = (meep::symmetry *) 0 ;
  meep::symmetry *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::symmetry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__symmetry, 1, 0);
  }
  {
    arg2 = (meep::symmetry *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__symmetry, 2, 0);
  }
  result = (bool)((meep::symmetry const *)arg1)->operator !=((meep::symmetry const &)*arg2);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_volume_list__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-volume-list"
  meep::volume *arg1 = 0 ;
  int arg2 ;
  complex< double > arg3 ;
  meep::volume_list *arg4 = (meep::volume_list *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::volume_list *result = 0 ;
  
  {
    arg1 = (meep::volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__volume, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME);
  }
  {
    cnumber cnum = ctl_convert_cnumber_to_c(argv[2]);
    arg3 = std::complex<double>(cnum.re, cnum.im);
  }
  {
    arg4 = (meep::volume_list *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__volume_list, 4, 0);
  }
  result = (meep::volume_list *)new meep::volume_list((meep::volume const &)*arg1,arg2,arg3,arg4);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__volume_list, 1);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_volume_list__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-volume-list"
  meep::volume *arg1 = 0 ;
  int arg2 ;
  complex< double > arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::volume_list *result = 0 ;
  
  {
    arg1 = (meep::volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__volume, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME);
  }
  {
    cnumber cnum = ctl_convert_cnumber_to_c(argv[2]);
    arg3 = std::complex<double>(cnum.re, cnum.im);
  }
  result = (meep::volume_list *)new meep::volume_list((meep::volume const &)*arg1,arg2,arg3);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__volume_list, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_volume_list__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-volume-list"
  meep::volume *arg1 = 0 ;
  int arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::volume_list *result = 0 ;
  
  {
    arg1 = (meep::volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__volume, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME);
  }
  result = (meep::volume_list *)new meep::volume_list((meep::volume const &)*arg1,arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__volume_list, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_volume_list(SCM rest)
{
#define FUNC_NAME "new-meep-volume-list"
  SCM argv[4];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 4, "new-meep-volume-list");
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        return _wrap_new_meep_volume_list__SWIG_2(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SwigComplex_Check(argv[2]);
        }
        if (_v) {
          return _wrap_new_meep_volume_list__SWIG_1(argc,argv);
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SwigComplex_Check(argv[2]);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__volume_list, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            return _wrap_new_meep_volume_list__SWIG_0(argc,argv);
          }
        }
      }
    }
  }
  
  scm_misc_error("new-meep-volume-list", "No matching method for generic function `new_meep_volume_list'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_delete_meep_volume_list (SCM s_0)
{
#define FUNC_NAME "delete-meep-volume-list"
  meep::volume_list *arg1 = (meep::volume_list *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::volume_list *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__volume_list, 1, 0);
  }
  delete arg1;
  gswig_result = SCM_UNSPECIFIED;
  
  SWIG_Guile_MarkPointerDestroyed(s_0);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_volume_list_v_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-volume-list-v-set"
  meep::volume_list *arg1 = (meep::volume_list *) 0 ;
  meep::volume *arg2 = (meep::volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::volume_list *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__volume_list, 1, 0);
  }
  {
    arg2 = (meep::volume *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__volume, 2, 0);
  }
  if (arg1) (arg1)->v = *arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_volume_list_v_get (SCM s_0)
{
#define FUNC_NAME "meep-volume-list-v-get"
  meep::volume_list *arg1 = (meep::volume_list *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::volume *result = 0 ;
  
  {
    arg1 = (meep::volume_list *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__volume_list, 1, 0);
  }
  result = (meep::volume *)& ((arg1)->v);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__volume, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_volume_list_c_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-volume-list-c-set"
  meep::volume_list *arg1 = (meep::volume_list *) 0 ;
  int arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::volume_list *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__volume_list, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(s_1, SCM_ARG1, FUNC_NAME);
  }
  if (arg1) (arg1)->c = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_volume_list_c_get (SCM s_0)
{
#define FUNC_NAME "meep-volume-list-c-get"
  meep::volume_list *arg1 = (meep::volume_list *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::volume_list *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__volume_list, 1, 0);
  }
  result = (int) ((arg1)->c);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_volume_list_weight_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-volume-list-weight-set"
  meep::volume_list *arg1 = (meep::volume_list *) 0 ;
  complex< double > arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::volume_list *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__volume_list, 1, 0);
  }
  {
    cnumber cnum = ctl_convert_cnumber_to_c(s_1);
    arg2 = std::complex<double>(cnum.re, cnum.im);
  }
  if (arg1) (arg1)->weight = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_volume_list_weight_get (SCM s_0)
{
#define FUNC_NAME "meep-volume-list-weight-get"
  meep::volume_list *arg1 = (meep::volume_list *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > result;
  
  {
    arg1 = (meep::volume_list *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__volume_list, 1, 0);
  }
  result =  ((arg1)->weight);
  {
    gswig_result = scm_make_rectangular(scm_make_real((&result)->real()),
      scm_make_real((&result)->imag()));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_volume_list_next_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-volume-list-next-set"
  meep::volume_list *arg1 = (meep::volume_list *) 0 ;
  meep::volume_list *arg2 = (meep::volume_list *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::volume_list *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__volume_list, 1, 0);
  }
  {
    arg2 = (meep::volume_list *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__volume_list, 2, 0);
  }
  if (arg1) (arg1)->next = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_volume_list_next_get (SCM s_0)
{
#define FUNC_NAME "meep-volume-list-next-get"
  meep::volume_list *arg1 = (meep::volume_list *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::volume_list *result = 0 ;
  
  {
    arg1 = (meep::volume_list *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__volume_list, 1, 0);
  }
  result = (meep::volume_list *) ((arg1)->next);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__volume_list, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_wall_time ()
{
#define FUNC_NAME "meep-wall-time"
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  result = (double)meep::wall_time();
  {
    gswig_result = scm_make_real(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_initialize (SCM s_0, SCM s_1)
{
#define FUNC_NAME "new-meep-initialize"
  int *arg1 = 0 ;
  char ***arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::initialize *result = 0 ;
  
  {
    arg1 = (int *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_int, 1, 0);
  }
  {
    arg2 = (char ***)SWIG_MustGetPtr(s_1, SWIGTYPE_p_p_p_char, 2, 0);
  }
  result = (meep::initialize *)new meep::initialize(*arg1,*arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__initialize, 1);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_delete_meep_initialize (SCM s_0)
{
#define FUNC_NAME "delete-meep-initialize"
  meep::initialize *arg1 = (meep::initialize *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::initialize *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__initialize, 1, 0);
  }
  delete arg1;
  gswig_result = SCM_UNSPECIFIED;
  
  SWIG_Guile_MarkPointerDestroyed(s_0);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_initialize_elapsed_time (SCM s_0)
{
#define FUNC_NAME "meep-initialize-elapsed-time"
  meep::initialize *arg1 = (meep::initialize *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::initialize *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__initialize, 1, 0);
  }
  result = (double)(arg1)->elapsed_time();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_all_wait ()
{
#define FUNC_NAME "meep-all-wait"
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  meep::all_wait();
  gswig_result = SCM_UNSPECIFIED;
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_count_processors ()
{
#define FUNC_NAME "meep-count-processors"
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  result = (int)meep::count_processors();
  {
    gswig_result = scm_long2num(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_my_rank ()
{
#define FUNC_NAME "meep-my-rank"
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  result = (int)meep::my_rank();
  {
    gswig_result = scm_long2num(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_am_really_master ()
{
#define FUNC_NAME "meep-am-really-master"
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  result = (bool)meep::am_really_master();
  {
    gswig_result = SCM_BOOL(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_am_master ()
{
#define FUNC_NAME "meep-am-master"
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  result = (int)meep::am_master();
  {
    gswig_result = scm_long2num(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_send__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-send"
  int arg1 ;
  int arg2 ;
  double *arg3 = (double *) 0 ;
  int arg4 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (int) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME);
  }
  {
    arg2 = (int) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME);
  }
  {
    arg3 = (double *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_double, 3, 0);
  }
  {
    arg4 = (int) scm_num2int(argv[3], SCM_ARG1, FUNC_NAME);
  }
  meep::send(arg1,arg2,arg3,arg4);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_send__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-send"
  int arg1 ;
  int arg2 ;
  double *arg3 = (double *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (int) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME);
  }
  {
    arg2 = (int) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME);
  }
  {
    arg3 = (double *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_double, 3, 0);
  }
  meep::send(arg1,arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_send(SCM rest)
{
#define FUNC_NAME "meep-send"
  SCM argv[4];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 4, "meep-send");
  if (argc == 3) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_double, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_meep_send__SWIG_1(argc,argv);
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_double, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_integer_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            return _wrap_meep_send__SWIG_0(argc,argv);
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-send", "No matching method for generic function `meep_send'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_broadcast__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-broadcast"
  int arg1 ;
  double *arg2 = (double *) 0 ;
  int arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (int) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME);
  }
  {
    arg2 = (double *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_double, 2, 0);
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  meep::broadcast(arg1,arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_broadcast__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-broadcast"
  int arg1 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (int) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME);
  }
  {
    arg2 = (char *)SWIG_scm2str(argv[1]);
    must_free2 = 1;
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  meep::broadcast(arg1,arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_broadcast__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-broadcast"
  int arg1 ;
  int *arg2 = (int *) 0 ;
  int arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (int) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME);
  }
  {
    arg2 = (int *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_int, 2, 0);
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  meep::broadcast(arg1,arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_broadcast__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-broadcast"
  int arg1 ;
  complex< double > *arg2 = (complex< double > *) 0 ;
  int arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (int) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME);
  }
  {
    arg2 = (complex< double > *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_complexT_double_t, 2, 0);
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  meep::broadcast(arg1,arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_broadcast__SWIG_4 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-broadcast"
  int arg1 ;
  complex< double > arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > result;
  
  {
    arg1 = (int) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME);
  }
  {
    cnumber cnum = ctl_convert_cnumber_to_c(argv[1]);
    arg2 = std::complex<double>(cnum.re, cnum.im);
  }
  result = meep::broadcast(arg1,arg2);
  {
    gswig_result = scm_make_rectangular(scm_make_real((&result)->real()),
      scm_make_real((&result)->imag()));
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_broadcast__SWIG_5 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-broadcast"
  int arg1 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (int) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME);
  }
  {
    arg2 = (double) scm_num2dbl(argv[1], FUNC_NAME);
  }
  result = (double)meep::broadcast(arg1,arg2);
  {
    gswig_result = scm_make_real(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_broadcast__SWIG_6 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-broadcast"
  int arg1 ;
  int arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (int) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME);
  }
  {
    arg2 = (int) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME);
  }
  result = (int)meep::broadcast(arg1,arg2);
  {
    gswig_result = scm_long2num(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_broadcast__SWIG_7 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-broadcast"
  int arg1 ;
  bool arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (int) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME);
  }
  {
    arg2 = (bool) SCM_NFALSEP(argv[1]);
  }
  result = (bool)meep::broadcast(arg1,arg2);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_broadcast(SCM rest)
{
#define FUNC_NAME "meep-broadcast"
  SCM argv[3];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "meep-broadcast");
  if (argc == 2) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      {
        _v = SCM_BOOLP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        return _wrap_meep_broadcast__SWIG_7(argc,argv);
      }
    }
  }
  if (argc == 2) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        return _wrap_meep_broadcast__SWIG_6(argc,argv);
      }
    }
  }
  if (argc == 2) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_real_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        return _wrap_meep_broadcast__SWIG_5(argc,argv);
      }
    }
  }
  if (argc == 2) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      {
        _v = SwigComplex_Check(argv[1]);
      }
      if (_v) {
        return _wrap_meep_broadcast__SWIG_4(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_double, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_broadcast__SWIG_0(argc,argv);
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_int, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_broadcast__SWIG_2(argc,argv);
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_complexT_double_t, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_broadcast__SWIG_3(argc,argv);
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      {
        _v = SCM_STRINGP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_broadcast__SWIG_1(argc,argv);
        }
      }
    }
  }
  
  scm_misc_error("meep-broadcast", "No matching method for generic function `meep_broadcast'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_max_to_master (SCM s_0)
{
#define FUNC_NAME "meep-max-to-master"
  double arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (double) scm_num2dbl(s_0, FUNC_NAME);
  }
  result = (double)meep::max_to_master(arg1);
  {
    gswig_result = scm_make_real(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_max_to_all__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-max-to-all"
  double arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (double) scm_num2dbl(argv[0], FUNC_NAME);
  }
  result = (double)meep::max_to_all(arg1);
  {
    gswig_result = scm_make_real(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_max_to_all__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-max-to-all"
  int arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (int) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME);
  }
  result = (int)meep::max_to_all(arg1);
  {
    gswig_result = scm_long2num(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_max_to_all(SCM rest)
{
#define FUNC_NAME "meep-max-to-all"
  SCM argv[1];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 1, "meep-max-to-all");
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__ivec, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      return _wrap_meep_max_to_all__SWIG_0(argc,argv);
    }
  }
  if (argc == 1) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      return _wrap_meep_max_to_all__SWIG_2(argc,argv);
    }
  }
  if (argc == 1) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_real_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      return _wrap_meep_max_to_all__SWIG_1(argc,argv);
    }
  }
  
  scm_misc_error("meep-max-to-all", "No matching method for generic function `meep_max_to_all'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_sum_to_master (SCM s_0)
{
#define FUNC_NAME "meep-sum-to-master"
  double arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (double) scm_num2dbl(s_0, FUNC_NAME);
  }
  result = (double)meep::sum_to_master(arg1);
  {
    gswig_result = scm_make_real(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_sum_to_all__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-sum-to-all"
  double arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (double) scm_num2dbl(argv[0], FUNC_NAME);
  }
  result = (double)meep::sum_to_all(arg1);
  {
    gswig_result = scm_make_real(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_sum_to_all__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-sum-to-all"
  double *arg1 = (double *) 0 ;
  double *arg2 = (double *) 0 ;
  int arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (double *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_double, 1, 0);
  }
  {
    arg2 = (double *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_double, 2, 0);
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  meep::sum_to_all((double const *)arg1,arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_sum_to_all__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-sum-to-all"
  long double arg1 ;
  long double *argp1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  long double result;
  
  {
    argp1 = (long double *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_long_double, 1, 0);
    arg1 = *argp1;
  }
  result = (long double)meep::sum_to_all(arg1);
  {
    long double * resultptr;
    resultptr = new long double((const long double &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_long_double, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_sum_to_all__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-sum-to-all"
  complex< double > arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > result;
  
  {
    cnumber cnum = ctl_convert_cnumber_to_c(argv[0]);
    arg1 = std::complex<double>(cnum.re, cnum.im);
  }
  result = meep::sum_to_all(arg1);
  {
    gswig_result = scm_make_rectangular(scm_make_real((&result)->real()),
      scm_make_real((&result)->imag()));
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_sum_to_all__SWIG_4 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-sum-to-all"
  complex< long double > arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< long double > result;
  
  {
    cnumber cnum = ctl_convert_cnumber_to_c(argv[0]);
    arg1 = std::complex<double>(cnum.re, cnum.im);
  }
  result = meep::sum_to_all(arg1);
  {
    gswig_result = scm_make_rectangular(scm_make_real((&result)->real()),
      scm_make_real((&result)->imag()));
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_sum_to_all__SWIG_5 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-sum-to-all"
  int arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (int) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME);
  }
  result = (int)meep::sum_to_all(arg1);
  {
    gswig_result = scm_long2num(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_sum_to_all(SCM rest)
{
#define FUNC_NAME "meep-sum-to-all"
  SCM argv[3];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "meep-sum-to-all");
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_long_double, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      return _wrap_meep_sum_to_all__SWIG_2(argc,argv);
    }
  }
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_complexT_long_double_t, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      return _wrap_meep_sum_to_all__SWIG_4(argc,argv);
    }
  }
  if (argc == 1) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      return _wrap_meep_sum_to_all__SWIG_5(argc,argv);
    }
  }
  if (argc == 1) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_real_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      return _wrap_meep_sum_to_all__SWIG_0(argc,argv);
    }
  }
  if (argc == 1) {
    int _v;
    {
      _v = SwigComplex_Check(argv[0]);
    }
    if (_v) {
      return _wrap_meep_sum_to_all__SWIG_3(argc,argv);
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_double, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_double, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_sum_to_all__SWIG_1(argc,argv);
        }
      }
    }
  }
  
  scm_misc_error("meep-sum-to-all", "No matching method for generic function `meep_sum_to_all'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_partial_sum_to_all (SCM s_0)
{
#define FUNC_NAME "meep-partial-sum-to-all"
  int arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (int) scm_num2int(s_0, SCM_ARG1, FUNC_NAME);
  }
  result = (int)meep::partial_sum_to_all(arg1);
  {
    gswig_result = scm_long2num(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_or_to_all__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-or-to-all"
  bool arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (bool) SCM_NFALSEP(argv[0]);
  }
  result = (bool)meep::or_to_all(arg1);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_or_to_all__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-or-to-all"
  int *arg1 = (int *) 0 ;
  int *arg2 = (int *) 0 ;
  int arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (int *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_int, 1, 0);
  }
  {
    arg2 = (int *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_int, 2, 0);
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  meep::or_to_all((int const *)arg1,arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_or_to_all(SCM rest)
{
#define FUNC_NAME "meep-or-to-all"
  SCM argv[3];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "meep-or-to-all");
  if (argc == 1) {
    int _v;
    {
      _v = SCM_BOOLP(argv[0]) ? 1 : 0;
    }
    if (_v) {
      return _wrap_meep_or_to_all__SWIG_0(argc,argv);
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_int, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_int, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_or_to_all__SWIG_1(argc,argv);
        }
      }
    }
  }
  
  scm_misc_error("meep-or-to-all", "No matching method for generic function `meep_or_to_all'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_and_to_all__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-and-to-all"
  bool arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (bool) SCM_NFALSEP(argv[0]);
  }
  result = (bool)meep::and_to_all(arg1);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_and_to_all__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-and-to-all"
  int *arg1 = (int *) 0 ;
  int *arg2 = (int *) 0 ;
  int arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (int *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_int, 1, 0);
  }
  {
    arg2 = (int *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_int, 2, 0);
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  meep::and_to_all((int const *)arg1,arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_and_to_all(SCM rest)
{
#define FUNC_NAME "meep-and-to-all"
  SCM argv[3];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "meep-and-to-all");
  if (argc == 1) {
    int _v;
    {
      _v = SCM_BOOLP(argv[0]) ? 1 : 0;
    }
    if (_v) {
      return _wrap_meep_and_to_all__SWIG_0(argc,argv);
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_int, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_int, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_and_to_all__SWIG_1(argc,argv);
        }
      }
    }
  }
  
  scm_misc_error("meep-and-to-all", "No matching method for generic function `meep_and_to_all'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_master_printf (SCM s_0)
{
#define FUNC_NAME "meep-master-printf"
  char *arg1 = (char *) 0 ;
  void *arg2 = 0 ;
  int must_free1 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (char *)SWIG_scm2str(s_0);
    must_free1 = 1;
  }
  meep::master_printf((char const *)arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  if (must_free1 && arg1) SWIG_free(arg1);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_debug_printf (SCM s_0)
{
#define FUNC_NAME "meep-debug-printf"
  char *arg1 = (char *) 0 ;
  void *arg2 = 0 ;
  int must_free1 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (char *)SWIG_scm2str(s_0);
    must_free1 = 1;
  }
  meep::debug_printf((char const *)arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  if (must_free1 && arg1) SWIG_free(arg1);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_master_fprintf (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-master-fprintf"
  FILE *arg1 = (FILE *) 0 ;
  char *arg2 = (char *) 0 ;
  void *arg3 = 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (FILE *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_FILE, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  meep::master_fprintf(arg1,(char const *)arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_master_fopen (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-master-fopen"
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free1 = 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  FILE *result = 0 ;
  
  {
    arg1 = (char *)SWIG_scm2str(s_0);
    must_free1 = 1;
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  result = (FILE *)meep::master_fopen((char const *)arg1,(char const *)arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_FILE, 0);
  }
  if (must_free1 && arg1) SWIG_free(arg1);
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_master_fclose (SCM s_0)
{
#define FUNC_NAME "meep-master-fclose"
  FILE *arg1 = (FILE *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (FILE *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_FILE, 1, 0);
  }
  meep::master_fclose(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_begin_critical_section (SCM s_0)
{
#define FUNC_NAME "meep-begin-critical-section"
  int arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (int) scm_num2int(s_0, SCM_ARG1, FUNC_NAME);
  }
  meep::begin_critical_section(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_end_critical_section (SCM s_0)
{
#define FUNC_NAME "meep-end-critical-section"
  int arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (int) scm_num2int(s_0, SCM_ARG1, FUNC_NAME);
  }
  meep::end_critical_section(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_divide_parallel_processes (SCM s_0)
{
#define FUNC_NAME "meep-divide-parallel-processes"
  int arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (int) scm_num2int(s_0, SCM_ARG1, FUNC_NAME);
  }
  result = (int)meep::divide_parallel_processes(arg1);
  {
    gswig_result = scm_long2num(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_begin_global_communications ()
{
#define FUNC_NAME "meep-begin-global-communications"
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  meep::begin_global_communications();
  gswig_result = SCM_UNSPECIFIED;
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_end_global_communications ()
{
#define FUNC_NAME "meep-end-global-communications"
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  meep::end_global_communications();
  gswig_result = SCM_UNSPECIFIED;
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_end_divide_parallel ()
{
#define FUNC_NAME "meep-end-divide-parallel"
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  meep::end_divide_parallel();
  gswig_result = SCM_UNSPECIFIED;
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_MEEP_SINGLE(SCM s_0)
{
#define FUNC_NAME "MEEP-SINGLE"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_MEEP_SINGLE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_quiet(SCM s_0)
{
#define FUNC_NAME "quiet"
  SCM gswig_result;
  
  if (s_0 != SCM_UNDEFINED) {
    {
      meep::quiet = (bool) SCM_NFALSEP(s_0);
    }
  }
  {
    gswig_result = SCM_BOOL(meep::quiet);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_pi(SCM s_0)
{
#define FUNC_NAME "pi"
  SCM gswig_result;
  
  {
    gswig_result = scm_make_real(meep::pi);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_infinity(SCM s_0)
{
#define FUNC_NAME "infinity"
  SCM gswig_result;
  
  {
    gswig_result = scm_make_real(meep::infinity);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_nan(SCM s_0)
{
#define FUNC_NAME "nan"
  SCM gswig_result;
  
  {
    gswig_result = scm_make_real(meep::nan);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_polarizability_identifier_ft_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-polarizability-identifier-ft-set"
  meep::polarizability_identifier *arg1 = (meep::polarizability_identifier *) 0 ;
  meep::field_type arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::polarizability_identifier *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__polarizability_identifier, 1, 0);
  }
  {
    arg2 = (meep::field_type) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  if (arg1) (arg1)->ft = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_polarizability_identifier_ft_get (SCM s_0)
{
#define FUNC_NAME "meep-polarizability-identifier-ft-get"
  meep::polarizability_identifier *arg1 = (meep::polarizability_identifier *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::field_type result;
  
  {
    arg1 = (meep::polarizability_identifier *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__polarizability_identifier, 1, 0);
  }
  result = (meep::field_type) ((arg1)->ft);
  {
    gswig_result = scm_long2num(result); 
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_polarizability_identifier_gamma_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-polarizability-identifier-gamma-set"
  meep::polarizability_identifier *arg1 = (meep::polarizability_identifier *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::polarizability_identifier *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__polarizability_identifier, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  if (arg1) (arg1)->gamma = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_polarizability_identifier_gamma_get (SCM s_0)
{
#define FUNC_NAME "meep-polarizability-identifier-gamma-get"
  meep::polarizability_identifier *arg1 = (meep::polarizability_identifier *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::polarizability_identifier *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__polarizability_identifier, 1, 0);
  }
  result = (double) ((arg1)->gamma);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_polarizability_identifier_omeganot_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-polarizability-identifier-omeganot-set"
  meep::polarizability_identifier *arg1 = (meep::polarizability_identifier *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::polarizability_identifier *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__polarizability_identifier, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  if (arg1) (arg1)->omeganot = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_polarizability_identifier_omeganot_get (SCM s_0)
{
#define FUNC_NAME "meep-polarizability-identifier-omeganot-get"
  meep::polarizability_identifier *arg1 = (meep::polarizability_identifier *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::polarizability_identifier *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__polarizability_identifier, 1, 0);
  }
  result = (double) ((arg1)->omeganot);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_polarizability_identifier ()
{
#define FUNC_NAME "new-meep-polarizability-identifier"
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::polarizability_identifier *result = 0 ;
  
  result = (meep::polarizability_identifier *)new meep::polarizability_identifier();
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__polarizability_identifier, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_delete_meep_polarizability_identifier (SCM s_0)
{
#define FUNC_NAME "delete-meep-polarizability-identifier"
  meep::polarizability_identifier *arg1 = (meep::polarizability_identifier *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::polarizability_identifier *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__polarizability_identifier, 1, 0);
  }
  delete arg1;
  gswig_result = SCM_UNSPECIFIED;
  
  SWIG_Guile_MarkPointerDestroyed(s_0);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_h5file_READONLY(SCM s_0)
{
#define FUNC_NAME "meep-h5file-READONLY"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_h5file_READONLY);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_h5file_READWRITE(SCM s_0)
{
#define FUNC_NAME "meep-h5file-READWRITE"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_h5file_READWRITE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_h5file_WRITE(SCM s_0)
{
#define FUNC_NAME "meep-h5file-WRITE"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_h5file_WRITE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_h5file__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-h5file"
  char *arg1 = (char *) 0 ;
  meep::h5file::access_mode arg2 ;
  bool arg3 ;
  int must_free1 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::h5file *result = 0 ;
  
  {
    arg1 = (char *)SWIG_scm2str(argv[0]);
    must_free1 = 1;
  }
  {
    arg2 = (meep::h5file::access_mode) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (bool) SCM_NFALSEP(argv[2]);
  }
  result = (meep::h5file *)new meep::h5file((char const *)arg1,arg2,arg3);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__h5file, 1);
  }
  if (must_free1 && arg1) SWIG_free(arg1);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_h5file__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-h5file"
  char *arg1 = (char *) 0 ;
  meep::h5file::access_mode arg2 ;
  int must_free1 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::h5file *result = 0 ;
  
  {
    arg1 = (char *)SWIG_scm2str(argv[0]);
    must_free1 = 1;
  }
  {
    arg2 = (meep::h5file::access_mode) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  result = (meep::h5file *)new meep::h5file((char const *)arg1,arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__h5file, 1);
  }
  if (must_free1 && arg1) SWIG_free(arg1);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_h5file__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-h5file"
  char *arg1 = (char *) 0 ;
  int must_free1 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::h5file *result = 0 ;
  
  {
    arg1 = (char *)SWIG_scm2str(argv[0]);
    must_free1 = 1;
  }
  result = (meep::h5file *)new meep::h5file((char const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__h5file, 1);
  }
  if (must_free1 && arg1) SWIG_free(arg1);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_h5file(SCM rest)
{
#define FUNC_NAME "new-meep-h5file"
  SCM argv[3];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "new-meep-h5file");
  if (argc == 1) {
    int _v;
    {
      _v = SCM_STRINGP(argv[0]) ? 1 : 0;
    }
    if (_v) {
      return _wrap_new_meep_h5file__SWIG_2(argc,argv);
    }
  }
  if (argc == 2) {
    int _v;
    {
      _v = SCM_STRINGP(argv[0]) ? 1 : 0;
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        return _wrap_new_meep_h5file__SWIG_1(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      _v = SCM_STRINGP(argv[0]) ? 1 : 0;
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_BOOLP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          return _wrap_new_meep_h5file__SWIG_0(argc,argv);
        }
      }
    }
  }
  
  scm_misc_error("new-meep-h5file", "No matching method for generic function `new_meep_h5file'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_delete_meep_h5file (SCM s_0)
{
#define FUNC_NAME "delete-meep-h5file"
  meep::h5file *arg1 = (meep::h5file *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::h5file *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__h5file, 1, 0);
  }
  delete arg1;
  gswig_result = SCM_UNSPECIFIED;
  
  SWIG_Guile_MarkPointerDestroyed(s_0);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_h5file_ok (SCM s_0)
{
#define FUNC_NAME "meep-h5file-ok"
  meep::h5file *arg1 = (meep::h5file *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::h5file *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__h5file, 1, 0);
  }
  result = (bool)(arg1)->ok();
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_h5file_read__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-h5file-read"
  meep::h5file *arg1 = (meep::h5file *) 0 ;
  char *arg2 = (char *) 0 ;
  int *arg3 = (int *) 0 ;
  int *arg4 = (int *) 0 ;
  int arg5 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::realnum *result = 0 ;
  
  {
    arg1 = (meep::h5file *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__h5file, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(argv[1]);
    must_free2 = 1;
  }
  {
    arg3 = (int *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_int, 3, 0);
  }
  {
    arg4 = (int *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_int, 4, 0);
  }
  {
    arg5 = (int) scm_num2int(argv[4], SCM_ARG1, FUNC_NAME);
  }
  result = (meep::realnum *)(arg1)->read((char const *)arg2,arg3,arg4,arg5);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_double, 0);
  }
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_h5file_write__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-h5file-write"
  meep::h5file *arg1 = (meep::h5file *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  int *arg4 = (int *) 0 ;
  meep::realnum *arg5 = (meep::realnum *) 0 ;
  bool arg6 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::h5file *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__h5file, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(argv[1]);
    must_free2 = 1;
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  {
    arg4 = (int *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_int, 4, 0);
  }
  {
    arg5 = (meep::realnum *)SWIG_MustGetPtr(argv[4], SWIGTYPE_p_double, 5, 0);
  }
  {
    arg6 = (bool) SCM_NFALSEP(argv[5]);
  }
  (arg1)->write((char const *)arg2,arg3,(int const *)arg4,arg5,arg6);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_h5file_write__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-h5file-write"
  meep::h5file *arg1 = (meep::h5file *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  int *arg4 = (int *) 0 ;
  meep::realnum *arg5 = (meep::realnum *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::h5file *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__h5file, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(argv[1]);
    must_free2 = 1;
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  {
    arg4 = (int *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_int, 4, 0);
  }
  {
    arg5 = (meep::realnum *)SWIG_MustGetPtr(argv[4], SWIGTYPE_p_double, 5, 0);
  }
  (arg1)->write((char const *)arg2,arg3,(int const *)arg4,arg5);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_h5file_read__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-h5file-read"
  meep::h5file *arg1 = (meep::h5file *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  char *result = 0 ;
  
  {
    arg1 = (meep::h5file *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__h5file, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(argv[1]);
    must_free2 = 1;
  }
  result = (char *)(arg1)->read((char const *)arg2);
  {
    gswig_result = scm_makfrom0str((const char *)result);
  }
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_h5file_read(SCM rest)
{
#define FUNC_NAME "meep-h5file-read"
  SCM argv[5];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 5, "meep-h5file-read");
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__h5file, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_STRINGP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        return _wrap_meep_h5file_read__SWIG_1(argc,argv);
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__h5file, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_STRINGP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_int, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_int, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_integer_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              return _wrap_meep_h5file_read__SWIG_0(argc,argv);
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-h5file-read", "No matching method for generic function `meep_h5file_read'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_h5file_write__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-h5file-write"
  meep::h5file *arg1 = (meep::h5file *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  int must_free2 = 0 ;
  int must_free3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::h5file *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__h5file, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(argv[1]);
    must_free2 = 1;
  }
  {
    arg3 = (char *)SWIG_scm2str(argv[2]);
    must_free3 = 1;
  }
  (arg1)->write((char const *)arg2,(char const *)arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  if (must_free3 && arg3) SWIG_free(arg3);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_h5file_write(SCM rest)
{
#define FUNC_NAME "meep-h5file-write"
  SCM argv[6];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 6, "meep-h5file-write");
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__h5file, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_STRINGP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_STRINGP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_h5file_write__SWIG_2(argc,argv);
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__h5file, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_STRINGP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_int, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              void *ptr;
              int res = SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_double, 0);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              return _wrap_meep_h5file_write__SWIG_1(argc,argv);
            }
          }
        }
      }
    }
  }
  if (argc == 6) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__h5file, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_STRINGP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_int, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              void *ptr;
              int res = SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_double, 0);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              {
                _v = SCM_BOOLP(argv[5]) ? 1 : 0;
              }
              if (_v) {
                return _wrap_meep_h5file_write__SWIG_0(argc,argv);
              }
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-h5file-write", "No matching method for generic function `meep_h5file_write'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_h5file_create_data__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-h5file-create-data"
  meep::h5file *arg1 = (meep::h5file *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  int *arg4 = (int *) 0 ;
  bool arg5 ;
  bool arg6 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::h5file *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__h5file, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(argv[1]);
    must_free2 = 1;
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  {
    arg4 = (int *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_int, 4, 0);
  }
  {
    arg5 = (bool) SCM_NFALSEP(argv[4]);
  }
  {
    arg6 = (bool) SCM_NFALSEP(argv[5]);
  }
  (arg1)->create_data((char const *)arg2,arg3,(int const *)arg4,arg5,arg6);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_h5file_create_data__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-h5file-create-data"
  meep::h5file *arg1 = (meep::h5file *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  int *arg4 = (int *) 0 ;
  bool arg5 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::h5file *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__h5file, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(argv[1]);
    must_free2 = 1;
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  {
    arg4 = (int *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_int, 4, 0);
  }
  {
    arg5 = (bool) SCM_NFALSEP(argv[4]);
  }
  (arg1)->create_data((char const *)arg2,arg3,(int const *)arg4,arg5);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_h5file_create_data__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-h5file-create-data"
  meep::h5file *arg1 = (meep::h5file *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  int *arg4 = (int *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::h5file *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__h5file, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(argv[1]);
    must_free2 = 1;
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  {
    arg4 = (int *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_int, 4, 0);
  }
  (arg1)->create_data((char const *)arg2,arg3,(int const *)arg4);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_h5file_create_data(SCM rest)
{
#define FUNC_NAME "meep-h5file-create-data"
  SCM argv[6];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 6, "meep-h5file-create-data");
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__h5file, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_STRINGP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_int, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            return _wrap_meep_h5file_create_data__SWIG_2(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__h5file, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_STRINGP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_int, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              _v = SCM_BOOLP(argv[4]) ? 1 : 0;
            }
            if (_v) {
              return _wrap_meep_h5file_create_data__SWIG_1(argc,argv);
            }
          }
        }
      }
    }
  }
  if (argc == 6) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__h5file, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_STRINGP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_int, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              _v = SCM_BOOLP(argv[4]) ? 1 : 0;
            }
            if (_v) {
              {
                _v = SCM_BOOLP(argv[5]) ? 1 : 0;
              }
              if (_v) {
                return _wrap_meep_h5file_create_data__SWIG_0(argc,argv);
              }
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-h5file-create-data", "No matching method for generic function `meep_h5file_create_data'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_h5file_extend_data (SCM s_0, SCM s_1, SCM s_2, SCM s_3)
{
#define FUNC_NAME "meep-h5file-extend-data"
  meep::h5file *arg1 = (meep::h5file *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  int *arg4 = (int *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::h5file *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__h5file, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  {
    arg3 = (int) scm_num2int(s_2, SCM_ARG1, FUNC_NAME);
  }
  {
    arg4 = (int *)SWIG_MustGetPtr(s_3, SWIGTYPE_p_int, 4, 0);
  }
  (arg1)->extend_data((char const *)arg2,arg3,(int const *)arg4);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_h5file_create_or_extend_data (SCM s_0, SCM s_1, SCM s_2, SCM s_3, SCM s_4, SCM s_5)
{
#define FUNC_NAME "meep-h5file-create-or-extend-data"
  meep::h5file *arg1 = (meep::h5file *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  int *arg4 = (int *) 0 ;
  bool arg5 ;
  bool arg6 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::h5file *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__h5file, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  {
    arg3 = (int) scm_num2int(s_2, SCM_ARG1, FUNC_NAME);
  }
  {
    arg4 = (int *)SWIG_MustGetPtr(s_3, SWIGTYPE_p_int, 4, 0);
  }
  {
    arg5 = (bool) SCM_NFALSEP(s_4);
  }
  {
    arg6 = (bool) SCM_NFALSEP(s_5);
  }
  (arg1)->create_or_extend_data((char const *)arg2,arg3,(int const *)arg4,arg5,arg6);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_h5file_write_chunk (SCM s_0, SCM s_1, SCM s_2, SCM s_3, SCM s_4)
{
#define FUNC_NAME "meep-h5file-write-chunk"
  meep::h5file *arg1 = (meep::h5file *) 0 ;
  int arg2 ;
  int *arg3 = (int *) 0 ;
  int *arg4 = (int *) 0 ;
  meep::realnum *arg5 = (meep::realnum *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::h5file *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__h5file, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(s_1, SCM_ARG1, FUNC_NAME);
  }
  {
    arg3 = (int *)SWIG_MustGetPtr(s_2, SWIGTYPE_p_int, 3, 0);
  }
  {
    arg4 = (int *)SWIG_MustGetPtr(s_3, SWIGTYPE_p_int, 4, 0);
  }
  {
    arg5 = (meep::realnum *)SWIG_MustGetPtr(s_4, SWIGTYPE_p_double, 5, 0);
  }
  (arg1)->write_chunk(arg2,(int const *)arg3,(int const *)arg4,arg5);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_h5file_done_writing_chunks (SCM s_0)
{
#define FUNC_NAME "meep-h5file-done-writing-chunks"
  meep::h5file *arg1 = (meep::h5file *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::h5file *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__h5file, 1, 0);
  }
  (arg1)->done_writing_chunks();
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_h5file_read_size (SCM s_0, SCM s_1, SCM s_2, SCM s_3, SCM s_4)
{
#define FUNC_NAME "meep-h5file-read-size"
  meep::h5file *arg1 = (meep::h5file *) 0 ;
  char *arg2 = (char *) 0 ;
  int *arg3 = (int *) 0 ;
  int *arg4 = (int *) 0 ;
  int arg5 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::h5file *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__h5file, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  {
    arg3 = (int *)SWIG_MustGetPtr(s_2, SWIGTYPE_p_int, 3, 0);
  }
  {
    arg4 = (int *)SWIG_MustGetPtr(s_3, SWIGTYPE_p_int, 4, 0);
  }
  {
    arg5 = (int) scm_num2int(s_4, SCM_ARG1, FUNC_NAME);
  }
  (arg1)->read_size((char const *)arg2,arg3,arg4,arg5);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_h5file_read_chunk (SCM s_0, SCM s_1, SCM s_2, SCM s_3, SCM s_4)
{
#define FUNC_NAME "meep-h5file-read-chunk"
  meep::h5file *arg1 = (meep::h5file *) 0 ;
  int arg2 ;
  int *arg3 = (int *) 0 ;
  int *arg4 = (int *) 0 ;
  meep::realnum *arg5 = (meep::realnum *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::h5file *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__h5file, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(s_1, SCM_ARG1, FUNC_NAME);
  }
  {
    arg3 = (int *)SWIG_MustGetPtr(s_2, SWIGTYPE_p_int, 3, 0);
  }
  {
    arg4 = (int *)SWIG_MustGetPtr(s_3, SWIGTYPE_p_int, 4, 0);
  }
  {
    arg5 = (meep::realnum *)SWIG_MustGetPtr(s_4, SWIGTYPE_p_double, 5, 0);
  }
  (arg1)->read_chunk(arg2,(int const *)arg3,(int const *)arg4,arg5);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_h5file_remove (SCM s_0)
{
#define FUNC_NAME "meep-h5file-remove"
  meep::h5file *arg1 = (meep::h5file *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::h5file *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__h5file, 1, 0);
  }
  (arg1)->remove();
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_h5file_remove_data (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-h5file-remove-data"
  meep::h5file *arg1 = (meep::h5file *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::h5file *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__h5file, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  (arg1)->remove_data((char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_h5file_file_name (SCM s_0)
{
#define FUNC_NAME "meep-h5file-file-name"
  meep::h5file *arg1 = (meep::h5file *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  char *result = 0 ;
  
  {
    arg1 = (meep::h5file *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__h5file, 1, 0);
  }
  result = (char *)((meep::h5file const *)arg1)->file_name();
  {
    gswig_result = scm_makfrom0str((const char *)result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_h5file_prevent_deadlock (SCM s_0)
{
#define FUNC_NAME "meep-h5file-prevent-deadlock"
  meep::h5file *arg1 = (meep::h5file *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::h5file *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__h5file, 1, 0);
  }
  (arg1)->prevent_deadlock();
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_DEFAULT_SUBPIXEL_TOL(SCM s_0)
{
#define FUNC_NAME "DEFAULT-SUBPIXEL-TOL"
  SCM gswig_result;
  
  {
    gswig_result = scm_make_real(gswig_const_DEFAULT_SUBPIXEL_TOL);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_DEFAULT_SUBPIXEL_MAXEVAL(SCM s_0)
{
#define FUNC_NAME "DEFAULT-SUBPIXEL-MAXEVAL"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_DEFAULT_SUBPIXEL_MAXEVAL);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_material_function ()
{
#define FUNC_NAME "new-meep-material-function"
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::material_function *result = 0 ;
  
  result = (meep::material_function *)new meep::material_function();
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__material_function, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_delete_meep_material_function (SCM s_0)
{
#define FUNC_NAME "delete-meep-material-function"
  meep::material_function *arg1 = (meep::material_function *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::material_function *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__material_function, 1, 0);
  }
  delete arg1;
  gswig_result = SCM_UNSPECIFIED;
  
  SWIG_Guile_MarkPointerDestroyed(s_0);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_material_function_set_volume (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-material-function-set-volume"
  meep::material_function *arg1 = (meep::material_function *) 0 ;
  meep::volume *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::material_function *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__material_function, 1, 0);
  }
  {
    arg2 = (meep::volume *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__volume, 2, 0);
  }
  (arg1)->set_volume((meep::volume const &)*arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_material_function_unset_volume (SCM s_0)
{
#define FUNC_NAME "meep-material-function-unset-volume"
  meep::material_function *arg1 = (meep::material_function *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::material_function *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__material_function, 1, 0);
  }
  (arg1)->unset_volume();
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_material_function_chi1p1 (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-material-function-chi1p1"
  meep::material_function *arg1 = (meep::material_function *) 0 ;
  meep::field_type arg2 ;
  meep::vec *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::material_function *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__material_function, 1, 0);
  }
  {
    arg2 = (meep::field_type) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  
  meep::vec vec__arg3 = vector3_to_vec(ctl_convert_vector3_to_c(s_2));
  arg3 = &vec__arg3;
  
  result = (double)(arg1)->chi1p1(arg2,(meep::vec const &)*arg3);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_material_function_eps (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-material-function-eps"
  meep::material_function *arg1 = (meep::material_function *) 0 ;
  meep::vec *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::material_function *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__material_function, 1, 0);
  }
  
  meep::vec vec__arg2 = vector3_to_vec(ctl_convert_vector3_to_c(s_1));
  arg2 = &vec__arg2;
  
  result = (double)(arg1)->eps((meep::vec const &)*arg2);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_material_function_has_mu (SCM s_0)
{
#define FUNC_NAME "meep-material-function-has-mu"
  meep::material_function *arg1 = (meep::material_function *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::material_function *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__material_function, 1, 0);
  }
  result = (bool)(arg1)->has_mu();
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_material_function_mu (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-material-function-mu"
  meep::material_function *arg1 = (meep::material_function *) 0 ;
  meep::vec *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::material_function *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__material_function, 1, 0);
  }
  
  meep::vec vec__arg2 = vector3_to_vec(ctl_convert_vector3_to_c(s_1));
  arg2 = &vec__arg2;
  
  result = (double)(arg1)->mu((meep::vec const &)*arg2);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_material_function_has_conductivity (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-material-function-has-conductivity"
  meep::material_function *arg1 = (meep::material_function *) 0 ;
  meep::component arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::material_function *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__material_function, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = (bool)(arg1)->has_conductivity(arg2);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_material_function_conductivity (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-material-function-conductivity"
  meep::material_function *arg1 = (meep::material_function *) 0 ;
  meep::component arg2 ;
  meep::vec *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::material_function *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__material_function, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  
  meep::vec vec__arg3 = vector3_to_vec(ctl_convert_vector3_to_c(s_2));
  arg3 = &vec__arg3;
  
  result = (double)(arg1)->conductivity(arg2,(meep::vec const &)*arg3);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_material_function_normal_vector (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-material-function-normal-vector"
  meep::material_function *arg1 = (meep::material_function *) 0 ;
  meep::field_type arg2 ;
  meep::volume *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::vec result;
  
  {
    arg1 = (meep::material_function *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__material_function, 1, 0);
  }
  {
    arg2 = (meep::field_type) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::volume *)SWIG_MustGetPtr(s_2, SWIGTYPE_p_meep__volume, 3, 0);
  }
  result = (arg1)->normal_vector(arg2,(meep::volume const &)*arg3);
  {
    gswig_result = ctl_convert_vector3_to_scm(vec_to_vector3(result));
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_material_function_eff_chi1inv_row__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-material-function-eff-chi1inv-row"
  meep::material_function *arg1 = (meep::material_function *) 0 ;
  meep::component arg2 ;
  double *arg3 ;
  meep::volume *arg4 = 0 ;
  double arg5 ;
  int arg6 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::material_function *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__material_function, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (double *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_double, 3, 0);
  }
  {
    arg4 = (meep::volume *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__volume, 4, 0);
  }
  {
    arg5 = (double) scm_num2dbl(argv[4], FUNC_NAME);
  }
  {
    arg6 = (int) scm_num2int(argv[5], SCM_ARG1, FUNC_NAME);
  }
  (arg1)->eff_chi1inv_row(arg2,arg3,(meep::volume const &)*arg4,arg5,arg6);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_material_function_eff_chi1inv_row__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-material-function-eff-chi1inv-row"
  meep::material_function *arg1 = (meep::material_function *) 0 ;
  meep::component arg2 ;
  double *arg3 ;
  meep::volume *arg4 = 0 ;
  double arg5 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::material_function *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__material_function, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (double *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_double, 3, 0);
  }
  {
    arg4 = (meep::volume *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__volume, 4, 0);
  }
  {
    arg5 = (double) scm_num2dbl(argv[4], FUNC_NAME);
  }
  (arg1)->eff_chi1inv_row(arg2,arg3,(meep::volume const &)*arg4,arg5);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_material_function_eff_chi1inv_row__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-material-function-eff-chi1inv-row"
  meep::material_function *arg1 = (meep::material_function *) 0 ;
  meep::component arg2 ;
  double *arg3 ;
  meep::volume *arg4 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::material_function *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__material_function, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (double *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_double, 3, 0);
  }
  {
    arg4 = (meep::volume *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__volume, 4, 0);
  }
  (arg1)->eff_chi1inv_row(arg2,arg3,(meep::volume const &)*arg4);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_material_function_eff_chi1inv_row(SCM rest)
{
#define FUNC_NAME "meep-material-function-eff-chi1inv-row"
  SCM argv[6];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 6, "meep-material-function-eff-chi1inv-row");
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__material_function, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_double, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__volume, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            return _wrap_meep_material_function_eff_chi1inv_row__SWIG_2(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__material_function, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_double, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__volume, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_real_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              return _wrap_meep_material_function_eff_chi1inv_row__SWIG_1(argc,argv);
            }
          }
        }
      }
    }
  }
  if (argc == 6) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__material_function, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_double, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__volume, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_real_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              {
                _v = SCM_NFALSEP(scm_integer_p(argv[5])) ? 1 : 0;
              }
              if (_v) {
                return _wrap_meep_material_function_eff_chi1inv_row__SWIG_0(argc,argv);
              }
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-material-function-eff-chi1inv-row", "No matching method for generic function `meep_material_function_eff_chi1inv_row'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_material_function_sigma_row (SCM s_0, SCM s_1, SCM s_2, SCM s_3)
{
#define FUNC_NAME "meep-material-function-sigma-row"
  meep::material_function *arg1 = (meep::material_function *) 0 ;
  meep::component arg2 ;
  double *arg3 ;
  meep::vec *arg4 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::material_function *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__material_function, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (double *)SWIG_MustGetPtr(s_2, SWIGTYPE_p_double, 3, 0);
  }
  
  meep::vec vec__arg4 = vector3_to_vec(ctl_convert_vector3_to_c(s_3));
  arg4 = &vec__arg4;
  
  (arg1)->sigma_row(arg2,arg3,(meep::vec const &)*arg4);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_material_function_set_polarizability (SCM s_0, SCM s_1, SCM s_2, SCM s_3)
{
#define FUNC_NAME "meep-material-function-set-polarizability"
  meep::material_function *arg1 = (meep::material_function *) 0 ;
  meep::field_type arg2 ;
  double arg3 ;
  double arg4 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::material_function *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__material_function, 1, 0);
  }
  {
    arg2 = (meep::field_type) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (double) scm_num2dbl(s_2, FUNC_NAME);
  }
  {
    arg4 = (double) scm_num2dbl(s_3, FUNC_NAME);
  }
  (arg1)->set_polarizability(arg2,arg3,arg4);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_material_function_has_chi3 (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-material-function-has-chi3"
  meep::material_function *arg1 = (meep::material_function *) 0 ;
  meep::component arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::material_function *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__material_function, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = (bool)(arg1)->has_chi3(arg2);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_material_function_chi3 (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-material-function-chi3"
  meep::material_function *arg1 = (meep::material_function *) 0 ;
  meep::component arg2 ;
  meep::vec *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::material_function *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__material_function, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  
  meep::vec vec__arg3 = vector3_to_vec(ctl_convert_vector3_to_c(s_2));
  arg3 = &vec__arg3;
  
  result = (double)(arg1)->chi3(arg2,(meep::vec const &)*arg3);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_material_function_has_chi2 (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-material-function-has-chi2"
  meep::material_function *arg1 = (meep::material_function *) 0 ;
  meep::component arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::material_function *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__material_function, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = (bool)(arg1)->has_chi2(arg2);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_material_function_chi2 (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-material-function-chi2"
  meep::material_function *arg1 = (meep::material_function *) 0 ;
  meep::component arg2 ;
  meep::vec *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::material_function *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__material_function, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  
  meep::vec vec__arg3 = vector3_to_vec(ctl_convert_vector3_to_c(s_2));
  arg3 = &vec__arg3;
  
  result = (double)(arg1)->chi2(arg2,(meep::vec const &)*arg3);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_simple_material_function (SCM s_0)
{
#define FUNC_NAME "new-meep-simple-material-function"
  double (*arg1)(meep::vec const &) = (double (*)(meep::vec const &)) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::simple_material_function *result = 0 ;
  
  {
    arg1 = (double (*)(meep::vec const &))SWIG_MustGetPtr(s_0, SWIGTYPE_p_f_r_q_const__meep__vec__double, 1, 0);
  }
  result = (meep::simple_material_function *)new meep::simple_material_function(arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__simple_material_function, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_delete_meep_simple_material_function (SCM s_0)
{
#define FUNC_NAME "delete-meep-simple-material-function"
  meep::simple_material_function *arg1 = (meep::simple_material_function *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::simple_material_function *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__simple_material_function, 1, 0);
  }
  delete arg1;
  gswig_result = SCM_UNSPECIFIED;
  
  SWIG_Guile_MarkPointerDestroyed(s_0);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_simple_material_function_chi1p1 (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-simple-material-function-chi1p1"
  meep::simple_material_function *arg1 = (meep::simple_material_function *) 0 ;
  meep::field_type arg2 ;
  meep::vec *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::simple_material_function *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__simple_material_function, 1, 0);
  }
  {
    arg2 = (meep::field_type) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  
  meep::vec vec__arg3 = vector3_to_vec(ctl_convert_vector3_to_c(s_2));
  arg3 = &vec__arg3;
  
  result = (double)(arg1)->chi1p1(arg2,(meep::vec const &)*arg3);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_simple_material_function_eps (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-simple-material-function-eps"
  meep::simple_material_function *arg1 = (meep::simple_material_function *) 0 ;
  meep::vec *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::simple_material_function *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__simple_material_function, 1, 0);
  }
  
  meep::vec vec__arg2 = vector3_to_vec(ctl_convert_vector3_to_c(s_1));
  arg2 = &vec__arg2;
  
  result = (double)(arg1)->eps((meep::vec const &)*arg2);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_simple_material_function_mu (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-simple-material-function-mu"
  meep::simple_material_function *arg1 = (meep::simple_material_function *) 0 ;
  meep::vec *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::simple_material_function *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__simple_material_function, 1, 0);
  }
  
  meep::vec vec__arg2 = vector3_to_vec(ctl_convert_vector3_to_c(s_1));
  arg2 = &vec__arg2;
  
  result = (double)(arg1)->mu((meep::vec const &)*arg2);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_simple_material_function_conductivity (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-simple-material-function-conductivity"
  meep::simple_material_function *arg1 = (meep::simple_material_function *) 0 ;
  meep::component arg2 ;
  meep::vec *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::simple_material_function *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__simple_material_function, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  
  meep::vec vec__arg3 = vector3_to_vec(ctl_convert_vector3_to_c(s_2));
  arg3 = &vec__arg3;
  
  result = (double)(arg1)->conductivity(arg2,(meep::vec const &)*arg3);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_simple_material_function_sigma_row (SCM s_0, SCM s_1, SCM s_2, SCM s_3)
{
#define FUNC_NAME "meep-simple-material-function-sigma-row"
  meep::simple_material_function *arg1 = (meep::simple_material_function *) 0 ;
  meep::component arg2 ;
  double *arg3 ;
  meep::vec *arg4 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::simple_material_function *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__simple_material_function, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (double *)SWIG_MustGetPtr(s_2, SWIGTYPE_p_double, 3, 0);
  }
  
  meep::vec vec__arg4 = vector3_to_vec(ctl_convert_vector3_to_c(s_3));
  arg4 = &vec__arg4;
  
  (arg1)->sigma_row(arg2,arg3,(meep::vec const &)*arg4);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_simple_material_function_chi3 (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-simple-material-function-chi3"
  meep::simple_material_function *arg1 = (meep::simple_material_function *) 0 ;
  meep::component arg2 ;
  meep::vec *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::simple_material_function *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__simple_material_function, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  
  meep::vec vec__arg3 = vector3_to_vec(ctl_convert_vector3_to_c(s_2));
  arg3 = &vec__arg3;
  
  result = (double)(arg1)->chi3(arg2,(meep::vec const &)*arg3);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_simple_material_function_chi2 (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-simple-material-function-chi2"
  meep::simple_material_function *arg1 = (meep::simple_material_function *) 0 ;
  meep::component arg2 ;
  meep::vec *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::simple_material_function *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__simple_material_function, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  
  meep::vec vec__arg3 = vector3_to_vec(ctl_convert_vector3_to_c(s_2));
  arg3 = &vec__arg3;
  
  result = (double)(arg1)->chi2(arg2,(meep::vec const &)*arg3);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_a_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-structure-chunk-a-set"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  if (arg1) (arg1)->a = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_a_get (SCM s_0)
{
#define FUNC_NAME "meep-structure-chunk-a-get"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  result = (double) ((arg1)->a);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_Courant_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-structure-chunk-Courant-set"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  if (arg1) (arg1)->Courant = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_Courant_get (SCM s_0)
{
#define FUNC_NAME "meep-structure-chunk-Courant-get"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  result = (double) ((arg1)->Courant);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_dt_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-structure-chunk-dt-set"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  if (arg1) (arg1)->dt = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_dt_get (SCM s_0)
{
#define FUNC_NAME "meep-structure-chunk-dt-get"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  result = (double) ((arg1)->dt);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_chi3_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-structure-chunk-chi3-set"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  meep::realnum **arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  {
    arg2 = (meep::realnum **)SWIG_MustGetPtr(s_1, SWIGTYPE_p_p_double, 2, 0);
  }
  {
    size_t ii;
    meep::realnum * *b = (meep::realnum * *) arg1->chi3;
    for (ii = 0; ii < (size_t)meep::NUM_FIELD_COMPONENTS; ii++) b[ii] = *((meep::realnum * *) arg2 + ii);
  }
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_chi3_get (SCM s_0)
{
#define FUNC_NAME "meep-structure-chunk-chi3-get"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::realnum **result = 0 ;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  result = (meep::realnum **)(meep::realnum **) ((arg1)->chi3);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_p_double, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_chi2_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-structure-chunk-chi2-set"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  meep::realnum **arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  {
    arg2 = (meep::realnum **)SWIG_MustGetPtr(s_1, SWIGTYPE_p_p_double, 2, 0);
  }
  {
    size_t ii;
    meep::realnum * *b = (meep::realnum * *) arg1->chi2;
    for (ii = 0; ii < (size_t)meep::NUM_FIELD_COMPONENTS; ii++) b[ii] = *((meep::realnum * *) arg2 + ii);
  }
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_chi2_get (SCM s_0)
{
#define FUNC_NAME "meep-structure-chunk-chi2-get"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::realnum **result = 0 ;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  result = (meep::realnum **)(meep::realnum **) ((arg1)->chi2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_p_double, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_chi1inv_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-structure-chunk-chi1inv-set"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  meep::realnum *(*arg2)[5] ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  {
    arg2 = (meep::realnum *(*)[5])SWIG_MustGetPtr(s_1, SWIGTYPE_p_a_5__p_double, 2, 0);
  }
  {
    meep::realnum * (*inp)[5] = (meep::realnum * (*)[5])(arg2);
    meep::realnum * (*dest)[5] = (meep::realnum * (*)[5])(arg1->chi1inv);
    size_t ii = 0;
    for (; ii < meep::NUM_FIELD_COMPONENTS; ++ii) {
      meep::realnum * *ip = inp[ii];
      meep::realnum * *dp = dest[ii];
      size_t jj = 0;
      for (; jj < 5; ++jj) dp[jj] = ip[jj];
    }
  }
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_chi1inv_get (SCM s_0)
{
#define FUNC_NAME "meep-structure-chunk-chi1inv-get"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::realnum *(*result)[5] = 0 ;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  result = (meep::realnum *(*)[5])(meep::realnum *(*)[5]) ((arg1)->chi1inv);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_a_5__p_double, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_trivial_chi1inv_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-structure-chunk-trivial-chi1inv-set"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  bool (*arg2)[5] ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  {
    arg2 = (bool (*)[5])SWIG_MustGetPtr(s_1, SWIGTYPE_p_a_5__bool, 2, 0);
  }
  {
    bool (*inp)[5] = (bool (*)[5])(arg2);
    bool (*dest)[5] = (bool (*)[5])(arg1->trivial_chi1inv);
    size_t ii = 0;
    for (; ii < meep::NUM_FIELD_COMPONENTS; ++ii) {
      bool *ip = inp[ii];
      bool *dp = dest[ii];
      size_t jj = 0;
      for (; jj < 5; ++jj) dp[jj] = ip[jj];
    }
  }
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_trivial_chi1inv_get (SCM s_0)
{
#define FUNC_NAME "meep-structure-chunk-trivial-chi1inv-get"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool (*result)[5] = 0 ;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  result = (bool (*)[5])(bool (*)[5]) ((arg1)->trivial_chi1inv);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_a_5__bool, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_conductivity_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-structure-chunk-conductivity-set"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  meep::realnum *(*arg2)[5] ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  {
    arg2 = (meep::realnum *(*)[5])SWIG_MustGetPtr(s_1, SWIGTYPE_p_a_5__p_double, 2, 0);
  }
  {
    meep::realnum * (*inp)[5] = (meep::realnum * (*)[5])(arg2);
    meep::realnum * (*dest)[5] = (meep::realnum * (*)[5])(arg1->conductivity);
    size_t ii = 0;
    for (; ii < meep::NUM_FIELD_COMPONENTS; ++ii) {
      meep::realnum * *ip = inp[ii];
      meep::realnum * *dp = dest[ii];
      size_t jj = 0;
      for (; jj < 5; ++jj) dp[jj] = ip[jj];
    }
  }
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_conductivity_get (SCM s_0)
{
#define FUNC_NAME "meep-structure-chunk-conductivity-get"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::realnum *(*result)[5] = 0 ;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  result = (meep::realnum *(*)[5])(meep::realnum *(*)[5]) ((arg1)->conductivity);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_a_5__p_double, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_condinv_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-structure-chunk-condinv-set"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  meep::realnum *(*arg2)[5] ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  {
    arg2 = (meep::realnum *(*)[5])SWIG_MustGetPtr(s_1, SWIGTYPE_p_a_5__p_double, 2, 0);
  }
  {
    meep::realnum * (*inp)[5] = (meep::realnum * (*)[5])(arg2);
    meep::realnum * (*dest)[5] = (meep::realnum * (*)[5])(arg1->condinv);
    size_t ii = 0;
    for (; ii < meep::NUM_FIELD_COMPONENTS; ++ii) {
      meep::realnum * *ip = inp[ii];
      meep::realnum * *dp = dest[ii];
      size_t jj = 0;
      for (; jj < 5; ++jj) dp[jj] = ip[jj];
    }
  }
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_condinv_get (SCM s_0)
{
#define FUNC_NAME "meep-structure-chunk-condinv-get"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::realnum *(*result)[5] = 0 ;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  result = (meep::realnum *(*)[5])(meep::realnum *(*)[5]) ((arg1)->condinv);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_a_5__p_double, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_condinv_stale_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-structure-chunk-condinv-stale-set"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  bool arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  {
    arg2 = (bool) SCM_NFALSEP(s_1);
  }
  if (arg1) (arg1)->condinv_stale = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_condinv_stale_get (SCM s_0)
{
#define FUNC_NAME "meep-structure-chunk-condinv-stale-get"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  result = (bool) ((arg1)->condinv_stale);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_sig_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-structure-chunk-sig-set"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  double **arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  {
    arg2 = (double **)SWIG_MustGetPtr(s_1, SWIGTYPE_p_p_double, 2, 0);
  }
  {
    size_t ii;
    double * *b = (double * *) arg1->sig;
    for (ii = 0; ii < (size_t)5; ii++) b[ii] = *((double * *) arg2 + ii);
  }
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_sig_get (SCM s_0)
{
#define FUNC_NAME "meep-structure-chunk-sig-get"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double **result = 0 ;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  result = (double **)(double **) ((arg1)->sig);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_p_double, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_siginv_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-structure-chunk-siginv-set"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  double **arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  {
    arg2 = (double **)SWIG_MustGetPtr(s_1, SWIGTYPE_p_p_double, 2, 0);
  }
  {
    size_t ii;
    double * *b = (double * *) arg1->siginv;
    for (ii = 0; ii < (size_t)5; ii++) b[ii] = *((double * *) arg2 + ii);
  }
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_siginv_get (SCM s_0)
{
#define FUNC_NAME "meep-structure-chunk-siginv-get"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double **result = 0 ;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  result = (double **)(double **) ((arg1)->siginv);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_p_double, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_sigsize_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-structure-chunk-sigsize-set"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  int *arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  {
    arg2 = (int *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_int, 2, 0);
  }
  {
    size_t ii;
    int *b = (int *) arg1->sigsize;
    for (ii = 0; ii < (size_t)5; ii++) b[ii] = *((int *) arg2 + ii);
  }
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_sigsize_get (SCM s_0)
{
#define FUNC_NAME "meep-structure-chunk-sigsize-get"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int *result = 0 ;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  result = (int *)(int *) ((arg1)->sigsize);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_int, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_gv_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-structure-chunk-gv-set"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  meep::grid_volume *arg2 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  {
    arg2 = (meep::grid_volume *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__grid_volume, 2, 0);
  }
  if (arg1) (arg1)->gv = *arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_gv_get (SCM s_0)
{
#define FUNC_NAME "meep-structure-chunk-gv-get"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::grid_volume *result = 0 ;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  result = (meep::grid_volume *)& ((arg1)->gv);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__grid_volume, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_v_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-structure-chunk-v-set"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  meep::volume *arg2 = (meep::volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  {
    arg2 = (meep::volume *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__volume, 2, 0);
  }
  if (arg1) (arg1)->v = *arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_v_get (SCM s_0)
{
#define FUNC_NAME "meep-structure-chunk-v-get"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::volume *result = 0 ;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  result = (meep::volume *)& ((arg1)->v);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__volume, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_pb_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-structure-chunk-pb-set"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  meep::polarizability *arg2 = (meep::polarizability *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  {
    arg2 = (meep::polarizability *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__polarizability, 2, 0);
  }
  if (arg1) (arg1)->pb = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_pb_get (SCM s_0)
{
#define FUNC_NAME "meep-structure-chunk-pb-get"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::polarizability *result = 0 ;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  result = (meep::polarizability *) ((arg1)->pb);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__polarizability, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_refcount_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-structure-chunk-refcount-set"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  int arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(s_1, SCM_ARG1, FUNC_NAME);
  }
  if (arg1) (arg1)->refcount = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_refcount_get (SCM s_0)
{
#define FUNC_NAME "meep-structure-chunk-refcount-get"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  result = (int) ((arg1)->refcount);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_delete_meep_structure_chunk (SCM s_0)
{
#define FUNC_NAME "delete-meep-structure-chunk"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  delete arg1;
  gswig_result = SCM_UNSPECIFIED;
  
  SWIG_Guile_MarkPointerDestroyed(s_0);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_structure_chunk__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-structure-chunk"
  meep::grid_volume *arg1 = 0 ;
  meep::volume *arg2 = 0 ;
  double arg3 ;
  int arg4 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::structure_chunk *result = 0 ;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::volume *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__volume, 2, 0);
  }
  {
    arg3 = (double) scm_num2dbl(argv[2], FUNC_NAME);
  }
  {
    arg4 = (int) scm_num2int(argv[3], SCM_ARG1, FUNC_NAME);
  }
  result = (meep::structure_chunk *)new meep::structure_chunk((meep::grid_volume const &)*arg1,(meep::volume const &)*arg2,arg3,arg4);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__structure_chunk, 1);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_structure_chunk__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-structure-chunk"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::structure_chunk *result = 0 ;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  result = (meep::structure_chunk *)new meep::structure_chunk((meep::structure_chunk const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__structure_chunk, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_structure_chunk(SCM rest)
{
#define FUNC_NAME "new-meep-structure-chunk"
  SCM argv[4];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 4, "new-meep-structure-chunk");
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure_chunk, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      return _wrap_new_meep_structure_chunk__SWIG_1(argc,argv);
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__volume, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_real_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_integer_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            return _wrap_new_meep_structure_chunk__SWIG_0(argc,argv);
          }
        }
      }
    }
  }
  
  scm_misc_error("new-meep-structure-chunk", "No matching method for generic function `new_meep_structure_chunk'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_set_chi1inv (SCM s_0, SCM s_1, SCM s_2, SCM s_3, SCM s_4, SCM s_5)
{
#define FUNC_NAME "meep-structure-chunk-set-chi1inv"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  meep::component arg2 ;
  meep::material_function *arg3 = 0 ;
  bool arg4 ;
  double arg5 ;
  int arg6 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::material_function *)SWIG_MustGetPtr(s_2, SWIGTYPE_p_meep__material_function, 3, 0);
  }
  {
    arg4 = (bool) SCM_NFALSEP(s_3);
  }
  {
    arg5 = (double) scm_num2dbl(s_4, FUNC_NAME);
  }
  {
    arg6 = (int) scm_num2int(s_5, SCM_ARG1, FUNC_NAME);
  }
  (arg1)->set_chi1inv(arg2,*arg3,arg4,arg5,arg6);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_has_chi1inv (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-structure-chunk-has-chi1inv"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  meep::component arg2 ;
  meep::direction arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::direction) scm_num2int(s_2, SCM_ARG1, FUNC_NAME); 
  }
  result = (bool)((meep::structure_chunk const *)arg1)->has_chi1inv(arg2,arg3);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_set_conductivity (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-structure-chunk-set-conductivity"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  meep::component arg2 ;
  meep::material_function *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::material_function *)SWIG_MustGetPtr(s_2, SWIGTYPE_p_meep__material_function, 3, 0);
  }
  (arg1)->set_conductivity(arg2,*arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_update_condinv (SCM s_0)
{
#define FUNC_NAME "meep-structure-chunk-update-condinv"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  (arg1)->update_condinv();
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_set_chi3 (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-structure-chunk-set-chi3"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  meep::component arg2 ;
  meep::material_function *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::material_function *)SWIG_MustGetPtr(s_2, SWIGTYPE_p_meep__material_function, 3, 0);
  }
  (arg1)->set_chi3(arg2,*arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_set_chi2 (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-structure-chunk-set-chi2"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  meep::component arg2 ;
  meep::material_function *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::material_function *)SWIG_MustGetPtr(s_2, SWIGTYPE_p_meep__material_function, 3, 0);
  }
  (arg1)->set_chi2(arg2,*arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_use_pml (SCM s_0, SCM s_1, SCM s_2, SCM s_3, SCM s_4, SCM s_5, SCM s_6, SCM s_7)
{
#define FUNC_NAME "meep-structure-chunk-use-pml"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  meep::direction arg2 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  meep::pml_profile_func arg6 = (meep::pml_profile_func) 0 ;
  void *arg7 = (void *) 0 ;
  double arg8 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  {
    arg2 = (meep::direction) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (double) scm_num2dbl(s_2, FUNC_NAME);
  }
  {
    arg4 = (double) scm_num2dbl(s_3, FUNC_NAME);
  }
  {
    arg5 = (double) scm_num2dbl(s_4, FUNC_NAME);
  }
  {
    arg6 = (meep::pml_profile_func)SWIG_MustGetPtr(s_5, SWIGTYPE_p_f_double_p_void__double, 6, 0);
  }
  {
    arg7 = (void *)SWIG_MustGetPtr(s_6, NULL, 7, 0);
  }
  {
    arg8 = (double) scm_num2dbl(s_7, FUNC_NAME);
  }
  (arg1)->use_pml(arg2,arg3,arg4,arg5,arg6,arg7,arg8);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_add_polarizability (SCM s_0, SCM s_1, SCM s_2, SCM s_3, SCM s_4)
{
#define FUNC_NAME "meep-structure-chunk-add-polarizability"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  meep::material_function *arg2 = 0 ;
  meep::field_type arg3 ;
  double arg4 ;
  double arg5 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  {
    arg2 = (meep::material_function *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__material_function, 2, 0);
  }
  {
    arg3 = (meep::field_type) scm_num2int(s_2, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg4 = (double) scm_num2dbl(s_3, FUNC_NAME);
  }
  {
    arg5 = (double) scm_num2dbl(s_4, FUNC_NAME);
  }
  (arg1)->add_polarizability(*arg2,arg3,arg4,arg5);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_mix_with (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-structure-chunk-mix-with"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  meep::structure_chunk *arg2 = (meep::structure_chunk *) 0 ;
  double arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  {
    arg2 = (meep::structure_chunk *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__structure_chunk, 2, 0);
  }
  {
    arg3 = (double) scm_num2dbl(s_2, FUNC_NAME);
  }
  (arg1)->mix_with((meep::structure_chunk const *)arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_n_proc (SCM s_0)
{
#define FUNC_NAME "meep-structure-chunk-n-proc"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  result = (int)((meep::structure_chunk const *)arg1)->n_proc();
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_is_mine (SCM s_0)
{
#define FUNC_NAME "meep-structure-chunk-is-mine"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  result = (int)((meep::structure_chunk const *)arg1)->is_mine();
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_remove_polarizabilities (SCM s_0)
{
#define FUNC_NAME "meep-structure-chunk-remove-polarizabilities"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  (arg1)->remove_polarizabilities();
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_get_chi1inv (SCM s_0, SCM s_1, SCM s_2, SCM s_3)
{
#define FUNC_NAME "meep-structure-chunk-get-chi1inv"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  meep::component arg2 ;
  meep::direction arg3 ;
  meep::ivec *arg4 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::direction) scm_num2int(s_2, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg4 = (meep::ivec *)SWIG_MustGetPtr(s_3, SWIGTYPE_p_meep__ivec, 4, 0);
  }
  result = (double)((meep::structure_chunk const *)arg1)->get_chi1inv(arg2,arg3,(meep::ivec const &)*arg4);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_get_inveps (SCM s_0, SCM s_1, SCM s_2, SCM s_3)
{
#define FUNC_NAME "meep-structure-chunk-get-inveps"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  meep::component arg2 ;
  meep::direction arg3 ;
  meep::ivec *arg4 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::direction) scm_num2int(s_2, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg4 = (meep::ivec *)SWIG_MustGetPtr(s_3, SWIGTYPE_p_meep__ivec, 4, 0);
  }
  result = (double)((meep::structure_chunk const *)arg1)->get_inveps(arg2,arg3,(meep::ivec const &)*arg4);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunk_max_eps (SCM s_0)
{
#define FUNC_NAME "meep-structure-chunk-max-eps"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  result = (double)((meep::structure_chunk const *)arg1)->max_eps();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_pml_quadratic_profile (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-pml-quadratic-profile"
  double arg1 ;
  void *arg2 = (void *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (double) scm_num2dbl(s_0, FUNC_NAME);
  }
  {
    arg2 = (void *)SWIG_MustGetPtr(s_1, NULL, 2, 0);
  }
  result = (double)meep::pml_quadratic_profile(arg1,arg2);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_boundary_region_NOTHING_SPECIAL(SCM s_0)
{
#define FUNC_NAME "meep-boundary-region-NOTHING-SPECIAL"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_boundary_region_NOTHING_SPECIAL);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_boundary_region_PML(SCM s_0)
{
#define FUNC_NAME "meep-boundary-region-PML"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_boundary_region_PML);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_boundary_region__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-boundary-region"
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::boundary_region *result = 0 ;
  
  result = (meep::boundary_region *)new meep::boundary_region();
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__boundary_region, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_boundary_region__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-boundary-region"
  meep::boundary_region::boundary_region_kind arg1 ;
  double arg2 ;
  double arg3 ;
  meep::pml_profile_func arg4 = (meep::pml_profile_func) 0 ;
  void *arg5 = (void *) 0 ;
  double arg6 ;
  meep::direction arg7 ;
  meep::boundary_side arg8 ;
  meep::boundary_region *arg9 = (meep::boundary_region *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::boundary_region *result = 0 ;
  
  {
    arg1 = (meep::boundary_region::boundary_region_kind) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg2 = (double) scm_num2dbl(argv[1], FUNC_NAME);
  }
  {
    arg3 = (double) scm_num2dbl(argv[2], FUNC_NAME);
  }
  {
    arg4 = (meep::pml_profile_func)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_f_double_p_void__double, 4, 0);
  }
  {
    arg5 = (void *)SWIG_MustGetPtr(argv[4], NULL, 5, 0);
  }
  {
    arg6 = (double) scm_num2dbl(argv[5], FUNC_NAME);
  }
  {
    arg7 = (meep::direction) scm_num2int(argv[6], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg8 = (meep::boundary_side) scm_num2int(argv[7], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg9 = (meep::boundary_region *)SWIG_MustGetPtr(argv[8], SWIGTYPE_p_meep__boundary_region, 9, 0);
  }
  result = (meep::boundary_region *)new meep::boundary_region(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__boundary_region, 1);
  }
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_boundary_region__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-boundary-region"
  meep::boundary_region::boundary_region_kind arg1 ;
  double arg2 ;
  double arg3 ;
  meep::pml_profile_func arg4 = (meep::pml_profile_func) 0 ;
  void *arg5 = (void *) 0 ;
  double arg6 ;
  meep::direction arg7 ;
  meep::boundary_side arg8 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::boundary_region *result = 0 ;
  
  {
    arg1 = (meep::boundary_region::boundary_region_kind) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg2 = (double) scm_num2dbl(argv[1], FUNC_NAME);
  }
  {
    arg3 = (double) scm_num2dbl(argv[2], FUNC_NAME);
  }
  {
    arg4 = (meep::pml_profile_func)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_f_double_p_void__double, 4, 0);
  }
  {
    arg5 = (void *)SWIG_MustGetPtr(argv[4], NULL, 5, 0);
  }
  {
    arg6 = (double) scm_num2dbl(argv[5], FUNC_NAME);
  }
  {
    arg7 = (meep::direction) scm_num2int(argv[6], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg8 = (meep::boundary_side) scm_num2int(argv[7], SCM_ARG1, FUNC_NAME); 
  }
  result = (meep::boundary_region *)new meep::boundary_region(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__boundary_region, 1);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_boundary_region__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-boundary-region"
  meep::boundary_region *arg1 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::boundary_region *result = 0 ;
  
  {
    arg1 = (meep::boundary_region *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__boundary_region, 1, 0);
  }
  result = (meep::boundary_region *)new meep::boundary_region((meep::boundary_region const &)*arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__boundary_region, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_boundary_region(SCM rest)
{
#define FUNC_NAME "new-meep-boundary-region"
  SCM argv[9];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 9, "new-meep-boundary-region");
  if (argc == 0) {
    return _wrap_new_meep_boundary_region__SWIG_0(argc,argv);
  }
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__boundary_region, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      return _wrap_new_meep_boundary_region__SWIG_3(argc,argv);
    }
  }
  if (argc == 8) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_real_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_real_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_f_double_p_void__double, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              void *ptr;
              int res = SWIG_ConvertPtr(argv[4], &ptr, 0, 0);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              {
                _v = SCM_NFALSEP(scm_real_p(argv[5])) ? 1 : 0;
              }
              if (_v) {
                {
                  _v = SCM_NFALSEP(scm_integer_p(argv[6])) ? 1 : 0;
                }
                if (_v) {
                  {
                    _v = SCM_NFALSEP(scm_integer_p(argv[7])) ? 1 : 0;
                  }
                  if (_v) {
                    return _wrap_new_meep_boundary_region__SWIG_2(argc,argv);
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  if (argc == 9) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_real_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_real_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_f_double_p_void__double, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              void *ptr;
              int res = SWIG_ConvertPtr(argv[4], &ptr, 0, 0);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              {
                _v = SCM_NFALSEP(scm_real_p(argv[5])) ? 1 : 0;
              }
              if (_v) {
                {
                  _v = SCM_NFALSEP(scm_integer_p(argv[6])) ? 1 : 0;
                }
                if (_v) {
                  {
                    _v = SCM_NFALSEP(scm_integer_p(argv[7])) ? 1 : 0;
                  }
                  if (_v) {
                    {
                      void *ptr;
                      int res = SWIG_ConvertPtr(argv[8], &ptr, SWIGTYPE_p_meep__boundary_region, 0);
                      _v = SWIG_CheckState(res);
                    }
                    if (_v) {
                      return _wrap_new_meep_boundary_region__SWIG_1(argc,argv);
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("new-meep-boundary-region", "No matching method for generic function `new_meep_boundary_region'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_delete_meep_boundary_region (SCM s_0)
{
#define FUNC_NAME "delete-meep-boundary-region"
  meep::boundary_region *arg1 = (meep::boundary_region *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::boundary_region *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__boundary_region, 1, 0);
  }
  delete arg1;
  gswig_result = SCM_UNSPECIFIED;
  
  SWIG_Guile_MarkPointerDestroyed(s_0);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_boundary_region_meep_boundary_region_add (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-boundary-region-meep-boundary-region-add"
  meep::boundary_region *arg1 = (meep::boundary_region *) 0 ;
  meep::boundary_region *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::boundary_region result;
  
  {
    arg1 = (meep::boundary_region *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__boundary_region, 1, 0);
  }
  {
    arg2 = (meep::boundary_region *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__boundary_region, 2, 0);
  }
  result = ((meep::boundary_region const *)arg1)->operator +((meep::boundary_region const &)*arg2);
  {
    meep::boundary_region * resultptr;
    resultptr = new meep::boundary_region((const meep::boundary_region &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__boundary_region, 1);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_boundary_region_meep_boundary_region_mul (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-boundary-region-meep-boundary-region-mul"
  meep::boundary_region *arg1 = (meep::boundary_region *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::boundary_region result;
  
  {
    arg1 = (meep::boundary_region *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__boundary_region, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  result = ((meep::boundary_region const *)arg1)->operator *(arg2);
  {
    meep::boundary_region * resultptr;
    resultptr = new meep::boundary_region((const meep::boundary_region &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__boundary_region, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_boundary_region_apply__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-boundary-region-apply"
  meep::boundary_region *arg1 = (meep::boundary_region *) 0 ;
  meep::structure *arg2 = (meep::structure *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::boundary_region *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__boundary_region, 1, 0);
  }
  {
    arg2 = (meep::structure *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__structure, 2, 0);
  }
  ((meep::boundary_region const *)arg1)->apply(arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_boundary_region_apply__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-boundary-region-apply"
  meep::boundary_region *arg1 = (meep::boundary_region *) 0 ;
  meep::structure *arg2 = (meep::structure *) 0 ;
  meep::structure_chunk *arg3 = (meep::structure_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::boundary_region *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__boundary_region, 1, 0);
  }
  {
    arg2 = (meep::structure *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__structure, 2, 0);
  }
  {
    arg3 = (meep::structure_chunk *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__structure_chunk, 3, 0);
  }
  ((meep::boundary_region const *)arg1)->apply((meep::structure const *)arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_boundary_region_apply(SCM rest)
{
#define FUNC_NAME "meep-boundary-region-apply"
  SCM argv[3];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "meep-boundary-region-apply");
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__boundary_region, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__structure, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_meep_boundary_region_apply__SWIG_0(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__boundary_region, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__structure, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__structure_chunk, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_meep_boundary_region_apply__SWIG_1(argc,argv);
        }
      }
    }
  }
  
  scm_misc_error("meep-boundary-region-apply", "No matching method for generic function `meep_boundary_region_apply'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_boundary_region_check_ok (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-boundary-region-check-ok"
  meep::boundary_region *arg1 = (meep::boundary_region *) 0 ;
  meep::grid_volume *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::boundary_region *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__boundary_region, 1, 0);
  }
  {
    arg2 = (meep::grid_volume *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__grid_volume, 2, 0);
  }
  result = (bool)((meep::boundary_region const *)arg1)->check_ok((meep::grid_volume const &)*arg2);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_pml__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-pml"
  double arg1 ;
  meep::direction arg2 ;
  meep::boundary_side arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::boundary_region result;
  
  {
    arg1 = (double) scm_num2dbl(argv[0], FUNC_NAME);
  }
  {
    arg2 = (meep::direction) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::boundary_side) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME); 
  }
  result = meep::pml(arg1,arg2,arg3);
  {
    meep::boundary_region * resultptr;
    resultptr = new meep::boundary_region((const meep::boundary_region &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__boundary_region, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_pml__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-pml"
  double arg1 ;
  meep::direction arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::boundary_region result;
  
  {
    arg1 = (double) scm_num2dbl(argv[0], FUNC_NAME);
  }
  {
    arg2 = (meep::direction) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  result = meep::pml(arg1,arg2);
  {
    meep::boundary_region * resultptr;
    resultptr = new meep::boundary_region((const meep::boundary_region &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__boundary_region, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_pml__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-pml"
  double arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::boundary_region result;
  
  {
    arg1 = (double) scm_num2dbl(argv[0], FUNC_NAME);
  }
  result = meep::pml(arg1);
  {
    meep::boundary_region * resultptr;
    resultptr = new meep::boundary_region((const meep::boundary_region &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__boundary_region, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_pml(SCM rest)
{
#define FUNC_NAME "meep-pml"
  SCM argv[3];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "meep-pml");
  if (argc == 1) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_real_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      return _wrap_meep_pml__SWIG_2(argc,argv);
    }
  }
  if (argc == 2) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_real_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        return _wrap_meep_pml__SWIG_1(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_real_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_pml__SWIG_0(argc,argv);
        }
      }
    }
  }
  
  scm_misc_error("meep-pml", "No matching method for generic function `meep_pml'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunks_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-structure-chunks-set"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::structure_chunk **arg2 = (meep::structure_chunk **) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::structure_chunk **)SWIG_MustGetPtr(s_1, SWIGTYPE_p_p_meep__structure_chunk, 2, 0);
  }
  if (arg1) (arg1)->chunks = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_chunks_get (SCM s_0)
{
#define FUNC_NAME "meep-structure-chunks-get"
  meep::structure *arg1 = (meep::structure *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::structure_chunk **result = 0 ;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  result = (meep::structure_chunk **) ((arg1)->chunks);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_p_meep__structure_chunk, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_num_chunks_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-structure-num-chunks-set"
  meep::structure *arg1 = (meep::structure *) 0 ;
  int arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(s_1, SCM_ARG1, FUNC_NAME);
  }
  if (arg1) (arg1)->num_chunks = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_num_chunks_get (SCM s_0)
{
#define FUNC_NAME "meep-structure-num-chunks-get"
  meep::structure *arg1 = (meep::structure *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  result = (int) ((arg1)->num_chunks);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_gv_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-structure-gv-set"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::grid_volume *arg2 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::grid_volume *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__grid_volume, 2, 0);
  }
  if (arg1) (arg1)->gv = *arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_gv_get (SCM s_0)
{
#define FUNC_NAME "meep-structure-gv-get"
  meep::structure *arg1 = (meep::structure *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::grid_volume *result = 0 ;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  result = (meep::grid_volume *)& ((arg1)->gv);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__grid_volume, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_user_volume_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-structure-user-volume-set"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::grid_volume *arg2 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::grid_volume *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__grid_volume, 2, 0);
  }
  if (arg1) (arg1)->user_volume = *arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_user_volume_get (SCM s_0)
{
#define FUNC_NAME "meep-structure-user-volume-get"
  meep::structure *arg1 = (meep::structure *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::grid_volume *result = 0 ;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  result = (meep::grid_volume *)& ((arg1)->user_volume);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__grid_volume, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_a_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-structure-a-set"
  meep::structure *arg1 = (meep::structure *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  if (arg1) (arg1)->a = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_a_get (SCM s_0)
{
#define FUNC_NAME "meep-structure-a-get"
  meep::structure *arg1 = (meep::structure *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  result = (double) ((arg1)->a);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_Courant_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-structure-Courant-set"
  meep::structure *arg1 = (meep::structure *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  if (arg1) (arg1)->Courant = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_Courant_get (SCM s_0)
{
#define FUNC_NAME "meep-structure-Courant-get"
  meep::structure *arg1 = (meep::structure *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  result = (double) ((arg1)->Courant);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_dt_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-structure-dt-set"
  meep::structure *arg1 = (meep::structure *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  if (arg1) (arg1)->dt = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_dt_get (SCM s_0)
{
#define FUNC_NAME "meep-structure-dt-get"
  meep::structure *arg1 = (meep::structure *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  result = (double) ((arg1)->dt);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_v_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-structure-v-set"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::volume *arg2 = (meep::volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::volume *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__volume, 2, 0);
  }
  if (arg1) (arg1)->v = *arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_v_get (SCM s_0)
{
#define FUNC_NAME "meep-structure-v-get"
  meep::structure *arg1 = (meep::structure *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::volume *result = 0 ;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  result = (meep::volume *)& ((arg1)->v);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__volume, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_S_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-structure-S-set"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::symmetry *arg2 = (meep::symmetry *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::symmetry *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__symmetry, 2, 0);
  }
  if (arg1) (arg1)->S = *arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_S_get (SCM s_0)
{
#define FUNC_NAME "meep-structure-S-get"
  meep::structure *arg1 = (meep::structure *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::symmetry *result = 0 ;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  result = (meep::symmetry *)& ((arg1)->S);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__symmetry, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_outdir_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-structure-outdir-set"
  meep::structure *arg1 = (meep::structure *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  {
    if (arg2) {
      arg1->outdir = (char const *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->outdir, (const char *)arg2);
    } else {
      arg1->outdir = 0;
    }
  }
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_outdir_get (SCM s_0)
{
#define FUNC_NAME "meep-structure-outdir-get"
  meep::structure *arg1 = (meep::structure *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  char *result = 0 ;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  result = (char *) ((arg1)->outdir);
  {
    gswig_result = scm_makfrom0str((const char *)result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_effort_volumes_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-structure-effort-volumes-set"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::grid_volume *arg2 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::grid_volume *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__grid_volume, 2, 0);
  }
  if (arg1) (arg1)->effort_volumes = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_effort_volumes_get (SCM s_0)
{
#define FUNC_NAME "meep-structure-effort-volumes-get"
  meep::structure *arg1 = (meep::structure *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::grid_volume *result = 0 ;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  result = (meep::grid_volume *) ((arg1)->effort_volumes);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__grid_volume, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_effort_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-structure-effort-set"
  meep::structure *arg1 = (meep::structure *) 0 ;
  double *arg2 = (double *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (double *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_double, 2, 0);
  }
  if (arg1) (arg1)->effort = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_effort_get (SCM s_0)
{
#define FUNC_NAME "meep-structure-effort-get"
  meep::structure *arg1 = (meep::structure *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double *result = 0 ;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  result = (double *) ((arg1)->effort);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_double, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_num_effort_volumes_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-structure-num-effort-volumes-set"
  meep::structure *arg1 = (meep::structure *) 0 ;
  int arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(s_1, SCM_ARG1, FUNC_NAME);
  }
  if (arg1) (arg1)->num_effort_volumes = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_num_effort_volumes_get (SCM s_0)
{
#define FUNC_NAME "meep-structure-num-effort-volumes-get"
  meep::structure *arg1 = (meep::structure *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  result = (int) ((arg1)->num_effort_volumes);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_delete_meep_structure (SCM s_0)
{
#define FUNC_NAME "delete-meep-structure"
  meep::structure *arg1 = (meep::structure *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  delete arg1;
  gswig_result = SCM_UNSPECIFIED;
  
  SWIG_Guile_MarkPointerDestroyed(s_0);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_structure__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-structure"
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::structure *result = 0 ;
  
  result = (meep::structure *)new meep::structure();
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__structure, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_structure__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-structure"
  meep::grid_volume *arg1 = 0 ;
  meep::material_function *arg2 = 0 ;
  meep::boundary_region *arg3 = 0 ;
  meep::symmetry *arg4 = 0 ;
  int arg5 ;
  double arg6 ;
  bool arg7 ;
  double arg8 ;
  int arg9 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::structure *result = 0 ;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::material_function *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__material_function, 2, 0);
  }
  {
    arg3 = (meep::boundary_region *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__boundary_region, 3, 0);
  }
  {
    arg4 = (meep::symmetry *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__symmetry, 4, 0);
  }
  {
    arg5 = (int) scm_num2int(argv[4], SCM_ARG1, FUNC_NAME);
  }
  {
    arg6 = (double) scm_num2dbl(argv[5], FUNC_NAME);
  }
  {
    arg7 = (bool) SCM_NFALSEP(argv[6]);
  }
  {
    arg8 = (double) scm_num2dbl(argv[7], FUNC_NAME);
  }
  {
    arg9 = (int) scm_num2int(argv[8], SCM_ARG1, FUNC_NAME);
  }
  result = (meep::structure *)new meep::structure((meep::grid_volume const &)*arg1,*arg2,(meep::boundary_region const &)*arg3,(meep::symmetry const &)*arg4,arg5,arg6,arg7,arg8,arg9);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__structure, 1);
  }
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_structure__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-structure"
  meep::grid_volume *arg1 = 0 ;
  meep::material_function *arg2 = 0 ;
  meep::boundary_region *arg3 = 0 ;
  meep::symmetry *arg4 = 0 ;
  int arg5 ;
  double arg6 ;
  bool arg7 ;
  double arg8 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::structure *result = 0 ;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::material_function *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__material_function, 2, 0);
  }
  {
    arg3 = (meep::boundary_region *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__boundary_region, 3, 0);
  }
  {
    arg4 = (meep::symmetry *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__symmetry, 4, 0);
  }
  {
    arg5 = (int) scm_num2int(argv[4], SCM_ARG1, FUNC_NAME);
  }
  {
    arg6 = (double) scm_num2dbl(argv[5], FUNC_NAME);
  }
  {
    arg7 = (bool) SCM_NFALSEP(argv[6]);
  }
  {
    arg8 = (double) scm_num2dbl(argv[7], FUNC_NAME);
  }
  result = (meep::structure *)new meep::structure((meep::grid_volume const &)*arg1,*arg2,(meep::boundary_region const &)*arg3,(meep::symmetry const &)*arg4,arg5,arg6,arg7,arg8);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__structure, 1);
  }
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_structure__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-structure"
  meep::grid_volume *arg1 = 0 ;
  meep::material_function *arg2 = 0 ;
  meep::boundary_region *arg3 = 0 ;
  meep::symmetry *arg4 = 0 ;
  int arg5 ;
  double arg6 ;
  bool arg7 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::structure *result = 0 ;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::material_function *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__material_function, 2, 0);
  }
  {
    arg3 = (meep::boundary_region *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__boundary_region, 3, 0);
  }
  {
    arg4 = (meep::symmetry *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__symmetry, 4, 0);
  }
  {
    arg5 = (int) scm_num2int(argv[4], SCM_ARG1, FUNC_NAME);
  }
  {
    arg6 = (double) scm_num2dbl(argv[5], FUNC_NAME);
  }
  {
    arg7 = (bool) SCM_NFALSEP(argv[6]);
  }
  result = (meep::structure *)new meep::structure((meep::grid_volume const &)*arg1,*arg2,(meep::boundary_region const &)*arg3,(meep::symmetry const &)*arg4,arg5,arg6,arg7);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__structure, 1);
  }
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_structure__SWIG_4 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-structure"
  meep::grid_volume *arg1 = 0 ;
  meep::material_function *arg2 = 0 ;
  meep::boundary_region *arg3 = 0 ;
  meep::symmetry *arg4 = 0 ;
  int arg5 ;
  double arg6 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::structure *result = 0 ;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::material_function *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__material_function, 2, 0);
  }
  {
    arg3 = (meep::boundary_region *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__boundary_region, 3, 0);
  }
  {
    arg4 = (meep::symmetry *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__symmetry, 4, 0);
  }
  {
    arg5 = (int) scm_num2int(argv[4], SCM_ARG1, FUNC_NAME);
  }
  {
    arg6 = (double) scm_num2dbl(argv[5], FUNC_NAME);
  }
  result = (meep::structure *)new meep::structure((meep::grid_volume const &)*arg1,*arg2,(meep::boundary_region const &)*arg3,(meep::symmetry const &)*arg4,arg5,arg6);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__structure, 1);
  }
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_structure__SWIG_5 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-structure"
  meep::grid_volume *arg1 = 0 ;
  meep::material_function *arg2 = 0 ;
  meep::boundary_region *arg3 = 0 ;
  meep::symmetry *arg4 = 0 ;
  int arg5 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::structure *result = 0 ;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::material_function *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__material_function, 2, 0);
  }
  {
    arg3 = (meep::boundary_region *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__boundary_region, 3, 0);
  }
  {
    arg4 = (meep::symmetry *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__symmetry, 4, 0);
  }
  {
    arg5 = (int) scm_num2int(argv[4], SCM_ARG1, FUNC_NAME);
  }
  result = (meep::structure *)new meep::structure((meep::grid_volume const &)*arg1,*arg2,(meep::boundary_region const &)*arg3,(meep::symmetry const &)*arg4,arg5);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__structure, 1);
  }
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_structure__SWIG_6 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-structure"
  meep::grid_volume *arg1 = 0 ;
  meep::material_function *arg2 = 0 ;
  meep::boundary_region *arg3 = 0 ;
  meep::symmetry *arg4 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::structure *result = 0 ;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::material_function *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__material_function, 2, 0);
  }
  {
    arg3 = (meep::boundary_region *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__boundary_region, 3, 0);
  }
  {
    arg4 = (meep::symmetry *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__symmetry, 4, 0);
  }
  result = (meep::structure *)new meep::structure((meep::grid_volume const &)*arg1,*arg2,(meep::boundary_region const &)*arg3,(meep::symmetry const &)*arg4);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__structure, 1);
  }
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_structure__SWIG_7 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-structure"
  meep::grid_volume *arg1 = 0 ;
  meep::material_function *arg2 = 0 ;
  meep::boundary_region *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::structure *result = 0 ;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::material_function *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__material_function, 2, 0);
  }
  {
    arg3 = (meep::boundary_region *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__boundary_region, 3, 0);
  }
  result = (meep::structure *)new meep::structure((meep::grid_volume const &)*arg1,*arg2,(meep::boundary_region const &)*arg3);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__structure, 1);
  }
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_structure__SWIG_8 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-structure"
  meep::grid_volume *arg1 = 0 ;
  meep::material_function *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::structure *result = 0 ;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (meep::material_function *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__material_function, 2, 0);
  }
  result = (meep::structure *)new meep::structure((meep::grid_volume const &)*arg1,*arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__structure, 1);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_structure__SWIG_9 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-structure"
  meep::grid_volume *arg1 = 0 ;
  double (*arg2)(meep::vec const &) = (double (*)(meep::vec const &)) 0 ;
  meep::boundary_region *arg3 = 0 ;
  meep::symmetry *arg4 = 0 ;
  int arg5 ;
  double arg6 ;
  bool arg7 ;
  double arg8 ;
  int arg9 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::structure *result = 0 ;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (double (*)(meep::vec const &))SWIG_MustGetPtr(argv[1], SWIGTYPE_p_f_r_q_const__meep__vec__double, 2, 0);
  }
  {
    arg3 = (meep::boundary_region *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__boundary_region, 3, 0);
  }
  {
    arg4 = (meep::symmetry *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__symmetry, 4, 0);
  }
  {
    arg5 = (int) scm_num2int(argv[4], SCM_ARG1, FUNC_NAME);
  }
  {
    arg6 = (double) scm_num2dbl(argv[5], FUNC_NAME);
  }
  {
    arg7 = (bool) SCM_NFALSEP(argv[6]);
  }
  {
    arg8 = (double) scm_num2dbl(argv[7], FUNC_NAME);
  }
  {
    arg9 = (int) scm_num2int(argv[8], SCM_ARG1, FUNC_NAME);
  }
  result = (meep::structure *)new meep::structure((meep::grid_volume const &)*arg1,arg2,(meep::boundary_region const &)*arg3,(meep::symmetry const &)*arg4,arg5,arg6,arg7,arg8,arg9);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__structure, 1);
  }
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_structure__SWIG_10 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-structure"
  meep::grid_volume *arg1 = 0 ;
  double (*arg2)(meep::vec const &) = (double (*)(meep::vec const &)) 0 ;
  meep::boundary_region *arg3 = 0 ;
  meep::symmetry *arg4 = 0 ;
  int arg5 ;
  double arg6 ;
  bool arg7 ;
  double arg8 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::structure *result = 0 ;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (double (*)(meep::vec const &))SWIG_MustGetPtr(argv[1], SWIGTYPE_p_f_r_q_const__meep__vec__double, 2, 0);
  }
  {
    arg3 = (meep::boundary_region *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__boundary_region, 3, 0);
  }
  {
    arg4 = (meep::symmetry *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__symmetry, 4, 0);
  }
  {
    arg5 = (int) scm_num2int(argv[4], SCM_ARG1, FUNC_NAME);
  }
  {
    arg6 = (double) scm_num2dbl(argv[5], FUNC_NAME);
  }
  {
    arg7 = (bool) SCM_NFALSEP(argv[6]);
  }
  {
    arg8 = (double) scm_num2dbl(argv[7], FUNC_NAME);
  }
  result = (meep::structure *)new meep::structure((meep::grid_volume const &)*arg1,arg2,(meep::boundary_region const &)*arg3,(meep::symmetry const &)*arg4,arg5,arg6,arg7,arg8);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__structure, 1);
  }
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_structure__SWIG_11 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-structure"
  meep::grid_volume *arg1 = 0 ;
  double (*arg2)(meep::vec const &) = (double (*)(meep::vec const &)) 0 ;
  meep::boundary_region *arg3 = 0 ;
  meep::symmetry *arg4 = 0 ;
  int arg5 ;
  double arg6 ;
  bool arg7 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::structure *result = 0 ;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (double (*)(meep::vec const &))SWIG_MustGetPtr(argv[1], SWIGTYPE_p_f_r_q_const__meep__vec__double, 2, 0);
  }
  {
    arg3 = (meep::boundary_region *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__boundary_region, 3, 0);
  }
  {
    arg4 = (meep::symmetry *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__symmetry, 4, 0);
  }
  {
    arg5 = (int) scm_num2int(argv[4], SCM_ARG1, FUNC_NAME);
  }
  {
    arg6 = (double) scm_num2dbl(argv[5], FUNC_NAME);
  }
  {
    arg7 = (bool) SCM_NFALSEP(argv[6]);
  }
  result = (meep::structure *)new meep::structure((meep::grid_volume const &)*arg1,arg2,(meep::boundary_region const &)*arg3,(meep::symmetry const &)*arg4,arg5,arg6,arg7);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__structure, 1);
  }
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_structure__SWIG_12 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-structure"
  meep::grid_volume *arg1 = 0 ;
  double (*arg2)(meep::vec const &) = (double (*)(meep::vec const &)) 0 ;
  meep::boundary_region *arg3 = 0 ;
  meep::symmetry *arg4 = 0 ;
  int arg5 ;
  double arg6 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::structure *result = 0 ;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (double (*)(meep::vec const &))SWIG_MustGetPtr(argv[1], SWIGTYPE_p_f_r_q_const__meep__vec__double, 2, 0);
  }
  {
    arg3 = (meep::boundary_region *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__boundary_region, 3, 0);
  }
  {
    arg4 = (meep::symmetry *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__symmetry, 4, 0);
  }
  {
    arg5 = (int) scm_num2int(argv[4], SCM_ARG1, FUNC_NAME);
  }
  {
    arg6 = (double) scm_num2dbl(argv[5], FUNC_NAME);
  }
  result = (meep::structure *)new meep::structure((meep::grid_volume const &)*arg1,arg2,(meep::boundary_region const &)*arg3,(meep::symmetry const &)*arg4,arg5,arg6);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__structure, 1);
  }
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_structure__SWIG_13 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-structure"
  meep::grid_volume *arg1 = 0 ;
  double (*arg2)(meep::vec const &) = (double (*)(meep::vec const &)) 0 ;
  meep::boundary_region *arg3 = 0 ;
  meep::symmetry *arg4 = 0 ;
  int arg5 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::structure *result = 0 ;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (double (*)(meep::vec const &))SWIG_MustGetPtr(argv[1], SWIGTYPE_p_f_r_q_const__meep__vec__double, 2, 0);
  }
  {
    arg3 = (meep::boundary_region *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__boundary_region, 3, 0);
  }
  {
    arg4 = (meep::symmetry *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__symmetry, 4, 0);
  }
  {
    arg5 = (int) scm_num2int(argv[4], SCM_ARG1, FUNC_NAME);
  }
  result = (meep::structure *)new meep::structure((meep::grid_volume const &)*arg1,arg2,(meep::boundary_region const &)*arg3,(meep::symmetry const &)*arg4,arg5);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__structure, 1);
  }
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_structure__SWIG_14 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-structure"
  meep::grid_volume *arg1 = 0 ;
  double (*arg2)(meep::vec const &) = (double (*)(meep::vec const &)) 0 ;
  meep::boundary_region *arg3 = 0 ;
  meep::symmetry *arg4 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::structure *result = 0 ;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (double (*)(meep::vec const &))SWIG_MustGetPtr(argv[1], SWIGTYPE_p_f_r_q_const__meep__vec__double, 2, 0);
  }
  {
    arg3 = (meep::boundary_region *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__boundary_region, 3, 0);
  }
  {
    arg4 = (meep::symmetry *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__symmetry, 4, 0);
  }
  result = (meep::structure *)new meep::structure((meep::grid_volume const &)*arg1,arg2,(meep::boundary_region const &)*arg3,(meep::symmetry const &)*arg4);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__structure, 1);
  }
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_structure__SWIG_15 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-structure"
  meep::grid_volume *arg1 = 0 ;
  double (*arg2)(meep::vec const &) = (double (*)(meep::vec const &)) 0 ;
  meep::boundary_region *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::structure *result = 0 ;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (double (*)(meep::vec const &))SWIG_MustGetPtr(argv[1], SWIGTYPE_p_f_r_q_const__meep__vec__double, 2, 0);
  }
  {
    arg3 = (meep::boundary_region *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__boundary_region, 3, 0);
  }
  result = (meep::structure *)new meep::structure((meep::grid_volume const &)*arg1,arg2,(meep::boundary_region const &)*arg3);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__structure, 1);
  }
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_structure__SWIG_16 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-structure"
  meep::grid_volume *arg1 = 0 ;
  double (*arg2)(meep::vec const &) = (double (*)(meep::vec const &)) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::structure *result = 0 ;
  
  {
    arg1 = (meep::grid_volume *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__grid_volume, 1, 0);
  }
  {
    arg2 = (double (*)(meep::vec const &))SWIG_MustGetPtr(argv[1], SWIGTYPE_p_f_r_q_const__meep__vec__double, 2, 0);
  }
  result = (meep::structure *)new meep::structure((meep::grid_volume const &)*arg1,arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__structure, 1);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_structure__SWIG_17 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-structure"
  meep::structure *arg1 = (meep::structure *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::structure *result = 0 ;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  result = (meep::structure *)new meep::structure((meep::structure const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__structure, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_structure__SWIG_18 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-structure"
  meep::structure *arg1 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::structure *result = 0 ;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  result = (meep::structure *)new meep::structure((meep::structure const &)*arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__structure, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_structure(SCM rest)
{
#define FUNC_NAME "new-meep-structure"
  SCM argv[9];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 9, "new-meep-structure");
  if (argc == 0) {
    return _wrap_new_meep_structure__SWIG_0(argc,argv);
  }
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      return _wrap_new_meep_structure__SWIG_17(argc,argv);
    }
  }
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      return _wrap_new_meep_structure__SWIG_18(argc,argv);
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__material_function, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_new_meep_structure__SWIG_8(argc,argv);
      }
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_f_r_q_const__meep__vec__double, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_new_meep_structure__SWIG_16(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_f_r_q_const__meep__vec__double, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__boundary_region, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_new_meep_structure__SWIG_15(argc,argv);
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__material_function, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__boundary_region, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_new_meep_structure__SWIG_7(argc,argv);
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__material_function, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__boundary_region, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__symmetry, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            return _wrap_new_meep_structure__SWIG_6(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_f_r_q_const__meep__vec__double, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__boundary_region, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__symmetry, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            return _wrap_new_meep_structure__SWIG_14(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_f_r_q_const__meep__vec__double, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__boundary_region, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__symmetry, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_integer_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              return _wrap_new_meep_structure__SWIG_13(argc,argv);
            }
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__material_function, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__boundary_region, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__symmetry, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_integer_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              return _wrap_new_meep_structure__SWIG_5(argc,argv);
            }
          }
        }
      }
    }
  }
  if (argc == 6) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__material_function, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__boundary_region, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__symmetry, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_integer_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              {
                _v = SCM_NFALSEP(scm_real_p(argv[5])) ? 1 : 0;
              }
              if (_v) {
                return _wrap_new_meep_structure__SWIG_4(argc,argv);
              }
            }
          }
        }
      }
    }
  }
  if (argc == 6) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_f_r_q_const__meep__vec__double, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__boundary_region, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__symmetry, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_integer_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              {
                _v = SCM_NFALSEP(scm_real_p(argv[5])) ? 1 : 0;
              }
              if (_v) {
                return _wrap_new_meep_structure__SWIG_12(argc,argv);
              }
            }
          }
        }
      }
    }
  }
  if (argc == 7) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_f_r_q_const__meep__vec__double, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__boundary_region, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__symmetry, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_integer_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              {
                _v = SCM_NFALSEP(scm_real_p(argv[5])) ? 1 : 0;
              }
              if (_v) {
                {
                  _v = SCM_BOOLP(argv[6]) ? 1 : 0;
                }
                if (_v) {
                  return _wrap_new_meep_structure__SWIG_11(argc,argv);
                }
              }
            }
          }
        }
      }
    }
  }
  if (argc == 7) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__material_function, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__boundary_region, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__symmetry, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_integer_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              {
                _v = SCM_NFALSEP(scm_real_p(argv[5])) ? 1 : 0;
              }
              if (_v) {
                {
                  _v = SCM_BOOLP(argv[6]) ? 1 : 0;
                }
                if (_v) {
                  return _wrap_new_meep_structure__SWIG_3(argc,argv);
                }
              }
            }
          }
        }
      }
    }
  }
  if (argc == 8) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__material_function, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__boundary_region, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__symmetry, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_integer_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              {
                _v = SCM_NFALSEP(scm_real_p(argv[5])) ? 1 : 0;
              }
              if (_v) {
                {
                  _v = SCM_BOOLP(argv[6]) ? 1 : 0;
                }
                if (_v) {
                  {
                    _v = SCM_NFALSEP(scm_real_p(argv[7])) ? 1 : 0;
                  }
                  if (_v) {
                    return _wrap_new_meep_structure__SWIG_2(argc,argv);
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  if (argc == 8) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_f_r_q_const__meep__vec__double, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__boundary_region, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__symmetry, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_integer_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              {
                _v = SCM_NFALSEP(scm_real_p(argv[5])) ? 1 : 0;
              }
              if (_v) {
                {
                  _v = SCM_BOOLP(argv[6]) ? 1 : 0;
                }
                if (_v) {
                  {
                    _v = SCM_NFALSEP(scm_real_p(argv[7])) ? 1 : 0;
                  }
                  if (_v) {
                    return _wrap_new_meep_structure__SWIG_10(argc,argv);
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  if (argc == 9) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_f_r_q_const__meep__vec__double, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__boundary_region, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__symmetry, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_integer_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              {
                _v = SCM_NFALSEP(scm_real_p(argv[5])) ? 1 : 0;
              }
              if (_v) {
                {
                  _v = SCM_BOOLP(argv[6]) ? 1 : 0;
                }
                if (_v) {
                  {
                    _v = SCM_NFALSEP(scm_real_p(argv[7])) ? 1 : 0;
                  }
                  if (_v) {
                    {
                      _v = SCM_NFALSEP(scm_integer_p(argv[8])) ? 1 : 0;
                    }
                    if (_v) {
                      return _wrap_new_meep_structure__SWIG_9(argc,argv);
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  if (argc == 9) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__grid_volume, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__material_function, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__boundary_region, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__symmetry, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_integer_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              {
                _v = SCM_NFALSEP(scm_real_p(argv[5])) ? 1 : 0;
              }
              if (_v) {
                {
                  _v = SCM_BOOLP(argv[6]) ? 1 : 0;
                }
                if (_v) {
                  {
                    _v = SCM_NFALSEP(scm_real_p(argv[7])) ? 1 : 0;
                  }
                  if (_v) {
                    {
                      _v = SCM_NFALSEP(scm_integer_p(argv[8])) ? 1 : 0;
                    }
                    if (_v) {
                      return _wrap_new_meep_structure__SWIG_1(argc,argv);
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("new-meep-structure", "No matching method for generic function `new_meep_structure'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_materials__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-set-materials"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::material_function *arg2 = 0 ;
  bool arg3 ;
  double arg4 ;
  int arg5 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::material_function *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__material_function, 2, 0);
  }
  {
    arg3 = (bool) SCM_NFALSEP(argv[2]);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  {
    arg5 = (int) scm_num2int(argv[4], SCM_ARG1, FUNC_NAME);
  }
  (arg1)->set_materials(*arg2,arg3,arg4,arg5);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_materials__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-set-materials"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::material_function *arg2 = 0 ;
  bool arg3 ;
  double arg4 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::material_function *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__material_function, 2, 0);
  }
  {
    arg3 = (bool) SCM_NFALSEP(argv[2]);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  (arg1)->set_materials(*arg2,arg3,arg4);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_materials__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-set-materials"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::material_function *arg2 = 0 ;
  bool arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::material_function *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__material_function, 2, 0);
  }
  {
    arg3 = (bool) SCM_NFALSEP(argv[2]);
  }
  (arg1)->set_materials(*arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_materials__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-set-materials"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::material_function *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::material_function *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__material_function, 2, 0);
  }
  (arg1)->set_materials(*arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_materials(SCM rest)
{
#define FUNC_NAME "meep-structure-set-materials"
  SCM argv[5];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 5, "meep-structure-set-materials");
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__material_function, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_meep_structure_set_materials__SWIG_3(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__material_function, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_BOOLP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_structure_set_materials__SWIG_2(argc,argv);
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__material_function, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_BOOLP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            return _wrap_meep_structure_set_materials__SWIG_1(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__material_function, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_BOOLP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_integer_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              return _wrap_meep_structure_set_materials__SWIG_0(argc,argv);
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-structure-set-materials", "No matching method for generic function `meep_structure_set_materials'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_chi1inv__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-set-chi1inv"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::component arg2 ;
  meep::material_function *arg3 = 0 ;
  bool arg4 ;
  double arg5 ;
  int arg6 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::material_function *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__material_function, 3, 0);
  }
  {
    arg4 = (bool) SCM_NFALSEP(argv[3]);
  }
  {
    arg5 = (double) scm_num2dbl(argv[4], FUNC_NAME);
  }
  {
    arg6 = (int) scm_num2int(argv[5], SCM_ARG1, FUNC_NAME);
  }
  (arg1)->set_chi1inv(arg2,*arg3,arg4,arg5,arg6);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_chi1inv__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-set-chi1inv"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::component arg2 ;
  meep::material_function *arg3 = 0 ;
  bool arg4 ;
  double arg5 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::material_function *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__material_function, 3, 0);
  }
  {
    arg4 = (bool) SCM_NFALSEP(argv[3]);
  }
  {
    arg5 = (double) scm_num2dbl(argv[4], FUNC_NAME);
  }
  (arg1)->set_chi1inv(arg2,*arg3,arg4,arg5);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_chi1inv__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-set-chi1inv"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::component arg2 ;
  meep::material_function *arg3 = 0 ;
  bool arg4 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::material_function *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__material_function, 3, 0);
  }
  {
    arg4 = (bool) SCM_NFALSEP(argv[3]);
  }
  (arg1)->set_chi1inv(arg2,*arg3,arg4);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_chi1inv__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-set-chi1inv"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::component arg2 ;
  meep::material_function *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::material_function *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__material_function, 3, 0);
  }
  (arg1)->set_chi1inv(arg2,*arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_chi1inv(SCM rest)
{
#define FUNC_NAME "meep-structure-set-chi1inv"
  SCM argv[6];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 6, "meep-structure-set-chi1inv");
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__material_function, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_meep_structure_set_chi1inv__SWIG_3(argc,argv);
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__material_function, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            _v = SCM_BOOLP(argv[3]) ? 1 : 0;
          }
          if (_v) {
            return _wrap_meep_structure_set_chi1inv__SWIG_2(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__material_function, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            _v = SCM_BOOLP(argv[3]) ? 1 : 0;
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_real_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              return _wrap_meep_structure_set_chi1inv__SWIG_1(argc,argv);
            }
          }
        }
      }
    }
  }
  if (argc == 6) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__material_function, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            _v = SCM_BOOLP(argv[3]) ? 1 : 0;
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_real_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              {
                _v = SCM_NFALSEP(scm_integer_p(argv[5])) ? 1 : 0;
              }
              if (_v) {
                return _wrap_meep_structure_set_chi1inv__SWIG_0(argc,argv);
              }
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-structure-set-chi1inv", "No matching method for generic function `meep_structure_set_chi1inv'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_has_chi1inv (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-structure-has-chi1inv"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::component arg2 ;
  meep::direction arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::direction) scm_num2int(s_2, SCM_ARG1, FUNC_NAME); 
  }
  result = (bool)((meep::structure const *)arg1)->has_chi1inv(arg2,arg3);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_epsilon__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-set-epsilon"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::material_function *arg2 = 0 ;
  bool arg3 ;
  double arg4 ;
  int arg5 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::material_function *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__material_function, 2, 0);
  }
  {
    arg3 = (bool) SCM_NFALSEP(argv[2]);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  {
    arg5 = (int) scm_num2int(argv[4], SCM_ARG1, FUNC_NAME);
  }
  (arg1)->set_epsilon(*arg2,arg3,arg4,arg5);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_epsilon__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-set-epsilon"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::material_function *arg2 = 0 ;
  bool arg3 ;
  double arg4 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::material_function *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__material_function, 2, 0);
  }
  {
    arg3 = (bool) SCM_NFALSEP(argv[2]);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  (arg1)->set_epsilon(*arg2,arg3,arg4);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_epsilon__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-set-epsilon"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::material_function *arg2 = 0 ;
  bool arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::material_function *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__material_function, 2, 0);
  }
  {
    arg3 = (bool) SCM_NFALSEP(argv[2]);
  }
  (arg1)->set_epsilon(*arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_epsilon__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-set-epsilon"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::material_function *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::material_function *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__material_function, 2, 0);
  }
  (arg1)->set_epsilon(*arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_epsilon__SWIG_4 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-set-epsilon"
  meep::structure *arg1 = (meep::structure *) 0 ;
  double (*arg2)(meep::vec const &) = (double (*)(meep::vec const &)) 0 ;
  bool arg3 ;
  double arg4 ;
  int arg5 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (double (*)(meep::vec const &))SWIG_MustGetPtr(argv[1], SWIGTYPE_p_f_r_q_const__meep__vec__double, 2, 0);
  }
  {
    arg3 = (bool) SCM_NFALSEP(argv[2]);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  {
    arg5 = (int) scm_num2int(argv[4], SCM_ARG1, FUNC_NAME);
  }
  (arg1)->set_epsilon(arg2,arg3,arg4,arg5);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_epsilon__SWIG_5 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-set-epsilon"
  meep::structure *arg1 = (meep::structure *) 0 ;
  double (*arg2)(meep::vec const &) = (double (*)(meep::vec const &)) 0 ;
  bool arg3 ;
  double arg4 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (double (*)(meep::vec const &))SWIG_MustGetPtr(argv[1], SWIGTYPE_p_f_r_q_const__meep__vec__double, 2, 0);
  }
  {
    arg3 = (bool) SCM_NFALSEP(argv[2]);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  (arg1)->set_epsilon(arg2,arg3,arg4);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_epsilon__SWIG_6 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-set-epsilon"
  meep::structure *arg1 = (meep::structure *) 0 ;
  double (*arg2)(meep::vec const &) = (double (*)(meep::vec const &)) 0 ;
  bool arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (double (*)(meep::vec const &))SWIG_MustGetPtr(argv[1], SWIGTYPE_p_f_r_q_const__meep__vec__double, 2, 0);
  }
  {
    arg3 = (bool) SCM_NFALSEP(argv[2]);
  }
  (arg1)->set_epsilon(arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_epsilon__SWIG_7 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-set-epsilon"
  meep::structure *arg1 = (meep::structure *) 0 ;
  double (*arg2)(meep::vec const &) = (double (*)(meep::vec const &)) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (double (*)(meep::vec const &))SWIG_MustGetPtr(argv[1], SWIGTYPE_p_f_r_q_const__meep__vec__double, 2, 0);
  }
  (arg1)->set_epsilon(arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_epsilon(SCM rest)
{
#define FUNC_NAME "meep-structure-set-epsilon"
  SCM argv[5];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 5, "meep-structure-set-epsilon");
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__material_function, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_meep_structure_set_epsilon__SWIG_3(argc,argv);
      }
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_f_r_q_const__meep__vec__double, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_meep_structure_set_epsilon__SWIG_7(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_f_r_q_const__meep__vec__double, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_BOOLP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_structure_set_epsilon__SWIG_6(argc,argv);
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__material_function, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_BOOLP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_structure_set_epsilon__SWIG_2(argc,argv);
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__material_function, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_BOOLP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            return _wrap_meep_structure_set_epsilon__SWIG_1(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_f_r_q_const__meep__vec__double, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_BOOLP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            return _wrap_meep_structure_set_epsilon__SWIG_5(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_f_r_q_const__meep__vec__double, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_BOOLP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_integer_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              return _wrap_meep_structure_set_epsilon__SWIG_4(argc,argv);
            }
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__material_function, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_BOOLP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_integer_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              return _wrap_meep_structure_set_epsilon__SWIG_0(argc,argv);
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-structure-set-epsilon", "No matching method for generic function `meep_structure_set_epsilon'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_mu__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-set-mu"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::material_function *arg2 = 0 ;
  bool arg3 ;
  double arg4 ;
  int arg5 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::material_function *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__material_function, 2, 0);
  }
  {
    arg3 = (bool) SCM_NFALSEP(argv[2]);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  {
    arg5 = (int) scm_num2int(argv[4], SCM_ARG1, FUNC_NAME);
  }
  (arg1)->set_mu(*arg2,arg3,arg4,arg5);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_mu__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-set-mu"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::material_function *arg2 = 0 ;
  bool arg3 ;
  double arg4 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::material_function *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__material_function, 2, 0);
  }
  {
    arg3 = (bool) SCM_NFALSEP(argv[2]);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  (arg1)->set_mu(*arg2,arg3,arg4);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_mu__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-set-mu"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::material_function *arg2 = 0 ;
  bool arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::material_function *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__material_function, 2, 0);
  }
  {
    arg3 = (bool) SCM_NFALSEP(argv[2]);
  }
  (arg1)->set_mu(*arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_mu__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-set-mu"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::material_function *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::material_function *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__material_function, 2, 0);
  }
  (arg1)->set_mu(*arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_mu__SWIG_4 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-set-mu"
  meep::structure *arg1 = (meep::structure *) 0 ;
  double (*arg2)(meep::vec const &) = (double (*)(meep::vec const &)) 0 ;
  bool arg3 ;
  double arg4 ;
  int arg5 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (double (*)(meep::vec const &))SWIG_MustGetPtr(argv[1], SWIGTYPE_p_f_r_q_const__meep__vec__double, 2, 0);
  }
  {
    arg3 = (bool) SCM_NFALSEP(argv[2]);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  {
    arg5 = (int) scm_num2int(argv[4], SCM_ARG1, FUNC_NAME);
  }
  (arg1)->set_mu(arg2,arg3,arg4,arg5);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_mu__SWIG_5 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-set-mu"
  meep::structure *arg1 = (meep::structure *) 0 ;
  double (*arg2)(meep::vec const &) = (double (*)(meep::vec const &)) 0 ;
  bool arg3 ;
  double arg4 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (double (*)(meep::vec const &))SWIG_MustGetPtr(argv[1], SWIGTYPE_p_f_r_q_const__meep__vec__double, 2, 0);
  }
  {
    arg3 = (bool) SCM_NFALSEP(argv[2]);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  (arg1)->set_mu(arg2,arg3,arg4);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_mu__SWIG_6 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-set-mu"
  meep::structure *arg1 = (meep::structure *) 0 ;
  double (*arg2)(meep::vec const &) = (double (*)(meep::vec const &)) 0 ;
  bool arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (double (*)(meep::vec const &))SWIG_MustGetPtr(argv[1], SWIGTYPE_p_f_r_q_const__meep__vec__double, 2, 0);
  }
  {
    arg3 = (bool) SCM_NFALSEP(argv[2]);
  }
  (arg1)->set_mu(arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_mu__SWIG_7 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-set-mu"
  meep::structure *arg1 = (meep::structure *) 0 ;
  double (*arg2)(meep::vec const &) = (double (*)(meep::vec const &)) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (double (*)(meep::vec const &))SWIG_MustGetPtr(argv[1], SWIGTYPE_p_f_r_q_const__meep__vec__double, 2, 0);
  }
  (arg1)->set_mu(arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_mu(SCM rest)
{
#define FUNC_NAME "meep-structure-set-mu"
  SCM argv[5];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 5, "meep-structure-set-mu");
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__material_function, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_meep_structure_set_mu__SWIG_3(argc,argv);
      }
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_f_r_q_const__meep__vec__double, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_meep_structure_set_mu__SWIG_7(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_f_r_q_const__meep__vec__double, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_BOOLP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_structure_set_mu__SWIG_6(argc,argv);
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__material_function, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_BOOLP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_structure_set_mu__SWIG_2(argc,argv);
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__material_function, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_BOOLP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            return _wrap_meep_structure_set_mu__SWIG_1(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_f_r_q_const__meep__vec__double, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_BOOLP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            return _wrap_meep_structure_set_mu__SWIG_5(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_f_r_q_const__meep__vec__double, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_BOOLP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_integer_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              return _wrap_meep_structure_set_mu__SWIG_4(argc,argv);
            }
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__material_function, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_BOOLP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_integer_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              return _wrap_meep_structure_set_mu__SWIG_0(argc,argv);
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-structure-set-mu", "No matching method for generic function `meep_structure_set_mu'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_conductivity__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-set-conductivity"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::component arg2 ;
  meep::material_function *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::material_function *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__material_function, 3, 0);
  }
  (arg1)->set_conductivity(arg2,*arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_conductivity__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-set-conductivity"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::component arg2 ;
  double (*arg3)(meep::vec const &) = (double (*)(meep::vec const &)) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (double (*)(meep::vec const &))SWIG_MustGetPtr(argv[2], SWIGTYPE_p_f_r_q_const__meep__vec__double, 3, 0);
  }
  (arg1)->set_conductivity(arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_conductivity(SCM rest)
{
#define FUNC_NAME "meep-structure-set-conductivity"
  SCM argv[3];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "meep-structure-set-conductivity");
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__material_function, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_meep_structure_set_conductivity__SWIG_0(argc,argv);
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_f_r_q_const__meep__vec__double, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_meep_structure_set_conductivity__SWIG_1(argc,argv);
        }
      }
    }
  }
  
  scm_misc_error("meep-structure-set-conductivity", "No matching method for generic function `meep_structure_set_conductivity'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_chi3__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-set-chi3"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::component arg2 ;
  meep::material_function *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::material_function *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__material_function, 3, 0);
  }
  (arg1)->set_chi3(arg2,*arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_chi3__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-set-chi3"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::material_function *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::material_function *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__material_function, 2, 0);
  }
  (arg1)->set_chi3(*arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_chi3__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-set-chi3"
  meep::structure *arg1 = (meep::structure *) 0 ;
  double (*arg2)(meep::vec const &) = (double (*)(meep::vec const &)) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (double (*)(meep::vec const &))SWIG_MustGetPtr(argv[1], SWIGTYPE_p_f_r_q_const__meep__vec__double, 2, 0);
  }
  (arg1)->set_chi3(arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_chi3(SCM rest)
{
#define FUNC_NAME "meep-structure-set-chi3"
  SCM argv[3];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "meep-structure-set-chi3");
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__material_function, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_meep_structure_set_chi3__SWIG_1(argc,argv);
      }
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_f_r_q_const__meep__vec__double, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_meep_structure_set_chi3__SWIG_2(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__material_function, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_meep_structure_set_chi3__SWIG_0(argc,argv);
        }
      }
    }
  }
  
  scm_misc_error("meep-structure-set-chi3", "No matching method for generic function `meep_structure_set_chi3'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_chi2__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-set-chi2"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::component arg2 ;
  meep::material_function *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::material_function *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__material_function, 3, 0);
  }
  (arg1)->set_chi2(arg2,*arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_chi2__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-set-chi2"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::material_function *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::material_function *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__material_function, 2, 0);
  }
  (arg1)->set_chi2(*arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_chi2__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-set-chi2"
  meep::structure *arg1 = (meep::structure *) 0 ;
  double (*arg2)(meep::vec const &) = (double (*)(meep::vec const &)) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (double (*)(meep::vec const &))SWIG_MustGetPtr(argv[1], SWIGTYPE_p_f_r_q_const__meep__vec__double, 2, 0);
  }
  (arg1)->set_chi2(arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_chi2(SCM rest)
{
#define FUNC_NAME "meep-structure-set-chi2"
  SCM argv[3];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "meep-structure-set-chi2");
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__material_function, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_meep_structure_set_chi2__SWIG_1(argc,argv);
      }
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_f_r_q_const__meep__vec__double, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_meep_structure_set_chi2__SWIG_2(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__material_function, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_meep_structure_set_chi2__SWIG_0(argc,argv);
        }
      }
    }
  }
  
  scm_misc_error("meep-structure-set-chi2", "No matching method for generic function `meep_structure_set_chi2'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_add_polarizability__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-add-polarizability"
  meep::structure *arg1 = (meep::structure *) 0 ;
  double (*arg2)(meep::vec const &) = (double (*)(meep::vec const &)) 0 ;
  meep::field_type arg3 ;
  double arg4 ;
  double arg5 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::polarizability_identifier result;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (double (*)(meep::vec const &))SWIG_MustGetPtr(argv[1], SWIGTYPE_p_f_r_q_const__meep__vec__double, 2, 0);
  }
  {
    arg3 = (meep::field_type) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  {
    arg5 = (double) scm_num2dbl(argv[4], FUNC_NAME);
  }
  result = (arg1)->add_polarizability(arg2,arg3,arg4,arg5);
  {
    meep::polarizability_identifier * resultptr;
    resultptr = new meep::polarizability_identifier((const meep::polarizability_identifier &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__polarizability_identifier, 1);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_add_polarizability__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-add-polarizability"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::material_function *arg2 = 0 ;
  meep::field_type arg3 ;
  double arg4 ;
  double arg5 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::polarizability_identifier result;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::material_function *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__material_function, 2, 0);
  }
  {
    arg3 = (meep::field_type) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  {
    arg5 = (double) scm_num2dbl(argv[4], FUNC_NAME);
  }
  result = (arg1)->add_polarizability(*arg2,arg3,arg4,arg5);
  {
    meep::polarizability_identifier * resultptr;
    resultptr = new meep::polarizability_identifier((const meep::polarizability_identifier &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__polarizability_identifier, 1);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_add_polarizability__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-add-polarizability"
  meep::structure *arg1 = (meep::structure *) 0 ;
  double (*arg2)(meep::vec const &) = (double (*)(meep::vec const &)) 0 ;
  double arg3 ;
  double arg4 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::polarizability_identifier result;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (double (*)(meep::vec const &))SWIG_MustGetPtr(argv[1], SWIGTYPE_p_f_r_q_const__meep__vec__double, 2, 0);
  }
  {
    arg3 = (double) scm_num2dbl(argv[2], FUNC_NAME);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  result = (arg1)->add_polarizability(arg2,arg3,arg4);
  {
    meep::polarizability_identifier * resultptr;
    resultptr = new meep::polarizability_identifier((const meep::polarizability_identifier &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__polarizability_identifier, 1);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_add_polarizability__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-add-polarizability"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::material_function *arg2 = 0 ;
  double arg3 ;
  double arg4 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::polarizability_identifier result;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::material_function *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__material_function, 2, 0);
  }
  {
    arg3 = (double) scm_num2dbl(argv[2], FUNC_NAME);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  result = (arg1)->add_polarizability(*arg2,arg3,arg4);
  {
    meep::polarizability_identifier * resultptr;
    resultptr = new meep::polarizability_identifier((const meep::polarizability_identifier &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__polarizability_identifier, 1);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_add_polarizability(SCM rest)
{
#define FUNC_NAME "meep-structure-add-polarizability"
  SCM argv[5];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 5, "meep-structure-add-polarizability");
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_f_r_q_const__meep__vec__double, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_real_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            return _wrap_meep_structure_add_polarizability__SWIG_2(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__material_function, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_real_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            return _wrap_meep_structure_add_polarizability__SWIG_3(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_f_r_q_const__meep__vec__double, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_real_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              return _wrap_meep_structure_add_polarizability__SWIG_0(argc,argv);
            }
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__material_function, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_real_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              return _wrap_meep_structure_add_polarizability__SWIG_1(argc,argv);
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-structure-add-polarizability", "No matching method for generic function `meep_structure_add_polarizability'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_remove_polarizabilities (SCM s_0)
{
#define FUNC_NAME "meep-structure-remove-polarizabilities"
  meep::structure *arg1 = (meep::structure *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  (arg1)->remove_polarizabilities();
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_set_output_directory (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-structure-set-output-directory"
  meep::structure *arg1 = (meep::structure *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  (arg1)->set_output_directory((char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_mix_with (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-structure-mix-with"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::structure *arg2 = (meep::structure *) 0 ;
  double arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::structure *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__structure, 2, 0);
  }
  {
    arg3 = (double) scm_num2dbl(s_2, FUNC_NAME);
  }
  (arg1)->mix_with((meep::structure const *)arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_equal_layout (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-structure-equal-layout"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::structure *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::structure *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__structure, 2, 0);
  }
  result = (bool)((meep::structure const *)arg1)->equal_layout((meep::structure const &)*arg2);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_print_layout (SCM s_0)
{
#define FUNC_NAME "meep-structure-print-layout"
  meep::structure *arg1 = (meep::structure *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  ((meep::structure const *)arg1)->print_layout();
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_get_chi1inv__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-get-chi1inv"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::component arg2 ;
  meep::direction arg3 ;
  meep::ivec *arg4 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::direction) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg4 = (meep::ivec *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__ivec, 4, 0);
  }
  result = (double)((meep::structure const *)arg1)->get_chi1inv(arg2,arg3,(meep::ivec const &)*arg4);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_get_chi1inv__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-get-chi1inv"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::component arg2 ;
  meep::direction arg3 ;
  meep::vec *arg4 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::direction) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME); 
  }
  
  meep::vec vec__arg4 = vector3_to_vec(ctl_convert_vector3_to_c(argv[3]));
  arg4 = &vec__arg4;
  
  result = (double)((meep::structure const *)arg1)->get_chi1inv(arg2,arg3,(meep::vec const &)*arg4);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_get_chi1inv(SCM rest)
{
#define FUNC_NAME "meep-structure-get-chi1inv"
  SCM argv[4];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 4, "meep-structure-get-chi1inv");
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__ivec, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            return _wrap_meep_structure_get_chi1inv__SWIG_0(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SwigVector3_Check(argv[3]);
          }
          if (_v) {
            return _wrap_meep_structure_get_chi1inv__SWIG_1(argc,argv);
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-structure-get-chi1inv", "No matching method for generic function `meep_structure_get_chi1inv'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_get_inveps__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-get-inveps"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::component arg2 ;
  meep::direction arg3 ;
  meep::ivec *arg4 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::direction) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg4 = (meep::ivec *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__ivec, 4, 0);
  }
  result = (double)((meep::structure const *)arg1)->get_inveps(arg2,arg3,(meep::ivec const &)*arg4);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_get_inveps__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-structure-get-inveps"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::component arg2 ;
  meep::direction arg3 ;
  meep::vec *arg4 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::direction) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME); 
  }
  
  meep::vec vec__arg4 = vector3_to_vec(ctl_convert_vector3_to_c(argv[3]));
  arg4 = &vec__arg4;
  
  result = (double)((meep::structure const *)arg1)->get_inveps(arg2,arg3,(meep::vec const &)*arg4);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_get_inveps(SCM rest)
{
#define FUNC_NAME "meep-structure-get-inveps"
  SCM argv[4];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 4, "meep-structure-get-inveps");
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__ivec, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            return _wrap_meep_structure_get_inveps__SWIG_0(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SwigVector3_Check(argv[3]);
          }
          if (_v) {
            return _wrap_meep_structure_get_inveps__SWIG_1(argc,argv);
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-structure-get-inveps", "No matching method for generic function `meep_structure_get_inveps'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_get_eps (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-structure-get-eps"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::vec *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  
  meep::vec vec__arg2 = vector3_to_vec(ctl_convert_vector3_to_c(s_1));
  arg2 = &vec__arg2;
  
  result = (double)((meep::structure const *)arg1)->get_eps((meep::vec const &)*arg2);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_get_mu (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-structure-get-mu"
  meep::structure *arg1 = (meep::structure *) 0 ;
  meep::vec *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  
  meep::vec vec__arg2 = vector3_to_vec(ctl_convert_vector3_to_c(s_1));
  arg2 = &vec__arg2;
  
  result = (double)((meep::structure const *)arg1)->get_mu((meep::vec const &)*arg2);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_structure_max_eps (SCM s_0)
{
#define FUNC_NAME "meep-structure-max-eps"
  meep::structure *arg1 = (meep::structure *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__structure, 1, 0);
  }
  result = (double)((meep::structure const *)arg1)->max_eps();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_src_time_is_integrated_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-src-time-is-integrated-set"
  meep::src_time *arg1 = (meep::src_time *) 0 ;
  bool arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::src_time *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__src_time, 1, 0);
  }
  {
    arg2 = (bool) SCM_NFALSEP(s_1);
  }
  if (arg1) (arg1)->is_integrated = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_src_time_is_integrated_get (SCM s_0)
{
#define FUNC_NAME "meep-src-time-is-integrated-get"
  meep::src_time *arg1 = (meep::src_time *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::src_time *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__src_time, 1, 0);
  }
  result = (bool) ((arg1)->is_integrated);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_src_time__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-src-time"
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::src_time *result = 0 ;
  
  result = (meep::src_time *)new meep::src_time();
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__src_time, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_delete_meep_src_time (SCM s_0)
{
#define FUNC_NAME "delete-meep-src-time"
  meep::src_time *arg1 = (meep::src_time *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::src_time *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__src_time, 1, 0);
  }
  delete arg1;
  gswig_result = SCM_UNSPECIFIED;
  
  SWIG_Guile_MarkPointerDestroyed(s_0);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_src_time__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-src-time"
  meep::src_time *arg1 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::src_time *result = 0 ;
  
  {
    arg1 = (meep::src_time *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__src_time, 1, 0);
  }
  result = (meep::src_time *)new meep::src_time((meep::src_time const &)*arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__src_time, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_src_time(SCM rest)
{
#define FUNC_NAME "new-meep-src-time"
  SCM argv[1];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 1, "new-meep-src-time");
  if (argc == 0) {
    return _wrap_new_meep_src_time__SWIG_0(argc,argv);
  }
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__src_time, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      return _wrap_new_meep_src_time__SWIG_1(argc,argv);
    }
  }
  
  scm_misc_error("new-meep-src-time", "No matching method for generic function `new_meep_src_time'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_src_time_dipole__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-src-time-dipole"
  meep::src_time *arg1 = (meep::src_time *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > result;
  
  {
    arg1 = (meep::src_time *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__src_time, 1, 0);
  }
  result = ((meep::src_time const *)arg1)->dipole();
  {
    gswig_result = scm_make_rectangular(scm_make_real((&result)->real()),
      scm_make_real((&result)->imag()));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_src_time_current__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-src-time-current"
  meep::src_time *arg1 = (meep::src_time *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > result;
  
  {
    arg1 = (meep::src_time *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__src_time, 1, 0);
  }
  result = ((meep::src_time const *)arg1)->current();
  {
    gswig_result = scm_make_rectangular(scm_make_real((&result)->real()),
      scm_make_real((&result)->imag()));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_src_time_update (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-src-time-update"
  meep::src_time *arg1 = (meep::src_time *) 0 ;
  double arg2 ;
  double arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::src_time *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__src_time, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  {
    arg3 = (double) scm_num2dbl(s_2, FUNC_NAME);
  }
  (arg1)->update(arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_src_time_current__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-src-time-current"
  meep::src_time *arg1 = (meep::src_time *) 0 ;
  double arg2 ;
  double arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > result;
  
  {
    arg1 = (meep::src_time *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__src_time, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(argv[1], FUNC_NAME);
  }
  {
    arg3 = (double) scm_num2dbl(argv[2], FUNC_NAME);
  }
  result = ((meep::src_time const *)arg1)->current(arg2,arg3);
  {
    gswig_result = scm_make_rectangular(scm_make_real((&result)->real()),
      scm_make_real((&result)->imag()));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_src_time_current(SCM rest)
{
#define FUNC_NAME "meep-src-time-current"
  SCM argv[3];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "meep-src-time-current");
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__src_time, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      return _wrap_meep_src_time_current__SWIG_0(argc,argv);
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__src_time, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_real_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_real_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_src_time_current__SWIG_1(argc,argv);
        }
      }
    }
  }
  
  scm_misc_error("meep-src-time-current", "No matching method for generic function `meep_src_time_current'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_src_time_last_time_max__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-src-time-last-time-max"
  meep::src_time *arg1 = (meep::src_time *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::src_time *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__src_time, 1, 0);
  }
  result = (double)(arg1)->last_time_max();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_src_time_last_time_max__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-src-time-last-time-max"
  meep::src_time *arg1 = (meep::src_time *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::src_time *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__src_time, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(argv[1], FUNC_NAME);
  }
  result = (double)(arg1)->last_time_max(arg2);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_src_time_last_time_max(SCM rest)
{
#define FUNC_NAME "meep-src-time-last-time-max"
  SCM argv[2];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 2, "meep-src-time-last-time-max");
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__src_time, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      return _wrap_meep_src_time_last_time_max__SWIG_0(argc,argv);
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__src_time, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_real_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        return _wrap_meep_src_time_last_time_max__SWIG_1(argc,argv);
      }
    }
  }
  
  scm_misc_error("meep-src-time-last-time-max", "No matching method for generic function `meep_src_time_last_time_max'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_src_time_add_to (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-src-time-add-to"
  meep::src_time *arg1 = (meep::src_time *) 0 ;
  meep::src_time *arg2 = (meep::src_time *) 0 ;
  meep::src_time **arg3 = (meep::src_time **) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::src_time *result = 0 ;
  
  {
    arg1 = (meep::src_time *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__src_time, 1, 0);
  }
  {
    arg2 = (meep::src_time *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__src_time, 2, 0);
  }
  {
    arg3 = (meep::src_time **)SWIG_MustGetPtr(s_2, SWIGTYPE_p_p_meep__src_time, 3, 0);
  }
  result = (meep::src_time *)((meep::src_time const *)arg1)->add_to(arg2,arg3);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__src_time, 0);
  }
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_src_time_next_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-src-time-next-set"
  meep::src_time *arg1 = (meep::src_time *) 0 ;
  meep::src_time *arg2 = (meep::src_time *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::src_time *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__src_time, 1, 0);
  }
  {
    arg2 = (meep::src_time *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__src_time, 2, 0);
  }
  if (arg1) (arg1)->next = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_src_time_next_get (SCM s_0)
{
#define FUNC_NAME "meep-src-time-next-get"
  meep::src_time *arg1 = (meep::src_time *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::src_time *result = 0 ;
  
  {
    arg1 = (meep::src_time *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__src_time, 1, 0);
  }
  result = (meep::src_time *) ((arg1)->next);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__src_time, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_src_time_dipole__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-src-time-dipole"
  meep::src_time *arg1 = (meep::src_time *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > result;
  
  {
    arg1 = (meep::src_time *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__src_time, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(argv[1], FUNC_NAME);
  }
  result = ((meep::src_time const *)arg1)->dipole(arg2);
  {
    gswig_result = scm_make_rectangular(scm_make_real((&result)->real()),
      scm_make_real((&result)->imag()));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_src_time_dipole(SCM rest)
{
#define FUNC_NAME "meep-src-time-dipole"
  SCM argv[2];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 2, "meep-src-time-dipole");
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__src_time, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      return _wrap_meep_src_time_dipole__SWIG_0(argc,argv);
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__src_time, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_real_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        return _wrap_meep_src_time_dipole__SWIG_1(argc,argv);
      }
    }
  }
  
  scm_misc_error("meep-src-time-dipole", "No matching method for generic function `meep_src_time_dipole'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_src_time_last_time (SCM s_0)
{
#define FUNC_NAME "meep-src-time-last-time"
  meep::src_time *arg1 = (meep::src_time *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::src_time *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__src_time, 1, 0);
  }
  result = (double)((meep::src_time const *)arg1)->last_time();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_src_time_clone (SCM s_0)
{
#define FUNC_NAME "meep-src-time-clone"
  meep::src_time *arg1 = (meep::src_time *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::src_time *result = 0 ;
  
  {
    arg1 = (meep::src_time *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__src_time, 1, 0);
  }
  result = (meep::src_time *)((meep::src_time const *)arg1)->clone();
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__src_time, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_src_time_is_equal (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-src-time-is-equal"
  meep::src_time *arg1 = (meep::src_time *) 0 ;
  meep::src_time *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::src_time *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__src_time, 1, 0);
  }
  {
    arg2 = (meep::src_time *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__src_time, 2, 0);
  }
  result = (bool)((meep::src_time const *)arg1)->is_equal((meep::src_time const &)*arg2);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_src_time_frequency (SCM s_0)
{
#define FUNC_NAME "meep-src-time-frequency"
  meep::src_time *arg1 = (meep::src_time *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > result;
  
  {
    arg1 = (meep::src_time *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__src_time, 1, 0);
  }
  result = ((meep::src_time const *)arg1)->frequency();
  {
    gswig_result = scm_make_rectangular(scm_make_real((&result)->real()),
      scm_make_real((&result)->imag()));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_src_time_set_frequency (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-src-time-set-frequency"
  meep::src_time *arg1 = (meep::src_time *) 0 ;
  complex< double > arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::src_time *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__src_time, 1, 0);
  }
  {
    cnumber cnum = ctl_convert_cnumber_to_c(s_1);
    arg2 = std::complex<double>(cnum.re, cnum.im);
  }
  (arg1)->set_frequency(arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_src_times_equal (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-src-times-equal"
  meep::src_time *arg1 = 0 ;
  meep::src_time *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::src_time *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__src_time, 1, 0);
  }
  {
    arg2 = (meep::src_time *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__src_time, 2, 0);
  }
  result = (bool)meep::src_times_equal((meep::src_time const &)*arg1,(meep::src_time const &)*arg2);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_gaussian_src_time__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-gaussian-src-time"
  double arg1 ;
  double arg2 ;
  double arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::gaussian_src_time *result = 0 ;
  
  {
    arg1 = (double) scm_num2dbl(argv[0], FUNC_NAME);
  }
  {
    arg2 = (double) scm_num2dbl(argv[1], FUNC_NAME);
  }
  {
    arg3 = (double) scm_num2dbl(argv[2], FUNC_NAME);
  }
  result = (meep::gaussian_src_time *)new meep::gaussian_src_time(arg1,arg2,arg3);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__gaussian_src_time, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_gaussian_src_time__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-gaussian-src-time"
  double arg1 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::gaussian_src_time *result = 0 ;
  
  {
    arg1 = (double) scm_num2dbl(argv[0], FUNC_NAME);
  }
  {
    arg2 = (double) scm_num2dbl(argv[1], FUNC_NAME);
  }
  result = (meep::gaussian_src_time *)new meep::gaussian_src_time(arg1,arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__gaussian_src_time, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_gaussian_src_time__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-gaussian-src-time"
  double arg1 ;
  double arg2 ;
  double arg3 ;
  double arg4 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::gaussian_src_time *result = 0 ;
  
  {
    arg1 = (double) scm_num2dbl(argv[0], FUNC_NAME);
  }
  {
    arg2 = (double) scm_num2dbl(argv[1], FUNC_NAME);
  }
  {
    arg3 = (double) scm_num2dbl(argv[2], FUNC_NAME);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  result = (meep::gaussian_src_time *)new meep::gaussian_src_time(arg1,arg2,arg3,arg4);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__gaussian_src_time, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_gaussian_src_time(SCM rest)
{
#define FUNC_NAME "new-meep-gaussian-src-time"
  SCM argv[4];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 4, "new-meep-gaussian-src-time");
  if (argc == 2) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_real_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_real_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        return _wrap_new_meep_gaussian_src_time__SWIG_1(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_real_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_real_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_real_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_new_meep_gaussian_src_time__SWIG_0(argc,argv);
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_real_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_real_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_real_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            return _wrap_new_meep_gaussian_src_time__SWIG_2(argc,argv);
          }
        }
      }
    }
  }
  
  scm_misc_error("new-meep-gaussian-src-time", "No matching method for generic function `new_meep_gaussian_src_time'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_delete_meep_gaussian_src_time (SCM s_0)
{
#define FUNC_NAME "delete-meep-gaussian-src-time"
  meep::gaussian_src_time *arg1 = (meep::gaussian_src_time *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::gaussian_src_time *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__gaussian_src_time, 1, 0);
  }
  delete arg1;
  gswig_result = SCM_UNSPECIFIED;
  
  SWIG_Guile_MarkPointerDestroyed(s_0);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_gaussian_src_time_dipole (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-gaussian-src-time-dipole"
  meep::gaussian_src_time *arg1 = (meep::gaussian_src_time *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > result;
  
  {
    arg1 = (meep::gaussian_src_time *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__gaussian_src_time, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  result = ((meep::gaussian_src_time const *)arg1)->dipole(arg2);
  {
    gswig_result = scm_make_rectangular(scm_make_real((&result)->real()),
      scm_make_real((&result)->imag()));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_gaussian_src_time_last_time (SCM s_0)
{
#define FUNC_NAME "meep-gaussian-src-time-last-time"
  meep::gaussian_src_time *arg1 = (meep::gaussian_src_time *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::gaussian_src_time *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__gaussian_src_time, 1, 0);
  }
  result = (double)((meep::gaussian_src_time const *)arg1)->last_time();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_gaussian_src_time_clone (SCM s_0)
{
#define FUNC_NAME "meep-gaussian-src-time-clone"
  meep::gaussian_src_time *arg1 = (meep::gaussian_src_time *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::src_time *result = 0 ;
  
  {
    arg1 = (meep::gaussian_src_time *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__gaussian_src_time, 1, 0);
  }
  result = (meep::src_time *)((meep::gaussian_src_time const *)arg1)->clone();
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__src_time, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_gaussian_src_time_is_equal (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-gaussian-src-time-is-equal"
  meep::gaussian_src_time *arg1 = (meep::gaussian_src_time *) 0 ;
  meep::src_time *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::gaussian_src_time *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__gaussian_src_time, 1, 0);
  }
  {
    arg2 = (meep::src_time *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__src_time, 2, 0);
  }
  result = (bool)((meep::gaussian_src_time const *)arg1)->is_equal((meep::src_time const &)*arg2);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_gaussian_src_time_frequency (SCM s_0)
{
#define FUNC_NAME "meep-gaussian-src-time-frequency"
  meep::gaussian_src_time *arg1 = (meep::gaussian_src_time *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > result;
  
  {
    arg1 = (meep::gaussian_src_time *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__gaussian_src_time, 1, 0);
  }
  result = ((meep::gaussian_src_time const *)arg1)->frequency();
  {
    gswig_result = scm_make_rectangular(scm_make_real((&result)->real()),
      scm_make_real((&result)->imag()));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_gaussian_src_time_set_frequency (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-gaussian-src-time-set-frequency"
  meep::gaussian_src_time *arg1 = (meep::gaussian_src_time *) 0 ;
  complex< double > arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::gaussian_src_time *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__gaussian_src_time, 1, 0);
  }
  {
    cnumber cnum = ctl_convert_cnumber_to_c(s_1);
    arg2 = std::complex<double>(cnum.re, cnum.im);
  }
  (arg1)->set_frequency(arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_continuous_src_time__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-continuous-src-time"
  complex< double > arg1 ;
  double arg2 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::continuous_src_time *result = 0 ;
  
  {
    cnumber cnum = ctl_convert_cnumber_to_c(argv[0]);
    arg1 = std::complex<double>(cnum.re, cnum.im);
  }
  {
    arg2 = (double) scm_num2dbl(argv[1], FUNC_NAME);
  }
  {
    arg3 = (double) scm_num2dbl(argv[2], FUNC_NAME);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  {
    arg5 = (double) scm_num2dbl(argv[4], FUNC_NAME);
  }
  result = (meep::continuous_src_time *)new meep::continuous_src_time(arg1,arg2,arg3,arg4,arg5);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__continuous_src_time, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_continuous_src_time__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-continuous-src-time"
  complex< double > arg1 ;
  double arg2 ;
  double arg3 ;
  double arg4 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::continuous_src_time *result = 0 ;
  
  {
    cnumber cnum = ctl_convert_cnumber_to_c(argv[0]);
    arg1 = std::complex<double>(cnum.re, cnum.im);
  }
  {
    arg2 = (double) scm_num2dbl(argv[1], FUNC_NAME);
  }
  {
    arg3 = (double) scm_num2dbl(argv[2], FUNC_NAME);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  result = (meep::continuous_src_time *)new meep::continuous_src_time(arg1,arg2,arg3,arg4);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__continuous_src_time, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_continuous_src_time__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-continuous-src-time"
  complex< double > arg1 ;
  double arg2 ;
  double arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::continuous_src_time *result = 0 ;
  
  {
    cnumber cnum = ctl_convert_cnumber_to_c(argv[0]);
    arg1 = std::complex<double>(cnum.re, cnum.im);
  }
  {
    arg2 = (double) scm_num2dbl(argv[1], FUNC_NAME);
  }
  {
    arg3 = (double) scm_num2dbl(argv[2], FUNC_NAME);
  }
  result = (meep::continuous_src_time *)new meep::continuous_src_time(arg1,arg2,arg3);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__continuous_src_time, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_continuous_src_time__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-continuous-src-time"
  complex< double > arg1 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::continuous_src_time *result = 0 ;
  
  {
    cnumber cnum = ctl_convert_cnumber_to_c(argv[0]);
    arg1 = std::complex<double>(cnum.re, cnum.im);
  }
  {
    arg2 = (double) scm_num2dbl(argv[1], FUNC_NAME);
  }
  result = (meep::continuous_src_time *)new meep::continuous_src_time(arg1,arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__continuous_src_time, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_continuous_src_time__SWIG_4 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-continuous-src-time"
  complex< double > arg1 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::continuous_src_time *result = 0 ;
  
  {
    cnumber cnum = ctl_convert_cnumber_to_c(argv[0]);
    arg1 = std::complex<double>(cnum.re, cnum.im);
  }
  result = (meep::continuous_src_time *)new meep::continuous_src_time(arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__continuous_src_time, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_continuous_src_time(SCM rest)
{
#define FUNC_NAME "new-meep-continuous-src-time"
  SCM argv[5];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 5, "new-meep-continuous-src-time");
  if (argc == 1) {
    int _v;
    {
      _v = SwigComplex_Check(argv[0]);
    }
    if (_v) {
      return _wrap_new_meep_continuous_src_time__SWIG_4(argc,argv);
    }
  }
  if (argc == 2) {
    int _v;
    {
      _v = SwigComplex_Check(argv[0]);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_real_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        return _wrap_new_meep_continuous_src_time__SWIG_3(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      _v = SwigComplex_Check(argv[0]);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_real_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_real_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_new_meep_continuous_src_time__SWIG_2(argc,argv);
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      _v = SwigComplex_Check(argv[0]);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_real_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_real_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            return _wrap_new_meep_continuous_src_time__SWIG_1(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      _v = SwigComplex_Check(argv[0]);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_real_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_real_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_real_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              return _wrap_new_meep_continuous_src_time__SWIG_0(argc,argv);
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("new-meep-continuous-src-time", "No matching method for generic function `new_meep_continuous_src_time'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_delete_meep_continuous_src_time (SCM s_0)
{
#define FUNC_NAME "delete-meep-continuous-src-time"
  meep::continuous_src_time *arg1 = (meep::continuous_src_time *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::continuous_src_time *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__continuous_src_time, 1, 0);
  }
  delete arg1;
  gswig_result = SCM_UNSPECIFIED;
  
  SWIG_Guile_MarkPointerDestroyed(s_0);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_continuous_src_time_dipole (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-continuous-src-time-dipole"
  meep::continuous_src_time *arg1 = (meep::continuous_src_time *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > result;
  
  {
    arg1 = (meep::continuous_src_time *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__continuous_src_time, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  result = ((meep::continuous_src_time const *)arg1)->dipole(arg2);
  {
    gswig_result = scm_make_rectangular(scm_make_real((&result)->real()),
      scm_make_real((&result)->imag()));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_continuous_src_time_last_time (SCM s_0)
{
#define FUNC_NAME "meep-continuous-src-time-last-time"
  meep::continuous_src_time *arg1 = (meep::continuous_src_time *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::continuous_src_time *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__continuous_src_time, 1, 0);
  }
  result = (double)((meep::continuous_src_time const *)arg1)->last_time();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_continuous_src_time_clone (SCM s_0)
{
#define FUNC_NAME "meep-continuous-src-time-clone"
  meep::continuous_src_time *arg1 = (meep::continuous_src_time *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::src_time *result = 0 ;
  
  {
    arg1 = (meep::continuous_src_time *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__continuous_src_time, 1, 0);
  }
  result = (meep::src_time *)((meep::continuous_src_time const *)arg1)->clone();
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__src_time, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_continuous_src_time_is_equal (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-continuous-src-time-is-equal"
  meep::continuous_src_time *arg1 = (meep::continuous_src_time *) 0 ;
  meep::src_time *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::continuous_src_time *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__continuous_src_time, 1, 0);
  }
  {
    arg2 = (meep::src_time *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__src_time, 2, 0);
  }
  result = (bool)((meep::continuous_src_time const *)arg1)->is_equal((meep::src_time const &)*arg2);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_continuous_src_time_frequency (SCM s_0)
{
#define FUNC_NAME "meep-continuous-src-time-frequency"
  meep::continuous_src_time *arg1 = (meep::continuous_src_time *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > result;
  
  {
    arg1 = (meep::continuous_src_time *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__continuous_src_time, 1, 0);
  }
  result = ((meep::continuous_src_time const *)arg1)->frequency();
  {
    gswig_result = scm_make_rectangular(scm_make_real((&result)->real()),
      scm_make_real((&result)->imag()));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_continuous_src_time_set_frequency (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-continuous-src-time-set-frequency"
  meep::continuous_src_time *arg1 = (meep::continuous_src_time *) 0 ;
  complex< double > arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::continuous_src_time *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__continuous_src_time, 1, 0);
  }
  {
    cnumber cnum = ctl_convert_cnumber_to_c(s_1);
    arg2 = std::complex<double>(cnum.re, cnum.im);
  }
  (arg1)->set_frequency(arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_custom_src_time__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-custom-src-time"
  complex< double > (*arg1)(double,void *) = (complex< double > (*)(double,void *)) 0 ;
  void *arg2 = (void *) 0 ;
  double arg3 ;
  double arg4 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::custom_src_time *result = 0 ;
  
  {
    arg1 = my_complex_func2;
    arg2 = (void *) argv[0]; // input is SCM pointer to Scheme function
  }
  {
    arg3 = (double) scm_num2dbl(argv[1], FUNC_NAME);
  }
  {
    arg4 = (double) scm_num2dbl(argv[2], FUNC_NAME);
  }
  result = (meep::custom_src_time *)new meep::custom_src_time(arg1,arg2,arg3,arg4);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__custom_src_time, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_custom_src_time__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-custom-src-time"
  complex< double > (*arg1)(double,void *) = (complex< double > (*)(double,void *)) 0 ;
  void *arg2 = (void *) 0 ;
  double arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::custom_src_time *result = 0 ;
  
  {
    arg1 = my_complex_func2;
    arg2 = (void *) argv[0]; // input is SCM pointer to Scheme function
  }
  {
    arg3 = (double) scm_num2dbl(argv[1], FUNC_NAME);
  }
  result = (meep::custom_src_time *)new meep::custom_src_time(arg1,arg2,arg3);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__custom_src_time, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_custom_src_time__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-custom-src-time"
  complex< double > (*arg1)(double,void *) = (complex< double > (*)(double,void *)) 0 ;
  void *arg2 = (void *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::custom_src_time *result = 0 ;
  
  {
    arg1 = my_complex_func2;
    arg2 = (void *) argv[0]; // input is SCM pointer to Scheme function
  }
  result = (meep::custom_src_time *)new meep::custom_src_time(arg1,arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__custom_src_time, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_custom_src_time(SCM rest)
{
#define FUNC_NAME "new-meep-custom-src-time"
  SCM argv[3];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "new-meep-custom-src-time");
  if (argc == 1) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_procedure_p(argv[0]));
    }
    if (_v) {
      if (argc <= 1) {
        return _wrap_new_meep_custom_src_time__SWIG_2(argc,argv);
      }
      return _wrap_new_meep_custom_src_time__SWIG_2(argc,argv);
    }
  }
  if (argc == 2) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_procedure_p(argv[0]));
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_real_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        return _wrap_new_meep_custom_src_time__SWIG_1(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_procedure_p(argv[0]));
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_real_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_real_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_new_meep_custom_src_time__SWIG_0(argc,argv);
        }
      }
    }
  }
  
  scm_misc_error("new-meep-custom-src-time", "No matching method for generic function `new_meep_custom_src_time'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_delete_meep_custom_src_time (SCM s_0)
{
#define FUNC_NAME "delete-meep-custom-src-time"
  meep::custom_src_time *arg1 = (meep::custom_src_time *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::custom_src_time *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__custom_src_time, 1, 0);
  }
  delete arg1;
  gswig_result = SCM_UNSPECIFIED;
  
  SWIG_Guile_MarkPointerDestroyed(s_0);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_custom_src_time_current (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-custom-src-time-current"
  meep::custom_src_time *arg1 = (meep::custom_src_time *) 0 ;
  double arg2 ;
  double arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > result;
  
  {
    arg1 = (meep::custom_src_time *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__custom_src_time, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  {
    arg3 = (double) scm_num2dbl(s_2, FUNC_NAME);
  }
  result = ((meep::custom_src_time const *)arg1)->current(arg2,arg3);
  {
    gswig_result = scm_make_rectangular(scm_make_real((&result)->real()),
      scm_make_real((&result)->imag()));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_custom_src_time_dipole (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-custom-src-time-dipole"
  meep::custom_src_time *arg1 = (meep::custom_src_time *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > result;
  
  {
    arg1 = (meep::custom_src_time *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__custom_src_time, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  result = ((meep::custom_src_time const *)arg1)->dipole(arg2);
  {
    gswig_result = scm_make_rectangular(scm_make_real((&result)->real()),
      scm_make_real((&result)->imag()));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_custom_src_time_last_time (SCM s_0)
{
#define FUNC_NAME "meep-custom-src-time-last-time"
  meep::custom_src_time *arg1 = (meep::custom_src_time *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::custom_src_time *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__custom_src_time, 1, 0);
  }
  result = (double)((meep::custom_src_time const *)arg1)->last_time();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_custom_src_time_clone (SCM s_0)
{
#define FUNC_NAME "meep-custom-src-time-clone"
  meep::custom_src_time *arg1 = (meep::custom_src_time *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::src_time *result = 0 ;
  
  {
    arg1 = (meep::custom_src_time *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__custom_src_time, 1, 0);
  }
  result = (meep::src_time *)((meep::custom_src_time const *)arg1)->clone();
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__src_time, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_custom_src_time_is_equal (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-custom-src-time-is-equal"
  meep::custom_src_time *arg1 = (meep::custom_src_time *) 0 ;
  meep::src_time *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::custom_src_time *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__custom_src_time, 1, 0);
  }
  {
    arg2 = (meep::src_time *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__src_time, 2, 0);
  }
  result = (bool)((meep::custom_src_time const *)arg1)->is_equal((meep::src_time const &)*arg2);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_monitor_point ()
{
#define FUNC_NAME "new-meep-monitor-point"
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::monitor_point *result = 0 ;
  
  result = (meep::monitor_point *)new meep::monitor_point();
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__monitor_point, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_delete_meep_monitor_point (SCM s_0)
{
#define FUNC_NAME "delete-meep-monitor-point"
  meep::monitor_point *arg1 = (meep::monitor_point *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::monitor_point *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__monitor_point, 1, 0);
  }
  delete arg1;
  gswig_result = SCM_UNSPECIFIED;
  
  SWIG_Guile_MarkPointerDestroyed(s_0);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_monitor_point_loc_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-monitor-point-loc-set"
  meep::monitor_point *arg1 = (meep::monitor_point *) 0 ;
  meep::vec *arg2 = (meep::vec *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::monitor_point *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__monitor_point, 1, 0);
  }
  {
    arg2 = (meep::vec *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__vec, 2, 0);
  }
  if (arg1) (arg1)->loc = *arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_monitor_point_loc_get (SCM s_0)
{
#define FUNC_NAME "meep-monitor-point-loc-get"
  meep::monitor_point *arg1 = (meep::monitor_point *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::vec *result = 0 ;
  
  {
    arg1 = (meep::monitor_point *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__monitor_point, 1, 0);
  }
  result = (meep::vec *)& ((arg1)->loc);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__vec, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_monitor_point_t_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-monitor-point-t-set"
  meep::monitor_point *arg1 = (meep::monitor_point *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::monitor_point *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__monitor_point, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  if (arg1) (arg1)->t = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_monitor_point_t_get (SCM s_0)
{
#define FUNC_NAME "meep-monitor-point-t-get"
  meep::monitor_point *arg1 = (meep::monitor_point *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::monitor_point *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__monitor_point, 1, 0);
  }
  result = (double) ((arg1)->t);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_monitor_point_f_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-monitor-point-f-set"
  meep::monitor_point *arg1 = (meep::monitor_point *) 0 ;
  complex< double > *arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::monitor_point *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__monitor_point, 1, 0);
  }
  {
    arg2 = (complex< double > *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_complexT_double_t, 2, 0);
  }
  {
    size_t ii;
    complex< double > *b = (complex< double > *) arg1->f;
    for (ii = 0; ii < (size_t)meep::NUM_FIELD_COMPONENTS; ii++) b[ii] = *((complex< double > *) arg2 + ii);
  }
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_monitor_point_f_get (SCM s_0)
{
#define FUNC_NAME "meep-monitor-point-f-get"
  meep::monitor_point *arg1 = (meep::monitor_point *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > *result = 0 ;
  
  {
    arg1 = (meep::monitor_point *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__monitor_point, 1, 0);
  }
  result = (complex< double > *)(complex< double > *) ((arg1)->f);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_complexT_double_t, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_monitor_point_next_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-monitor-point-next-set"
  meep::monitor_point *arg1 = (meep::monitor_point *) 0 ;
  meep::monitor_point *arg2 = (meep::monitor_point *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::monitor_point *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__monitor_point, 1, 0);
  }
  {
    arg2 = (meep::monitor_point *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__monitor_point, 2, 0);
  }
  if (arg1) (arg1)->next = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_monitor_point_next_get (SCM s_0)
{
#define FUNC_NAME "meep-monitor-point-next-get"
  meep::monitor_point *arg1 = (meep::monitor_point *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::monitor_point *result = 0 ;
  
  {
    arg1 = (meep::monitor_point *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__monitor_point, 1, 0);
  }
  result = (meep::monitor_point *) ((arg1)->next);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__monitor_point, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_monitor_point_get_component (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-monitor-point-get-component"
  meep::monitor_point *arg1 = (meep::monitor_point *) 0 ;
  meep::component arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > result;
  
  {
    arg1 = (meep::monitor_point *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__monitor_point, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = (arg1)->get_component(arg2);
  {
    gswig_result = scm_make_rectangular(scm_make_real((&result)->real()),
      scm_make_real((&result)->imag()));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_monitor_point_poynting_in_direction__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-monitor-point-poynting-in-direction"
  meep::monitor_point *arg1 = (meep::monitor_point *) 0 ;
  meep::direction arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::monitor_point *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__monitor_point, 1, 0);
  }
  {
    arg2 = (meep::direction) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  result = (double)(arg1)->poynting_in_direction(arg2);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_monitor_point_poynting_in_direction__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-monitor-point-poynting-in-direction"
  meep::monitor_point *arg1 = (meep::monitor_point *) 0 ;
  meep::vec arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::monitor_point *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__monitor_point, 1, 0);
  }
  {
    arg2 = vector3_to_vec(ctl_convert_vector3_to_c(argv[1]));
  }
  result = (double)(arg1)->poynting_in_direction(arg2);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_monitor_point_poynting_in_direction(SCM rest)
{
#define FUNC_NAME "meep-monitor-point-poynting-in-direction"
  SCM argv[2];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 2, "meep-monitor-point-poynting-in-direction");
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__monitor_point, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        return _wrap_meep_monitor_point_poynting_in_direction__SWIG_0(argc,argv);
      }
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__monitor_point, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SwigVector3_Check(argv[1]);
      }
      if (_v) {
        return _wrap_meep_monitor_point_poynting_in_direction__SWIG_1(argc,argv);
      }
    }
  }
  
  scm_misc_error("meep-monitor-point-poynting-in-direction", "No matching method for generic function `meep_monitor_point_poynting_in_direction'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_monitor_point_fourier_transform__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-monitor-point-fourier-transform"
  meep::monitor_point *arg1 = (meep::monitor_point *) 0 ;
  meep::component arg2 ;
  complex< double > **arg3 = (complex< double > **) 0 ;
  complex< double > **arg4 = (complex< double > **) 0 ;
  int *arg5 = (int *) 0 ;
  double arg6 ;
  double arg7 ;
  int arg8 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::monitor_point *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__monitor_point, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (complex< double > **)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_p_complexT_double_t, 3, 0);
  }
  {
    arg4 = (complex< double > **)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_p_complexT_double_t, 4, 0);
  }
  {
    arg5 = (int *)SWIG_MustGetPtr(argv[4], SWIGTYPE_p_int, 5, 0);
  }
  {
    arg6 = (double) scm_num2dbl(argv[5], FUNC_NAME);
  }
  {
    arg7 = (double) scm_num2dbl(argv[6], FUNC_NAME);
  }
  {
    arg8 = (int) scm_num2int(argv[7], SCM_ARG1, FUNC_NAME);
  }
  (arg1)->fourier_transform(arg2,arg3,arg4,arg5,arg6,arg7,arg8);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_monitor_point_fourier_transform__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-monitor-point-fourier-transform"
  meep::monitor_point *arg1 = (meep::monitor_point *) 0 ;
  meep::component arg2 ;
  complex< double > **arg3 = (complex< double > **) 0 ;
  complex< double > **arg4 = (complex< double > **) 0 ;
  int *arg5 = (int *) 0 ;
  double arg6 ;
  double arg7 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::monitor_point *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__monitor_point, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (complex< double > **)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_p_complexT_double_t, 3, 0);
  }
  {
    arg4 = (complex< double > **)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_p_complexT_double_t, 4, 0);
  }
  {
    arg5 = (int *)SWIG_MustGetPtr(argv[4], SWIGTYPE_p_int, 5, 0);
  }
  {
    arg6 = (double) scm_num2dbl(argv[5], FUNC_NAME);
  }
  {
    arg7 = (double) scm_num2dbl(argv[6], FUNC_NAME);
  }
  (arg1)->fourier_transform(arg2,arg3,arg4,arg5,arg6,arg7);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_monitor_point_fourier_transform__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-monitor-point-fourier-transform"
  meep::monitor_point *arg1 = (meep::monitor_point *) 0 ;
  meep::component arg2 ;
  complex< double > **arg3 = (complex< double > **) 0 ;
  complex< double > **arg4 = (complex< double > **) 0 ;
  int *arg5 = (int *) 0 ;
  double arg6 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::monitor_point *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__monitor_point, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (complex< double > **)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_p_complexT_double_t, 3, 0);
  }
  {
    arg4 = (complex< double > **)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_p_complexT_double_t, 4, 0);
  }
  {
    arg5 = (int *)SWIG_MustGetPtr(argv[4], SWIGTYPE_p_int, 5, 0);
  }
  {
    arg6 = (double) scm_num2dbl(argv[5], FUNC_NAME);
  }
  (arg1)->fourier_transform(arg2,arg3,arg4,arg5,arg6);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_monitor_point_fourier_transform__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-monitor-point-fourier-transform"
  meep::monitor_point *arg1 = (meep::monitor_point *) 0 ;
  meep::component arg2 ;
  complex< double > **arg3 = (complex< double > **) 0 ;
  complex< double > **arg4 = (complex< double > **) 0 ;
  int *arg5 = (int *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::monitor_point *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__monitor_point, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (complex< double > **)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_p_complexT_double_t, 3, 0);
  }
  {
    arg4 = (complex< double > **)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_p_complexT_double_t, 4, 0);
  }
  {
    arg5 = (int *)SWIG_MustGetPtr(argv[4], SWIGTYPE_p_int, 5, 0);
  }
  (arg1)->fourier_transform(arg2,arg3,arg4,arg5);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_monitor_point_fourier_transform(SCM rest)
{
#define FUNC_NAME "meep-monitor-point-fourier-transform"
  SCM argv[8];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 8, "meep-monitor-point-fourier-transform");
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__monitor_point, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_p_complexT_double_t, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_p_complexT_double_t, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              void *ptr;
              int res = SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_int, 0);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              return _wrap_meep_monitor_point_fourier_transform__SWIG_3(argc,argv);
            }
          }
        }
      }
    }
  }
  if (argc == 6) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__monitor_point, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_p_complexT_double_t, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_p_complexT_double_t, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              void *ptr;
              int res = SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_int, 0);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              {
                _v = SCM_NFALSEP(scm_real_p(argv[5])) ? 1 : 0;
              }
              if (_v) {
                return _wrap_meep_monitor_point_fourier_transform__SWIG_2(argc,argv);
              }
            }
          }
        }
      }
    }
  }
  if (argc == 7) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__monitor_point, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_p_complexT_double_t, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_p_complexT_double_t, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              void *ptr;
              int res = SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_int, 0);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              {
                _v = SCM_NFALSEP(scm_real_p(argv[5])) ? 1 : 0;
              }
              if (_v) {
                {
                  _v = SCM_NFALSEP(scm_real_p(argv[6])) ? 1 : 0;
                }
                if (_v) {
                  return _wrap_meep_monitor_point_fourier_transform__SWIG_1(argc,argv);
                }
              }
            }
          }
        }
      }
    }
  }
  if (argc == 8) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__monitor_point, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_p_complexT_double_t, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_p_complexT_double_t, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              void *ptr;
              int res = SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_int, 0);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              {
                _v = SCM_NFALSEP(scm_real_p(argv[5])) ? 1 : 0;
              }
              if (_v) {
                {
                  _v = SCM_NFALSEP(scm_real_p(argv[6])) ? 1 : 0;
                }
                if (_v) {
                  {
                    _v = SCM_NFALSEP(scm_integer_p(argv[7])) ? 1 : 0;
                  }
                  if (_v) {
                    return _wrap_meep_monitor_point_fourier_transform__SWIG_0(argc,argv);
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-monitor-point-fourier-transform", "No matching method for generic function `meep_monitor_point_fourier_transform'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_monitor_point_harminv (SCM s_0, SCM s_1, SCM s_2, SCM s_3, SCM s_4, SCM s_5, SCM s_6, SCM s_7)
{
#define FUNC_NAME "meep-monitor-point-harminv"
  meep::monitor_point *arg1 = (meep::monitor_point *) 0 ;
  meep::component arg2 ;
  complex< double > **arg3 = (complex< double > **) 0 ;
  complex< double > **arg4 = (complex< double > **) 0 ;
  int *arg5 = (int *) 0 ;
  double arg6 ;
  double arg7 ;
  int arg8 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::monitor_point *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__monitor_point, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (complex< double > **)SWIG_MustGetPtr(s_2, SWIGTYPE_p_p_complexT_double_t, 3, 0);
  }
  {
    arg4 = (complex< double > **)SWIG_MustGetPtr(s_3, SWIGTYPE_p_p_complexT_double_t, 4, 0);
  }
  {
    arg5 = (int *)SWIG_MustGetPtr(s_4, SWIGTYPE_p_int, 5, 0);
  }
  {
    arg6 = (double) scm_num2dbl(s_5, FUNC_NAME);
  }
  {
    arg7 = (double) scm_num2dbl(s_6, FUNC_NAME);
  }
  {
    arg8 = (int) scm_num2int(s_7, SCM_ARG1, FUNC_NAME);
  }
  (arg1)->harminv(arg2,arg3,arg4,arg5,arg6,arg7,arg8);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_dft_chunk (SCM s_0, SCM s_1, SCM s_2, SCM s_3, SCM s_4, SCM s_5, SCM s_6, SCM s_7, SCM s_8, SCM s_9, SCM s_10, SCM s_11, SCM s_12, SCM s_13)
{
#define FUNC_NAME "new-meep-dft-chunk"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::ivec arg2 ;
  meep::ivec arg3 ;
  meep::vec arg4 ;
  meep::vec arg5 ;
  meep::vec arg6 ;
  meep::vec arg7 ;
  double arg8 ;
  double arg9 ;
  complex< double > arg10 ;
  complex< double > arg11 ;
  meep::component arg12 ;
  bool arg13 ;
  void *arg14 = (void *) 0 ;
  meep::ivec *argp2 ;
  meep::ivec *argp3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::dft_chunk *result = 0 ;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    argp2 = (meep::ivec *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__ivec, 2, 0);
    arg2 = *argp2;
  }
  {
    argp3 = (meep::ivec *)SWIG_MustGetPtr(s_2, SWIGTYPE_p_meep__ivec, 3, 0);
    arg3 = *argp3;
  }
  {
    arg4 = vector3_to_vec(ctl_convert_vector3_to_c(s_3));
  }
  {
    arg5 = vector3_to_vec(ctl_convert_vector3_to_c(s_4));
  }
  {
    arg6 = vector3_to_vec(ctl_convert_vector3_to_c(s_5));
  }
  {
    arg7 = vector3_to_vec(ctl_convert_vector3_to_c(s_6));
  }
  {
    arg8 = (double) scm_num2dbl(s_7, FUNC_NAME);
  }
  {
    arg9 = (double) scm_num2dbl(s_8, FUNC_NAME);
  }
  {
    cnumber cnum = ctl_convert_cnumber_to_c(s_9);
    arg10 = std::complex<double>(cnum.re, cnum.im);
  }
  {
    cnumber cnum = ctl_convert_cnumber_to_c(s_10);
    arg11 = std::complex<double>(cnum.re, cnum.im);
  }
  {
    arg12 = (meep::component) scm_num2int(s_11, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg13 = (bool) SCM_NFALSEP(s_12);
  }
  {
    arg14 = (void *)SWIG_MustGetPtr(s_13, NULL, 14, 0);
  }
  result = (meep::dft_chunk *)new meep::dft_chunk(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13,(void const *)arg14);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__dft_chunk, 1);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_dft_chunk_rest (SCM rest)
{
SCM arg[14];
SWIG_Guile_GetArgs (arg, rest, 14, 0, "new-meep-dft-chunk");
return _wrap_new_meep_dft_chunk(arg[0], arg[1], arg[2], arg[3], arg[4], arg[5], arg[6], arg[7], arg[8], arg[9], arg[10], arg[11], arg[12], arg[13]);
}
static SCM
_wrap_delete_meep_dft_chunk (SCM s_0)
{
#define FUNC_NAME "delete-meep-dft-chunk"
  meep::dft_chunk *arg1 = (meep::dft_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_chunk, 1, 0);
  }
  delete arg1;
  gswig_result = SCM_UNSPECIFIED;
  
  SWIG_Guile_MarkPointerDestroyed(s_0);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_chunk_update_dft (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-dft-chunk-update-dft"
  meep::dft_chunk *arg1 = (meep::dft_chunk *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_chunk, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  (arg1)->update_dft(arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_chunk_scale_dft (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-dft-chunk-scale-dft"
  meep::dft_chunk *arg1 = (meep::dft_chunk *) 0 ;
  complex< double > arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_chunk, 1, 0);
  }
  {
    cnumber cnum = ctl_convert_cnumber_to_c(s_1);
    arg2 = std::complex<double>(cnum.re, cnum.im);
  }
  (arg1)->scale_dft(arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_chunk_meep_dft_chunk_subeq (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-dft-chunk-meep-dft-chunk-subeq"
  meep::dft_chunk *arg1 = (meep::dft_chunk *) 0 ;
  meep::dft_chunk *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_chunk, 1, 0);
  }
  {
    arg2 = (meep::dft_chunk *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__dft_chunk, 2, 0);
  }
  (arg1)->operator -=((meep::dft_chunk const &)*arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_chunk_omega_min_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-dft-chunk-omega-min-set"
  meep::dft_chunk *arg1 = (meep::dft_chunk *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_chunk, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  if (arg1) (arg1)->omega_min = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_chunk_omega_min_get (SCM s_0)
{
#define FUNC_NAME "meep-dft-chunk-omega-min-get"
  meep::dft_chunk *arg1 = (meep::dft_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::dft_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_chunk, 1, 0);
  }
  result = (double) ((arg1)->omega_min);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_chunk_domega_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-dft-chunk-domega-set"
  meep::dft_chunk *arg1 = (meep::dft_chunk *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_chunk, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  if (arg1) (arg1)->domega = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_chunk_domega_get (SCM s_0)
{
#define FUNC_NAME "meep-dft-chunk-domega-get"
  meep::dft_chunk *arg1 = (meep::dft_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::dft_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_chunk, 1, 0);
  }
  result = (double) ((arg1)->domega);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_chunk_Nomega_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-dft-chunk-Nomega-set"
  meep::dft_chunk *arg1 = (meep::dft_chunk *) 0 ;
  int arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_chunk, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(s_1, SCM_ARG1, FUNC_NAME);
  }
  if (arg1) (arg1)->Nomega = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_chunk_Nomega_get (SCM s_0)
{
#define FUNC_NAME "meep-dft-chunk-Nomega-get"
  meep::dft_chunk *arg1 = (meep::dft_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::dft_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_chunk, 1, 0);
  }
  result = (int) ((arg1)->Nomega);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_chunk_c_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-dft-chunk-c-set"
  meep::dft_chunk *arg1 = (meep::dft_chunk *) 0 ;
  meep::component arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_chunk, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  if (arg1) (arg1)->c = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_chunk_c_get (SCM s_0)
{
#define FUNC_NAME "meep-dft-chunk-c-get"
  meep::dft_chunk *arg1 = (meep::dft_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::component result;
  
  {
    arg1 = (meep::dft_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_chunk, 1, 0);
  }
  result = (meep::component) ((arg1)->c);
  {
    gswig_result = scm_long2num(result); 
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_chunk_N_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-dft-chunk-N-set"
  meep::dft_chunk *arg1 = (meep::dft_chunk *) 0 ;
  int arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_chunk, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(s_1, SCM_ARG1, FUNC_NAME);
  }
  if (arg1) (arg1)->N = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_chunk_N_get (SCM s_0)
{
#define FUNC_NAME "meep-dft-chunk-N-get"
  meep::dft_chunk *arg1 = (meep::dft_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::dft_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_chunk, 1, 0);
  }
  result = (int) ((arg1)->N);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_chunk_dft_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-dft-chunk-dft-set"
  meep::dft_chunk *arg1 = (meep::dft_chunk *) 0 ;
  complex< meep::realnum > *arg2 = (complex< meep::realnum > *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_chunk, 1, 0);
  }
  {
    arg2 = (complex< meep::realnum > *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_complexT_double_t, 2, 0);
  }
  if (arg1) (arg1)->dft = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_chunk_dft_get (SCM s_0)
{
#define FUNC_NAME "meep-dft-chunk-dft-get"
  meep::dft_chunk *arg1 = (meep::dft_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< meep::realnum > *result = 0 ;
  
  {
    arg1 = (meep::dft_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_chunk, 1, 0);
  }
  result = (complex< meep::realnum > *) ((arg1)->dft);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_complexT_double_t, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_chunk_next_in_chunk_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-dft-chunk-next-in-chunk-set"
  meep::dft_chunk *arg1 = (meep::dft_chunk *) 0 ;
  meep::dft_chunk *arg2 = (meep::dft_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_chunk, 1, 0);
  }
  {
    arg2 = (meep::dft_chunk *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__dft_chunk, 2, 0);
  }
  if (arg1) (arg1)->next_in_chunk = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_chunk_next_in_chunk_get (SCM s_0)
{
#define FUNC_NAME "meep-dft-chunk-next-in-chunk-get"
  meep::dft_chunk *arg1 = (meep::dft_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::dft_chunk *result = 0 ;
  
  {
    arg1 = (meep::dft_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_chunk, 1, 0);
  }
  result = (meep::dft_chunk *) ((arg1)->next_in_chunk);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__dft_chunk, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_chunk_next_in_dft_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-dft-chunk-next-in-dft-set"
  meep::dft_chunk *arg1 = (meep::dft_chunk *) 0 ;
  meep::dft_chunk *arg2 = (meep::dft_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_chunk, 1, 0);
  }
  {
    arg2 = (meep::dft_chunk *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__dft_chunk, 2, 0);
  }
  if (arg1) (arg1)->next_in_dft = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_chunk_next_in_dft_get (SCM s_0)
{
#define FUNC_NAME "meep-dft-chunk-next-in-dft-get"
  meep::dft_chunk *arg1 = (meep::dft_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::dft_chunk *result = 0 ;
  
  {
    arg1 = (meep::dft_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_chunk, 1, 0);
  }
  result = (meep::dft_chunk *) ((arg1)->next_in_dft);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__dft_chunk, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_chunk_extra_weight_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-dft-chunk-extra-weight-set"
  meep::dft_chunk *arg1 = (meep::dft_chunk *) 0 ;
  complex< double > arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_chunk, 1, 0);
  }
  {
    cnumber cnum = ctl_convert_cnumber_to_c(s_1);
    arg2 = std::complex<double>(cnum.re, cnum.im);
  }
  if (arg1) (arg1)->extra_weight = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_chunk_extra_weight_get (SCM s_0)
{
#define FUNC_NAME "meep-dft-chunk-extra-weight-get"
  meep::dft_chunk *arg1 = (meep::dft_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > result;
  
  {
    arg1 = (meep::dft_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_chunk, 1, 0);
  }
  result =  ((arg1)->extra_weight);
  {
    gswig_result = scm_make_rectangular(scm_make_real((&result)->real()),
      scm_make_real((&result)->imag()));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_save_dft_hdf5__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-save-dft-hdf5"
  meep::dft_chunk *arg1 = (meep::dft_chunk *) 0 ;
  meep::component arg2 ;
  meep::h5file *arg3 = (meep::h5file *) 0 ;
  char *arg4 = (char *) 0 ;
  int must_free4 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_chunk *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__dft_chunk, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::h5file *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__h5file, 3, 0);
  }
  {
    arg4 = (char *)SWIG_scm2str(argv[3]);
    must_free4 = 1;
  }
  meep::save_dft_hdf5(arg1,arg2,arg3,(char const *)arg4);
  gswig_result = SCM_UNSPECIFIED;
  
  
  if (must_free4 && arg4) SWIG_free(arg4);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_save_dft_hdf5__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-save-dft-hdf5"
  meep::dft_chunk *arg1 = (meep::dft_chunk *) 0 ;
  meep::component arg2 ;
  meep::h5file *arg3 = (meep::h5file *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_chunk *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__dft_chunk, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::h5file *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__h5file, 3, 0);
  }
  meep::save_dft_hdf5(arg1,arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_load_dft_hdf5__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-load-dft-hdf5"
  meep::dft_chunk *arg1 = (meep::dft_chunk *) 0 ;
  meep::component arg2 ;
  meep::h5file *arg3 = (meep::h5file *) 0 ;
  char *arg4 = (char *) 0 ;
  int must_free4 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_chunk *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__dft_chunk, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::h5file *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__h5file, 3, 0);
  }
  {
    arg4 = (char *)SWIG_scm2str(argv[3]);
    must_free4 = 1;
  }
  meep::load_dft_hdf5(arg1,arg2,arg3,(char const *)arg4);
  gswig_result = SCM_UNSPECIFIED;
  
  
  if (must_free4 && arg4) SWIG_free(arg4);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_load_dft_hdf5__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-load-dft-hdf5"
  meep::dft_chunk *arg1 = (meep::dft_chunk *) 0 ;
  meep::component arg2 ;
  meep::h5file *arg3 = (meep::h5file *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_chunk *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__dft_chunk, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::h5file *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__h5file, 3, 0);
  }
  meep::load_dft_hdf5(arg1,arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_save_dft_hdf5__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-save-dft-hdf5"
  meep::dft_chunk *arg1 = (meep::dft_chunk *) 0 ;
  char *arg2 = (char *) 0 ;
  meep::h5file *arg3 = (meep::h5file *) 0 ;
  char *arg4 = (char *) 0 ;
  int must_free2 = 0 ;
  int must_free4 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_chunk *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__dft_chunk, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(argv[1]);
    must_free2 = 1;
  }
  {
    arg3 = (meep::h5file *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__h5file, 3, 0);
  }
  {
    arg4 = (char *)SWIG_scm2str(argv[3]);
    must_free4 = 1;
  }
  meep::save_dft_hdf5(arg1,(char const *)arg2,arg3,(char const *)arg4);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  if (must_free4 && arg4) SWIG_free(arg4);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_save_dft_hdf5__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-save-dft-hdf5"
  meep::dft_chunk *arg1 = (meep::dft_chunk *) 0 ;
  char *arg2 = (char *) 0 ;
  meep::h5file *arg3 = (meep::h5file *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_chunk *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__dft_chunk, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(argv[1]);
    must_free2 = 1;
  }
  {
    arg3 = (meep::h5file *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__h5file, 3, 0);
  }
  meep::save_dft_hdf5(arg1,(char const *)arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_save_dft_hdf5(SCM rest)
{
#define FUNC_NAME "meep-save-dft-hdf5"
  SCM argv[4];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 4, "meep-save-dft-hdf5");
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__dft_chunk, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__h5file, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_meep_save_dft_hdf5__SWIG_1(argc,argv);
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__dft_chunk, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_STRINGP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__h5file, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_meep_save_dft_hdf5__SWIG_3(argc,argv);
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__dft_chunk, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__h5file, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            _v = SCM_STRINGP(argv[3]) ? 1 : 0;
          }
          if (_v) {
            return _wrap_meep_save_dft_hdf5__SWIG_0(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__dft_chunk, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_STRINGP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__h5file, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            _v = SCM_STRINGP(argv[3]) ? 1 : 0;
          }
          if (_v) {
            return _wrap_meep_save_dft_hdf5__SWIG_2(argc,argv);
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-save-dft-hdf5", "No matching method for generic function `meep_save_dft_hdf5'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_load_dft_hdf5__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-load-dft-hdf5"
  meep::dft_chunk *arg1 = (meep::dft_chunk *) 0 ;
  char *arg2 = (char *) 0 ;
  meep::h5file *arg3 = (meep::h5file *) 0 ;
  char *arg4 = (char *) 0 ;
  int must_free2 = 0 ;
  int must_free4 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_chunk *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__dft_chunk, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(argv[1]);
    must_free2 = 1;
  }
  {
    arg3 = (meep::h5file *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__h5file, 3, 0);
  }
  {
    arg4 = (char *)SWIG_scm2str(argv[3]);
    must_free4 = 1;
  }
  meep::load_dft_hdf5(arg1,(char const *)arg2,arg3,(char const *)arg4);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  if (must_free4 && arg4) SWIG_free(arg4);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_load_dft_hdf5__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-load-dft-hdf5"
  meep::dft_chunk *arg1 = (meep::dft_chunk *) 0 ;
  char *arg2 = (char *) 0 ;
  meep::h5file *arg3 = (meep::h5file *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_chunk *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__dft_chunk, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(argv[1]);
    must_free2 = 1;
  }
  {
    arg3 = (meep::h5file *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__h5file, 3, 0);
  }
  meep::load_dft_hdf5(arg1,(char const *)arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_load_dft_hdf5(SCM rest)
{
#define FUNC_NAME "meep-load-dft-hdf5"
  SCM argv[4];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 4, "meep-load-dft-hdf5");
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__dft_chunk, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__h5file, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_meep_load_dft_hdf5__SWIG_1(argc,argv);
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__dft_chunk, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_STRINGP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__h5file, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_meep_load_dft_hdf5__SWIG_3(argc,argv);
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__dft_chunk, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__h5file, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            _v = SCM_STRINGP(argv[3]) ? 1 : 0;
          }
          if (_v) {
            return _wrap_meep_load_dft_hdf5__SWIG_0(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__dft_chunk, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_STRINGP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__h5file, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            _v = SCM_STRINGP(argv[3]) ? 1 : 0;
          }
          if (_v) {
            return _wrap_meep_load_dft_hdf5__SWIG_2(argc,argv);
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-load-dft-hdf5", "No matching method for generic function `meep_load_dft_hdf5'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_dft_flux__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-dft-flux"
  meep::component arg1 ;
  meep::component arg2 ;
  meep::dft_chunk *arg3 = (meep::dft_chunk *) 0 ;
  meep::dft_chunk *arg4 = (meep::dft_chunk *) 0 ;
  double arg5 ;
  double arg6 ;
  int arg7 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::dft_flux *result = 0 ;
  
  {
    arg1 = (meep::component const) scm_num2int(argv[0], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg2 = (meep::component const) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::dft_chunk *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__dft_chunk, 3, 0);
  }
  {
    arg4 = (meep::dft_chunk *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__dft_chunk, 4, 0);
  }
  {
    arg5 = (double) scm_num2dbl(argv[4], FUNC_NAME);
  }
  {
    arg6 = (double) scm_num2dbl(argv[5], FUNC_NAME);
  }
  {
    arg7 = (int) scm_num2int(argv[6], SCM_ARG1, FUNC_NAME);
  }
  result = (meep::dft_flux *)new meep::dft_flux(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__dft_flux, 1);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_dft_flux__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-dft-flux"
  meep::dft_flux *arg1 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::dft_flux *result = 0 ;
  
  {
    arg1 = (meep::dft_flux *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__dft_flux, 1, 0);
  }
  result = (meep::dft_flux *)new meep::dft_flux((meep::dft_flux const &)*arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__dft_flux, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_dft_flux(SCM rest)
{
#define FUNC_NAME "new-meep-dft-flux"
  SCM argv[7];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 7, "new-meep-dft-flux");
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__dft_flux, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      return _wrap_new_meep_dft_flux__SWIG_1(argc,argv);
    }
  }
  if (argc == 7) {
    int _v;
    {
      _v = SCM_NFALSEP(scm_integer_p(argv[0])) ? 1 : 0;
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__dft_chunk, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__dft_chunk, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_real_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              {
                _v = SCM_NFALSEP(scm_real_p(argv[5])) ? 1 : 0;
              }
              if (_v) {
                {
                  _v = SCM_NFALSEP(scm_integer_p(argv[6])) ? 1 : 0;
                }
                if (_v) {
                  return _wrap_new_meep_dft_flux__SWIG_0(argc,argv);
                }
              }
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("new-meep-dft-flux", "No matching method for generic function `new_meep_dft_flux'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_flux_flux (SCM s_0)
{
#define FUNC_NAME "meep-dft-flux-flux"
  meep::dft_flux *arg1 = (meep::dft_flux *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double *result = 0 ;
  
  {
    arg1 = (meep::dft_flux *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_flux, 1, 0);
  }
  result = (double *)(arg1)->flux();
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_double, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_flux_save_hdf5__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-dft-flux-save-hdf5"
  meep::dft_flux *arg1 = (meep::dft_flux *) 0 ;
  meep::h5file *arg2 = (meep::h5file *) 0 ;
  char *arg3 = (char *) 0 ;
  int must_free3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_flux *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__dft_flux, 1, 0);
  }
  {
    arg2 = (meep::h5file *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__h5file, 2, 0);
  }
  {
    arg3 = (char *)SWIG_scm2str(argv[2]);
    must_free3 = 1;
  }
  (arg1)->save_hdf5(arg2,(char const *)arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  if (must_free3 && arg3) SWIG_free(arg3);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_flux_save_hdf5__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-dft-flux-save-hdf5"
  meep::dft_flux *arg1 = (meep::dft_flux *) 0 ;
  meep::h5file *arg2 = (meep::h5file *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_flux *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__dft_flux, 1, 0);
  }
  {
    arg2 = (meep::h5file *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__h5file, 2, 0);
  }
  (arg1)->save_hdf5(arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_flux_load_hdf5__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-dft-flux-load-hdf5"
  meep::dft_flux *arg1 = (meep::dft_flux *) 0 ;
  meep::h5file *arg2 = (meep::h5file *) 0 ;
  char *arg3 = (char *) 0 ;
  int must_free3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_flux *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__dft_flux, 1, 0);
  }
  {
    arg2 = (meep::h5file *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__h5file, 2, 0);
  }
  {
    arg3 = (char *)SWIG_scm2str(argv[2]);
    must_free3 = 1;
  }
  (arg1)->load_hdf5(arg2,(char const *)arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  if (must_free3 && arg3) SWIG_free(arg3);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_flux_load_hdf5__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-dft-flux-load-hdf5"
  meep::dft_flux *arg1 = (meep::dft_flux *) 0 ;
  meep::h5file *arg2 = (meep::h5file *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_flux *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__dft_flux, 1, 0);
  }
  {
    arg2 = (meep::h5file *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__h5file, 2, 0);
  }
  (arg1)->load_hdf5(arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_flux_meep_dft_flux_subeq (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-dft-flux-meep-dft-flux-subeq"
  meep::dft_flux *arg1 = (meep::dft_flux *) 0 ;
  meep::dft_flux *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_flux *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_flux, 1, 0);
  }
  {
    arg2 = (meep::dft_flux *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__dft_flux, 2, 0);
  }
  (arg1)->operator -=((meep::dft_flux const &)*arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_flux_save_hdf5__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-dft-flux-save-hdf5"
  meep::dft_flux *arg1 = (meep::dft_flux *) 0 ;
  meep::fields *arg2 = 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  char *arg5 = (char *) 0 ;
  int must_free3 = 0 ;
  int must_free4 = 0 ;
  int must_free5 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_flux *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__dft_flux, 1, 0);
  }
  {
    arg2 = (meep::fields *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__fields, 2, 0);
  }
  {
    arg3 = (char *)SWIG_scm2str(argv[2]);
    must_free3 = 1;
  }
  {
    arg4 = (char *)SWIG_scm2str(argv[3]);
    must_free4 = 1;
  }
  {
    arg5 = (char *)SWIG_scm2str(argv[4]);
    must_free5 = 1;
  }
  (arg1)->save_hdf5(*arg2,(char const *)arg3,(char const *)arg4,(char const *)arg5);
  gswig_result = SCM_UNSPECIFIED;
  
  
  if (must_free3 && arg3) SWIG_free(arg3);
  if (must_free4 && arg4) SWIG_free(arg4);
  if (must_free5 && arg5) SWIG_free(arg5);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_flux_save_hdf5__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-dft-flux-save-hdf5"
  meep::dft_flux *arg1 = (meep::dft_flux *) 0 ;
  meep::fields *arg2 = 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  int must_free3 = 0 ;
  int must_free4 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_flux *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__dft_flux, 1, 0);
  }
  {
    arg2 = (meep::fields *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__fields, 2, 0);
  }
  {
    arg3 = (char *)SWIG_scm2str(argv[2]);
    must_free3 = 1;
  }
  {
    arg4 = (char *)SWIG_scm2str(argv[3]);
    must_free4 = 1;
  }
  (arg1)->save_hdf5(*arg2,(char const *)arg3,(char const *)arg4);
  gswig_result = SCM_UNSPECIFIED;
  
  
  if (must_free3 && arg3) SWIG_free(arg3);
  if (must_free4 && arg4) SWIG_free(arg4);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_flux_save_hdf5__SWIG_4 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-dft-flux-save-hdf5"
  meep::dft_flux *arg1 = (meep::dft_flux *) 0 ;
  meep::fields *arg2 = 0 ;
  char *arg3 = (char *) 0 ;
  int must_free3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_flux *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__dft_flux, 1, 0);
  }
  {
    arg2 = (meep::fields *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__fields, 2, 0);
  }
  {
    arg3 = (char *)SWIG_scm2str(argv[2]);
    must_free3 = 1;
  }
  (arg1)->save_hdf5(*arg2,(char const *)arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  if (must_free3 && arg3) SWIG_free(arg3);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_flux_save_hdf5(SCM rest)
{
#define FUNC_NAME "meep-dft-flux-save-hdf5"
  SCM argv[5];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 5, "meep-dft-flux-save-hdf5");
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__dft_flux, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__h5file, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_meep_dft_flux_save_hdf5__SWIG_1(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__dft_flux, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__h5file, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_STRINGP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_dft_flux_save_hdf5__SWIG_0(argc,argv);
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__dft_flux, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__fields, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_STRINGP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_dft_flux_save_hdf5__SWIG_4(argc,argv);
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__dft_flux, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__fields, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_STRINGP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_STRINGP(argv[3]) ? 1 : 0;
          }
          if (_v) {
            return _wrap_meep_dft_flux_save_hdf5__SWIG_3(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__dft_flux, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__fields, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_STRINGP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_STRINGP(argv[3]) ? 1 : 0;
          }
          if (_v) {
            {
              _v = SCM_STRINGP(argv[4]) ? 1 : 0;
            }
            if (_v) {
              return _wrap_meep_dft_flux_save_hdf5__SWIG_2(argc,argv);
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-dft-flux-save-hdf5", "No matching method for generic function `meep_dft_flux_save_hdf5'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_flux_load_hdf5__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-dft-flux-load-hdf5"
  meep::dft_flux *arg1 = (meep::dft_flux *) 0 ;
  meep::fields *arg2 = 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  char *arg5 = (char *) 0 ;
  int must_free3 = 0 ;
  int must_free4 = 0 ;
  int must_free5 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_flux *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__dft_flux, 1, 0);
  }
  {
    arg2 = (meep::fields *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__fields, 2, 0);
  }
  {
    arg3 = (char *)SWIG_scm2str(argv[2]);
    must_free3 = 1;
  }
  {
    arg4 = (char *)SWIG_scm2str(argv[3]);
    must_free4 = 1;
  }
  {
    arg5 = (char *)SWIG_scm2str(argv[4]);
    must_free5 = 1;
  }
  (arg1)->load_hdf5(*arg2,(char const *)arg3,(char const *)arg4,(char const *)arg5);
  gswig_result = SCM_UNSPECIFIED;
  
  
  if (must_free3 && arg3) SWIG_free(arg3);
  if (must_free4 && arg4) SWIG_free(arg4);
  if (must_free5 && arg5) SWIG_free(arg5);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_flux_load_hdf5__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-dft-flux-load-hdf5"
  meep::dft_flux *arg1 = (meep::dft_flux *) 0 ;
  meep::fields *arg2 = 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  int must_free3 = 0 ;
  int must_free4 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_flux *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__dft_flux, 1, 0);
  }
  {
    arg2 = (meep::fields *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__fields, 2, 0);
  }
  {
    arg3 = (char *)SWIG_scm2str(argv[2]);
    must_free3 = 1;
  }
  {
    arg4 = (char *)SWIG_scm2str(argv[3]);
    must_free4 = 1;
  }
  (arg1)->load_hdf5(*arg2,(char const *)arg3,(char const *)arg4);
  gswig_result = SCM_UNSPECIFIED;
  
  
  if (must_free3 && arg3) SWIG_free(arg3);
  if (must_free4 && arg4) SWIG_free(arg4);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_flux_load_hdf5__SWIG_4 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-dft-flux-load-hdf5"
  meep::dft_flux *arg1 = (meep::dft_flux *) 0 ;
  meep::fields *arg2 = 0 ;
  char *arg3 = (char *) 0 ;
  int must_free3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_flux *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__dft_flux, 1, 0);
  }
  {
    arg2 = (meep::fields *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__fields, 2, 0);
  }
  {
    arg3 = (char *)SWIG_scm2str(argv[2]);
    must_free3 = 1;
  }
  (arg1)->load_hdf5(*arg2,(char const *)arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  if (must_free3 && arg3) SWIG_free(arg3);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_flux_load_hdf5(SCM rest)
{
#define FUNC_NAME "meep-dft-flux-load-hdf5"
  SCM argv[5];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 5, "meep-dft-flux-load-hdf5");
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__dft_flux, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__h5file, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_meep_dft_flux_load_hdf5__SWIG_1(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__dft_flux, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__h5file, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_STRINGP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_dft_flux_load_hdf5__SWIG_0(argc,argv);
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__dft_flux, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__fields, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_STRINGP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_dft_flux_load_hdf5__SWIG_4(argc,argv);
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__dft_flux, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__fields, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_STRINGP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_STRINGP(argv[3]) ? 1 : 0;
          }
          if (_v) {
            return _wrap_meep_dft_flux_load_hdf5__SWIG_3(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__dft_flux, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__fields, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_STRINGP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_STRINGP(argv[3]) ? 1 : 0;
          }
          if (_v) {
            {
              _v = SCM_STRINGP(argv[4]) ? 1 : 0;
            }
            if (_v) {
              return _wrap_meep_dft_flux_load_hdf5__SWIG_2(argc,argv);
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-dft-flux-load-hdf5", "No matching method for generic function `meep_dft_flux_load_hdf5'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_flux_scale_dfts (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-dft-flux-scale-dfts"
  meep::dft_flux *arg1 = (meep::dft_flux *) 0 ;
  complex< double > arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_flux *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_flux, 1, 0);
  }
  {
    cnumber cnum = ctl_convert_cnumber_to_c(s_1);
    arg2 = std::complex<double>(cnum.re, cnum.im);
  }
  (arg1)->scale_dfts(arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_flux_remove (SCM s_0)
{
#define FUNC_NAME "meep-dft-flux-remove"
  meep::dft_flux *arg1 = (meep::dft_flux *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_flux *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_flux, 1, 0);
  }
  (arg1)->remove();
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_flux_freq_min_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-dft-flux-freq-min-set"
  meep::dft_flux *arg1 = (meep::dft_flux *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_flux *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_flux, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  if (arg1) (arg1)->freq_min = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_flux_freq_min_get (SCM s_0)
{
#define FUNC_NAME "meep-dft-flux-freq-min-get"
  meep::dft_flux *arg1 = (meep::dft_flux *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::dft_flux *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_flux, 1, 0);
  }
  result = (double) ((arg1)->freq_min);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_flux_dfreq_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-dft-flux-dfreq-set"
  meep::dft_flux *arg1 = (meep::dft_flux *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_flux *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_flux, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  if (arg1) (arg1)->dfreq = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_flux_dfreq_get (SCM s_0)
{
#define FUNC_NAME "meep-dft-flux-dfreq-get"
  meep::dft_flux *arg1 = (meep::dft_flux *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::dft_flux *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_flux, 1, 0);
  }
  result = (double) ((arg1)->dfreq);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_flux_Nfreq_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-dft-flux-Nfreq-set"
  meep::dft_flux *arg1 = (meep::dft_flux *) 0 ;
  int arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_flux *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_flux, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(s_1, SCM_ARG1, FUNC_NAME);
  }
  if (arg1) (arg1)->Nfreq = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_flux_Nfreq_get (SCM s_0)
{
#define FUNC_NAME "meep-dft-flux-Nfreq-get"
  meep::dft_flux *arg1 = (meep::dft_flux *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::dft_flux *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_flux, 1, 0);
  }
  result = (int) ((arg1)->Nfreq);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_flux_E_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-dft-flux-E-set"
  meep::dft_flux *arg1 = (meep::dft_flux *) 0 ;
  meep::dft_chunk *arg2 = (meep::dft_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_flux *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_flux, 1, 0);
  }
  {
    arg2 = (meep::dft_chunk *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__dft_chunk, 2, 0);
  }
  if (arg1) (arg1)->E = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_flux_E_get (SCM s_0)
{
#define FUNC_NAME "meep-dft-flux-E-get"
  meep::dft_flux *arg1 = (meep::dft_flux *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::dft_chunk *result = 0 ;
  
  {
    arg1 = (meep::dft_flux *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_flux, 1, 0);
  }
  result = (meep::dft_chunk *) ((arg1)->E);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__dft_chunk, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_flux_H_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-dft-flux-H-set"
  meep::dft_flux *arg1 = (meep::dft_flux *) 0 ;
  meep::dft_chunk *arg2 = (meep::dft_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_flux *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_flux, 1, 0);
  }
  {
    arg2 = (meep::dft_chunk *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__dft_chunk, 2, 0);
  }
  if (arg1) (arg1)->H = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_flux_H_get (SCM s_0)
{
#define FUNC_NAME "meep-dft-flux-H-get"
  meep::dft_flux *arg1 = (meep::dft_flux *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::dft_chunk *result = 0 ;
  
  {
    arg1 = (meep::dft_flux *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_flux, 1, 0);
  }
  result = (meep::dft_chunk *) ((arg1)->H);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__dft_chunk, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_flux_cE_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-dft-flux-cE-set"
  meep::dft_flux *arg1 = (meep::dft_flux *) 0 ;
  meep::component arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_flux *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_flux, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  if (arg1) (arg1)->cE = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_flux_cE_get (SCM s_0)
{
#define FUNC_NAME "meep-dft-flux-cE-get"
  meep::dft_flux *arg1 = (meep::dft_flux *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::component result;
  
  {
    arg1 = (meep::dft_flux *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_flux, 1, 0);
  }
  result = (meep::component) ((arg1)->cE);
  {
    gswig_result = scm_long2num(result); 
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_flux_cH_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-dft-flux-cH-set"
  meep::dft_flux *arg1 = (meep::dft_flux *) 0 ;
  meep::component arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_flux *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_flux, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  if (arg1) (arg1)->cH = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_flux_cH_get (SCM s_0)
{
#define FUNC_NAME "meep-dft-flux-cH-get"
  meep::dft_flux *arg1 = (meep::dft_flux *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::component result;
  
  {
    arg1 = (meep::dft_flux *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_flux, 1, 0);
  }
  result = (meep::component) ((arg1)->cH);
  {
    gswig_result = scm_long2num(result); 
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_delete_meep_dft_flux (SCM s_0)
{
#define FUNC_NAME "delete-meep-dft-flux"
  meep::dft_flux *arg1 = (meep::dft_flux *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_flux *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_flux, 1, 0);
  }
  delete arg1;
  gswig_result = SCM_UNSPECIFIED;
  
  SWIG_Guile_MarkPointerDestroyed(s_0);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_dft_force__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-dft-force"
  meep::dft_chunk *arg1 = (meep::dft_chunk *) 0 ;
  meep::dft_chunk *arg2 = (meep::dft_chunk *) 0 ;
  meep::dft_chunk *arg3 = (meep::dft_chunk *) 0 ;
  double arg4 ;
  double arg5 ;
  int arg6 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::dft_force *result = 0 ;
  
  {
    arg1 = (meep::dft_chunk *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__dft_chunk, 1, 0);
  }
  {
    arg2 = (meep::dft_chunk *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__dft_chunk, 2, 0);
  }
  {
    arg3 = (meep::dft_chunk *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__dft_chunk, 3, 0);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  {
    arg5 = (double) scm_num2dbl(argv[4], FUNC_NAME);
  }
  {
    arg6 = (int) scm_num2int(argv[5], SCM_ARG1, FUNC_NAME);
  }
  result = (meep::dft_force *)new meep::dft_force(arg1,arg2,arg3,arg4,arg5,arg6);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__dft_force, 1);
  }
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_dft_force__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-dft-force"
  meep::dft_force *arg1 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::dft_force *result = 0 ;
  
  {
    arg1 = (meep::dft_force *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__dft_force, 1, 0);
  }
  result = (meep::dft_force *)new meep::dft_force((meep::dft_force const &)*arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__dft_force, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_dft_force(SCM rest)
{
#define FUNC_NAME "new-meep-dft-force"
  SCM argv[6];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 6, "new-meep-dft-force");
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__dft_force, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      return _wrap_new_meep_dft_force__SWIG_1(argc,argv);
    }
  }
  if (argc == 6) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__dft_chunk, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__dft_chunk, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__dft_chunk, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_real_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              {
                _v = SCM_NFALSEP(scm_integer_p(argv[5])) ? 1 : 0;
              }
              if (_v) {
                return _wrap_new_meep_dft_force__SWIG_0(argc,argv);
              }
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("new-meep-dft-force", "No matching method for generic function `new_meep_dft_force'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_force_force (SCM s_0)
{
#define FUNC_NAME "meep-dft-force-force"
  meep::dft_force *arg1 = (meep::dft_force *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double *result = 0 ;
  
  {
    arg1 = (meep::dft_force *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_force, 1, 0);
  }
  result = (double *)(arg1)->force();
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_double, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_force_save_hdf5__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-dft-force-save-hdf5"
  meep::dft_force *arg1 = (meep::dft_force *) 0 ;
  meep::h5file *arg2 = (meep::h5file *) 0 ;
  char *arg3 = (char *) 0 ;
  int must_free3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_force *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__dft_force, 1, 0);
  }
  {
    arg2 = (meep::h5file *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__h5file, 2, 0);
  }
  {
    arg3 = (char *)SWIG_scm2str(argv[2]);
    must_free3 = 1;
  }
  (arg1)->save_hdf5(arg2,(char const *)arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  if (must_free3 && arg3) SWIG_free(arg3);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_force_save_hdf5__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-dft-force-save-hdf5"
  meep::dft_force *arg1 = (meep::dft_force *) 0 ;
  meep::h5file *arg2 = (meep::h5file *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_force *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__dft_force, 1, 0);
  }
  {
    arg2 = (meep::h5file *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__h5file, 2, 0);
  }
  (arg1)->save_hdf5(arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_force_load_hdf5__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-dft-force-load-hdf5"
  meep::dft_force *arg1 = (meep::dft_force *) 0 ;
  meep::h5file *arg2 = (meep::h5file *) 0 ;
  char *arg3 = (char *) 0 ;
  int must_free3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_force *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__dft_force, 1, 0);
  }
  {
    arg2 = (meep::h5file *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__h5file, 2, 0);
  }
  {
    arg3 = (char *)SWIG_scm2str(argv[2]);
    must_free3 = 1;
  }
  (arg1)->load_hdf5(arg2,(char const *)arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  if (must_free3 && arg3) SWIG_free(arg3);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_force_load_hdf5__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-dft-force-load-hdf5"
  meep::dft_force *arg1 = (meep::dft_force *) 0 ;
  meep::h5file *arg2 = (meep::h5file *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_force *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__dft_force, 1, 0);
  }
  {
    arg2 = (meep::h5file *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__h5file, 2, 0);
  }
  (arg1)->load_hdf5(arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_force_save_hdf5__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-dft-force-save-hdf5"
  meep::dft_force *arg1 = (meep::dft_force *) 0 ;
  meep::fields *arg2 = 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  char *arg5 = (char *) 0 ;
  int must_free3 = 0 ;
  int must_free4 = 0 ;
  int must_free5 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_force *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__dft_force, 1, 0);
  }
  {
    arg2 = (meep::fields *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__fields, 2, 0);
  }
  {
    arg3 = (char *)SWIG_scm2str(argv[2]);
    must_free3 = 1;
  }
  {
    arg4 = (char *)SWIG_scm2str(argv[3]);
    must_free4 = 1;
  }
  {
    arg5 = (char *)SWIG_scm2str(argv[4]);
    must_free5 = 1;
  }
  (arg1)->save_hdf5(*arg2,(char const *)arg3,(char const *)arg4,(char const *)arg5);
  gswig_result = SCM_UNSPECIFIED;
  
  
  if (must_free3 && arg3) SWIG_free(arg3);
  if (must_free4 && arg4) SWIG_free(arg4);
  if (must_free5 && arg5) SWIG_free(arg5);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_force_save_hdf5__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-dft-force-save-hdf5"
  meep::dft_force *arg1 = (meep::dft_force *) 0 ;
  meep::fields *arg2 = 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  int must_free3 = 0 ;
  int must_free4 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_force *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__dft_force, 1, 0);
  }
  {
    arg2 = (meep::fields *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__fields, 2, 0);
  }
  {
    arg3 = (char *)SWIG_scm2str(argv[2]);
    must_free3 = 1;
  }
  {
    arg4 = (char *)SWIG_scm2str(argv[3]);
    must_free4 = 1;
  }
  (arg1)->save_hdf5(*arg2,(char const *)arg3,(char const *)arg4);
  gswig_result = SCM_UNSPECIFIED;
  
  
  if (must_free3 && arg3) SWIG_free(arg3);
  if (must_free4 && arg4) SWIG_free(arg4);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_force_save_hdf5__SWIG_4 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-dft-force-save-hdf5"
  meep::dft_force *arg1 = (meep::dft_force *) 0 ;
  meep::fields *arg2 = 0 ;
  char *arg3 = (char *) 0 ;
  int must_free3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_force *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__dft_force, 1, 0);
  }
  {
    arg2 = (meep::fields *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__fields, 2, 0);
  }
  {
    arg3 = (char *)SWIG_scm2str(argv[2]);
    must_free3 = 1;
  }
  (arg1)->save_hdf5(*arg2,(char const *)arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  if (must_free3 && arg3) SWIG_free(arg3);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_force_save_hdf5(SCM rest)
{
#define FUNC_NAME "meep-dft-force-save-hdf5"
  SCM argv[5];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 5, "meep-dft-force-save-hdf5");
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__dft_force, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__h5file, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_meep_dft_force_save_hdf5__SWIG_1(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__dft_force, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__h5file, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_STRINGP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_dft_force_save_hdf5__SWIG_0(argc,argv);
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__dft_force, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__fields, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_STRINGP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_dft_force_save_hdf5__SWIG_4(argc,argv);
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__dft_force, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__fields, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_STRINGP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_STRINGP(argv[3]) ? 1 : 0;
          }
          if (_v) {
            return _wrap_meep_dft_force_save_hdf5__SWIG_3(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__dft_force, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__fields, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_STRINGP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_STRINGP(argv[3]) ? 1 : 0;
          }
          if (_v) {
            {
              _v = SCM_STRINGP(argv[4]) ? 1 : 0;
            }
            if (_v) {
              return _wrap_meep_dft_force_save_hdf5__SWIG_2(argc,argv);
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-dft-force-save-hdf5", "No matching method for generic function `meep_dft_force_save_hdf5'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_force_load_hdf5__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-dft-force-load-hdf5"
  meep::dft_force *arg1 = (meep::dft_force *) 0 ;
  meep::fields *arg2 = 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  char *arg5 = (char *) 0 ;
  int must_free3 = 0 ;
  int must_free4 = 0 ;
  int must_free5 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_force *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__dft_force, 1, 0);
  }
  {
    arg2 = (meep::fields *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__fields, 2, 0);
  }
  {
    arg3 = (char *)SWIG_scm2str(argv[2]);
    must_free3 = 1;
  }
  {
    arg4 = (char *)SWIG_scm2str(argv[3]);
    must_free4 = 1;
  }
  {
    arg5 = (char *)SWIG_scm2str(argv[4]);
    must_free5 = 1;
  }
  (arg1)->load_hdf5(*arg2,(char const *)arg3,(char const *)arg4,(char const *)arg5);
  gswig_result = SCM_UNSPECIFIED;
  
  
  if (must_free3 && arg3) SWIG_free(arg3);
  if (must_free4 && arg4) SWIG_free(arg4);
  if (must_free5 && arg5) SWIG_free(arg5);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_force_load_hdf5__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-dft-force-load-hdf5"
  meep::dft_force *arg1 = (meep::dft_force *) 0 ;
  meep::fields *arg2 = 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  int must_free3 = 0 ;
  int must_free4 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_force *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__dft_force, 1, 0);
  }
  {
    arg2 = (meep::fields *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__fields, 2, 0);
  }
  {
    arg3 = (char *)SWIG_scm2str(argv[2]);
    must_free3 = 1;
  }
  {
    arg4 = (char *)SWIG_scm2str(argv[3]);
    must_free4 = 1;
  }
  (arg1)->load_hdf5(*arg2,(char const *)arg3,(char const *)arg4);
  gswig_result = SCM_UNSPECIFIED;
  
  
  if (must_free3 && arg3) SWIG_free(arg3);
  if (must_free4 && arg4) SWIG_free(arg4);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_force_load_hdf5__SWIG_4 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-dft-force-load-hdf5"
  meep::dft_force *arg1 = (meep::dft_force *) 0 ;
  meep::fields *arg2 = 0 ;
  char *arg3 = (char *) 0 ;
  int must_free3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_force *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__dft_force, 1, 0);
  }
  {
    arg2 = (meep::fields *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__fields, 2, 0);
  }
  {
    arg3 = (char *)SWIG_scm2str(argv[2]);
    must_free3 = 1;
  }
  (arg1)->load_hdf5(*arg2,(char const *)arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  if (must_free3 && arg3) SWIG_free(arg3);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_force_load_hdf5(SCM rest)
{
#define FUNC_NAME "meep-dft-force-load-hdf5"
  SCM argv[5];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 5, "meep-dft-force-load-hdf5");
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__dft_force, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__h5file, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_meep_dft_force_load_hdf5__SWIG_1(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__dft_force, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__h5file, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_STRINGP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_dft_force_load_hdf5__SWIG_0(argc,argv);
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__dft_force, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__fields, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_STRINGP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_dft_force_load_hdf5__SWIG_4(argc,argv);
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__dft_force, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__fields, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_STRINGP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_STRINGP(argv[3]) ? 1 : 0;
          }
          if (_v) {
            return _wrap_meep_dft_force_load_hdf5__SWIG_3(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__dft_force, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__fields, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_STRINGP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_STRINGP(argv[3]) ? 1 : 0;
          }
          if (_v) {
            {
              _v = SCM_STRINGP(argv[4]) ? 1 : 0;
            }
            if (_v) {
              return _wrap_meep_dft_force_load_hdf5__SWIG_2(argc,argv);
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-dft-force-load-hdf5", "No matching method for generic function `meep_dft_force_load_hdf5'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_force_scale_dfts (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-dft-force-scale-dfts"
  meep::dft_force *arg1 = (meep::dft_force *) 0 ;
  complex< double > arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_force *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_force, 1, 0);
  }
  {
    cnumber cnum = ctl_convert_cnumber_to_c(s_1);
    arg2 = std::complex<double>(cnum.re, cnum.im);
  }
  (arg1)->scale_dfts(arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_force_remove (SCM s_0)
{
#define FUNC_NAME "meep-dft-force-remove"
  meep::dft_force *arg1 = (meep::dft_force *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_force *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_force, 1, 0);
  }
  (arg1)->remove();
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_force_freq_min_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-dft-force-freq-min-set"
  meep::dft_force *arg1 = (meep::dft_force *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_force *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_force, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  if (arg1) (arg1)->freq_min = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_force_freq_min_get (SCM s_0)
{
#define FUNC_NAME "meep-dft-force-freq-min-get"
  meep::dft_force *arg1 = (meep::dft_force *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::dft_force *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_force, 1, 0);
  }
  result = (double) ((arg1)->freq_min);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_force_dfreq_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-dft-force-dfreq-set"
  meep::dft_force *arg1 = (meep::dft_force *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_force *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_force, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  if (arg1) (arg1)->dfreq = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_force_dfreq_get (SCM s_0)
{
#define FUNC_NAME "meep-dft-force-dfreq-get"
  meep::dft_force *arg1 = (meep::dft_force *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::dft_force *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_force, 1, 0);
  }
  result = (double) ((arg1)->dfreq);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_force_Nfreq_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-dft-force-Nfreq-set"
  meep::dft_force *arg1 = (meep::dft_force *) 0 ;
  int arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_force *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_force, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(s_1, SCM_ARG1, FUNC_NAME);
  }
  if (arg1) (arg1)->Nfreq = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_force_Nfreq_get (SCM s_0)
{
#define FUNC_NAME "meep-dft-force-Nfreq-get"
  meep::dft_force *arg1 = (meep::dft_force *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::dft_force *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_force, 1, 0);
  }
  result = (int) ((arg1)->Nfreq);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_force_offdiag1_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-dft-force-offdiag1-set"
  meep::dft_force *arg1 = (meep::dft_force *) 0 ;
  meep::dft_chunk *arg2 = (meep::dft_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_force *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_force, 1, 0);
  }
  {
    arg2 = (meep::dft_chunk *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__dft_chunk, 2, 0);
  }
  if (arg1) (arg1)->offdiag1 = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_force_offdiag1_get (SCM s_0)
{
#define FUNC_NAME "meep-dft-force-offdiag1-get"
  meep::dft_force *arg1 = (meep::dft_force *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::dft_chunk *result = 0 ;
  
  {
    arg1 = (meep::dft_force *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_force, 1, 0);
  }
  result = (meep::dft_chunk *) ((arg1)->offdiag1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__dft_chunk, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_force_offdiag2_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-dft-force-offdiag2-set"
  meep::dft_force *arg1 = (meep::dft_force *) 0 ;
  meep::dft_chunk *arg2 = (meep::dft_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_force *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_force, 1, 0);
  }
  {
    arg2 = (meep::dft_chunk *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__dft_chunk, 2, 0);
  }
  if (arg1) (arg1)->offdiag2 = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_force_offdiag2_get (SCM s_0)
{
#define FUNC_NAME "meep-dft-force-offdiag2-get"
  meep::dft_force *arg1 = (meep::dft_force *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::dft_chunk *result = 0 ;
  
  {
    arg1 = (meep::dft_force *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_force, 1, 0);
  }
  result = (meep::dft_chunk *) ((arg1)->offdiag2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__dft_chunk, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_force_diag_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-dft-force-diag-set"
  meep::dft_force *arg1 = (meep::dft_force *) 0 ;
  meep::dft_chunk *arg2 = (meep::dft_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_force *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_force, 1, 0);
  }
  {
    arg2 = (meep::dft_chunk *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__dft_chunk, 2, 0);
  }
  if (arg1) (arg1)->diag = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_dft_force_diag_get (SCM s_0)
{
#define FUNC_NAME "meep-dft-force-diag-get"
  meep::dft_force *arg1 = (meep::dft_force *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::dft_chunk *result = 0 ;
  
  {
    arg1 = (meep::dft_force *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_force, 1, 0);
  }
  result = (meep::dft_chunk *) ((arg1)->diag);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__dft_chunk, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_delete_meep_dft_force (SCM s_0)
{
#define FUNC_NAME "delete-meep-dft-force"
  meep::dft_force *arg1 = (meep::dft_force *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::dft_force *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__dft_force, 1, 0);
  }
  delete arg1;
  gswig_result = SCM_UNSPECIFIED;
  
  SWIG_Guile_MarkPointerDestroyed(s_0);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_in_or_out_Incoming(SCM s_0)
{
#define FUNC_NAME "meep-in-or-out-Incoming"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_in_or_out_Incoming);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_in_or_out_Outgoing(SCM s_0)
{
#define FUNC_NAME "meep-in-or-out-Outgoing"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_in_or_out_Outgoing);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_connect_phase_CONNECT_PHASE(SCM s_0)
{
#define FUNC_NAME "meep-connect-phase-CONNECT-PHASE"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_connect_phase_CONNECT_PHASE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_connect_phase_CONNECT_NEGATE(SCM s_0)
{
#define FUNC_NAME "meep-connect-phase-CONNECT-NEGATE"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_connect_phase_CONNECT_NEGATE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_connect_phase_CONNECT_COPY(SCM s_0)
{
#define FUNC_NAME "meep-connect-phase-CONNECT-COPY"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_connect_phase_CONNECT_COPY);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_f_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-f-set"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::realnum *(*arg2)[2] ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::realnum *(*)[2])SWIG_MustGetPtr(s_1, SWIGTYPE_p_a_2__p_double, 2, 0);
  }
  {
    meep::realnum * (*inp)[2] = (meep::realnum * (*)[2])(arg2);
    meep::realnum * (*dest)[2] = (meep::realnum * (*)[2])(arg1->f);
    size_t ii = 0;
    for (; ii < meep::NUM_FIELD_COMPONENTS; ++ii) {
      meep::realnum * *ip = inp[ii];
      meep::realnum * *dp = dest[ii];
      size_t jj = 0;
      for (; jj < 2; ++jj) dp[jj] = ip[jj];
    }
  }
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_f_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-f-get"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::realnum *(*result)[2] = 0 ;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (meep::realnum *(*)[2])(meep::realnum *(*)[2]) ((arg1)->f);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_a_2__p_double, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_f_u_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-f-u-set"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::realnum *(*arg2)[2] ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::realnum *(*)[2])SWIG_MustGetPtr(s_1, SWIGTYPE_p_a_2__p_double, 2, 0);
  }
  {
    meep::realnum * (*inp)[2] = (meep::realnum * (*)[2])(arg2);
    meep::realnum * (*dest)[2] = (meep::realnum * (*)[2])(arg1->f_u);
    size_t ii = 0;
    for (; ii < meep::NUM_FIELD_COMPONENTS; ++ii) {
      meep::realnum * *ip = inp[ii];
      meep::realnum * *dp = dest[ii];
      size_t jj = 0;
      for (; jj < 2; ++jj) dp[jj] = ip[jj];
    }
  }
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_f_u_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-f-u-get"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::realnum *(*result)[2] = 0 ;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (meep::realnum *(*)[2])(meep::realnum *(*)[2]) ((arg1)->f_u);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_a_2__p_double, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_f_w_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-f-w-set"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::realnum *(*arg2)[2] ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::realnum *(*)[2])SWIG_MustGetPtr(s_1, SWIGTYPE_p_a_2__p_double, 2, 0);
  }
  {
    meep::realnum * (*inp)[2] = (meep::realnum * (*)[2])(arg2);
    meep::realnum * (*dest)[2] = (meep::realnum * (*)[2])(arg1->f_w);
    size_t ii = 0;
    for (; ii < meep::NUM_FIELD_COMPONENTS; ++ii) {
      meep::realnum * *ip = inp[ii];
      meep::realnum * *dp = dest[ii];
      size_t jj = 0;
      for (; jj < 2; ++jj) dp[jj] = ip[jj];
    }
  }
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_f_w_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-f-w-get"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::realnum *(*result)[2] = 0 ;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (meep::realnum *(*)[2])(meep::realnum *(*)[2]) ((arg1)->f_w);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_a_2__p_double, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_f_cond_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-f-cond-set"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::realnum *(*arg2)[2] ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::realnum *(*)[2])SWIG_MustGetPtr(s_1, SWIGTYPE_p_a_2__p_double, 2, 0);
  }
  {
    meep::realnum * (*inp)[2] = (meep::realnum * (*)[2])(arg2);
    meep::realnum * (*dest)[2] = (meep::realnum * (*)[2])(arg1->f_cond);
    size_t ii = 0;
    for (; ii < meep::NUM_FIELD_COMPONENTS; ++ii) {
      meep::realnum * *ip = inp[ii];
      meep::realnum * *dp = dest[ii];
      size_t jj = 0;
      for (; jj < 2; ++jj) dp[jj] = ip[jj];
    }
  }
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_f_cond_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-f-cond-get"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::realnum *(*result)[2] = 0 ;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (meep::realnum *(*)[2])(meep::realnum *(*)[2]) ((arg1)->f_cond);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_a_2__p_double, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_f_backup_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-f-backup-set"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::realnum *(*arg2)[2] ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::realnum *(*)[2])SWIG_MustGetPtr(s_1, SWIGTYPE_p_a_2__p_double, 2, 0);
  }
  {
    meep::realnum * (*inp)[2] = (meep::realnum * (*)[2])(arg2);
    meep::realnum * (*dest)[2] = (meep::realnum * (*)[2])(arg1->f_backup);
    size_t ii = 0;
    for (; ii < meep::NUM_FIELD_COMPONENTS; ++ii) {
      meep::realnum * *ip = inp[ii];
      meep::realnum * *dp = dest[ii];
      size_t jj = 0;
      for (; jj < 2; ++jj) dp[jj] = ip[jj];
    }
  }
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_f_backup_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-f-backup-get"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::realnum *(*result)[2] = 0 ;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (meep::realnum *(*)[2])(meep::realnum *(*)[2]) ((arg1)->f_backup);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_a_2__p_double, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_f_u_backup_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-f-u-backup-set"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::realnum *(*arg2)[2] ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::realnum *(*)[2])SWIG_MustGetPtr(s_1, SWIGTYPE_p_a_2__p_double, 2, 0);
  }
  {
    meep::realnum * (*inp)[2] = (meep::realnum * (*)[2])(arg2);
    meep::realnum * (*dest)[2] = (meep::realnum * (*)[2])(arg1->f_u_backup);
    size_t ii = 0;
    for (; ii < meep::NUM_FIELD_COMPONENTS; ++ii) {
      meep::realnum * *ip = inp[ii];
      meep::realnum * *dp = dest[ii];
      size_t jj = 0;
      for (; jj < 2; ++jj) dp[jj] = ip[jj];
    }
  }
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_f_u_backup_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-f-u-backup-get"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::realnum *(*result)[2] = 0 ;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (meep::realnum *(*)[2])(meep::realnum *(*)[2]) ((arg1)->f_u_backup);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_a_2__p_double, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_f_w_backup_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-f-w-backup-set"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::realnum *(*arg2)[2] ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::realnum *(*)[2])SWIG_MustGetPtr(s_1, SWIGTYPE_p_a_2__p_double, 2, 0);
  }
  {
    meep::realnum * (*inp)[2] = (meep::realnum * (*)[2])(arg2);
    meep::realnum * (*dest)[2] = (meep::realnum * (*)[2])(arg1->f_w_backup);
    size_t ii = 0;
    for (; ii < meep::NUM_FIELD_COMPONENTS; ++ii) {
      meep::realnum * *ip = inp[ii];
      meep::realnum * *dp = dest[ii];
      size_t jj = 0;
      for (; jj < 2; ++jj) dp[jj] = ip[jj];
    }
  }
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_f_w_backup_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-f-w-backup-get"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::realnum *(*result)[2] = 0 ;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (meep::realnum *(*)[2])(meep::realnum *(*)[2]) ((arg1)->f_w_backup);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_a_2__p_double, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_f_cond_backup_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-f-cond-backup-set"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::realnum *(*arg2)[2] ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::realnum *(*)[2])SWIG_MustGetPtr(s_1, SWIGTYPE_p_a_2__p_double, 2, 0);
  }
  {
    meep::realnum * (*inp)[2] = (meep::realnum * (*)[2])(arg2);
    meep::realnum * (*dest)[2] = (meep::realnum * (*)[2])(arg1->f_cond_backup);
    size_t ii = 0;
    for (; ii < meep::NUM_FIELD_COMPONENTS; ++ii) {
      meep::realnum * *ip = inp[ii];
      meep::realnum * *dp = dest[ii];
      size_t jj = 0;
      for (; jj < 2; ++jj) dp[jj] = ip[jj];
    }
  }
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_f_cond_backup_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-f-cond-backup-get"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::realnum *(*result)[2] = 0 ;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (meep::realnum *(*)[2])(meep::realnum *(*)[2]) ((arg1)->f_cond_backup);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_a_2__p_double, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_f_minus_p_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-f-minus-p-set"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::realnum *(*arg2)[2] ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::realnum *(*)[2])SWIG_MustGetPtr(s_1, SWIGTYPE_p_a_2__p_double, 2, 0);
  }
  {
    meep::realnum * (*inp)[2] = (meep::realnum * (*)[2])(arg2);
    meep::realnum * (*dest)[2] = (meep::realnum * (*)[2])(arg1->f_minus_p);
    size_t ii = 0;
    for (; ii < meep::NUM_FIELD_COMPONENTS; ++ii) {
      meep::realnum * *ip = inp[ii];
      meep::realnum * *dp = dest[ii];
      size_t jj = 0;
      for (; jj < 2; ++jj) dp[jj] = ip[jj];
    }
  }
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_f_minus_p_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-f-minus-p-get"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::realnum *(*result)[2] = 0 ;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (meep::realnum *(*)[2])(meep::realnum *(*)[2]) ((arg1)->f_minus_p);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_a_2__p_double, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_f_rderiv_int_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-f-rderiv-int-set"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::realnum *arg2 = (meep::realnum *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::realnum *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_double, 2, 0);
  }
  if (arg1) (arg1)->f_rderiv_int = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_f_rderiv_int_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-f-rderiv-int-get"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::realnum *result = 0 ;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (meep::realnum *) ((arg1)->f_rderiv_int);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_double, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_dft_chunks_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-dft-chunks-set"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::dft_chunk *arg2 = (meep::dft_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::dft_chunk *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__dft_chunk, 2, 0);
  }
  if (arg1) (arg1)->dft_chunks = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_dft_chunks_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-dft-chunks-get"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::dft_chunk *result = 0 ;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (meep::dft_chunk *) ((arg1)->dft_chunks);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__dft_chunk, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_zeroes_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-zeroes-set"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::realnum ***arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::realnum ***)SWIG_MustGetPtr(s_1, SWIGTYPE_p_p_p_double, 2, 0);
  }
  {
    size_t ii;
    meep::realnum ** *b = (meep::realnum ** *) arg1->zeroes;
    for (ii = 0; ii < (size_t)meep::NUM_FIELD_TYPES; ii++) b[ii] = *((meep::realnum ** *) arg2 + ii);
  }
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_zeroes_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-zeroes-get"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::realnum ***result = 0 ;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (meep::realnum ***)(meep::realnum ***) ((arg1)->zeroes);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_p_p_double, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_num_zeroes_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-num-zeroes-set"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  int *arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (int *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_int, 2, 0);
  }
  {
    size_t ii;
    int *b = (int *) arg1->num_zeroes;
    for (ii = 0; ii < (size_t)meep::NUM_FIELD_TYPES; ii++) b[ii] = *((int *) arg2 + ii);
  }
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_num_zeroes_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-num-zeroes-get"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int *result = 0 ;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (int *)(int *) ((arg1)->num_zeroes);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_int, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_connections_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-connections-set"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::realnum **(*arg2)[meep::CONNECT_COPY+1][meep::Outgoing+1] ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::realnum **(*)[meep::CONNECT_COPY+1][meep::Outgoing+1])SWIG_MustGetPtr(s_1, SWIGTYPE_p_a_meep__CONNECT_COPY_1__a_meep__Outgoing_1__p_p_double, 2, 0);
  }
  {
    meep::realnum ** (*inp)[meep::CONNECT_COPY+1] = (meep::realnum ** (*)[meep::CONNECT_COPY+1])(arg2);
    meep::realnum ** (*dest)[meep::CONNECT_COPY+1] = (meep::realnum ** (*)[meep::CONNECT_COPY+1])(arg1->connections);
    size_t ii = 0;
    for (; ii < meep::NUM_FIELD_TYPES; ++ii) {
      meep::realnum ** *ip = inp[ii];
      meep::realnum ** *dp = dest[ii];
      size_t jj = 0;
      for (; jj < meep::CONNECT_COPY+1; ++jj) dp[jj] = ip[jj];
    }
  }
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_connections_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-connections-get"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::realnum **(*result)[meep::CONNECT_COPY+1][meep::Outgoing+1] = 0 ;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (meep::realnum **(*)[meep::CONNECT_COPY+1][meep::Outgoing+1])(meep::realnum **(*)[meep::CONNECT_COPY+1][meep::Outgoing+1]) ((arg1)->connections);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_a_meep__CONNECT_COPY_1__a_meep__Outgoing_1__p_p_double, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_num_connections_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-num-connections-set"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  int (*arg2)[meep::CONNECT_COPY+1][meep::Outgoing+1] ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (int (*)[meep::CONNECT_COPY+1][meep::Outgoing+1])SWIG_MustGetPtr(s_1, SWIGTYPE_p_a_meep__CONNECT_COPY_1__a_meep__Outgoing_1__int, 2, 0);
  }
  {
    int (*inp)[meep::CONNECT_COPY+1] = (int (*)[meep::CONNECT_COPY+1])(arg2);
    int (*dest)[meep::CONNECT_COPY+1] = (int (*)[meep::CONNECT_COPY+1])(arg1->num_connections);
    size_t ii = 0;
    for (; ii < meep::NUM_FIELD_TYPES; ++ii) {
      int *ip = inp[ii];
      int *dp = dest[ii];
      size_t jj = 0;
      for (; jj < meep::CONNECT_COPY+1; ++jj) dp[jj] = ip[jj];
    }
  }
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_num_connections_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-num-connections-get"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int (*result)[meep::CONNECT_COPY+1][meep::Outgoing+1] = 0 ;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (int (*)[meep::CONNECT_COPY+1][meep::Outgoing+1])(int (*)[meep::CONNECT_COPY+1][meep::Outgoing+1]) ((arg1)->num_connections);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_a_meep__CONNECT_COPY_1__a_meep__Outgoing_1__int, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_connection_phases_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-connection-phases-set"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  complex< meep::realnum > **arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (complex< meep::realnum > **)SWIG_MustGetPtr(s_1, SWIGTYPE_p_p_complexT_double_t, 2, 0);
  }
  {
    size_t ii;
    complex< meep::realnum > * *b = (complex< meep::realnum > * *) arg1->connection_phases;
    for (ii = 0; ii < (size_t)meep::NUM_FIELD_TYPES; ii++) b[ii] = *((complex< meep::realnum > * *) arg2 + ii);
  }
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_connection_phases_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-connection-phases-get"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< meep::realnum > **result = 0 ;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (complex< meep::realnum > **)(complex< meep::realnum > **) ((arg1)->connection_phases);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_p_complexT_double_t, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_pols_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-pols-set"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::polarization **arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::polarization **)SWIG_MustGetPtr(s_1, SWIGTYPE_p_p_meep__polarization, 2, 0);
  }
  {
    size_t ii;
    meep::polarization * *b = (meep::polarization * *) arg1->pols;
    for (ii = 0; ii < (size_t)meep::NUM_FIELD_TYPES; ii++) b[ii] = *((meep::polarization * *) arg2 + ii);
  }
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_pols_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-pols-get"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::polarization **result = 0 ;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (meep::polarization **)(meep::polarization **) ((arg1)->pols);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_p_meep__polarization, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_olpols_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-olpols-set"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::polarization **arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::polarization **)SWIG_MustGetPtr(s_1, SWIGTYPE_p_p_meep__polarization, 2, 0);
  }
  {
    size_t ii;
    meep::polarization * *b = (meep::polarization * *) arg1->olpols;
    for (ii = 0; ii < (size_t)meep::NUM_FIELD_TYPES; ii++) b[ii] = *((meep::polarization * *) arg2 + ii);
  }
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_olpols_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-olpols-get"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::polarization **result = 0 ;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (meep::polarization **)(meep::polarization **) ((arg1)->olpols);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_p_meep__polarization, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_a_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-a-set"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  if (arg1) (arg1)->a = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_a_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-a-get"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (double) ((arg1)->a);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_Courant_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-Courant-set"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  if (arg1) (arg1)->Courant = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_Courant_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-Courant-get"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (double) ((arg1)->Courant);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_dt_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-dt-set"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  if (arg1) (arg1)->dt = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_dt_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-dt-get"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (double) ((arg1)->dt);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_gv_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-gv-set"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::grid_volume *arg2 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::grid_volume *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__grid_volume, 2, 0);
  }
  if (arg1) (arg1)->gv = *arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_gv_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-gv-get"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::grid_volume *result = 0 ;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (meep::grid_volume *)& ((arg1)->gv);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__grid_volume, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_v_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-v-set"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::volume *arg2 = (meep::volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::volume *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__volume, 2, 0);
  }
  if (arg1) (arg1)->v = *arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_v_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-v-get"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::volume *result = 0 ;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (meep::volume *)& ((arg1)->v);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__volume, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_m_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-m-set"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  if (arg1) (arg1)->m = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_m_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-m-get"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (double) ((arg1)->m);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_zero_fields_near_cylorigin_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-zero-fields-near-cylorigin-set"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  bool arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (bool) SCM_NFALSEP(s_1);
  }
  if (arg1) (arg1)->zero_fields_near_cylorigin = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_zero_fields_near_cylorigin_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-zero-fields-near-cylorigin-get"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (bool) ((arg1)->zero_fields_near_cylorigin);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_beta_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-beta-set"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  if (arg1) (arg1)->beta = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_beta_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-beta-get"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (double) ((arg1)->beta);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_is_real_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-is-real-set"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  int arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(s_1, SCM_ARG1, FUNC_NAME);
  }
  if (arg1) (arg1)->is_real = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_is_real_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-is-real-get"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (int) ((arg1)->is_real);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_store_pol_energy_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-store-pol-energy-set"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  int arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(s_1, SCM_ARG1, FUNC_NAME);
  }
  if (arg1) (arg1)->store_pol_energy = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_store_pol_energy_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-store-pol-energy-get"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (int) ((arg1)->store_pol_energy);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_bands_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-bands-set"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::bandsdata *arg2 = (meep::bandsdata *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::bandsdata *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__bandsdata, 2, 0);
  }
  if (arg1) (arg1)->bands = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_bands_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-bands-get"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::bandsdata *result = 0 ;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (meep::bandsdata *) ((arg1)->bands);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__bandsdata, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_sources_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-sources-set"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::src_vol **arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::src_vol **)SWIG_MustGetPtr(s_1, SWIGTYPE_p_p_meep__src_vol, 2, 0);
  }
  {
    size_t ii;
    meep::src_vol * *b = (meep::src_vol * *) arg1->sources;
    for (ii = 0; ii < (size_t)meep::NUM_FIELD_TYPES; ii++) b[ii] = *((meep::src_vol * *) arg2 + ii);
  }
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_sources_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-sources-get"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::src_vol **result = 0 ;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (meep::src_vol **)(meep::src_vol **) ((arg1)->sources);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_p_meep__src_vol, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_new_s_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-new-s-set"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::structure_chunk *arg2 = (meep::structure_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::structure_chunk *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__structure_chunk, 2, 0);
  }
  if (arg1) (arg1)->new_s = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_new_s_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-new-s-get"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::structure_chunk *result = 0 ;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (meep::structure_chunk *) ((arg1)->new_s);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__structure_chunk, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_s_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-s-set"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::structure_chunk *arg2 = (meep::structure_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::structure_chunk *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__structure_chunk, 2, 0);
  }
  if (arg1) (arg1)->s = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_s_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-s-get"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::structure_chunk *result = 0 ;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (meep::structure_chunk *) ((arg1)->s);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__structure_chunk, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_outdir_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-outdir-set"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  {
    if (arg2) {
      arg1->outdir = (char const *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->outdir, (const char *)arg2);
    } else {
      arg1->outdir = 0;
    }
  }
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_outdir_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-outdir-get"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  char *result = 0 ;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (char *) ((arg1)->outdir);
  {
    gswig_result = scm_makfrom0str((const char *)result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_fields_chunk__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-fields-chunk"
  meep::structure_chunk *arg1 = (meep::structure_chunk *) 0 ;
  char *arg2 = (char *) 0 ;
  double arg3 ;
  bool arg4 ;
  double arg5 ;
  bool arg6 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::fields_chunk *result = 0 ;
  
  {
    arg1 = (meep::structure_chunk *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure_chunk, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(argv[1]);
    must_free2 = 1;
  }
  {
    arg3 = (double) scm_num2dbl(argv[2], FUNC_NAME);
  }
  {
    arg4 = (bool) SCM_NFALSEP(argv[3]);
  }
  {
    arg5 = (double) scm_num2dbl(argv[4], FUNC_NAME);
  }
  {
    arg6 = (bool) SCM_NFALSEP(argv[5]);
  }
  result = (meep::fields_chunk *)new meep::fields_chunk(arg1,(char const *)arg2,arg3,arg4,arg5,arg6);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__fields_chunk, 1);
  }
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_fields_chunk__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-fields-chunk"
  meep::fields_chunk *arg1 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::fields_chunk *result = 0 ;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (meep::fields_chunk *)new meep::fields_chunk((meep::fields_chunk const &)*arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__fields_chunk, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_fields_chunk(SCM rest)
{
#define FUNC_NAME "new-meep-fields-chunk"
  SCM argv[6];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 6, "new-meep-fields-chunk");
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields_chunk, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      return _wrap_new_meep_fields_chunk__SWIG_1(argc,argv);
    }
  }
  if (argc == 6) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure_chunk, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_STRINGP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_real_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_BOOLP(argv[3]) ? 1 : 0;
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_real_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              {
                _v = SCM_BOOLP(argv[5]) ? 1 : 0;
              }
              if (_v) {
                return _wrap_new_meep_fields_chunk__SWIG_0(argc,argv);
              }
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("new-meep-fields-chunk", "No matching method for generic function `new_meep_fields_chunk'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_delete_meep_fields_chunk (SCM s_0)
{
#define FUNC_NAME "delete-meep-fields-chunk"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  delete arg1;
  gswig_result = SCM_UNSPECIFIED;
  
  SWIG_Guile_MarkPointerDestroyed(s_0);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_peek_field (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-fields-chunk-peek-field"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::component arg2 ;
  meep::vec *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  
  meep::vec vec__arg3 = vector3_to_vec(ctl_convert_vector3_to_c(s_2));
  arg3 = &vec__arg3;
  
  result = (double)(arg1)->peek_field(arg2,(meep::vec const &)*arg3);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_use_real_fields (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-use-real-fields"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  (arg1)->use_real_fields();
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_have_component__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-chunk-have-component"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::component arg2 ;
  bool arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (bool) SCM_NFALSEP(argv[2]);
  }
  result = (bool)(arg1)->have_component(arg2,arg3);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_have_component__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-chunk-have-component"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::component arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  result = (bool)(arg1)->have_component(arg2);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_have_component(SCM rest)
{
#define FUNC_NAME "meep-fields-chunk-have-component"
  SCM argv[3];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "meep-fields-chunk-have-component");
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields_chunk, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        return _wrap_meep_fields_chunk_have_component__SWIG_1(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields_chunk, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_BOOLP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_fields_chunk_have_component__SWIG_0(argc,argv);
        }
      }
    }
  }
  
  scm_misc_error("meep-fields-chunk-have-component", "No matching method for generic function `meep_fields_chunk_have_component'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_last_source_time (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-last-source-time"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (double)(arg1)->last_source_time();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_get_field__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-chunk-get-field"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::component arg2 ;
  meep::ivec *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > result;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::ivec *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__ivec, 3, 0);
  }
  result = ((meep::fields_chunk const *)arg1)->get_field(arg2,(meep::ivec const &)*arg3);
  {
    gswig_result = scm_make_rectangular(scm_make_real((&result)->real()),
      scm_make_real((&result)->imag()));
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_get_field_gv (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-get-field-gv"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::component arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  SwigValueWrapper< meep::volume > result;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = ((meep::fields_chunk const *)arg1)->get_field_gv(arg2);
  {
    meep::volume * resultptr;
    resultptr = new meep::volume((const meep::volume &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__volume, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_get_field__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-chunk-get-field"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::component arg2 ;
  meep::vec *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > result;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  
  meep::vec vec__arg3 = vector3_to_vec(ctl_convert_vector3_to_c(argv[2]));
  arg3 = &vec__arg3;
  
  result = ((meep::fields_chunk const *)arg1)->get_field(arg2,(meep::vec const &)*arg3);
  {
    gswig_result = scm_make_rectangular(scm_make_real((&result)->real()),
      scm_make_real((&result)->imag()));
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_get_field(SCM rest)
{
#define FUNC_NAME "meep-fields-chunk-get-field"
  SCM argv[3];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "meep-fields-chunk-get-field");
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields_chunk, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__ivec, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_meep_fields_chunk_get_field__SWIG_0(argc,argv);
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields_chunk, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SwigVector3_Check(argv[2]);
        }
        if (_v) {
          return _wrap_meep_fields_chunk_get_field__SWIG_1(argc,argv);
        }
      }
    }
  }
  
  scm_misc_error("meep-fields-chunk-get-field", "No matching method for generic function `meep_fields_chunk_get_field'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_get_polarization_energy__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-chunk-get-polarization-energy"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::ivec *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::ivec *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__ivec, 2, 0);
  }
  result = (double)((meep::fields_chunk const *)arg1)->get_polarization_energy((meep::ivec const &)*arg2);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_my_polarization_energy__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-chunk-my-polarization-energy"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::ivec *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::ivec *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__ivec, 2, 0);
  }
  result = (double)((meep::fields_chunk const *)arg1)->my_polarization_energy((meep::ivec const &)*arg2);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_get_polarization_energy__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-chunk-get-polarization-energy"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::polarizability_identifier *arg2 = 0 ;
  meep::ivec *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::polarizability_identifier *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__polarizability_identifier, 2, 0);
  }
  {
    arg3 = (meep::ivec *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__ivec, 3, 0);
  }
  result = (double)((meep::fields_chunk const *)arg1)->get_polarization_energy((meep::polarizability_identifier const &)*arg2,(meep::ivec const &)*arg3);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_get_polarization_energy(SCM rest)
{
#define FUNC_NAME "meep-fields-chunk-get-polarization-energy"
  SCM argv[3];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "meep-fields-chunk-get-polarization-energy");
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields_chunk, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__ivec, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_meep_fields_chunk_get_polarization_energy__SWIG_0(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields_chunk, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__polarizability_identifier, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__ivec, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_meep_fields_chunk_get_polarization_energy__SWIG_1(argc,argv);
        }
      }
    }
  }
  
  scm_misc_error("meep-fields-chunk-get-polarization-energy", "No matching method for generic function `meep_fields_chunk_get_polarization_energy'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_my_polarization_energy__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-chunk-my-polarization-energy"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::polarizability_identifier *arg2 = 0 ;
  meep::ivec *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::polarizability_identifier *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__polarizability_identifier, 2, 0);
  }
  {
    arg3 = (meep::ivec *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__ivec, 3, 0);
  }
  result = (double)((meep::fields_chunk const *)arg1)->my_polarization_energy((meep::polarizability_identifier const &)*arg2,(meep::ivec const &)*arg3);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_my_polarization_energy(SCM rest)
{
#define FUNC_NAME "meep-fields-chunk-my-polarization-energy"
  SCM argv[3];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "meep-fields-chunk-my-polarization-energy");
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields_chunk, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__ivec, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_meep_fields_chunk_my_polarization_energy__SWIG_0(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields_chunk, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__polarizability_identifier, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__ivec, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_meep_fields_chunk_my_polarization_energy__SWIG_1(argc,argv);
        }
      }
    }
  }
  
  scm_misc_error("meep-fields-chunk-my-polarization-energy", "No matching method for generic function `meep_fields_chunk_my_polarization_energy'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_get_chi1inv (SCM s_0, SCM s_1, SCM s_2, SCM s_3)
{
#define FUNC_NAME "meep-fields-chunk-get-chi1inv"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::component arg2 ;
  meep::direction arg3 ;
  meep::ivec *arg4 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::direction) scm_num2int(s_2, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg4 = (meep::ivec *)SWIG_MustGetPtr(s_3, SWIGTYPE_p_meep__ivec, 4, 0);
  }
  result = (double)((meep::fields_chunk const *)arg1)->get_chi1inv(arg2,arg3,(meep::ivec const &)*arg4);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_analytic_chi1 (SCM s_0, SCM s_1, SCM s_2, SCM s_3)
{
#define FUNC_NAME "meep-fields-chunk-analytic-chi1"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::component arg2 ;
  double arg3 ;
  meep::vec *arg4 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > result;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (double) scm_num2dbl(s_2, FUNC_NAME);
  }
  
  meep::vec vec__arg4 = vector3_to_vec(ctl_convert_vector3_to_c(s_3));
  arg4 = &vec__arg4;
  
  result = ((meep::fields_chunk const *)arg1)->analytic_chi1(arg2,arg3,(meep::vec const &)*arg4);
  {
    gswig_result = scm_make_rectangular(scm_make_real((&result)->real()),
      scm_make_real((&result)->imag()));
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_backup_component (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-backup-component"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::component arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  (arg1)->backup_component(arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_average_with_backup (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-average-with-backup"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::component arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  (arg1)->average_with_backup(arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_restore_component (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-restore-component"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::component arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  (arg1)->restore_component(arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_set_output_directory (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-set-output-directory"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  (arg1)->set_output_directory((char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_verbose__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-chunk-verbose"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  int arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME);
  }
  (arg1)->verbose(arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_verbose__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-chunk-verbose"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  (arg1)->verbose();
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_verbose(SCM rest)
{
#define FUNC_NAME "meep-fields-chunk-verbose"
  SCM argv[2];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 2, "meep-fields-chunk-verbose");
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields_chunk, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      return _wrap_meep_fields_chunk_verbose__SWIG_1(argc,argv);
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields_chunk, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        return _wrap_meep_fields_chunk_verbose__SWIG_0(argc,argv);
      }
    }
  }
  
  scm_misc_error("meep-fields-chunk-verbose", "No matching method for generic function `meep_fields_chunk_verbose'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_count_volume (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-count-volume"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::component arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = (double)(arg1)->count_volume(arg2);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_n_proc (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-n-proc"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (int)((meep::fields_chunk const *)arg1)->n_proc();
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_is_mine (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-is-mine"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  result = (int)((meep::fields_chunk const *)arg1)->is_mine();
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_zero_metal (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-zero-metal"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::field_type arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::field_type) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  (arg1)->zero_metal(arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_remove_sources (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-remove-sources"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  (arg1)->remove_sources();
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_remove_polarizabilities (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-remove-polarizabilities"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  (arg1)->remove_polarizabilities();
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_zero_fields (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-zero-fields"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  (arg1)->zero_fields();
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_update_eh__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-chunk-update-eh"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::field_type arg2 ;
  bool arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::field_type) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (bool) SCM_NFALSEP(argv[2]);
  }
  result = (bool)(arg1)->update_eh(arg2,arg3);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_update_eh__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-chunk-update-eh"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::field_type arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::field_type) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  result = (bool)(arg1)->update_eh(arg2);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_update_eh(SCM rest)
{
#define FUNC_NAME "meep-fields-chunk-update-eh"
  SCM argv[3];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "meep-fields-chunk-update-eh");
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields_chunk, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        return _wrap_meep_fields_chunk_update_eh__SWIG_1(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields_chunk, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_BOOLP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_fields_chunk_update_eh__SWIG_0(argc,argv);
        }
      }
    }
  }
  
  scm_misc_error("meep-fields-chunk-update-eh", "No matching method for generic function `meep_fields_chunk_update_eh'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_alloc_f (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-alloc-f"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  meep::component arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = (bool)(arg1)->alloc_f(arg2);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_figure_out_step_plan (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-figure-out-step-plan"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  (arg1)->figure_out_step_plan();
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_set_solve_cw_omega (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunk-set-solve-cw-omega"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  complex< double > arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  {
    cnumber cnum = ctl_convert_cnumber_to_c(s_1);
    arg2 = std::complex<double>(cnum.re, cnum.im);
  }
  (arg1)->set_solve_cw_omega(arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunk_unset_solve_cw_omega (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunk-unset-solve-cw-omega"
  meep::fields_chunk *arg1 = (meep::fields_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields_chunk *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields_chunk, 1, 0);
  }
  (arg1)->unset_solve_cw_omega();
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_boundary_condition_Periodic(SCM s_0)
{
#define FUNC_NAME "meep-boundary-condition-Periodic"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_boundary_condition_Periodic);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_boundary_condition_Metallic(SCM s_0)
{
#define FUNC_NAME "meep-boundary-condition-Metallic"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_boundary_condition_Metallic);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_boundary_condition_Magnetic(SCM s_0)
{
#define FUNC_NAME "meep-boundary-condition-Magnetic"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_boundary_condition_Magnetic);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_boundary_condition_None(SCM s_0)
{
#define FUNC_NAME "meep-boundary-condition-None"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_boundary_condition_None);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_time_sink_Connecting(SCM s_0)
{
#define FUNC_NAME "meep-time-sink-Connecting"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_time_sink_Connecting);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_time_sink_Stepping(SCM s_0)
{
#define FUNC_NAME "meep-time-sink-Stepping"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_time_sink_Stepping);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_time_sink_Boundaries(SCM s_0)
{
#define FUNC_NAME "meep-time-sink-Boundaries"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_time_sink_Boundaries);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_time_sink_MpiTime(SCM s_0)
{
#define FUNC_NAME "meep-time-sink-MpiTime"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_time_sink_MpiTime);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_time_sink_FieldOutput(SCM s_0)
{
#define FUNC_NAME "meep-time-sink-FieldOutput"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_time_sink_FieldOutput);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_time_sink_FourierTransforming(SCM s_0)
{
#define FUNC_NAME "meep-time-sink-FourierTransforming"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_time_sink_FourierTransforming);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_time_sink_Other(SCM s_0)
{
#define FUNC_NAME "meep-time-sink-Other"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_meep_time_sink_Other);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_derived_component_func (SCM s_0, SCM s_1, SCM s_2, SCM s_3)
{
#define FUNC_NAME "meep-derived-component-func"
  meep::derived_component arg1 ;
  meep::grid_volume *arg2 = 0 ;
  int *arg3 = 0 ;
  meep::component *arg4 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::field_rfunction result;
  
  {
    arg1 = (meep::derived_component) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg2 = (meep::grid_volume *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__grid_volume, 2, 0);
  }
  {
    arg3 = (int *)SWIG_MustGetPtr(s_2, SWIGTYPE_p_int, 3, 0);
  }
  {
    arg4 = (meep::component *)SWIG_MustGetPtr(s_3, SWIGTYPE_p_meep__component, 4, 0);
  }
  result = (meep::field_rfunction)meep::derived_component_func(arg1,(meep::grid_volume const &)*arg2,*arg3,arg4);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_f_p_q_const__complex__double___r_q_const__meep__vec_p_void__double, 0);
  }
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_num_chunks_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-num-chunks-set"
  meep::fields *arg1 = (meep::fields *) 0 ;
  int arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(s_1, SCM_ARG1, FUNC_NAME);
  }
  if (arg1) (arg1)->num_chunks = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_num_chunks_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-num-chunks-get"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (int) ((arg1)->num_chunks);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunks_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-chunks-set"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::fields_chunk **arg2 = (meep::fields_chunk **) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::fields_chunk **)SWIG_MustGetPtr(s_1, SWIGTYPE_p_p_meep__fields_chunk, 2, 0);
  }
  if (arg1) (arg1)->chunks = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_chunks_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-chunks-get"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::fields_chunk **result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (meep::fields_chunk **) ((arg1)->chunks);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_p_meep__fields_chunk, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_sources_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-sources-set"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::src_time *arg2 = (meep::src_time *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::src_time *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__src_time, 2, 0);
  }
  if (arg1) (arg1)->sources = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_sources_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-sources-get"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::src_time *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (meep::src_time *) ((arg1)->sources);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__src_time, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_fluxes_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-fluxes-set"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::flux_vol *arg2 = (meep::flux_vol *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::flux_vol *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__flux_vol, 2, 0);
  }
  if (arg1) (arg1)->fluxes = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_fluxes_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-fluxes-get"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::flux_vol *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (meep::flux_vol *) ((arg1)->fluxes);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__flux_vol, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_S_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-S-set"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::symmetry *arg2 = (meep::symmetry *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::symmetry *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__symmetry, 2, 0);
  }
  if (arg1) (arg1)->S = *arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_S_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-S-get"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::symmetry *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (meep::symmetry *)& ((arg1)->S);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__symmetry, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_comm_blocks_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-comm-blocks-set"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::realnum ***arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::realnum ***)SWIG_MustGetPtr(s_1, SWIGTYPE_p_p_p_double, 2, 0);
  }
  {
    size_t ii;
    meep::realnum ** *b = (meep::realnum ** *) arg1->comm_blocks;
    for (ii = 0; ii < (size_t)meep::NUM_FIELD_TYPES; ii++) b[ii] = *((meep::realnum ** *) arg2 + ii);
  }
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_comm_blocks_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-comm-blocks-get"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::realnum ***result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (meep::realnum ***)(meep::realnum ***) ((arg1)->comm_blocks);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_p_p_double, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_comm_sizes_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-comm-sizes-set"
  meep::fields *arg1 = (meep::fields *) 0 ;
  int *(*arg2)[meep::CONNECT_COPY+1] ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (int *(*)[meep::CONNECT_COPY+1])SWIG_MustGetPtr(s_1, SWIGTYPE_p_a_meep__CONNECT_COPY_1__p_int, 2, 0);
  }
  {
    int * (*inp)[meep::CONNECT_COPY+1] = (int * (*)[meep::CONNECT_COPY+1])(arg2);
    int * (*dest)[meep::CONNECT_COPY+1] = (int * (*)[meep::CONNECT_COPY+1])(arg1->comm_sizes);
    size_t ii = 0;
    for (; ii < meep::NUM_FIELD_TYPES; ++ii) {
      int * *ip = inp[ii];
      int * *dp = dest[ii];
      size_t jj = 0;
      for (; jj < meep::CONNECT_COPY+1; ++jj) dp[jj] = ip[jj];
    }
  }
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_comm_sizes_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-comm-sizes-get"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int *(*result)[meep::CONNECT_COPY+1] = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (int *(*)[meep::CONNECT_COPY+1])(int *(*)[meep::CONNECT_COPY+1]) ((arg1)->comm_sizes);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_a_meep__CONNECT_COPY_1__p_int, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_comm_size_tot (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-fields-comm-size-tot"
  meep::fields *arg1 = (meep::fields *) 0 ;
  int arg2 ;
  int arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(s_1, SCM_ARG1, FUNC_NAME);
  }
  {
    arg3 = (int) scm_num2int(s_2, SCM_ARG1, FUNC_NAME);
  }
  result = (int)((meep::fields const *)arg1)->comm_size_tot(arg2,arg3);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_a_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-a-set"
  meep::fields *arg1 = (meep::fields *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  if (arg1) (arg1)->a = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_a_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-a-get"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (double) ((arg1)->a);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_dt_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-dt-set"
  meep::fields *arg1 = (meep::fields *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  if (arg1) (arg1)->dt = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_dt_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-dt-get"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (double) ((arg1)->dt);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_gv_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-gv-set"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::grid_volume *arg2 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::grid_volume *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__grid_volume, 2, 0);
  }
  if (arg1) (arg1)->gv = *arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_gv_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-gv-get"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::grid_volume *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (meep::grid_volume *)& ((arg1)->gv);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__grid_volume, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_user_volume_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-user-volume-set"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::grid_volume *arg2 = (meep::grid_volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::grid_volume *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__grid_volume, 2, 0);
  }
  if (arg1) (arg1)->user_volume = *arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_user_volume_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-user-volume-get"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::grid_volume *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (meep::grid_volume *)& ((arg1)->user_volume);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__grid_volume, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_v_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-v-set"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::volume *arg2 = (meep::volume *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::volume *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__volume, 2, 0);
  }
  if (arg1) (arg1)->v = *arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_v_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-v-get"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::volume *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (meep::volume *)& ((arg1)->v);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__volume, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_m_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-m-set"
  meep::fields *arg1 = (meep::fields *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  if (arg1) (arg1)->m = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_m_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-m-get"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (double) ((arg1)->m);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_beta_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-beta-set"
  meep::fields *arg1 = (meep::fields *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  if (arg1) (arg1)->beta = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_beta_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-beta-get"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (double) ((arg1)->beta);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_t_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-t-set"
  meep::fields *arg1 = (meep::fields *) 0 ;
  int arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(s_1, SCM_ARG1, FUNC_NAME);
  }
  if (arg1) (arg1)->t = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_t_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-t-get"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (int) ((arg1)->t);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_phasein_time_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-phasein-time-set"
  meep::fields *arg1 = (meep::fields *) 0 ;
  int arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(s_1, SCM_ARG1, FUNC_NAME);
  }
  if (arg1) (arg1)->phasein_time = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_phasein_time_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-phasein-time-get"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (int) ((arg1)->phasein_time);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_is_real_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-is-real-set"
  meep::fields *arg1 = (meep::fields *) 0 ;
  int arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(s_1, SCM_ARG1, FUNC_NAME);
  }
  if (arg1) (arg1)->is_real = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_is_real_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-is-real-get"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (int) ((arg1)->is_real);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_k_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-k-set"
  meep::fields *arg1 = (meep::fields *) 0 ;
  complex< double > *arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (complex< double > *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_complexT_double_t, 2, 0);
  }
  {
    size_t ii;
    complex< double > *b = (complex< double > *) arg1->k;
    for (ii = 0; ii < (size_t)5; ii++) b[ii] = *((complex< double > *) arg2 + ii);
  }
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_k_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-k-get"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (complex< double > *)(complex< double > *) ((arg1)->k);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_complexT_double_t, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_eikna_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-eikna-set"
  meep::fields *arg1 = (meep::fields *) 0 ;
  complex< double > *arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (complex< double > *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_complexT_double_t, 2, 0);
  }
  {
    size_t ii;
    complex< double > *b = (complex< double > *) arg1->eikna;
    for (ii = 0; ii < (size_t)5; ii++) b[ii] = *((complex< double > *) arg2 + ii);
  }
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_eikna_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-eikna-get"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (complex< double > *)(complex< double > *) ((arg1)->eikna);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_complexT_double_t, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_coskna_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-coskna-set"
  meep::fields *arg1 = (meep::fields *) 0 ;
  double *arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (double *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_double, 2, 0);
  }
  {
    size_t ii;
    double *b = (double *) arg1->coskna;
    for (ii = 0; ii < (size_t)5; ii++) b[ii] = *((double *) arg2 + ii);
  }
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_coskna_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-coskna-get"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (double *)(double *) ((arg1)->coskna);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_double, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_sinkna_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-sinkna-set"
  meep::fields *arg1 = (meep::fields *) 0 ;
  double *arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (double *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_double, 2, 0);
  }
  {
    size_t ii;
    double *b = (double *) arg1->sinkna;
    for (ii = 0; ii < (size_t)5; ii++) b[ii] = *((double *) arg2 + ii);
  }
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_sinkna_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-sinkna-get"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (double *)(double *) ((arg1)->sinkna);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_double, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_boundaries_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-boundaries-set"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::boundary_condition (*arg2)[5] ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::boundary_condition (*)[5])SWIG_MustGetPtr(s_1, SWIGTYPE_p_a_5__meep__boundary_condition, 2, 0);
  }
  {
    meep::boundary_condition (*inp)[5] = (meep::boundary_condition (*)[5])(arg2);
    meep::boundary_condition (*dest)[5] = (meep::boundary_condition (*)[5])(arg1->boundaries);
    size_t ii = 0;
    for (; ii < 2; ++ii) {
      meep::boundary_condition *ip = inp[ii];
      meep::boundary_condition *dp = dest[ii];
      size_t jj = 0;
      for (; jj < 5; ++jj) dp[jj] = ip[jj];
    }
  }
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_boundaries_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-boundaries-get"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::boundary_condition (*result)[5] = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (meep::boundary_condition (*)[5])(meep::boundary_condition (*)[5]) ((arg1)->boundaries);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_a_5__meep__boundary_condition, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_bands_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-bands-set"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::bandsdata *arg2 = (meep::bandsdata *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::bandsdata *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__bandsdata, 2, 0);
  }
  if (arg1) (arg1)->bands = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_bands_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-bands-get"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::bandsdata *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (meep::bandsdata *) ((arg1)->bands);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__bandsdata, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_outdir_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-outdir-set"
  meep::fields *arg1 = (meep::fields *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  {
    if (arg1->outdir) delete [] arg1->outdir;
    if (arg2) {
      arg1->outdir = (char *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->outdir, (const char *)arg2);
    } else {
      arg1->outdir = 0;
    }
  }
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_outdir_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-outdir-get"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  char *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (char *) ((arg1)->outdir);
  {
    gswig_result = scm_makfrom0str((const char *)result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_fields__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-fields"
  meep::structure *arg1 = (meep::structure *) 0 ;
  double arg2 ;
  bool arg3 ;
  double arg4 ;
  bool arg5 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::fields *result = 0 ;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(argv[1], FUNC_NAME);
  }
  {
    arg3 = (bool) SCM_NFALSEP(argv[2]);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  {
    arg5 = (bool) SCM_NFALSEP(argv[4]);
  }
  result = (meep::fields *)new meep::fields(arg1,arg2,arg3,arg4,arg5);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__fields, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_fields__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-fields"
  meep::structure *arg1 = (meep::structure *) 0 ;
  double arg2 ;
  bool arg3 ;
  double arg4 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::fields *result = 0 ;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(argv[1], FUNC_NAME);
  }
  {
    arg3 = (bool) SCM_NFALSEP(argv[2]);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  result = (meep::fields *)new meep::fields(arg1,arg2,arg3,arg4);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__fields, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_fields__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-fields"
  meep::structure *arg1 = (meep::structure *) 0 ;
  double arg2 ;
  bool arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::fields *result = 0 ;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(argv[1], FUNC_NAME);
  }
  {
    arg3 = (bool) SCM_NFALSEP(argv[2]);
  }
  result = (meep::fields *)new meep::fields(arg1,arg2,arg3);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__fields, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_fields__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-fields"
  meep::structure *arg1 = (meep::structure *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::fields *result = 0 ;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(argv[1], FUNC_NAME);
  }
  result = (meep::fields *)new meep::fields(arg1,arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__fields, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_fields__SWIG_4 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-fields"
  meep::structure *arg1 = (meep::structure *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::fields *result = 0 ;
  
  {
    arg1 = (meep::structure *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__structure, 1, 0);
  }
  result = (meep::fields *)new meep::fields(arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__fields, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_fields__SWIG_5 (int argc, SCM *argv)
{
#define FUNC_NAME "new-meep-fields"
  meep::fields *arg1 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::fields *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (meep::fields *)new meep::fields((meep::fields const &)*arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__fields, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new_meep_fields(SCM rest)
{
#define FUNC_NAME "new-meep-fields"
  SCM argv[5];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 5, "new-meep-fields");
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      return _wrap_new_meep_fields__SWIG_4(argc,argv);
    }
  }
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      return _wrap_new_meep_fields__SWIG_5(argc,argv);
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_real_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        return _wrap_new_meep_fields__SWIG_3(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_real_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_BOOLP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          return _wrap_new_meep_fields__SWIG_2(argc,argv);
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_real_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_BOOLP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            return _wrap_new_meep_fields__SWIG_1(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__structure, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_real_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_BOOLP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            {
              _v = SCM_BOOLP(argv[4]) ? 1 : 0;
            }
            if (_v) {
              return _wrap_new_meep_fields__SWIG_0(argc,argv);
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("new-meep-fields", "No matching method for generic function `new_meep_fields'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_delete_meep_fields (SCM s_0)
{
#define FUNC_NAME "delete-meep-fields"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  delete arg1;
  gswig_result = SCM_UNSPECIFIED;
  
  SWIG_Guile_MarkPointerDestroyed(s_0);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_equal_layout (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-equal-layout"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::fields *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::fields *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__fields, 2, 0);
  }
  result = (bool)((meep::fields const *)arg1)->equal_layout((meep::fields const &)*arg2);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_use_real_fields (SCM s_0)
{
#define FUNC_NAME "meep-fields-use-real-fields"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  (arg1)->use_real_fields();
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_zero_fields (SCM s_0)
{
#define FUNC_NAME "meep-fields-zero-fields"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  (arg1)->zero_fields();
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_remove_sources (SCM s_0)
{
#define FUNC_NAME "meep-fields-remove-sources"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  (arg1)->remove_sources();
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_remove_polarizabilities (SCM s_0)
{
#define FUNC_NAME "meep-fields-remove-polarizabilities"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  (arg1)->remove_polarizabilities();
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_remove_fluxes (SCM s_0)
{
#define FUNC_NAME "meep-fields-remove-fluxes"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  (arg1)->remove_fluxes();
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_reset (SCM s_0)
{
#define FUNC_NAME "meep-fields-reset"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  (arg1)->reset();
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_time_spent_on (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-time-spent-on"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::time_sink arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::time_sink) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = (double)(arg1)->time_spent_on(arg2);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_print_times (SCM s_0)
{
#define FUNC_NAME "meep-fields-print-times"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  (arg1)->print_times();
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_set_boundary (SCM s_0, SCM s_1, SCM s_2, SCM s_3)
{
#define FUNC_NAME "meep-fields-set-boundary"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::boundary_side arg2 ;
  meep::direction arg3 ;
  meep::boundary_condition arg4 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::boundary_side) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::direction) scm_num2int(s_2, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg4 = (meep::boundary_condition) scm_num2int(s_3, SCM_ARG1, FUNC_NAME); 
  }
  (arg1)->set_boundary(arg2,arg3,arg4);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_use_bloch__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-use-bloch"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::direction arg2 ;
  double arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::direction) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (double) scm_num2dbl(argv[2], FUNC_NAME);
  }
  (arg1)->use_bloch(arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_use_bloch__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-use-bloch"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::direction arg2 ;
  complex< double > arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::direction) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    cnumber cnum = ctl_convert_cnumber_to_c(argv[2]);
    arg3 = std::complex<double>(cnum.re, cnum.im);
  }
  (arg1)->use_bloch(arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_use_bloch__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-use-bloch"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::vec *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  
  meep::vec vec__arg2 = vector3_to_vec(ctl_convert_vector3_to_c(argv[1]));
  arg2 = &vec__arg2;
  
  (arg1)->use_bloch((meep::vec const &)*arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_use_bloch(SCM rest)
{
#define FUNC_NAME "meep-fields-use-bloch"
  SCM argv[3];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "meep-fields-use-bloch");
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SwigVector3_Check(argv[1]);
      }
      if (_v) {
        return _wrap_meep_fields_use_bloch__SWIG_2(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_real_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_fields_use_bloch__SWIG_0(argc,argv);
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SwigComplex_Check(argv[2]);
        }
        if (_v) {
          return _wrap_meep_fields_use_bloch__SWIG_1(argc,argv);
        }
      }
    }
  }
  
  scm_misc_error("meep-fields-use-bloch", "No matching method for generic function `meep_fields_use_bloch'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_lattice_vector (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-lattice-vector"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::direction arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::vec result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::direction) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = ((meep::fields const *)arg1)->lattice_vector(arg2);
  {
    gswig_result = ctl_convert_vector3_to_scm(vec_to_vector3(result));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_update_eh__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-update-eh"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::field_type arg2 ;
  bool arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::field_type) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (bool) SCM_NFALSEP(argv[2]);
  }
  (arg1)->update_eh(arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_update_eh__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-update-eh"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::field_type arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::field_type) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  (arg1)->update_eh(arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_update_eh(SCM rest)
{
#define FUNC_NAME "meep-fields-update-eh"
  SCM argv[3];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "meep-fields-update-eh");
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        return _wrap_meep_fields_update_eh__SWIG_1(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_BOOLP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_fields_update_eh__SWIG_0(argc,argv);
        }
      }
    }
  }
  
  scm_misc_error("meep-fields-update-eh", "No matching method for generic function `meep_fields_update_eh'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_total_volume (SCM s_0)
{
#define FUNC_NAME "meep-fields-total-volume"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  SwigValueWrapper< meep::volume > result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = ((meep::fields const *)arg1)->total_volume();
  {
    meep::volume * resultptr;
    resultptr = new meep::volume((const meep::volume &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__volume, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_output_hdf5__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-output-hdf5"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::h5file *arg2 = (meep::h5file *) 0 ;
  char *arg3 = (char *) 0 ;
  int arg4 ;
  meep::component *arg5 = (meep::component *) 0 ;
  meep::field_function arg6 = (meep::field_function) 0 ;
  void *arg7 = (void *) 0 ;
  int arg8 ;
  meep::volume *arg9 = 0 ;
  bool arg10 ;
  bool arg11 ;
  int must_free3 = 0 ;
  my_field_func_data data4 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::h5file *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__h5file, 2, 0);
  }
  {
    arg3 = (char *)SWIG_scm2str(argv[2]);
    must_free3 = 1;
  }
  {
    arg4 = list_length(SCM_CAR(argv[3]));
    arg5 = new meep::component[arg4];
    for (int i = 0; i < arg4; ++i)
    arg5[i] = meep::component(integer_list_ref(SCM_CAR(argv[3]), i));
    data4.nf = arg4;
    data4.func = SCM_CDR(argv[3]);
    arg6 = my_field_func;
    arg7 = &data4;
  }
  {
    arg8 = (int) scm_num2int(argv[4], SCM_ARG1, FUNC_NAME);
  }
  {
    arg9 = (meep::volume *)SWIG_MustGetPtr(argv[5], SWIGTYPE_p_meep__volume, 9, 0);
  }
  {
    arg10 = (bool) SCM_NFALSEP(argv[6]);
  }
  {
    arg11 = (bool) SCM_NFALSEP(argv[7]);
  }
  (arg1)->output_hdf5(arg2,(char const *)arg3,arg4,(meep::component const *)arg5,arg6,arg7,arg8,(meep::volume const &)*arg9,arg10,arg11);
  gswig_result = SCM_UNSPECIFIED;
  
  
  if (must_free3 && arg3) SWIG_free(arg3);
  {
    if (arg5) delete[] arg5;
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_output_hdf5__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-output-hdf5"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::h5file *arg2 = (meep::h5file *) 0 ;
  char *arg3 = (char *) 0 ;
  int arg4 ;
  meep::component *arg5 = (meep::component *) 0 ;
  meep::field_function arg6 = (meep::field_function) 0 ;
  void *arg7 = (void *) 0 ;
  int arg8 ;
  meep::volume *arg9 = 0 ;
  bool arg10 ;
  int must_free3 = 0 ;
  my_field_func_data data4 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::h5file *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__h5file, 2, 0);
  }
  {
    arg3 = (char *)SWIG_scm2str(argv[2]);
    must_free3 = 1;
  }
  {
    arg4 = list_length(SCM_CAR(argv[3]));
    arg5 = new meep::component[arg4];
    for (int i = 0; i < arg4; ++i)
    arg5[i] = meep::component(integer_list_ref(SCM_CAR(argv[3]), i));
    data4.nf = arg4;
    data4.func = SCM_CDR(argv[3]);
    arg6 = my_field_func;
    arg7 = &data4;
  }
  {
    arg8 = (int) scm_num2int(argv[4], SCM_ARG1, FUNC_NAME);
  }
  {
    arg9 = (meep::volume *)SWIG_MustGetPtr(argv[5], SWIGTYPE_p_meep__volume, 9, 0);
  }
  {
    arg10 = (bool) SCM_NFALSEP(argv[6]);
  }
  (arg1)->output_hdf5(arg2,(char const *)arg3,arg4,(meep::component const *)arg5,arg6,arg7,arg8,(meep::volume const &)*arg9,arg10);
  gswig_result = SCM_UNSPECIFIED;
  
  
  if (must_free3 && arg3) SWIG_free(arg3);
  {
    if (arg5) delete[] arg5;
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_output_hdf5__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-output-hdf5"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::h5file *arg2 = (meep::h5file *) 0 ;
  char *arg3 = (char *) 0 ;
  int arg4 ;
  meep::component *arg5 = (meep::component *) 0 ;
  meep::field_function arg6 = (meep::field_function) 0 ;
  void *arg7 = (void *) 0 ;
  int arg8 ;
  meep::volume *arg9 = 0 ;
  int must_free3 = 0 ;
  my_field_func_data data4 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::h5file *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__h5file, 2, 0);
  }
  {
    arg3 = (char *)SWIG_scm2str(argv[2]);
    must_free3 = 1;
  }
  {
    arg4 = list_length(SCM_CAR(argv[3]));
    arg5 = new meep::component[arg4];
    for (int i = 0; i < arg4; ++i)
    arg5[i] = meep::component(integer_list_ref(SCM_CAR(argv[3]), i));
    data4.nf = arg4;
    data4.func = SCM_CDR(argv[3]);
    arg6 = my_field_func;
    arg7 = &data4;
  }
  {
    arg8 = (int) scm_num2int(argv[4], SCM_ARG1, FUNC_NAME);
  }
  {
    arg9 = (meep::volume *)SWIG_MustGetPtr(argv[5], SWIGTYPE_p_meep__volume, 9, 0);
  }
  (arg1)->output_hdf5(arg2,(char const *)arg3,arg4,(meep::component const *)arg5,arg6,arg7,arg8,(meep::volume const &)*arg9);
  gswig_result = SCM_UNSPECIFIED;
  
  
  if (must_free3 && arg3) SWIG_free(arg3);
  {
    if (arg5) delete[] arg5;
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_output_hdf5__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-output-hdf5"
  meep::fields *arg1 = (meep::fields *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  meep::component *arg4 = (meep::component *) 0 ;
  meep::field_function arg5 = (meep::field_function) 0 ;
  void *arg6 = (void *) 0 ;
  meep::volume *arg7 = 0 ;
  meep::h5file *arg8 = (meep::h5file *) 0 ;
  bool arg9 ;
  bool arg10 ;
  char *arg11 = (char *) 0 ;
  bool arg12 ;
  int must_free2 = 0 ;
  my_field_func_data data3 ;
  int must_free11 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(argv[1]);
    must_free2 = 1;
  }
  {
    arg3 = list_length(SCM_CAR(argv[2]));
    arg4 = new meep::component[arg3];
    for (int i = 0; i < arg3; ++i)
    arg4[i] = meep::component(integer_list_ref(SCM_CAR(argv[2]), i));
    data3.nf = arg3;
    data3.func = SCM_CDR(argv[2]);
    arg5 = my_field_func;
    arg6 = &data3;
  }
  {
    arg7 = (meep::volume *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__volume, 7, 0);
  }
  {
    arg8 = (meep::h5file *)SWIG_MustGetPtr(argv[4], SWIGTYPE_p_meep__h5file, 8, 0);
  }
  {
    arg9 = (bool) SCM_NFALSEP(argv[5]);
  }
  {
    arg10 = (bool) SCM_NFALSEP(argv[6]);
  }
  {
    arg11 = (char *)SWIG_scm2str(argv[7]);
    must_free11 = 1;
  }
  {
    arg12 = (bool) SCM_NFALSEP(argv[8]);
  }
  (arg1)->output_hdf5((char const *)arg2,arg3,(meep::component const *)arg4,arg5,arg6,(meep::volume const &)*arg7,arg8,arg9,arg10,(char const *)arg11,arg12);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  {
    if (arg4) delete[] arg4;
  }
  
  
  if (must_free11 && arg11) SWIG_free(arg11);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_output_hdf5__SWIG_4 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-output-hdf5"
  meep::fields *arg1 = (meep::fields *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  meep::component *arg4 = (meep::component *) 0 ;
  meep::field_function arg5 = (meep::field_function) 0 ;
  void *arg6 = (void *) 0 ;
  meep::volume *arg7 = 0 ;
  meep::h5file *arg8 = (meep::h5file *) 0 ;
  bool arg9 ;
  bool arg10 ;
  char *arg11 = (char *) 0 ;
  int must_free2 = 0 ;
  my_field_func_data data3 ;
  int must_free11 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(argv[1]);
    must_free2 = 1;
  }
  {
    arg3 = list_length(SCM_CAR(argv[2]));
    arg4 = new meep::component[arg3];
    for (int i = 0; i < arg3; ++i)
    arg4[i] = meep::component(integer_list_ref(SCM_CAR(argv[2]), i));
    data3.nf = arg3;
    data3.func = SCM_CDR(argv[2]);
    arg5 = my_field_func;
    arg6 = &data3;
  }
  {
    arg7 = (meep::volume *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__volume, 7, 0);
  }
  {
    arg8 = (meep::h5file *)SWIG_MustGetPtr(argv[4], SWIGTYPE_p_meep__h5file, 8, 0);
  }
  {
    arg9 = (bool) SCM_NFALSEP(argv[5]);
  }
  {
    arg10 = (bool) SCM_NFALSEP(argv[6]);
  }
  {
    arg11 = (char *)SWIG_scm2str(argv[7]);
    must_free11 = 1;
  }
  (arg1)->output_hdf5((char const *)arg2,arg3,(meep::component const *)arg4,arg5,arg6,(meep::volume const &)*arg7,arg8,arg9,arg10,(char const *)arg11);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  {
    if (arg4) delete[] arg4;
  }
  
  
  if (must_free11 && arg11) SWIG_free(arg11);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_output_hdf5__SWIG_5 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-output-hdf5"
  meep::fields *arg1 = (meep::fields *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  meep::component *arg4 = (meep::component *) 0 ;
  meep::field_function arg5 = (meep::field_function) 0 ;
  void *arg6 = (void *) 0 ;
  meep::volume *arg7 = 0 ;
  meep::h5file *arg8 = (meep::h5file *) 0 ;
  bool arg9 ;
  bool arg10 ;
  int must_free2 = 0 ;
  my_field_func_data data3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(argv[1]);
    must_free2 = 1;
  }
  {
    arg3 = list_length(SCM_CAR(argv[2]));
    arg4 = new meep::component[arg3];
    for (int i = 0; i < arg3; ++i)
    arg4[i] = meep::component(integer_list_ref(SCM_CAR(argv[2]), i));
    data3.nf = arg3;
    data3.func = SCM_CDR(argv[2]);
    arg5 = my_field_func;
    arg6 = &data3;
  }
  {
    arg7 = (meep::volume *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__volume, 7, 0);
  }
  {
    arg8 = (meep::h5file *)SWIG_MustGetPtr(argv[4], SWIGTYPE_p_meep__h5file, 8, 0);
  }
  {
    arg9 = (bool) SCM_NFALSEP(argv[5]);
  }
  {
    arg10 = (bool) SCM_NFALSEP(argv[6]);
  }
  (arg1)->output_hdf5((char const *)arg2,arg3,(meep::component const *)arg4,arg5,arg6,(meep::volume const &)*arg7,arg8,arg9,arg10);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  {
    if (arg4) delete[] arg4;
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_output_hdf5__SWIG_6 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-output-hdf5"
  meep::fields *arg1 = (meep::fields *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  meep::component *arg4 = (meep::component *) 0 ;
  meep::field_function arg5 = (meep::field_function) 0 ;
  void *arg6 = (void *) 0 ;
  meep::volume *arg7 = 0 ;
  meep::h5file *arg8 = (meep::h5file *) 0 ;
  bool arg9 ;
  int must_free2 = 0 ;
  my_field_func_data data3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(argv[1]);
    must_free2 = 1;
  }
  {
    arg3 = list_length(SCM_CAR(argv[2]));
    arg4 = new meep::component[arg3];
    for (int i = 0; i < arg3; ++i)
    arg4[i] = meep::component(integer_list_ref(SCM_CAR(argv[2]), i));
    data3.nf = arg3;
    data3.func = SCM_CDR(argv[2]);
    arg5 = my_field_func;
    arg6 = &data3;
  }
  {
    arg7 = (meep::volume *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__volume, 7, 0);
  }
  {
    arg8 = (meep::h5file *)SWIG_MustGetPtr(argv[4], SWIGTYPE_p_meep__h5file, 8, 0);
  }
  {
    arg9 = (bool) SCM_NFALSEP(argv[5]);
  }
  (arg1)->output_hdf5((char const *)arg2,arg3,(meep::component const *)arg4,arg5,arg6,(meep::volume const &)*arg7,arg8,arg9);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  {
    if (arg4) delete[] arg4;
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_output_hdf5__SWIG_7 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-output-hdf5"
  meep::fields *arg1 = (meep::fields *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  meep::component *arg4 = (meep::component *) 0 ;
  meep::field_function arg5 = (meep::field_function) 0 ;
  void *arg6 = (void *) 0 ;
  meep::volume *arg7 = 0 ;
  meep::h5file *arg8 = (meep::h5file *) 0 ;
  int must_free2 = 0 ;
  my_field_func_data data3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(argv[1]);
    must_free2 = 1;
  }
  {
    arg3 = list_length(SCM_CAR(argv[2]));
    arg4 = new meep::component[arg3];
    for (int i = 0; i < arg3; ++i)
    arg4[i] = meep::component(integer_list_ref(SCM_CAR(argv[2]), i));
    data3.nf = arg3;
    data3.func = SCM_CDR(argv[2]);
    arg5 = my_field_func;
    arg6 = &data3;
  }
  {
    arg7 = (meep::volume *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__volume, 7, 0);
  }
  {
    arg8 = (meep::h5file *)SWIG_MustGetPtr(argv[4], SWIGTYPE_p_meep__h5file, 8, 0);
  }
  (arg1)->output_hdf5((char const *)arg2,arg3,(meep::component const *)arg4,arg5,arg6,(meep::volume const &)*arg7,arg8);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  {
    if (arg4) delete[] arg4;
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_output_hdf5__SWIG_8 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-output-hdf5"
  meep::fields *arg1 = (meep::fields *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  meep::component *arg4 = (meep::component *) 0 ;
  meep::field_function arg5 = (meep::field_function) 0 ;
  void *arg6 = (void *) 0 ;
  meep::volume *arg7 = 0 ;
  int must_free2 = 0 ;
  my_field_func_data data3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(argv[1]);
    must_free2 = 1;
  }
  {
    arg3 = list_length(SCM_CAR(argv[2]));
    arg4 = new meep::component[arg3];
    for (int i = 0; i < arg3; ++i)
    arg4[i] = meep::component(integer_list_ref(SCM_CAR(argv[2]), i));
    data3.nf = arg3;
    data3.func = SCM_CDR(argv[2]);
    arg5 = my_field_func;
    arg6 = &data3;
  }
  {
    arg7 = (meep::volume *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__volume, 7, 0);
  }
  (arg1)->output_hdf5((char const *)arg2,arg3,(meep::component const *)arg4,arg5,arg6,(meep::volume const &)*arg7);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  {
    if (arg4) delete[] arg4;
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_output_hdf5__SWIG_9 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-output-hdf5"
  meep::fields *arg1 = (meep::fields *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  meep::component *arg4 = (meep::component *) 0 ;
  meep::field_rfunction arg5 = (meep::field_rfunction) 0 ;
  void *arg6 = (void *) 0 ;
  meep::volume *arg7 = 0 ;
  meep::h5file *arg8 = (meep::h5file *) 0 ;
  bool arg9 ;
  bool arg10 ;
  char *arg11 = (char *) 0 ;
  int must_free2 = 0 ;
  int must_free11 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(argv[1]);
    must_free2 = 1;
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  {
    arg4 = (meep::component *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__component, 4, 0);
  }
  {
    arg5 = (meep::field_rfunction)SWIG_MustGetPtr(argv[4], SWIGTYPE_p_f_p_q_const__complex__double___r_q_const__meep__vec_p_void__double, 5, 0);
  }
  {
    arg6 = (void *)SWIG_MustGetPtr(argv[5], NULL, 6, 0);
  }
  {
    arg7 = (meep::volume *)SWIG_MustGetPtr(argv[6], SWIGTYPE_p_meep__volume, 7, 0);
  }
  {
    arg8 = (meep::h5file *)SWIG_MustGetPtr(argv[7], SWIGTYPE_p_meep__h5file, 8, 0);
  }
  {
    arg9 = (bool) SCM_NFALSEP(argv[8]);
  }
  {
    arg10 = (bool) SCM_NFALSEP(argv[9]);
  }
  {
    arg11 = (char *)SWIG_scm2str(argv[10]);
    must_free11 = 1;
  }
  (arg1)->output_hdf5((char const *)arg2,arg3,(meep::component const *)arg4,arg5,arg6,(meep::volume const &)*arg7,arg8,arg9,arg10,(char const *)arg11);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  
  
  
  
  if (must_free11 && arg11) SWIG_free(arg11);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_output_hdf5__SWIG_10 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-output-hdf5"
  meep::fields *arg1 = (meep::fields *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  meep::component *arg4 = (meep::component *) 0 ;
  meep::field_rfunction arg5 = (meep::field_rfunction) 0 ;
  void *arg6 = (void *) 0 ;
  meep::volume *arg7 = 0 ;
  meep::h5file *arg8 = (meep::h5file *) 0 ;
  bool arg9 ;
  bool arg10 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(argv[1]);
    must_free2 = 1;
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  {
    arg4 = (meep::component *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__component, 4, 0);
  }
  {
    arg5 = (meep::field_rfunction)SWIG_MustGetPtr(argv[4], SWIGTYPE_p_f_p_q_const__complex__double___r_q_const__meep__vec_p_void__double, 5, 0);
  }
  {
    arg6 = (void *)SWIG_MustGetPtr(argv[5], NULL, 6, 0);
  }
  {
    arg7 = (meep::volume *)SWIG_MustGetPtr(argv[6], SWIGTYPE_p_meep__volume, 7, 0);
  }
  {
    arg8 = (meep::h5file *)SWIG_MustGetPtr(argv[7], SWIGTYPE_p_meep__h5file, 8, 0);
  }
  {
    arg9 = (bool) SCM_NFALSEP(argv[8]);
  }
  {
    arg10 = (bool) SCM_NFALSEP(argv[9]);
  }
  (arg1)->output_hdf5((char const *)arg2,arg3,(meep::component const *)arg4,arg5,arg6,(meep::volume const &)*arg7,arg8,arg9,arg10);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_output_hdf5__SWIG_11 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-output-hdf5"
  meep::fields *arg1 = (meep::fields *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  meep::component *arg4 = (meep::component *) 0 ;
  meep::field_rfunction arg5 = (meep::field_rfunction) 0 ;
  void *arg6 = (void *) 0 ;
  meep::volume *arg7 = 0 ;
  meep::h5file *arg8 = (meep::h5file *) 0 ;
  bool arg9 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(argv[1]);
    must_free2 = 1;
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  {
    arg4 = (meep::component *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__component, 4, 0);
  }
  {
    arg5 = (meep::field_rfunction)SWIG_MustGetPtr(argv[4], SWIGTYPE_p_f_p_q_const__complex__double___r_q_const__meep__vec_p_void__double, 5, 0);
  }
  {
    arg6 = (void *)SWIG_MustGetPtr(argv[5], NULL, 6, 0);
  }
  {
    arg7 = (meep::volume *)SWIG_MustGetPtr(argv[6], SWIGTYPE_p_meep__volume, 7, 0);
  }
  {
    arg8 = (meep::h5file *)SWIG_MustGetPtr(argv[7], SWIGTYPE_p_meep__h5file, 8, 0);
  }
  {
    arg9 = (bool) SCM_NFALSEP(argv[8]);
  }
  (arg1)->output_hdf5((char const *)arg2,arg3,(meep::component const *)arg4,arg5,arg6,(meep::volume const &)*arg7,arg8,arg9);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_output_hdf5__SWIG_12 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-output-hdf5"
  meep::fields *arg1 = (meep::fields *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  meep::component *arg4 = (meep::component *) 0 ;
  meep::field_rfunction arg5 = (meep::field_rfunction) 0 ;
  void *arg6 = (void *) 0 ;
  meep::volume *arg7 = 0 ;
  meep::h5file *arg8 = (meep::h5file *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(argv[1]);
    must_free2 = 1;
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  {
    arg4 = (meep::component *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__component, 4, 0);
  }
  {
    arg5 = (meep::field_rfunction)SWIG_MustGetPtr(argv[4], SWIGTYPE_p_f_p_q_const__complex__double___r_q_const__meep__vec_p_void__double, 5, 0);
  }
  {
    arg6 = (void *)SWIG_MustGetPtr(argv[5], NULL, 6, 0);
  }
  {
    arg7 = (meep::volume *)SWIG_MustGetPtr(argv[6], SWIGTYPE_p_meep__volume, 7, 0);
  }
  {
    arg8 = (meep::h5file *)SWIG_MustGetPtr(argv[7], SWIGTYPE_p_meep__h5file, 8, 0);
  }
  (arg1)->output_hdf5((char const *)arg2,arg3,(meep::component const *)arg4,arg5,arg6,(meep::volume const &)*arg7,arg8);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_output_hdf5__SWIG_13 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-output-hdf5"
  meep::fields *arg1 = (meep::fields *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  meep::component *arg4 = (meep::component *) 0 ;
  meep::field_rfunction arg5 = (meep::field_rfunction) 0 ;
  void *arg6 = (void *) 0 ;
  meep::volume *arg7 = 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(argv[1]);
    must_free2 = 1;
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  {
    arg4 = (meep::component *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__component, 4, 0);
  }
  {
    arg5 = (meep::field_rfunction)SWIG_MustGetPtr(argv[4], SWIGTYPE_p_f_p_q_const__complex__double___r_q_const__meep__vec_p_void__double, 5, 0);
  }
  {
    arg6 = (void *)SWIG_MustGetPtr(argv[5], NULL, 6, 0);
  }
  {
    arg7 = (meep::volume *)SWIG_MustGetPtr(argv[6], SWIGTYPE_p_meep__volume, 7, 0);
  }
  (arg1)->output_hdf5((char const *)arg2,arg3,(meep::component const *)arg4,arg5,arg6,(meep::volume const &)*arg7);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_output_hdf5__SWIG_14 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-output-hdf5"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::component arg2 ;
  meep::volume *arg3 = 0 ;
  meep::h5file *arg4 = (meep::h5file *) 0 ;
  bool arg5 ;
  bool arg6 ;
  char *arg7 = (char *) 0 ;
  int must_free7 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::volume *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__volume, 3, 0);
  }
  {
    arg4 = (meep::h5file *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__h5file, 4, 0);
  }
  {
    arg5 = (bool) SCM_NFALSEP(argv[4]);
  }
  {
    arg6 = (bool) SCM_NFALSEP(argv[5]);
  }
  {
    arg7 = (char *)SWIG_scm2str(argv[6]);
    must_free7 = 1;
  }
  (arg1)->output_hdf5(arg2,(meep::volume const &)*arg3,arg4,arg5,arg6,(char const *)arg7);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  if (must_free7 && arg7) SWIG_free(arg7);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_output_hdf5__SWIG_15 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-output-hdf5"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::component arg2 ;
  meep::volume *arg3 = 0 ;
  meep::h5file *arg4 = (meep::h5file *) 0 ;
  bool arg5 ;
  bool arg6 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::volume *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__volume, 3, 0);
  }
  {
    arg4 = (meep::h5file *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__h5file, 4, 0);
  }
  {
    arg5 = (bool) SCM_NFALSEP(argv[4]);
  }
  {
    arg6 = (bool) SCM_NFALSEP(argv[5]);
  }
  (arg1)->output_hdf5(arg2,(meep::volume const &)*arg3,arg4,arg5,arg6);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_output_hdf5__SWIG_16 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-output-hdf5"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::component arg2 ;
  meep::volume *arg3 = 0 ;
  meep::h5file *arg4 = (meep::h5file *) 0 ;
  bool arg5 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::volume *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__volume, 3, 0);
  }
  {
    arg4 = (meep::h5file *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__h5file, 4, 0);
  }
  {
    arg5 = (bool) SCM_NFALSEP(argv[4]);
  }
  (arg1)->output_hdf5(arg2,(meep::volume const &)*arg3,arg4,arg5);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_output_hdf5__SWIG_17 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-output-hdf5"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::component arg2 ;
  meep::volume *arg3 = 0 ;
  meep::h5file *arg4 = (meep::h5file *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::volume *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__volume, 3, 0);
  }
  {
    arg4 = (meep::h5file *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__h5file, 4, 0);
  }
  (arg1)->output_hdf5(arg2,(meep::volume const &)*arg3,arg4);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_output_hdf5__SWIG_18 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-output-hdf5"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::component arg2 ;
  meep::volume *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::volume *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__volume, 3, 0);
  }
  (arg1)->output_hdf5(arg2,(meep::volume const &)*arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_output_hdf5__SWIG_19 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-output-hdf5"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::derived_component arg2 ;
  meep::volume *arg3 = 0 ;
  meep::h5file *arg4 = (meep::h5file *) 0 ;
  bool arg5 ;
  bool arg6 ;
  char *arg7 = (char *) 0 ;
  int must_free7 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::derived_component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::volume *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__volume, 3, 0);
  }
  {
    arg4 = (meep::h5file *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__h5file, 4, 0);
  }
  {
    arg5 = (bool) SCM_NFALSEP(argv[4]);
  }
  {
    arg6 = (bool) SCM_NFALSEP(argv[5]);
  }
  {
    arg7 = (char *)SWIG_scm2str(argv[6]);
    must_free7 = 1;
  }
  (arg1)->output_hdf5(arg2,(meep::volume const &)*arg3,arg4,arg5,arg6,(char const *)arg7);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  if (must_free7 && arg7) SWIG_free(arg7);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_output_hdf5__SWIG_20 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-output-hdf5"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::derived_component arg2 ;
  meep::volume *arg3 = 0 ;
  meep::h5file *arg4 = (meep::h5file *) 0 ;
  bool arg5 ;
  bool arg6 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::derived_component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::volume *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__volume, 3, 0);
  }
  {
    arg4 = (meep::h5file *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__h5file, 4, 0);
  }
  {
    arg5 = (bool) SCM_NFALSEP(argv[4]);
  }
  {
    arg6 = (bool) SCM_NFALSEP(argv[5]);
  }
  (arg1)->output_hdf5(arg2,(meep::volume const &)*arg3,arg4,arg5,arg6);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_output_hdf5__SWIG_21 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-output-hdf5"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::derived_component arg2 ;
  meep::volume *arg3 = 0 ;
  meep::h5file *arg4 = (meep::h5file *) 0 ;
  bool arg5 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::derived_component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::volume *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__volume, 3, 0);
  }
  {
    arg4 = (meep::h5file *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__h5file, 4, 0);
  }
  {
    arg5 = (bool) SCM_NFALSEP(argv[4]);
  }
  (arg1)->output_hdf5(arg2,(meep::volume const &)*arg3,arg4,arg5);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_output_hdf5__SWIG_22 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-output-hdf5"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::derived_component arg2 ;
  meep::volume *arg3 = 0 ;
  meep::h5file *arg4 = (meep::h5file *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::derived_component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::volume *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__volume, 3, 0);
  }
  {
    arg4 = (meep::h5file *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__h5file, 4, 0);
  }
  (arg1)->output_hdf5(arg2,(meep::volume const &)*arg3,arg4);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_output_hdf5__SWIG_23 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-output-hdf5"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::derived_component arg2 ;
  meep::volume *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::derived_component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::volume *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__volume, 3, 0);
  }
  (arg1)->output_hdf5(arg2,(meep::volume const &)*arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_output_hdf5(SCM rest)
{
#define FUNC_NAME "meep-fields-output-hdf5"
  SCM argv[11];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 11, "meep-fields-output-hdf5");
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__volume, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_meep_fields_output_hdf5__SWIG_18(argc,argv);
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__volume, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_meep_fields_output_hdf5__SWIG_23(argc,argv);
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__volume, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__h5file, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            return _wrap_meep_fields_output_hdf5__SWIG_22(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__volume, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__h5file, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            return _wrap_meep_fields_output_hdf5__SWIG_17(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_STRINGP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_pair_p(argv[2])) &&
          SCM_NFALSEP(scm_list_p(SCM_CAR(argv[2]))) &&
          SCM_NFALSEP(scm_procedure_p(SCM_CDR(argv[2]))); 
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__volume, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            return _wrap_meep_fields_output_hdf5__SWIG_8(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__volume, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__h5file, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              _v = SCM_BOOLP(argv[4]) ? 1 : 0;
            }
            if (_v) {
              return _wrap_meep_fields_output_hdf5__SWIG_21(argc,argv);
            }
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__volume, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__h5file, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              _v = SCM_BOOLP(argv[4]) ? 1 : 0;
            }
            if (_v) {
              return _wrap_meep_fields_output_hdf5__SWIG_16(argc,argv);
            }
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_STRINGP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_pair_p(argv[2])) &&
          SCM_NFALSEP(scm_list_p(SCM_CAR(argv[2]))) &&
          SCM_NFALSEP(scm_procedure_p(SCM_CDR(argv[2]))); 
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__volume, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              void *ptr;
              int res = SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_meep__h5file, 0);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              return _wrap_meep_fields_output_hdf5__SWIG_7(argc,argv);
            }
          }
        }
      }
    }
  }
  if (argc == 6) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__h5file, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_STRINGP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_pair_p(argv[3])) &&
            SCM_NFALSEP(scm_list_p(SCM_CAR(argv[3]))) &&
            SCM_NFALSEP(scm_procedure_p(SCM_CDR(argv[3]))); 
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_integer_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              {
                void *ptr;
                int res = SWIG_ConvertPtr(argv[5], &ptr, SWIGTYPE_p_meep__volume, 0);
                _v = SWIG_CheckState(res);
              }
              if (_v) {
                return _wrap_meep_fields_output_hdf5__SWIG_2(argc,argv);
              }
            }
          }
        }
      }
    }
  }
  if (argc == 6) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__volume, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__h5file, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              _v = SCM_BOOLP(argv[4]) ? 1 : 0;
            }
            if (_v) {
              {
                _v = SCM_BOOLP(argv[5]) ? 1 : 0;
              }
              if (_v) {
                return _wrap_meep_fields_output_hdf5__SWIG_20(argc,argv);
              }
            }
          }
        }
      }
    }
  }
  if (argc == 6) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__volume, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__h5file, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              _v = SCM_BOOLP(argv[4]) ? 1 : 0;
            }
            if (_v) {
              {
                _v = SCM_BOOLP(argv[5]) ? 1 : 0;
              }
              if (_v) {
                return _wrap_meep_fields_output_hdf5__SWIG_15(argc,argv);
              }
            }
          }
        }
      }
    }
  }
  if (argc == 6) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_STRINGP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_pair_p(argv[2])) &&
          SCM_NFALSEP(scm_list_p(SCM_CAR(argv[2]))) &&
          SCM_NFALSEP(scm_procedure_p(SCM_CDR(argv[2]))); 
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__volume, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              void *ptr;
              int res = SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_meep__h5file, 0);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              {
                _v = SCM_BOOLP(argv[5]) ? 1 : 0;
              }
              if (_v) {
                return _wrap_meep_fields_output_hdf5__SWIG_6(argc,argv);
              }
            }
          }
        }
      }
    }
  }
  if (argc == 7) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__h5file, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_STRINGP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_pair_p(argv[3])) &&
            SCM_NFALSEP(scm_list_p(SCM_CAR(argv[3]))) &&
            SCM_NFALSEP(scm_procedure_p(SCM_CDR(argv[3]))); 
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_integer_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              {
                void *ptr;
                int res = SWIG_ConvertPtr(argv[5], &ptr, SWIGTYPE_p_meep__volume, 0);
                _v = SWIG_CheckState(res);
              }
              if (_v) {
                {
                  _v = SCM_BOOLP(argv[6]) ? 1 : 0;
                }
                if (_v) {
                  return _wrap_meep_fields_output_hdf5__SWIG_1(argc,argv);
                }
              }
            }
          }
        }
      }
    }
  }
  if (argc == 7) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__volume, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__h5file, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              _v = SCM_BOOLP(argv[4]) ? 1 : 0;
            }
            if (_v) {
              {
                _v = SCM_BOOLP(argv[5]) ? 1 : 0;
              }
              if (_v) {
                {
                  _v = SCM_STRINGP(argv[6]) ? 1 : 0;
                }
                if (_v) {
                  return _wrap_meep_fields_output_hdf5__SWIG_19(argc,argv);
                }
              }
            }
          }
        }
      }
    }
  }
  if (argc == 7) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__volume, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__h5file, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              _v = SCM_BOOLP(argv[4]) ? 1 : 0;
            }
            if (_v) {
              {
                _v = SCM_BOOLP(argv[5]) ? 1 : 0;
              }
              if (_v) {
                {
                  _v = SCM_STRINGP(argv[6]) ? 1 : 0;
                }
                if (_v) {
                  return _wrap_meep_fields_output_hdf5__SWIG_14(argc,argv);
                }
              }
            }
          }
        }
      }
    }
  }
  if (argc == 7) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_STRINGP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_pair_p(argv[2])) &&
          SCM_NFALSEP(scm_list_p(SCM_CAR(argv[2]))) &&
          SCM_NFALSEP(scm_procedure_p(SCM_CDR(argv[2]))); 
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__volume, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              void *ptr;
              int res = SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_meep__h5file, 0);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              {
                _v = SCM_BOOLP(argv[5]) ? 1 : 0;
              }
              if (_v) {
                {
                  _v = SCM_BOOLP(argv[6]) ? 1 : 0;
                }
                if (_v) {
                  return _wrap_meep_fields_output_hdf5__SWIG_5(argc,argv);
                }
              }
            }
          }
        }
      }
    }
  }
  if (argc == 7) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_STRINGP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__component, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              void *ptr;
              int res = SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_f_p_q_const__complex__double___r_q_const__meep__vec_p_void__double, 0);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              {
                void *ptr;
                int res = SWIG_ConvertPtr(argv[5], &ptr, 0, 0);
                _v = SWIG_CheckState(res);
              }
              if (_v) {
                {
                  void *ptr;
                  int res = SWIG_ConvertPtr(argv[6], &ptr, SWIGTYPE_p_meep__volume, 0);
                  _v = SWIG_CheckState(res);
                }
                if (_v) {
                  return _wrap_meep_fields_output_hdf5__SWIG_13(argc,argv);
                }
              }
            }
          }
        }
      }
    }
  }
  if (argc == 8) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__h5file, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_STRINGP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_pair_p(argv[3])) &&
            SCM_NFALSEP(scm_list_p(SCM_CAR(argv[3]))) &&
            SCM_NFALSEP(scm_procedure_p(SCM_CDR(argv[3]))); 
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_integer_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              {
                void *ptr;
                int res = SWIG_ConvertPtr(argv[5], &ptr, SWIGTYPE_p_meep__volume, 0);
                _v = SWIG_CheckState(res);
              }
              if (_v) {
                {
                  _v = SCM_BOOLP(argv[6]) ? 1 : 0;
                }
                if (_v) {
                  {
                    _v = SCM_BOOLP(argv[7]) ? 1 : 0;
                  }
                  if (_v) {
                    return _wrap_meep_fields_output_hdf5__SWIG_0(argc,argv);
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  if (argc == 8) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_STRINGP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_pair_p(argv[2])) &&
          SCM_NFALSEP(scm_list_p(SCM_CAR(argv[2]))) &&
          SCM_NFALSEP(scm_procedure_p(SCM_CDR(argv[2]))); 
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__volume, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              void *ptr;
              int res = SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_meep__h5file, 0);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              {
                _v = SCM_BOOLP(argv[5]) ? 1 : 0;
              }
              if (_v) {
                {
                  _v = SCM_BOOLP(argv[6]) ? 1 : 0;
                }
                if (_v) {
                  {
                    _v = SCM_STRINGP(argv[7]) ? 1 : 0;
                  }
                  if (_v) {
                    return _wrap_meep_fields_output_hdf5__SWIG_4(argc,argv);
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  if (argc == 8) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_STRINGP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__component, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              void *ptr;
              int res = SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_f_p_q_const__complex__double___r_q_const__meep__vec_p_void__double, 0);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              {
                void *ptr;
                int res = SWIG_ConvertPtr(argv[5], &ptr, 0, 0);
                _v = SWIG_CheckState(res);
              }
              if (_v) {
                {
                  void *ptr;
                  int res = SWIG_ConvertPtr(argv[6], &ptr, SWIGTYPE_p_meep__volume, 0);
                  _v = SWIG_CheckState(res);
                }
                if (_v) {
                  {
                    void *ptr;
                    int res = SWIG_ConvertPtr(argv[7], &ptr, SWIGTYPE_p_meep__h5file, 0);
                    _v = SWIG_CheckState(res);
                  }
                  if (_v) {
                    return _wrap_meep_fields_output_hdf5__SWIG_12(argc,argv);
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  if (argc == 9) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_STRINGP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_pair_p(argv[2])) &&
          SCM_NFALSEP(scm_list_p(SCM_CAR(argv[2]))) &&
          SCM_NFALSEP(scm_procedure_p(SCM_CDR(argv[2]))); 
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__volume, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              void *ptr;
              int res = SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_meep__h5file, 0);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              {
                _v = SCM_BOOLP(argv[5]) ? 1 : 0;
              }
              if (_v) {
                {
                  _v = SCM_BOOLP(argv[6]) ? 1 : 0;
                }
                if (_v) {
                  {
                    _v = SCM_STRINGP(argv[7]) ? 1 : 0;
                  }
                  if (_v) {
                    {
                      _v = SCM_BOOLP(argv[8]) ? 1 : 0;
                    }
                    if (_v) {
                      return _wrap_meep_fields_output_hdf5__SWIG_3(argc,argv);
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  if (argc == 9) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_STRINGP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__component, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              void *ptr;
              int res = SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_f_p_q_const__complex__double___r_q_const__meep__vec_p_void__double, 0);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              {
                void *ptr;
                int res = SWIG_ConvertPtr(argv[5], &ptr, 0, 0);
                _v = SWIG_CheckState(res);
              }
              if (_v) {
                {
                  void *ptr;
                  int res = SWIG_ConvertPtr(argv[6], &ptr, SWIGTYPE_p_meep__volume, 0);
                  _v = SWIG_CheckState(res);
                }
                if (_v) {
                  {
                    void *ptr;
                    int res = SWIG_ConvertPtr(argv[7], &ptr, SWIGTYPE_p_meep__h5file, 0);
                    _v = SWIG_CheckState(res);
                  }
                  if (_v) {
                    {
                      _v = SCM_BOOLP(argv[8]) ? 1 : 0;
                    }
                    if (_v) {
                      return _wrap_meep_fields_output_hdf5__SWIG_11(argc,argv);
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  if (argc == 10) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_STRINGP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__component, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              void *ptr;
              int res = SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_f_p_q_const__complex__double___r_q_const__meep__vec_p_void__double, 0);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              {
                void *ptr;
                int res = SWIG_ConvertPtr(argv[5], &ptr, 0, 0);
                _v = SWIG_CheckState(res);
              }
              if (_v) {
                {
                  void *ptr;
                  int res = SWIG_ConvertPtr(argv[6], &ptr, SWIGTYPE_p_meep__volume, 0);
                  _v = SWIG_CheckState(res);
                }
                if (_v) {
                  {
                    void *ptr;
                    int res = SWIG_ConvertPtr(argv[7], &ptr, SWIGTYPE_p_meep__h5file, 0);
                    _v = SWIG_CheckState(res);
                  }
                  if (_v) {
                    {
                      _v = SCM_BOOLP(argv[8]) ? 1 : 0;
                    }
                    if (_v) {
                      {
                        _v = SCM_BOOLP(argv[9]) ? 1 : 0;
                      }
                      if (_v) {
                        return _wrap_meep_fields_output_hdf5__SWIG_10(argc,argv);
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  if (argc == 11) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_STRINGP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__component, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              void *ptr;
              int res = SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_f_p_q_const__complex__double___r_q_const__meep__vec_p_void__double, 0);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              {
                void *ptr;
                int res = SWIG_ConvertPtr(argv[5], &ptr, 0, 0);
                _v = SWIG_CheckState(res);
              }
              if (_v) {
                {
                  void *ptr;
                  int res = SWIG_ConvertPtr(argv[6], &ptr, SWIGTYPE_p_meep__volume, 0);
                  _v = SWIG_CheckState(res);
                }
                if (_v) {
                  {
                    void *ptr;
                    int res = SWIG_ConvertPtr(argv[7], &ptr, SWIGTYPE_p_meep__h5file, 0);
                    _v = SWIG_CheckState(res);
                  }
                  if (_v) {
                    {
                      _v = SCM_BOOLP(argv[8]) ? 1 : 0;
                    }
                    if (_v) {
                      {
                        _v = SCM_BOOLP(argv[9]) ? 1 : 0;
                      }
                      if (_v) {
                        {
                          _v = SCM_STRINGP(argv[10]) ? 1 : 0;
                        }
                        if (_v) {
                          return _wrap_meep_fields_output_hdf5__SWIG_9(argc,argv);
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-fields-output-hdf5", "No matching method for generic function `meep_fields_output_hdf5'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_open_h5file__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-open-h5file"
  meep::fields *arg1 = (meep::fields *) 0 ;
  char *arg2 = (char *) 0 ;
  meep::h5file::access_mode arg3 ;
  char *arg4 = (char *) 0 ;
  bool arg5 ;
  int must_free2 = 0 ;
  int must_free4 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::h5file *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(argv[1]);
    must_free2 = 1;
  }
  {
    arg3 = (meep::h5file::access_mode) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg4 = (char *)SWIG_scm2str(argv[3]);
    must_free4 = 1;
  }
  {
    arg5 = (bool) SCM_NFALSEP(argv[4]);
  }
  result = (meep::h5file *)(arg1)->open_h5file((char const *)arg2,arg3,(char const *)arg4,arg5);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__h5file, 1);
  }
  
  if (must_free2 && arg2) SWIG_free(arg2);
  if (must_free4 && arg4) SWIG_free(arg4);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_open_h5file__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-open-h5file"
  meep::fields *arg1 = (meep::fields *) 0 ;
  char *arg2 = (char *) 0 ;
  meep::h5file::access_mode arg3 ;
  char *arg4 = (char *) 0 ;
  int must_free2 = 0 ;
  int must_free4 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::h5file *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(argv[1]);
    must_free2 = 1;
  }
  {
    arg3 = (meep::h5file::access_mode) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg4 = (char *)SWIG_scm2str(argv[3]);
    must_free4 = 1;
  }
  result = (meep::h5file *)(arg1)->open_h5file((char const *)arg2,arg3,(char const *)arg4);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__h5file, 1);
  }
  
  if (must_free2 && arg2) SWIG_free(arg2);
  if (must_free4 && arg4) SWIG_free(arg4);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_open_h5file__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-open-h5file"
  meep::fields *arg1 = (meep::fields *) 0 ;
  char *arg2 = (char *) 0 ;
  meep::h5file::access_mode arg3 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::h5file *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(argv[1]);
    must_free2 = 1;
  }
  {
    arg3 = (meep::h5file::access_mode) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME); 
  }
  result = (meep::h5file *)(arg1)->open_h5file((char const *)arg2,arg3);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__h5file, 1);
  }
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_open_h5file__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-open-h5file"
  meep::fields *arg1 = (meep::fields *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::h5file *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(argv[1]);
    must_free2 = 1;
  }
  result = (meep::h5file *)(arg1)->open_h5file((char const *)arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__h5file, 1);
  }
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_open_h5file(SCM rest)
{
#define FUNC_NAME "meep-fields-open-h5file"
  SCM argv[5];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 5, "meep-fields-open-h5file");
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_STRINGP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        return _wrap_meep_fields_open_h5file__SWIG_3(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_STRINGP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_fields_open_h5file__SWIG_2(argc,argv);
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_STRINGP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_STRINGP(argv[3]) ? 1 : 0;
          }
          if (_v) {
            return _wrap_meep_fields_open_h5file__SWIG_1(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_STRINGP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_STRINGP(argv[3]) ? 1 : 0;
          }
          if (_v) {
            {
              _v = SCM_BOOLP(argv[4]) ? 1 : 0;
            }
            if (_v) {
              return _wrap_meep_fields_open_h5file__SWIG_0(argc,argv);
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-fields-open-h5file", "No matching method for generic function `meep_fields_open_h5file'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_h5file_name__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-h5file-name"
  meep::fields *arg1 = (meep::fields *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  bool arg4 ;
  int must_free2 = 0 ;
  int must_free3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  char *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(argv[1]);
    must_free2 = 1;
  }
  {
    arg3 = (char *)SWIG_scm2str(argv[2]);
    must_free3 = 1;
  }
  {
    arg4 = (bool) SCM_NFALSEP(argv[3]);
  }
  result = (char *)(arg1)->h5file_name((char const *)arg2,(char const *)arg3,arg4);
  {
    gswig_result = scm_makfrom0str((const char *)result);
  }
  
  if (must_free2 && arg2) SWIG_free(arg2);
  if (must_free3 && arg3) SWIG_free(arg3);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_h5file_name__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-h5file-name"
  meep::fields *arg1 = (meep::fields *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  int must_free2 = 0 ;
  int must_free3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  char *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(argv[1]);
    must_free2 = 1;
  }
  {
    arg3 = (char *)SWIG_scm2str(argv[2]);
    must_free3 = 1;
  }
  result = (char *)(arg1)->h5file_name((char const *)arg2,(char const *)arg3);
  {
    gswig_result = scm_makfrom0str((const char *)result);
  }
  
  if (must_free2 && arg2) SWIG_free(arg2);
  if (must_free3 && arg3) SWIG_free(arg3);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_h5file_name__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-h5file-name"
  meep::fields *arg1 = (meep::fields *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  char *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(argv[1]);
    must_free2 = 1;
  }
  result = (char *)(arg1)->h5file_name((char const *)arg2);
  {
    gswig_result = scm_makfrom0str((const char *)result);
  }
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_h5file_name(SCM rest)
{
#define FUNC_NAME "meep-fields-h5file-name"
  SCM argv[4];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 4, "meep-fields-h5file-name");
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_STRINGP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        return _wrap_meep_fields_h5file_name__SWIG_2(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_STRINGP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_STRINGP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_fields_h5file_name__SWIG_1(argc,argv);
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_STRINGP(argv[1]) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_STRINGP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_BOOLP(argv[3]) ? 1 : 0;
          }
          if (_v) {
            return _wrap_meep_fields_h5file_name__SWIG_0(argc,argv);
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-fields-h5file-name", "No matching method for generic function `meep_fields_h5file_name'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_last_step_output_wall_time_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-last-step-output-wall-time-set"
  meep::fields *arg1 = (meep::fields *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(s_1, FUNC_NAME);
  }
  if (arg1) (arg1)->last_step_output_wall_time = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_last_step_output_wall_time_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-last-step-output-wall-time-get"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (double) ((arg1)->last_step_output_wall_time);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_last_step_output_t_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-last-step-output-t-set"
  meep::fields *arg1 = (meep::fields *) 0 ;
  int arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(s_1, SCM_ARG1, FUNC_NAME);
  }
  if (arg1) (arg1)->last_step_output_t = arg2;
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_last_step_output_t_get (SCM s_0)
{
#define FUNC_NAME "meep-fields-last-step-output-t-get"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (int) ((arg1)->last_step_output_t);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_step (SCM s_0)
{
#define FUNC_NAME "meep-fields-step"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  (arg1)->step();
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_round_time (SCM s_0)
{
#define FUNC_NAME "meep-fields-round-time"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (double)((meep::fields const *)arg1)->round_time();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_time (SCM s_0)
{
#define FUNC_NAME "meep-fields-time"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (double)((meep::fields const *)arg1)->time();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_solve_cw__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-solve-cw"
  meep::fields *arg1 = (meep::fields *) 0 ;
  double arg2 ;
  int arg3 ;
  complex< double > arg4 ;
  int arg5 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(argv[1], FUNC_NAME);
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  {
    cnumber cnum = ctl_convert_cnumber_to_c(argv[3]);
    arg4 = std::complex<double>(cnum.re, cnum.im);
  }
  {
    arg5 = (int) scm_num2int(argv[4], SCM_ARG1, FUNC_NAME);
  }
  result = (bool)(arg1)->solve_cw(arg2,arg3,arg4,arg5);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_solve_cw__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-solve-cw"
  meep::fields *arg1 = (meep::fields *) 0 ;
  double arg2 ;
  int arg3 ;
  complex< double > arg4 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(argv[1], FUNC_NAME);
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  {
    cnumber cnum = ctl_convert_cnumber_to_c(argv[3]);
    arg4 = std::complex<double>(cnum.re, cnum.im);
  }
  result = (bool)(arg1)->solve_cw(arg2,arg3,arg4);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_solve_cw__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-solve-cw"
  meep::fields *arg1 = (meep::fields *) 0 ;
  double arg2 ;
  int arg3 ;
  int arg4 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(argv[1], FUNC_NAME);
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  {
    arg4 = (int) scm_num2int(argv[3], SCM_ARG1, FUNC_NAME);
  }
  result = (bool)(arg1)->solve_cw(arg2,arg3,arg4);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_solve_cw__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-solve-cw"
  meep::fields *arg1 = (meep::fields *) 0 ;
  double arg2 ;
  int arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(argv[1], FUNC_NAME);
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  result = (bool)(arg1)->solve_cw(arg2,arg3);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_solve_cw__SWIG_4 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-solve-cw"
  meep::fields *arg1 = (meep::fields *) 0 ;
  double arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (double) scm_num2dbl(argv[1], FUNC_NAME);
  }
  result = (bool)(arg1)->solve_cw(arg2);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_solve_cw__SWIG_5 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-solve-cw"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (bool)(arg1)->solve_cw();
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_solve_cw(SCM rest)
{
#define FUNC_NAME "meep-fields-solve-cw"
  SCM argv[5];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 5, "meep-fields-solve-cw");
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      return _wrap_meep_fields_solve_cw__SWIG_5(argc,argv);
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_real_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        return _wrap_meep_fields_solve_cw__SWIG_4(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_real_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_fields_solve_cw__SWIG_3(argc,argv);
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_real_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_integer_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            return _wrap_meep_fields_solve_cw__SWIG_2(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_real_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SwigComplex_Check(argv[3]);
          }
          if (_v) {
            return _wrap_meep_fields_solve_cw__SWIG_1(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_real_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SwigComplex_Check(argv[3]);
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_integer_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              return _wrap_meep_fields_solve_cw__SWIG_0(argc,argv);
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-fields-solve-cw", "No matching method for generic function `meep_fields_solve_cw'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_last_source_time (SCM s_0)
{
#define FUNC_NAME "meep-fields-last-source-time"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (double)(arg1)->last_source_time();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_point_source__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-add-point-source"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::component arg2 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  double arg6 ;
  meep::vec *arg7 = 0 ;
  complex< double > arg8 ;
  int arg9 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (double) scm_num2dbl(argv[2], FUNC_NAME);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  {
    arg5 = (double) scm_num2dbl(argv[4], FUNC_NAME);
  }
  {
    arg6 = (double) scm_num2dbl(argv[5], FUNC_NAME);
  }
  
  meep::vec vec__arg7 = vector3_to_vec(ctl_convert_vector3_to_c(argv[6]));
  arg7 = &vec__arg7;
  
  {
    cnumber cnum = ctl_convert_cnumber_to_c(argv[7]);
    arg8 = std::complex<double>(cnum.re, cnum.im);
  }
  {
    arg9 = (int) scm_num2int(argv[8], SCM_ARG1, FUNC_NAME);
  }
  (arg1)->add_point_source(arg2,arg3,arg4,arg5,arg6,(meep::vec const &)*arg7,arg8,arg9);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_point_source__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-add-point-source"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::component arg2 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  double arg6 ;
  meep::vec *arg7 = 0 ;
  complex< double > arg8 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (double) scm_num2dbl(argv[2], FUNC_NAME);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  {
    arg5 = (double) scm_num2dbl(argv[4], FUNC_NAME);
  }
  {
    arg6 = (double) scm_num2dbl(argv[5], FUNC_NAME);
  }
  
  meep::vec vec__arg7 = vector3_to_vec(ctl_convert_vector3_to_c(argv[6]));
  arg7 = &vec__arg7;
  
  {
    cnumber cnum = ctl_convert_cnumber_to_c(argv[7]);
    arg8 = std::complex<double>(cnum.re, cnum.im);
  }
  (arg1)->add_point_source(arg2,arg3,arg4,arg5,arg6,(meep::vec const &)*arg7,arg8);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_point_source__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-add-point-source"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::component arg2 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  double arg6 ;
  meep::vec *arg7 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (double) scm_num2dbl(argv[2], FUNC_NAME);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  {
    arg5 = (double) scm_num2dbl(argv[4], FUNC_NAME);
  }
  {
    arg6 = (double) scm_num2dbl(argv[5], FUNC_NAME);
  }
  
  meep::vec vec__arg7 = vector3_to_vec(ctl_convert_vector3_to_c(argv[6]));
  arg7 = &vec__arg7;
  
  (arg1)->add_point_source(arg2,arg3,arg4,arg5,arg6,(meep::vec const &)*arg7);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_point_source__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-add-point-source"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::component arg2 ;
  meep::src_time *arg3 = 0 ;
  meep::vec *arg4 = 0 ;
  complex< double > arg5 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::src_time *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__src_time, 3, 0);
  }
  
  meep::vec vec__arg4 = vector3_to_vec(ctl_convert_vector3_to_c(argv[3]));
  arg4 = &vec__arg4;
  
  {
    cnumber cnum = ctl_convert_cnumber_to_c(argv[4]);
    arg5 = std::complex<double>(cnum.re, cnum.im);
  }
  (arg1)->add_point_source(arg2,(meep::src_time const &)*arg3,(meep::vec const &)*arg4,arg5);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_point_source__SWIG_4 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-add-point-source"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::component arg2 ;
  meep::src_time *arg3 = 0 ;
  meep::vec *arg4 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::src_time *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__src_time, 3, 0);
  }
  
  meep::vec vec__arg4 = vector3_to_vec(ctl_convert_vector3_to_c(argv[3]));
  arg4 = &vec__arg4;
  
  (arg1)->add_point_source(arg2,(meep::src_time const &)*arg3,(meep::vec const &)*arg4);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_point_source(SCM rest)
{
#define FUNC_NAME "meep-fields-add-point-source"
  SCM argv[9];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 9, "meep-fields-add-point-source");
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__src_time, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            _v = SwigVector3_Check(argv[3]);
          }
          if (_v) {
            return _wrap_meep_fields_add_point_source__SWIG_4(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__src_time, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            _v = SwigVector3_Check(argv[3]);
          }
          if (_v) {
            {
              _v = SwigComplex_Check(argv[4]);
            }
            if (_v) {
              return _wrap_meep_fields_add_point_source__SWIG_3(argc,argv);
            }
          }
        }
      }
    }
  }
  if (argc == 7) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_real_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_real_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              {
                _v = SCM_NFALSEP(scm_real_p(argv[5])) ? 1 : 0;
              }
              if (_v) {
                {
                  _v = SwigVector3_Check(argv[6]);
                }
                if (_v) {
                  return _wrap_meep_fields_add_point_source__SWIG_2(argc,argv);
                }
              }
            }
          }
        }
      }
    }
  }
  if (argc == 8) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_real_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_real_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              {
                _v = SCM_NFALSEP(scm_real_p(argv[5])) ? 1 : 0;
              }
              if (_v) {
                {
                  _v = SwigVector3_Check(argv[6]);
                }
                if (_v) {
                  {
                    _v = SwigComplex_Check(argv[7]);
                  }
                  if (_v) {
                    return _wrap_meep_fields_add_point_source__SWIG_1(argc,argv);
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  if (argc == 9) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_real_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_real_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              {
                _v = SCM_NFALSEP(scm_real_p(argv[5])) ? 1 : 0;
              }
              if (_v) {
                {
                  _v = SwigVector3_Check(argv[6]);
                }
                if (_v) {
                  {
                    _v = SwigComplex_Check(argv[7]);
                  }
                  if (_v) {
                    {
                      _v = SCM_NFALSEP(scm_integer_p(argv[8])) ? 1 : 0;
                    }
                    if (_v) {
                      return _wrap_meep_fields_add_point_source__SWIG_0(argc,argv);
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-fields-add-point-source", "No matching method for generic function `meep_fields_add_point_source'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_volume_source__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-add-volume-source"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::component arg2 ;
  meep::src_time *arg3 = 0 ;
  meep::volume *arg4 = 0 ;
  complex< double > (*arg5)(meep::vec const &) = (complex< double > (*)(meep::vec const &)) 0 ;
  complex< double > arg6 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::src_time *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__src_time, 3, 0);
  }
  {
    arg4 = (meep::volume *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__volume, 4, 0);
  }
  {
    my_complex_func_scm = argv[4];
    arg5 = my_complex_func;
  }
  {
    cnumber cnum = ctl_convert_cnumber_to_c(argv[5]);
    arg6 = std::complex<double>(cnum.re, cnum.im);
  }
  (arg1)->add_volume_source(arg2,(meep::src_time const &)*arg3,(meep::volume const &)*arg4,arg5,arg6);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_volume_source__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-add-volume-source"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::component arg2 ;
  meep::src_time *arg3 = 0 ;
  meep::volume *arg4 = 0 ;
  complex< double > (*arg5)(meep::vec const &) = (complex< double > (*)(meep::vec const &)) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::src_time *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__src_time, 3, 0);
  }
  {
    arg4 = (meep::volume *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__volume, 4, 0);
  }
  {
    my_complex_func_scm = argv[4];
    arg5 = my_complex_func;
  }
  (arg1)->add_volume_source(arg2,(meep::src_time const &)*arg3,(meep::volume const &)*arg4,arg5);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_volume_source__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-add-volume-source"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::component arg2 ;
  meep::src_time *arg3 = 0 ;
  meep::volume *arg4 = 0 ;
  complex< double > arg5 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::src_time *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__src_time, 3, 0);
  }
  {
    arg4 = (meep::volume *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__volume, 4, 0);
  }
  {
    cnumber cnum = ctl_convert_cnumber_to_c(argv[4]);
    arg5 = std::complex<double>(cnum.re, cnum.im);
  }
  (arg1)->add_volume_source(arg2,(meep::src_time const &)*arg3,(meep::volume const &)*arg4,arg5);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_volume_source__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-add-volume-source"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::component arg2 ;
  meep::src_time *arg3 = 0 ;
  meep::volume *arg4 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::src_time *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__src_time, 3, 0);
  }
  {
    arg4 = (meep::volume *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__volume, 4, 0);
  }
  (arg1)->add_volume_source(arg2,(meep::src_time const &)*arg3,(meep::volume const &)*arg4);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_volume_source(SCM rest)
{
#define FUNC_NAME "meep-fields-add-volume-source"
  SCM argv[6];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 6, "meep-fields-add-volume-source");
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__src_time, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__volume, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            return _wrap_meep_fields_add_volume_source__SWIG_3(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__src_time, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__volume, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_procedure_p(argv[4]));
            }
            if (_v) {
              return _wrap_meep_fields_add_volume_source__SWIG_1(argc,argv);
            }
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__src_time, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__volume, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              _v = SwigComplex_Check(argv[4]);
            }
            if (_v) {
              return _wrap_meep_fields_add_volume_source__SWIG_2(argc,argv);
            }
          }
        }
      }
    }
  }
  if (argc == 6) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__src_time, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__volume, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_procedure_p(argv[4]));
            }
            if (_v) {
              {
                _v = SwigComplex_Check(argv[5]);
              }
              if (_v) {
                return _wrap_meep_fields_add_volume_source__SWIG_0(argc,argv);
              }
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-fields-add-volume-source", "No matching method for generic function `meep_fields_add_volume_source'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_require_component (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-require-component"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::component arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  (arg1)->require_component(arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_eigenmode_source__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-add-eigenmode-source"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::component arg2 ;
  meep::src_time *arg3 = 0 ;
  meep::volume *arg4 = 0 ;
  meep::volume *arg5 = 0 ;
  int arg6 ;
  meep::vec *arg7 = 0 ;
  int arg8 ;
  double arg9 ;
  double arg10 ;
  complex< double > arg11 ;
  complex< double > (*arg12)(meep::vec const &) = (complex< double > (*)(meep::vec const &)) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::src_time *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__src_time, 3, 0);
  }
  {
    arg4 = (meep::volume *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__volume, 4, 0);
  }
  {
    arg5 = (meep::volume *)SWIG_MustGetPtr(argv[4], SWIGTYPE_p_meep__volume, 5, 0);
  }
  {
    arg6 = (int) scm_num2int(argv[5], SCM_ARG1, FUNC_NAME);
  }
  
  meep::vec vec__arg7 = vector3_to_vec(ctl_convert_vector3_to_c(argv[6]));
  arg7 = &vec__arg7;
  
  {
    arg8 = (int) scm_num2int(argv[7], SCM_ARG1, FUNC_NAME);
  }
  {
    arg9 = (double) scm_num2dbl(argv[8], FUNC_NAME);
  }
  {
    arg10 = (double) scm_num2dbl(argv[9], FUNC_NAME);
  }
  {
    cnumber cnum = ctl_convert_cnumber_to_c(argv[10]);
    arg11 = std::complex<double>(cnum.re, cnum.im);
  }
  {
    my_complex_func_scm = argv[11];
    arg12 = my_complex_func;
  }
  (arg1)->add_eigenmode_source(arg2,(meep::src_time const &)*arg3,(meep::volume const &)*arg4,(meep::volume const &)*arg5,arg6,(meep::vec const &)*arg7,arg8,arg9,arg10,arg11,arg12);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_eigenmode_source__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-add-eigenmode-source"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::component arg2 ;
  meep::src_time *arg3 = 0 ;
  meep::volume *arg4 = 0 ;
  meep::volume *arg5 = 0 ;
  int arg6 ;
  meep::vec *arg7 = 0 ;
  int arg8 ;
  double arg9 ;
  double arg10 ;
  complex< double > arg11 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::src_time *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__src_time, 3, 0);
  }
  {
    arg4 = (meep::volume *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__volume, 4, 0);
  }
  {
    arg5 = (meep::volume *)SWIG_MustGetPtr(argv[4], SWIGTYPE_p_meep__volume, 5, 0);
  }
  {
    arg6 = (int) scm_num2int(argv[5], SCM_ARG1, FUNC_NAME);
  }
  
  meep::vec vec__arg7 = vector3_to_vec(ctl_convert_vector3_to_c(argv[6]));
  arg7 = &vec__arg7;
  
  {
    arg8 = (int) scm_num2int(argv[7], SCM_ARG1, FUNC_NAME);
  }
  {
    arg9 = (double) scm_num2dbl(argv[8], FUNC_NAME);
  }
  {
    arg10 = (double) scm_num2dbl(argv[9], FUNC_NAME);
  }
  {
    cnumber cnum = ctl_convert_cnumber_to_c(argv[10]);
    arg11 = std::complex<double>(cnum.re, cnum.im);
  }
  (arg1)->add_eigenmode_source(arg2,(meep::src_time const &)*arg3,(meep::volume const &)*arg4,(meep::volume const &)*arg5,arg6,(meep::vec const &)*arg7,arg8,arg9,arg10,arg11);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_eigenmode_source(SCM rest)
{
#define FUNC_NAME "meep-fields-add-eigenmode-source"
  SCM argv[12];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 12, "meep-fields-add-eigenmode-source");
  if (argc == 11) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__src_time, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__volume, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              void *ptr;
              int res = SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_meep__volume, 0);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              {
                _v = SCM_NFALSEP(scm_integer_p(argv[5])) ? 1 : 0;
              }
              if (_v) {
                {
                  _v = SwigVector3_Check(argv[6]);
                }
                if (_v) {
                  {
                    _v = SCM_NFALSEP(scm_integer_p(argv[7])) ? 1 : 0;
                  }
                  if (_v) {
                    {
                      _v = SCM_NFALSEP(scm_real_p(argv[8])) ? 1 : 0;
                    }
                    if (_v) {
                      {
                        _v = SCM_NFALSEP(scm_real_p(argv[9])) ? 1 : 0;
                      }
                      if (_v) {
                        {
                          _v = SwigComplex_Check(argv[10]);
                        }
                        if (_v) {
                          return _wrap_meep_fields_add_eigenmode_source__SWIG_1(argc,argv);
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  if (argc == 12) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__src_time, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__volume, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              void *ptr;
              int res = SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_meep__volume, 0);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              {
                _v = SCM_NFALSEP(scm_integer_p(argv[5])) ? 1 : 0;
              }
              if (_v) {
                {
                  _v = SwigVector3_Check(argv[6]);
                }
                if (_v) {
                  {
                    _v = SCM_NFALSEP(scm_integer_p(argv[7])) ? 1 : 0;
                  }
                  if (_v) {
                    {
                      _v = SCM_NFALSEP(scm_real_p(argv[8])) ? 1 : 0;
                    }
                    if (_v) {
                      {
                        _v = SCM_NFALSEP(scm_real_p(argv[9])) ? 1 : 0;
                      }
                      if (_v) {
                        {
                          _v = SwigComplex_Check(argv[10]);
                        }
                        if (_v) {
                          {
                            _v = SCM_NFALSEP(scm_procedure_p(argv[11]));
                          }
                          if (_v) {
                            return _wrap_meep_fields_add_eigenmode_source__SWIG_0(argc,argv);
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-fields-add-eigenmode-source", "No matching method for generic function `meep_fields_add_eigenmode_source'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_initialize_field (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-fields-initialize-field"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::component arg2 ;
  complex< double > (*arg3)(meep::vec const &) = (complex< double > (*)(meep::vec const &)) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    my_complex_func_scm = s_2;
    arg3 = my_complex_func;
  }
  (arg1)->initialize_field(arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_initialize_with_nth_te (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-initialize-with-nth-te"
  meep::fields *arg1 = (meep::fields *) 0 ;
  int arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(s_1, SCM_ARG1, FUNC_NAME);
  }
  (arg1)->initialize_with_nth_te(arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_initialize_with_nth_tm (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-initialize-with-nth-tm"
  meep::fields *arg1 = (meep::fields *) 0 ;
  int arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(s_1, SCM_ARG1, FUNC_NAME);
  }
  (arg1)->initialize_with_nth_tm(arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_initialize_with_n_te (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-initialize-with-n-te"
  meep::fields *arg1 = (meep::fields *) 0 ;
  int arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(s_1, SCM_ARG1, FUNC_NAME);
  }
  (arg1)->initialize_with_n_te(arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_initialize_with_n_tm (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-initialize-with-n-tm"
  meep::fields *arg1 = (meep::fields *) 0 ;
  int arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(s_1, SCM_ARG1, FUNC_NAME);
  }
  (arg1)->initialize_with_n_tm(arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_phase_in_material (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-fields-phase-in-material"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::structure *arg2 = (meep::structure *) 0 ;
  double arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::structure *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__structure, 2, 0);
  }
  {
    arg3 = (double) scm_num2dbl(s_2, FUNC_NAME);
  }
  result = (int)(arg1)->phase_in_material((meep::structure const *)arg2,arg3);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_is_phasing (SCM s_0)
{
#define FUNC_NAME "meep-fields-is-phasing"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  int result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (int)(arg1)->is_phasing();
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_loop_in_chunks__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-loop-in-chunks"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::field_chunkloop arg2 = (meep::field_chunkloop) 0 ;
  void *arg3 = (void *) 0 ;
  meep::volume *arg4 = 0 ;
  meep::component arg5 ;
  bool arg6 ;
  bool arg7 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::field_chunkloop)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_f_p_meep__fields_chunk_int_enum_meep__component_meep__ivec_meep__ivec_meep__vec_meep__vec_meep__vec_meep__vec_double_double_meep__ivec_complex__double___r_q_const__meep__symmetry_int_p_void__void, 2, 0);
  }
  {
    arg3 = (void *)SWIG_MustGetPtr(argv[2], NULL, 3, 0);
  }
  {
    arg4 = (meep::volume *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__volume, 4, 0);
  }
  {
    arg5 = (meep::component) scm_num2int(argv[4], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg6 = (bool) SCM_NFALSEP(argv[5]);
  }
  {
    arg7 = (bool) SCM_NFALSEP(argv[6]);
  }
  (arg1)->loop_in_chunks(arg2,arg3,(meep::volume const &)*arg4,arg5,arg6,arg7);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_loop_in_chunks__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-loop-in-chunks"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::field_chunkloop arg2 = (meep::field_chunkloop) 0 ;
  void *arg3 = (void *) 0 ;
  meep::volume *arg4 = 0 ;
  meep::component arg5 ;
  bool arg6 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::field_chunkloop)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_f_p_meep__fields_chunk_int_enum_meep__component_meep__ivec_meep__ivec_meep__vec_meep__vec_meep__vec_meep__vec_double_double_meep__ivec_complex__double___r_q_const__meep__symmetry_int_p_void__void, 2, 0);
  }
  {
    arg3 = (void *)SWIG_MustGetPtr(argv[2], NULL, 3, 0);
  }
  {
    arg4 = (meep::volume *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__volume, 4, 0);
  }
  {
    arg5 = (meep::component) scm_num2int(argv[4], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg6 = (bool) SCM_NFALSEP(argv[5]);
  }
  (arg1)->loop_in_chunks(arg2,arg3,(meep::volume const &)*arg4,arg5,arg6);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_loop_in_chunks__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-loop-in-chunks"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::field_chunkloop arg2 = (meep::field_chunkloop) 0 ;
  void *arg3 = (void *) 0 ;
  meep::volume *arg4 = 0 ;
  meep::component arg5 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::field_chunkloop)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_f_p_meep__fields_chunk_int_enum_meep__component_meep__ivec_meep__ivec_meep__vec_meep__vec_meep__vec_meep__vec_double_double_meep__ivec_complex__double___r_q_const__meep__symmetry_int_p_void__void, 2, 0);
  }
  {
    arg3 = (void *)SWIG_MustGetPtr(argv[2], NULL, 3, 0);
  }
  {
    arg4 = (meep::volume *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__volume, 4, 0);
  }
  {
    arg5 = (meep::component) scm_num2int(argv[4], SCM_ARG1, FUNC_NAME); 
  }
  (arg1)->loop_in_chunks(arg2,arg3,(meep::volume const &)*arg4,arg5);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_loop_in_chunks__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-loop-in-chunks"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::field_chunkloop arg2 = (meep::field_chunkloop) 0 ;
  void *arg3 = (void *) 0 ;
  meep::volume *arg4 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::field_chunkloop)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_f_p_meep__fields_chunk_int_enum_meep__component_meep__ivec_meep__ivec_meep__vec_meep__vec_meep__vec_meep__vec_double_double_meep__ivec_complex__double___r_q_const__meep__symmetry_int_p_void__void, 2, 0);
  }
  {
    arg3 = (void *)SWIG_MustGetPtr(argv[2], NULL, 3, 0);
  }
  {
    arg4 = (meep::volume *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__volume, 4, 0);
  }
  (arg1)->loop_in_chunks(arg2,arg3,(meep::volume const &)*arg4);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_loop_in_chunks(SCM rest)
{
#define FUNC_NAME "meep-fields-loop-in-chunks"
  SCM argv[7];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 7, "meep-fields-loop-in-chunks");
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_f_p_meep__fields_chunk_int_enum_meep__component_meep__ivec_meep__ivec_meep__vec_meep__vec_meep__vec_meep__vec_double_double_meep__ivec_complex__double___r_q_const__meep__symmetry_int_p_void__void, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, 0, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__volume, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            return _wrap_meep_fields_loop_in_chunks__SWIG_3(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_f_p_meep__fields_chunk_int_enum_meep__component_meep__ivec_meep__ivec_meep__vec_meep__vec_meep__vec_meep__vec_double_double_meep__ivec_complex__double___r_q_const__meep__symmetry_int_p_void__void, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, 0, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__volume, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_integer_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              return _wrap_meep_fields_loop_in_chunks__SWIG_2(argc,argv);
            }
          }
        }
      }
    }
  }
  if (argc == 6) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_f_p_meep__fields_chunk_int_enum_meep__component_meep__ivec_meep__ivec_meep__vec_meep__vec_meep__vec_meep__vec_double_double_meep__ivec_complex__double___r_q_const__meep__symmetry_int_p_void__void, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, 0, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__volume, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_integer_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              {
                _v = SCM_BOOLP(argv[5]) ? 1 : 0;
              }
              if (_v) {
                return _wrap_meep_fields_loop_in_chunks__SWIG_1(argc,argv);
              }
            }
          }
        }
      }
    }
  }
  if (argc == 7) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_f_p_meep__fields_chunk_int_enum_meep__component_meep__ivec_meep__ivec_meep__vec_meep__vec_meep__vec_meep__vec_double_double_meep__ivec_complex__double___r_q_const__meep__symmetry_int_p_void__void, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, 0, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__volume, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_integer_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              {
                _v = SCM_BOOLP(argv[5]) ? 1 : 0;
              }
              if (_v) {
                {
                  _v = SCM_BOOLP(argv[6]) ? 1 : 0;
                }
                if (_v) {
                  return _wrap_meep_fields_loop_in_chunks__SWIG_0(argc,argv);
                }
              }
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-fields-loop-in-chunks", "No matching method for generic function `meep_fields_loop_in_chunks'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_integrate__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-integrate"
  meep::fields *arg1 = (meep::fields *) 0 ;
  int arg2 ;
  meep::component *arg3 = (meep::component *) 0 ;
  meep::field_function arg4 = (meep::field_function) 0 ;
  void *arg5 = (void *) 0 ;
  meep::volume *arg6 = 0 ;
  double *arg7 = (double *) 0 ;
  my_field_func_data data2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = list_length(SCM_CAR(argv[1]));
    arg3 = new meep::component[arg2];
    for (int i = 0; i < arg2; ++i)
    arg3[i] = meep::component(integer_list_ref(SCM_CAR(argv[1]), i));
    data2.nf = arg2;
    data2.func = SCM_CDR(argv[1]);
    arg4 = my_field_func;
    arg5 = &data2;
  }
  {
    arg6 = (meep::volume *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__volume, 6, 0);
  }
  {
    arg7 = (double *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_double, 7, 0);
  }
  result = (arg1)->integrate(arg2,(meep::component const *)arg3,arg4,arg5,(meep::volume const &)*arg6,arg7);
  {
    gswig_result = scm_make_rectangular(scm_make_real((&result)->real()),
      scm_make_real((&result)->imag()));
  }
  
  {
    if (arg3) delete[] arg3;
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_integrate__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-integrate"
  meep::fields *arg1 = (meep::fields *) 0 ;
  int arg2 ;
  meep::component *arg3 = (meep::component *) 0 ;
  meep::field_function arg4 = (meep::field_function) 0 ;
  void *arg5 = (void *) 0 ;
  meep::volume *arg6 = 0 ;
  my_field_func_data data2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = list_length(SCM_CAR(argv[1]));
    arg3 = new meep::component[arg2];
    for (int i = 0; i < arg2; ++i)
    arg3[i] = meep::component(integer_list_ref(SCM_CAR(argv[1]), i));
    data2.nf = arg2;
    data2.func = SCM_CDR(argv[1]);
    arg4 = my_field_func;
    arg5 = &data2;
  }
  {
    arg6 = (meep::volume *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__volume, 6, 0);
  }
  result = (arg1)->integrate(arg2,(meep::component const *)arg3,arg4,arg5,(meep::volume const &)*arg6);
  {
    gswig_result = scm_make_rectangular(scm_make_real((&result)->real()),
      scm_make_real((&result)->imag()));
  }
  
  {
    if (arg3) delete[] arg3;
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_integrate__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-integrate"
  meep::fields *arg1 = (meep::fields *) 0 ;
  int arg2 ;
  meep::component *arg3 = (meep::component *) 0 ;
  meep::field_rfunction arg4 = (meep::field_rfunction) 0 ;
  void *arg5 = (void *) 0 ;
  meep::volume *arg6 = 0 ;
  double *arg7 = (double *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME);
  }
  {
    arg3 = (meep::component *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__component, 3, 0);
  }
  {
    arg4 = (meep::field_rfunction)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_f_p_q_const__complex__double___r_q_const__meep__vec_p_void__double, 4, 0);
  }
  {
    arg5 = (void *)SWIG_MustGetPtr(argv[4], NULL, 5, 0);
  }
  {
    arg6 = (meep::volume *)SWIG_MustGetPtr(argv[5], SWIGTYPE_p_meep__volume, 6, 0);
  }
  {
    arg7 = (double *)SWIG_MustGetPtr(argv[6], SWIGTYPE_p_double, 7, 0);
  }
  result = (double)(arg1)->integrate(arg2,(meep::component const *)arg3,arg4,arg5,(meep::volume const &)*arg6,arg7);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_integrate__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-integrate"
  meep::fields *arg1 = (meep::fields *) 0 ;
  int arg2 ;
  meep::component *arg3 = (meep::component *) 0 ;
  meep::field_rfunction arg4 = (meep::field_rfunction) 0 ;
  void *arg5 = (void *) 0 ;
  meep::volume *arg6 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME);
  }
  {
    arg3 = (meep::component *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__component, 3, 0);
  }
  {
    arg4 = (meep::field_rfunction)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_f_p_q_const__complex__double___r_q_const__meep__vec_p_void__double, 4, 0);
  }
  {
    arg5 = (void *)SWIG_MustGetPtr(argv[4], NULL, 5, 0);
  }
  {
    arg6 = (meep::volume *)SWIG_MustGetPtr(argv[5], SWIGTYPE_p_meep__volume, 6, 0);
  }
  result = (double)(arg1)->integrate(arg2,(meep::component const *)arg3,arg4,arg5,(meep::volume const &)*arg6);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_integrate(SCM rest)
{
#define FUNC_NAME "meep-fields-integrate"
  SCM argv[7];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 7, "meep-fields-integrate");
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_pair_p(argv[1])) &&
        SCM_NFALSEP(scm_list_p(SCM_CAR(argv[1]))) &&
        SCM_NFALSEP(scm_procedure_p(SCM_CDR(argv[1]))); 
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__volume, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_meep_fields_integrate__SWIG_1(argc,argv);
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_pair_p(argv[1])) &&
        SCM_NFALSEP(scm_list_p(SCM_CAR(argv[1]))) &&
        SCM_NFALSEP(scm_procedure_p(SCM_CDR(argv[1]))); 
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__volume, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_double, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            return _wrap_meep_fields_integrate__SWIG_0(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 6) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__component, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_f_p_q_const__complex__double___r_q_const__meep__vec_p_void__double, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              void *ptr;
              int res = SWIG_ConvertPtr(argv[4], &ptr, 0, 0);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              {
                void *ptr;
                int res = SWIG_ConvertPtr(argv[5], &ptr, SWIGTYPE_p_meep__volume, 0);
                _v = SWIG_CheckState(res);
              }
              if (_v) {
                return _wrap_meep_fields_integrate__SWIG_3(argc,argv);
              }
            }
          }
        }
      }
    }
  }
  if (argc == 7) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__component, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_f_p_q_const__complex__double___r_q_const__meep__vec_p_void__double, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              void *ptr;
              int res = SWIG_ConvertPtr(argv[4], &ptr, 0, 0);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              {
                void *ptr;
                int res = SWIG_ConvertPtr(argv[5], &ptr, SWIGTYPE_p_meep__volume, 0);
                _v = SWIG_CheckState(res);
              }
              if (_v) {
                {
                  void *ptr;
                  int res = SWIG_ConvertPtr(argv[6], &ptr, SWIGTYPE_p_double, 0);
                  _v = SWIG_CheckState(res);
                }
                if (_v) {
                  return _wrap_meep_fields_integrate__SWIG_2(argc,argv);
                }
              }
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-fields-integrate", "No matching method for generic function `meep_fields_integrate'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_integrate2__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-integrate2"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::fields *arg2 = 0 ;
  int arg3 ;
  meep::component *arg4 = (meep::component *) 0 ;
  int arg5 ;
  meep::component *arg6 = (meep::component *) 0 ;
  meep::field_function arg7 = (meep::field_function) 0 ;
  void *arg8 = (void *) 0 ;
  meep::volume *arg9 = 0 ;
  double *arg10 = (double *) 0 ;
  my_field_func_data data3 ;
  my_field_func_data data30 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::fields *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__fields, 2, 0);
  }
  {
    arg3 = list_length(SCM_CAR(SCM_CAR(argv[2])));
    arg4 = new meep::component[arg3];
    for (int i = 0; i < arg3; ++i)
    arg4[i] = meep::component(integer_list_ref(SCM_CAR(SCM_CAR(argv[2])), i));
    arg5 = list_length(SCM_CDR(SCM_CAR(argv[2])));
    arg6 = new meep::component[arg5];
    for (int i = 0; i < arg5; ++i)
    arg6[i] = meep::component(integer_list_ref(SCM_CDR(SCM_CAR(argv[2])), i));
    data3.nf = arg3 + arg5;
    data3.func = SCM_CDR(argv[2]);
    arg7 = my_field_func;
    arg8 = &data3;
  }
  {
    arg9 = (meep::volume *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__volume, 9, 0);
  }
  {
    arg10 = (double *)SWIG_MustGetPtr(argv[4], SWIGTYPE_p_double, 10, 0);
  }
  result = (arg1)->integrate2((meep::fields const &)*arg2,arg3,(meep::component const *)arg4,arg5,(meep::component const *)arg6,arg7,arg8,(meep::volume const &)*arg9,arg10);
  {
    gswig_result = scm_make_rectangular(scm_make_real((&result)->real()),
      scm_make_real((&result)->imag()));
  }
  
  
  {
    if (arg4) delete[] arg4;
    if (arg6) delete[] arg6;
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_integrate2__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-integrate2"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::fields *arg2 = 0 ;
  int arg3 ;
  meep::component *arg4 = (meep::component *) 0 ;
  int arg5 ;
  meep::component *arg6 = (meep::component *) 0 ;
  meep::field_function arg7 = (meep::field_function) 0 ;
  void *arg8 = (void *) 0 ;
  meep::volume *arg9 = 0 ;
  my_field_func_data data3 ;
  my_field_func_data data30 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::fields *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__fields, 2, 0);
  }
  {
    arg3 = list_length(SCM_CAR(SCM_CAR(argv[2])));
    arg4 = new meep::component[arg3];
    for (int i = 0; i < arg3; ++i)
    arg4[i] = meep::component(integer_list_ref(SCM_CAR(SCM_CAR(argv[2])), i));
    arg5 = list_length(SCM_CDR(SCM_CAR(argv[2])));
    arg6 = new meep::component[arg5];
    for (int i = 0; i < arg5; ++i)
    arg6[i] = meep::component(integer_list_ref(SCM_CDR(SCM_CAR(argv[2])), i));
    data3.nf = arg3 + arg5;
    data3.func = SCM_CDR(argv[2]);
    arg7 = my_field_func;
    arg8 = &data3;
  }
  {
    arg9 = (meep::volume *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__volume, 9, 0);
  }
  result = (arg1)->integrate2((meep::fields const &)*arg2,arg3,(meep::component const *)arg4,arg5,(meep::component const *)arg6,arg7,arg8,(meep::volume const &)*arg9);
  {
    gswig_result = scm_make_rectangular(scm_make_real((&result)->real()),
      scm_make_real((&result)->imag()));
  }
  
  
  {
    if (arg4) delete[] arg4;
    if (arg6) delete[] arg6;
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_integrate2__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-integrate2"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::fields *arg2 = 0 ;
  int arg3 ;
  meep::component *arg4 = (meep::component *) 0 ;
  int arg5 ;
  meep::component *arg6 = (meep::component *) 0 ;
  meep::field_rfunction arg7 = (meep::field_rfunction) 0 ;
  void *arg8 = (void *) 0 ;
  meep::volume *arg9 = 0 ;
  double *arg10 = (double *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::fields *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__fields, 2, 0);
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  {
    arg4 = (meep::component *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__component, 4, 0);
  }
  {
    arg5 = (int) scm_num2int(argv[4], SCM_ARG1, FUNC_NAME);
  }
  {
    arg6 = (meep::component *)SWIG_MustGetPtr(argv[5], SWIGTYPE_p_meep__component, 6, 0);
  }
  {
    arg7 = (meep::field_rfunction)SWIG_MustGetPtr(argv[6], SWIGTYPE_p_f_p_q_const__complex__double___r_q_const__meep__vec_p_void__double, 7, 0);
  }
  {
    arg8 = (void *)SWIG_MustGetPtr(argv[7], NULL, 8, 0);
  }
  {
    arg9 = (meep::volume *)SWIG_MustGetPtr(argv[8], SWIGTYPE_p_meep__volume, 9, 0);
  }
  {
    arg10 = (double *)SWIG_MustGetPtr(argv[9], SWIGTYPE_p_double, 10, 0);
  }
  result = (double)(arg1)->integrate2((meep::fields const &)*arg2,arg3,(meep::component const *)arg4,arg5,(meep::component const *)arg6,arg7,arg8,(meep::volume const &)*arg9,arg10);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_integrate2__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-integrate2"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::fields *arg2 = 0 ;
  int arg3 ;
  meep::component *arg4 = (meep::component *) 0 ;
  int arg5 ;
  meep::component *arg6 = (meep::component *) 0 ;
  meep::field_rfunction arg7 = (meep::field_rfunction) 0 ;
  void *arg8 = (void *) 0 ;
  meep::volume *arg9 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::fields *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__fields, 2, 0);
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  {
    arg4 = (meep::component *)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_meep__component, 4, 0);
  }
  {
    arg5 = (int) scm_num2int(argv[4], SCM_ARG1, FUNC_NAME);
  }
  {
    arg6 = (meep::component *)SWIG_MustGetPtr(argv[5], SWIGTYPE_p_meep__component, 6, 0);
  }
  {
    arg7 = (meep::field_rfunction)SWIG_MustGetPtr(argv[6], SWIGTYPE_p_f_p_q_const__complex__double___r_q_const__meep__vec_p_void__double, 7, 0);
  }
  {
    arg8 = (void *)SWIG_MustGetPtr(argv[7], NULL, 8, 0);
  }
  {
    arg9 = (meep::volume *)SWIG_MustGetPtr(argv[8], SWIGTYPE_p_meep__volume, 9, 0);
  }
  result = (double)(arg1)->integrate2((meep::fields const &)*arg2,arg3,(meep::component const *)arg4,arg5,(meep::component const *)arg6,arg7,arg8,(meep::volume const &)*arg9);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_integrate2(SCM rest)
{
#define FUNC_NAME "meep-fields-integrate2"
  SCM argv[10];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 10, "meep-fields-integrate2");
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__fields, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_pair_p(argv[2])) &&
          SCM_NFALSEP(scm_pair_p(SCM_CAR(argv[2]))) &&
          SCM_NFALSEP(scm_list_p(SCM_CAR(SCM_CAR(argv[2])))) &&
          SCM_NFALSEP(scm_list_p(SCM_CDR(SCM_CAR(argv[2])))) &&
          SCM_NFALSEP(scm_procedure_p(SCM_CDR(argv[2]))); 
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__volume, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            return _wrap_meep_fields_integrate2__SWIG_1(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__fields, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_pair_p(argv[2])) &&
          SCM_NFALSEP(scm_pair_p(SCM_CAR(argv[2]))) &&
          SCM_NFALSEP(scm_list_p(SCM_CAR(SCM_CAR(argv[2])))) &&
          SCM_NFALSEP(scm_list_p(SCM_CDR(SCM_CAR(argv[2])))) &&
          SCM_NFALSEP(scm_procedure_p(SCM_CDR(argv[2]))); 
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__volume, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              void *ptr;
              int res = SWIG_ConvertPtr(argv[4], &ptr, SWIGTYPE_p_double, 0);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              return _wrap_meep_fields_integrate2__SWIG_0(argc,argv);
            }
          }
        }
      }
    }
  }
  if (argc == 9) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__fields, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__component, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_integer_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              {
                void *ptr;
                int res = SWIG_ConvertPtr(argv[5], &ptr, SWIGTYPE_p_meep__component, 0);
                _v = SWIG_CheckState(res);
              }
              if (_v) {
                {
                  void *ptr;
                  int res = SWIG_ConvertPtr(argv[6], &ptr, SWIGTYPE_p_f_p_q_const__complex__double___r_q_const__meep__vec_p_void__double, 0);
                  _v = SWIG_CheckState(res);
                }
                if (_v) {
                  {
                    void *ptr;
                    int res = SWIG_ConvertPtr(argv[7], &ptr, 0, 0);
                    _v = SWIG_CheckState(res);
                  }
                  if (_v) {
                    {
                      void *ptr;
                      int res = SWIG_ConvertPtr(argv[8], &ptr, SWIGTYPE_p_meep__volume, 0);
                      _v = SWIG_CheckState(res);
                    }
                    if (_v) {
                      return _wrap_meep_fields_integrate2__SWIG_3(argc,argv);
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  if (argc == 10) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__fields, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_meep__component, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_integer_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              {
                void *ptr;
                int res = SWIG_ConvertPtr(argv[5], &ptr, SWIGTYPE_p_meep__component, 0);
                _v = SWIG_CheckState(res);
              }
              if (_v) {
                {
                  void *ptr;
                  int res = SWIG_ConvertPtr(argv[6], &ptr, SWIGTYPE_p_f_p_q_const__complex__double___r_q_const__meep__vec_p_void__double, 0);
                  _v = SWIG_CheckState(res);
                }
                if (_v) {
                  {
                    void *ptr;
                    int res = SWIG_ConvertPtr(argv[7], &ptr, 0, 0);
                    _v = SWIG_CheckState(res);
                  }
                  if (_v) {
                    {
                      void *ptr;
                      int res = SWIG_ConvertPtr(argv[8], &ptr, SWIGTYPE_p_meep__volume, 0);
                      _v = SWIG_CheckState(res);
                    }
                    if (_v) {
                      {
                        void *ptr;
                        int res = SWIG_ConvertPtr(argv[9], &ptr, SWIGTYPE_p_double, 0);
                        _v = SWIG_CheckState(res);
                      }
                      if (_v) {
                        return _wrap_meep_fields_integrate2__SWIG_2(argc,argv);
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-fields-integrate2", "No matching method for generic function `meep_fields_integrate2'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_max_abs__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-max-abs"
  meep::fields *arg1 = (meep::fields *) 0 ;
  int arg2 ;
  meep::component *arg3 = (meep::component *) 0 ;
  meep::field_function arg4 = (meep::field_function) 0 ;
  void *arg5 = (void *) 0 ;
  meep::volume *arg6 = 0 ;
  my_field_func_data data2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = list_length(SCM_CAR(argv[1]));
    arg3 = new meep::component[arg2];
    for (int i = 0; i < arg2; ++i)
    arg3[i] = meep::component(integer_list_ref(SCM_CAR(argv[1]), i));
    data2.nf = arg2;
    data2.func = SCM_CDR(argv[1]);
    arg4 = my_field_func;
    arg5 = &data2;
  }
  {
    arg6 = (meep::volume *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__volume, 6, 0);
  }
  result = (double)(arg1)->max_abs(arg2,(meep::component const *)arg3,arg4,arg5,(meep::volume const &)*arg6);
  {
    gswig_result = scm_make_real(result);
  }
  
  {
    if (arg3) delete[] arg3;
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_max_abs__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-max-abs"
  meep::fields *arg1 = (meep::fields *) 0 ;
  int arg2 ;
  meep::component *arg3 = (meep::component *) 0 ;
  meep::field_rfunction arg4 = (meep::field_rfunction) 0 ;
  void *arg5 = (void *) 0 ;
  meep::volume *arg6 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME);
  }
  {
    arg3 = (meep::component *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__component, 3, 0);
  }
  {
    arg4 = (meep::field_rfunction)SWIG_MustGetPtr(argv[3], SWIGTYPE_p_f_p_q_const__complex__double___r_q_const__meep__vec_p_void__double, 4, 0);
  }
  {
    arg5 = (void *)SWIG_MustGetPtr(argv[4], NULL, 5, 0);
  }
  {
    arg6 = (meep::volume *)SWIG_MustGetPtr(argv[5], SWIGTYPE_p_meep__volume, 6, 0);
  }
  result = (double)(arg1)->max_abs(arg2,(meep::component const *)arg3,arg4,arg5,(meep::volume const &)*arg6);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_max_abs__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-max-abs"
  meep::fields *arg1 = (meep::fields *) 0 ;
  int arg2 ;
  meep::volume *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME);
  }
  {
    arg3 = (meep::volume *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__volume, 3, 0);
  }
  result = (double)(arg1)->max_abs(arg2,(meep::volume const &)*arg3);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_max_abs__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-max-abs"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::component arg2 ;
  meep::volume *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::volume *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__volume, 3, 0);
  }
  result = (double)(arg1)->max_abs(arg2,(meep::volume const &)*arg3);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_max_abs__SWIG_4 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-max-abs"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::derived_component arg2 ;
  meep::volume *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::derived_component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::volume *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__volume, 3, 0);
  }
  result = (double)(arg1)->max_abs(arg2,(meep::volume const &)*arg3);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_max_abs(SCM rest)
{
#define FUNC_NAME "meep-fields-max-abs"
  SCM argv[6];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 6, "meep-fields-max-abs");
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_pair_p(argv[1])) &&
        SCM_NFALSEP(scm_list_p(SCM_CAR(argv[1]))) &&
        SCM_NFALSEP(scm_procedure_p(SCM_CDR(argv[1]))); 
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__volume, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_meep_fields_max_abs__SWIG_0(argc,argv);
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__volume, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_meep_fields_max_abs__SWIG_2(argc,argv);
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__volume, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_meep_fields_max_abs__SWIG_3(argc,argv);
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__volume, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_meep_fields_max_abs__SWIG_4(argc,argv);
        }
      }
    }
  }
  if (argc == 6) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__component, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            void *ptr;
            int res = SWIG_ConvertPtr(argv[3], &ptr, SWIGTYPE_p_f_p_q_const__complex__double___r_q_const__meep__vec_p_void__double, 0);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              void *ptr;
              int res = SWIG_ConvertPtr(argv[4], &ptr, 0, 0);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              {
                void *ptr;
                int res = SWIG_ConvertPtr(argv[5], &ptr, SWIGTYPE_p_meep__volume, 0);
                _v = SWIG_CheckState(res);
              }
              if (_v) {
                return _wrap_meep_fields_max_abs__SWIG_1(argc,argv);
              }
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-fields-max-abs", "No matching method for generic function `meep_fields_max_abs'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_dft__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-add-dft"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::component arg2 ;
  meep::volume *arg3 = 0 ;
  double arg4 ;
  double arg5 ;
  int arg6 ;
  bool arg7 ;
  complex< double > arg8 ;
  meep::dft_chunk *arg9 = (meep::dft_chunk *) 0 ;
  bool arg10 ;
  complex< double > arg11 ;
  bool arg12 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::dft_chunk *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::volume *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__volume, 3, 0);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  {
    arg5 = (double) scm_num2dbl(argv[4], FUNC_NAME);
  }
  {
    arg6 = (int) scm_num2int(argv[5], SCM_ARG1, FUNC_NAME);
  }
  {
    arg7 = (bool) SCM_NFALSEP(argv[6]);
  }
  {
    cnumber cnum = ctl_convert_cnumber_to_c(argv[7]);
    arg8 = std::complex<double>(cnum.re, cnum.im);
  }
  {
    arg9 = (meep::dft_chunk *)SWIG_MustGetPtr(argv[8], SWIGTYPE_p_meep__dft_chunk, 9, 0);
  }
  {
    arg10 = (bool) SCM_NFALSEP(argv[9]);
  }
  {
    cnumber cnum = ctl_convert_cnumber_to_c(argv[10]);
    arg11 = std::complex<double>(cnum.re, cnum.im);
  }
  {
    arg12 = (bool) SCM_NFALSEP(argv[11]);
  }
  result = (meep::dft_chunk *)(arg1)->add_dft(arg2,(meep::volume const &)*arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__dft_chunk, 0);
  }
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_dft__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-add-dft"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::component arg2 ;
  meep::volume *arg3 = 0 ;
  double arg4 ;
  double arg5 ;
  int arg6 ;
  bool arg7 ;
  complex< double > arg8 ;
  meep::dft_chunk *arg9 = (meep::dft_chunk *) 0 ;
  bool arg10 ;
  complex< double > arg11 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::dft_chunk *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::volume *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__volume, 3, 0);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  {
    arg5 = (double) scm_num2dbl(argv[4], FUNC_NAME);
  }
  {
    arg6 = (int) scm_num2int(argv[5], SCM_ARG1, FUNC_NAME);
  }
  {
    arg7 = (bool) SCM_NFALSEP(argv[6]);
  }
  {
    cnumber cnum = ctl_convert_cnumber_to_c(argv[7]);
    arg8 = std::complex<double>(cnum.re, cnum.im);
  }
  {
    arg9 = (meep::dft_chunk *)SWIG_MustGetPtr(argv[8], SWIGTYPE_p_meep__dft_chunk, 9, 0);
  }
  {
    arg10 = (bool) SCM_NFALSEP(argv[9]);
  }
  {
    cnumber cnum = ctl_convert_cnumber_to_c(argv[10]);
    arg11 = std::complex<double>(cnum.re, cnum.im);
  }
  result = (meep::dft_chunk *)(arg1)->add_dft(arg2,(meep::volume const &)*arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__dft_chunk, 0);
  }
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_dft__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-add-dft"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::component arg2 ;
  meep::volume *arg3 = 0 ;
  double arg4 ;
  double arg5 ;
  int arg6 ;
  bool arg7 ;
  complex< double > arg8 ;
  meep::dft_chunk *arg9 = (meep::dft_chunk *) 0 ;
  bool arg10 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::dft_chunk *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::volume *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__volume, 3, 0);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  {
    arg5 = (double) scm_num2dbl(argv[4], FUNC_NAME);
  }
  {
    arg6 = (int) scm_num2int(argv[5], SCM_ARG1, FUNC_NAME);
  }
  {
    arg7 = (bool) SCM_NFALSEP(argv[6]);
  }
  {
    cnumber cnum = ctl_convert_cnumber_to_c(argv[7]);
    arg8 = std::complex<double>(cnum.re, cnum.im);
  }
  {
    arg9 = (meep::dft_chunk *)SWIG_MustGetPtr(argv[8], SWIGTYPE_p_meep__dft_chunk, 9, 0);
  }
  {
    arg10 = (bool) SCM_NFALSEP(argv[9]);
  }
  result = (meep::dft_chunk *)(arg1)->add_dft(arg2,(meep::volume const &)*arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__dft_chunk, 0);
  }
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_dft__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-add-dft"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::component arg2 ;
  meep::volume *arg3 = 0 ;
  double arg4 ;
  double arg5 ;
  int arg6 ;
  bool arg7 ;
  complex< double > arg8 ;
  meep::dft_chunk *arg9 = (meep::dft_chunk *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::dft_chunk *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::volume *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__volume, 3, 0);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  {
    arg5 = (double) scm_num2dbl(argv[4], FUNC_NAME);
  }
  {
    arg6 = (int) scm_num2int(argv[5], SCM_ARG1, FUNC_NAME);
  }
  {
    arg7 = (bool) SCM_NFALSEP(argv[6]);
  }
  {
    cnumber cnum = ctl_convert_cnumber_to_c(argv[7]);
    arg8 = std::complex<double>(cnum.re, cnum.im);
  }
  {
    arg9 = (meep::dft_chunk *)SWIG_MustGetPtr(argv[8], SWIGTYPE_p_meep__dft_chunk, 9, 0);
  }
  result = (meep::dft_chunk *)(arg1)->add_dft(arg2,(meep::volume const &)*arg3,arg4,arg5,arg6,arg7,arg8,arg9);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__dft_chunk, 0);
  }
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_dft__SWIG_4 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-add-dft"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::component arg2 ;
  meep::volume *arg3 = 0 ;
  double arg4 ;
  double arg5 ;
  int arg6 ;
  bool arg7 ;
  complex< double > arg8 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::dft_chunk *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::volume *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__volume, 3, 0);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  {
    arg5 = (double) scm_num2dbl(argv[4], FUNC_NAME);
  }
  {
    arg6 = (int) scm_num2int(argv[5], SCM_ARG1, FUNC_NAME);
  }
  {
    arg7 = (bool) SCM_NFALSEP(argv[6]);
  }
  {
    cnumber cnum = ctl_convert_cnumber_to_c(argv[7]);
    arg8 = std::complex<double>(cnum.re, cnum.im);
  }
  result = (meep::dft_chunk *)(arg1)->add_dft(arg2,(meep::volume const &)*arg3,arg4,arg5,arg6,arg7,arg8);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__dft_chunk, 0);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_dft__SWIG_5 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-add-dft"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::component arg2 ;
  meep::volume *arg3 = 0 ;
  double arg4 ;
  double arg5 ;
  int arg6 ;
  bool arg7 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::dft_chunk *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::volume *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__volume, 3, 0);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  {
    arg5 = (double) scm_num2dbl(argv[4], FUNC_NAME);
  }
  {
    arg6 = (int) scm_num2int(argv[5], SCM_ARG1, FUNC_NAME);
  }
  {
    arg7 = (bool) SCM_NFALSEP(argv[6]);
  }
  result = (meep::dft_chunk *)(arg1)->add_dft(arg2,(meep::volume const &)*arg3,arg4,arg5,arg6,arg7);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__dft_chunk, 0);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_dft__SWIG_6 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-add-dft"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::component arg2 ;
  meep::volume *arg3 = 0 ;
  double arg4 ;
  double arg5 ;
  int arg6 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::dft_chunk *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::volume *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__volume, 3, 0);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  {
    arg5 = (double) scm_num2dbl(argv[4], FUNC_NAME);
  }
  {
    arg6 = (int) scm_num2int(argv[5], SCM_ARG1, FUNC_NAME);
  }
  result = (meep::dft_chunk *)(arg1)->add_dft(arg2,(meep::volume const &)*arg3,arg4,arg5,arg6);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__dft_chunk, 0);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_dft_pt (SCM s_0, SCM s_1, SCM s_2, SCM s_3, SCM s_4, SCM s_5)
{
#define FUNC_NAME "meep-fields-add-dft-pt"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::component arg2 ;
  meep::vec *arg3 = 0 ;
  double arg4 ;
  double arg5 ;
  int arg6 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::dft_chunk *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  
  meep::vec vec__arg3 = vector3_to_vec(ctl_convert_vector3_to_c(s_2));
  arg3 = &vec__arg3;
  
  {
    arg4 = (double) scm_num2dbl(s_3, FUNC_NAME);
  }
  {
    arg5 = (double) scm_num2dbl(s_4, FUNC_NAME);
  }
  {
    arg6 = (int) scm_num2int(s_5, SCM_ARG1, FUNC_NAME);
  }
  result = (meep::dft_chunk *)(arg1)->add_dft_pt(arg2,(meep::vec const &)*arg3,arg4,arg5,arg6);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__dft_chunk, 0);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_dft__SWIG_7 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-add-dft"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::volume_list *arg2 = (meep::volume_list *) 0 ;
  double arg3 ;
  double arg4 ;
  int arg5 ;
  bool arg6 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::dft_chunk *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::volume_list *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__volume_list, 2, 0);
  }
  {
    arg3 = (double) scm_num2dbl(argv[2], FUNC_NAME);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  {
    arg5 = (int) scm_num2int(argv[4], SCM_ARG1, FUNC_NAME);
  }
  {
    arg6 = (bool) SCM_NFALSEP(argv[5]);
  }
  result = (meep::dft_chunk *)(arg1)->add_dft((meep::volume_list const *)arg2,arg3,arg4,arg5,arg6);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__dft_chunk, 0);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_dft__SWIG_8 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-add-dft"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::volume_list *arg2 = (meep::volume_list *) 0 ;
  double arg3 ;
  double arg4 ;
  int arg5 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::dft_chunk *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::volume_list *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__volume_list, 2, 0);
  }
  {
    arg3 = (double) scm_num2dbl(argv[2], FUNC_NAME);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  {
    arg5 = (int) scm_num2int(argv[4], SCM_ARG1, FUNC_NAME);
  }
  result = (meep::dft_chunk *)(arg1)->add_dft((meep::volume_list const *)arg2,arg3,arg4,arg5);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__dft_chunk, 0);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_dft(SCM rest)
{
#define FUNC_NAME "meep-fields-add-dft"
  SCM argv[12];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 12, "meep-fields-add-dft");
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__volume_list, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_real_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_integer_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              return _wrap_meep_fields_add_dft__SWIG_8(argc,argv);
            }
          }
        }
      }
    }
  }
  if (argc == 6) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__volume_list, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_real_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_integer_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              {
                _v = SCM_BOOLP(argv[5]) ? 1 : 0;
              }
              if (_v) {
                return _wrap_meep_fields_add_dft__SWIG_7(argc,argv);
              }
            }
          }
        }
      }
    }
  }
  if (argc == 6) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__volume, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_real_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              {
                _v = SCM_NFALSEP(scm_integer_p(argv[5])) ? 1 : 0;
              }
              if (_v) {
                return _wrap_meep_fields_add_dft__SWIG_6(argc,argv);
              }
            }
          }
        }
      }
    }
  }
  if (argc == 7) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__volume, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_real_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              {
                _v = SCM_NFALSEP(scm_integer_p(argv[5])) ? 1 : 0;
              }
              if (_v) {
                {
                  _v = SCM_BOOLP(argv[6]) ? 1 : 0;
                }
                if (_v) {
                  return _wrap_meep_fields_add_dft__SWIG_5(argc,argv);
                }
              }
            }
          }
        }
      }
    }
  }
  if (argc == 8) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__volume, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_real_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              {
                _v = SCM_NFALSEP(scm_integer_p(argv[5])) ? 1 : 0;
              }
              if (_v) {
                {
                  _v = SCM_BOOLP(argv[6]) ? 1 : 0;
                }
                if (_v) {
                  {
                    _v = SwigComplex_Check(argv[7]);
                  }
                  if (_v) {
                    return _wrap_meep_fields_add_dft__SWIG_4(argc,argv);
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  if (argc == 9) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__volume, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_real_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              {
                _v = SCM_NFALSEP(scm_integer_p(argv[5])) ? 1 : 0;
              }
              if (_v) {
                {
                  _v = SCM_BOOLP(argv[6]) ? 1 : 0;
                }
                if (_v) {
                  {
                    _v = SwigComplex_Check(argv[7]);
                  }
                  if (_v) {
                    {
                      void *ptr;
                      int res = SWIG_ConvertPtr(argv[8], &ptr, SWIGTYPE_p_meep__dft_chunk, 0);
                      _v = SWIG_CheckState(res);
                    }
                    if (_v) {
                      return _wrap_meep_fields_add_dft__SWIG_3(argc,argv);
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  if (argc == 10) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__volume, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_real_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              {
                _v = SCM_NFALSEP(scm_integer_p(argv[5])) ? 1 : 0;
              }
              if (_v) {
                {
                  _v = SCM_BOOLP(argv[6]) ? 1 : 0;
                }
                if (_v) {
                  {
                    _v = SwigComplex_Check(argv[7]);
                  }
                  if (_v) {
                    {
                      void *ptr;
                      int res = SWIG_ConvertPtr(argv[8], &ptr, SWIGTYPE_p_meep__dft_chunk, 0);
                      _v = SWIG_CheckState(res);
                    }
                    if (_v) {
                      {
                        _v = SCM_BOOLP(argv[9]) ? 1 : 0;
                      }
                      if (_v) {
                        return _wrap_meep_fields_add_dft__SWIG_2(argc,argv);
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  if (argc == 11) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__volume, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_real_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              {
                _v = SCM_NFALSEP(scm_integer_p(argv[5])) ? 1 : 0;
              }
              if (_v) {
                {
                  _v = SCM_BOOLP(argv[6]) ? 1 : 0;
                }
                if (_v) {
                  {
                    _v = SwigComplex_Check(argv[7]);
                  }
                  if (_v) {
                    {
                      void *ptr;
                      int res = SWIG_ConvertPtr(argv[8], &ptr, SWIGTYPE_p_meep__dft_chunk, 0);
                      _v = SWIG_CheckState(res);
                    }
                    if (_v) {
                      {
                        _v = SCM_BOOLP(argv[9]) ? 1 : 0;
                      }
                      if (_v) {
                        {
                          _v = SwigComplex_Check(argv[10]);
                        }
                        if (_v) {
                          return _wrap_meep_fields_add_dft__SWIG_1(argc,argv);
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  if (argc == 12) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__volume, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_real_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              {
                _v = SCM_NFALSEP(scm_integer_p(argv[5])) ? 1 : 0;
              }
              if (_v) {
                {
                  _v = SCM_BOOLP(argv[6]) ? 1 : 0;
                }
                if (_v) {
                  {
                    _v = SwigComplex_Check(argv[7]);
                  }
                  if (_v) {
                    {
                      void *ptr;
                      int res = SWIG_ConvertPtr(argv[8], &ptr, SWIGTYPE_p_meep__dft_chunk, 0);
                      _v = SWIG_CheckState(res);
                    }
                    if (_v) {
                      {
                        _v = SCM_BOOLP(argv[9]) ? 1 : 0;
                      }
                      if (_v) {
                        {
                          _v = SwigComplex_Check(argv[10]);
                        }
                        if (_v) {
                          {
                            _v = SCM_BOOLP(argv[11]) ? 1 : 0;
                          }
                          if (_v) {
                            return _wrap_meep_fields_add_dft__SWIG_0(argc,argv);
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-fields-add-dft", "No matching method for generic function `meep_fields_add_dft'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_update_dfts (SCM s_0)
{
#define FUNC_NAME "meep-fields-update-dfts"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  (arg1)->update_dfts();
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_dft_flux__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-add-dft-flux"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::direction arg2 ;
  meep::volume *arg3 = 0 ;
  double arg4 ;
  double arg5 ;
  int arg6 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  SwigValueWrapper< meep::dft_flux > result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::direction) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::volume *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__volume, 3, 0);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  {
    arg5 = (double) scm_num2dbl(argv[4], FUNC_NAME);
  }
  {
    arg6 = (int) scm_num2int(argv[5], SCM_ARG1, FUNC_NAME);
  }
  result = (arg1)->add_dft_flux(arg2,(meep::volume const &)*arg3,arg4,arg5,arg6);
  {
    meep::dft_flux * resultptr;
    resultptr = new meep::dft_flux((const meep::dft_flux &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__dft_flux, 1);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_dft_flux_box (SCM s_0, SCM s_1, SCM s_2, SCM s_3, SCM s_4)
{
#define FUNC_NAME "meep-fields-add-dft-flux-box"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::volume *arg2 = 0 ;
  double arg3 ;
  double arg4 ;
  int arg5 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  SwigValueWrapper< meep::dft_flux > result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::volume *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__volume, 2, 0);
  }
  {
    arg3 = (double) scm_num2dbl(s_2, FUNC_NAME);
  }
  {
    arg4 = (double) scm_num2dbl(s_3, FUNC_NAME);
  }
  {
    arg5 = (int) scm_num2int(s_4, SCM_ARG1, FUNC_NAME);
  }
  result = (arg1)->add_dft_flux_box((meep::volume const &)*arg2,arg3,arg4,arg5);
  {
    meep::dft_flux * resultptr;
    resultptr = new meep::dft_flux((const meep::dft_flux &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__dft_flux, 1);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_dft_flux_plane (SCM s_0, SCM s_1, SCM s_2, SCM s_3, SCM s_4)
{
#define FUNC_NAME "meep-fields-add-dft-flux-plane"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::volume *arg2 = 0 ;
  double arg3 ;
  double arg4 ;
  int arg5 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  SwigValueWrapper< meep::dft_flux > result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::volume *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__volume, 2, 0);
  }
  {
    arg3 = (double) scm_num2dbl(s_2, FUNC_NAME);
  }
  {
    arg4 = (double) scm_num2dbl(s_3, FUNC_NAME);
  }
  {
    arg5 = (int) scm_num2int(s_4, SCM_ARG1, FUNC_NAME);
  }
  result = (arg1)->add_dft_flux_plane((meep::volume const &)*arg2,arg3,arg4,arg5);
  {
    meep::dft_flux * resultptr;
    resultptr = new meep::dft_flux((const meep::dft_flux &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__dft_flux, 1);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_dft_flux__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-add-dft-flux"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::volume_list *arg2 = (meep::volume_list *) 0 ;
  double arg3 ;
  double arg4 ;
  int arg5 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  SwigValueWrapper< meep::dft_flux > result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::volume_list *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__volume_list, 2, 0);
  }
  {
    arg3 = (double) scm_num2dbl(argv[2], FUNC_NAME);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  {
    arg5 = (int) scm_num2int(argv[4], SCM_ARG1, FUNC_NAME);
  }
  result = (arg1)->add_dft_flux((meep::volume_list const *)arg2,arg3,arg4,arg5);
  {
    meep::dft_flux * resultptr;
    resultptr = new meep::dft_flux((const meep::dft_flux &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__dft_flux, 1);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_dft_flux(SCM rest)
{
#define FUNC_NAME "meep-fields-add-dft-flux"
  SCM argv[6];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 6, "meep-fields-add-dft-flux");
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__volume_list, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_real_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_integer_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              return _wrap_meep_fields_add_dft_flux__SWIG_1(argc,argv);
            }
          }
        }
      }
    }
  }
  if (argc == 6) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__volume, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_real_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              {
                _v = SCM_NFALSEP(scm_integer_p(argv[5])) ? 1 : 0;
              }
              if (_v) {
                return _wrap_meep_fields_add_dft_flux__SWIG_0(argc,argv);
              }
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-fields-add-dft-flux", "No matching method for generic function `meep_fields_add_dft_flux'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_dft_force (SCM s_0, SCM s_1, SCM s_2, SCM s_3, SCM s_4)
{
#define FUNC_NAME "meep-fields-add-dft-force"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::volume_list *arg2 = (meep::volume_list *) 0 ;
  double arg3 ;
  double arg4 ;
  int arg5 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  SwigValueWrapper< meep::dft_force > result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::volume_list *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__volume_list, 2, 0);
  }
  {
    arg3 = (double) scm_num2dbl(s_2, FUNC_NAME);
  }
  {
    arg4 = (double) scm_num2dbl(s_3, FUNC_NAME);
  }
  {
    arg5 = (int) scm_num2int(s_4, SCM_ARG1, FUNC_NAME);
  }
  result = (arg1)->add_dft_force((meep::volume_list const *)arg2,arg3,arg4,arg5);
  {
    meep::dft_force * resultptr;
    resultptr = new meep::dft_force((const meep::dft_force &) result);
    gswig_result =  SWIG_NewPointerObj (resultptr, SWIGTYPE_p_meep__dft_force, 1);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_get_chi1inv (SCM s_0, SCM s_1, SCM s_2, SCM s_3)
{
#define FUNC_NAME "meep-fields-get-chi1inv"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::component arg2 ;
  meep::direction arg3 ;
  meep::vec *arg4 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::direction) scm_num2int(s_2, SCM_ARG1, FUNC_NAME); 
  }
  
  meep::vec vec__arg4 = vector3_to_vec(ctl_convert_vector3_to_c(s_3));
  arg4 = &vec__arg4;
  
  result = (double)((meep::fields const *)arg1)->get_chi1inv(arg2,arg3,(meep::vec const &)*arg4);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_get_inveps (SCM s_0, SCM s_1, SCM s_2, SCM s_3)
{
#define FUNC_NAME "meep-fields-get-inveps"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::component arg2 ;
  meep::direction arg3 ;
  meep::vec *arg4 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::direction) scm_num2int(s_2, SCM_ARG1, FUNC_NAME); 
  }
  
  meep::vec vec__arg4 = vector3_to_vec(ctl_convert_vector3_to_c(s_3));
  arg4 = &vec__arg4;
  
  result = (double)((meep::fields const *)arg1)->get_inveps(arg2,arg3,(meep::vec const &)*arg4);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_get_eps (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-get-eps"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::vec *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  
  meep::vec vec__arg2 = vector3_to_vec(ctl_convert_vector3_to_c(s_1));
  arg2 = &vec__arg2;
  
  result = (double)((meep::fields const *)arg1)->get_eps((meep::vec const &)*arg2);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_get_mu (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-get-mu"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::vec *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  
  meep::vec vec__arg2 = vector3_to_vec(ctl_convert_vector3_to_c(s_1));
  arg2 = &vec__arg2;
  
  result = (double)((meep::fields const *)arg1)->get_mu((meep::vec const &)*arg2);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_get_point (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-fields-get-point"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::monitor_point *arg2 = (meep::monitor_point *) 0 ;
  meep::vec *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::monitor_point *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__monitor_point, 2, 0);
  }
  
  meep::vec vec__arg3 = vector3_to_vec(ctl_convert_vector3_to_c(s_2));
  arg3 = &vec__arg3;
  
  ((meep::fields const *)arg1)->get_point(arg2,(meep::vec const &)*arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_get_new_point__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-get-new-point"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::vec *arg2 = 0 ;
  meep::monitor_point *arg3 = (meep::monitor_point *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::monitor_point *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  
  meep::vec vec__arg2 = vector3_to_vec(ctl_convert_vector3_to_c(argv[1]));
  arg2 = &vec__arg2;
  
  {
    arg3 = (meep::monitor_point *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__monitor_point, 3, 0);
  }
  result = (meep::monitor_point *)((meep::fields const *)arg1)->get_new_point((meep::vec const &)*arg2,arg3);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__monitor_point, 0);
  }
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_get_new_point__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-get-new-point"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::vec *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::monitor_point *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  
  meep::vec vec__arg2 = vector3_to_vec(ctl_convert_vector3_to_c(argv[1]));
  arg2 = &vec__arg2;
  
  result = (meep::monitor_point *)((meep::fields const *)arg1)->get_new_point((meep::vec const &)*arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__monitor_point, 0);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_get_new_point(SCM rest)
{
#define FUNC_NAME "meep-fields-get-new-point"
  SCM argv[3];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "meep-fields-get-new-point");
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SwigVector3_Check(argv[1]);
      }
      if (_v) {
        return _wrap_meep_fields_get_new_point__SWIG_1(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SwigVector3_Check(argv[1]);
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__monitor_point, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_meep_fields_get_new_point__SWIG_0(argc,argv);
        }
      }
    }
  }
  
  scm_misc_error("meep-fields-get-new-point", "No matching method for generic function `meep_fields_get_new_point'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_analytic_chi1 (SCM s_0, SCM s_1, SCM s_2, SCM s_3)
{
#define FUNC_NAME "meep-fields-analytic-chi1"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::component arg2 ;
  double arg3 ;
  meep::vec *arg4 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (double) scm_num2dbl(s_2, FUNC_NAME);
  }
  
  meep::vec vec__arg4 = vector3_to_vec(ctl_convert_vector3_to_c(s_3));
  arg4 = &vec__arg4;
  
  result = ((meep::fields const *)arg1)->analytic_chi1(arg2,arg3,(meep::vec const &)*arg4);
  {
    gswig_result = scm_make_rectangular(scm_make_real((&result)->real()),
      scm_make_real((&result)->imag()));
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_prepare_for_bands__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-prepare-for-bands"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::vec *arg2 = 0 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  double arg6 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  
  meep::vec vec__arg2 = vector3_to_vec(ctl_convert_vector3_to_c(argv[1]));
  arg2 = &vec__arg2;
  
  {
    arg3 = (double) scm_num2dbl(argv[2], FUNC_NAME);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  {
    arg5 = (double) scm_num2dbl(argv[4], FUNC_NAME);
  }
  {
    arg6 = (double) scm_num2dbl(argv[5], FUNC_NAME);
  }
  (arg1)->prepare_for_bands((meep::vec const &)*arg2,arg3,arg4,arg5,arg6);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_prepare_for_bands__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-prepare-for-bands"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::vec *arg2 = 0 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  
  meep::vec vec__arg2 = vector3_to_vec(ctl_convert_vector3_to_c(argv[1]));
  arg2 = &vec__arg2;
  
  {
    arg3 = (double) scm_num2dbl(argv[2], FUNC_NAME);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  {
    arg5 = (double) scm_num2dbl(argv[4], FUNC_NAME);
  }
  (arg1)->prepare_for_bands((meep::vec const &)*arg2,arg3,arg4,arg5);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_prepare_for_bands__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-prepare-for-bands"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::vec *arg2 = 0 ;
  double arg3 ;
  double arg4 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  
  meep::vec vec__arg2 = vector3_to_vec(ctl_convert_vector3_to_c(argv[1]));
  arg2 = &vec__arg2;
  
  {
    arg3 = (double) scm_num2dbl(argv[2], FUNC_NAME);
  }
  {
    arg4 = (double) scm_num2dbl(argv[3], FUNC_NAME);
  }
  (arg1)->prepare_for_bands((meep::vec const &)*arg2,arg3,arg4);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_prepare_for_bands__SWIG_3 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-prepare-for-bands"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::vec *arg2 = 0 ;
  double arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  
  meep::vec vec__arg2 = vector3_to_vec(ctl_convert_vector3_to_c(argv[1]));
  arg2 = &vec__arg2;
  
  {
    arg3 = (double) scm_num2dbl(argv[2], FUNC_NAME);
  }
  (arg1)->prepare_for_bands((meep::vec const &)*arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_prepare_for_bands(SCM rest)
{
#define FUNC_NAME "meep-fields-prepare-for-bands"
  SCM argv[6];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 6, "meep-fields-prepare-for-bands");
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SwigVector3_Check(argv[1]);
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_real_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_fields_prepare_for_bands__SWIG_3(argc,argv);
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SwigVector3_Check(argv[1]);
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_real_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            return _wrap_meep_fields_prepare_for_bands__SWIG_2(argc,argv);
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SwigVector3_Check(argv[1]);
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_real_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_real_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              return _wrap_meep_fields_prepare_for_bands__SWIG_1(argc,argv);
            }
          }
        }
      }
    }
  }
  if (argc == 6) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SwigVector3_Check(argv[1]);
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_real_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_real_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            {
              _v = SCM_NFALSEP(scm_real_p(argv[4])) ? 1 : 0;
            }
            if (_v) {
              {
                _v = SCM_NFALSEP(scm_real_p(argv[5])) ? 1 : 0;
              }
              if (_v) {
                return _wrap_meep_fields_prepare_for_bands__SWIG_0(argc,argv);
              }
            }
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-fields-prepare-for-bands", "No matching method for generic function `meep_fields_prepare_for_bands'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_record_bands (SCM s_0)
{
#define FUNC_NAME "meep-fields-record-bands"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  (arg1)->record_bands();
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_get_band__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-get-band"
  meep::fields *arg1 = (meep::fields *) 0 ;
  int arg2 ;
  int arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME);
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  result = (arg1)->get_band(arg2,arg3);
  {
    gswig_result = scm_make_rectangular(scm_make_real((&result)->real()),
      scm_make_real((&result)->imag()));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_get_band__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-get-band"
  meep::fields *arg1 = (meep::fields *) 0 ;
  int arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME);
  }
  result = (arg1)->get_band(arg2);
  {
    gswig_result = scm_make_rectangular(scm_make_real((&result)->real()),
      scm_make_real((&result)->imag()));
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_get_band(SCM rest)
{
#define FUNC_NAME "meep-fields-get-band"
  SCM argv[3];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "meep-fields-get-band");
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        return _wrap_meep_fields_get_band__SWIG_1(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_fields_get_band__SWIG_0(argc,argv);
        }
      }
    }
  }
  
  scm_misc_error("meep-fields-get-band", "No matching method for generic function `meep_fields_get_band'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_grace_bands__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-grace-bands"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::grace *arg2 = (meep::grace *) 0 ;
  int arg3 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::grace *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__grace, 2, 0);
  }
  {
    arg3 = (int) scm_num2int(argv[2], SCM_ARG1, FUNC_NAME);
  }
  (arg1)->grace_bands(arg2,arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_grace_bands__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-grace-bands"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::grace *arg2 = (meep::grace *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::grace *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__grace, 2, 0);
  }
  (arg1)->grace_bands(arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_grace_bands(SCM rest)
{
#define FUNC_NAME "meep-fields-grace-bands"
  SCM argv[3];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "meep-fields-grace-bands");
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__grace, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_meep_fields_grace_bands__SWIG_1(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__grace, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_NFALSEP(scm_integer_p(argv[2])) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_fields_grace_bands__SWIG_0(argc,argv);
        }
      }
    }
  }
  
  scm_misc_error("meep-fields-grace-bands", "No matching method for generic function `meep_fields_grace_bands'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_output_bands__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-output-bands"
  meep::fields *arg1 = (meep::fields *) 0 ;
  FILE *arg2 = (FILE *) 0 ;
  char *arg3 = (char *) 0 ;
  int arg4 ;
  int must_free3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (FILE *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_FILE, 2, 0);
  }
  {
    arg3 = (char *)SWIG_scm2str(argv[2]);
    must_free3 = 1;
  }
  {
    arg4 = (int) scm_num2int(argv[3], SCM_ARG1, FUNC_NAME);
  }
  (arg1)->output_bands(arg2,(char const *)arg3,arg4);
  gswig_result = SCM_UNSPECIFIED;
  
  
  if (must_free3 && arg3) SWIG_free(arg3);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_output_bands__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-output-bands"
  meep::fields *arg1 = (meep::fields *) 0 ;
  FILE *arg2 = (FILE *) 0 ;
  char *arg3 = (char *) 0 ;
  int must_free3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (FILE *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_FILE, 2, 0);
  }
  {
    arg3 = (char *)SWIG_scm2str(argv[2]);
    must_free3 = 1;
  }
  (arg1)->output_bands(arg2,(char const *)arg3);
  gswig_result = SCM_UNSPECIFIED;
  
  
  if (must_free3 && arg3) SWIG_free(arg3);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_output_bands(SCM rest)
{
#define FUNC_NAME "meep-fields-output-bands"
  SCM argv[4];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 4, "meep-fields-output-bands");
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FILE, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_STRINGP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          return _wrap_meep_fields_output_bands__SWIG_1(argc,argv);
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_FILE, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          _v = SCM_STRINGP(argv[2]) ? 1 : 0;
        }
        if (_v) {
          {
            _v = SCM_NFALSEP(scm_integer_p(argv[3])) ? 1 : 0;
          }
          if (_v) {
            return _wrap_meep_fields_output_bands__SWIG_0(argc,argv);
          }
        }
      }
    }
  }
  
  scm_misc_error("meep-fields-output-bands", "No matching method for generic function `meep_fields_output_bands'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_get_field__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-get-field"
  meep::fields *arg1 = (meep::fields *) 0 ;
  int arg2 ;
  meep::vec *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME);
  }
  
  meep::vec vec__arg3 = vector3_to_vec(ctl_convert_vector3_to_c(argv[2]));
  arg3 = &vec__arg3;
  
  result = ((meep::fields const *)arg1)->get_field(arg2,(meep::vec const &)*arg3);
  {
    gswig_result = scm_make_rectangular(scm_make_real((&result)->real()),
      scm_make_real((&result)->imag()));
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_get_field__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-get-field"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::component arg2 ;
  meep::vec *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  
  meep::vec vec__arg3 = vector3_to_vec(ctl_convert_vector3_to_c(argv[2]));
  arg3 = &vec__arg3;
  
  result = ((meep::fields const *)arg1)->get_field(arg2,(meep::vec const &)*arg3);
  {
    gswig_result = scm_make_rectangular(scm_make_real((&result)->real()),
      scm_make_real((&result)->imag()));
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_get_field__SWIG_2 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-get-field"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::derived_component arg2 ;
  meep::vec *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::derived_component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  
  meep::vec vec__arg3 = vector3_to_vec(ctl_convert_vector3_to_c(argv[2]));
  arg3 = &vec__arg3;
  
  result = (double)((meep::fields const *)arg1)->get_field(arg2,(meep::vec const &)*arg3);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_get_field(SCM rest)
{
#define FUNC_NAME "meep-fields-get-field"
  SCM argv[3];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "meep-fields-get-field");
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SwigVector3_Check(argv[2]);
        }
        if (_v) {
          return _wrap_meep_fields_get_field__SWIG_0(argc,argv);
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SwigVector3_Check(argv[2]);
        }
        if (_v) {
          return _wrap_meep_fields_get_field__SWIG_1(argc,argv);
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          _v = SwigVector3_Check(argv[2]);
        }
        if (_v) {
          return _wrap_meep_fields_get_field__SWIG_2(argc,argv);
        }
      }
    }
  }
  
  scm_misc_error("meep-fields-get-field", "No matching method for generic function `meep_fields_get_field'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_synchronize_magnetic_fields (SCM s_0)
{
#define FUNC_NAME "meep-fields-synchronize-magnetic-fields"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  (arg1)->synchronize_magnetic_fields();
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_restore_magnetic_fields (SCM s_0)
{
#define FUNC_NAME "meep-fields-restore-magnetic-fields"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  (arg1)->restore_magnetic_fields();
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_energy_in_box (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-energy-in-box"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::volume *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::volume *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__volume, 2, 0);
  }
  result = (double)(arg1)->energy_in_box((meep::volume const &)*arg2);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_electric_energy_in_box (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-electric-energy-in-box"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::volume *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::volume *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__volume, 2, 0);
  }
  result = (double)(arg1)->electric_energy_in_box((meep::volume const &)*arg2);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_magnetic_energy_in_box (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-magnetic-energy-in-box"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::volume *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::volume *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__volume, 2, 0);
  }
  result = (double)(arg1)->magnetic_energy_in_box((meep::volume const &)*arg2);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_thermo_energy_in_box (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-thermo-energy-in-box"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::volume *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::volume *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__volume, 2, 0);
  }
  result = (double)(arg1)->thermo_energy_in_box((meep::volume const &)*arg2);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_total_energy (SCM s_0)
{
#define FUNC_NAME "meep-fields-total-energy"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (double)(arg1)->total_energy();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_field_energy_in_box__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-field-energy-in-box"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::volume *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::volume *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__volume, 2, 0);
  }
  result = (double)(arg1)->field_energy_in_box((meep::volume const &)*arg2);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_field_energy_in_box__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-field-energy-in-box"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::component arg2 ;
  meep::volume *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::volume *)SWIG_MustGetPtr(argv[2], SWIGTYPE_p_meep__volume, 3, 0);
  }
  result = (double)(arg1)->field_energy_in_box(arg2,(meep::volume const &)*arg3);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_field_energy_in_box(SCM rest)
{
#define FUNC_NAME "meep-fields-field-energy-in-box"
  SCM argv[3];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "meep-fields-field-energy-in-box");
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__volume, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_meep_fields_field_energy_in_box__SWIG_0(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        {
          void *ptr;
          int res = SWIG_ConvertPtr(argv[2], &ptr, SWIGTYPE_p_meep__volume, 0);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_meep_fields_field_energy_in_box__SWIG_1(argc,argv);
        }
      }
    }
  }
  
  scm_misc_error("meep-fields-field-energy-in-box", "No matching method for generic function `meep_fields_field_energy_in_box'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_field_energy (SCM s_0)
{
#define FUNC_NAME "meep-fields-field-energy"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (double)(arg1)->field_energy();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_flux_in_box_wrongH (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-fields-flux-in-box-wrongH"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::direction arg2 ;
  meep::volume *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::direction) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::volume *)SWIG_MustGetPtr(s_2, SWIGTYPE_p_meep__volume, 3, 0);
  }
  result = (double)(arg1)->flux_in_box_wrongH(arg2,(meep::volume const &)*arg3);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_flux_in_box (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-fields-flux-in-box"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::direction arg2 ;
  meep::volume *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::direction) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::volume *)SWIG_MustGetPtr(s_2, SWIGTYPE_p_meep__volume, 3, 0);
  }
  result = (double)(arg1)->flux_in_box(arg2,(meep::volume const &)*arg3);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_flux_vol (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-fields-add-flux-vol"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::direction arg2 ;
  meep::volume *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::flux_vol *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::direction) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg3 = (meep::volume *)SWIG_MustGetPtr(s_2, SWIGTYPE_p_meep__volume, 3, 0);
  }
  result = (meep::flux_vol *)(arg1)->add_flux_vol(arg2,(meep::volume const &)*arg3);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__flux_vol, 0);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_flux_plane__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-add-flux-plane"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::volume *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::flux_vol *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::volume *)SWIG_MustGetPtr(argv[1], SWIGTYPE_p_meep__volume, 2, 0);
  }
  result = (meep::flux_vol *)(arg1)->add_flux_plane((meep::volume const &)*arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__flux_vol, 0);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_flux_plane__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-add-flux-plane"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::vec *arg2 = 0 ;
  meep::vec *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::flux_vol *result = 0 ;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  
  meep::vec vec__arg2 = vector3_to_vec(ctl_convert_vector3_to_c(argv[1]));
  arg2 = &vec__arg2;
  
  
  meep::vec vec__arg3 = vector3_to_vec(ctl_convert_vector3_to_c(argv[2]));
  arg3 = &vec__arg3;
  
  result = (meep::flux_vol *)(arg1)->add_flux_plane((meep::vec const &)*arg2,(meep::vec const &)*arg3);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_meep__flux_vol, 0);
  }
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_add_flux_plane(SCM rest)
{
#define FUNC_NAME "meep-fields-add-flux-plane"
  SCM argv[3];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 3, "meep-fields-add-flux-plane");
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        void *ptr;
        int res = SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_meep__volume, 0);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_meep_fields_add_flux_plane__SWIG_0(argc,argv);
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SwigVector3_Check(argv[1]);
      }
      if (_v) {
        {
          _v = SwigVector3_Check(argv[2]);
        }
        if (_v) {
          return _wrap_meep_fields_add_flux_plane__SWIG_1(argc,argv);
        }
      }
    }
  }
  
  scm_misc_error("meep-fields-add-flux-plane", "No matching method for generic function `meep_fields_add_flux_plane'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_electric_energy_max_in_box (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-electric-energy-max-in-box"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::volume *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::volume *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__volume, 2, 0);
  }
  result = (double)(arg1)->electric_energy_max_in_box((meep::volume const &)*arg2);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_modal_volume_in_box (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-modal-volume-in-box"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::volume *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::volume *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__volume, 2, 0);
  }
  result = (double)(arg1)->modal_volume_in_box((meep::volume const &)*arg2);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_electric_sqr_weighted_integral (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-fields-electric-sqr-weighted-integral"
  meep::fields *arg1 = (meep::fields *) 0 ;
  double (*arg2)(meep::vec const &) = (double (*)(meep::vec const &)) 0 ;
  meep::volume *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (double (*)(meep::vec const &))SWIG_MustGetPtr(s_1, SWIGTYPE_p_f_r_q_const__meep__vec__double, 2, 0);
  }
  {
    arg3 = (meep::volume *)SWIG_MustGetPtr(s_2, SWIGTYPE_p_meep__volume, 3, 0);
  }
  result = (double)(arg1)->electric_sqr_weighted_integral(arg2,(meep::volume const &)*arg3);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_electric_energy_weighted_integral (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "meep-fields-electric-energy-weighted-integral"
  meep::fields *arg1 = (meep::fields *) 0 ;
  double (*arg2)(meep::vec const &) = (double (*)(meep::vec const &)) 0 ;
  meep::volume *arg3 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (double (*)(meep::vec const &))SWIG_MustGetPtr(s_1, SWIGTYPE_p_f_r_q_const__meep__vec__double, 2, 0);
  }
  {
    arg3 = (meep::volume *)SWIG_MustGetPtr(s_2, SWIGTYPE_p_meep__volume, 3, 0);
  }
  result = (double)(arg1)->electric_energy_weighted_integral(arg2,(meep::volume const &)*arg3);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_set_output_directory (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-set-output-directory"
  meep::fields *arg1 = (meep::fields *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  (arg1)->set_output_directory((char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_verbose__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-verbose"
  meep::fields *arg1 = (meep::fields *) 0 ;
  int arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (int) scm_num2int(argv[1], SCM_ARG1, FUNC_NAME);
  }
  (arg1)->verbose(arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_verbose__SWIG_1 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-verbose"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_meep__fields, 1, 0);
  }
  (arg1)->verbose();
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_verbose(SCM rest)
{
#define FUNC_NAME "meep-fields-verbose"
  SCM argv[2];
  int argc = SWIG_Guile_GetArgs (argv, rest, 0, 2, "meep-fields-verbose");
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      return _wrap_meep_fields_verbose__SWIG_1(argc,argv);
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      int res = SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_meep__fields, 0);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        _v = SCM_NFALSEP(scm_integer_p(argv[1])) ? 1 : 0;
      }
      if (_v) {
        return _wrap_meep_fields_verbose__SWIG_0(argc,argv);
      }
    }
  }
  
  scm_misc_error("meep-fields-verbose", "No matching method for generic function `meep_fields_verbose'", SCM_EOL);
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_count_volume (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-count-volume"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::component arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = (double)(arg1)->count_volume(arg2);
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_have_component (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-have-component"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::component arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::component) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = (bool)(arg1)->have_component(arg2);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_max_eps (SCM s_0)
{
#define FUNC_NAME "meep-fields-max-eps"
  meep::fields *arg1 = (meep::fields *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  double result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  result = (double)((meep::fields const *)arg1)->max_eps();
  {
    gswig_result = scm_make_real(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_step_boundaries (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-step-boundaries"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::field_type arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::field_type) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  (arg1)->step_boundaries(arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_nosize_direction (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-nosize-direction"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::direction arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  bool result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::direction) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = (bool)((meep::fields const *)arg1)->nosize_direction(arg2);
  {
    gswig_result = SCM_BOOL(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_normal_direction (SCM s_0, SCM s_1)
{
#define FUNC_NAME "meep-fields-normal-direction"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::volume *arg2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  meep::direction result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_meep__fields, 1, 0);
  }
  {
    arg2 = (meep::volume *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_meep__volume, 2, 0);
  }
  result = (meep::direction)((meep::fields const *)arg1)->normal_direction((meep::volume const &)*arg2);
  {
    gswig_result = scm_long2num(result); 
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_meep_fields_casimir_stress_dct_integral__SWIG_0 (int argc, SCM *argv)
{
#define FUNC_NAME "meep-fields-casimir-stress-dct-integral"
  meep::fields *arg1 = (meep::fields *) 0 ;
  meep::direction arg2 ;
  meep::direction arg3 ;
  double arg4 ;
  double arg5 ;
  double arg6 ;
  meep::field_type arg7 ;
  SwigValueWrapper< meep::volume > arg8 ;
  bool arg9 ;
  meep::volume *argp8 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  complex< double > result;
  
  {
    arg1 = (meep::fields *)SWIG_MustGetPtr(argv[0], SWIGTYPE_p_m