#ifndef _COMPAT_LINUX_FS_H
#define _COMPAT_LINUX_FS_H

/* Include the autogenerated header file */
#include "../../compat/config.h"

#include_next <linux/fs.h>

#if !defined(CONFIG_COMPAT) || !defined(HAVE_COMPAT_PTR_IOCTL_EXPORTED) 
#define compat_ptr_ioctl NULL
#else
extern long compat_ptr_ioctl(struct file *file, unsigned int cmd,
		                                        unsigned long arg);
#endif /*CONFIG_COMPAT*/

#ifndef get_file_rcu
#define get_file_rcu_many(x, cnt)       \
        atomic_long_add_unless(&(x)->f_count, (cnt), 0)
#define get_file_rcu(x) get_file_rcu_many((x), 1)
#endif

#endif /* _COMPAT_LINUX_FS_H */
