/*
 * This file is part of Flowplayer, http://flowplayer.org
 *
 * By: Daniel Rossi, <electroteque@gmail.com>, Anssi Piirainen Flowplayer Oy
 * Copyright (c) 2008-2011 Flowplayer Oy *
 * Released under the MIT License:
 * http://www.opensource.org/licenses/mit-license.php
 */

package org.flowplayer.bitrateselect.config {
    import flash.system.Capabilities;

    import org.flowplayer.bitrateselect.config.HDButtonConfig;
    import org.flowplayer.bitrateselect.config.IconConfig;

    import org.flowplayer.ui.buttons.TooltipButtonConfig;
    import org.flowplayer.util.PropertyBinder;

    public class Config {

        private var _icons:IconConfig = new IconConfig();
        private var _hdButton:HDButtonConfig = new HDButtonConfig();
        private var _menu:Boolean = false;
        private var _menuPluginName:String = "menu";
        private var _controlsPlugin:String = "controls";

        public function set icons(config:Object):void {
            new PropertyBinder(_icons.buttons).copyProperties(config);
        }

        public function get iconConfig():TooltipButtonConfig {
            return _icons.buttons;
        }

        public function get hdButton():HDButtonConfig {
            return _hdButton;
        }

        public function setHdButton(value:Object):void {
            if (value is String || value is Boolean) {
                _hdButton.place = value;
                return;
            }
            new PropertyBinder(_hdButton).copyProperties(value);
        }

        public function get menu():Boolean {
            return _menu;
        }

        public function set menu(value:Boolean):void {
            _menu = value;
            if (_menu) {
                // disable the button
                _hdButton.place = "none";
            }
        }

        public function get menuPluginName():String {
            return _menuPluginName;
        }

        public function set menuPluginName(value:String):void {
            _menuPluginName = value;
        }

        public function set controlsPlugin(value:String):void {
            _controlsPlugin = value;
        }

        public function get controlsPlugin():String {
            return _controlsPlugin;
        }
    }
}
