! Molecular Orbital PACkage (MOPAC)
! Copyright 2021 Virginia Polytechnic Institute and State University
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!    http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.

subroutine copyc6(maxc,max_elem,c6ab,maxci)
implicit none
integer :: maxc,max_elem,maxci(max_elem),nlines
double precision :: c6ab(max_elem,max_elem,maxc,maxc,3)
integer :: iat,jat, iadr,jadr,nn,kk
double precision :: pars(161925)
  nlines = 32385
  data pars(     1:     5) /  1,  1,   0.30267000D+01,   0.91180D+00,   0.91180D+00/
  data pars(     6:    10) /  2,  1,   0.20835000D+01,   0.00000D+00,   0.91180D+00/
  data pars(    11:    15) /  2,  2,   0.15583000D+01,   0.00000D+00,   0.00000D+00/
  data pars(    16:    20) /  3,  1,   0.38944800D+02,   0.00000D+00,   0.91180D+00/
  data pars(    21:    25) /  3,  2,   0.22150800D+02,   0.00000D+00,   0.00000D+00/
  data pars(    26:    30) /  3,  3,   0.11634454D+04,   0.00000D+00,   0.00000D+00/
  data pars(    31:    35) /  4,  1,   0.24441500D+02,   0.00000D+00,   0.91180D+00/
  data pars(    36:    40) /  4,  2,   0.14824600D+02,   0.00000D+00,   0.00000D+00/
  data pars(    41:    45) /  4,  3,   0.49461900D+03,   0.00000D+00,   0.00000D+00/
  data pars(    46:    50) /  4,  4,   0.25748630D+03,   0.00000D+00,   0.00000D+00/
  data pars(    51:    55) /  5,  1,   0.17314300D+02,   0.00000D+00,   0.91180D+00/
  data pars(    56:    60) /  5,  2,   0.11097500D+02,   0.00000D+00,   0.00000D+00/
  data pars(    61:    65) /  5,  3,   0.28373080D+03,   0.00000D+00,   0.00000D+00/
  data pars(    66:    70) /  5,  4,   0.16159710D+03,   0.00000D+00,   0.00000D+00/
  data pars(    71:    75) /  5,  5,   0.10717770D+03,   0.00000D+00,   0.00000D+00/
  data pars(    76:    80) /  6,  1,   0.12140200D+02,   0.00000D+00,   0.91180D+00/
  data pars(    81:    85) /  6,  2,   0.81841000D+01,   0.00000D+00,   0.00000D+00/
  data pars(    86:    90) /  6,  3,   0.16990300D+03,   0.00000D+00,   0.00000D+00/
  data pars(    91:    95) /  6,  4,   0.10295600D+03,   0.00000D+00,   0.00000D+00/
  data pars(    96:   100) /  6,  5,   0.71279400D+02,   0.00000D+00,   0.00000D+00/
  data pars(   101:   105) /  6,  6,   0.49113000D+02,   0.00000D+00,   0.00000D+00/
  data pars(   106:   110) /  7,  1,   0.87171000D+01,   0.00000D+00,   0.91180D+00/
  data pars(   111:   115) /  7,  2,   0.61380000D+01,   0.00000D+00,   0.00000D+00/
  data pars(   116:   120) /  7,  3,   0.10848540D+03,   0.00000D+00,   0.00000D+00/
  data pars(   121:   125) /  7,  4,   0.68645800D+02,   0.00000D+00,   0.00000D+00/
  data pars(   126:   130) /  7,  5,   0.49113200D+02,   0.00000D+00,   0.00000D+00/
  data pars(   131:   135) /  7,  6,   0.34814600D+02,   0.00000D+00,   0.00000D+00/
  data pars(   136:   140) /  7,  7,   0.25268500D+02,   0.00000D+00,   0.00000D+00/
  data pars(   141:   145) /  8,  1,   0.67180000D+01,   0.00000D+00,   0.91180D+00/
  data pars(   146:   150) /  8,  2,   0.48949000D+01,   0.00000D+00,   0.00000D+00/
  data pars(   151:   155) /  8,  3,   0.76961300D+02,   0.00000D+00,   0.00000D+00/
  data pars(   156:   160) /  8,  4,   0.50125200D+02,   0.00000D+00,   0.00000D+00/
  data pars(   161:   165) /  8,  5,   0.36724700D+02,   0.00000D+00,   0.00000D+00/
  data pars(   166:   170) /  8,  6,   0.26592900D+02,   0.00000D+00,   0.00000D+00/
  data pars(   171:   175) /  8,  7,   0.19654600D+02,   0.00000D+00,   0.00000D+00/
  data pars(   176:   180) /  8,  8,   0.15505900D+02,   0.00000D+00,   0.00000D+00/
  data pars(   181:   185) /  9,  1,   0.51616000D+01,   0.00000D+00,   0.91180D+00/
  data pars(   186:   190) /  9,  2,   0.38825000D+01,   0.00000D+00,   0.00000D+00/
  data pars(   191:   195) /  9,  3,   0.55093300D+02,   0.00000D+00,   0.00000D+00/
  data pars(   196:   200) /  9,  4,   0.36745300D+02,   0.00000D+00,   0.00000D+00/
  data pars(   201:   205) /  9,  5,   0.27482100D+02,   0.00000D+00,   0.00000D+00/
  data pars(   206:   210) /  9,  6,   0.20282700D+02,   0.00000D+00,   0.00000D+00/
  data pars(   211:   215) /  9,  7,   0.15241800D+02,   0.00000D+00,   0.00000D+00/
  data pars(   216:   220) /  9,  8,   0.12183400D+02,   0.00000D+00,   0.00000D+00/
  data pars(   221:   225) /  9,  9,   0.96916000D+01,   0.00000D+00,   0.00000D+00/
  data pars(   226:   230) / 10,  1,   0.40112000D+01,   0.00000D+00,   0.91180D+00/
  data pars(   231:   235) / 10,  2,   0.31025000D+01,   0.00000D+00,   0.00000D+00/
  data pars(   236:   240) / 10,  3,   0.40473100D+02,   0.00000D+00,   0.00000D+00/
  data pars(   241:   245) / 10,  4,   0.27486700D+02,   0.00000D+00,   0.00000D+00/
  data pars(   246:   250) / 10,  5,   0.20902200D+02,   0.00000D+00,   0.00000D+00/
  data pars(   251:   255) / 10,  6,   0.15674000D+02,   0.00000D+00,   0.00000D+00/
  data pars(   256:   260) / 10,  7,   0.11947900D+02,   0.00000D+00,   0.00000D+00/
  data pars(   261:   265) / 10,  8,   0.96606000D+01,   0.00000D+00,   0.00000D+00/
  data pars(   266:   270) / 10,  9,   0.77691000D+01,   0.00000D+00,   0.00000D+00/
  data pars(   271:   275) / 10, 10,   0.62896000D+01,   0.00000D+00,   0.00000D+00/
  data pars(   276:   280) / 11,  1,   0.46823200D+02,   0.00000D+00,   0.91180D+00/
  data pars(   281:   285) / 11,  2,   0.26862800D+02,   0.00000D+00,   0.00000D+00/
  data pars(   286:   290) / 11,  3,   0.13673272D+04,   0.00000D+00,   0.00000D+00/
  data pars(   291:   295) / 11,  4,   0.58745630D+03,   0.00000D+00,   0.00000D+00/
  data pars(   296:   300) / 11,  5,   0.33872120D+03,   0.00000D+00,   0.00000D+00/
  data pars(   301:   305) / 11,  6,   0.20376310D+03,   0.00000D+00,   0.00000D+00/
  data pars(   306:   310) / 11,  7,   0.13065630D+03,   0.00000D+00,   0.00000D+00/
  data pars(   311:   315) / 11,  8,   0.93026300D+02,   0.00000D+00,   0.00000D+00/
  data pars(   316:   320) / 11,  9,   0.66842300D+02,   0.00000D+00,   0.00000D+00/
  data pars(   321:   325) / 11, 10,   0.49279900D+02,   0.00000D+00,   0.00000D+00/
  data pars(   326:   330) / 11, 11,   0.16080286D+04,   0.00000D+00,   0.00000D+00/
  data pars(   331:   335) / 12,  1,   0.38353100D+02,   0.00000D+00,   0.91180D+00/
  data pars(   336:   340) / 12,  2,   0.23032000D+02,   0.00000D+00,   0.00000D+00/
  data pars(   341:   345) / 12,  3,   0.83081560D+03,   0.00000D+00,   0.00000D+00/
  data pars(   346:   350) / 12,  4,   0.41821640D+03,   0.00000D+00,   0.00000D+00/
  data pars(   351:   355) / 12,  5,   0.25813030D+03,   0.00000D+00,   0.00000D+00/
  data pars(   356:   360) / 12,  6,   0.16260820D+03,   0.00000D+00,   0.00000D+00/
  data pars(   361:   365) / 12,  7,   0.10761500D+03,   0.00000D+00,   0.00000D+00/
  data pars(   366:   370) / 12,  8,   0.78225000D+02,   0.00000D+00,   0.00000D+00/
  data pars(   371:   375) / 12,  9,   0.57160500D+02,   0.00000D+00,   0.00000D+00/
  data pars(   376:   380) / 12, 10,   0.42677100D+02,   0.00000D+00,   0.00000D+00/
  data pars(   381:   385) / 12, 11,   0.98516970D+03,   0.00000D+00,   0.00000D+00/
  data pars(   386:   390) / 12, 12,   0.68337580D+03,   0.00000D+00,   0.00000D+00/
  data pars(   391:   395) / 13,  1,   0.36290900D+02,   0.00000D+00,   0.91180D+00/
  data pars(   396:   400) / 13,  2,   0.22322400D+02,   0.00000D+00,   0.00000D+00/
  data pars(   401:   405) / 13,  3,   0.70582540D+03,   0.00000D+00,   0.00000D+00/
  data pars(   406:   410) / 13,  4,   0.37263020D+03,   0.00000D+00,   0.00000D+00/
  data pars(   411:   415) / 13,  5,   0.23647800D+03,   0.00000D+00,   0.00000D+00/
  data pars(   416:   420) / 13,  6,   0.15209340D+03,   0.00000D+00,   0.00000D+00/
  data pars(   421:   425) / 13,  7,   0.10220000D+03,   0.00000D+00,   0.00000D+00/
  data pars(   426:   430) / 13,  8,   0.75075500D+02,   0.00000D+00,   0.00000D+00/
  data pars(   431:   435) / 13,  9,   0.55341200D+02,   0.00000D+00,   0.00000D+00/
  data pars(   436:   440) / 13, 10,   0.41596600D+02,   0.00000D+00,   0.00000D+00/
  data pars(   441:   445) / 13, 11,   0.83896480D+03,   0.00000D+00,   0.00000D+00/
  data pars(   446:   450) / 13, 12,   0.60346890D+03,   0.00000D+00,   0.00000D+00/
  data pars(   451:   455) / 13, 13,   0.54054060D+03,   0.00000D+00,   0.00000D+00/
  data pars(   456:   460) / 14,  1,   0.29594700D+02,   0.00000D+00,   0.91180D+00/
  data pars(   461:   465) / 14,  2,   0.18850000D+02,   0.00000D+00,   0.00000D+00/
  data pars(   466:   470) / 14,  3,   0.49534490D+03,   0.00000D+00,   0.00000D+00/
  data pars(   471:   475) / 14,  4,   0.27978630D+03,   0.00000D+00,   0.00000D+00/
  data pars(   476:   480) / 14,  5,   0.18451110D+03,   0.00000D+00,   0.00000D+00/
  data pars(   481:   485) / 14,  6,   0.12213870D+03,   0.00000D+00,   0.00000D+00/
  data pars(   486:   490) / 14,  7,   0.83849800D+02,   0.00000D+00,   0.00000D+00/
  data pars(   491:   495) / 14,  8,   0.62534900D+02,   0.00000D+00,   0.00000D+00/
  data pars(   496:   500) / 14,  9,   0.46693600D+02,   0.00000D+00,   0.00000D+00/
  data pars(   501:   505) / 14, 10,   0.35455000D+02,   0.00000D+00,   0.00000D+00/
  data pars(   506:   510) / 14, 11,   0.59104580D+03,   0.00000D+00,   0.00000D+00/
  data pars(   511:   515) / 14, 12,   0.44764230D+03,   0.00000D+00,   0.00000D+00/
  data pars(   516:   520) / 14, 13,   0.40896060D+03,   0.00000D+00,   0.00000D+00/
  data pars(   521:   525) / 14, 14,   0.31785740D+03,   0.00000D+00,   0.00000D+00/
  data pars(   526:   530) / 15,  1,   0.23760400D+02,   0.00000D+00,   0.91180D+00/
  data pars(   531:   535) / 15,  2,   0.15668900D+02,   0.00000D+00,   0.00000D+00/
  data pars(   536:   540) / 15,  3,   0.35080300D+03,   0.00000D+00,   0.00000D+00/
  data pars(   541:   545) / 15,  4,   0.20873310D+03,   0.00000D+00,   0.00000D+00/
  data pars(   546:   550) / 15,  5,   0.14234810D+03,   0.00000D+00,   0.00000D+00/
  data pars(   551:   555) / 15,  6,   0.96750300D+02,   0.00000D+00,   0.00000D+00/
  data pars(   556:   560) / 15,  7,   0.67787300D+02,   0.00000D+00,   0.00000D+00/
  data pars(   561:   565) / 15,  8,   0.51309800D+02,   0.00000D+00,   0.00000D+00/
  data pars(   566:   570) / 15,  9,   0.38808400D+02,   0.00000D+00,   0.00000D+00/
  data pars(   571:   575) / 15, 10,   0.29776700D+02,   0.00000D+00,   0.00000D+00/
  data pars(   576:   580) / 15, 11,   0.42000640D+03,   0.00000D+00,   0.00000D+00/
  data pars(   581:   585) / 15, 12,   0.33078010D+03,   0.00000D+00,   0.00000D+00/
  data pars(   586:   590) / 15, 13,   0.30729650D+03,   0.00000D+00,   0.00000D+00/
  data pars(   591:   595) / 15, 14,   0.24435460D+03,   0.00000D+00,   0.00000D+00/
  data pars(   596:   600) / 15, 15,   0.19168870D+03,   0.00000D+00,   0.00000D+00/
  data pars(   601:   605) / 16,  1,   0.20094800D+02,   0.00000D+00,   0.91180D+00/
  data pars(   606:   610) / 16,  2,   0.13610800D+02,   0.00000D+00,   0.00000D+00/
  data pars(   611:   615) / 16,  3,   0.27378670D+03,   0.00000D+00,   0.00000D+00/
  data pars(   616:   620) / 16,  4,   0.16795130D+03,   0.00000D+00,   0.00000D+00/
  data pars(   621:   625) / 16,  5,   0.11711210D+03,   0.00000D+00,   0.00000D+00/
  data pars(   626:   630) / 16,  6,   0.81091900D+02,   0.00000D+00,   0.00000D+00/
  data pars(   631:   635) / 16,  7,   0.57673400D+02,   0.00000D+00,   0.00000D+00/
  data pars(   636:   640) / 16,  8,   0.44147000D+02,   0.00000D+00,   0.00000D+00/
  data pars(   641:   645) / 16,  9,   0.33726400D+02,   0.00000D+00,   0.00000D+00/
  data pars(   646:   650) / 16, 10,   0.26094000D+02,   0.00000D+00,   0.00000D+00/
  data pars(   651:   655) / 16, 11,   0.32859900D+03,   0.00000D+00,   0.00000D+00/
  data pars(   656:   660) / 16, 12,   0.26466650D+03,   0.00000D+00,   0.00000D+00/
  data pars(   661:   665) / 16, 13,   0.24850080D+03,   0.00000D+00,   0.00000D+00/
  data pars(   666:   670) / 16, 14,   0.20053740D+03,   0.00000D+00,   0.00000D+00/
  data pars(   671:   675) / 16, 15,   0.15948980D+03,   0.00000D+00,   0.00000D+00/
  data pars(   676:   680) / 16, 16,   0.13400660D+03,   0.00000D+00,   0.00000D+00/
  data pars(   681:   685) / 17,  1,   0.16705200D+02,   0.00000D+00,   0.91180D+00/
  data pars(   686:   690) / 17,  2,   0.11630200D+02,   0.00000D+00,   0.00000D+00/
  data pars(   691:   695) / 17,  3,   0.21066260D+03,   0.00000D+00,   0.00000D+00/
  data pars(   696:   700) / 17,  4,   0.13298080D+03,   0.00000D+00,   0.00000D+00/
  data pars(   701:   705) / 17,  5,   0.94761200D+02,   0.00000D+00,   0.00000D+00/
  data pars(   706:   710) / 17,  6,   0.66840700D+02,   0.00000D+00,   0.00000D+00/
  data pars(   711:   715) / 17,  7,   0.48262400D+02,   0.00000D+00,   0.00000D+00/
  data pars(   716:   720) / 17,  8,   0.37368800D+02,   0.00000D+00,   0.00000D+00/
  data pars(   721:   725) / 17,  9,   0.28844500D+02,   0.00000D+00,   0.00000D+00/
  data pars(   726:   730) / 17, 10,   0.22512100D+02,   0.00000D+00,   0.00000D+00/
  data pars(   731:   735) / 17, 11,   0.25351360D+03,   0.00000D+00,   0.00000D+00/
  data pars(   736:   740) / 17, 12,   0.20849780D+03,   0.00000D+00,   0.00000D+00/
  data pars(   741:   745) / 17, 13,   0.19775940D+03,   0.00000D+00,   0.00000D+00/
  data pars(   746:   750) / 17, 14,   0.16186860D+03,   0.00000D+00,   0.00000D+00/
  data pars(   751:   755) / 17, 15,   0.13047250D+03,   0.00000D+00,   0.00000D+00/
  data pars(   756:   760) / 17, 16,   0.11070060D+03,   0.00000D+00,   0.00000D+00/
  data pars(   761:   765) / 17, 17,   0.92346000D+02,   0.00000D+00,   0.00000D+00/
  data pars(   766:   770) / 18,  1,   0.13870000D+02,   0.00000D+00,   0.91180D+00/
  data pars(   771:   775) / 18,  2,   0.99130000D+01,   0.00000D+00,   0.00000D+00/
  data pars(   776:   780) / 18,  3,   0.16354970D+03,   0.00000D+00,   0.00000D+00/
  data pars(   781:   785) / 18,  4,   0.10572290D+03,   0.00000D+00,   0.00000D+00/
  data pars(   786:   790) / 18,  5,   0.76794900D+02,   0.00000D+00,   0.00000D+00/
  data pars(   791:   795) / 18,  6,   0.55089800D+02,   0.00000D+00,   0.00000D+00/
  data pars(   796:   800) / 18,  7,   0.40343500D+02,   0.00000D+00,   0.00000D+00/
  data pars(   801:   805) / 18,  8,   0.31578300D+02,   0.00000D+00,   0.00000D+00/
  data pars(   806:   810) / 18,  9,   0.24617800D+02,   0.00000D+00,   0.00000D+00/
  data pars(   811:   815) / 18, 10,   0.19377400D+02,   0.00000D+00,   0.00000D+00/
  data pars(   816:   820) / 18, 11,   0.19734400D+03,   0.00000D+00,   0.00000D+00/
  data pars(   821:   825) / 18, 12,   0.16510060D+03,   0.00000D+00,   0.00000D+00/
  data pars(   826:   830) / 18, 13,   0.15795950D+03,   0.00000D+00,   0.00000D+00/
  data pars(   831:   835) / 18, 14,   0.13089270D+03,   0.00000D+00,   0.00000D+00/
  data pars(   836:   840) / 18, 15,   0.10676980D+03,   0.00000D+00,   0.00000D+00/
  data pars(   841:   845) / 18, 16,   0.91401400D+02,   0.00000D+00,   0.00000D+00/
  data pars(   846:   850) / 18, 17,   0.76938300D+02,   0.00000D+00,   0.00000D+00/
  data pars(   851:   855) / 18, 18,   0.64646200D+02,   0.00000D+00,   0.00000D+00/
  data pars(   856:   860) / 19,  1,   0.76237600D+02,   0.00000D+00,   0.91180D+00/
  data pars(   861:   865) / 19,  2,   0.44041100D+02,   0.00000D+00,   0.00000D+00/
  data pars(   866:   870) / 19,  3,   0.23871574D+04,   0.00000D+00,   0.00000D+00/
  data pars(   871:   875) / 19,  4,   0.97231970D+03,   0.00000D+00,   0.00000D+00/
  data pars(   876:   880) / 19,  5,   0.55419800D+03,   0.00000D+00,   0.00000D+00/
  data pars(   881:   885) / 19,  6,   0.33226940D+03,   0.00000D+00,   0.00000D+00/
  data pars(   886:   890) / 19,  7,   0.21320010D+03,   0.00000D+00,   0.00000D+00/
  data pars(   891:   895) / 19,  8,   0.15214200D+03,   0.00000D+00,   0.00000D+00/
  data pars(   896:   900) / 19,  9,   0.10964390D+03,   0.00000D+00,   0.00000D+00/
  data pars(   901:   905) / 19, 10,   0.81086100D+02,   0.00000D+00,   0.00000D+00/
  data pars(   906:   910) / 19, 11,   0.27986124D+04,   0.00000D+00,   0.00000D+00/
  data pars(   911:   915) / 19, 12,   0.16420587D+04,   0.00000D+00,   0.00000D+00/
  data pars(   916:   920) / 19, 13,   0.13879361D+04,   0.00000D+00,   0.00000D+00/
  data pars(   921:   925) / 19, 14,   0.96762830D+03,   0.00000D+00,   0.00000D+00/
  data pars(   926:   930) / 19, 15,   0.68449680D+03,   0.00000D+00,   0.00000D+00/
  data pars(   931:   935) / 19, 16,   0.53523840D+03,   0.00000D+00,   0.00000D+00/
  data pars(   936:   940) / 19, 17,   0.41315120D+03,   0.00000D+00,   0.00000D+00/
  data pars(   941:   945) / 19, 18,   0.32211550D+03,   0.00000D+00,   0.00000D+00/
  data pars(   946:   950) / 19, 19,   0.49835009D+04,   0.00000D+00,   0.00000D+00/
  data pars(   951:   955) / 20,  1,   0.65818000D+02,   0.00000D+00,   0.91180D+00/
  data pars(   956:   960) / 20,  2,   0.39070100D+02,   0.00000D+00,   0.00000D+00/
  data pars(   961:   965) / 20,  3,   0.16144719D+04,   0.00000D+00,   0.00000D+00/
  data pars(   966:   970) / 20,  4,   0.75790700D+03,   0.00000D+00,   0.00000D+00/
  data pars(   971:   975) / 20,  5,   0.45484390D+03,   0.00000D+00,   0.00000D+00/
  data pars(   976:   980) / 20,  6,   0.28170350D+03,   0.00000D+00,   0.00000D+00/
  data pars(   981:   985) / 20,  7,   0.18454980D+03,   0.00000D+00,   0.00000D+00/
  data pars(   986:   990) / 20,  8,   0.13338470D+03,   0.00000D+00,   0.00000D+00/
  data pars(   991:   995) / 20,  9,   0.97082400D+02,   0.00000D+00,   0.00000D+00/
  data pars(   996:  1000) / 20, 10,   0.72307200D+02,   0.00000D+00,   0.00000D+00/
  data pars(  1001:  1005) / 20, 11,   0.19077081D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1006:  1010) / 20, 12,   0.12525932D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1011:  1015) / 20, 13,   0.10888420D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1016:  1020) / 20, 14,   0.79063470D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1021:  1025) / 20, 15,   0.57546270D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1026:  1030) / 20, 16,   0.45684430D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1031:  1035) / 20, 17,   0.35747370D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1036:  1040) / 20, 18,   0.28168230D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1041:  1045) / 20, 19,   0.32404393D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1046:  1050) / 20, 20,   0.23526862D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1051:  1055) / 21,  1,   0.54966900D+02,   0.00000D+00,   0.91180D+00/
  data pars(  1056:  1060) / 21,  2,   0.32899500D+02,   0.00000D+00,   0.00000D+00/
  data pars(  1061:  1065) / 21,  3,   0.12781183D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1066:  1070) / 21,  4,   0.61733580D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1071:  1075) / 21,  5,   0.37504180D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1076:  1080) / 21,  6,   0.23419500D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1081:  1085) / 21,  7,   0.15429470D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1086:  1090) / 21,  8,   0.11193590D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1091:  1095) / 21,  9,   0.81724200D+02,   0.00000D+00,   0.00000D+00/
  data pars(  1096:  1100) / 21, 10,   0.61015400D+02,   0.00000D+00,   0.00000D+00/
  data pars(  1101:  1105) / 21, 11,   0.15125338D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1106:  1110) / 21, 12,   0.10155454D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1111:  1115) / 21, 13,   0.88860250D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1116:  1120) / 21, 14,   0.65120400D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1121:  1125) / 21, 15,   0.47727970D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1126:  1130) / 21, 16,   0.38041070D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1131:  1135) / 21, 17,   0.29876860D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1136:  1140) / 21, 18,   0.23614170D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1141:  1145) / 21, 19,   0.25499412D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1146:  1150) / 21, 20,   0.18887902D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1151:  1155) / 21, 21,   0.15224676D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1156:  1160) / 22,  1,   0.53687500D+02,   0.00000D+00,   0.91180D+00/
  data pars(  1161:  1165) / 22,  2,   0.32531600D+02,   0.00000D+00,   0.00000D+00/
  data pars(  1166:  1170) / 22,  3,   0.11929128D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1171:  1175) / 22,  4,   0.58748980D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1176:  1180) / 22,  5,   0.36108650D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1181:  1185) / 22,  6,   0.22757230D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1186:  1190) / 22,  7,   0.15101990D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1191:  1195) / 22,  8,   0.11014520D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1196:  1200) / 22,  9,   0.80797500D+02,   0.00000D+00,   0.00000D+00/
  data pars(  1201:  1205) / 22, 10,   0.60559400D+02,   0.00000D+00,   0.00000D+00/
  data pars(  1206:  1210) / 22, 11,   0.14131570D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1211:  1215) / 22, 12,   0.96298310D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1216:  1220) / 22, 13,   0.84746150D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1221:  1225) / 22, 14,   0.62623530D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1226:  1230) / 22, 15,   0.46232470D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1231:  1235) / 22, 16,   0.37026310D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1236:  1240) / 22, 17,   0.29218530D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1241:  1245) / 22, 18,   0.23192080D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1246:  1250) / 22, 19,   0.23746690D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1251:  1255) / 22, 20,   0.17795162D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1256:  1260) / 22, 21,   0.14382841D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1261:  1265) / 22, 22,   0.13619185D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1266:  1270) / 23,  1,   0.49481900D+02,   0.00000D+00,   0.91180D+00/
  data pars(  1271:  1275) / 23,  2,   0.30185100D+02,   0.00000D+00,   0.00000D+00/
  data pars(  1276:  1280) / 23,  3,   0.10690426D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1281:  1285) / 23,  4,   0.53334990D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1286:  1290) / 23,  5,   0.33010230D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1291:  1295) / 23,  6,   0.20914500D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1296:  1300) / 23,  7,   0.13935120D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1301:  1305) / 23,  8,   0.10193250D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1306:  1310) / 23,  9,   0.74967100D+02,   0.00000D+00,   0.00000D+00/
  data pars(  1311:  1315) / 23, 10,   0.56310800D+02,   0.00000D+00,   0.00000D+00/
  data pars(  1316:  1320) / 23, 11,   0.12673139D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1321:  1325) / 23, 12,   0.87225790D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1326:  1330) / 23, 13,   0.77034320D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1331:  1335) / 23, 14,   0.57211290D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1336:  1340) / 23, 15,   0.42414700D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1341:  1345) / 23, 16,   0.34060200D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1346:  1350) / 23, 17,   0.26948630D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1351:  1355) / 23, 18,   0.21440020D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1356:  1360) / 23, 19,   0.21241985D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1361:  1365) / 23, 20,   0.16049178D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1366:  1370) / 23, 21,   0.12995197D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1371:  1375) / 23, 22,   0.12323235D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1376:  1380) / 23, 23,   0.11160984D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1381:  1385) / 24,  1,   0.39122100D+02,   0.00000D+00,   0.91180D+00/
  data pars(  1386:  1390) / 24,  2,   0.24146300D+02,   0.00000D+00,   0.00000D+00/
  data pars(  1391:  1395) / 24,  3,   0.84409360D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1396:  1400) / 24,  4,   0.41816350D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1401:  1405) / 24,  5,   0.25930210D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1406:  1410) / 24,  6,   0.16498820D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1411:  1415) / 24,  7,   0.11048610D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1416:  1420) / 24,  8,   0.81200000D+02,   0.00000D+00,   0.00000D+00/
  data pars(  1421:  1425) / 24,  9,   0.60009900D+02,   0.00000D+00,   0.00000D+00/
  data pars(  1426:  1430) / 24, 10,   0.45282000D+02,   0.00000D+00,   0.00000D+00/
  data pars(  1431:  1435) / 24, 11,   0.10004652D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1436:  1440) / 24, 12,   0.68440150D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1441:  1445) / 24, 13,   0.60440710D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1446:  1450) / 24, 14,   0.44922160D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1451:  1455) / 24, 15,   0.33383800D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1456:  1460) / 24, 16,   0.26880290D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1461:  1465) / 24, 17,   0.21336680D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1466:  1470) / 24, 18,   0.17034650D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1471:  1475) / 24, 19,   0.16836701D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1476:  1480) / 24, 20,   0.12630809D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1481:  1485) / 24, 21,   0.10216871D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1486:  1490) / 24, 22,   0.96885650D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1491:  1495) / 24, 23,   0.87738550D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1496:  1500) / 24, 24,   0.69074250D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1501:  1505) / 25,  1,   0.43002800D+02,   0.00000D+00,   0.91180D+00/
  data pars(  1506:  1510) / 25,  2,   0.26497800D+02,   0.00000D+00,   0.00000D+00/
  data pars(  1511:  1515) / 25,  3,   0.89197560D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1516:  1520) / 25,  4,   0.45336860D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1521:  1525) / 25,  5,   0.28347440D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1526:  1530) / 25,  6,   0.18100350D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1531:  1535) / 25,  7,   0.12132330D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1536:  1540) / 25,  8,   0.89134600D+02,   0.00000D+00,   0.00000D+00/
  data pars(  1541:  1545) / 25,  9,   0.65811200D+02,   0.00000D+00,   0.00000D+00/
  data pars(  1546:  1550) / 25, 10,   0.49595900D+02,   0.00000D+00,   0.00000D+00/
  data pars(  1551:  1555) / 25, 11,   0.10585103D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1556:  1560) / 25, 12,   0.73904110D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1561:  1565) / 25, 13,   0.65607380D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1566:  1570) / 25, 14,   0.49081560D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1571:  1575) / 25, 15,   0.36612040D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1576:  1580) / 25, 16,   0.29517370D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1581:  1585) / 25, 17,   0.23445330D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1586:  1590) / 25, 18,   0.18717280D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1591:  1595) / 25, 19,   0.17680322D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1596:  1600) / 25, 20,   0.13514785D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1601:  1605) / 25, 21,   0.10971539D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1606:  1610) / 25, 22,   0.10426625D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1611:  1615) / 25, 23,   0.94560720D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1616:  1620) / 25, 24,   0.74331790D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1621:  1625) / 25, 25,   0.80274840D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1626:  1630) / 26,  1,   0.33911000D+02,   0.00000D+00,   0.91180D+00/
  data pars(  1631:  1635) / 26,  2,   0.21175000D+02,   0.00000D+00,   0.00000D+00/
  data pars(  1636:  1640) / 26,  3,   0.69845390D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1641:  1645) / 26,  4,   0.35353580D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1646:  1650) / 26,  5,   0.22175470D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1651:  1655) / 26,  6,   0.14234670D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1656:  1660) / 26,  7,   0.95978200D+02,   0.00000D+00,   0.00000D+00/
  data pars(  1661:  1665) / 26,  8,   0.70894200D+02,   0.00000D+00,   0.00000D+00/
  data pars(  1666:  1670) / 26,  9,   0.52631000D+02,   0.00000D+00,   0.00000D+00/
  data pars(  1671:  1675) / 26, 10,   0.39865900D+02,   0.00000D+00,   0.00000D+00/
  data pars(  1676:  1680) / 26, 11,   0.82889360D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1681:  1685) / 26, 12,   0.57651210D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1686:  1690) / 26, 13,   0.51208230D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1691:  1695) / 26, 14,   0.38374450D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1696:  1700) / 26, 15,   0.28716060D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1701:  1705) / 26, 16,   0.23226250D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1706:  1710) / 26, 17,   0.18518230D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1711:  1715) / 26, 18,   0.14843190D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1716:  1720) / 26, 19,   0.13889522D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1721:  1725) / 26, 20,   0.10565193D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1726:  1730) / 26, 21,   0.85717300D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1731:  1735) / 26, 22,   0.81484020D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1736:  1740) / 26, 23,   0.73905420D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1741:  1745) / 26, 24,   0.58181140D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1746:  1750) / 26, 25,   0.62754030D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1751:  1755) / 26, 26,   0.49133490D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1756:  1760) / 27,  1,   0.36323400D+02,   0.00000D+00,   0.91180D+00/
  data pars(  1761:  1765) / 27,  2,   0.22723300D+02,   0.00000D+00,   0.00000D+00/
  data pars(  1766:  1770) / 27,  3,   0.70153240D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1771:  1775) / 27,  4,   0.36919280D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1776:  1780) / 27,  5,   0.23486930D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1781:  1785) / 27,  6,   0.15187030D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1786:  1790) / 27,  7,   0.10275030D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1791:  1795) / 27,  8,   0.75991200D+02,   0.00000D+00,   0.00000D+00/
  data pars(  1796:  1800) / 27,  9,   0.56430700D+02,   0.00000D+00,   0.00000D+00/
  data pars(  1801:  1805) / 27, 10,   0.42727000D+02,   0.00000D+00,   0.00000D+00/
  data pars(  1806:  1810) / 27, 11,   0.83418260D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1811:  1815) / 27, 12,   0.59833020D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1816:  1820) / 27, 13,   0.53597060D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1821:  1825) / 27, 14,   0.40599070D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1826:  1830) / 27, 15,   0.30592560D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1831:  1835) / 27, 16,   0.24821160D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1836:  1840) / 27, 17,   0.19835700D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1841:  1845) / 27, 18,   0.15919570D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1846:  1850) / 27, 19,   0.13829771D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1851:  1855) / 27, 20,   0.10817690D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1856:  1860) / 27, 21,   0.88245030D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1861:  1865) / 27, 22,   0.84183350D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1866:  1870) / 27, 23,   0.76531780D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1871:  1875) / 27, 24,   0.60141780D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1876:  1880) / 27, 25,   0.65196880D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1881:  1885) / 27, 26,   0.50977640D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1886:  1890) / 27, 27,   0.53277940D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1891:  1895) / 28,  1,   0.37159600D+02,   0.00000D+00,   0.91180D+00/
  data pars(  1896:  1900) / 28,  2,   0.23079200D+02,   0.00000D+00,   0.00000D+00/
  data pars(  1901:  1905) / 28,  3,   0.73885800D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1906:  1910) / 28,  4,   0.38391400D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1911:  1915) / 28,  5,   0.24241740D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1916:  1920) / 28,  6,   0.15585070D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1921:  1925) / 28,  7,   0.10498340D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1926:  1930) / 28,  8,   0.77401000D+02,   0.00000D+00,   0.00000D+00/
  data pars(  1931:  1935) / 28,  9,   0.57324800D+02,   0.00000D+00,   0.00000D+00/
  data pars(  1936:  1940) / 28, 10,   0.43312900D+02,   0.00000D+00,   0.00000D+00/
  data pars(  1941:  1945) / 28, 11,   0.87793540D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1946:  1950) / 28, 12,   0.62363050D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1951:  1955) / 28, 13,   0.55653890D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1956:  1960) / 28, 14,   0.41935930D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1961:  1965) / 28, 15,   0.31456980D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1966:  1970) / 28, 16,   0.25446830D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1971:  1975) / 28, 17,   0.20277050D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1976:  1980) / 28, 18,   0.16232640D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1981:  1985) / 28, 19,   0.14584501D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1986:  1990) / 28, 20,   0.11321074D+04,   0.00000D+00,   0.00000D+00/
  data pars(  1991:  1995) / 28, 21,   0.92189900D+03,   0.00000D+00,   0.00000D+00/
  data pars(  1996:  2000) / 28, 22,   0.87809390D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2001:  2005) / 28, 23,   0.79751950D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2006:  2010) / 28, 24,   0.62664720D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2011:  2015) / 28, 25,   0.67845310D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2016:  2020) / 28, 26,   0.53032210D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2021:  2025) / 28, 27,   0.55308340D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2026:  2030) / 28, 28,   0.57474360D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2031:  2035) / 29,  1,   0.28594000D+02,   0.00000D+00,   0.91180D+00/
  data pars(  2036:  2040) / 29,  2,   0.18021600D+02,   0.00000D+00,   0.00000D+00/
  data pars(  2041:  2045) / 29,  3,   0.56945260D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2046:  2050) / 29,  4,   0.29279550D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2051:  2055) / 29,  5,   0.18517410D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2056:  2060) / 29,  6,   0.11963500D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2061:  2065) / 29,  7,   0.81085500D+02,   0.00000D+00,   0.00000D+00/
  data pars(  2066:  2070) / 29,  8,   0.60133500D+02,   0.00000D+00,   0.00000D+00/
  data pars(  2071:  2075) / 29,  9,   0.44809800D+02,   0.00000D+00,   0.00000D+00/
  data pars(  2076:  2080) / 29, 10,   0.34054400D+02,   0.00000D+00,   0.00000D+00/
  data pars(  2081:  2085) / 29, 11,   0.67647730D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2086:  2090) / 29, 12,   0.47624260D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2091:  2095) / 29, 13,   0.42477230D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2096:  2100) / 29, 14,   0.32019130D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2101:  2105) / 29, 15,   0.24079740D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2106:  2110) / 29, 16,   0.19540750D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2111:  2115) / 29, 17,   0.15631610D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2116:  2120) / 29, 18,   0.12567760D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2121:  2125) / 29, 19,   0.11299518D+04,   0.00000D+00,   0.00000D+00/
  data pars(  2126:  2130) / 29, 20,   0.86836740D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2131:  2135) / 29, 21,   0.70607200D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2136:  2140) / 29, 22,   0.67241280D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2141:  2145) / 29, 23,   0.61057000D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2146:  2150) / 29, 24,   0.48069380D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2151:  2155) / 29, 25,   0.51930780D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2156:  2160) / 29, 26,   0.40672680D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2161:  2165) / 29, 27,   0.42308770D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2166:  2170) / 29, 28,   0.43963650D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2171:  2175) / 29, 29,   0.33718080D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2176:  2180) / 30,  1,   0.29868900D+02,   0.00000D+00,   0.91180D+00/
  data pars(  2181:  2185) / 30,  2,   0.18969500D+02,   0.00000D+00,   0.00000D+00/
  data pars(  2186:  2190) / 30,  3,   0.54091600D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2191:  2195) / 30,  4,   0.29331060D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2196:  2200) / 30,  5,   0.18962930D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2201:  2205) / 30,  6,   0.12410320D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2206:  2210) / 30,  7,   0.84731100D+02,   0.00000D+00,   0.00000D+00/
  data pars(  2211:  2215) / 30,  8,   0.63077400D+02,   0.00000D+00,   0.00000D+00/
  data pars(  2216:  2220) / 30,  9,   0.47112200D+02,   0.00000D+00,   0.00000D+00/
  data pars(  2221:  2225) / 30, 10,   0.35842700D+02,   0.00000D+00,   0.00000D+00/
  data pars(  2226:  2230) / 30, 11,   0.64434080D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2231:  2235) / 30, 12,   0.47291430D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2236:  2240) / 30, 13,   0.42716100D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2241:  2245) / 30, 14,   0.32728100D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2246:  2250) / 30, 15,   0.24897430D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2251:  2255) / 30, 16,   0.20324270D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2256:  2260) / 30, 17,   0.16338480D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2261:  2265) / 30, 18,   0.13181190D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2266:  2270) / 30, 19,   0.10625928D+04,   0.00000D+00,   0.00000D+00/
  data pars(  2271:  2275) / 30, 20,   0.84685270D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2276:  2280) / 30, 21,   0.69367870D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2281:  2285) / 30, 22,   0.66410090D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2286:  2290) / 30, 23,   0.60506230D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2291:  2295) / 30, 24,   0.47555940D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2296:  2300) / 30, 25,   0.51709100D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2301:  2305) / 30, 26,   0.40455580D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2306:  2310) / 30, 27,   0.42487900D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2311:  2315) / 30, 28,   0.44009000D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2316:  2320) / 30, 29,   0.33664930D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2321:  2325) / 30, 30,   0.34052130D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2326:  2330) / 31,  1,   0.35169700D+02,   0.00000D+00,   0.91180D+00/
  data pars(  2331:  2335) / 31,  2,   0.22045800D+02,   0.00000D+00,   0.00000D+00/
  data pars(  2336:  2340) / 31,  3,   0.65674410D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2341:  2345) / 31,  4,   0.35111410D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2346:  2350) / 31,  5,   0.22539330D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2351:  2355) / 31,  6,   0.14655440D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2356:  2360) / 31,  7,   0.99440700D+02,   0.00000D+00,   0.00000D+00/
  data pars(  2361:  2365) / 31,  8,   0.73625300D+02,   0.00000D+00,   0.00000D+00/
  data pars(  2366:  2370) / 31,  9,   0.54678200D+02,   0.00000D+00,   0.00000D+00/
  data pars(  2371:  2375) / 31, 10,   0.41368100D+02,   0.00000D+00,   0.00000D+00/
  data pars(  2376:  2380) / 31, 11,   0.78135240D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2381:  2385) / 31, 12,   0.56716380D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2386:  2390) / 31, 13,   0.51058540D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2391:  2395) / 31, 14,   0.38926560D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2396:  2400) / 31, 15,   0.29479250D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2401:  2405) / 31, 16,   0.23981830D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2406:  2410) / 31, 17,   0.19205780D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2411:  2415) / 31, 18,   0.15434230D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2416:  2420) / 31, 19,   0.12928121D+04,   0.00000D+00,   0.00000D+00/
  data pars(  2421:  2425) / 31, 20,   0.10198835D+04,   0.00000D+00,   0.00000D+00/
  data pars(  2426:  2430) / 31, 21,   0.83374240D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2431:  2435) / 31, 22,   0.79686170D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2436:  2440) / 31, 23,   0.72525140D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2441:  2445) / 31, 24,   0.56976450D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2446:  2450) / 31, 25,   0.61883870D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2451:  2455) / 31, 26,   0.48378150D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2456:  2460) / 31, 27,   0.50713160D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2461:  2465) / 31, 28,   0.52581620D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2466:  2470) / 31, 29,   0.40196130D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2471:  2475) / 31, 30,   0.40545650D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2476:  2480) / 31, 31,   0.48375160D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2481:  2485) / 32,  1,   0.31817000D+02,   0.00000D+00,   0.91180D+00/
  data pars(  2486:  2490) / 32,  2,   0.20431800D+02,   0.00000D+00,   0.00000D+00/
  data pars(  2491:  2495) / 32,  3,   0.52792680D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2496:  2500) / 32,  4,   0.29842200D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2501:  2505) / 32,  5,   0.19734480D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2506:  2510) / 32,  6,   0.13109540D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2511:  2515) / 32,  7,   0.90332800D+02,   0.00000D+00,   0.00000D+00/
  data pars(  2516:  2520) / 32,  8,   0.67593200D+02,   0.00000D+00,   0.00000D+00/
  data pars(  2521:  2525) / 32,  9,   0.50641200D+02,   0.00000D+00,   0.00000D+00/
  data pars(  2526:  2530) / 32, 10,   0.38574600D+02,   0.00000D+00,   0.00000D+00/
  data pars(  2531:  2535) / 32, 11,   0.63010410D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2536:  2540) / 32, 12,   0.47737440D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2541:  2545) / 32, 13,   0.43650600D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2546:  2550) / 32, 14,   0.33983280D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2551:  2555) / 32, 15,   0.26182350D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2556:  2560) / 32, 16,   0.21531010D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2561:  2565) / 32, 17,   0.17419690D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2566:  2570) / 32, 18,   0.14120630D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2571:  2575) / 32, 19,   0.10326651D+04,   0.00000D+00,   0.00000D+00/
  data pars(  2576:  2580) / 32, 20,   0.84336440D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2581:  2585) / 32, 21,   0.69470240D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2586:  2590) / 32, 22,   0.66837860D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2591:  2595) / 32, 23,   0.61076390D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2596:  2600) / 32, 24,   0.47996390D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2601:  2605) / 32, 25,   0.52418480D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2606:  2610) / 32, 26,   0.41021060D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2611:  2615) / 32, 27,   0.43385080D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2616:  2620) / 32, 28,   0.44798680D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2621:  2625) / 32, 29,   0.34242610D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2626:  2630) / 32, 30,   0.34998850D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2631:  2635) / 32, 31,   0.41595300D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2636:  2640) / 32, 32,   0.36354740D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2641:  2645) / 33,  1,   0.27788400D+02,   0.00000D+00,   0.91180D+00/
  data pars(  2646:  2650) / 33,  2,   0.18328400D+02,   0.00000D+00,   0.00000D+00/
  data pars(  2651:  2655) / 33,  3,   0.41515320D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2656:  2660) / 33,  4,   0.24548310D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2661:  2665) / 33,  5,   0.16690600D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2666:  2670) / 33,  6,   0.11326160D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2671:  2675) / 33,  7,   0.79308600D+02,   0.00000D+00,   0.00000D+00/
  data pars(  2676:  2680) / 33,  8,   0.60028900D+02,   0.00000D+00,   0.00000D+00/
  data pars(  2681:  2685) / 33,  9,   0.45418000D+02,   0.00000D+00,   0.00000D+00/
  data pars(  2686:  2690) / 33, 10,   0.34868600D+02,   0.00000D+00,   0.00000D+00/
  data pars(  2691:  2695) / 33, 11,   0.49693380D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2696:  2700) / 33, 12,   0.38949270D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2701:  2705) / 33, 13,   0.36119130D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2706:  2710) / 33, 14,   0.28659090D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2711:  2715) / 33, 15,   0.22447740D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2716:  2720) / 33, 16,   0.18663480D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2721:  2725) / 33, 17,   0.15260350D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2726:  2730) / 33, 18,   0.12485610D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2731:  2735) / 33, 19,   0.81065540D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2736:  2740) / 33, 20,   0.67900440D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2741:  2745) / 33, 21,   0.56269470D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2746:  2750) / 33, 22,   0.54467970D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2751:  2755) / 33, 23,   0.49949700D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2756:  2760) / 33, 24,   0.39319220D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2761:  2765) / 33, 25,   0.43091460D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2766:  2770) / 33, 26,   0.33800960D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2771:  2775) / 33, 27,   0.35971500D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2776:  2780) / 33, 28,   0.37003590D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2781:  2785) / 33, 29,   0.28333230D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2786:  2790) / 33, 30,   0.29250300D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2791:  2795) / 33, 31,   0.34635080D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2796:  2800) / 33, 32,   0.30710100D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2801:  2805) / 33, 33,   0.26294980D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2806:  2810) / 34,  1,   0.25309800D+02,   0.00000D+00,   0.91180D+00/
  data pars(  2811:  2815) / 34,  2,   0.17024300D+02,   0.00000D+00,   0.00000D+00/
  data pars(  2816:  2820) / 34,  3,   0.35454290D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2821:  2825) / 34,  4,   0.21502380D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2826:  2830) / 34,  5,   0.14880080D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2831:  2835) / 34,  6,   0.10243460D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2836:  2840) / 34,  7,   0.72540300D+02,   0.00000D+00,   0.00000D+00/
  data pars(  2841:  2845) / 34,  8,   0.55362700D+02,   0.00000D+00,   0.00000D+00/
  data pars(  2846:  2850) / 34,  9,   0.42192300D+02,   0.00000D+00,   0.00000D+00/
  data pars(  2851:  2855) / 34, 10,   0.32584300D+02,   0.00000D+00,   0.00000D+00/
  data pars(  2856:  2860) / 34, 11,   0.42518640D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2861:  2865) / 34, 12,   0.33957420D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2866:  2870) / 34, 13,   0.31761820D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2871:  2875) / 34, 14,   0.25500990D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2876:  2880) / 34, 15,   0.20190190D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2881:  2885) / 34, 16,   0.16913080D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2886:  2890) / 34, 17,   0.13931630D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2891:  2895) / 34, 18,   0.11474490D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2896:  2900) / 34, 19,   0.69291160D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2901:  2905) / 34, 20,   0.58796470D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2906:  2910) / 34, 21,   0.48887150D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2911:  2915) / 34, 22,   0.47503480D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2916:  2920) / 34, 23,   0.43657180D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2921:  2925) / 34, 24,   0.34429560D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2926:  2930) / 34, 25,   0.37782760D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2931:  2935) / 34, 26,   0.29703960D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2936:  2940) / 34, 27,   0.31701740D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2941:  2945) / 34, 28,   0.32534190D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2946:  2950) / 34, 29,   0.24963850D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2951:  2955) / 34, 30,   0.25904590D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2956:  2960) / 34, 31,   0.30595010D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2961:  2965) / 34, 32,   0.27365300D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2966:  2970) / 34, 33,   0.23634730D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2971:  2975) / 34, 34,   0.21367380D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2976:  2980) / 35,  1,   0.22483400D+02,   0.00000D+00,   0.91180D+00/
  data pars(  2981:  2985) / 35,  2,   0.15455300D+02,   0.00000D+00,   0.00000D+00/
  data pars(  2986:  2990) / 35,  3,   0.29478970D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2991:  2995) / 35,  4,   0.18337420D+03,   0.00000D+00,   0.00000D+00/
  data pars(  2996:  3000) / 35,  5,   0.12924950D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3001:  3005) / 35,  6,   0.90342400D+02,   0.00000D+00,   0.00000D+00/
  data pars(  3006:  3010) / 35,  7,   0.64763200D+02,   0.00000D+00,   0.00000D+00/
  data pars(  3011:  3015) / 35,  8,   0.49879500D+02,   0.00000D+00,   0.00000D+00/
  data pars(  3016:  3020) / 35,  9,   0.38322500D+02,   0.00000D+00,   0.00000D+00/
  data pars(  3021:  3025) / 35, 10,   0.29795800D+02,   0.00000D+00,   0.00000D+00/
  data pars(  3026:  3030) / 35, 11,   0.35428690D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3031:  3035) / 35, 12,   0.28827360D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3036:  3040) / 35, 13,   0.27200980D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3041:  3045) / 35, 14,   0.22105370D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3046:  3050) / 35, 15,   0.17699300D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3051:  3055) / 35, 16,   0.14945630D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3056:  3060) / 35, 17,   0.12409090D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3061:  3065) / 35, 18,   0.10294710D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3066:  3070) / 35, 19,   0.57723180D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3071:  3075) / 35, 20,   0.49597540D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3076:  3080) / 35, 21,   0.41374680D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3081:  3085) / 35, 22,   0.40365760D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3086:  3090) / 35, 23,   0.37180710D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3091:  3095) / 35, 24,   0.29391850D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3096:  3100) / 35, 25,   0.32284330D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3101:  3105) / 35, 26,   0.25453060D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3106:  3110) / 35, 27,   0.27230530D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3111:  3115) / 35, 28,   0.27877050D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3116:  3120) / 35, 29,   0.21450590D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3121:  3125) / 35, 30,   0.22363480D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3126:  3130) / 35, 31,   0.26334580D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3131:  3135) / 35, 32,   0.23762950D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3136:  3140) / 35, 33,   0.20707720D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3141:  3145) / 35, 34,   0.18836050D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3146:  3150) / 35, 35,   0.16712970D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3151:  3155) / 36,  1,   0.19818200D+02,   0.00000D+00,   0.91180D+00/
  data pars(  3156:  3160) / 36,  2,   0.13921100D+02,   0.00000D+00,   0.00000D+00/
  data pars(  3161:  3165) / 36,  3,   0.24455540D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3166:  3170) / 36,  4,   0.15556160D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3171:  3175) / 36,  5,   0.11153710D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3176:  3180) / 36,  6,   0.79108000D+02,   0.00000D+00,   0.00000D+00/
  data pars(  3181:  3185) / 36,  7,   0.57389500D+02,   0.00000D+00,   0.00000D+00/
  data pars(  3186:  3190) / 36,  8,   0.44600300D+02,   0.00000D+00,   0.00000D+00/
  data pars(  3191:  3195) / 36,  9,   0.34545200D+02,   0.00000D+00,   0.00000D+00/
  data pars(  3196:  3200) / 36, 10,   0.27043000D+02,   0.00000D+00,   0.00000D+00/
  data pars(  3201:  3205) / 36, 11,   0.29455740D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3206:  3210) / 36, 12,   0.24359650D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3211:  3215) / 36, 13,   0.23169040D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3216:  3220) / 36, 14,   0.19039340D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3221:  3225) / 36, 15,   0.15405750D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3226:  3230) / 36, 16,   0.13109280D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3231:  3235) / 36, 17,   0.10968390D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3236:  3240) / 36, 18,   0.91643000D+02,   0.00000D+00,   0.00000D+00/
  data pars(  3241:  3245) / 36, 19,   0.48024720D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3246:  3250) / 36, 20,   0.41697770D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3251:  3255) / 36, 21,   0.34884740D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3256:  3260) / 36, 22,   0.34162730D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3261:  3265) / 36, 23,   0.31532510D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3266:  3270) / 36, 24,   0.24994130D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3271:  3275) / 36, 25,   0.27464190D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3276:  3280) / 36, 26,   0.21720710D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3281:  3285) / 36, 27,   0.23275940D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3286:  3290) / 36, 28,   0.23774470D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3291:  3295) / 36, 29,   0.18353470D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3296:  3300) / 36, 30,   0.19204840D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3301:  3305) / 36, 31,   0.22545370D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3306:  3310) / 36, 32,   0.20505980D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3311:  3315) / 36, 33,   0.18018180D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3316:  3320) / 36, 34,   0.16484940D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3321:  3325) / 36, 35,   0.14718300D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3326:  3330) / 36, 36,   0.13040170D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3331:  3335) / 37,  1,   0.85949900D+02,   0.00000D+00,   0.91180D+00/
  data pars(  3336:  3340) / 37,  2,   0.50049100D+02,   0.00000D+00,   0.00000D+00/
  data pars(  3341:  3345) / 37,  3,   0.26473331D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3346:  3350) / 37,  4,   0.10827052D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3351:  3355) / 37,  5,   0.62008780D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3356:  3360) / 37,  6,   0.37353840D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3361:  3365) / 37,  7,   0.24069400D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3366:  3370) / 37,  8,   0.17233980D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3371:  3375) / 37,  9,   0.12458790D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3376:  3380) / 37, 10,   0.92382700D+02,   0.00000D+00,   0.00000D+00/
  data pars(  3381:  3385) / 37, 11,   0.31041016D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3386:  3390) / 37, 12,   0.18264648D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3391:  3395) / 37, 13,   0.15469229D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3396:  3400) / 37, 14,   0.10820563D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3401:  3405) / 37, 15,   0.76813350D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3406:  3410) / 37, 16,   0.60222210D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3411:  3415) / 37, 17,   0.46615650D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3416:  3420) / 37, 18,   0.36440670D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3421:  3425) / 37, 19,   0.55302806D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3426:  3430) / 37, 20,   0.35994349D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3431:  3435) / 37, 21,   0.28340920D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3436:  3440) / 37, 22,   0.26412435D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3441:  3445) / 37, 23,   0.23637175D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3446:  3450) / 37, 24,   0.18740326D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3451:  3455) / 37, 25,   0.19687631D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3456:  3460) / 37, 26,   0.15471982D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3461:  3465) / 37, 27,   0.15418997D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3466:  3470) / 37, 28,   0.16251034D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3471:  3475) / 37, 29,   0.12594427D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3476:  3480) / 37, 30,   0.11862631D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3481:  3485) / 37, 31,   0.14423807D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3486:  3490) / 37, 32,   0.11551526D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3491:  3495) / 37, 33,   0.90942570D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3496:  3500) / 37, 34,   0.77892040D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3501:  3505) / 37, 35,   0.65036060D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3506:  3510) / 37, 36,   0.54231600D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3511:  3515) / 37, 37,   0.61387755D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3516:  3520) / 38,  1,   0.78390100D+02,   0.00000D+00,   0.91180D+00/
  data pars(  3521:  3525) / 38,  2,   0.46665800D+02,   0.00000D+00,   0.00000D+00/
  data pars(  3526:  3530) / 38,  3,   0.19442260D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3531:  3535) / 38,  4,   0.90392650D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3536:  3540) / 38,  5,   0.54157290D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3541:  3545) / 38,  6,   0.33545970D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3546:  3550) / 38,  7,   0.21996080D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3551:  3555) / 38,  8,   0.15914600D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3556:  3560) / 38,  9,   0.11596470D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3561:  3565) / 38, 10,   0.86462700D+02,   0.00000D+00,   0.00000D+00/
  data pars(  3566:  3570) / 38, 11,   0.22961906D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3571:  3575) / 38, 12,   0.14958141D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3576:  3580) / 38, 13,   0.12985356D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3581:  3585) / 38, 14,   0.94141210D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3586:  3590) / 38, 15,   0.68496320D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3591:  3595) / 38, 16,   0.54396270D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3596:  3600) / 38, 17,   0.42589970D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3601:  3605) / 38, 18,   0.33586900D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3606:  3610) / 38, 19,   0.39153529D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3611:  3615) / 38, 20,   0.28194935D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3616:  3620) / 38, 21,   0.22604217D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3621:  3625) / 38, 22,   0.21283951D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3626:  3630) / 38, 23,   0.19186941D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3631:  3635) / 38, 24,   0.15113043D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3636:  3640) / 38, 25,   0.16147190D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3641:  3645) / 38, 26,   0.12632327D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3646:  3650) / 38, 27,   0.12908718D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3651:  3655) / 38, 28,   0.13513702D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3656:  3660) / 38, 29,   0.10377284D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3661:  3665) / 38, 30,   0.10096809D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3666:  3670) / 38, 31,   0.12165138D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3671:  3675) / 38, 32,   0.10044824D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3676:  3680) / 38, 33,   0.80833700D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3681:  3685) / 38, 34,   0.70005320D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3686:  3690) / 38, 35,   0.59073260D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3691:  3695) / 38, 36,   0.49691200D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3696:  3700) / 38, 37,   0.43492577D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3701:  3705) / 38, 38,   0.33813672D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3706:  3710) / 39,  1,   0.70057000D+02,   0.00000D+00,   0.91180D+00/
  data pars(  3711:  3715) / 39,  2,   0.42419500D+02,   0.00000D+00,   0.00000D+00/
  data pars(  3716:  3720) / 39,  3,   0.15853950D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3721:  3725) / 39,  4,   0.77148440D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3726:  3730) / 39,  5,   0.47243640D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3731:  3735) / 39,  6,   0.29721710D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3736:  3740) / 39,  7,   0.19706110D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3741:  3745) / 39,  8,   0.14366020D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3746:  3750) / 39,  9,   0.10534470D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3751:  3755) / 39, 10,   0.78931600D+02,   0.00000D+00,   0.00000D+00/
  data pars(  3756:  3760) / 39, 11,   0.18768634D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3761:  3765) / 39, 12,   0.12667602D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3766:  3770) / 39, 13,   0.11122980D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3771:  3775) / 39, 14,   0.81954180D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3776:  3780) / 39, 15,   0.60399160D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3781:  3785) / 39, 16,   0.48337970D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3786:  3790) / 39, 17,   0.38124620D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3791:  3795) / 39, 18,   0.30251430D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3796:  3800) / 39, 19,   0.31660625D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3801:  3805) / 39, 20,   0.23508018D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3806:  3810) / 39, 21,   0.18967809D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3811:  3815) / 39, 22,   0.17943180D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3816:  3820) / 39, 23,   0.16224689D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3821:  3825) / 39, 24,   0.12764352D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3826:  3830) / 39, 25,   0.13714492D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3831:  3835) / 39, 26,   0.10723265D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3836:  3840) / 39, 27,   0.11053016D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3841:  3845) / 39, 28,   0.11535737D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3846:  3850) / 39, 29,   0.88416480D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3851:  3855) / 39, 30,   0.87069350D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3856:  3860) / 39, 31,   0.10455505D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3861:  3865) / 39, 32,   0.87478360D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3866:  3870) / 39, 33,   0.71175060D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3871:  3875) / 39, 34,   0.62033340D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3876:  3880) / 39, 35,   0.52682990D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3881:  3885) / 39, 36,   0.44570130D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3886:  3890) / 39, 37,   0.35209466D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3891:  3895) / 39, 38,   0.28137007D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3896:  3900) / 39, 39,   0.23658925D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3901:  3905) / 40,  1,   0.63780100D+02,   0.00000D+00,   0.91180D+00/
  data pars(  3906:  3910) / 40,  2,   0.39108800D+02,   0.00000D+00,   0.00000D+00/
  data pars(  3911:  3915) / 40,  3,   0.13632842D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3916:  3920) / 40,  4,   0.68152830D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3921:  3925) / 40,  5,   0.42323020D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3926:  3930) / 40,  6,   0.26904900D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3931:  3935) / 40,  7,   0.17977770D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3936:  3940) / 40,  8,   0.13178520D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3941:  3945) / 40,  9,   0.97097700D+02,   0.00000D+00,   0.00000D+00/
  data pars(  3946:  3950) / 40, 10,   0.73031500D+02,   0.00000D+00,   0.00000D+00/
  data pars(  3951:  3955) / 40, 11,   0.16162863D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3956:  3960) / 40, 12,   0.11138339D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3961:  3965) / 40, 13,   0.98504940D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3966:  3970) / 40, 14,   0.73318070D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3971:  3975) / 40, 15,   0.54488820D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3976:  3980) / 40, 16,   0.43838900D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3981:  3985) / 40, 17,   0.34753340D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3986:  3990) / 40, 18,   0.27699080D+03,   0.00000D+00,   0.00000D+00/
  data pars(  3991:  3995) / 40, 19,   0.27111542D+04,   0.00000D+00,   0.00000D+00/
  data pars(  3996:  4000) / 40, 20,   0.20485251D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4001:  4005) / 40, 21,   0.16591156D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4006:  4010) / 40, 22,   0.15741401D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4011:  4015) / 40, 23,   0.14260687D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4016:  4020) / 40, 24,   0.11215489D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4021:  4025) / 40, 25,   0.12087451D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4026:  4030) / 40, 26,   0.94517130D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4031:  4035) / 40, 27,   0.97897670D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4036:  4040) / 40, 28,   0.10197589D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4041:  4045) / 40, 29,   0.78111330D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4046:  4050) / 40, 30,   0.77458710D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4051:  4055) / 40, 31,   0.92819820D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4056:  4060) / 40, 32,   0.78294420D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4061:  4065) / 40, 33,   0.64155640D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4066:  4070) / 40, 34,   0.56154740D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4071:  4075) / 40, 35,   0.47900400D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4076:  4080) / 40, 36,   0.40687270D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4081:  4085) / 40, 37,   0.30176856D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4086:  4090) / 40, 38,   0.24494723D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4091:  4095) / 40, 39,   0.20726170D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4096:  4100) / 40, 40,   0.18227181D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4101:  4105) / 41,  1,   0.58676800D+02,   0.00000D+00,   0.91180D+00/
  data pars(  4106:  4110) / 41,  2,   0.36341800D+02,   0.00000D+00,   0.00000D+00/
  data pars(  4111:  4115) / 41,  3,   0.12090304D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4116:  4120) / 41,  4,   0.61398500D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4121:  4125) / 41,  5,   0.38490720D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4126:  4130) / 41,  6,   0.24652410D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4131:  4135) / 41,  7,   0.16569430D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4136:  4140) / 41,  8,   0.12198680D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4141:  4145) / 41,  9,   0.90223400D+02,   0.00000D+00,   0.00000D+00/
  data pars(  4146:  4150) / 41, 10,   0.68076900D+02,   0.00000D+00,   0.00000D+00/
  data pars(  4151:  4155) / 41, 11,   0.14346641D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4156:  4160) / 41, 12,   0.10005663D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4161:  4165) / 41, 13,   0.88903020D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4166:  4170) / 41, 14,   0.66615070D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4171:  4175) / 41, 15,   0.49797030D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4176:  4180) / 41, 16,   0.40219740D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4181:  4185) / 41, 17,   0.32006760D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4186:  4190) / 41, 18,   0.25597690D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4191:  4195) / 41, 19,   0.24006918D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4196:  4200) / 41, 20,   0.18308523D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4201:  4205) / 41, 21,   0.14860620D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4206:  4210) / 41, 22,   0.14126818D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4211:  4215) / 41, 23,   0.12813349D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4216:  4220) / 41, 24,   0.10078571D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4221:  4225) / 41, 25,   0.10879837D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4226:  4230) / 41, 26,   0.85106340D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4231:  4235) / 41, 27,   0.88388900D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4236:  4240) / 41, 28,   0.91953540D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4241:  4245) / 41, 29,   0.70437890D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4246:  4250) / 41, 30,   0.70135490D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4251:  4255) / 41, 31,   0.83928280D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4256:  4260) / 41, 32,   0.71168230D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4261:  4265) / 41, 33,   0.58600840D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4266:  4270) / 41, 34,   0.51450770D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4271:  4275) / 41, 35,   0.44029990D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4276:  4280) / 41, 36,   0.37513390D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4281:  4285) / 41, 37,   0.26739344D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4286:  4290) / 41, 38,   0.21882864D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4291:  4295) / 41, 39,   0.18586377D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4296:  4300) / 41, 40,   0.16384938D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4301:  4305) / 41, 41,   0.14752500D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4306:  4310) / 42,  1,   0.46040600D+02,   0.00000D+00,   0.91180D+00/
  data pars(  4311:  4315) / 42,  2,   0.29161700D+02,   0.00000D+00,   0.00000D+00/
  data pars(  4316:  4320) / 42,  3,   0.89051260D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4321:  4325) / 42,  4,   0.46330650D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4326:  4330) / 42,  5,   0.29535920D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4331:  4335) / 42,  6,   0.19195280D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4336:  4340) / 42,  7,   0.13060450D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4341:  4345) / 42,  8,   0.97067500D+02,   0.00000D+00,   0.00000D+00/
  data pars(  4346:  4350) / 42,  9,   0.72418600D+02,   0.00000D+00,   0.00000D+00/
  data pars(  4351:  4355) / 42, 10,   0.55048700D+02,   0.00000D+00,   0.00000D+00/
  data pars(  4356:  4360) / 42, 11,   0.10583899D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4361:  4365) / 42, 12,   0.75166280D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4366:  4370) / 42, 13,   0.67311930D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4371:  4375) / 42, 14,   0.51023520D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4376:  4380) / 42, 15,   0.38558950D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4381:  4385) / 42, 16,   0.31386570D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4386:  4390) / 42, 17,   0.25177230D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4391:  4395) / 42, 18,   0.20285720D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4396:  4400) / 42, 19,   0.17658946D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4401:  4405) / 42, 20,   0.13654837D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4406:  4410) / 42, 21,   0.11120098D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4411:  4415) / 42, 22,   0.10606255D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4416:  4420) / 42, 23,   0.96394340D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4421:  4425) / 42, 24,   0.75899550D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4426:  4430) / 42, 25,   0.82093130D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4431:  4435) / 42, 26,   0.64312470D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4436:  4440) / 42, 27,   0.67034900D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4441:  4445) / 42, 28,   0.69583480D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4446:  4450) / 42, 29,   0.53365350D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4451:  4455) / 42, 30,   0.53452070D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4456:  4460) / 42, 31,   0.63792330D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4461:  4465) / 42, 32,   0.54578450D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4466:  4470) / 42, 33,   0.45341860D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4471:  4475) / 42, 34,   0.40049980D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4476:  4480) / 42, 35,   0.34498260D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4481:  4485) / 42, 36,   0.29579940D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4486:  4490) / 42, 37,   0.19694796D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4491:  4495) / 42, 38,   0.16315424D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4496:  4500) / 42, 39,   0.13940976D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4501:  4505) / 42, 40,   0.12339095D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4506:  4510) / 42, 41,   0.11140924D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4511:  4515) / 42, 42,   0.84589720D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4516:  4520) / 43,  1,   0.51052700D+02,   0.00000D+00,   0.91180D+00/
  data pars(  4521:  4525) / 43,  2,   0.32058800D+02,   0.00000D+00,   0.00000D+00/
  data pars(  4526:  4530) / 43,  3,   0.10116099D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4531:  4535) / 43,  4,   0.52142490D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4536:  4540) / 43,  5,   0.33032570D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4541:  4545) / 43,  6,   0.21347990D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4546:  4550) / 43,  7,   0.14456970D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4551:  4555) / 43,  8,   0.10705880D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4556:  4560) / 43,  9,   0.79612100D+02,   0.00000D+00,   0.00000D+00/
  data pars(  4561:  4565) / 43, 10,   0.60352100D+02,   0.00000D+00,   0.00000D+00/
  data pars(  4566:  4570) / 43, 11,   0.12015234D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4571:  4575) / 43, 12,   0.84734970D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4576:  4580) / 43, 13,   0.75661950D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4581:  4585) / 43, 14,   0.57105010D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4586:  4590) / 43, 15,   0.42976770D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4591:  4595) / 43, 16,   0.34877440D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4596:  4600) / 43, 17,   0.27891230D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4601:  4605) / 43, 18,   0.22407940D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4606:  4610) / 43, 19,   0.20076137D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4611:  4615) / 43, 20,   0.15434258D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4616:  4620) / 43, 21,   0.12553446D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4621:  4625) / 43, 22,   0.11958434D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4626:  4630) / 43, 23,   0.10860231D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4631:  4635) / 43, 24,   0.85474740D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4636:  4640) / 43, 25,   0.92387430D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4641:  4645) / 43, 26,   0.72332020D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4646:  4650) / 43, 27,   0.75296780D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4651:  4655) / 43, 28,   0.78224830D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4656:  4660) / 43, 29,   0.59961920D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4661:  4665) / 43, 30,   0.59931410D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4666:  4670) / 43, 31,   0.71598110D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4671:  4675) / 43, 32,   0.61053270D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4676:  4680) / 43, 33,   0.50550910D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4681:  4685) / 43, 34,   0.44547780D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4686:  4690) / 43, 35,   0.38275910D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4691:  4695) / 43, 36,   0.32738270D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4696:  4700) / 43, 37,   0.22379665D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4701:  4705) / 43, 38,   0.18443774D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4706:  4710) / 43, 39,   0.15723759D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4711:  4715) / 43, 40,   0.13895979D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4716:  4720) / 43, 41,   0.12533465D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4721:  4725) / 43, 42,   0.94964900D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4726:  4730) / 43, 43,   0.10670169D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4731:  4735) / 44,  1,   0.39574500D+02,   0.00000D+00,   0.91180D+00/
  data pars(  4736:  4740) / 44,  2,   0.25462200D+02,   0.00000D+00,   0.00000D+00/
  data pars(  4741:  4745) / 44,  3,   0.73055330D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4746:  4750) / 44,  4,   0.38726810D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4751:  4755) / 44,  5,   0.24993820D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4756:  4760) / 44,  6,   0.16412790D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4761:  4765) / 44,  7,   0.11263780D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4766:  4770) / 44,  8,   0.84272500D+02,   0.00000D+00,   0.00000D+00/
  data pars(  4771:  4775) / 44,  9,   0.63259900D+02,   0.00000D+00,   0.00000D+00/
  data pars(  4776:  4780) / 44, 10,   0.48342900D+02,   0.00000D+00,   0.00000D+00/
  data pars(  4781:  4785) / 44, 11,   0.86937740D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4786:  4790) / 44, 12,   0.62621040D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4791:  4795) / 44, 13,   0.56407160D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4796:  4800) / 44, 14,   0.43121320D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4801:  4805) / 44, 15,   0.32840720D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4806:  4810) / 44, 16,   0.26878240D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4811:  4815) / 44, 17,   0.21680700D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4816:  4820) / 44, 18,   0.17558760D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4821:  4825) / 44, 19,   0.14473048D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4826:  4830) / 44, 20,   0.11311769D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4831:  4835) / 44, 21,   0.92358110D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4836:  4840) / 44, 22,   0.88314920D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4841:  4845) / 44, 23,   0.80388070D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4846:  4850) / 44, 24,   0.63343940D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4851:  4855) / 44, 25,   0.68617720D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4856:  4860) / 44, 26,   0.53814350D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4861:  4865) / 44, 27,   0.56248000D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4866:  4870) / 44, 28,   0.58290140D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4871:  4875) / 44, 29,   0.44742590D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4876:  4880) / 44, 30,   0.45015430D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4881:  4885) / 44, 31,   0.53610930D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4886:  4890) / 44, 32,   0.46167950D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4891:  4895) / 44, 33,   0.38598830D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4896:  4900) / 44, 34,   0.34238140D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4901:  4905) / 44, 35,   0.29626680D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4906:  4910) / 44, 36,   0.25515160D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4911:  4915) / 44, 37,   0.16158387D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4916:  4920) / 44, 38,   0.13511988D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4921:  4925) / 44, 39,   0.11599071D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4926:  4930) / 44, 40,   0.10297665D+04,   0.00000D+00,   0.00000D+00/
  data pars(  4931:  4935) / 44, 41,   0.93174450D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4936:  4940) / 44, 42,   0.71028370D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4941:  4945) / 44, 43,   0.79619510D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4946:  4950) / 44, 44,   0.59819880D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4951:  4955) / 45,  1,   0.43166100D+02,   0.00000D+00,   0.91180D+00/
  data pars(  4956:  4960) / 45,  2,   0.27574500D+02,   0.00000D+00,   0.00000D+00/
  data pars(  4961:  4965) / 45,  3,   0.79420060D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4966:  4970) / 45,  4,   0.42441200D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4971:  4975) / 45,  5,   0.27371950D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4976:  4980) / 45,  6,   0.17927080D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4981:  4985) / 45,  7,   0.12264260D+03,   0.00000D+00,   0.00000D+00/
  data pars(  4986:  4990) / 45,  8,   0.91495900D+02,   0.00000D+00,   0.00000D+00/
  data pars(  4991:  4995) / 45,  9,   0.68488800D+02,   0.00000D+00,   0.00000D+00/
  data pars(  4996:  5000) / 45, 10,   0.52207200D+02,   0.00000D+00,   0.00000D+00/
  data pars(  5001:  5005) / 45, 11,   0.94542210D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5006:  5010) / 45, 12,   0.68566280D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5011:  5015) / 45, 13,   0.61792440D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5016:  5020) / 45, 14,   0.47237380D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5021:  5025) / 45, 15,   0.35925470D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5026:  5030) / 45, 16,   0.29352140D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5031:  5035) / 45, 17,   0.23627500D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5036:  5040) / 45, 18,   0.19093520D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5041:  5045) / 45, 19,   0.15674954D+04,   0.00000D+00,   0.00000D+00/
  data pars(  5046:  5050) / 45, 20,   0.12346013D+04,   0.00000D+00,   0.00000D+00/
  data pars(  5051:  5055) / 45, 21,   0.10091933D+04,   0.00000D+00,   0.00000D+00/
  data pars(  5056:  5060) / 45, 22,   0.96523080D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5061:  5065) / 45, 23,   0.87880270D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5066:  5070) / 45, 24,   0.69163140D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5071:  5075) / 45, 25,   0.75032510D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5076:  5080) / 45, 26,   0.58775440D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5081:  5085) / 45, 27,   0.61543640D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5086:  5090) / 45, 28,   0.63776340D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5091:  5095) / 45, 29,   0.48875010D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5096:  5100) / 45, 30,   0.49263190D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5101:  5105) / 45, 31,   0.58677320D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5106:  5110) / 45, 32,   0.50544520D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5111:  5115) / 45, 33,   0.42219710D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5116:  5120) / 45, 34,   0.37406320D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5121:  5125) / 45, 35,   0.32319410D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5126:  5130) / 45, 36,   0.27786800D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5131:  5135) / 45, 37,   0.17497615D+04,   0.00000D+00,   0.00000D+00/
  data pars(  5136:  5140) / 45, 38,   0.14735487D+04,   0.00000D+00,   0.00000D+00/
  data pars(  5141:  5145) / 45, 39,   0.12668436D+04,   0.00000D+00,   0.00000D+00/
  data pars(  5146:  5150) / 45, 40,   0.11253403D+04,   0.00000D+00,   0.00000D+00/
  data pars(  5151:  5155) / 45, 41,   0.10182915D+04,   0.00000D+00,   0.00000D+00/
  data pars(  5156:  5160) / 45, 42,   0.77583530D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5161:  5165) / 45, 43,   0.86989620D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5166:  5170) / 45, 44,   0.65317750D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5171:  5175) / 45, 45,   0.71394270D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5176:  5180) / 46,  1,   0.40237200D+02,   0.00000D+00,   0.91180D+00/
  data pars(  5181:  5185) / 46,  2,   0.25871600D+02,   0.00000D+00,   0.00000D+00/
  data pars(  5186:  5190) / 46,  3,   0.72242940D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5191:  5195) / 46,  4,   0.39043100D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5196:  5200) / 46,  5,   0.25334250D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5201:  5205) / 46,  6,   0.16671110D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5206:  5210) / 46,  7,   0.11447630D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5211:  5215) / 46,  8,   0.85642700D+02,   0.00000D+00,   0.00000D+00/
  data pars(  5216:  5220) / 46,  9,   0.64270700D+02,   0.00000D+00,   0.00000D+00/
  data pars(  5221:  5225) / 46, 10,   0.49099000D+02,   0.00000D+00,   0.00000D+00/
  data pars(  5226:  5230) / 46, 11,   0.86062090D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5231:  5235) / 46, 12,   0.62959120D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5236:  5240) / 46, 13,   0.56914100D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5241:  5245) / 46, 14,   0.43694630D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5246:  5250) / 46, 15,   0.33352190D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5251:  5255) / 46, 16,   0.27315680D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5256:  5260) / 46, 17,   0.22040990D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5261:  5265) / 46, 18,   0.17850210D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5266:  5270) / 46, 19,   0.14240271D+04,   0.00000D+00,   0.00000D+00/
  data pars(  5271:  5275) / 46, 20,   0.11296670D+04,   0.00000D+00,   0.00000D+00/
  data pars(  5276:  5280) / 46, 21,   0.92485560D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5281:  5285) / 46, 22,   0.88576570D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5286:  5290) / 46, 23,   0.80712580D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5291:  5295) / 46, 24,   0.63532570D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5296:  5300) / 46, 25,   0.68996470D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5301:  5305) / 46, 26,   0.54065990D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5306:  5310) / 46, 27,   0.56710440D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5311:  5315) / 46, 28,   0.58718190D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5316:  5320) / 46, 29,   0.45005590D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5321:  5325) / 46, 30,   0.45480310D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5326:  5330) / 46, 31,   0.54115010D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5331:  5335) / 46, 32,   0.46770420D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5336:  5340) / 46, 33,   0.39185280D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5341:  5345) / 46, 34,   0.34783930D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5346:  5350) / 46, 35,   0.30113900D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5351:  5355) / 46, 36,   0.25939640D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5356:  5360) / 46, 37,   0.15904415D+04,   0.00000D+00,   0.00000D+00/
  data pars(  5361:  5365) / 46, 38,   0.13479007D+04,   0.00000D+00,   0.00000D+00/
  data pars(  5366:  5370) / 46, 39,   0.11619289D+04,   0.00000D+00,   0.00000D+00/
  data pars(  5371:  5375) / 46, 40,   0.10338735D+04,   0.00000D+00,   0.00000D+00/
  data pars(  5376:  5380) / 46, 41,   0.93655280D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5381:  5385) / 46, 42,   0.71494950D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5386:  5390) / 46, 43,   0.80104420D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5391:  5395) / 46, 44,   0.60279560D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5396:  5400) / 46, 45,   0.65887530D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5401:  5405) / 46, 46,   0.60850410D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5406:  5410) / 47,  1,   0.33541300D+02,   0.00000D+00,   0.91180D+00/
  data pars(  5411:  5415) / 47,  2,   0.21789600D+02,   0.00000D+00,   0.00000D+00/
  data pars(  5416:  5420) / 47,  3,   0.61414770D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5421:  5425) / 47,  4,   0.32557750D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5426:  5430) / 47,  5,   0.21068110D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5431:  5435) / 47,  6,   0.13887580D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5436:  5440) / 47,  7,   0.95713700D+02,   0.00000D+00,   0.00000D+00/
  data pars(  5441:  5445) / 47,  8,   0.71892600D+02,   0.00000D+00,   0.00000D+00/
  data pars(  5446:  5450) / 47,  9,   0.54190300D+02,   0.00000D+00,   0.00000D+00/
  data pars(  5451:  5455) / 47, 10,   0.41578000D+02,   0.00000D+00,   0.00000D+00/
  data pars(  5456:  5460) / 47, 11,   0.73108320D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5461:  5465) / 47, 12,   0.52647760D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5466:  5470) / 47, 13,   0.47457130D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5471:  5475) / 47, 14,   0.36335850D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5476:  5480) / 47, 15,   0.27735770D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5481:  5485) / 47, 16,   0.22750240D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5486:  5490) / 47, 17,   0.18398760D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5491:  5495) / 47, 18,   0.14942690D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5496:  5500) / 47, 19,   0.12184699D+04,   0.00000D+00,   0.00000D+00/
  data pars(  5501:  5505) / 47, 20,   0.95149350D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5506:  5510) / 47, 21,   0.77689140D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5511:  5515) / 47, 22,   0.74320410D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5516:  5520) / 47, 23,   0.67665530D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5521:  5525) / 47, 24,   0.53368780D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5526:  5530) / 47, 25,   0.57781270D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5531:  5535) / 47, 26,   0.45363270D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5536:  5540) / 47, 27,   0.47392440D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5541:  5545) / 47, 28,   0.49097830D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5546:  5550) / 47, 29,   0.37735310D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5551:  5555) / 47, 30,   0.37956550D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5556:  5560) / 47, 31,   0.45158870D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5561:  5565) / 47, 32,   0.38930750D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5566:  5570) / 47, 33,   0.32603710D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5571:  5575) / 47, 34,   0.28964690D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5576:  5580) / 47, 35,   0.25111890D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5581:  5585) / 47, 36,   0.21673360D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5586:  5590) / 47, 37,   0.13607517D+04,   0.00000D+00,   0.00000D+00/
  data pars(  5591:  5595) / 47, 38,   0.11369099D+04,   0.00000D+00,   0.00000D+00/
  data pars(  5596:  5600) / 47, 39,   0.97620250D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5601:  5605) / 47, 40,   0.86700560D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5606:  5610) / 47, 41,   0.78481880D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5611:  5615) / 47, 42,   0.59905300D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5616:  5620) / 47, 43,   0.67117170D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5621:  5625) / 47, 44,   0.50502690D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5626:  5630) / 47, 45,   0.55108020D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5631:  5635) / 47, 46,   0.50877420D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5636:  5640) / 47, 47,   0.42674500D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5641:  5645) / 48,  1,   0.35687900D+02,   0.00000D+00,   0.91180D+00/
  data pars(  5646:  5650) / 48,  2,   0.23156300D+02,   0.00000D+00,   0.00000D+00/
  data pars(  5651:  5655) / 48,  3,   0.62105360D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5656:  5660) / 48,  4,   0.34041220D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5661:  5665) / 48,  5,   0.22262730D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5666:  5670) / 48,  6,   0.14741380D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5671:  5675) / 48,  7,   0.10173770D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5676:  5680) / 48,  8,   0.76409200D+02,   0.00000D+00,   0.00000D+00/
  data pars(  5681:  5685) / 48,  9,   0.57550000D+02,   0.00000D+00,   0.00000D+00/
  data pars(  5686:  5690) / 48, 10,   0.44106200D+02,   0.00000D+00,   0.00000D+00/
  data pars(  5691:  5695) / 48, 11,   0.74057870D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5696:  5700) / 48, 12,   0.54767210D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5701:  5705) / 48, 13,   0.49703370D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5706:  5710) / 48, 14,   0.38367900D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5711:  5715) / 48, 15,   0.29424650D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5716:  5720) / 48, 16,   0.24176140D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5721:  5725) / 48, 17,   0.19570440D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5726:  5730) / 48, 18,   0.15896500D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5731:  5735) / 48, 19,   0.12225553D+04,   0.00000D+00,   0.00000D+00/
  data pars(  5736:  5740) / 48, 20,   0.97842510D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5741:  5745) / 48, 21,   0.80260200D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5746:  5750) / 48, 22,   0.77003030D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5751:  5755) / 48, 23,   0.70242130D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5756:  5760) / 48, 24,   0.55309190D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5761:  5765) / 48, 25,   0.60140530D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5766:  5770) / 48, 26,   0.47153290D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5771:  5775) / 48, 27,   0.49563130D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5776:  5780) / 48, 28,   0.51262200D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5781:  5785) / 48, 29,   0.39305100D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5786:  5790) / 48, 30,   0.39845720D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5791:  5795) / 48, 31,   0.47342030D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5796:  5800) / 48, 32,   0.41090580D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5801:  5805) / 48, 33,   0.34560850D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5806:  5810) / 48, 34,   0.30755390D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5811:  5815) / 48, 35,   0.26697000D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5816:  5820) / 48, 36,   0.23054930D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5821:  5825) / 48, 37,   0.13663938D+04,   0.00000D+00,   0.00000D+00/
  data pars(  5826:  5830) / 48, 38,   0.11670471D+04,   0.00000D+00,   0.00000D+00/
  data pars(  5831:  5835) / 48, 39,   0.10094418D+04,   0.00000D+00,   0.00000D+00/
  data pars(  5836:  5840) / 48, 40,   0.90011540D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5841:  5845) / 48, 41,   0.81654950D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5846:  5850) / 48, 42,   0.62495060D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5851:  5855) / 48, 43,   0.69953820D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5856:  5860) / 48, 44,   0.52793870D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5861:  5865) / 48, 45,   0.57701070D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5866:  5870) / 48, 46,   0.53341340D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5871:  5875) / 48, 47,   0.44587010D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5876:  5880) / 48, 48,   0.46819000D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5881:  5885) / 49,  1,   0.44041700D+02,   0.00000D+00,   0.91180D+00/
  data pars(  5886:  5890) / 49,  2,   0.27958600D+02,   0.00000D+00,   0.00000D+00/
  data pars(  5891:  5895) / 49,  3,   0.82896730D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5896:  5900) / 49,  4,   0.43833960D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5901:  5905) / 49,  5,   0.28117370D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5906:  5910) / 49,  6,   0.18333680D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5911:  5915) / 49,  7,   0.12497980D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5916:  5920) / 49,  8,   0.92996800D+02,   0.00000D+00,   0.00000D+00/
  data pars(  5921:  5925) / 49,  9,   0.69455800D+02,   0.00000D+00,   0.00000D+00/
  data pars(  5926:  5930) / 49, 10,   0.52851700D+02,   0.00000D+00,   0.00000D+00/
  data pars(  5931:  5935) / 49, 11,   0.98609990D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5936:  5940) / 49, 12,   0.70935650D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5941:  5945) / 49, 13,   0.63758320D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5946:  5950) / 49, 14,   0.48553920D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5951:  5955) / 49, 15,   0.36802750D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5956:  5960) / 49, 16,   0.29998530D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5961:  5965) / 49, 17,   0.24091040D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5966:  5970) / 49, 18,   0.19426460D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5971:  5975) / 49, 19,   0.16388153D+04,   0.00000D+00,   0.00000D+00/
  data pars(  5976:  5980) / 49, 20,   0.12812612D+04,   0.00000D+00,   0.00000D+00/
  data pars(  5981:  5985) / 49, 21,   0.10458401D+04,   0.00000D+00,   0.00000D+00/
  data pars(  5986:  5990) / 49, 22,   0.99909710D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5991:  5995) / 49, 23,   0.90897530D+03,   0.00000D+00,   0.00000D+00/
  data pars(  5996:  6000) / 49, 24,   0.71527990D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6001:  6005) / 49, 25,   0.77527360D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6006:  6010) / 49, 26,   0.60709640D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6011:  6015) / 49, 27,   0.63472630D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6016:  6020) / 49, 28,   0.65825260D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6021:  6025) / 49, 29,   0.50438020D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6026:  6030) / 49, 30,   0.50724520D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6031:  6035) / 49, 31,   0.60471830D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6036:  6040) / 49, 32,   0.51935010D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6041:  6045) / 49, 33,   0.43261670D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6046:  6050) / 49, 34,   0.38259680D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6051:  6055) / 49, 35,   0.32992500D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6056:  6060) / 49, 36,   0.28312690D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6061:  6065) / 49, 37,   0.18285696D+04,   0.00000D+00,   0.00000D+00/
  data pars(  6066:  6070) / 49, 38,   0.15296862D+04,   0.00000D+00,   0.00000D+00/
  data pars(  6071:  6075) / 49, 39,   0.13118922D+04,   0.00000D+00,   0.00000D+00/
  data pars(  6076:  6080) / 49, 40,   0.11635963D+04,   0.00000D+00,   0.00000D+00/
  data pars(  6081:  6085) / 49, 41,   0.10518917D+04,   0.00000D+00,   0.00000D+00/
  data pars(  6086:  6090) / 49, 42,   0.79999940D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6091:  6095) / 49, 43,   0.89764510D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6096:  6100) / 49, 44,   0.67265160D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6101:  6105) / 49, 45,   0.73525250D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6106:  6110) / 49, 46,   0.67809960D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6111:  6115) / 49, 47,   0.56733030D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6116:  6120) / 49, 48,   0.59335740D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6121:  6125) / 49, 49,   0.75773970D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6126:  6130) / 50,  1,   0.41533400D+02,   0.00000D+00,   0.91180D+00/
  data pars(  6131:  6135) / 50,  2,   0.26786200D+02,   0.00000D+00,   0.00000D+00/
  data pars(  6136:  6140) / 50,  3,   0.70845970D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6141:  6145) / 50,  4,   0.39379910D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6146:  6150) / 50,  5,   0.25871460D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6151:  6155) / 50,  6,   0.17143670D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6156:  6160) / 50,  7,   0.11815090D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6161:  6165) / 50,  8,   0.88540800D+02,   0.00000D+00,   0.00000D+00/
  data pars(  6166:  6170) / 50,  9,   0.66499600D+02,   0.00000D+00,   0.00000D+00/
  data pars(  6171:  6175) / 50, 10,   0.50811000D+02,   0.00000D+00,   0.00000D+00/
  data pars(  6176:  6180) / 50, 11,   0.84513480D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6181:  6185) / 50, 12,   0.63194340D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6186:  6190) / 50, 13,   0.57540180D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6191:  6195) / 50, 14,   0.44576230D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6196:  6200) / 50, 15,   0.34241690D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6201:  6205) / 50, 16,   0.28132550D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6206:  6210) / 50, 17,   0.22756350D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6211:  6215) / 50, 18,   0.18458450D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6216:  6220) / 50, 19,   0.13902912D+04,   0.00000D+00,   0.00000D+00/
  data pars(  6221:  6225) / 50, 20,   0.11230616D+04,   0.00000D+00,   0.00000D+00/
  data pars(  6226:  6230) / 50, 21,   0.92301820D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6231:  6235) / 50, 22,   0.88663180D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6236:  6240) / 50, 23,   0.80941340D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6241:  6245) / 50, 24,   0.63665610D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6246:  6250) / 50, 25,   0.69374420D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6251:  6255) / 50, 26,   0.54336290D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6256:  6260) / 50, 27,   0.57281690D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6261:  6265) / 50, 28,   0.59204640D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6266:  6270) / 50, 29,   0.45320890D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6271:  6275) / 50, 30,   0.46119710D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6276:  6280) / 50, 31,   0.54805490D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6281:  6285) / 50, 32,   0.47710340D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6286:  6290) / 50, 33,   0.40194150D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6291:  6295) / 50, 34,   0.35778710D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6296:  6300) / 50, 35,   0.31050930D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6301:  6305) / 50, 36,   0.26795320D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6306:  6310) / 50, 37,   0.15543698D+04,   0.00000D+00,   0.00000D+00/
  data pars(  6311:  6315) / 50, 38,   0.13385665D+04,   0.00000D+00,   0.00000D+00/
  data pars(  6316:  6320) / 50, 39,   0.11613674D+04,   0.00000D+00,   0.00000D+00/
  data pars(  6321:  6325) / 50, 40,   0.10372812D+04,   0.00000D+00,   0.00000D+00/
  data pars(  6326:  6330) / 50, 41,   0.94177920D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6331:  6335) / 50, 42,   0.72129060D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6336:  6340) / 50, 43,   0.80723580D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6341:  6345) / 50, 44,   0.60961520D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6346:  6350) / 50, 45,   0.66689540D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6351:  6355) / 50, 46,   0.61675220D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6356:  6360) / 50, 47,   0.51444770D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6361:  6365) / 50, 48,   0.54154900D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6366:  6370) / 50, 49,   0.68561380D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6371:  6375) / 50, 50,   0.62756770D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6376:  6380) / 51,  1,   0.37768100D+02,   0.00000D+00,   0.91180D+00/
  data pars(  6381:  6385) / 51,  2,   0.24858300D+02,   0.00000D+00,   0.00000D+00/
  data pars(  6386:  6390) / 51,  3,   0.58668880D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6391:  6395) / 51,  4,   0.34030300D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6396:  6400) / 51,  5,   0.22904210D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6401:  6405) / 51,  6,   0.15448510D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6406:  6410) / 51,  7,   0.10784360D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6411:  6415) / 51,  8,   0.81535800D+02,   0.00000D+00,   0.00000D+00/
  data pars(  6416:  6420) / 51,  9,   0.61691200D+02,   0.00000D+00,   0.00000D+00/
  data pars(  6421:  6425) / 51, 10,   0.47407300D+02,   0.00000D+00,   0.00000D+00/
  data pars(  6426:  6430) / 51, 11,   0.70169030D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6431:  6435) / 51, 12,   0.54198260D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6436:  6440) / 51, 13,   0.49972920D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6441:  6445) / 51, 14,   0.39368990D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6446:  6450) / 51, 15,   0.30669120D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6451:  6455) / 51, 16,   0.25424180D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6456:  6460) / 51, 17,   0.20740430D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6461:  6465) / 51, 18,   0.16945330D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6466:  6470) / 51, 19,   0.11476700D+04,   0.00000D+00,   0.00000D+00/
  data pars(  6471:  6475) / 51, 20,   0.95065430D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6476:  6480) / 51, 21,   0.78583230D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6481:  6485) / 51, 22,   0.75894060D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6486:  6490) / 51, 23,   0.69506830D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6491:  6495) / 51, 24,   0.54719810D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6496:  6500) / 51, 25,   0.59851680D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6501:  6505) / 51, 26,   0.46945690D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6506:  6510) / 51, 27,   0.49804720D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6511:  6515) / 51, 28,   0.51305850D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6516:  6520) / 51, 29,   0.39302490D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6521:  6525) / 51, 30,   0.40386210D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6526:  6530) / 51, 31,   0.47839930D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6531:  6535) / 51, 32,   0.42186160D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6536:  6540) / 51, 33,   0.35955640D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6541:  6545) / 51, 34,   0.32236080D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6546:  6550) / 51, 35,   0.28180500D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6551:  6555) / 51, 36,   0.24479020D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6556:  6560) / 51, 37,   0.12861750D+04,   0.00000D+00,   0.00000D+00/
  data pars(  6561:  6565) / 51, 38,   0.11321713D+04,   0.00000D+00,   0.00000D+00/
  data pars(  6566:  6570) / 51, 39,   0.99240010D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6571:  6575) / 51, 40,   0.89208770D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6576:  6580) / 51, 41,   0.81343450D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6581:  6585) / 51, 42,   0.62768490D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6586:  6590) / 51, 43,   0.70051630D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6591:  6595) / 51, 44,   0.53338040D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6596:  6600) / 51, 45,   0.58333460D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6601:  6605) / 51, 46,   0.54091250D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6606:  6610) / 51, 47,   0.45064270D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6611:  6615) / 51, 48,   0.47657830D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6616:  6620) / 51, 49,   0.59828910D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6621:  6625) / 51, 50,   0.55335920D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6626:  6630) / 51, 51,   0.49293790D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6631:  6635) / 52,  1,   0.35484100D+02,   0.00000D+00,   0.91180D+00/
  data pars(  6636:  6640) / 52,  2,   0.23691100D+02,   0.00000D+00,   0.00000D+00/
  data pars(  6641:  6645) / 52,  3,   0.52125110D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6646:  6650) / 52,  4,   0.30954390D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6651:  6655) / 52,  5,   0.21148980D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6656:  6660) / 52,  6,   0.14430320D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6661:  6665) / 52,  7,   0.10161240D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6666:  6670) / 52,  8,   0.77297000D+02,   0.00000D+00,   0.00000D+00/
  data pars(  6671:  6675) / 52,  9,   0.58788100D+02,   0.00000D+00,   0.00000D+00/
  data pars(  6676:  6680) / 52, 10,   0.45361300D+02,   0.00000D+00,   0.00000D+00/
  data pars(  6681:  6685) / 52, 11,   0.62440760D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6686:  6690) / 52, 12,   0.49087600D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6691:  6695) / 52, 13,   0.45604000D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6696:  6700) / 52, 14,   0.36295180D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6701:  6705) / 52, 15,   0.28527790D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6706:  6710) / 52, 16,   0.23790180D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6711:  6715) / 52, 17,   0.19518610D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6716:  6720) / 52, 18,   0.16026740D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6721:  6725) / 52, 19,   0.10193121D+04,   0.00000D+00,   0.00000D+00/
  data pars(  6726:  6730) / 52, 20,   0.85518820D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6731:  6735) / 52, 21,   0.70913030D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6736:  6740) / 52, 22,   0.68712350D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6741:  6745) / 52, 23,   0.63049010D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6746:  6750) / 52, 24,   0.49691430D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6751:  6755) / 52, 25,   0.54441560D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6756:  6760) / 52, 26,   0.42764390D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6761:  6765) / 52, 27,   0.45508360D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6766:  6770) / 52, 28,   0.46784930D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6771:  6775) / 52, 29,   0.35881670D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6776:  6780) / 52, 30,   0.37059360D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6781:  6785) / 52, 31,   0.43811020D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6786:  6790) / 52, 32,   0.38929970D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6791:  6795) / 52, 33,   0.33422340D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6796:  6800) / 52, 34,   0.30105450D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6801:  6805) / 52, 35,   0.26445160D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6806:  6810) / 52, 36,   0.23074260D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6811:  6815) / 52, 37,   0.11441913D+04,   0.00000D+00,   0.00000D+00/
  data pars(  6816:  6820) / 52, 38,   0.10183413D+04,   0.00000D+00,   0.00000D+00/
  data pars(  6821:  6825) / 52, 39,   0.89780430D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6826:  6830) / 52, 40,   0.81010280D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6831:  6835) / 52, 41,   0.74062110D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6836:  6840) / 52, 42,   0.57429320D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6841:  6845) / 52, 43,   0.63974650D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6846:  6850) / 52, 44,   0.48969560D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6851:  6855) / 52, 45,   0.53521890D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6856:  6860) / 52, 46,   0.49709590D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6861:  6865) / 52, 47,   0.41415120D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6866:  6870) / 52, 48,   0.43888610D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6871:  6875) / 52, 49,   0.54812670D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6876:  6880) / 52, 50,   0.50996980D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6881:  6885) / 52, 51,   0.45710570D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6886:  6890) / 52, 52,   0.42553550D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6891:  6895) / 53,  1,   0.32517100D+02,   0.00000D+00,   0.91180D+00/
  data pars(  6896:  6900) / 53,  2,   0.22081300D+02,   0.00000D+00,   0.00000D+00/
  data pars(  6901:  6905) / 53,  3,   0.44985120D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6906:  6910) / 53,  4,   0.27373980D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6911:  6915) / 53,  5,   0.19010940D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6916:  6920) / 53,  6,   0.13140510D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6921:  6925) / 53,  7,   0.93456200D+02,   0.00000D+00,   0.00000D+00/
  data pars(  6926:  6930) / 53,  8,   0.71605900D+02,   0.00000D+00,   0.00000D+00/
  data pars(  6931:  6935) / 53,  9,   0.54799000D+02,   0.00000D+00,   0.00000D+00/
  data pars(  6936:  6940) / 53, 10,   0.42495400D+02,   0.00000D+00,   0.00000D+00/
  data pars(  6941:  6945) / 53, 11,   0.53985360D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6946:  6950) / 53, 12,   0.43217920D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6951:  6955) / 53, 13,   0.40476310D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6956:  6960) / 53, 14,   0.32569120D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6961:  6965) / 53, 15,   0.25851210D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6966:  6970) / 53, 16,   0.21703370D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6971:  6975) / 53, 17,   0.17923060D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6976:  6980) / 53, 18,   0.14802160D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6981:  6985) / 53, 19,   0.88017410D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6986:  6990) / 53, 20,   0.74793060D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6991:  6995) / 53, 21,   0.62218410D+03,   0.00000D+00,   0.00000D+00/
  data pars(  6996:  7000) / 53, 22,   0.60505080D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7001:  7005) / 53, 23,   0.55631660D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7006:  7010) / 53, 24,   0.43916600D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7011:  7015) / 53, 25,   0.48180770D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7016:  7020) / 53, 26,   0.37922120D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7021:  7025) / 53, 27,   0.40469290D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7026:  7030) / 53, 28,   0.41513030D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7031:  7035) / 53, 29,   0.31896420D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7036:  7040) / 53, 30,   0.33106510D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7041:  7045) / 53, 31,   0.39045420D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7046:  7050) / 53, 32,   0.34977600D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7051:  7055) / 53, 33,   0.30267430D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7056:  7060) / 53, 34,   0.27406300D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7061:  7065) / 53, 35,   0.24205560D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7066:  7070) / 53, 36,   0.21228200D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7071:  7075) / 53, 37,   0.98989210D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7076:  7080) / 53, 38,   0.89067230D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7081:  7085) / 53, 39,   0.79002570D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7086:  7090) / 53, 40,   0.71573180D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7091:  7095) / 53, 41,   0.65622760D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7096:  7100) / 53, 42,   0.51167720D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7101:  7105) / 53, 43,   0.56879090D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7106:  7110) / 53, 44,   0.43799920D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7111:  7115) / 53, 45,   0.47824810D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7116:  7120) / 53, 46,   0.44496620D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7121:  7125) / 53, 47,   0.37093440D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7126:  7130) / 53, 48,   0.39376550D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7131:  7135) / 53, 49,   0.48897090D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7136:  7140) / 53, 50,   0.45771560D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7141:  7145) / 53, 51,   0.41298520D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7146:  7150) / 53, 52,   0.38609970D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7151:  7155) / 53, 53,   0.35196670D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7156:  7160) / 54,  1,   0.29605500D+02,   0.00000D+00,   0.91180D+00/
  data pars(  7161:  7165) / 54,  2,   0.20459400D+02,   0.00000D+00,   0.00000D+00/
  data pars(  7166:  7170) / 54,  3,   0.38699690D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7171:  7175) / 54,  4,   0.24076890D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7176:  7180) / 54,  5,   0.16985780D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7181:  7185) / 54,  6,   0.11891780D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7186:  7190) / 54,  7,   0.85429300D+02,   0.00000D+00,   0.00000D+00/
  data pars(  7191:  7195) / 54,  8,   0.65940300D+02,   0.00000D+00,   0.00000D+00/
  data pars(  7196:  7200) / 54,  9,   0.50790000D+02,   0.00000D+00,   0.00000D+00/
  data pars(  7201:  7205) / 54, 10,   0.39595100D+02,   0.00000D+00,   0.00000D+00/
  data pars(  7206:  7210) / 54, 11,   0.46528170D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7211:  7215) / 54, 12,   0.37861340D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7216:  7220) / 54, 13,   0.35729600D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7221:  7225) / 54, 14,   0.29049850D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7226:  7230) / 54, 15,   0.23277860D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7231:  7235) / 54, 16,   0.19673740D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7236:  7240) / 54, 17,   0.16353680D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7241:  7245) / 54, 18,   0.13585920D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7246:  7250) / 54, 19,   0.75832530D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7251:  7255) / 54, 20,   0.65153920D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7256:  7260) / 54, 21,   0.54356310D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7261:  7265) / 54, 22,   0.53043120D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7266:  7270) / 54, 23,   0.48865220D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7271:  7275) / 54, 24,   0.38650670D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7276:  7280) / 54, 25,   0.42441250D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7281:  7285) / 54, 26,   0.33482590D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7286:  7290) / 54, 27,   0.35809540D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7291:  7295) / 54, 28,   0.36655970D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7296:  7300) / 54, 29,   0.28228880D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7301:  7305) / 54, 30,   0.29421380D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7306:  7310) / 54, 31,   0.34613450D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7311:  7315) / 54, 32,   0.31242650D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7316:  7320) / 54, 33,   0.27241100D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7321:  7325) / 54, 34,   0.24792750D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7326:  7330) / 54, 35,   0.22015810D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7331:  7335) / 54, 36,   0.19406990D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7336:  7340) / 54, 37,   0.85452230D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7341:  7345) / 54, 38,   0.77608590D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7346:  7350) / 54, 39,   0.69223860D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7351:  7355) / 54, 40,   0.62952300D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7356:  7360) / 54, 41,   0.57878760D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7361:  7365) / 54, 42,   0.45379980D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7366:  7370) / 54, 43,   0.50338110D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7371:  7375) / 54, 44,   0.38995320D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7376:  7380) / 54, 45,   0.42526840D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7381:  7385) / 54, 46,   0.39634680D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7386:  7390) / 54, 47,   0.33076460D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7391:  7395) / 54, 48,   0.35152850D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7396:  7400) / 54, 49,   0.43409320D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7401:  7405) / 54, 50,   0.40859520D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7406:  7410) / 54, 51,   0.37095720D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7411:  7415) / 54, 52,   0.34822390D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7416:  7420) / 54, 53,   0.31889050D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7421:  7425) / 54, 54,   0.29022230D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7426:  7430) / 55,  1,   0.10500960D+03,   0.00000D+00,   0.91180D+00/
  data pars(  7431:  7435) / 55,  2,   0.61318400D+02,   0.00000D+00,   0.00000D+00/
  data pars(  7436:  7440) / 55,  3,   0.32422404D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7441:  7445) / 55,  4,   0.13162189D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7446:  7450) / 55,  5,   0.75492430D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7451:  7455) / 55,  6,   0.45569600D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7456:  7460) / 55,  7,   0.29414830D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7461:  7465) / 55,  8,   0.21086720D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7466:  7470) / 55,  9,   0.15256720D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7471:  7475) / 55, 10,   0.11317640D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7476:  7480) / 55, 11,   0.37989439D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7481:  7485) / 55, 12,   0.22209652D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7486:  7490) / 55, 13,   0.18817164D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7491:  7495) / 55, 14,   0.13170056D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7496:  7500) / 55, 15,   0.93630690D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7501:  7505) / 55, 16,   0.73500610D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7506:  7510) / 55, 17,   0.56967010D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7511:  7515) / 55, 18,   0.44581710D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7516:  7520) / 55, 19,   0.68083900D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7521:  7525) / 55, 20,   0.43871669D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7526:  7530) / 55, 21,   0.34508369D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7531:  7535) / 55, 22,   0.32158544D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7536:  7540) / 55, 23,   0.28775279D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7541:  7545) / 55, 24,   0.22830674D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7546:  7550) / 55, 25,   0.23963445D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7551:  7555) / 55, 26,   0.18842824D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7556:  7560) / 55, 27,   0.18757209D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7561:  7565) / 55, 28,   0.19768609D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7566:  7570) / 55, 29,   0.15334063D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7571:  7575) / 55, 30,   0.14430004D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7576:  7580) / 55, 31,   0.17555105D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7581:  7585) / 55, 32,   0.14062206D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7586:  7590) / 55, 33,   0.11083145D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7591:  7595) / 55, 34,   0.95019750D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7596:  7600) / 55, 35,   0.79421840D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7601:  7605) / 55, 36,   0.66295560D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7606:  7610) / 55, 37,   0.75604361D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7611:  7615) / 55, 38,   0.53051627D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7616:  7620) / 55, 39,   0.42896097D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7621:  7625) / 55, 40,   0.36748556D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7626:  7630) / 55, 41,   0.32563633D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7631:  7635) / 55, 42,   0.23987520D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7636:  7640) / 55, 43,   0.27260486D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7641:  7645) / 55, 44,   0.19683066D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7646:  7650) / 55, 45,   0.21299275D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7651:  7655) / 55, 46,   0.19358392D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7656:  7660) / 55, 47,   0.16577829D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7661:  7665) / 55, 48,   0.16630447D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7666:  7670) / 55, 49,   0.22264867D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7671:  7675) / 55, 50,   0.18919207D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7676:  7680) / 55, 51,   0.15665042D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7681:  7685) / 55, 52,   0.13945709D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7686:  7690) / 55, 53,   0.12075672D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7691:  7695) / 55, 54,   0.10433955D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7696:  7700) / 55, 55,   0.93307294D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7701:  7705) / 56,  1,   0.99457900D+02,   0.00000D+00,   0.91180D+00/
  data pars(  7706:  7710) / 56,  2,   0.59114100D+02,   0.00000D+00,   0.00000D+00/
  data pars(  7711:  7715) / 56,  3,   0.25515260D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7716:  7720) / 56,  4,   0.11604419D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7721:  7725) / 56,  5,   0.69068520D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7726:  7730) / 56,  6,   0.42636670D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7731:  7735) / 56,  7,   0.27907420D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7736:  7740) / 56,  8,   0.20174110D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7741:  7745) / 56,  9,   0.14691740D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7746:  7750) / 56, 10,   0.10950000D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7751:  7755) / 56, 11,   0.30097233D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7756:  7760) / 56, 12,   0.19263504D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7761:  7765) / 56, 13,   0.16657662D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7766:  7770) / 56, 14,   0.12012021D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7771:  7775) / 56, 15,   0.87116470D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7776:  7780) / 56, 16,   0.69086510D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7781:  7785) / 56, 17,   0.54031600D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7786:  7790) / 56, 18,   0.42579090D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7791:  7795) / 56, 19,   0.51712978D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7796:  7800) / 56, 20,   0.36591655D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7801:  7805) / 56, 21,   0.29244395D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7806:  7810) / 56, 22,   0.27489797D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7811:  7815) / 56, 23,   0.24751427D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7816:  7820) / 56, 24,   0.19521126D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7821:  7825) / 56, 25,   0.20794950D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7826:  7830) / 56, 26,   0.16284040D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7831:  7835) / 56, 27,   0.16569384D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7836:  7840) / 56, 28,   0.17363987D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7841:  7845) / 56, 29,   0.13357319D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7846:  7850) / 56, 30,   0.12926630D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7851:  7855) / 56, 31,   0.15597012D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7856:  7860) / 56, 32,   0.12819152D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7861:  7865) / 56, 33,   0.10285424D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7866:  7870) / 56, 34,   0.88961470D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7871:  7875) / 56, 35,   0.74984750D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7876:  7880) / 56, 36,   0.63024360D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7881:  7885) / 56, 37,   0.57435673D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7886:  7890) / 56, 38,   0.43943607D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7891:  7895) / 56, 39,   0.36394735D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7896:  7900) / 56, 40,   0.31601776D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7901:  7905) / 56, 41,   0.28195147D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7906:  7910) / 56, 42,   0.20984813D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7911:  7915) / 56, 43,   0.23739131D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7916:  7920) / 56, 44,   0.17354827D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7921:  7925) / 56, 45,   0.18901371D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7926:  7930) / 56, 46,   0.17272738D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7931:  7935) / 56, 47,   0.14605858D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7936:  7940) / 56, 48,   0.14937369D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7941:  7945) / 56, 49,   0.19640913D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7946:  7950) / 56, 50,   0.17108832D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7951:  7955) / 56, 51,   0.14425135D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7956:  7960) / 56, 52,   0.12956354D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7961:  7965) / 56, 53,   0.11317221D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7966:  7970) / 56, 54,   0.98512660D+03,   0.00000D+00,   0.00000D+00/
  data pars(  7971:  7975) / 56, 55,   0.70164917D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7976:  7980) / 56, 56,   0.57269887D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7981:  7985) / 57,  1,   0.89101800D+02,   0.00000D+00,   0.91180D+00/
  data pars(  7986:  7990) / 57,  2,   0.53798200D+02,   0.00000D+00,   0.00000D+00/
  data pars(  7991:  7995) / 57,  3,   0.20850661D+04,   0.00000D+00,   0.00000D+00/
  data pars(  7996:  8000) / 57,  4,   0.99403160D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8001:  8005) / 57,  5,   0.60449150D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8006:  8010) / 57,  6,   0.37879280D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8011:  8015) / 57,  7,   0.25055770D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8016:  8020) / 57,  8,   0.18240750D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8021:  8025) / 57,  9,   0.13361230D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8026:  8030) / 57, 10,   0.10002770D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8031:  8035) / 57, 11,   0.24655965D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8036:  8040) / 57, 12,   0.16371586D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8041:  8045) / 57, 13,   0.14317496D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8046:  8050) / 57, 14,   0.10491934D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8051:  8055) / 57, 15,   0.77049240D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8056:  8060) / 57, 16,   0.61555590D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8061:  8065) / 57, 17,   0.48476910D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8066:  8070) / 57, 18,   0.38423060D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8071:  8075) / 57, 19,   0.41858968D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8076:  8080) / 57, 20,   0.30598941D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8081:  8085) / 57, 21,   0.24617619D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8086:  8090) / 57, 22,   0.23247454D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8091:  8095) / 57, 23,   0.20995853D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8096:  8100) / 57, 24,   0.16534435D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8101:  8105) / 57, 25,   0.17717653D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8106:  8110) / 57, 26,   0.13863132D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8111:  8115) / 57, 27,   0.14234023D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8116:  8120) / 57, 28,   0.14871454D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8121:  8125) / 57, 29,   0.11414078D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8126:  8130) / 57, 30,   0.11183973D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8131:  8135) / 57, 31,   0.13447968D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8136:  8140) / 57, 32,   0.11200021D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8141:  8145) / 57, 33,   0.90836700D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8146:  8150) / 57, 34,   0.79048550D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8151:  8155) / 57, 35,   0.67038430D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8156:  8160) / 57, 36,   0.56651010D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8161:  8165) / 57, 37,   0.46537454D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8166:  8170) / 57, 38,   0.36666556D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8171:  8175) / 57, 39,   0.30693037D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8176:  8180) / 57, 40,   0.26820879D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8181:  8185) / 57, 41,   0.24019326D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8186:  8190) / 57, 42,   0.17981970D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8191:  8195) / 57, 43,   0.20296163D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8196:  8200) / 57, 44,   0.14938895D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8201:  8205) / 57, 45,   0.16299126D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8206:  8210) / 57, 46,   0.14934855D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8211:  8215) / 57, 47,   0.12574297D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8216:  8220) / 57, 48,   0.12959364D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8221:  8225) / 57, 49,   0.16894085D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8226:  8230) / 57, 50,   0.14890440D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8231:  8235) / 57, 51,   0.12682622D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8236:  8240) / 57, 52,   0.11455595D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8241:  8245) / 57, 53,   0.10065104D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8246:  8250) / 57, 54,   0.88082020D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8251:  8255) / 57, 55,   0.56757434D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8256:  8260) / 57, 56,   0.47544826D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8261:  8265) / 57, 57,   0.39906172D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8266:  8270) / 58,  1,   0.44510400D+02,   0.27991D+01,   0.91180D+00/
  data pars(  8271:  8275) / 58,  2,   0.29308100D+02,   0.27991D+01,   0.00000D+00/
  data pars(  8276:  8280) / 58,  3,   0.70433450D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8281:  8285) / 58,  4,   0.40374270D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8286:  8290) / 58,  5,   0.27061870D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8291:  8295) / 58,  6,   0.18221640D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8296:  8300) / 58,  7,   0.12713550D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8301:  8305) / 58,  8,   0.96118900D+02,   0.27991D+01,   0.00000D+00/
  data pars(  8306:  8310) / 58,  9,   0.72735900D+02,   0.27991D+01,   0.00000D+00/
  data pars(  8311:  8315) / 58, 10,   0.55904800D+02,   0.27991D+01,   0.00000D+00/
  data pars(  8316:  8320) / 58, 11,   0.84189860D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8321:  8325) / 58, 12,   0.64422200D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8326:  8330) / 58, 13,   0.59240470D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8331:  8335) / 58, 14,   0.46526310D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8336:  8340) / 58, 15,   0.36180150D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8341:  8345) / 58, 16,   0.29974470D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8346:  8350) / 58, 17,   0.24444680D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8351:  8355) / 58, 18,   0.19971380D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8356:  8360) / 58, 19,   0.13810183D+04,   0.27991D+01,   0.00000D+00/
  data pars(  8361:  8365) / 58, 20,   0.11346748D+04,   0.27991D+01,   0.00000D+00/
  data pars(  8366:  8370) / 58, 21,   0.93640680D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8371:  8375) / 58, 22,   0.90333060D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8376:  8380) / 58, 23,   0.82670470D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8381:  8385) / 58, 24,   0.65114400D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8386:  8390) / 58, 25,   0.71114230D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8391:  8395) / 58, 26,   0.55801770D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8396:  8400) / 58, 27,   0.59073870D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8401:  8405) / 58, 28,   0.60892420D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8406:  8410) / 58, 29,   0.46681100D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8411:  8415) / 58, 30,   0.47833500D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8416:  8420) / 58, 31,   0.56687830D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8421:  8425) / 58, 32,   0.49862840D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8426:  8430) / 58, 33,   0.42429060D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8431:  8435) / 58, 34,   0.38016060D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8436:  8440) / 58, 35,   0.33218840D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8441:  8445) / 58, 36,   0.28850100D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8446:  8450) / 58, 37,   0.15470780D+04,   0.27991D+01,   0.00000D+00/
  data pars(  8451:  8455) / 58, 38,   0.13520803D+04,   0.27991D+01,   0.00000D+00/
  data pars(  8456:  8460) / 58, 39,   0.11820124D+04,   0.27991D+01,   0.00000D+00/
  data pars(  8461:  8465) / 58, 40,   0.10609721D+04,   0.27991D+01,   0.00000D+00/
  data pars(  8466:  8470) / 58, 41,   0.96662010D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8471:  8475) / 58, 42,   0.74511760D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8476:  8480) / 58, 43,   0.83183600D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8481:  8485) / 58, 44,   0.63266390D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8486:  8490) / 58, 45,   0.69156460D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8491:  8495) / 58, 46,   0.64096110D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8496:  8500) / 58, 47,   0.53459930D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8501:  8505) / 58, 48,   0.56439100D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8506:  8510) / 58, 49,   0.70950090D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8511:  8515) / 58, 50,   0.65467230D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8516:  8520) / 58, 51,   0.58216180D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8521:  8525) / 58, 52,   0.53941670D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8526:  8530) / 58, 53,   0.48703330D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8531:  8535) / 58, 54,   0.43728340D+03,   0.27991D+01,   0.00000D+00/
  data pars(  8536:  8540) / 58, 55,   0.18844554D+04,   0.27991D+01,   0.00000D+00/
  data pars(  8541:  8545) / 58, 56,   0.17247415D+04,   0.27991D+01,   0.00000D+00/
  data pars(  8546:  8550) / 58, 57,   0.15122504D+04,   0.27991D+01,   0.00000D+00/
  data pars(  8551:  8555) / 58, 58,   0.68803530D+03,   0.27991D+01,   0.27991D+01/
  data pars(  8556:  8560) / 59,  1,   0.88687700D+02,   0.00000D+00,   0.91180D+00/
  data pars(  8561:  8565) / 59,  2,   0.53152300D+02,   0.00000D+00,   0.00000D+00/
  data pars(  8566:  8570) / 59,  3,   0.22103168D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8571:  8575) / 59,  4,   0.10189540D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8576:  8580) / 59,  5,   0.61076150D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8581:  8585) / 59,  6,   0.37910380D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8586:  8590) / 59,  7,   0.24926330D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8591:  8595) / 59,  8,   0.18083830D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8596:  8600) / 59,  9,   0.13215840D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8601:  8605) / 59, 10,   0.98822000D+02,   0.00000D+00,   0.00000D+00/
  data pars(  8606:  8610) / 59, 11,   0.26090440D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8611:  8615) / 59, 12,   0.16875419D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8616:  8620) / 59, 13,   0.14644446D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8621:  8625) / 59, 14,   0.10615213D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8626:  8630) / 59, 15,   0.77317210D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8631:  8635) / 59, 16,   0.61486520D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8636:  8640) / 59, 17,   0.48225090D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8641:  8645) / 59, 18,   0.38105030D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8646:  8650) / 59, 19,   0.44737784D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8651:  8655) / 59, 20,   0.31902086D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8656:  8660) / 59, 21,   0.25547353D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8661:  8665) / 59, 22,   0.24050561D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8666:  8670) / 59, 23,   0.21676325D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8671:  8675) / 59, 24,   0.17091137D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8676:  8680) / 59, 25,   0.18237858D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8681:  8685) / 59, 26,   0.14281039D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8686:  8690) / 59, 27,   0.14570358D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8691:  8695) / 59, 28,   0.15254141D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8696:  8700) / 59, 29,   0.11729549D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8701:  8705) / 59, 30,   0.11394352D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8706:  8710) / 59, 31,   0.13728649D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8711:  8715) / 59, 32,   0.11331627D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8716:  8720) / 59, 33,   0.91252630D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8721:  8725) / 59, 34,   0.79102140D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8726:  8730) / 59, 35,   0.66833280D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8731:  8735) / 59, 36,   0.56301560D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8736:  8740) / 59, 37,   0.49710778D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8741:  8745) / 59, 38,   0.38289626D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8746:  8750) / 59, 39,   0.31814405D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8751:  8755) / 59, 40,   0.27679894D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8756:  8760) / 59, 41,   0.24726905D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8761:  8765) / 59, 42,   0.18440715D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8766:  8770) / 59, 43,   0.20845975D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8771:  8775) / 59, 44,   0.15276056D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8776:  8780) / 59, 45,   0.16644640D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8781:  8785) / 59, 46,   0.15224806D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8786:  8790) / 59, 47,   0.12860441D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8791:  8795) / 59, 48,   0.13182791D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8796:  8800) / 59, 49,   0.17282162D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8801:  8805) / 59, 50,   0.15110459D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8806:  8810) / 59, 51,   0.12783406D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8811:  8815) / 59, 52,   0.11504200D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8816:  8820) / 59, 53,   0.10070198D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8821:  8825) / 59, 54,   0.87837980D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8826:  8830) / 59, 55,   0.60738935D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8831:  8835) / 59, 56,   0.49833126D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8836:  8840) / 59, 57,   0.41503203D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8841:  8845) / 59, 58,   0.15271461D+04,   0.00000D+00,   0.27991D+01/
  data pars(  8846:  8850) / 59, 59,   0.43422386D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8851:  8855) / 60,  1,   0.85408000D+02,   0.00000D+00,   0.91180D+00/
  data pars(  8856:  8860) / 60,  2,   0.51295200D+02,   0.00000D+00,   0.00000D+00/
  data pars(  8861:  8865) / 60,  3,   0.20915068D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8866:  8870) / 60,  4,   0.97461670D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8871:  8875) / 60,  5,   0.58618960D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8876:  8880) / 60,  6,   0.36465190D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8881:  8885) / 60,  7,   0.24011390D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8886:  8890) / 60,  8,   0.17436780D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8891:  8895) / 60,  9,   0.12753080D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8896:  8900) / 60, 10,   0.95420200D+02,   0.00000D+00,   0.00000D+00/
  data pars(  8901:  8905) / 60, 11,   0.24706020D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8906:  8910) / 60, 12,   0.16117831D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8911:  8915) / 60, 13,   0.14013191D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8916:  8920) / 60, 14,   0.10185098D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8921:  8925) / 60, 15,   0.74324070D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8926:  8930) / 60, 16,   0.59167520D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8931:  8935) / 60, 17,   0.46450620D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8936:  8940) / 60, 18,   0.36731630D+03,   0.00000D+00,   0.00000D+00/
  data pars(  8941:  8945) / 60, 19,   0.42163998D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8946:  8950) / 60, 20,   0.30363662D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8951:  8955) / 60, 21,   0.24350889D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8956:  8960) / 60, 22,   0.22942857D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8961:  8965) / 60, 23,   0.20689809D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8966:  8970) / 60, 24,   0.16306018D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8971:  8975) / 60, 25,   0.17421942D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8976:  8980) / 60, 26,   0.13638456D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8981:  8985) / 60, 27,   0.13940822D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8986:  8990) / 60, 28,   0.14587399D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8991:  8995) / 60, 29,   0.11209931D+04,   0.00000D+00,   0.00000D+00/
  data pars(  8996:  9000) / 60, 30,   0.10915722D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9001:  9005) / 60, 31,   0.13142306D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9006:  9010) / 60, 32,   0.10872533D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9011:  9015) / 60, 33,   0.87700660D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9016:  9020) / 60, 34,   0.76089490D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9021:  9025) / 60, 35,   0.64343050D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9026:  9030) / 60, 36,   0.54243830D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9031:  9035) / 60, 37,   0.46850846D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9036:  9040) / 60, 38,   0.36420492D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9041:  9045) / 60, 39,   0.30329183D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9046:  9050) / 60, 40,   0.26420526D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9051:  9055) / 60, 41,   0.23616974D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9056:  9060) / 60, 42,   0.17631139D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9061:  9065) / 60, 43,   0.19921534D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9066:  9070) / 60, 44,   0.14616458D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9071:  9075) / 60, 45,   0.15933696D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9076:  9080) / 60, 46,   0.14581671D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9081:  9085) / 60, 47,   0.12304969D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9086:  9090) / 60, 48,   0.12633482D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9091:  9095) / 60, 49,   0.16535039D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9096:  9100) / 60, 50,   0.14488711D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9101:  9105) / 60, 51,   0.12277455D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9106:  9110) / 60, 52,   0.11058143D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9111:  9115) / 60, 53,   0.96879470D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9116:  9120) / 60, 54,   0.84567030D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9121:  9125) / 60, 55,   0.57167999D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9126:  9130) / 60, 56,   0.47334185D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9131:  9135) / 60, 57,   0.39519956D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9136:  9140) / 60, 58,   0.14659695D+04,   0.00000D+00,   0.27991D+01/
  data pars(  9141:  9145) / 60, 59,   0.41259023D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9146:  9150) / 60, 60,   0.39244211D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9151:  9155) / 61,  1,   0.83331000D+02,   0.00000D+00,   0.91180D+00/
  data pars(  9156:  9160) / 61,  2,   0.50074800D+02,   0.00000D+00,   0.00000D+00/
  data pars(  9161:  9165) / 61,  3,   0.20312740D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9166:  9170) / 61,  4,   0.94912550D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9171:  9175) / 61,  5,   0.57141130D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9176:  9180) / 61,  6,   0.35567120D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9181:  9185) / 61,  7,   0.23429130D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9186:  9190) / 61,  8,   0.17018170D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9191:  9195) / 61,  9,   0.12449460D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9196:  9200) / 61, 10,   0.93163500D+02,   0.00000D+00,   0.00000D+00/
  data pars(  9201:  9205) / 61, 11,   0.23998207D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9206:  9210) / 61, 12,   0.15689885D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9211:  9215) / 61, 13,   0.13648494D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9216:  9220) / 61, 14,   0.99275070D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9221:  9225) / 61, 15,   0.72481970D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9226:  9230) / 61, 16,   0.57716960D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9231:  9235) / 61, 17,   0.45323130D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9236:  9240) / 61, 18,   0.35847210D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9241:  9245) / 61, 19,   0.40920575D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9246:  9250) / 61, 20,   0.29529794D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9251:  9255) / 61, 21,   0.23691244D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9256:  9260) / 61, 22,   0.22326503D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9261:  9265) / 61, 23,   0.20137194D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9266:  9270) / 61, 24,   0.15868512D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9271:  9275) / 61, 25,   0.16960441D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9276:  9280) / 61, 26,   0.13276064D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9281:  9285) / 61, 27,   0.13577395D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9286:  9290) / 61, 28,   0.14205045D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9291:  9295) / 61, 29,   0.10914214D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9296:  9300) / 61, 30,   0.10634898D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9301:  9305) / 61, 31,   0.12801762D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9306:  9310) / 61, 32,   0.10597536D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9311:  9315) / 61, 33,   0.85521770D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9316:  9320) / 61, 34,   0.74216490D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9321:  9325) / 61, 35,   0.62773420D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9326:  9330) / 61, 36,   0.52930700D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9331:  9335) / 61, 37,   0.45470720D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9336:  9340) / 61, 38,   0.35414930D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9341:  9345) / 61, 39,   0.29509303D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9346:  9350) / 61, 40,   0.25714964D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9351:  9355) / 61, 41,   0.22990481D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9356:  9360) / 61, 42,   0.17168038D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9361:  9365) / 61, 43,   0.19396215D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9366:  9370) / 61, 44,   0.14235531D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9371:  9375) / 61, 45,   0.15520522D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9376:  9380) / 61, 46,   0.14205469D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9381:  9385) / 61, 47,   0.11984194D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9386:  9390) / 61, 48,   0.12309598D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9391:  9395) / 61, 49,   0.16104142D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9396:  9400) / 61, 50,   0.14119588D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9401:  9405) / 61, 51,   0.11970157D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9406:  9410) / 61, 52,   0.10783854D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9411:  9415) / 61, 53,   0.94498140D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9416:  9420) / 61, 54,   0.82504730D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9421:  9425) / 61, 55,   0.55474900D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9426:  9430) / 61, 56,   0.46012171D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9431:  9435) / 61, 57,   0.38440367D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9436:  9440) / 61, 58,   0.14290690D+04,   0.00000D+00,   0.27991D+01/
  data pars(  9441:  9445) / 61, 59,   0.40113635D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9446:  9450) / 61, 60,   0.38161118D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9451:  9455) / 61, 61,   0.37109375D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9456:  9460) / 62,  1,   0.81412300D+02,   0.00000D+00,   0.91180D+00/
  data pars(  9461:  9465) / 62,  2,   0.48940600D+02,   0.00000D+00,   0.00000D+00/
  data pars(  9466:  9470) / 62,  3,   0.19766955D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9471:  9475) / 62,  4,   0.92581580D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9476:  9480) / 62,  5,   0.55783800D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9481:  9485) / 62,  6,   0.34739210D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9486:  9490) / 62,  7,   0.22890650D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9491:  9495) / 62,  8,   0.16630040D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9496:  9500) / 62,  9,   0.12167270D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9501:  9505) / 62, 10,   0.91061400D+02,   0.00000D+00,   0.00000D+00/
  data pars(  9506:  9510) / 62, 11,   0.23356474D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9511:  9515) / 62, 12,   0.15299120D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9516:  9520) / 62, 13,   0.13314786D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9521:  9525) / 62, 14,   0.96910260D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9526:  9530) / 62, 15,   0.70786040D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9531:  9535) / 62, 16,   0.56378900D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9536:  9540) / 62, 17,   0.44280950D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9541:  9545) / 62, 18,   0.35028120D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9546:  9550) / 62, 19,   0.39796309D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9551:  9555) / 62, 20,   0.28770680D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9556:  9560) / 62, 21,   0.23089962D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9561:  9565) / 62, 22,   0.21764184D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9566:  9570) / 62, 23,   0.19632723D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9571:  9575) / 62, 24,   0.15469195D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9576:  9580) / 62, 25,   0.16538773D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9581:  9585) / 62, 26,   0.12944951D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9586:  9590) / 62, 27,   0.13244770D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9591:  9595) / 62, 28,   0.13855313D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9596:  9600) / 62, 29,   0.10643798D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9601:  9605) / 62, 30,   0.10377490D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9606:  9610) / 62, 31,   0.12489915D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9611:  9615) / 62, 32,   0.10345024D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9616:  9620) / 62, 33,   0.83516220D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9621:  9625) / 62, 34,   0.72489870D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9626:  9630) / 62, 35,   0.61324050D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9631:  9635) / 62, 36,   0.51716170D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9636:  9640) / 62, 37,   0.44222696D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9641:  9645) / 62, 38,   0.34499906D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9646:  9650) / 62, 39,   0.28761716D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9651:  9655) / 62, 40,   0.25070805D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9656:  9660) / 62, 41,   0.22418085D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9661:  9665) / 62, 42,   0.16744360D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9666:  9670) / 62, 43,   0.18915883D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9671:  9675) / 62, 44,   0.13886668D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9676:  9680) / 62, 45,   0.15142016D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9681:  9685) / 62, 46,   0.13860622D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9686:  9690) / 62, 47,   0.11690360D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9691:  9695) / 62, 48,   0.12012473D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9696:  9700) / 62, 49,   0.15709643D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9701:  9705) / 62, 50,   0.13780830D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9706:  9710) / 62, 51,   0.11687524D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9711:  9715) / 62, 52,   0.10531255D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9716:  9720) / 62, 53,   0.92301940D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9721:  9725) / 62, 54,   0.80600020D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9726:  9730) / 62, 55,   0.53944846D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9731:  9735) / 62, 56,   0.44810449D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9736:  9740) / 62, 57,   0.37456921D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9741:  9745) / 62, 58,   0.13951471D+04,   0.00000D+00,   0.27991D+01/
  data pars(  9746:  9750) / 62, 59,   0.39071923D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9751:  9755) / 62, 60,   0.37175407D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9756:  9760) / 62, 61,   0.36152067D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9761:  9765) / 62, 62,   0.35220508D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9766:  9770) / 63,  1,   0.79713800D+02,   0.00000D+00,   0.91180D+00/
  data pars(  9771:  9775) / 63,  2,   0.47936500D+02,   0.00000D+00,   0.00000D+00/
  data pars(  9776:  9780) / 63,  3,   0.19280810D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9781:  9785) / 63,  4,   0.90511010D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9786:  9790) / 63,  5,   0.54580150D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9791:  9795) / 63,  6,   0.34005800D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9796:  9800) / 63,  7,   0.22413830D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9801:  9805) / 63,  8,   0.16286380D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9806:  9810) / 63,  9,   0.11917340D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9811:  9815) / 63, 10,   0.89198800D+02,   0.00000D+00,   0.00000D+00/
  data pars(  9816:  9820) / 63, 11,   0.22784898D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9821:  9825) / 63, 12,   0.14951792D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9826:  9830) / 63, 13,   0.13018438D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9831:  9835) / 63, 14,   0.94812880D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9836:  9840) / 63, 15,   0.69283380D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9841:  9845) / 63, 16,   0.55193900D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9846:  9850) / 63, 17,   0.43358310D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9851:  9855) / 63, 18,   0.34303070D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9856:  9860) / 63, 19,   0.38794729D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9861:  9865) / 63, 20,   0.28095233D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9866:  9870) / 63, 21,   0.22555157D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9871:  9875) / 63, 22,   0.21264190D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9876:  9880) / 63, 23,   0.19184254D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9881:  9885) / 63, 24,   0.15114156D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9886:  9890) / 63, 25,   0.16164023D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9891:  9895) / 63, 26,   0.12650643D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9896:  9900) / 63, 27,   0.12949313D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9901:  9905) / 63, 28,   0.13544595D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9906:  9910) / 63, 29,   0.10403490D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9911:  9915) / 63, 30,   0.10148959D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9916:  9920) / 63, 31,   0.12213030D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9921:  9925) / 63, 32,   0.10121053D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9926:  9930) / 63, 33,   0.81738880D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9931:  9935) / 63, 34,   0.70960390D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9936:  9940) / 63, 35,   0.60040640D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9941:  9945) / 63, 36,   0.50640980D+03,   0.00000D+00,   0.00000D+00/
  data pars(  9946:  9950) / 63, 37,   0.43110961D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9951:  9955) / 63, 38,   0.33685646D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9956:  9960) / 63, 39,   0.28096885D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9961:  9965) / 63, 40,   0.24498188D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9966:  9970) / 63, 41,   0.21909387D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9971:  9975) / 63, 42,   0.16367956D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9976:  9980) / 63, 43,   0.18489097D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9981:  9985) / 63, 44,   0.13576810D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9986:  9990) / 63, 45,   0.14805878D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9991:  9995) / 63, 46,   0.13554425D+04,   0.00000D+00,   0.00000D+00/
  data pars(  9996: 10000) / 63, 47,   0.11429352D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10001: 10005) / 63, 48,   0.11748699D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10006: 10010) / 63, 49,   0.15359254D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10011: 10015) / 63, 50,   0.13480216D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10016: 10020) / 63, 51,   0.11436919D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10021: 10025) / 63, 52,   0.10307380D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10026: 10030) / 63, 53,   0.90356300D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10031: 10035) / 63, 54,   0.78913200D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10036: 10040) / 63, 55,   0.52582068D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10041: 10045) / 63, 56,   0.43740826D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10046: 10050) / 63, 57,   0.36582120D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10051: 10055) / 63, 58,   0.13650615D+04,   0.00000D+00,   0.27991D+01/
  data pars( 10056: 10060) / 63, 59,   0.38144921D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10061: 10065) / 63, 60,   0.36298268D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10066: 10070) / 63, 61,   0.35300228D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10071: 10075) / 63, 62,   0.34391601D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10076: 10080) / 63, 63,   0.33583122D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10081: 10085) / 64,  1,   0.64188000D+02,   0.00000D+00,   0.91180D+00/
  data pars( 10086: 10090) / 64,  2,   0.39578600D+02,   0.00000D+00,   0.00000D+00/
  data pars( 10091: 10095) / 64,  3,   0.14077335D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10096: 10100) / 64,  4,   0.68992870D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10101: 10105) / 64,  5,   0.42648970D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10106: 10110) / 64,  6,   0.27091830D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10111: 10115) / 64,  7,   0.18125810D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10116: 10120) / 64,  8,   0.13314380D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10121: 10125) / 64,  9,   0.98357300D+02,   0.00000D+00,   0.00000D+00/
  data pars( 10126: 10130) / 64, 10,   0.74191200D+02,   0.00000D+00,   0.00000D+00/
  data pars( 10131: 10135) / 64, 11,   0.16673895D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10136: 10140) / 64, 12,   0.11308198D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10141: 10145) / 64, 13,   0.99679240D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10146: 10150) / 64, 14,   0.73902000D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10151: 10155) / 64, 15,   0.54836330D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10156: 10160) / 64, 16,   0.44123030D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10161: 10165) / 64, 17,   0.35003690D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10166: 10170) / 64, 18,   0.27935150D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10171: 10175) / 64, 19,   0.28176333D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10176: 10180) / 64, 20,   0.20945326D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10181: 10185) / 64, 21,   0.16917052D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10186: 10190) / 64, 22,   0.16028927D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10191: 10195) / 64, 23,   0.14507174D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10196: 10200) / 64, 24,   0.11427015D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10201: 10205) / 64, 25,   0.12280426D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10206: 10210) / 64, 26,   0.96156000D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10211: 10215) / 64, 27,   0.99206730D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10216: 10220) / 64, 28,   0.10341932D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10221: 10225) / 64, 29,   0.79387630D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10226: 10230) / 64, 30,   0.78351140D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10231: 10235) / 64, 31,   0.93936520D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10236: 10240) / 64, 32,   0.78963690D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10241: 10245) / 64, 33,   0.64598490D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10246: 10250) / 64, 34,   0.56529910D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10251: 10255) / 64, 35,   0.48231720D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10256: 10260) / 64, 36,   0.40998030D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10261: 10265) / 64, 37,   0.31359242D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10266: 10270) / 64, 38,   0.25077589D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10271: 10275) / 64, 39,   0.21132076D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10276: 10280) / 64, 40,   0.18544837D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10281: 10285) / 64, 41,   0.16654372D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10286: 10290) / 64, 42,   0.12530730D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10291: 10295) / 64, 43,   0.14116759D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10296: 10300) / 64, 44,   0.10450617D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10301: 10305) / 64, 45,   0.11404525D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10306: 10310) / 64, 46,   0.10471279D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10311: 10315) / 64, 47,   0.88053130D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10316: 10320) / 64, 48,   0.91107960D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10321: 10325) / 64, 49,   0.11799720D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10326: 10330) / 64, 50,   0.10480976D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10331: 10335) / 64, 51,   0.89951620D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10336: 10340) / 64, 52,   0.81630470D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10341: 10345) / 64, 53,   0.72098470D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10346: 10350) / 64, 54,   0.63421630D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10351: 10355) / 64, 55,   0.38238426D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10356: 10360) / 64, 56,   0.32436561D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10361: 10365) / 64, 57,   0.27405478D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10366: 10370) / 64, 58,   0.10709597D+04,   0.00000D+00,   0.27991D+01/
  data pars( 10371: 10375) / 64, 59,   0.28381357D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10376: 10380) / 64, 60,   0.27056826D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10381: 10385) / 64, 61,   0.26326657D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10386: 10390) / 64, 62,   0.25660607D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10391: 10395) / 64, 63,   0.25068352D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10396: 10400) / 64, 64,   0.18916719D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10401: 10405) / 65,  1,   0.70179400D+02,   0.00000D+00,   0.91180D+00/
  data pars( 10406: 10410) / 65,  2,   0.42367900D+02,   0.00000D+00,   0.00000D+00/
  data pars( 10411: 10415) / 65,  3,   0.18023852D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10416: 10420) / 65,  4,   0.80848660D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10421: 10425) / 65,  5,   0.48279770D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10426: 10430) / 65,  6,   0.29984690D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10431: 10435) / 65,  7,   0.19762340D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10436: 10440) / 65,  8,   0.14377540D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10441: 10445) / 65,  9,   0.10539700D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10446: 10450) / 65, 10,   0.79048400D+02,   0.00000D+00,   0.00000D+00/
  data pars( 10451: 10455) / 65, 11,   0.21240831D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10456: 10460) / 65, 12,   0.13433651D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10461: 10465) / 65, 13,   0.11621560D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10466: 10470) / 65, 14,   0.83917760D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10471: 10475) / 65, 15,   0.61083180D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10476: 10480) / 65, 16,   0.48623190D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10481: 10485) / 65, 17,   0.38195840D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10486: 10490) / 65, 18,   0.30241490D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10491: 10495) / 65, 19,   0.36876305D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10496: 10500) / 65, 20,   0.25641443D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10501: 10505) / 65, 21,   0.20454927D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10506: 10510) / 65, 22,   0.19228302D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10511: 10515) / 65, 23,   0.17309890D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10516: 10520) / 65, 24,   0.13680049D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10521: 10525) / 65, 25,   0.14541614D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10526: 10530) / 65, 26,   0.11408713D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10531: 10535) / 65, 27,   0.11579011D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10536: 10540) / 65, 28,   0.12132014D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10541: 10545) / 65, 29,   0.93575440D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10546: 10550) / 65, 30,   0.90359910D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10551: 10555) / 65, 31,   0.10900939D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10556: 10560) / 65, 32,   0.89646510D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10561: 10565) / 65, 33,   0.72120420D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10566: 10570) / 65, 34,   0.62544800D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10571: 10575) / 65, 35,   0.52893810D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10576: 10580) / 65, 36,   0.44620840D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10581: 10585) / 65, 37,   0.40985678D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10586: 10590) / 65, 38,   0.30839899D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10591: 10595) / 65, 39,   0.25485911D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10596: 10600) / 65, 40,   0.22114907D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10601: 10605) / 65, 41,   0.19735648D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10606: 10610) / 65, 42,   0.14705265D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10611: 10615) / 65, 43,   0.16631347D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10616: 10620) / 65, 44,   0.12173511D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10621: 10625) / 65, 45,   0.13235223D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10626: 10630) / 65, 46,   0.12096847D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10631: 10635) / 65, 47,   0.10256835D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10636: 10640) / 65, 48,   0.10465789D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10641: 10645) / 65, 49,   0.13756067D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10646: 10650) / 65, 50,   0.11975597D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10651: 10655) / 65, 51,   0.10112975D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10656: 10660) / 65, 52,   0.90991270D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10661: 10665) / 65, 53,   0.79669950D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10666: 10670) / 65, 54,   0.69543500D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10671: 10675) / 65, 55,   0.50226967D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10676: 10680) / 65, 56,   0.40300910D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10681: 10685) / 65, 57,   0.33357435D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10686: 10690) / 65, 58,   0.12096287D+04,   0.00000D+00,   0.27991D+01/
  data pars( 10691: 10695) / 65, 59,   0.35071716D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10696: 10700) / 65, 60,   0.33250797D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10701: 10705) / 65, 61,   0.32313241D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10706: 10710) / 65, 62,   0.31461740D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10711: 10715) / 65, 63,   0.30703853D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10716: 10720) / 65, 64,   0.22762532D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10721: 10725) / 65, 65,   0.28516677D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10726: 10730) / 66,  1,   0.67958000D+02,   0.00000D+00,   0.91180D+00/
  data pars( 10731: 10735) / 66,  2,   0.41162200D+02,   0.00000D+00,   0.00000D+00/
  data pars( 10736: 10740) / 66,  3,   0.17207353D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10741: 10745) / 66,  4,   0.77577180D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10746: 10750) / 66,  5,   0.46524390D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10751: 10755) / 66,  6,   0.28984550D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10756: 10760) / 66,  7,   0.19145500D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10761: 10765) / 66,  8,   0.13949370D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10766: 10770) / 66,  9,   0.10238110D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10771: 10775) / 66, 10,   0.76855700D+02,   0.00000D+00,   0.00000D+00/
  data pars( 10776: 10780) / 66, 11,   0.20278568D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10781: 10785) / 66, 12,   0.12872471D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10786: 10790) / 66, 13,   0.11160341D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10791: 10795) / 66, 14,   0.80833220D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10796: 10800) / 66, 15,   0.58989410D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10801: 10805) / 66, 16,   0.47029770D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10806: 10810) / 66, 17,   0.36998330D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10811: 10815) / 66, 18,   0.29329050D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10816: 10820) / 66, 19,   0.35269705D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10821: 10825) / 66, 20,   0.24517734D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10826: 10830) / 66, 21,   0.19574581D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10831: 10835) / 66, 22,   0.18415883D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10836: 10840) / 66, 23,   0.16587019D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10841: 10845) / 66, 24,   0.13107538D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10846: 10850) / 66, 25,   0.13944853D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10851: 10855) / 66, 26,   0.10940016D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10856: 10860) / 66, 27,   0.11118174D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10861: 10865) / 66, 28,   0.11642755D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10866: 10870) / 66, 29,   0.89783730D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10871: 10875) / 66, 30,   0.86875770D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10876: 10880) / 66, 31,   0.10475640D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10881: 10885) / 66, 32,   0.86358600D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10886: 10890) / 66, 33,   0.69627600D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10891: 10895) / 66, 34,   0.60460480D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10896: 10900) / 66, 35,   0.51197160D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10901: 10905) / 66, 36,   0.43238930D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10906: 10910) / 66, 37,   0.39216962D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10911: 10915) / 66, 38,   0.29485688D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10916: 10920) / 66, 39,   0.24401762D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10921: 10925) / 66, 40,   0.21194908D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10926: 10930) / 66, 41,   0.18927858D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10931: 10935) / 66, 42,   0.14117363D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10936: 10940) / 66, 43,   0.15962074D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10941: 10945) / 66, 44,   0.11696785D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10946: 10950) / 66, 45,   0.12718937D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10951: 10955) / 66, 46,   0.11630374D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10956: 10960) / 66, 47,   0.98556970D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10961: 10965) / 66, 48,   0.10068382D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10966: 10970) / 66, 49,   0.13215257D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10971: 10975) / 66, 50,   0.11527975D+04,   0.00000D+00,   0.00000D+00/
  data pars( 10976: 10980) / 66, 51,   0.97544350D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10981: 10985) / 66, 52,   0.87867530D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10986: 10990) / 66, 53,   0.77029080D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10991: 10995) / 66, 54,   0.67313940D+03,   0.00000D+00,   0.00000D+00/
  data pars( 10996: 11000) / 66, 55,   0.48123323D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11001: 11005) / 66, 56,   0.38522949D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11006: 11010) / 66, 57,   0.31924039D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11011: 11015) / 66, 58,   0.11661633D+04,   0.00000D+00,   0.27991D+01/
  data pars( 11016: 11020) / 66, 59,   0.33558765D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11021: 11025) / 66, 60,   0.31799629D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11026: 11030) / 66, 61,   0.30904072D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11031: 11035) / 66, 62,   0.30090778D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11036: 11040) / 66, 63,   0.29367065D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11041: 11045) / 66, 64,   0.21810675D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11046: 11050) / 66, 65,   0.27299739D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11051: 11055) / 66, 66,   0.26173310D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11056: 11060) / 67,  1,   0.72220300D+02,   0.00000D+00,   0.91180D+00/
  data pars( 11061: 11065) / 67,  2,   0.43571100D+02,   0.00000D+00,   0.00000D+00/
  data pars( 11066: 11070) / 67,  3,   0.17049679D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11071: 11075) / 67,  4,   0.81136880D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11076: 11080) / 67,  5,   0.49188750D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11081: 11085) / 67,  6,   0.30751980D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11086: 11090) / 67,  7,   0.20315540D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11091: 11095) / 67,  8,   0.14783550D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11096: 11100) / 67,  9,   0.10830760D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11101: 11105) / 67, 10,   0.81141600D+02,   0.00000D+00,   0.00000D+00/
  data pars( 11106: 11110) / 67, 11,   0.20163392D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11111: 11115) / 67, 12,   0.13374783D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11116: 11120) / 67, 13,   0.11679358D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11121: 11125) / 67, 14,   0.85407400D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11126: 11130) / 67, 15,   0.62593940D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11131: 11135) / 67, 16,   0.49945760D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11136: 11140) / 67, 17,   0.39293850D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11141: 11145) / 67, 18,   0.31124870D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11146: 11150) / 67, 19,   0.34195160D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11151: 11155) / 67, 20,   0.25014164D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11156: 11160) / 67, 21,   0.20120352D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11161: 11165) / 67, 22,   0.18992044D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11166: 11170) / 67, 23,   0.17148635D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11171: 11175) / 67, 24,   0.13502932D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11176: 11180) / 67, 25,   0.14466020D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11181: 11185) / 67, 26,   0.11317710D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11186: 11190) / 67, 27,   0.11614905D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11191: 11195) / 67, 28,   0.12139348D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11196: 11200) / 67, 29,   0.93167930D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11201: 11205) / 67, 30,   0.91200820D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11206: 11210) / 67, 31,   0.10964450D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11211: 11215) / 67, 32,   0.91172230D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11216: 11220) / 67, 33,   0.73821290D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11221: 11225) / 67, 34,   0.64174520D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11226: 11230) / 67, 35,   0.54371620D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11231: 11235) / 67, 36,   0.45912050D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11236: 11240) / 67, 37,   0.38008304D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11241: 11245) / 67, 38,   0.29970212D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11246: 11250) / 67, 39,   0.25073572D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11251: 11255) / 67, 40,   0.21900272D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11256: 11260) / 67, 41,   0.19605194D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11261: 11265) / 67, 42,   0.14668017D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11266: 11270) / 67, 43,   0.16559466D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11271: 11275) / 67, 44,   0.12180651D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11276: 11280) / 67, 45,   0.13291426D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11281: 11285) / 67, 46,   0.12176582D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11286: 11290) / 67, 47,   0.10253902D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11291: 11295) / 67, 48,   0.10563718D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11296: 11300) / 67, 49,   0.13778901D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11301: 11305) / 67, 50,   0.12131043D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11306: 11310) / 67, 51,   0.10318071D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11311: 11315) / 67, 52,   0.93112390D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11316: 11320) / 67, 53,   0.81732200D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11321: 11325) / 67, 54,   0.71464770D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11326: 11330) / 67, 55,   0.46328428D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11331: 11335) / 67, 56,   0.38855093D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11336: 11340) / 67, 57,   0.32599132D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11341: 11345) / 67, 58,   0.12305989D+04,   0.00000D+00,   0.27991D+01/
  data pars( 11346: 11350) / 67, 59,   0.33915411D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11351: 11355) / 67, 60,   0.32298168D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11356: 11360) / 67, 61,   0.31416098D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11361: 11365) / 67, 62,   0.30612537D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11366: 11370) / 67, 63,   0.29897660D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11371: 11375) / 67, 64,   0.22379026D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11376: 11380) / 67, 65,   0.27243602D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11381: 11385) / 67, 66,   0.26065136D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11386: 11390) / 67, 67,   0.26641668D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11391: 11395) / 68,  1,   0.70715400D+02,   0.00000D+00,   0.91180D+00/
  data pars( 11396: 11400) / 68,  2,   0.42665800D+02,   0.00000D+00,   0.00000D+00/
  data pars( 11401: 11405) / 68,  3,   0.16647700D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11406: 11410) / 68,  4,   0.79368770D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11411: 11415) / 68,  5,   0.48143850D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11416: 11420) / 68,  6,   0.30106920D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11421: 11425) / 68,  7,   0.19891850D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11426: 11430) / 68,  8,   0.14475870D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11431: 11435) / 68,  9,   0.10605520D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11436: 11440) / 68, 10,   0.79453900D+02,   0.00000D+00,   0.00000D+00/
  data pars( 11441: 11445) / 68, 11,   0.19689928D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11446: 11450) / 68, 12,   0.13079814D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11451: 11455) / 68, 13,   0.11425656D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11456: 11460) / 68, 14,   0.83589690D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11461: 11465) / 68, 15,   0.61278090D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11466: 11470) / 68, 16,   0.48901070D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11471: 11475) / 68, 17,   0.38474960D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11476: 11480) / 68, 18,   0.30477480D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11481: 11485) / 68, 19,   0.33372227D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11486: 11490) / 68, 20,   0.24446758D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11491: 11495) / 68, 21,   0.19669050D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11496: 11500) / 68, 22,   0.18568743D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11501: 11505) / 68, 23,   0.16768129D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11506: 11510) / 68, 24,   0.13201912D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11511: 11515) / 68, 25,   0.14147048D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11516: 11520) / 68, 26,   0.11067246D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11521: 11525) / 68, 27,   0.11361897D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11526: 11530) / 68, 28,   0.11873873D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11531: 11535) / 68, 29,   0.91117070D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11536: 11540) / 68, 30,   0.89233320D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11541: 11545) / 68, 31,   0.10726768D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11546: 11550) / 68, 32,   0.89230170D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11551: 11555) / 68, 33,   0.72266540D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11556: 11560) / 68, 34,   0.62829340D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11561: 11565) / 68, 35,   0.53236410D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11566: 11570) / 68, 36,   0.44955920D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11571: 11575) / 68, 37,   0.37094297D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11576: 11580) / 68, 38,   0.29287164D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11581: 11585) / 68, 39,   0.24511775D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11586: 11590) / 68, 40,   0.21414202D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11591: 11595) / 68, 41,   0.19172203D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11596: 11600) / 68, 42,   0.14346130D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11601: 11605) / 68, 43,   0.16195186D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11606: 11610) / 68, 44,   0.11914716D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11611: 11615) / 68, 45,   0.13002637D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11616: 11620) / 68, 46,   0.11912962D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11621: 11625) / 68, 47,   0.10029797D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11626: 11630) / 68, 48,   0.10336009D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11631: 11635) / 68, 49,   0.13478497D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11636: 11640) / 68, 50,   0.11871040D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11641: 11645) / 68, 51,   0.10099583D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11646: 11650) / 68, 52,   0.91151370D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11651: 11655) / 68, 53,   0.80019180D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11656: 11660) / 68, 54,   0.69972310D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11661: 11665) / 68, 55,   0.45209645D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11666: 11670) / 68, 56,   0.37960924D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11671: 11675) / 68, 57,   0.31862327D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11676: 11680) / 68, 58,   0.12044185D+04,   0.00000D+00,   0.27991D+01/
  data pars( 11681: 11685) / 68, 59,   0.33138879D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11686: 11690) / 68, 60,   0.31561992D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11691: 11695) / 68, 61,   0.30700842D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11696: 11700) / 68, 62,   0.29916275D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11701: 11705) / 68, 63,   0.29218310D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11706: 11710) / 68, 64,   0.21877803D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11711: 11715) / 68, 65,   0.26611461D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11716: 11720) / 68, 66,   0.25461249D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11721: 11725) / 68, 67,   0.26039653D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11726: 11730) / 68, 68,   0.25451713D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11731: 11735) / 69,  1,   0.69379100D+02,   0.00000D+00,   0.91180D+00/
  data pars( 11736: 11740) / 69,  2,   0.41872700D+02,   0.00000D+00,   0.00000D+00/
  data pars( 11741: 11745) / 69,  3,   0.16270951D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11746: 11750) / 69,  4,   0.77746020D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11751: 11755) / 69,  5,   0.47198600D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11756: 11760) / 69,  6,   0.29530140D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11761: 11765) / 69,  7,   0.19516300D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11766: 11770) / 69,  8,   0.14204780D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11771: 11775) / 69,  9,   0.10408000D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11776: 11780) / 69, 10,   0.77978800D+02,   0.00000D+00,   0.00000D+00/
  data pars( 11781: 11785) / 69, 11,   0.19246593D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11786: 11790) / 69, 12,   0.12807911D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11791: 11795) / 69, 13,   0.11193391D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11796: 11800) / 69, 14,   0.81942800D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11801: 11805) / 69, 15,   0.60097010D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11806: 11810) / 69, 16,   0.47969090D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11811: 11815) / 69, 17,   0.37748730D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11816: 11820) / 69, 18,   0.29906220D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11821: 11825) / 69, 19,   0.32599368D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11826: 11830) / 69, 20,   0.23919954D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11831: 11835) / 69, 21,   0.19251263D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11836: 11840) / 69, 22,   0.18177881D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11841: 11845) / 69, 23,   0.16417354D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11846: 11850) / 69, 24,   0.12924384D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11851: 11855) / 69, 25,   0.13853712D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11856: 11860) / 69, 26,   0.10836957D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11861: 11865) / 69, 27,   0.11130259D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11866: 11870) / 69, 28,   0.11630369D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11871: 11875) / 69, 29,   0.89235160D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11876: 11880) / 69, 30,   0.87439610D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11881: 11885) / 69, 31,   0.10509705D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11886: 11890) / 69, 32,   0.87471320D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11891: 11895) / 69, 33,   0.70869500D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11896: 11900) / 69, 34,   0.61626580D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11901: 11905) / 69, 35,   0.52226550D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11906: 11910) / 69, 36,   0.44109320D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11911: 11915) / 69, 37,   0.36236511D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11916: 11920) / 69, 38,   0.28652613D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11921: 11925) / 69, 39,   0.23992487D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11926: 11930) / 69, 40,   0.20966400D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11931: 11935) / 69, 41,   0.18774174D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11936: 11940) / 69, 42,   0.14051352D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11941: 11945) / 69, 43,   0.15861100D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11946: 11950) / 69, 44,   0.11671878D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11951: 11955) / 69, 45,   0.12739026D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11956: 11960) / 69, 46,   0.11672707D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11961: 11965) / 69, 47,   0.98252100D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11966: 11970) / 69, 48,   0.10128904D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11971: 11975) / 69, 49,   0.13203887D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11976: 11980) / 69, 50,   0.11634988D+04,   0.00000D+00,   0.00000D+00/
  data pars( 11981: 11985) / 69, 51,   0.99025880D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11986: 11990) / 69, 52,   0.89390800D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11991: 11995) / 69, 53,   0.78488410D+03,   0.00000D+00,   0.00000D+00/
  data pars( 11996: 12000) / 69, 54,   0.68644520D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12001: 12005) / 69, 55,   0.44159694D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12006: 12010) / 69, 56,   0.37128812D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12011: 12015) / 69, 57,   0.31180001D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12016: 12020) / 69, 58,   0.11807776D+04,   0.00000D+00,   0.27991D+01/
  data pars( 12021: 12025) / 69, 59,   0.32417266D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12026: 12030) / 69, 60,   0.30878489D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12031: 12035) / 69, 61,   0.30036922D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12036: 12040) / 69, 62,   0.29270118D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12041: 12045) / 69, 63,   0.28587977D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12046: 12050) / 69, 64,   0.21415264D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12051: 12055) / 69, 65,   0.26023122D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12056: 12060) / 69, 66,   0.24899643D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12061: 12065) / 69, 67,   0.25481802D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12066: 12070) / 69, 68,   0.24906989D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12071: 12075) / 69, 69,   0.24374539D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12076: 12080) / 70,  1,   0.68494900D+02,   0.00000D+00,   0.91180D+00/
  data pars( 12081: 12085) / 70,  2,   0.41286600D+02,   0.00000D+00,   0.00000D+00/
  data pars( 12086: 12090) / 70,  3,   0.16127581D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12091: 12095) / 70,  4,   0.76939830D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12096: 12100) / 70,  5,   0.46660990D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12101: 12105) / 70,  6,   0.29168170D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12106: 12110) / 70,  7,   0.19263240D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12111: 12115) / 70,  8,   0.14013000D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12116: 12120) / 70,  9,   0.10262510D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12121: 12125) / 70, 10,   0.76858100D+02,   0.00000D+00,   0.00000D+00/
  data pars( 12126: 12130) / 70, 11,   0.19075332D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12131: 12135) / 70, 12,   0.12678866D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12136: 12140) / 70, 13,   0.11075215D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12141: 12145) / 70, 14,   0.81018450D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12146: 12150) / 70, 15,   0.59379110D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12151: 12155) / 70, 16,   0.47373900D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12156: 12160) / 70, 17,   0.37262670D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12161: 12165) / 70, 18,   0.29508360D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12166: 12170) / 70, 19,   0.32317117D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12171: 12175) / 70, 20,   0.23690958D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12176: 12180) / 70, 21,   0.19062802D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12181: 12185) / 70, 22,   0.17996377D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12186: 12190) / 70, 23,   0.16251430D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12191: 12195) / 70, 24,   0.12793493D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12196: 12200) / 70, 25,   0.13711198D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12201: 12205) / 70, 26,   0.10724959D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12206: 12210) / 70, 27,   0.11012182D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12211: 12215) / 70, 28,   0.11508553D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12216: 12220) / 70, 29,   0.88299190D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12221: 12225) / 70, 30,   0.86485460D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12226: 12230) / 70, 31,   0.10396601D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12231: 12235) / 70, 32,   0.86479960D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12236: 12240) / 70, 33,   0.70027180D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12241: 12245) / 70, 34,   0.60871740D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12246: 12250) / 70, 35,   0.51566490D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12251: 12255) / 70, 36,   0.43535350D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12256: 12260) / 70, 37,   0.35920465D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12261: 12265) / 70, 38,   0.28379423D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12266: 12270) / 70, 39,   0.23754679D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12271: 12275) / 70, 40,   0.20753417D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12276: 12280) / 70, 41,   0.18580353D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12281: 12285) / 70, 42,   0.13902059D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12286: 12290) / 70, 43,   0.15694426D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12291: 12295) / 70, 44,   0.11545209D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12296: 12300) / 70, 45,   0.12600764D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12301: 12305) / 70, 46,   0.11544639D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12306: 12310) / 70, 47,   0.97180930D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12311: 12315) / 70, 48,   0.10016214D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12316: 12320) / 70, 49,   0.13062023D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12321: 12325) / 70, 50,   0.11504571D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12326: 12330) / 70, 51,   0.97868710D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12331: 12335) / 70, 52,   0.88319190D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12336: 12340) / 70, 53,   0.77520910D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12341: 12345) / 70, 54,   0.67775440D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12346: 12350) / 70, 55,   0.43774766D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12351: 12355) / 70, 56,   0.36779606D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12356: 12360) / 70, 57,   0.30875154D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12361: 12365) / 70, 58,   0.11670799D+04,   0.00000D+00,   0.27991D+01/
  data pars( 12366: 12370) / 70, 59,   0.32108489D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12371: 12375) / 70, 60,   0.30582277D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12376: 12380) / 70, 61,   0.29748238D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12381: 12385) / 70, 62,   0.28988349D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12386: 12390) / 70, 63,   0.28312344D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12391: 12395) / 70, 64,   0.21199794D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12396: 12400) / 70, 65,   0.25778005D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12401: 12405) / 70, 66,   0.24663583D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12406: 12410) / 70, 67,   0.25233630D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12411: 12415) / 70, 68,   0.24664143D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12416: 12420) / 70, 69,   0.24136514D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12421: 12425) / 70, 70,   0.23901227D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12426: 12430) / 71,  1,   0.58651900D+02,   0.00000D+00,   0.91180D+00/
  data pars( 12431: 12435) / 71,  2,   0.35951600D+02,   0.00000D+00,   0.00000D+00/
  data pars( 12436: 12440) / 71,  3,   0.12947583D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12441: 12445) / 71,  4,   0.63458810D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12446: 12450) / 71,  5,   0.39146520D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12451: 12455) / 71,  6,   0.24795570D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12456: 12460) / 71,  7,   0.16541840D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12461: 12465) / 71,  8,   0.12121480D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12466: 12470) / 71,  9,   0.89340500D+02,   0.00000D+00,   0.00000D+00/
  data pars( 12471: 12475) / 71, 10,   0.67257500D+02,   0.00000D+00,   0.00000D+00/
  data pars( 12476: 12480) / 71, 11,   0.15332675D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12481: 12485) / 71, 12,   0.10401825D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12486: 12490) / 71, 13,   0.91638240D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12491: 12495) / 71, 14,   0.67855410D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12496: 12500) / 71, 15,   0.50255170D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12501: 12505) / 71, 16,   0.40367180D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12506: 12510) / 71, 17,   0.31962860D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12511: 12515) / 71, 18,   0.25459790D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12516: 12520) / 71, 19,   0.25921299D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12521: 12525) / 71, 20,   0.19255453D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12526: 12530) / 71, 21,   0.15553939D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12531: 12535) / 71, 22,   0.14734091D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12536: 12540) / 71, 23,   0.13334027D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12541: 12545) / 71, 24,   0.10496142D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12546: 12550) / 71, 25,   0.11285309D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12551: 12555) / 71, 26,   0.88302170D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12556: 12560) / 71, 27,   0.91141500D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12561: 12565) / 71, 28,   0.95032780D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12566: 12570) / 71, 29,   0.72889260D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12571: 12575) / 71, 30,   0.71952410D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12576: 12580) / 71, 31,   0.86291390D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12581: 12585) / 71, 32,   0.72475130D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12586: 12590) / 71, 33,   0.59205870D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12591: 12595) / 71, 34,   0.51745760D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12596: 12600) / 71, 35,   0.44084280D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12601: 12605) / 71, 36,   0.37414020D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12606: 12610) / 71, 37,   0.28847585D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12611: 12615) / 71, 38,   0.23048558D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12616: 12620) / 71, 39,   0.19421387D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12621: 12625) / 71, 40,   0.17040440D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12626: 12630) / 71, 41,   0.15299721D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12631: 12635) / 71, 42,   0.11501604D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12636: 12640) / 71, 43,   0.12962701D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12641: 12645) / 71, 44,   0.95869920D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12646: 12650) / 71, 45,   0.10467597D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12651: 12655) / 71, 46,   0.96091280D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12656: 12660) / 71, 47,   0.80744060D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12661: 12665) / 71, 48,   0.83583100D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12666: 12670) / 71, 49,   0.10833008D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12671: 12675) / 71, 50,   0.96184020D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12676: 12680) / 71, 51,   0.82469640D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12681: 12685) / 71, 52,   0.74775790D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12686: 12690) / 71, 53,   0.65970490D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12691: 12695) / 71, 54,   0.57959110D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12696: 12700) / 71, 55,   0.35195236D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12701: 12705) / 71, 56,   0.29806436D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12706: 12710) / 71, 57,   0.25182192D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12711: 12715) / 71, 58,   0.98175310D+03,   0.00000D+00,   0.27991D+01/
  data pars( 12716: 12720) / 71, 59,   0.26089193D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12721: 12725) / 71, 60,   0.24861931D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12726: 12730) / 71, 61,   0.24191164D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12731: 12735) / 71, 62,   0.23579439D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12736: 12740) / 71, 63,   0.23035540D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12741: 12745) / 71, 64,   0.17376565D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12746: 12750) / 71, 65,   0.20919380D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12751: 12755) / 71, 66,   0.20059243D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12756: 12760) / 71, 67,   0.20565310D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12761: 12765) / 71, 68,   0.20105203D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12766: 12770) / 71, 69,   0.19680474D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12771: 12775) / 71, 70,   0.19483102D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12776: 12780) / 71, 71,   0.15974796D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12781: 12785) / 72,  1,   0.58850400D+02,   0.00000D+00,   0.91180D+00/
  data pars( 12786: 12790) / 72,  2,   0.36574900D+02,   0.00000D+00,   0.00000D+00/
  data pars( 12791: 12795) / 72,  3,   0.11772268D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12796: 12800) / 72,  4,   0.60758590D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12801: 12805) / 72,  5,   0.38350840D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12806: 12810) / 72,  6,   0.24668260D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12811: 12815) / 72,  7,   0.16624720D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12816: 12820) / 72,  8,   0.12259130D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12821: 12825) / 72,  9,   0.90778400D+02,   0.00000D+00,   0.00000D+00/
  data pars( 12826: 12830) / 72, 10,   0.68550500D+02,   0.00000D+00,   0.00000D+00/
  data pars( 12831: 12835) / 72, 11,   0.13981254D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12836: 12840) / 72, 12,   0.98752390D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12841: 12845) / 72, 13,   0.88079020D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12846: 12850) / 72, 14,   0.66333140D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12851: 12855) / 72, 15,   0.49770150D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12856: 12860) / 72, 16,   0.40279470D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12861: 12865) / 72, 17,   0.32111450D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12866: 12870) / 72, 18,   0.25716510D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12871: 12875) / 72, 19,   0.23300562D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12876: 12880) / 72, 20,   0.17971024D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12881: 12885) / 72, 21,   0.14619589D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12886: 12890) / 72, 22,   0.13919848D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12891: 12895) / 72, 23,   0.12638660D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12896: 12900) / 72, 24,   0.99362820D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12901: 12905) / 72, 25,   0.10747287D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12906: 12910) / 72, 26,   0.84045370D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12911: 12915) / 72, 27,   0.87543360D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12916: 12920) / 72, 28,   0.90984070D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12921: 12925) / 72, 29,   0.69642830D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12926: 12930) / 72, 30,   0.69621350D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12931: 12935) / 72, 31,   0.83232490D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12936: 12940) / 72, 32,   0.70869710D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12941: 12945) / 72, 33,   0.58542500D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12946: 12950) / 72, 34,   0.51487840D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12951: 12955) / 72, 35,   0.44133770D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12956: 12960) / 72, 36,   0.37652870D+03,   0.00000D+00,   0.00000D+00/
  data pars( 12961: 12965) / 72, 37,   0.25964033D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12966: 12970) / 72, 38,   0.21464040D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12971: 12975) / 72, 39,   0.18297515D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12976: 12980) / 72, 40,   0.16164737D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12981: 12985) / 72, 41,   0.14572492D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12986: 12990) / 72, 42,   0.11025669D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12991: 12995) / 72, 43,   0.12395201D+04,   0.00000D+00,   0.00000D+00/
  data pars( 12996: 13000) / 72, 44,   0.92341980D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13001: 13005) / 72, 45,   0.10097527D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13006: 13010) / 72, 46,   0.92946760D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13011: 13015) / 72, 47,   0.77779950D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13016: 13020) / 72, 48,   0.81120400D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13021: 13025) / 72, 49,   0.10422993D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13026: 13030) / 72, 50,   0.93663610D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13031: 13035) / 72, 51,   0.81148690D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13036: 13040) / 72, 52,   0.74006690D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13041: 13045) / 72, 53,   0.65681710D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13046: 13050) / 72, 54,   0.58013770D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13051: 13055) / 72, 55,   0.31606446D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13056: 13060) / 72, 56,   0.27609094D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13061: 13065) / 72, 57,   0.23609186D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13066: 13070) / 72, 58,   0.96347730D+03,   0.00000D+00,   0.27991D+01/
  data pars( 13071: 13075) / 72, 59,   0.24240491D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13076: 13080) / 72, 60,   0.23170514D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13081: 13085) / 72, 61,   0.22560584D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13086: 13090) / 72, 62,   0.22002906D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13091: 13095) / 72, 63,   0.21507417D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13096: 13100) / 72, 64,   0.16406567D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13101: 13105) / 72, 65,   0.19309949D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13106: 13110) / 72, 66,   0.18529581D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13111: 13115) / 72, 67,   0.19265925D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13116: 13120) / 72, 68,   0.18843048D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13121: 13125) / 72, 69,   0.18455050D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13126: 13130) / 72, 70,   0.18262149D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13131: 13135) / 72, 71,   0.15072441D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13136: 13140) / 72, 72,   0.14412394D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13141: 13145) / 73,  1,   0.54401500D+02,   0.00000D+00,   0.91180D+00/
  data pars( 13146: 13150) / 73,  2,   0.34283400D+02,   0.00000D+00,   0.00000D+00/
  data pars( 13151: 13155) / 73,  3,   0.10273577D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13156: 13160) / 73,  4,   0.54443550D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13161: 13165) / 73,  5,   0.34862850D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13166: 13170) / 73,  6,   0.22671590D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13171: 13175) / 73,  7,   0.15406960D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13176: 13180) / 73,  8,   0.11429670D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13181: 13185) / 73,  9,   0.85081400D+02,   0.00000D+00,   0.00000D+00/
  data pars( 13186: 13190) / 73, 10,   0.64523800D+02,   0.00000D+00,   0.00000D+00/
  data pars( 13191: 13195) / 73, 11,   0.12220335D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13196: 13200) / 73, 12,   0.88084690D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13201: 13205) / 73, 13,   0.79141350D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13206: 13210) / 73, 14,   0.60213470D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13211: 13215) / 73, 15,   0.45569700D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13216: 13220) / 73, 16,   0.37087230D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13221: 13225) / 73, 17,   0.29728390D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13226: 13230) / 73, 18,   0.23922910D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13231: 13235) / 73, 19,   0.20266698D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13236: 13240) / 73, 20,   0.15894883D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13241: 13245) / 73, 21,   0.12977826D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13246: 13250) / 73, 22,   0.12395033D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13251: 13255) / 73, 23,   0.11275812D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13256: 13260) / 73, 24,   0.88658800D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13261: 13265) / 73, 25,   0.96151940D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13266: 13270) / 73, 26,   0.75231040D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13271: 13275) / 73, 27,   0.78703270D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13276: 13280) / 73, 28,   0.81634550D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13281: 13285) / 73, 29,   0.62484080D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13286: 13290) / 73, 30,   0.62867410D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13291: 13295) / 73, 31,   0.74997760D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13296: 13300) / 73, 32,   0.64373010D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13301: 13305) / 73, 33,   0.53560150D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13306: 13310) / 73, 34,   0.47316850D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13311: 13315) / 73, 35,   0.40746910D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13316: 13320) / 73, 36,   0.34913050D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13321: 13325) / 73, 37,   0.22608400D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13326: 13330) / 73, 38,   0.18969799D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13331: 13335) / 73, 39,   0.16272670D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13336: 13340) / 73, 40,   0.14431973D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13341: 13345) / 73, 41,   0.13043213D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13346: 13350) / 73, 42,   0.99116570D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13351: 13355) / 73, 43,   0.11124511D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13356: 13360) / 73, 44,   0.83281910D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13361: 13365) / 73, 45,   0.91084260D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13366: 13370) / 73, 46,   0.83983510D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13371: 13375) / 73, 47,   0.70192840D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13376: 13380) / 73, 48,   0.73456590D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13381: 13385) / 73, 49,   0.93877020D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13386: 13390) / 73, 50,   0.84925790D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13391: 13395) / 73, 51,   0.74051010D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13396: 13400) / 73, 52,   0.67794300D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13401: 13405) / 73, 53,   0.60419180D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13406: 13410) / 73, 54,   0.53577730D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13411: 13415) / 73, 55,   0.27516509D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13416: 13420) / 73, 56,   0.24344207D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13421: 13425) / 73, 57,   0.20948531D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13426: 13430) / 73, 58,   0.87810980D+03,   0.00000D+00,   0.27991D+01/
  data pars( 13431: 13435) / 73, 59,   0.21417667D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13436: 13440) / 73, 60,   0.20496125D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13441: 13445) / 73, 61,   0.19962879D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13446: 13450) / 73, 62,   0.19474669D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13451: 13455) / 73, 63,   0.19041085D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13456: 13460) / 73, 64,   0.14623131D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13461: 13465) / 73, 65,   0.17026705D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13466: 13470) / 73, 66,   0.16355752D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13471: 13475) / 73, 67,   0.17084912D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13476: 13480) / 73, 68,   0.16713110D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13481: 13485) / 73, 69,   0.16373225D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13486: 13490) / 73, 70,   0.16197710D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13491: 13495) / 73, 71,   0.13428697D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13496: 13500) / 73, 72,   0.12925836D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13501: 13505) / 73, 73,   0.11638241D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13506: 13510) / 74,  1,   0.46481300D+02,   0.00000D+00,   0.91180D+00/
  data pars( 13511: 13515) / 74,  2,   0.29820600D+02,   0.00000D+00,   0.00000D+00/
  data pars( 13516: 13520) / 74,  3,   0.84241230D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13521: 13525) / 74,  4,   0.45198610D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13526: 13530) / 74,  5,   0.29290150D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13531: 13535) / 74,  6,   0.19259840D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13536: 13540) / 74,  7,   0.13214100D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13541: 13545) / 74,  8,   0.98766600D+02,   0.00000D+00,   0.00000D+00/
  data pars( 13546: 13550) / 74,  9,   0.74030900D+02,   0.00000D+00,   0.00000D+00/
  data pars( 13551: 13555) / 74, 10,   0.56476700D+02,   0.00000D+00,   0.00000D+00/
  data pars( 13556: 13560) / 74, 11,   0.10029508D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13561: 13565) / 74, 12,   0.72933520D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13566: 13570) / 74, 13,   0.65874710D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13571: 13575) / 74, 14,   0.50518900D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13576: 13580) / 74, 15,   0.38541090D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13581: 13585) / 74, 16,   0.31556320D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13586: 13590) / 74, 17,   0.25452870D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13591: 13595) / 74, 18,   0.20602860D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13596: 13600) / 74, 19,   0.16644321D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13601: 13605) / 74, 20,   0.13117641D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13606: 13610) / 74, 21,   0.10728050D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13611: 13615) / 74, 22,   0.10269214D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13616: 13620) / 74, 23,   0.93538590D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13621: 13625) / 74, 24,   0.73650630D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13626: 13630) / 74, 25,   0.79917580D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13631: 13635) / 74, 26,   0.62633800D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13636: 13640) / 74, 27,   0.65622600D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13641: 13645) / 74, 28,   0.67963140D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13646: 13650) / 74, 29,   0.52108220D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13651: 13655) / 74, 30,   0.52588940D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13656: 13660) / 74, 31,   0.62622030D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13661: 13665) / 74, 32,   0.54069840D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13666: 13670) / 74, 33,   0.45278370D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13671: 13675) / 74, 34,   0.40184290D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13676: 13680) / 74, 35,   0.34779630D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13681: 13685) / 74, 36,   0.29948800D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13686: 13690) / 74, 37,   0.18587683D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13691: 13695) / 74, 38,   0.15659413D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13696: 13700) / 74, 39,   0.13478163D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13701: 13705) / 74, 40,   0.11983202D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13706: 13710) / 74, 41,   0.10850878D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13711: 13715) / 74, 42,   0.82786250D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13716: 13720) / 74, 43,   0.92774070D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13721: 13725) / 74, 44,   0.69763460D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13726: 13730) / 74, 45,   0.76226600D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13731: 13735) / 74, 46,   0.70376190D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13736: 13740) / 74, 47,   0.58870290D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13741: 13745) / 74, 48,   0.61664100D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13746: 13750) / 74, 49,   0.78470960D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13751: 13755) / 74, 50,   0.71294940D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13756: 13760) / 74, 51,   0.62490100D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13761: 13765) / 74, 52,   0.57415840D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13766: 13770) / 74, 53,   0.51383150D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13771: 13775) / 74, 54,   0.45758530D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13776: 13780) / 74, 55,   0.22639013D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13781: 13785) / 74, 56,   0.20087751D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13786: 13790) / 74, 57,   0.17339129D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13791: 13795) / 74, 58,   0.74068630D+03,   0.00000D+00,   0.27991D+01/
  data pars( 13796: 13800) / 74, 59,   0.17694139D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13801: 13805) / 74, 60,   0.16938988D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13806: 13810) / 74, 61,   0.16500004D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13811: 13815) / 74, 62,   0.16097798D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13816: 13820) / 74, 63,   0.15740661D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13821: 13825) / 74, 64,   0.12144448D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13826: 13830) / 74, 65,   0.14078390D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13831: 13835) / 74, 66,   0.13533433D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13836: 13840) / 74, 67,   0.14132821D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13841: 13845) / 74, 68,   0.13825761D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13846: 13850) / 74, 69,   0.13545779D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13851: 13855) / 74, 70,   0.13397711D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13856: 13860) / 74, 71,   0.11143056D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13861: 13865) / 74, 72,   0.10763807D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13866: 13870) / 74, 73,   0.97195240D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13871: 13875) / 74, 74,   0.81436220D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13876: 13880) / 75,  1,   0.47481400D+02,   0.00000D+00,   0.91180D+00/
  data pars( 13881: 13885) / 75,  2,   0.30549200D+02,   0.00000D+00,   0.00000D+00/
  data pars( 13886: 13890) / 75,  3,   0.84030290D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13891: 13895) / 75,  4,   0.45686870D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13896: 13900) / 75,  5,   0.29769360D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13901: 13905) / 75,  6,   0.19640730D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13906: 13910) / 75,  7,   0.13504060D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13911: 13915) / 75,  8,   0.10106690D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13916: 13920) / 75,  9,   0.75833700D+02,   0.00000D+00,   0.00000D+00/
  data pars( 13921: 13925) / 75, 10,   0.57897000D+02,   0.00000D+00,   0.00000D+00/
  data pars( 13926: 13930) / 75, 11,   0.10011833D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13931: 13935) / 75, 12,   0.73565530D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13936: 13940) / 75, 13,   0.66653080D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13941: 13945) / 75, 14,   0.51321450D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13946: 13950) / 75, 15,   0.39266040D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13951: 13955) / 75, 16,   0.32200220D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13956: 13960) / 75, 17,   0.26008050D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13961: 13965) / 75, 18,   0.21074970D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13966: 13970) / 75, 19,   0.16563829D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13971: 13975) / 75, 20,   0.13172961D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13976: 13980) / 75, 21,   0.10793168D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13981: 13985) / 75, 22,   0.10345489D+04,   0.00000D+00,   0.00000D+00/
  data pars( 13986: 13990) / 75, 23,   0.94314230D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13991: 13995) / 75, 24,   0.74238390D+03,   0.00000D+00,   0.00000D+00/
  data pars( 13996: 14000) / 75, 25,   0.80678450D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14001: 14005) / 75, 26,   0.63220880D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14006: 14010) / 75, 27,   0.66388710D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14011: 14015) / 75, 28,   0.68701430D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14016: 14020) / 75, 29,   0.52648590D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14021: 14025) / 75, 30,   0.53299620D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14026: 14030) / 75, 31,   0.63416620D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14031: 14035) / 75, 32,   0.54932810D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14036: 14040) / 75, 33,   0.46115310D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14041: 14045) / 75, 34,   0.40981080D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14046: 14050) / 75, 35,   0.35513780D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14051: 14055) / 75, 36,   0.30613060D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14056: 14060) / 75, 37,   0.18506131D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14061: 14065) / 75, 38,   0.15716863D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14066: 14070) / 75, 39,   0.13568533D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14071: 14075) / 75, 40,   0.12084737D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14076: 14080) / 75, 41,   0.10954282D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14081: 14085) / 75, 42,   0.83707080D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14086: 14090) / 75, 43,   0.93753010D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14091: 14095) / 75, 44,   0.70623580D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14096: 14100) / 75, 45,   0.77195670D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14101: 14105) / 75, 46,   0.71318460D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14106: 14110) / 75, 47,   0.59599800D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14111: 14115) / 75, 48,   0.62541990D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14116: 14120) / 75, 49,   0.79423010D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14121: 14125) / 75, 50,   0.72367260D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14126: 14130) / 75, 51,   0.63581610D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14131: 14135) / 75, 52,   0.58492700D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14136: 14140) / 75, 53,   0.52412750D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14141: 14145) / 75, 54,   0.46726420D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14146: 14150) / 75, 55,   0.22535037D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14151: 14155) / 75, 56,   0.20134740D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14156: 14160) / 75, 57,   0.17433791D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14161: 14165) / 75, 58,   0.75313690D+03,   0.00000D+00,   0.27991D+01/
  data pars( 14166: 14170) / 75, 59,   0.17753357D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14171: 14175) / 75, 60,   0.17005706D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14176: 14180) / 75, 61,   0.16567768D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14181: 14185) / 75, 62,   0.16166266D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14186: 14190) / 75, 63,   0.15809835D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14191: 14195) / 75, 64,   0.12234224D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14196: 14200) / 75, 65,   0.14105904D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14201: 14205) / 75, 66,   0.13567115D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14206: 14210) / 75, 67,   0.14207081D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14211: 14215) / 75, 68,   0.13899934D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14216: 14220) / 75, 69,   0.13620334D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14221: 14225) / 75, 70,   0.13469951D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14226: 14230) / 75, 71,   0.11225706D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14231: 14235) / 75, 72,   0.10876931D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14236: 14240) / 75, 73,   0.98375910D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14241: 14245) / 75, 74,   0.82496150D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14246: 14250) / 75, 75,   0.83633100D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14251: 14255) / 76,  1,   0.43502700D+02,   0.00000D+00,   0.91180D+00/
  data pars( 14256: 14260) / 76,  2,   0.28354600D+02,   0.00000D+00,   0.00000D+00/
  data pars( 14261: 14265) / 76,  3,   0.73192340D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14266: 14270) / 76,  4,   0.40716460D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14271: 14275) / 76,  5,   0.26873040D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14276: 14280) / 76,  6,   0.17905630D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14281: 14285) / 76,  7,   0.12405100D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14286: 14290) / 76,  8,   0.93359700D+02,   0.00000D+00,   0.00000D+00/
  data pars( 14291: 14295) / 76,  9,   0.70395400D+02,   0.00000D+00,   0.00000D+00/
  data pars( 14296: 14300) / 76, 10,   0.53964200D+02,   0.00000D+00,   0.00000D+00/
  data pars( 14301: 14305) / 76, 11,   0.87335890D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14306: 14310) / 76, 12,   0.65307500D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14311: 14315) / 76, 13,   0.59556280D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14316: 14320) / 76, 14,   0.46268400D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14321: 14325) / 76, 15,   0.35670880D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14326: 14330) / 76, 16,   0.29400210D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14331: 14335) / 76, 17,   0.23864150D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14336: 14340) / 76, 18,   0.19423140D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14341: 14345) / 76, 19,   0.14396620D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14346: 14350) / 76, 20,   0.11612618D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14351: 14355) / 76, 21,   0.95445330D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14356: 14360) / 76, 22,   0.91746900D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14361: 14365) / 76, 23,   0.83784550D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14366: 14370) / 76, 24,   0.65982040D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14371: 14375) / 76, 25,   0.71850590D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14376: 14380) / 76, 26,   0.56350590D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14381: 14385) / 76, 27,   0.59375330D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14386: 14390) / 76, 28,   0.61335130D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14391: 14395) / 76, 29,   0.47025530D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14396: 14400) / 76, 30,   0.47853750D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14401: 14405) / 76, 31,   0.56822510D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14406: 14410) / 76, 32,   0.49561460D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14411: 14415) / 76, 33,   0.41868920D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14416: 14420) / 76, 34,   0.37355900D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14421: 14425) / 76, 35,   0.32506940D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14426: 14430) / 76, 36,   0.28130190D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14431: 14435) / 76, 37,   0.16103754D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14436: 14440) / 76, 38,   0.13848254D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14441: 14445) / 76, 39,   0.12021044D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14446: 14450) / 76, 40,   0.10743491D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14451: 14455) / 76, 41,   0.97608420D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14456: 14460) / 76, 42,   0.74894180D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14461: 14465) / 76, 43,   0.83752750D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14466: 14470) / 76, 44,   0.63378860D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14471: 14475) / 76, 45,   0.69267540D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14476: 14480) / 76, 46,   0.64089680D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14481: 14485) / 76, 47,   0.53528690D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14486: 14490) / 76, 48,   0.56312050D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14491: 14495) / 76, 49,   0.71169730D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14496: 14500) / 76, 50,   0.65211350D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14501: 14505) / 76, 51,   0.57610750D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14506: 14510) / 76, 52,   0.53178230D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14511: 14515) / 76, 53,   0.47825570D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14516: 14520) / 76, 54,   0.42787240D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14521: 14525) / 76, 55,   0.19610192D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14526: 14530) / 76, 56,   0.17707984D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14531: 14535) / 76, 57,   0.15416747D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14536: 14540) / 76, 58,   0.68178680D+03,   0.00000D+00,   0.27991D+01/
  data pars( 14541: 14545) / 76, 59,   0.15643082D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14546: 14550) / 76, 60,   0.14998732D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14551: 14555) / 76, 61,   0.14616315D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14556: 14560) / 76, 62,   0.14265281D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14561: 14565) / 76, 63,   0.13953763D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14566: 14570) / 76, 64,   0.10864242D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14571: 14575) / 76, 65,   0.12413205D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14576: 14580) / 76, 66,   0.11950783D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14581: 14585) / 76, 67,   0.12556728D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14586: 14590) / 76, 68,   0.12287111D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14591: 14595) / 76, 69,   0.12042523D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14596: 14600) / 76, 70,   0.11906528D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14601: 14605) / 76, 71,   0.99636440D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14606: 14610) / 76, 72,   0.97080130D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14611: 14615) / 76, 73,   0.88109380D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14616: 14620) / 76, 74,   0.74095590D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14621: 14625) / 76, 75,   0.75215710D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14626: 14630) / 76, 76,   0.67852780D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14631: 14635) / 77,  1,   0.40192800D+02,   0.00000D+00,   0.91180D+00/
  data pars( 14636: 14640) / 77,  2,   0.26493600D+02,   0.00000D+00,   0.00000D+00/
  data pars( 14641: 14645) / 77,  3,   0.64922250D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14646: 14650) / 77,  4,   0.36768190D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14651: 14655) / 77,  5,   0.24523810D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14656: 14660) / 77,  6,   0.16475860D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14661: 14665) / 77,  7,   0.11488740D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14666: 14670) / 77,  8,   0.86879300D+02,   0.00000D+00,   0.00000D+00/
  data pars( 14671: 14675) / 77,  9,   0.65790400D+02,   0.00000D+00,   0.00000D+00/
  data pars( 14676: 14680) / 77, 10,   0.50615900D+02,   0.00000D+00,   0.00000D+00/
  data pars( 14681: 14685) / 77, 11,   0.77563370D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14686: 14690) / 77, 12,   0.58794870D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14691: 14695) / 77, 13,   0.53899920D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14696: 14700) / 77, 14,   0.42178390D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14701: 14705) / 77, 15,   0.32723040D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14706: 14710) / 77, 16,   0.27085510D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14711: 14715) / 77, 17,   0.22077630D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14716: 14720) / 77, 18,   0.18037110D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14721: 14725) / 77, 19,   0.12755198D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14726: 14730) / 77, 20,   0.10398993D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14731: 14735) / 77, 21,   0.85678860D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14736: 14740) / 77, 22,   0.82551250D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14741: 14745) / 77, 23,   0.75491930D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14746: 14750) / 77, 24,   0.59487280D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14751: 14755) / 77, 25,   0.64870850D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14756: 14760) / 77, 26,   0.50921810D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14761: 14765) / 77, 27,   0.53789460D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14766: 14770) / 77, 28,   0.55484790D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14771: 14775) / 77, 29,   0.42567880D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14776: 14780) / 77, 30,   0.43487920D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14781: 14785) / 77, 31,   0.51550510D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14786: 14790) / 77, 32,   0.45212560D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14791: 14795) / 77, 33,   0.38392650D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14796: 14800) / 77, 34,   0.34368330D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14801: 14805) / 77, 35,   0.30011780D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14806: 14810) / 77, 36,   0.26056720D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14811: 14815) / 77, 37,   0.14282493D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14816: 14820) / 77, 38,   0.12397351D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14821: 14825) / 77, 39,   0.10808340D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14826: 14830) / 77, 40,   0.96864880D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14831: 14835) / 77, 41,   0.88171010D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14836: 14840) / 77, 42,   0.67887180D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14841: 14845) / 77, 43,   0.75818340D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14846: 14850) / 77, 44,   0.57594520D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14851: 14855) / 77, 45,   0.62929090D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14856: 14860) / 77, 46,   0.58296220D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14861: 14865) / 77, 47,   0.48681310D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14866: 14870) / 77, 48,   0.51303760D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14871: 14875) / 77, 49,   0.64586290D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14876: 14880) / 77, 50,   0.59440490D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14881: 14885) / 77, 51,   0.52746810D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14886: 14890) / 77, 52,   0.48823190D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14891: 14895) / 77, 53,   0.44042470D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14896: 14900) / 77, 54,   0.39518890D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14901: 14905) / 77, 55,   0.17394992D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14906: 14910) / 77, 56,   0.15831333D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14911: 14915) / 77, 57,   0.13842225D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14916: 14920) / 77, 58,   0.62381140D+03,   0.00000D+00,   0.27991D+01/
  data pars( 14921: 14925) / 77, 59,   0.14006813D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14926: 14930) / 77, 60,   0.13439514D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14931: 14935) / 77, 61,   0.13099454D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14936: 14940) / 77, 62,   0.12786986D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14941: 14945) / 77, 63,   0.12509767D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14946: 14950) / 77, 64,   0.97887040D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14951: 14955) / 77, 65,   0.11106969D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14956: 14960) / 77, 66,   0.10701912D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14961: 14965) / 77, 67,   0.11269388D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14966: 14970) / 77, 68,   0.11028614D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14971: 14975) / 77, 69,   0.10810811D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14976: 14980) / 77, 70,   0.10686460D+04,   0.00000D+00,   0.00000D+00/
  data pars( 14981: 14985) / 77, 71,   0.89729150D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14986: 14990) / 77, 72,   0.87805750D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14991: 14995) / 77, 73,   0.79916860D+03,   0.00000D+00,   0.00000D+00/
  data pars( 14996: 15000) / 77, 74,   0.67370750D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15001: 15005) / 77, 75,   0.68458550D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15006: 15010) / 77, 76,   0.61911480D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15011: 15015) / 77, 77,   0.56606600D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15016: 15020) / 78,  1,   0.33737400D+02,   0.00000D+00,   0.91180D+00/
  data pars( 15021: 15025) / 78,  2,   0.22655000D+02,   0.00000D+00,   0.00000D+00/
  data pars( 15026: 15030) / 78,  3,   0.52329220D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15031: 15035) / 78,  4,   0.30016240D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15036: 15040) / 78,  5,   0.20254080D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15041: 15045) / 78,  6,   0.13757620D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15046: 15050) / 78,  7,   0.96865800D+02,   0.00000D+00,   0.00000D+00/
  data pars( 15051: 15055) / 78,  8,   0.73818300D+02,   0.00000D+00,   0.00000D+00/
  data pars( 15056: 15060) / 78,  9,   0.56305300D+02,   0.00000D+00,   0.00000D+00/
  data pars( 15061: 15065) / 78, 10,   0.43593000D+02,   0.00000D+00,   0.00000D+00/
  data pars( 15066: 15070) / 78, 11,   0.62596250D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15071: 15075) / 78, 12,   0.47885350D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15076: 15080) / 78, 13,   0.44120140D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15081: 15085) / 78, 14,   0.34788170D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15086: 15090) / 78, 15,   0.27198720D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15091: 15095) / 78, 16,   0.22647100D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15096: 15100) / 78, 17,   0.18574640D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15101: 15105) / 78, 18,   0.15265670D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15106: 15110) / 78, 19,   0.10299899D+04,   0.00000D+00,   0.00000D+00/
  data pars( 15111: 15115) / 78, 20,   0.84443870D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15116: 15120) / 78, 21,   0.69692720D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15121: 15125) / 78, 22,   0.67305270D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15126: 15130) / 78, 23,   0.61630660D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15131: 15135) / 78, 24,   0.48652160D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15136: 15140) / 78, 25,   0.53065270D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15141: 15145) / 78, 26,   0.41743140D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15146: 15150) / 78, 27,   0.44140210D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15151: 15155) / 78, 28,   0.45462950D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15156: 15160) / 78, 29,   0.34958030D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15161: 15165) / 78, 30,   0.35801260D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15166: 15170) / 78, 31,   0.42342920D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15171: 15175) / 78, 32,   0.37342980D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15176: 15180) / 78, 33,   0.31904090D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15181: 15185) / 78, 34,   0.28687030D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15186: 15190) / 78, 35,   0.25174820D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15191: 15195) / 78, 36,   0.21965520D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15196: 15200) / 78, 37,   0.11547638D+04,   0.00000D+00,   0.00000D+00/
  data pars( 15201: 15205) / 78, 38,   0.10070623D+04,   0.00000D+00,   0.00000D+00/
  data pars( 15206: 15210) / 78, 39,   0.88099930D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15211: 15215) / 78, 40,   0.79155440D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15216: 15220) / 78, 41,   0.72193400D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15221: 15225) / 78, 42,   0.55823890D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15226: 15230) / 78, 43,   0.62242220D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15231: 15235) / 78, 44,   0.47507150D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15236: 15240) / 78, 45,   0.51845950D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15241: 15245) / 78, 46,   0.48093890D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15246: 15250) / 78, 47,   0.40219150D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15251: 15255) / 78, 48,   0.42403900D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15256: 15260) / 78, 49,   0.53144420D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15261: 15265) / 78, 50,   0.49101090D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15266: 15270) / 78, 51,   0.43782090D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15271: 15275) / 78, 52,   0.40661850D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15276: 15280) / 78, 53,   0.36825920D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15281: 15285) / 78, 54,   0.33179040D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15286: 15290) / 78, 55,   0.14071724D+04,   0.00000D+00,   0.00000D+00/
  data pars( 15291: 15295) / 78, 56,   0.12854322D+04,   0.00000D+00,   0.00000D+00/
  data pars( 15296: 15300) / 78, 57,   0.11275157D+04,   0.00000D+00,   0.00000D+00/
  data pars( 15301: 15305) / 78, 58,   0.51768570D+03,   0.00000D+00,   0.27991D+01/
  data pars( 15306: 15310) / 78, 59,   0.11388994D+04,   0.00000D+00,   0.00000D+00/
  data pars( 15311: 15315) / 78, 60,   0.10932462D+04,   0.00000D+00,   0.00000D+00/
  data pars( 15316: 15320) / 78, 61,   0.10657050D+04,   0.00000D+00,   0.00000D+00/
  data pars( 15321: 15325) / 78, 62,   0.10403742D+04,   0.00000D+00,   0.00000D+00/
  data pars( 15326: 15330) / 78, 63,   0.10179032D+04,   0.00000D+00,   0.00000D+00/
  data pars( 15331: 15335) / 78, 64,   0.80035340D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15336: 15340) / 78, 65,   0.90395940D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15341: 15345) / 78, 66,   0.87158450D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15346: 15350) / 78, 67,   0.91760410D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15351: 15355) / 78, 68,   0.89802720D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15356: 15360) / 78, 69,   0.88036430D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15361: 15365) / 78, 70,   0.87003670D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15366: 15370) / 78, 71,   0.73291850D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15371: 15375) / 78, 72,   0.71957520D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15376: 15380) / 78, 73,   0.65682120D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15381: 15385) / 78, 74,   0.55562970D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15386: 15390) / 78, 75,   0.56502640D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15391: 15395) / 78, 76,   0.51242690D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15396: 15400) / 78, 77,   0.46966640D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15401: 15405) / 78, 78,   0.39114480D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15406: 15410) / 79,  1,   0.31643100D+02,   0.00000D+00,   0.91180D+00/
  data pars( 15411: 15415) / 79,  2,   0.21405700D+02,   0.00000D+00,   0.00000D+00/
  data pars( 15416: 15420) / 79,  3,   0.48271200D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15421: 15425) / 79,  4,   0.27848740D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15426: 15430) / 79,  5,   0.18878590D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15431: 15435) / 79,  6,   0.12878430D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15436: 15440) / 79,  7,   0.91021000D+02,   0.00000D+00,   0.00000D+00/
  data pars( 15441: 15445) / 79,  8,   0.69577200D+02,   0.00000D+00,   0.00000D+00/
  data pars( 15446: 15450) / 79,  9,   0.53225800D+02,   0.00000D+00,   0.00000D+00/
  data pars( 15451: 15455) / 79, 10,   0.41316600D+02,   0.00000D+00,   0.00000D+00/
  data pars( 15456: 15460) / 79, 11,   0.57775500D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15461: 15465) / 79, 12,   0.44384910D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15466: 15470) / 79, 13,   0.40978640D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15471: 15475) / 79, 14,   0.32409250D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15476: 15480) / 79, 15,   0.25414960D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15481: 15485) / 79, 16,   0.21210390D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15486: 15490) / 79, 17,   0.17438080D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15491: 15495) / 79, 18,   0.14364860D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15496: 15500) / 79, 19,   0.95062180D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15501: 15505) / 79, 20,   0.78160440D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15506: 15510) / 79, 21,   0.64557500D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15511: 15515) / 79, 22,   0.62406930D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15516: 15520) / 79, 23,   0.57177460D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15521: 15525) / 79, 24,   0.45167990D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15526: 15530) / 79, 25,   0.49272680D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15531: 15535) / 79, 26,   0.38791960D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15536: 15540) / 79, 27,   0.41040680D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15541: 15545) / 79, 28,   0.42244780D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15546: 15550) / 79, 29,   0.32511980D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15551: 15555) / 79, 30,   0.33331770D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15556: 15560) / 79, 31,   0.39382270D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15561: 15565) / 79, 32,   0.34809220D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15566: 15570) / 79, 33,   0.29810130D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15571: 15575) / 79, 34,   0.26850000D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15576: 15580) / 79, 35,   0.23607650D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15581: 15585) / 79, 36,   0.20637560D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15586: 15590) / 79, 37,   0.10663289D+04,   0.00000D+00,   0.00000D+00/
  data pars( 15591: 15595) / 79, 38,   0.93220550D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15596: 15600) / 79, 39,   0.81674650D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15601: 15605) / 79, 40,   0.73461520D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15606: 15610) / 79, 41,   0.67055170D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15611: 15615) / 79, 42,   0.51941000D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15616: 15620) / 79, 43,   0.57874610D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15621: 15625) / 79, 44,   0.44259210D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15626: 15630) / 79, 45,   0.48280890D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15631: 15635) / 79, 46,   0.44812160D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15636: 15640) / 79, 47,   0.37494860D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15641: 15645) / 79, 48,   0.39541490D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15646: 15650) / 79, 49,   0.49465360D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15651: 15655) / 79, 50,   0.45775290D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15656: 15660) / 79, 51,   0.40894270D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15661: 15665) / 79, 52,   0.38029110D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15666: 15670) / 79, 53,   0.34494080D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15671: 15675) / 79, 54,   0.31127000D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15676: 15680) / 79, 55,   0.12995975D+04,   0.00000D+00,   0.00000D+00/
  data pars( 15681: 15685) / 79, 56,   0.11895405D+04,   0.00000D+00,   0.00000D+00/
  data pars( 15686: 15690) / 79, 57,   0.10448996D+04,   0.00000D+00,   0.00000D+00/
  data pars( 15691: 15695) / 79, 58,   0.48348310D+03,   0.00000D+00,   0.27991D+01/
  data pars( 15696: 15700) / 79, 59,   0.10546339D+04,   0.00000D+00,   0.00000D+00/
  data pars( 15701: 15705) / 79, 60,   0.10125735D+04,   0.00000D+00,   0.00000D+00/
  data pars( 15706: 15710) / 79, 61,   0.98712160D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15711: 15715) / 79, 62,   0.96370210D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15716: 15720) / 79, 63,   0.94292740D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15721: 15725) / 79, 64,   0.74291920D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15726: 15730) / 79, 65,   0.83729210D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15731: 15735) / 79, 66,   0.80754210D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15736: 15740) / 79, 67,   0.85029540D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15741: 15745) / 79, 68,   0.83217180D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15746: 15750) / 79, 69,   0.81583760D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15751: 15755) / 79, 70,   0.80619030D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15756: 15760) / 79, 71,   0.68007310D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15761: 15765) / 79, 72,   0.66862000D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15766: 15770) / 79, 73,   0.61103860D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15771: 15775) / 79, 74,   0.51760830D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15776: 15780) / 79, 75,   0.52653700D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15781: 15785) / 79, 76,   0.47806720D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15786: 15790) / 79, 77,   0.43860830D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15791: 15795) / 79, 78,   0.36582470D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15796: 15800) / 79, 79,   0.34235260D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15801: 15805) / 80,  1,   0.32647500D+02,   0.00000D+00,   0.91180D+00/
  data pars( 15806: 15810) / 80,  2,   0.22083700D+02,   0.00000D+00,   0.00000D+00/
  data pars( 15811: 15815) / 80,  3,   0.48740200D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15816: 15820) / 80,  4,   0.28506170D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15821: 15825) / 80,  5,   0.19416150D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15826: 15830) / 80,  6,   0.13273170D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15831: 15835) / 80,  7,   0.93883600D+02,   0.00000D+00,   0.00000D+00/
  data pars( 15836: 15840) / 80,  8,   0.71776000D+02,   0.00000D+00,   0.00000D+00/
  data pars( 15841: 15845) / 80,  9,   0.54902300D+02,   0.00000D+00,   0.00000D+00/
  data pars( 15846: 15850) / 80, 10,   0.42608500D+02,   0.00000D+00,   0.00000D+00/
  data pars( 15851: 15855) / 80, 11,   0.58379600D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15856: 15860) / 80, 12,   0.45335960D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15861: 15865) / 80, 13,   0.41983840D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15866: 15870) / 80, 14,   0.33321670D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15871: 15875) / 80, 15,   0.26185840D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15876: 15880) / 80, 16,   0.21871850D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15881: 15885) / 80, 17,   0.17991240D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15886: 15890) / 80, 18,   0.14823250D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15891: 15895) / 80, 19,   0.95736170D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15896: 15900) / 80, 20,   0.79465850D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15901: 15905) / 80, 21,   0.65759170D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15906: 15910) / 80, 22,   0.63652100D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15911: 15915) / 80, 23,   0.58366570D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15916: 15920) / 80, 24,   0.46085090D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15921: 15925) / 80, 25,   0.50355400D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15926: 15930) / 80, 26,   0.39629990D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15931: 15935) / 80, 27,   0.42025520D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15936: 15940) / 80, 28,   0.43227410D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15941: 15945) / 80, 29,   0.33243400D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15946: 15950) / 80, 30,   0.34187100D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15951: 15955) / 80, 31,   0.40370590D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15956: 15960) / 80, 32,   0.35784550D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15961: 15965) / 80, 33,   0.30703710D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15966: 15970) / 80, 34,   0.27676970D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15971: 15975) / 80, 35,   0.24349600D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15976: 15980) / 80, 36,   0.21293560D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15981: 15985) / 80, 37,   0.10744128D+04,   0.00000D+00,   0.00000D+00/
  data pars( 15986: 15990) / 80, 38,   0.94720110D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15991: 15995) / 80, 39,   0.83242220D+03,   0.00000D+00,   0.00000D+00/
  data pars( 15996: 16000) / 80, 40,   0.74998240D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16001: 16005) / 80, 41,   0.68523850D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16006: 16010) / 80, 42,   0.53145620D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16011: 16015) / 80, 43,   0.59192160D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16016: 16020) / 80, 44,   0.45328020D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16021: 16025) / 80, 45,   0.49471860D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16026: 16030) / 80, 46,   0.45942820D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16031: 16035) / 80, 47,   0.38395180D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16036: 16040) / 80, 48,   0.40566070D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16041: 16045) / 80, 49,   0.50664510D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16046: 16050) / 80, 50,   0.47008500D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16051: 16055) / 80, 51,   0.42079320D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16056: 16060) / 80, 52,   0.39167400D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16061: 16065) / 80, 53,   0.35554970D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16066: 16070) / 80, 54,   0.32102510D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16071: 16075) / 80, 55,   0.13092921D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16076: 16080) / 80, 56,   0.12070341D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16081: 16085) / 80, 57,   0.10636276D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16086: 16090) / 80, 58,   0.49715300D+03,   0.00000D+00,   0.27991D+01/
  data pars( 16091: 16095) / 80, 59,   0.10712093D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16096: 16100) / 80, 60,   0.10290835D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16101: 16105) / 80, 61,   0.10033846D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16106: 16110) / 80, 62,   0.97972320D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16111: 16115) / 80, 63,   0.95873970D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16116: 16120) / 80, 64,   0.75756310D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16121: 16125) / 80, 65,   0.84922660D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16126: 16130) / 80, 66,   0.81952610D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16131: 16135) / 80, 67,   0.86529630D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16136: 16140) / 80, 68,   0.84694850D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16141: 16145) / 80, 69,   0.83044190D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16146: 16150) / 80, 70,   0.82053560D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16151: 16155) / 80, 71,   0.69354790D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16156: 16160) / 80, 72,   0.68391950D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16161: 16165) / 80, 73,   0.62592010D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16166: 16170) / 80, 74,   0.53051690D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16171: 16175) / 80, 75,   0.54005040D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16176: 16180) / 80, 76,   0.49085310D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16181: 16185) / 80, 77,   0.45068210D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16186: 16190) / 80, 78,   0.37600960D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16191: 16195) / 80, 79,   0.35193500D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16196: 16200) / 80, 80,   0.36207550D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16201: 16205) / 81,  1,   0.45565900D+02,   0.00000D+00,   0.91180D+00/
  data pars( 16206: 16210) / 81,  2,   0.29383200D+02,   0.00000D+00,   0.00000D+00/
  data pars( 16211: 16215) / 81,  3,   0.84156200D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16216: 16220) / 81,  4,   0.44509900D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16221: 16225) / 81,  5,   0.28743460D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16226: 16230) / 81,  6,   0.18891370D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16231: 16235) / 81,  7,   0.12977590D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16236: 16240) / 81,  8,   0.97188700D+02,   0.00000D+00,   0.00000D+00/
  data pars( 16241: 16245) / 81,  9,   0.73035300D+02,   0.00000D+00,   0.00000D+00/
  data pars( 16246: 16250) / 81, 10,   0.55878200D+02,   0.00000D+00,   0.00000D+00/
  data pars( 16251: 16255) / 81, 11,   0.10013499D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16256: 16260) / 81, 12,   0.71984280D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16261: 16265) / 81, 13,   0.64850370D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16266: 16270) / 81, 14,   0.49588920D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16271: 16275) / 81, 15,   0.37786060D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16276: 16280) / 81, 16,   0.30940570D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16281: 16285) / 81, 17,   0.24971520D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16286: 16290) / 81, 18,   0.20236390D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16291: 16295) / 81, 19,   0.16699732D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16296: 16300) / 81, 20,   0.13012325D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16301: 16305) / 81, 21,   0.10621257D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16306: 16310) / 81, 22,   0.10156676D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16311: 16315) / 81, 23,   0.92450540D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16316: 16320) / 81, 24,   0.72875260D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16321: 16325) / 81, 25,   0.78917040D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16326: 16330) / 81, 26,   0.61912140D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16331: 16335) / 81, 27,   0.64688450D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16336: 16340) / 81, 28,   0.67034360D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16341: 16345) / 81, 29,   0.51478030D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16346: 16350) / 81, 30,   0.51777130D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16351: 16355) / 81, 31,   0.61653920D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16356: 16360) / 81, 32,   0.53101480D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16361: 16365) / 81, 33,   0.44413160D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16366: 16370) / 81, 34,   0.39408930D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16371: 16375) / 81, 35,   0.34115420D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16376: 16380) / 81, 36,   0.29394640D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16381: 16385) / 81, 37,   0.18646164D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16386: 16390) / 81, 38,   0.15547036D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16391: 16395) / 81, 39,   0.13341432D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16396: 16400) / 81, 40,   0.11843558D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16401: 16405) / 81, 41,   0.10716858D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16406: 16410) / 81, 42,   0.81713880D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16411: 16415) / 81, 43,   0.91594930D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16416: 16420) / 81, 44,   0.68833610D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16421: 16425) / 81, 45,   0.75141170D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16426: 16430) / 81, 46,   0.69349420D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16431: 16435) / 81, 47,   0.58127400D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16436: 16440) / 81, 48,   0.60745600D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16441: 16445) / 81, 49,   0.77388330D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16446: 16450) / 81, 50,   0.70133540D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16451: 16455) / 81, 51,   0.61379650D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16456: 16460) / 81, 52,   0.56366330D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16461: 16465) / 81, 53,   0.50431850D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16466: 16470) / 81, 54,   0.44915730D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16471: 16475) / 81, 55,   0.22724078D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16476: 16480) / 81, 56,   0.19977665D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16481: 16485) / 81, 57,   0.17187930D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16486: 16490) / 81, 58,   0.72802070D+03,   0.00000D+00,   0.27991D+01/
  data pars( 16491: 16495) / 81, 59,   0.17584731D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16496: 16500) / 81, 60,   0.16821281D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16501: 16505) / 81, 61,   0.16382173D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16506: 16510) / 81, 62,   0.15980083D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16511: 16515) / 81, 63,   0.15622939D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16516: 16520) / 81, 64,   0.12025229D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16521: 16525) / 81, 65,   0.14026627D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16526: 16530) / 81, 66,   0.13479037D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16531: 16535) / 81, 67,   0.14013832D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16536: 16540) / 81, 68,   0.13707449D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16541: 16545) / 81, 69,   0.13427654D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16546: 16550) / 81, 70,   0.13281907D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16551: 16555) / 81, 71,   0.11030932D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16556: 16560) / 81, 72,   0.10619960D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16561: 16565) / 81, 73,   0.95783300D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16566: 16570) / 81, 74,   0.80262850D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16571: 16575) / 81, 75,   0.81249710D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16576: 16580) / 81, 76,   0.72924020D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16581: 16585) / 81, 77,   0.66279090D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16586: 16590) / 81, 78,   0.54691720D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16591: 16595) / 81, 79,   0.50961460D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16596: 16600) / 81, 80,   0.52190910D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16601: 16605) / 81, 81,   0.79223780D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16606: 16610) / 82,  1,   0.45178600D+02,   0.00000D+00,   0.91180D+00/
  data pars( 16611: 16615) / 82,  2,   0.29396300D+02,   0.00000D+00,   0.00000D+00/
  data pars( 16616: 16620) / 82,  3,   0.77049850D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16621: 16625) / 82,  4,   0.42598770D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16626: 16630) / 82,  5,   0.28017140D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16631: 16635) / 82,  6,   0.18622350D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16636: 16640) / 82,  7,   0.12882430D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16641: 16645) / 82,  8,   0.96880100D+02,   0.00000D+00,   0.00000D+00/
  data pars( 16646: 16650) / 82,  9,   0.73028500D+02,   0.00000D+00,   0.00000D+00/
  data pars( 16651: 16655) / 82, 10,   0.55990900D+02,   0.00000D+00,   0.00000D+00/
  data pars( 16656: 16660) / 82, 11,   0.91912570D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16661: 16665) / 82, 12,   0.68410110D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16666: 16670) / 82, 13,   0.62271340D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16671: 16675) / 82, 14,   0.48258810D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16676: 16680) / 82, 15,   0.37129390D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16681: 16685) / 82, 16,   0.30563890D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16686: 16690) / 82, 17,   0.24781410D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16691: 16695) / 82, 18,   0.20153300D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16696: 16700) / 82, 19,   0.15164193D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16701: 16705) / 82, 20,   0.12187009D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16706: 16710) / 82, 21,   0.10008602D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16711: 16715) / 82, 22,   0.96137180D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16716: 16720) / 82, 23,   0.87756550D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16721: 16725) / 82, 24,   0.69108340D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16726: 16730) / 82, 25,   0.75211560D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16731: 16735) / 82, 26,   0.58980850D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16736: 16740) / 82, 27,   0.62087440D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16741: 16745) / 82, 28,   0.64167640D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16746: 16750) / 82, 29,   0.49199760D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16751: 16755) / 82, 30,   0.49993220D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16756: 16760) / 82, 31,   0.59373850D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16761: 16765) / 82, 32,   0.51689320D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16766: 16770) / 82, 33,   0.43592810D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16771: 16775) / 82, 34,   0.38853730D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16776: 16780) / 82, 35,   0.33776830D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16781: 16785) / 82, 36,   0.29204720D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16786: 16790) / 82, 37,   0.16956909D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16791: 16795) / 82, 38,   0.14534745D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16796: 16800) / 82, 39,   0.12598691D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16801: 16805) / 82, 40,   0.11249617D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16806: 16810) / 82, 41,   0.10214733D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16811: 16815) / 82, 42,   0.78299060D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16816: 16820) / 82, 43,   0.87595820D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16821: 16825) / 82, 44,   0.66216750D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16826: 16830) / 82, 45,   0.72370460D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16831: 16835) / 82, 46,   0.66938820D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16836: 16840) / 82, 47,   0.55927100D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16841: 16845) / 82, 48,   0.58793680D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16846: 16850) / 82, 49,   0.74387970D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16851: 16855) / 82, 50,   0.68057520D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16856: 16860) / 82, 51,   0.60037140D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16861: 16865) / 82, 52,   0.55368260D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16866: 16870) / 82, 53,   0.49748720D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16871: 16875) / 82, 54,   0.44470070D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16876: 16880) / 82, 55,   0.20646687D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16881: 16885) / 82, 56,   0.18594085D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16886: 16890) / 82, 57,   0.16164677D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16891: 16895) / 82, 58,   0.71062890D+03,   0.00000D+00,   0.27991D+01/
  data pars( 16896: 16900) / 82, 59,   0.16419885D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16901: 16905) / 82, 60,   0.15739763D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16906: 16910) / 82, 61,   0.15337469D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16911: 16915) / 82, 62,   0.14968291D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16916: 16920) / 82, 63,   0.14640624D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16921: 16925) / 82, 64,   0.11380979D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16926: 16930) / 82, 65,   0.13034316D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16931: 16935) / 82, 66,   0.12545335D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16936: 16940) / 82, 67,   0.13170177D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16941: 16945) / 82, 68,   0.12886907D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16946: 16950) / 82, 69,   0.12629662D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16951: 16955) / 82, 70,   0.12487891D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16956: 16960) / 82, 71,   0.10439034D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16961: 16965) / 82, 72,   0.10154887D+04,   0.00000D+00,   0.00000D+00/
  data pars( 16966: 16970) / 82, 73,   0.92083050D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16971: 16975) / 82, 74,   0.77385260D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16976: 16980) / 82, 75,   0.78529450D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16981: 16985) / 82, 76,   0.70790090D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16986: 16990) / 82, 77,   0.64554700D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16991: 16995) / 82, 78,   0.53402070D+03,   0.00000D+00,   0.00000D+00/
  data pars( 16996: 17000) / 82, 79,   0.49813010D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17001: 17005) / 82, 80,   0.51131450D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17006: 17010) / 82, 81,   0.76196480D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17011: 17015) / 82, 82,   0.73881560D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17016: 17020) / 83,  1,   0.42241900D+02,   0.00000D+00,   0.91180D+00/
  data pars( 17021: 17025) / 83,  2,   0.27932900D+02,   0.00000D+00,   0.00000D+00/
  data pars( 17026: 17030) / 83,  3,   0.66152780D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17031: 17035) / 83,  4,   0.38103070D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17036: 17040) / 83,  5,   0.25605370D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17041: 17045) / 83,  6,   0.17278310D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17046: 17050) / 83,  7,   0.12079930D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17051: 17055) / 83,  8,   0.91493400D+02,   0.00000D+00,   0.00000D+00/
  data pars( 17056: 17060) / 83,  9,   0.69368900D+02,   0.00000D+00,   0.00000D+00/
  data pars( 17061: 17065) / 83, 10,   0.53420400D+02,   0.00000D+00,   0.00000D+00/
  data pars( 17066: 17070) / 83, 11,   0.79108680D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17071: 17075) / 83, 12,   0.60760080D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17076: 17080) / 83, 13,   0.55943360D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17081: 17085) / 83, 14,   0.44013430D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17086: 17090) / 83, 15,   0.34277880D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17091: 17095) / 83, 16,   0.28429480D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17096: 17100) / 83, 17,   0.23212190D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17101: 17105) / 83, 18,   0.18987560D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17106: 17110) / 83, 19,   0.12966253D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17111: 17115) / 83, 20,   0.10686331D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17116: 17120) / 83, 21,   0.88251530D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17121: 17125) / 83, 22,   0.85188550D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17126: 17130) / 83, 23,   0.77993360D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17131: 17135) / 83, 24,   0.61445090D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17136: 17140) / 83, 25,   0.67130550D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17141: 17145) / 83, 26,   0.52693210D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17146: 17150) / 83, 27,   0.55817400D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17151: 17155) / 83, 28,   0.57514870D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17156: 17160) / 83, 29,   0.44105510D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17161: 17165) / 83, 30,   0.45236780D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17166: 17170) / 83, 31,   0.53570130D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17171: 17175) / 83, 32,   0.47183760D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17176: 17180) / 83, 33,   0.40199200D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17181: 17185) / 83, 34,   0.36047350D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17186: 17190) / 83, 35,   0.31527740D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17191: 17195) / 83, 36,   0.27407550D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17196: 17200) / 83, 37,   0.14529418D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17201: 17205) / 83, 38,   0.12732370D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17206: 17210) / 83, 39,   0.11143977D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17211: 17215) / 83, 40,   0.10010315D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17216: 17220) / 83, 41,   0.91248200D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17221: 17225) / 83, 42,   0.70407130D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17226: 17230) / 83, 43,   0.78575170D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17231: 17235) / 83, 44,   0.59827920D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17236: 17240) / 83, 45,   0.65393370D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17241: 17245) / 83, 46,   0.60631280D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17246: 17250) / 83, 47,   0.50575740D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17251: 17255) / 83, 48,   0.53417140D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17256: 17260) / 83, 49,   0.67073540D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17261: 17265) / 83, 50,   0.61958270D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17266: 17270) / 83, 51,   0.55156050D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17271: 17275) / 83, 52,   0.51139760D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17276: 17280) / 83, 53,   0.46208340D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17281: 17285) / 83, 54,   0.41520110D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17286: 17290) / 83, 55,   0.17696390D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17291: 17295) / 83, 56,   0.16234740D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17296: 17300) / 83, 57,   0.14251223D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17301: 17305) / 83, 58,   0.65171260D+03,   0.00000D+00,   0.27991D+01/
  data pars( 17306: 17310) / 83, 59,   0.14382615D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17311: 17315) / 83, 60,   0.13809451D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17316: 17320) / 83, 61,   0.13462674D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17321: 17325) / 83, 62,   0.13143784D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17326: 17330) / 83, 63,   0.12860963D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17331: 17335) / 83, 64,   0.10103860D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17336: 17340) / 83, 65,   0.11390166D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17341: 17345) / 83, 66,   0.10983110D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17346: 17350) / 83, 67,   0.11597774D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17351: 17355) / 83, 68,   0.11351424D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17356: 17360) / 83, 69,   0.11129109D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17361: 17365) / 83, 70,   0.10999410D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17366: 17370) / 83, 71,   0.92612910D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17371: 17375) / 83, 72,   0.90981540D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17376: 17380) / 83, 73,   0.82982850D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17381: 17385) / 83, 74,   0.70043950D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17386: 17390) / 83, 75,   0.71241700D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17391: 17395) / 83, 76,   0.64537650D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17396: 17400) / 83, 77,   0.59085050D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17401: 17405) / 83, 78,   0.49072340D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17406: 17410) / 83, 79,   0.45847260D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17411: 17415) / 83, 80,   0.47152310D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17416: 17420) / 83, 81,   0.68856550D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17421: 17425) / 83, 82,   0.67269040D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17426: 17430) / 83, 83,   0.61752960D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17431: 17435) / 84,  1,   0.40710600D+02,   0.00000D+00,   0.91180D+00/
  data pars( 17436: 17440) / 84,  2,   0.27211800D+02,   0.00000D+00,   0.00000D+00/
  data pars( 17441: 17445) / 84,  3,   0.60731510D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17446: 17450) / 84,  4,   0.35746030D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17451: 17455) / 84,  5,   0.24330570D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17456: 17460) / 84,  6,   0.16573270D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17461: 17465) / 84,  7,   0.11666150D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17466: 17470) / 84,  8,   0.88773600D+02,   0.00000D+00,   0.00000D+00/
  data pars( 17471: 17475) / 84,  9,   0.67567200D+02,   0.00000D+00,   0.00000D+00/
  data pars( 17476: 17480) / 84, 10,   0.52188100D+02,   0.00000D+00,   0.00000D+00/
  data pars( 17481: 17485) / 84, 11,   0.72726310D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17486: 17490) / 84, 12,   0.56780720D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17491: 17495) / 84, 13,   0.52626000D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17496: 17500) / 84, 14,   0.41768440D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17501: 17505) / 84, 15,   0.32771360D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17506: 17510) / 84, 16,   0.27309950D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17511: 17515) / 84, 17,   0.22398500D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17516: 17520) / 84, 18,   0.18392230D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17521: 17525) / 84, 19,   0.11891902D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17526: 17530) / 84, 20,   0.99221250D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17531: 17535) / 84, 21,   0.82178250D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17536: 17540) / 84, 22,   0.79553840D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17541: 17545) / 84, 23,   0.72956570D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17546: 17550) / 84, 24,   0.57517310D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17551: 17555) / 84, 25,   0.62948100D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17556: 17560) / 84, 26,   0.49459140D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17561: 17565) / 84, 27,   0.52549790D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17566: 17570) / 84, 28,   0.54053270D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17571: 17575) / 84, 29,   0.41478690D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17576: 17580) / 84, 30,   0.42746160D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17581: 17585) / 84, 31,   0.50536000D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17586: 17590) / 84, 32,   0.44808220D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17591: 17595) / 84, 33,   0.38408530D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17596: 17600) / 84, 34,   0.34572660D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17601: 17605) / 84, 35,   0.30354480D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17606: 17610) / 84, 36,   0.26479780D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17611: 17615) / 84, 37,   0.13343692D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17616: 17620) / 84, 38,   0.11818604D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17621: 17625) / 84, 39,   0.10398622D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17626: 17630) / 84, 40,   0.93720360D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17631: 17635) / 84, 41,   0.85623980D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17636: 17640) / 84, 42,   0.66336080D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17641: 17645) / 84, 43,   0.73919570D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17646: 17650) / 84, 44,   0.56531410D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17651: 17655) / 84, 45,   0.61769980D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17656: 17660) / 84, 46,   0.57350990D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17661: 17665) / 84, 47,   0.47823360D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17666: 17670) / 84, 48,   0.50616860D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17671: 17675) / 84, 49,   0.63278330D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17676: 17680) / 84, 50,   0.58760970D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17681: 17685) / 84, 51,   0.52587280D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17686: 17690) / 84, 52,   0.48916400D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17691: 17695) / 84, 53,   0.44353000D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17696: 17700) / 84, 54,   0.39983350D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17701: 17705) / 84, 55,   0.16260419D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17706: 17710) / 84, 56,   0.15047607D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17711: 17715) / 84, 57,   0.13277397D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17716: 17720) / 84, 58,   0.62085480D+03,   0.00000D+00,   0.27991D+01/
  data pars( 17721: 17725) / 84, 59,   0.13354309D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17726: 17730) / 84, 60,   0.12832336D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17731: 17735) / 84, 61,   0.12512879D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17736: 17740) / 84, 62,   0.12218775D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17741: 17745) / 84, 63,   0.11958046D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17746: 17750) / 84, 64,   0.94515700D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17751: 17755) / 84, 65,   0.10569864D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17756: 17760) / 84, 66,   0.10202790D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17761: 17765) / 84, 67,   0.10796889D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17766: 17770) / 84, 68,   0.10568831D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17771: 17775) / 84, 69,   0.10363788D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17776: 17780) / 84, 70,   0.10240338D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17781: 17785) / 84, 71,   0.86580300D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17786: 17790) / 84, 72,   0.85504390D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17791: 17795) / 84, 73,   0.78248020D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17796: 17800) / 84, 74,   0.66238200D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17801: 17805) / 84, 75,   0.67449800D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17806: 17810) / 84, 76,   0.61277720D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17811: 17815) / 84, 77,   0.56231000D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17816: 17820) / 84, 78,   0.46825250D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17821: 17825) / 84, 79,   0.43792710D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17826: 17830) / 84, 80,   0.45080740D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17831: 17835) / 84, 81,   0.65074290D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17836: 17840) / 84, 82,   0.63822510D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17841: 17845) / 84, 83,   0.58861880D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17846: 17850) / 84, 84,   0.56260110D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17851: 17855) / 85,  1,   0.38046800D+02,   0.00000D+00,   0.91180D+00/
  data pars( 17856: 17860) / 85,  2,   0.25807100D+02,   0.00000D+00,   0.00000D+00/
  data pars( 17861: 17865) / 85,  3,   0.53565210D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17866: 17870) / 85,  4,   0.32315400D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17871: 17875) / 85,  5,   0.22339710D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17876: 17880) / 85,  6,   0.15398830D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17881: 17885) / 85,  7,   0.10936180D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17886: 17890) / 85,  8,   0.83743700D+02,   0.00000D+00,   0.00000D+00/
  data pars( 17891: 17895) / 85,  9,   0.64079700D+02,   0.00000D+00,   0.00000D+00/
  data pars( 17896: 17900) / 85, 10,   0.49704300D+02,   0.00000D+00,   0.00000D+00/
  data pars( 17901: 17905) / 85, 11,   0.64255990D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17906: 17910) / 85, 12,   0.51104720D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17911: 17915) / 85, 13,   0.47738160D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17916: 17920) / 85, 14,   0.38289140D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17921: 17925) / 85, 15,   0.30317170D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17926: 17930) / 85, 16,   0.25418990D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17931: 17935) / 85, 17,   0.20969510D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17936: 17940) / 85, 18,   0.17306680D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17941: 17945) / 85, 19,   0.10486754D+04,   0.00000D+00,   0.00000D+00/
  data pars( 17946: 17950) / 85, 20,   0.88679380D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17951: 17955) / 85, 21,   0.73687680D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17956: 17960) / 85, 22,   0.71582420D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17961: 17965) / 85, 23,   0.65777000D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17966: 17970) / 85, 24,   0.51922800D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17971: 17975) / 85, 25,   0.56918500D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17976: 17980) / 85, 26,   0.44794120D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17981: 17985) / 85, 27,   0.47740460D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17986: 17990) / 85, 28,   0.49002960D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17991: 17995) / 85, 29,   0.37654500D+03,   0.00000D+00,   0.00000D+00/
  data pars( 17996: 18000) / 85, 30,   0.39005450D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18001: 18005) / 85, 31,   0.46013230D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18006: 18010) / 85, 32,   0.41119140D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18011: 18015) / 85, 33,   0.35508990D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18016: 18020) / 85, 34,   0.32115720D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18021: 18025) / 85, 35,   0.28336260D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18026: 18030) / 85, 36,   0.24831690D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18031: 18035) / 85, 37,   0.11787843D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18036: 18040) / 85, 38,   0.10561781D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18041: 18045) / 85, 39,   0.93492800D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18046: 18050) / 85, 40,   0.84595890D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18051: 18055) / 85, 41,   0.77500770D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18056: 18060) / 85, 42,   0.60351860D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18061: 18065) / 85, 43,   0.67120920D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18066: 18070) / 85, 44,   0.51618070D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18071: 18075) / 85, 45,   0.56361340D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18076: 18080) / 85, 46,   0.52417160D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18081: 18085) / 85, 47,   0.43716280D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18086: 18090) / 85, 48,   0.46363160D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18091: 18095) / 85, 49,   0.57648690D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18096: 18100) / 85, 50,   0.53857130D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18101: 18105) / 85, 51,   0.48503660D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18106: 18110) / 85, 52,   0.45297260D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18111: 18115) / 85, 53,   0.41249290D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18116: 18120) / 85, 54,   0.37339600D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18121: 18125) / 85, 55,   0.14375237D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18126: 18130) / 85, 56,   0.13427557D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18131: 18135) / 85, 57,   0.11918004D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18136: 18140) / 85, 58,   0.57219880D+03,   0.00000D+00,   0.27991D+01/
  data pars( 18141: 18145) / 85, 59,   0.11941552D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18146: 18150) / 85, 60,   0.11484879D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18151: 18155) / 85, 61,   0.11201674D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18156: 18160) / 85, 62,   0.10940580D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18161: 18165) / 85, 63,   0.10709219D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18166: 18170) / 85, 64,   0.85263060D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18171: 18175) / 85, 65,   0.94504500D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18176: 18180) / 85, 66,   0.91333710D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18181: 18185) / 85, 67,   0.96825870D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18186: 18190) / 85, 68,   0.94792020D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18191: 18195) / 85, 69,   0.92971630D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18196: 18200) / 85, 70,   0.91834420D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18201: 18205) / 85, 71,   0.78031510D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18206: 18210) / 85, 72,   0.77523370D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18211: 18215) / 85, 73,   0.71228880D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18216: 18220) / 85, 74,   0.60524130D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18221: 18225) / 85, 75,   0.61710680D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18226: 18230) / 85, 76,   0.56258800D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18231: 18235) / 85, 77,   0.51772850D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18236: 18240) / 85, 78,   0.43264880D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18241: 18245) / 85, 79,   0.40518020D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18246: 18250) / 85, 80,   0.41747370D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18251: 18255) / 85, 81,   0.59434970D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18256: 18260) / 85, 82,   0.58543140D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18261: 18265) / 85, 83,   0.54287440D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18266: 18270) / 85, 84,   0.52058720D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18271: 18275) / 85, 85,   0.48365360D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18276: 18280) / 86,  1,   0.35275000D+02,   0.00000D+00,   0.91180D+00/
  data pars( 18281: 18285) / 86,  2,   0.24288600D+02,   0.00000D+00,   0.00000D+00/
  data pars( 18286: 18290) / 86,  3,   0.47129940D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18291: 18295) / 86,  4,   0.29040790D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18296: 18300) / 86,  5,   0.20366210D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18301: 18305) / 86,  6,   0.14199460D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18306: 18310) / 86,  7,   0.10173400D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18311: 18315) / 86,  8,   0.78399300D+02,   0.00000D+00,   0.00000D+00/
  data pars( 18316: 18320) / 86,  9,   0.60320800D+02,   0.00000D+00,   0.00000D+00/
  data pars( 18321: 18325) / 86, 10,   0.46997000D+02,   0.00000D+00,   0.00000D+00/
  data pars( 18326: 18330) / 86, 11,   0.56630470D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18331: 18335) / 86, 12,   0.45752070D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18336: 18340) / 86, 13,   0.43040700D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18341: 18345) / 86, 14,   0.34853240D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18346: 18350) / 86, 15,   0.27834410D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18351: 18355) / 86, 16,   0.23475630D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18356: 18360) / 86, 17,   0.19477780D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18361: 18365) / 86, 18,   0.16157780D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18366: 18370) / 86, 19,   0.92348960D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18371: 18375) / 86, 20,   0.78946510D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18376: 18380) / 86, 21,   0.65782090D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18381: 18385) / 86, 22,   0.64106890D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18386: 18390) / 86, 23,   0.59013650D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18391: 18395) / 86, 24,   0.46657860D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18396: 18400) / 86, 25,   0.51200690D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18401: 18405) / 86, 26,   0.40371620D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18406: 18410) / 86, 27,   0.43125430D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18411: 18415) / 86, 28,   0.44180520D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18416: 18420) / 86, 29,   0.34010290D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18421: 18425) / 86, 30,   0.35375690D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18426: 18430) / 86, 31,   0.41640720D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18431: 18435) / 86, 32,   0.37473780D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18436: 18440) / 86, 33,   0.32584680D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18441: 18445) / 86, 34,   0.29605910D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18446: 18450) / 86, 35,   0.26246780D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18451: 18455) / 86, 36,   0.23103920D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18456: 18460) / 86, 37,   0.10398788D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18461: 18465) / 86, 38,   0.94037660D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18466: 18470) / 86, 39,   0.83682440D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18471: 18475) / 86, 40,   0.75986860D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18476: 18480) / 86, 41,   0.69790750D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18481: 18485) / 86, 42,   0.54617620D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18486: 18490) / 86, 43,   0.60628810D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18491: 18495) / 86, 44,   0.46875270D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18496: 18500) / 86, 45,   0.51133700D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18501: 18505) / 86, 46,   0.47629130D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18506: 18510) / 86, 47,   0.39751230D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18511: 18515) / 86, 48,   0.42213930D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18516: 18520) / 86, 49,   0.52225240D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18521: 18525) / 86, 50,   0.49045740D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18526: 18530) / 86, 51,   0.44423510D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18531: 18535) / 86, 52,   0.41640380D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18536: 18540) / 86, 53,   0.38074630D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18541: 18545) / 86, 54,   0.34603400D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18546: 18550) / 86, 55,   0.12691514D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18551: 18555) / 86, 56,   0.11942553D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18556: 18560) / 86, 57,   0.10653886D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18561: 18565) / 86, 58,   0.52379990D+03,   0.00000D+00,   0.27991D+01/
  data pars( 18566: 18570) / 86, 59,   0.10641113D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18571: 18575) / 86, 60,   0.10241601D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18576: 18580) / 86, 61,   0.99910040D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18581: 18585) / 86, 62,   0.97596710D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18586: 18590) / 86, 63,   0.95547530D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18591: 18595) / 86, 64,   0.76577540D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18596: 18600) / 86, 65,   0.84248080D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18601: 18605) / 86, 66,   0.81508100D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18606: 18610) / 86, 67,   0.86486000D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18611: 18615) / 86, 68,   0.84676410D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18616: 18620) / 86, 69,   0.83063370D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18621: 18625) / 86, 70,   0.82022230D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18626: 18630) / 86, 71,   0.70009390D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18631: 18635) / 86, 72,   0.69908500D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18636: 18640) / 86, 73,   0.64467130D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18641: 18645) / 86, 74,   0.54983920D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18646: 18650) / 86, 75,   0.56121370D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18651: 18655) / 86, 76,   0.51327610D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18656: 18660) / 86, 77,   0.47360870D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18661: 18665) / 86, 78,   0.39719060D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18666: 18670) / 86, 79,   0.37248250D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18671: 18675) / 86, 80,   0.38402410D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18676: 18680) / 86, 81,   0.53990550D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18681: 18685) / 86, 82,   0.53369840D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18686: 18690) / 86, 83,   0.49729720D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18691: 18695) / 86, 84,   0.47831130D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18696: 18700) / 86, 85,   0.44604470D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18701: 18705) / 86, 86,   0.41282750D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18706: 18710) / 87,  1,   0.10074940D+03,   0.00000D+00,   0.91180D+00/
  data pars( 18711: 18715) / 87,  2,   0.59659400D+02,   0.00000D+00,   0.00000D+00/
  data pars( 18716: 18720) / 87,  3,   0.28945966D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18721: 18725) / 87,  4,   0.12189348D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18726: 18730) / 87,  5,   0.71065850D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18731: 18735) / 87,  6,   0.43419670D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18736: 18740) / 87,  7,   0.28277630D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18741: 18745) / 87,  8,   0.20397230D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18746: 18750) / 87,  9,   0.14835840D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18751: 18755) / 87, 10,   0.11051200D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18756: 18760) / 87, 11,   0.33986461D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18761: 18765) / 87, 12,   0.20446296D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18766: 18770) / 87, 13,   0.17465418D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18771: 18775) / 87, 14,   0.12378269D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18776: 18780) / 87, 15,   0.88882250D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18781: 18785) / 87, 16,   0.70197610D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18786: 18790) / 87, 17,   0.54727120D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18791: 18795) / 87, 18,   0.43044680D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18796: 18800) / 87, 19,   0.60209123D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18801: 18805) / 87, 20,   0.39885535D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18806: 18810) / 87, 21,   0.31533933D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18811: 18815) / 87, 22,   0.29483214D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18816: 18820) / 87, 23,   0.26441348D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18821: 18825) / 87, 24,   0.20951563D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18826: 18830) / 87, 25,   0.22092516D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18831: 18835) / 87, 26,   0.17359767D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18836: 18840) / 87, 27,   0.17406013D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18841: 18845) / 87, 28,   0.18302286D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18846: 18850) / 87, 29,   0.14168737D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18851: 18855) / 87, 30,   0.13464975D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18856: 18860) / 87, 31,   0.16330869D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18861: 18865) / 87, 32,   0.13219669D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18866: 18870) / 87, 33,   0.10509064D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18871: 18875) / 87, 34,   0.90547240D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18876: 18880) / 87, 35,   0.76070860D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18881: 18885) / 87, 36,   0.63792100D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18886: 18890) / 87, 37,   0.66879551D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18891: 18895) / 87, 38,   0.48140613D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18896: 18900) / 87, 39,   0.39238630D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18901: 18905) / 87, 40,   0.33777348D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18906: 18910) / 87, 41,   0.30012009D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18911: 18915) / 87, 42,   0.22208404D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18916: 18920) / 87, 43,   0.25189457D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18921: 18925) / 87, 44,   0.18286037D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18926: 18930) / 87, 45,   0.19819822D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18931: 18935) / 87, 46,   0.18052792D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18936: 18940) / 87, 47,   0.15403020D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18941: 18945) / 87, 48,   0.15550964D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18946: 18950) / 87, 49,   0.20671731D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18951: 18955) / 87, 50,   0.17732620D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18956: 18960) / 87, 51,   0.14801255D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18961: 18965) / 87, 52,   0.13236329D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18966: 18970) / 87, 53,   0.11516386D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18971: 18975) / 87, 54,   0.99949930D+03,   0.00000D+00,   0.00000D+00/
  data pars( 18976: 18980) / 87, 55,   0.82315280D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18981: 18985) / 87, 56,   0.63397235D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18986: 18990) / 87, 57,   0.51715628D+04,   0.00000D+00,   0.00000D+00/
  data pars( 18991: 18995) / 87, 58,   0.17765919D+04,   0.00000D+00,   0.27991D+01/
  data pars( 18996: 19000) / 87, 59,   0.54969601D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19001: 19005) / 87, 60,   0.51886826D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19006: 19010) / 87, 61,   0.50376830D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19011: 19015) / 87, 62,   0.49009739D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19016: 19020) / 87, 63,   0.47792385D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19021: 19025) / 87, 64,   0.35004650D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19026: 19030) / 87, 65,   0.45180145D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19031: 19035) / 87, 66,   0.43256882D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19036: 19040) / 87, 67,   0.42216216D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19041: 19045) / 87, 68,   0.41211013D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19046: 19050) / 87, 69,   0.40270614D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19051: 19055) / 87, 70,   0.39908778D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19056: 19060) / 87, 71,   0.32187704D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19061: 19065) / 87, 72,   0.29218119D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19066: 19070) / 87, 73,   0.25563295D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19071: 19075) / 87, 74,   0.21076991D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19076: 19080) / 87, 75,   0.21032454D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19081: 19085) / 87, 76,   0.18383882D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19086: 19090) / 87, 77,   0.16363884D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19091: 19095) / 87, 78,   0.13271181D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19096: 19100) / 87, 79,   0.12270914D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19101: 19105) / 87, 80,   0.12394986D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19106: 19110) / 87, 81,   0.21094753D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19111: 19115) / 87, 82,   0.19333025D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19116: 19120) / 87, 83,   0.16699965D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19121: 19125) / 87, 84,   0.15408317D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19126: 19130) / 87, 85,   0.13687363D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19131: 19135) / 87, 86,   0.12134959D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19136: 19140) / 87, 87,   0.73147398D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19141: 19145) / 88,  1,   0.99413100D+02,   0.00000D+00,   0.91180D+00/
  data pars( 19146: 19150) / 88,  2,   0.59674000D+02,   0.00000D+00,   0.00000D+00/
  data pars( 19151: 19155) / 88,  3,   0.24340697D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19156: 19160) / 88,  4,   0.11320344D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19161: 19165) / 88,  5,   0.68137890D+03,   0.00000D+00,   0.00000D+00/
  data pars( 19166: 19170) / 88,  6,   0.42416130D+03,   0.00000D+00,   0.00000D+00/
  data pars( 19171: 19175) / 88,  7,   0.27936020D+03,   0.00000D+00,   0.00000D+00/
  data pars( 19176: 19180) / 88,  8,   0.20282600D+03,   0.00000D+00,   0.00000D+00/
  data pars( 19181: 19185) / 88,  9,   0.14825160D+03,   0.00000D+00,   0.00000D+00/
  data pars( 19186: 19190) / 88, 10,   0.11081260D+03,   0.00000D+00,   0.00000D+00/
  data pars( 19191: 19195) / 88, 11,   0.28745717D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19196: 19200) / 88, 12,   0.18719600D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19201: 19205) / 88, 13,   0.16279493D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19206: 19210) / 88, 14,   0.11837103D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19211: 19215) / 88, 15,   0.86434290D+03,   0.00000D+00,   0.00000D+00/
  data pars( 19216: 19220) / 88, 16,   0.68837560D+03,   0.00000D+00,   0.00000D+00/
  data pars( 19221: 19225) / 88, 17,   0.54058680D+03,   0.00000D+00,   0.00000D+00/
  data pars( 19226: 19230) / 88, 18,   0.42751470D+03,   0.00000D+00,   0.00000D+00/
  data pars( 19231: 19235) / 88, 19,   0.49128581D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19236: 19240) / 88, 20,   0.35289590D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19241: 19245) / 88, 21,   0.28292273D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19246: 19250) / 88, 22,   0.26655950D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19251: 19255) / 88, 23,   0.24036878D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19256: 19260) / 88, 24,   0.18947707D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19261: 19265) / 88, 25,   0.20238919D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19266: 19270) / 88, 26,   0.15845838D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19271: 19275) / 88, 27,   0.16192221D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19276: 19280) / 88, 28,   0.16942469D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19281: 19285) / 88, 29,   0.13022136D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19286: 19290) / 88, 30,   0.12677966D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19291: 19295) / 88, 31,   0.15270149D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19296: 19300) / 88, 32,   0.12635730D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19301: 19305) / 88, 33,   0.10197251D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19306: 19310) / 88, 34,   0.88504330D+03,   0.00000D+00,   0.00000D+00/
  data pars( 19311: 19315) / 88, 35,   0.74865020D+03,   0.00000D+00,   0.00000D+00/
  data pars( 19316: 19320) / 88, 36,   0.63127570D+03,   0.00000D+00,   0.00000D+00/
  data pars( 19321: 19325) / 88, 37,   0.54594039D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19326: 19330) / 88, 38,   0.42339736D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19331: 19335) / 88, 39,   0.35246180D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19336: 19340) / 88, 40,   0.30700206D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19341: 19345) / 88, 41,   0.27442675D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19346: 19350) / 88, 42,   0.20488350D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19351: 19355) / 88, 43,   0.23149349D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19356: 19360) / 88, 44,   0.16984672D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19361: 19365) / 88, 45,   0.18511077D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19366: 19370) / 88, 46,   0.16939362D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19371: 19375) / 88, 47,   0.14296950D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19376: 19380) / 88, 48,   0.14674624D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19381: 19385) / 88, 49,   0.19210215D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19386: 19390) / 88, 50,   0.16832537D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19391: 19395) / 88, 51,   0.14267831D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19396: 19400) / 88, 52,   0.12854608D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19401: 19405) / 88, 53,   0.11265319D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19406: 19410) / 88, 54,   0.98363370D+03,   0.00000D+00,   0.00000D+00/
  data pars( 19411: 19415) / 88, 55,   0.66646049D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19416: 19420) / 88, 56,   0.55052582D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19421: 19425) / 88, 57,   0.45943095D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19426: 19430) / 88, 58,   0.17037104D+04,   0.00000D+00,   0.27991D+01/
  data pars( 19431: 19435) / 88, 59,   0.47976061D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19436: 19440) / 88, 60,   0.45623865D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19441: 19445) / 88, 61,   0.44362592D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19446: 19450) / 88, 62,   0.43214914D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19451: 19455) / 88, 63,   0.42193690D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19456: 19460) / 88, 64,   0.31447184D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19461: 19465) / 88, 65,   0.38693475D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19466: 19470) / 88, 66,   0.37006978D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19471: 19475) / 88, 67,   0.37536534D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19476: 19480) / 88, 68,   0.36679746D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19481: 19485) / 88, 69,   0.35884351D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19486: 19490) / 88, 70,   0.35540067D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19491: 19495) / 88, 71,   0.28892983D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19496: 19500) / 88, 72,   0.26921229D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19501: 19505) / 88, 73,   0.23813318D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19506: 19510) / 88, 74,   0.19684730D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19511: 19515) / 88, 75,   0.19760672D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19516: 19520) / 88, 76,   0.17428522D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19521: 19525) / 88, 77,   0.15616887D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19526: 19530) / 88, 78,   0.12704258D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19531: 19535) / 88, 79,   0.11766222D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19536: 19540) / 88, 80,   0.11957573D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19541: 19545) / 88, 81,   0.19547292D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19546: 19550) / 88, 82,   0.18286515D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19551: 19555) / 88, 83,   0.16046349D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19556: 19560) / 88, 84,   0.14914089D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19561: 19565) / 88, 85,   0.13351632D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19566: 19570) / 88, 86,   0.11909286D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19571: 19575) / 88, 87,   0.60457168D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19576: 19580) / 88, 88,   0.53054399D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19581: 19585) / 89,  1,   0.89406000D+02,   0.00000D+00,   0.91180D+00/
  data pars( 19586: 19590) / 89,  2,   0.54461300D+02,   0.00000D+00,   0.00000D+00/
  data pars( 19591: 19595) / 89,  3,   0.20082591D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19596: 19600) / 89,  4,   0.97721480D+03,   0.00000D+00,   0.00000D+00/
  data pars( 19601: 19605) / 89,  5,   0.60005330D+03,   0.00000D+00,   0.00000D+00/
  data pars( 19606: 19610) / 89,  6,   0.37866720D+03,   0.00000D+00,   0.00000D+00/
  data pars( 19611: 19615) / 89,  7,   0.25180860D+03,   0.00000D+00,   0.00000D+00/
  data pars( 19616: 19620) / 89,  8,   0.18403180D+03,   0.00000D+00,   0.00000D+00/
  data pars( 19621: 19625) / 89,  9,   0.13527920D+03,   0.00000D+00,   0.00000D+00/
  data pars( 19626: 19630) / 89, 10,   0.10158570D+03,   0.00000D+00,   0.00000D+00/
  data pars( 19631: 19635) / 89, 11,   0.23774617D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19636: 19640) / 89, 12,   0.16040300D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19641: 19645) / 89, 13,   0.14098711D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19646: 19650) / 89, 14,   0.10405681D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19651: 19655) / 89, 15,   0.76851320D+03,   0.00000D+00,   0.00000D+00/
  data pars( 19656: 19660) / 89, 16,   0.61613190D+03,   0.00000D+00,   0.00000D+00/
  data pars( 19661: 19665) / 89, 17,   0.48688350D+03,   0.00000D+00,   0.00000D+00/
  data pars( 19666: 19670) / 89, 18,   0.38707200D+03,   0.00000D+00,   0.00000D+00/
  data pars( 19671: 19675) / 89, 19,   0.40174782D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19676: 19680) / 89, 20,   0.29771478D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19681: 19685) / 89, 21,   0.24021540D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19686: 19690) / 89, 22,   0.22732739D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19691: 19695) / 89, 23,   0.20559589D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19696: 19700) / 89, 24,   0.16183634D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19701: 19705) / 89, 25,   0.17384495D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19706: 19710) / 89, 26,   0.13600663D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19711: 19715) / 89, 27,   0.14017622D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19716: 19720) / 89, 28,   0.14625357D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19721: 19725) / 89, 29,   0.11217466D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19726: 19730) / 89, 30,   0.11049523D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19731: 19735) / 89, 31,   0.13263601D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19736: 19740) / 89, 32,   0.11110958D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19741: 19745) / 89, 33,   0.90553420D+03,   0.00000D+00,   0.00000D+00/
  data pars( 19746: 19750) / 89, 34,   0.79026450D+03,   0.00000D+00,   0.00000D+00/
  data pars( 19751: 19755) / 89, 35,   0.67216580D+03,   0.00000D+00,   0.00000D+00/
  data pars( 19756: 19760) / 89, 36,   0.56954790D+03,   0.00000D+00,   0.00000D+00/
  data pars( 19761: 19765) / 89, 37,   0.44690053D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19766: 19770) / 89, 38,   0.35643510D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19771: 19775) / 89, 39,   0.29977722D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19776: 19780) / 89, 40,   0.26270446D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19781: 19785) / 89, 41,   0.23567083D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19786: 19790) / 89, 42,   0.17692538D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19791: 19795) / 89, 43,   0.19948729D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19796: 19800) / 89, 44,   0.14730457D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19801: 19805) / 89, 45,   0.16081722D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19806: 19810) / 89, 46,   0.14753924D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19811: 19815) / 89, 47,   0.12402274D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19816: 19820) / 89, 48,   0.12822835D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19821: 19825) / 89, 49,   0.16650502D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19826: 19830) / 89, 50,   0.14751121D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19831: 19835) / 89, 51,   0.12620917D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19836: 19840) / 89, 52,   0.11429090D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19841: 19845) / 89, 53,   0.10069141D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19846: 19850) / 89, 54,   0.88341400D+03,   0.00000D+00,   0.00000D+00/
  data pars( 19851: 19855) / 89, 55,   0.54478929D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19856: 19860) / 89, 56,   0.46120247D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19861: 19865) / 89, 57,   0.38897052D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19866: 19870) / 89, 58,   0.15031569D+04,   0.00000D+00,   0.27991D+01/
  data pars( 19871: 19875) / 89, 59,   0.40323992D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19876: 19880) / 89, 60,   0.38433536D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19881: 19885) / 89, 61,   0.37393646D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19886: 19890) / 89, 62,   0.36445469D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19891: 19895) / 89, 63,   0.35602278D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19896: 19900) / 89, 64,   0.26796802D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19901: 19905) / 89, 65,   0.32333681D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19906: 19910) / 89, 66,   0.30968078D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19911: 19915) / 89, 67,   0.31769406D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19916: 19920) / 89, 68,   0.31056847D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19921: 19925) / 89, 69,   0.30398461D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19926: 19930) / 89, 70,   0.30095999D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19931: 19935) / 89, 71,   0.24623774D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19936: 19940) / 89, 72,   0.23202277D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19941: 19945) / 89, 73,   0.20645670D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19946: 19950) / 89, 74,   0.17115570D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19951: 19955) / 89, 75,   0.17232231D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19956: 19960) / 89, 76,   0.15276535D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19961: 19965) / 89, 77,   0.13743640D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19966: 19970) / 89, 78,   0.11213924D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19971: 19975) / 89, 79,   0.10400238D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19976: 19980) / 89, 80,   0.10600607D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19981: 19985) / 89, 81,   0.16946605D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19986: 19990) / 89, 82,   0.16008616D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19991: 19995) / 89, 83,   0.14174346D+04,   0.00000D+00,   0.00000D+00/
  data pars( 19996: 20000) / 89, 84,   0.13236360D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20001: 20005) / 89, 85,   0.11913272D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20006: 20010) / 89, 86,   0.10675065D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20011: 20015) / 89, 87,   0.49814961D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20016: 20020) / 89, 88,   0.44669584D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20021: 20025) / 89, 89,   0.37996565D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20026: 20030) / 90,  1,   0.82083600D+02,   0.00000D+00,   0.91180D+00/
  data pars( 20031: 20035) / 90,  2,   0.51110300D+02,   0.00000D+00,   0.00000D+00/
  data pars( 20036: 20040) / 90,  3,   0.16724768D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20041: 20045) / 90,  4,   0.85252490D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20046: 20050) / 90,  5,   0.53608580D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20051: 20055) / 90,  6,   0.34435760D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20056: 20060) / 90,  7,   0.23207230D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20061: 20065) / 90,  8,   0.17124180D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20066: 20070) / 90,  9,   0.12693930D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20071: 20075) / 90, 10,   0.95984500D+02,   0.00000D+00,   0.00000D+00/
  data pars( 20076: 20080) / 90, 11,   0.19852103D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20081: 20085) / 90, 12,   0.13883756D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20086: 20090) / 90, 13,   0.12352681D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20091: 20095) / 90, 14,   0.92751070D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20096: 20100) / 90, 15,   0.69479830D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20101: 20105) / 90, 16,   0.56206360D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20106: 20110) / 90, 17,   0.44804860D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20111: 20115) / 90, 18,   0.35892730D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20116: 20120) / 90, 19,   0.33208171D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20121: 20125) / 90, 20,   0.25377308D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20126: 20130) / 90, 21,   0.20608901D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20131: 20135) / 90, 22,   0.19602827D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20136: 20140) / 90, 23,   0.17786546D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20141: 20145) / 90, 24,   0.13994778D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20146: 20150) / 90, 25,   0.15110816D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20151: 20155) / 90, 26,   0.11825093D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20156: 20160) / 90, 27,   0.12287380D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20161: 20165) / 90, 28,   0.12777896D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20166: 20170) / 90, 29,   0.97919840D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20171: 20175) / 90, 30,   0.97588560D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20176: 20180) / 90, 31,   0.11670583D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20181: 20185) / 90, 32,   0.99120150D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20186: 20190) / 90, 33,   0.81755520D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20191: 20195) / 90, 34,   0.71866790D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20196: 20200) / 90, 35,   0.61585050D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20201: 20205) / 90, 36,   0.52542400D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20206: 20210) / 90, 37,   0.36996637D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20211: 20215) / 90, 38,   0.30331273D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20216: 20220) / 90, 39,   0.25787074D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20221: 20225) / 90, 40,   0.22748325D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20226: 20230) / 90, 41,   0.20492299D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20231: 20235) / 90, 42,   0.15491780D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20236: 20240) / 90, 43,   0.17421202D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20241: 20245) / 90, 44,   0.12966551D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20246: 20250) / 90, 45,   0.14168423D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20251: 20255) / 90, 46,   0.13036060D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20256: 20260) / 90, 47,   0.10925939D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20261: 20265) / 90, 48,   0.11371745D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20266: 20270) / 90, 49,   0.14631580D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20271: 20275) / 90, 50,   0.13115880D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20276: 20280) / 90, 51,   0.11344385D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20281: 20285) / 90, 52,   0.10338769D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20286: 20290) / 90, 53,   0.91709200D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20291: 20295) / 90, 54,   0.80980180D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20296: 20300) / 90, 55,   0.45055681D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20301: 20305) / 90, 56,   0.39071262D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20306: 20310) / 90, 57,   0.33315473D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20311: 20315) / 90, 58,   0.13478223D+04,   0.00000D+00,   0.27991D+01/
  data pars( 20316: 20320) / 90, 59,   0.34277894D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20321: 20325) / 90, 60,   0.32744792D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20326: 20330) / 90, 61,   0.31877428D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20331: 20335) / 90, 62,   0.31084769D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20336: 20340) / 90, 63,   0.30380345D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20341: 20345) / 90, 64,   0.23122086D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20346: 20350) / 90, 65,   0.27358113D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20351: 20355) / 90, 66,   0.26241922D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20356: 20360) / 90, 67,   0.27191319D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20361: 20365) / 90, 68,   0.26591268D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20366: 20370) / 90, 69,   0.26040009D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20371: 20375) / 90, 70,   0.25769767D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20376: 20380) / 90, 71,   0.21236819D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20381: 20385) / 90, 72,   0.20248239D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20386: 20390) / 90, 73,   0.18137564D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20391: 20395) / 90, 74,   0.15101361D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20396: 20400) / 90, 75,   0.15249297D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20401: 20405) / 90, 76,   0.13598576D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20406: 20410) / 90, 77,   0.12292164D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20411: 20415) / 90, 78,   0.10074225D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20416: 20420) / 90, 79,   0.93609580D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20421: 20425) / 90, 80,   0.95680470D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20426: 20430) / 90, 81,   0.14915698D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20431: 20435) / 90, 82,   0.14229431D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20436: 20440) / 90, 83,   0.12726601D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20441: 20445) / 90, 84,   0.11951492D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20446: 20450) / 90, 85,   0.10828719D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20451: 20455) / 90, 86,   0.97614170D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20456: 20460) / 90, 87,   0.41555932D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20461: 20465) / 90, 88,   0.38047750D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20466: 20470) / 90, 89,   0.32704258D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20471: 20475) / 90, 90,   0.28472704D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20476: 20480) / 91,  1,   0.80726000D+02,   0.00000D+00,   0.91180D+00/
  data pars( 20481: 20485) / 91,  2,   0.50005200D+02,   0.00000D+00,   0.00000D+00/
  data pars( 20486: 20490) / 91,  3,   0.17306038D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20491: 20495) / 91,  4,   0.85763790D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20496: 20500) / 91,  5,   0.53308180D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20501: 20505) / 91,  6,   0.33998630D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20506: 20510) / 91,  7,   0.22813330D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20511: 20515) / 91,  8,   0.16791870D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20516: 20520) / 91,  9,   0.12426420D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20521: 20525) / 91, 10,   0.93866300D+02,   0.00000D+00,   0.00000D+00/
  data pars( 20526: 20530) / 91, 11,   0.20511151D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20531: 20535) / 91, 12,   0.14030924D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20536: 20540) / 91, 13,   0.12403071D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20541: 20545) / 91, 14,   0.92324960D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20546: 20550) / 91, 15,   0.68729140D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20551: 20555) / 91, 16,   0.55412740D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20556: 20560) / 91, 17,   0.44044180D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20561: 20565) / 91, 18,   0.35207430D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20566: 20570) / 91, 19,   0.34570434D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20571: 20575) / 91, 20,   0.25892888D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20576: 20580) / 91, 21,   0.20945389D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20581: 20585) / 91, 22,   0.19869265D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20586: 20590) / 91, 23,   0.17996577D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20591: 20595) / 91, 24,   0.14173421D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20596: 20600) / 91, 25,   0.15251022D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20601: 20605) / 91, 26,   0.11941778D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20606: 20610) / 91, 27,   0.12344914D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20611: 20615) / 91, 28,   0.12859300D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20616: 20620) / 91, 29,   0.98684670D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20621: 20625) / 91, 30,   0.97668650D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20626: 20630) / 91, 31,   0.11699494D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20631: 20635) / 91, 32,   0.98664000D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20636: 20640) / 91, 33,   0.80937540D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20641: 20645) / 91, 34,   0.70943800D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20646: 20650) / 91, 35,   0.60630260D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20651: 20655) / 91, 36,   0.51614250D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20656: 20660) / 91, 37,   0.38488310D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20661: 20665) / 91, 38,   0.30987868D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20666: 20670) / 91, 39,   0.26179361D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20671: 20675) / 91, 40,   0.23009943D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20676: 20680) / 91, 41,   0.20684111D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20681: 20685) / 91, 42,   0.15587481D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20686: 20690) / 91, 43,   0.17549706D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20691: 20695) / 91, 44,   0.13015598D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20696: 20700) / 91, 45,   0.14207211D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20701: 20705) / 91, 46,   0.13053320D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20706: 20710) / 91, 47,   0.10968175D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20711: 20715) / 91, 48,   0.11367042D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20716: 20720) / 91, 49,   0.14690715D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20721: 20725) / 91, 50,   0.13085146D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20726: 20730) / 91, 51,   0.11258498D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20731: 20735) / 91, 52,   0.10231942D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20736: 20740) / 91, 53,   0.90511410D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20741: 20745) / 91, 54,   0.79733130D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20746: 20750) / 91, 55,   0.46916964D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20751: 20755) / 91, 56,   0.40037089D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20756: 20760) / 91, 57,   0.33915606D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20761: 20765) / 91, 58,   0.13396248D+04,   0.00000D+00,   0.27991D+01/
  data pars( 20766: 20770) / 91, 59,   0.35059336D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20771: 20775) / 91, 60,   0.33442162D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20776: 20780) / 91, 61,   0.32544268D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20781: 20785) / 91, 62,   0.31724783D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20786: 20790) / 91, 63,   0.30996207D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20791: 20795) / 91, 64,   0.23450320D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20796: 20800) / 91, 65,   0.28084101D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20801: 20805) / 91, 66,   0.26917985D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20806: 20810) / 91, 67,   0.27690943D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20811: 20815) / 91, 68,   0.27073188D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20816: 20820) / 91, 69,   0.26503867D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20821: 20825) / 91, 70,   0.26234579D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20826: 20830) / 91, 71,   0.21538516D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20831: 20835) / 91, 72,   0.20393959D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20836: 20840) / 91, 73,   0.18205331D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20841: 20845) / 91, 74,   0.15133881D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20846: 20850) / 91, 75,   0.15256409D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20851: 20855) / 91, 76,   0.13566458D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20856: 20860) / 91, 77,   0.12236676D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20861: 20865) / 91, 78,   0.10014754D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20866: 20870) / 91, 79,   0.92999430D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20871: 20875) / 91, 80,   0.94896980D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20876: 20880) / 91, 81,   0.14976018D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20881: 20885) / 91, 82,   0.14206996D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20886: 20890) / 91, 83,   0.12642423D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20891: 20895) / 91, 84,   0.11841627D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20896: 20900) / 91, 85,   0.10698651D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20901: 20905) / 91, 86,   0.96217680D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20906: 20910) / 91, 87,   0.43039645D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20911: 20915) / 91, 88,   0.38865716D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20916: 20920) / 91, 89,   0.33200764D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20921: 20925) / 91, 90,   0.28725136D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20926: 20930) / 91, 91,   0.29089206D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20931: 20935) / 92,  1,   0.78203400D+02,   0.00000D+00,   0.91180D+00/
  data pars( 20936: 20940) / 92,  2,   0.48498000D+02,   0.00000D+00,   0.00000D+00/
  data pars( 20941: 20945) / 92,  3,   0.16716156D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20946: 20950) / 92,  4,   0.82971320D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20951: 20955) / 92,  5,   0.51601950D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20956: 20960) / 92,  6,   0.32928020D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20961: 20965) / 92,  7,   0.22106590D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20966: 20970) / 92,  8,   0.16279260D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20971: 20975) / 92,  9,   0.12052900D+03,   0.00000D+00,   0.00000D+00/
  data pars( 20976: 20980) / 92, 10,   0.91086900D+02,   0.00000D+00,   0.00000D+00/
  data pars( 20981: 20985) / 92, 11,   0.19814675D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20986: 20990) / 92, 12,   0.13571628D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20991: 20995) / 92, 13,   0.12000275D+04,   0.00000D+00,   0.00000D+00/
  data pars( 20996: 21000) / 92, 14,   0.89364440D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21001: 21005) / 92, 15,   0.66549650D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21006: 21010) / 92, 16,   0.53670890D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21011: 21015) / 92, 17,   0.42673540D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21016: 21020) / 92, 18,   0.34123400D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21021: 21025) / 92, 19,   0.33376961D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21026: 21030) / 92, 20,   0.25033576D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21031: 21035) / 92, 21,   0.20254740D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21036: 21040) / 92, 22,   0.19216819D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21041: 21045) / 92, 23,   0.17407294D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21046: 21050) / 92, 24,   0.13709264D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21051: 21055) / 92, 25,   0.14753669D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21056: 21060) / 92, 26,   0.11552737D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21061: 21065) / 92, 27,   0.11945389D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21066: 21070) / 92, 28,   0.12442037D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21071: 21075) / 92, 29,   0.95483090D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21076: 21080) / 92, 30,   0.94527750D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21081: 21085) / 92, 31,   0.11321107D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21086: 21090) / 92, 32,   0.95506070D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21091: 21095) / 92, 33,   0.78370690D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21096: 21100) / 92, 34,   0.68708390D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21101: 21105) / 92, 35,   0.58734500D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21106: 21110) / 92, 36,   0.50013680D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21111: 21115) / 92, 37,   0.37160678D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21116: 21120) / 92, 38,   0.29957186D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21121: 21125) / 92, 39,   0.25317373D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21126: 21130) / 92, 40,   0.22256807D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21131: 21135) / 92, 41,   0.20009439D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21136: 21140) / 92, 42,   0.15082494D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21141: 21145) / 92, 43,   0.16979484D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21146: 21150) / 92, 44,   0.12596142D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21151: 21155) / 92, 45,   0.13749665D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21156: 21160) / 92, 46,   0.12634136D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21161: 21165) / 92, 47,   0.10615457D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21166: 21170) / 92, 48,   0.11003399D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21171: 21175) / 92, 49,   0.14216099D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21176: 21180) / 92, 50,   0.12666329D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21181: 21185) / 92, 51,   0.10901053D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21186: 21190) / 92, 52,   0.99086960D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21191: 21195) / 92, 53,   0.87669020D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21196: 21200) / 92, 54,   0.77245190D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21201: 21205) / 92, 55,   0.45291727D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21206: 21210) / 92, 56,   0.38697611D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21211: 21215) / 92, 57,   0.32793360D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21216: 21220) / 92, 58,   0.12970461D+04,   0.00000D+00,   0.27991D+01/
  data pars( 21221: 21225) / 92, 59,   0.33890395D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21226: 21230) / 92, 60,   0.32330975D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21231: 21235) / 92, 61,   0.31463690D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21236: 21240) / 92, 62,   0.30672053D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21241: 21245) / 92, 63,   0.29968237D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21246: 21250) / 92, 64,   0.22680138D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21251: 21255) / 92, 65,   0.27140296D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21256: 21260) / 92, 66,   0.26013226D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21261: 21265) / 92, 67,   0.26775672D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21266: 21270) / 92, 68,   0.26178718D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21271: 21275) / 92, 69,   0.25628645D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21276: 21280) / 92, 70,   0.25367915D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21281: 21285) / 92, 71,   0.20830385D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21286: 21290) / 92, 72,   0.19730821D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21291: 21295) / 92, 73,   0.17616844D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21296: 21300) / 92, 74,   0.14646529D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21301: 21305) / 92, 75,   0.14766337D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21306: 21310) / 92, 76,   0.13133066D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21311: 21315) / 92, 77,   0.11847530D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21316: 21320) / 92, 78,   0.96980220D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21321: 21325) / 92, 79,   0.90065620D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21326: 21330) / 92, 80,   0.91908240D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21331: 21335) / 92, 81,   0.14493061D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21336: 21340) / 92, 82,   0.13752752D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21341: 21345) / 92, 83,   0.12241322D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21346: 21350) / 92, 84,   0.11467509D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21351: 21355) / 92, 85,   0.10362496D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21356: 21360) / 92, 86,   0.93211210D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21361: 21365) / 92, 87,   0.41565121D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21366: 21370) / 92, 88,   0.37572430D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21371: 21375) / 92, 89,   0.32107560D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21376: 21380) / 92, 90,   0.27789432D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21381: 21385) / 92, 91,   0.28136269D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21386: 21390) / 92, 92,   0.27215209D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21391: 21395) / 93,  1,   0.79439100D+02,   0.00000D+00,   0.91180D+00/
  data pars( 21396: 21400) / 93,  2,   0.48724100D+02,   0.00000D+00,   0.00000D+00/
  data pars( 21401: 21405) / 93,  3,   0.18005066D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21406: 21410) / 93,  4,   0.86956410D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21411: 21415) / 93,  5,   0.53289880D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21416: 21420) / 93,  6,   0.33646270D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21421: 21425) / 93,  7,   0.22420940D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21426: 21430) / 93,  8,   0.16429590D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21431: 21435) / 93,  9,   0.12116670D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21436: 21440) / 93, 10,   0.91309000D+02,   0.00000D+00,   0.00000D+00/
  data pars( 21441: 21445) / 93, 11,   0.21313007D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21446: 21450) / 93, 12,   0.14294308D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21451: 21455) / 93, 13,   0.12543604D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21456: 21460) / 93, 14,   0.92419700D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21461: 21465) / 93, 15,   0.68227500D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21466: 21470) / 93, 16,   0.54731890D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21471: 21475) / 93, 17,   0.43301050D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21476: 21480) / 93, 18,   0.34483050D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21481: 21485) / 93, 19,   0.36085602D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21486: 21490) / 93, 20,   0.26611178D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21491: 21495) / 93, 21,   0.21449232D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21496: 21500) / 93, 22,   0.20287846D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21501: 21505) / 93, 23,   0.18341800D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21506: 21510) / 93, 24,   0.14450682D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21511: 21515) / 93, 25,   0.15501899D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21516: 21520) / 93, 26,   0.12138708D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21521: 21525) / 93, 27,   0.12487909D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21526: 21530) / 93, 28,   0.13033334D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21531: 21535) / 93, 29,   0.10009549D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21536: 21540) / 93, 30,   0.98372150D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21541: 21545) / 93, 31,   0.11804499D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21546: 21550) / 93, 32,   0.98737510D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21551: 21555) / 93, 33,   0.80425620D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21556: 21560) / 93, 34,   0.70203110D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21561: 21565) / 93, 35,   0.59750350D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21566: 21570) / 93, 36,   0.50682160D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21571: 21575) / 93, 37,   0.40138973D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21576: 21580) / 93, 38,   0.31875734D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21581: 21585) / 93, 39,   0.26766472D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21586: 21590) / 93, 40,   0.23437586D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21591: 21595) / 93, 41,   0.21018417D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21596: 21600) / 93, 42,   0.15778736D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21601: 21605) / 93, 43,   0.17790323D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21606: 21610) / 93, 44,   0.13137158D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21611: 21615) / 93, 45,   0.14331563D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21616: 21620) / 93, 46,   0.13146561D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21621: 21625) / 93, 47,   0.11068617D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21626: 21630) / 93, 48,   0.11425196D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21631: 21635) / 93, 49,   0.14840150D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21636: 21640) / 93, 50,   0.13126653D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21641: 21645) / 93, 51,   0.11221440D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21646: 21650) / 93, 52,   0.10160025D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21651: 21655) / 93, 53,   0.89523210D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21656: 21660) / 93, 54,   0.78580380D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21661: 21665) / 93, 55,   0.48930436D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21666: 21670) / 93, 56,   0.41279330D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21671: 21675) / 93, 57,   0.34757124D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21676: 21680) / 93, 58,   0.13372850D+04,   0.00000D+00,   0.27991D+01/
  data pars( 21681: 21685) / 93, 59,   0.36078825D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21686: 21690) / 93, 60,   0.34378544D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21691: 21695) / 93, 61,   0.33445279D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21696: 21700) / 93, 62,   0.32594431D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21701: 21705) / 93, 63,   0.31837627D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21706: 21710) / 93, 64,   0.23935584D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21711: 21715) / 93, 65,   0.28964080D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21716: 21720) / 93, 66,   0.27730351D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21721: 21725) / 93, 67,   0.28396469D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21726: 21730) / 93, 68,   0.27757424D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21731: 21735) / 93, 69,   0.27166522D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21736: 21740) / 93, 70,   0.26897033D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21741: 21745) / 93, 71,   0.21986632D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21746: 21750) / 93, 72,   0.20680029D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21751: 21755) / 93, 73,   0.18390464D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21756: 21760) / 93, 74,   0.15251115D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21761: 21765) / 93, 75,   0.15347972D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21766: 21770) / 93, 76,   0.13602378D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21771: 21775) / 93, 77,   0.12236448D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21776: 21780) / 93, 78,   0.99920960D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21781: 21785) / 93, 79,   0.92702850D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21786: 21790) / 93, 80,   0.94428620D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21791: 21795) / 93, 81,   0.15116714D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21796: 21800) / 93, 82,   0.14258266D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21801: 21805) / 93, 83,   0.12612415D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21806: 21810) / 93, 84,   0.11774038D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21811: 21815) / 93, 85,   0.10596377D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21816: 21820) / 93, 86,   0.94975540D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21821: 21825) / 93, 87,   0.44697774D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21826: 21830) / 93, 88,   0.39952606D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21831: 21835) / 93, 89,   0.33932601D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21836: 21840) / 93, 90,   0.29170992D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21841: 21845) / 93, 91,   0.29646668D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21846: 21850) / 93, 92,   0.28671025D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21851: 21855) / 93, 93,   0.30329760D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21856: 21860) / 94,  1,   0.77102100D+02,   0.00000D+00,   0.91180D+00/
  data pars( 21861: 21865) / 94,  2,   0.47379800D+02,   0.00000D+00,   0.00000D+00/
  data pars( 21866: 21870) / 94,  3,   0.17278140D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21871: 21875) / 94,  4,   0.83944780D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21876: 21880) / 94,  5,   0.51579770D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21881: 21885) / 94,  6,   0.32625000D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21886: 21890) / 94,  7,   0.21767650D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21891: 21895) / 94,  8,   0.15964350D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21896: 21900) / 94,  9,   0.11781930D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21901: 21905) / 94, 10,   0.88836500D+02,   0.00000D+00,   0.00000D+00/
  data pars( 21906: 21910) / 94, 11,   0.20459284D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21911: 21915) / 94, 12,   0.13785876D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21916: 21920) / 94, 13,   0.12114443D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21921: 21925) / 94, 14,   0.89432550D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21926: 21930) / 94, 15,   0.66120920D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21931: 21935) / 94, 16,   0.53088280D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21936: 21940) / 94, 17,   0.42034980D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21941: 21945) / 94, 18,   0.33497590D+03,   0.00000D+00,   0.00000D+00/
  data pars( 21946: 21950) / 94, 19,   0.34586883D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21951: 21955) / 94, 20,   0.25612750D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21956: 21960) / 94, 21,   0.20661768D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21961: 21965) / 94, 22,   0.19554505D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21966: 21970) / 94, 23,   0.17685649D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21971: 21975) / 94, 24,   0.13931385D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21976: 21980) / 94, 25,   0.14955657D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21981: 21985) / 94, 26,   0.11710013D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21986: 21990) / 94, 27,   0.12060158D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21991: 21995) / 94, 28,   0.12582170D+04,   0.00000D+00,   0.00000D+00/
  data pars( 21996: 22000) / 94, 29,   0.96605990D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22001: 22005) / 94, 30,   0.95086030D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22006: 22010) / 94, 31,   0.11405197D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22011: 22015) / 94, 32,   0.95550390D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22016: 22020) / 94, 33,   0.77929760D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22021: 22025) / 94, 34,   0.68073550D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22026: 22030) / 94, 35,   0.57979560D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22031: 22035) / 94, 36,   0.49211280D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22036: 22040) / 94, 37,   0.38477324D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22041: 22045) / 94, 38,   0.30671463D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22046: 22050) / 94, 39,   0.25790022D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22051: 22055) / 94, 40,   0.22600639D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22056: 22060) / 94, 41,   0.20277440D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22061: 22065) / 94, 42,   0.15233742D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22066: 22070) / 94, 43,   0.17171041D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22071: 22075) / 94, 44,   0.12690647D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22076: 22080) / 94, 45,   0.13847315D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22081: 22085) / 94, 46,   0.12706578D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22086: 22090) / 94, 47,   0.10692791D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22091: 22095) / 94, 48,   0.11047467D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22096: 22100) / 94, 49,   0.14334370D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22101: 22105) / 94, 50,   0.12697368D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22106: 22110) / 94, 51,   0.10867671D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22111: 22115) / 94, 52,   0.98462910D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22116: 22120) / 94, 53,   0.86818680D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22121: 22125) / 94, 54,   0.76254070D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22126: 22130) / 94, 55,   0.46894909D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22131: 22135) / 94, 56,   0.39694488D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22136: 22140) / 94, 57,   0.33469278D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22141: 22145) / 94, 58,   0.12946997D+04,   0.00000D+00,   0.27991D+01/
  data pars( 22146: 22150) / 94, 59,   0.34708103D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22151: 22155) / 94, 60,   0.33082782D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22156: 22160) / 94, 61,   0.32187253D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22161: 22165) / 94, 62,   0.31370576D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22166: 22170) / 94, 63,   0.30644224D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22171: 22175) / 94, 64,   0.23068366D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22176: 22180) / 94, 65,   0.27842586D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22181: 22185) / 94, 66,   0.26660816D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22186: 22190) / 94, 67,   0.27342974D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22191: 22195) / 94, 68,   0.26729042D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22196: 22200) / 94, 69,   0.26161724D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22201: 22205) / 94, 70,   0.25900957D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22206: 22210) / 94, 71,   0.21189811D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22211: 22215) / 94, 72,   0.19960266D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22216: 22220) / 94, 73,   0.17764187D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22221: 22225) / 94, 74,   0.14737544D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22226: 22230) / 94, 75,   0.14836747D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22231: 22235) / 94, 76,   0.13158080D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22236: 22240) / 94, 77,   0.11842955D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22241: 22245) / 94, 78,   0.96746430D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22246: 22250) / 94, 79,   0.89773860D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22251: 22255) / 94, 80,   0.91479120D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22256: 22260) / 94, 81,   0.14602247D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22261: 22265) / 94, 82,   0.13790263D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22266: 22270) / 94, 83,   0.12212647D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22271: 22275) / 94, 84,   0.11407827D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22276: 22280) / 94, 85,   0.10273948D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22281: 22285) / 94, 86,   0.92140470D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22286: 22290) / 94, 87,   0.42885858D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22291: 22295) / 94, 88,   0.38444325D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22296: 22300) / 94, 89,   0.32695288D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22301: 22305) / 94, 90,   0.28146033D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22306: 22310) / 94, 91,   0.28581875D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22311: 22315) / 94, 92,   0.27642585D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22316: 22320) / 94, 93,   0.29218223D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22321: 22325) / 94, 94,   0.28152366D+04,   0.00000D+00,   0.00000D+00/
  data pars( 22326: 22330) /101,  1,   0.47379000D+01,   0.00000D+00,   0.91180D+00/
  data pars( 22331: 22335) /101,  2,   0.31287000D+01,   0.00000D+00,   0.00000D+00/
  data pars( 22336: 22340) /101,  3,   0.68939100D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22341: 22345) /101,  4,   0.41307800D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22346: 22350) /101,  5,   0.28276700D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22351: 22355) /101,  6,   0.19265300D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22356: 22360) /101,  7,   0.13516400D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22361: 22365) /101,  8,   0.10237100D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22366: 22370) /101,  9,   0.77441000D+01,   0.00000D+00,   0.00000D+00/
  data pars( 22371: 22375) /101, 10,   0.59403000D+01,   0.00000D+00,   0.00000D+00/
  data pars( 22376: 22380) /101, 11,   0.82564100D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22381: 22385) /101, 12,   0.65370300D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22386: 22390) /101, 13,   0.60855800D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22391: 22395) /101, 14,   0.48518200D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22396: 22400) /101, 15,   0.38139700D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22401: 22405) /101, 16,   0.31771300D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22406: 22410) /101, 17,   0.26017000D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22411: 22415) /101, 18,   0.21305500D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22416: 22420) /101, 19,   0.13444410D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22421: 22425) /101, 20,   0.11348570D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22426: 22430) /101, 21,   0.94208300D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22431: 22435) /101, 22,   0.91333400D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22436: 22440) /101, 23,   0.83831300D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22441: 22445) /101, 24,   0.65983700D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22446: 22450) /101, 25,   0.72411100D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22451: 22455) /101, 26,   0.56799300D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22456: 22460) /101, 27,   0.60574600D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22461: 22465) /101, 28,   0.62253200D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22466: 22470) /101, 29,   0.47649900D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22471: 22475) /101, 30,   0.49346900D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22476: 22480) /101, 31,   0.58420700D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22481: 22485) /101, 32,   0.51990500D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22486: 22490) /101, 33,   0.44651200D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22491: 22495) /101, 34,   0.40201000D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22496: 22500) /101, 35,   0.35274000D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22501: 22505) /101, 36,   0.30726100D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22506: 22510) /101, 37,   0.15093400D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22511: 22515) /101, 38,   0.13506640D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22516: 22520) /101, 39,   0.11929610D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22521: 22525) /101, 40,   0.10773060D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22526: 22530) /101, 41,   0.98518300D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22531: 22535) /101, 42,   0.76366100D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22536: 22540) /101, 43,   0.85080000D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22541: 22545) /101, 44,   0.65086300D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22546: 22550) /101, 45,   0.71198500D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22551: 22555) /101, 46,   0.66121100D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22556: 22560) /101, 47,   0.54965800D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22561: 22565) /101, 48,   0.58356800D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22566: 22570) /101, 49,   0.72907600D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22571: 22575) /101, 50,   0.67943000D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22576: 22580) /101, 51,   0.60947000D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22581: 22585) /101, 52,   0.56742700D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22586: 22590) /101, 53,   0.51465600D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22591: 22595) /101, 54,   0.46379400D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22596: 22600) /101, 55,   0.18402230D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22601: 22605) /101, 56,   0.17170330D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22606: 22610) /101, 57,   0.15211060D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22611: 22615) /101, 58,   0.71883000D+02,   0.00000D+00,   0.27991D+01/
  data pars( 22616: 22620) /101, 59,   0.15245020D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22621: 22625) /101, 60,   0.14658510D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22626: 22630) /101, 61,   0.14296200D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22631: 22635) /101, 62,   0.13962540D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22636: 22640) /101, 63,   0.13666950D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22641: 22645) /101, 64,   0.10836620D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22646: 22650) /101, 65,   0.12040560D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22651: 22655) /101, 66,   0.11631780D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22656: 22660) /101, 67,   0.12352200D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22661: 22665) /101, 68,   0.12093020D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22666: 22670) /101, 69,   0.11860700D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22671: 22675) /101, 70,   0.11718110D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22676: 22680) /101, 71,   0.99298400D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22681: 22685) /101, 72,   0.98513600D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22686: 22690) /101, 73,   0.90285800D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22691: 22695) /101, 74,   0.76415000D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22696: 22700) /101, 75,   0.77879300D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22701: 22705) /101, 76,   0.70802400D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22706: 22710) /101, 77,   0.64989000D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22711: 22715) /101, 78,   0.54045100D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22716: 22720) /101, 79,   0.50508600D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22721: 22725) /101, 80,   0.52054700D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22726: 22730) /101, 81,   0.74881700D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22731: 22735) /101, 82,   0.73669200D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22736: 22740) /101, 83,   0.68103100D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22741: 22745) /101, 84,   0.65160500D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22746: 22750) /101, 85,   0.60333800D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22751: 22755) /101, 86,   0.55434500D+02,   0.00000D+00,   0.00000D+00/
  data pars( 22756: 22760) /101, 87,   0.17492120D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22761: 22765) /101, 88,   0.17050820D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22766: 22770) /101, 89,   0.15181390D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22771: 22775) /101, 90,   0.13747240D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22776: 22780) /101, 91,   0.13587010D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22781: 22785) /101, 92,   0.13156440D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22786: 22790) /101, 93,   0.13473040D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22791: 22795) /101, 94,   0.13059460D+03,   0.00000D+00,   0.00000D+00/
  data pars( 22796: 22800) /101,101,   0.75916000D+01,   0.00000D+00,   0.00000D+00/
  data pars( 22801: 22805) /103,  1,   0.14316500D+02,   0.98650D+00,   0.91180D+00/
  data pars( 22806: 22810) /103,  2,   0.87773000D+01,   0.98650D+00,   0.00000D+00/
  data pars( 22811: 22815) /103,  3,   0.28221060D+03,   0.98650D+00,   0.00000D+00/
  data pars( 22816: 22820) /103,  4,   0.14813230D+03,   0.98650D+00,   0.00000D+00/
  data pars( 22821: 22825) /103,  5,   0.93672900D+02,   0.98650D+00,   0.00000D+00/
  data pars( 22826: 22830) /103,  6,   0.60086000D+02,   0.98650D+00,   0.00000D+00/
  data pars( 22831: 22835) /103,  7,   0.40294400D+02,   0.98650D+00,   0.00000D+00/
  data pars( 22836: 22840) /103,  8,   0.29557500D+02,   0.98650D+00,   0.00000D+00/
  data pars( 22841: 22845) /103,  9,   0.21760500D+02,   0.98650D+00,   0.00000D+00/
  data pars( 22846: 22850) /103, 10,   0.16338800D+02,   0.98650D+00,   0.00000D+00/
  data pars( 22851: 22855) /103, 11,   0.33534500D+03,   0.98650D+00,   0.00000D+00/
  data pars( 22856: 22860) /103, 12,   0.24016270D+03,   0.98650D+00,   0.00000D+00/
  data pars( 22861: 22865) /103, 13,   0.21472650D+03,   0.98650D+00,   0.00000D+00/
  data pars( 22866: 22870) /103, 14,   0.16205080D+03,   0.98650D+00,   0.00000D+00/
  data pars( 22871: 22875) /103, 15,   0.12150670D+03,   0.98650D+00,   0.00000D+00/
  data pars( 22876: 22880) /103, 16,   0.98124900D+02,   0.98650D+00,   0.00000D+00/
  data pars( 22881: 22885) /103, 17,   0.77986500D+02,   0.98650D+00,   0.00000D+00/
  data pars( 22886: 22890) /103, 18,   0.62220500D+02,   0.98650D+00,   0.00000D+00/
  data pars( 22891: 22895) /103, 19,   0.55515160D+03,   0.98650D+00,   0.00000D+00/
  data pars( 22896: 22900) /103, 20,   0.43415760D+03,   0.98650D+00,   0.00000D+00/
  data pars( 22901: 22905) /103, 21,   0.35403170D+03,   0.98650D+00,   0.00000D+00/
  data pars( 22906: 22910) /103, 22,   0.33738960D+03,   0.98650D+00,   0.00000D+00/
  data pars( 22911: 22915) /103, 23,   0.30654820D+03,   0.98650D+00,   0.00000D+00/
  data pars( 22916: 22920) /103, 24,   0.24050330D+03,   0.98650D+00,   0.00000D+00/
  data pars( 22921: 22925) /103, 25,   0.26090190D+03,   0.98650D+00,   0.00000D+00/
  data pars( 22926: 22930) /103, 26,   0.20361490D+03,   0.98650D+00,   0.00000D+00/
  data pars( 22931: 22935) /103, 27,   0.21289780D+03,   0.98650D+00,   0.00000D+00/
  data pars( 22936: 22940) /103, 28,   0.22117390D+03,   0.98650D+00,   0.00000D+00/
  data pars( 22941: 22945) /103, 29,   0.16880750D+03,   0.98650D+00,   0.00000D+00/
  data pars( 22946: 22950) /103, 30,   0.16949490D+03,   0.98650D+00,   0.00000D+00/
  data pars( 22951: 22955) /103, 31,   0.20269000D+03,   0.98650D+00,   0.00000D+00/
  data pars( 22956: 22960) /103, 32,   0.17294250D+03,   0.98650D+00,   0.00000D+00/
  data pars( 22961: 22965) /103, 33,   0.14284710D+03,   0.98650D+00,   0.00000D+00/
  data pars( 22966: 22970) /103, 34,   0.12547680D+03,   0.98650D+00,   0.00000D+00/
  data pars( 22971: 22975) /103, 35,   0.10733800D+03,   0.98650D+00,   0.00000D+00/
  data pars( 22976: 22980) /103, 36,   0.91333300D+02,   0.98650D+00,   0.00000D+00/
  data pars( 22981: 22985) /103, 37,   0.61856810D+03,   0.98650D+00,   0.00000D+00/
  data pars( 22986: 22990) /103, 38,   0.51783930D+03,   0.98650D+00,   0.00000D+00/
  data pars( 22991: 22995) /103, 39,   0.44294480D+03,   0.98650D+00,   0.00000D+00/
  data pars( 22996: 23000) /103, 40,   0.39191790D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23001: 23005) /103, 41,   0.35350080D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23006: 23010) /103, 42,   0.26737610D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23011: 23015) /103, 43,   0.30065330D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23016: 23020) /103, 44,   0.22388710D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23021: 23025) /103, 45,   0.24525610D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23026: 23030) /103, 46,   0.22580420D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23031: 23035) /103, 47,   0.18833740D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23036: 23040) /103, 48,   0.19709400D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23041: 23045) /103, 49,   0.25313700D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23046: 23050) /103, 50,   0.22808140D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23051: 23055) /103, 51,   0.19776980D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23056: 23060) /103, 52,   0.18030560D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23061: 23065) /103, 53,   0.15986700D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23066: 23070) /103, 54,   0.14098180D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23071: 23075) /103, 55,   0.75234180D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23076: 23080) /103, 56,   0.66457190D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23081: 23085) /103, 57,   0.57042660D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23086: 23090) /103, 58,   0.23452710D+03,   0.98650D+00,   0.27991D+01/
  data pars( 23091: 23095) /103, 59,   0.58397970D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23096: 23100) /103, 60,   0.55869720D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23101: 23105) /103, 61,   0.54412320D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23106: 23110) /103, 62,   0.53079090D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23111: 23115) /103, 63,   0.51894980D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23116: 23120) /103, 64,   0.39672230D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23121: 23125) /103, 65,   0.46354420D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23126: 23130) /103, 66,   0.44501010D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23131: 23135) /103, 67,   0.46541000D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23136: 23140) /103, 68,   0.45528270D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23141: 23145) /103, 69,   0.44600300D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23146: 23150) /103, 70,   0.44132200D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23151: 23155) /103, 71,   0.36474670D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23156: 23160) /103, 72,   0.35006170D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23161: 23165) /103, 73,   0.31424830D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23166: 23170) /103, 74,   0.26138330D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23171: 23175) /103, 75,   0.26436970D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23176: 23180) /103, 76,   0.23602580D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23181: 23185) /103, 77,   0.21346440D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23186: 23190) /103, 78,   0.17461320D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23191: 23195) /103, 79,   0.16213420D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23196: 23200) /103, 80,   0.16604890D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23201: 23205) /103, 81,   0.25738230D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23206: 23210) /103, 82,   0.24683550D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23211: 23215) /103, 83,   0.22143250D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23216: 23220) /103, 84,   0.20812690D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23221: 23225) /103, 85,   0.18860730D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23226: 23230) /103, 86,   0.16989430D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23231: 23235) /103, 87,   0.69764490D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23236: 23240) /103, 88,   0.64903250D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23241: 23245) /103, 89,   0.56135190D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23246: 23250) /103, 90,   0.49107770D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23251: 23255) /103, 91,   0.49346510D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23256: 23260) /103, 92,   0.47742540D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23261: 23265) /103, 93,   0.49952020D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23266: 23270) /103, 94,   0.48234660D+03,   0.98650D+00,   0.00000D+00/
  data pars( 23271: 23275) /103,101,   0.24057300D+02,   0.98650D+00,   0.00000D+00/
  data pars( 23276: 23280) /103,103,   0.85319700D+02,   0.98650D+00,   0.98650D+00/
  data pars( 23281: 23285) /104,  1,   0.18465600D+02,   0.98080D+00,   0.91180D+00/
  data pars( 23286: 23290) /104,  2,   0.11465500D+02,   0.98080D+00,   0.00000D+00/
  data pars( 23291: 23295) /104,  3,   0.35221600D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23296: 23300) /104,  4,   0.18634530D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23301: 23305) /104,  5,   0.11908150D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23306: 23310) /104,  6,   0.77095100D+02,   0.98080D+00,   0.00000D+00/
  data pars( 23311: 23315) /104,  7,   0.52085200D+02,   0.98080D+00,   0.00000D+00/
  data pars( 23316: 23320) /104,  8,   0.38413200D+02,   0.98080D+00,   0.00000D+00/
  data pars( 23321: 23325) /104,  9,   0.28409800D+02,   0.98080D+00,   0.00000D+00/
  data pars( 23326: 23330) /104, 10,   0.21406700D+02,   0.98080D+00,   0.00000D+00/
  data pars( 23331: 23335) /104, 11,   0.41864880D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23336: 23340) /104, 12,   0.30137770D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23341: 23345) /104, 13,   0.27074610D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23346: 23350) /104, 14,   0.20575440D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23351: 23355) /104, 15,   0.15536440D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23356: 23360) /104, 16,   0.12609930D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23361: 23365) /104, 17,   0.10072120D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23366: 23370) /104, 18,   0.80717400D+02,   0.98080D+00,   0.00000D+00/
  data pars( 23371: 23375) /104, 19,   0.69485960D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23376: 23380) /104, 20,   0.54358420D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23381: 23385) /104, 21,   0.44371900D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23386: 23390) /104, 22,   0.42362170D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23391: 23395) /104, 23,   0.38527540D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23396: 23400) /104, 24,   0.30260610D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23401: 23405) /104, 25,   0.32840120D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23406: 23410) /104, 26,   0.25660430D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23411: 23415) /104, 27,   0.26862840D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23416: 23420) /104, 28,   0.27871160D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23421: 23425) /104, 29,   0.21297970D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23426: 23430) /104, 30,   0.21442560D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23431: 23435) /104, 31,   0.25620490D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23436: 23440) /104, 32,   0.21973750D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23441: 23445) /104, 33,   0.18253380D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23446: 23450) /104, 34,   0.16096870D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23451: 23455) /104, 35,   0.13827470D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23456: 23460) /104, 36,   0.11812400D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23461: 23465) /104, 37,   0.77496560D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23466: 23470) /104, 38,   0.64864220D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23471: 23475) /104, 39,   0.55615030D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23476: 23480) /104, 40,   0.49301000D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23481: 23485) /104, 41,   0.44537360D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23486: 23490) /104, 42,   0.33790350D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23491: 23495) /104, 43,   0.37952540D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23496: 23500) /104, 44,   0.28356950D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23501: 23505) /104, 45,   0.31037810D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23506: 23510) /104, 46,   0.28603950D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23511: 23515) /104, 47,   0.23869620D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23516: 23520) /104, 48,   0.24999150D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23521: 23525) /104, 49,   0.32009120D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23526: 23530) /104, 50,   0.28947130D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23531: 23535) /104, 51,   0.25216490D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23536: 23540) /104, 52,   0.23063090D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23541: 23545) /104, 53,   0.20522370D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23546: 23550) /104, 54,   0.18162600D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23551: 23555) /104, 55,   0.94385470D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23556: 23560) /104, 56,   0.83262510D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23561: 23565) /104, 57,   0.71607580D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23566: 23570) /104, 58,   0.29887820D+03,   0.98080D+00,   0.27991D+01/
  data pars( 23571: 23575) /104, 59,   0.73216420D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23576: 23580) /104, 60,   0.70044420D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23581: 23585) /104, 61,   0.68219010D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23586: 23590) /104, 62,   0.66548680D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23591: 23595) /104, 63,   0.65065570D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23596: 23600) /104, 64,   0.49918370D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23601: 23605) /104, 65,   0.58212240D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23606: 23610) /104, 66,   0.55929170D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23611: 23615) /104, 67,   0.58370670D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23616: 23620) /104, 68,   0.57100390D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23621: 23625) /104, 69,   0.55938980D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23626: 23630) /104, 70,   0.55342660D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23631: 23635) /104, 71,   0.45865820D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23636: 23640) /104, 72,   0.44137890D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23641: 23645) /104, 73,   0.39713120D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23646: 23650) /104, 74,   0.33121240D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23651: 23655) /104, 75,   0.33522610D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23656: 23660) /104, 76,   0.29995650D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23661: 23665) /104, 77,   0.27181190D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23666: 23670) /104, 78,   0.22291570D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23671: 23675) /104, 79,   0.20718310D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23676: 23680) /104, 80,   0.21231320D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23681: 23685) /104, 81,   0.32610680D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23686: 23690) /104, 82,   0.31346750D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23691: 23695) /104, 83,   0.28229350D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23696: 23700) /104, 84,   0.26602000D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23701: 23705) /104, 85,   0.24186880D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23706: 23710) /104, 86,   0.21856870D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23711: 23715) /104, 87,   0.87585630D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23716: 23720) /104, 88,   0.81413080D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23721: 23725) /104, 89,   0.70540110D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23726: 23730) /104, 90,   0.61906050D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23731: 23735) /104, 91,   0.62133990D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23736: 23740) /104, 92,   0.60114960D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23741: 23745) /104, 93,   0.62763850D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23746: 23750) /104, 94,   0.60621390D+03,   0.98080D+00,   0.00000D+00/
  data pars( 23751: 23755) /104,101,   0.30786600D+02,   0.98080D+00,   0.00000D+00/
  data pars( 23756: 23760) /104,103,   0.10750830D+03,   0.98080D+00,   0.98650D+00/
  data pars( 23761: 23765) /104,104,   0.13584450D+03,   0.98080D+00,   0.98080D+00/
  data pars( 23766: 23770) /105,  1,   0.14723700D+02,   0.97060D+00,   0.91180D+00/
  data pars( 23771: 23775) /105,  2,   0.95836000D+01,   0.97060D+00,   0.00000D+00/
  data pars( 23776: 23780) /105,  3,   0.23142090D+03,   0.97060D+00,   0.00000D+00/
  data pars( 23781: 23785) /105,  4,   0.13372650D+03,   0.97060D+00,   0.00000D+00/
  data pars( 23786: 23790) /105,  5,   0.89742900D+02,   0.97060D+00,   0.00000D+00/
  data pars( 23791: 23795) /105,  6,   0.60299600D+02,   0.97060D+00,   0.00000D+00/
  data pars( 23796: 23800) /105,  7,   0.41901500D+02,   0.97060D+00,   0.00000D+00/
  data pars( 23801: 23805) /105,  8,   0.31535400D+02,   0.97060D+00,   0.00000D+00/
  data pars( 23806: 23810) /105,  9,   0.23736900D+02,   0.97060D+00,   0.00000D+00/
  data pars( 23811: 23815) /105, 10,   0.18142400D+02,   0.97060D+00,   0.00000D+00/
  data pars( 23816: 23820) /105, 11,   0.27656710D+03,   0.97060D+00,   0.00000D+00/
  data pars( 23821: 23825) /105, 12,   0.21299790D+03,   0.97060D+00,   0.00000D+00/
  data pars( 23826: 23830) /105, 13,   0.19620140D+03,   0.97060D+00,   0.00000D+00/
  data pars( 23831: 23835) /105, 14,   0.15429010D+03,   0.97060D+00,   0.00000D+00/
  data pars( 23836: 23840) /105, 15,   0.11993530D+03,   0.97060D+00,   0.00000D+00/
  data pars( 23841: 23845) /105, 16,   0.99215900D+02,   0.97060D+00,   0.00000D+00/
  data pars( 23846: 23850) /105, 17,   0.80727200D+02,   0.97060D+00,   0.00000D+00/
  data pars( 23851: 23855) /105, 18,   0.65758000D+02,   0.97060D+00,   0.00000D+00/
  data pars( 23856: 23860) /105, 19,   0.45251930D+03,   0.97060D+00,   0.00000D+00/
  data pars( 23861: 23865) /105, 20,   0.37388150D+03,   0.97060D+00,   0.00000D+00/
  data pars( 23866: 23870) /105, 21,   0.30887210D+03,   0.97060D+00,   0.00000D+00/
  data pars( 23871: 23875) /105, 22,   0.29808710D+03,   0.97060D+00,   0.00000D+00/
  data pars( 23876: 23880) /105, 23,   0.27287470D+03,   0.97060D+00,   0.00000D+00/
  data pars( 23881: 23885) /105, 24,   0.21463600D+03,   0.97060D+00,   0.00000D+00/
  data pars( 23886: 23890) /105, 25,   0.23480000D+03,   0.97060D+00,   0.00000D+00/
  data pars( 23891: 23895) /105, 26,   0.18397370D+03,   0.97060D+00,   0.00000D+00/
  data pars( 23896: 23900) /105, 27,   0.19517310D+03,   0.97060D+00,   0.00000D+00/
  data pars( 23901: 23905) /105, 28,   0.20113510D+03,   0.97060D+00,   0.00000D+00/
  data pars( 23906: 23910) /105, 29,   0.15388240D+03,   0.97060D+00,   0.00000D+00/
  data pars( 23911: 23915) /105, 30,   0.15808480D+03,   0.97060D+00,   0.00000D+00/
  data pars( 23916: 23920) /105, 31,   0.18757970D+03,   0.97060D+00,   0.00000D+00/
  data pars( 23921: 23925) /105, 32,   0.16519300D+03,   0.97060D+00,   0.00000D+00/
  data pars( 23926: 23930) /105, 33,   0.14056250D+03,   0.97060D+00,   0.00000D+00/
  data pars( 23931: 23935) /105, 34,   0.12584370D+03,   0.97060D+00,   0.00000D+00/
  data pars( 23936: 23940) /105, 35,   0.10980600D+03,   0.97060D+00,   0.00000D+00/
  data pars( 23941: 23945) /105, 36,   0.95176300D+02,   0.97060D+00,   0.00000D+00/
  data pars( 23946: 23950) /105, 37,   0.50694210D+03,   0.97060D+00,   0.00000D+00/
  data pars( 23951: 23955) /105, 38,   0.44526080D+03,   0.97060D+00,   0.00000D+00/
  data pars( 23956: 23960) /105, 39,   0.38988230D+03,   0.97060D+00,   0.00000D+00/
  data pars( 23961: 23965) /105, 40,   0.35019700D+03,   0.97060D+00,   0.00000D+00/
  data pars( 23966: 23970) /105, 41,   0.31911510D+03,   0.97060D+00,   0.00000D+00/
  data pars( 23971: 23975) /105, 42,   0.24585270D+03,   0.97060D+00,   0.00000D+00/
  data pars( 23976: 23980) /105, 43,   0.27453340D+03,   0.97060D+00,   0.00000D+00/
  data pars( 23981: 23985) /105, 44,   0.20863620D+03,   0.97060D+00,   0.00000D+00/
  data pars( 23986: 23990) /105, 45,   0.22828220D+03,   0.97060D+00,   0.00000D+00/
  data pars( 23991: 23995) /105, 46,   0.21155590D+03,   0.97060D+00,   0.00000D+00/
  data pars( 23996: 24000) /105, 47,   0.17606030D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24001: 24005) /105, 48,   0.18621990D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24006: 24010) /105, 49,   0.23421710D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24011: 24015) /105, 50,   0.21642760D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24016: 24020) /105, 51,   0.19255420D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24021: 24025) /105, 52,   0.17839190D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24026: 24030) /105, 53,   0.16096790D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24031: 24035) /105, 54,   0.14436970D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24036: 24040) /105, 55,   0.61760580D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24041: 24045) /105, 56,   0.56751360D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24046: 24050) /105, 57,   0.49845340D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24051: 24055) /105, 58,   0.22741890D+03,   0.97060D+00,   0.27991D+01/
  data pars( 24056: 24060) /105, 59,   0.50249670D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24061: 24065) /105, 60,   0.48250770D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24066: 24070) /105, 61,   0.47040290D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24071: 24075) /105, 62,   0.45927530D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24076: 24080) /105, 63,   0.44941020D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24081: 24085) /105, 64,   0.35290870D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24086: 24090) /105, 65,   0.39744990D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24091: 24095) /105, 66,   0.38329520D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24096: 24100) /105, 67,   0.40532850D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24101: 24105) /105, 68,   0.39673770D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24106: 24110) /105, 69,   0.38898900D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24111: 24115) /105, 70,   0.38447010D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24116: 24120) /105, 71,   0.32364500D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24121: 24125) /105, 72,   0.31828720D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24126: 24130) /105, 73,   0.29018010D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24131: 24135) /105, 74,   0.24456750D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24136: 24140) /105, 75,   0.24877750D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24141: 24145) /105, 76,   0.22518190D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24146: 24150) /105, 77,   0.20597020D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24151: 24155) /105, 78,   0.17065560D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24156: 24160) /105, 79,   0.15926350D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24161: 24165) /105, 80,   0.16388200D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24166: 24170) /105, 81,   0.24000000D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24171: 24175) /105, 82,   0.23460480D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24176: 24180) /105, 83,   0.21530270D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24181: 24185) /105, 84,   0.20513340D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24186: 24190) /105, 85,   0.18899910D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24191: 24195) /105, 86,   0.17288540D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24196: 24200) /105, 87,   0.58298150D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24201: 24205) /105, 88,   0.56100860D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24206: 24210) /105, 89,   0.49563890D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24211: 24215) /105, 90,   0.44481020D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24216: 24220) /105, 91,   0.44155780D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24221: 24225) /105, 92,   0.42748070D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24226: 24230) /105, 93,   0.44027100D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24231: 24235) /105, 94,   0.42632550D+03,   0.97060D+00,   0.00000D+00/
  data pars( 24236: 24240) /105,101,   0.23841200D+02,   0.97060D+00,   0.00000D+00/
  data pars( 24241: 24245) /105,103,   0.77663300D+02,   0.97060D+00,   0.98650D+00/
  data pars( 24246: 24250) /105,104,   0.98993800D+02,   0.97060D+00,   0.98080D+00/
  data pars( 24251: 24255) /105,105,   0.75368600D+02,   0.97060D+00,   0.97060D+00/
  data pars( 24256: 24260) /106,  1,   0.11393200D+02,   0.98680D+00,   0.91180D+00/
  data pars( 24261: 24265) /106,  2,   0.77065000D+01,   0.98680D+00,   0.00000D+00/
  data pars( 24266: 24270) /106,  3,   0.16045900D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24271: 24275) /106,  4,   0.96543100D+02,   0.98680D+00,   0.00000D+00/
  data pars( 24276: 24280) /106,  5,   0.66798600D+02,   0.98680D+00,   0.00000D+00/
  data pars( 24281: 24285) /106,  6,   0.46068100D+02,   0.98680D+00,   0.00000D+00/
  data pars( 24286: 24290) /106,  7,   0.32700900D+02,   0.98680D+00,   0.00000D+00/
  data pars( 24291: 24295) /106,  8,   0.25009700D+02,   0.98680D+00,   0.00000D+00/
  data pars( 24296: 24300) /106,  9,   0.19097400D+02,   0.98680D+00,   0.00000D+00/
  data pars( 24301: 24305) /106, 10,   0.14771600D+02,   0.98680D+00,   0.00000D+00/
  data pars( 24306: 24310) /106, 11,   0.19237290D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24311: 24315) /106, 12,   0.15261300D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24316: 24320) /106, 13,   0.14260940D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24321: 24325) /106, 14,   0.11444050D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24326: 24330) /106, 15,   0.90676700D+02,   0.98680D+00,   0.00000D+00/
  data pars( 24331: 24335) /106, 16,   0.76055200D+02,   0.98680D+00,   0.00000D+00/
  data pars( 24336: 24340) /106, 17,   0.62746500D+02,   0.98680D+00,   0.00000D+00/
  data pars( 24341: 24345) /106, 18,   0.51768400D+02,   0.98680D+00,   0.00000D+00/
  data pars( 24346: 24350) /106, 19,   0.31458000D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24351: 24355) /106, 20,   0.26512060D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24356: 24360) /106, 21,   0.22018540D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24361: 24365) /106, 22,   0.21386820D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24366: 24370) /106, 23,   0.19648850D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24371: 24375) /106, 24,   0.15511710D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24376: 24380) /106, 25,   0.16997960D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24381: 24385) /106, 26,   0.13377000D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24386: 24390) /106, 27,   0.14251400D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24391: 24395) /106, 28,   0.14627110D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24396: 24400) /106, 29,   0.11239140D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24401: 24405) /106, 30,   0.11639870D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24406: 24410) /106, 31,   0.13747230D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24411: 24415) /106, 32,   0.12288050D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24416: 24420) /106, 33,   0.10616860D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24421: 24425) /106, 34,   0.96059900D+02,   0.98680D+00,   0.00000D+00/
  data pars( 24426: 24430) /106, 35,   0.84772300D+02,   0.98680D+00,   0.00000D+00/
  data pars( 24431: 24435) /106, 36,   0.74286500D+02,   0.98680D+00,   0.00000D+00/
  data pars( 24436: 24440) /106, 37,   0.35363020D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24441: 24445) /106, 38,   0.31589230D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24446: 24450) /106, 39,   0.27947270D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24451: 24455) /106, 40,   0.25282130D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24456: 24460) /106, 41,   0.23159760D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24461: 24465) /106, 42,   0.18033900D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24466: 24470) /106, 43,   0.20054640D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24471: 24475) /106, 44,   0.15419380D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24476: 24480) /106, 45,   0.16831150D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24481: 24485) /106, 46,   0.15650060D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24486: 24490) /106, 47,   0.13051440D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24491: 24495) /106, 48,   0.13836720D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24496: 24500) /106, 49,   0.17212290D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24501: 24505) /106, 50,   0.16079100D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24506: 24510) /106, 51,   0.14484620D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24511: 24515) /106, 52,   0.13531220D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24516: 24520) /106, 53,   0.12325380D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24521: 24525) /106, 54,   0.11159230D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24526: 24530) /106, 55,   0.43151720D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24531: 24535) /106, 56,   0.40187740D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24536: 24540) /106, 57,   0.35646100D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24541: 24545) /106, 58,   0.17092620D+03,   0.98680D+00,   0.27991D+01/
  data pars( 24546: 24550) /106, 59,   0.35713990D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24551: 24555) /106, 60,   0.34341530D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24556: 24560) /106, 61,   0.33492450D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24561: 24565) /106, 62,   0.32709910D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24566: 24570) /106, 63,   0.32016570D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24571: 24575) /106, 64,   0.25481220D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24576: 24580) /106, 65,   0.28285470D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24581: 24585) /106, 66,   0.27333750D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24586: 24590) /106, 67,   0.28939200D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24591: 24595) /106, 68,   0.28330010D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24596: 24600) /106, 69,   0.27784930D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24601: 24605) /106, 70,   0.27445000D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24606: 24610) /106, 71,   0.23313940D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24611: 24615) /106, 72,   0.23163340D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24616: 24620) /106, 73,   0.21280410D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24621: 24625) /106, 74,   0.18084620D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24626: 24630) /106, 75,   0.18435860D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24631: 24635) /106, 76,   0.16804770D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24636: 24640) /106, 77,   0.15462480D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24641: 24645) /106, 78,   0.12918350D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24646: 24650) /106, 79,   0.12094850D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24651: 24655) /106, 80,   0.12459510D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24656: 24660) /106, 81,   0.17748530D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24661: 24665) /106, 82,   0.17476750D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24666: 24670) /106, 83,   0.16207400D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24671: 24675) /106, 84,   0.15545060D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24676: 24680) /106, 85,   0.14445320D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24681: 24685) /106, 86,   0.13324320D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24686: 24690) /106, 87,   0.41058600D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24691: 24695) /106, 88,   0.39952250D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24696: 24700) /106, 89,   0.35611270D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24701: 24705) /106, 90,   0.32349590D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24706: 24710) /106, 91,   0.31967610D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24711: 24715) /106, 92,   0.30960820D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24716: 24720) /106, 93,   0.31659670D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24721: 24725) /106, 94,   0.30693030D+03,   0.98680D+00,   0.00000D+00/
  data pars( 24726: 24730) /106,101,   0.18057500D+02,   0.98680D+00,   0.00000D+00/
  data pars( 24731: 24735) /106,103,   0.56346800D+02,   0.98680D+00,   0.98650D+00/
  data pars( 24736: 24740) /106,104,   0.72316200D+02,   0.98680D+00,   0.98080D+00/
  data pars( 24741: 24745) /106,105,   0.56529500D+02,   0.98680D+00,   0.97060D+00/
  data pars( 24746: 24750) /106,106,   0.43245200D+02,   0.98680D+00,   0.98680D+00/
  data pars( 24751: 24755) /107,  1,   0.81417000D+01,   0.99440D+00,   0.91180D+00/
  data pars( 24756: 24760) /107,  2,   0.57601000D+01,   0.99440D+00,   0.00000D+00/
  data pars( 24761: 24765) /107,  3,   0.10127010D+03,   0.99440D+00,   0.00000D+00/
  data pars( 24766: 24770) /107,  4,   0.63858000D+02,   0.99440D+00,   0.00000D+00/
  data pars( 24771: 24775) /107,  5,   0.45731900D+02,   0.99440D+00,   0.00000D+00/
  data pars( 24776: 24780) /107,  6,   0.32484800D+02,   0.99440D+00,   0.00000D+00/
  data pars( 24781: 24785) /107,  7,   0.23629500D+02,   0.99440D+00,   0.00000D+00/
  data pars( 24786: 24790) /107,  8,   0.18412800D+02,   0.99440D+00,   0.00000D+00/
  data pars( 24791: 24795) /107,  9,   0.14301500D+02,   0.99440D+00,   0.00000D+00/
  data pars( 24796: 24800) /107, 10,   0.11224300D+02,   0.99440D+00,   0.00000D+00/
  data pars( 24801: 24805) /107, 11,   0.12196010D+03,   0.99440D+00,   0.00000D+00/
  data pars( 24806: 24810) /107, 12,   0.10014430D+03,   0.99440D+00,   0.00000D+00/
  data pars( 24811: 24815) /107, 13,   0.95091600D+02,   0.99440D+00,   0.00000D+00/
  data pars( 24816: 24820) /107, 14,   0.78046600D+02,   0.99440D+00,   0.00000D+00/
  data pars( 24821: 24825) /107, 15,   0.63166900D+02,   0.99440D+00,   0.00000D+00/
  data pars( 24826: 24830) /107, 16,   0.53810700D+02,   0.99440D+00,   0.00000D+00/
  data pars( 24831: 24835) /107, 17,   0.45095200D+02,   0.99440D+00,   0.00000D+00/
  data pars( 24836: 24840) /107, 18,   0.37752200D+02,   0.99440D+00,   0.00000D+00/
  data pars( 24841: 24845) /107, 19,   0.19944050D+03,   0.99440D+00,   0.00000D+00/
  data pars( 24846: 24850) /107, 20,   0.17204550D+03,   0.99440D+00,   0.00000D+00/
  data pars( 24851: 24855) /107, 21,   0.14376580D+03,   0.99440D+00,   0.00000D+00/
  data pars( 24856: 24860) /107, 22,   0.14071150D+03,   0.99440D+00,   0.00000D+00/
  data pars( 24861: 24865) /107, 23,   0.12982970D+03,   0.99440D+00,   0.00000D+00/
  data pars( 24866: 24870) /107, 24,   0.10301890D+03,   0.99440D+00,   0.00000D+00/
  data pars( 24871: 24875) /107, 25,   0.11302480D+03,   0.99440D+00,   0.00000D+00/
  data pars( 24876: 24880) /107, 26,   0.89486800D+02,   0.99440D+00,   0.00000D+00/
  data pars( 24881: 24885) /107, 27,   0.95705100D+02,   0.99440D+00,   0.00000D+00/
  data pars( 24886: 24890) /107, 28,   0.97776100D+02,   0.99440D+00,   0.00000D+00/
  data pars( 24891: 24895) /107, 29,   0.75598700D+02,   0.99440D+00,   0.00000D+00/
  data pars( 24896: 24900) /107, 30,   0.78918300D+02,   0.99440D+00,   0.00000D+00/
  data pars( 24901: 24905) /107, 31,   0.92602500D+02,   0.99440D+00,   0.00000D+00/
  data pars( 24906: 24910) /107, 32,   0.84127600D+02,   0.99440D+00,   0.00000D+00/
  data pars( 24911: 24915) /107, 33,   0.73914200D+02,   0.99440D+00,   0.00000D+00/
  data pars( 24916: 24920) /107, 34,   0.67663600D+02,   0.99440D+00,   0.00000D+00/
  data pars( 24921: 24925) /107, 35,   0.60472800D+02,   0.99440D+00,   0.00000D+00/
  data pars( 24926: 24930) /107, 36,   0.53649600D+02,   0.99440D+00,   0.00000D+00/
  data pars( 24931: 24935) /107, 37,   0.22519190D+03,   0.99440D+00,   0.00000D+00/
  data pars( 24936: 24940) /107, 38,   0.20515740D+03,   0.99440D+00,   0.00000D+00/
  data pars( 24941: 24945) /107, 39,   0.18368510D+03,   0.99440D+00,   0.00000D+00/
  data pars( 24946: 24950) /107, 40,   0.16755010D+03,   0.99440D+00,   0.00000D+00/
  data pars( 24951: 24955) /107, 41,   0.15443560D+03,   0.99440D+00,   0.00000D+00/
  data pars( 24956: 24960) /107, 42,   0.12180660D+03,   0.99440D+00,   0.00000D+00/
  data pars( 24961: 24965) /107, 43,   0.13478870D+03,   0.99440D+00,   0.00000D+00/
  data pars( 24966: 24970) /107, 44,   0.10509050D+03,   0.99440D+00,   0.00000D+00/
  data pars( 24971: 24975) /107, 45,   0.11434960D+03,   0.99440D+00,   0.00000D+00/
  data pars( 24976: 24980) /107, 46,   0.10674380D+03,   0.99440D+00,   0.00000D+00/
  data pars( 24981: 24985) /107, 47,   0.89341900D+02,   0.99440D+00,   0.00000D+00/
  data pars( 24986: 24990) /107, 48,   0.94877000D+02,   0.99440D+00,   0.00000D+00/
  data pars( 24991: 24995) /107, 49,   0.11649590D+03,   0.99440D+00,   0.00000D+00/
  data pars( 24996: 25000) /107, 50,   0.11009510D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25001: 25005) /107, 51,   0.10051820D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25006: 25010) /107, 52,   0.94750800D+02,   0.99440D+00,   0.00000D+00/
  data pars( 25011: 25015) /107, 53,   0.87202800D+02,   0.99440D+00,   0.00000D+00/
  data pars( 25016: 25020) /107, 54,   0.79777300D+02,   0.99440D+00,   0.00000D+00/
  data pars( 25021: 25025) /107, 55,   0.27525670D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25026: 25030) /107, 56,   0.26044810D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25031: 25035) /107, 57,   0.23366190D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25036: 25040) /107, 58,   0.11854700D+03,   0.99440D+00,   0.27991D+01/
  data pars( 25041: 25045) /107, 59,   0.23257830D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25046: 25050) /107, 60,   0.22400400D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25051: 25055) /107, 61,   0.21856110D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25056: 25060) /107, 62,   0.21352770D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25061: 25065) /107, 63,   0.20907000D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25066: 25070) /107, 64,   0.16905560D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25071: 25075) /107, 65,   0.18459040D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25076: 25080) /107, 66,   0.17880740D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25081: 25085) /107, 67,   0.18945310D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25086: 25090) /107, 68,   0.18549310D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25091: 25095) /107, 69,   0.18198230D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25096: 25100) /107, 70,   0.17962020D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25101: 25105) /107, 71,   0.15422920D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25106: 25110) /107, 72,   0.15491020D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25111: 25115) /107, 73,   0.14357630D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25116: 25120) /107, 74,   0.12323020D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25121: 25125) /107, 75,   0.12591210D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25126: 25130) /107, 76,   0.11569380D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25131: 25135) /107, 77,   0.10717750D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25136: 25140) /107, 78,   0.90445600D+02,   0.99440D+00,   0.00000D+00/
  data pars( 25141: 25145) /107, 79,   0.85014600D+02,   0.99440D+00,   0.00000D+00/
  data pars( 25146: 25150) /107, 80,   0.87649000D+02,   0.99440D+00,   0.00000D+00/
  data pars( 25151: 25155) /107, 81,   0.12108000D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25156: 25160) /107, 82,   0.12012680D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25161: 25165) /107, 83,   0.11264850D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25166: 25170) /107, 84,   0.10881340D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25171: 25175) /107, 85,   0.10205240D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25176: 25180) /107, 86,   0.94992800D+02,   0.99440D+00,   0.00000D+00/
  data pars( 25181: 25185) /107, 87,   0.26444300D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25186: 25190) /107, 88,   0.26065290D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25191: 25195) /107, 89,   0.23476520D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25196: 25200) /107, 90,   0.21630740D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25201: 25205) /107, 91,   0.21274560D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25206: 25210) /107, 92,   0.20616310D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25211: 25215) /107, 93,   0.20915240D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25216: 25220) /107, 94,   0.20304180D+03,   0.99440D+00,   0.00000D+00/
  data pars( 25221: 25225) /107,101,   0.12598000D+02,   0.99440D+00,   0.00000D+00/
  data pars( 25226: 25230) /107,103,   0.37493900D+02,   0.99440D+00,   0.98650D+00/
  data pars( 25231: 25235) /107,104,   0.48488500D+02,   0.99440D+00,   0.98080D+00/
  data pars( 25236: 25240) /107,105,   0.39043300D+02,   0.99440D+00,   0.97060D+00/
  data pars( 25241: 25245) /107,106,   0.30541000D+02,   0.99440D+00,   0.98680D+00/
  data pars( 25246: 25250) /107,107,   0.22124100D+02,   0.99440D+00,   0.99440D+00/
  data pars( 25251: 25255) /108,  1,   0.60575000D+01,   0.99250D+00,   0.91180D+00/
  data pars( 25256: 25260) /108,  2,   0.44593000D+01,   0.99250D+00,   0.00000D+00/
  data pars( 25261: 25265) /108,  3,   0.67931200D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25266: 25270) /108,  4,   0.44496800D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25271: 25275) /108,  5,   0.32813600D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25276: 25280) /108,  6,   0.23912000D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25281: 25285) /108,  7,   0.17769800D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25286: 25290) /108,  8,   0.14076400D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25291: 25295) /108,  9,   0.11099400D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25296: 25300) /108, 10,   0.88252000D+01,   0.99250D+00,   0.00000D+00/
  data pars( 25301: 25305) /108, 11,   0.82182000D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25306: 25310) /108, 12,   0.69367500D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25311: 25315) /108, 13,   0.66745100D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25316: 25320) /108, 14,   0.55817500D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25321: 25325) /108, 15,   0.45993700D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25326: 25330) /108, 16,   0.39709100D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25331: 25335) /108, 17,   0.33731300D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25336: 25340) /108, 18,   0.28600000D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25341: 25345) /108, 19,   0.13465080D+03,   0.99250D+00,   0.00000D+00/
  data pars( 25346: 25350) /108, 20,   0.11824110D+03,   0.99250D+00,   0.00000D+00/
  data pars( 25351: 25355) /108, 21,   0.99293900D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25356: 25360) /108, 22,   0.97834500D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25361: 25365) /108, 23,   0.90600700D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25366: 25370) /108, 24,   0.72287200D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25371: 25375) /108, 25,   0.79304700D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25376: 25380) /108, 26,   0.63186500D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25381: 25385) /108, 27,   0.67711700D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25386: 25390) /108, 28,   0.68908600D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25391: 25395) /108, 29,   0.53642000D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25396: 25400) /108, 30,   0.56288400D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25401: 25405) /108, 31,   0.65621400D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25406: 25410) /108, 32,   0.60404100D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25411: 25415) /108, 33,   0.53815300D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25416: 25420) /108, 34,   0.49755200D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25421: 25425) /108, 35,   0.44951000D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25426: 25430) /108, 36,   0.40304300D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25431: 25435) /108, 37,   0.15267570D+03,   0.99250D+00,   0.00000D+00/
  data pars( 25436: 25440) /108, 38,   0.14115920D+03,   0.99250D+00,   0.00000D+00/
  data pars( 25441: 25445) /108, 39,   0.12762820D+03,   0.99250D+00,   0.00000D+00/
  data pars( 25446: 25450) /108, 40,   0.11723280D+03,   0.99250D+00,   0.00000D+00/
  data pars( 25451: 25455) /108, 41,   0.10863780D+03,   0.99250D+00,   0.00000D+00/
  data pars( 25456: 25460) /108, 42,   0.86680300D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25461: 25465) /108, 43,   0.95496600D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25466: 25470) /108, 44,   0.75391000D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25471: 25475) /108, 45,   0.81764000D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25476: 25480) /108, 46,   0.76587100D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25481: 25485) /108, 47,   0.64388000D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25486: 25490) /108, 48,   0.68394300D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25491: 25495) /108, 49,   0.83027800D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25496: 25500) /108, 50,   0.79170400D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25501: 25505) /108, 51,   0.73071800D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25506: 25510) /108, 52,   0.69390100D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25511: 25515) /108, 53,   0.64414100D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25516: 25520) /108, 54,   0.59446800D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25521: 25525) /108, 55,   0.18687910D+03,   0.99250D+00,   0.00000D+00/
  data pars( 25526: 25530) /108, 56,   0.17895490D+03,   0.99250D+00,   0.00000D+00/
  data pars( 25531: 25535) /108, 57,   0.16203710D+03,   0.99250D+00,   0.00000D+00/
  data pars( 25536: 25540) /108, 58,   0.86166500D+02,   0.99250D+00,   0.27991D+01/
  data pars( 25541: 25545) /108, 59,   0.16052330D+03,   0.99250D+00,   0.00000D+00/
  data pars( 25546: 25550) /108, 60,   0.15480670D+03,   0.99250D+00,   0.00000D+00/
  data pars( 25551: 25555) /108, 61,   0.15109700D+03,   0.99250D+00,   0.00000D+00/
  data pars( 25556: 25560) /108, 62,   0.14765520D+03,   0.99250D+00,   0.00000D+00/
  data pars( 25561: 25565) /108, 63,   0.14460750D+03,   0.99250D+00,   0.00000D+00/
  data pars( 25566: 25570) /108, 64,   0.11853880D+03,   0.99250D+00,   0.00000D+00/
  data pars( 25571: 25575) /108, 65,   0.12778280D+03,   0.99250D+00,   0.00000D+00/
  data pars( 25576: 25580) /108, 66,   0.12401580D+03,   0.99250D+00,   0.00000D+00/
  data pars( 25581: 25585) /108, 67,   0.13130040D+03,   0.99250D+00,   0.00000D+00/
  data pars( 25586: 25590) /108, 68,   0.12856660D+03,   0.99250D+00,   0.00000D+00/
  data pars( 25591: 25595) /108, 69,   0.12616140D+03,   0.99250D+00,   0.00000D+00/
  data pars( 25596: 25600) /108, 70,   0.12444020D+03,   0.99250D+00,   0.00000D+00/
  data pars( 25601: 25605) /108, 71,   0.10783510D+03,   0.99250D+00,   0.00000D+00/
  data pars( 25606: 25610) /108, 72,   0.10920420D+03,   0.99250D+00,   0.00000D+00/
  data pars( 25611: 25615) /108, 73,   0.10197340D+03,   0.99250D+00,   0.00000D+00/
  data pars( 25616: 25620) /108, 74,   0.88315600D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25621: 25625) /108, 75,   0.90391800D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25626: 25630) /108, 76,   0.83622700D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25631: 25635) /108, 77,   0.77919400D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25636: 25640) /108, 78,   0.66359100D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25641: 25645) /108, 79,   0.62600800D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25646: 25650) /108, 80,   0.64555200D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25651: 25655) /108, 81,   0.86955200D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25656: 25660) /108, 82,   0.86739200D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25661: 25665) /108, 83,   0.82055900D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25666: 25670) /108, 84,   0.79713300D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25671: 25675) /108, 85,   0.75326800D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25676: 25680) /108, 86,   0.70648000D+02,   0.99250D+00,   0.00000D+00/
  data pars( 25681: 25685) /108, 87,   0.18100550D+03,   0.99250D+00,   0.00000D+00/
  data pars( 25686: 25690) /108, 88,   0.18009880D+03,   0.99250D+00,   0.00000D+00/
  data pars( 25691: 25695) /108, 89,   0.16360420D+03,   0.99250D+00,   0.00000D+00/
  data pars( 25696: 25700) /108, 90,   0.15256500D+03,   0.99250D+00,   0.00000D+00/
  data pars( 25701: 25705) /108, 91,   0.14955510D+03,   0.99250D+00,   0.00000D+00/
  data pars( 25706: 25710) /108, 92,   0.14501130D+03,   0.99250D+00,   0.00000D+00/
  data pars( 25711: 25715) /108, 93,   0.14619280D+03,   0.99250D+00,   0.00000D+00/
  data pars( 25716: 25720) /108, 94,   0.14207750D+03,   0.99250D+00,   0.00000D+00/
  data pars( 25721: 25725) /108,101,   0.91812000D+01,   0.99250D+00,   0.00000D+00/
  data pars( 25726: 25730) /108,103,   0.26270800D+02,   0.99250D+00,   0.98650D+00/
  data pars( 25731: 25735) /108,104,   0.34198300D+02,   0.99250D+00,   0.98080D+00/
  data pars( 25736: 25740) /108,105,   0.28232700D+02,   0.99250D+00,   0.97060D+00/
  data pars( 25741: 25745) /108,106,   0.22517800D+02,   0.99250D+00,   0.98680D+00/
  data pars( 25746: 25750) /108,107,   0.16677500D+02,   0.99250D+00,   0.99440D+00/
  data pars( 25751: 25755) /108,108,   0.12816100D+02,   0.99250D+00,   0.99250D+00/
  data pars( 25756: 25760) /109,  1,   0.42672000D+01,   0.99820D+00,   0.91180D+00/
  data pars( 25761: 25765) /109,  2,   0.33077000D+01,   0.99820D+00,   0.00000D+00/
  data pars( 25766: 25770) /109,  3,   0.42062700D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25771: 25775) /109,  4,   0.28861500D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25776: 25780) /109,  5,   0.22093100D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25781: 25785) /109,  6,   0.16637300D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25786: 25790) /109,  7,   0.12710700D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25791: 25795) /109,  8,   0.10286700D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25796: 25800) /109,  9,   0.82739000D+01,   0.99820D+00,   0.00000D+00/
  data pars( 25801: 25805) /109, 10,   0.66950000D+01,   0.99820D+00,   0.00000D+00/
  data pars( 25806: 25810) /109, 11,   0.51249800D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25811: 25815) /109, 12,   0.44714100D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25816: 25820) /109, 13,   0.43736400D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25821: 25825) /109, 14,   0.37442100D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25826: 25830) /109, 15,   0.31557700D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25831: 25835) /109, 16,   0.27713700D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25836: 25840) /109, 17,   0.23950500D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25841: 25845) /109, 18,   0.20639400D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25846: 25850) /109, 19,   0.84368800D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25851: 25855) /109, 20,   0.75585000D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25856: 25860) /109, 21,   0.63856400D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25861: 25865) /109, 22,   0.63474800D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25866: 25870) /109, 23,   0.59066500D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25871: 25875) /109, 24,   0.47531800D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25876: 25880) /109, 25,   0.52078000D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25881: 25885) /109, 26,   0.41894200D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25886: 25890) /109, 27,   0.44940700D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25891: 25895) /109, 28,   0.45515500D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25896: 25900) /109, 29,   0.35810000D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25901: 25905) /109, 30,   0.37755900D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25906: 25910) /109, 31,   0.43568500D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25911: 25915) /109, 32,   0.40750000D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25916: 25920) /109, 33,   0.36938900D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25921: 25925) /109, 34,   0.34579200D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25926: 25930) /109, 35,   0.31669900D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25931: 25935) /109, 36,   0.28780000D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25936: 25940) /109, 37,   0.96223500D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25941: 25945) /109, 38,   0.90408100D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25946: 25950) /109, 39,   0.82733700D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25951: 25955) /109, 40,   0.76671200D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25956: 25960) /109, 41,   0.71549300D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25961: 25965) /109, 42,   0.57978400D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25966: 25970) /109, 43,   0.63507900D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25971: 25975) /109, 44,   0.50977000D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25976: 25980) /109, 45,   0.55024000D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25981: 25985) /109, 46,   0.51774000D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25986: 25990) /109, 47,   0.43848000D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25991: 25995) /109, 48,   0.46534000D+02,   0.99820D+00,   0.00000D+00/
  data pars( 25996: 26000) /109, 49,   0.55658900D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26001: 26005) /109, 50,   0.53624300D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26006: 26010) /109, 51,   0.50147300D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26011: 26015) /109, 52,   0.48053500D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26016: 26020) /109, 53,   0.45084800D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26021: 26025) /109, 54,   0.42063400D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26026: 26030) /109, 55,   0.11797180D+03,   0.99820D+00,   0.00000D+00/
  data pars( 26031: 26035) /109, 56,   0.11446760D+03,   0.99820D+00,   0.00000D+00/
  data pars( 26036: 26040) /109, 57,   0.10480950D+03,   0.99820D+00,   0.00000D+00/
  data pars( 26041: 26045) /109, 58,   0.59137900D+02,   0.99820D+00,   0.27991D+01/
  data pars( 26046: 26050) /109, 59,   0.10336160D+03,   0.99820D+00,   0.00000D+00/
  data pars( 26051: 26055) /109, 60,   0.99833100D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26056: 26060) /109, 61,   0.97478900D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26061: 26065) /109, 62,   0.95284600D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26066: 26070) /109, 63,   0.93341000D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26071: 26075) /109, 64,   0.77874200D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26076: 26080) /109, 65,   0.82715400D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26081: 26085) /109, 66,   0.80460700D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26086: 26090) /109, 67,   0.84947800D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26091: 26095) /109, 68,   0.83182700D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26096: 26100) /109, 69,   0.81643700D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26101: 26105) /109, 70,   0.80457500D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26106: 26110) /109, 71,   0.70552200D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26111: 26115) /109, 72,   0.72088700D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26116: 26120) /109, 73,   0.67959000D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26121: 26125) /109, 74,   0.59575800D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26126: 26130) /109, 75,   0.61094900D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26131: 26135) /109, 76,   0.57011100D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26136: 26140) /109, 77,   0.53521400D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26141: 26145) /109, 78,   0.46144200D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26146: 26150) /109, 79,   0.43746800D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26151: 26155) /109, 80,   0.45120500D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26156: 26160) /109, 81,   0.58912900D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26161: 26165) /109, 82,   0.59109700D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26166: 26170) /109, 83,   0.56500700D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26171: 26175) /109, 84,   0.55261400D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26176: 26180) /109, 85,   0.52703300D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26181: 26185) /109, 86,   0.49892700D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26186: 26190) /109, 87,   0.11543210D+03,   0.99820D+00,   0.00000D+00/
  data pars( 26191: 26195) /109, 88,   0.11600620D+03,   0.99820D+00,   0.00000D+00/
  data pars( 26196: 26200) /109, 89,   0.10653030D+03,   0.99820D+00,   0.00000D+00/
  data pars( 26201: 26205) /109, 90,   0.10090290D+03,   0.99820D+00,   0.00000D+00/
  data pars( 26206: 26210) /109, 91,   0.98576800D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26211: 26215) /109, 92,   0.95662500D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26216: 26220) /109, 93,   0.95732200D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26221: 26225) /109, 94,   0.93161400D+02,   0.99820D+00,   0.00000D+00/
  data pars( 26226: 26230) /109,101,   0.63000000D+01,   0.99820D+00,   0.00000D+00/
  data pars( 26231: 26235) /109,103,   0.17173300D+02,   0.99820D+00,   0.98650D+00/
  data pars( 26236: 26240) /109,104,   0.22541300D+02,   0.99820D+00,   0.98080D+00/
  data pars( 26241: 26245) /109,105,   0.19202900D+02,   0.99820D+00,   0.97060D+00/
  data pars( 26246: 26250) /109,106,   0.15685700D+02,   0.99820D+00,   0.98680D+00/
  data pars( 26251: 26255) /109,107,   0.11947000D+02,   0.99820D+00,   0.99440D+00/
  data pars( 26256: 26260) /109,108,   0.94048000D+01,   0.99820D+00,   0.99250D+00/
  data pars( 26261: 26265) /109,109,   0.71341000D+01,   0.99820D+00,   0.99820D+00/
  data pars( 26266: 26270) /111,  1,   0.20756700D+02,   0.96840D+00,   0.91180D+00/
  data pars( 26271: 26275) /111,  2,   0.12728700D+02,   0.96840D+00,   0.00000D+00/
  data pars( 26276: 26280) /111,  3,   0.42571610D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26281: 26285) /111,  4,   0.21865720D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26286: 26290) /111,  5,   0.13695360D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26291: 26295) /111,  6,   0.87395600D+02,   0.96840D+00,   0.00000D+00/
  data pars( 26296: 26300) /111,  7,   0.58485300D+02,   0.96840D+00,   0.00000D+00/
  data pars( 26301: 26305) /111,  8,   0.42891100D+02,   0.96840D+00,   0.00000D+00/
  data pars( 26306: 26310) /111,  9,   0.31606000D+02,   0.96840D+00,   0.00000D+00/
  data pars( 26311: 26315) /111, 10,   0.23774500D+02,   0.96840D+00,   0.00000D+00/
  data pars( 26316: 26320) /111, 11,   0.50543630D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26321: 26325) /111, 12,   0.35591800D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26326: 26330) /111, 13,   0.31645880D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26331: 26335) /111, 14,   0.23713260D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26336: 26340) /111, 15,   0.17692050D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26341: 26345) /111, 16,   0.14254300D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26346: 26350) /111, 17,   0.11310250D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26351: 26355) /111, 18,   0.90173500D+02,   0.96840D+00,   0.00000D+00/
  data pars( 26356: 26360) /111, 19,   0.84082990D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26361: 26365) /111, 20,   0.64831050D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26366: 26370) /111, 21,   0.52709170D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26371: 26375) /111, 22,   0.50123930D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26376: 26380) /111, 23,   0.45480300D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26381: 26385) /111, 24,   0.35715080D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26386: 26390) /111, 25,   0.38634260D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26391: 26395) /111, 26,   0.30174010D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26396: 26400) /111, 27,   0.31417180D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26401: 26405) /111, 28,   0.32682710D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26406: 26410) /111, 29,   0.24981970D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26411: 26415) /111, 30,   0.24939250D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26416: 26420) /111, 31,   0.29840070D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26421: 26425) /111, 32,   0.25314330D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26426: 26430) /111, 33,   0.20818020D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26431: 26435) /111, 34,   0.18247440D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26436: 26440) /111, 35,   0.15582020D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26441: 26445) /111, 36,   0.13243480D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26446: 26450) /111, 37,   0.93630060D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26451: 26455) /111, 38,   0.77398540D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26456: 26460) /111, 39,   0.65879630D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26461: 26465) /111, 40,   0.58124800D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26466: 26470) /111, 41,   0.52340580D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26471: 26475) /111, 42,   0.39500580D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26476: 26480) /111, 43,   0.44452690D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26481: 26485) /111, 44,   0.33022730D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26486: 26490) /111, 45,   0.36142870D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26491: 26495) /111, 46,   0.33243920D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26496: 26500) /111, 47,   0.27794280D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26501: 26505) /111, 48,   0.28984740D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26506: 26510) /111, 49,   0.37337940D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26511: 26515) /111, 50,   0.33470230D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26516: 26520) /111, 51,   0.28898880D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26521: 26525) /111, 52,   0.26288460D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26526: 26530) /111, 53,   0.23260530D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26531: 26535) /111, 54,   0.20479860D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26536: 26540) /111, 55,   0.11389256D+04,   0.96840D+00,   0.00000D+00/
  data pars( 26541: 26545) /111, 56,   0.99536600D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26546: 26550) /111, 57,   0.85007680D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26551: 26555) /111, 58,   0.34313820D+03,   0.96840D+00,   0.27991D+01/
  data pars( 26556: 26560) /111, 59,   0.87351340D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26561: 26565) /111, 60,   0.83492630D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26566: 26570) /111, 61,   0.81293500D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26571: 26575) /111, 62,   0.79283360D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26576: 26580) /111, 63,   0.77497190D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26581: 26585) /111, 64,   0.58968210D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26586: 26590) /111, 65,   0.69502110D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26591: 26595) /111, 66,   0.66665150D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26596: 26600) /111, 67,   0.69407420D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26601: 26605) /111, 68,   0.67884860D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26606: 26610) /111, 69,   0.66485800D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26611: 26615) /111, 70,   0.65799220D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26616: 26620) /111, 71,   0.54208720D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26621: 26625) /111, 72,   0.51742950D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26626: 26630) /111, 73,   0.46327240D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26631: 26635) /111, 74,   0.38490910D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26636: 26640) /111, 75,   0.38879710D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26641: 26645) /111, 76,   0.34639970D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26646: 26650) /111, 77,   0.31281320D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26651: 26655) /111, 78,   0.25572890D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26656: 26660) /111, 79,   0.23740440D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26661: 26665) /111, 80,   0.24279190D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26666: 26670) /111, 81,   0.37972090D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26671: 26675) /111, 82,   0.36256490D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26676: 26680) /111, 83,   0.32393500D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26681: 26685) /111, 84,   0.30383030D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26686: 26690) /111, 85,   0.27473150D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26691: 26695) /111, 86,   0.24706350D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26696: 26700) /111, 87,   0.10521318D+04,   0.96840D+00,   0.00000D+00/
  data pars( 26701: 26705) /111, 88,   0.96974210D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26706: 26710) /111, 89,   0.83486500D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26711: 26715) /111, 90,   0.72693870D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26716: 26720) /111, 91,   0.73265540D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26721: 26725) /111, 92,   0.70879360D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26726: 26730) /111, 93,   0.74391900D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26731: 26735) /111, 94,   0.71791000D+03,   0.96840D+00,   0.00000D+00/
  data pars( 26736: 26740) /111,101,   0.34995200D+02,   0.96840D+00,   0.00000D+00/
  data pars( 26741: 26745) /111,103,   0.12582450D+03,   0.96840D+00,   0.98650D+00/
  data pars( 26746: 26750) /111,104,   0.15832680D+03,   0.96840D+00,   0.98080D+00/
  data pars( 26751: 26755) /111,105,   0.11340160D+03,   0.96840D+00,   0.97060D+00/
  data pars( 26756: 26760) /111,106,   0.82014400D+02,   0.96840D+00,   0.98680D+00/
  data pars( 26761: 26765) /111,107,   0.54445400D+02,   0.96840D+00,   0.99440D+00/
  data pars( 26766: 26770) /111,108,   0.38122700D+02,   0.96840D+00,   0.99250D+00/
  data pars( 26771: 26775) /111,109,   0.24956000D+02,   0.96840D+00,   0.99820D+00/
  data pars( 26776: 26780) /111,111,   0.18610520D+03,   0.96840D+00,   0.96840D+00/
  data pars( 26781: 26785) /112,  1,   0.31991300D+02,   0.96280D+00,   0.91180D+00/
  data pars( 26786: 26790) /112,  2,   0.19464800D+02,   0.96280D+00,   0.00000D+00/
  data pars( 26791: 26795) /112,  3,   0.67003300D+03,   0.96280D+00,   0.00000D+00/
  data pars( 26796: 26800) /112,  4,   0.34026020D+03,   0.96280D+00,   0.00000D+00/
  data pars( 26801: 26805) /112,  5,   0.21221800D+03,   0.96280D+00,   0.00000D+00/
  data pars( 26806: 26810) /112,  6,   0.13492270D+03,   0.96280D+00,   0.00000D+00/
  data pars( 26811: 26815) /112,  7,   0.89964600D+02,   0.96280D+00,   0.00000D+00/
  data pars( 26816: 26820) /112,  8,   0.65760900D+02,   0.96280D+00,   0.00000D+00/
  data pars( 26821: 26825) /112,  9,   0.48286500D+02,   0.96280D+00,   0.00000D+00/
  data pars( 26826: 26830) /112, 10,   0.36191100D+02,   0.96280D+00,   0.00000D+00/
  data pars( 26831: 26835) /112, 11,   0.79475970D+03,   0.96280D+00,   0.00000D+00/
  data pars( 26836: 26840) /112, 12,   0.55459670D+03,   0.96280D+00,   0.00000D+00/
  data pars( 26841: 26845) /112, 13,   0.49208290D+03,   0.96280D+00,   0.00000D+00/
  data pars( 26846: 26850) /112, 14,   0.36758110D+03,   0.96280D+00,   0.00000D+00/
  data pars( 26851: 26855) /112, 15,   0.27352680D+03,   0.96280D+00,   0.00000D+00/
  data pars( 26856: 26860) /112, 16,   0.21994890D+03,   0.96280D+00,   0.00000D+00/
  data pars( 26861: 26865) /112, 17,   0.17413990D+03,   0.96280D+00,   0.00000D+00/
  data pars( 26866: 26870) /112, 18,   0.13851900D+03,   0.96280D+00,   0.00000D+00/
  data pars( 26871: 26875) /112, 19,   0.13273176D+04,   0.96280D+00,   0.00000D+00/
  data pars( 26876: 26880) /112, 20,   0.10137695D+04,   0.96280D+00,   0.00000D+00/
  data pars( 26881: 26885) /112, 21,   0.82289570D+03,   0.96280D+00,   0.00000D+00/
  data pars( 26886: 26890) /112, 22,   0.78169930D+03,   0.96280D+00,   0.00000D+00/
  data pars( 26891: 26895) /112, 23,   0.70876840D+03,   0.96280D+00,   0.00000D+00/
  data pars( 26896: 26900) /112, 24,   0.55661270D+03,   0.96280D+00,   0.00000D+00/
  data pars( 26901: 26905) /112, 25,   0.60144990D+03,   0.96280D+00,   0.00000D+00/
  data pars( 26906: 26910) /112, 26,   0.46964370D+03,   0.96280D+00,   0.00000D+00/
  data pars( 26911: 26915) /112, 27,   0.48817150D+03,   0.96280D+00,   0.00000D+00/
  data pars( 26916: 26920) /112, 28,   0.50815850D+03,   0.96280D+00,   0.00000D+00/
  data pars( 26921: 26925) /112, 29,   0.38842090D+03,   0.96280D+00,   0.00000D+00/
  data pars( 26926: 26930) /112, 30,   0.38688840D+03,   0.96280D+00,   0.00000D+00/
  data pars( 26931: 26935) /112, 31,   0.46356910D+03,   0.96280D+00,   0.00000D+00/
  data pars( 26936: 26940) /112, 32,   0.39225330D+03,   0.96280D+00,   0.00000D+00/
  data pars( 26941: 26945) /112, 33,   0.32187320D+03,   0.96280D+00,   0.00000D+00/
  data pars( 26946: 26950) /112, 34,   0.28171730D+03,   0.96280D+00,   0.00000D+00/
  data pars( 26951: 26955) /112, 35,   0.24015650D+03,   0.96280D+00,   0.00000D+00/
  data pars( 26956: 26960) /112, 36,   0.20374730D+03,   0.96280D+00,   0.00000D+00/
  data pars( 26961: 26965) /112, 37,   0.14776556D+04,   0.96280D+00,   0.00000D+00/
  data pars( 26966: 26970) /112, 38,   0.12109593D+04,   0.96280D+00,   0.00000D+00/
  data pars( 26971: 26975) /112, 39,   0.10281365D+04,   0.96280D+00,   0.00000D+00/
  data pars( 26976: 26980) /112, 40,   0.90577500D+03,   0.96280D+00,   0.00000D+00/
  data pars( 26981: 26985) /112, 41,   0.81492890D+03,   0.96280D+00,   0.00000D+00/
  data pars( 26986: 26990) /112, 42,   0.61402650D+03,   0.96280D+00,   0.00000D+00/
  data pars( 26991: 26995) /112, 43,   0.69144970D+03,   0.96280D+00,   0.00000D+00/
  data pars( 26996: 27000) /112, 44,   0.51267590D+03,   0.96280D+00,   0.00000D+00/
  data pars( 27001: 27005) /112, 45,   0.56100100D+03,   0.96280D+00,   0.00000D+00/
  data pars( 27006: 27010) /112, 46,   0.51564570D+03,   0.96280D+00,   0.00000D+00/
  data pars( 27011: 27015) /112, 47,   0.43128070D+03,   0.96280D+00,   0.00000D+00/
  data pars( 27016: 27020) /112, 48,   0.44915670D+03,   0.96280D+00,   0.00000D+00/
  data pars( 27021: 27025) /112, 49,   0.57992340D+03,   0.96280D+00,   0.00000D+00/
  data pars( 27026: 27030) /112, 50,   0.51865180D+03,   0.96280D+00,   0.00000D+00/
  data pars( 27031: 27035) /112, 51,   0.44692300D+03,   0.96280D+00,   0.00000D+00/
  data pars( 27036: 27040) /112, 52,   0.40607280D+03,   0.96280D+00,   0.00000D+00/
  data pars( 27041: 27045) /112, 53,   0.35880520D+03,   0.96280D+00,   0.00000D+00/
  data pars( 27046: 27050) /112, 54,   0.31545810D+03,   0.96280D+00,   0.00000D+00/
  data pars( 27051: 27055) /112, 55,   0.17990180D+04,   0.96280D+00,   0.00000D+00/
  data pars( 27056: 27060) /112, 56,   0.15595050D+04,   0.96280D+00,   0.00000D+00/
  data pars( 27061: 27065) /112, 57,   0.13282510D+04,   0.96280D+00,   0.00000D+00/
  data pars( 27066: 27070) /112, 58,   0.53086500D+03,   0.96280D+00,   0.27991D+01/
  data pars( 27071: 27075) /112, 59,   0.13672714D+04,   0.96280D+00,   0.00000D+00/
  data pars( 27076: 27080) /112, 60,   0.13059000D+04,   0.96280D+00,   0.00000D+00/
  data pars( 27081: 27085) /112, 61,   0.12712883D+04,   0.96280D+00,   0.00000D+00/
  data pars( 27086: 27090) /112, 62,   0.12396749D+04,   0.96280D+00,   0.00000D+00/
  data pars( 27091: 27095) /112, 63,   0.12115825D+04,   0.96280D+00,   0.00000D+00/
  data pars( 27096: 27100) /112, 64,   0.91963290D+03,   0.96280D+00,   0.00000D+00/
  data pars( 27101: 27105) /112, 65,   0.10898214D+04,   0.96280D+00,   0.00000D+00/
  data pars( 27106: 27110) /112, 66,   0.10451961D+04,   0.96280D+00,   0.00000D+00/
  data pars( 27111: 27115) /112, 67,   0.10842313D+04,   0.96280D+00,   0.00000D+00/
  data pars( 27116: 27120) /112, 68,   0.10603386D+04,   0.96280D+00,   0.00000D+00/
  data pars( 27121: 27125) /112, 69,   0.10383601D+04,   0.96280D+00,   0.00000D+00/
  data pars( 27126: 27130) /112, 70,   0.10277356D+04,   0.96280D+00,   0.00000D+00/
  data pars( 27131: 27135) /112, 71,   0.84553860D+03,   0.96280D+00,   0.00000D+00/
  data pars( 27136: 27140) /112, 72,   0.80500140D+03,   0.96280D+00,   0.00000D+00/
  data pars( 27141: 27145) /112, 73,   0.71971520D+03,   0.96280D+00,   0.00000D+00/
  data pars( 27146: 27150) /112, 74,   0.59743440D+03,   0.96280D+00,   0.00000D+00/
  data pars( 27151: 27155) /112, 75,   0.60309070D+03,   0.96280D+00,   0.00000D+00/
  data pars( 27156: 27160) /112, 76,   0.53662210D+03,   0.96280D+00,   0.00000D+00/
  data pars( 27161: 27165) /112, 77,   0.48407160D+03,   0.96280D+00,   0.00000D+00/
  data pars( 27166: 27170) /112, 78,   0.39524010D+03,   0.96280D+00,   0.00000D+00/
  data pars( 27171: 27175) /112, 79,   0.36670170D+03,   0.96280D+00,   0.00000D+00/
  data pars( 27176: 27180) /112, 80,   0.37485520D+03,   0.96280D+00,   0.00000D+00/
  data pars( 27181: 27185) /112, 81,   0.58953950D+03,   0.96280D+00,   0.00000D+00/
  data pars( 27186: 27190) /112, 82,   0.56172980D+03,   0.96280D+00,   0.00000D+00/
  data pars( 27191: 27195) /112, 83,   0.50092230D+03,   0.96280D+00,   0.00000D+00/
  data pars( 27196: 27200) /112, 84,   0.46935230D+03,   0.96280D+00,   0.00000D+00/
  data pars( 27201: 27205) /112, 85,   0.42385000D+03,   0.96280D+00,   0.00000D+00/
  data pars( 27206: 27210) /112, 86,   0.38067930D+03,   0.96280D+00,   0.00000D+00/
  data pars( 27211: 27215) /112, 87,   0.16575070D+04,   0.96280D+00,   0.00000D+00/
  data pars( 27216: 27220) /112, 88,   0.15173457D+04,   0.96280D+00,   0.00000D+00/
  data pars( 27221: 27225) /112, 89,   0.13028376D+04,   0.96280D+00,   0.00000D+00/
  data pars( 27226: 27230) /112, 90,   0.11313898D+04,   0.96280D+00,   0.00000D+00/
  data pars( 27231: 27235) /112, 91,   0.11418668D+04,   0.96280D+00,   0.00000D+00/
  data pars( 27236: 27240) /112, 92,   0.11045083D+04,   0.96280D+00,   0.00000D+00/
  data pars( 27241: 27245) /112, 93,   0.11608135D+04,   0.96280D+00,   0.00000D+00/
  data pars( 27246: 27250) /112, 94,   0.11198466D+04,   0.96280D+00,   0.00000D+00/
  data pars( 27251: 27255) /112,101,   0.54102100D+02,   0.96280D+00,   0.00000D+00/
  data pars( 27256: 27260) /112,103,   0.19570570D+03,   0.96280D+00,   0.98650D+00/
  data pars( 27261: 27265) /112,104,   0.24622270D+03,   0.96280D+00,   0.98080D+00/
  data pars( 27266: 27270) /112,105,   0.17556460D+03,   0.96280D+00,   0.97060D+00/
  data pars( 27271: 27275) /112,106,   0.12666570D+03,   0.96280D+00,   0.98680D+00/
  data pars( 27276: 27280) /112,107,   0.83770300D+02,   0.96280D+00,   0.99440D+00/
  data pars( 27281: 27285) /112,108,   0.58430300D+02,   0.96280D+00,   0.99250D+00/
  data pars( 27286: 27290) /112,109,   0.37988400D+02,   0.96280D+00,   0.99820D+00/
  data pars( 27291: 27295) /112,111,   0.28960820D+03,   0.96280D+00,   0.96840D+00/
  data pars( 27296: 27300) /112,112,   0.45127080D+03,   0.96280D+00,   0.96280D+00/
  data pars( 27301: 27305) /113,  1,   0.33104800D+02,   0.96480D+00,   0.91180D+00/
  data pars( 27306: 27310) /113,  2,   0.20515800D+02,   0.96480D+00,   0.00000D+00/
  data pars( 27311: 27315) /113,  3,   0.62753090D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27316: 27320) /113,  4,   0.33473350D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27321: 27325) /113,  5,   0.21388480D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27326: 27330) /113,  6,   0.13832540D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27331: 27335) /113,  7,   0.93354200D+02,   0.96480D+00,   0.00000D+00/
  data pars( 27336: 27340) /113,  8,   0.68798300D+02,   0.96480D+00,   0.00000D+00/
  data pars( 27341: 27345) /113,  9,   0.50857700D+02,   0.96480D+00,   0.00000D+00/
  data pars( 27346: 27350) /113, 10,   0.38315400D+02,   0.96480D+00,   0.00000D+00/
  data pars( 27351: 27355) /113, 11,   0.74634190D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27356: 27360) /113, 12,   0.54102850D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27361: 27365) /113, 13,   0.48623650D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27366: 27370) /113, 14,   0.36962320D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27371: 27375) /113, 15,   0.27892720D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27376: 27380) /113, 16,   0.22621560D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27381: 27385) /113, 17,   0.18054300D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27386: 27390) /113, 18,   0.14457980D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27391: 27395) /113, 19,   0.12332237D+04,   0.96480D+00,   0.00000D+00/
  data pars( 27396: 27400) /113, 20,   0.97304930D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27401: 27405) /113, 21,   0.79522060D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27406: 27410) /113, 22,   0.75945320D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27411: 27415) /113, 23,   0.69091560D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27416: 27420) /113, 24,   0.54224590D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27421: 27425) /113, 25,   0.58914750D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27426: 27430) /113, 26,   0.46004960D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27431: 27435) /113, 27,   0.48229900D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27436: 27440) /113, 28,   0.50035250D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27441: 27445) /113, 29,   0.38199230D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27446: 27450) /113, 30,   0.38514490D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27451: 27455) /113, 31,   0.45995440D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27456: 27460) /113, 32,   0.39466500D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27461: 27465) /113, 33,   0.32772290D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27466: 27470) /113, 34,   0.28884850D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27471: 27475) /113, 35,   0.24796920D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27476: 27480) /113, 36,   0.21169490D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27481: 27485) /113, 37,   0.13752558D+04,   0.96480D+00,   0.00000D+00/
  data pars( 27486: 27490) /113, 38,   0.11602539D+04,   0.96480D+00,   0.00000D+00/
  data pars( 27491: 27495) /113, 39,   0.99637570D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27496: 27500) /113, 40,   0.88385410D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27501: 27505) /113, 41,   0.79860940D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27506: 27510) /113, 42,   0.60591350D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27511: 27515) /113, 43,   0.68054270D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27516: 27520) /113, 44,   0.50852890D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27521: 27525) /113, 45,   0.55700430D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27526: 27530) /113, 46,   0.51341630D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27531: 27535) /113, 47,   0.42799620D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27536: 27540) /113, 48,   0.44880710D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27541: 27545) /113, 49,   0.57434200D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27546: 27550) /113, 50,   0.51984240D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27551: 27555) /113, 51,   0.45284940D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27556: 27560) /113, 52,   0.41405440D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27561: 27565) /113, 53,   0.36827920D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27566: 27570) /113, 54,   0.32576250D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27571: 27575) /113, 55,   0.16731922D+04,   0.96480D+00,   0.00000D+00/
  data pars( 27576: 27580) /113, 56,   0.14872964D+04,   0.96480D+00,   0.00000D+00/
  data pars( 27581: 27585) /113, 57,   0.12815229D+04,   0.96480D+00,   0.00000D+00/
  data pars( 27586: 27590) /113, 58,   0.53656260D+03,   0.96480D+00,   0.27991D+01/
  data pars( 27591: 27595) /113, 59,   0.13086041D+04,   0.96480D+00,   0.00000D+00/
  data pars( 27596: 27600) /113, 60,   0.12526928D+04,   0.96480D+00,   0.00000D+00/
  data pars( 27601: 27605) /113, 61,   0.12202246D+04,   0.96480D+00,   0.00000D+00/
  data pars( 27606: 27610) /113, 62,   0.11905003D+04,   0.96480D+00,   0.00000D+00/
  data pars( 27611: 27615) /113, 63,   0.11641089D+04,   0.96480D+00,   0.00000D+00/
  data pars( 27616: 27620) /113, 64,   0.89395150D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27621: 27625) /113, 65,   0.10381047D+04,   0.96480D+00,   0.00000D+00/
  data pars( 27626: 27630) /113, 66,   0.99738370D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27631: 27635) /113, 67,   0.10450038D+04,   0.96480D+00,   0.00000D+00/
  data pars( 27636: 27640) /113, 68,   0.10223674D+04,   0.96480D+00,   0.00000D+00/
  data pars( 27641: 27645) /113, 69,   0.10016784D+04,   0.96480D+00,   0.00000D+00/
  data pars( 27646: 27650) /113, 70,   0.99098080D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27651: 27655) /113, 71,   0.82160050D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27656: 27660) /113, 72,   0.79184560D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27661: 27665) /113, 73,   0.71274220D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27666: 27670) /113, 74,   0.59416160D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27671: 27675) /113, 75,   0.60157800D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27676: 27680) /113, 76,   0.53838550D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27681: 27685) /113, 77,   0.48789840D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27686: 27690) /113, 78,   0.39997680D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27691: 27695) /113, 79,   0.37172100D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27696: 27700) /113, 80,   0.38105900D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27701: 27705) /113, 81,   0.58469720D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27706: 27710) /113, 82,   0.56268750D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27711: 27715) /113, 83,   0.50686630D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27716: 27720) /113, 84,   0.47758620D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27721: 27725) /113, 85,   0.43409690D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27726: 27730) /113, 86,   0.39211690D+03,   0.96480D+00,   0.00000D+00/
  data pars( 27731: 27735) /113, 87,   0.15558848D+04,   0.96480D+00,   0.00000D+00/
  data pars( 27736: 27740) /113, 88,   0.14554241D+04,   0.96480D+00,   0.00000D+00/
  data pars( 27741: 27745) /113, 89,   0.12633724D+04,   0.96480D+00,   0.00000D+00/
  data pars( 27746: 27750) /113, 90,   0.11100628D+04,   0.96480D+00,   0.00000D+00/
  data pars( 27751: 27755) /113, 91,   0.11130738D+04,   0.96480D+00,   0.00000D+00/
  data pars( 27756: 27760) /113, 92,   0.10770005D+04,   0.96480D+00,   0.00000D+00/
  data pars( 27761: 27765) /113, 93,   0.11238008D+04,   0.96480D+00,   0.00000D+00/
  data pars( 27766: 27770) /113, 94,   0.10856846D+04,   0.96480D+00,   0.00000D+00/
  data pars( 27771: 27775) /113,101,   0.55263600D+02,   0.96480D+00,   0.00000D+00/
  data pars( 27776: 27780) /113,103,   0.19307070D+03,   0.96480D+00,   0.98650D+00/
  data pars( 27781: 27785) /113,104,   0.24376120D+03,   0.96480D+00,   0.98080D+00/
  data pars( 27786: 27790) /113,105,   0.17772540D+03,   0.96480D+00,   0.97060D+00/
  data pars( 27791: 27795) /113,106,   0.12969220D+03,   0.96480D+00,   0.98680D+00/
  data pars( 27796: 27800) /113,107,   0.86872800D+02,   0.96480D+00,   0.99440D+00/
  data pars( 27801: 27805) /113,108,   0.61217500D+02,   0.96480D+00,   0.99250D+00/
  data pars( 27806: 27810) /113,109,   0.40322000D+02,   0.96480D+00,   0.99820D+00/
  data pars( 27811: 27815) /113,111,   0.28422510D+03,   0.96480D+00,   0.96840D+00/
  data pars( 27816: 27820) /113,112,   0.44173220D+03,   0.96480D+00,   0.96280D+00/
  data pars( 27821: 27825) /113,113,   0.43775750D+03,   0.96480D+00,   0.96480D+00/
  data pars( 27826: 27830) /114,  1,   0.27498900D+02,   0.95070D+00,   0.91180D+00/
  data pars( 27831: 27835) /114,  2,   0.17635600D+02,   0.95070D+00,   0.00000D+00/
  data pars( 27836: 27840) /114,  3,   0.45095830D+03,   0.95070D+00,   0.00000D+00/
  data pars( 27841: 27845) /114,  4,   0.25658810D+03,   0.95070D+00,   0.00000D+00/
  data pars( 27846: 27850) /114,  5,   0.17018910D+03,   0.95070D+00,   0.00000D+00/
  data pars( 27851: 27855) /114,  6,   0.11320460D+03,   0.95070D+00,   0.00000D+00/
  data pars( 27856: 27860) /114,  7,   0.78019000D+02,   0.95070D+00,   0.00000D+00/
  data pars( 27861: 27865) /114,  8,   0.58355700D+02,   0.95070D+00,   0.00000D+00/
  data pars( 27866: 27870) /114,  9,   0.43685500D+02,   0.95070D+00,   0.00000D+00/
  data pars( 27871: 27875) /114, 10,   0.33241600D+02,   0.95070D+00,   0.00000D+00/
  data pars( 27876: 27880) /114, 11,   0.53834120D+03,   0.95070D+00,   0.00000D+00/
  data pars( 27881: 27885) /114, 12,   0.40991740D+03,   0.95070D+00,   0.00000D+00/
  data pars( 27886: 27890) /114, 13,   0.37552330D+03,   0.95070D+00,   0.00000D+00/
  data pars( 27891: 27895) /114, 14,   0.29299940D+03,   0.95070D+00,   0.00000D+00/
  data pars( 27896: 27900) /114, 15,   0.22606570D+03,   0.95070D+00,   0.00000D+00/
  data pars( 27901: 27905) /114, 16,   0.18600510D+03,   0.95070D+00,   0.00000D+00/
  data pars( 27906: 27910) /114, 17,   0.15052310D+03,   0.95070D+00,   0.00000D+00/
  data pars( 27911: 27915) /114, 18,   0.12200120D+03,   0.95070D+00,   0.00000D+00/
  data pars( 27916: 27920) /114, 19,   0.88126240D+03,   0.95070D+00,   0.00000D+00/
  data pars( 27921: 27925) /114, 20,   0.72251110D+03,   0.95070D+00,   0.00000D+00/
  data pars( 27926: 27930) /114, 21,   0.59567250D+03,   0.95070D+00,   0.00000D+00/
  data pars( 27931: 27935) /114, 22,   0.57349880D+03,   0.95070D+00,   0.00000D+00/
  data pars( 27936: 27940) /114, 23,   0.52428080D+03,   0.95070D+00,   0.00000D+00/
  data pars( 27941: 27945) /114, 24,   0.41188790D+03,   0.95070D+00,   0.00000D+00/
  data pars( 27946: 27950) /114, 25,   0.45022340D+03,   0.95070D+00,   0.00000D+00/
  data pars( 27951: 27955) /114, 26,   0.35224080D+03,   0.95070D+00,   0.00000D+00/
  data pars( 27956: 27960) /114, 27,   0.37301250D+03,   0.95070D+00,   0.00000D+00/
  data pars( 27961: 27965) /114, 28,   0.38500480D+03,   0.95070D+00,   0.00000D+00/
  data pars( 27966: 27970) /114, 29,   0.29414060D+03,   0.95070D+00,   0.00000D+00/
  data pars( 27971: 27975) /114, 30,   0.30117090D+03,   0.95070D+00,   0.00000D+00/
  data pars( 27976: 27980) /114, 31,   0.35794110D+03,   0.95070D+00,   0.00000D+00/
  data pars( 27981: 27985) /114, 32,   0.31339110D+03,   0.95070D+00,   0.00000D+00/
  data pars( 27986: 27990) /114, 33,   0.26507110D+03,   0.95070D+00,   0.00000D+00/
  data pars( 27991: 27995) /114, 34,   0.23633230D+03,   0.95070D+00,   0.00000D+00/
  data pars( 27996: 28000) /114, 35,   0.20529760D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28001: 28005) /114, 36,   0.17718110D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28006: 28010) /114, 37,   0.98604380D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28011: 28015) /114, 38,   0.86034210D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28016: 28020) /114, 39,   0.75038170D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28021: 28025) /114, 40,   0.67218340D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28026: 28030) /114, 41,   0.61131470D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28031: 28035) /114, 42,   0.46910920D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28036: 28040) /114, 43,   0.52464790D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28041: 28045) /114, 44,   0.39698620D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28046: 28050) /114, 45,   0.43472510D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28051: 28055) /114, 46,   0.40236620D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28056: 28060) /114, 47,   0.33466730D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28061: 28065) /114, 48,   0.35359760D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28066: 28070) /114, 49,   0.44659370D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28071: 28075) /114, 50,   0.41089600D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28076: 28080) /114, 51,   0.36378460D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28081: 28085) /114, 52,   0.33592400D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28086: 28090) /114, 53,   0.30198520D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28091: 28095) /114, 54,   0.26983720D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28096: 28100) /114, 55,   0.12005803D+04,   0.95070D+00,   0.00000D+00/
  data pars( 28101: 28105) /114, 56,   0.10973980D+04,   0.95070D+00,   0.00000D+00/
  data pars( 28106: 28110) /114, 57,   0.96023320D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28111: 28115) /114, 58,   0.42980740D+03,   0.95070D+00,   0.27991D+01/
  data pars( 28116: 28120) /114, 59,   0.97039570D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28121: 28125) /114, 60,   0.93129170D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28126: 28130) /114, 61,   0.90779700D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28131: 28135) /114, 62,   0.88621930D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28136: 28140) /114, 63,   0.86708440D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28141: 28145) /114, 64,   0.67748060D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28146: 28150) /114, 65,   0.76730550D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28151: 28155) /114, 66,   0.73939750D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28156: 28160) /114, 67,   0.78137480D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28161: 28165) /114, 68,   0.76476680D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28166: 28170) /114, 69,   0.74974130D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28171: 28175) /114, 70,   0.74120300D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28176: 28180) /114, 71,   0.62181690D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28181: 28185) /114, 72,   0.60906080D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28186: 28190) /114, 73,   0.55365420D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28191: 28195) /114, 74,   0.46519420D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28196: 28200) /114, 75,   0.47279230D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28201: 28205) /114, 76,   0.42679800D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28206: 28210) /114, 77,   0.38949880D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28211: 28215) /114, 78,   0.32171830D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28216: 28220) /114, 79,   0.29988580D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28221: 28225) /114, 80,   0.30842630D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28226: 28230) /114, 81,   0.45658720D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28231: 28235) /114, 82,   0.44500360D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28236: 28240) /114, 83,   0.40670170D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28241: 28245) /114, 84,   0.38646750D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28246: 28250) /114, 85,   0.35486660D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28251: 28255) /114, 86,   0.32354110D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28256: 28260) /114, 87,   0.11298915D+04,   0.95070D+00,   0.00000D+00/
  data pars( 28261: 28265) /114, 88,   0.10825018D+04,   0.95070D+00,   0.00000D+00/
  data pars( 28266: 28270) /114, 89,   0.95314260D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28271: 28275) /114, 90,   0.85147580D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28276: 28280) /114, 91,   0.84679590D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28281: 28285) /114, 92,   0.81968560D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28286: 28290) /114, 93,   0.84655430D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28291: 28295) /114, 94,   0.81936980D+03,   0.95070D+00,   0.00000D+00/
  data pars( 28296: 28300) /114,101,   0.44903000D+02,   0.95070D+00,   0.00000D+00/
  data pars( 28301: 28305) /114,103,   0.14874780D+03,   0.95070D+00,   0.98650D+00/
  data pars( 28306: 28310) /114,104,   0.18910900D+03,   0.95070D+00,   0.98080D+00/
  data pars( 28311: 28315) /114,105,   0.14251230D+03,   0.95070D+00,   0.97060D+00/
  data pars( 28316: 28320) /114,106,   0.10608060D+03,   0.95070D+00,   0.98680D+00/
  data pars( 28321: 28325) /114,107,   0.72637300D+02,   0.95070D+00,   0.99440D+00/
  data pars( 28326: 28330) /114,108,   0.52131100D+02,   0.95070D+00,   0.99250D+00/
  data pars( 28331: 28335) /114,109,   0.35129000D+02,   0.95070D+00,   0.99820D+00/
  data pars( 28336: 28340) /114,111,   0.21750490D+03,   0.95070D+00,   0.96840D+00/
  data pars( 28341: 28345) /114,112,   0.33702500D+03,   0.95070D+00,   0.96280D+00/
  data pars( 28346: 28350) /114,113,   0.33965160D+03,   0.95070D+00,   0.96480D+00/
  data pars( 28351: 28355) /114,114,   0.27026500D+03,   0.95070D+00,   0.95070D+00/
  data pars( 28356: 28360) /115,  1,   0.23090800D+02,   0.99470D+00,   0.91180D+00/
  data pars( 28361: 28365) /115,  2,   0.15261900D+02,   0.99470D+00,   0.00000D+00/
  data pars( 28366: 28370) /115,  3,   0.33966930D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28371: 28375) /115,  4,   0.20222820D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28376: 28380) /115,  5,   0.13807740D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28381: 28385) /115,  6,   0.93966300D+02,   0.99470D+00,   0.00000D+00/
  data pars( 28386: 28390) /115,  7,   0.65912700D+02,   0.99470D+00,   0.00000D+00/
  data pars( 28391: 28395) /115,  8,   0.49937400D+02,   0.99470D+00,   0.00000D+00/
  data pars( 28396: 28400) /115,  9,   0.37803500D+02,   0.99470D+00,   0.00000D+00/
  data pars( 28401: 28405) /115, 10,   0.29028000D+02,   0.99470D+00,   0.00000D+00/
  data pars( 28406: 28410) /115, 11,   0.40671500D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28411: 28415) /115, 12,   0.32041760D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28416: 28420) /115, 13,   0.29780760D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28421: 28425) /115, 14,   0.23698640D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28426: 28430) /115, 15,   0.18606840D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28431: 28435) /115, 16,   0.15492290D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28436: 28440) /115, 17,   0.12683120D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28441: 28445) /115, 18,   0.10386530D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28446: 28450) /115, 19,   0.66311840D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28451: 28455) /115, 20,   0.55742550D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28456: 28460) /115, 21,   0.46235110D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28461: 28465) /115, 22,   0.44795900D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28466: 28470) /115, 23,   0.41101210D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28471: 28475) /115, 24,   0.32359140D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28476: 28480) /115, 25,   0.35484320D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28481: 28485) /115, 26,   0.27840200D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28486: 28490) /115, 27,   0.29657890D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28491: 28495) /115, 28,   0.30491450D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28496: 28500) /115, 29,   0.23348980D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28501: 28505) /115, 30,   0.24143800D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28506: 28510) /115, 31,   0.28580720D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28511: 28515) /115, 32,   0.25397440D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28516: 28520) /115, 33,   0.21789200D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28521: 28525) /115, 34,   0.19608060D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28526: 28530) /115, 35,   0.17199100D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28531: 28535) /115, 36,   0.14979330D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28536: 28540) /115, 37,   0.74424750D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28541: 28545) /115, 38,   0.66356560D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28546: 28550) /115, 39,   0.58524670D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28551: 28555) /115, 40,   0.52808410D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28556: 28560) /115, 41,   0.48270360D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28561: 28565) /115, 42,   0.37394270D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28566: 28570) /115, 43,   0.41670800D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28571: 28575) /115, 44,   0.31859120D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28576: 28580) /115, 45,   0.34844490D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28581: 28585) /115, 46,   0.32352760D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28586: 28590) /115, 47,   0.26912200D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28591: 28595) /115, 48,   0.28548020D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28596: 28600) /115, 49,   0.35690690D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28601: 28605) /115, 50,   0.33217220D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28606: 28610) /115, 51,   0.29765980D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28611: 28615) /115, 52,   0.27698090D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28616: 28620) /115, 53,   0.25110810D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28621: 28625) /115, 54,   0.22622110D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28626: 28630) /115, 55,   0.90729930D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28631: 28635) /115, 56,   0.84401200D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28636: 28640) /115, 57,   0.74659930D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28641: 28645) /115, 58,   0.35115850D+03,   0.99470D+00,   0.27991D+01/
  data pars( 28646: 28650) /115, 59,   0.74914380D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28651: 28655) /115, 60,   0.72014500D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28656: 28660) /115, 61,   0.70229590D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28661: 28665) /115, 62,   0.68586200D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28666: 28670) /115, 63,   0.67130090D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28671: 28675) /115, 64,   0.53154240D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28676: 28680) /115, 65,   0.59201350D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28681: 28685) /115, 66,   0.57174810D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28686: 28690) /115, 67,   0.60649400D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28691: 28695) /115, 68,   0.59374030D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28696: 28700) /115, 69,   0.58229560D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28701: 28705) /115, 70,   0.57532620D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28706: 28710) /115, 71,   0.48706190D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28711: 28715) /115, 72,   0.48246160D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28716: 28720) /115, 73,   0.44186160D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28721: 28725) /115, 74,   0.37386540D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28726: 28730) /115, 75,   0.38091200D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28731: 28735) /115, 76,   0.34613260D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28736: 28740) /115, 77,   0.31760850D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28741: 28745) /115, 78,   0.26410910D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28746: 28750) /115, 79,   0.24683080D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28751: 28755) /115, 80,   0.25431280D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28756: 28760) /115, 81,   0.36658420D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28761: 28765) /115, 82,   0.36026310D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28766: 28770) /115, 83,   0.33271860D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28771: 28775) /115, 84,   0.31818410D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28776: 28780) /115, 85,   0.29447100D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28781: 28785) /115, 86,   0.27046770D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28786: 28790) /115, 87,   0.86138240D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28791: 28795) /115, 88,   0.83751280D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28796: 28800) /115, 89,   0.74476320D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28801: 28805) /115, 90,   0.67356880D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28806: 28810) /115, 91,   0.66625820D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28811: 28815) /115, 92,   0.64514050D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28816: 28820) /115, 93,   0.66128050D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28821: 28825) /115, 94,   0.64087610D+03,   0.99470D+00,   0.00000D+00/
  data pars( 28826: 28830) /115,101,   0.37023600D+02,   0.99470D+00,   0.00000D+00/
  data pars( 28831: 28835) /115,103,   0.11774720D+03,   0.99470D+00,   0.98650D+00/
  data pars( 28836: 28840) /115,104,   0.15060680D+03,   0.99470D+00,   0.98080D+00/
  data pars( 28841: 28845) /115,105,   0.11638180D+03,   0.99470D+00,   0.97060D+00/
  data pars( 28846: 28850) /115,106,   0.88076900D+02,   0.99470D+00,   0.98680D+00/
  data pars( 28851: 28855) /115,107,   0.61428600D+02,   0.99470D+00,   0.99440D+00/
  data pars( 28856: 28860) /115,108,   0.44777000D+02,   0.99470D+00,   0.99250D+00/
  data pars( 28861: 28865) /115,109,   0.30768800D+02,   0.99470D+00,   0.99820D+00/
  data pars( 28866: 28870) /115,111,   0.17144690D+03,   0.99470D+00,   0.96840D+00/
  data pars( 28871: 28875) /115,112,   0.26503780D+03,   0.99470D+00,   0.96280D+00/
  data pars( 28876: 28880) /115,113,   0.27035800D+03,   0.99470D+00,   0.96480D+00/
  data pars( 28881: 28885) /115,114,   0.21928630D+03,   0.99470D+00,   0.95070D+00/
  data pars( 28886: 28890) /115,115,   0.18062380D+03,   0.99470D+00,   0.99470D+00/
  data pars( 28891: 28895) /116,  1,   0.19866700D+02,   0.99480D+00,   0.91180D+00/
  data pars( 28896: 28900) /116,  2,   0.13459800D+02,   0.99480D+00,   0.00000D+00/
  data pars( 28901: 28905) /116,  3,   0.27130110D+03,   0.99480D+00,   0.00000D+00/
  data pars( 28906: 28910) /116,  4,   0.16618070D+03,   0.99480D+00,   0.00000D+00/
  data pars( 28911: 28915) /116,  5,   0.11581680D+03,   0.99480D+00,   0.00000D+00/
  data pars( 28916: 28920) /116,  6,   0.80180400D+02,   0.99480D+00,   0.00000D+00/
  data pars( 28921: 28925) /116,  7,   0.57025500D+02,   0.99480D+00,   0.00000D+00/
  data pars( 28926: 28930) /116,  8,   0.43654800D+02,   0.99480D+00,   0.00000D+00/
  data pars( 28931: 28935) /116,  9,   0.33355000D+02,   0.99480D+00,   0.00000D+00/
  data pars( 28936: 28940) /116, 10,   0.25810700D+02,   0.99480D+00,   0.00000D+00/
  data pars( 28941: 28945) /116, 11,   0.32559690D+03,   0.99480D+00,   0.00000D+00/
  data pars( 28946: 28950) /116, 12,   0.26194370D+03,   0.99480D+00,   0.00000D+00/
  data pars( 28951: 28955) /116, 13,   0.24585680D+03,   0.99480D+00,   0.00000D+00/
  data pars( 28956: 28960) /116, 14,   0.19832660D+03,   0.99480D+00,   0.00000D+00/
  data pars( 28961: 28965) /116, 15,   0.15769710D+03,   0.99480D+00,   0.00000D+00/
  data pars( 28966: 28970) /116, 16,   0.13249220D+03,   0.99480D+00,   0.00000D+00/
  data pars( 28971: 28975) /116, 17,   0.10944860D+03,   0.99480D+00,   0.00000D+00/
  data pars( 28976: 28980) /116, 18,   0.90371600D+02,   0.99480D+00,   0.00000D+00/
  data pars( 28981: 28985) /116, 19,   0.53051920D+03,   0.99480D+00,   0.00000D+00/
  data pars( 28986: 28990) /116, 20,   0.45237450D+03,   0.99480D+00,   0.00000D+00/
  data pars( 28991: 28995) /116, 21,   0.37661420D+03,   0.99480D+00,   0.00000D+00/
  data pars( 28996: 29000) /116, 22,   0.36651510D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29001: 29005) /116, 23,   0.33712500D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29006: 29010) /116, 24,   0.26607620D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29011: 29015) /116, 25,   0.29212570D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29016: 29020) /116, 26,   0.22987760D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29021: 29025) /116, 27,   0.24559880D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29026: 29030) /116, 28,   0.25180970D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29031: 29035) /116, 29,   0.19338650D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29036: 29040) /116, 30,   0.20107040D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29041: 29045) /116, 31,   0.23725630D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29046: 29050) /116, 32,   0.21294370D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29051: 29055) /116, 33,   0.18454670D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29056: 29060) /116, 34,   0.16722640D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29061: 29065) /116, 35,   0.14776790D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29066: 29070) /116, 36,   0.12961230D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29071: 29075) /116, 37,   0.59687630D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29076: 29080) /116, 38,   0.53867240D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29081: 29085) /116, 39,   0.47852040D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29086: 29090) /116, 40,   0.43390360D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29091: 29095) /116, 41,   0.39804190D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29096: 29100) /116, 42,   0.31058610D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29101: 29105) /116, 43,   0.34514340D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29106: 29110) /116, 44,   0.26595280D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29111: 29115) /116, 45,   0.29041460D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29116: 29120) /116, 46,   0.27025240D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29121: 29125) /116, 47,   0.22511810D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29126: 29130) /116, 48,   0.23917840D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29131: 29135) /116, 49,   0.29682140D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29136: 29140) /116, 50,   0.27827870D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29141: 29145) /116, 51,   0.25143440D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29146: 29150) /116, 52,   0.23525190D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29151: 29155) /116, 53,   0.21460020D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29156: 29160) /116, 54,   0.19452370D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29161: 29165) /116, 55,   0.72846530D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29166: 29170) /116, 56,   0.68423530D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29171: 29175) /116, 57,   0.60944200D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29176: 29180) /116, 58,   0.29645810D+03,   0.99480D+00,   0.27991D+01/
  data pars( 29181: 29185) /116, 59,   0.60891190D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29186: 29190) /116, 60,   0.58591340D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29191: 29195) /116, 61,   0.57153970D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29196: 29200) /116, 62,   0.55828160D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29201: 29205) /116, 63,   0.54653950D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29206: 29210) /116, 64,   0.43677850D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29211: 29215) /116, 65,   0.48158940D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29216: 29220) /116, 66,   0.46577580D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29221: 29225) /116, 67,   0.49452850D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29226: 29230) /116, 68,   0.48417910D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29231: 29235) /116, 69,   0.47494430D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29236: 29240) /116, 70,   0.46905670D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29241: 29245) /116, 71,   0.39959520D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29246: 29250) /116, 72,   0.39859150D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29251: 29255) /116, 73,   0.36694770D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29256: 29260) /116, 74,   0.31220810D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29261: 29265) /116, 75,   0.31855560D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29266: 29270) /116, 76,   0.29082630D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29271: 29275) /116, 77,   0.26791140D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29276: 29280) /116, 78,   0.22401000D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29281: 29285) /116, 79,   0.20979980D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29286: 29290) /116, 80,   0.21632530D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29291: 29295) /116, 81,   0.30615090D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29296: 29300) /116, 82,   0.30235050D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29301: 29305) /116, 83,   0.28117730D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29306: 29310) /116, 84,   0.27007790D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29311: 29315) /116, 85,   0.25135500D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29316: 29320) /116, 86,   0.23212580D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29321: 29325) /116, 87,   0.69553530D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29326: 29330) /116, 88,   0.68165580D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29331: 29335) /116, 89,   0.60993410D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29336: 29340) /116, 90,   0.55624920D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29341: 29345) /116, 91,   0.54849710D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29346: 29350) /116, 92,   0.53125540D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29351: 29355) /116, 93,   0.54187030D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29356: 29360) /116, 94,   0.52557770D+03,   0.99480D+00,   0.00000D+00/
  data pars( 29361: 29365) /116,101,   0.31412700D+02,   0.99480D+00,   0.00000D+00/
  data pars( 29366: 29370) /116,103,   0.97084900D+02,   0.99480D+00,   0.98650D+00/
  data pars( 29371: 29375) /116,104,   0.12475120D+03,   0.99480D+00,   0.98080D+00/
  data pars( 29376: 29380) /116,105,   0.98113900D+02,   0.99480D+00,   0.97060D+00/
  data pars( 29381: 29385) /116,106,   0.75203900D+02,   0.99480D+00,   0.98680D+00/
  data pars( 29386: 29390) /116,107,   0.53208600D+02,   0.99480D+00,   0.99440D+00/
  data pars( 29391: 29395) /116,108,   0.39268300D+02,   0.99480D+00,   0.99250D+00/
  data pars( 29396: 29400) /116,109,   0.27411700D+02,   0.99480D+00,   0.99820D+00/
  data pars( 29401: 29405) /116,111,   0.14105990D+03,   0.99480D+00,   0.96840D+00/
  data pars( 29406: 29410) /116,112,   0.21766290D+03,   0.99480D+00,   0.96280D+00/
  data pars( 29411: 29415) /116,113,   0.22379420D+03,   0.99480D+00,   0.96480D+00/
  data pars( 29416: 29420) /116,114,   0.18394830D+03,   0.99480D+00,   0.95070D+00/
  data pars( 29421: 29425) /116,115,   0.15318230D+03,   0.99480D+00,   0.99470D+00/
  data pars( 29426: 29430) /116,116,   0.13099650D+03,   0.99480D+00,   0.99480D+00/
  data pars( 29431: 29435) /117,  1,   0.16527300D+02,   0.99720D+00,   0.91180D+00/
  data pars( 29436: 29440) /117,  2,   0.11509200D+02,   0.99720D+00,   0.00000D+00/
  data pars( 29441: 29445) /117,  3,   0.20877430D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29446: 29450) /117,  4,   0.13164980D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29451: 29455) /117,  5,   0.93774300D+02,   0.99720D+00,   0.00000D+00/
  data pars( 29456: 29460) /117,  6,   0.66135400D+02,   0.99720D+00,   0.00000D+00/
  data pars( 29461: 29465) /117,  7,   0.47754000D+02,   0.99720D+00,   0.00000D+00/
  data pars( 29466: 29470) /117,  8,   0.36978300D+02,   0.99720D+00,   0.00000D+00/
  data pars( 29471: 29475) /117,  9,   0.28546800D+02,   0.99720D+00,   0.00000D+00/
  data pars( 29476: 29480) /117, 10,   0.22283200D+02,   0.99720D+00,   0.00000D+00/
  data pars( 29481: 29485) /117, 11,   0.25123260D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29486: 29490) /117, 12,   0.20645210D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29491: 29495) /117, 13,   0.19576470D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29496: 29500) /117, 14,   0.16018790D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29501: 29505) /117, 15,   0.12909560D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29506: 29510) /117, 16,   0.10952700D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29511: 29515) /117, 17,   0.91366700D+02,   0.99720D+00,   0.00000D+00/
  data pars( 29516: 29520) /117, 18,   0.76125600D+02,   0.99720D+00,   0.00000D+00/
  data pars( 29521: 29525) /117, 19,   0.40951050D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29526: 29530) /117, 20,   0.35409350D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29531: 29535) /117, 21,   0.29590280D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29536: 29540) /117, 22,   0.28935120D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29541: 29545) /117, 23,   0.26685570D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29546: 29550) /117, 24,   0.21129280D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29551: 29555) /117, 25,   0.23214470D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29556: 29560) /117, 26,   0.18336610D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29561: 29565) /117, 27,   0.19637550D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29566: 29570) /117, 28,   0.20075710D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29571: 29575) /117, 29,   0.15477560D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29576: 29580) /117, 30,   0.16173370D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29581: 29585) /117, 31,   0.19011390D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29586: 29590) /117, 32,   0.17239330D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29591: 29595) /117, 33,   0.15099990D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29596: 29600) /117, 34,   0.13784430D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29601: 29605) /117, 35,   0.12277630D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29606: 29610) /117, 36,   0.10852260D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29611: 29615) /117, 37,   0.46202520D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29616: 29620) /117, 38,   0.42188670D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29621: 29625) /117, 39,   0.37756420D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29626: 29630) /117, 40,   0.34413180D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29631: 29635) /117, 41,   0.31691100D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29636: 29640) /117, 42,   0.24926710D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29641: 29645) /117, 43,   0.27614550D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29646: 29650) /117, 44,   0.21463800D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29651: 29655) /117, 45,   0.23390310D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29656: 29660) /117, 46,   0.21819030D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29661: 29665) /117, 47,   0.18215470D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29666: 29670) /117, 48,   0.19372730D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29671: 29675) /117, 49,   0.23849880D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29676: 29680) /117, 50,   0.22523810D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29681: 29685) /117, 51,   0.20525120D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29686: 29690) /117, 52,   0.19314490D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29691: 29695) /117, 53,   0.17734580D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29696: 29700) /117, 54,   0.16181190D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29701: 29705) /117, 55,   0.56460060D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29706: 29710) /117, 56,   0.53526780D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29711: 29715) /117, 57,   0.48012440D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29716: 29720) /117, 58,   0.24192230D+03,   0.99720D+00,   0.27991D+01/
  data pars( 29721: 29725) /117, 59,   0.47771970D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29726: 29730) /117, 60,   0.46012500D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29731: 29735) /117, 61,   0.44895170D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29736: 29740) /117, 62,   0.43862430D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29741: 29745) /117, 63,   0.42948100D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29746: 29750) /117, 64,   0.34664610D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29751: 29755) /117, 65,   0.37839840D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29756: 29760) /117, 66,   0.36651660D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29761: 29765) /117, 67,   0.38919850D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29766: 29770) /117, 68,   0.38108470D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29771: 29775) /117, 69,   0.37388780D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29776: 29780) /117, 70,   0.36907690D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29781: 29785) /117, 71,   0.31653270D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29786: 29790) /117, 72,   0.31792390D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29791: 29795) /117, 73,   0.29429820D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29796: 29800) /117, 74,   0.25196160D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29801: 29805) /117, 75,   0.25744470D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29806: 29810) /117, 76,   0.23620650D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29811: 29815) /117, 77,   0.21851340D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29816: 29820) /117, 78,   0.18384350D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29821: 29825) /117, 79,   0.17259550D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29826: 29830) /117, 80,   0.17806050D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29831: 29835) /117, 81,   0.24721900D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29836: 29840) /117, 82,   0.24529500D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29841: 29845) /117, 83,   0.22972670D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29846: 29850) /117, 84,   0.22165670D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29851: 29855) /117, 85,   0.20750080D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29856: 29860) /117, 86,   0.19273160D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29861: 29865) /117, 87,   0.54229530D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29866: 29870) /117, 88,   0.53547060D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29871: 29875) /117, 89,   0.48217720D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29876: 29880) /117, 90,   0.44362620D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29881: 29885) /117, 91,   0.43615260D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29886: 29890) /117, 92,   0.42258040D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29891: 29895) /117, 93,   0.42886190D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29896: 29900) /117, 94,   0.41631150D+03,   0.99720D+00,   0.00000D+00/
  data pars( 29901: 29905) /117,101,   0.25741400D+02,   0.99720D+00,   0.00000D+00/
  data pars( 29906: 29910) /117,103,   0.77202300D+02,   0.99720D+00,   0.98650D+00/
  data pars( 29911: 29915) /117,104,   0.99699500D+02,   0.99720D+00,   0.98080D+00/
  data pars( 29916: 29920) /117,105,   0.79883300D+02,   0.99720D+00,   0.97060D+00/
  data pars( 29921: 29925) /117,106,   0.62086400D+02,   0.99720D+00,   0.98680D+00/
  data pars( 29926: 29930) /117,107,   0.44621700D+02,   0.99720D+00,   0.99440D+00/
  data pars( 29931: 29935) /117,108,   0.33380100D+02,   0.99720D+00,   0.99250D+00/
  data pars( 29936: 29940) /117,109,   0.23705900D+02,   0.99720D+00,   0.99820D+00/
  data pars( 29941: 29945) /117,111,   0.11198290D+03,   0.99720D+00,   0.96840D+00/
  data pars( 29946: 29950) /117,112,   0.17241480D+03,   0.99720D+00,   0.96280D+00/
  data pars( 29951: 29955) /117,113,   0.17871270D+03,   0.99720D+00,   0.96480D+00/
  data pars( 29956: 29960) /117,114,   0.14895590D+03,   0.99720D+00,   0.95070D+00/
  data pars( 29961: 29965) /117,115,   0.12549300D+03,   0.99720D+00,   0.99470D+00/
  data pars( 29966: 29970) /117,116,   0.10828930D+03,   0.99720D+00,   0.99480D+00/
  data pars( 29971: 29975) /117,117,   0.90398500D+02,   0.99720D+00,   0.99720D+00/
  data pars( 29976: 29980) /119,  1,   0.29300000D+02,   0.97670D+00,   0.91180D+00/
  data pars( 29981: 29985) /119,  2,   0.18665500D+02,   0.97670D+00,   0.00000D+00/
  data pars( 29986: 29990) /119,  3,   0.56029540D+03,   0.97670D+00,   0.00000D+00/
  data pars( 29991: 29995) /119,  4,   0.29222240D+03,   0.97670D+00,   0.00000D+00/
  data pars( 29996: 30000) /119,  5,   0.18695660D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30001: 30005) /119,  6,   0.12192920D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30006: 30010) /119,  7,   0.83215300D+02,   0.97670D+00,   0.00000D+00/
  data pars( 30011: 30015) /119,  8,   0.61994800D+02,   0.97670D+00,   0.00000D+00/
  data pars( 30016: 30020) /119,  9,   0.46352000D+02,   0.97670D+00,   0.00000D+00/
  data pars( 30021: 30025) /119, 10,   0.35296900D+02,   0.97670D+00,   0.00000D+00/
  data pars( 30026: 30030) /119, 11,   0.66603570D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30031: 30035) /119, 12,   0.47376610D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30036: 30040) /119, 13,   0.42489260D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30041: 30045) /119, 14,   0.32282330D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30046: 30050) /119, 15,   0.24457290D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30051: 30055) /119, 16,   0.19946720D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30056: 30060) /119, 17,   0.16033040D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30061: 30065) /119, 18,   0.12942830D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30066: 30070) /119, 19,   0.11122277D+04,   0.97670D+00,   0.00000D+00/
  data pars( 30071: 30075) /119, 20,   0.86017710D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30076: 30080) /119, 21,   0.70072810D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30081: 30085) /119, 22,   0.66875460D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30086: 30090) /119, 23,   0.60799510D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30091: 30095) /119, 24,   0.47897440D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30096: 30100) /119, 25,   0.51805830D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30101: 30105) /119, 26,   0.40608760D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30106: 30110) /119, 27,   0.42338090D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30111: 30115) /119, 28,   0.43928450D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30116: 30120) /119, 29,   0.33711170D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30121: 30125) /119, 30,   0.33789860D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30126: 30130) /119, 31,   0.40307450D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30131: 30135) /119, 32,   0.34544340D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30136: 30140) /119, 33,   0.28755350D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30141: 30145) /119, 34,   0.25436700D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30146: 30150) /119, 35,   0.21946470D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30151: 30155) /119, 36,   0.18848190D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30156: 30160) /119, 37,   0.12408631D+04,   0.97670D+00,   0.00000D+00/
  data pars( 30161: 30165) /119, 38,   0.10279671D+04,   0.97670D+00,   0.00000D+00/
  data pars( 30166: 30170) /119, 39,   0.87903460D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30171: 30175) /119, 40,   0.77852380D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30176: 30180) /119, 41,   0.70330600D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30181: 30185) /119, 42,   0.53463030D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30186: 30190) /119, 43,   0.59993020D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30191: 30195) /119, 44,   0.44930300D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30196: 30200) /119, 45,   0.49058070D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30201: 30205) /119, 46,   0.45224640D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30206: 30210) /119, 47,   0.37908360D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30211: 30215) /119, 48,   0.39551350D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30216: 30220) /119, 49,   0.50568380D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30221: 30225) /119, 50,   0.45646130D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30226: 30230) /119, 51,   0.39784160D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30231: 30235) /119, 52,   0.36440900D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30236: 30240) /119, 53,   0.32510680D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30241: 30245) /119, 54,   0.28872750D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30246: 30250) /119, 55,   0.15118898D+04,   0.97670D+00,   0.00000D+00/
  data pars( 30251: 30255) /119, 56,   0.13222619D+04,   0.97670D+00,   0.00000D+00/
  data pars( 30256: 30260) /119, 57,   0.11337749D+04,   0.97670D+00,   0.00000D+00/
  data pars( 30261: 30265) /119, 58,   0.47224550D+03,   0.97670D+00,   0.27991D+01/
  data pars( 30266: 30270) /119, 59,   0.11622835D+04,   0.97670D+00,   0.00000D+00/
  data pars( 30271: 30275) /119, 60,   0.11112638D+04,   0.97670D+00,   0.00000D+00/
  data pars( 30276: 30280) /119, 61,   0.10820865D+04,   0.97670D+00,   0.00000D+00/
  data pars( 30281: 30285) /119, 62,   0.10553891D+04,   0.97670D+00,   0.00000D+00/
  data pars( 30286: 30290) /119, 63,   0.10316716D+04,   0.97670D+00,   0.00000D+00/
  data pars( 30291: 30295) /119, 64,   0.79078540D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30296: 30300) /119, 65,   0.92736720D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30301: 30305) /119, 66,   0.89050560D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30306: 30310) /119, 67,   0.92461970D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30311: 30315) /119, 68,   0.90432570D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30316: 30320) /119, 69,   0.88575380D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30321: 30325) /119, 70,   0.87628990D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30326: 30330) /119, 71,   0.72564410D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30331: 30335) /119, 72,   0.69618310D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30336: 30340) /119, 73,   0.62634420D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30341: 30345) /119, 74,   0.52368920D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30346: 30350) /119, 75,   0.52962490D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30351: 30355) /119, 76,   0.47425390D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30356: 30360) /119, 77,   0.43019640D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30361: 30365) /119, 78,   0.35414110D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30366: 30370) /119, 79,   0.32964710D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30371: 30375) /119, 80,   0.33733350D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30376: 30380) /119, 81,   0.51695330D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30381: 30385) /119, 82,   0.49569810D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30386: 30390) /119, 83,   0.44630330D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30391: 30395) /119, 84,   0.42086840D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30396: 30400) /119, 85,   0.38335330D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30401: 30405) /119, 86,   0.34734370D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30406: 30410) /119, 87,   0.14001686D+04,   0.97670D+00,   0.00000D+00/
  data pars( 30411: 30415) /119, 88,   0.12915073D+04,   0.97670D+00,   0.00000D+00/
  data pars( 30416: 30420) /119, 89,   0.11159288D+04,   0.97670D+00,   0.00000D+00/
  data pars( 30421: 30425) /119, 90,   0.97819280D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30426: 30430) /119, 91,   0.98391310D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30431: 30435) /119, 92,   0.95206270D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30436: 30440) /119, 93,   0.99535270D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30441: 30445) /119, 94,   0.96105430D+03,   0.97670D+00,   0.00000D+00/
  data pars( 30446: 30450) /119,101,   0.48449900D+02,   0.97670D+00,   0.00000D+00/
  data pars( 30451: 30455) /119,103,   0.16874120D+03,   0.97670D+00,   0.98650D+00/
  data pars( 30456: 30460) /119,104,   0.21344440D+03,   0.97670D+00,   0.98080D+00/
  data pars( 30461: 30465) /119,105,   0.15577810D+03,   0.97670D+00,   0.97060D+00/
  data pars( 30466: 30470) /119,106,   0.11457230D+03,   0.97670D+00,   0.98680D+00/
  data pars( 30471: 30475) /119,107,   0.77631700D+02,   0.97670D+00,   0.99440D+00/
  data pars( 30476: 30480) /119,108,   0.55403200D+02,   0.97670D+00,   0.99250D+00/
  data pars( 30481: 30485) /119,109,   0.37198200D+02,   0.97670D+00,   0.99820D+00/
  data pars( 30486: 30490) /119,111,   0.24922000D+03,   0.97670D+00,   0.96840D+00/
  data pars( 30491: 30495) /119,112,   0.38733490D+03,   0.97670D+00,   0.96280D+00/
  data pars( 30496: 30500) /119,113,   0.38264220D+03,   0.97670D+00,   0.96480D+00/
  data pars( 30501: 30505) /119,114,   0.29694090D+03,   0.97670D+00,   0.95070D+00/
  data pars( 30506: 30510) /119,115,   0.23721910D+03,   0.97670D+00,   0.99470D+00/
  data pars( 30511: 30515) /119,116,   0.19738060D+03,   0.97670D+00,   0.99480D+00/
  data pars( 30516: 30520) /119,117,   0.15873300D+03,   0.97670D+00,   0.99720D+00/
  data pars( 30521: 30525) /119,119,   0.33802070D+03,   0.97670D+00,   0.97670D+00/
  data pars( 30526: 30530) /120,  1,   0.52987100D+02,   0.98310D+00,   0.91180D+00/
  data pars( 30531: 30535) /120,  2,   0.31879600D+02,   0.98310D+00,   0.00000D+00/
  data pars( 30536: 30540) /120,  3,   0.13100314D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30541: 30545) /120,  4,   0.60256610D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30546: 30550) /120,  5,   0.36268620D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30551: 30555) /120,  6,   0.22596290D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30556: 30560) /120,  7,   0.14897930D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30561: 30565) /120,  8,   0.10827180D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30566: 30570) /120,  9,   0.79221800D+02,   0.98310D+00,   0.00000D+00/
  data pars( 30571: 30575) /120, 10,   0.59277900D+02,   0.98310D+00,   0.00000D+00/
  data pars( 30576: 30580) /120, 11,   0.15457064D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30581: 30585) /120, 12,   0.99724860D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30586: 30590) /120, 13,   0.86695170D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30591: 30595) /120, 14,   0.63004560D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30596: 30600) /120, 15,   0.46026350D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30601: 30605) /120, 16,   0.36677110D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30606: 30610) /120, 17,   0.28821820D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30611: 30615) /120, 18,   0.22808920D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30616: 30620) /120, 19,   0.26610830D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30621: 30625) /120, 20,   0.18864221D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30626: 30630) /120, 21,   0.15101427D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30631: 30635) /120, 22,   0.14223244D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30636: 30640) /120, 23,   0.12821610D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30641: 30645) /120, 24,   0.10115955D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30646: 30650) /120, 25,   0.10791532D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30651: 30655) /120, 26,   0.84546860D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30656: 30660) /120, 27,   0.86250360D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30661: 30665) /120, 28,   0.90260140D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30666: 30670) /120, 29,   0.69450580D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30671: 30675) /120, 30,   0.67502990D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30676: 30680) /120, 31,   0.81349430D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30681: 30685) /120, 32,   0.67269170D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30686: 30690) /120, 33,   0.54301230D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30691: 30695) /120, 34,   0.47148220D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30696: 30700) /120, 35,   0.39902260D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30701: 30705) /120, 36,   0.33664830D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30706: 30710) /120, 37,   0.29580410D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30711: 30715) /120, 38,   0.22654155D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30716: 30720) /120, 39,   0.18821338D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30721: 30725) /120, 40,   0.16379667D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30726: 30730) /120, 41,   0.14638890D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30731: 30735) /120, 42,   0.10926733D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30736: 30740) /120, 43,   0.12349316D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30741: 30745) /120, 44,   0.90575150D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30746: 30750) /120, 45,   0.98637270D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30751: 30755) /120, 46,   0.90244050D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30756: 30760) /120, 47,   0.76261740D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30761: 30765) /120, 48,   0.78166000D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30766: 30770) /120, 49,   0.10241614D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30771: 30775) /120, 50,   0.89641550D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30776: 30780) /120, 51,   0.75979880D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30781: 30785) /120, 52,   0.68470730D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30786: 30790) /120, 53,   0.60026980D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30791: 30795) /120, 54,   0.52435470D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30796: 30800) /120, 55,   0.36192660D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30801: 30805) /120, 56,   0.29513362D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30806: 30810) /120, 57,   0.24567601D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30811: 30815) /120, 58,   0.90740120D+03,   0.98310D+00,   0.27991D+01/
  data pars( 30816: 30820) /120, 59,   0.25715319D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30821: 30825) /120, 60,   0.24420495D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30826: 30830) /120, 61,   0.23740445D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30831: 30835) /120, 62,   0.23122147D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30836: 30840) /120, 63,   0.22571993D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30841: 30845) /120, 64,   0.16806338D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30846: 30850) /120, 65,   0.20816173D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30851: 30855) /120, 66,   0.19928728D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30856: 30860) /120, 67,   0.20062958D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30861: 30865) /120, 68,   0.19602391D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30866: 30870) /120, 69,   0.19174640D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30871: 30875) /120, 70,   0.18991306D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30876: 30880) /120, 71,   0.15446852D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30881: 30885) /120, 72,   0.14351503D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30886: 30890) /120, 73,   0.12687518D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30891: 30895) /120, 74,   0.10493296D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30896: 30900) /120, 75,   0.10529922D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30901: 30905) /120, 76,   0.92845210D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30906: 30910) /120, 77,   0.83187520D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30911: 30915) /120, 78,   0.67699020D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30916: 30920) /120, 79,   0.62708530D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30921: 30925) /120, 80,   0.63711120D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30926: 30930) /120, 81,   0.10430556D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30931: 30935) /120, 82,   0.97428450D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30936: 30940) /120, 83,   0.85466400D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30941: 30945) /120, 84,   0.79444910D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30946: 30950) /120, 85,   0.71141430D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30951: 30955) /120, 86,   0.63479210D+03,   0.98310D+00,   0.00000D+00/
  data pars( 30956: 30960) /120, 87,   0.32712563D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30961: 30965) /120, 88,   0.28409447D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30966: 30970) /120, 89,   0.23867637D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30971: 30975) /120, 90,   0.20296245D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30976: 30980) /120, 91,   0.20761172D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30981: 30985) /120, 92,   0.20066915D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30986: 30990) /120, 93,   0.21352269D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30991: 30995) /120, 94,   0.20540131D+04,   0.98310D+00,   0.00000D+00/
  data pars( 30996: 31000) /120,101,   0.90792700D+02,   0.98310D+00,   0.00000D+00/
  data pars( 31001: 31005) /120,103,   0.34561200D+03,   0.98310D+00,   0.98650D+00/
  data pars( 31006: 31010) /120,104,   0.43402840D+03,   0.98310D+00,   0.98080D+00/
  data pars( 31011: 31015) /120,105,   0.29872640D+03,   0.98310D+00,   0.97060D+00/
  data pars( 31016: 31020) /120,106,   0.21289570D+03,   0.98310D+00,   0.98680D+00/
  data pars( 31021: 31025) /120,107,   0.13902190D+03,   0.98310D+00,   0.99440D+00/
  data pars( 31026: 31030) /120,108,   0.96158400D+02,   0.98310D+00,   0.99250D+00/
  data pars( 31031: 31035) /120,109,   0.62058000D+02,   0.98310D+00,   0.99820D+00/
  data pars( 31036: 31040) /120,111,   0.51669170D+03,   0.98310D+00,   0.96840D+00/
  data pars( 31041: 31045) /120,112,   0.80921820D+03,   0.98310D+00,   0.96280D+00/
  data pars( 31046: 31050) /120,113,   0.77508320D+03,   0.98310D+00,   0.96480D+00/
  data pars( 31051: 31055) /120,114,   0.57629620D+03,   0.98310D+00,   0.95070D+00/
  data pars( 31056: 31060) /120,115,   0.44601700D+03,   0.98310D+00,   0.99470D+00/
  data pars( 31061: 31065) /120,116,   0.36319510D+03,   0.98310D+00,   0.99480D+00/
  data pars( 31066: 31070) /120,117,   0.28549050D+03,   0.98310D+00,   0.99720D+00/
  data pars( 31071: 31075) /120,119,   0.68899110D+03,   0.98310D+00,   0.97670D+00/
  data pars( 31076: 31080) /120,120,   0.15251891D+04,   0.98310D+00,   0.98310D+00/
  data pars( 31081: 31085) /121,  1,   0.29995300D+02,   0.18627D+01,   0.91180D+00/
  data pars( 31086: 31090) /121,  2,   0.19384100D+02,   0.18627D+01,   0.00000D+00/
  data pars( 31091: 31095) /121,  3,   0.50482680D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31096: 31100) /121,  4,   0.28244200D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31101: 31105) /121,  5,   0.18614190D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31106: 31110) /121,  6,   0.12363790D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31111: 31115) /121,  7,   0.85340400D+02,   0.18627D+01,   0.00000D+00/
  data pars( 31116: 31120) /121,  8,   0.64007200D+02,   0.18627D+01,   0.00000D+00/
  data pars( 31121: 31125) /121,  9,   0.48093600D+02,   0.18627D+01,   0.00000D+00/
  data pars( 31126: 31130) /121, 10,   0.36746800D+02,   0.18627D+01,   0.00000D+00/
  data pars( 31131: 31135) /121, 11,   0.60249290D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31136: 31140) /121, 12,   0.45276000D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31141: 31145) /121, 13,   0.41290580D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31146: 31150) /121, 14,   0.32058960D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31151: 31155) /121, 15,   0.24673580D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31156: 31160) /121, 16,   0.20296720D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31161: 31165) /121, 17,   0.16436550D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31166: 31170) /121, 18,   0.13344040D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31171: 31175) /121, 19,   0.98858810D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31176: 31180) /121, 20,   0.80323800D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31181: 31185) /121, 21,   0.66067800D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31186: 31190) /121, 22,   0.63504570D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31191: 31195) /121, 23,   0.57995840D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31196: 31200) /121, 24,   0.45620230D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31201: 31205) /121, 25,   0.49734740D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31206: 31210) /121, 26,   0.38959740D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31211: 31215) /121, 27,   0.41105720D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31216: 31220) /121, 28,   0.42466930D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31221: 31225) /121, 29,   0.32508500D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31226: 31230) /121, 30,   0.33123100D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31231: 31235) /121, 31,   0.39353000D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31236: 31240) /121, 32,   0.34316790D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31241: 31245) /121, 33,   0.28955820D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31246: 31250) /121, 34,   0.25800840D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31251: 31255) /121, 35,   0.22413750D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31256: 31260) /121, 36,   0.19358680D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31261: 31265) /121, 37,   0.11054608D+04,   0.18627D+01,   0.00000D+00/
  data pars( 31266: 31270) /121, 38,   0.95722710D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31271: 31275) /121, 39,   0.83166790D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31276: 31280) /121, 40,   0.74343180D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31281: 31285) /121, 41,   0.67533140D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31286: 31290) /121, 42,   0.51773400D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31291: 31295) /121, 43,   0.57916230D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31296: 31300) /121, 44,   0.43784320D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31301: 31305) /121, 45,   0.47895980D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31306: 31310) /121, 46,   0.44308160D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31311: 31315) /121, 47,   0.36949330D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31316: 31320) /121, 48,   0.38918590D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31321: 31325) /121, 49,   0.49219040D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31326: 31330) /121, 50,   0.45113400D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31331: 31335) /121, 51,   0.39831520D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31336: 31340) /121, 52,   0.36739080D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31341: 31345) /121, 53,   0.33004180D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31346: 31350) /121, 54,   0.29487060D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31351: 31355) /121, 55,   0.13445274D+04,   0.18627D+01,   0.00000D+00/
  data pars( 31356: 31360) /121, 56,   0.12227426D+04,   0.18627D+01,   0.00000D+00/
  data pars( 31361: 31365) /121, 57,   0.10658140D+04,   0.18627D+01,   0.00000D+00/
  data pars( 31366: 31370) /121, 58,   0.47118540D+03,   0.18627D+01,   0.27991D+01/
  data pars( 31371: 31375) /121, 59,   0.10799647D+04,   0.18627D+01,   0.00000D+00/
  data pars( 31376: 31380) /121, 60,   0.10362055D+04,   0.18627D+01,   0.00000D+00/
  data pars( 31381: 31385) /121, 61,   0.10098893D+04,   0.18627D+01,   0.00000D+00/
  data pars( 31386: 31390) /121, 62,   0.98572640D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31391: 31395) /121, 63,   0.96428550D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31396: 31400) /121, 64,   0.75078480D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31401: 31405) /121, 65,   0.85514710D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31406: 31410) /121, 66,   0.82284200D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31411: 31415) /121, 67,   0.86811040D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31416: 31420) /121, 68,   0.84953940D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31421: 31425) /121, 69,   0.83269610D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31426: 31430) /121, 70,   0.82330890D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31431: 31435) /121, 71,   0.68862420D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31436: 31440) /121, 72,   0.67192580D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31441: 31445) /121, 73,   0.60975150D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31446: 31450) /121, 74,   0.51221050D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31451: 31455) /121, 75,   0.52005780D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31456: 31460) /121, 76,   0.46895650D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31461: 31465) /121, 77,   0.42768450D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31466: 31470) /121, 78,   0.35348450D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31471: 31475) /121, 79,   0.32959850D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31476: 31480) /121, 80,   0.33854780D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31481: 31485) /121, 81,   0.50363930D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31486: 31490) /121, 82,   0.48925410D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31491: 31495) /121, 83,   0.44592310D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31496: 31500) /121, 84,   0.42320630D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31501: 31505) /121, 85,   0.38821220D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31506: 31510) /121, 86,   0.35380050D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31511: 31515) /121, 87,   0.12630191D+04,   0.18627D+01,   0.00000D+00/
  data pars( 31516: 31520) /121, 88,   0.12039859D+04,   0.18627D+01,   0.00000D+00/
  data pars( 31521: 31525) /121, 89,   0.10563541D+04,   0.18627D+01,   0.00000D+00/
  data pars( 31526: 31530) /121, 90,   0.94062410D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31531: 31535) /121, 91,   0.93765790D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31536: 31540) /121, 92,   0.90769560D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31541: 31545) /121, 93,   0.93986910D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31546: 31550) /121, 94,   0.90928950D+03,   0.18627D+01,   0.00000D+00/
  data pars( 31551: 31555) /121,101,   0.48975300D+02,   0.18627D+01,   0.00000D+00/
  data pars( 31556: 31560) /121,103,   0.16364460D+03,   0.18627D+01,   0.98650D+00/
  data pars( 31561: 31565) /121,104,   0.20781070D+03,   0.18627D+01,   0.98080D+00/
  data pars( 31566: 31570) /121,105,   0.15582280D+03,   0.18627D+01,   0.97060D+00/
  data pars( 31571: 31575) /121,106,   0.11597260D+03,   0.18627D+01,   0.98680D+00/
  data pars( 31576: 31580) /121,107,   0.79538300D+02,   0.18627D+01,   0.99440D+00/
  data pars( 31581: 31585) /121,108,   0.57261100D+02,   0.18627D+01,   0.99250D+00/
  data pars( 31586: 31590) /121,109,   0.38809700D+02,   0.18627D+01,   0.99820D+00/
  data pars( 31591: 31595) /121,111,   0.23997140D+03,   0.18627D+01,   0.96840D+00/
  data pars( 31596: 31600) /121,112,   0.37177680D+03,   0.18627D+01,   0.96280D+00/
  data pars( 31601: 31605) /121,113,   0.37318450D+03,   0.18627D+01,   0.96480D+00/
  data pars( 31606: 31610) /121,114,   0.29561010D+03,   0.18627D+01,   0.95070D+00/
  data pars( 31611: 31615) /121,115,   0.23937010D+03,   0.18627D+01,   0.99470D+00/
  data pars( 31616: 31620) /121,116,   0.20076220D+03,   0.18627D+01,   0.99480D+00/
  data pars( 31621: 31625) /121,117,   0.16268060D+03,   0.18627D+01,   0.99720D+00/
  data pars( 31626: 31630) /121,119,   0.32770920D+03,   0.18627D+01,   0.97670D+00/
  data pars( 31631: 31635) /121,120,   0.64070760D+03,   0.18627D+01,   0.98310D+00/
  data pars( 31636: 31640) /121,121,   0.32450680D+03,   0.18627D+01,   0.18627D+01/
  data pars( 31641: 31645) /122,  1,   0.29000900D+02,   0.18299D+01,   0.91180D+00/
  data pars( 31646: 31650) /122,  2,   0.18808400D+02,   0.18299D+01,   0.00000D+00/
  data pars( 31651: 31655) /122,  3,   0.48829310D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31656: 31660) /122,  4,   0.27202010D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31661: 31665) /122,  5,   0.17950770D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31666: 31670) /122,  6,   0.11943760D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31671: 31675) /122,  7,   0.82583400D+02,   0.18299D+01,   0.00000D+00/
  data pars( 31676: 31680) /122,  8,   0.62030900D+02,   0.18299D+01,   0.00000D+00/
  data pars( 31681: 31685) /122,  9,   0.46676500D+02,   0.18299D+01,   0.00000D+00/
  data pars( 31686: 31690) /122, 10,   0.35711700D+02,   0.18299D+01,   0.00000D+00/
  data pars( 31691: 31695) /122, 11,   0.58252700D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31696: 31700) /122, 12,   0.43610910D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31701: 31705) /122, 13,   0.39786180D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31706: 31710) /122, 14,   0.30910810D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31711: 31715) /122, 15,   0.23816440D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31716: 31720) /122, 16,   0.19611280D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31721: 31725) /122, 17,   0.15898920D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31726: 31730) /122, 18,   0.12921800D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31731: 31735) /122, 19,   0.96033760D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31736: 31740) /122, 20,   0.77468630D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31741: 31745) /122, 21,   0.63687060D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31746: 31750) /122, 22,   0.61222250D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31751: 31755) /122, 23,   0.55911570D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31756: 31760) /122, 24,   0.44007620D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31761: 31765) /122, 25,   0.47949690D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31766: 31770) /122, 26,   0.37582420D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31771: 31775) /122, 27,   0.39627480D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31776: 31780) /122, 28,   0.40935550D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31781: 31785) /122, 29,   0.31360260D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31786: 31790) /122, 30,   0.31938340D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31791: 31795) /122, 31,   0.37941090D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31796: 31800) /122, 32,   0.33097100D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31801: 31805) /122, 33,   0.27949900D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31806: 31810) /122, 34,   0.24922580D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31811: 31815) /122, 35,   0.21669210D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31816: 31820) /122, 36,   0.18732310D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31821: 31825) /122, 37,   0.10741973D+04,   0.18299D+01,   0.00000D+00/
  data pars( 31826: 31830) /122, 38,   0.92365570D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31831: 31835) /122, 39,   0.80203240D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31836: 31840) /122, 40,   0.71686090D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31841: 31845) /122, 41,   0.65128470D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31846: 31850) /122, 42,   0.49950110D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31851: 31855) /122, 43,   0.55872110D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31856: 31860) /122, 44,   0.42257080D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31861: 31865) /122, 45,   0.46203140D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31866: 31870) /122, 46,   0.42745770D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31871: 31875) /122, 47,   0.35672450D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31876: 31880) /122, 48,   0.37552610D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31881: 31885) /122, 49,   0.47481120D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31886: 31890) /122, 50,   0.43519480D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31891: 31895) /122, 51,   0.38444870D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31896: 31900) /122, 52,   0.35477930D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31901: 31905) /122, 53,   0.31891710D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31906: 31910) /122, 54,   0.28513250D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31911: 31915) /122, 55,   0.13086418D+04,   0.18299D+01,   0.00000D+00/
  data pars( 31916: 31920) /122, 56,   0.11809424D+04,   0.18299D+01,   0.00000D+00/
  data pars( 31921: 31925) /122, 57,   0.10284169D+04,   0.18299D+01,   0.00000D+00/
  data pars( 31926: 31930) /122, 58,   0.45482000D+03,   0.18299D+01,   0.27991D+01/
  data pars( 31931: 31935) /122, 59,   0.10433187D+04,   0.18299D+01,   0.00000D+00/
  data pars( 31936: 31940) /122, 60,   0.10002155D+04,   0.18299D+01,   0.00000D+00/
  data pars( 31941: 31945) /122, 61,   0.97472270D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31946: 31950) /122, 62,   0.95132570D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31951: 31955) /122, 63,   0.93056540D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31956: 31960) /122, 64,   0.72458860D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31961: 31965) /122, 65,   0.82779700D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31966: 31970) /122, 66,   0.79723640D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31971: 31975) /122, 67,   0.83746180D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31976: 31980) /122, 68,   0.81949730D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31981: 31985) /122, 69,   0.80320320D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31986: 31990) /122, 70,   0.79414040D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31991: 31995) /122, 71,   0.66477270D+03,   0.18299D+01,   0.00000D+00/
  data pars( 31996: 32000) /122, 72,   0.64787460D+03,   0.18299D+01,   0.00000D+00/
  data pars( 32001: 32005) /122, 73,   0.58798130D+03,   0.18299D+01,   0.00000D+00/
  data pars( 32006: 32010) /122, 74,   0.49423570D+03,   0.18299D+01,   0.00000D+00/
  data pars( 32011: 32015) /122, 75,   0.50177330D+03,   0.18299D+01,   0.00000D+00/
  data pars( 32016: 32020) /122, 76,   0.45257260D+03,   0.18299D+01,   0.00000D+00/
  data pars( 32021: 32025) /122, 77,   0.41285580D+03,   0.18299D+01,   0.00000D+00/
  data pars( 32026: 32030) /122, 78,   0.34145400D+03,   0.18299D+01,   0.00000D+00/
  data pars( 32031: 32035) /122, 79,   0.31846190D+03,   0.18299D+01,   0.00000D+00/
  data pars( 32036: 32040) /122, 80,   0.32707700D+03,   0.18299D+01,   0.00000D+00/
  data pars( 32041: 32045) /122, 81,   0.48621160D+03,   0.18299D+01,   0.00000D+00/
  data pars( 32046: 32050) /122, 82,   0.47215520D+03,   0.18299D+01,   0.00000D+00/
  data pars( 32051: 32055) /122, 83,   0.43048050D+03,   0.18299D+01,   0.00000D+00/
  data pars( 32056: 32060) /122, 84,   0.40869510D+03,   0.18299D+01,   0.00000D+00/
  data pars( 32061: 32065) /122, 85,   0.37510290D+03,   0.18299D+01,   0.00000D+00/
  data pars( 32066: 32070) /122, 86,   0.34205750D+03,   0.18299D+01,   0.00000D+00/
  data pars( 32071: 32075) /122, 87,   0.12263970D+04,   0.18299D+01,   0.00000D+00/
  data pars( 32076: 32080) /122, 88,   0.11623660D+04,   0.18299D+01,   0.00000D+00/
  data pars( 32081: 32085) /122, 89,   0.10191422D+04,   0.18299D+01,   0.00000D+00/
  data pars( 32086: 32090) /122, 90,   0.90723670D+03,   0.18299D+01,   0.00000D+00/
  data pars( 32091: 32095) /122, 91,   0.90483310D+03,   0.18299D+01,   0.00000D+00/
  data pars( 32096: 32100) /122, 92,   0.87587480D+03,   0.18299D+01,   0.00000D+00/
  data pars( 32101: 32105) /122, 93,   0.90696160D+03,   0.18299D+01,   0.00000D+00/
  data pars( 32106: 32110) /122, 94,   0.87736450D+03,   0.18299D+01,   0.00000D+00/
  data pars( 32111: 32115) /122,101,   0.47275500D+02,   0.18299D+01,   0.00000D+00/
  data pars( 32116: 32120) /122,103,   0.15766670D+03,   0.18299D+01,   0.98650D+00/
  data pars( 32121: 32125) /122,104,   0.20036690D+03,   0.18299D+01,   0.98080D+00/
  data pars( 32126: 32130) /122,105,   0.15035200D+03,   0.18299D+01,   0.97060D+00/
  data pars( 32131: 32135) /122,106,   0.11205230D+03,   0.18299D+01,   0.98680D+00/
  data pars( 32136: 32140) /122,107,   0.76983400D+02,   0.18299D+01,   0.99440D+00/
  data pars( 32141: 32145) /122,108,   0.55516000D+02,   0.18299D+01,   0.99250D+00/
  data pars( 32146: 32150) /122,109,   0.37722200D+02,   0.18299D+01,   0.99820D+00/
  data pars( 32151: 32155) /122,111,   0.23126120D+03,   0.18299D+01,   0.96840D+00/
  data pars( 32156: 32160) /122,112,   0.35836020D+03,   0.18299D+01,   0.96280D+00/
  data pars( 32161: 32165) /122,113,   0.35964970D+03,   0.18299D+01,   0.96480D+00/
  data pars( 32166: 32170) /122,114,   0.28509570D+03,   0.18299D+01,   0.95070D+00/
  data pars( 32171: 32175) /122,115,   0.23107730D+03,   0.18299D+01,   0.99470D+00/
  data pars( 32176: 32180) /122,116,   0.19398450D+03,   0.18299D+01,   0.99480D+00/
  data pars( 32181: 32185) /122,117,   0.15736040D+03,   0.18299D+01,   0.99720D+00/
  data pars( 32186: 32190) /122,119,   0.31625180D+03,   0.18299D+01,   0.97670D+00/
  data pars( 32191: 32195) /122,120,   0.61943010D+03,   0.18299D+01,   0.98310D+00/
  data pars( 32196: 32200) /122,121,   0.31292020D+03,   0.18299D+01,   0.18627D+01/
  data pars( 32201: 32205) /122,122,   0.30199880D+03,   0.18299D+01,   0.18299D+01/
  data pars( 32206: 32210) /123,  1,   0.28406700D+02,   0.19138D+01,   0.91180D+00/
  data pars( 32211: 32215) /123,  2,   0.18435900D+02,   0.19138D+01,   0.00000D+00/
  data pars( 32216: 32220) /123,  3,   0.47914020D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32221: 32225) /123,  4,   0.26670500D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32226: 32230) /123,  5,   0.17589090D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32231: 32235) /123,  6,   0.11700980D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32236: 32240) /123,  7,   0.80914400D+02,   0.19138D+01,   0.00000D+00/
  data pars( 32241: 32245) /123,  8,   0.60793300D+02,   0.19138D+01,   0.00000D+00/
  data pars( 32246: 32250) /123,  9,   0.45763000D+02,   0.19138D+01,   0.00000D+00/
  data pars( 32251: 32255) /123, 10,   0.35029000D+02,   0.19138D+01,   0.00000D+00/
  data pars( 32256: 32260) /123, 11,   0.57164550D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32261: 32265) /123, 12,   0.42771560D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32266: 32270) /123, 13,   0.39004320D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32271: 32275) /123, 14,   0.30289850D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32276: 32280) /123, 15,   0.23331760D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32281: 32285) /123, 16,   0.19211130D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32286: 32290) /123, 17,   0.15575070D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32291: 32295) /123, 18,   0.12660270D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32296: 32300) /123, 19,   0.94198370D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32301: 32305) /123, 20,   0.76007180D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32306: 32310) /123, 21,   0.62478010D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32311: 32315) /123, 22,   0.60052210D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32316: 32320) /123, 23,   0.54839080D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32321: 32325) /123, 24,   0.43166830D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32326: 32330) /123, 25,   0.47025290D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32331: 32335) /123, 26,   0.36861360D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32336: 32340) /123, 27,   0.38857290D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32341: 32345) /123, 28,   0.40143290D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32346: 32350) /123, 29,   0.30757630D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32351: 32355) /123, 30,   0.31312860D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32356: 32360) /123, 31,   0.37194270D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32361: 32365) /123, 32,   0.32434350D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32366: 32370) /123, 33,   0.27383520D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32371: 32375) /123, 34,   0.24415540D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32376: 32380) /123, 35,   0.21227920D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32381: 32385) /123, 36,   0.18351710D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32386: 32390) /123, 37,   0.10535834D+04,   0.19138D+01,   0.00000D+00/
  data pars( 32391: 32395) /123, 38,   0.90623640D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32396: 32400) /123, 39,   0.78672550D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32401: 32405) /123, 40,   0.70307840D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32406: 32410) /123, 41,   0.63870140D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32411: 32415) /123, 42,   0.48981600D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32416: 32420) /123, 43,   0.54789060D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32421: 32425) /123, 44,   0.41435750D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32426: 32430) /123, 45,   0.45302620D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32431: 32435) /123, 46,   0.41911340D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32436: 32440) /123, 47,   0.34982880D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32441: 32445) /123, 48,   0.36818710D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32446: 32450) /123, 49,   0.46556470D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32451: 32455) /123, 50,   0.42659330D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32456: 32460) /123, 51,   0.37675440D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32461: 32465) /123, 52,   0.34763740D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32466: 32470) /123, 53,   0.31247140D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32471: 32475) /123, 54,   0.27936120D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32476: 32480) /123, 55,   0.12831193D+04,   0.19138D+01,   0.00000D+00/
  data pars( 32481: 32485) /123, 56,   0.11586662D+04,   0.19138D+01,   0.00000D+00/
  data pars( 32486: 32490) /123, 57,   0.10088336D+04,   0.19138D+01,   0.00000D+00/
  data pars( 32491: 32495) /123, 58,   0.44575700D+03,   0.19138D+01,   0.27991D+01/
  data pars( 32496: 32500) /123, 59,   0.10235395D+04,   0.19138D+01,   0.00000D+00/
  data pars( 32501: 32505) /123, 60,   0.98134570D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32506: 32510) /123, 61,   0.95633210D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32511: 32515) /123, 62,   0.93337380D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32516: 32520) /123, 63,   0.91300140D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32521: 32525) /123, 64,   0.71072370D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32526: 32530) /123, 65,   0.81199050D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32531: 32535) /123, 66,   0.78182720D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32536: 32540) /123, 67,   0.82162740D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32541: 32545) /123, 68,   0.80399890D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32546: 32550) /123, 69,   0.78800640D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32551: 32555) /123, 70,   0.77912190D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32556: 32560) /123, 71,   0.65197940D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32561: 32565) /123, 72,   0.63529960D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32566: 32570) /123, 73,   0.57649460D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32571: 32575) /123, 74,   0.48455830D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32576: 32580) /123, 75,   0.49191200D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32581: 32585) /123, 76,   0.44364130D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32586: 32590) /123, 77,   0.40468640D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32591: 32595) /123, 78,   0.33471530D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32596: 32600) /123, 79,   0.31218730D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32601: 32605) /123, 80,   0.32060120D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32606: 32610) /123, 81,   0.47675960D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32611: 32615) /123, 82,   0.46287410D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32616: 32620) /123, 83,   0.42191810D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32621: 32625) /123, 84,   0.40051720D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32626: 32630) /123, 85,   0.36755880D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32631: 32635) /123, 86,   0.33516100D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32636: 32640) /123, 87,   0.12027024D+04,   0.19138D+01,   0.00000D+00/
  data pars( 32641: 32645) /123, 88,   0.11403430D+04,   0.19138D+01,   0.00000D+00/
  data pars( 32646: 32650) /123, 89,   0.99965520D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32651: 32655) /123, 90,   0.88972590D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32656: 32660) /123, 91,   0.88748800D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32661: 32665) /123, 92,   0.85909970D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32666: 32670) /123, 93,   0.88977190D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32671: 32675) /123, 94,   0.86071780D+03,   0.19138D+01,   0.00000D+00/
  data pars( 32676: 32680) /123,101,   0.46308900D+02,   0.19138D+01,   0.00000D+00/
  data pars( 32681: 32685) /123,103,   0.15457620D+03,   0.19138D+01,   0.98650D+00/
  data pars( 32686: 32690) /123,104,   0.19640270D+03,   0.19138D+01,   0.98080D+00/
  data pars( 32691: 32695) /123,105,   0.14731530D+03,   0.19138D+01,   0.97060D+00/
  data pars( 32696: 32700) /123,106,   0.10977970D+03,   0.19138D+01,   0.98680D+00/
  data pars( 32701: 32705) /123,107,   0.75430300D+02,   0.19138D+01,   0.99440D+00/
  data pars( 32706: 32710) /123,108,   0.54410900D+02,   0.19138D+01,   0.99250D+00/
  data pars( 32711: 32715) /123,109,   0.36996200D+02,   0.19138D+01,   0.99820D+00/
  data pars( 32716: 32720) /123,111,   0.22678860D+03,   0.19138D+01,   0.96840D+00/
  data pars( 32721: 32725) /123,112,   0.35139280D+03,   0.19138D+01,   0.96280D+00/
  data pars( 32726: 32730) /123,113,   0.35255750D+03,   0.19138D+01,   0.96480D+00/
  data pars( 32731: 32735) /123,114,   0.27935630D+03,   0.19138D+01,   0.95070D+00/
  data pars( 32736: 32740) /123,115,   0.22637670D+03,   0.19138D+01,   0.99470D+00/
  data pars( 32741: 32745) /123,116,   0.19002990D+03,   0.19138D+01,   0.99480D+00/
  data pars( 32746: 32750) /123,117,   0.15415760D+03,   0.19138D+01,   0.99720D+00/
  data pars( 32751: 32755) /123,119,   0.31011080D+03,   0.19138D+01,   0.97670D+00/
  data pars( 32756: 32760) /123,120,   0.60755710D+03,   0.19138D+01,   0.98310D+00/
  data pars( 32761: 32765) /123,121,   0.30673890D+03,   0.19138D+01,   0.18627D+01/
  data pars( 32766: 32770) /123,122,   0.29600290D+03,   0.19138D+01,   0.18299D+01/
  data pars( 32771: 32775) /123,123,   0.29014360D+03,   0.19138D+01,   0.19138D+01/
  data pars( 32776: 32780) /124,  1,   0.28056200D+02,   0.18269D+01,   0.91180D+00/
  data pars( 32781: 32785) /124,  2,   0.18175400D+02,   0.18269D+01,   0.00000D+00/
  data pars( 32786: 32790) /124,  3,   0.48059440D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32791: 32795) /124,  4,   0.26540880D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32796: 32800) /124,  5,   0.17437190D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32801: 32805) /124,  6,   0.11571820D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32806: 32810) /124,  7,   0.79902400D+02,   0.18269D+01,   0.00000D+00/
  data pars( 32811: 32815) /124,  8,   0.59982900D+02,   0.18269D+01,   0.00000D+00/
  data pars( 32816: 32820) /124,  9,   0.45129000D+02,   0.18269D+01,   0.00000D+00/
  data pars( 32821: 32825) /124, 10,   0.34535000D+02,   0.18269D+01,   0.00000D+00/
  data pars( 32826: 32830) /124, 11,   0.57314360D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32831: 32835) /124, 12,   0.42622760D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32836: 32840) /124, 13,   0.38786950D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32841: 32845) /124, 14,   0.30039280D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32846: 32850) /124, 15,   0.23090900D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32851: 32855) /124, 16,   0.18990520D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32856: 32860) /124, 17,   0.15380570D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32861: 32865) /124, 18,   0.12492650D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32866: 32870) /124, 19,   0.94587000D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32871: 32875) /124, 20,   0.75936840D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32876: 32880) /124, 21,   0.62353320D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32881: 32885) /124, 22,   0.59879810D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32886: 32890) /124, 23,   0.54652440D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32891: 32895) /124, 24,   0.43023530D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32896: 32900) /124, 25,   0.46829610D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32901: 32905) /124, 26,   0.36707850D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32906: 32910) /124, 27,   0.38644860D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32911: 32915) /124, 28,   0.39945300D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32916: 32920) /124, 29,   0.30611810D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32921: 32925) /124, 30,   0.31106030D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32926: 32930) /124, 31,   0.36963020D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32931: 32935) /124, 32,   0.32164040D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32936: 32940) /124, 33,   0.27107700D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32941: 32945) /124, 34,   0.24145850D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32946: 32950) /124, 35,   0.20973930D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32951: 32955) /124, 36,   0.18118190D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32956: 32960) /124, 37,   0.10575718D+04,   0.18269D+01,   0.00000D+00/
  data pars( 32961: 32965) /124, 38,   0.90561870D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32966: 32970) /124, 39,   0.78474890D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32971: 32975) /124, 40,   0.70054320D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32976: 32980) /124, 41,   0.63596390D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32981: 32985) /124, 42,   0.48719110D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32986: 32990) /124, 43,   0.54517240D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32991: 32995) /124, 44,   0.41181870D+03,   0.18269D+01,   0.00000D+00/
  data pars( 32996: 33000) /124, 45,   0.45019430D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33001: 33005) /124, 46,   0.41632300D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33006: 33010) /124, 47,   0.34767860D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33011: 33015) /124, 48,   0.36555310D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33016: 33020) /124, 49,   0.46283040D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33021: 33025) /124, 50,   0.42332080D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33026: 33030) /124, 51,   0.37325910D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33031: 33035) /124, 52,   0.34409820D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33036: 33040) /124, 53,   0.30900630D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33041: 33045) /124, 54,   0.27604060D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33046: 33050) /124, 55,   0.12879616D+04,   0.18269D+01,   0.00000D+00/
  data pars( 33051: 33055) /124, 56,   0.11586672D+04,   0.18269D+01,   0.00000D+00/
  data pars( 33056: 33060) /124, 57,   0.10069636D+04,   0.18269D+01,   0.00000D+00/
  data pars( 33061: 33065) /124, 58,   0.44178090D+03,   0.18269D+01,   0.27991D+01/
  data pars( 33066: 33070) /124, 59,   0.10229773D+04,   0.18269D+01,   0.00000D+00/
  data pars( 33071: 33075) /124, 60,   0.98048290D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33076: 33080) /124, 61,   0.95540420D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33081: 33085) /124, 62,   0.93239460D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33086: 33090) /124, 63,   0.91197350D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33091: 33095) /124, 64,   0.70857690D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33096: 33100) /124, 65,   0.81204950D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33101: 33105) /124, 66,   0.78162600D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33106: 33110) /124, 67,   0.82030710D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33111: 33115) /124, 68,   0.80266090D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33116: 33120) /124, 69,   0.78663360D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33121: 33125) /124, 70,   0.77782320D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33126: 33130) /124, 71,   0.65005720D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33131: 33135) /124, 72,   0.63220990D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33136: 33140) /124, 73,   0.57309450D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33141: 33145) /124, 74,   0.48138140D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33146: 33150) /124, 75,   0.48847190D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33151: 33155) /124, 76,   0.44016550D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33156: 33160) /124, 77,   0.40125220D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33161: 33165) /124, 78,   0.33169650D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33166: 33170) /124, 79,   0.30930750D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33171: 33175) /124, 80,   0.31751490D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33176: 33180) /124, 81,   0.47384960D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33181: 33185) /124, 82,   0.45937430D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33186: 33190) /124, 83,   0.41810440D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33191: 33195) /124, 84,   0.39657360D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33196: 33200) /124, 85,   0.36360680D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33201: 33205) /124, 86,   0.33130140D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33206: 33210) /124, 87,   0.12054436D+04,   0.18269D+01,   0.00000D+00/
  data pars( 33211: 33215) /124, 88,   0.11392761D+04,   0.18269D+01,   0.00000D+00/
  data pars( 33216: 33220) /124, 89,   0.99702490D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33221: 33225) /124, 90,   0.88576610D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33226: 33230) /124, 91,   0.88442800D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33231: 33235) /124, 92,   0.85610390D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33236: 33240) /124, 93,   0.88770660D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33241: 33245) /124, 94,   0.85853020D+03,   0.18269D+01,   0.00000D+00/
  data pars( 33246: 33250) /124,101,   0.45817300D+02,   0.18269D+01,   0.00000D+00/
  data pars( 33251: 33255) /124,103,   0.15375390D+03,   0.18269D+01,   0.98650D+00/
  data pars( 33256: 33260) /124,104,   0.19523170D+03,   0.18269D+01,   0.98080D+00/
  data pars( 33261: 33265) /124,105,   0.14594770D+03,   0.18269D+01,   0.97060D+00/
  data pars( 33266: 33270) /124,106,   0.10858200D+03,   0.18269D+01,   0.98680D+00/
  data pars( 33271: 33275) /124,107,   0.74489000D+02,   0.18269D+01,   0.99440D+00/
  data pars( 33276: 33280) /124,108,   0.53673300D+02,   0.18269D+01,   0.99250D+00/
  data pars( 33281: 33285) /124,109,   0.36459400D+02,   0.18269D+01,   0.99820D+00/
  data pars( 33286: 33290) /124,111,   0.22578370D+03,   0.18269D+01,   0.96840D+00/
  data pars( 33291: 33295) /124,112,   0.34993280D+03,   0.18269D+01,   0.96280D+00/
  data pars( 33296: 33300) /124,113,   0.35042960D+03,   0.18269D+01,   0.96480D+00/
  data pars( 33301: 33305) /124,114,   0.27695120D+03,   0.18269D+01,   0.95070D+00/
  data pars( 33306: 33310) /124,115,   0.22403030D+03,   0.18269D+01,   0.99470D+00/
  data pars( 33311: 33315) /124,116,   0.18785700D+03,   0.18269D+01,   0.99480D+00/
  data pars( 33316: 33320) /124,117,   0.15223830D+03,   0.18269D+01,   0.99720D+00/
  data pars( 33321: 33325) /124,119,   0.30839010D+03,   0.18269D+01,   0.97670D+00/
  data pars( 33326: 33330) /124,120,   0.60707000D+03,   0.18269D+01,   0.98310D+00/
  data pars( 33331: 33335) /124,121,   0.30430940D+03,   0.18269D+01,   0.18627D+01/
  data pars( 33336: 33340) /124,122,   0.29365980D+03,   0.18269D+01,   0.18299D+01/
  data pars( 33341: 33345) /124,123,   0.28786570D+03,   0.18269D+01,   0.19138D+01/
  data pars( 33346: 33350) /124,124,   0.28569050D+03,   0.18269D+01,   0.18269D+01/
  data pars( 33351: 33355) /125,  1,   0.26181000D+02,   0.16406D+01,   0.91180D+00/
  data pars( 33356: 33360) /125,  2,   0.17152600D+02,   0.16406D+01,   0.00000D+00/
  data pars( 33361: 33365) /125,  3,   0.41608360D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33366: 33370) /125,  4,   0.23896060D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33371: 33375) /125,  5,   0.15984920D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33376: 33380) /125,  6,   0.10733820D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33381: 33385) /125,  7,   0.74699800D+02,   0.16406D+01,   0.00000D+00/
  data pars( 33386: 33390) /125,  8,   0.56362200D+02,   0.16406D+01,   0.00000D+00/
  data pars( 33391: 33395) /125,  9,   0.42576400D+02,   0.16406D+01,   0.00000D+00/
  data pars( 33396: 33400) /125, 10,   0.32680600D+02,   0.16406D+01,   0.00000D+00/
  data pars( 33401: 33405) /125, 11,   0.49735820D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33406: 33410) /125, 12,   0.38129680D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33411: 33415) /125, 13,   0.35045220D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33416: 33420) /125, 14,   0.27492570D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33421: 33425) /125, 15,   0.21341010D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33426: 33430) /125, 16,   0.17651650D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33431: 33435) /125, 17,   0.14370010D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33436: 33440) /125, 18,   0.11720570D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33441: 33445) /125, 19,   0.81424680D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33446: 33450) /125, 20,   0.67083370D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33451: 33455) /125, 21,   0.55379310D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33456: 33460) /125, 22,   0.53412660D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33461: 33465) /125, 23,   0.48879470D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33466: 33470) /125, 24,   0.38469310D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33471: 33475) /125, 25,   0.42042070D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33476: 33480) /125, 26,   0.32962730D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33481: 33485) /125, 27,   0.34919410D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33486: 33490) /125, 28,   0.36001720D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33491: 33495) /125, 29,   0.27572060D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33496: 33500) /125, 30,   0.28266670D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33501: 33505) /125, 31,   0.33506150D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33506: 33510) /125, 32,   0.29451840D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33511: 33515) /125, 33,   0.25028310D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33516: 33520) /125, 34,   0.22398570D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33521: 33525) /125, 35,   0.19545360D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33526: 33530) /125, 36,   0.16950970D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33531: 33535) /125, 37,   0.91194330D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33536: 33540) /125, 38,   0.79901250D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33541: 33545) /125, 39,   0.69867600D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33546: 33550) /125, 40,   0.62707900D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33551: 33555) /125, 41,   0.57118620D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33556: 33560) /125, 42,   0.43993260D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33561: 33565) /125, 43,   0.49132100D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33566: 33570) /125, 44,   0.37334420D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33571: 33575) /125, 45,   0.40836770D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33576: 33580) /125, 46,   0.37842950D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33581: 33585) /125, 47,   0.31534820D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33586: 33590) /125, 48,   0.33315180D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33591: 33595) /125, 49,   0.41907070D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33596: 33600) /125, 50,   0.38661840D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33601: 33605) /125, 51,   0.34352050D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33606: 33610) /125, 52,   0.31804850D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33611: 33615) /125, 53,   0.28687200D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33616: 33620) /125, 54,   0.25728030D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33621: 33625) /125, 55,   0.11103588D+04,   0.16406D+01,   0.00000D+00/
  data pars( 33626: 33630) /125, 56,   0.10186688D+04,   0.16406D+01,   0.00000D+00/
  data pars( 33631: 33635) /125, 57,   0.89350560D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33636: 33640) /125, 58,   0.40587370D+03,   0.16406D+01,   0.27991D+01/
  data pars( 33641: 33645) /125, 59,   0.90204820D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33646: 33650) /125, 60,   0.86604420D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33651: 33655) /125, 61,   0.84428560D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33656: 33660) /125, 62,   0.82428300D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33661: 33665) /125, 63,   0.80654320D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33666: 33670) /125, 64,   0.63257430D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33671: 33675) /125, 65,   0.71375520D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33676: 33680) /125, 66,   0.68811250D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33681: 33685) /125, 67,   0.72723780D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33686: 33690) /125, 68,   0.71180010D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33691: 33695) /125, 69,   0.69785650D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33696: 33700) /125, 70,   0.68978470D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33701: 33705) /125, 71,   0.58012870D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33706: 33710) /125, 72,   0.56940560D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33711: 33715) /125, 73,   0.51879050D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33716: 33720) /125, 74,   0.43720880D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33721: 33725) /125, 75,   0.44459970D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33726: 33730) /125, 76,   0.40230970D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33731: 33735) /125, 77,   0.36794540D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33736: 33740) /125, 78,   0.30505010D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33741: 33745) /125, 79,   0.28480180D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33746: 33750) /125, 80,   0.29291770D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33751: 33755) /125, 81,   0.42959510D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33756: 33760) /125, 82,   0.41941490D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33761: 33765) /125, 83,   0.38444960D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33766: 33770) /125, 84,   0.36605470D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33771: 33775) /125, 85,   0.33709280D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33776: 33780) /125, 86,   0.30829470D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33781: 33785) /125, 87,   0.10472098D+04,   0.16406D+01,   0.00000D+00/
  data pars( 33786: 33790) /125, 88,   0.10062859D+04,   0.16406D+01,   0.00000D+00/
  data pars( 33791: 33795) /125, 89,   0.88823000D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33796: 33800) /125, 90,   0.79631050D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33801: 33805) /125, 91,   0.79125770D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33806: 33810) /125, 92,   0.76609840D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33811: 33815) /125, 93,   0.78992350D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33816: 33820) /125, 94,   0.76480610D+03,   0.16406D+01,   0.00000D+00/
  data pars( 33821: 33825) /125,101,   0.42392700D+02,   0.16406D+01,   0.00000D+00/
  data pars( 33826: 33830) /125,103,   0.13874910D+03,   0.16406D+01,   0.98650D+00/
  data pars( 33831: 33835) /125,104,   0.17668170D+03,   0.16406D+01,   0.98080D+00/
  data pars( 33836: 33840) /125,105,   0.13421360D+03,   0.16406D+01,   0.97060D+00/
  data pars( 33841: 33845) /125,106,   0.10064630D+03,   0.16406D+01,   0.98680D+00/
  data pars( 33846: 33850) /125,107,   0.69621500D+02,   0.16406D+01,   0.99440D+00/
  data pars( 33851: 33855) /125,108,   0.50485800D+02,   0.16406D+01,   0.99250D+00/
  data pars( 33856: 33860) /125,109,   0.34548100D+02,   0.16406D+01,   0.99820D+00/
  data pars( 33861: 33865) /125,111,   0.20296760D+03,   0.16406D+01,   0.96840D+00/
  data pars( 33866: 33870) /125,112,   0.31401190D+03,   0.16406D+01,   0.96280D+00/
  data pars( 33871: 33875) /125,113,   0.31732870D+03,   0.16406D+01,   0.96480D+00/
  data pars( 33876: 33880) /125,114,   0.25388000D+03,   0.16406D+01,   0.95070D+00/
  data pars( 33881: 33885) /125,115,   0.20709950D+03,   0.16406D+01,   0.99470D+00/
  data pars( 33886: 33890) /125,116,   0.17457750D+03,   0.16406D+01,   0.99480D+00/
  data pars( 33891: 33895) /125,117,   0.14221510D+03,   0.16406D+01,   0.99720D+00/
  data pars( 33896: 33900) /125,119,   0.27872590D+03,   0.16406D+01,   0.97670D+00/
  data pars( 33901: 33905) /125,120,   0.53581490D+03,   0.16406D+01,   0.98310D+00/
  data pars( 33906: 33910) /125,121,   0.27819650D+03,   0.16406D+01,   0.18627D+01/
  data pars( 33911: 33915) /125,122,   0.26846570D+03,   0.16406D+01,   0.18299D+01/
  data pars( 33916: 33920) /125,123,   0.26311270D+03,   0.16406D+01,   0.19138D+01/
  data pars( 33921: 33925) /125,124,   0.26077730D+03,   0.16406D+01,   0.18269D+01/
  data pars( 33926: 33930) /125,125,   0.23955540D+03,   0.16406D+01,   0.16406D+01/
  data pars( 33931: 33935) /126,  1,   0.24345200D+02,   0.16483D+01,   0.91180D+00/
  data pars( 33936: 33940) /126,  2,   0.16056000D+02,   0.16483D+01,   0.00000D+00/
  data pars( 33941: 33945) /126,  3,   0.37921170D+03,   0.16483D+01,   0.00000D+00/
  data pars( 33946: 33950) /126,  4,   0.21947750D+03,   0.16483D+01,   0.00000D+00/
  data pars( 33951: 33955) /126,  5,   0.14762980D+03,   0.16483D+01,   0.00000D+00/
  data pars( 33956: 33960) /126,  6,   0.99588000D+02,   0.16483D+01,   0.00000D+00/
  data pars( 33961: 33965) /126,  7,   0.69563800D+02,   0.16483D+01,   0.00000D+00/
  data pars( 33966: 33970) /126,  8,   0.52635100D+02,   0.16483D+01,   0.00000D+00/
  data pars( 33971: 33975) /126,  9,   0.39862800D+02,   0.16483D+01,   0.00000D+00/
  data pars( 33976: 33980) /126, 10,   0.30664800D+02,   0.16483D+01,   0.00000D+00/
  data pars( 33981: 33985) /126, 11,   0.45354440D+03,   0.16483D+01,   0.00000D+00/
  data pars( 33986: 33990) /126, 12,   0.34971160D+03,   0.16483D+01,   0.00000D+00/
  data pars( 33991: 33995) /126, 13,   0.32227810D+03,   0.16483D+01,   0.00000D+00/
  data pars( 33996: 34000) /126, 14,   0.25376380D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34001: 34005) /126, 15,   0.19765690D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34006: 34010) /126, 16,   0.16387940D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34011: 34015) /126, 17,   0.13373240D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34016: 34020) /126, 18,   0.10931550D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34021: 34025) /126, 19,   0.74225200D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34026: 34030) /126, 20,   0.61392330D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34031: 34035) /126, 21,   0.50734010D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34036: 34040) /126, 22,   0.48989960D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34041: 34045) /126, 23,   0.44862620D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34046: 34050) /126, 24,   0.35327090D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34051: 34055) /126, 25,   0.38626020D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34056: 34060) /126, 26,   0.30304800D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34061: 34065) /126, 27,   0.32134480D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34066: 34070) /126, 28,   0.33106140D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34071: 34075) /126, 29,   0.25370380D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34076: 34080) /126, 30,   0.26053410D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34081: 34085) /126, 31,   0.30855290D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34086: 34090) /126, 32,   0.27197110D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34091: 34095) /126, 33,   0.23176180D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34096: 34100) /126, 34,   0.20779480D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34101: 34105) /126, 35,   0.18168360D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34106: 34110) /126, 36,   0.15786610D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34111: 34115) /126, 37,   0.83179600D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34116: 34120) /126, 38,   0.73123300D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34121: 34125) /126, 39,   0.64066410D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34126: 34130) /126, 40,   0.57577520D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34131: 34135) /126, 41,   0.52495880D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34136: 34140) /126, 42,   0.40508170D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34141: 34145) /126, 43,   0.45208310D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34146: 34150) /126, 44,   0.34423220D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34151: 34155) /126, 45,   0.37640450D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34156: 34160) /126, 46,   0.34902580D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34161: 34165) /126, 47,   0.29090830D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34166: 34170) /126, 48,   0.30752090D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34171: 34175) /126, 49,   0.38606280D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34176: 34180) /126, 50,   0.35691590D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34181: 34185) /126, 51,   0.31786240D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34186: 34190) /126, 52,   0.29473480D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34191: 34195) /126, 53,   0.26629100D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34196: 34200) /126, 54,   0.23921900D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34201: 34205) /126, 55,   0.10130459D+04,   0.16483D+01,   0.00000D+00/
  data pars( 34206: 34210) /126, 56,   0.93186100D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34211: 34215) /126, 57,   0.81889940D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34216: 34220) /126, 58,   0.37545680D+03,   0.16483D+01,   0.27991D+01/
  data pars( 34221: 34225) /126, 59,   0.82577350D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34226: 34230) /126, 60,   0.79302390D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34231: 34235) /126, 61,   0.77315750D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34236: 34240) /126, 62,   0.75488610D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34241: 34245) /126, 63,   0.73868360D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34246: 34250) /126, 64,   0.58077730D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34251: 34255) /126, 65,   0.65347520D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34256: 34260) /126, 66,   0.63025330D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34261: 34265) /126, 67,   0.66633780D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34266: 34270) /126, 68,   0.65221550D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34271: 34275) /126, 69,   0.63947820D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34276: 34280) /126, 70,   0.63201230D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34281: 34285) /126, 71,   0.53244100D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34286: 34290) /126, 72,   0.52361220D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34291: 34295) /126, 73,   0.47773970D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34296: 34300) /126, 74,   0.40318600D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34301: 34305) /126, 75,   0.41018490D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34306: 34310) /126, 76,   0.37164480D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34311: 34315) /126, 77,   0.34026720D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34316: 34320) /126, 78,   0.28250560D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34321: 34325) /126, 79,   0.26390350D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34326: 34330) /126, 80,   0.27150750D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34331: 34335) /126, 81,   0.39615750D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34336: 34340) /126, 82,   0.38734040D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34341: 34345) /126, 83,   0.35575280D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34346: 34350) /126, 84,   0.33914780D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34351: 34355) /126, 85,   0.31279910D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34356: 34360) /126, 86,   0.28650170D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34361: 34365) /126, 87,   0.95682050D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34366: 34370) /126, 88,   0.92149130D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34371: 34375) /126, 89,   0.81480800D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34376: 34380) /126, 90,   0.73215470D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34381: 34385) /126, 91,   0.72684330D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34386: 34390) /126, 92,   0.70377870D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34391: 34395) /126, 93,   0.72468840D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34396: 34400) /126, 94,   0.70180630D+03,   0.16483D+01,   0.00000D+00/
  data pars( 34401: 34405) /126,101,   0.39274200D+02,   0.16483D+01,   0.00000D+00/
  data pars( 34406: 34410) /126,103,   0.12754920D+03,   0.16483D+01,   0.98650D+00/
  data pars( 34411: 34415) /126,104,   0.16261080D+03,   0.16483D+01,   0.98080D+00/
  data pars( 34416: 34420) /126,105,   0.12411700D+03,   0.16483D+01,   0.97060D+00/
  data pars( 34421: 34425) /126,106,   0.93384800D+02,   0.16483D+01,   0.98680D+00/
  data pars( 34426: 34430) /126,107,   0.64846800D+02,   0.16483D+01,   0.99440D+00/
  data pars( 34431: 34435) /126,108,   0.47181600D+02,   0.16483D+01,   0.99250D+00/
  data pars( 34436: 34440) /126,109,   0.32432100D+02,   0.16483D+01,   0.99820D+00/
  data pars( 34441: 34445) /126,111,   0.18646690D+03,   0.16483D+01,   0.96840D+00/
  data pars( 34446: 34450) /126,112,   0.28833710D+03,   0.16483D+01,   0.96280D+00/
  data pars( 34451: 34455) /126,113,   0.29202470D+03,   0.16483D+01,   0.96480D+00/
  data pars( 34456: 34460) /126,114,   0.23448430D+03,   0.16483D+01,   0.95070D+00/
  data pars( 34461: 34465) /126,115,   0.19184290D+03,   0.16483D+01,   0.99470D+00/
  data pars( 34466: 34470) /126,116,   0.16207500D+03,   0.16483D+01,   0.99480D+00/
  data pars( 34471: 34475) /126,117,   0.13234800D+03,   0.16483D+01,   0.99720D+00/
  data pars( 34476: 34480) /126,119,   0.25675790D+03,   0.16483D+01,   0.97670D+00/
  data pars( 34481: 34485) /126,120,   0.49074810D+03,   0.16483D+01,   0.98310D+00/
  data pars( 34486: 34490) /126,121,   0.25688890D+03,   0.16483D+01,   0.18627D+01/
  data pars( 34491: 34495) /126,122,   0.24796360D+03,   0.16483D+01,   0.18299D+01/
  data pars( 34496: 34500) /126,123,   0.24301480D+03,   0.16483D+01,   0.19138D+01/
  data pars( 34501: 34505) /126,124,   0.24078340D+03,   0.16483D+01,   0.18269D+01/
  data pars( 34506: 34510) /126,125,   0.22153400D+03,   0.16483D+01,   0.16406D+01/
  data pars( 34511: 34515) /126,126,   0.20499250D+03,   0.16483D+01,   0.16483D+01/
  data pars( 34516: 34520) /127,  1,   0.23231000D+02,   0.17149D+01,   0.91180D+00/
  data pars( 34521: 34525) /127,  2,   0.15354500D+02,   0.17149D+01,   0.00000D+00/
  data pars( 34526: 34530) /127,  3,   0.36237460D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34531: 34535) /127,  4,   0.20922270D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34536: 34540) /127,  5,   0.14074280D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34541: 34545) /127,  6,   0.95005100D+02,   0.17149D+01,   0.00000D+00/
  data pars( 34546: 34550) /127,  7,   0.66421800D+02,   0.17149D+01,   0.00000D+00/
  data pars( 34551: 34555) /127,  8,   0.50301600D+02,   0.17149D+01,   0.00000D+00/
  data pars( 34556: 34560) /127,  9,   0.38131300D+02,   0.17149D+01,   0.00000D+00/
  data pars( 34561: 34565) /127, 10,   0.29359800D+02,   0.17149D+01,   0.00000D+00/
  data pars( 34566: 34570) /127, 11,   0.43337360D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34571: 34575) /127, 12,   0.33347670D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34576: 34580) /127, 13,   0.30725400D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34581: 34585) /127, 14,   0.24191590D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34586: 34590) /127, 15,   0.18848520D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34591: 34595) /127, 16,   0.15634230D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34596: 34600) /127, 17,   0.12765130D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34601: 34605) /127, 18,   0.10440910D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34606: 34610) /127, 19,   0.71018180D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34611: 34615) /127, 20,   0.58595780D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34616: 34620) /127, 21,   0.48407230D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34621: 34625) /127, 22,   0.46739840D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34626: 34630) /127, 23,   0.42799360D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34631: 34635) /127, 24,   0.33714360D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34636: 34640) /127, 25,   0.36847190D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34641: 34645) /127, 26,   0.28919370D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34646: 34650) /127, 27,   0.30649680D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34651: 34655) /127, 28,   0.31577130D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34656: 34660) /127, 29,   0.24210300D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34661: 34665) /127, 30,   0.24848550D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34666: 34670) /127, 31,   0.29424080D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34671: 34675) /127, 32,   0.25932240D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34676: 34680) /127, 33,   0.22102330D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34681: 34685) /127, 34,   0.19822130D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34686: 34690) /127, 35,   0.17337930D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34691: 34695) /127, 36,   0.15071900D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34696: 34700) /127, 37,   0.79588590D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34701: 34705) /127, 38,   0.69807620D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34706: 34710) /127, 39,   0.61134030D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34711: 34715) /127, 40,   0.54932940D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34716: 34720) /127, 41,   0.50083550D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34721: 34725) /127, 42,   0.38652450D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34726: 34730) /127, 43,   0.43134780D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34731: 34735) /127, 44,   0.32850150D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34736: 34740) /127, 45,   0.35910570D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34741: 34745) /127, 46,   0.33298960D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34746: 34750) /127, 47,   0.27768230D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34751: 34755) /127, 48,   0.29340740D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34756: 34760) /127, 49,   0.36832240D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34761: 34765) /127, 50,   0.34042650D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34766: 34770) /127, 51,   0.30318560D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34771: 34775) /127, 52,   0.28116330D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34776: 34780) /127, 53,   0.25408770D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34781: 34785) /127, 54,   0.22832560D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34786: 34790) /127, 55,   0.96954620D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34791: 34795) /127, 56,   0.88993460D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34796: 34800) /127, 57,   0.78163500D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34801: 34805) /127, 58,   0.35816770D+03,   0.17149D+01,   0.27991D+01/
  data pars( 34806: 34810) /127, 59,   0.78858090D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34811: 34815) /127, 60,   0.75717110D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34816: 34820) /127, 61,   0.73817480D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34821: 34825) /127, 62,   0.72070520D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34826: 34830) /127, 63,   0.70521290D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34831: 34835) /127, 64,   0.55434620D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34836: 34840) /127, 65,   0.62444810D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34841: 34845) /127, 66,   0.60226720D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34846: 34850) /127, 67,   0.63603570D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34851: 34855) /127, 68,   0.62253720D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34856: 34860) /127, 69,   0.61036000D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34861: 34865) /127, 70,   0.60323520D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34866: 34870) /127, 71,   0.50816310D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34871: 34875) /127, 72,   0.49947010D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34876: 34880) /127, 73,   0.45568660D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34881: 34885) /127, 74,   0.38467230D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34886: 34890) /127, 75,   0.39131100D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34891: 34895) /127, 76,   0.35455820D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34896: 34900) /127, 77,   0.32464910D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34901: 34905) /127, 78,   0.26963380D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34906: 34910) /127, 79,   0.25191510D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34911: 34915) /127, 80,   0.25913820D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34916: 34920) /127, 81,   0.37809130D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34921: 34925) /127, 82,   0.36955020D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34926: 34930) /127, 83,   0.33939390D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34931: 34935) /127, 84,   0.32357100D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34936: 34940) /127, 85,   0.29847990D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34941: 34945) /127, 86,   0.27345010D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34946: 34950) /127, 87,   0.91516100D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34951: 34955) /127, 88,   0.87983390D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34956: 34960) /127, 89,   0.77761650D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34961: 34965) /127, 90,   0.69856190D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34966: 34970) /127, 91,   0.69371430D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34971: 34975) /127, 92,   0.67170070D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34976: 34980) /127, 93,   0.69179850D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34981: 34985) /127, 94,   0.66991580D+03,   0.17149D+01,   0.00000D+00/
  data pars( 34986: 34990) /127,101,   0.37449600D+02,   0.17149D+01,   0.00000D+00/
  data pars( 34991: 34995) /127,103,   0.12160370D+03,   0.17149D+01,   0.98650D+00/
  data pars( 34996: 35000) /127,104,   0.15505540D+03,   0.17149D+01,   0.98080D+00/
  data pars( 35001: 35005) /127,105,   0.11835300D+03,   0.17149D+01,   0.97060D+00/
  data pars( 35006: 35010) /127,106,   0.89099200D+02,   0.17149D+01,   0.98680D+00/
  data pars( 35011: 35015) /127,107,   0.61925600D+02,   0.17149D+01,   0.99440D+00/
  data pars( 35016: 35020) /127,108,   0.45100200D+02,   0.17149D+01,   0.99250D+00/
  data pars( 35021: 35025) /127,109,   0.31051600D+02,   0.17149D+01,   0.99820D+00/
  data pars( 35026: 35030) /127,111,   0.17783550D+03,   0.17149D+01,   0.96840D+00/
  data pars( 35031: 35035) /127,112,   0.27498400D+03,   0.17149D+01,   0.96280D+00/
  data pars( 35036: 35040) /127,113,   0.27841730D+03,   0.17149D+01,   0.96480D+00/
  data pars( 35041: 35045) /127,114,   0.22355480D+03,   0.17149D+01,   0.95070D+00/
  data pars( 35046: 35050) /127,115,   0.18295110D+03,   0.17149D+01,   0.99470D+00/
  data pars( 35051: 35055) /127,116,   0.15462430D+03,   0.17149D+01,   0.99480D+00/
  data pars( 35056: 35060) /127,117,   0.12633190D+03,   0.17149D+01,   0.99720D+00/
  data pars( 35061: 35065) /127,119,   0.24501880D+03,   0.17149D+01,   0.97670D+00/
  data pars( 35066: 35070) /127,120,   0.46868990D+03,   0.17149D+01,   0.98310D+00/
  data pars( 35071: 35075) /127,121,   0.24500350D+03,   0.17149D+01,   0.18627D+01/
  data pars( 35076: 35080) /127,122,   0.23653250D+03,   0.17149D+01,   0.18299D+01/
  data pars( 35081: 35085) /127,123,   0.23181800D+03,   0.17149D+01,   0.19138D+01/
  data pars( 35086: 35090) /127,124,   0.22970220D+03,   0.17149D+01,   0.18269D+01/
  data pars( 35091: 35095) /127,125,   0.21130250D+03,   0.17149D+01,   0.16406D+01/
  data pars( 35096: 35100) /127,126,   0.19554300D+03,   0.17149D+01,   0.16483D+01/
  data pars( 35101: 35105) /127,127,   0.18654620D+03,   0.17149D+01,   0.17149D+01/
  data pars( 35106: 35110) /128,  1,   0.22682200D+02,   0.17937D+01,   0.91180D+00/
  data pars( 35111: 35115) /128,  2,   0.14983300D+02,   0.17937D+01,   0.00000D+00/
  data pars( 35116: 35120) /128,  3,   0.35596060D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35121: 35125) /128,  4,   0.20490860D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35126: 35130) /128,  5,   0.13762540D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35131: 35135) /128,  6,   0.92810700D+02,   0.17937D+01,   0.00000D+00/
  data pars( 35136: 35140) /128,  7,   0.64851900D+02,   0.17937D+01,   0.00000D+00/
  data pars( 35141: 35145) /128,  8,   0.49099600D+02,   0.17937D+01,   0.00000D+00/
  data pars( 35146: 35150) /128,  9,   0.37215800D+02,   0.17937D+01,   0.00000D+00/
  data pars( 35151: 35155) /128, 10,   0.28655400D+02,   0.17937D+01,   0.00000D+00/
  data pars( 35156: 35160) /128, 11,   0.42564550D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35161: 35165) /128, 12,   0.32678640D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35166: 35170) /128, 13,   0.30082710D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35171: 35175) /128, 14,   0.23659520D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35176: 35180) /128, 15,   0.18418470D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35181: 35185) /128, 16,   0.15270360D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35186: 35190) /128, 17,   0.12463170D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35191: 35195) /128, 18,   0.10191160D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35196: 35200) /128, 19,   0.69776500D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35201: 35205) /128, 20,   0.57475220D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35206: 35210) /128, 21,   0.47462540D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35211: 35215) /128, 22,   0.45811360D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35216: 35220) /128, 23,   0.41940370D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35221: 35225) /128, 24,   0.33038080D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35226: 35230) /128, 25,   0.36096920D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35231: 35235) /128, 26,   0.28330110D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35236: 35240) /128, 27,   0.30010550D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35241: 35245) /128, 28,   0.30925430D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35246: 35250) /128, 29,   0.23712000D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35251: 35255) /128, 30,   0.24319600D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35256: 35260) /128, 31,   0.28800730D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35261: 35265) /128, 32,   0.25361340D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35266: 35270) /128, 33,   0.21600430D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35271: 35275) /128, 34,   0.19364320D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35276: 35280) /128, 35,   0.16931330D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35281: 35285) /128, 36,   0.14714170D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35286: 35290) /128, 37,   0.78184410D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35291: 35295) /128, 38,   0.68477150D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35296: 35300) /128, 39,   0.59926520D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35301: 35305) /128, 40,   0.53824800D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35306: 35310) /128, 41,   0.49059730D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35311: 35315) /128, 42,   0.37845940D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35316: 35320) /128, 43,   0.42241440D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35321: 35325) /128, 44,   0.32155060D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35326: 35330) /128, 45,   0.35149860D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35331: 35335) /128, 46,   0.32588580D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35336: 35340) /128, 47,   0.27180880D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35341: 35345) /128, 48,   0.28709580D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35346: 35350) /128, 49,   0.36057310D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35351: 35355) /128, 50,   0.33303010D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35356: 35360) /128, 51,   0.29640640D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35361: 35365) /128, 52,   0.27477510D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35366: 35370) /128, 53,   0.24822370D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35371: 35375) /128, 54,   0.22298560D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35376: 35380) /128, 55,   0.95234010D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35381: 35385) /128, 56,   0.87316220D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35386: 35390) /128, 57,   0.76636770D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35391: 35395) /128, 58,   0.35020540D+03,   0.17937D+01,   0.27991D+01/
  data pars( 35396: 35400) /128, 59,   0.77355490D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35401: 35405) /128, 60,   0.74267570D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35406: 35410) /128, 61,   0.72402070D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35411: 35415) /128, 62,   0.70686710D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35416: 35420) /128, 63,   0.69165380D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35421: 35425) /128, 64,   0.54327420D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35426: 35430) /128, 65,   0.61263290D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35431: 35435) /128, 66,   0.59076940D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35436: 35440) /128, 67,   0.62369960D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35441: 35445) /128, 68,   0.61045110D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35446: 35450) /128, 69,   0.59849350D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35451: 35455) /128, 70,   0.59152550D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35456: 35460) /128, 71,   0.49802530D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35461: 35465) /128, 72,   0.48915250D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35466: 35470) /128, 73,   0.44609160D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35471: 35475) /128, 74,   0.37646650D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35476: 35480) /128, 75,   0.38290120D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35481: 35485) /128, 76,   0.34682510D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35486: 35490) /128, 77,   0.31748840D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35491: 35495) /128, 78,   0.26363220D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35496: 35500) /128, 79,   0.24629020D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35501: 35505) /128, 80,   0.25331490D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35506: 35510) /128, 81,   0.37009330D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35511: 35515) /128, 82,   0.36153570D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35516: 35520) /128, 83,   0.33183930D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35521: 35525) /128, 84,   0.31626530D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35526: 35530) /128, 85,   0.29163450D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35531: 35535) /128, 86,   0.26709740D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35536: 35540) /128, 87,   0.89847060D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35541: 35545) /128, 88,   0.86294020D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35546: 35550) /128, 89,   0.76220730D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35551: 35555) /128, 90,   0.68424210D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35556: 35560) /128, 91,   0.67974920D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35561: 35565) /128, 92,   0.65817270D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35566: 35570) /128, 93,   0.67818560D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35571: 35575) /128, 94,   0.65668000D+03,   0.17937D+01,   0.00000D+00/
  data pars( 35576: 35580) /128,101,   0.36590100D+02,   0.17937D+01,   0.00000D+00/
  data pars( 35581: 35585) /128,103,   0.11907250D+03,   0.17937D+01,   0.98650D+00/
  data pars( 35586: 35590) /128,104,   0.15177980D+03,   0.17937D+01,   0.98080D+00/
  data pars( 35591: 35595) /128,105,   0.11570000D+03,   0.17937D+01,   0.97060D+00/
  data pars( 35596: 35600) /128,106,   0.87043200D+02,   0.17937D+01,   0.98680D+00/
  data pars( 35601: 35605) /128,107,   0.60460800D+02,   0.17937D+01,   0.99440D+00/
  data pars( 35606: 35610) /128,108,   0.44017300D+02,   0.17937D+01,   0.99250D+00/
  data pars( 35611: 35615) /128,109,   0.30300400D+02,   0.17937D+01,   0.99820D+00/
  data pars( 35616: 35620) /128,111,   0.17420010D+03,   0.17937D+01,   0.96840D+00/
  data pars( 35621: 35625) /128,112,   0.26937790D+03,   0.17937D+01,   0.96280D+00/
  data pars( 35626: 35630) /128,113,   0.27254090D+03,   0.17937D+01,   0.96480D+00/
  data pars( 35631: 35635) /128,114,   0.21860660D+03,   0.17937D+01,   0.95070D+00/
  data pars( 35636: 35640) /128,115,   0.17877350D+03,   0.17937D+01,   0.99470D+00/
  data pars( 35641: 35645) /128,116,   0.15102860D+03,   0.17937D+01,   0.99480D+00/
  data pars( 35646: 35650) /128,117,   0.12334570D+03,   0.17937D+01,   0.99720D+00/
  data pars( 35651: 35655) /128,119,   0.23988490D+03,   0.17937D+01,   0.97670D+00/
  data pars( 35656: 35660) /128,120,   0.45968120D+03,   0.17937D+01,   0.98310D+00/
  data pars( 35661: 35665) /128,121,   0.23965630D+03,   0.17937D+01,   0.18627D+01/
  data pars( 35666: 35670) /128,122,   0.23136310D+03,   0.17937D+01,   0.18299D+01/
  data pars( 35671: 35675) /128,123,   0.22676010D+03,   0.17937D+01,   0.19138D+01/
  data pars( 35676: 35680) /128,124,   0.22471760D+03,   0.17937D+01,   0.18269D+01/
  data pars( 35681: 35685) /128,125,   0.20661260D+03,   0.17937D+01,   0.16406D+01/
  data pars( 35686: 35690) /128,126,   0.19117980D+03,   0.17937D+01,   0.16483D+01/
  data pars( 35691: 35695) /128,127,   0.18238760D+03,   0.17937D+01,   0.17149D+01/
  data pars( 35696: 35700) /128,128,   0.17833110D+03,   0.17937D+01,   0.17937D+01/
  data pars( 35701: 35705) /129,  1,   0.22155000D+02,   0.95760D+00,   0.91180D+00/
  data pars( 35706: 35710) /129,  2,   0.14514700D+02,   0.95760D+00,   0.00000D+00/
  data pars( 35711: 35715) /129,  3,   0.36743080D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35716: 35720) /129,  4,   0.20593130D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35721: 35725) /129,  5,   0.13637050D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35726: 35730) /129,  6,   0.91102500D+02,   0.95760D+00,   0.00000D+00/
  data pars( 35731: 35735) /129,  7,   0.63270900D+02,   0.95760D+00,   0.00000D+00/
  data pars( 35736: 35740) /129,  8,   0.47723900D+02,   0.95760D+00,   0.00000D+00/
  data pars( 35741: 35745) /129,  9,   0.36074900D+02,   0.95760D+00,   0.00000D+00/
  data pars( 35746: 35750) /129, 10,   0.27728200D+02,   0.95760D+00,   0.00000D+00/
  data pars( 35751: 35755) /129, 11,   0.43871980D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35756: 35760) /129, 12,   0.33000180D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35761: 35765) /129, 13,   0.30146500D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35766: 35770) /129, 14,   0.23475480D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35771: 35775) /129, 15,   0.18132670D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35776: 35780) /129, 16,   0.14964210D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35781: 35785) /129, 17,   0.12163290D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35786: 35790) /129, 18,   0.99139800D+02,   0.95760D+00,   0.00000D+00/
  data pars( 35791: 35795) /129, 19,   0.72200020D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35796: 35800) /129, 20,   0.58537040D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35801: 35805) /129, 21,   0.48164720D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35806: 35810) /129, 22,   0.46339240D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35811: 35815) /129, 23,   0.42341930D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35816: 35820) /129, 24,   0.33350140D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35821: 35825) /129, 25,   0.36341710D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35826: 35830) /129, 26,   0.28510180D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35831: 35835) /129, 27,   0.30073560D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35836: 35840) /129, 28,   0.31051330D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35841: 35845) /129, 29,   0.23812070D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35846: 35850) /129, 30,   0.24268930D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35851: 35855) /129, 31,   0.28785200D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35856: 35860) /129, 32,   0.25153860D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35861: 35865) /129, 33,   0.21283460D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35866: 35870) /129, 34,   0.19007710D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35871: 35875) /129, 35,   0.16558600D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35876: 35880) /129, 36,   0.14345250D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35881: 35885) /129, 37,   0.80787860D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35886: 35890) /129, 38,   0.69786230D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35891: 35895) /129, 39,   0.60685850D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35896: 35900) /129, 40,   0.54294990D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35901: 35905) /129, 41,   0.49363630D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35906: 35910) /129, 42,   0.37922990D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35911: 35915) /129, 43,   0.42391540D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35916: 35920) /129, 44,   0.32125020D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35921: 35925) /129, 45,   0.35112220D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35926: 35930) /129, 46,   0.32504660D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35931: 35935) /129, 47,   0.27146340D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35936: 35940) /129, 48,   0.28581800D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35941: 35945) /129, 49,   0.36066260D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35946: 35950) /129, 50,   0.33100630D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35951: 35955) /129, 51,   0.29285890D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35956: 35960) /129, 52,   0.27055260D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35961: 35965) /129, 53,   0.24354750D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35966: 35970) /129, 54,   0.21809290D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35971: 35975) /129, 55,   0.98359160D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35976: 35980) /129, 56,   0.89168850D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35981: 35985) /129, 57,   0.77770700D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35986: 35990) /129, 58,   0.34643740D+03,   0.95760D+00,   0.27991D+01/
  data pars( 35991: 35995) /129, 59,   0.78837610D+03,   0.95760D+00,   0.00000D+00/
  data pars( 35996: 36000) /129, 60,   0.75615770D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36001: 36005) /129, 61,   0.73695090D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36006: 36010) /129, 62,   0.71931180D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36011: 36015) /129, 63,   0.70365920D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36016: 36020) /129, 64,   0.54891190D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36021: 36025) /129, 65,   0.62523960D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36026: 36030) /129, 66,   0.60214160D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36031: 36035) /129, 67,   0.63352600D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36036: 36040) /129, 68,   0.61995970D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36041: 36045) /129, 69,   0.60766330D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36046: 36050) /129, 70,   0.60075720D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36051: 36055) /129, 71,   0.50338410D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36056: 36060) /129, 72,   0.49122120D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36061: 36065) /129, 73,   0.44629550D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36066: 36070) /129, 74,   0.37560840D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36071: 36075) /129, 75,   0.38145840D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36076: 36080) /129, 76,   0.34444290D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36081: 36085) /129, 77,   0.31453250D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36086: 36090) /129, 78,   0.26057850D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36091: 36095) /129, 79,   0.24322040D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36096: 36100) /129, 80,   0.24982310D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36101: 36105) /129, 81,   0.36971340D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36106: 36110) /129, 82,   0.35938220D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36111: 36115) /129, 83,   0.32809610D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36116: 36120) /129, 84,   0.31175430D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36121: 36125) /129, 85,   0.28648030D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36126: 36130) /129, 86,   0.26159230D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36131: 36135) /129, 87,   0.92344480D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36136: 36140) /129, 88,   0.87838880D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36141: 36145) /129, 89,   0.77137100D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36146: 36150) /129, 90,   0.68798510D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36151: 36155) /129, 91,   0.68576140D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36156: 36160) /129, 92,   0.66390850D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36161: 36165) /129, 93,   0.68694090D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36166: 36170) /129, 94,   0.66465810D+03,   0.95760D+00,   0.00000D+00/
  data pars( 36171: 36175) /129,101,   0.35987100D+02,   0.95760D+00,   0.00000D+00/
  data pars( 36176: 36180) /129,103,   0.11943970D+03,   0.95760D+00,   0.98650D+00/
  data pars( 36181: 36185) /129,104,   0.15184260D+03,   0.95760D+00,   0.98080D+00/
  data pars( 36186: 36190) /129,105,   0.11434660D+03,   0.95760D+00,   0.97060D+00/
  data pars( 36191: 36195) /129,106,   0.85473100D+02,   0.95760D+00,   0.98680D+00/
  data pars( 36196: 36200) /129,107,   0.58990300D+02,   0.95760D+00,   0.99440D+00/
  data pars( 36201: 36205) /129,108,   0.42745800D+02,   0.95760D+00,   0.99250D+00/
  data pars( 36206: 36210) /129,109,   0.29280800D+02,   0.95760D+00,   0.99820D+00/
  data pars( 36211: 36215) /129,111,   0.17525310D+03,   0.95760D+00,   0.96840D+00/
  data pars( 36216: 36220) /129,112,   0.27127550D+03,   0.95760D+00,   0.96280D+00/
  data pars( 36221: 36225) /129,113,   0.27263840D+03,   0.95760D+00,   0.96480D+00/
  data pars( 36226: 36230) /129,114,   0.21661540D+03,   0.95760D+00,   0.95070D+00/
  data pars( 36231: 36235) /129,115,   0.17596280D+03,   0.95760D+00,   0.99470D+00/
  data pars( 36236: 36240) /129,116,   0.14802440D+03,   0.95760D+00,   0.99480D+00/
  data pars( 36241: 36245) /129,117,   0.12039270D+03,   0.95760D+00,   0.99720D+00/
  data pars( 36246: 36250) /129,119,   0.24017910D+03,   0.95760D+00,   0.97670D+00/
  data pars( 36251: 36255) /129,120,   0.46791560D+03,   0.95760D+00,   0.98310D+00/
  data pars( 36256: 36260) /129,121,   0.23801280D+03,   0.95760D+00,   0.18627D+01/
  data pars( 36261: 36265) /129,122,   0.22972260D+03,   0.95760D+00,   0.18299D+01/
  data pars( 36266: 36270) /129,123,   0.22520200D+03,   0.95760D+00,   0.19138D+01/
  data pars( 36271: 36275) /129,124,   0.22340090D+03,   0.95760D+00,   0.18269D+01/
  data pars( 36276: 36280) /129,125,   0.20444800D+03,   0.95760D+00,   0.16406D+01/
  data pars( 36281: 36285) /129,126,   0.18894450D+03,   0.95760D+00,   0.16483D+01/
  data pars( 36286: 36290) /129,127,   0.18027190D+03,   0.95760D+00,   0.17149D+01/
  data pars( 36291: 36295) /129,128,   0.17633580D+03,   0.95760D+00,   0.17937D+01/
  data pars( 36296: 36300) /129,129,   0.17499690D+03,   0.95760D+00,   0.95760D+00/
  data pars( 36301: 36305) /130,  1,   0.21213900D+02,   0.19419D+01,   0.91180D+00/
  data pars( 36306: 36310) /130,  2,   0.14118500D+02,   0.19419D+01,   0.00000D+00/
  data pars( 36311: 36315) /130,  3,   0.31788260D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36316: 36320) /130,  4,   0.18730120D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36321: 36325) /130,  5,   0.12724880D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36326: 36330) /130,  6,   0.86470900D+02,   0.19419D+01,   0.00000D+00/
  data pars( 36331: 36335) /130,  7,   0.60733100D+02,   0.19419D+01,   0.00000D+00/
  data pars( 36336: 36340) /130,  8,   0.46135500D+02,   0.19419D+01,   0.00000D+00/
  data pars( 36341: 36345) /130,  9,   0.35062900D+02,   0.19419D+01,   0.00000D+00/
  data pars( 36346: 36350) /130, 10,   0.27052400D+02,   0.19419D+01,   0.00000D+00/
  data pars( 36351: 36355) /130, 11,   0.38065680D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36356: 36360) /130, 12,   0.29754400D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36361: 36365) /130, 13,   0.27562990D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36366: 36370) /130, 14,   0.21852820D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36371: 36375) /130, 15,   0.17118890D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36376: 36380) /130, 16,   0.14245910D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36381: 36385) /130, 17,   0.11666370D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36386: 36390) /130, 18,   0.95658600D+02,   0.19419D+01,   0.00000D+00/
  data pars( 36391: 36395) /130, 19,   0.62148410D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36396: 36400) /130, 20,   0.51951820D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36401: 36405) /130, 21,   0.43036750D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36406: 36410) /130, 22,   0.41653280D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36411: 36415) /130, 23,   0.38196290D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36416: 36420) /130, 24,   0.30093230D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36421: 36425) /130, 25,   0.32951960D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36426: 36430) /130, 26,   0.25872900D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36431: 36435) /130, 27,   0.27503810D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36436: 36440) /130, 28,   0.28296560D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36441: 36445) /130, 29,   0.21695700D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36446: 36450) /130, 30,   0.22366220D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36451: 36455) /130, 31,   0.26447240D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36456: 36460) /130, 32,   0.23434070D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36461: 36465) /130, 33,   0.20064080D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36466: 36470) /130, 34,   0.18041890D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36471: 36475) /130, 35,   0.15822130D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36476: 36480) /130, 36,   0.13785900D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36481: 36485) /130, 37,   0.69720120D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36486: 36490) /130, 38,   0.61859280D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36491: 36495) /130, 39,   0.54431400D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36496: 36500) /130, 40,   0.49050970D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36501: 36505) /130, 41,   0.44803280D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36506: 36510) /130, 42,   0.34683870D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36511: 36515) /130, 43,   0.38662560D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36516: 36520) /130, 44,   0.29543070D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36521: 36525) /130, 45,   0.32298310D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36526: 36530) /130, 46,   0.29983170D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36531: 36535) /130, 47,   0.24983480D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36536: 36540) /130, 48,   0.26457160D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36541: 36545) /130, 49,   0.33095850D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36546: 36550) /130, 50,   0.30726350D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36551: 36555) /130, 51,   0.27478160D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36556: 36560) /130, 52,   0.25542890D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36561: 36565) /130, 53,   0.23140060D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36566: 36570) /130, 54,   0.20840550D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36571: 36575) /130, 55,   0.84934460D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36576: 36580) /130, 56,   0.78727710D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36581: 36585) /130, 57,   0.69479590D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36586: 36590) /130, 58,   0.32433650D+03,   0.19419D+01,   0.27991D+01/
  data pars( 36591: 36595) /130, 59,   0.69872430D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36596: 36600) /130, 60,   0.67147320D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36601: 36605) /130, 61,   0.65477760D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36606: 36610) /130, 62,   0.63940750D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36611: 36615) /130, 63,   0.62578200D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36616: 36620) /130, 64,   0.49442430D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36621: 36625) /130, 65,   0.55258030D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36626: 36630) /130, 66,   0.53339380D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36631: 36635) /130, 67,   0.56508580D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36636: 36640) /130, 68,   0.55316870D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36641: 36645) /130, 69,   0.54245160D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36646: 36650) /130, 70,   0.53600770D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36651: 36655) /130, 71,   0.45307620D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36656: 36660) /130, 72,   0.44744320D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36661: 36665) /130, 73,   0.40933690D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36666: 36670) /130, 74,   0.34623600D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36671: 36675) /130, 75,   0.35258880D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36676: 36680) /130, 76,   0.32019590D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36681: 36685) /130, 77,   0.29371130D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36686: 36690) /130, 78,   0.24437210D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36691: 36695) /130, 79,   0.22847850D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36696: 36700) /130, 80,   0.23524690D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36701: 36705) /130, 81,   0.34006610D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36706: 36710) /130, 82,   0.33355770D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36711: 36715) /130, 83,   0.30748710D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36716: 36720) /130, 84,   0.29376220D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36721: 36725) /130, 85,   0.27163520D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36726: 36730) /130, 86,   0.24938090D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36731: 36735) /130, 87,   0.80499020D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36736: 36740) /130, 88,   0.78026750D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36741: 36745) /130, 89,   0.69268280D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36746: 36750) /130, 90,   0.62529330D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36751: 36755) /130, 91,   0.61943840D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36756: 36760) /130, 92,   0.59985590D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36761: 36765) /130, 93,   0.61596070D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36766: 36770) /130, 94,   0.59681690D+03,   0.19419D+01,   0.00000D+00/
  data pars( 36771: 36775) /130,101,   0.34031200D+02,   0.19419D+01,   0.00000D+00/
  data pars( 36776: 36780) /130,103,   0.10901270D+03,   0.19419D+01,   0.98650D+00/
  data pars( 36781: 36785) /130,104,   0.13924200D+03,   0.19419D+01,   0.98080D+00/
  data pars( 36786: 36790) /130,105,   0.10720260D+03,   0.19419D+01,   0.97060D+00/
  data pars( 36791: 36795) /130,106,   0.81068600D+02,   0.19419D+01,   0.98680D+00/
  data pars( 36796: 36800) /130,107,   0.56614000D+02,   0.19419D+01,   0.99440D+00/
  data pars( 36801: 36805) /130,108,   0.41386200D+02,   0.19419D+01,   0.99250D+00/
  data pars( 36806: 36810) /130,109,   0.28629100D+02,   0.19419D+01,   0.99820D+00/
  data pars( 36811: 36815) /130,111,   0.15912280D+03,   0.19419D+01,   0.96840D+00/
  data pars( 36816: 36820) /130,112,   0.24580540D+03,   0.19419D+01,   0.96280D+00/
  data pars( 36821: 36825) /130,113,   0.25007300D+03,   0.19419D+01,   0.96480D+00/
  data pars( 36826: 36830) /130,114,   0.20213060D+03,   0.19419D+01,   0.95070D+00/
  data pars( 36831: 36835) /130,115,   0.16618870D+03,   0.19419D+01,   0.99470D+00/
  data pars( 36836: 36840) /130,116,   0.14088040D+03,   0.19419D+01,   0.99480D+00/
  data pars( 36841: 36845) /130,117,   0.11545010D+03,   0.19419D+01,   0.99720D+00/
  data pars( 36846: 36850) /130,119,   0.21998520D+03,   0.19419D+01,   0.97670D+00/
  data pars( 36851: 36855) /130,120,   0.41556380D+03,   0.19419D+01,   0.98310D+00/
  data pars( 36856: 36860) /130,121,   0.22124670D+03,   0.19419D+01,   0.18627D+01/
  data pars( 36861: 36865) /130,122,   0.21361910D+03,   0.19419D+01,   0.18299D+01/
  data pars( 36866: 36870) /130,123,   0.20934280D+03,   0.19419D+01,   0.19138D+01/
  data pars( 36871: 36875) /130,124,   0.20729260D+03,   0.19419D+01,   0.18269D+01/
  data pars( 36876: 36880) /130,125,   0.19131250D+03,   0.19419D+01,   0.16406D+01/
  data pars( 36881: 36885) /130,126,   0.17720340D+03,   0.19419D+01,   0.16483D+01/
  data pars( 36886: 36890) /130,127,   0.16904610D+03,   0.19419D+01,   0.17149D+01/
  data pars( 36891: 36895) /130,128,   0.16523610D+03,   0.19419D+01,   0.17937D+01/
  data pars( 36896: 36900) /130,129,   0.16292360D+03,   0.19419D+01,   0.95760D+00/
  data pars( 36901: 36905) /130,130,   0.15345280D+03,   0.19419D+01,   0.19419D+01/
  data pars( 36906: 36910) /131,  1,   0.33251500D+02,   0.96010D+00,   0.91180D+00/
  data pars( 36911: 36915) /131,  2,   0.20987400D+02,   0.96010D+00,   0.00000D+00/
  data pars( 36916: 36920) /131,  3,   0.60281040D+03,   0.96010D+00,   0.00000D+00/
  data pars( 36921: 36925) /131,  4,   0.32666720D+03,   0.96010D+00,   0.00000D+00/
  data pars( 36926: 36930) /131,  5,   0.21127560D+03,   0.96010D+00,   0.00000D+00/
  data pars( 36931: 36935) /131,  6,   0.13814970D+03,   0.96010D+00,   0.00000D+00/
  data pars( 36936: 36940) /131,  7,   0.94132900D+02,   0.96010D+00,   0.00000D+00/
  data pars( 36941: 36945) /131,  8,   0.69903900D+02,   0.96010D+00,   0.00000D+00/
  data pars( 36946: 36950) /131,  9,   0.52047600D+02,   0.96010D+00,   0.00000D+00/
  data pars( 36951: 36955) /131, 10,   0.39458700D+02,   0.96010D+00,   0.00000D+00/
  data pars( 36956: 36960) /131, 11,   0.71775310D+03,   0.96010D+00,   0.00000D+00/
  data pars( 36961: 36965) /131, 12,   0.52642360D+03,   0.96010D+00,   0.00000D+00/
  data pars( 36966: 36970) /131, 13,   0.47573180D+03,   0.96010D+00,   0.00000D+00/
  data pars( 36971: 36975) /131, 14,   0.36461100D+03,   0.96010D+00,   0.00000D+00/
  data pars( 36976: 36980) /131, 15,   0.27735230D+03,   0.96010D+00,   0.00000D+00/
  data pars( 36981: 36985) /131, 16,   0.22627960D+03,   0.96010D+00,   0.00000D+00/
  data pars( 36986: 36990) /131, 17,   0.18171780D+03,   0.96010D+00,   0.00000D+00/
  data pars( 36991: 36995) /131, 18,   0.14638550D+03,   0.96010D+00,   0.00000D+00/
  data pars( 36996: 37000) /131, 19,   0.11848327D+04,   0.96010D+00,   0.00000D+00/
  data pars( 37001: 37005) /131, 20,   0.94258280D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37006: 37010) /131, 21,   0.77197630D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37011: 37015) /131, 22,   0.73902810D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37016: 37020) /131, 23,   0.67328230D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37021: 37025) /131, 24,   0.52900060D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37026: 37030) /131, 25,   0.57532290D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37031: 37035) /131, 26,   0.44990400D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37036: 37040) /131, 27,   0.47264010D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37041: 37045) /131, 28,   0.48954990D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37046: 37050) /131, 29,   0.37425370D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37051: 37055) /131, 30,   0.37873290D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37056: 37060) /131, 31,   0.45140030D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37061: 37065) /131, 32,   0.38973700D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37066: 37070) /131, 33,   0.32572680D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37071: 37075) /131, 34,   0.28839340D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37076: 37080) /131, 35,   0.24882110D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37081: 37085) /131, 36,   0.21348210D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37086: 37090) /131, 37,   0.13227322D+04,   0.96010D+00,   0.00000D+00/
  data pars( 37091: 37095) /131, 38,   0.11239167D+04,   0.96010D+00,   0.00000D+00/
  data pars( 37096: 37100) /131, 39,   0.96907770D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37101: 37105) /131, 40,   0.86203630D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37106: 37110) /131, 41,   0.78048050D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37111: 37115) /131, 42,   0.59457650D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37116: 37120) /131, 43,   0.66676010D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37121: 37125) /131, 44,   0.50051620D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37126: 37130) /131, 45,   0.54783460D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37131: 37135) /131, 46,   0.50566980D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37136: 37140) /131, 47,   0.42174200D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37141: 37145) /131, 48,   0.44286390D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37146: 37150) /131, 49,   0.56415640D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37151: 37155) /131, 50,   0.51303150D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37156: 37160) /131, 51,   0.44930060D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37161: 37165) /131, 52,   0.41227930D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37166: 37170) /131, 53,   0.36821830D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37171: 37175) /131, 54,   0.32708380D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37176: 37180) /131, 55,   0.16098951D+04,   0.96010D+00,   0.00000D+00/
  data pars( 37181: 37185) /131, 56,   0.14393610D+04,   0.96010D+00,   0.00000D+00/
  data pars( 37186: 37190) /131, 57,   0.12450382D+04,   0.96010D+00,   0.00000D+00/
  data pars( 37191: 37195) /131, 58,   0.53206830D+03,   0.96010D+00,   0.27991D+01/
  data pars( 37196: 37200) /131, 59,   0.12682581D+04,   0.96010D+00,   0.00000D+00/
  data pars( 37201: 37205) /131, 60,   0.12147867D+04,   0.96010D+00,   0.00000D+00/
  data pars( 37206: 37210) /131, 61,   0.11834931D+04,   0.96010D+00,   0.00000D+00/
  data pars( 37211: 37215) /131, 62,   0.11548172D+04,   0.96010D+00,   0.00000D+00/
  data pars( 37216: 37220) /131, 63,   0.11293623D+04,   0.96010D+00,   0.00000D+00/
  data pars( 37221: 37225) /131, 64,   0.87169660D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37226: 37230) /131, 65,   0.10061273D+04,   0.96010D+00,   0.00000D+00/
  data pars( 37231: 37235) /131, 66,   0.96741930D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37236: 37240) /131, 67,   0.10147443D+04,   0.96010D+00,   0.00000D+00/
  data pars( 37241: 37245) /131, 68,   0.99283980D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37246: 37250) /131, 69,   0.97287530D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37251: 37255) /131, 70,   0.96226810D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37256: 37260) /131, 71,   0.80056070D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37261: 37265) /131, 72,   0.77479490D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37266: 37270) /131, 73,   0.69954820D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37271: 37275) /131, 74,   0.58500690D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37276: 37280) /131, 75,   0.59290660D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37281: 37285) /131, 76,   0.53219500D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37286: 37290) /131, 77,   0.48350900D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37291: 37295) /131, 78,   0.39773910D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37296: 37300) /131, 79,   0.37015170D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37301: 37305) /131, 80,   0.37970920D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37306: 37310) /131, 81,   0.57562810D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37311: 37315) /131, 82,   0.55583070D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37316: 37320) /131, 83,   0.50298850D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37321: 37325) /131, 84,   0.47531340D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37326: 37330) /131, 85,   0.43366250D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37331: 37335) /131, 86,   0.39318500D+03,   0.96010D+00,   0.00000D+00/
  data pars( 37336: 37340) /131, 87,   0.15014541D+04,   0.96010D+00,   0.00000D+00/
  data pars( 37341: 37345) /131, 88,   0.14115217D+04,   0.96010D+00,   0.00000D+00/
  data pars( 37346: 37350) /131, 89,   0.12297307D+04,   0.96010D+00,   0.00000D+00/
  data pars( 37351: 37355) /131, 90,   0.10857394D+04,   0.96010D+00,   0.00000D+00/
  data pars( 37356: 37360) /131, 91,   0.10865380D+04,   0.96010D+00,   0.00000D+00/
  data pars( 37361: 37365) /131, 92,   0.10514942D+04,   0.96010D+00,   0.00000D+00/
  data pars( 37366: 37370) /131, 93,   0.10941031D+04,   0.96010D+00,   0.00000D+00/
  data pars( 37371: 37375) /131, 94,   0.10575095D+04,   0.96010D+00,   0.00000D+00/
  data pars( 37376: 37380) /131,101,   0.54991900D+02,   0.96010D+00,   0.00000D+00/
  data pars( 37381: 37385) /131,103,   0.18876220D+03,   0.96010D+00,   0.98650D+00/
  data pars( 37386: 37390) /131,104,   0.23890680D+03,   0.96010D+00,   0.98080D+00/
  data pars( 37391: 37395) /131,105,   0.17609760D+03,   0.96010D+00,   0.97060D+00/
  data pars( 37396: 37400) /131,106,   0.12956700D+03,   0.96010D+00,   0.98680D+00/
  data pars( 37401: 37405) /131,107,   0.87664500D+02,   0.96010D+00,   0.99440D+00/
  data pars( 37406: 37410) /131,108,   0.62352200D+02,   0.96010D+00,   0.99250D+00/
  data pars( 37411: 37415) /131,109,   0.41590900D+02,   0.96010D+00,   0.99820D+00/
  data pars( 37416: 37420) /131,111,   0.27751430D+03,   0.96010D+00,   0.96840D+00/
  data pars( 37421: 37425) /131,112,   0.43082970D+03,   0.96010D+00,   0.96280D+00/
  data pars( 37426: 37430) /131,113,   0.42895210D+03,   0.96010D+00,   0.96480D+00/
  data pars( 37431: 37435) /131,114,   0.33552060D+03,   0.96010D+00,   0.95070D+00/
  data pars( 37436: 37440) /131,115,   0.26893700D+03,   0.96010D+00,   0.99470D+00/
  data pars( 37441: 37445) /131,116,   0.22384530D+03,   0.96010D+00,   0.99480D+00/
  data pars( 37446: 37450) /131,117,   0.17986830D+03,   0.96010D+00,   0.99720D+00/
  data pars( 37451: 37455) /131,119,   0.37584950D+03,   0.96010D+00,   0.97670D+00/
  data pars( 37456: 37460) /131,120,   0.75181440D+03,   0.96010D+00,   0.98310D+00/
  data pars( 37461: 37465) /131,121,   0.36854170D+03,   0.96010D+00,   0.18627D+01/
  data pars( 37466: 37470) /131,122,   0.35534980D+03,   0.96010D+00,   0.18299D+01/
  data pars( 37471: 37475) /131,123,   0.34832930D+03,   0.96010D+00,   0.19138D+01/
  data pars( 37476: 37480) /131,124,   0.34597960D+03,   0.96010D+00,   0.18269D+01/
  data pars( 37481: 37485) /131,125,   0.31442440D+03,   0.96010D+00,   0.16406D+01/
  data pars( 37486: 37490) /131,126,   0.28975880D+03,   0.96010D+00,   0.16483D+01/
  data pars( 37491: 37495) /131,127,   0.27631300D+03,   0.96010D+00,   0.17149D+01/
  data pars( 37496: 37500) /131,128,   0.27040230D+03,   0.96010D+00,   0.17937D+01/
  data pars( 37501: 37505) /131,129,   0.26973440D+03,   0.96010D+00,   0.95760D+00/
  data pars( 37506: 37510) /131,130,   0.24870030D+03,   0.96010D+00,   0.19419D+01/
  data pars( 37511: 37515) /131,131,   0.42164970D+03,   0.96010D+00,   0.96010D+00/
  data pars( 37516: 37520) /132,  1,   0.29952700D+02,   0.94340D+00,   0.91180D+00/
  data pars( 37521: 37525) /132,  2,   0.19376100D+02,   0.94340D+00,   0.00000D+00/
  data pars( 37526: 37530) /132,  3,   0.48401650D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37531: 37535) /132,  4,   0.27657170D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37536: 37540) /132,  5,   0.18420550D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37541: 37545) /132,  6,   0.12305740D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37546: 37550) /132,  7,   0.85162100D+02,   0.94340D+00,   0.00000D+00/
  data pars( 37551: 37555) /132,  8,   0.63924500D+02,   0.94340D+00,   0.00000D+00/
  data pars( 37556: 37560) /132,  9,   0.48023300D+02,   0.94340D+00,   0.00000D+00/
  data pars( 37561: 37565) /132, 10,   0.36661500D+02,   0.94340D+00,   0.00000D+00/
  data pars( 37566: 37570) /132, 11,   0.57808820D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37571: 37575) /132, 12,   0.44152390D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37576: 37580) /132, 13,   0.40516110D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37581: 37585) /132, 14,   0.31697000D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37586: 37590) /132, 15,   0.24526830D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37591: 37595) /132, 16,   0.20228630D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37596: 37600) /132, 17,   0.16412660D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37601: 37605) /132, 18,   0.13337940D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37606: 37610) /132, 19,   0.94657560D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37611: 37615) /132, 20,   0.77753610D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37616: 37620) /132, 21,   0.64140640D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37621: 37625) /132, 22,   0.61804010D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37626: 37630) /132, 23,   0.56526390D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37631: 37635) /132, 24,   0.44441960D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37636: 37640) /132, 25,   0.48576480D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37641: 37645) /132, 26,   0.38038530D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37646: 37650) /132, 27,   0.40291460D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37651: 37655) /132, 28,   0.41564390D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37656: 37660) /132, 29,   0.31786240D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37661: 37665) /132, 30,   0.32569280D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37666: 37670) /132, 31,   0.38671290D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37671: 37675) /132, 32,   0.33924040D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37676: 37680) /132, 33,   0.28758470D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37681: 37685) /132, 34,   0.25685170D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37686: 37690) /132, 35,   0.22357440D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37691: 37695) /132, 36,   0.19336340D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37696: 37700) /132, 37,   0.10596044D+04,   0.94340D+00,   0.00000D+00/
  data pars( 37701: 37705) /132, 38,   0.92600250D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37706: 37710) /132, 39,   0.80859910D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37711: 37715) /132, 40,   0.72498050D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37716: 37720) /132, 41,   0.65980390D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37721: 37725) /132, 42,   0.50715030D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37726: 37730) /132, 43,   0.56682940D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37731: 37735) /132, 44,   0.42969960D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37736: 37740) /132, 45,   0.47030780D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37741: 37745) /132, 46,   0.43552680D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37746: 37750) /132, 47,   0.36250760D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37751: 37755) /132, 48,   0.38302040D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37756: 37760) /132, 49,   0.48291150D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37761: 37765) /132, 50,   0.44490480D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37766: 37770) /132, 51,   0.39458220D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37771: 37775) /132, 52,   0.36482430D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37776: 37780) /132, 53,   0.32847500D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37781: 37785) /132, 54,   0.29399660D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37786: 37790) /132, 55,   0.12903249D+04,   0.94340D+00,   0.00000D+00/
  data pars( 37791: 37795) /132, 56,   0.11809729D+04,   0.94340D+00,   0.00000D+00/
  data pars( 37796: 37800) /132, 57,   0.10344900D+04,   0.94340D+00,   0.00000D+00/
  data pars( 37801: 37805) /132, 58,   0.46618800D+03,   0.94340D+00,   0.27991D+01/
  data pars( 37806: 37810) /132, 59,   0.10448624D+04,   0.94340D+00,   0.00000D+00/
  data pars( 37811: 37815) /132, 60,   0.10029138D+04,   0.94340D+00,   0.00000D+00/
  data pars( 37816: 37820) /132, 61,   0.97765230D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37821: 37825) /132, 62,   0.95444310D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37826: 37830) /132, 63,   0.93386150D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37831: 37835) /132, 64,   0.73092270D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37836: 37840) /132, 65,   0.82651040D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37841: 37845) /132, 66,   0.79662990D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37846: 37850) /132, 67,   0.84175260D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37851: 37855) /132, 68,   0.82386870D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37856: 37860) /132, 69,   0.80770310D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37861: 37865) /132, 70,   0.79843800D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37866: 37870) /132, 71,   0.67060970D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37871: 37875) /132, 72,   0.65755650D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37876: 37880) /132, 73,   0.59836780D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37881: 37885) /132, 74,   0.50344310D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37886: 37890) /132, 75,   0.51179750D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37891: 37895) /132, 76,   0.46250420D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37896: 37900) /132, 77,   0.42248760D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37901: 37905) /132, 78,   0.34951600D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37906: 37910) /132, 79,   0.32600720D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37911: 37915) /132, 80,   0.33530450D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37916: 37920) /132, 81,   0.49429340D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37921: 37925) /132, 82,   0.48215480D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37926: 37930) /132, 83,   0.44128680D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37931: 37935) /132, 84,   0.41974070D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37936: 37940) /132, 85,   0.38594190D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37941: 37945) /132, 86,   0.35237490D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37946: 37950) /132, 87,   0.12154454D+04,   0.94340D+00,   0.00000D+00/
  data pars( 37951: 37955) /132, 88,   0.11657107D+04,   0.94340D+00,   0.00000D+00/
  data pars( 37956: 37960) /132, 89,   0.10274859D+04,   0.94340D+00,   0.00000D+00/
  data pars( 37961: 37965) /132, 90,   0.91935170D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37966: 37970) /132, 91,   0.91390230D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37971: 37975) /132, 92,   0.88471530D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37976: 37980) /132, 93,   0.91297050D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37981: 37985) /132, 94,   0.88377800D+03,   0.94340D+00,   0.00000D+00/
  data pars( 37986: 37990) /132,101,   0.48724700D+02,   0.94340D+00,   0.00000D+00/
  data pars( 37991: 37995) /132,103,   0.16045020D+03,   0.94340D+00,   0.98650D+00/
  data pars( 37996: 38000) /132,104,   0.20416900D+03,   0.94340D+00,   0.98080D+00/
  data pars( 38001: 38005) /132,105,   0.15444090D+03,   0.94340D+00,   0.97060D+00/
  data pars( 38006: 38010) /132,106,   0.11534880D+03,   0.94340D+00,   0.98680D+00/
  data pars( 38011: 38015) /132,107,   0.79327800D+02,   0.94340D+00,   0.99440D+00/
  data pars( 38016: 38020) /132,108,   0.57175200D+02,   0.94340D+00,   0.99250D+00/
  data pars( 38021: 38025) /132,109,   0.38758300D+02,   0.94340D+00,   0.99820D+00/
  data pars( 38026: 38030) /132,111,   0.23460480D+03,   0.94340D+00,   0.96840D+00/
  data pars( 38031: 38035) /132,112,   0.36333200D+03,   0.94340D+00,   0.96280D+00/
  data pars( 38036: 38040) /132,113,   0.36665610D+03,   0.94340D+00,   0.96480D+00/
  data pars( 38041: 38045) /132,114,   0.29253350D+03,   0.94340D+00,   0.95070D+00/
  data pars( 38046: 38050) /132,115,   0.23795800D+03,   0.94340D+00,   0.99470D+00/
  data pars( 38051: 38055) /132,116,   0.20005260D+03,   0.94340D+00,   0.99480D+00/
  data pars( 38056: 38060) /132,117,   0.16242060D+03,   0.94340D+00,   0.99720D+00/
  data pars( 38061: 38065) /132,119,   0.32115740D+03,   0.94340D+00,   0.97670D+00/
  data pars( 38066: 38070) /132,120,   0.62067350D+03,   0.94340D+00,   0.98310D+00/
  data pars( 38071: 38075) /132,121,   0.32013420D+03,   0.94340D+00,   0.18627D+01/
  data pars( 38076: 38080) /132,122,   0.30883040D+03,   0.94340D+00,   0.18299D+01/
  data pars( 38081: 38085) /132,123,   0.30262720D+03,   0.94340D+00,   0.19138D+01/
  data pars( 38086: 38090) /132,124,   0.29997060D+03,   0.94340D+00,   0.18269D+01/
  data pars( 38091: 38095) /132,125,   0.27526070D+03,   0.94340D+00,   0.16406D+01/
  data pars( 38096: 38100) /132,126,   0.25437350D+03,   0.94340D+00,   0.16483D+01/
  data pars( 38101: 38105) /132,127,   0.24255720D+03,   0.94340D+00,   0.17149D+01/
  data pars( 38106: 38110) /132,128,   0.23717370D+03,   0.94340D+00,   0.17937D+01/
  data pars( 38111: 38115) /132,129,   0.23483270D+03,   0.94340D+00,   0.95760D+00/
  data pars( 38116: 38120) /132,130,   0.21945080D+03,   0.94340D+00,   0.19419D+01/
  data pars( 38121: 38125) /132,131,   0.36268320D+03,   0.94340D+00,   0.96010D+00/
  data pars( 38126: 38130) /132,132,   0.31685210D+03,   0.94340D+00,   0.94340D+00/
  data pars( 38131: 38135) /133,  1,   0.27357400D+02,   0.98890D+00,   0.91180D+00/
  data pars( 38136: 38140) /133,  2,   0.18081600D+02,   0.98890D+00,   0.00000D+00/
  data pars( 38141: 38145) /133,  3,   0.40634270D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38146: 38150) /133,  4,   0.24075590D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38151: 38155) /133,  5,   0.16396550D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38156: 38160) /133,  6,   0.11142570D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38161: 38165) /133,  7,   0.78113800D+02,   0.98890D+00,   0.00000D+00/
  data pars( 38166: 38170) /133,  8,   0.59176400D+02,   0.98890D+00,   0.00000D+00/
  data pars( 38171: 38175) /133,  9,   0.44807900D+02,   0.98890D+00,   0.00000D+00/
  data pars( 38176: 38180) /133, 10,   0.34422600D+02,   0.98890D+00,   0.00000D+00/
  data pars( 38181: 38185) /133, 11,   0.48646380D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38186: 38190) /133, 12,   0.38183960D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38191: 38195) /133, 13,   0.35437060D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38196: 38200) /133, 14,   0.28148930D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38201: 38205) /133, 15,   0.22071460D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38206: 38210) /133, 16,   0.18364620D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38211: 38215) /133, 17,   0.15027420D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38216: 38220) /133, 18,   0.12303580D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38221: 38225) /133, 19,   0.79363060D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38226: 38230) /133, 20,   0.66532210D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38231: 38235) /133, 21,   0.55149990D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38236: 38240) /133, 22,   0.53402660D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38241: 38245) /133, 23,   0.48982100D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38246: 38250) /133, 24,   0.38565770D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38251: 38255) /133, 25,   0.42268740D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38256: 38260) /133, 26,   0.33163890D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38261: 38265) /133, 27,   0.35300740D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38266: 38270) /133, 28,   0.36305660D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38271: 38275) /133, 29,   0.27805780D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38276: 38280) /133, 30,   0.28717780D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38281: 38285) /133, 31,   0.33996250D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38286: 38290) /133, 32,   0.30168000D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38291: 38295) /133, 33,   0.25852630D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38296: 38300) /133, 34,   0.23250720D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38301: 38305) /133, 35,   0.20384000D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38306: 38310) /133, 36,   0.17747160D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38311: 38315) /133, 37,   0.89049310D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38316: 38320) /133, 38,   0.79208160D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38321: 38325) /133, 39,   0.69780370D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38326: 38330) /133, 40,   0.62921900D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38331: 38335) /133, 41,   0.57490090D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38336: 38340) /133, 42,   0.44507990D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38341: 38345) /133, 43,   0.49610230D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38346: 38350) /133, 44,   0.37904270D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38351: 38355) /133, 45,   0.41454110D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38356: 38360) /133, 46,   0.38481520D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38361: 38365) /133, 47,   0.32022310D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38366: 38370) /133, 48,   0.33948140D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38371: 38375) /133, 49,   0.42470080D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38376: 38380) /133, 50,   0.39481650D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38381: 38385) /133, 51,   0.35342450D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38386: 38390) /133, 52,   0.32867560D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38391: 38395) /133, 53,   0.29780640D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38396: 38400) /133, 54,   0.26817000D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38401: 38405) /133, 55,   0.10853677D+04,   0.98890D+00,   0.00000D+00/
  data pars( 38406: 38410) /133, 56,   0.10077913D+04,   0.98890D+00,   0.00000D+00/
  data pars( 38411: 38415) /133, 57,   0.89047640D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38416: 38420) /133, 58,   0.41703500D+03,   0.98890D+00,   0.27991D+01/
  data pars( 38421: 38425) /133, 59,   0.89428150D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38426: 38430) /133, 60,   0.85952480D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38431: 38435) /133, 61,   0.83818370D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38436: 38440) /133, 62,   0.81853810D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38441: 38445) /133, 63,   0.80112860D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38446: 38450) /133, 64,   0.63358090D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38451: 38455) /133, 65,   0.70687070D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38456: 38460) /133, 66,   0.68251260D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38461: 38465) /133, 67,   0.72360130D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38466: 38470) /133, 68,   0.70836530D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38471: 38475) /133, 69,   0.69468070D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38476: 38480) /133, 70,   0.68640110D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38481: 38485) /133, 71,   0.58061170D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38486: 38490) /133, 72,   0.57440900D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38491: 38495) /133, 73,   0.52573750D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38496: 38500) /133, 74,   0.44464860D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38501: 38505) /133, 75,   0.45291770D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38506: 38510) /133, 76,   0.41136690D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38511: 38515) /133, 77,   0.37733280D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38516: 38520) /133, 78,   0.31370400D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38521: 38525) /133, 79,   0.29316560D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38526: 38530) /133, 80,   0.30197230D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38531: 38535) /133, 81,   0.43615840D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38536: 38540) /133, 82,   0.42826390D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38541: 38545) /133, 83,   0.39514950D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38546: 38550) /133, 84,   0.37768730D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38551: 38555) /133, 85,   0.34934070D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38556: 38560) /133, 86,   0.32071970D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38561: 38565) /133, 87,   0.10295399D+04,   0.98890D+00,   0.00000D+00/
  data pars( 38566: 38570) /133, 88,   0.99943950D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38571: 38575) /133, 89,   0.88791120D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38576: 38580) /133, 90,   0.80215530D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38581: 38585) /133, 91,   0.79394730D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38586: 38590) /133, 92,   0.76878210D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38591: 38595) /133, 93,   0.78864020D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38596: 38600) /133, 94,   0.76421100D+03,   0.98890D+00,   0.00000D+00/
  data pars( 38601: 38605) /133,101,   0.43906700D+02,   0.98890D+00,   0.00000D+00/
  data pars( 38606: 38610) /133,103,   0.14013530D+03,   0.98890D+00,   0.98650D+00/
  data pars( 38611: 38615) /133,104,   0.17913900D+03,   0.98890D+00,   0.98080D+00/
  data pars( 38616: 38620) /133,105,   0.13814460D+03,   0.98890D+00,   0.97060D+00/
  data pars( 38621: 38625) /133,106,   0.10445320D+03,   0.98890D+00,   0.98680D+00/
  data pars( 38626: 38630) /133,107,   0.72807300D+02,   0.98890D+00,   0.99440D+00/
  data pars( 38631: 38635) /133,108,   0.53064500D+02,   0.98890D+00,   0.99250D+00/
  data pars( 38636: 38640) /133,109,   0.36472800D+02,   0.98890D+00,   0.99820D+00/
  data pars( 38641: 38645) /133,111,   0.20419370D+03,   0.98890D+00,   0.96840D+00/
  data pars( 38646: 38650) /133,112,   0.31566880D+03,   0.98890D+00,   0.96280D+00/
  data pars( 38651: 38655) /133,113,   0.32160430D+03,   0.98890D+00,   0.96480D+00/
  data pars( 38656: 38660) /133,114,   0.26040440D+03,   0.98890D+00,   0.95070D+00/
  data pars( 38661: 38665) /133,115,   0.21425140D+03,   0.98890D+00,   0.99470D+00/
  data pars( 38666: 38670) /133,116,   0.18159050D+03,   0.98890D+00,   0.99480D+00/
  data pars( 38671: 38675) /133,117,   0.14869430D+03,   0.98890D+00,   0.99720D+00/
  data pars( 38676: 38680) /133,119,   0.28230700D+03,   0.98890D+00,   0.97670D+00/
  data pars( 38681: 38685) /133,120,   0.53224610D+03,   0.98890D+00,   0.98310D+00/
  data pars( 38686: 38690) /133,121,   0.28445160D+03,   0.98890D+00,   0.18627D+01/
  data pars( 38691: 38695) /133,122,   0.27459290D+03,   0.98890D+00,   0.18299D+01/
  data pars( 38696: 38700) /133,123,   0.26902700D+03,   0.98890D+00,   0.19138D+01/
  data pars( 38701: 38705) /133,124,   0.26629390D+03,   0.98890D+00,   0.18269D+01/
  data pars( 38706: 38710) /133,125,   0.24597130D+03,   0.98890D+00,   0.16406D+01/
  data pars( 38711: 38715) /133,126,   0.22781130D+03,   0.98890D+00,   0.16483D+01/
  data pars( 38716: 38720) /133,127,   0.21726350D+03,   0.98890D+00,   0.17149D+01/
  data pars( 38721: 38725) /133,128,   0.21232210D+03,   0.98890D+00,   0.17937D+01/
  data pars( 38726: 38730) /133,129,   0.20913220D+03,   0.98890D+00,   0.95760D+00/
  data pars( 38731: 38735) /133,130,   0.19727710D+03,   0.98890D+00,   0.19419D+01/
  data pars( 38736: 38740) /133,131,   0.31978710D+03,   0.98890D+00,   0.96010D+00/
  data pars( 38741: 38745) /133,132,   0.28257170D+03,   0.98890D+00,   0.94340D+00/
  data pars( 38746: 38750) /133,133,   0.25419240D+03,   0.98890D+00,   0.98890D+00/
  data pars( 38751: 38755) /134,  1,   0.25314900D+02,   0.99010D+00,   0.91180D+00/
  data pars( 38756: 38760) /134,  2,   0.17028000D+02,   0.99010D+00,   0.00000D+00/
  data pars( 38761: 38765) /134,  3,   0.35504500D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38766: 38770) /134,  4,   0.21516710D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38771: 38775) /134,  5,   0.14885900D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38776: 38780) /134,  6,   0.10246200D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38781: 38785) /134,  7,   0.72556700D+02,   0.99010D+00,   0.00000D+00/
  data pars( 38786: 38790) /134,  8,   0.55375200D+02,   0.99010D+00,   0.00000D+00/
  data pars( 38791: 38795) /134,  9,   0.42202700D+02,   0.99010D+00,   0.00000D+00/
  data pars( 38796: 38800) /134, 10,   0.32593500D+02,   0.99010D+00,   0.00000D+00/
  data pars( 38801: 38805) /134, 11,   0.42577330D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38806: 38810) /134, 12,   0.33984270D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38811: 38815) /134, 13,   0.31781330D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38816: 38820) /134, 14,   0.25511530D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38821: 38825) /134, 15,   0.20196030D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38826: 38830) /134, 16,   0.16917120D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38831: 38835) /134, 17,   0.13934530D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38836: 38840) /134, 18,   0.11476770D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38841: 38845) /134, 19,   0.69398180D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38846: 38850) /134, 20,   0.58857630D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38851: 38855) /134, 21,   0.48933050D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38856: 38860) /134, 22,   0.47544530D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38861: 38865) /134, 23,   0.43692930D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38866: 38870) /134, 24,   0.34458580D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38871: 38875) /134, 25,   0.37811330D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38876: 38880) /134, 26,   0.29726970D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38881: 38885) /134, 27,   0.31722330D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38886: 38890) /134, 28,   0.32556670D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38891: 38895) /134, 29,   0.24982100D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38896: 38900) /134, 30,   0.25919160D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38901: 38905) /134, 31,   0.30612750D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38906: 38910) /134, 32,   0.27376800D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38911: 38915) /134, 33,   0.23642060D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38916: 38920) /134, 34,   0.21372980D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38921: 38925) /134, 35,   0.18840310D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38926: 38930) /134, 36,   0.16488330D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38931: 38935) /134, 37,   0.78009860D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38936: 38940) /134, 38,   0.70080150D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38941: 38945) /134, 39,   0.62089180D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38946: 38950) /134, 40,   0.56200010D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38951: 38955) /134, 41,   0.51489450D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38956: 38960) /134, 42,   0.40077220D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38961: 38965) /134, 43,   0.44579160D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38966: 38970) /134, 44,   0.34259700D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38971: 38975) /134, 45,   0.37429000D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38976: 38980) /134, 46,   0.34804020D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38981: 38985) /134, 47,   0.28983280D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38986: 38990) /134, 48,   0.30772140D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38991: 38995) /134, 49,   0.38283810D+03,   0.99010D+00,   0.00000D+00/
  data pars( 38996: 39000) /134, 50,   0.35796090D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39001: 39005) /134, 51,   0.32248120D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39006: 39010) /134, 52,   0.30115060D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39011: 39015) /134, 53,   0.27413770D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39016: 39020) /134, 54,   0.24798670D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39021: 39025) /134, 55,   0.95163050D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39026: 39030) /134, 56,   0.89062640D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39031: 39035) /134, 57,   0.79124710D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39036: 39040) /134, 58,   0.38031600D+03,   0.99010D+00,   0.27991D+01/
  data pars( 39041: 39045) /134, 59,   0.79188170D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39046: 39050) /134, 60,   0.76169980D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39051: 39055) /134, 61,   0.74294350D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39056: 39060) /134, 62,   0.72565360D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39061: 39065) /134, 63,   0.71033760D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39066: 39070) /134, 64,   0.56579140D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39071: 39075) /134, 65,   0.62617050D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39076: 39080) /134, 66,   0.60528280D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39081: 39085) /134, 67,   0.64237950D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39086: 39090) /134, 68,   0.62891080D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39091: 39095) /134, 69,   0.61686660D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39096: 39100) /134, 70,   0.60931460D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39101: 39105) /134, 71,   0.51790690D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39106: 39110) /134, 72,   0.51523880D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39111: 39115) /134, 73,   0.47346190D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39116: 39120) /134, 74,   0.40207780D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39121: 39125) /134, 75,   0.41003520D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39126: 39130) /134, 76,   0.37374220D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39131: 39135) /134, 77,   0.34383760D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39136: 39140) /134, 78,   0.28699450D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39141: 39145) /134, 79,   0.26861450D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39146: 39150) /134, 80,   0.27687780D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39151: 39155) /134, 81,   0.39433850D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39156: 39160) /134, 82,   0.38873570D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39161: 39165) /134, 83,   0.36061850D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39166: 39170) /134, 84,   0.34584750D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39171: 39175) /134, 85,   0.32125280D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39176: 39180) /134, 86,   0.29613640D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39181: 39185) /134, 87,   0.90670650D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39186: 39190) /134, 88,   0.88597380D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39191: 39195) /134, 89,   0.79097170D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39196: 39200) /134, 90,   0.71920180D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39201: 39205) /134, 91,   0.71002990D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39206: 39210) /134, 92,   0.68765590D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39211: 39215) /134, 93,   0.70268800D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39216: 39220) /134, 94,   0.68135890D+03,   0.99010D+00,   0.00000D+00/
  data pars( 39221: 39225) /134,101,   0.40211700D+02,   0.99010D+00,   0.00000D+00/
  data pars( 39226: 39230) /134,103,   0.12555640D+03,   0.99010D+00,   0.98650D+00/
  data pars( 39231: 39235) /134,104,   0.16106370D+03,   0.99010D+00,   0.98080D+00/
  data pars( 39236: 39240) /134,105,   0.12588880D+03,   0.99010D+00,   0.97060D+00/
  data pars( 39241: 39245) /134,106,   0.96087200D+02,   0.99010D+00,   0.98680D+00/
  data pars( 39246: 39250) /134,107,   0.67679600D+02,   0.99010D+00,   0.99440D+00/
  data pars( 39251: 39255) /134,108,   0.49766500D+02,   0.99010D+00,   0.99250D+00/
  data pars( 39256: 39260) /134,109,   0.34588200D+02,   0.99010D+00,   0.99820D+00/
  data pars( 39261: 39265) /134,111,   0.18260620D+03,   0.99010D+00,   0.96840D+00/
  data pars( 39266: 39270) /134,112,   0.28192490D+03,   0.99010D+00,   0.96280D+00/
  data pars( 39271: 39275) /134,113,   0.28901630D+03,   0.99010D+00,   0.96480D+00/
  data pars( 39276: 39280) /134,114,   0.23642530D+03,   0.99010D+00,   0.95070D+00/
  data pars( 39281: 39285) /134,115,   0.19613740D+03,   0.99010D+00,   0.99470D+00/
  data pars( 39286: 39290) /134,116,   0.16726720D+03,   0.99010D+00,   0.99480D+00/
  data pars( 39291: 39295) /134,117,   0.13787350D+03,   0.99010D+00,   0.99720D+00/
  data pars( 39296: 39300) /134,119,   0.25453760D+03,   0.99010D+00,   0.97670D+00/
  data pars( 39301: 39305) /134,120,   0.47198210D+03,   0.99010D+00,   0.98310D+00/
  data pars( 39306: 39310) /134,121,   0.25812950D+03,   0.99010D+00,   0.18627D+01/
  data pars( 39311: 39315) /134,122,   0.24934370D+03,   0.99010D+00,   0.18299D+01/
  data pars( 39316: 39320) /134,123,   0.24427270D+03,   0.99010D+00,   0.19138D+01/
  data pars( 39321: 39325) /134,124,   0.24158030D+03,   0.99010D+00,   0.18269D+01/
  data pars( 39326: 39330) /134,125,   0.22407570D+03,   0.99010D+00,   0.16406D+01/
  data pars( 39331: 39335) /134,126,   0.20787480D+03,   0.99010D+00,   0.16483D+01/
  data pars( 39336: 39340) /134,127,   0.19829930D+03,   0.99010D+00,   0.17149D+01/
  data pars( 39341: 39345) /134,128,   0.19372130D+03,   0.99010D+00,   0.17937D+01/
  data pars( 39346: 39350) /134,129,   0.19016850D+03,   0.99010D+00,   0.95760D+00/
  data pars( 39351: 39355) /134,130,   0.18048120D+03,   0.99010D+00,   0.19419D+01/
  data pars( 39356: 39360) /134,131,   0.28854930D+03,   0.99010D+00,   0.96010D+00/
  data pars( 39361: 39365) /134,132,   0.25695230D+03,   0.99010D+00,   0.94340D+00/
  data pars( 39366: 39370) /134,133,   0.23257840D+03,   0.99010D+00,   0.98890D+00/
  data pars( 39371: 39375) /134,134,   0.21378620D+03,   0.99010D+00,   0.99010D+00/
  data pars( 39376: 39380) /135,  1,   0.22623000D+02,   0.99740D+00,   0.91180D+00/
  data pars( 39381: 39385) /135,  2,   0.15538700D+02,   0.99740D+00,   0.00000D+00/
  data pars( 39386: 39390) /135,  3,   0.29768350D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39391: 39395) /135,  4,   0.18488320D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39396: 39400) /135,  5,   0.13018810D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39401: 39405) /135,  6,   0.90934300D+02,   0.99740D+00,   0.00000D+00/
  data pars( 39406: 39410) /135,  7,   0.65154300D+02,   0.99740D+00,   0.00000D+00/
  data pars( 39411: 39415) /135,  8,   0.50163200D+02,   0.99740D+00,   0.00000D+00/
  data pars( 39416: 39420) /135,  9,   0.38529400D+02,   0.99740D+00,   0.00000D+00/
  data pars( 39421: 39425) /135, 10,   0.29950100D+02,   0.99740D+00,   0.00000D+00/
  data pars( 39426: 39430) /135, 11,   0.35772460D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39431: 39435) /135, 12,   0.29072760D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39436: 39440) /135, 13,   0.27418940D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39441: 39445) /135, 14,   0.22268120D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39446: 39450) /135, 15,   0.17819840D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39451: 39455) /135, 16,   0.15042030D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39456: 39460) /135, 17,   0.12484950D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39461: 39465) /135, 18,   0.10354670D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39466: 39470) /135, 19,   0.58289140D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39471: 39475) /135, 20,   0.50041520D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39476: 39480) /135, 21,   0.41736480D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39481: 39485) /135, 22,   0.40709700D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39486: 39490) /135, 23,   0.37492830D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39491: 39495) /135, 24,   0.29636070D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39496: 39500) /135, 25,   0.32549450D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39501: 39505) /135, 26,   0.25659390D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39506: 39510) /135, 27,   0.27446200D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39511: 39515) /135, 28,   0.28101540D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39516: 39520) /135, 29,   0.21621400D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39521: 39525) /135, 30,   0.22534570D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39526: 39530) /135, 31,   0.26539390D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39531: 39535) /135, 32,   0.23936360D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39536: 39540) /135, 33,   0.20849570D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39541: 39545) /135, 34,   0.18959740D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39546: 39550) /135, 35,   0.16817910D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39551: 39555) /135, 36,   0.14806890D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39556: 39560) /135, 37,   0.65665740D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39561: 39565) /135, 38,   0.59602140D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39566: 39570) /135, 39,   0.53134260D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39571: 39575) /135, 40,   0.48298730D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39576: 39580) /135, 41,   0.44388480D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39581: 39585) /135, 42,   0.34768000D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39586: 39590) /135, 43,   0.38579860D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39591: 39595) /135, 44,   0.29851740D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39596: 39600) /135, 45,   0.32566500D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39601: 39605) /135, 46,   0.30341070D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39606: 39610) /135, 47,   0.25300950D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39611: 39615) /135, 48,   0.26894910D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39616: 39620) /135, 49,   0.33247910D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39621: 39625) /135, 50,   0.31279940D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39626: 39630) /135, 51,   0.28377610D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39631: 39635) /135, 52,   0.26623860D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39636: 39640) /135, 53,   0.24362960D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39641: 39645) /135, 54,   0.22153670D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39646: 39650) /135, 55,   0.80186140D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39651: 39655) /135, 56,   0.75662710D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39656: 39660) /135, 57,   0.67619300D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39661: 39665) /135, 58,   0.33452620D+03,   0.99740D+00,   0.27991D+01/
  data pars( 39666: 39670) /135, 59,   0.67428760D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39671: 39675) /135, 60,   0.64912820D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39676: 39680) /135, 61,   0.63328350D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39681: 39685) /135, 62,   0.61865400D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39686: 39690) /135, 63,   0.60569940D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39691: 39695) /135, 64,   0.48634440D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39696: 39700) /135, 65,   0.53364850D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39701: 39705) /135, 66,   0.51649050D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39706: 39710) /135, 67,   0.54846290D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39711: 39715) /135, 68,   0.53700790D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39716: 39720) /135, 69,   0.52681470D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39721: 39725) /135, 70,   0.52016740D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39726: 39730) /135, 71,   0.44455160D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39731: 39735) /135, 72,   0.44488510D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39736: 39740) /135, 73,   0.41064300D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39741: 39745) /135, 74,   0.35042340D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39746: 39750) /135, 75,   0.35779320D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39751: 39755) /135, 76,   0.32743170D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39756: 39760) /135, 77,   0.30224750D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39761: 39765) /135, 78,   0.25348160D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39766: 39770) /135, 79,   0.23768320D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39771: 39775) /135, 80,   0.24514110D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39776: 39780) /135, 81,   0.34374040D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39781: 39785) /135, 82,   0.34024220D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39786: 39790) /135, 83,   0.31748380D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39791: 39795) /135, 84,   0.30560970D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39796: 39800) /135, 85,   0.28522290D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39801: 39805) /135, 86,   0.26413340D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39806: 39810) /135, 87,   0.76779060D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39811: 39815) /135, 88,   0.75526170D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39816: 39820) /135, 89,   0.67787670D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39821: 39825) /135, 90,   0.62082600D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39826: 39830) /135, 91,   0.61130750D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39831: 39835) /135, 92,   0.59218710D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39836: 39840) /135, 93,   0.60258350D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39841: 39845) /135, 94,   0.58469980D+03,   0.99740D+00,   0.00000D+00/
  data pars( 39846: 39850) /135,101,   0.35512300D+02,   0.99740D+00,   0.00000D+00/
  data pars( 39851: 39855) /135,103,   0.10820480D+03,   0.99740D+00,   0.98650D+00/
  data pars( 39856: 39860) /135,104,   0.13936170D+03,   0.99740D+00,   0.98080D+00/
  data pars( 39861: 39865) /135,105,   0.11058020D+03,   0.99740D+00,   0.97060D+00/
  data pars( 39866: 39870) /135,106,   0.85326500D+02,   0.99740D+00,   0.98680D+00/
  data pars( 39871: 39875) /135,107,   0.60835900D+02,   0.99740D+00,   0.99440D+00/
  data pars( 39876: 39880) /135,108,   0.45201900D+02,   0.99740D+00,   0.99250D+00/
  data pars( 39881: 39885) /135,109,   0.31831300D+02,   0.99740D+00,   0.99820D+00/
  data pars( 39886: 39890) /135,111,   0.15710050D+03,   0.99740D+00,   0.96840D+00/
  data pars( 39891: 39895) /135,112,   0.24214760D+03,   0.99740D+00,   0.96280D+00/
  data pars( 39896: 39900) /135,113,   0.24992480D+03,   0.99740D+00,   0.96480D+00/
  data pars( 39901: 39905) /135,114,   0.20678800D+03,   0.99740D+00,   0.95070D+00/
  data pars( 39906: 39910) /135,115,   0.17315820D+03,   0.99740D+00,   0.99470D+00/
  data pars( 39911: 39915) /135,116,   0.14872190D+03,   0.99740D+00,   0.99480D+00/
  data pars( 39916: 39920) /135,117,   0.12352740D+03,   0.99740D+00,   0.99720D+00/
  data pars( 39921: 39925) /135,119,   0.22116420D+03,   0.99740D+00,   0.97670D+00/
  data pars( 39926: 39930) /135,120,   0.40253800D+03,   0.99740D+00,   0.98310D+00/
  data pars( 39931: 39935) /135,121,   0.22577840D+03,   0.99740D+00,   0.18627D+01/
  data pars( 39936: 39940) /135,122,   0.21827110D+03,   0.99740D+00,   0.18299D+01/
  data pars( 39941: 39945) /135,123,   0.21382760D+03,   0.99740D+00,   0.19138D+01/
  data pars( 39946: 39950) /135,124,   0.21128090D+03,   0.99740D+00,   0.18269D+01/
  data pars( 39951: 39955) /135,125,   0.19683950D+03,   0.99740D+00,   0.16406D+01/
  data pars( 39956: 39960) /135,126,   0.18295500D+03,   0.99740D+00,   0.16483D+01/
  data pars( 39961: 39965) /135,127,   0.17459100D+03,   0.99740D+00,   0.17149D+01/
  data pars( 39966: 39970) /135,128,   0.17050040D+03,   0.99740D+00,   0.17937D+01/
  data pars( 39971: 39975) /135,129,   0.16678160D+03,   0.99740D+00,   0.95760D+00/
  data pars( 39976: 39980) /135,130,   0.15930490D+03,   0.99740D+00,   0.19419D+01/
  data pars( 39981: 39985) /135,131,   0.25072470D+03,   0.99740D+00,   0.96010D+00/
  data pars( 39986: 39990) /135,132,   0.22517920D+03,   0.99740D+00,   0.94340D+00/
  data pars( 39991: 39995) /135,133,   0.20523050D+03,   0.99740D+00,   0.98890D+00/
  data pars( 39996: 40000) /135,134,   0.18964080D+03,   0.99740D+00,   0.99010D+00/
  data pars( 40001: 40005) /135,135,   0.16923750D+03,   0.99740D+00,   0.99740D+00/
  data pars( 40006: 40010) /137,  1,   0.35196300D+02,   0.97380D+00,   0.91180D+00/
  data pars( 40011: 40015) /137,  2,   0.22623100D+02,   0.97380D+00,   0.00000D+00/
  data pars( 40016: 40020) /137,  3,   0.65740760D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40021: 40025) /137,  4,   0.34543780D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40026: 40030) /137,  5,   0.22250810D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40031: 40035) /137,  6,   0.14599740D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40036: 40040) /137,  7,   0.10014180D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40041: 40045) /137,  8,   0.74886800D+02,   0.97380D+00,   0.00000D+00/
  data pars( 40046: 40050) /137,  9,   0.56177900D+02,   0.97380D+00,   0.00000D+00/
  data pars( 40051: 40055) /137, 10,   0.42895700D+02,   0.97380D+00,   0.00000D+00/
  data pars( 40056: 40060) /137, 11,   0.78185270D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40061: 40065) /137, 12,   0.55913370D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40066: 40070) /137, 13,   0.50299330D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40071: 40075) /137, 14,   0.38390840D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40076: 40080) /137, 15,   0.29216040D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40081: 40085) /137, 16,   0.23905720D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40086: 40090) /137, 17,   0.19278770D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40091: 40095) /137, 18,   0.15610100D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40096: 40100) /137, 19,   0.13058840D+04,   0.97380D+00,   0.00000D+00/
  data pars( 40101: 40105) /137, 20,   0.10130706D+04,   0.97380D+00,   0.00000D+00/
  data pars( 40106: 40110) /137, 21,   0.82610410D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40111: 40115) /137, 22,   0.78941170D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40116: 40120) /137, 23,   0.71821250D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40121: 40125) /137, 24,   0.56618560D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40126: 40130) /137, 25,   0.61264440D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40131: 40135) /137, 26,   0.48062360D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40136: 40140) /137, 27,   0.50159400D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40141: 40145) /137, 28,   0.51998260D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40146: 40150) /137, 29,   0.39935340D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40151: 40155) /137, 30,   0.40105480D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40156: 40160) /137, 31,   0.47797370D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40161: 40165) /137, 32,   0.41103890D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40166: 40170) /137, 33,   0.34339780D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40171: 40175) /137, 34,   0.30453120D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40176: 40180) /137, 35,   0.26345920D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40181: 40185) /137, 36,   0.22685900D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40186: 40190) /137, 37,   0.14577817D+04,   0.97380D+00,   0.00000D+00/
  data pars( 40191: 40195) /137, 38,   0.12108108D+04,   0.97380D+00,   0.00000D+00/
  data pars( 40196: 40200) /137, 39,   0.10374434D+04,   0.97380D+00,   0.00000D+00/
  data pars( 40201: 40205) /137, 40,   0.92013580D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40206: 40210) /137, 41,   0.83213680D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40211: 40215) /137, 42,   0.63394710D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40216: 40220) /137, 43,   0.71077790D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40221: 40225) /137, 44,   0.53361350D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40226: 40230) /137, 45,   0.58237420D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40231: 40235) /137, 46,   0.53725650D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40236: 40240) /137, 47,   0.45047140D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40241: 40245) /137, 48,   0.47031190D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40246: 40250) /137, 49,   0.59989870D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40251: 40255) /137, 50,   0.54287770D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40256: 40260) /137, 51,   0.47456410D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40261: 40265) /137, 52,   0.43555550D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40266: 40270) /137, 53,   0.38946840D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40271: 40275) /137, 54,   0.34667910D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40276: 40280) /137, 55,   0.17768880D+04,   0.97380D+00,   0.00000D+00/
  data pars( 40281: 40285) /137, 56,   0.15569958D+04,   0.97380D+00,   0.00000D+00/
  data pars( 40286: 40290) /137, 57,   0.13375010D+04,   0.97380D+00,   0.00000D+00/
  data pars( 40291: 40295) /137, 58,   0.56314800D+03,   0.97380D+00,   0.27991D+01/
  data pars( 40296: 40300) /137, 59,   0.13695245D+04,   0.97380D+00,   0.00000D+00/
  data pars( 40301: 40305) /137, 60,   0.13097014D+04,   0.97380D+00,   0.00000D+00/
  data pars( 40306: 40310) /137, 61,   0.12753968D+04,   0.97380D+00,   0.00000D+00/
  data pars( 40311: 40315) /137, 62,   0.12439950D+04,   0.97380D+00,   0.00000D+00/
  data pars( 40316: 40320) /137, 63,   0.12161018D+04,   0.97380D+00,   0.00000D+00/
  data pars( 40321: 40325) /137, 64,   0.93460820D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40326: 40330) /137, 65,   0.10930934D+04,   0.97380D+00,   0.00000D+00/
  data pars( 40331: 40335) /137, 66,   0.10500925D+04,   0.97380D+00,   0.00000D+00/
  data pars( 40336: 40340) /137, 67,   0.10903500D+04,   0.97380D+00,   0.00000D+00/
  data pars( 40341: 40345) /137, 68,   0.10664469D+04,   0.97380D+00,   0.00000D+00/
  data pars( 40346: 40350) /137, 69,   0.10446045D+04,   0.97380D+00,   0.00000D+00/
  data pars( 40351: 40355) /137, 70,   0.10333196D+04,   0.97380D+00,   0.00000D+00/
  data pars( 40356: 40360) /137, 71,   0.85724780D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40361: 40365) /137, 72,   0.82420500D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40366: 40370) /137, 73,   0.74273970D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40371: 40375) /137, 74,   0.62209770D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40376: 40380) /137, 75,   0.62947280D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40381: 40385) /137, 76,   0.56455160D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40386: 40390) /137, 77,   0.51279660D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40391: 40395) /137, 78,   0.42290190D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40396: 40400) /137, 79,   0.39392880D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40401: 40405) /137, 80,   0.40326450D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40406: 40410) /137, 81,   0.61404690D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40411: 40415) /137, 82,   0.58982750D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40416: 40420) /137, 83,   0.53239070D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40421: 40425) /137, 84,   0.50286730D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40426: 40430) /137, 85,   0.45900050D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40431: 40435) /137, 86,   0.41673210D+03,   0.97380D+00,   0.00000D+00/
  data pars( 40436: 40440) /137, 87,   0.16476456D+04,   0.97380D+00,   0.00000D+00/
  data pars( 40441: 40445) /137, 88,   0.15223656D+04,   0.97380D+00,   0.00000D+00/
  data pars( 40446: 40450) /137, 89,   0.13176426D+04,   0.97380D+00,   0.00000D+00/
  data pars( 40451: 40455) /137, 90,   0.11578649D+04,   0.97380D+00,   0.00000D+00/
  data pars( 40456: 40460) /137, 91,   0.11634976D+04,   0.97380D+00,   0.00000D+00/
  data pars( 40461: 40465) /137, 92,   0.11259076D+04,   0.97380D+00,   0.00000D+00/
  data pars( 40466: 40470) /137, 93,   0.11753584D+04,   0.97380D+00,   0.00000D+00/
  data pars( 40471: 40475) /137, 94,   0.11351209D+04,   0.97380D+00,   0.00000D+00/
  data pars( 40476: 40480) /137,101,   0.57903900D+02,   0.97380D+00,   0.00000D+00/
  data pars( 40481: 40485) /137,103,   0.19967710D+03,   0.97380D+00,   0.98650D+00/
  data pars( 40486: 40490) /137,104,   0.25295740D+03,   0.97380D+00,   0.98080D+00/
  data pars( 40491: 40495) /137,105,   0.18572060D+03,   0.97380D+00,   0.97060D+00/
  data pars( 40496: 40500) /137,106,   0.13721250D+03,   0.97380D+00,   0.98680D+00/
  data pars( 40501: 40505) /137,107,   0.93458400D+02,   0.97380D+00,   0.99440D+00/
  data pars( 40506: 40510) /137,108,   0.67004500D+02,   0.97380D+00,   0.99250D+00/
  data pars( 40511: 40515) /137,109,   0.45248900D+02,   0.97380D+00,   0.99820D+00/
  data pars( 40516: 40520) /137,111,   0.29467950D+03,   0.97380D+00,   0.96840D+00/
  data pars( 40521: 40525) /137,112,   0.45778310D+03,   0.97380D+00,   0.96280D+00/
  data pars( 40526: 40530) /137,113,   0.45336360D+03,   0.97380D+00,   0.96480D+00/
  data pars( 40531: 40535) /137,114,   0.35341420D+03,   0.97380D+00,   0.95070D+00/
  data pars( 40536: 40540) /137,115,   0.28343680D+03,   0.97380D+00,   0.99470D+00/
  data pars( 40541: 40545) /137,116,   0.23654670D+03,   0.97380D+00,   0.99480D+00/
  data pars( 40546: 40550) /137,117,   0.19086020D+03,   0.97380D+00,   0.99720D+00/
  data pars( 40551: 40555) /137,119,   0.40103710D+03,   0.97380D+00,   0.97670D+00/
  data pars( 40556: 40560) /137,120,   0.81234890D+03,   0.97380D+00,   0.98310D+00/
  data pars( 40561: 40565) /137,121,   0.38990570D+03,   0.97380D+00,   0.18627D+01/
  data pars( 40566: 40570) /137,122,   0.37639190D+03,   0.97380D+00,   0.18299D+01/
  data pars( 40571: 40575) /137,123,   0.36906490D+03,   0.97380D+00,   0.19138D+01/
  data pars( 40576: 40580) /137,124,   0.36686860D+03,   0.97380D+00,   0.18269D+01/
  data pars( 40581: 40585) /137,125,   0.33222150D+03,   0.97380D+00,   0.16406D+01/
  data pars( 40586: 40590) /137,126,   0.30627200D+03,   0.97380D+00,   0.16483D+01/
  data pars( 40591: 40595) /137,127,   0.29229920D+03,   0.97380D+00,   0.17149D+01/
  data pars( 40596: 40600) /137,128,   0.28612410D+03,   0.97380D+00,   0.17937D+01/
  data pars( 40601: 40605) /137,129,   0.28601310D+03,   0.97380D+00,   0.95760D+00/
  data pars( 40606: 40610) /137,130,   0.26273320D+03,   0.97380D+00,   0.19419D+01/
  data pars( 40611: 40615) /137,131,   0.44607980D+03,   0.97380D+00,   0.96010D+00/
  data pars( 40616: 40620) /137,132,   0.38250120D+03,   0.97380D+00,   0.94340D+00/
  data pars( 40621: 40625) /137,133,   0.33721600D+03,   0.97380D+00,   0.98890D+00/
  data pars( 40626: 40630) /137,134,   0.30472790D+03,   0.97380D+00,   0.99010D+00/
  data pars( 40631: 40635) /137,135,   0.26546470D+03,   0.97380D+00,   0.99740D+00/
  data pars( 40636: 40640) /137,137,   0.47625910D+03,   0.97380D+00,   0.97380D+00/
  data pars( 40641: 40645) /138,  1,   0.64406500D+02,   0.98010D+00,   0.91180D+00/
  data pars( 40646: 40650) /138,  2,   0.38833300D+02,   0.98010D+00,   0.00000D+00/
  data pars( 40651: 40655) /138,  3,   0.16182465D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40656: 40660) /138,  4,   0.73479260D+03,   0.98010D+00,   0.00000D+00/
  data pars( 40661: 40665) /138,  5,   0.44112610D+03,   0.98010D+00,   0.00000D+00/
  data pars( 40666: 40670) /138,  6,   0.27470310D+03,   0.98010D+00,   0.00000D+00/
  data pars( 40671: 40675) /138,  7,   0.18119730D+03,   0.98010D+00,   0.00000D+00/
  data pars( 40676: 40680) /138,  8,   0.13178460D+03,   0.98010D+00,   0.00000D+00/
  data pars( 40681: 40685) /138,  9,   0.96508000D+02,   0.98010D+00,   0.00000D+00/
  data pars( 40686: 40690) /138, 10,   0.72270300D+02,   0.98010D+00,   0.00000D+00/
  data pars( 40691: 40695) /138, 11,   0.19079592D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40696: 40700) /138, 12,   0.12181274D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40701: 40705) /138, 13,   0.10570218D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40706: 40710) /138, 14,   0.76638470D+03,   0.98010D+00,   0.00000D+00/
  data pars( 40711: 40715) /138, 15,   0.55938210D+03,   0.98010D+00,   0.00000D+00/
  data pars( 40716: 40720) /138, 16,   0.44578600D+03,   0.98010D+00,   0.00000D+00/
  data pars( 40721: 40725) /138, 17,   0.35042730D+03,   0.98010D+00,   0.00000D+00/
  data pars( 40726: 40730) /138, 18,   0.27747590D+03,   0.98010D+00,   0.00000D+00/
  data pars( 40731: 40735) /138, 19,   0.33022504D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40736: 40740) /138, 20,   0.23148420D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40741: 40745) /138, 21,   0.18497319D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40746: 40750) /138, 22,   0.17407410D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40751: 40755) /138, 23,   0.15682263D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40756: 40760) /138, 24,   0.12385036D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40761: 40765) /138, 25,   0.13188096D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40766: 40770) /138, 26,   0.10340602D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40771: 40775) /138, 27,   0.10522336D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40776: 40780) /138, 28,   0.11016666D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40781: 40785) /138, 29,   0.84879520D+03,   0.98010D+00,   0.00000D+00/
  data pars( 40786: 40790) /138, 30,   0.82251670D+03,   0.98010D+00,   0.00000D+00/
  data pars( 40791: 40795) /138, 31,   0.99191230D+03,   0.98010D+00,   0.00000D+00/
  data pars( 40796: 40800) /138, 32,   0.81848870D+03,   0.98010D+00,   0.00000D+00/
  data pars( 40801: 40805) /138, 33,   0.66009280D+03,   0.98010D+00,   0.00000D+00/
  data pars( 40806: 40810) /138, 34,   0.57308500D+03,   0.98010D+00,   0.00000D+00/
  data pars( 40811: 40815) /138, 35,   0.48506500D+03,   0.98010D+00,   0.00000D+00/
  data pars( 40816: 40820) /138, 36,   0.40937610D+03,   0.98010D+00,   0.00000D+00/
  data pars( 40821: 40825) /138, 37,   0.36709261D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40826: 40830) /138, 38,   0.27824577D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40831: 40835) /138, 39,   0.23056086D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40836: 40840) /138, 40,   0.20037829D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40841: 40845) /138, 41,   0.17897638D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40846: 40850) /138, 42,   0.13350700D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40851: 40855) /138, 43,   0.15092981D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40856: 40860) /138, 44,   0.11061259D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40861: 40865) /138, 45,   0.12034301D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40866: 40870) /138, 46,   0.11005370D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40871: 40875) /138, 47,   0.93160220D+03,   0.98010D+00,   0.00000D+00/
  data pars( 40876: 40880) /138, 48,   0.95275330D+03,   0.98010D+00,   0.00000D+00/
  data pars( 40881: 40885) /138, 49,   0.12501173D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40886: 40890) /138, 50,   0.10916636D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40891: 40895) /138, 51,   0.92413690D+03,   0.98010D+00,   0.00000D+00/
  data pars( 40896: 40900) /138, 52,   0.83250600D+03,   0.98010D+00,   0.00000D+00/
  data pars( 40901: 40905) /138, 53,   0.72971760D+03,   0.98010D+00,   0.00000D+00/
  data pars( 40906: 40910) /138, 54,   0.63746600D+03,   0.98010D+00,   0.00000D+00/
  data pars( 40911: 40915) /138, 55,   0.44969846D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40916: 40920) /138, 56,   0.36314540D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40921: 40925) /138, 57,   0.30140781D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40926: 40930) /138, 58,   0.11044325D+04,   0.98010D+00,   0.27991D+01/
  data pars( 40931: 40935) /138, 59,   0.31621198D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40936: 40940) /138, 60,   0.29999283D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40941: 40945) /138, 61,   0.29157949D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40946: 40950) /138, 62,   0.28393501D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40951: 40955) /138, 63,   0.27713234D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40956: 40960) /138, 64,   0.20594692D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40961: 40965) /138, 65,   0.25668729D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40966: 40970) /138, 66,   0.24578402D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40971: 40975) /138, 67,   0.24609470D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40976: 40980) /138, 68,   0.24041111D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40981: 40985) /138, 69,   0.23512803D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40986: 40990) /138, 70,   0.23289369D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40991: 40995) /138, 71,   0.18927447D+04,   0.98010D+00,   0.00000D+00/
  data pars( 40996: 41000) /138, 72,   0.17529565D+04,   0.98010D+00,   0.00000D+00/
  data pars( 41001: 41005) /138, 73,   0.15479897D+04,   0.98010D+00,   0.00000D+00/
  data pars( 41006: 41010) /138, 74,   0.12804929D+04,   0.98010D+00,   0.00000D+00/
  data pars( 41011: 41015) /138, 75,   0.12840434D+04,   0.98010D+00,   0.00000D+00/
  data pars( 41016: 41020) /138, 76,   0.11312913D+04,   0.98010D+00,   0.00000D+00/
  data pars( 41021: 41025) /138, 77,   0.10131095D+04,   0.98010D+00,   0.00000D+00/
  data pars( 41026: 41030) /138, 78,   0.82466090D+03,   0.98010D+00,   0.00000D+00/
  data pars( 41031: 41035) /138, 79,   0.76388530D+03,   0.98010D+00,   0.00000D+00/
  data pars( 41036: 41040) /138, 80,   0.77550460D+03,   0.98010D+00,   0.00000D+00/
  data pars( 41041: 41045) /138, 81,   0.12742283D+04,   0.98010D+00,   0.00000D+00/
  data pars( 41046: 41050) /138, 82,   0.11873359D+04,   0.98010D+00,   0.00000D+00/
  data pars( 41051: 41055) /138, 83,   0.10400523D+04,   0.98010D+00,   0.00000D+00/
  data pars( 41056: 41060) /138, 84,   0.96630350D+03,   0.98010D+00,   0.00000D+00/
  data pars( 41061: 41065) /138, 85,   0.86500840D+03,   0.98010D+00,   0.00000D+00/
  data pars( 41066: 41070) /138, 86,   0.77178770D+03,   0.98010D+00,   0.00000D+00/
  data pars( 41071: 41075) /138, 87,   0.40533897D+04,   0.98010D+00,   0.00000D+00/
  data pars( 41076: 41080) /138, 88,   0.34910837D+04,   0.98010D+00,   0.00000D+00/
  data pars( 41081: 41085) /138, 89,   0.29248174D+04,   0.98010D+00,   0.00000D+00/
  data pars( 41086: 41090) /138, 90,   0.24812627D+04,   0.98010D+00,   0.00000D+00/
  data pars( 41091: 41095) /138, 91,   0.25425532D+04,   0.98010D+00,   0.00000D+00/
  data pars( 41096: 41100) /138, 92,   0.24572393D+04,   0.98010D+00,   0.00000D+00/
  data pars( 41101: 41105) /138, 93,   0.26180036D+04,   0.98010D+00,   0.00000D+00/
  data pars( 41106: 41110) /138, 94,   0.25175053D+04,   0.98010D+00,   0.00000D+00/
  data pars( 41111: 41115) /138,101,   0.11032750D+03,   0.98010D+00,   0.00000D+00/
  data pars( 41116: 41120) /138,103,   0.42146100D+03,   0.98010D+00,   0.98650D+00/
  data pars( 41121: 41125) /138,104,   0.52954940D+03,   0.98010D+00,   0.98080D+00/
  data pars( 41126: 41130) /138,105,   0.36336070D+03,   0.98010D+00,   0.97060D+00/
  data pars( 41131: 41135) /138,106,   0.25898850D+03,   0.98010D+00,   0.98680D+00/
  data pars( 41136: 41140) /138,107,   0.16917720D+03,   0.98010D+00,   0.99440D+00/
  data pars( 41141: 41145) /138,108,   0.11710180D+03,   0.98010D+00,   0.99250D+00/
  data pars( 41146: 41150) /138,109,   0.75675800D+02,   0.98010D+00,   0.99820D+00/
  data pars( 41151: 41155) /138,111,   0.63083040D+03,   0.98010D+00,   0.96840D+00/
  data pars( 41156: 41160) /138,112,   0.98878570D+03,   0.98010D+00,   0.96280D+00/
  data pars( 41161: 41165) /138,113,   0.94475350D+03,   0.98010D+00,   0.96480D+00/
  data pars( 41166: 41170) /138,114,   0.70100090D+03,   0.98010D+00,   0.95070D+00/
  data pars( 41171: 41175) /138,115,   0.54212620D+03,   0.98010D+00,   0.99470D+00/
  data pars( 41176: 41180) /138,116,   0.44147190D+03,   0.98010D+00,   0.99480D+00/
  data pars( 41181: 41185) /138,117,   0.34712550D+03,   0.98010D+00,   0.99720D+00/
  data pars( 41186: 41190) /138,119,   0.84199830D+03,   0.98010D+00,   0.97670D+00/
  data pars( 41191: 41195) /138,120,   0.18769417D+04,   0.98010D+00,   0.98310D+00/
  data pars( 41196: 41200) /138,121,   0.77994880D+03,   0.98010D+00,   0.18627D+01/
  data pars( 41201: 41205) /138,122,   0.75467530D+03,   0.98010D+00,   0.18299D+01/
  data pars( 41206: 41210) /138,123,   0.74017630D+03,   0.98010D+00,   0.19138D+01/
  data pars( 41211: 41215) /138,124,   0.73983150D+03,   0.98010D+00,   0.18269D+01/
  data pars( 41216: 41220) /138,125,   0.65184050D+03,   0.98010D+00,   0.16406D+01/
  data pars( 41221: 41225) /138,126,   0.59697670D+03,   0.98010D+00,   0.16483D+01/
  data pars( 41226: 41230) /138,127,   0.57030240D+03,   0.98010D+00,   0.17149D+01/
  data pars( 41231: 41235) /138,128,   0.55938830D+03,   0.98010D+00,   0.17937D+01/
  data pars( 41236: 41240) /138,129,   0.56991510D+03,   0.98010D+00,   0.95760D+00/
  data pars( 41241: 41245) /138,130,   0.50526080D+03,   0.98010D+00,   0.19419D+01/
  data pars( 41246: 41250) /138,131,   0.91623120D+03,   0.98010D+00,   0.96010D+00/
  data pars( 41251: 41255) /138,132,   0.75505840D+03,   0.98010D+00,   0.94340D+00/
  data pars( 41256: 41260) /138,133,   0.64702200D+03,   0.98010D+00,   0.98890D+00/
  data pars( 41261: 41265) /138,134,   0.57371350D+03,   0.98010D+00,   0.99010D+00/
  data pars( 41266: 41270) /138,135,   0.48934610D+03,   0.98010D+00,   0.99740D+00/
  data pars( 41271: 41275) /138,137,   0.99279700D+03,   0.98010D+00,   0.97380D+00/
  data pars( 41276: 41280) /138,138,   0.23126602D+04,   0.98010D+00,   0.98010D+00/
  data pars( 41281: 41285) /139,  1,   0.51235600D+02,   0.19153D+01,   0.91180D+00/
  data pars( 41286: 41290) /139,  2,   0.31988900D+02,   0.19153D+01,   0.00000D+00/
  data pars( 41291: 41295) /139,  3,   0.10745875D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41296: 41300) /139,  4,   0.53251100D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41301: 41305) /139,  5,   0.33413510D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41306: 41310) /139,  6,   0.21477600D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41311: 41315) /139,  7,   0.14492070D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41316: 41320) /139,  8,   0.10704380D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41321: 41325) /139,  9,   0.79407600D+02,   0.19153D+01,   0.00000D+00/
  data pars( 41326: 41330) /139, 10,   0.60062800D+02,   0.19153D+01,   0.00000D+00/
  data pars( 41331: 41335) /139, 11,   0.12727028D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41336: 41340) /139, 12,   0.86937390D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41341: 41345) /139, 13,   0.77186060D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41346: 41350) /139, 14,   0.57805500D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41351: 41355) /139, 15,   0.43301710D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41356: 41360) /139, 16,   0.35057750D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41361: 41365) /139, 17,   0.27973550D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41366: 41370) /139, 18,   0.22431260D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41371: 41375) /139, 19,   0.21637031D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41376: 41380) /139, 20,   0.16036362D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41381: 41385) /139, 21,   0.12972964D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41386: 41390) /139, 22,   0.12323433D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41391: 41395) /139, 23,   0.11169531D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41396: 41400) /139, 24,   0.88060690D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41401: 41405) /139, 25,   0.94758340D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41406: 41410) /139, 26,   0.74266410D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41411: 41415) /139, 27,   0.76821070D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41416: 41420) /139, 28,   0.79937100D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41421: 41425) /139, 29,   0.61409830D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41426: 41430) /139, 30,   0.60904990D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41431: 41435) /139, 31,   0.72958130D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41436: 41440) /139, 32,   0.61799850D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41441: 41445) /139, 33,   0.50955030D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41446: 41450) /139, 34,   0.44813810D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41451: 41455) /139, 35,   0.38429010D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41456: 41460) /139, 36,   0.32813160D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41461: 41465) /139, 37,   0.24114577D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41466: 41470) /139, 38,   0.19209295D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41471: 41475) /139, 39,   0.16243636D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41476: 41480) /139, 40,   0.14293576D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41481: 41485) /139, 41,   0.12864770D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41486: 41490) /139, 42,   0.97159590D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41491: 41495) /139, 43,   0.10932424D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41496: 41500) /139, 44,   0.81262860D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41501: 41505) /139, 45,   0.88627500D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41506: 41510) /139, 46,   0.81484020D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41511: 41515) /139, 47,   0.68497960D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41516: 41520) /139, 48,   0.71021720D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41521: 41525) /139, 49,   0.91615920D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41526: 41530) /139, 50,   0.81841300D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41531: 41535) /139, 51,   0.70709330D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41536: 41540) /139, 52,   0.64444940D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41541: 41545) /139, 53,   0.57184320D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41546: 41550) /139, 54,   0.50522620D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41551: 41555) /139, 55,   0.29502475D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41556: 41560) /139, 56,   0.24856310D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41561: 41565) /139, 57,   0.21057491D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41566: 41570) /139, 58,   0.84084100D+03,   0.19153D+01,   0.27991D+01/
  data pars( 41571: 41575) /139, 59,   0.21783229D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41576: 41580) /139, 60,   0.20748807D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41581: 41585) /139, 61,   0.20189224D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41586: 41590) /139, 62,   0.19678827D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41591: 41595) /139, 63,   0.19225226D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41596: 41600) /139, 64,   0.14581969D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41601: 41605) /139, 65,   0.17521144D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41606: 41610) /139, 66,   0.16830549D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41611: 41615) /139, 67,   0.17170123D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41616: 41620) /139, 68,   0.16785781D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41621: 41625) /139, 69,   0.16432139D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41626: 41630) /139, 70,   0.16263339D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41631: 41635) /139, 71,   0.13398149D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41636: 41640) /139, 72,   0.12689492D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41641: 41645) /139, 73,   0.11346407D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41646: 41650) /139, 74,   0.94540990D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41651: 41655) /139, 75,   0.95356340D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41656: 41660) /139, 76,   0.84938170D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41661: 41665) /139, 77,   0.76730030D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41666: 41670) /139, 78,   0.62916050D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41671: 41675) /139, 79,   0.58463530D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41676: 41680) /139, 80,   0.59694450D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41681: 41685) /139, 81,   0.93562990D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41686: 41690) /139, 82,   0.88887560D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41691: 41695) /139, 83,   0.79367010D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41696: 41700) /139, 84,   0.74514710D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41701: 41705) /139, 85,   0.67518420D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41706: 41710) /139, 86,   0.60886250D+03,   0.19153D+01,   0.00000D+00/
  data pars( 41711: 41715) /139, 87,   0.26980970D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41716: 41720) /139, 88,   0.24134225D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41721: 41725) /139, 89,   0.20622685D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41726: 41730) /139, 90,   0.17871863D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41731: 41735) /139, 91,   0.18092861D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41736: 41740) /139, 92,   0.17497379D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41741: 41745) /139, 93,   0.18406901D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41746: 41750) /139, 94,   0.17746391D+04,   0.19153D+01,   0.00000D+00/
  data pars( 41751: 41755) /139,101,   0.85681500D+02,   0.19153D+01,   0.00000D+00/
  data pars( 41756: 41760) /139,103,   0.30688620D+03,   0.19153D+01,   0.98650D+00/
  data pars( 41761: 41765) /139,104,   0.38765640D+03,   0.19153D+01,   0.98080D+00/
  data pars( 41766: 41770) /139,105,   0.27740500D+03,   0.19153D+01,   0.97060D+00/
  data pars( 41771: 41775) /139,106,   0.20197440D+03,   0.19153D+01,   0.98680D+00/
  data pars( 41776: 41780) /139,107,   0.13518390D+03,   0.19153D+01,   0.99440D+00/
  data pars( 41781: 41785) /139,108,   0.95445800D+02,   0.19153D+01,   0.99250D+00/
  data pars( 41786: 41790) /139,109,   0.63188900D+02,   0.19153D+01,   0.99820D+00/
  data pars( 41791: 41795) /139,111,   0.45499280D+03,   0.19153D+01,   0.96840D+00/
  data pars( 41796: 41800) /139,112,   0.70969610D+03,   0.19153D+01,   0.96280D+00/
  data pars( 41801: 41805) /139,113,   0.69347320D+03,   0.19153D+01,   0.96480D+00/
  data pars( 41806: 41810) /139,114,   0.53081800D+03,   0.19153D+01,   0.95070D+00/
  data pars( 41811: 41815) /139,115,   0.41987180D+03,   0.19153D+01,   0.99470D+00/
  data pars( 41816: 41820) /139,116,   0.34697100D+03,   0.19153D+01,   0.99480D+00/
  data pars( 41821: 41825) /139,117,   0.27697730D+03,   0.19153D+01,   0.99720D+00/
  data pars( 41826: 41830) /139,119,   0.61384630D+03,   0.19153D+01,   0.97670D+00/
  data pars( 41831: 41835) /139,120,   0.12935159D+04,   0.19153D+01,   0.98310D+00/
  data pars( 41836: 41840) /139,121,   0.58631350D+03,   0.19153D+01,   0.18627D+01/
  data pars( 41841: 41845) /139,122,   0.56686700D+03,   0.19153D+01,   0.18299D+01/
  data pars( 41846: 41850) /139,123,   0.55572150D+03,   0.19153D+01,   0.19138D+01/
  data pars( 41851: 41855) /139,124,   0.55347640D+03,   0.19153D+01,   0.18269D+01/
  data pars( 41856: 41860) /139,125,   0.49633310D+03,   0.19153D+01,   0.16406D+01/
  data pars( 41861: 41865) /139,126,   0.45638780D+03,   0.19153D+01,   0.16483D+01/
  data pars( 41866: 41870) /139,127,   0.43567010D+03,   0.19153D+01,   0.17149D+01/
  data pars( 41871: 41875) /139,128,   0.42674050D+03,   0.19153D+01,   0.17937D+01/
  data pars( 41876: 41880) /139,129,   0.42937430D+03,   0.19153D+01,   0.95760D+00/
  data pars( 41881: 41885) /139,130,   0.38958110D+03,   0.19153D+01,   0.19419D+01/
  data pars( 41886: 41890) /139,131,   0.67825900D+03,   0.19153D+01,   0.96010D+00/
  data pars( 41891: 41895) /139,132,   0.57321390D+03,   0.19153D+01,   0.94340D+00/
  data pars( 41896: 41900) /139,133,   0.50000710D+03,   0.19153D+01,   0.98890D+00/
  data pars( 41901: 41905) /139,134,   0.44848720D+03,   0.19153D+01,   0.99010D+00/
  data pars( 41906: 41910) /139,135,   0.38738760D+03,   0.19153D+01,   0.99740D+00/
  data pars( 41911: 41915) /139,137,   0.72686130D+03,   0.19153D+01,   0.97380D+00/
  data pars( 41916: 41920) /139,138,   0.15865402D+04,   0.19153D+01,   0.98010D+00/
  data pars( 41921: 41925) /139,139,   0.11322983D+04,   0.19153D+01,   0.19153D+01/
  data pars( 41926: 41930) /140,  1,   0.39666900D+02,   0.19355D+01,   0.91180D+00/
  data pars( 41931: 41935) /140,  2,   0.25703700D+02,   0.19355D+01,   0.00000D+00/
  data pars( 41936: 41940) /140,  3,   0.67848100D+03,   0.19355D+01,   0.00000D+00/
  data pars( 41941: 41945) /140,  4,   0.37401350D+03,   0.19355D+01,   0.00000D+00/
  data pars( 41946: 41950) /140,  5,   0.24601470D+03,   0.19355D+01,   0.00000D+00/
  data pars( 41951: 41955) /140,  6,   0.16345480D+03,   0.19355D+01,   0.00000D+00/
  data pars( 41956: 41960) /140,  7,   0.11293390D+03,   0.19355D+01,   0.00000D+00/
  data pars( 41961: 41965) /140,  8,   0.84787600D+02,   0.19355D+01,   0.00000D+00/
  data pars( 41966: 41970) /140,  9,   0.63768000D+02,   0.19355D+01,   0.00000D+00/
  data pars( 41971: 41975) /140, 10,   0.48760000D+02,   0.19355D+01,   0.00000D+00/
  data pars( 41976: 41980) /140, 11,   0.80899730D+03,   0.19355D+01,   0.00000D+00/
  data pars( 41981: 41985) /140, 12,   0.60055110D+03,   0.19355D+01,   0.00000D+00/
  data pars( 41986: 41990) /140, 13,   0.54671760D+03,   0.19355D+01,   0.00000D+00/
  data pars( 41991: 41995) /140, 14,   0.42369920D+03,   0.19355D+01,   0.00000D+00/
  data pars( 41996: 42000) /140, 15,   0.32600870D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42001: 42005) /140, 16,   0.26830770D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42006: 42010) /140, 17,   0.21743220D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42011: 42015) /140, 18,   0.17666900D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42016: 42020) /140, 19,   0.13359899D+04,   0.19355D+01,   0.00000D+00/
  data pars( 42021: 42025) /140, 20,   0.10709104D+04,   0.19355D+01,   0.00000D+00/
  data pars( 42026: 42030) /140, 21,   0.87901650D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42031: 42035) /140, 22,   0.84415650D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42036: 42040) /140, 23,   0.77041850D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42041: 42045) /140, 24,   0.60670400D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42046: 42050) /140, 25,   0.66010050D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42051: 42055) /140, 26,   0.51758120D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42056: 42060) /140, 27,   0.54466430D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42061: 42065) /140, 28,   0.56293440D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42066: 42070) /140, 29,   0.43155440D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42071: 42075) /140, 30,   0.43840800D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42076: 42080) /140, 31,   0.52118020D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42081: 42085) /140, 32,   0.45369050D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42086: 42090) /140, 33,   0.38264580D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42091: 42095) /140, 34,   0.34103380D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42096: 42100) /140, 35,   0.29639440D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42101: 42105) /140, 36,   0.25615010D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42106: 42110) /140, 37,   0.14937993D+04,   0.19355D+01,   0.00000D+00/
  data pars( 42111: 42115) /140, 38,   0.12775813D+04,   0.19355D+01,   0.00000D+00/
  data pars( 42116: 42120) /140, 39,   0.11066630D+04,   0.19355D+01,   0.00000D+00/
  data pars( 42121: 42125) /140, 40,   0.98782570D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42126: 42130) /140, 41,   0.89679520D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42131: 42135) /140, 42,   0.68718480D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42136: 42140) /140, 43,   0.76884280D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42141: 42145) /140, 44,   0.58090070D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42146: 42150) /140, 45,   0.63480240D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42151: 42155) /140, 46,   0.58702020D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42156: 42160) /140, 47,   0.49038170D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42161: 42165) /140, 48,   0.51538610D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42166: 42170) /140, 49,   0.65256540D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42171: 42175) /140, 50,   0.59689190D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42176: 42180) /140, 51,   0.52654260D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42181: 42185) /140, 52,   0.48561760D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42186: 42190) /140, 53,   0.43630460D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42191: 42195) /140, 54,   0.38993850D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42196: 42200) /140, 55,   0.18190406D+04,   0.19355D+01,   0.00000D+00/
  data pars( 42201: 42205) /140, 56,   0.16353622D+04,   0.19355D+01,   0.00000D+00/
  data pars( 42206: 42210) /140, 57,   0.14206192D+04,   0.19355D+01,   0.00000D+00/
  data pars( 42211: 42215) /140, 58,   0.62328410D+03,   0.19355D+01,   0.27991D+01/
  data pars( 42216: 42220) /140, 59,   0.14429680D+04,   0.19355D+01,   0.00000D+00/
  data pars( 42221: 42225) /140, 60,   0.13832190D+04,   0.19355D+01,   0.00000D+00/
  data pars( 42226: 42230) /140, 61,   0.13477804D+04,   0.19355D+01,   0.00000D+00/
  data pars( 42231: 42235) /140, 62,   0.13152670D+04,   0.19355D+01,   0.00000D+00/
  data pars( 42236: 42240) /140, 63,   0.12864106D+04,   0.19355D+01,   0.00000D+00/
  data pars( 42241: 42245) /140, 64,   0.99936150D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42246: 42250) /140, 65,   0.11461276D+04,   0.19355D+01,   0.00000D+00/
  data pars( 42251: 42255) /140, 66,   0.11025614D+04,   0.19355D+01,   0.00000D+00/
  data pars( 42256: 42260) /140, 67,   0.11568729D+04,   0.19355D+01,   0.00000D+00/
  data pars( 42261: 42265) /140, 68,   0.11319421D+04,   0.19355D+01,   0.00000D+00/
  data pars( 42266: 42270) /140, 69,   0.11093035D+04,   0.19355D+01,   0.00000D+00/
  data pars( 42271: 42275) /140, 70,   0.10968681D+04,   0.19355D+01,   0.00000D+00/
  data pars( 42276: 42280) /140, 71,   0.91629250D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42281: 42285) /140, 72,   0.89141000D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42286: 42290) /140, 73,   0.80810660D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42291: 42295) /140, 74,   0.67904580D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42296: 42300) /140, 75,   0.68897190D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42301: 42305) /140, 76,   0.62088940D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42306: 42310) /140, 77,   0.56604620D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42311: 42315) /140, 78,   0.46802460D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42316: 42320) /140, 79,   0.43643220D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42321: 42325) /140, 80,   0.44796630D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42326: 42330) /140, 81,   0.66836720D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42331: 42335) /140, 82,   0.64781650D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42336: 42340) /140, 83,   0.58976480D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42341: 42345) /140, 84,   0.55956430D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42346: 42350) /140, 85,   0.51325740D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42351: 42355) /140, 86,   0.46784580D+03,   0.19355D+01,   0.00000D+00/
  data pars( 42356: 42360) /140, 87,   0.17028592D+04,   0.19355D+01,   0.00000D+00/
  data pars( 42361: 42365) /140, 88,   0.16078178D+04,   0.19355D+01,   0.00000D+00/
  data pars( 42366: 42370) /140, 89,   0.14061219D+04,   0.19355D+01,   0.00000D+00/
  data pars( 42371: 42375) /140, 90,   0.12490250D+04,   0.19355D+01,   0.00000D+00/
  data pars( 42376: 42380) /140, 91,   0.12473212D+04,   0.19355D+01,   0.00000D+00/
  data pars( 42381: 42385) /140, 92,   0.12073349D+04,   0.19355D+01,   0.00000D+00/
  data pars( 42386: 42390) /140, 93,   0.12519154D+04,   0.19355D+01,   0.00000D+00/
  data pars( 42391: 42395) /140, 94,   0.12106981D+04,   0.19355D+01,   0.00000D+00/
  data pars( 42396: 42400) /140,101,   0.64706800D+02,   0.19355D+01,   0.00000D+00/
  data pars( 42401: 42405) /140,103,   0.21671700D+03,   0.19355D+01,   0.98650D+00/
  data pars( 42406: 42410) /140,104,   0.27536440D+03,   0.19355D+01,   0.98080D+00/
  data pars( 42411: 42415) /140,105,   0.20600140D+03,   0.19355D+01,   0.97060D+00/
  data pars( 42416: 42420) /140,106,   0.15342290D+03,   0.19355D+01,   0.98680D+00/
  data pars( 42421: 42425) /140,107,   0.10531510D+03,   0.19355D+01,   0.99440D+00/
  data pars( 42426: 42430) /140,108,   0.75899400D+02,   0.19355D+01,   0.99250D+00/
  data pars( 42431: 42435) /140,109,   0.51515800D+02,   0.19355D+01,   0.99820D+00/
  data pars( 42436: 42440) /140,111,   0.31816780D+03,   0.19355D+01,   0.96840D+00/
  data pars( 42441: 42445) /140,112,   0.49330570D+03,   0.19355D+01,   0.96280D+00/
  data pars( 42446: 42450) /140,113,   0.49402450D+03,   0.19355D+01,   0.96480D+00/
  data pars( 42451: 42455) /140,114,   0.39071920D+03,   0.19355D+01,   0.95070D+00/
  data pars( 42456: 42460) /140,115,   0.31631690D+03,   0.19355D+01,   0.99470D+00/
  data pars( 42461: 42465) /140,116,   0.26540890D+03,   0.19355D+01,   0.99480D+00/
  data pars( 42466: 42470) /140,117,   0.21521010D+03,   0.19355D+01,   0.99720D+00/
  data pars( 42471: 42475) /140,119,   0.43506490D+03,   0.19355D+01,   0.97670D+00/
  data pars( 42476: 42480) /140,120,   0.85671310D+03,   0.19355D+01,   0.98310D+00/
  data pars( 42481: 42485) /140,121,   0.42930190D+03,   0.19355D+01,   0.18627D+01/
  data pars( 42486: 42490) /140,122,   0.41420300D+03,   0.19355D+01,   0.18299D+01/
  data pars( 42491: 42495) /140,123,   0.40602230D+03,   0.19355D+01,   0.19138D+01/
  data pars( 42496: 42500) /140,124,   0.40292000D+03,   0.19355D+01,   0.18269D+01/
  data pars( 42501: 42505) /140,125,   0.36779370D+03,   0.19355D+01,   0.16406D+01/
  data pars( 42506: 42510) /140,126,   0.33962780D+03,   0.19355D+01,   0.16483D+01/
  data pars( 42511: 42515) /140,127,   0.32399210D+03,   0.19355D+01,   0.17149D+01/
  data pars( 42516: 42520) /140,128,   0.31694170D+03,   0.19355D+01,   0.17937D+01/
  data pars( 42521: 42525) /140,129,   0.31499080D+03,   0.19355D+01,   0.95760D+00/
  data pars( 42526: 42530) /140,130,   0.29240050D+03,   0.19355D+01,   0.19419D+01/
  data pars( 42531: 42535) /140,131,   0.48787590D+03,   0.19355D+01,   0.96010D+00/
  data pars( 42536: 42540) /140,132,   0.42320760D+03,   0.19355D+01,   0.94340D+00/
  data pars( 42541: 42545) /140,133,   0.37591790D+03,   0.19355D+01,   0.98890D+00/
  data pars( 42546: 42550) /140,134,   0.34120400D+03,   0.19355D+01,   0.99010D+00/
  data pars( 42551: 42555) /140,135,   0.29856340D+03,   0.19355D+01,   0.99740D+00/
  data pars( 42556: 42560) /140,137,   0.51769610D+03,   0.19355D+01,   0.97380D+00/
  data pars( 42561: 42565) /140,138,   0.10443401D+04,   0.19355D+01,   0.98010D+00/
  data pars( 42566: 42570) /140,139,   0.78082120D+03,   0.19355D+01,   0.19153D+01/
  data pars( 42571: 42575) /140,140,   0.56867890D+03,   0.19355D+01,   0.19355D+01/
  data pars( 42576: 42580) /141,  1,   0.40030400D+02,   0.19545D+01,   0.91180D+00/
  data pars( 42581: 42585) /141,  2,   0.25953400D+02,   0.19545D+01,   0.00000D+00/
  data pars( 42586: 42590) /141,  3,   0.68410400D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42591: 42595) /141,  4,   0.37796930D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42596: 42600) /141,  5,   0.24842660D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42601: 42605) /141,  6,   0.16499800D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42606: 42610) /141,  7,   0.11399890D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42611: 42615) /141,  8,   0.85602400D+02,   0.19545D+01,   0.00000D+00/
  data pars( 42616: 42620) /141,  9,   0.64401000D+02,   0.19545D+01,   0.00000D+00/
  data pars( 42621: 42625) /141, 10,   0.49263500D+02,   0.19545D+01,   0.00000D+00/
  data pars( 42626: 42630) /141, 11,   0.81603170D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42631: 42635) /141, 12,   0.60700730D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42636: 42640) /141, 13,   0.55235500D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42641: 42645) /141, 14,   0.42788370D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42646: 42650) /141, 15,   0.32909470D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42651: 42655) /141, 16,   0.27080590D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42656: 42660) /141, 17,   0.21944620D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42661: 42665) /141, 18,   0.17831830D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42666: 42670) /141, 19,   0.13433714D+04,   0.19545D+01,   0.00000D+00/
  data pars( 42671: 42675) /141, 20,   0.10819930D+04,   0.19545D+01,   0.00000D+00/
  data pars( 42676: 42680) /141, 21,   0.88833560D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42681: 42685) /141, 22,   0.85304640D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42686: 42690) /141, 23,   0.77852660D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42691: 42695) /141, 24,   0.61302240D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42696: 42700) /141, 25,   0.66703050D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42701: 42705) /141, 26,   0.52300200D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42706: 42710) /141, 27,   0.55040920D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42711: 42715) /141, 28,   0.56890880D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42716: 42720) /141, 29,   0.43610420D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42721: 42725) /141, 30,   0.44298860D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42726: 42730) /141, 31,   0.52649640D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42731: 42735) /141, 32,   0.45819200D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42736: 42740) /141, 33,   0.38630910D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42741: 42745) /141, 34,   0.34424250D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42746: 42750) /141, 35,   0.29915350D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42751: 42755) /141, 36,   0.25853040D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42756: 42760) /141, 37,   0.15017789D+04,   0.19545D+01,   0.00000D+00/
  data pars( 42761: 42765) /141, 38,   0.12904826D+04,   0.19545D+01,   0.00000D+00/
  data pars( 42766: 42770) /141, 39,   0.11181402D+04,   0.19545D+01,   0.00000D+00/
  data pars( 42771: 42775) /141, 40,   0.99812240D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42776: 42780) /141, 41,   0.90608010D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42781: 42785) /141, 42,   0.69429830D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42786: 42790) /141, 43,   0.77673680D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42791: 42795) /141, 44,   0.58689450D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42796: 42800) /141, 45,   0.64141640D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42801: 42805) /141, 46,   0.59314140D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42806: 42810) /141, 47,   0.49548000D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42811: 42815) /141, 48,   0.52076290D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42816: 42820) /141, 49,   0.65928650D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42821: 42825) /141, 50,   0.60296920D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42826: 42830) /141, 51,   0.53174240D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42831: 42835) /141, 52,   0.49032060D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42836: 42840) /141, 53,   0.44045990D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42841: 42845) /141, 54,   0.39361210D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42846: 42850) /141, 55,   0.18264461D+04,   0.19545D+01,   0.00000D+00/
  data pars( 42851: 42855) /141, 56,   0.16509334D+04,   0.19545D+01,   0.00000D+00/
  data pars( 42856: 42860) /141, 57,   0.14348956D+04,   0.19545D+01,   0.00000D+00/
  data pars( 42861: 42865) /141, 58,   0.62949770D+03,   0.19545D+01,   0.27991D+01/
  data pars( 42866: 42870) /141, 59,   0.14565113D+04,   0.19545D+01,   0.00000D+00/
  data pars( 42871: 42875) /141, 60,   0.13970298D+04,   0.19545D+01,   0.00000D+00/
  data pars( 42876: 42880) /141, 61,   0.13613178D+04,   0.19545D+01,   0.00000D+00/
  data pars( 42881: 42885) /141, 62,   0.13285415D+04,   0.19545D+01,   0.00000D+00/
  data pars( 42886: 42890) /141, 63,   0.12994488D+04,   0.19545D+01,   0.00000D+00/
  data pars( 42891: 42895) /141, 64,   0.10094419D+04,   0.19545D+01,   0.00000D+00/
  data pars( 42896: 42900) /141, 65,   0.11553947D+04,   0.19545D+01,   0.00000D+00/
  data pars( 42901: 42905) /141, 66,   0.11106913D+04,   0.19545D+01,   0.00000D+00/
  data pars( 42906: 42910) /141, 67,   0.11688393D+04,   0.19545D+01,   0.00000D+00/
  data pars( 42911: 42915) /141, 68,   0.11436857D+04,   0.19545D+01,   0.00000D+00/
  data pars( 42916: 42920) /141, 69,   0.11208436D+04,   0.19545D+01,   0.00000D+00/
  data pars( 42921: 42925) /141, 70,   0.11082791D+04,   0.19545D+01,   0.00000D+00/
  data pars( 42926: 42930) /141, 71,   0.92522660D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42931: 42935) /141, 72,   0.90068080D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42936: 42940) /141, 73,   0.81649740D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42941: 42945) /141, 74,   0.68598560D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42946: 42950) /141, 75,   0.69600400D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42951: 42955) /141, 76,   0.62720650D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42956: 42960) /141, 77,   0.57177930D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42961: 42965) /141, 78,   0.47276430D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42966: 42970) /141, 79,   0.44085970D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42971: 42975) /141, 80,   0.45247610D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42976: 42980) /141, 81,   0.67515180D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42981: 42985) /141, 82,   0.65444510D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42986: 42990) /141, 83,   0.59566400D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42991: 42995) /141, 84,   0.56506480D+03,   0.19545D+01,   0.00000D+00/
  data pars( 42996: 43000) /141, 85,   0.51821240D+03,   0.19545D+01,   0.00000D+00/
  data pars( 43001: 43005) /141, 86,   0.47230580D+03,   0.19545D+01,   0.00000D+00/
  data pars( 43006: 43010) /141, 87,   0.17127050D+04,   0.19545D+01,   0.00000D+00/
  data pars( 43011: 43015) /141, 88,   0.16235376D+04,   0.19545D+01,   0.00000D+00/
  data pars( 43016: 43020) /141, 89,   0.14203983D+04,   0.19545D+01,   0.00000D+00/
  data pars( 43021: 43025) /141, 90,   0.12619867D+04,   0.19545D+01,   0.00000D+00/
  data pars( 43026: 43030) /141, 91,   0.12600147D+04,   0.19545D+01,   0.00000D+00/
  data pars( 43031: 43035) /141, 92,   0.12197064D+04,   0.19545D+01,   0.00000D+00/
  data pars( 43036: 43040) /141, 93,   0.12648378D+04,   0.19545D+01,   0.00000D+00/
  data pars( 43041: 43045) /141, 94,   0.12232638D+04,   0.19545D+01,   0.00000D+00/
  data pars( 43046: 43050) /141,101,   0.65312900D+02,   0.19545D+01,   0.00000D+00/
  data pars( 43051: 43055) /141,103,   0.21897060D+03,   0.19545D+01,   0.98650D+00/
  data pars( 43056: 43060) /141,104,   0.27808810D+03,   0.19545D+01,   0.98080D+00/
  data pars( 43061: 43065) /141,105,   0.20799430D+03,   0.19545D+01,   0.97060D+00/
  data pars( 43066: 43070) /141,106,   0.15487640D+03,   0.19545D+01,   0.98680D+00/
  data pars( 43071: 43075) /141,107,   0.10631410D+03,   0.19545D+01,   0.99440D+00/
  data pars( 43076: 43080) /141,108,   0.76634700D+02,   0.19545D+01,   0.99250D+00/
  data pars( 43081: 43085) /141,109,   0.52041200D+02,   0.19545D+01,   0.99820D+00/
  data pars( 43086: 43090) /141,111,   0.32153780D+03,   0.19545D+01,   0.96840D+00/
  data pars( 43091: 43095) /141,112,   0.49834860D+03,   0.19545D+01,   0.96280D+00/
  data pars( 43096: 43100) /141,113,   0.49907610D+03,   0.19545D+01,   0.96480D+00/
  data pars( 43101: 43105) /141,114,   0.39454030D+03,   0.19545D+01,   0.95070D+00/
  data pars( 43106: 43110) /141,115,   0.31930990D+03,   0.19545D+01,   0.99470D+00/
  data pars( 43111: 43115) /141,116,   0.26788580D+03,   0.19545D+01,   0.99480D+00/
  data pars( 43116: 43120) /141,117,   0.21720780D+03,   0.19545D+01,   0.99720D+00/
  data pars( 43121: 43125) /141,119,   0.43952280D+03,   0.19545D+01,   0.97670D+00/
  data pars( 43126: 43130) /141,120,   0.86414110D+03,   0.19545D+01,   0.98310D+00/
  data pars( 43131: 43135) /141,121,   0.43378650D+03,   0.19545D+01,   0.18627D+01/
  data pars( 43136: 43140) /141,122,   0.41830680D+03,   0.19545D+01,   0.18299D+01/
  data pars( 43141: 43145) /141,123,   0.41010330D+03,   0.19545D+01,   0.19138D+01/
  data pars( 43146: 43150) /141,124,   0.40698940D+03,   0.19545D+01,   0.18269D+01/
  data pars( 43151: 43155) /141,125,   0.37146910D+03,   0.19545D+01,   0.16406D+01/
  data pars( 43156: 43160) /141,126,   0.34300120D+03,   0.19545D+01,   0.16483D+01/
  data pars( 43161: 43165) /141,127,   0.32719950D+03,   0.19545D+01,   0.17149D+01/
  data pars( 43166: 43170) /141,128,   0.32009600D+03,   0.19545D+01,   0.17937D+01/
  data pars( 43171: 43175) /141,129,   0.31821360D+03,   0.19545D+01,   0.95760D+00/
  data pars( 43176: 43180) /141,130,   0.29527620D+03,   0.19545D+01,   0.19419D+01/
  data pars( 43181: 43185) /141,131,   0.49283160D+03,   0.19545D+01,   0.96010D+00/
  data pars( 43186: 43190) /141,132,   0.42736220D+03,   0.19545D+01,   0.94340D+00/
  data pars( 43191: 43195) /141,133,   0.37950970D+03,   0.19545D+01,   0.98890D+00/
  data pars( 43196: 43200) /141,134,   0.34441690D+03,   0.19545D+01,   0.99010D+00/
  data pars( 43201: 43205) /141,135,   0.30134630D+03,   0.19545D+01,   0.99740D+00/
  data pars( 43206: 43210) /141,137,   0.52294490D+03,   0.19545D+01,   0.97380D+00/
  data pars( 43211: 43215) /141,138,   0.10528629D+04,   0.19545D+01,   0.98010D+00/
  data pars( 43216: 43220) /141,139,   0.78749500D+03,   0.19545D+01,   0.19153D+01/
  data pars( 43221: 43225) /141,140,   0.57445910D+03,   0.19545D+01,   0.19355D+01/
  data pars( 43226: 43230) /141,141,   0.58058240D+03,   0.19545D+01,   0.19545D+01/
  data pars( 43231: 43235) /142,  1,   0.37547800D+02,   0.19420D+01,   0.91180D+00/
  data pars( 43236: 43240) /142,  2,   0.24553000D+02,   0.19420D+01,   0.00000D+00/
  data pars( 43241: 43245) /142,  3,   0.62818170D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43246: 43250) /142,  4,   0.34918970D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43251: 43255) /142,  5,   0.23104490D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43256: 43260) /142,  6,   0.15432880D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43261: 43265) /142,  7,   0.10713040D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43266: 43270) /142,  8,   0.80736000D+02,   0.19420D+01,   0.00000D+00/
  data pars( 43271: 43275) /142,  9,   0.60941400D+02,   0.19420D+01,   0.00000D+00/
  data pars( 43276: 43280) /142, 10,   0.46749800D+02,   0.19420D+01,   0.00000D+00/
  data pars( 43281: 43285) /142, 11,   0.74949740D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43286: 43290) /142, 12,   0.55988560D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43291: 43295) /142, 13,   0.51108100D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43296: 43300) /142, 14,   0.39766020D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43301: 43305) /142, 15,   0.30713840D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43306: 43310) /142, 16,   0.25349850D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43311: 43315) /142, 17,   0.20604590D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43316: 43320) /142, 18,   0.16790140D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43321: 43325) /142, 19,   0.12379643D+04,   0.19420D+01,   0.00000D+00/
  data pars( 43326: 43330) /142, 20,   0.99601570D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43331: 43335) /142, 21,   0.81851610D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43336: 43340) /142, 22,   0.78705650D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43341: 43345) /142, 23,   0.71884690D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43346: 43350) /142, 24,   0.56643000D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43351: 43355) /142, 25,   0.61659930D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43356: 43360) /142, 26,   0.48385370D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43361: 43365) /142, 27,   0.50969990D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43366: 43370) /142, 28,   0.52637950D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43371: 43375) /142, 29,   0.40384000D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43376: 43380) /142, 30,   0.41098660D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43381: 43385) /142, 31,   0.48798580D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43386: 43390) /142, 32,   0.42607030D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43391: 43395) /142, 33,   0.36044960D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43396: 43400) /142, 34,   0.32194150D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43401: 43405) /142, 35,   0.28047020D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43406: 43410) /142, 36,   0.24296840D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43411: 43415) /142, 37,   0.13851228D+04,   0.19420D+01,   0.00000D+00/
  data pars( 43416: 43420) /142, 38,   0.11881982D+04,   0.19420D+01,   0.00000D+00/
  data pars( 43421: 43425) /142, 39,   0.10314745D+04,   0.19420D+01,   0.00000D+00/
  data pars( 43426: 43430) /142, 40,   0.92206600D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43431: 43435) /142, 41,   0.83798490D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43436: 43440) /142, 42,   0.64347210D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43441: 43445) /142, 43,   0.71936590D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43446: 43450) /142, 44,   0.54480750D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43451: 43455) /142, 45,   0.59515030D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43456: 43460) /142, 46,   0.55075570D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43461: 43465) /142, 47,   0.46023670D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43466: 43470) /142, 48,   0.48402860D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43471: 43475) /142, 49,   0.61139110D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43476: 43480) /142, 50,   0.56051040D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43481: 43485) /142, 51,   0.49569480D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43486: 43490) /142, 52,   0.45793020D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43491: 43495) /142, 53,   0.41222750D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43496: 43500) /142, 54,   0.36915310D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43501: 43505) /142, 55,   0.16877490D+04,   0.19420D+01,   0.00000D+00/
  data pars( 43506: 43510) /142, 56,   0.15201317D+04,   0.19420D+01,   0.00000D+00/
  data pars( 43511: 43515) /142, 57,   0.13232583D+04,   0.19420D+01,   0.00000D+00/
  data pars( 43516: 43520) /142, 58,   0.58664300D+03,   0.19420D+01,   0.27991D+01/
  data pars( 43521: 43525) /142, 59,   0.13428116D+04,   0.19420D+01,   0.00000D+00/
  data pars( 43526: 43530) /142, 60,   0.12872763D+04,   0.19420D+01,   0.00000D+00/
  data pars( 43531: 43535) /142, 61,   0.12544039D+04,   0.19420D+01,   0.00000D+00/
  data pars( 43536: 43540) /142, 62,   0.12242314D+04,   0.19420D+01,   0.00000D+00/
  data pars( 43541: 43545) /142, 63,   0.11974564D+04,   0.19420D+01,   0.00000D+00/
  data pars( 43546: 43550) /142, 64,   0.93283320D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43551: 43555) /142, 65,   0.10667077D+04,   0.19420D+01,   0.00000D+00/
  data pars( 43556: 43560) /142, 66,   0.10271026D+04,   0.19420D+01,   0.00000D+00/
  data pars( 43561: 43565) /142, 67,   0.10774205D+04,   0.19420D+01,   0.00000D+00/
  data pars( 43566: 43570) /142, 68,   0.10542484D+04,   0.19420D+01,   0.00000D+00/
  data pars( 43571: 43575) /142, 69,   0.10332364D+04,   0.19420D+01,   0.00000D+00/
  data pars( 43576: 43580) /142, 70,   0.10215311D+04,   0.19420D+01,   0.00000D+00/
  data pars( 43581: 43585) /142, 71,   0.85524570D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43586: 43590) /142, 72,   0.83345230D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43591: 43595) /142, 73,   0.75675320D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43596: 43600) /142, 74,   0.63690770D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43601: 43605) /142, 75,   0.64654950D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43606: 43610) /142, 76,   0.58352570D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43611: 43615) /142, 77,   0.53265790D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43616: 43620) /142, 78,   0.44119610D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43621: 43625) /142, 79,   0.41171360D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43626: 43630) /142, 80,   0.42271910D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43631: 43635) /142, 81,   0.62693260D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43636: 43640) /142, 82,   0.60866200D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43641: 43645) /142, 83,   0.55532550D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43646: 43650) /142, 84,   0.52759970D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43651: 43655) /142, 85,   0.48478900D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43656: 43660) /142, 86,   0.44266740D+03,   0.19420D+01,   0.00000D+00/
  data pars( 43661: 43665) /142, 87,   0.15815449D+04,   0.19420D+01,   0.00000D+00/
  data pars( 43666: 43670) /142, 88,   0.14962077D+04,   0.19420D+01,   0.00000D+00/
  data pars( 43671: 43675) /142, 89,   0.13112088D+04,   0.19420D+01,   0.00000D+00/
  data pars( 43676: 43680) /142, 90,   0.11676309D+04,   0.19420D+01,   0.00000D+00/
  data pars( 43681: 43685) /142, 91,   0.11649288D+04,   0.19420D+01,   0.00000D+00/
  data pars( 43686: 43690) /142, 92,   0.11276927D+04,   0.19420D+01,   0.00000D+00/
  data pars( 43691: 43695) /142, 93,   0.11676383D+04,   0.19420D+01,   0.00000D+00/
  data pars( 43696: 43700) /142, 94,   0.11294830D+04,   0.19420D+01,   0.00000D+00/
  data pars( 43701: 43705) /142,101,   0.60977300D+02,   0.19420D+01,   0.00000D+00/
  data pars( 43706: 43710) /142,103,   0.20251730D+03,   0.19420D+01,   0.98650D+00/
  data pars( 43711: 43715) /142,104,   0.25760880D+03,   0.19420D+01,   0.98080D+00/
  data pars( 43716: 43720) /142,105,   0.19375570D+03,   0.19420D+01,   0.97060D+00/
  data pars( 43721: 43725) /142,106,   0.14487380D+03,   0.19420D+01,   0.98680D+00/
  data pars( 43726: 43730) /142,107,   0.99938100D+02,   0.19420D+01,   0.99440D+00/
  data pars( 43731: 43735) /142,108,   0.72352000D+02,   0.19420D+01,   0.99250D+00/
  data pars( 43736: 43740) /142,109,   0.49416600D+02,   0.19420D+01,   0.99820D+00/
  data pars( 43741: 43745) /142,111,   0.29717130D+03,   0.19420D+01,   0.96840D+00/
  data pars( 43746: 43750) /142,112,   0.46042340D+03,   0.19420D+01,   0.96280D+00/
  data pars( 43751: 43755) /142,113,   0.46216780D+03,   0.19420D+01,   0.96480D+00/
  data pars( 43756: 43760) /142,114,   0.36695490D+03,   0.19420D+01,   0.95070D+00/
  data pars( 43761: 43765) /142,115,   0.29806610D+03,   0.19420D+01,   0.99470D+00/
  data pars( 43766: 43770) /142,116,   0.25075730D+03,   0.19420D+01,   0.99480D+00/
  data pars( 43771: 43775) /142,117,   0.20393970D+03,   0.19420D+01,   0.99720D+00/
  data pars( 43776: 43780) /142,119,   0.40759060D+03,   0.19420D+01,   0.97670D+00/
  data pars( 43781: 43785) /142,120,   0.79747730D+03,   0.19420D+01,   0.98310D+00/
  data pars( 43786: 43790) /142,121,   0.40315400D+03,   0.19420D+01,   0.18627D+01/
  data pars( 43791: 43795) /142,122,   0.38917870D+03,   0.19420D+01,   0.18299D+01/
  data pars( 43796: 43800) /142,123,   0.38148040D+03,   0.19420D+01,   0.19138D+01/
  data pars( 43801: 43805) /142,124,   0.37844740D+03,   0.19420D+01,   0.18269D+01/
  data pars( 43806: 43810) /142,125,   0.34604230D+03,   0.19420D+01,   0.16406D+01/
  data pars( 43811: 43815) /142,126,   0.31976370D+03,   0.19420D+01,   0.16483D+01/
  data pars( 43816: 43820) /142,127,   0.30508870D+03,   0.19420D+01,   0.17149D+01/
  data pars( 43821: 43825) /142,128,   0.29841290D+03,   0.19420D+01,   0.17937D+01/
  data pars( 43826: 43830) /142,129,   0.29619890D+03,   0.19420D+01,   0.95760D+00/
  data pars( 43831: 43835) /142,130,   0.27560550D+03,   0.19420D+01,   0.19419D+01/
  data pars( 43836: 43840) /142,131,   0.45716410D+03,   0.19420D+01,   0.96010D+00/
  data pars( 43841: 43845) /142,132,   0.39775920D+03,   0.19420D+01,   0.94340D+00/
  data pars( 43846: 43850) /142,133,   0.35418680D+03,   0.19420D+01,   0.98890D+00/
  data pars( 43851: 43855) /142,134,   0.32209780D+03,   0.19420D+01,   0.99010D+00/
  data pars( 43856: 43860) /142,135,   0.28249330D+03,   0.19420D+01,   0.99740D+00/
  data pars( 43861: 43865) /142,137,   0.48541290D+03,   0.19420D+01,   0.97380D+00/
  data pars( 43866: 43870) /142,138,   0.97212330D+03,   0.19420D+01,   0.98010D+00/
  data pars( 43871: 43875) /142,139,   0.73014460D+03,   0.19420D+01,   0.19153D+01/
  data pars( 43876: 43880) /142,140,   0.53401080D+03,   0.19420D+01,   0.19355D+01/
  data pars( 43881: 43885) /142,141,   0.53935320D+03,   0.19420D+01,   0.19545D+01/
  data pars( 43886: 43890) /142,142,   0.50200730D+03,   0.19420D+01,   0.19420D+01/
  data pars( 43891: 43895) /143,  1,   0.41338500D+02,   0.16682D+01,   0.91180D+00/
  data pars( 43896: 43900) /143,  2,   0.26621700D+02,   0.16682D+01,   0.00000D+00/
  data pars( 43901: 43905) /143,  3,   0.76378140D+03,   0.16682D+01,   0.00000D+00/
  data pars( 43906: 43910) /143,  4,   0.40277270D+03,   0.16682D+01,   0.00000D+00/
  data pars( 43911: 43915) /143,  5,   0.26037960D+03,   0.16682D+01,   0.00000D+00/
  data pars( 43916: 43920) /143,  6,   0.17125810D+03,   0.16682D+01,   0.00000D+00/
  data pars( 43921: 43925) /143,  7,   0.11764790D+03,   0.16682D+01,   0.00000D+00/
  data pars( 43926: 43930) /143,  8,   0.88060900D+02,   0.16682D+01,   0.00000D+00/
  data pars( 43931: 43935) /143,  9,   0.66109300D+02,   0.16682D+01,   0.00000D+00/
  data pars( 43936: 43940) /143, 10,   0.50508700D+02,   0.16682D+01,   0.00000D+00/
  data pars( 43941: 43945) /143, 11,   0.90840250D+03,   0.16682D+01,   0.00000D+00/
  data pars( 43946: 43950) /143, 12,   0.65125640D+03,   0.16682D+01,   0.00000D+00/
  data pars( 43951: 43955) /143, 13,   0.58698620D+03,   0.16682D+01,   0.00000D+00/
  data pars( 43956: 43960) /143, 14,   0.44911910D+03,   0.16682D+01,   0.00000D+00/
  data pars( 43961: 43965) /143, 15,   0.34248830D+03,   0.16682D+01,   0.00000D+00/
  data pars( 43966: 43970) /143, 16,   0.28056130D+03,   0.16682D+01,   0.00000D+00/
  data pars( 43971: 43975) /143, 17,   0.22648330D+03,   0.16682D+01,   0.00000D+00/
  data pars( 43976: 43980) /143, 18,   0.18352050D+03,   0.16682D+01,   0.00000D+00/
  data pars( 43981: 43985) /143, 19,   0.15188755D+04,   0.16682D+01,   0.00000D+00/
  data pars( 43986: 43990) /143, 20,   0.11783302D+04,   0.16682D+01,   0.00000D+00/
  data pars( 43991: 43995) /143, 21,   0.96136570D+03,   0.16682D+01,   0.00000D+00/
  data pars( 43996: 44000) /143, 22,   0.91930990D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44001: 44005) /143, 23,   0.83673410D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44006: 44010) /143, 24,   0.65972010D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44011: 44015) /143, 25,   0.71418300D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44016: 44020) /143, 26,   0.56036480D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44021: 44025) /143, 27,   0.58529350D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44026: 44030) /143, 28,   0.60647400D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44031: 44035) /143, 29,   0.46581470D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44036: 44040) /143, 30,   0.46845290D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44041: 44045) /143, 31,   0.55815220D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44046: 44050) /143, 32,   0.48089260D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44051: 44055) /143, 33,   0.40245400D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44056: 44060) /143, 34,   0.35725110D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44061: 44065) /143, 35,   0.30935300D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44066: 44070) /143, 36,   0.26657770D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44071: 44075) /143, 37,   0.16961214D+04,   0.16682D+01,   0.00000D+00/
  data pars( 44076: 44080) /143, 38,   0.14083895D+04,   0.16682D+01,   0.00000D+00/
  data pars( 44081: 44085) /143, 39,   0.12079868D+04,   0.16682D+01,   0.00000D+00/
  data pars( 44086: 44090) /143, 40,   0.10721935D+04,   0.16682D+01,   0.00000D+00/
  data pars( 44091: 44095) /143, 41,   0.97020700D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44096: 44100) /143, 42,   0.73979150D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44101: 44105) /143, 43,   0.82924080D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44106: 44110) /143, 44,   0.62313860D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44111: 44115) /143, 45,   0.68005240D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44116: 44120) /143, 46,   0.62758100D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44121: 44125) /143, 47,   0.52609770D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44126: 44130) /143, 48,   0.54963380D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44131: 44135) /143, 49,   0.70042290D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44136: 44140) /143, 50,   0.63478310D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44141: 44145) /143, 51,   0.55577940D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44146: 44150) /143, 52,   0.51056820D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44151: 44155) /143, 53,   0.45697070D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44156: 44160) /143, 54,   0.40709700D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44161: 44165) /143, 55,   0.20688557D+04,   0.16682D+01,   0.00000D+00/
  data pars( 44166: 44170) /143, 56,   0.18110626D+04,   0.16682D+01,   0.00000D+00/
  data pars( 44171: 44175) /143, 57,   0.15570674D+04,   0.16682D+01,   0.00000D+00/
  data pars( 44176: 44180) /143, 58,   0.65923480D+03,   0.16682D+01,   0.27991D+01/
  data pars( 44181: 44185) /143, 59,   0.15936331D+04,   0.16682D+01,   0.00000D+00/
  data pars( 44186: 44190) /143, 60,   0.15238714D+04,   0.16682D+01,   0.00000D+00/
  data pars( 44191: 44195) /143, 61,   0.14839817D+04,   0.16682D+01,   0.00000D+00/
  data pars( 44196: 44200) /143, 62,   0.14474665D+04,   0.16682D+01,   0.00000D+00/
  data pars( 44201: 44205) /143, 63,   0.14150358D+04,   0.16682D+01,   0.00000D+00/
  data pars( 44206: 44210) /143, 64,   0.10889839D+04,   0.16682D+01,   0.00000D+00/
  data pars( 44211: 44215) /143, 65,   0.12727235D+04,   0.16682D+01,   0.00000D+00/
  data pars( 44216: 44220) /143, 66,   0.12232739D+04,   0.16682D+01,   0.00000D+00/
  data pars( 44221: 44225) /143, 67,   0.12689174D+04,   0.16682D+01,   0.00000D+00/
  data pars( 44226: 44230) /143, 68,   0.12411151D+04,   0.16682D+01,   0.00000D+00/
  data pars( 44231: 44235) /143, 69,   0.12157298D+04,   0.16682D+01,   0.00000D+00/
  data pars( 44236: 44240) /143, 70,   0.12025314D+04,   0.16682D+01,   0.00000D+00/
  data pars( 44241: 44245) /143, 71,   0.99886140D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44246: 44250) /143, 72,   0.96131920D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44251: 44255) /143, 73,   0.86700540D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44256: 44260) /143, 74,   0.72670660D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44261: 44265) /143, 75,   0.73557240D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44266: 44270) /143, 76,   0.66018700D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44271: 44275) /143, 77,   0.60002740D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44276: 44280) /143, 78,   0.49511760D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44281: 44285) /143, 79,   0.46130260D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44286: 44290) /143, 80,   0.47242330D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44291: 44295) /143, 81,   0.71722290D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44296: 44300) /143, 82,   0.68964350D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44301: 44305) /143, 83,   0.62335390D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44306: 44310) /143, 84,   0.58927250D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44311: 44315) /143, 85,   0.53837470D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44316: 44320) /143, 86,   0.48918620D+03,   0.16682D+01,   0.00000D+00/
  data pars( 44321: 44325) /143, 87,   0.19184029D+04,   0.16682D+01,   0.00000D+00/
  data pars( 44326: 44330) /143, 88,   0.17715639D+04,   0.16682D+01,   0.00000D+00/
  data pars( 44331: 44335) /143, 89,   0.15346792D+04,   0.16682D+01,   0.00000D+00/
  data pars( 44336: 44340) /143, 90,   0.13502400D+04,   0.16682D+01,   0.00000D+00/
  data pars( 44341: 44345) /143, 91,   0.13560504D+04,   0.16682D+01,   0.00000D+00/
  data pars( 44346: 44350) /143, 92,   0.13122121D+04,   0.16682D+01,   0.00000D+00/
  data pars( 44351: 44355) /143, 93,   0.13686610D+04,   0.16682D+01,   0.00000D+00/
  data pars( 44356: 44360) /143, 94,   0.13219594D+04,   0.16682D+01,   0.00000D+00/
  data pars( 44361: 44365) /143,101,   0.67892400D+02,   0.16682D+01,   0.00000D+00/
  data pars( 44366: 44370) /143,103,   0.23295390D+03,   0.16682D+01,   0.98650D+00/
  data pars( 44371: 44375) /143,104,   0.29538160D+03,   0.16682D+01,   0.98080D+00/
  data pars( 44376: 44380) /143,105,   0.21747620D+03,   0.16682D+01,   0.97060D+00/
  data pars( 44381: 44385) /143,106,   0.16092230D+03,   0.16682D+01,   0.98680D+00/
  data pars( 44386: 44390) /143,107,   0.10977550D+03,   0.16682D+01,   0.99440D+00/
  data pars( 44391: 44395) /143,108,   0.78792000D+02,   0.16682D+01,   0.99250D+00/
  data pars( 44396: 44400) /143,109,   0.53288000D+02,   0.16682D+01,   0.99820D+00/
  data pars( 44401: 44405) /143,111,   0.34355920D+03,   0.16682D+01,   0.96840D+00/
  data pars( 44406: 44410) /143,112,   0.53370850D+03,   0.16682D+01,   0.96280D+00/
  data pars( 44411: 44415) /143,113,   0.52930430D+03,   0.16682D+01,   0.96480D+00/
  data pars( 44416: 44420) /143,114,   0.41359910D+03,   0.16682D+01,   0.95070D+00/
  data pars( 44421: 44425) /143,115,   0.33227830D+03,   0.16682D+01,   0.99470D+00/
  data pars( 44426: 44430) /143,116,   0.27760020D+03,   0.16682D+01,   0.99480D+00/
  data pars( 44431: 44435) /143,117,   0.22420950D+03,   0.16682D+01,   0.99720D+00/
  data pars( 44436: 44440) /143,119,   0.46809770D+03,   0.16682D+01,   0.97670D+00/
  data pars( 44441: 44445) /143,120,   0.94599430D+03,   0.16682D+01,   0.98310D+00/
  data pars( 44446: 44450) /143,121,   0.45591090D+03,   0.16682D+01,   0.18627D+01/
  data pars( 44451: 44455) /143,122,   0.44025610D+03,   0.16682D+01,   0.18299D+01/
  data pars( 44456: 44460) /143,123,   0.43163910D+03,   0.16682D+01,   0.19138D+01/
  data pars( 44461: 44465) /143,124,   0.42896620D+03,   0.16682D+01,   0.18269D+01/
  data pars( 44466: 44470) /143,125,   0.38890660D+03,   0.16682D+01,   0.16406D+01/
  data pars( 44471: 44475) /143,126,   0.35865620D+03,   0.16682D+01,   0.16483D+01/
  data pars( 44476: 44480) /143,127,   0.34229790D+03,   0.16682D+01,   0.17149D+01/
  data pars( 44481: 44485) /143,128,   0.33502870D+03,   0.16682D+01,   0.17937D+01/
  data pars( 44486: 44490) /143,129,   0.33456150D+03,   0.16682D+01,   0.95760D+00/
  data pars( 44491: 44495) /143,130,   0.30788150D+03,   0.16682D+01,   0.19419D+01/
  data pars( 44496: 44500) /143,131,   0.52114410D+03,   0.16682D+01,   0.96010D+00/
  data pars( 44501: 44505) /143,132,   0.44771310D+03,   0.16682D+01,   0.94340D+00/
  data pars( 44506: 44510) /143,133,   0.39524720D+03,   0.16682D+01,   0.98890D+00/
  data pars( 44511: 44515) /143,134,   0.35747370D+03,   0.16682D+01,   0.99010D+00/
  data pars( 44516: 44520) /143,135,   0.31169010D+03,   0.16682D+01,   0.99740D+00/
  data pars( 44521: 44525) /143,137,   0.55612550D+03,   0.16682D+01,   0.97380D+00/
  data pars( 44526: 44530) /143,138,   0.11562604D+04,   0.16682D+01,   0.98010D+00/
  data pars( 44531: 44535) /143,139,   0.84837270D+03,   0.16682D+01,   0.19153D+01/
  data pars( 44536: 44540) /143,140,   0.60533890D+03,   0.16682D+01,   0.19355D+01/
  data pars( 44541: 44545) /143,141,   0.61127640D+03,   0.16682D+01,   0.19545D+01/
  data pars( 44546: 44550) /143,142,   0.56776700D+03,   0.16682D+01,   0.19420D+01/
  data pars( 44551: 44555) /143,143,   0.64971430D+03,   0.16682D+01,   0.16682D+01/
  data pars( 44556: 44560) /144,  1,   0.33187500D+02,   0.18584D+01,   0.91180D+00/
  data pars( 44561: 44565) /144,  2,   0.22061600D+02,   0.18584D+01,   0.00000D+00/
  data pars( 44566: 44570) /144,  3,   0.51733300D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44571: 44575) /144,  4,   0.29751860D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44576: 44580) /144,  5,   0.20032990D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44581: 44585) /144,  6,   0.13555170D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44586: 44590) /144,  7,   0.95019000D+02,   0.18584D+01,   0.00000D+00/
  data pars( 44591: 44595) /144,  8,   0.72117300D+02,   0.18584D+01,   0.00000D+00/
  data pars( 44596: 44600) /144,  9,   0.54778100D+02,   0.18584D+01,   0.00000D+00/
  data pars( 44601: 44605) /144, 10,   0.42243200D+02,   0.18584D+01,   0.00000D+00/
  data pars( 44606: 44610) /144, 11,   0.61866690D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44611: 44615) /144, 12,   0.47441800D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44616: 44620) /144, 13,   0.43702090D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44621: 44625) /144, 14,   0.34421130D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44626: 44630) /144, 15,   0.26854160D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44631: 44635) /144, 16,   0.22308830D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44636: 44640) /144, 17,   0.18247210D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44641: 44645) /144, 18,   0.14952220D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44646: 44650) /144, 19,   0.10157997D+04,   0.18584D+01,   0.00000D+00/
  data pars( 44651: 44655) /144, 20,   0.83526920D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44656: 44660) /144, 21,   0.68960880D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44661: 44665) /144, 22,   0.66581430D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44666: 44670) /144, 23,   0.60961590D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44671: 44675) /144, 24,   0.48063820D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44676: 44680) /144, 25,   0.52477480D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44681: 44685) /144, 26,   0.41224680D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44686: 44690) /144, 27,   0.43640540D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44691: 44695) /144, 28,   0.44958060D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44696: 44700) /144, 29,   0.34510430D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44701: 44705) /144, 30,   0.35378800D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44706: 44710) /144, 31,   0.41885730D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44711: 44715) /144, 32,   0.36917340D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44716: 44720) /144, 33,   0.31492530D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44721: 44725) /144, 34,   0.28273020D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44726: 44730) /144, 35,   0.24762030D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44731: 44735) /144, 36,   0.21556830D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44736: 44740) /144, 37,   0.11385265D+04,   0.18584D+01,   0.00000D+00/
  data pars( 44741: 44745) /144, 38,   0.99561160D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44746: 44750) /144, 39,   0.87126000D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44751: 44755) /144, 40,   0.78271660D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44756: 44760) /144, 41,   0.71364770D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44761: 44765) /144, 42,   0.55112400D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44766: 44770) /144, 43,   0.61481850D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44771: 44775) /144, 44,   0.46856950D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44776: 44780) /144, 45,   0.51183150D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44781: 44785) /144, 46,   0.47463690D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44786: 44790) /144, 47,   0.39627420D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44791: 44795) /144, 48,   0.41825790D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44796: 44800) /144, 49,   0.52482360D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44801: 44805) /144, 50,   0.48488550D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44806: 44810) /144, 51,   0.43198650D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44811: 44815) /144, 52,   0.40083190D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44816: 44820) /144, 53,   0.36253740D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44821: 44825) /144, 54,   0.32611570D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44826: 44830) /144, 55,   0.13871242D+04,   0.18584D+01,   0.00000D+00/
  data pars( 44831: 44835) /144, 56,   0.12701002D+04,   0.18584D+01,   0.00000D+00/
  data pars( 44836: 44840) /144, 57,   0.11145962D+04,   0.18584D+01,   0.00000D+00/
  data pars( 44841: 44845) /144, 58,   0.51058640D+03,   0.18584D+01,   0.27991D+01/
  data pars( 44846: 44850) /144, 59,   0.11251127D+04,   0.18584D+01,   0.00000D+00/
  data pars( 44851: 44855) /144, 60,   0.10801628D+04,   0.18584D+01,   0.00000D+00/
  data pars( 44856: 44860) /144, 61,   0.10529974D+04,   0.18584D+01,   0.00000D+00/
  data pars( 44861: 44865) /144, 62,   0.10280158D+04,   0.18584D+01,   0.00000D+00/
  data pars( 44866: 44870) /144, 63,   0.10058586D+04,   0.18584D+01,   0.00000D+00/
  data pars( 44871: 44875) /144, 64,   0.79051760D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44876: 44880) /144, 65,   0.89187640D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44881: 44885) /144, 66,   0.85997290D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44886: 44890) /144, 67,   0.90692140D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44891: 44895) /144, 68,   0.88762020D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44896: 44900) /144, 69,   0.87020630D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44901: 44905) /144, 70,   0.86003450D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44906: 44910) /144, 71,   0.72429040D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44911: 44915) /144, 72,   0.71147790D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44916: 44920) /144, 73,   0.64914710D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44921: 44925) /144, 74,   0.54842120D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44926: 44930) /144, 75,   0.55775610D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44931: 44935) /144, 76,   0.50549330D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44936: 44940) /144, 77,   0.46298700D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44941: 44945) /144, 78,   0.38491460D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44946: 44950) /144, 79,   0.35974270D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44951: 44955) /144, 80,   0.36989520D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44956: 44960) /144, 81,   0.53929820D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44961: 44965) /144, 82,   0.52677380D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44966: 44970) /144, 83,   0.48381430D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44971: 44975) /144, 84,   0.46139360D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44976: 44980) /144, 85,   0.42587210D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44981: 44985) /144, 86,   0.39047110D+03,   0.18584D+01,   0.00000D+00/
  data pars( 44986: 44990) /144, 87,   0.13086904D+04,   0.18584D+01,   0.00000D+00/
  data pars( 44991: 44995) /144, 88,   0.12553593D+04,   0.18584D+01,   0.00000D+00/
  data pars( 44996: 45000) /144, 89,   0.11084934D+04,   0.18584D+01,   0.00000D+00/
  data pars( 45001: 45005) /144, 90,   0.99548230D+03,   0.18584D+01,   0.00000D+00/
  data pars( 45006: 45010) /144, 91,   0.98913640D+03,   0.18584D+01,   0.00000D+00/
  data pars( 45011: 45015) /144, 92,   0.95777810D+03,   0.18584D+01,   0.00000D+00/
  data pars( 45016: 45020) /144, 93,   0.98673520D+03,   0.18584D+01,   0.00000D+00/
  data pars( 45021: 45025) /144, 94,   0.95542490D+03,   0.18584D+01,   0.00000D+00/
  data pars( 45026: 45030) /144,101,   0.53364800D+02,   0.18584D+01,   0.00000D+00/
  data pars( 45031: 45035) /144,103,   0.17297080D+03,   0.18584D+01,   0.98650D+00/
  data pars( 45036: 45040) /144,104,   0.22067460D+03,   0.18584D+01,   0.98080D+00/
  data pars( 45041: 45045) /144,105,   0.16859440D+03,   0.18584D+01,   0.97060D+00/
  data pars( 45046: 45050) /144,106,   0.12721250D+03,   0.18584D+01,   0.98680D+00/
  data pars( 45051: 45055) /144,107,   0.88661300D+02,   0.18584D+01,   0.99440D+00/
  data pars( 45056: 45060) /144,108,   0.64744800D+02,   0.18584D+01,   0.99250D+00/
  data pars( 45061: 45065) /144,109,   0.44708700D+02,   0.18584D+01,   0.99820D+00/
  data pars( 45066: 45070) /144,111,   0.25309000D+03,   0.18584D+01,   0.96840D+00/
  data pars( 45071: 45075) /144,112,   0.39136060D+03,   0.18584D+01,   0.96280D+00/
  data pars( 45076: 45080) /144,113,   0.39606340D+03,   0.18584D+01,   0.96480D+00/
  data pars( 45081: 45085) /144,114,   0.31817950D+03,   0.18584D+01,   0.95070D+00/
  data pars( 45086: 45090) /144,115,   0.26070120D+03,   0.18584D+01,   0.99470D+00/
  data pars( 45091: 45095) /144,116,   0.22064770D+03,   0.18584D+01,   0.99480D+00/
  data pars( 45096: 45100) /144,117,   0.18059160D+03,   0.18584D+01,   0.99720D+00/
  data pars( 45101: 45105) /144,119,   0.34947530D+03,   0.18584D+01,   0.97670D+00/
  data pars( 45106: 45110) /144,120,   0.66876460D+03,   0.18584D+01,   0.98310D+00/
  data pars( 45111: 45115) /144,121,   0.34907020D+03,   0.18584D+01,   0.18627D+01/
  data pars( 45116: 45120) /144,122,   0.33705530D+03,   0.18584D+01,   0.18299D+01/
  data pars( 45121: 45125) /144,123,   0.33035670D+03,   0.18584D+01,   0.19138D+01/
  data pars( 45126: 45130) /144,124,   0.32735530D+03,   0.18584D+01,   0.18269D+01/
  data pars( 45131: 45135) /144,125,   0.30103970D+03,   0.18584D+01,   0.16406D+01/
  data pars( 45136: 45140) /144,126,   0.27865260D+03,   0.18584D+01,   0.16483D+01/
  data pars( 45141: 45145) /144,127,   0.26587520D+03,   0.18584D+01,   0.17149D+01/
  data pars( 45146: 45150) /144,128,   0.25994720D+03,   0.18584D+01,   0.17937D+01/
  data pars( 45151: 45155) /144,129,   0.25694800D+03,   0.18584D+01,   0.95760D+00/
  data pars( 45156: 45160) /144,130,   0.24091240D+03,   0.18584D+01,   0.19419D+01/
  data pars( 45161: 45165) /144,131,   0.39335710D+03,   0.18584D+01,   0.96010D+00/
  data pars( 45166: 45170) /144,132,   0.34538720D+03,   0.18584D+01,   0.94340D+00/
  data pars( 45171: 45175) /144,133,   0.30960350D+03,   0.18584D+01,   0.98890D+00/
  data pars( 45176: 45180) /144,134,   0.28284600D+03,   0.18584D+01,   0.99010D+00/
  data pars( 45181: 45185) /144,135,   0.24934040D+03,   0.18584D+01,   0.99740D+00/
  data pars( 45186: 45190) /144,137,   0.41708310D+03,   0.18584D+01,   0.97380D+00/
  data pars( 45191: 45195) /144,138,   0.81419750D+03,   0.18584D+01,   0.98010D+00/
  data pars( 45196: 45200) /144,139,   0.62130580D+03,   0.18584D+01,   0.19153D+01/
  data pars( 45201: 45205) /144,140,   0.46191410D+03,   0.18584D+01,   0.19355D+01/
  data pars( 45206: 45210) /144,141,   0.46653580D+03,   0.18584D+01,   0.19545D+01/
  data pars( 45211: 45215) /144,142,   0.43510620D+03,   0.18584D+01,   0.19420D+01/
  data pars( 45216: 45220) /144,143,   0.48832640D+03,   0.18584D+01,   0.16682D+01/
  data pars( 45221: 45225) /144,144,   0.37926550D+03,   0.18584D+01,   0.18584D+01/
  data pars( 45226: 45230) /145,  1,   0.31102400D+02,   0.19003D+01,   0.91180D+00/
  data pars( 45231: 45235) /145,  2,   0.20777600D+02,   0.19003D+01,   0.00000D+00/
  data pars( 45236: 45240) /145,  3,   0.48243420D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45241: 45245) /145,  4,   0.27741740D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45246: 45250) /145,  5,   0.18713270D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45251: 45255) /145,  6,   0.12690850D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45256: 45260) /145,  7,   0.89165900D+02,   0.19003D+01,   0.00000D+00/
  data pars( 45261: 45265) /145,  8,   0.67811400D+02,   0.19003D+01,   0.00000D+00/
  data pars( 45266: 45270) /145,  9,   0.51611700D+02,   0.19003D+01,   0.00000D+00/
  data pars( 45271: 45275) /145, 10,   0.39876200D+02,   0.19003D+01,   0.00000D+00/
  data pars( 45276: 45280) /145, 11,   0.57701810D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45281: 45285) /145, 12,   0.44233810D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45286: 45290) /145, 13,   0.40769990D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45291: 45295) /145, 14,   0.32145940D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45296: 45300) /145, 15,   0.25114770D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45301: 45305) /145, 16,   0.20890670D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45306: 45310) /145, 17,   0.17111870D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45311: 45315) /145, 18,   0.14042730D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45316: 45320) /145, 19,   0.94851400D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45321: 45325) /145, 20,   0.77905470D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45326: 45330) /145, 21,   0.64318930D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45331: 45335) /145, 22,   0.62118070D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45336: 45340) /145, 23,   0.56883480D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45341: 45345) /145, 24,   0.44875270D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45346: 45350) /145, 25,   0.48979330D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45351: 45355) /145, 26,   0.38501530D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45356: 45360) /145, 27,   0.40745740D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45361: 45365) /145, 28,   0.41967090D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45366: 45370) /145, 29,   0.32239880D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45371: 45375) /145, 30,   0.33047130D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45376: 45380) /145, 31,   0.39105080D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45381: 45385) /145, 32,   0.34491000D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45386: 45390) /145, 33,   0.29454210D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45391: 45395) /145, 34,   0.26467170D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45396: 45400) /145, 35,   0.23205800D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45401: 45405) /145, 36,   0.20225670D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45406: 45410) /145, 37,   0.10633477D+04,   0.19003D+01,   0.00000D+00/
  data pars( 45411: 45415) /145, 38,   0.92882550D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45416: 45420) /145, 39,   0.81293380D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45421: 45425) /145, 40,   0.73049700D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45426: 45430) /145, 41,   0.66622590D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45431: 45435) /145, 42,   0.51491280D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45436: 45440) /145, 43,   0.57424560D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45441: 45445) /145, 44,   0.43804260D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45446: 45450) /145, 45,   0.47828480D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45451: 45455) /145, 46,   0.44362800D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45456: 45460) /145, 47,   0.37063780D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45461: 45465) /145, 48,   0.39106750D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45466: 45470) /145, 49,   0.49033250D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45471: 45475) /145, 50,   0.45317940D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45476: 45480) /145, 51,   0.40403840D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45481: 45485) /145, 52,   0.37513030D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45486: 45490) /145, 53,   0.33956200D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45491: 45495) /145, 54,   0.30572010D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45496: 45500) /145, 55,   0.12958507D+04,   0.19003D+01,   0.00000D+00/
  data pars( 45501: 45505) /145, 56,   0.11851747D+04,   0.19003D+01,   0.00000D+00/
  data pars( 45506: 45510) /145, 57,   0.10401066D+04,   0.19003D+01,   0.00000D+00/
  data pars( 45511: 45515) /145, 58,   0.47759450D+03,   0.19003D+01,   0.27991D+01/
  data pars( 45516: 45520) /145, 59,   0.10500763D+04,   0.19003D+01,   0.00000D+00/
  data pars( 45521: 45525) /145, 60,   0.10080521D+04,   0.19003D+01,   0.00000D+00/
  data pars( 45526: 45530) /145, 61,   0.98268750D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45531: 45535) /145, 62,   0.95935980D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45536: 45540) /145, 63,   0.93866880D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45541: 45545) /145, 64,   0.73813170D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45546: 45550) /145, 65,   0.83296700D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45551: 45555) /145, 66,   0.80325110D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45556: 45560) /145, 67,   0.84631030D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45561: 45565) /145, 68,   0.82828260D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45566: 45570) /145, 69,   0.81202140D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45571: 45575) /145, 70,   0.80250260D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45576: 45580) /145, 71,   0.67613200D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45581: 45585) /145, 72,   0.66419530D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45586: 45590) /145, 73,   0.60624630D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45591: 45595) /145, 74,   0.51256560D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45596: 45600) /145, 75,   0.52130610D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45601: 45605) /145, 76,   0.47268090D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45606: 45610) /145, 77,   0.43312920D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45611: 45615) /145, 78,   0.36041730D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45616: 45620) /145, 79,   0.33697140D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45621: 45625) /145, 80,   0.34645260D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45626: 45630) /145, 81,   0.50424040D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45631: 45635) /145, 82,   0.49256890D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45636: 45640) /145, 83,   0.45264510D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45641: 45645) /145, 84,   0.43185880D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45646: 45650) /145, 85,   0.39887680D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45651: 45655) /145, 86,   0.36599140D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45656: 45660) /145, 87,   0.12224485D+04,   0.19003D+01,   0.00000D+00/
  data pars( 45661: 45665) /145, 88,   0.11715378D+04,   0.19003D+01,   0.00000D+00/
  data pars( 45666: 45670) /145, 89,   0.10345633D+04,   0.19003D+01,   0.00000D+00/
  data pars( 45671: 45675) /145, 90,   0.92953190D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45676: 45680) /145, 91,   0.92366730D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45681: 45685) /145, 92,   0.89441350D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45686: 45690) /145, 93,   0.92128530D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45691: 45695) /145, 94,   0.89206410D+03,   0.19003D+01,   0.00000D+00/
  data pars( 45696: 45700) /145,101,   0.49909000D+02,   0.19003D+01,   0.00000D+00/
  data pars( 45701: 45705) /145,103,   0.16134990D+03,   0.19003D+01,   0.98650D+00/
  data pars( 45706: 45710) /145,104,   0.20595300D+03,   0.19003D+01,   0.98080D+00/
  data pars( 45711: 45715) /145,105,   0.15759490D+03,   0.19003D+01,   0.97060D+00/
  data pars( 45716: 45720) /145,106,   0.11912650D+03,   0.19003D+01,   0.98680D+00/
  data pars( 45721: 45725) /145,107,   0.83222700D+02,   0.19003D+01,   0.99440D+00/
  data pars( 45726: 45730) /145,108,   0.60915900D+02,   0.19003D+01,   0.99250D+00/
  data pars( 45731: 45735) /145,109,   0.42208400D+02,   0.19003D+01,   0.99820D+00/
  data pars( 45736: 45740) /145,111,   0.23614440D+03,   0.19003D+01,   0.96840D+00/
  data pars( 45741: 45745) /145,112,   0.36507050D+03,   0.19003D+01,   0.96280D+00/
  data pars( 45746: 45750) /145,113,   0.36958140D+03,   0.19003D+01,   0.96480D+00/
  data pars( 45751: 45755) /145,114,   0.29723390D+03,   0.19003D+01,   0.95070D+00/
  data pars( 45756: 45760) /145,115,   0.24384390D+03,   0.19003D+01,   0.99470D+00/
  data pars( 45761: 45765) /145,116,   0.20662580D+03,   0.19003D+01,   0.99480D+00/
  data pars( 45766: 45770) /145,117,   0.16935840D+03,   0.19003D+01,   0.99720D+00/
  data pars( 45771: 45775) /145,119,   0.32659470D+03,   0.19003D+01,   0.97670D+00/
  data pars( 45776: 45780) /145,120,   0.62428500D+03,   0.19003D+01,   0.98310D+00/
  data pars( 45781: 45785) /145,121,   0.32625030D+03,   0.19003D+01,   0.18627D+01/
  data pars( 45786: 45790) /145,122,   0.31509820D+03,   0.19003D+01,   0.18299D+01/
  data pars( 45791: 45795) /145,123,   0.30884820D+03,   0.19003D+01,   0.19138D+01/
  data pars( 45796: 45800) /145,124,   0.30603400D+03,   0.19003D+01,   0.18269D+01/
  data pars( 45801: 45805) /145,125,   0.28151340D+03,   0.19003D+01,   0.16406D+01/
  data pars( 45806: 45810) /145,126,   0.26065670D+03,   0.19003D+01,   0.16483D+01/
  data pars( 45811: 45815) /145,127,   0.24873880D+03,   0.19003D+01,   0.17149D+01/
  data pars( 45816: 45820) /145,128,   0.24319090D+03,   0.19003D+01,   0.17937D+01/
  data pars( 45821: 45825) /145,129,   0.24032600D+03,   0.19003D+01,   0.95760D+00/
  data pars( 45826: 45830) /145,130,   0.22543980D+03,   0.19003D+01,   0.19419D+01/
  data pars( 45831: 45835) /145,131,   0.36731970D+03,   0.19003D+01,   0.96010D+00/
  data pars( 45836: 45840) /145,132,   0.32278160D+03,   0.19003D+01,   0.94340D+00/
  data pars( 45841: 45845) /145,133,   0.28959340D+03,   0.19003D+01,   0.98890D+00/
  data pars( 45846: 45850) /145,134,   0.26478150D+03,   0.19003D+01,   0.99010D+00/
  data pars( 45851: 45855) /145,135,   0.23366080D+03,   0.19003D+01,   0.99740D+00/
  data pars( 45856: 45860) /145,137,   0.38991830D+03,   0.19003D+01,   0.97380D+00/
  data pars( 45861: 45865) /145,138,   0.76024370D+03,   0.19003D+01,   0.98010D+00/
  data pars( 45866: 45870) /145,139,   0.58041450D+03,   0.19003D+01,   0.19153D+01/
  data pars( 45871: 45875) /145,140,   0.43182880D+03,   0.19003D+01,   0.19355D+01/
  data pars( 45876: 45880) /145,141,   0.43614400D+03,   0.19003D+01,   0.19545D+01/
  data pars( 45881: 45885) /145,142,   0.40693380D+03,   0.19003D+01,   0.19420D+01/
  data pars( 45886: 45890) /145,143,   0.45656180D+03,   0.19003D+01,   0.16682D+01/
  data pars( 45891: 45895) /145,144,   0.35492820D+03,   0.19003D+01,   0.18584D+01/
  data pars( 45896: 45900) /145,145,   0.33224250D+03,   0.19003D+01,   0.19003D+01/
  data pars( 45901: 45905) /146,  1,   0.28966100D+02,   0.18630D+01,   0.91180D+00/
  data pars( 45906: 45910) /146,  2,   0.19468900D+02,   0.18630D+01,   0.00000D+00/
  data pars( 45911: 45915) /146,  3,   0.44391060D+03,   0.18630D+01,   0.00000D+00/
  data pars( 45916: 45920) /146,  4,   0.25623270D+03,   0.18630D+01,   0.00000D+00/
  data pars( 45921: 45925) /146,  5,   0.17343600D+03,   0.18630D+01,   0.00000D+00/
  data pars( 45926: 45930) /146,  6,   0.11801370D+03,   0.18630D+01,   0.00000D+00/
  data pars( 45931: 45935) /146,  7,   0.83171000D+02,   0.18630D+01,   0.00000D+00/
  data pars( 45936: 45940) /146,  8,   0.63412500D+02,   0.18630D+01,   0.00000D+00/
  data pars( 45941: 45945) /146,  9,   0.48382400D+02,   0.18630D+01,   0.00000D+00/
  data pars( 45946: 45950) /146, 10,   0.37464700D+02,   0.18630D+01,   0.00000D+00/
  data pars( 45951: 45955) /146, 11,   0.53116760D+03,   0.18630D+01,   0.00000D+00/
  data pars( 45956: 45960) /146, 12,   0.40830220D+03,   0.18630D+01,   0.00000D+00/
  data pars( 45961: 45965) /146, 13,   0.37687760D+03,   0.18630D+01,   0.00000D+00/
  data pars( 45966: 45970) /146, 14,   0.29781740D+03,   0.18630D+01,   0.00000D+00/
  data pars( 45971: 45975) /146, 15,   0.23321060D+03,   0.18630D+01,   0.00000D+00/
  data pars( 45976: 45980) /146, 16,   0.19433730D+03,   0.18630D+01,   0.00000D+00/
  data pars( 45981: 45985) /146, 17,   0.15949140D+03,   0.18630D+01,   0.00000D+00/
  data pars( 45986: 45990) /146, 18,   0.13113380D+03,   0.18630D+01,   0.00000D+00/
  data pars( 45991: 45995) /146, 19,   0.87329840D+03,   0.18630D+01,   0.00000D+00/
  data pars( 45996: 46000) /146, 20,   0.71849830D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46001: 46005) /146, 21,   0.59349940D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46006: 46010) /146, 22,   0.57359720D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46011: 46015) /146, 23,   0.52547320D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46016: 46020) /146, 24,   0.41479180D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46021: 46025) /146, 25,   0.45273530D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46026: 46030) /146, 26,   0.35613440D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46031: 46035) /146, 27,   0.37699280D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46036: 46040) /146, 28,   0.38812000D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46041: 46045) /146, 29,   0.29838940D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46046: 46050) /146, 30,   0.30606330D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46051: 46055) /146, 31,   0.36187800D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46056: 46060) /146, 32,   0.31969460D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46061: 46065) /146, 33,   0.27350100D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46066: 46070) /146, 34,   0.24609210D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46071: 46075) /146, 35,   0.21609450D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46076: 46080) /146, 36,   0.18863390D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46081: 46085) /146, 37,   0.97940320D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46086: 46090) /146, 38,   0.85671690D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46091: 46095) /146, 39,   0.75059330D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46096: 46100) /146, 40,   0.67499290D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46101: 46105) /146, 41,   0.61597590D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46106: 46110) /146, 42,   0.47670900D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46111: 46115) /146, 43,   0.53137000D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46116: 46120) /146, 44,   0.40593980D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46121: 46125) /146, 45,   0.44306590D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46126: 46130) /146, 46,   0.41113610D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46131: 46135) /146, 47,   0.34367070D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46136: 46140) /146, 48,   0.36264320D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46141: 46145) /146, 49,   0.45405760D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46146: 46150) /146, 50,   0.42012680D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46151: 46155) /146, 51,   0.37509950D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46156: 46160) /146, 52,   0.34860740D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46161: 46165) /146, 53,   0.31592880D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46166: 46170) /146, 54,   0.28479640D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46171: 46175) /146, 55,   0.11937040D+04,   0.18630D+01,   0.00000D+00/
  data pars( 46176: 46180) /146, 56,   0.10930044D+04,   0.18630D+01,   0.00000D+00/
  data pars( 46181: 46185) /146, 57,   0.96013460D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46186: 46190) /146, 58,   0.44336290D+03,   0.18630D+01,   0.27991D+01/
  data pars( 46191: 46195) /146, 59,   0.96887580D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46196: 46200) /146, 60,   0.93022500D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46201: 46205) /146, 61,   0.90685110D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46206: 46210) /146, 62,   0.88534770D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46211: 46215) /146, 63,   0.86627480D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46216: 46220) /146, 64,   0.68220730D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46221: 46225) /146, 65,   0.76879040D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46226: 46230) /146, 66,   0.74151490D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46231: 46235) /146, 67,   0.78120400D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46236: 46240) /146, 68,   0.76457050D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46241: 46245) /146, 69,   0.74957790D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46246: 46250) /146, 70,   0.74073920D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46251: 46255) /146, 71,   0.62471570D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46256: 46260) /146, 72,   0.61425310D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46261: 46265) /146, 73,   0.56115170D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46266: 46270) /146, 74,   0.47494930D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46271: 46275) /146, 75,   0.48315690D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46276: 46280) /146, 76,   0.43846770D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46281: 46285) /146, 77,   0.40208340D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46286: 46290) /146, 78,   0.33498540D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46291: 46295) /146, 79,   0.31334830D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46296: 46300) /146, 80,   0.32218840D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46301: 46305) /146, 81,   0.46735710D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46306: 46310) /146, 82,   0.45686740D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46311: 46315) /146, 83,   0.42032740D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46316: 46320) /146, 84,   0.40133490D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46321: 46325) /146, 85,   0.37107280D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46326: 46330) /146, 86,   0.34084580D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46331: 46335) /146, 87,   0.11269549D+04,   0.18630D+01,   0.00000D+00/
  data pars( 46336: 46340) /146, 88,   0.10810405D+04,   0.18630D+01,   0.00000D+00/
  data pars( 46341: 46345) /146, 89,   0.95553590D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46346: 46350) /146, 90,   0.85969500D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46351: 46355) /146, 91,   0.85393730D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46356: 46360) /146, 92,   0.82694450D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46361: 46365) /146, 93,   0.85119160D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46366: 46370) /146, 94,   0.82429470D+03,   0.18630D+01,   0.00000D+00/
  data pars( 46371: 46375) /146,101,   0.46348900D+02,   0.18630D+01,   0.00000D+00/
  data pars( 46376: 46380) /146,103,   0.14912090D+03,   0.18630D+01,   0.98650D+00/
  data pars( 46381: 46385) /146,104,   0.19048260D+03,   0.18630D+01,   0.98080D+00/
  data pars( 46386: 46390) /146,105,   0.14620200D+03,   0.18630D+01,   0.97060D+00/
  data pars( 46391: 46395) /146,106,   0.11079460D+03,   0.18630D+01,   0.98680D+00/
  data pars( 46396: 46400) /146,107,   0.77647900D+02,   0.18630D+01,   0.99440D+00/
  data pars( 46401: 46405) /146,108,   0.57004900D+02,   0.18630D+01,   0.99250D+00/
  data pars( 46406: 46410) /146,109,   0.39663600D+02,   0.18630D+01,   0.99820D+00/
  data pars( 46411: 46415) /146,111,   0.21823330D+03,   0.18630D+01,   0.96840D+00/
  data pars( 46416: 46420) /146,112,   0.33722560D+03,   0.18630D+01,   0.96280D+00/
  data pars( 46421: 46425) /146,113,   0.34179460D+03,   0.18630D+01,   0.96480D+00/
  data pars( 46426: 46430) /146,114,   0.27549250D+03,   0.18630D+01,   0.95070D+00/
  data pars( 46431: 46435) /146,115,   0.22646050D+03,   0.18630D+01,   0.99470D+00/
  data pars( 46436: 46440) /146,116,   0.19221720D+03,   0.18630D+01,   0.99480D+00/
  data pars( 46441: 46445) /146,117,   0.15785240D+03,   0.18630D+01,   0.99720D+00/
  data pars( 46446: 46450) /146,119,   0.30246350D+03,   0.18630D+01,   0.97670D+00/
  data pars( 46451: 46455) /146,120,   0.57613740D+03,   0.18630D+01,   0.98310D+00/
  data pars( 46456: 46460) /146,121,   0.30248980D+03,   0.18630D+01,   0.18627D+01/
  data pars( 46461: 46465) /146,122,   0.29221350D+03,   0.18630D+01,   0.18299D+01/
  data pars( 46466: 46470) /146,123,   0.28642780D+03,   0.18630D+01,   0.19138D+01/
  data pars( 46471: 46475) /146,124,   0.28377850D+03,   0.18630D+01,   0.18269D+01/
  data pars( 46476: 46480) /146,125,   0.26126350D+03,   0.18630D+01,   0.16406D+01/
  data pars( 46481: 46485) /146,126,   0.24201470D+03,   0.18630D+01,   0.16483D+01/
  data pars( 46486: 46490) /146,127,   0.23097880D+03,   0.18630D+01,   0.17149D+01/
  data pars( 46491: 46495) /146,128,   0.22581650D+03,   0.18630D+01,   0.17937D+01/
  data pars( 46496: 46500) /146,129,   0.22301540D+03,   0.18630D+01,   0.95760D+00/
  data pars( 46501: 46505) /146,130,   0.20945460D+03,   0.18630D+01,   0.19419D+01/
  data pars( 46506: 46510) /146,131,   0.34006750D+03,   0.18630D+01,   0.96010D+00/
  data pars( 46511: 46515) /146,132,   0.29932800D+03,   0.18630D+01,   0.94340D+00/
  data pars( 46516: 46520) /146,133,   0.26894270D+03,   0.18630D+01,   0.98890D+00/
  data pars( 46521: 46525) /146,134,   0.24619370D+03,   0.18630D+01,   0.99010D+00/
  data pars( 46526: 46530) /146,135,   0.21757380D+03,   0.18630D+01,   0.99740D+00/
  data pars( 46531: 46535) /146,137,   0.36130470D+03,   0.18630D+01,   0.97380D+00/
  data pars( 46536: 46540) /146,138,   0.70165500D+03,   0.18630D+01,   0.98010D+00/
  data pars( 46541: 46545) /146,139,   0.53685660D+03,   0.18630D+01,   0.19153D+01/
  data pars( 46546: 46550) /146,140,   0.40042090D+03,   0.18630D+01,   0.19355D+01/
  data pars( 46551: 46555) /146,141,   0.40443000D+03,   0.18630D+01,   0.19545D+01/
  data pars( 46556: 46560) /146,142,   0.37755350D+03,   0.18630D+01,   0.19420D+01/
  data pars( 46561: 46565) /146,143,   0.42312790D+03,   0.18630D+01,   0.16682D+01/
  data pars( 46566: 46570) /146,144,   0.32968260D+03,   0.18630D+01,   0.18584D+01/
  data pars( 46571: 46575) /146,145,   0.30870590D+03,   0.18630D+01,   0.19003D+01/
  data pars( 46576: 46580) /146,146,   0.28695190D+03,   0.18630D+01,   0.18630D+01/
  data pars( 46581: 46585) /147,  1,   0.27951800D+02,   0.96790D+00,   0.91180D+00/
  data pars( 46586: 46590) /147,  2,   0.18773100D+02,   0.96790D+00,   0.00000D+00/
  data pars( 46591: 46595) /147,  3,   0.43260780D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46596: 46600) /147,  4,   0.24865730D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46601: 46605) /147,  5,   0.16783500D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46606: 46610) /147,  6,   0.11399930D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46611: 46615) /147,  7,   0.80266300D+02,   0.96790D+00,   0.00000D+00/
  data pars( 46616: 46620) /147,  8,   0.61174800D+02,   0.96790D+00,   0.00000D+00/
  data pars( 46621: 46625) /147,  9,   0.46672600D+02,   0.96790D+00,   0.00000D+00/
  data pars( 46626: 46630) /147, 10,   0.36148600D+02,   0.96790D+00,   0.00000D+00/
  data pars( 46631: 46635) /147, 11,   0.51756800D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46636: 46640) /147, 12,   0.39661250D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46641: 46645) /147, 13,   0.36552690D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46646: 46650) /147, 14,   0.28828630D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46651: 46655) /147, 15,   0.22539450D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46656: 46660) /147, 16,   0.18765970D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46661: 46665) /147, 17,   0.15390320D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46666: 46670) /147, 18,   0.12648250D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46671: 46675) /147, 19,   0.85100880D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46676: 46680) /147, 20,   0.69886180D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46681: 46685) /147, 21,   0.57696360D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46686: 46690) /147, 22,   0.55728800D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46691: 46695) /147, 23,   0.51036440D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46696: 46700) /147, 24,   0.40283830D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46701: 46705) /147, 25,   0.43950990D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46706: 46710) /147, 26,   0.34569950D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46711: 46715) /147, 27,   0.36569250D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46716: 46720) /147, 28,   0.37662810D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46721: 46725) /147, 29,   0.28955800D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46726: 46730) /147, 30,   0.29667280D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46731: 46735) /147, 31,   0.35080100D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46736: 46740) /147, 32,   0.30945430D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46741: 46745) /147, 33,   0.26439570D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46746: 46750) /147, 34,   0.23772170D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46751: 46755) /147, 35,   0.20860440D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46756: 46760) /147, 36,   0.18200160D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46761: 46765) /147, 37,   0.95413200D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46766: 46770) /147, 38,   0.83331680D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46771: 46775) /147, 39,   0.72933160D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46776: 46780) /147, 40,   0.65543290D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46781: 46785) /147, 41,   0.59785280D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46786: 46790) /147, 42,   0.46233830D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46791: 46795) /147, 43,   0.51549530D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46796: 46800) /147, 44,   0.39350880D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46801: 46805) /147, 45,   0.42951430D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46806: 46810) /147, 46,   0.39846620D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46811: 46815) /147, 47,   0.33315830D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46816: 46820) /147, 48,   0.35137120D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46821: 46825) /147, 49,   0.44027330D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46826: 46830) /147, 50,   0.40690290D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46831: 46835) /147, 51,   0.36287400D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46836: 46840) /147, 52,   0.33701310D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46841: 46845) /147, 53,   0.30521220D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46846: 46850) /147, 54,   0.27497440D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46851: 46855) /147, 55,   0.11625520D+04,   0.96790D+00,   0.00000D+00/
  data pars( 46856: 46860) /147, 56,   0.10633544D+04,   0.96790D+00,   0.00000D+00/
  data pars( 46861: 46865) /147, 57,   0.93316800D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46866: 46870) /147, 58,   0.42899800D+03,   0.96790D+00,   0.27991D+01/
  data pars( 46871: 46875) /147, 59,   0.94235470D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46876: 46880) /147, 60,   0.90466880D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46881: 46885) /147, 61,   0.88190710D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46886: 46890) /147, 62,   0.86096980D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46891: 46895) /147, 63,   0.84239660D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46896: 46900) /147, 64,   0.66260290D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46901: 46905) /147, 65,   0.74772470D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46906: 46910) /147, 66,   0.72101030D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46911: 46915) /147, 67,   0.75950840D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46916: 46920) /147, 68,   0.74332210D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46921: 46925) /147, 69,   0.72872030D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46926: 46930) /147, 70,   0.72016540D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46931: 46935) /147, 71,   0.60683130D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46936: 46940) /147, 72,   0.59598520D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46941: 46945) /147, 73,   0.54409850D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46946: 46950) /147, 74,   0.46026700D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46951: 46955) /147, 75,   0.46810840D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46956: 46960) /147, 76,   0.42458230D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46961: 46965) /147, 77,   0.38918700D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46966: 46970) /147, 78,   0.32412400D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46971: 46975) /147, 79,   0.30315550D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46976: 46980) /147, 80,   0.31163540D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46981: 46985) /147, 81,   0.45304550D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46986: 46990) /147, 82,   0.44250950D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46991: 46995) /147, 83,   0.40670840D+03,   0.96790D+00,   0.00000D+00/
  data pars( 46996: 47000) /147, 84,   0.38810010D+03,   0.96790D+00,   0.00000D+00/
  data pars( 47001: 47005) /147, 85,   0.35859540D+03,   0.96790D+00,   0.00000D+00/
  data pars( 47006: 47010) /147, 86,   0.32919900D+03,   0.96790D+00,   0.00000D+00/
  data pars( 47011: 47015) /147, 87,   0.10968369D+04,   0.96790D+00,   0.00000D+00/
  data pars( 47016: 47020) /147, 88,   0.10511515D+04,   0.96790D+00,   0.00000D+00/
  data pars( 47021: 47025) /147, 89,   0.92833020D+03,   0.96790D+00,   0.00000D+00/
  data pars( 47026: 47030) /147, 90,   0.83431790D+03,   0.96790D+00,   0.00000D+00/
  data pars( 47031: 47035) /147, 91,   0.82919230D+03,   0.96790D+00,   0.00000D+00/
  data pars( 47036: 47040) /147, 92,   0.80298090D+03,   0.96790D+00,   0.00000D+00/
  data pars( 47041: 47045) /147, 93,   0.82716130D+03,   0.96790D+00,   0.00000D+00/
  data pars( 47046: 47050) /147, 94,   0.80093320D+03,   0.96790D+00,   0.00000D+00/
  data pars( 47051: 47055) /147,101,   0.44783500D+02,   0.96790D+00,   0.00000D+00/
  data pars( 47056: 47060) /147,103,   0.14465630D+03,   0.96790D+00,   0.98650D+00/
  data pars( 47061: 47065) /147,104,   0.18465300D+03,   0.96790D+00,   0.98080D+00/
  data pars( 47066: 47070) /147,105,   0.14140600D+03,   0.96790D+00,   0.97060D+00/
  data pars( 47071: 47075) /147,106,   0.10702860D+03,   0.96790D+00,   0.98680D+00/
  data pars( 47076: 47080) /147,107,   0.74935400D+02,   0.96790D+00,   0.99440D+00/
  data pars( 47081: 47085) /147,108,   0.54985600D+02,   0.96790D+00,   0.99250D+00/
  data pars( 47086: 47090) /147,109,   0.38253900D+02,   0.96790D+00,   0.99820D+00/
  data pars( 47091: 47095) /147,111,   0.21184190D+03,   0.96790D+00,   0.96840D+00/
  data pars( 47096: 47100) /147,112,   0.32735090D+03,   0.96790D+00,   0.96280D+00/
  data pars( 47101: 47105) /147,113,   0.33138320D+03,   0.96790D+00,   0.96480D+00/
  data pars( 47106: 47110) /147,114,   0.26660080D+03,   0.96790D+00,   0.95070D+00/
  data pars( 47111: 47115) /147,115,   0.21886170D+03,   0.96790D+00,   0.99470D+00/
  data pars( 47116: 47120) /147,116,   0.18561970D+03,   0.96790D+00,   0.99480D+00/
  data pars( 47121: 47125) /147,117,   0.15232700D+03,   0.96790D+00,   0.99720D+00/
  data pars( 47126: 47130) /147,119,   0.29329110D+03,   0.96790D+00,   0.97670D+00/
  data pars( 47131: 47135) /147,120,   0.56012980D+03,   0.96790D+00,   0.98310D+00/
  data pars( 47136: 47140) /147,121,   0.29290630D+03,   0.96790D+00,   0.18627D+01/
  data pars( 47141: 47145) /147,122,   0.28293320D+03,   0.96790D+00,   0.18299D+01/
  data pars( 47146: 47150) /147,123,   0.27735250D+03,   0.96790D+00,   0.19138D+01/
  data pars( 47151: 47155) /147,124,   0.27484520D+03,   0.96790D+00,   0.18269D+01/
  data pars( 47156: 47160) /147,125,   0.25282980D+03,   0.96790D+00,   0.16406D+01/
  data pars( 47161: 47165) /147,126,   0.23415110D+03,   0.96790D+00,   0.16483D+01/
  data pars( 47166: 47170) /147,127,   0.22348050D+03,   0.96790D+00,   0.17149D+01/
  data pars( 47171: 47175) /147,128,   0.21850750D+03,   0.96790D+00,   0.17937D+01/
  data pars( 47176: 47180) /147,129,   0.21595810D+03,   0.96790D+00,   0.95760D+00/
  data pars( 47181: 47185) /147,130,   0.20256850D+03,   0.96790D+00,   0.19419D+01/
  data pars( 47186: 47190) /147,131,   0.32953870D+03,   0.96790D+00,   0.96010D+00/
  data pars( 47191: 47195) /147,132,   0.28964110D+03,   0.96790D+00,   0.94340D+00/
  data pars( 47196: 47200) /147,133,   0.25997060D+03,   0.96790D+00,   0.98890D+00/
  data pars( 47201: 47205) /147,134,   0.23782380D+03,   0.96790D+00,   0.99010D+00/
  data pars( 47206: 47210) /147,135,   0.21004110D+03,   0.96790D+00,   0.99740D+00/
  data pars( 47211: 47215) /147,137,   0.35022950D+03,   0.96790D+00,   0.97380D+00/
  data pars( 47216: 47220) /147,138,   0.68218170D+03,   0.96790D+00,   0.98010D+00/
  data pars( 47221: 47225) /147,139,   0.52087240D+03,   0.96790D+00,   0.19153D+01/
  data pars( 47226: 47230) /147,140,   0.38773360D+03,   0.96790D+00,   0.19355D+01/
  data pars( 47231: 47235) /147,141,   0.39166370D+03,   0.96790D+00,   0.19545D+01/
  data pars( 47236: 47240) /147,142,   0.36552610D+03,   0.96790D+00,   0.19420D+01/
  data pars( 47241: 47245) /147,143,   0.41006670D+03,   0.96790D+00,   0.16682D+01/
  data pars( 47246: 47250) /147,144,   0.31896650D+03,   0.96790D+00,   0.18584D+01/
  data pars( 47251: 47255) /147,145,   0.29866780D+03,   0.96790D+00,   0.19003D+01/
  data pars( 47256: 47260) /147,146,   0.27760230D+03,   0.96790D+00,   0.18630D+01/
  data pars( 47261: 47265) /147,147,   0.26861300D+03,   0.96790D+00,   0.96790D+00/
  data pars( 47266: 47270) /148,  1,   0.27928100D+02,   0.19539D+01,   0.91180D+00/
  data pars( 47271: 47275) /148,  2,   0.18860700D+02,   0.19539D+01,   0.00000D+00/
  data pars( 47276: 47280) /148,  3,   0.40844290D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47281: 47285) /148,  4,   0.24209500D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47286: 47290) /148,  5,   0.16565870D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47291: 47295) /148,  6,   0.11343690D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47296: 47300) /148,  7,   0.80249200D+02,   0.19539D+01,   0.00000D+00/
  data pars( 47301: 47305) /148,  8,   0.61323400D+02,   0.19539D+01,   0.00000D+00/
  data pars( 47306: 47310) /148,  9,   0.46869200D+02,   0.19539D+01,   0.00000D+00/
  data pars( 47311: 47315) /148, 10,   0.36340100D+02,   0.19539D+01,   0.00000D+00/
  data pars( 47316: 47320) /148, 11,   0.48951290D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47321: 47325) /148, 12,   0.38417280D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47326: 47330) /148, 13,   0.35686540D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47331: 47335) /148, 14,   0.28421390D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47336: 47340) /148, 15,   0.22377830D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47341: 47345) /148, 16,   0.18701630D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47346: 47350) /148, 17,   0.15385920D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47351: 47355) /148, 18,   0.12673560D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47356: 47360) /148, 19,   0.80025930D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47361: 47365) /148, 20,   0.67026330D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47366: 47370) /148, 21,   0.55566790D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47371: 47375) /148, 22,   0.53855020D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47376: 47380) /148, 23,   0.49422370D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47381: 47385) /148, 24,   0.38999530D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47386: 47390) /148, 25,   0.42685790D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47391: 47395) /148, 26,   0.33576420D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47396: 47400) /148, 27,   0.35691720D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47401: 47405) /148, 28,   0.36686680D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47406: 47410) /148, 29,   0.28186750D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47411: 47415) /148, 30,   0.29078950D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47416: 47420) /148, 31,   0.34329430D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47421: 47425) /148, 32,   0.30514680D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47426: 47430) /148, 33,   0.26228400D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47431: 47435) /148, 34,   0.23657790D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47436: 47440) /148, 35,   0.20821130D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47441: 47445) /148, 36,   0.18208670D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47446: 47450) /148, 37,   0.89853420D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47451: 47455) /148, 38,   0.79845280D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47456: 47460) /148, 39,   0.70379920D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47461: 47465) /148, 40,   0.63513700D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47466: 47470) /148, 41,   0.58084120D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47471: 47475) /148, 42,   0.45097760D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47476: 47480) /148, 43,   0.50211680D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47481: 47485) /148, 44,   0.38494360D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47486: 47490) /148, 45,   0.42037460D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47491: 47495) /148, 46,   0.39057700D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47496: 47500) /148, 47,   0.32596620D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47501: 47505) /148, 48,   0.34505990D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47506: 47510) /148, 49,   0.43036070D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47511: 47515) /148, 50,   0.40034740D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47516: 47520) /148, 51,   0.35905550D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47521: 47525) /148, 52,   0.33449170D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47526: 47530) /148, 53,   0.30384100D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47531: 47535) /148, 54,   0.27444070D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47536: 47540) /148, 55,   0.10949943D+04,   0.19539D+01,   0.00000D+00/
  data pars( 47541: 47545) /148, 56,   0.10161802D+04,   0.19539D+01,   0.00000D+00/
  data pars( 47546: 47550) /148, 57,   0.89820920D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47551: 47555) /148, 58,   0.42389100D+03,   0.19539D+01,   0.27991D+01/
  data pars( 47556: 47560) /148, 59,   0.90262940D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47561: 47565) /148, 60,   0.86759380D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47566: 47570) /148, 61,   0.84606160D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47571: 47575) /148, 62,   0.82622610D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47576: 47580) /148, 63,   0.80864130D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47581: 47585) /148, 64,   0.64073930D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47586: 47590) /148, 65,   0.71462060D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47591: 47595) /148, 66,   0.69004230D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47596: 47600) /148, 67,   0.73042860D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47601: 47605) /148, 68,   0.71501980D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47606: 47610) /148, 69,   0.70118290D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47611: 47615) /148, 70,   0.69275040D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47616: 47620) /148, 71,   0.58668300D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47621: 47625) /148, 72,   0.58027960D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47626: 47630) /148, 73,   0.53179240D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47631: 47635) /148, 74,   0.45093600D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47636: 47640) /148, 75,   0.45935930D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47641: 47645) /148, 76,   0.41790820D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47646: 47650) /148, 77,   0.38396000D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47651: 47655) /148, 78,   0.32036400D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47656: 47660) /148, 79,   0.29986260D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47661: 47665) /148, 80,   0.30870590D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47666: 47670) /148, 81,   0.44321180D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47671: 47675) /148, 82,   0.43519640D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47676: 47680) /148, 83,   0.40209000D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47681: 47685) /148, 84,   0.38476220D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47686: 47690) /148, 85,   0.35659780D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47691: 47695) /148, 86,   0.32818400D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47696: 47700) /148, 87,   0.10391920D+04,   0.19539D+01,   0.00000D+00/
  data pars( 47701: 47705) /148, 88,   0.10081792D+04,   0.19539D+01,   0.00000D+00/
  data pars( 47706: 47710) /148, 89,   0.89630090D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47711: 47715) /148, 90,   0.81114820D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47716: 47720) /148, 91,   0.80315200D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47721: 47725) /148, 92,   0.77787630D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47726: 47730) /148, 93,   0.79775990D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47731: 47735) /148, 94,   0.77311930D+03,   0.19539D+01,   0.00000D+00/
  data pars( 47736: 47740) /148,101,   0.44500600D+02,   0.19539D+01,   0.00000D+00/
  data pars( 47741: 47745) /148,103,   0.14109010D+03,   0.19539D+01,   0.98650D+00/
  data pars( 47746: 47750) /148,104,   0.18052070D+03,   0.19539D+01,   0.98080D+00/
  data pars( 47751: 47755) /148,105,   0.13987930D+03,   0.19539D+01,   0.97060D+00/
  data pars( 47756: 47760) /148,106,   0.10643320D+03,   0.19539D+01,   0.98680D+00/
  data pars( 47761: 47765) /148,107,   0.74892500D+02,   0.19539D+01,   0.99440D+00/
  data pars( 47766: 47770) /148,108,   0.55139200D+02,   0.19539D+01,   0.99250D+00/
  data pars( 47771: 47775) /148,109,   0.38490600D+02,   0.19539D+01,   0.99820D+00/
  data pars( 47776: 47780) /148,111,   0.20596470D+03,   0.19539D+01,   0.96840D+00/
  data pars( 47781: 47785) /148,112,   0.31790020D+03,   0.19539D+01,   0.96280D+00/
  data pars( 47786: 47790) /148,113,   0.32408300D+03,   0.19539D+01,   0.96480D+00/
  data pars( 47791: 47795) /148,114,   0.26314380D+03,   0.19539D+01,   0.95070D+00/
  data pars( 47796: 47800) /148,115,   0.21731990D+03,   0.19539D+01,   0.99470D+00/
  data pars( 47801: 47805) /148,116,   0.18495220D+03,   0.19539D+01,   0.99480D+00/
  data pars( 47806: 47810) /148,117,   0.15226460D+03,   0.19539D+01,   0.99720D+00/
  data pars( 47811: 47815) /148,119,   0.28627350D+03,   0.19539D+01,   0.97670D+00/
  data pars( 47816: 47820) /148,120,   0.53708890D+03,   0.19539D+01,   0.98310D+00/
  data pars( 47821: 47825) /148,121,   0.28838750D+03,   0.19539D+01,   0.18627D+01/
  data pars( 47826: 47830) /148,122,   0.27858690D+03,   0.19539D+01,   0.18299D+01/
  data pars( 47831: 47835) /148,123,   0.27303310D+03,   0.19539D+01,   0.19138D+01/
  data pars( 47836: 47840) /148,124,   0.27028900D+03,   0.19539D+01,   0.18269D+01/
  data pars( 47841: 47845) /148,125,   0.24982010D+03,   0.19539D+01,   0.16406D+01/
  data pars( 47846: 47850) /148,126,   0.23161700D+03,   0.19539D+01,   0.16483D+01/
  data pars( 47851: 47855) /148,127,   0.22102480D+03,   0.19539D+01,   0.17149D+01/
  data pars( 47856: 47860) /148,128,   0.21602110D+03,   0.19539D+01,   0.17937D+01/
  data pars( 47861: 47865) /148,129,   0.21274680D+03,   0.19539D+01,   0.95760D+00/
  data pars( 47866: 47870) /148,130,   0.20082240D+03,   0.19539D+01,   0.19419D+01/
  data pars( 47871: 47875) /148,131,   0.32310800D+03,   0.19539D+01,   0.96010D+00/
  data pars( 47876: 47880) /148,132,   0.28605510D+03,   0.19539D+01,   0.94340D+00/
  data pars( 47881: 47885) /148,133,   0.25796890D+03,   0.19539D+01,   0.98890D+00/
  data pars( 47886: 47890) /148,134,   0.23666040D+03,   0.19539D+01,   0.99010D+00/
  data pars( 47891: 47895) /148,135,   0.20960830D+03,   0.19539D+01,   0.99740D+00/
  data pars( 47896: 47900) /148,137,   0.34234100D+03,   0.19539D+01,   0.97380D+00/
  data pars( 47901: 47905) /148,138,   0.65327820D+03,   0.19539D+01,   0.98010D+00/
  data pars( 47906: 47910) /148,139,   0.50567470D+03,   0.19539D+01,   0.19153D+01/
  data pars( 47911: 47915) /148,140,   0.38134050D+03,   0.19539D+01,   0.19355D+01/
  data pars( 47916: 47920) /148,141,   0.38512060D+03,   0.19539D+01,   0.19545D+01/
  data pars( 47921: 47925) /148,142,   0.35990590D+03,   0.19539D+01,   0.19420D+01/
  data pars( 47926: 47930) /148,143,   0.40123820D+03,   0.19539D+01,   0.16682D+01/
  data pars( 47931: 47935) /148,144,   0.31533650D+03,   0.19539D+01,   0.18584D+01/
  data pars( 47936: 47940) /148,145,   0.29530360D+03,   0.19539D+01,   0.19003D+01/
  data pars( 47941: 47945) /148,146,   0.27461540D+03,   0.19539D+01,   0.18630D+01/
  data pars( 47946: 47950) /148,147,   0.26554500D+03,   0.19539D+01,   0.96790D+00/
  data pars( 47951: 47955) /148,148,   0.26345080D+03,   0.19539D+01,   0.19539D+01/
  data pars( 47956: 47960) /149,  1,   0.42282700D+02,   0.96330D+00,   0.91180D+00/
  data pars( 47961: 47965) /149,  2,   0.27023600D+02,   0.96330D+00,   0.00000D+00/
  data pars( 47966: 47970) /149,  3,   0.76925140D+03,   0.96330D+00,   0.00000D+00/
  data pars( 47971: 47975) /149,  4,   0.41349650D+03,   0.96330D+00,   0.00000D+00/
  data pars( 47976: 47980) /149,  5,   0.26747500D+03,   0.96330D+00,   0.00000D+00/
  data pars( 47981: 47985) /149,  6,   0.17545850D+03,   0.96330D+00,   0.00000D+00/
  data pars( 47986: 47990) /149,  7,   0.12012790D+03,   0.96330D+00,   0.00000D+00/
  data pars( 47991: 47995) /149,  8,   0.89652000D+02,   0.96330D+00,   0.00000D+00/
  data pars( 47996: 48000) /149,  9,   0.67123200D+02,   0.96330D+00,   0.00000D+00/
  data pars( 48001: 48005) /149, 10,   0.51174700D+02,   0.96330D+00,   0.00000D+00/
  data pars( 48006: 48010) /149, 11,   0.91594130D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48011: 48015) /149, 12,   0.66728440D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48016: 48020) /149, 13,   0.60241430D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48021: 48025) /149, 14,   0.46150930D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48026: 48030) /149, 15,   0.35151570D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48031: 48035) /149, 16,   0.28739220D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48036: 48040) /149, 17,   0.23145540D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48041: 48045) /149, 18,   0.18709160D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48046: 48050) /149, 19,   0.15173687D+04,   0.96330D+00,   0.00000D+00/
  data pars( 48051: 48055) /149, 20,   0.11989287D+04,   0.96330D+00,   0.00000D+00/
  data pars( 48056: 48060) /149, 21,   0.98084640D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48061: 48065) /149, 22,   0.93876410D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48066: 48070) /149, 23,   0.85507440D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48071: 48075) /149, 24,   0.67285260D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48076: 48080) /149, 25,   0.73052210D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48081: 48085) /149, 26,   0.57217290D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48086: 48090) /149, 27,   0.59982550D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48091: 48095) /149, 28,   0.62133050D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48096: 48100) /149, 29,   0.47601650D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48101: 48105) /149, 30,   0.48059720D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48106: 48110) /149, 31,   0.57226580D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48111: 48115) /149, 32,   0.49379840D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48116: 48120) /149, 33,   0.41301260D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48121: 48125) /149, 34,   0.36615190D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48126: 48130) /149, 35,   0.31652310D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48131: 48135) /149, 36,   0.27222880D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48136: 48140) /149, 37,   0.16942091D+04,   0.96330D+00,   0.00000D+00/
  data pars( 48141: 48145) /149, 38,   0.14306640D+04,   0.96330D+00,   0.00000D+00/
  data pars( 48146: 48150) /149, 39,   0.12316979D+04,   0.96330D+00,   0.00000D+00/
  data pars( 48151: 48155) /149, 40,   0.10950419D+04,   0.96330D+00,   0.00000D+00/
  data pars( 48156: 48160) /149, 41,   0.99140130D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48161: 48165) /149, 42,   0.75589180D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48166: 48170) /149, 43,   0.84735570D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48171: 48175) /149, 44,   0.63674800D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48176: 48180) /149, 45,   0.69613210D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48181: 48185) /149, 46,   0.64264560D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48186: 48190) /149, 47,   0.53720580D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48191: 48195) /149, 48,   0.56303120D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48196: 48200) /149, 49,   0.71679570D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48201: 48205) /149, 50,   0.65114030D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48206: 48210) /149, 51,   0.57030150D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48211: 48215) /149, 52,   0.52361310D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48216: 48220) /149, 53,   0.46816800D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48221: 48225) /149, 54,   0.41650530D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48226: 48230) /149, 55,   0.20626273D+04,   0.96330D+00,   0.00000D+00/
  data pars( 48231: 48235) /149, 56,   0.18342595D+04,   0.96330D+00,   0.00000D+00/
  data pars( 48236: 48240) /149, 57,   0.15838792D+04,   0.96330D+00,   0.00000D+00/
  data pars( 48241: 48245) /149, 58,   0.67579110D+03,   0.96330D+00,   0.27991D+01/
  data pars( 48246: 48250) /149, 59,   0.16159882D+04,   0.96330D+00,   0.00000D+00/
  data pars( 48251: 48255) /149, 60,   0.15472492D+04,   0.96330D+00,   0.00000D+00/
  data pars( 48256: 48260) /149, 61,   0.15072236D+04,   0.96330D+00,   0.00000D+00/
  data pars( 48261: 48265) /149, 62,   0.14705492D+04,   0.96330D+00,   0.00000D+00/
  data pars( 48266: 48270) /149, 63,   0.14379844D+04,   0.96330D+00,   0.00000D+00/
  data pars( 48271: 48275) /149, 64,   0.11092250D+04,   0.96330D+00,   0.00000D+00/
  data pars( 48276: 48280) /149, 65,   0.12845648D+04,   0.96330D+00,   0.00000D+00/
  data pars( 48281: 48285) /149, 66,   0.12348582D+04,   0.96330D+00,   0.00000D+00/
  data pars( 48286: 48290) /149, 67,   0.12913513D+04,   0.96330D+00,   0.00000D+00/
  data pars( 48291: 48295) /149, 68,   0.12633503D+04,   0.96330D+00,   0.00000D+00/
  data pars( 48296: 48300) /149, 69,   0.12378116D+04,   0.96330D+00,   0.00000D+00/
  data pars( 48301: 48305) /149, 70,   0.12243143D+04,   0.96330D+00,   0.00000D+00/
  data pars( 48306: 48310) /149, 71,   0.10181407D+04,   0.96330D+00,   0.00000D+00/
  data pars( 48311: 48315) /149, 72,   0.98356470D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48316: 48320) /149, 73,   0.88792510D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48321: 48325) /149, 74,   0.74340350D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48326: 48330) /149, 75,   0.75315120D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48331: 48335) /149, 76,   0.67623400D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48336: 48340) /149, 77,   0.61465820D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48341: 48345) /149, 78,   0.50654420D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48346: 48350) /149, 79,   0.47177480D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48351: 48355) /149, 80,   0.48363130D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48356: 48360) /149, 81,   0.73258080D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48361: 48365) /149, 82,   0.70644460D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48366: 48370) /149, 83,   0.63913150D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48371: 48375) /149, 84,   0.60410820D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48376: 48380) /149, 85,   0.55158440D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48381: 48385) /149, 86,   0.50067860D+03,   0.96330D+00,   0.00000D+00/
  data pars( 48386: 48390) /149, 87,   0.19210063D+04,   0.96330D+00,   0.00000D+00/
  data pars( 48391: 48395) /149, 88,   0.17975569D+04,   0.96330D+00,   0.00000D+00/
  data pars( 48396: 48400) /149, 89,   0.15637265D+04,   0.96330D+00,   0.00000D+00/
  data pars( 48401: 48405) /149, 90,   0.13796361D+04,   0.96330D+00,   0.00000D+00/
  data pars( 48406: 48410) /149, 91,   0.13822903D+04,   0.96330D+00,   0.00000D+00/
  data pars( 48411: 48415) /149, 92,   0.13377839D+04,   0.96330D+00,   0.00000D+00/
  data pars( 48416: 48420) /149, 93,   0.13931101D+04,   0.96330D+00,   0.00000D+00/
  data pars( 48421: 48425) /149, 94,   0.13462697D+04,   0.96330D+00,   0.00000D+00/
  data pars( 48426: 48430) /149,101,   0.69675400D+02,   0.96330D+00,   0.00000D+00/
  data pars( 48431: 48435) /149,103,   0.23904190D+03,   0.96330D+00,   0.98650D+00/
  data pars( 48436: 48440) /149,104,   0.30266780D+03,   0.96330D+00,   0.98080D+00/
  data pars( 48441: 48445) /149,105,   0.22316290D+03,   0.96330D+00,   0.97060D+00/
  data pars( 48446: 48450) /149,106,   0.16468120D+03,   0.96330D+00,   0.98680D+00/
  data pars( 48451: 48455) /149,107,   0.11197070D+03,   0.96330D+00,   0.99440D+00/
  data pars( 48456: 48460) /149,108,   0.80098600D+02,   0.96330D+00,   0.99250D+00/
  data pars( 48461: 48465) /149,109,   0.53936400D+02,   0.96330D+00,   0.99820D+00/
  data pars( 48466: 48470) /149,111,   0.35200740D+03,   0.96330D+00,   0.96840D+00/
  data pars( 48471: 48475) /149,112,   0.54627620D+03,   0.96330D+00,   0.96280D+00/
  data pars( 48476: 48480) /149,113,   0.54321880D+03,   0.96330D+00,   0.96480D+00/
  data pars( 48481: 48485) /149,114,   0.42482930D+03,   0.96330D+00,   0.95070D+00/
  data pars( 48486: 48490) /149,115,   0.34093960D+03,   0.96330D+00,   0.99470D+00/
  data pars( 48491: 48495) /149,116,   0.28433500D+03,   0.96330D+00,   0.99480D+00/
  data pars( 48496: 48500) /149,117,   0.22912290D+03,   0.96330D+00,   0.99720D+00/
  data pars( 48501: 48505) /149,119,   0.47801410D+03,   0.96330D+00,   0.97670D+00/
  data pars( 48506: 48510) /149,120,   0.95798970D+03,   0.96330D+00,   0.98310D+00/
  data pars( 48511: 48515) /149,121,   0.46767000D+03,   0.96330D+00,   0.18627D+01/
  data pars( 48516: 48520) /149,122,   0.45116580D+03,   0.96330D+00,   0.18299D+01/
  data pars( 48521: 48525) /149,123,   0.44234200D+03,   0.96330D+00,   0.19138D+01/
  data pars( 48526: 48530) /149,124,   0.43947280D+03,   0.96330D+00,   0.18269D+01/
  data pars( 48531: 48535) /149,125,   0.39910790D+03,   0.96330D+00,   0.16406D+01/
  data pars( 48536: 48540) /149,126,   0.36795920D+03,   0.96330D+00,   0.16483D+01/
  data pars( 48541: 48545) /149,127,   0.35103000D+03,   0.96330D+00,   0.17149D+01/
  data pars( 48546: 48550) /149,128,   0.34356200D+03,   0.96330D+00,   0.17937D+01/
  data pars( 48551: 48555) /149,129,   0.34289310D+03,   0.96330D+00,   0.95760D+00/
  data pars( 48556: 48560) /149,130,   0.31591660D+03,   0.96330D+00,   0.19419D+01/
  data pars( 48561: 48565) /149,131,   0.53451270D+03,   0.96330D+00,   0.96010D+00/
  data pars( 48566: 48570) /149,132,   0.45962850D+03,   0.96330D+00,   0.94340D+00/
  data pars( 48571: 48575) /149,133,   0.40554530D+03,   0.96330D+00,   0.98890D+00/
  data pars( 48576: 48580) /149,134,   0.36636520D+03,   0.96330D+00,   0.99010D+00/
  data pars( 48581: 48585) /149,135,   0.31893050D+03,   0.96330D+00,   0.99740D+00/
  data pars( 48586: 48590) /149,137,   0.56760020D+03,   0.96330D+00,   0.97380D+00/
  data pars( 48591: 48595) /149,138,   0.11685036D+04,   0.96330D+00,   0.98010D+00/
  data pars( 48596: 48600) /149,139,   0.86288330D+03,   0.96330D+00,   0.19153D+01/
  data pars( 48601: 48605) /149,140,   0.61965370D+03,   0.96330D+00,   0.19355D+01/
  data pars( 48606: 48610) /149,141,   0.62602540D+03,   0.96330D+00,   0.19545D+01/
  data pars( 48611: 48615) /149,142,   0.58105490D+03,   0.96330D+00,   0.19420D+01/
  data pars( 48616: 48620) /149,143,   0.66303800D+03,   0.96330D+00,   0.16682D+01/
  data pars( 48621: 48625) /149,144,   0.50016280D+03,   0.96330D+00,   0.18584D+01/
  data pars( 48626: 48630) /149,145,   0.46737710D+03,   0.96330D+00,   0.19003D+01/
  data pars( 48631: 48635) /149,146,   0.43299730D+03,   0.96330D+00,   0.18630D+01/
  data pars( 48636: 48640) /149,147,   0.41968680D+03,   0.96330D+00,   0.96790D+00/
  data pars( 48641: 48645) /149,148,   0.41115760D+03,   0.96330D+00,   0.19539D+01/
  data pars( 48646: 48650) /149,149,   0.67899200D+03,   0.96330D+00,   0.96330D+00/
  data pars( 48651: 48655) /150,  1,   0.39050000D+02,   0.95140D+00,   0.91180D+00/
  data pars( 48656: 48660) /150,  2,   0.25410500D+02,   0.95140D+00,   0.00000D+00/
  data pars( 48661: 48665) /150,  3,   0.64241900D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48666: 48670) /150,  4,   0.36274340D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48671: 48675) /150,  5,   0.24059340D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48676: 48680) /150,  6,   0.16058760D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48681: 48685) /150,  7,   0.11127680D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48686: 48690) /150,  8,   0.83712000D+02,   0.95140D+00,   0.00000D+00/
  data pars( 48691: 48695) /150,  9,   0.63080600D+02,   0.95140D+00,   0.00000D+00/
  data pars( 48696: 48700) /150, 10,   0.48325800D+02,   0.95140D+00,   0.00000D+00/
  data pars( 48701: 48705) /150, 11,   0.76709550D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48706: 48710) /150, 12,   0.58045000D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48711: 48715) /150, 13,   0.53107940D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48716: 48720) /150, 14,   0.41414030D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48721: 48725) /150, 15,   0.31993070D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48726: 48730) /150, 16,   0.26382770D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48731: 48735) /150, 17,   0.21417230D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48736: 48740) /150, 18,   0.17426390D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48741: 48745) /150, 19,   0.12595964D+04,   0.95140D+00,   0.00000D+00/
  data pars( 48746: 48750) /150, 20,   0.10266097D+04,   0.95140D+00,   0.00000D+00/
  data pars( 48751: 48755) /150, 21,   0.84554470D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48756: 48760) /150, 22,   0.81389640D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48761: 48765) /150, 23,   0.74392530D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48766: 48770) /150, 24,   0.58540690D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48771: 48775) /150, 25,   0.63875870D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48776: 48780) /150, 26,   0.50063040D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48781: 48785) /150, 27,   0.52899650D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48786: 48790) /150, 28,   0.54604730D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48791: 48795) /150, 29,   0.41817300D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48796: 48800) /150, 30,   0.42710250D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48801: 48805) /150, 31,   0.50688380D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48806: 48810) /150, 32,   0.44348920D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48811: 48815) /150, 33,   0.37536940D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48816: 48820) /150, 34,   0.33511820D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48821: 48825) /150, 35,   0.29171790D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48826: 48830) /150, 36,   0.25244080D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48831: 48835) /150, 37,   0.14095386D+04,   0.95140D+00,   0.00000D+00/
  data pars( 48836: 48840) /150, 38,   0.12233073D+04,   0.95140D+00,   0.00000D+00/
  data pars( 48841: 48845) /150, 39,   0.10654342D+04,   0.95140D+00,   0.00000D+00/
  data pars( 48846: 48850) /150, 40,   0.95393220D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48851: 48855) /150, 41,   0.86754750D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48856: 48860) /150, 42,   0.66641970D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48861: 48865) /150, 43,   0.74499930D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48866: 48870) /150, 44,   0.56445890D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48871: 48875) /150, 45,   0.61737910D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48876: 48880) /150, 46,   0.57156020D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48881: 48885) /150, 47,   0.47659660D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48886: 48890) /150, 48,   0.50255130D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48891: 48895) /150, 49,   0.63411950D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48896: 48900) /150, 50,   0.58276930D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48901: 48905) /150, 51,   0.51594670D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48906: 48910) /150, 52,   0.47668110D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48911: 48915) /150, 53,   0.42899630D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48916: 48920) /150, 54,   0.38394570D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48921: 48925) /150, 55,   0.17161526D+04,   0.95140D+00,   0.00000D+00/
  data pars( 48926: 48930) /150, 56,   0.15618289D+04,   0.95140D+00,   0.00000D+00/
  data pars( 48931: 48935) /150, 57,   0.13644290D+04,   0.95140D+00,   0.00000D+00/
  data pars( 48936: 48940) /150, 58,   0.61000420D+03,   0.95140D+00,   0.27991D+01/
  data pars( 48941: 48945) /150, 59,   0.13811677D+04,   0.95140D+00,   0.00000D+00/
  data pars( 48946: 48950) /150, 60,   0.13251151D+04,   0.95140D+00,   0.00000D+00/
  data pars( 48951: 48955) /150, 61,   0.12915707D+04,   0.95140D+00,   0.00000D+00/
  data pars( 48956: 48960) /150, 62,   0.12607608D+04,   0.95140D+00,   0.00000D+00/
  data pars( 48961: 48965) /150, 63,   0.12334280D+04,   0.95140D+00,   0.00000D+00/
  data pars( 48966: 48970) /150, 64,   0.96322340D+03,   0.95140D+00,   0.00000D+00/
  data pars( 48971: 48975) /150, 65,   0.10940703D+04,   0.95140D+00,   0.00000D+00/
  data pars( 48976: 48980) /150, 66,   0.10539748D+04,   0.95140D+00,   0.00000D+00/
  data pars( 48981: 48985) /150, 67,   0.11110005D+04,   0.95140D+00,   0.00000D+00/
  data pars( 48986: 48990) /150, 68,   0.10872901D+04,   0.95140D+00,   0.00000D+00/
  data pars( 48991: 48995) /150, 69,   0.10658196D+04,   0.95140D+00,   0.00000D+00/
  data pars( 48996: 49000) /150, 70,   0.10536773D+04,   0.95140D+00,   0.00000D+00/
  data pars( 49001: 49005) /150, 71,   0.88359210D+03,   0.95140D+00,   0.00000D+00/
  data pars( 49006: 49010) /150, 72,   0.86380750D+03,   0.95140D+00,   0.00000D+00/
  data pars( 49011: 49015) /150, 73,   0.78517710D+03,   0.95140D+00,   0.00000D+00/
  data pars( 49016: 49020) /150, 74,   0.66055390D+03,   0.95140D+00,   0.00000D+00/
  data pars( 49021: 49025) /150, 75,   0.67110130D+03,   0.95140D+00,   0.00000D+00/
  data pars( 49026: 49030) /150, 76,   0.60606460D+03,   0.95140D+00,   0.00000D+00/
  data pars( 49031: 49035) /150, 77,   0.55342010D+03,   0.95140D+00,   0.00000D+00/
  data pars( 49036: 49040) /150, 78,   0.45807960D+03,   0.95140D+00,   0.00000D+00/
  data pars( 49041: 49045) /150, 79,   0.42739480D+03,   0.95140D+00,   0.00000D+00/
  data pars( 49046: 49050) /150, 80,   0.43923750D+03,   0.95140D+00,   0.00000D+00/
  data pars( 49051: 49055) /150, 81,   0.64947520D+03,   0.95140D+00,   0.00000D+00/
  data pars( 49056: 49060) /150, 82,   0.63216060D+03,   0.95140D+00,   0.00000D+00/
  data pars( 49061: 49065) /150, 83,   0.57757500D+03,   0.95140D+00,   0.00000D+00/
  data pars( 49066: 49070) /150, 84,   0.54893280D+03,   0.95140D+00,   0.00000D+00/
  data pars( 49071: 49075) /150, 85,   0.50441400D+03,   0.95140D+00,   0.00000D+00/
  data pars( 49076: 49080) /150, 86,   0.46043530D+03,   0.95140D+00,   0.00000D+00/
  data pars( 49081: 49085) /150, 87,   0.16132050D+04,   0.95140D+00,   0.00000D+00/
  data pars( 49086: 49090) /150, 88,   0.15396549D+04,   0.95140D+00,   0.00000D+00/
  data pars( 49091: 49095) /150, 89,   0.13539743D+04,   0.95140D+00,   0.00000D+00/
  data pars( 49096: 49100) /150, 90,   0.12088936D+04,   0.95140D+00,   0.00000D+00/
  data pars( 49101: 49105) /150, 91,   0.12037043D+04,   0.95140D+00,   0.00000D+00/
  data pars( 49106: 49110) /150, 92,   0.11652987D+04,   0.95140D+00,   0.00000D+00/
  data pars( 49111: 49115) /150, 93,   0.12045686D+04,   0.95140D+00,   0.00000D+00/
  data pars( 49116: 49120) /150, 94,   0.11657062D+04,   0.95140D+00,   0.00000D+00/
  data pars( 49121: 49125) /150,101,   0.63518900D+02,   0.95140D+00,   0.00000D+00/
  data pars( 49126: 49130) /150,103,   0.21038150D+03,   0.95140D+00,   0.98650D+00/
  data pars( 49131: 49135) /150,104,   0.26750360D+03,   0.95140D+00,   0.98080D+00/
  data pars( 49136: 49140) /150,105,   0.20167580D+03,   0.95140D+00,   0.97060D+00/
  data pars( 49141: 49145) /150,106,   0.15060400D+03,   0.95140D+00,   0.98680D+00/
  data pars( 49146: 49150) /150,107,   0.10370700D+03,   0.95140D+00,   0.99440D+00/
  data pars( 49151: 49155) /150,108,   0.74928900D+02,   0.95140D+00,   0.99250D+00/
  data pars( 49156: 49160) /150,109,   0.51049200D+02,   0.95140D+00,   0.99820D+00/
  data pars( 49161: 49165) /150,111,   0.30824700D+03,   0.95140D+00,   0.96840D+00/
  data pars( 49166: 49170) /150,112,   0.47728480D+03,   0.95140D+00,   0.96280D+00/
  data pars( 49171: 49175) /150,113,   0.48037350D+03,   0.95140D+00,   0.96480D+00/
  data pars( 49176: 49180) /150,114,   0.38212550D+03,   0.95140D+00,   0.95070D+00/
  data pars( 49181: 49185) /150,115,   0.31042380D+03,   0.95140D+00,   0.99470D+00/
  data pars( 49186: 49190) /150,116,   0.26094970D+03,   0.95140D+00,   0.99480D+00/
  data pars( 49191: 49195) /150,117,   0.21197090D+03,   0.95140D+00,   0.99720D+00/
  data pars( 49196: 49200) /150,119,   0.42200550D+03,   0.95140D+00,   0.97670D+00/
  data pars( 49201: 49205) /150,120,   0.81999260D+03,   0.95140D+00,   0.98310D+00/
  data pars( 49206: 49210) /150,121,   0.41914320D+03,   0.95140D+00,   0.18627D+01/
  data pars( 49211: 49215) /150,122,   0.40443780D+03,   0.95140D+00,   0.18299D+01/
  data pars( 49216: 49220) /150,123,   0.39640790D+03,   0.95140D+00,   0.19138D+01/
  data pars( 49221: 49225) /150,124,   0.39312150D+03,   0.95140D+00,   0.18269D+01/
  data pars( 49226: 49230) /150,125,   0.36011140D+03,   0.95140D+00,   0.16406D+01/
  data pars( 49231: 49235) /150,126,   0.33275950D+03,   0.95140D+00,   0.16483D+01/
  data pars( 49236: 49240) /150,127,   0.31739780D+03,   0.95140D+00,   0.17149D+01/
  data pars( 49241: 49245) /150,128,   0.31042370D+03,   0.95140D+00,   0.17937D+01/
  data pars( 49246: 49250) /150,129,   0.30781940D+03,   0.95140D+00,   0.95760D+00/
  data pars( 49251: 49255) /150,130,   0.28694640D+03,   0.95140D+00,   0.19419D+01/
  data pars( 49256: 49260) /150,131,   0.47510140D+03,   0.95140D+00,   0.96010D+00/
  data pars( 49261: 49265) /150,132,   0.41406130D+03,   0.95140D+00,   0.94340D+00/
  data pars( 49266: 49270) /150,133,   0.36881960D+03,   0.95140D+00,   0.98890D+00/
  data pars( 49271: 49275) /150,134,   0.33526670D+03,   0.95140D+00,   0.99010D+00/
  data pars( 49276: 49280) /150,135,   0.29382390D+03,   0.95140D+00,   0.99740D+00/
  data pars( 49281: 49285) /150,137,   0.50249860D+03,   0.95140D+00,   0.97380D+00/
  data pars( 49286: 49290) /150,138,   0.99819190D+03,   0.95140D+00,   0.98010D+00/
  data pars( 49291: 49295) /150,139,   0.75411460D+03,   0.95140D+00,   0.19153D+01/
  data pars( 49296: 49300) /150,140,   0.55441070D+03,   0.95140D+00,   0.19355D+01/
  data pars( 49301: 49305) /150,141,   0.55998500D+03,   0.95140D+00,   0.19545D+01/
  data pars( 49306: 49310) /150,142,   0.52115630D+03,   0.95140D+00,   0.19420D+01/
  data pars( 49311: 49315) /150,143,   0.58793550D+03,   0.95140D+00,   0.16682D+01/
  data pars( 49316: 49320) /150,144,   0.45216820D+03,   0.95140D+00,   0.18584D+01/
  data pars( 49321: 49325) /150,145,   0.42274380D+03,   0.95140D+00,   0.19003D+01/
  data pars( 49326: 49330) /150,146,   0.39214710D+03,   0.95140D+00,   0.18630D+01/
  data pars( 49331: 49335) /150,147,   0.37963350D+03,   0.95140D+00,   0.96790D+00/
  data pars( 49336: 49340) /150,148,   0.37434300D+03,   0.95140D+00,   0.19539D+01/
  data pars( 49341: 49345) /150,149,   0.60309650D+03,   0.95140D+00,   0.96330D+00/
  data pars( 49346: 49350) /150,150,   0.54204390D+03,   0.95140D+00,   0.95140D+00/
  data pars( 49351: 49355) /151,  1,   0.37118600D+02,   0.97490D+00,   0.91180D+00/
  data pars( 49356: 49360) /151,  2,   0.24506800D+02,   0.97490D+00,   0.00000D+00/
  data pars( 49361: 49365) /151,  3,   0.56950200D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49366: 49370) /151,  4,   0.33206650D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49371: 49375) /151,  5,   0.22424380D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49376: 49380) /151,  6,   0.15163340D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49381: 49385) /151,  7,   0.10605380D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49386: 49390) /151,  8,   0.80289900D+02,   0.97490D+00,   0.00000D+00/
  data pars( 49391: 49395) /151,  9,   0.60817400D+02,   0.97490D+00,   0.00000D+00/
  data pars( 49396: 49400) /151, 10,   0.46777500D+02,   0.97490D+00,   0.00000D+00/
  data pars( 49401: 49405) /151, 11,   0.68136500D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49406: 49410) /151, 12,   0.52835450D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49411: 49415) /151, 13,   0.48798470D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49416: 49420) /151, 14,   0.38531020D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49421: 49425) /151, 15,   0.30075580D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49426: 49430) /151, 16,   0.24964690D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49431: 49435) /151, 17,   0.20391030D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49436: 49440) /151, 18,   0.16677960D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49441: 49445) /151, 19,   0.11139369D+04,   0.97490D+00,   0.00000D+00/
  data pars( 49446: 49450) /151, 20,   0.92532660D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49451: 49455) /151, 21,   0.76543030D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49456: 49460) /151, 22,   0.73977510D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49461: 49465) /151, 23,   0.67780140D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49466: 49470) /151, 24,   0.53372530D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49471: 49475) /151, 25,   0.58400790D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49476: 49480) /151, 26,   0.45821350D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49481: 49485) /151, 27,   0.48646450D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49486: 49490) /151, 28,   0.50090110D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49491: 49495) /151, 29,   0.38380100D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49496: 49500) /151, 30,   0.39484340D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49501: 49505) /151, 31,   0.46751190D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49506: 49510) /151, 32,   0.41296610D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49511: 49515) /151, 33,   0.35254270D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49516: 49520) /151, 34,   0.31639840D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49521: 49525) /151, 35,   0.27688560D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49526: 49530) /151, 36,   0.24075150D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49531: 49535) /151, 37,   0.12488109D+04,   0.97490D+00,   0.00000D+00/
  data pars( 49536: 49540) /151, 38,   0.11019644D+04,   0.97490D+00,   0.00000D+00/
  data pars( 49541: 49545) /151, 39,   0.96716720D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49546: 49550) /151, 40,   0.87013340D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49551: 49555) /151, 41,   0.79387710D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49556: 49560) /151, 42,   0.61324700D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49561: 49565) /151, 43,   0.68412920D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49566: 49570) /151, 44,   0.52150710D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49571: 49575) /151, 45,   0.57027900D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49576: 49580) /151, 46,   0.52899540D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49581: 49585) /151, 47,   0.44070410D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49586: 49590) /151, 48,   0.46629410D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49591: 49595) /151, 49,   0.58471100D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49596: 49600) /151, 50,   0.54152090D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49601: 49605) /151, 51,   0.48305960D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49606: 49610) /151, 52,   0.44833330D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49611: 49615) /151, 53,   0.40544000D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49616: 49620) /151, 54,   0.36450640D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49621: 49625) /151, 55,   0.15212386D+04,   0.97490D+00,   0.00000D+00/
  data pars( 49626: 49630) /151, 56,   0.14035743D+04,   0.97490D+00,   0.00000D+00/
  data pars( 49631: 49635) /151, 57,   0.12355723D+04,   0.97490D+00,   0.00000D+00/
  data pars( 49636: 49640) /151, 58,   0.57038460D+03,   0.97490D+00,   0.27991D+01/
  data pars( 49641: 49645) /151, 59,   0.12443690D+04,   0.97490D+00,   0.00000D+00/
  data pars( 49646: 49650) /151, 60,   0.11953394D+04,   0.97490D+00,   0.00000D+00/
  data pars( 49651: 49655) /151, 61,   0.11654811D+04,   0.97490D+00,   0.00000D+00/
  data pars( 49656: 49660) /151, 62,   0.11380116D+04,   0.97490D+00,   0.00000D+00/
  data pars( 49661: 49665) /151, 63,   0.11136574D+04,   0.97490D+00,   0.00000D+00/
  data pars( 49666: 49670) /151, 64,   0.87723370D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49671: 49675) /151, 65,   0.98436690D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49676: 49680) /151, 66,   0.94971600D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49681: 49685) /151, 67,   0.10050059D+04,   0.97490D+00,   0.00000D+00/
  data pars( 49686: 49690) /151, 68,   0.98375110D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49691: 49695) /151, 69,   0.96460520D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49696: 49700) /151, 70,   0.95326960D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49701: 49705) /151, 71,   0.80412310D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49706: 49710) /151, 72,   0.79227200D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49711: 49715) /151, 73,   0.72359370D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49716: 49720) /151, 74,   0.61110290D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49721: 49725) /151, 75,   0.62195650D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49726: 49730) /151, 76,   0.56397010D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49731: 49735) /151, 77,   0.51667170D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49736: 49740) /151, 78,   0.42917250D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49741: 49745) /151, 79,   0.40097810D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49746: 49750) /151, 80,   0.41268870D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49751: 49755) /151, 81,   0.60016760D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49756: 49760) /151, 82,   0.58760720D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49761: 49765) /151, 83,   0.54048320D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49766: 49770) /151, 84,   0.51568470D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49771: 49775) /151, 85,   0.47605910D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49776: 49780) /151, 86,   0.43636860D+03,   0.97490D+00,   0.00000D+00/
  data pars( 49781: 49785) /151, 87,   0.14387730D+04,   0.97490D+00,   0.00000D+00/
  data pars( 49786: 49790) /151, 88,   0.13892118D+04,   0.97490D+00,   0.00000D+00/
  data pars( 49791: 49795) /151, 89,   0.12302614D+04,   0.97490D+00,   0.00000D+00/
  data pars( 49796: 49800) /151, 90,   0.11073931D+04,   0.97490D+00,   0.00000D+00/
  data pars( 49801: 49805) /151, 91,   0.10983173D+04,   0.97490D+00,   0.00000D+00/
  data pars( 49806: 49810) /151, 92,   0.10634833D+04,   0.97490D+00,   0.00000D+00/
  data pars( 49811: 49815) /151, 93,   0.10937836D+04,   0.97490D+00,   0.00000D+00/
  data pars( 49816: 49820) /151, 94,   0.10594592D+04,   0.97490D+00,   0.00000D+00/
  data pars( 49821: 49825) /151,101,   0.59779600D+02,   0.97490D+00,   0.00000D+00/
  data pars( 49826: 49830) /151,103,   0.19308010D+03,   0.97490D+00,   0.98650D+00/
  data pars( 49831: 49835) /151,104,   0.24635800D+03,   0.97490D+00,   0.98080D+00/
  data pars( 49836: 49840) /151,105,   0.18865770D+03,   0.97490D+00,   0.97060D+00/
  data pars( 49841: 49845) /151,106,   0.14217370D+03,   0.97490D+00,   0.98680D+00/
  data pars( 49846: 49850) /151,107,   0.98858300D+02,   0.97490D+00,   0.99440D+00/
  data pars( 49851: 49855) /151,108,   0.71981600D+02,   0.97490D+00,   0.99250D+00/
  data pars( 49856: 49860) /151,109,   0.49497000D+02,   0.97490D+00,   0.99820D+00/
  data pars( 49861: 49865) /151,111,   0.28199230D+03,   0.97490D+00,   0.96840D+00/
  data pars( 49866: 49870) /151,112,   0.43599230D+03,   0.97490D+00,   0.96280D+00/
  data pars( 49871: 49875) /151,113,   0.44239460D+03,   0.97490D+00,   0.96480D+00/
  data pars( 49876: 49880) /151,114,   0.35616810D+03,   0.97490D+00,   0.95070D+00/
  data pars( 49881: 49885) /151,115,   0.29192250D+03,   0.97490D+00,   0.99470D+00/
  data pars( 49886: 49890) /151,116,   0.24688440D+03,   0.97490D+00,   0.99480D+00/
  data pars( 49891: 49895) /151,117,   0.20178980D+03,   0.97490D+00,   0.99720D+00/
  data pars( 49896: 49900) /151,119,   0.38878440D+03,   0.97490D+00,   0.97670D+00/
  data pars( 49901: 49905) /151,120,   0.73983800D+03,   0.97490D+00,   0.98310D+00/
  data pars( 49906: 49910) /151,121,   0.38986450D+03,   0.97490D+00,   0.18627D+01/
  data pars( 49911: 49915) /151,122,   0.37633360D+03,   0.97490D+00,   0.18299D+01/
  data pars( 49916: 49920) /151,123,   0.36879080D+03,   0.97490D+00,   0.19138D+01/
  data pars( 49921: 49925) /151,124,   0.36529400D+03,   0.97490D+00,   0.18269D+01/
  data pars( 49926: 49930) /151,125,   0.33651780D+03,   0.97490D+00,   0.16406D+01/
  data pars( 49931: 49935) /151,126,   0.31148590D+03,   0.97490D+00,   0.16483D+01/
  data pars( 49936: 49940) /151,127,   0.29711100D+03,   0.97490D+00,   0.17149D+01/
  data pars( 49941: 49945) /151,128,   0.29044330D+03,   0.97490D+00,   0.17937D+01/
  data pars( 49946: 49950) /151,129,   0.28674360D+03,   0.97490D+00,   0.95760D+00/
  data pars( 49951: 49955) /151,130,   0.26942080D+03,   0.97490D+00,   0.19419D+01/
  data pars( 49956: 49960) /151,131,   0.43926920D+03,   0.97490D+00,   0.96010D+00/
  data pars( 49961: 49965) /151,132,   0.38642600D+03,   0.97490D+00,   0.94340D+00/
  data pars( 49966: 49970) /151,133,   0.34656560D+03,   0.97490D+00,   0.98890D+00/
  data pars( 49971: 49975) /151,134,   0.31651250D+03,   0.97490D+00,   0.99010D+00/
  data pars( 49976: 49980) /151,135,   0.27880760D+03,   0.97490D+00,   0.99740D+00/
  data pars( 49981: 49985) /151,137,   0.46396320D+03,   0.97490D+00,   0.97380D+00/
  data pars( 49986: 49990) /151,138,   0.89977960D+03,   0.97490D+00,   0.98010D+00/
  data pars( 49991: 49995) /151,139,   0.69024350D+03,   0.97490D+00,   0.19153D+01/
  data pars( 49996: 50000) /151,140,   0.51535410D+03,   0.97490D+00,   0.19355D+01/
  data pars( 50001: 50005) /151,141,   0.52041820D+03,   0.97490D+00,   0.19545D+01/
  data pars( 50006: 50010) /151,142,   0.48533740D+03,   0.97490D+00,   0.19420D+01/
  data pars( 50011: 50015) /151,143,   0.54348220D+03,   0.97490D+00,   0.16682D+01/
  data pars( 50016: 50020) /151,144,   0.42337510D+03,   0.97490D+00,   0.18584D+01/
  data pars( 50021: 50025) /151,145,   0.39603590D+03,   0.97490D+00,   0.19003D+01/
  data pars( 50026: 50030) /151,146,   0.36774930D+03,   0.97490D+00,   0.18630D+01/
  data pars( 50031: 50035) /151,147,   0.35570800D+03,   0.97490D+00,   0.96790D+00/
  data pars( 50036: 50040) /151,148,   0.35221320D+03,   0.97490D+00,   0.19539D+01/
  data pars( 50041: 50045) /151,149,   0.55762720D+03,   0.97490D+00,   0.96330D+00/
  data pars( 50046: 50050) /151,150,   0.50519000D+03,   0.97490D+00,   0.95140D+00/
  data pars( 50051: 50055) /151,151,   0.47347030D+03,   0.97490D+00,   0.97490D+00/
  data pars( 50056: 50060) /152,  1,   0.35486100D+02,   0.98110D+00,   0.91180D+00/
  data pars( 50061: 50065) /152,  2,   0.23710000D+02,   0.98110D+00,   0.00000D+00/
  data pars( 50066: 50070) /152,  3,   0.51945180D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50071: 50075) /152,  4,   0.30894260D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50076: 50080) /152,  5,   0.21127990D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50081: 50085) /152,  6,   0.14426000D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50086: 50090) /152,  7,   0.10163150D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50091: 50095) /152,  8,   0.77336500D+02,   0.98110D+00,   0.00000D+00/
  data pars( 50096: 50100) /152,  9,   0.58833200D+02,   0.98110D+00,   0.00000D+00/
  data pars( 50101: 50105) /152, 10,   0.45404400D+02,   0.98110D+00,   0.00000D+00/
  data pars( 50106: 50110) /152, 11,   0.62230990D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50111: 50115) /152, 12,   0.48978200D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50116: 50120) /152, 13,   0.45524770D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50121: 50125) /152, 14,   0.36255610D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50126: 50130) /152, 15,   0.28512390D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50131: 50135) /152, 16,   0.23785710D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50136: 50140) /152, 17,   0.19521310D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50141: 50145) /152, 18,   0.16033310D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50146: 50150) /152, 19,   0.10157738D+04,   0.98110D+00,   0.00000D+00/
  data pars( 50151: 50155) /152, 20,   0.85290360D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50156: 50160) /152, 21,   0.70737690D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50161: 50165) /152, 22,   0.68556870D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50166: 50170) /152, 23,   0.62913900D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50171: 50175) /152, 24,   0.49588010D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50176: 50180) /152, 25,   0.54334380D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50181: 50185) /152, 26,   0.42683610D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50186: 50190) /152, 27,   0.45431700D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50191: 50195) /152, 28,   0.46700090D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50196: 50200) /152, 29,   0.35818700D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50201: 50205) /152, 30,   0.37006740D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50206: 50210) /152, 31,   0.43744170D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50211: 50215) /152, 32,   0.38889460D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50216: 50220) /152, 33,   0.33402630D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50221: 50225) /152, 34,   0.30096170D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50226: 50230) /152, 35,   0.26444460D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50231: 50235) /152, 36,   0.23079470D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50236: 50240) /152, 37,   0.11403397D+04,   0.98110D+00,   0.00000D+00/
  data pars( 50241: 50245) /152, 38,   0.10156122D+04,   0.98110D+00,   0.00000D+00/
  data pars( 50246: 50250) /152, 39,   0.89573040D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50251: 50255) /152, 40,   0.80842520D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50256: 50260) /152, 41,   0.73920970D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50261: 50265) /152, 42,   0.57337000D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50266: 50270) /152, 43,   0.63864620D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50271: 50275) /152, 44,   0.48901000D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50276: 50280) /152, 45,   0.53445110D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50281: 50285) /152, 46,   0.49643130D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50286: 50290) /152, 47,   0.41359130D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50291: 50295) /152, 48,   0.43835340D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50296: 50300) /152, 49,   0.54729130D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50301: 50305) /152, 50,   0.50938490D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50306: 50310) /152, 51,   0.45675890D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50311: 50315) /152, 52,   0.42531520D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50316: 50320) /152, 53,   0.38599880D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50321: 50325) /152, 54,   0.34821640D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50326: 50330) /152, 55,   0.13899562D+04,   0.98110D+00,   0.00000D+00/
  data pars( 50331: 50335) /152, 56,   0.12920505D+04,   0.98110D+00,   0.00000D+00/
  data pars( 50336: 50340) /152, 57,   0.11428009D+04,   0.98110D+00,   0.00000D+00/
  data pars( 50341: 50345) /152, 58,   0.53897800D+03,   0.98110D+00,   0.27991D+01/
  data pars( 50346: 50350) /152, 59,   0.11473718D+04,   0.98110D+00,   0.00000D+00/
  data pars( 50351: 50355) /152, 60,   0.11029411D+04,   0.98110D+00,   0.00000D+00/
  data pars( 50356: 50360) /152, 61,   0.10755989D+04,   0.98110D+00,   0.00000D+00/
  data pars( 50361: 50365) /152, 62,   0.10504168D+04,   0.98110D+00,   0.00000D+00/
  data pars( 50366: 50370) /152, 63,   0.10280990D+04,   0.98110D+00,   0.00000D+00/
  data pars( 50371: 50375) /152, 64,   0.81457180D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50376: 50380) /152, 65,   0.90749290D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50381: 50385) /152, 66,   0.87640540D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50386: 50390) /152, 67,   0.92881650D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50391: 50395) /152, 68,   0.90926160D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50396: 50400) /152, 69,   0.89171060D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50401: 50405) /152, 70,   0.88100370D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50406: 50410) /152, 71,   0.74613080D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50411: 50415) /152, 72,   0.73873540D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50416: 50420) /152, 73,   0.67688650D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50421: 50425) /152, 74,   0.57338870D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50426: 50430) /152, 75,   0.58418960D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50431: 50435) /152, 76,   0.53122090D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50436: 50440) /152, 77,   0.48779780D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50441: 50445) /152, 78,   0.40633480D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50446: 50450) /152, 79,   0.38005290D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50451: 50455) /152, 80,   0.39145330D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50456: 50460) /152, 81,   0.56288150D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50461: 50465) /152, 82,   0.55306450D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50466: 50470) /152, 83,   0.51099880D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50471: 50475) /152, 84,   0.48888150D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50476: 50480) /152, 85,   0.45282060D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50481: 50485) /152, 86,   0.41635580D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50486: 50490) /152, 87,   0.13196282D+04,   0.98110D+00,   0.00000D+00/
  data pars( 50491: 50495) /152, 88,   0.12821564D+04,   0.98110D+00,   0.00000D+00/
  data pars( 50496: 50500) /152, 89,   0.11403381D+04,   0.98110D+00,   0.00000D+00/
  data pars( 50501: 50505) /152, 90,   0.10319646D+04,   0.98110D+00,   0.00000D+00/
  data pars( 50506: 50510) /152, 91,   0.10211167D+04,   0.98110D+00,   0.00000D+00/
  data pars( 50511: 50515) /152, 92,   0.98886570D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50516: 50520) /152, 93,   0.10136901D+04,   0.98110D+00,   0.00000D+00/
  data pars( 50521: 50525) /152, 94,   0.98242950D+03,   0.98110D+00,   0.00000D+00/
  data pars( 50526: 50530) /152,101,   0.56715600D+02,   0.98110D+00,   0.00000D+00/
  data pars( 50531: 50535) /152,103,   0.17998120D+03,   0.98110D+00,   0.98650D+00/
  data pars( 50536: 50540) /152,104,   0.23026410D+03,   0.98110D+00,   0.98080D+00/
  data pars( 50541: 50545) /152,105,   0.17825090D+03,   0.98110D+00,   0.97060D+00/
  data pars( 50546: 50550) /152,106,   0.13527200D+03,   0.98110D+00,   0.98680D+00/
  data pars( 50551: 50555) /152,107,   0.94770500D+02,   0.98110D+00,   0.99440D+00/
  data pars( 50556: 50560) /152,108,   0.69431700D+02,   0.98110D+00,   0.99250D+00/
  data pars( 50561: 50565) /152,109,   0.48103700D+02,   0.98110D+00,   0.99820D+00/
  data pars( 50566: 50570) /152,111,   0.26236970D+03,   0.98110D+00,   0.96840D+00/
  data pars( 50571: 50575) /152,112,   0.40525290D+03,   0.98110D+00,   0.96280D+00/
  data pars( 50576: 50580) /152,113,   0.41338560D+03,   0.98110D+00,   0.96480D+00/
  data pars( 50581: 50585) /152,114,   0.33559140D+03,   0.98110D+00,   0.95070D+00/
  data pars( 50586: 50590) /152,115,   0.27683720D+03,   0.98110D+00,   0.99470D+00/
  data pars( 50591: 50595) /152,116,   0.23520590D+03,   0.98110D+00,   0.99480D+00/
  data pars( 50596: 50600) /152,117,   0.19317040D+03,   0.98110D+00,   0.99720D+00/
  data pars( 50601: 50605) /152,119,   0.36384820D+03,   0.98110D+00,   0.97670D+00/
  data pars( 50606: 50610) /152,120,   0.68296210D+03,   0.98110D+00,   0.98310D+00/
  data pars( 50611: 50615) /152,121,   0.36699000D+03,   0.98110D+00,   0.18627D+01/
  data pars( 50616: 50620) /152,122,   0.35440290D+03,   0.98110D+00,   0.18299D+01/
  data pars( 50621: 50625) /152,123,   0.34726480D+03,   0.98110D+00,   0.19138D+01/
  data pars( 50626: 50630) /152,124,   0.34370870D+03,   0.98110D+00,   0.18269D+01/
  data pars( 50631: 50635) /152,125,   0.31777500D+03,   0.98110D+00,   0.16406D+01/
  data pars( 50636: 50640) /152,126,   0.29450790D+03,   0.98110D+00,   0.16483D+01/
  data pars( 50641: 50645) /152,127,   0.28094820D+03,   0.98110D+00,   0.17149D+01/
  data pars( 50646: 50650) /152,128,   0.27455800D+03,   0.98110D+00,   0.17937D+01/
  data pars( 50651: 50655) /152,129,   0.27027830D+03,   0.98110D+00,   0.95760D+00/
  data pars( 50656: 50660) /152,130,   0.25527130D+03,   0.98110D+00,   0.19419D+01/
  data pars( 50661: 50665) /152,131,   0.41170180D+03,   0.98110D+00,   0.96010D+00/
  data pars( 50666: 50670) /152,132,   0.36448820D+03,   0.98110D+00,   0.94340D+00/
  data pars( 50671: 50675) /152,133,   0.32849090D+03,   0.98110D+00,   0.98890D+00/
  data pars( 50676: 50680) /152,134,   0.30105670D+03,   0.98110D+00,   0.99010D+00/
  data pars( 50681: 50685) /152,135,   0.26622780D+03,   0.98110D+00,   0.99740D+00/
  data pars( 50686: 50690) /152,137,   0.43493910D+03,   0.98110D+00,   0.97380D+00/
  data pars( 50691: 50695) /152,138,   0.83036610D+03,   0.98110D+00,   0.98010D+00/
  data pars( 50696: 50700) /152,139,   0.64326970D+03,   0.98110D+00,   0.19153D+01/
  data pars( 50701: 50705) /152,140,   0.48508560D+03,   0.98110D+00,   0.19355D+01/
  data pars( 50706: 50710) /152,141,   0.48977500D+03,   0.98110D+00,   0.19545D+01/
  data pars( 50711: 50715) /152,142,   0.45747170D+03,   0.98110D+00,   0.19420D+01/
  data pars( 50716: 50720) /152,143,   0.50987810D+03,   0.98110D+00,   0.16682D+01/
  data pars( 50721: 50725) /152,144,   0.40053650D+03,   0.98110D+00,   0.18584D+01/
  data pars( 50726: 50730) /152,145,   0.37486560D+03,   0.98110D+00,   0.19003D+01/
  data pars( 50731: 50735) /152,146,   0.34838020D+03,   0.98110D+00,   0.18630D+01/
  data pars( 50736: 50740) /152,147,   0.33677710D+03,   0.98110D+00,   0.96790D+00/
  data pars( 50741: 50745) /152,148,   0.33432410D+03,   0.98110D+00,   0.19539D+01/
  data pars( 50746: 50750) /152,149,   0.52288630D+03,   0.98110D+00,   0.96330D+00/
  data pars( 50751: 50755) /152,150,   0.47620870D+03,   0.98110D+00,   0.95140D+00/
  data pars( 50756: 50760) /152,151,   0.44801730D+03,   0.98110D+00,   0.97490D+00/
  data pars( 50761: 50765) /152,152,   0.42510150D+03,   0.98110D+00,   0.98110D+00/
  data pars( 50766: 50770) /153,  1,   0.32815100D+02,   0.99680D+00,   0.91180D+00/
  data pars( 50771: 50775) /153,  2,   0.22271700D+02,   0.99680D+00,   0.00000D+00/
  data pars( 50776: 50780) /153,  3,   0.45439540D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50781: 50785) /153,  4,   0.27643090D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50786: 50790) /153,  5,   0.19192730D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50791: 50795) /153,  6,   0.13262510D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50796: 50800) /153,  7,   0.94299100D+02,   0.99680D+00,   0.00000D+00/
  data pars( 50801: 50805) /153,  8,   0.72235800D+02,   0.99680D+00,   0.00000D+00/
  data pars( 50806: 50810) /153,  9,   0.55268900D+02,   0.99680D+00,   0.00000D+00/
  data pars( 50811: 50815) /153, 10,   0.42851200D+02,   0.99680D+00,   0.00000D+00/
  data pars( 50816: 50820) /153, 11,   0.54528550D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50821: 50825) /153, 12,   0.43644520D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50826: 50830) /153, 13,   0.40871490D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50831: 50835) /153, 14,   0.32881570D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50836: 50840) /153, 15,   0.26094460D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50841: 50845) /153, 16,   0.21904300D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50846: 50850) /153, 17,   0.18086040D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50851: 50855) /153, 18,   0.14934300D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50856: 50860) /153, 19,   0.88900260D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50861: 50865) /153, 20,   0.75534780D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50866: 50870) /153, 21,   0.62833170D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50871: 50875) /153, 22,   0.61099490D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50876: 50880) /153, 23,   0.56176430D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50881: 50885) /153, 24,   0.44344010D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50886: 50890) /153, 25,   0.48650250D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50891: 50895) /153, 26,   0.38289000D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50896: 50900) /153, 27,   0.40860640D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50901: 50905) /153, 28,   0.41915920D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50906: 50910) /153, 29,   0.32203460D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50911: 50915) /153, 30,   0.33424140D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50916: 50920) /153, 31,   0.39422890D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50921: 50925) /153, 32,   0.35311560D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50926: 50930) /153, 33,   0.30552140D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50931: 50935) /153, 34,   0.27661090D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50936: 50940) /153, 35,   0.24427520D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50941: 50945) /153, 36,   0.21420040D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50946: 50950) /153, 37,   0.99978710D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50951: 50955) /153, 38,   0.89949300D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50956: 50960) /153, 39,   0.79779010D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50961: 50965) /153, 40,   0.72272400D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50966: 50970) /153, 41,   0.66260680D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50971: 50975) /153, 42,   0.51659320D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50976: 50980) /153, 43,   0.57428050D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50981: 50985) /153, 44,   0.44217100D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50986: 50990) /153, 45,   0.48282170D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50991: 50995) /153, 46,   0.44920610D+03,   0.99680D+00,   0.00000D+00/
  data pars( 50996: 51000) /153, 47,   0.37444670D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51001: 51005) /153, 48,   0.39749790D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51006: 51010) /153, 49,   0.49366250D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51011: 51015) /153, 50,   0.46207160D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51016: 51020) /153, 51,   0.41687150D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51021: 51025) /153, 52,   0.38970290D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51026: 51030) /153, 53,   0.35521750D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51031: 51035) /153, 54,   0.32180290D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51036: 51040) /153, 55,   0.12196272D+04,   0.99680D+00,   0.00000D+00/
  data pars( 51041: 51045) /153, 56,   0.11429378D+04,   0.99680D+00,   0.00000D+00/
  data pars( 51046: 51050) /153, 57,   0.10164155D+04,   0.99680D+00,   0.00000D+00/
  data pars( 51051: 51055) /153, 58,   0.49161500D+03,   0.99680D+00,   0.27991D+01/
  data pars( 51056: 51060) /153, 59,   0.10169588D+04,   0.99680D+00,   0.00000D+00/
  data pars( 51061: 51065) /153, 60,   0.97834710D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51066: 51070) /153, 61,   0.95429670D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51071: 51075) /153, 62,   0.93211660D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51076: 51080) /153, 63,   0.91246710D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51081: 51085) /153, 64,   0.72800530D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51086: 51090) /153, 65,   0.80453430D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51091: 51095) /153, 66,   0.77785480D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51096: 51100) /153, 67,   0.82536440D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51101: 51105) /153, 68,   0.80806540D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51106: 51110) /153, 69,   0.79260610D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51111: 51115) /153, 70,   0.78284050D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51116: 51120) /153, 71,   0.66614790D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51121: 51125) /153, 72,   0.66319200D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51126: 51130) /153, 73,   0.61001430D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51131: 51135) /153, 74,   0.51873530D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51136: 51140) /153, 75,   0.52912210D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51141: 51145) /153, 76,   0.48278010D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51146: 51150) /153, 77,   0.44456400D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51151: 51155) /153, 78,   0.37168100D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51156: 51160) /153, 79,   0.34813080D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51161: 51165) /153, 80,   0.35883830D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51166: 51170) /153, 81,   0.50911500D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51171: 51175) /153, 82,   0.50219660D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51176: 51180) /153, 83,   0.46641830D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51181: 51185) /153, 84,   0.44766490D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51186: 51190) /153, 85,   0.41630430D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51191: 51195) /153, 86,   0.38423110D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51196: 51200) /153, 87,   0.11630702D+04,   0.99680D+00,   0.00000D+00/
  data pars( 51201: 51205) /153, 88,   0.11376470D+04,   0.99680D+00,   0.00000D+00/
  data pars( 51206: 51210) /153, 89,   0.10167803D+04,   0.99680D+00,   0.00000D+00/
  data pars( 51211: 51215) /153, 90,   0.92598120D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51216: 51220) /153, 91,   0.91390750D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51221: 51225) /153, 92,   0.88520210D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51226: 51230) /153, 93,   0.90396880D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51231: 51235) /153, 94,   0.87665190D+03,   0.99680D+00,   0.00000D+00/
  data pars( 51236: 51240) /153,101,   0.51949600D+02,   0.99680D+00,   0.00000D+00/
  data pars( 51241: 51245) /153,103,   0.16143030D+03,   0.99680D+00,   0.98650D+00/
  data pars( 51246: 51250) /153,104,   0.20721850D+03,   0.99680D+00,   0.98080D+00/
  data pars( 51251: 51255) /153,105,   0.16249390D+03,   0.99680D+00,   0.97060D+00/
  data pars( 51256: 51260) /153,106,   0.12439580D+03,   0.99680D+00,   0.98680D+00/
  data pars( 51261: 51265) /153,107,   0.87986900D+02,   0.99680D+00,   0.99440D+00/
  data pars( 51266: 51270) /153,108,   0.64976400D+02,   0.99680D+00,   0.99250D+00/
  data pars( 51271: 51275) /153,109,   0.45461800D+02,   0.99680D+00,   0.99820D+00/
  data pars( 51276: 51280) /153,111,   0.23487760D+03,   0.99680D+00,   0.96840D+00/
  data pars( 51281: 51285) /153,112,   0.36232580D+03,   0.99680D+00,   0.96280D+00/
  data pars( 51286: 51290) /153,113,   0.37186150D+03,   0.99680D+00,   0.96480D+00/
  data pars( 51291: 51295) /153,114,   0.30487150D+03,   0.99680D+00,   0.95070D+00/
  data pars( 51296: 51300) /153,115,   0.25346770D+03,   0.99680D+00,   0.99470D+00/
  data pars( 51301: 51305) /153,116,   0.21658660D+03,   0.99680D+00,   0.99480D+00/
  data pars( 51306: 51310) /153,117,   0.17895810D+03,   0.99680D+00,   0.99720D+00/
  data pars( 51311: 51315) /153,119,   0.32822070D+03,   0.99680D+00,   0.97670D+00/
  data pars( 51316: 51320) /153,120,   0.60618590D+03,   0.99680D+00,   0.98310D+00/
  data pars( 51321: 51325) /153,121,   0.33318010D+03,   0.99680D+00,   0.18627D+01/
  data pars( 51326: 51330) /153,122,   0.32194330D+03,   0.99680D+00,   0.18299D+01/
  data pars( 51331: 51335) /153,123,   0.31543490D+03,   0.99680D+00,   0.19138D+01/
  data pars( 51336: 51340) /153,124,   0.31193950D+03,   0.99680D+00,   0.18269D+01/
  data pars( 51341: 51345) /153,125,   0.28957840D+03,   0.99680D+00,   0.16406D+01/
  data pars( 51346: 51350) /153,126,   0.26879340D+03,   0.99680D+00,   0.16483D+01/
  data pars( 51351: 51355) /153,127,   0.25647210D+03,   0.99680D+00,   0.17149D+01/
  data pars( 51356: 51360) /153,128,   0.25055360D+03,   0.99680D+00,   0.17937D+01/
  data pars( 51361: 51365) /153,129,   0.24584350D+03,   0.99680D+00,   0.95760D+00/
  data pars( 51366: 51370) /153,130,   0.23356320D+03,   0.99680D+00,   0.19419D+01/
  data pars( 51371: 51375) /153,131,   0.37176550D+03,   0.99680D+00,   0.96010D+00/
  data pars( 51376: 51380) /153,132,   0.33159870D+03,   0.99680D+00,   0.94340D+00/
  data pars( 51381: 51385) /153,133,   0.30060430D+03,   0.99680D+00,   0.98890D+00/
  data pars( 51386: 51390) /153,134,   0.27668620D+03,   0.99680D+00,   0.99010D+00/
  data pars( 51391: 51395) /153,135,   0.24586470D+03,   0.99680D+00,   0.99740D+00/
  data pars( 51396: 51400) /153,137,   0.39318090D+03,   0.99680D+00,   0.97380D+00/
  data pars( 51401: 51405) /153,138,   0.73690210D+03,   0.99680D+00,   0.98010D+00/
  data pars( 51406: 51410) /153,139,   0.57738050D+03,   0.99680D+00,   0.19153D+01/
  data pars( 51411: 51415) /153,140,   0.44044740D+03,   0.99680D+00,   0.19355D+01/
  data pars( 51416: 51420) /153,141,   0.44464020D+03,   0.99680D+00,   0.19545D+01/
  data pars( 51421: 51425) /153,142,   0.41612070D+03,   0.99680D+00,   0.19420D+01/
  data pars( 51426: 51430) /153,143,   0.46132230D+03,   0.99680D+00,   0.16682D+01/
  data pars( 51431: 51435) /153,144,   0.36592820D+03,   0.99680D+00,   0.18584D+01/
  data pars( 51436: 51440) /153,145,   0.34272790D+03,   0.99680D+00,   0.19003D+01/
  data pars( 51441: 51445) /153,146,   0.31886290D+03,   0.99680D+00,   0.18630D+01/
  data pars( 51446: 51450) /153,147,   0.30804750D+03,   0.99680D+00,   0.96790D+00/
  data pars( 51451: 51455) /153,148,   0.30665490D+03,   0.99680D+00,   0.19539D+01/
  data pars( 51456: 51460) /153,149,   0.47264410D+03,   0.99680D+00,   0.96330D+00/
  data pars( 51461: 51465) /153,150,   0.43305890D+03,   0.99680D+00,   0.95140D+00/
  data pars( 51466: 51470) /153,151,   0.40924850D+03,   0.99680D+00,   0.97490D+00/
  data pars( 51471: 51475) /153,152,   0.38959960D+03,   0.99680D+00,   0.98110D+00/
  data pars( 51476: 51480) /153,153,   0.35849950D+03,   0.99680D+00,   0.99680D+00/
  data pars( 51481: 51485) /155,  1,   0.42305800D+02,   0.99090D+00,   0.91180D+00/
  data pars( 51486: 51490) /155,  2,   0.27469500D+02,   0.99090D+00,   0.00000D+00/
  data pars( 51491: 51495) /155,  3,   0.73291200D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51496: 51500) /155,  4,   0.39940200D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51501: 51505) /155,  5,   0.26223870D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51506: 51510) /155,  6,   0.17427180D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51511: 51515) /155,  7,   0.12049820D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51516: 51520) /155,  8,   0.90530300D+02,   0.99090D+00,   0.00000D+00/
  data pars( 51521: 51525) /155,  9,   0.68123900D+02,   0.99090D+00,   0.00000D+00/
  data pars( 51526: 51530) /155, 10,   0.52104100D+02,   0.99090D+00,   0.00000D+00/
  data pars( 51531: 51535) /155, 11,   0.87326650D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51536: 51540) /155, 12,   0.64218460D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51541: 51545) /155, 13,   0.58368500D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51546: 51550) /155, 14,   0.45161710D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51551: 51555) /155, 15,   0.34740300D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51556: 51560) /155, 16,   0.28604180D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51561: 51565) /155, 17,   0.23194830D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51566: 51570) /155, 18,   0.18859500D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51571: 51575) /155, 19,   0.14495860D+04,   0.99090D+00,   0.00000D+00/
  data pars( 51576: 51580) /155, 20,   0.11498295D+04,   0.99090D+00,   0.00000D+00/
  data pars( 51581: 51585) /155, 21,   0.94227450D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51586: 51590) /155, 22,   0.90422250D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51591: 51595) /155, 23,   0.82477800D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51596: 51600) /155, 24,   0.65006270D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51601: 51605) /155, 25,   0.70614120D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51606: 51610) /155, 26,   0.55409250D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51611: 51615) /155, 27,   0.58184580D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51616: 51620) /155, 28,   0.60158080D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51621: 51625) /155, 29,   0.46170190D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51626: 51630) /155, 30,   0.46787310D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51631: 51635) /155, 31,   0.55650160D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51636: 51640) /155, 32,   0.48371170D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51641: 51645) /155, 33,   0.40779580D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51646: 51650) /155, 34,   0.36352860D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51651: 51655) /155, 35,   0.31607000D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51656: 51660) /155, 36,   0.27329990D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51661: 51665) /155, 37,   0.16207604D+04,   0.99090D+00,   0.00000D+00/
  data pars( 51666: 51670) /155, 38,   0.13728515D+04,   0.99090D+00,   0.00000D+00/
  data pars( 51671: 51675) /155, 39,   0.11863885D+04,   0.99090D+00,   0.00000D+00/
  data pars( 51676: 51680) /155, 40,   0.10577660D+04,   0.99090D+00,   0.00000D+00/
  data pars( 51681: 51685) /155, 41,   0.95979080D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51686: 51690) /155, 42,   0.73514980D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51691: 51695) /155, 43,   0.82258290D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51696: 51700) /155, 44,   0.62119680D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51701: 51705) /155, 45,   0.67827670D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51706: 51710) /155, 46,   0.62700570D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51711: 51715) /155, 47,   0.52450750D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51716: 51720) /155, 48,   0.55025650D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51721: 51725) /155, 49,   0.69737450D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51726: 51730) /155, 50,   0.63676120D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51731: 51735) /155, 51,   0.56125330D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51736: 51740) /155, 52,   0.51758070D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51741: 51745) /155, 53,   0.46507030D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51746: 51750) /155, 54,   0.41576900D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51751: 51755) /155, 55,   0.19759738D+04,   0.99090D+00,   0.00000D+00/
  data pars( 51756: 51760) /155, 56,   0.17600602D+04,   0.99090D+00,   0.00000D+00/
  data pars( 51761: 51765) /155, 57,   0.15249399D+04,   0.99090D+00,   0.00000D+00/
  data pars( 51766: 51770) /155, 58,   0.66483460D+03,   0.99090D+00,   0.27991D+01/
  data pars( 51771: 51775) /155, 59,   0.15520845D+04,   0.99090D+00,   0.00000D+00/
  data pars( 51776: 51780) /155, 60,   0.14864897D+04,   0.99090D+00,   0.00000D+00/
  data pars( 51781: 51785) /155, 61,   0.14481464D+04,   0.99090D+00,   0.00000D+00/
  data pars( 51786: 51790) /155, 62,   0.14129908D+04,   0.99090D+00,   0.00000D+00/
  data pars( 51791: 51795) /155, 63,   0.13817863D+04,   0.99090D+00,   0.00000D+00/
  data pars( 51796: 51800) /155, 64,   0.10715717D+04,   0.99090D+00,   0.00000D+00/
  data pars( 51801: 51805) /155, 65,   0.12355701D+04,   0.99090D+00,   0.00000D+00/
  data pars( 51806: 51810) /155, 66,   0.11888012D+04,   0.99090D+00,   0.00000D+00/
  data pars( 51811: 51815) /155, 67,   0.12416267D+04,   0.99090D+00,   0.00000D+00/
  data pars( 51816: 51820) /155, 68,   0.12147181D+04,   0.99090D+00,   0.00000D+00/
  data pars( 51821: 51825) /155, 69,   0.11902611D+04,   0.99090D+00,   0.00000D+00/
  data pars( 51826: 51830) /155, 70,   0.11769746D+04,   0.99090D+00,   0.00000D+00/
  data pars( 51831: 51835) /155, 71,   0.98243040D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51836: 51840) /155, 72,   0.95327210D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51841: 51845) /155, 73,   0.86345810D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51846: 51850) /155, 74,   0.72569910D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51851: 51855) /155, 75,   0.73587000D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51856: 51860) /155, 76,   0.66279760D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51861: 51865) /155, 77,   0.60405240D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51866: 51870) /155, 78,   0.49959380D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51871: 51875) /155, 79,   0.46588050D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51876: 51880) /155, 80,   0.47788590D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51881: 51885) /155, 81,   0.71477590D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51886: 51890) /155, 82,   0.69152340D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51891: 51895) /155, 83,   0.62890510D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51896: 51900) /155, 84,   0.59653870D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51901: 51905) /155, 85,   0.54712200D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51906: 51910) /155, 86,   0.49878710D+03,   0.99090D+00,   0.00000D+00/
  data pars( 51911: 51915) /155, 87,   0.18443405D+04,   0.99090D+00,   0.00000D+00/
  data pars( 51916: 51920) /155, 88,   0.17284117D+04,   0.99090D+00,   0.00000D+00/
  data pars( 51921: 51925) /155, 89,   0.15078114D+04,   0.99090D+00,   0.00000D+00/
  data pars( 51926: 51930) /155, 90,   0.13366572D+04,   0.99090D+00,   0.00000D+00/
  data pars( 51931: 51935) /155, 91,   0.13367673D+04,   0.99090D+00,   0.00000D+00/
  data pars( 51936: 51940) /155, 92,   0.12938174D+04,   0.99090D+00,   0.00000D+00/
  data pars( 51941: 51945) /155, 93,   0.13431115D+04,   0.99090D+00,   0.00000D+00/
  data pars( 51946: 51950) /155, 94,   0.12984675D+04,   0.99090D+00,   0.00000D+00/
  data pars( 51951: 51955) /155,101,   0.68953700D+02,   0.99090D+00,   0.00000D+00/
  data pars( 51956: 51960) /155,103,   0.23141650D+03,   0.99090D+00,   0.98650D+00/
  data pars( 51961: 51965) /155,104,   0.29414590D+03,   0.99090D+00,   0.98080D+00/
  data pars( 51966: 51970) /155,105,   0.21963870D+03,   0.99090D+00,   0.97060D+00/
  data pars( 51971: 51975) /155,106,   0.16367150D+03,   0.99090D+00,   0.98680D+00/
  data pars( 51976: 51980) /155,107,   0.11242780D+03,   0.99090D+00,   0.99440D+00/
  data pars( 51981: 51985) /155,108,   0.81084500D+02,   0.99090D+00,   0.99250D+00/
  data pars( 51986: 51990) /155,109,   0.55078600D+02,   0.99090D+00,   0.99820D+00/
  data pars( 51991: 51995) /155,111,   0.34006240D+03,   0.99090D+00,   0.96840D+00/
  data pars( 51996: 52000) /155,112,   0.52756300D+03,   0.99090D+00,   0.96280D+00/
  data pars( 52001: 52005) /155,113,   0.52732820D+03,   0.99090D+00,   0.96480D+00/
  data pars( 52006: 52010) /155,114,   0.41648610D+03,   0.99090D+00,   0.95070D+00/
  data pars( 52011: 52015) /155,115,   0.33711350D+03,   0.99090D+00,   0.99470D+00/
  data pars( 52016: 52020) /155,116,   0.28296690D+03,   0.99090D+00,   0.99480D+00/
  data pars( 52021: 52025) /155,117,   0.22958370D+03,   0.99090D+00,   0.99720D+00/
  data pars( 52026: 52030) /155,119,   0.46551820D+03,   0.99090D+00,   0.97670D+00/
  data pars( 52031: 52035) /155,120,   0.92179340D+03,   0.99090D+00,   0.98310D+00/
  data pars( 52036: 52040) /155,121,   0.45790120D+03,   0.99090D+00,   0.18627D+01/
  data pars( 52041: 52045) /155,122,   0.44205470D+03,   0.99090D+00,   0.18299D+01/
  data pars( 52046: 52050) /155,123,   0.43331390D+03,   0.99090D+00,   0.19138D+01/
  data pars( 52051: 52055) /155,124,   0.43010400D+03,   0.99090D+00,   0.18269D+01/
  data pars( 52056: 52060) /155,125,   0.39208310D+03,   0.99090D+00,   0.16406D+01/
  data pars( 52061: 52065) /155,126,   0.36204550D+03,   0.99090D+00,   0.16483D+01/
  data pars( 52066: 52070) /155,127,   0.34544700D+03,   0.99090D+00,   0.17149D+01/
  data pars( 52071: 52075) /155,128,   0.33794540D+03,   0.99090D+00,   0.17937D+01/
  data pars( 52076: 52080) /155,129,   0.33608210D+03,   0.99090D+00,   0.95760D+00/
  data pars( 52081: 52085) /155,130,   0.31158000D+03,   0.99090D+00,   0.19419D+01/
  data pars( 52086: 52090) /155,131,   0.52074900D+03,   0.99090D+00,   0.96010D+00/
  data pars( 52091: 52095) /155,132,   0.45117170D+03,   0.99090D+00,   0.94340D+00/
  data pars( 52096: 52100) /155,133,   0.40064390D+03,   0.99090D+00,   0.98890D+00/
  data pars( 52101: 52105) /155,134,   0.36372020D+03,   0.99090D+00,   0.99010D+00/
  data pars( 52106: 52110) /155,135,   0.31838270D+03,   0.99090D+00,   0.99740D+00/
  data pars( 52111: 52115) /155,137,   0.55397800D+03,   0.99090D+00,   0.97380D+00/
  data pars( 52116: 52120) /155,138,   0.11249345D+04,   0.99090D+00,   0.98010D+00/
  data pars( 52121: 52125) /155,139,   0.83761350D+03,   0.99090D+00,   0.19153D+01/
  data pars( 52126: 52130) /155,140,   0.60719510D+03,   0.99090D+00,   0.19355D+01/
  data pars( 52131: 52135) /155,141,   0.61320100D+03,   0.99090D+00,   0.19545D+01/
  data pars( 52136: 52140) /155,142,   0.57026210D+03,   0.99090D+00,   0.19420D+01/
  data pars( 52141: 52145) /155,143,   0.64766860D+03,   0.99090D+00,   0.16682D+01/
  data pars( 52146: 52150) /155,144,   0.49283010D+03,   0.99090D+00,   0.18584D+01/
  data pars( 52151: 52155) /155,145,   0.46081940D+03,   0.99090D+00,   0.19003D+01/
  data pars( 52156: 52160) /155,146,   0.42732470D+03,   0.99090D+00,   0.18630D+01/
  data pars( 52161: 52165) /155,147,   0.41377960D+03,   0.99090D+00,   0.96790D+00/
  data pars( 52166: 52170) /155,148,   0.40654590D+03,   0.99090D+00,   0.19539D+01/
  data pars( 52171: 52175) /155,149,   0.66184230D+03,   0.99090D+00,   0.96330D+00/
  data pars( 52176: 52180) /155,150,   0.59127640D+03,   0.99090D+00,   0.95140D+00/
  data pars( 52181: 52185) /155,151,   0.54930440D+03,   0.99090D+00,   0.97490D+00/
  data pars( 52186: 52190) /155,152,   0.51701090D+03,   0.99090D+00,   0.98110D+00/
  data pars( 52191: 52195) /155,153,   0.46948180D+03,   0.99090D+00,   0.99680D+00/
  data pars( 52196: 52200) /155,155,   0.64909240D+03,   0.99090D+00,   0.99090D+00/
  data pars( 52201: 52205) /156,  1,   0.83014100D+02,   0.97970D+00,   0.91180D+00/
  data pars( 52206: 52210) /156,  2,   0.49923200D+02,   0.97970D+00,   0.00000D+00/
  data pars( 52211: 52215) /156,  3,   0.21804015D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52216: 52220) /156,  4,   0.96110490D+03,   0.97970D+00,   0.00000D+00/
  data pars( 52221: 52225) /156,  5,   0.57230020D+03,   0.97970D+00,   0.00000D+00/
  data pars( 52226: 52230) /156,  6,   0.35484660D+03,   0.97970D+00,   0.00000D+00/
  data pars( 52231: 52235) /156,  7,   0.23350060D+03,   0.97970D+00,   0.00000D+00/
  data pars( 52236: 52240) /156,  8,   0.16960300D+03,   0.97970D+00,   0.00000D+00/
  data pars( 52241: 52245) /156,  9,   0.12408020D+03,   0.97970D+00,   0.00000D+00/
  data pars( 52246: 52250) /156, 10,   0.92849400D+02,   0.97970D+00,   0.00000D+00/
  data pars( 52251: 52255) /156, 11,   0.25659398D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52256: 52260) /156, 12,   0.15996001D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52261: 52265) /156, 13,   0.13814389D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52266: 52270) /156, 14,   0.99489260D+03,   0.97970D+00,   0.00000D+00/
  data pars( 52271: 52275) /156, 15,   0.72325040D+03,   0.97970D+00,   0.00000D+00/
  data pars( 52276: 52280) /156, 16,   0.57533170D+03,   0.97970D+00,   0.00000D+00/
  data pars( 52281: 52285) /156, 17,   0.45158250D+03,   0.97970D+00,   0.00000D+00/
  data pars( 52286: 52290) /156, 18,   0.35719350D+03,   0.97970D+00,   0.00000D+00/
  data pars( 52291: 52295) /156, 19,   0.44958369D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52296: 52300) /156, 20,   0.30704624D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52301: 52305) /156, 21,   0.24434277D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52306: 52310) /156, 22,   0.22946062D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52311: 52315) /156, 23,   0.20640309D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52316: 52320) /156, 24,   0.16327022D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52321: 52325) /156, 25,   0.17320375D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52326: 52330) /156, 26,   0.13596156D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52331: 52335) /156, 27,   0.13759674D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52336: 52340) /156, 28,   0.14425133D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52341: 52345) /156, 29,   0.11138541D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52346: 52350) /156, 30,   0.10720643D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52351: 52355) /156, 31,   0.12954563D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52356: 52360) /156, 32,   0.10627315D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52361: 52365) /156, 33,   0.85391570D+03,   0.97970D+00,   0.00000D+00/
  data pars( 52366: 52370) /156, 34,   0.74014960D+03,   0.97970D+00,   0.00000D+00/
  data pars( 52371: 52375) /156, 35,   0.62555040D+03,   0.97970D+00,   0.00000D+00/
  data pars( 52376: 52380) /156, 36,   0.52735210D+03,   0.97970D+00,   0.00000D+00/
  data pars( 52381: 52385) /156, 37,   0.49979230D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52386: 52390) /156, 38,   0.36976569D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52391: 52395) /156, 39,   0.30451620D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52396: 52400) /156, 40,   0.26376782D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52401: 52405) /156, 41,   0.23521278D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52406: 52410) /156, 42,   0.17503829D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52411: 52415) /156, 43,   0.19809508D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52416: 52420) /156, 44,   0.14476221D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52421: 52425) /156, 45,   0.15723023D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52426: 52430) /156, 46,   0.14360400D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52431: 52435) /156, 47,   0.12194904D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52436: 52440) /156, 48,   0.12412980D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52441: 52445) /156, 49,   0.16356158D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52446: 52450) /156, 50,   0.14200022D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52451: 52455) /156, 51,   0.11973790D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52456: 52460) /156, 52,   0.10767503D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52461: 52465) /156, 53,   0.94225240D+03,   0.97970D+00,   0.00000D+00/
  data pars( 52466: 52470) /156, 54,   0.82205680D+03,   0.97970D+00,   0.00000D+00/
  data pars( 52471: 52475) /156, 55,   0.61419784D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52476: 52480) /156, 56,   0.48451776D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52481: 52485) /156, 57,   0.39942273D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52486: 52490) /156, 58,   0.14330469D+04,   0.97970D+00,   0.27991D+01/
  data pars( 52491: 52495) /156, 59,   0.42139225D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52496: 52500) /156, 60,   0.39873600D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52501: 52505) /156, 61,   0.38737284D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52506: 52510) /156, 62,   0.37706523D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52511: 52515) /156, 63,   0.36789146D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52516: 52520) /156, 64,   0.27207653D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52521: 52525) /156, 65,   0.34419852D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52526: 52530) /156, 66,   0.32989422D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52531: 52535) /156, 67,   0.32598698D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52536: 52540) /156, 68,   0.31836011D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52541: 52545) /156, 69,   0.31125536D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52546: 52550) /156, 70,   0.30835002D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52551: 52555) /156, 71,   0.25019262D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52556: 52560) /156, 72,   0.22987008D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52561: 52565) /156, 73,   0.20237991D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52566: 52570) /156, 74,   0.16732640D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52571: 52575) /156, 75,   0.16751136D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52576: 52580) /156, 76,   0.14722933D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52581: 52585) /156, 77,   0.13162117D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52586: 52590) /156, 78,   0.10706911D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52591: 52595) /156, 79,   0.99139190D+03,   0.97970D+00,   0.00000D+00/
  data pars( 52596: 52600) /156, 80,   0.10048014D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52601: 52605) /156, 81,   0.16688986D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52606: 52610) /156, 82,   0.15461030D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52611: 52615) /156, 83,   0.13487488D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52616: 52620) /156, 84,   0.12508513D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52621: 52625) /156, 85,   0.11176702D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52626: 52630) /156, 86,   0.99586790D+03,   0.97970D+00,   0.00000D+00/
  data pars( 52631: 52635) /156, 87,   0.54979393D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52636: 52640) /156, 88,   0.46433162D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52641: 52645) /156, 89,   0.38656041D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52646: 52650) /156, 90,   0.32597257D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52651: 52655) /156, 91,   0.33538826D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52656: 52660) /156, 92,   0.32402913D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52661: 52665) /156, 93,   0.34630576D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52666: 52670) /156, 94,   0.33272478D+04,   0.97970D+00,   0.00000D+00/
  data pars( 52671: 52675) /156,101,   0.14256800D+03,   0.97970D+00,   0.00000D+00/
  data pars( 52676: 52680) /156,103,   0.55107920D+03,   0.97970D+00,   0.98650D+00/
  data pars( 52681: 52685) /156,104,   0.69284150D+03,   0.97970D+00,   0.98080D+00/
  data pars( 52686: 52690) /156,105,   0.47105030D+03,   0.97970D+00,   0.97060D+00/
  data pars( 52691: 52695) /156,106,   0.33492070D+03,   0.97970D+00,   0.98680D+00/
  data pars( 52696: 52700) /156,107,   0.21815960D+03,   0.97970D+00,   0.99440D+00/
  data pars( 52701: 52705) /156,108,   0.15070560D+03,   0.97970D+00,   0.99250D+00/
  data pars( 52706: 52710) /156,109,   0.97192600D+02,   0.97970D+00,   0.99820D+00/
  data pars( 52711: 52715) /156,111,   0.82695650D+03,   0.97970D+00,   0.96840D+00/
  data pars( 52716: 52720) /156,112,   0.12989425D+04,   0.97970D+00,   0.96280D+00/
  data pars( 52721: 52725) /156,113,   0.12335817D+04,   0.97970D+00,   0.96480D+00/
  data pars( 52726: 52730) /156,114,   0.90965670D+03,   0.97970D+00,   0.95070D+00/
  data pars( 52731: 52735) /156,115,   0.70099830D+03,   0.97970D+00,   0.99470D+00/
  data pars( 52736: 52740) /156,116,   0.56985090D+03,   0.97970D+00,   0.99480D+00/
  data pars( 52741: 52745) /156,117,   0.44736800D+03,   0.97970D+00,   0.99720D+00/
  data pars( 52746: 52750) /156,119,   0.11041068D+04,   0.97970D+00,   0.97670D+00/
  data pars( 52751: 52755) /156,120,   0.25056537D+04,   0.97970D+00,   0.98310D+00/
  data pars( 52756: 52760) /156,121,   0.10130298D+04,   0.97970D+00,   0.18627D+01/
  data pars( 52761: 52765) /156,122,   0.98236380D+03,   0.97970D+00,   0.18299D+01/
  data pars( 52766: 52770) /156,123,   0.96327250D+03,   0.97970D+00,   0.19138D+01/
  data pars( 52771: 52775) /156,124,   0.96365340D+03,   0.97970D+00,   0.18269D+01/
  data pars( 52776: 52780) /156,125,   0.84521190D+03,   0.97970D+00,   0.16406D+01/
  data pars( 52781: 52785) /156,126,   0.77366980D+03,   0.97970D+00,   0.16483D+01/
  data pars( 52786: 52790) /156,127,   0.73950900D+03,   0.97970D+00,   0.17149D+01/
  data pars( 52791: 52795) /156,128,   0.72552030D+03,   0.97970D+00,   0.17937D+01/
  data pars( 52796: 52800) /156,129,   0.74098720D+03,   0.97970D+00,   0.95760D+00/
  data pars( 52801: 52805) /156,130,   0.65373360D+03,   0.97970D+00,   0.19419D+01/
  data pars( 52806: 52810) /156,131,   0.11948773D+04,   0.97970D+00,   0.96010D+00/
  data pars( 52811: 52815) /156,132,   0.97957420D+03,   0.97970D+00,   0.94340D+00/
  data pars( 52816: 52820) /156,133,   0.83693640D+03,   0.97970D+00,   0.98890D+00/
  data pars( 52821: 52825) /156,134,   0.74102200D+03,   0.97970D+00,   0.99010D+00/
  data pars( 52826: 52830) /156,135,   0.63113970D+03,   0.97970D+00,   0.99740D+00/
  data pars( 52831: 52835) /156,137,   0.13013999D+04,   0.97970D+00,   0.97380D+00/
  data pars( 52836: 52840) /156,138,   0.30957594D+04,   0.97970D+00,   0.98010D+00/
  data pars( 52841: 52845) /156,139,   0.21010372D+04,   0.97970D+00,   0.19153D+01/
  data pars( 52846: 52850) /156,140,   0.13604000D+04,   0.97970D+00,   0.19355D+01/
  data pars( 52851: 52855) /156,141,   0.13693825D+04,   0.97970D+00,   0.19545D+01/
  data pars( 52856: 52860) /156,142,   0.12660803D+04,   0.97970D+00,   0.19420D+01/
  data pars( 52861: 52865) /156,143,   0.15162134D+04,   0.97970D+00,   0.16682D+01/
  data pars( 52866: 52870) /156,144,   0.10564422D+04,   0.97970D+00,   0.18584D+01/
  data pars( 52871: 52875) /156,145,   0.98676430D+03,   0.97970D+00,   0.19003D+01/
  data pars( 52876: 52880) /156,146,   0.91052680D+03,   0.97970D+00,   0.18630D+01/
  data pars( 52881: 52885) /156,147,   0.88540390D+03,   0.97970D+00,   0.96790D+00/
  data pars( 52886: 52890) /156,148,   0.84515800D+03,   0.97970D+00,   0.19539D+01/
  data pars( 52891: 52895) /156,149,   0.15259278D+04,   0.97970D+00,   0.96330D+00/
  data pars( 52896: 52900) /156,150,   0.12966408D+04,   0.97970D+00,   0.95140D+00/
  data pars( 52901: 52905) /156,151,   0.11653603D+04,   0.97970D+00,   0.97490D+00/
  data pars( 52906: 52910) /156,152,   0.10738698D+04,   0.97970D+00,   0.98110D+00/
  data pars( 52911: 52915) /156,153,   0.95154100D+03,   0.97970D+00,   0.99680D+00/
  data pars( 52916: 52920) /156,155,   0.14690705D+04,   0.97970D+00,   0.99090D+00/
  data pars( 52921: 52925) /156,156,   0.41717842D+04,   0.97970D+00,   0.97970D+00/
  data pars( 52926: 52930) /157,  1,   0.64690600D+02,   0.19373D+01,   0.91180D+00/
  data pars( 52931: 52935) /157,  2,   0.40332900D+02,   0.19373D+01,   0.00000D+00/
  data pars( 52936: 52940) /157,  3,   0.13841283D+04,   0.19373D+01,   0.00000D+00/
  data pars( 52941: 52945) /157,  4,   0.67673740D+03,   0.19373D+01,   0.00000D+00/
  data pars( 52946: 52950) /157,  5,   0.42308150D+03,   0.19373D+01,   0.00000D+00/
  data pars( 52951: 52955) /157,  6,   0.27142480D+03,   0.19373D+01,   0.00000D+00/
  data pars( 52956: 52960) /157,  7,   0.18293910D+03,   0.19373D+01,   0.00000D+00/
  data pars( 52961: 52965) /157,  8,   0.13503220D+03,   0.19373D+01,   0.00000D+00/
  data pars( 52966: 52970) /157,  9,   0.10010900D+03,   0.19373D+01,   0.00000D+00/
  data pars( 52971: 52975) /157, 10,   0.75679100D+02,   0.19373D+01,   0.00000D+00/
  data pars( 52976: 52980) /157, 11,   0.16377878D+04,   0.19373D+01,   0.00000D+00/
  data pars( 52981: 52985) /157, 12,   0.11067221D+04,   0.19373D+01,   0.00000D+00/
  data pars( 52986: 52990) /157, 13,   0.98043760D+03,   0.19373D+01,   0.00000D+00/
  data pars( 52991: 52995) /157, 14,   0.73212110D+03,   0.19373D+01,   0.00000D+00/
  data pars( 52996: 53000) /157, 15,   0.54746530D+03,   0.19373D+01,   0.00000D+00/
  data pars( 53001: 53005) /157, 16,   0.44287990D+03,   0.19373D+01,   0.00000D+00/
  data pars( 53006: 53010) /157, 17,   0.35314670D+03,   0.19373D+01,   0.00000D+00/
  data pars( 53011: 53015) /157, 18,   0.28303510D+03,   0.19373D+01,   0.00000D+00/
  data pars( 53016: 53020) /157, 19,   0.28009569D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53021: 53025) /157, 20,   0.20504253D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53026: 53030) /157, 21,   0.16557011D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53031: 53035) /157, 22,   0.15712363D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53036: 53040) /157, 23,   0.14231173D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53041: 53045) /157, 24,   0.11226576D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53046: 53050) /157, 25,   0.12061393D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53051: 53055) /157, 26,   0.94568080D+03,   0.19373D+01,   0.00000D+00/
  data pars( 53056: 53060) /157, 27,   0.97598360D+03,   0.19373D+01,   0.00000D+00/
  data pars( 53061: 53065) /157, 28,   0.10161745D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53066: 53070) /157, 29,   0.78128810D+03,   0.19373D+01,   0.00000D+00/
  data pars( 53071: 53075) /157, 30,   0.77266500D+03,   0.19373D+01,   0.00000D+00/
  data pars( 53076: 53080) /157, 31,   0.92637230D+03,   0.19373D+01,   0.00000D+00/
  data pars( 53081: 53085) /157, 32,   0.78274010D+03,   0.19373D+01,   0.00000D+00/
  data pars( 53086: 53090) /157, 33,   0.64435600D+03,   0.19373D+01,   0.00000D+00/
  data pars( 53091: 53095) /157, 34,   0.56629200D+03,   0.19373D+01,   0.00000D+00/
  data pars( 53096: 53100) /157, 35,   0.48529550D+03,   0.19373D+01,   0.00000D+00/
  data pars( 53101: 53105) /157, 36,   0.41416640D+03,   0.19373D+01,   0.00000D+00/
  data pars( 53106: 53110) /157, 37,   0.31215559D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53111: 53115) /157, 38,   0.24580845D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53116: 53120) /157, 39,   0.20727978D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53121: 53125) /157, 40,   0.18212145D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53126: 53130) /157, 41,   0.16379243D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53131: 53135) /157, 42,   0.12356226D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53136: 53140) /157, 43,   0.13909989D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53141: 53145) /157, 44,   0.10325864D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53146: 53150) /157, 45,   0.11254492D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53151: 53155) /157, 46,   0.10341628D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53156: 53160) /157, 47,   0.87041020D+03,   0.19373D+01,   0.00000D+00/
  data pars( 53161: 53165) /157, 48,   0.90076730D+03,   0.19373D+01,   0.00000D+00/
  data pars( 53166: 53170) /157, 49,   0.11640480D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53171: 53175) /157, 50,   0.10373050D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53176: 53180) /157, 51,   0.89470260D+03,   0.19373D+01,   0.00000D+00/
  data pars( 53181: 53185) /157, 52,   0.81481140D+03,   0.19373D+01,   0.00000D+00/
  data pars( 53186: 53190) /157, 53,   0.72249320D+03,   0.19373D+01,   0.00000D+00/
  data pars( 53191: 53195) /157, 54,   0.63795900D+03,   0.19373D+01,   0.00000D+00/
  data pars( 53196: 53200) /157, 55,   0.38250881D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53201: 53205) /157, 56,   0.31862921D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53206: 53210) /157, 57,   0.26909591D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53211: 53215) /157, 58,   0.10645933D+04,   0.19373D+01,   0.27991D+01/
  data pars( 53216: 53220) /157, 59,   0.27909891D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53221: 53225) /157, 60,   0.26551171D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53226: 53230) /157, 61,   0.25829722D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53231: 53235) /157, 62,   0.25172239D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53236: 53240) /157, 63,   0.24587886D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53241: 53245) /157, 64,   0.18607370D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53246: 53250) /157, 65,   0.22509654D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53251: 53255) /157, 66,   0.21634599D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53256: 53260) /157, 67,   0.21938636D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53261: 53265) /157, 68,   0.21444704D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53266: 53270) /157, 69,   0.20989702D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53271: 53275) /157, 70,   0.20775774D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53276: 53280) /157, 71,   0.17103545D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53281: 53285) /157, 72,   0.16140907D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53286: 53290) /157, 73,   0.14413394D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53291: 53295) /157, 74,   0.12005662D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53296: 53300) /157, 75,   0.12100818D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53301: 53305) /157, 76,   0.10767583D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53306: 53310) /157, 77,   0.97197370D+03,   0.19373D+01,   0.00000D+00/
  data pars( 53311: 53315) /157, 78,   0.79670010D+03,   0.19373D+01,   0.00000D+00/
  data pars( 53316: 53320) /157, 79,   0.74016750D+03,   0.19373D+01,   0.00000D+00/
  data pars( 53321: 53325) /157, 80,   0.75524870D+03,   0.19373D+01,   0.00000D+00/
  data pars( 53326: 53330) /157, 81,   0.11891662D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53331: 53335) /157, 82,   0.11270513D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53336: 53340) /157, 83,   0.10045839D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53341: 53345) /157, 84,   0.94243520D+03,   0.19373D+01,   0.00000D+00/
  data pars( 53346: 53350) /157, 85,   0.85327010D+03,   0.19373D+01,   0.00000D+00/
  data pars( 53351: 53355) /157, 86,   0.76899820D+03,   0.19373D+01,   0.00000D+00/
  data pars( 53356: 53360) /157, 87,   0.34855386D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53361: 53365) /157, 88,   0.30892071D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53366: 53370) /157, 89,   0.26322561D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53371: 53375) /157, 90,   0.22749680D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53376: 53380) /157, 91,   0.23071665D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53381: 53385) /157, 92,   0.22309267D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53386: 53390) /157, 93,   0.23502253D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53391: 53395) /157, 94,   0.22650122D+04,   0.19373D+01,   0.00000D+00/
  data pars( 53396: 53400) /157,101,   0.10830590D+03,   0.19373D+01,   0.00000D+00/
  data pars( 53401: 53405) /157,103,   0.38990700D+03,   0.19373D+01,   0.98650D+00/
  data pars( 53406: 53410) /157,104,   0.49258240D+03,   0.19373D+01,   0.98080D+00/
  data pars( 53411: 53415) /157,105,   0.35111660D+03,   0.19373D+01,   0.97060D+00/
  data pars( 53416: 53420) /157,106,   0.25535340D+03,   0.19373D+01,   0.98680D+00/
  data pars( 53421: 53425) /157,107,   0.17069380D+03,   0.19373D+01,   0.99440D+00/
  data pars( 53426: 53430) /157,108,   0.12040040D+03,   0.19373D+01,   0.99250D+00/
  data pars( 53431: 53435) /157,109,   0.79615100D+02,   0.19373D+01,   0.99820D+00/
  data pars( 53436: 53440) /157,111,   0.57870070D+03,   0.19373D+01,   0.96840D+00/
  data pars( 53441: 53445) /157,112,   0.90345630D+03,   0.19373D+01,   0.96280D+00/
  data pars( 53446: 53450) /157,113,   0.88049000D+03,   0.19373D+01,   0.96480D+00/
  data pars( 53451: 53455) /157,114,   0.67215910D+03,   0.19373D+01,   0.95070D+00/
  data pars( 53456: 53460) /157,115,   0.53085730D+03,   0.19373D+01,   0.99470D+00/
  data pars( 53461: 53465) /157,116,   0.43834960D+03,   0.19373D+01,   0.99480D+00/
  data pars( 53466: 53470) /157,117,   0.34967640D+03,   0.19373D+01,   0.99720D+00/
  data pars( 53471: 53475) /157,119,   0.78068060D+03,   0.19373D+01,   0.97670D+00/
  data pars( 53476: 53480) /157,120,   0.16583459D+04,   0.19373D+01,   0.98310D+00/
  data pars( 53481: 53485) /157,121,   0.74263980D+03,   0.19373D+01,   0.18627D+01/
  data pars( 53486: 53490) /157,122,   0.71867820D+03,   0.19373D+01,   0.18299D+01/
  data pars( 53491: 53495) /157,123,   0.70447310D+03,   0.19373D+01,   0.19138D+01/
  data pars( 53496: 53500) /157,124,   0.70187680D+03,   0.19373D+01,   0.18269D+01/
  data pars( 53501: 53505) /157,125,   0.62823400D+03,   0.19373D+01,   0.16406D+01/
  data pars( 53506: 53510) /157,126,   0.57752630D+03,   0.19373D+01,   0.16483D+01/
  data pars( 53511: 53515) /157,127,   0.55142260D+03,   0.19373D+01,   0.17149D+01/
  data pars( 53516: 53520) /157,128,   0.54016790D+03,   0.19373D+01,   0.17937D+01/
  data pars( 53521: 53525) /157,129,   0.54406610D+03,   0.19373D+01,   0.95760D+00/
  data pars( 53526: 53530) /157,130,   0.49263420D+03,   0.19373D+01,   0.19419D+01/
  data pars( 53531: 53535) /157,131,   0.86066320D+03,   0.19373D+01,   0.96010D+00/
  data pars( 53536: 53540) /157,132,   0.72574740D+03,   0.19373D+01,   0.94340D+00/
  data pars( 53541: 53545) /157,133,   0.63226020D+03,   0.19373D+01,   0.98890D+00/
  data pars( 53546: 53550) /157,134,   0.56675130D+03,   0.19373D+01,   0.99010D+00/
  data pars( 53551: 53555) /157,135,   0.48922910D+03,   0.19373D+01,   0.99740D+00/
  data pars( 53556: 53560) /157,137,   0.92422030D+03,   0.19373D+01,   0.97380D+00/
  data pars( 53561: 53565) /157,138,   0.20365362D+04,   0.19373D+01,   0.98010D+00/
  data pars( 53566: 53570) /157,139,   0.14462394D+04,   0.19373D+01,   0.19153D+01/
  data pars( 53571: 53575) /157,140,   0.99010590D+03,   0.19373D+01,   0.19355D+01/
  data pars( 53576: 53580) /157,141,   0.99792220D+03,   0.19373D+01,   0.19545D+01/
  data pars( 53581: 53585) /157,142,   0.92583590D+03,   0.19373D+01,   0.19420D+01/
  data pars( 53586: 53590) /157,143,   0.10787908D+04,   0.19373D+01,   0.16682D+01/
  data pars( 53591: 53595) /157,144,   0.78658860D+03,   0.19373D+01,   0.18584D+01/
  data pars( 53596: 53600) /157,145,   0.73489180D+03,   0.19373D+01,   0.19003D+01/
  data pars( 53601: 53605) /157,146,   0.67965720D+03,   0.19373D+01,   0.18630D+01/
  data pars( 53606: 53610) /157,147,   0.65947100D+03,   0.19373D+01,   0.96790D+00/
  data pars( 53611: 53615) /157,148,   0.63938320D+03,   0.19373D+01,   0.19539D+01/
  data pars( 53616: 53620) /157,149,   0.10954590D+04,   0.19373D+01,   0.96330D+00/
  data pars( 53621: 53625) /157,150,   0.95522580D+03,   0.19373D+01,   0.95140D+00/
  data pars( 53626: 53630) /157,151,   0.87322870D+03,   0.19373D+01,   0.97490D+00/
  data pars( 53631: 53635) /157,152,   0.81328280D+03,   0.19373D+01,   0.98110D+00/
  data pars( 53636: 53640) /157,153,   0.72949490D+03,   0.19373D+01,   0.99680D+00/
  data pars( 53641: 53645) /157,155,   0.10633274D+04,   0.19373D+01,   0.99090D+00/
  data pars( 53646: 53650) /157,156,   0.27055816D+04,   0.19373D+01,   0.97970D+00/
  data pars( 53651: 53655) /157,157,   0.18500003D+04,   0.19373D+01,   0.19373D+01/
  data pars( 53656: 53660) /159,  1,   0.43220200D+02,   0.29425D+01,   0.91180D+00/
  data pars( 53661: 53665) /159,  2,   0.28506000D+02,   0.29425D+01,   0.00000D+00/
  data pars( 53666: 53670) /159,  3,   0.68024790D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53671: 53675) /159,  4,   0.39079830D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53676: 53680) /159,  5,   0.26231920D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53681: 53685) /159,  6,   0.17683390D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53686: 53690) /159,  7,   0.12349550D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53691: 53695) /159,  8,   0.93432700D+02,   0.29425D+01,   0.00000D+00/
  data pars( 53696: 53700) /159,  9,   0.70748100D+02,   0.29425D+01,   0.00000D+00/
  data pars( 53701: 53705) /159, 10,   0.54406100D+02,   0.29425D+01,   0.00000D+00/
  data pars( 53706: 53710) /159, 11,   0.81323530D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53711: 53715) /159, 12,   0.62332230D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53716: 53720) /159, 13,   0.57359020D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53721: 53725) /159, 14,   0.45092530D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53726: 53730) /159, 15,   0.35095780D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53731: 53735) /159, 16,   0.29093690D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53736: 53740) /159, 17,   0.23740720D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53741: 53745) /159, 18,   0.19406980D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53746: 53750) /159, 19,   0.13337958D+04,   0.29425D+01,   0.00000D+00/
  data pars( 53751: 53755) /159, 20,   0.10971659D+04,   0.29425D+01,   0.00000D+00/
  data pars( 53756: 53760) /159, 21,   0.90572410D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53761: 53765) /159, 22,   0.87400660D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53766: 53770) /159, 23,   0.80001520D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53771: 53775) /159, 24,   0.63019610D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53776: 53780) /159, 25,   0.68836930D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53781: 53785) /159, 26,   0.54023110D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53786: 53790) /159, 27,   0.57207380D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53791: 53795) /159, 28,   0.58956950D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53796: 53800) /159, 29,   0.45203420D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53801: 53805) /159, 30,   0.46341480D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53806: 53810) /159, 31,   0.54906920D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53811: 53815) /159, 32,   0.48331740D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53816: 53820) /159, 33,   0.41155330D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53821: 53825) /159, 34,   0.36892060D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53826: 53830) /159, 35,   0.32252720D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53831: 53835) /159, 36,   0.28024380D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53836: 53840) /159, 37,   0.14944074D+04,   0.29425D+01,   0.00000D+00/
  data pars( 53841: 53845) /159, 38,   0.13073665D+04,   0.29425D+01,   0.00000D+00/
  data pars( 53846: 53850) /159, 39,   0.11435524D+04,   0.29425D+01,   0.00000D+00/
  data pars( 53851: 53855) /159, 40,   0.10268226D+04,   0.29425D+01,   0.00000D+00/
  data pars( 53856: 53860) /159, 41,   0.93574670D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53861: 53865) /159, 42,   0.72166730D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53866: 53870) /159, 43,   0.80551110D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53871: 53875) /159, 44,   0.61296820D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53876: 53880) /159, 45,   0.66999170D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53881: 53885) /159, 46,   0.62106870D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53886: 53890) /159, 47,   0.51802070D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53891: 53895) /159, 48,   0.54699380D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53896: 53900) /159, 49,   0.68726670D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53901: 53905) /159, 50,   0.63451560D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53906: 53910) /159, 51,   0.56457530D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53911: 53915) /159, 52,   0.52332050D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53916: 53920) /159, 53,   0.47270040D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53921: 53925) /159, 54,   0.42459150D+03,   0.29425D+01,   0.00000D+00/
  data pars( 53926: 53930) /159, 55,   0.18204201D+04,   0.29425D+01,   0.00000D+00/
  data pars( 53931: 53935) /159, 56,   0.16674685D+04,   0.29425D+01,   0.00000D+00/
  data pars( 53936: 53940) /159, 57,   0.14628142D+04,   0.29425D+01,   0.00000D+00/
  data pars( 53941: 53945) /159, 58,   0.66720180D+03,   0.29425D+01,   0.27991D+01/
  data pars( 53946: 53950) /159, 59,   0.14767389D+04,   0.29425D+01,   0.00000D+00/
  data pars( 53951: 53955) /159, 60,   0.14176855D+04,   0.29425D+01,   0.00000D+00/
  data pars( 53956: 53960) /159, 61,   0.13820320D+04,   0.29425D+01,   0.00000D+00/
  data pars( 53961: 53965) /159, 62,   0.13492524D+04,   0.29425D+01,   0.00000D+00/
  data pars( 53966: 53970) /159, 63,   0.13201809D+04,   0.29425D+01,   0.00000D+00/
  data pars( 53971: 53975) /159, 64,   0.10364403D+04,   0.29425D+01,   0.00000D+00/
  data pars( 53976: 53980) /159, 65,   0.11696897D+04,   0.29425D+01,   0.00000D+00/
  data pars( 53981: 53985) /159, 66,   0.11277999D+04,   0.29425D+01,   0.00000D+00/
  data pars( 53986: 53990) /159, 67,   0.11902918D+04,   0.29425D+01,   0.00000D+00/
  data pars( 53991: 53995) /159, 68,   0.11649825D+04,   0.29425D+01,   0.00000D+00/
  data pars( 53996: 54000) /159, 69,   0.11421370D+04,   0.29425D+01,   0.00000D+00/
  data pars( 54001: 54005) /159, 70,   0.11288548D+04,   0.29425D+01,   0.00000D+00/
  data pars( 54006: 54010) /159, 71,   0.95004210D+03,   0.29425D+01,   0.00000D+00/
  data pars( 54011: 54015) /159, 72,   0.93285060D+03,   0.29425D+01,   0.00000D+00/
  data pars( 54016: 54020) /159, 73,   0.85051620D+03,   0.29425D+01,   0.00000D+00/
  data pars( 54021: 54025) /159, 74,   0.71766720D+03,   0.29425D+01,   0.00000D+00/
  data pars( 54026: 54030) /159, 75,   0.72982300D+03,   0.29425D+01,   0.00000D+00/
  data pars( 54031: 54035) /159, 76,   0.66090480D+03,   0.29425D+01,   0.00000D+00/
  data pars( 54036: 54040) /159, 77,   0.60487530D+03,   0.29425D+01,   0.00000D+00/
  data pars( 54041: 54045) /159, 78,   0.50215100D+03,   0.29425D+01,   0.00000D+00/
  data pars( 54046: 54050) /159, 79,   0.46904220D+03,   0.29425D+01,   0.00000D+00/
  data pars( 54051: 54055) /159, 80,   0.48234510D+03,   0.29425D+01,   0.00000D+00/
  data pars( 54056: 54060) /159, 81,   0.70537820D+03,   0.29425D+01,   0.00000D+00/
  data pars( 54061: 54065) /159, 82,   0.68881010D+03,   0.29425D+01,   0.00000D+00/
  data pars( 54066: 54070) /159, 83,   0.63203130D+03,   0.29425D+01,   0.00000D+00/
  data pars( 54071: 54075) /159, 84,   0.60229480D+03,   0.29425D+01,   0.00000D+00/
  data pars( 54076: 54080) /159, 85,   0.55531140D+03,   0.29425D+01,   0.00000D+00/
  data pars( 54081: 54085) /159, 86,   0.50853060D+03,   0.29425D+01,   0.00000D+00/
  data pars( 54086: 54090) /159, 87,   0.17169108D+04,   0.29425D+01,   0.00000D+00/
  data pars( 54091: 54095) /159, 88,   0.16476121D+04,   0.29425D+01,   0.00000D+00/
  data pars( 54096: 54100) /159, 89,   0.14543881D+04,   0.29425D+01,   0.00000D+00/
  data pars( 54101: 54105) /159, 90,   0.13048970D+04,   0.29425D+01,   0.00000D+00/
  data pars( 54106: 54110) /159, 91,   0.12966238D+04,   0.29425D+01,   0.00000D+00/
  data pars( 54111: 54115) /159, 92,   0.12554359D+04,   0.29425D+01,   0.00000D+00/
  data pars( 54116: 54120) /159, 93,   0.12939094D+04,   0.29425D+01,   0.00000D+00/
  data pars( 54121: 54125) /159, 94,   0.12527870D+04,   0.29425D+01,   0.00000D+00/
  data pars( 54126: 54130) /159,101,   0.69734100D+02,   0.29425D+01,   0.00000D+00/
  data pars( 54131: 54135) /159,103,   0.22705790D+03,   0.29425D+01,   0.98650D+00/
  data pars( 54136: 54140) /159,104,   0.28944340D+03,   0.29425D+01,   0.98080D+00/
  data pars( 54141: 54145) /159,105,   0.22051700D+03,   0.29425D+01,   0.97060D+00/
  data pars( 54146: 54150) /159,106,   0.16588050D+03,   0.29425D+01,   0.98680D+00/
  data pars( 54151: 54155) /159,107,   0.11516050D+03,   0.29425D+01,   0.99440D+00/
  data pars( 54156: 54160) /159,108,   0.83776500D+02,   0.29425D+01,   0.99250D+00/
  data pars( 54161: 54165) /159,109,   0.57559900D+02,   0.29425D+01,   0.99820D+00/
  data pars( 54166: 54170) /159,111,   0.33214950D+03,   0.29425D+01,   0.96840D+00/
  data pars( 54171: 54175) /159,112,   0.51379560D+03,   0.29425D+01,   0.96280D+00/
  data pars( 54176: 54180) /159,113,   0.51961650D+03,   0.29425D+01,   0.96480D+00/
  data pars( 54181: 54185) /159,114,   0.41662720D+03,   0.29425D+01,   0.95070D+00/
  data pars( 54186: 54190) /159,115,   0.34064700D+03,   0.29425D+01,   0.99470D+00/
  data pars( 54191: 54195) /159,116,   0.28774490D+03,   0.29425D+01,   0.99480D+00/
  data pars( 54196: 54200) /159,117,   0.23495440D+03,   0.29425D+01,   0.99720D+00/
  data pars( 54201: 54205) /159,119,   0.45743380D+03,   0.29425D+01,   0.97670D+00/
  data pars( 54206: 54210) /159,120,   0.87755280D+03,   0.29425D+01,   0.98310D+00/
  data pars( 54211: 54215) /159,121,   0.45670870D+03,   0.29425D+01,   0.18627D+01/
  data pars( 54216: 54220) /159,122,   0.44087260D+03,   0.29425D+01,   0.18299D+01/
  data pars( 54221: 54225) /159,123,   0.43208390D+03,   0.29425D+01,   0.19138D+01/
  data pars( 54226: 54230) /159,124,   0.42819360D+03,   0.29425D+01,   0.18269D+01/
  data pars( 54231: 54235) /159,125,   0.39355560D+03,   0.29425D+01,   0.16406D+01/
  data pars( 54236: 54240) /159,126,   0.36411700D+03,   0.29425D+01,   0.16483D+01/
  data pars( 54241: 54245) /159,127,   0.34735660D+03,   0.29425D+01,   0.17149D+01/
  data pars( 54246: 54250) /159,128,   0.33962320D+03,   0.29425D+01,   0.17937D+01/
  data pars( 54251: 54255) /159,129,   0.33586060D+03,   0.29425D+01,   0.95760D+00/
  data pars( 54256: 54260) /159,130,   0.31461930D+03,   0.29425D+01,   0.19419D+01/
  data pars( 54261: 54265) /159,131,   0.51545120D+03,   0.29425D+01,   0.96010D+00/
  data pars( 54266: 54270) /159,132,   0.45195710D+03,   0.29425D+01,   0.94340D+00/
  data pars( 54271: 54275) /159,133,   0.40453400D+03,   0.29425D+01,   0.98890D+00/
  data pars( 54276: 54280) /159,134,   0.36906970D+03,   0.29425D+01,   0.99010D+00/
  data pars( 54281: 54285) /159,135,   0.32478940D+03,   0.29425D+01,   0.99740D+00/
  data pars( 54286: 54290) /159,137,   0.54559170D+03,   0.29425D+01,   0.97380D+00/
  data pars( 54291: 54295) /159,138,   0.10680684D+04,   0.29425D+01,   0.98010D+00/
  data pars( 54296: 54300) /159,139,   0.81406370D+03,   0.29425D+01,   0.19153D+01/
  data pars( 54301: 54305) /159,140,   0.60412500D+03,   0.29425D+01,   0.19355D+01/
  data pars( 54306: 54310) /159,141,   0.61013660D+03,   0.29425D+01,   0.19545D+01/
  data pars( 54311: 54315) /159,142,   0.56871480D+03,   0.29425D+01,   0.19420D+01/
  data pars( 54316: 54320) /159,143,   0.63873760D+03,   0.29425D+01,   0.16682D+01/
  data pars( 54321: 54325) /159,144,   0.49520560D+03,   0.29425D+01,   0.18584D+01/
  data pars( 54326: 54330) /159,145,   0.46324120D+03,   0.29425D+01,   0.19003D+01/
  data pars( 54331: 54335) /159,146,   0.43008630D+03,   0.29425D+01,   0.18630D+01/
  data pars( 54336: 54340) /159,147,   0.41612810D+03,   0.29425D+01,   0.96790D+00/
  data pars( 54341: 54345) /159,148,   0.41129410D+03,   0.29425D+01,   0.19539D+01/
  data pars( 54346: 54350) /159,149,   0.65474970D+03,   0.29425D+01,   0.96330D+00/
  data pars( 54351: 54355) /159,150,   0.59136710D+03,   0.29425D+01,   0.95140D+00/
  data pars( 54356: 54360) /159,151,   0.55320050D+03,   0.29425D+01,   0.97490D+00/
  data pars( 54361: 54365) /159,152,   0.52290670D+03,   0.29425D+01,   0.98110D+00/
  data pars( 54366: 54370) /159,153,   0.47714300D+03,   0.29425D+01,   0.99680D+00/
  data pars( 54371: 54375) /159,155,   0.64438580D+03,   0.29425D+01,   0.99090D+00/
  data pars( 54376: 54380) /159,156,   0.13856402D+04,   0.29425D+01,   0.97970D+00/
  data pars( 54381: 54385) /159,157,   0.10306163D+04,   0.29425D+01,   0.19373D+01/
  data pars( 54386: 54390) /159,159,   0.64702500D+03,   0.29425D+01,   0.29425D+01/
  data pars( 54391: 54395) /160,  1,   0.42334300D+02,   0.29455D+01,   0.91180D+00/
  data pars( 54396: 54400) /160,  2,   0.27932400D+02,   0.29455D+01,   0.00000D+00/
  data pars( 54401: 54405) /160,  3,   0.66553290D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54406: 54410) /160,  4,   0.38257600D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54411: 54415) /160,  5,   0.25686460D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54416: 54420) /160,  6,   0.17319330D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54421: 54425) /160,  7,   0.12097590D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54426: 54430) /160,  8,   0.91540700D+02,   0.29455D+01,   0.00000D+00/
  data pars( 54431: 54435) /160,  9,   0.69326100D+02,   0.29455D+01,   0.00000D+00/
  data pars( 54436: 54440) /160, 10,   0.53320100D+02,   0.29455D+01,   0.00000D+00/
  data pars( 54441: 54445) /160, 11,   0.79568730D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54446: 54450) /160, 12,   0.61016250D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54451: 54455) /160, 13,   0.56154980D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54456: 54460) /160, 14,   0.44153690D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54461: 54465) /160, 15,   0.34370190D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54466: 54470) /160, 16,   0.28495290D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54471: 54475) /160, 17,   0.23255130D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54476: 54480) /160, 18,   0.19012240D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54481: 54485) /160, 19,   0.13047563D+04,   0.29455D+01,   0.00000D+00/
  data pars( 54486: 54490) /160, 20,   0.10738235D+04,   0.29455D+01,   0.00000D+00/
  data pars( 54491: 54495) /160, 21,   0.88652660D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54496: 54500) /160, 22,   0.85553540D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54501: 54505) /160, 23,   0.78313860D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54506: 54510) /160, 24,   0.61691000D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54511: 54515) /160, 25,   0.67388620D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54516: 54520) /160, 26,   0.52887800D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54521: 54525) /160, 27,   0.56009170D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54526: 54530) /160, 28,   0.57719940D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54531: 54535) /160, 29,   0.44255790D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54536: 54540) /160, 30,   0.45374620D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54541: 54545) /160, 31,   0.53757900D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54546: 54550) /160, 32,   0.47326730D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54551: 54555) /160, 33,   0.40304410D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54556: 54560) /160, 34,   0.36132220D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54561: 54565) /160, 35,   0.31591320D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54566: 54570) /160, 36,   0.27452240D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54571: 54575) /160, 37,   0.14619055D+04,   0.29455D+01,   0.00000D+00/
  data pars( 54576: 54580) /160, 38,   0.12795273D+04,   0.29455D+01,   0.00000D+00/
  data pars( 54581: 54585) /160, 39,   0.11193527D+04,   0.29455D+01,   0.00000D+00/
  data pars( 54586: 54590) /160, 40,   0.10051742D+04,   0.29455D+01,   0.00000D+00/
  data pars( 54591: 54595) /160, 41,   0.91606480D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54596: 54600) /160, 42,   0.70655730D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54601: 54605) /160, 43,   0.78861510D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54606: 54610) /160, 44,   0.60017770D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54611: 54615) /160, 45,   0.65600920D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54616: 54620) /160, 46,   0.60812890D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54621: 54625) /160, 47,   0.50722690D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54626: 54630) /160, 48,   0.53562280D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54631: 54635) /160, 49,   0.67289960D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54636: 54640) /160, 50,   0.62132160D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54641: 54645) /160, 51,   0.55289340D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54646: 54650) /160, 52,   0.51252450D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54651: 54655) /160, 53,   0.46298250D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54656: 54660) /160, 54,   0.41589380D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54661: 54665) /160, 55,   0.17807379D+04,   0.29455D+01,   0.00000D+00/
  data pars( 54666: 54670) /160, 56,   0.16318559D+04,   0.29455D+01,   0.00000D+00/
  data pars( 54671: 54675) /160, 57,   0.14317796D+04,   0.29455D+01,   0.00000D+00/
  data pars( 54676: 54680) /160, 58,   0.65338750D+03,   0.29455D+01,   0.27991D+01/
  data pars( 54681: 54685) /160, 59,   0.14452611D+04,   0.29455D+01,   0.00000D+00/
  data pars( 54686: 54690) /160, 60,   0.13875284D+04,   0.29455D+01,   0.00000D+00/
  data pars( 54691: 54695) /160, 61,   0.13526449D+04,   0.29455D+01,   0.00000D+00/
  data pars( 54696: 54700) /160, 62,   0.13205717D+04,   0.29455D+01,   0.00000D+00/
  data pars( 54701: 54705) /160, 63,   0.12921268D+04,   0.29455D+01,   0.00000D+00/
  data pars( 54706: 54710) /160, 64,   0.10145593D+04,   0.29455D+01,   0.00000D+00/
  data pars( 54711: 54715) /160, 65,   0.11446770D+04,   0.29455D+01,   0.00000D+00/
  data pars( 54716: 54720) /160, 66,   0.11036788D+04,   0.29455D+01,   0.00000D+00/
  data pars( 54721: 54725) /160, 67,   0.11650450D+04,   0.29455D+01,   0.00000D+00/
  data pars( 54726: 54730) /160, 68,   0.11402779D+04,   0.29455D+01,   0.00000D+00/
  data pars( 54731: 54735) /160, 69,   0.11179234D+04,   0.29455D+01,   0.00000D+00/
  data pars( 54736: 54740) /160, 70,   0.11049164D+04,   0.29455D+01,   0.00000D+00/
  data pars( 54741: 54745) /160, 71,   0.92996320D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54746: 54750) /160, 72,   0.91326380D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54751: 54755) /160, 73,   0.83272290D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54756: 54760) /160, 74,   0.70269660D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54761: 54765) /160, 75,   0.71461940D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54766: 54770) /160, 76,   0.64718140D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54771: 54775) /160, 77,   0.59234880D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54776: 54780) /160, 78,   0.49178730D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54781: 54785) /160, 79,   0.45937630D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54786: 54790) /160, 80,   0.47241230D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54791: 54795) /160, 81,   0.69065930D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54796: 54800) /160, 82,   0.67450000D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54801: 54805) /160, 83,   0.61895970D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54806: 54810) /160, 84,   0.58986940D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54811: 54815) /160, 85,   0.54389180D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54816: 54820) /160, 86,   0.49810570D+03,   0.29455D+01,   0.00000D+00/
  data pars( 54821: 54825) /160, 87,   0.16797710D+04,   0.29455D+01,   0.00000D+00/
  data pars( 54826: 54830) /160, 88,   0.16125437D+04,   0.29455D+01,   0.00000D+00/
  data pars( 54831: 54835) /160, 89,   0.14236214D+04,   0.29455D+01,   0.00000D+00/
  data pars( 54836: 54840) /160, 90,   0.12774745D+04,   0.29455D+01,   0.00000D+00/
  data pars( 54841: 54845) /160, 91,   0.12692909D+04,   0.29455D+01,   0.00000D+00/
  data pars( 54846: 54850) /160, 92,   0.12289809D+04,   0.29455D+01,   0.00000D+00/
  data pars( 54851: 54855) /160, 93,   0.12665506D+04,   0.29455D+01,   0.00000D+00/
  data pars( 54856: 54860) /160, 94,   0.12263194D+04,   0.29455D+01,   0.00000D+00/
  data pars( 54861: 54865) /160,101,   0.68293100D+02,   0.29455D+01,   0.00000D+00/
  data pars( 54866: 54870) /160,103,   0.22228830D+03,   0.29455D+01,   0.98650D+00/
  data pars( 54871: 54875) /160,104,   0.28337150D+03,   0.29455D+01,   0.98080D+00/
  data pars( 54876: 54880) /160,105,   0.21594380D+03,   0.29455D+01,   0.97060D+00/
  data pars( 54881: 54885) /160,106,   0.16246650D+03,   0.29455D+01,   0.98680D+00/
  data pars( 54886: 54890) /160,107,   0.11281340D+03,   0.29455D+01,   0.99440D+00/
  data pars( 54891: 54895) /160,108,   0.82084900D+02,   0.29455D+01,   0.99250D+00/
  data pars( 54896: 54900) /160,109,   0.56411700D+02,   0.29455D+01,   0.99820D+00/
  data pars( 54901: 54905) /160,111,   0.32516360D+03,   0.29455D+01,   0.96840D+00/
  data pars( 54906: 54910) /160,112,   0.50296550D+03,   0.29455D+01,   0.96280D+00/
  data pars( 54911: 54915) /160,113,   0.50872500D+03,   0.29455D+01,   0.96480D+00/
  data pars( 54916: 54920) /160,114,   0.40796290D+03,   0.29455D+01,   0.95070D+00/
  data pars( 54921: 54925) /160,115,   0.33360650D+03,   0.29455D+01,   0.99470D+00/
  data pars( 54926: 54930) /160,116,   0.28182650D+03,   0.29455D+01,   0.99480D+00/
  data pars( 54931: 54935) /160,117,   0.23014880D+03,   0.29455D+01,   0.99720D+00/
  data pars( 54936: 54940) /160,119,   0.44786360D+03,   0.29455D+01,   0.97670D+00/
  data pars( 54941: 54945) /160,120,   0.85883830D+03,   0.29455D+01,   0.98310D+00/
  data pars( 54946: 54950) /160,121,   0.44722200D+03,   0.29455D+01,   0.18627D+01/
  data pars( 54951: 54955) /160,122,   0.43170970D+03,   0.29455D+01,   0.18299D+01/
  data pars( 54956: 54960) /160,123,   0.42310550D+03,   0.29455D+01,   0.19138D+01/
  data pars( 54961: 54965) /160,124,   0.41928980D+03,   0.29455D+01,   0.18269D+01/
  data pars( 54966: 54970) /160,125,   0.38540430D+03,   0.29455D+01,   0.16406D+01/
  data pars( 54971: 54975) /160,126,   0.35658500D+03,   0.29455D+01,   0.16483D+01/
  data pars( 54976: 54980) /160,127,   0.34017190D+03,   0.29455D+01,   0.17149D+01/
  data pars( 54981: 54985) /160,128,   0.33259710D+03,   0.29455D+01,   0.17937D+01/
  data pars( 54986: 54990) /160,129,   0.32889540D+03,   0.29455D+01,   0.95760D+00/
  data pars( 54991: 54995) /160,130,   0.30812510D+03,   0.29455D+01,   0.19419D+01/
  data pars( 54996: 55000) /160,131,   0.50468300D+03,   0.29455D+01,   0.96010D+00/
  data pars( 55001: 55005) /160,132,   0.44257280D+03,   0.29455D+01,   0.94340D+00/
  data pars( 55006: 55010) /160,133,   0.39617290D+03,   0.29455D+01,   0.98890D+00/
  data pars( 55011: 55015) /160,134,   0.36146790D+03,   0.29455D+01,   0.99010D+00/
  data pars( 55016: 55020) /160,135,   0.31812780D+03,   0.29455D+01,   0.99740D+00/
  data pars( 55021: 55025) /160,137,   0.53419470D+03,   0.29455D+01,   0.97380D+00/
  data pars( 55026: 55030) /160,138,   0.10452541D+04,   0.29455D+01,   0.98010D+00/
  data pars( 55031: 55035) /160,139,   0.79688440D+03,   0.29455D+01,   0.19153D+01/
  data pars( 55036: 55040) /160,140,   0.59156300D+03,   0.29455D+01,   0.19355D+01/
  data pars( 55041: 55045) /160,141,   0.59746030D+03,   0.29455D+01,   0.19545D+01/
  data pars( 55046: 55050) /160,142,   0.55690660D+03,   0.29455D+01,   0.19420D+01/
  data pars( 55051: 55055) /160,143,   0.62539660D+03,   0.29455D+01,   0.16682D+01/
  data pars( 55056: 55060) /160,144,   0.48497040D+03,   0.29455D+01,   0.18584D+01/
  data pars( 55061: 55065) /160,145,   0.45367340D+03,   0.29455D+01,   0.19003D+01/
  data pars( 55066: 55070) /160,146,   0.42121350D+03,   0.29455D+01,   0.18630D+01/
  data pars( 55071: 55075) /160,147,   0.40754200D+03,   0.29455D+01,   0.96790D+00/
  data pars( 55076: 55080) /160,148,   0.40282810D+03,   0.29455D+01,   0.19539D+01/
  data pars( 55081: 55085) /160,149,   0.64108970D+03,   0.29455D+01,   0.96330D+00/
  data pars( 55086: 55090) /160,150,   0.57909510D+03,   0.29455D+01,   0.95140D+00/
  data pars( 55091: 55095) /160,151,   0.54176140D+03,   0.29455D+01,   0.97490D+00/
  data pars( 55096: 55100) /160,152,   0.51212090D+03,   0.29455D+01,   0.98110D+00/
  data pars( 55101: 55105) /160,153,   0.46733270D+03,   0.29455D+01,   0.99680D+00/
  data pars( 55106: 55110) /160,155,   0.63096990D+03,   0.29455D+01,   0.99090D+00/
  data pars( 55111: 55115) /160,156,   0.13558874D+04,   0.29455D+01,   0.97970D+00/
  data pars( 55116: 55120) /160,157,   0.10088176D+04,   0.29455D+01,   0.19373D+01/
  data pars( 55121: 55125) /160,159,   0.63363330D+03,   0.29455D+01,   0.29425D+01/
  data pars( 55126: 55130) /160,160,   0.62052060D+03,   0.29455D+01,   0.29455D+01/
  data pars( 55131: 55135) /161,  1,   0.41035600D+02,   0.29413D+01,   0.91180D+00/
  data pars( 55136: 55140) /161,  2,   0.27115000D+02,   0.29413D+01,   0.00000D+00/
  data pars( 55141: 55145) /161,  3,   0.64218080D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55146: 55150) /161,  4,   0.36981420D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55151: 55155) /161,  5,   0.24860710D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55156: 55160) /161,  6,   0.16779680D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55161: 55165) /161,  7,   0.11730260D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55166: 55170) /161,  8,   0.88815900D+02,   0.29413D+01,   0.00000D+00/
  data pars( 55171: 55175) /161,  9,   0.67299900D+02,   0.29413D+01,   0.00000D+00/
  data pars( 55176: 55180) /161, 10,   0.51786000D+02,   0.29413D+01,   0.00000D+00/
  data pars( 55181: 55185) /161, 11,   0.76786760D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55186: 55190) /161, 12,   0.58961410D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55191: 55195) /161, 13,   0.54296830D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55196: 55200) /161, 14,   0.42728580D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55201: 55205) /161, 15,   0.33286240D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55206: 55210) /161, 16,   0.27611290D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55211: 55215) /161, 17,   0.22545620D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55216: 55220) /161, 18,   0.18441100D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55221: 55225) /161, 19,   0.12590280D+04,   0.29413D+01,   0.00000D+00/
  data pars( 55226: 55230) /161, 20,   0.10371340D+04,   0.29413D+01,   0.00000D+00/
  data pars( 55231: 55235) /161, 21,   0.85644340D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55236: 55240) /161, 22,   0.82672570D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55241: 55245) /161, 23,   0.75688430D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55246: 55250) /161, 24,   0.59629710D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55251: 55255) /161, 25,   0.65144380D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55256: 55260) /161, 26,   0.51133840D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55261: 55265) /161, 27,   0.54164010D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55266: 55270) /161, 28,   0.55809040D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55271: 55275) /161, 29,   0.42796300D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55276: 55280) /161, 30,   0.43895460D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55281: 55285) /161, 31,   0.51995360D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55286: 55290) /161, 32,   0.45803850D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55291: 55295) /161, 33,   0.39031610D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55296: 55300) /161, 34,   0.35005540D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55301: 55305) /161, 35,   0.30619590D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55306: 55310) /161, 36,   0.26618930D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55311: 55315) /161, 37,   0.14108565D+04,   0.29413D+01,   0.00000D+00/
  data pars( 55316: 55320) /161, 38,   0.12358086D+04,   0.29413D+01,   0.00000D+00/
  data pars( 55321: 55325) /161, 39,   0.10815963D+04,   0.29413D+01,   0.00000D+00/
  data pars( 55326: 55330) /161, 40,   0.97156440D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55331: 55335) /161, 41,   0.88562820D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55336: 55340) /161, 42,   0.68336810D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55341: 55345) /161, 43,   0.76261340D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55346: 55350) /161, 44,   0.58065630D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55351: 55355) /161, 45,   0.63462930D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55356: 55360) /161, 46,   0.58839190D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55361: 55365) /161, 47,   0.49078330D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55366: 55370) /161, 48,   0.51833560D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55371: 55375) /161, 49,   0.65088900D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55376: 55380) /161, 50,   0.60128620D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55381: 55385) /161, 51,   0.53534260D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55386: 55390) /161, 52,   0.49642060D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55391: 55395) /161, 53,   0.44860200D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55396: 55400) /161, 54,   0.40312330D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55401: 55405) /161, 55,   0.17186565D+04,   0.29413D+01,   0.00000D+00/
  data pars( 55406: 55410) /161, 56,   0.15759396D+04,   0.29413D+01,   0.00000D+00/
  data pars( 55411: 55415) /161, 57,   0.13833184D+04,   0.29413D+01,   0.00000D+00/
  data pars( 55416: 55420) /161, 58,   0.63260690D+03,   0.29413D+01,   0.27991D+01/
  data pars( 55421: 55425) /161, 59,   0.13959648D+04,   0.29413D+01,   0.00000D+00/
  data pars( 55426: 55430) /161, 60,   0.13402848D+04,   0.29413D+01,   0.00000D+00/
  data pars( 55431: 55435) /161, 61,   0.13066123D+04,   0.29413D+01,   0.00000D+00/
  data pars( 55436: 55440) /161, 62,   0.12756493D+04,   0.29413D+01,   0.00000D+00/
  data pars( 55441: 55445) /161, 63,   0.12481896D+04,   0.29413D+01,   0.00000D+00/
  data pars( 55446: 55450) /161, 64,   0.98061140D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55451: 55455) /161, 65,   0.11056577D+04,   0.29413D+01,   0.00000D+00/
  data pars( 55456: 55460) /161, 66,   0.10661553D+04,   0.29413D+01,   0.00000D+00/
  data pars( 55461: 55465) /161, 67,   0.11255430D+04,   0.29413D+01,   0.00000D+00/
  data pars( 55466: 55470) /161, 68,   0.11016251D+04,   0.29413D+01,   0.00000D+00/
  data pars( 55471: 55475) /161, 69,   0.10800441D+04,   0.29413D+01,   0.00000D+00/
  data pars( 55476: 55480) /161, 70,   0.10674513D+04,   0.29413D+01,   0.00000D+00/
  data pars( 55481: 55485) /161, 71,   0.89877880D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55486: 55490) /161, 72,   0.88303380D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55491: 55495) /161, 73,   0.80541670D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55496: 55500) /161, 74,   0.67986960D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55501: 55505) /161, 75,   0.69147700D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55506: 55510) /161, 76,   0.62640460D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55511: 55515) /161, 77,   0.57347180D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55516: 55520) /161, 78,   0.47626530D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55521: 55525) /161, 79,   0.44493320D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55526: 55530) /161, 80,   0.45759140D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55531: 55535) /161, 81,   0.66821650D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55536: 55540) /161, 82,   0.65280350D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55541: 55545) /161, 83,   0.59931800D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55546: 55550) /161, 84,   0.57130760D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55551: 55555) /161, 85,   0.52695800D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55556: 55560) /161, 86,   0.48275550D+03,   0.29413D+01,   0.00000D+00/
  data pars( 55561: 55565) /161, 87,   0.16217509D+04,   0.29413D+01,   0.00000D+00/
  data pars( 55566: 55570) /161, 88,   0.15576603D+04,   0.29413D+01,   0.00000D+00/
  data pars( 55571: 55575) /161, 89,   0.13757224D+04,   0.29413D+01,   0.00000D+00/
  data pars( 55576: 55580) /161, 90,   0.12351334D+04,   0.29413D+01,   0.00000D+00/
  data pars( 55581: 55585) /161, 91,   0.12269612D+04,   0.29413D+01,   0.00000D+00/
  data pars( 55586: 55590) /161, 92,   0.11880136D+04,   0.29413D+01,   0.00000D+00/
  data pars( 55591: 55595) /161, 93,   0.12239539D+04,   0.29413D+01,   0.00000D+00/
  data pars( 55596: 55600) /161, 94,   0.11851389D+04,   0.29413D+01,   0.00000D+00/
  data pars( 55601: 55605) /161,101,   0.66143900D+02,   0.29413D+01,   0.00000D+00/
  data pars( 55606: 55610) /161,103,   0.21491570D+03,   0.29413D+01,   0.98650D+00/
  data pars( 55611: 55615) /161,104,   0.27404530D+03,   0.29413D+01,   0.98080D+00/
  data pars( 55616: 55620) /161,105,   0.20906270D+03,   0.29413D+01,   0.97060D+00/
  data pars( 55621: 55625) /161,106,   0.15740780D+03,   0.29413D+01,   0.98680D+00/
  data pars( 55626: 55630) /161,107,   0.10939440D+03,   0.29413D+01,   0.99440D+00/
  data pars( 55631: 55635) /161,108,   0.79656600D+02,   0.29413D+01,   0.99250D+00/
  data pars( 55636: 55640) /161,109,   0.54794700D+02,   0.29413D+01,   0.99820D+00/
  data pars( 55641: 55645) /161,111,   0.31433160D+03,   0.29413D+01,   0.96840D+00/
  data pars( 55646: 55650) /161,112,   0.48615820D+03,   0.29413D+01,   0.96280D+00/
  data pars( 55651: 55655) /161,113,   0.49197000D+03,   0.29413D+01,   0.96480D+00/
  data pars( 55656: 55660) /161,114,   0.39485010D+03,   0.29413D+01,   0.95070D+00/
  data pars( 55661: 55665) /161,115,   0.32309660D+03,   0.29413D+01,   0.99470D+00/
  data pars( 55666: 55670) /161,116,   0.27308190D+03,   0.29413D+01,   0.99480D+00/
  data pars( 55671: 55675) /161,117,   0.22312610D+03,   0.29413D+01,   0.99720D+00/
  data pars( 55676: 55680) /161,119,   0.43320740D+03,   0.29413D+01,   0.97670D+00/
  data pars( 55681: 55685) /161,120,   0.82964080D+03,   0.29413D+01,   0.98310D+00/
  data pars( 55686: 55690) /161,121,   0.43282760D+03,   0.29413D+01,   0.18627D+01/
  data pars( 55691: 55695) /161,122,   0.41783600D+03,   0.29413D+01,   0.18299D+01/
  data pars( 55696: 55700) /161,123,   0.40950580D+03,   0.29413D+01,   0.19138D+01/
  data pars( 55701: 55705) /161,124,   0.40578350D+03,   0.29413D+01,   0.18269D+01/
  data pars( 55706: 55710) /161,125,   0.37312230D+03,   0.29413D+01,   0.16406D+01/
  data pars( 55711: 55715) /161,126,   0.34526760D+03,   0.29413D+01,   0.16483D+01/
  data pars( 55716: 55720) /161,127,   0.32938120D+03,   0.29413D+01,   0.17149D+01/
  data pars( 55721: 55725) /161,128,   0.32203750D+03,   0.29413D+01,   0.17937D+01/
  data pars( 55726: 55730) /161,129,   0.31836420D+03,   0.29413D+01,   0.95760D+00/
  data pars( 55731: 55735) /161,130,   0.29841060D+03,   0.29413D+01,   0.19419D+01/
  data pars( 55736: 55740) /161,131,   0.48821620D+03,   0.29413D+01,   0.96010D+00/
  data pars( 55741: 55745) /161,132,   0.42840160D+03,   0.29413D+01,   0.94340D+00/
  data pars( 55746: 55750) /161,133,   0.38367750D+03,   0.29413D+01,   0.98890D+00/
  data pars( 55751: 55755) /161,134,   0.35019520D+03,   0.29413D+01,   0.99010D+00/
  data pars( 55756: 55760) /161,135,   0.30833610D+03,   0.29413D+01,   0.99740D+00/
  data pars( 55761: 55765) /161,137,   0.51680260D+03,   0.29413D+01,   0.97380D+00/
  data pars( 55766: 55770) /161,138,   0.10097020D+04,   0.29413D+01,   0.98010D+00/
  data pars( 55771: 55775) /161,139,   0.77048950D+03,   0.29413D+01,   0.19153D+01/
  data pars( 55776: 55780) /161,140,   0.57252260D+03,   0.29413D+01,   0.19355D+01/
  data pars( 55781: 55785) /161,141,   0.57822130D+03,   0.29413D+01,   0.19545D+01/
  data pars( 55786: 55790) /161,142,   0.53906400D+03,   0.29413D+01,   0.19420D+01/
  data pars( 55791: 55795) /161,143,   0.60508290D+03,   0.29413D+01,   0.16682D+01/
  data pars( 55796: 55800) /161,144,   0.46961340D+03,   0.29413D+01,   0.18584D+01/
  data pars( 55801: 55805) /161,145,   0.43933610D+03,   0.29413D+01,   0.19003D+01/
  data pars( 55806: 55810) /161,146,   0.40794200D+03,   0.29413D+01,   0.18630D+01/
  data pars( 55811: 55815) /161,147,   0.39468140D+03,   0.29413D+01,   0.96790D+00/
  data pars( 55816: 55820) /161,148,   0.39021360D+03,   0.29413D+01,   0.19539D+01/
  data pars( 55821: 55825) /161,149,   0.62022960D+03,   0.29413D+01,   0.96330D+00/
  data pars( 55826: 55830) /161,150,   0.56054060D+03,   0.29413D+01,   0.95140D+00/
  data pars( 55831: 55835) /161,151,   0.52460280D+03,   0.29413D+01,   0.97490D+00/
  data pars( 55836: 55840) /161,152,   0.49603960D+03,   0.29413D+01,   0.98110D+00/
  data pars( 55841: 55845) /161,153,   0.45281350D+03,   0.29413D+01,   0.99680D+00/
  data pars( 55846: 55850) /161,155,   0.61065170D+03,   0.29413D+01,   0.99090D+00/
  data pars( 55851: 55855) /161,156,   0.13096071D+04,   0.29413D+01,   0.97970D+00/
  data pars( 55856: 55860) /161,157,   0.97534290D+03,   0.29413D+01,   0.19373D+01/
  data pars( 55861: 55865) /161,159,   0.61350220D+03,   0.29413D+01,   0.29425D+01/
  data pars( 55866: 55870) /161,160,   0.60081010D+03,   0.29413D+01,   0.29455D+01/
  data pars( 55871: 55875) /161,161,   0.58174350D+03,   0.29413D+01,   0.29413D+01/
  data pars( 55876: 55880) /162,  1,   0.41118600D+02,   0.29300D+01,   0.91180D+00/
  data pars( 55881: 55885) /162,  2,   0.27091000D+02,   0.29300D+01,   0.00000D+00/
  data pars( 55886: 55890) /162,  3,   0.65371250D+03,   0.29300D+01,   0.00000D+00/
  data pars( 55891: 55895) /162,  4,   0.37335380D+03,   0.29300D+01,   0.00000D+00/
  data pars( 55896: 55900) /162,  5,   0.25006900D+03,   0.29300D+01,   0.00000D+00/
  data pars( 55901: 55905) /162,  6,   0.16835070D+03,   0.29300D+01,   0.00000D+00/
  data pars( 55906: 55910) /162,  7,   0.11747400D+03,   0.29300D+01,   0.00000D+00/
  data pars( 55911: 55915) /162,  8,   0.88833200D+02,   0.29300D+01,   0.00000D+00/
  data pars( 55916: 55920) /162,  9,   0.67241500D+02,   0.29300D+01,   0.00000D+00/
  data pars( 55921: 55925) /162, 10,   0.51697700D+02,   0.29300D+01,   0.00000D+00/
  data pars( 55926: 55930) /162, 11,   0.78120500D+03,   0.29300D+01,   0.00000D+00/
  data pars( 55931: 55935) /162, 12,   0.59600220D+03,   0.29300D+01,   0.00000D+00/
  data pars( 55936: 55940) /162, 13,   0.54777420D+03,   0.29300D+01,   0.00000D+00/
  data pars( 55941: 55945) /162, 14,   0.42994940D+03,   0.29300D+01,   0.00000D+00/
  data pars( 55946: 55950) /162, 15,   0.33425170D+03,   0.29300D+01,   0.00000D+00/
  data pars( 55951: 55955) /162, 16,   0.27691160D+03,   0.29300D+01,   0.00000D+00/
  data pars( 55956: 55960) /162, 17,   0.22583700D+03,   0.29300D+01,   0.00000D+00/
  data pars( 55961: 55965) /162, 18,   0.18453320D+03,   0.29300D+01,   0.00000D+00/
  data pars( 55966: 55970) /162, 19,   0.12836315D+04,   0.29300D+01,   0.00000D+00/
  data pars( 55971: 55975) /162, 20,   0.10509848D+04,   0.29300D+01,   0.00000D+00/
  data pars( 55976: 55980) /162, 21,   0.86692280D+03,   0.29300D+01,   0.00000D+00/
  data pars( 55981: 55985) /162, 22,   0.83609940D+03,   0.29300D+01,   0.00000D+00/
  data pars( 55986: 55990) /162, 23,   0.76505120D+03,   0.29300D+01,   0.00000D+00/
  data pars( 55991: 55995) /162, 24,   0.60271130D+03,   0.29300D+01,   0.00000D+00/
  data pars( 55996: 56000) /162, 25,   0.65796350D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56001: 56005) /162, 26,   0.51637700D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56006: 56010) /162, 27,   0.54633630D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56011: 56015) /162, 28,   0.56322550D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56016: 56020) /162, 29,   0.43190330D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56021: 56025) /162, 30,   0.44225450D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56026: 56030) /162, 31,   0.52416760D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56031: 56035) /162, 32,   0.46081790D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56036: 56040) /162, 33,   0.39201390D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56041: 56045) /162, 34,   0.35121820D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56046: 56050) /162, 35,   0.30689590D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56051: 56055) /162, 36,   0.26654940D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56056: 56060) /162, 37,   0.14379300D+04,   0.29300D+01,   0.00000D+00/
  data pars( 56061: 56065) /162, 38,   0.12526342D+04,   0.29300D+01,   0.00000D+00/
  data pars( 56066: 56070) /162, 39,   0.10942695D+04,   0.29300D+01,   0.00000D+00/
  data pars( 56071: 56075) /162, 40,   0.98185530D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56076: 56080) /162, 41,   0.89439170D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56081: 56085) /162, 42,   0.68930910D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56086: 56090) /162, 43,   0.76959900D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56091: 56095) /162, 44,   0.58520650D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56096: 56100) /162, 45,   0.63957050D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56101: 56105) /162, 46,   0.59271510D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56106: 56110) /162, 47,   0.49454430D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56111: 56115) /162, 48,   0.52185710D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56116: 56120) /162, 49,   0.65623190D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56121: 56125) /162, 50,   0.60519030D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56126: 56130) /162, 51,   0.53798990D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56131: 56135) /162, 52,   0.49842910D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56136: 56140) /162, 53,   0.44999200D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56141: 56145) /162, 54,   0.40401740D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56146: 56150) /162, 55,   0.17521410D+04,   0.29300D+01,   0.00000D+00/
  data pars( 56151: 56155) /162, 56,   0.15986396D+04,   0.29300D+01,   0.00000D+00/
  data pars( 56156: 56160) /162, 57,   0.14005068D+04,   0.29300D+01,   0.00000D+00/
  data pars( 56161: 56165) /162, 58,   0.63591570D+03,   0.29300D+01,   0.27991D+01/
  data pars( 56166: 56170) /162, 59,   0.14152709D+04,   0.29300D+01,   0.00000D+00/
  data pars( 56171: 56175) /162, 60,   0.13581904D+04,   0.29300D+01,   0.00000D+00/
  data pars( 56176: 56180) /162, 61,   0.13239329D+04,   0.29300D+01,   0.00000D+00/
  data pars( 56181: 56185) /162, 62,   0.12924475D+04,   0.29300D+01,   0.00000D+00/
  data pars( 56186: 56190) /162, 63,   0.12645213D+04,   0.29300D+01,   0.00000D+00/
  data pars( 56191: 56195) /162, 64,   0.99151760D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56196: 56200) /162, 65,   0.11218549D+04,   0.29300D+01,   0.00000D+00/
  data pars( 56201: 56205) /162, 66,   0.10816001D+04,   0.29300D+01,   0.00000D+00/
  data pars( 56206: 56210) /162, 67,   0.11396825D+04,   0.29300D+01,   0.00000D+00/
  data pars( 56211: 56215) /162, 68,   0.11153978D+04,   0.29300D+01,   0.00000D+00/
  data pars( 56216: 56220) /162, 69,   0.10934602D+04,   0.29300D+01,   0.00000D+00/
  data pars( 56221: 56225) /162, 70,   0.10807974D+04,   0.29300D+01,   0.00000D+00/
  data pars( 56226: 56230) /162, 71,   0.90896190D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56231: 56235) /162, 72,   0.89127890D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56236: 56240) /162, 73,   0.81208250D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56241: 56245) /162, 74,   0.68499030D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56246: 56250) /162, 75,   0.69640000D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56251: 56255) /162, 76,   0.63031370D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56256: 56260) /162, 77,   0.57665350D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56261: 56265) /162, 78,   0.47857310D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56266: 56270) /162, 79,   0.44696260D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56271: 56275) /162, 80,   0.45952800D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56276: 56280) /162, 81,   0.67346620D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56281: 56285) /162, 82,   0.65702270D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56286: 56290) /162, 83,   0.60234550D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56291: 56295) /162, 84,   0.57374780D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56296: 56300) /162, 85,   0.52872700D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56301: 56305) /162, 86,   0.48398270D+03,   0.29300D+01,   0.00000D+00/
  data pars( 56306: 56310) /162, 87,   0.16501361D+04,   0.29300D+01,   0.00000D+00/
  data pars( 56311: 56315) /162, 88,   0.15785123D+04,   0.29300D+01,   0.00000D+00/
  data pars( 56316: 56320) /162, 89,   0.13916728D+04,   0.29300D+01,   0.00000D+00/
  data pars( 56321: 56325) /162, 90,   0.12470771D+04,   0.29300D+01,   0.00000D+00/
  data pars( 56326: 56330) /162, 91,   0.12400445D+04,   0.29300D+01,   0.00000D+00/
  data pars( 56331: 56335) /162, 92,   0.12006028D+04,   0.29300D+01,   0.00000D+00/
  data pars( 56336: 56340) /162, 93,   0.12383187D+04,   0.29300D+01,   0.00000D+00/
  data pars( 56341: 56345) /162, 94,   0.11987720D+04,   0.29300D+01,   0.00000D+00/
  data pars( 56346: 56350) /162,101,   0.66405700D+02,   0.29300D+01,   0.00000D+00/
  data pars( 56351: 56355) /162,103,   0.21686950D+03,   0.29300D+01,   0.98650D+00/
  data pars( 56356: 56360) /162,104,   0.27638280D+03,   0.29300D+01,   0.98080D+00/
  data pars( 56361: 56365) /162,105,   0.21014480D+03,   0.29300D+01,   0.97060D+00/
  data pars( 56366: 56370) /162,106,   0.15794060D+03,   0.29300D+01,   0.98680D+00/
  data pars( 56371: 56375) /162,107,   0.10955230D+03,   0.29300D+01,   0.99440D+00/
  data pars( 56376: 56380) /162,108,   0.79647700D+02,   0.29300D+01,   0.99250D+00/
  data pars( 56381: 56385) /162,109,   0.54685200D+02,   0.29300D+01,   0.99820D+00/
  data pars( 56386: 56390) /162,111,   0.31740960D+03,   0.29300D+01,   0.96840D+00/
  data pars( 56391: 56395) /162,112,   0.49113850D+03,   0.29300D+01,   0.96280D+00/
  data pars( 56396: 56400) /162,113,   0.49609590D+03,   0.29300D+01,   0.96480D+00/
  data pars( 56401: 56405) /162,114,   0.39717520D+03,   0.29300D+01,   0.95070D+00/
  data pars( 56406: 56410) /162,115,   0.32442460D+03,   0.29300D+01,   0.99470D+00/
  data pars( 56411: 56415) /162,116,   0.27388040D+03,   0.29300D+01,   0.99480D+00/
  data pars( 56416: 56420) /162,117,   0.22350790D+03,   0.29300D+01,   0.99720D+00/
  data pars( 56421: 56425) /162,119,   0.43688540D+03,   0.29300D+01,   0.97670D+00/
  data pars( 56426: 56430) /162,120,   0.84105190D+03,   0.29300D+01,   0.98310D+00/
  data pars( 56431: 56435) /162,121,   0.43551720D+03,   0.29300D+01,   0.18627D+01/
  data pars( 56436: 56440) /162,122,   0.42046710D+03,   0.29300D+01,   0.18299D+01/
  data pars( 56441: 56445) /162,123,   0.41208740D+03,   0.29300D+01,   0.19138D+01/
  data pars( 56446: 56450) /162,124,   0.40844600D+03,   0.29300D+01,   0.18269D+01/
  data pars( 56451: 56455) /162,125,   0.37510510D+03,   0.29300D+01,   0.16406D+01/
  data pars( 56456: 56460) /162,126,   0.34698680D+03,   0.29300D+01,   0.16483D+01/
  data pars( 56461: 56465) /162,127,   0.33102820D+03,   0.29300D+01,   0.17149D+01/
  data pars( 56466: 56470) /162,128,   0.32367720D+03,   0.29300D+01,   0.17937D+01/
  data pars( 56471: 56475) /162,129,   0.32026840D+03,   0.29300D+01,   0.95760D+00/
  data pars( 56476: 56480) /162,130,   0.29970920D+03,   0.29300D+01,   0.19419D+01/
  data pars( 56481: 56485) /162,131,   0.49191570D+03,   0.29300D+01,   0.96010D+00/
  data pars( 56486: 56490) /162,132,   0.43081190D+03,   0.29300D+01,   0.94340D+00/
  data pars( 56491: 56495) /162,133,   0.38530990D+03,   0.29300D+01,   0.98890D+00/
  data pars( 56496: 56500) /162,134,   0.35136440D+03,   0.29300D+01,   0.99010D+00/
  data pars( 56501: 56505) /162,135,   0.30905750D+03,   0.29300D+01,   0.99740D+00/
  data pars( 56506: 56510) /162,137,   0.52097030D+03,   0.29300D+01,   0.97380D+00/
  data pars( 56511: 56515) /162,138,   0.10240101D+04,   0.29300D+01,   0.98010D+00/
  data pars( 56516: 56520) /162,139,   0.77856140D+03,   0.29300D+01,   0.19153D+01/
  data pars( 56521: 56525) /162,140,   0.57624530D+03,   0.29300D+01,   0.19355D+01/
  data pars( 56526: 56530) /162,141,   0.58193050D+03,   0.29300D+01,   0.19545D+01/
  data pars( 56531: 56535) /162,142,   0.54238030D+03,   0.29300D+01,   0.19420D+01/
  data pars( 56536: 56540) /162,143,   0.60986550D+03,   0.29300D+01,   0.16682D+01/
  data pars( 56541: 56545) /162,144,   0.47194410D+03,   0.29300D+01,   0.18584D+01/
  data pars( 56546: 56550) /162,145,   0.44147690D+03,   0.29300D+01,   0.19003D+01/
  data pars( 56551: 56555) /162,146,   0.40984440D+03,   0.29300D+01,   0.18630D+01/
  data pars( 56556: 56560) /162,147,   0.39658040D+03,   0.29300D+01,   0.96790D+00/
  data pars( 56561: 56565) /162,148,   0.39174910D+03,   0.29300D+01,   0.19539D+01/
  data pars( 56566: 56570) /162,149,   0.62494310D+03,   0.29300D+01,   0.96330D+00/
  data pars( 56571: 56575) /162,150,   0.56383860D+03,   0.29300D+01,   0.95140D+00/
  data pars( 56576: 56580) /162,151,   0.52709190D+03,   0.29300D+01,   0.97490D+00/
  data pars( 56581: 56585) /162,152,   0.49801930D+03,   0.29300D+01,   0.98110D+00/
  data pars( 56586: 56590) /162,153,   0.45422360D+03,   0.29300D+01,   0.99680D+00/
  data pars( 56591: 56595) /162,155,   0.61477890D+03,   0.29300D+01,   0.99090D+00/
  data pars( 56596: 56600) /162,156,   0.13297509D+04,   0.29300D+01,   0.97970D+00/
  data pars( 56601: 56605) /162,157,   0.98604390D+03,   0.29300D+01,   0.19373D+01/
  data pars( 56606: 56610) /162,159,   0.61665720D+03,   0.29300D+01,   0.29425D+01/
  data pars( 56611: 56615) /162,160,   0.60388680D+03,   0.29300D+01,   0.29455D+01/
  data pars( 56616: 56620) /162,161,   0.58467880D+03,   0.29300D+01,   0.29413D+01/
  data pars( 56621: 56625) /162,162,   0.58778910D+03,   0.29300D+01,   0.29300D+01/
  data pars( 56626: 56630) /163,  1,   0.39256400D+02,   0.18286D+01,   0.91180D+00/
  data pars( 56631: 56635) /163,  2,   0.25691300D+02,   0.18286D+01,   0.00000D+00/
  data pars( 56636: 56640) /163,  3,   0.65368460D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56641: 56645) /163,  4,   0.36511120D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56646: 56650) /163,  5,   0.24163430D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56651: 56655) /163,  6,   0.16139330D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56656: 56660) /163,  7,   0.11205120D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56661: 56665) /163,  8,   0.84473100D+02,   0.18286D+01,   0.00000D+00/
  data pars( 56666: 56670) /163,  9,   0.63799600D+02,   0.18286D+01,   0.00000D+00/
  data pars( 56671: 56675) /163, 10,   0.48980900D+02,   0.18286D+01,   0.00000D+00/
  data pars( 56676: 56680) /163, 11,   0.78026740D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56681: 56685) /163, 12,   0.58523670D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56686: 56690) /163, 13,   0.53437570D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56691: 56695) /163, 14,   0.41591500D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56696: 56700) /163, 15,   0.32121200D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56701: 56705) /163, 16,   0.26508690D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56706: 56710) /163, 17,   0.21546030D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56711: 56715) /163, 18,   0.17559080D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56716: 56720) /163, 19,   0.12856965D+04,   0.18286D+01,   0.00000D+00/
  data pars( 56721: 56725) /163, 20,   0.10394662D+04,   0.18286D+01,   0.00000D+00/
  data pars( 56726: 56730) /163, 21,   0.85482160D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56731: 56735) /163, 22,   0.82218100D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56736: 56740) /163, 23,   0.75108930D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56741: 56745) /163, 24,   0.59166600D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56746: 56750) /163, 25,   0.64444210D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56751: 56755) /163, 26,   0.50560640D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56756: 56760) /163, 27,   0.53300400D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56761: 56765) /163, 28,   0.55039520D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56766: 56770) /163, 29,   0.42213760D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56771: 56775) /163, 30,   0.42993040D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56776: 56780) /163, 31,   0.51021570D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56781: 56785) /163, 32,   0.44563750D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56786: 56790) /163, 33,   0.37699910D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56791: 56795) /163, 34,   0.33669100D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56796: 56800) /163, 35,   0.29330360D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56801: 56805) /163, 36,   0.25408590D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56806: 56810) /163, 37,   0.14385445D+04,   0.18286D+01,   0.00000D+00/
  data pars( 56811: 56815) /163, 38,   0.12395504D+04,   0.18286D+01,   0.00000D+00/
  data pars( 56816: 56820) /163, 39,   0.10770858D+04,   0.18286D+01,   0.00000D+00/
  data pars( 56821: 56825) /163, 40,   0.96327150D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56826: 56830) /163, 41,   0.87559310D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56831: 56835) /163, 42,   0.67249140D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56836: 56840) /163, 43,   0.75175670D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56841: 56845) /163, 44,   0.56950600D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56846: 56850) /163, 45,   0.62232140D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56851: 56855) /163, 46,   0.57599650D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56856: 56860) /163, 47,   0.48115240D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56861: 56865) /163, 48,   0.50633030D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56866: 56870) /163, 49,   0.63922390D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56871: 56875) /163, 50,   0.58633170D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56876: 56880) /163, 51,   0.51859750D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56881: 56885) /163, 52,   0.47906490D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56886: 56890) /163, 53,   0.43122670D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56891: 56895) /163, 54,   0.38614600D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56896: 56900) /163, 55,   0.17518319D+04,   0.18286D+01,   0.00000D+00/
  data pars( 56901: 56905) /163, 56,   0.15845929D+04,   0.18286D+01,   0.00000D+00/
  data pars( 56906: 56910) /163, 57,   0.13809239D+04,   0.18286D+01,   0.00000D+00/
  data pars( 56911: 56915) /163, 58,   0.61365370D+03,   0.18286D+01,   0.27991D+01/
  data pars( 56916: 56920) /163, 59,   0.14003880D+04,   0.18286D+01,   0.00000D+00/
  data pars( 56921: 56925) /163, 60,   0.13429247D+04,   0.18286D+01,   0.00000D+00/
  data pars( 56926: 56930) /163, 61,   0.13087424D+04,   0.18286D+01,   0.00000D+00/
  data pars( 56931: 56935) /163, 62,   0.12773568D+04,   0.18286D+01,   0.00000D+00/
  data pars( 56936: 56940) /163, 63,   0.12495054D+04,   0.18286D+01,   0.00000D+00/
  data pars( 56941: 56945) /163, 64,   0.97406900D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56946: 56950) /163, 65,   0.11111877D+04,   0.18286D+01,   0.00000D+00/
  data pars( 56951: 56955) /163, 66,   0.10699921D+04,   0.18286D+01,   0.00000D+00/
  data pars( 56956: 56960) /163, 67,   0.11246771D+04,   0.18286D+01,   0.00000D+00/
  data pars( 56961: 56965) /163, 68,   0.11005512D+04,   0.18286D+01,   0.00000D+00/
  data pars( 56966: 56970) /163, 69,   0.10786794D+04,   0.18286D+01,   0.00000D+00/
  data pars( 56971: 56975) /163, 70,   0.10664387D+04,   0.18286D+01,   0.00000D+00/
  data pars( 56976: 56980) /163, 71,   0.89316870D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56981: 56985) /163, 72,   0.87110070D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56986: 56990) /163, 73,   0.79118140D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56991: 56995) /163, 74,   0.66583170D+03,   0.18286D+01,   0.00000D+00/
  data pars( 56996: 57000) /163, 75,   0.67605760D+03,   0.18286D+01,   0.00000D+00/
  data pars( 57001: 57005) /163, 76,   0.61029470D+03,   0.18286D+01,   0.00000D+00/
  data pars( 57006: 57010) /163, 77,   0.55718050D+03,   0.18286D+01,   0.00000D+00/
  data pars( 57011: 57015) /163, 78,   0.46153520D+03,   0.18286D+01,   0.00000D+00/
  data pars( 57016: 57020) /163, 79,   0.43073110D+03,   0.18286D+01,   0.00000D+00/
  data pars( 57021: 57025) /163, 80,   0.44232070D+03,   0.18286D+01,   0.00000D+00/
  data pars( 57026: 57030) /163, 81,   0.65532760D+03,   0.18286D+01,   0.00000D+00/
  data pars( 57031: 57035) /163, 82,   0.63664300D+03,   0.18286D+01,   0.00000D+00/
  data pars( 57036: 57040) /163, 83,   0.58099830D+03,   0.18286D+01,   0.00000D+00/
  data pars( 57041: 57045) /163, 84,   0.55199550D+03,   0.18286D+01,   0.00000D+00/
  data pars( 57046: 57050) /163, 85,   0.50719420D+03,   0.18286D+01,   0.00000D+00/
  data pars( 57051: 57055) /163, 86,   0.46310600D+03,   0.18286D+01,   0.00000D+00/
  data pars( 57056: 57060) /163, 87,   0.16436058D+04,   0.18286D+01,   0.00000D+00/
  data pars( 57061: 57065) /163, 88,   0.15604236D+04,   0.18286D+01,   0.00000D+00/
  data pars( 57066: 57070) /163, 89,   0.13690464D+04,   0.18286D+01,   0.00000D+00/
  data pars( 57071: 57075) /163, 90,   0.12201277D+04,   0.18286D+01,   0.00000D+00/
  data pars( 57076: 57080) /163, 91,   0.12166738D+04,   0.18286D+01,   0.00000D+00/
  data pars( 57081: 57085) /163, 92,   0.11778612D+04,   0.18286D+01,   0.00000D+00/
  data pars( 57086: 57090) /163, 93,   0.12191450D+04,   0.18286D+01,   0.00000D+00/
  data pars( 57091: 57095) /163, 94,   0.11794690D+04,   0.18286D+01,   0.00000D+00/
  data pars( 57096: 57100) /163,101,   0.63762900D+02,   0.18286D+01,   0.00000D+00/
  data pars( 57101: 57105) /163,103,   0.21174000D+03,   0.18286D+01,   0.98650D+00/
  data pars( 57106: 57110) /163,104,   0.26923050D+03,   0.18286D+01,   0.98080D+00/
  data pars( 57111: 57115) /163,105,   0.20261480D+03,   0.18286D+01,   0.97060D+00/
  data pars( 57116: 57120) /163,106,   0.15147130D+03,   0.18286D+01,   0.98680D+00/
  data pars( 57121: 57125) /163,107,   0.10450970D+03,   0.18286D+01,   0.99440D+00/
  data pars( 57126: 57130) /163,108,   0.75690800D+02,   0.18286D+01,   0.99250D+00/
  data pars( 57131: 57135) /163,109,   0.51755700D+02,   0.18286D+01,   0.99820D+00/
  data pars( 57136: 57140) /163,111,   0.31068640D+03,   0.18286D+01,   0.96840D+00/
  data pars( 57141: 57145) /163,112,   0.48112160D+03,   0.18286D+01,   0.96280D+00/
  data pars( 57146: 57150) /163,113,   0.48324150D+03,   0.18286D+01,   0.96480D+00/
  data pars( 57151: 57155) /163,114,   0.38377640D+03,   0.18286D+01,   0.95070D+00/
  data pars( 57156: 57160) /163,115,   0.31171580D+03,   0.18286D+01,   0.99470D+00/
  data pars( 57161: 57165) /163,116,   0.26222190D+03,   0.18286D+01,   0.99480D+00/
  data pars( 57166: 57170) /163,117,   0.21326140D+03,   0.18286D+01,   0.99720D+00/
  data pars( 57171: 57175) /163,119,   0.42593700D+03,   0.18286D+01,   0.97670D+00/
  data pars( 57176: 57180) /163,120,   0.83127500D+03,   0.18286D+01,   0.98310D+00/
  data pars( 57181: 57185) /163,121,   0.42169690D+03,   0.18286D+01,   0.18627D+01/
  data pars( 57186: 57190) /163,122,   0.40700940D+03,   0.18286D+01,   0.18299D+01/
  data pars( 57191: 57195) /163,123,   0.39898160D+03,   0.18286D+01,   0.19138D+01/
  data pars( 57196: 57200) /163,124,   0.39579870D+03,   0.18286D+01,   0.18269D+01/
  data pars( 57201: 57205) /163,125,   0.36204930D+03,   0.18286D+01,   0.16406D+01/
  data pars( 57206: 57210) /163,126,   0.33456150D+03,   0.18286D+01,   0.16483D+01/
  data pars( 57211: 57215) /163,127,   0.31919930D+03,   0.18286D+01,   0.17149D+01/
  data pars( 57216: 57220) /163,128,   0.31222210D+03,   0.18286D+01,   0.17937D+01/
  data pars( 57221: 57225) /163,129,   0.30989590D+03,   0.18286D+01,   0.95760D+00/
  data pars( 57226: 57230) /163,130,   0.28840040D+03,   0.18286D+01,   0.19419D+01/
  data pars( 57231: 57235) /163,131,   0.47803960D+03,   0.18286D+01,   0.96010D+00/
  data pars( 57236: 57240) /163,132,   0.41601900D+03,   0.18286D+01,   0.94340D+00/
  data pars( 57241: 57245) /163,133,   0.37044180D+03,   0.18286D+01,   0.98890D+00/
  data pars( 57246: 57250) /163,134,   0.33685390D+03,   0.18286D+01,   0.99010D+00/
  data pars( 57251: 57255) /163,135,   0.29542100D+03,   0.18286D+01,   0.99740D+00/
  data pars( 57256: 57260) /163,137,   0.50722850D+03,   0.18286D+01,   0.97380D+00/
  data pars( 57261: 57265) /163,138,   0.10128078D+04,   0.18286D+01,   0.98010D+00/
  data pars( 57266: 57270) /163,139,   0.76200330D+03,   0.18286D+01,   0.19153D+01/
  data pars( 57271: 57275) /163,140,   0.55829510D+03,   0.18286D+01,   0.19355D+01/
  data pars( 57276: 57280) /163,141,   0.56398160D+03,   0.18286D+01,   0.19545D+01/
  data pars( 57281: 57285) /163,142,   0.52490850D+03,   0.18286D+01,   0.19420D+01/
  data pars( 57286: 57290) /163,143,   0.59323860D+03,   0.18286D+01,   0.16682D+01/
  data pars( 57291: 57295) /163,144,   0.45513890D+03,   0.18286D+01,   0.18584D+01/
  data pars( 57296: 57300) /163,145,   0.42567220D+03,   0.18286D+01,   0.19003D+01/
  data pars( 57301: 57305) /163,146,   0.39496580D+03,   0.18286D+01,   0.18630D+01/
  data pars( 57306: 57310) /163,147,   0.38242790D+03,   0.18286D+01,   0.96790D+00/
  data pars( 57311: 57315) /163,148,   0.37661900D+03,   0.18286D+01,   0.19539D+01/
  data pars( 57316: 57320) /163,149,   0.60761490D+03,   0.18286D+01,   0.96330D+00/
  data pars( 57321: 57325) /163,150,   0.54518900D+03,   0.18286D+01,   0.95140D+00/
  data pars( 57326: 57330) /163,151,   0.50775680D+03,   0.18286D+01,   0.97490D+00/
  data pars( 57331: 57335) /163,152,   0.47858010D+03,   0.18286D+01,   0.98110D+00/
  data pars( 57336: 57340) /163,153,   0.43529630D+03,   0.18286D+01,   0.99680D+00/
  data pars( 57341: 57345) /163,155,   0.59594990D+03,   0.18286D+01,   0.99090D+00/
  data pars( 57346: 57350) /163,156,   0.13176067D+04,   0.18286D+01,   0.97970D+00/
  data pars( 57351: 57355) /163,157,   0.96582370D+03,   0.18286D+01,   0.19373D+01/
  data pars( 57356: 57360) /163,159,   0.59490700D+03,   0.18286D+01,   0.29425D+01/
  data pars( 57361: 57365) /163,160,   0.58256410D+03,   0.18286D+01,   0.29455D+01/
  data pars( 57366: 57370) /163,161,   0.56390150D+03,   0.18286D+01,   0.29413D+01/
  data pars( 57371: 57375) /163,162,   0.56731710D+03,   0.18286D+01,   0.29300D+01/
  data pars( 57376: 57380) /163,163,   0.54902810D+03,   0.18286D+01,   0.18286D+01/
  data pars( 57381: 57385) /164,  1,   0.41327500D+02,   0.28732D+01,   0.91180D+00/
  data pars( 57386: 57390) /164,  2,   0.27159500D+02,   0.28732D+01,   0.00000D+00/
  data pars( 57391: 57395) /164,  3,   0.65909240D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57396: 57400) /164,  4,   0.37646100D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57401: 57405) /164,  5,   0.25184240D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57406: 57410) /164,  6,   0.16931590D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57411: 57415) /164,  7,   0.11799770D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57416: 57420) /164,  8,   0.89135900D+02,   0.28732D+01,   0.00000D+00/
  data pars( 57421: 57425) /164,  9,   0.67403000D+02,   0.28732D+01,   0.00000D+00/
  data pars( 57426: 57430) /164, 10,   0.51775600D+02,   0.28732D+01,   0.00000D+00/
  data pars( 57431: 57435) /164, 11,   0.78761870D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57436: 57440) /164, 12,   0.60103840D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57441: 57445) /164, 13,   0.55215450D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57446: 57450) /164, 14,   0.43306620D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57451: 57455) /164, 15,   0.33637000D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57456: 57460) /164, 16,   0.27845510D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57461: 57465) /164, 17,   0.22691090D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57466: 57470) /164, 18,   0.18526210D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57471: 57475) /164, 19,   0.12927733D+04,   0.28732D+01,   0.00000D+00/
  data pars( 57476: 57480) /164, 20,   0.10597192D+04,   0.28732D+01,   0.00000D+00/
  data pars( 57481: 57485) /164, 21,   0.87413140D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57486: 57490) /164, 22,   0.84288400D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57491: 57495) /164, 23,   0.77118400D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57496: 57500) /164, 24,   0.60734870D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57501: 57505) /164, 25,   0.66313130D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57506: 57510) /164, 26,   0.52025690D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57511: 57515) /164, 27,   0.55050450D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57516: 57520) /164, 28,   0.56760260D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57521: 57525) /164, 29,   0.43508290D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57526: 57530) /164, 30,   0.44549820D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57531: 57535) /164, 31,   0.52813050D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57536: 57540) /164, 32,   0.46406710D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57541: 57545) /164, 33,   0.39450330D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57546: 57550) /164, 34,   0.35325210D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57551: 57555) /164, 35,   0.30847630D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57556: 57560) /164, 36,   0.26774640D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57561: 57565) /164, 37,   0.14479360D+04,   0.28732D+01,   0.00000D+00/
  data pars( 57566: 57570) /164, 38,   0.12628491D+04,   0.28732D+01,   0.00000D+00/
  data pars( 57571: 57575) /164, 39,   0.11030742D+04,   0.28732D+01,   0.00000D+00/
  data pars( 57576: 57580) /164, 40,   0.98959400D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57581: 57585) /164, 41,   0.90127470D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57586: 57590) /164, 42,   0.69429580D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57591: 57595) /164, 43,   0.77529730D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57596: 57600) /164, 44,   0.58924130D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57601: 57605) /164, 45,   0.64413130D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57606: 57610) /164, 46,   0.59686540D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57611: 57615) /164, 47,   0.49784100D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57616: 57620) /164, 48,   0.52541210D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57621: 57625) /164, 49,   0.66098150D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57626: 57630) /164, 50,   0.60940140D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57631: 57635) /164, 51,   0.54146000D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57636: 57640) /164, 52,   0.50144410D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57641: 57645) /164, 53,   0.45249160D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57646: 57650) /164, 54,   0.40604790D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57651: 57655) /164, 55,   0.17636917D+04,   0.28732D+01,   0.00000D+00/
  data pars( 57656: 57660) /164, 56,   0.16113765D+04,   0.28732D+01,   0.00000D+00/
  data pars( 57661: 57665) /164, 57,   0.14116458D+04,   0.28732D+01,   0.00000D+00/
  data pars( 57666: 57670) /164, 58,   0.63999700D+03,   0.28732D+01,   0.27991D+01/
  data pars( 57671: 57675) /164, 59,   0.14263405D+04,   0.28732D+01,   0.00000D+00/
  data pars( 57676: 57680) /164, 60,   0.13689945D+04,   0.28732D+01,   0.00000D+00/
  data pars( 57681: 57685) /164, 61,   0.13344823D+04,   0.28732D+01,   0.00000D+00/
  data pars( 57686: 57690) /164, 62,   0.13027626D+04,   0.28732D+01,   0.00000D+00/
  data pars( 57691: 57695) /164, 63,   0.12746283D+04,   0.28732D+01,   0.00000D+00/
  data pars( 57696: 57700) /164, 64,   0.99906170D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57701: 57705) /164, 65,   0.11300310D+04,   0.28732D+01,   0.00000D+00/
  data pars( 57706: 57710) /164, 66,   0.10892614D+04,   0.28732D+01,   0.00000D+00/
  data pars( 57711: 57715) /164, 67,   0.11488304D+04,   0.28732D+01,   0.00000D+00/
  data pars( 57716: 57720) /164, 68,   0.11243657D+04,   0.28732D+01,   0.00000D+00/
  data pars( 57721: 57725) /164, 69,   0.11022614D+04,   0.28732D+01,   0.00000D+00/
  data pars( 57726: 57730) /164, 70,   0.10895200D+04,   0.28732D+01,   0.00000D+00/
  data pars( 57731: 57735) /164, 71,   0.91593800D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57736: 57740) /164, 72,   0.89812800D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57741: 57745) /164, 73,   0.81811890D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57746: 57750) /164, 74,   0.68977370D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57751: 57755) /164, 75,   0.70124130D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57756: 57760) /164, 76,   0.63451700D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57761: 57765) /164, 77,   0.58034520D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57766: 57770) /164, 78,   0.48140120D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57771: 57775) /164, 79,   0.44951810D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57776: 57780) /164, 80,   0.46216400D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57781: 57785) /164, 81,   0.67804940D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57786: 57790) /164, 82,   0.66143650D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57791: 57795) /164, 83,   0.60616090D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57796: 57800) /164, 84,   0.57721150D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57801: 57805) /164, 85,   0.53169500D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57806: 57810) /164, 86,   0.48648120D+03,   0.28732D+01,   0.00000D+00/
  data pars( 57811: 57815) /164, 87,   0.16615027D+04,   0.28732D+01,   0.00000D+00/
  data pars( 57816: 57820) /164, 88,   0.15910020D+04,   0.28732D+01,   0.00000D+00/
  data pars( 57821: 57825) /164, 89,   0.14026190D+04,   0.28732D+01,   0.00000D+00/
  data pars( 57826: 57830) /164, 90,   0.12565351D+04,   0.28732D+01,   0.00000D+00/
  data pars( 57831: 57835) /164, 91,   0.12494197D+04,   0.28732D+01,   0.00000D+00/
  data pars( 57836: 57840) /164, 92,   0.12096721D+04,   0.28732D+01,   0.00000D+00/
  data pars( 57841: 57845) /164, 93,   0.12478750D+04,   0.28732D+01,   0.00000D+00/
  data pars( 57846: 57850) /164, 94,   0.12080168D+04,   0.28732D+01,   0.00000D+00/
  data pars( 57851: 57855) /164,101,   0.66823500D+02,   0.28732D+01,   0.00000D+00/
  data pars( 57856: 57860) /164,103,   0.21861950D+03,   0.28732D+01,   0.98650D+00/
  data pars( 57861: 57865) /164,104,   0.27850800D+03,   0.28732D+01,   0.98080D+00/
  data pars( 57866: 57870) /164,105,   0.21154850D+03,   0.28732D+01,   0.97060D+00/
  data pars( 57871: 57875) /164,106,   0.15883010D+03,   0.28732D+01,   0.98680D+00/
  data pars( 57876: 57880) /164,107,   0.11002650D+03,   0.28732D+01,   0.99440D+00/
  data pars( 57881: 57885) /164,108,   0.79894900D+02,   0.28732D+01,   0.99250D+00/
  data pars( 57886: 57890) /164,109,   0.54760000D+02,   0.28732D+01,   0.99820D+00/
  data pars( 57891: 57895) /164,111,   0.31995720D+03,   0.28732D+01,   0.96840D+00/
  data pars( 57896: 57900) /164,112,   0.49511470D+03,   0.28732D+01,   0.96280D+00/
  data pars( 57901: 57905) /164,113,   0.49998200D+03,   0.28732D+01,   0.96480D+00/
  data pars( 57906: 57910) /164,114,   0.39998160D+03,   0.28732D+01,   0.95070D+00/
  data pars( 57911: 57915) /164,115,   0.32645920D+03,   0.28732D+01,   0.99470D+00/
  data pars( 57916: 57920) /164,116,   0.27540540D+03,   0.28732D+01,   0.99480D+00/
  data pars( 57921: 57925) /164,117,   0.22456980D+03,   0.28732D+01,   0.99720D+00/
  data pars( 57926: 57930) /164,119,   0.43997650D+03,   0.28732D+01,   0.97670D+00/
  data pars( 57931: 57935) /164,120,   0.84744860D+03,   0.28732D+01,   0.98310D+00/
  data pars( 57936: 57940) /164,121,   0.43855500D+03,   0.28732D+01,   0.18627D+01/
  data pars( 57941: 57945) /164,122,   0.42330690D+03,   0.28732D+01,   0.18299D+01/
  data pars( 57946: 57950) /164,123,   0.41487410D+03,   0.28732D+01,   0.19138D+01/
  data pars( 57951: 57955) /164,124,   0.41122300D+03,   0.28732D+01,   0.18269D+01/
  data pars( 57956: 57960) /164,125,   0.37757470D+03,   0.28732D+01,   0.16406D+01/
  data pars( 57961: 57965) /164,126,   0.34920950D+03,   0.28732D+01,   0.16483D+01/
  data pars( 57966: 57970) /164,127,   0.33312400D+03,   0.28732D+01,   0.17149D+01/
  data pars( 57971: 57975) /164,128,   0.32573280D+03,   0.28732D+01,   0.17937D+01/
  data pars( 57976: 57980) /164,129,   0.32237280D+03,   0.28732D+01,   0.95760D+00/
  data pars( 57981: 57985) /164,130,   0.30155830D+03,   0.28732D+01,   0.19419D+01/
  data pars( 57986: 57990) /164,131,   0.49556680D+03,   0.28732D+01,   0.96010D+00/
  data pars( 57991: 57995) /164,132,   0.43376750D+03,   0.28732D+01,   0.94340D+00/
  data pars( 57996: 58000) /164,133,   0.38773360D+03,   0.28732D+01,   0.98890D+00/
  data pars( 58001: 58005) /164,134,   0.35339890D+03,   0.28732D+01,   0.99010D+00/
  data pars( 58006: 58010) /164,135,   0.31065690D+03,   0.28732D+01,   0.99740D+00/
  data pars( 58011: 58015) /164,137,   0.52453740D+03,   0.28732D+01,   0.97380D+00/
  data pars( 58016: 58020) /164,138,   0.10315808D+04,   0.28732D+01,   0.98010D+00/
  data pars( 58021: 58025) /164,139,   0.78404790D+03,   0.28732D+01,   0.19153D+01/
  data pars( 58026: 58030) /164,140,   0.58016290D+03,   0.28732D+01,   0.19355D+01/
  data pars( 58031: 58035) /164,141,   0.58594010D+03,   0.28732D+01,   0.19545D+01/
  data pars( 58036: 58040) /164,142,   0.54592550D+03,   0.28732D+01,   0.19420D+01/
  data pars( 58041: 58045) /164,143,   0.61398170D+03,   0.28732D+01,   0.16682D+01/
  data pars( 58046: 58050) /164,144,   0.47485900D+03,   0.28732D+01,   0.18584D+01/
  data pars( 58051: 58055) /164,145,   0.44414170D+03,   0.28732D+01,   0.19003D+01/
  data pars( 58056: 58060) /164,146,   0.41225320D+03,   0.28732D+01,   0.18630D+01/
  data pars( 58061: 58065) /164,147,   0.39892850D+03,   0.28732D+01,   0.96790D+00/
  data pars( 58066: 58070) /164,148,   0.39401610D+03,   0.28732D+01,   0.19539D+01/
  data pars( 58071: 58075) /164,149,   0.62938940D+03,   0.28732D+01,   0.96330D+00/
  data pars( 58076: 58080) /164,150,   0.56763680D+03,   0.28732D+01,   0.95140D+00/
  data pars( 58081: 58085) /164,151,   0.53044640D+03,   0.28732D+01,   0.97490D+00/
  data pars( 58086: 58090) /164,152,   0.50102050D+03,   0.28732D+01,   0.98110D+00/
  data pars( 58091: 58095) /164,153,   0.45675320D+03,   0.28732D+01,   0.99680D+00/
  data pars( 58096: 58100) /164,155,   0.61885080D+03,   0.28732D+01,   0.99090D+00/
  data pars( 58101: 58105) /164,156,   0.13390290D+04,   0.28732D+01,   0.97970D+00/
  data pars( 58106: 58110) /164,157,   0.99282930D+03,   0.28732D+01,   0.19373D+01/
  data pars( 58111: 58115) /164,159,   0.62058810D+03,   0.28732D+01,   0.29425D+01/
  data pars( 58116: 58120) /164,160,   0.60773400D+03,   0.28732D+01,   0.29455D+01/
  data pars( 58121: 58125) /164,161,   0.58838130D+03,   0.28732D+01,   0.29413D+01/
  data pars( 58126: 58130) /164,162,   0.59153680D+03,   0.28732D+01,   0.29300D+01/
  data pars( 58131: 58135) /164,163,   0.57104500D+03,   0.28732D+01,   0.18286D+01/
  data pars( 58136: 58140) /164,164,   0.59536280D+03,   0.28732D+01,   0.28732D+01/
  data pars( 58141: 58145) /165,  1,   0.38915000D+02,   0.29086D+01,   0.91180D+00/
  data pars( 58146: 58150) /165,  2,   0.25669500D+02,   0.29086D+01,   0.00000D+00/
  data pars( 58151: 58155) /165,  3,   0.61281660D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58156: 58160) /165,  4,   0.35207530D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58161: 58165) /165,  5,   0.23626590D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58166: 58170) /165,  6,   0.15924220D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58171: 58175) /165,  7,   0.11120430D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58176: 58180) /165,  8,   0.84136300D+02,   0.29086D+01,   0.00000D+00/
  data pars( 58181: 58185) /165,  9,   0.63715200D+02,   0.29086D+01,   0.00000D+00/
  data pars( 58186: 58190) /165, 10,   0.49005000D+02,   0.29086D+01,   0.00000D+00/
  data pars( 58191: 58195) /165, 11,   0.73264570D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58196: 58200) /165, 12,   0.56159910D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58201: 58205) /165, 13,   0.51672630D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58206: 58210) /165, 14,   0.40615220D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58211: 58215) /165, 15,   0.31605550D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58216: 58220) /165, 16,   0.26197720D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58221: 58225) /165, 17,   0.21376170D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58226: 58230) /165, 18,   0.17473800D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58231: 58235) /165, 19,   0.12013307D+04,   0.29086D+01,   0.00000D+00/
  data pars( 58236: 58240) /165, 20,   0.98850950D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58241: 58245) /165, 21,   0.81603910D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58246: 58250) /165, 22,   0.78743780D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58251: 58255) /165, 23,   0.72076790D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58256: 58260) /165, 24,   0.56775360D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58261: 58265) /165, 25,   0.62017110D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58266: 58270) /165, 26,   0.48669710D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58271: 58275) /165, 27,   0.51538390D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58276: 58280) /165, 28,   0.53115950D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58281: 58285) /165, 29,   0.40724140D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58286: 58290) /165, 30,   0.41747630D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58291: 58295) /165, 31,   0.49461700D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58296: 58300) /165, 32,   0.43533390D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58301: 58305) /165, 33,   0.37064210D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58306: 58310) /165, 34,   0.33221730D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58311: 58315) /165, 35,   0.29041790D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58316: 58320) /165, 36,   0.25233250D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58321: 58325) /165, 37,   0.13459552D+04,   0.29086D+01,   0.00000D+00/
  data pars( 58326: 58330) /165, 38,   0.11778523D+04,   0.29086D+01,   0.00000D+00/
  data pars( 58331: 58335) /165, 39,   0.10302577D+04,   0.29086D+01,   0.00000D+00/
  data pars( 58336: 58340) /165, 40,   0.92507300D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58341: 58345) /165, 41,   0.84300140D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58346: 58350) /165, 42,   0.65010950D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58351: 58355) /165, 43,   0.72565600D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58356: 58360) /165, 44,   0.55217930D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58361: 58365) /165, 45,   0.60356690D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58366: 58370) /165, 46,   0.55949210D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58371: 58375) /165, 47,   0.46665970D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58376: 58380) /165, 48,   0.49276250D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58381: 58385) /165, 49,   0.61913660D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58386: 58390) /165, 50,   0.57157510D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58391: 58395) /165, 51,   0.50851710D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58396: 58400) /165, 52,   0.47131940D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58401: 58405) /165, 53,   0.42569420D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58406: 58410) /165, 54,   0.38234290D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58411: 58415) /165, 55,   0.16393995D+04,   0.29086D+01,   0.00000D+00/
  data pars( 58416: 58420) /165, 56,   0.15021922D+04,   0.29086D+01,   0.00000D+00/
  data pars( 58421: 58425) /165, 57,   0.13178387D+04,   0.29086D+01,   0.00000D+00/
  data pars( 58426: 58430) /165, 58,   0.60095180D+03,   0.29086D+01,   0.27991D+01/
  data pars( 58431: 58435) /165, 59,   0.13303810D+04,   0.29086D+01,   0.00000D+00/
  data pars( 58436: 58440) /165, 60,   0.12772241D+04,   0.29086D+01,   0.00000D+00/
  data pars( 58441: 58445) /165, 61,   0.12451109D+04,   0.29086D+01,   0.00000D+00/
  data pars( 58446: 58450) /165, 62,   0.12155853D+04,   0.29086D+01,   0.00000D+00/
  data pars( 58451: 58455) /165, 63,   0.11893991D+04,   0.29086D+01,   0.00000D+00/
  data pars( 58456: 58460) /165, 64,   0.93372280D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58461: 58465) /165, 65,   0.10536587D+04,   0.29086D+01,   0.00000D+00/
  data pars( 58466: 58470) /165, 66,   0.10158840D+04,   0.29086D+01,   0.00000D+00/
  data pars( 58471: 58475) /165, 67,   0.10723978D+04,   0.29086D+01,   0.00000D+00/
  data pars( 58476: 58480) /165, 68,   0.10495999D+04,   0.29086D+01,   0.00000D+00/
  data pars( 58481: 58485) /165, 69,   0.10290199D+04,   0.29086D+01,   0.00000D+00/
  data pars( 58486: 58490) /165, 70,   0.10170572D+04,   0.29086D+01,   0.00000D+00/
  data pars( 58491: 58495) /165, 71,   0.85590310D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58496: 58500) /165, 72,   0.84038840D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58501: 58505) /165, 73,   0.76618830D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58506: 58510) /165, 74,   0.64647490D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58511: 58515) /165, 75,   0.65742490D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58516: 58520) /165, 76,   0.59532710D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58521: 58525) /165, 77,   0.54484580D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58526: 58530) /165, 78,   0.45230750D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58531: 58535) /165, 79,   0.42248760D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58536: 58540) /165, 80,   0.43446390D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58541: 58545) /165, 81,   0.63542770D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58546: 58550) /165, 82,   0.62048770D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58551: 58555) /165, 83,   0.56929560D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58556: 58560) /165, 84,   0.54247560D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58561: 58565) /165, 85,   0.50012070D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58566: 58570) /165, 86,   0.45795880D+03,   0.29086D+01,   0.00000D+00/
  data pars( 58571: 58575) /165, 87,   0.15463042D+04,   0.29086D+01,   0.00000D+00/
  data pars( 58576: 58580) /165, 88,   0.14842932D+04,   0.29086D+01,   0.00000D+00/
  data pars( 58581: 58585) /165, 89,   0.13102595D+04,   0.29086D+01,   0.00000D+00/
  data pars( 58586: 58590) /165, 90,   0.11755520D+04,   0.29086D+01,   0.00000D+00/
  data pars( 58591: 58595) /165, 91,   0.11681093D+04,   0.29086D+01,   0.00000D+00/
  data pars( 58596: 58600) /165, 92,   0.11310127D+04,   0.29086D+01,   0.00000D+00/
  data pars( 58601: 58605) /165, 93,   0.11657289D+04,   0.29086D+01,   0.00000D+00/
  data pars( 58606: 58610) /165, 94,   0.11286850D+04,   0.29086D+01,   0.00000D+00/
  data pars( 58611: 58615) /165,101,   0.62797100D+02,   0.29086D+01,   0.00000D+00/
  data pars( 58616: 58620) /165,103,   0.20455140D+03,   0.29086D+01,   0.98650D+00/
  data pars( 58621: 58625) /165,104,   0.26072450D+03,   0.29086D+01,   0.98080D+00/
  data pars( 58626: 58630) /165,105,   0.19860250D+03,   0.29086D+01,   0.97060D+00/
  data pars( 58631: 58635) /165,106,   0.14938110D+03,   0.29086D+01,   0.98680D+00/
  data pars( 58636: 58640) /165,107,   0.10370340D+03,   0.29086D+01,   0.99440D+00/
  data pars( 58641: 58645) /165,108,   0.75446500D+02,   0.29086D+01,   0.99250D+00/
  data pars( 58646: 58650) /165,109,   0.51841400D+02,   0.29086D+01,   0.99820D+00/
  data pars( 58651: 58655) /165,111,   0.29924680D+03,   0.29086D+01,   0.96840D+00/
  data pars( 58656: 58660) /165,112,   0.46288270D+03,   0.29086D+01,   0.96280D+00/
  data pars( 58661: 58665) /165,113,   0.46808680D+03,   0.29086D+01,   0.96480D+00/
  data pars( 58666: 58670) /165,114,   0.37524590D+03,   0.29086D+01,   0.95070D+00/
  data pars( 58671: 58675) /165,115,   0.30676780D+03,   0.29086D+01,   0.99470D+00/
  data pars( 58676: 58680) /165,116,   0.25910430D+03,   0.29086D+01,   0.99480D+00/
  data pars( 58681: 58685) /165,117,   0.21155470D+03,   0.29086D+01,   0.99720D+00/
  data pars( 58686: 58690) /165,119,   0.41206550D+03,   0.29086D+01,   0.97670D+00/
  data pars( 58691: 58695) /165,120,   0.79052270D+03,   0.29086D+01,   0.98310D+00/
  data pars( 58696: 58700) /165,121,   0.41139690D+03,   0.29086D+01,   0.18627D+01/
  data pars( 58701: 58705) /165,122,   0.39711900D+03,   0.29086D+01,   0.18299D+01/
  data pars( 58706: 58710) /165,123,   0.38920800D+03,   0.29086D+01,   0.19138D+01/
  data pars( 58711: 58715) /165,124,   0.38571070D+03,   0.29086D+01,   0.18269D+01/
  data pars( 58716: 58720) /165,125,   0.35449400D+03,   0.29086D+01,   0.16406D+01/
  data pars( 58721: 58725) /165,126,   0.32797050D+03,   0.29086D+01,   0.16483D+01/
  data pars( 58726: 58730) /165,127,   0.31287350D+03,   0.29086D+01,   0.17149D+01/
  data pars( 58731: 58735) /165,128,   0.30591120D+03,   0.29086D+01,   0.17937D+01/
  data pars( 58736: 58740) /165,129,   0.30254470D+03,   0.29086D+01,   0.95760D+00/
  data pars( 58741: 58745) /165,130,   0.28337650D+03,   0.29086D+01,   0.19419D+01/
  data pars( 58746: 58750) /165,131,   0.46432020D+03,   0.29086D+01,   0.96010D+00/
  data pars( 58751: 58755) /165,132,   0.40707180D+03,   0.29086D+01,   0.94340D+00/
  data pars( 58756: 58760) /165,133,   0.36431690D+03,   0.29086D+01,   0.98890D+00/
  data pars( 58761: 58765) /165,134,   0.33235190D+03,   0.29086D+01,   0.99010D+00/
  data pars( 58766: 58770) /165,135,   0.29245640D+03,   0.29086D+01,   0.99740D+00/
  data pars