
/*
 * $Header: /cvsroot/mpdist/mpdist/mp/input.h,v 1.1.1.1 2002/04/12 16:47:25 richbastard Exp $
 * 
 * Copyright (c) 1987-2002 Rich Burridge, Sun Microsystems Inc.
 * All rights reserved.
 * 
 * This software is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __MP_INPUT_H__
#define __MP_INPUT_H__

typedef enum {
    DO_MAIL, DO_NEWS, DO_TEXT
} document_type;

extern char *owner;             /* Name of owner (usually equal to 'to') */

extern char *current_line       (void);
extern char *get_line           (void);
extern char *who_am_i           (void);

extern document_type doc_type   (void);

extern int line_len             (void);
extern int message_len          (void);
extern int end_of_file          (void);
extern int end_of_line          (void);
extern int end_of_page          (void);

extern void close_input         (void);
extern void Input               (void);
extern void init_setup          (void);
extern void readline            (void);
extern void set_doc_type        (document_type);
extern void set_eof             (int);
extern void set_eop             (int);
extern void set_input           (FILE *);
extern void set_line_number     (int);
extern void set_message_len     (int);

#endif /* __MP_INPUT_H__ */
